# Generated by Django 3.1.2 on 2020-12-17 05:43

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import blueprints.validators


class Migration(migrations.Migration):

    dependencies = [
        ("eveonline", "0012_index_additions"),
        ("eveuniverse", "0004_effect_longer_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("blueprints", "0002_auto_20201211_1714"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="blueprints",
            options={
                "default_permissions": (),
                "managed": False,
                "permissions": (
                    ("basic_access", "Can access this app"),
                    ("request_blueprints", "Can request blueprints"),
                    ("manage_requests", "Can review and accept blueprint requests"),
                    ("add_blueprint_owner", "Can add blueprint owners"),
                    ("view_alliance_blueprints", "Can view alliance's blueprints"),
                ),
            },
        ),
        migrations.AlterField(
            model_name="blueprint",
            name="material_efficiency",
            field=models.PositiveIntegerField(
                help_text="Material efficiency of the blueprint",
                validators=[blueprints.validators.validate_material_efficiency],
            ),
        ),
        migrations.AlterField(
            model_name="blueprint",
            name="time_efficiency",
            field=models.PositiveIntegerField(
                help_text="Time efficiency of the blueprint",
                validators=[blueprints.validators.validate_time_efficiency],
            ),
        ),
        migrations.CreateModel(
            name="Request",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "material_efficiency",
                    models.PositiveIntegerField(
                        help_text="Material efficiency of the blueprint requested",
                        validators=[blueprints.validators.validate_material_efficiency],
                    ),
                ),
                (
                    "time_efficiency",
                    models.PositiveIntegerField(
                        help_text="Time efficiency of the blueprint requested",
                        validators=[blueprints.validators.validate_time_efficiency],
                    ),
                ),
                (
                    "runs",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Runs requested or blank for maximum allowed",
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("OP", "Open"),
                            ("IP", "In Progress"),
                            ("FL", "Fulfilled"),
                            ("CL", "Cancelled"),
                        ],
                        help_text="Status of the blueprint request",
                        max_length=2,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "closed_at",
                    models.DateTimeField(blank=True, db_index=True, null=True),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "fulfulling_user",
                    models.ForeignKey(
                        blank=True,
                        help_text="The user that fulfilled the request, if it has been fulfilled",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Location of the blueprint requested",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="blueprints.location",
                    ),
                ),
                (
                    "requestee_corporation",
                    models.ForeignKey(
                        help_text="Corporation owning the requested blueprint",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveonline.evecorporationinfo",
                    ),
                ),
                (
                    "requesting_user",
                    models.ForeignKey(
                        help_text="The requesting user",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
    ]
