# -*- coding: utf-8 -*-
# vim:fileencoding=utf-8 ai ts=4 sts=4 et sw=4
# Copyright 2008 Simon Cross <hodgestar@gmail.com>
# GPL - see COPYING for details
# pylint: disable=too-many-lines
# Including the database dump to setup the test means we have a lot of lines.

"""Test database upgrading"""

from logging import StreamHandler
from io import StringIO
import sys

from sqlobject import sqlhub, connectionForURI

from sutekh.base.core.BaseDBManagement import copy_to_new_abstract_card_db
from sutekh.base.core.CardLookup import SimpleLookup
from sutekh.base.core.BaseTables import (AbstractCard, PhysicalCardSet,
                                         PhysicalCard, Printing, Expansion,
                                         VersionTable)
from sutekh.base.core.BaseAdapters import (IAbstractCard, IPhysicalCardSet,
                                           IPhysicalCard, IPrinting,
                                           IExpansion)
from sutekh.base.core.DatabaseVersion import DatabaseVersion
from sutekh.base.core.DBUtility import init_cache
from sutekh.base.tests.TestUtils import make_null_handler, make_card

from sutekh.core.DatabaseUpgrade import DBUpgradeManager
from sutekh.core.SutekhTables import TABLE_LIST
from sutekh.tests.TestCore import SutekhTest
from sutekh.tests import create_db


# Dump created from Sutekh 0.8
# pylint: disable=line-too-long
OLD_VERSION_DUMP = [
    """BEGIN TRANSACTION""",
    """CREATE TABLE version_table (    id INTEGER PRIMARY KEY AUTOINCREMENT,    table_name VARCHAR(50) NOT NULL UNIQUE,    version INT);""",
    """INSERT INTO "version_table" VALUES(1,'version_table',1);""",
    """INSERT INTO "version_table" VALUES(2,'abstract_card',5);""",
    """INSERT INTO "version_table" VALUES(3,'expansion',3);""",
    """INSERT INTO "version_table" VALUES(4,'physical_card',2);""",
    """INSERT INTO "version_table" VALUES(5,'physical_card_set',6);""",
    """INSERT INTO "version_table" VALUES(6,'rarity',3);""",
    """INSERT INTO "version_table" VALUES(7,'rarity_pair',1);""",
    """INSERT INTO "version_table" VALUES(8,'discipline',3);""",
    """INSERT INTO "version_table" VALUES(9,'discipline_pair',1);""",
    """INSERT INTO "version_table" VALUES(10,'clan',3);""",
    """INSERT INTO "version_table" VALUES(11,'card_type',2)""",
    """INSERT INTO "version_table" VALUES(12,'sect',2)""",
    """INSERT INTO "version_table" VALUES(13,'title',2)""",
    """INSERT INTO "version_table" VALUES(14,'ruling',2)""",
    """INSERT INTO "version_table" VALUES(15,'virtue',2)""",
    """INSERT INTO "version_table" VALUES(16,'creed',2)""",
    """INSERT INTO "version_table" VALUES(17,'artist',1)""",
    """INSERT INTO "version_table" VALUES(18,'keyword',1)""",
    """INSERT INTO "version_table" VALUES(19,'physical_map',1)""",
    """INSERT INTO "version_table" VALUES(20,'abs_rarity_pair_map',1)""",
    """INSERT INTO "version_table" VALUES(21,'abs_ruling_map',1)""",
    """INSERT INTO "version_table" VALUES(22,'abs_clan_map',1)""",
    """INSERT INTO "version_table" VALUES(23,'abs_discipline_pair_map',1)""",
    """INSERT INTO "version_table" VALUES(24,'abs_type_map',1)""",
    """INSERT INTO "version_table" VALUES(25,'abs_sect_map',1)""",
    """INSERT INTO "version_table" VALUES(26,'abs_title_map',1)""",
    """INSERT INTO "version_table" VALUES(27,'abs_virtue_map',1)""",
    """INSERT INTO "version_table" VALUES(28,'abs_creed_map',1)""",
    """INSERT INTO "version_table" VALUES(29,'abs_artist_map',1)""",
    """INSERT INTO "version_table" VALUES(30,'abs_keyword_map',1)""",
    """DELETE FROM sqlite_sequence""",
    """INSERT INTO "sqlite_sequence" VALUES('version_table',30)""",
    """INSERT INTO "sqlite_sequence" VALUES('rarity',9)""",
    """INSERT INTO "sqlite_sequence" VALUES('expansion',25)""",
    """INSERT INTO "sqlite_sequence" VALUES('discipline',23)""",
    """INSERT INTO "sqlite_sequence" VALUES('clan',22)""",
    """INSERT INTO "sqlite_sequence" VALUES('creed',3)""",
    """INSERT INTO "sqlite_sequence" VALUES('virtue',6)""",
    """INSERT INTO "sqlite_sequence" VALUES('card_type',13)""",
    """INSERT INTO "sqlite_sequence" VALUES('ruling',3)""",
    """INSERT INTO "sqlite_sequence" VALUES('discipline_pair',37)""",
    """INSERT INTO "sqlite_sequence" VALUES('rarity_pair',64)""",
    """INSERT INTO "sqlite_sequence" VALUES('sect',4)""",
    """INSERT INTO "sqlite_sequence" VALUES('title',12)""",
    """INSERT INTO "sqlite_sequence" VALUES('artist',48)""",
    """INSERT INTO "sqlite_sequence" VALUES('keyword',36)""",
    """INSERT INTO "sqlite_sequence" VALUES('abstract_card',72)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_rarity_pair_map',162)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_type_map',74)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_keyword_map',211)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_artist_map',82)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_ruling_map',3)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_discipline_pair_map',138)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_clan_map',42)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_sect_map',31)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_virtue_map',9)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_title_map',14)""",
    """INSERT INTO "sqlite_sequence" VALUES('abs_creed_map',3)""",
    """INSERT INTO "sqlite_sequence" VALUES('physical_card',225)""",
    """INSERT INTO "sqlite_sequence" VALUES('physical_card_set',3)""",
    """INSERT INTO "sqlite_sequence" VALUES('physical_map',27);""",
    """CREATE TABLE abstract_card (    id INTEGER PRIMARY KEY AUTOINCREMENT,    canonical_name VARCHAR(512) NOT NULL UNIQUE,    name TEXT,    text TEXT,    grp INT,    capacity INT,    cost INT,    life INT,    costtype VARCHAR(10) CHECK (costtype in ('pool', 'blood', 'conviction', NULL)),    level VARCHAR(8) CHECK (level in ('advanced', NULL)));""",
    """INSERT INTO "abstract_card" VALUES(1,'.44 magnum','.44 Magnum','Weapon, gun.2R damage each strike, with an optional maneuver each combat.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(2,'ak-47','AK-47','Weapon. Gun.2R damage each strike, with an optional maneuver {each combat}. When bearer strikes with this gun, he or she gets an optional additional strike this round, only usable to strike with this gun.',NULL,NULL,5,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(3,'aabbt kindred','Aabbt Kindred','Independent: Aabbt Kindred cannot perform (D) actions unless Nefertiti is ready. Aabbt Kindred can prevent 1 damage each combat. Aabbt Kindred are not unique and do not contest.',2,4,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(4,'aaron bathurst','Aaron Bathurst','Sabbat.',4,4,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(5,'aaron duggan, cameron''s toady','Aaron Duggan, Cameron''s Toady','Sabbat',2,2,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(6,'aaron''s feeding razor','Aaron''s Feeding Razor','Unique equipment.When this vampire successfully hunts, he or she gains 1 additional blood.',NULL,NULL,1,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(7,'abandoning the flesh','Abandoning the Flesh','Only usable by a vampire being burned. Usable by a vampire in torpor.[dem] Remove this vampire from the game instead (diablerie, if any, is still successful), and put this card into play. You may not play this card if you already have an Abandoning the Flesh in play. You may tap this card when a vampire with Dementation is bleeding to give that vampire +1 bleed for the current action.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(8,'abbot','Abbot','+1 stealth action. Requires a Sabbat vampire.Put this card on this acting Sabbat vampire and untap him or her. This Sabbat vampire gets +1 intercept against (D) actions directed at his or her controller. A vampire may have only one Abbot.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(9,'abd al-rashid','Abd al-Rashid','Independent: (Blood Cursed)',2,5,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(10,'abdelsobek','Abdelsobek','Independent: Abdelsobek can untap a vampire or mummy you control as a +1 stealth action.',5,5,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(11,'abebe','Abebe','Independent.',4,4,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(12,'abjure','Abjure','[COMBAT] Tap this imbued before range is determined to end a combat between a monster and a mortal. If the mortal is a minion other than this imbued, you may move a conviction to this imbued from your hand or ash heap.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(13,'ablative skin','Ablative Skin','+1 stealth action.[for] Put this card on the acting vampire and put 3 ablative counters on this card. While in combat, this vampire may remove any number of ablative counters from this card to prevent that amount of non-aggravated damage. Burn this card when it has no more ablative counters. [FOR] As above, but this vampire may also prevent aggravated damage in combat in this way.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(14,'abombwe','Abombwe','Master: Discipline. Trifle.Put this card on a Laibon or on a vampire with Protean [pro]. This vampire gains one level of Abombwe [abo]. Capacity increases by 1: the vampire is one generation older. Cannot be placed on a vampire with superior Abombwe.',NULL,1,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(15,'aeron','Aeron','Sabbat Archbishop of London: Minions opposing Aeron in combat take an additional point of damage during strike resolution if the range is close. Once each combat, Aeron may burn a blood for a press.',3,9,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(16,'agent of power','Agent of Power','Master: Discipline. Trifle. Unique.Put this card on a vampire you control and choose a Discipline. This vampire gains 1 level of that Discipline. Burn this card during your discard phase.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(17,'aire of elation','Aire of Elation','You cannot play another action modifier to further increase the bleed for this action.[pre] +1 bleed; +2 bleed if the acting vampire is Toreador. [PRE] +2 bleed; +3 bleed if the acting vampire is Toreador.',NULL,NULL,1,NULL,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(18,'akram','Akram','Camarilla primogen: Once each turn after completing combat, if Akram and the opposing minion are still ready, Akram may burn 1 blood to begin another combat with the opposing minion.',2,8,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(19,'alan sovereign','Alan Sovereign','Camarilla: When you play an investment card, add an additional counter to it from the blood bank.',3,6,NULL,NULL,NULL,NULL)""",
    """INSERT INTO "abstract_card" VALUES(20,'alan sovereign (advanced)','Alan Sovereign (Advanced)','Advanced, Camarilla: While Alan is ready, you may pay some or all of the pool cost of equipping from any investment cards you control.[MERGED] During your master phase, if Alan is ready, you may move a counter from any investment card to your pool.',3,6,NULL,NULL,NULL,'advanced');""",
    """INSERT INTO "abstract_card" VALUES(21,'alexandra','Alexandra','Camarilla Inner Circle: Once during your turn, you may tap or untap another ready Toreador. +2 bleed.',2,11,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(22,'alfred benezri','Alfred Benezri','Sabbat bishop: Alfred gets -1 strength in combat with an ally.',3,6,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(23,'ambrogino giovanni','Ambrogino Giovanni','Independent: Ambrogino has 1 vote. +1 bleed.',2,9,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(24,'amisa','Amisa','Independent: Amisa has 2 votes. Amisa can tap a vampire with a capacity above 7 as a (D) action.',2,8,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(25,'anastasz di zagreb','Anastasz di Zagreb','Camarilla Tremere Justicar: If there are any other justicars ready, Anastasz gets 1 fewer vote from his justicar title. Anastasz may steal 1 blood as a ranged strike.',3,8,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(26,'angelica, the canonicus','Angelica, The Canonicus','Sabbat cardinal: Once each {action that} Angelica attempts to block, you may burn X master cards from your hand to give her +X intercept.',2,10,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(27,'the ankara citadel, turkey','The Ankara Citadel, Turkey','This equipment card represents a unique location and does not count as equipment while in play.The vampire with this location pays only half of the blood cost for any cards he or she plays (round down).',NULL,NULL,2,NULL,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(28,'anna "dictatrix11" suljic','Anna "Dictatrix11" Suljic','Anna may move 2 blood from the blood bank to any vampire as a +1 stealth action. During your untap phase, you may look at the top three cards of your library.',4,NULL,NULL,6,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(29,'anson','Anson','Camarilla Prince of Seattle: If Anson is ready during your master phase, you get two master phase actions (instead of one).',1,8,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(30,'bravo','Bravo','Master: archetype.Put this card on a vampire you control. Once per turn, when this vampire successfully performs an action to enter combat with another, he or she gains 1 blood from the blood bank when the combat ends, if he or she is still ready. A vampire can have only one archetype.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(31,'bronwen','Bronwen','Sabbat priscus: Once each combat, Bronwen may dodge as a strike.',2,10,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(32,'cedric','Cedric','Camarilla. Tremere slave: If Cedric successfully blocks a (D) action, he may burn 1 blood when the action ends (after combat, if any) to untap. Flight [FLIGHT].',4,6,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(33,'cesewayo','Cesewayo','Laibon magaji: Once each action, Cesewayo may burn 1 blood to get +1 intercept.',4,10,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(34,'dramatic upheaval','Dramatic Upheaval','Choose another Methuselah. Successful referendum means you switch places with that Methuselah. {Added to the V:EKN banned list in 2005.}',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(35,'earl "shaka74" deams','Earl "Shaka74" Deams','Earl gets +1 stealth on actions other than actions to enter combat. During your untap phase, if you control more than two ready imbued, Earl burns 1 conviction [1 CONVICTION].',4,NULL,NULL,6,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(36,'enkidu, the noah','Enkidu, The Noah','Sabbat. Red List: Enkidu can enter combat with any minion as a (D) action. If Enkidu successfully performs an action to employ a retainer, he untaps at the end of the turn. He cannot have or use equipment. +2 strength.',4,11,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(37,'fidus, the shrunken beast','Fidus, The Shrunken Beast','Camarilla Tremere Slave: Fidus gets +1 stealth on undirected actions. -1 strength. Flight [FLIGHT].',2,4,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(38,'ghoul retainer','Ghoul Retainer','Ghoul with 2 life. 1 strength.During the initial strike resolution each round, the Ghoul Retainer inflicts 1 damage or may use a weapon not used by the employing minion (or another retainer) that round (either before or after). This is not a strike, although it does count as "using" the weapon.',NULL,NULL,2,2,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(39,'gracis nostinus','Gracis Nostinus','Camarilla Primogen: If a younger vampire attempts to block Gracis and fails, tap that vampire at the end of the action.',3,7,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(40,'gypsies','Gypsies','Unique {mortal} with 1 life. 1 {strength}, 1 bleed.Gypsies get +1 stealth on each of their actions.',NULL,NULL,3,1,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(41,'high top','High Top','Unique werewolf with 3 life. 1 strength, 0 bleed.High Top gets +1 intercept. High Top may enter combat with any minion controlled by another Methuselah as a (D) action. High Top gets an additional strike each round and an optional maneuver once each combat. He may play cards requiring basic Celerity [cel] as a vampire with a capacity of 4. If High Top has less than 3 life during your untap phase, he gains 1 life.',NULL,NULL,4,3,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(42,'inez "nurse216" villagrande','Inez "Nurse216" Villagrande','When Inez enters play, you may search your library (shuffle afterward) or hand for a power that requires innocence and put it on her.',4,NULL,NULL,3,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(43,'kabede maru','Kabede Maru','Laibon magaji: Kabede gets +1 intercept against political actions. (The blood curse does not affect Kabede.)',5,9,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(44,'kemintiri (advanced)','Kemintiri (Advanced)','Advanced, Independent. Red List: +1 stealth.[MERGED] Kemintiri has 3 votes (titled). She can play {minion} cards that require Camarilla, Ventrue, and/or a justicar title {as if she met that/those requirement(s)}.',2,10,NULL,NULL,NULL,'advanced');""",
    """INSERT INTO "abstract_card" VALUES(45,'lázár dobrescu','Lázár Dobrescu','Independent: Lázár may move one blood from {an uncontrolled minion} in your prey''s uncontrolled region to a vampire in your uncontrolled region as a (D) action.',2,3,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(46,'living manse','Living Manse','This equipment card represents a location and does not count as an equipment card while it is in play.The vampire with this location gets +1 bleed. He or she can burn this card before range is determined to end combat. A vampire may have only one Living Manse.',NULL,NULL,1,NULL,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(47,'necromancy','Necromancy','Master: Discipline.Put this card on a vampire. This vampire gains 1 level of Necromancy [nec]. Capacity increases by 1: the vampire is one generation older. Cannot be placed on a vampire with superior Necromancy.',NULL,1,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(48,'ossian','Ossian','Unique werewolf with 4 life. 2 strength, 0 bleed. Red List.Ossian may enter combat with any vampire as a +1 stealth (D) action. In the first round of combat with a vampire who has played a card that requires Auspex [aus] during this action, that vampire cannot use any maneuvers or strikes. Ossian gains 1 life at the end of each round for each blood the opposing vampire used to heal damage or prevent destruction that round.',NULL,NULL,3,4,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(49,'pariah','Pariah','Independent: During your master phase, discard a master card or tap Pariah. Pariah cannot take undirected actions other than hunting. He can enter combat with any minion as a (D) action. +1 strength. Scarce. Sterile.',2,6,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(50,'paris opera house','Paris Opera House','Master: unique location.Tap to give a Daughter of Cacophony you control +1 stealth. Tap this card and a Daughter of Cacophony you control to give any minion +1 stealth.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(51,'park hunting ground','Park Hunting Ground','Master: unique location. Hunting ground.During your untap phase, you may move 1 blood from the blood bank to a ready vampire you control. A vampire can gain blood from only one Hunting Ground card each turn.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(52,'the path of blood','The Path of Blood','Unique master.Put this card in play. Cards that require Quietus [qui] {cost Assamites 1 less blood}. Any minion may burn this card as a (D) action; if that minion is a vampire, he or she then takes 1 unpreventable damage when this card is burned.',NULL,NULL,1,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(53,'pier 13, port of baltimore','Pier 13, Port of Baltimore','This equipment card represents a unique location and does not count as equipment while in play.During your influence phase, this minion may equip with a non-location, non-unique equipment card from your hand (requirements and cost apply as normal). This is not an action and cannot be blocked.',NULL,NULL,2,NULL,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(54,'political hunting ground','Political Hunting Ground','Master: unique location. Hunting ground.During your untap phase, you may move 1 blood from the bank to a ready vampire you control. A vampire can gain blood from only one hunting ground card each turn.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(55,'predator''s communion','Predator''s Communion','[abo] [REFLEX] Cancel a frenzy card played on this vampire as it is played.[abo] +1 intercept. Only usable when a vampire is acting. [ABO] Only usable by a tapped vampire when a vampire is acting. This reacting vampire untaps.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(56,'protracted investment','Protracted Investment','Master. Investment.{Put this card in play and} move 5 blood from the blood bank to this card. You may use a master phase action to move 1 blood from this card to your pool. Burn this card when all blood has been removed.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(57,'raven spy','Raven Spy','Animal with 1 life.[ani] This minion gets +1 intercept. [ANI] As above, but the Raven Spy has 2 life.',NULL,NULL,1,1,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(58,'rebekka, chantry elder of munich','Rebekka, Chantry Elder of Munich','Camarilla: Rebekka gets +1 stealth on each of her actions. Rebekka gets +1 bleed when bleeding a Methuselah who controls a ready Malkavian.',2,8,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(59,'rock cat','Rock Cat','Gargoyle creature with 4 life. 3 strength, 0 bleed.Rock Cat may enter combat with a ready minion as a (D) action. Opposing vampires with capacity 3 or less cannot strike in the first round. Rock Cat gets an optional press each combat. Rock Cat may play cards requiring basic Potence [pot] as a 3-capacity vampire.',NULL,NULL,4,4,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(60,'scapelli, the family "mechanic"','Scapelli, The Family "Mechanic"','Unique {mortal} with 3 life. {0 strength}, 1 bleed.{Scapelli may strike for 2R damage.} Once each combat, Scapelli may press to continue combat.',NULL,NULL,3,3,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(61,'shade','Shade','{Demon} with 2 life.[obt] When the minion with this retainer is in combat, the opposing minion takes 1 damage during strike resolution {if the range is close}. [OBT] As above, but Shade has 3 life.',NULL,NULL,1,2,'blood',NULL);""",
    """INSERT INTO "abstract_card" VALUES(62,'sha-ennu','Sha-Ennu','Sabbat regent: Vampires with capacity less than 4 cannot block Sha-Ennu. +2 bleed.',4,11,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(63,'the siamese','The Siamese','Sabbat: +1 bleed. Sterile.',2,7,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(64,'the slaughterhouse','The Slaughterhouse','Master: location.Tap to burn two cards from the top of your prey''s library.',NULL,NULL,1,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(65,'two wrongs','Two Wrongs','Master: out-of-turn. Trifle.Play when a minion controlled by a Methuselah other than your predator is bleeding you {after blocks are declined}. That minion is now bleeding his or her prey. The next card that would change the target of this bleed is canceled as it is played.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(66,'vox domini','Vox Domini','Master: out-of-turn.Only usable during the referendum of a political action. Not usable on a referendum that is automatically passing. The referendum fails. Each Methuselah may play only one Vox Domini each game.',NULL,NULL,1,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(67,'yvette, the hopeless','Yvette, The Hopeless','Camarilla.',3,3,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(68,'hide the heart','Hide the Heart','[aus] Reduce a bleed against you by 1.[val] The action ends (unsuccessfully). The acting minion may burn 1 blood to cancel this card as it is played. Only one Hide the Heart may be played at [val] each action. [VAL] Reduce a bleed against you by 2, or tap to reduce a bleed against any Methuselah by 2.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(69,'anarch railroad','Anarch Railroad','Master: unique location.Tap to give an anarch +1 stealth for the current action.',NULL,NULL,2,NULL,'pool',NULL);""",
    """INSERT INTO "abstract_card" VALUES(70,'anarch revolt','Anarch Revolt','Master.Put this card in play. A Methuselah who does not control a ready anarch burns 1 pool during his or her untap phase. Any vampire can call a referendum to burn this card as a +1 stealth political action.',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """INSERT INTO "abstract_card" VALUES(71,'smite','Smite','{Strike:} strength+1 aggravated ranged damage. Even if the strike is dodged, burn any electronic equipment (e.g., IR Goggles, Laptop Computer, or Phased Motion Detector) on either combatant.',NULL,NULL,3,NULL,'conviction',NULL);""",
    """INSERT INTO "abstract_card" VALUES(72,'motivated by gehenna','Motivated by Gehenna','Master.Put this card in play, If you control the Edge, any vampire you control may enter combat with a ready minion controlled by another Methuselah as a (D) action that costs 1 blood.  {NOT FOR LEGAL PLAY}',NULL,NULL,NULL,NULL,NULL,NULL);""",
    """CREATE TABLE expansion (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    shortname TEXT);""",
    """INSERT INTO "expansion" VALUES(1,'Jyhad','Jyhad');""",
    """INSERT INTO "expansion" VALUES(2,'VTES','VTES');""",
    """INSERT INTO "expansion" VALUES(3,'Sabbat','Sabbat');""",
    """INSERT INTO "expansion" VALUES(4,'Sabbat Wars','SW');""",
    """INSERT INTO "expansion" VALUES(5,'Camarilla Edition','CE');""",
    """INSERT INTO "expansion" VALUES(6,'Legacy of Blood','LoB');""",
    """INSERT INTO "expansion" VALUES(7,'Lords of the Night','LotN');""",
    """INSERT INTO "expansion" VALUES(8,'Final Nights','FN');""",
    """INSERT INTO "expansion" VALUES(9,'Third Edition','Third');""",
    """INSERT INTO "expansion" VALUES(10,'Keepers of Tradition','KoT');""",
    """INSERT INTO "expansion" VALUES(11,'Ancient Hearts','AH');""",
    """INSERT INTO "expansion" VALUES(12,'Nights of Reckoning','NoR');""",
    """INSERT INTO "expansion" VALUES(13,'Gehenna','Gehenna');""",
    """INSERT INTO "expansion" VALUES(14,'Heirs to the Blood','HttB');""",
    """INSERT INTO "expansion" VALUES(15,'Dark Sovereigns','DS');""",
    """INSERT INTO "expansion" VALUES(16,'Anarchs','Anarchs');""",
    """INSERT INTO "expansion" VALUES(17,'Kindred Most Wanted','KMW');""",
    """INSERT INTO "expansion" VALUES(18,'Blood Shadowed Court','BSC');""",
    """INSERT INTO "expansion" VALUES(19,'Promo-20051001','Promo');""",
    """INSERT INTO "expansion" VALUES(20,'Tenth Anniversary','Tenth');""",
    """INSERT INTO "expansion" VALUES(21,'Black Hand','BH');""",
    """INSERT INTO "expansion" VALUES(22,'Bloodlines','BL');""",
    """INSERT INTO "expansion" VALUES(23,'Promo-20081119','Promo');""",
    """INSERT INTO "expansion" VALUES(24,'Anarchs and Alastors Storyline','Promo-20080810');""",
    """INSERT INTO "expansion" VALUES(25,'Eden''s Legacy Storyline','Eden''s Legacy Storyline');""",
    """CREATE TABLE physical_card (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    expansion_id INT CONSTRAINT expansion_id_exists REFERENCES expansion(id) );""",
    """INSERT INTO "physical_card" VALUES(1,1,NULL);""",
    """INSERT INTO "physical_card" VALUES(2,1,5);""",
    """INSERT INTO "physical_card" VALUES(3,1,4);""",
    """INSERT INTO "physical_card" VALUES(4,1,6);""",
    """INSERT INTO "physical_card" VALUES(5,1,1);""",
    """INSERT INTO "physical_card" VALUES(6,1,3);""",
    """INSERT INTO "physical_card" VALUES(7,1,2);""",
    """INSERT INTO "physical_card" VALUES(8,2,NULL);""",
    """INSERT INTO "physical_card" VALUES(9,2,7);""",
    """INSERT INTO "physical_card" VALUES(10,3,NULL);""",
    """INSERT INTO "physical_card" VALUES(11,3,8);""",
    """INSERT INTO "physical_card" VALUES(12,4,NULL);""",
    """INSERT INTO "physical_card" VALUES(13,4,9);""",
    """INSERT INTO "physical_card" VALUES(14,5,NULL);""",
    """INSERT INTO "physical_card" VALUES(15,5,3);""",
    """INSERT INTO "physical_card" VALUES(16,5,4);""",
    """INSERT INTO "physical_card" VALUES(17,6,NULL);""",
    """INSERT INTO "physical_card" VALUES(18,6,1);""",
    """INSERT INTO "physical_card" VALUES(19,6,2);""",
    """INSERT INTO "physical_card" VALUES(20,6,5);""",
    """INSERT INTO "physical_card" VALUES(21,6,10);""",
    """INSERT INTO "physical_card" VALUES(22,7,NULL);""",
    """INSERT INTO "physical_card" VALUES(23,7,9);""",
    """INSERT INTO "physical_card" VALUES(24,7,5);""",
    """INSERT INTO "physical_card" VALUES(25,8,NULL);""",
    """INSERT INTO "physical_card" VALUES(26,8,9);""",
    """INSERT INTO "physical_card" VALUES(27,9,NULL);""",
    """INSERT INTO "physical_card" VALUES(28,9,11);""",
    """INSERT INTO "physical_card" VALUES(29,9,8);""",
    """INSERT INTO "physical_card" VALUES(30,10,NULL);""",
    """INSERT INTO "physical_card" VALUES(31,10,7);""",
    """INSERT INTO "physical_card" VALUES(32,11,NULL);""",
    """INSERT INTO "physical_card" VALUES(33,11,6);""",
    """INSERT INTO "physical_card" VALUES(34,12,NULL);""",
    """INSERT INTO "physical_card" VALUES(35,12,12);""",
    """INSERT INTO "physical_card" VALUES(36,13,NULL);""",
    """INSERT INTO "physical_card" VALUES(37,13,3);""",
    """INSERT INTO "physical_card" VALUES(38,13,4);""",
    """INSERT INTO "physical_card" VALUES(39,13,9);""",
    """INSERT INTO "physical_card" VALUES(40,14,NULL);""",
    """INSERT INTO "physical_card" VALUES(41,14,6);""",
    """INSERT INTO "physical_card" VALUES(42,15,NULL);""",
    """INSERT INTO "physical_card" VALUES(43,15,13);""",
    """INSERT INTO "physical_card" VALUES(44,16,NULL);""",
    """INSERT INTO "physical_card" VALUES(45,16,7);""",
    """INSERT INTO "physical_card" VALUES(46,16,14);""",
    """INSERT INTO "physical_card" VALUES(47,17,NULL);""",
    """INSERT INTO "physical_card" VALUES(48,17,17);""",
    """INSERT INTO "physical_card" VALUES(49,17,15);""",
    """INSERT INTO "physical_card" VALUES(50,17,8);""",
    """INSERT INTO "physical_card" VALUES(51,17,5);""",
    """INSERT INTO "physical_card" VALUES(52,17,16);""",
    """INSERT INTO "physical_card" VALUES(53,18,NULL);""",
    """INSERT INTO "physical_card" VALUES(54,18,11);""",
    """INSERT INTO "physical_card" VALUES(55,18,5);""",
    """INSERT INTO "physical_card" VALUES(56,19,NULL);""",
    """INSERT INTO "physical_card" VALUES(57,19,18);""",
    """INSERT INTO "physical_card" VALUES(58,19,5);""",
    """INSERT INTO "physical_card" VALUES(59,20,NULL);""",
    """INSERT INTO "physical_card" VALUES(60,20,19);""",
    """INSERT INTO "physical_card" VALUES(61,21,NULL);""",
    """INSERT INTO "physical_card" VALUES(62,21,15);""",
    """INSERT INTO "physical_card" VALUES(63,21,5);""",
    """INSERT INTO "physical_card" VALUES(64,22,NULL);""",
    """INSERT INTO "physical_card" VALUES(65,22,18);""",
    """INSERT INTO "physical_card" VALUES(66,22,5);""",
    """INSERT INTO "physical_card" VALUES(67,23,NULL);""",
    """INSERT INTO "physical_card" VALUES(68,23,8);""",
    """INSERT INTO "physical_card" VALUES(69,24,NULL);""",
    """INSERT INTO "physical_card" VALUES(70,24,11);""",
    """INSERT INTO "physical_card" VALUES(71,24,8);""",
    """INSERT INTO "physical_card" VALUES(72,25,NULL);""",
    """INSERT INTO "physical_card" VALUES(73,25,17);""",
    """INSERT INTO "physical_card" VALUES(74,25,18);""",
    """INSERT INTO "physical_card" VALUES(75,25,5);""",
    """INSERT INTO "physical_card" VALUES(76,26,NULL);""",
    """INSERT INTO "physical_card" VALUES(77,26,3);""",
    """INSERT INTO "physical_card" VALUES(78,26,4);""",
    """INSERT INTO "physical_card" VALUES(79,27,NULL);""",
    """INSERT INTO "physical_card" VALUES(80,27,11);""",
    """INSERT INTO "physical_card" VALUES(81,27,10);""",
    """INSERT INTO "physical_card" VALUES(82,27,5);""",
    """INSERT INTO "physical_card" VALUES(83,28,NULL);""",
    """INSERT INTO "physical_card" VALUES(84,28,12);""",
    """INSERT INTO "physical_card" VALUES(85,29,NULL);""",
    """INSERT INTO "physical_card" VALUES(86,29,20);""",
    """INSERT INTO "physical_card" VALUES(87,29,1);""",
    """INSERT INTO "physical_card" VALUES(88,29,2);""",
    """INSERT INTO "physical_card" VALUES(89,30,NULL);""",
    """INSERT INTO "physical_card" VALUES(90,30,13);""",
    """INSERT INTO "physical_card" VALUES(91,31,NULL);""",
    """INSERT INTO "physical_card" VALUES(92,31,3);""",
    """INSERT INTO "physical_card" VALUES(93,31,4);""",
    """INSERT INTO "physical_card" VALUES(94,32,NULL);""",
    """INSERT INTO "physical_card" VALUES(95,32,14);""",
    """INSERT INTO "physical_card" VALUES(96,32,6);""",
    """INSERT INTO "physical_card" VALUES(97,33,NULL);""",
    """INSERT INTO "physical_card" VALUES(98,33,6);""",
    """INSERT INTO "physical_card" VALUES(99,34,NULL);""",
    """INSERT INTO "physical_card" VALUES(100,34,1);""",
    """INSERT INTO "physical_card" VALUES(101,34,2);""",
    """INSERT INTO "physical_card" VALUES(102,34,21);""",
    """INSERT INTO "physical_card" VALUES(103,34,16);""",
    """INSERT INTO "physical_card" VALUES(104,34,5);""",
    """INSERT INTO "physical_card" VALUES(105,35,NULL);""",
    """INSERT INTO "physical_card" VALUES(106,35,12);""",
    """INSERT INTO "physical_card" VALUES(107,36,NULL);""",
    """INSERT INTO "physical_card" VALUES(108,36,17);""",
    """INSERT INTO "physical_card" VALUES(109,37,NULL);""",
    """INSERT INTO "physical_card" VALUES(110,37,22);""",
    """INSERT INTO "physical_card" VALUES(111,38,NULL);""",
    """INSERT INTO "physical_card" VALUES(112,38,1);""",
    """INSERT INTO "physical_card" VALUES(113,38,2);""",
    """INSERT INTO "physical_card" VALUES(114,38,5);""",
    """INSERT INTO "physical_card" VALUES(115,38,10);""",
    """INSERT INTO "physical_card" VALUES(116,39,NULL);""",
    """INSERT INTO "physical_card" VALUES(117,39,18);""",
    """INSERT INTO "physical_card" VALUES(118,39,5);""",
    """INSERT INTO "physical_card" VALUES(119,40,NULL);""",
    """INSERT INTO "physical_card" VALUES(120,40,1);""",
    """INSERT INTO "physical_card" VALUES(121,40,2);""",
    """INSERT INTO "physical_card" VALUES(122,41,NULL);""",
    """INSERT INTO "physical_card" VALUES(123,41,6);""",
    """INSERT INTO "physical_card" VALUES(124,41,22);""",
    """INSERT INTO "physical_card" VALUES(125,42,NULL);""",
    """INSERT INTO "physical_card" VALUES(126,42,12);""",
    """INSERT INTO "physical_card" VALUES(127,43,NULL);""",
    """INSERT INTO "physical_card" VALUES(128,43,7);""",
    """INSERT INTO "physical_card" VALUES(129,44,NULL);""",
    """INSERT INTO "physical_card" VALUES(130,44,17);""",
    """INSERT INTO "physical_card" VALUES(131,45,NULL);""",
    """INSERT INTO "physical_card" VALUES(132,45,11);""",
    """INSERT INTO "physical_card" VALUES(133,45,8);""",
    """INSERT INTO "physical_card" VALUES(134,46,NULL);""",
    """INSERT INTO "physical_card" VALUES(135,46,3);""",
    """INSERT INTO "physical_card" VALUES(136,46,4);""",
    """INSERT INTO "physical_card" VALUES(137,46,9);""",
    """INSERT INTO "physical_card" VALUES(138,47,NULL);""",
    """INSERT INTO "physical_card" VALUES(139,47,7);""",
    """INSERT INTO "physical_card" VALUES(140,47,15);""",
    """INSERT INTO "physical_card" VALUES(141,47,8);""",
    """INSERT INTO "physical_card" VALUES(142,48,NULL);""",
    """INSERT INTO "physical_card" VALUES(143,48,17);""",
    """INSERT INTO "physical_card" VALUES(144,48,10);""",
    """INSERT INTO "physical_card" VALUES(145,49,NULL);""",
    """INSERT INTO "physical_card" VALUES(146,49,17);""",
    """INSERT INTO "physical_card" VALUES(147,50,NULL);""",
    """INSERT INTO "physical_card" VALUES(148,50,6);""",
    """INSERT INTO "physical_card" VALUES(149,50,22);""",
    """INSERT INTO "physical_card" VALUES(150,51,NULL);""",
    """INSERT INTO "physical_card" VALUES(151,51,7);""",
    """INSERT INTO "physical_card" VALUES(152,51,15);""",
    """INSERT INTO "physical_card" VALUES(153,51,8);""",
    """INSERT INTO "physical_card" VALUES(154,52,NULL);""",
    """INSERT INTO "physical_card" VALUES(155,52,11);""",
    """INSERT INTO "physical_card" VALUES(156,52,7);""",
    """INSERT INTO "physical_card" VALUES(157,52,8);""",
    """INSERT INTO "physical_card" VALUES(158,53,NULL);""",
    """INSERT INTO "physical_card" VALUES(159,53,4);""",
    """INSERT INTO "physical_card" VALUES(160,53,9);""",
    """INSERT INTO "physical_card" VALUES(161,53,10);""",
    """INSERT INTO "physical_card" VALUES(162,54,NULL);""",
    """INSERT INTO "physical_card" VALUES(163,54,3);""",
    """INSERT INTO "physical_card" VALUES(164,54,4);""",
    """INSERT INTO "physical_card" VALUES(165,54,14);""",
    """INSERT INTO "physical_card" VALUES(166,55,NULL);""",
    """INSERT INTO "physical_card" VALUES(167,55,6);""",
    """INSERT INTO "physical_card" VALUES(168,56,NULL);""",
    """INSERT INTO "physical_card" VALUES(169,56,1);""",
    """INSERT INTO "physical_card" VALUES(170,56,2);""",
    """INSERT INTO "physical_card" VALUES(171,56,5);""",
    """INSERT INTO "physical_card" VALUES(172,57,NULL);""",
    """INSERT INTO "physical_card" VALUES(173,57,17);""",
    """INSERT INTO "physical_card" VALUES(174,57,10);""",
    """INSERT INTO "physical_card" VALUES(175,57,16);""",
    """INSERT INTO "physical_card" VALUES(176,57,5);""",
    """INSERT INTO "physical_card" VALUES(177,57,7);""",
    """INSERT INTO "physical_card" VALUES(178,57,1);""",
    """INSERT INTO "physical_card" VALUES(179,57,21);""",
    """INSERT INTO "physical_card" VALUES(180,57,9);""",
    """INSERT INTO "physical_card" VALUES(181,57,2);""",
    """INSERT INTO "physical_card" VALUES(182,58,NULL);""",
    """INSERT INTO "physical_card" VALUES(183,58,15);""",
    """INSERT INTO "physical_card" VALUES(184,58,5);""",
    """INSERT INTO "physical_card" VALUES(185,59,NULL);""",
    """INSERT INTO "physical_card" VALUES(186,59,14);""",
    """INSERT INTO "physical_card" VALUES(187,59,6);""",
    """INSERT INTO "physical_card" VALUES(188,59,22);""",
    """INSERT INTO "physical_card" VALUES(189,60,NULL);""",
    """INSERT INTO "physical_card" VALUES(190,60,15);""",
    """INSERT INTO "physical_card" VALUES(191,61,NULL);""",
    """INSERT INTO "physical_card" VALUES(192,61,3);""",
    """INSERT INTO "physical_card" VALUES(193,61,4);""",
    """INSERT INTO "physical_card" VALUES(194,62,NULL);""",
    """INSERT INTO "physical_card" VALUES(195,62,9);""",
    """INSERT INTO "physical_card" VALUES(196,63,NULL);""",
    """INSERT INTO "physical_card" VALUES(197,63,22);""",
    """INSERT INTO "physical_card" VALUES(198,64,NULL);""",
    """INSERT INTO "physical_card" VALUES(199,64,6);""",
    """INSERT INTO "physical_card" VALUES(200,64,22);""",
    """INSERT INTO "physical_card" VALUES(201,65,NULL);""",
    """INSERT INTO "physical_card" VALUES(202,65,23);""",
    """INSERT INTO "physical_card" VALUES(203,66,NULL);""",
    """INSERT INTO "physical_card" VALUES(204,66,21);""",
    """INSERT INTO "physical_card" VALUES(205,66,6);""",
    """INSERT INTO "physical_card" VALUES(206,67,NULL);""",
    """INSERT INTO "physical_card" VALUES(207,67,18);""",
    """INSERT INTO "physical_card" VALUES(208,67,5);""",
    """INSERT INTO "physical_card" VALUES(209,68,NULL);""",
    """INSERT INTO "physical_card" VALUES(210,68,14);""",
    """INSERT INTO "physical_card" VALUES(211,69,NULL);""",
    """INSERT INTO "physical_card" VALUES(212,69,16);""",
    """INSERT INTO "physical_card" VALUES(213,70,NULL);""",
    """INSERT INTO "physical_card" VALUES(214,70,17);""",
    """INSERT INTO "physical_card" VALUES(215,70,16);""",
    """INSERT INTO "physical_card" VALUES(216,70,5);""",
    """INSERT INTO "physical_card" VALUES(217,70,1);""",
    """INSERT INTO "physical_card" VALUES(218,70,9);""",
    """INSERT INTO "physical_card" VALUES(219,70,2);""",
    """INSERT INTO "physical_card" VALUES(220,69,24);""",
    """INSERT INTO "physical_card" VALUES(221,70,24);""",
    """INSERT INTO "physical_card" VALUES(222,71,NULL);""",
    """INSERT INTO "physical_card" VALUES(223,71,12);""",
    """INSERT INTO "physical_card" VALUES(224,72,NULL);""",
    """INSERT INTO "physical_card" VALUES(225,72,25);""",
    """CREATE TABLE rarity (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    shortname VARCHAR(512) NOT NULL UNIQUE);""",
    """INSERT INTO "rarity" VALUES(1,'Common','C');""",
    """INSERT INTO "rarity" VALUES(2,'Precon','P');""",
    """INSERT INTO "rarity" VALUES(3,'Vampire','V');""",
    """INSERT INTO "rarity" VALUES(4,'Rare','R');""",
    """INSERT INTO "rarity" VALUES(5,'Uncommon','U');""",
    """INSERT INTO "rarity" VALUES(6,'BSC','X');""",
    """INSERT INTO "rarity" VALUES(7,'Not Applicable','NA');""",
    """INSERT INTO "rarity" VALUES(8,'Tenth','A');""",
    """INSERT INTO "rarity" VALUES(9,'Storyline','Storyline');""",
    """CREATE TABLE rarity_pair (    id INTEGER PRIMARY KEY AUTOINCREMENT,    expansion_id INT CONSTRAINT expansion_id_exists REFERENCES expansion(id) ,    rarity_id INT CONSTRAINT rarity_id_exists REFERENCES rarity(id) );""",
    """INSERT INTO "rarity_pair" VALUES(1,1,1);""",
    """INSERT INTO "rarity_pair" VALUES(2,2,1);""",
    """INSERT INTO "rarity_pair" VALUES(3,3,1);""",
    """INSERT INTO "rarity_pair" VALUES(4,4,2);""",
    """INSERT INTO "rarity_pair" VALUES(5,5,2);""",
    """INSERT INTO "rarity_pair" VALUES(6,6,2);""",
    """INSERT INTO "rarity_pair" VALUES(7,5,3);""",
    """INSERT INTO "rarity_pair" VALUES(8,7,4);""",
    """INSERT INTO "rarity_pair" VALUES(9,8,5);""",
    """INSERT INTO "rarity_pair" VALUES(10,9,3);""",
    """INSERT INTO "rarity_pair" VALUES(11,3,3);""",
    """INSERT INTO "rarity_pair" VALUES(12,4,5);""",
    """INSERT INTO "rarity_pair" VALUES(13,1,4);""",
    """INSERT INTO "rarity_pair" VALUES(14,2,4);""",
    """INSERT INTO "rarity_pair" VALUES(15,5,4);""",
    """INSERT INTO "rarity_pair" VALUES(16,10,4);""",
    """INSERT INTO "rarity_pair" VALUES(17,9,4);""",
    """INSERT INTO "rarity_pair" VALUES(18,9,5);""",
    """INSERT INTO "rarity_pair" VALUES(19,11,3);""",
    """INSERT INTO "rarity_pair" VALUES(20,8,2);""",
    """INSERT INTO "rarity_pair" VALUES(21,7,5);""",
    """INSERT INTO "rarity_pair" VALUES(22,6,5);""",
    """INSERT INTO "rarity_pair" VALUES(23,12,4);""",
    """INSERT INTO "rarity_pair" VALUES(24,3,4);""",
    """INSERT INTO "rarity_pair" VALUES(25,4,4);""",
    """INSERT INTO "rarity_pair" VALUES(26,6,1);""",
    """INSERT INTO "rarity_pair" VALUES(27,13,5);""",
    """INSERT INTO "rarity_pair" VALUES(28,7,1);""",
    """INSERT INTO "rarity_pair" VALUES(29,14,2);""",
    """INSERT INTO "rarity_pair" VALUES(30,15,1);""",
    """INSERT INTO "rarity_pair" VALUES(31,5,1);""",
    """INSERT INTO "rarity_pair" VALUES(32,16,2);""",
    """INSERT INTO "rarity_pair" VALUES(33,17,2);""",
    """INSERT INTO "rarity_pair" VALUES(34,18,6);""",
    """INSERT INTO "rarity_pair" VALUES(35,19,7);""",
    """INSERT INTO "rarity_pair" VALUES(36,15,3);""",
    """INSERT INTO "rarity_pair" VALUES(37,11,5);""",
    """INSERT INTO "rarity_pair" VALUES(38,5,5);""",
    """INSERT INTO "rarity_pair" VALUES(39,10,5);""",
    """INSERT INTO "rarity_pair" VALUES(40,12,5);""",
    """INSERT INTO "rarity_pair" VALUES(41,1,3);""",
    """INSERT INTO "rarity_pair" VALUES(42,2,3);""",
    """INSERT INTO "rarity_pair" VALUES(43,20,8);""",
    """INSERT INTO "rarity_pair" VALUES(44,13,1);""",
    """INSERT INTO "rarity_pair" VALUES(45,21,2);""",
    """INSERT INTO "rarity_pair" VALUES(46,17,5);""",
    """INSERT INTO "rarity_pair" VALUES(47,22,5);""",
    """INSERT INTO "rarity_pair" VALUES(48,1,5);""",
    """INSERT INTO "rarity_pair" VALUES(49,2,5);""",
    """INSERT INTO "rarity_pair" VALUES(50,22,4);""",
    """INSERT INTO "rarity_pair" VALUES(51,6,4);""",
    """INSERT INTO "rarity_pair" VALUES(52,7,2);""",
    """INSERT INTO "rarity_pair" VALUES(53,17,4);""",
    """INSERT INTO "rarity_pair" VALUES(54,11,1);""",
    """INSERT INTO "rarity_pair" VALUES(55,3,5);""",
    """INSERT INTO "rarity_pair" VALUES(56,9,2);""",
    """INSERT INTO "rarity_pair" VALUES(57,15,5);""",
    """INSERT INTO "rarity_pair" VALUES(58,22,1);""",
    """INSERT INTO "rarity_pair" VALUES(59,23,7);""",
    """INSERT INTO "rarity_pair" VALUES(60,21,4);""",
    """INSERT INTO "rarity_pair" VALUES(61,14,1);""",
    """INSERT INTO "rarity_pair" VALUES(62,16,4);""",
    """INSERT INTO "rarity_pair" VALUES(63,24,7);""",
    """INSERT INTO "rarity_pair" VALUES(64,25,9);""",
    """CREATE TABLE discipline (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    fullname TEXT);""",
    """INSERT INTO "discipline" VALUES(1,'for','Fortitude');""",
    """INSERT INTO "discipline" VALUES(2,'pre','Presence');""",
    """INSERT INTO "discipline" VALUES(3,'ser','Serpentis');""",
    """INSERT INTO "discipline" VALUES(4,'obf','Obfuscate');""",
    """INSERT INTO "discipline" VALUES(5,'pot','Potence');""",
    """INSERT INTO "discipline" VALUES(6,'obt','Obtenebration');""",
    """INSERT INTO "discipline" VALUES(7,'dem','Dementation');""",
    """INSERT INTO "discipline" VALUES(8,'cel','Celerity');""",
    """INSERT INTO "discipline" VALUES(9,'qui','Quietus');""",
    """INSERT INTO "discipline" VALUES(10,'nec','Necromancy');""",
    """INSERT INTO "discipline" VALUES(11,'thn','Thanatosis');""",
    """INSERT INTO "discipline" VALUES(12,'aus','Auspex');""",
    """INSERT INTO "discipline" VALUES(13,'pro','Protean');""",
    """INSERT INTO "discipline" VALUES(14,'ani','Animalism');""",
    """INSERT INTO "discipline" VALUES(15,'dom','Dominate');""",
    """INSERT INTO "discipline" VALUES(16,'tha','Thaumaturgy');""",
    """INSERT INTO "discipline" VALUES(17,'vis','Visceratika');""",
    """INSERT INTO "discipline" VALUES(18,'fli','Flight');""",
    """INSERT INTO "discipline" VALUES(19,'abo','Abombwe');""",
    """INSERT INTO "discipline" VALUES(20,'chi','Chimerstry');""",
    """INSERT INTO "discipline" VALUES(21,'vic','Vicissitude');""",
    """INSERT INTO "discipline" VALUES(22,'spi','Spiritus');""",
    """INSERT INTO "discipline" VALUES(23,'val','Valeren');""",
    """CREATE TABLE discipline_pair (    id INTEGER PRIMARY KEY AUTOINCREMENT,    discipline_id INT CONSTRAINT discipline_id_exists REFERENCES discipline(id) ,    level VARCHAR(8) CHECK (level in ('inferior', 'superior')));""",
    """INSERT INTO "discipline_pair" VALUES(1,1,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(2,2,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(3,3,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(4,4,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(5,5,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(6,6,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(7,7,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(8,8,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(9,9,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(10,10,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(11,11,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(12,1,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(13,12,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(14,13,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(15,14,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(16,4,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(17,5,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(18,2,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(19,12,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(20,15,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(21,15,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(22,16,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(23,10,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(24,3,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(25,14,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(26,8,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(27,6,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(28,17,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(29,18,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(30,13,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(31,16,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(32,19,'inferior');""",
    """INSERT INTO "discipline_pair" VALUES(33,19,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(34,20,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(35,21,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(36,22,'superior');""",
    """INSERT INTO "discipline_pair" VALUES(37,23,'superior');""",
    """CREATE TABLE clan (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    shortname TEXT);""",
    """INSERT INTO "clan" VALUES(1,'Follower of Set','Set');""",
    """INSERT INTO "clan" VALUES(2,'Nosferatu antitribu','!Nos');""",
    """INSERT INTO "clan" VALUES(3,'Lasombra','Lasom');""",
    """INSERT INTO "clan" VALUES(4,'Assamite','Assa');""",
    """INSERT INTO "clan" VALUES(5,'Samedi','Sam');""",
    """INSERT INTO "clan" VALUES(6,'Brujah','Brujah');""",
    """INSERT INTO "clan" VALUES(7,'Ventrue','Ven');""",
    """INSERT INTO "clan" VALUES(8,'Toreador','Tor');""",
    """INSERT INTO "clan" VALUES(9,'Pander','Pan');""",
    """INSERT INTO "clan" VALUES(10,'Giovanni','Giov');""",
    """INSERT INTO "clan" VALUES(11,'Tremere','Tre');""",
    """INSERT INTO "clan" VALUES(12,'Brujah antitribu','!Brujah');""",
    """INSERT INTO "clan" VALUES(13,'Gargoyle','Garg');""",
    """INSERT INTO "clan" VALUES(14,'Osebo','Ose');""",
    """INSERT INTO "clan" VALUES(15,'Gangrel antitribu','!Gangrel');""",
    """INSERT INTO "clan" VALUES(16,'Gangrel','Gangrel');""",
    """INSERT INTO "clan" VALUES(17,'Ahrimane','Ahrimanes');""",
    """INSERT INTO "clan" VALUES(18,'Ravnos','Ravnos');""",
    """INSERT INTO "clan" VALUES(19,'Tzimisce','Tz');""",
    """INSERT INTO "clan" VALUES(20,'Abomination','Abom');""",
    """INSERT INTO "clan" VALUES(21,'Daughter of Cacophony','DoC');""",
    """INSERT INTO "clan" VALUES(22,'Harbinger of Skulls','HoS');""",
    """CREATE TABLE card_type (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE);""",
    """INSERT INTO "card_type" VALUES(1,'Equipment');""",
    """INSERT INTO "card_type" VALUES(2,'Vampire');""",
    """INSERT INTO "card_type" VALUES(3,'Reaction');""",
    """INSERT INTO "card_type" VALUES(4,'Combat');""",
    """INSERT INTO "card_type" VALUES(5,'Action');""",
    """INSERT INTO "card_type" VALUES(6,'Power');""",
    """INSERT INTO "card_type" VALUES(7,'Master');""",
    """INSERT INTO "card_type" VALUES(8,'Action Modifier');""",
    """INSERT INTO "card_type" VALUES(9,'Imbued');""",
    """INSERT INTO "card_type" VALUES(10,'Political Action');""",
    """INSERT INTO "card_type" VALUES(11,'Retainer');""",
    """INSERT INTO "card_type" VALUES(12,'Ally');""",
    """INSERT INTO "card_type" VALUES(13,'Reflex');""",
    """CREATE TABLE sect (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE);""",
    """INSERT INTO "sect" VALUES(1,'Independent');""",
    """INSERT INTO "sect" VALUES(2,'Sabbat');""",
    """INSERT INTO "sect" VALUES(3,'Camarilla');""",
    """INSERT INTO "sect" VALUES(4,'Laibon');""",
    """CREATE TABLE title (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE);""",
    """INSERT INTO "title" VALUES(1,'Archbishop');""",
    """INSERT INTO "title" VALUES(2,'Primogen');""",
    """INSERT INTO "title" VALUES(3,'Inner Circle');""",
    """INSERT INTO "title" VALUES(4,'Bishop');""",
    """INSERT INTO "title" VALUES(5,'Independent with 1 vote');""",
    """INSERT INTO "title" VALUES(6,'Independent with 2 votes');""",
    """INSERT INTO "title" VALUES(7,'Justicar');""",
    """INSERT INTO "title" VALUES(8,'Cardinal');""",
    """INSERT INTO "title" VALUES(9,'Prince');""",
    """INSERT INTO "title" VALUES(10,'Priscus');""",
    """INSERT INTO "title" VALUES(11,'Magaji');""",
    """INSERT INTO "title" VALUES(12,'Regent');""",
    """CREATE TABLE ruling (    id INTEGER PRIMARY KEY AUTOINCREMENT,    text VARCHAR(512) NOT NULL UNIQUE,    code TEXT,    url TEXT);""",
    """INSERT INTO "ruling" VALUES(1,'The AK-47 provides the bearer one optional maneuver "each combat".','[LSJ 20070928]',NULL);""",
    """INSERT INTO "ruling" VALUES(2,'Cannot be used to prevent damage that cannot be prevented by cards that require Fortitude (e.g., Blood Rage and Blood Fury).','[LSJ 19990216]',NULL);""",
    """INSERT INTO "ruling" VALUES(3,'Cannot use his special ability if his controller has no vampires in her uncontrolled region.','[LSJ 19990215]',NULL);""",
    """CREATE TABLE virtue (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    fullname TEXT);""",
    """INSERT INTO "virtue" VALUES(1,'red','Redemption');""",
    """INSERT INTO "virtue" VALUES(2,'mar','Martyrdom');""",
    """INSERT INTO "virtue" VALUES(3,'vis','Vision');""",
    """INSERT INTO "virtue" VALUES(4,'jud','Judgment');""",
    """INSERT INTO "virtue" VALUES(5,'inn','Innocence');""",
    """INSERT INTO "virtue" VALUES(6,'ven','Vengeance');""",
    """CREATE TABLE creed (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    shortname TEXT);""",
    """INSERT INTO "creed" VALUES(1,'Martyr','Martyr');""",
    """INSERT INTO "creed" VALUES(2,'Visionary','Visionary');""",
    """INSERT INTO "creed" VALUES(3,'Innocent','Innocent');""",
    """CREATE TABLE artist (    id INTEGER PRIMARY KEY AUTOINCREMENT,    canonical_name VARCHAR(512) NOT NULL UNIQUE,    name TEXT);""",
    """INSERT INTO "artist" VALUES(1,'né né thomas','Né Né Thomas');""",
    """INSERT INTO "artist" VALUES(2,'greg simanson','Greg Simanson');""",
    """INSERT INTO "artist" VALUES(3,'franz vohwinkel','Franz Vohwinkel');""",
    """INSERT INTO "artist" VALUES(4,'lawrence snelly','Lawrence Snelly');""",
    """INSERT INTO "artist" VALUES(5,'rik martin','Rik Martin');""",
    """INSERT INTO "artist" VALUES(6,'eric lacombe','Eric LaCombe');""",
    """INSERT INTO "artist" VALUES(7,'thomas nairb','Thomas Nairb');""",
    """INSERT INTO "artist" VALUES(8,'christopher rush','Christopher Rush');""",
    """INSERT INTO "artist" VALUES(9,'steve ellis','Steve Ellis');""",
    """INSERT INTO "artist" VALUES(10,'john bridges','John Bridges');""",
    """INSERT INTO "artist" VALUES(11,'tom wänerstrand','Tom Wänerstrand');""",
    """INSERT INTO "artist" VALUES(12,'ken meyer, jr.','Ken Meyer, Jr.');""",
    """INSERT INTO "artist" VALUES(13,'james stowe','James Stowe');""",
    """INSERT INTO "artist" VALUES(14,'brian leblanc','Brian LeBlanc');""",
    """INSERT INTO "artist" VALUES(15,'richard thomas','Richard Thomas');""",
    """INSERT INTO "artist" VALUES(16,'jeff holt','Jeff Holt');""",
    """INSERT INTO "artist" VALUES(17,'terese nielsen','Terese Nielsen');""",
    """INSERT INTO "artist" VALUES(18,'steve prescott','Steve Prescott');""",
    """INSERT INTO "artist" VALUES(19,'leif jones','Leif Jones');""",
    """INSERT INTO "artist" VALUES(20,'quinton hoover','Quinton Hoover');""",
    """INSERT INTO "artist" VALUES(21,'christopher shy','Christopher Shy');""",
    """INSERT INTO "artist" VALUES(22,'pete venters','Pete Venters');""",
    """INSERT INTO "artist" VALUES(23,'john bolton','John Bolton');""",
    """INSERT INTO "artist" VALUES(24,'thomas manning','Thomas Manning');""",
    """INSERT INTO "artist" VALUES(25,'mark tedin','Mark Tedin');""",
    """INSERT INTO "artist" VALUES(26,'nilson','Nilson');""",
    """INSERT INTO "artist" VALUES(27,'david day','David Day');""",
    """INSERT INTO "artist" VALUES(28,'abrar ajmal','Abrar Ajmal');""",
    """INSERT INTO "artist" VALUES(29,'heather hudson','Heather Hudson');""",
    """INSERT INTO "artist" VALUES(30,'mike huddleston','Mike Huddleston');""",
    """INSERT INTO "artist" VALUES(31,'mark nelson','Mark Nelson');""",
    """INSERT INTO "artist" VALUES(32,'l. a. williams','L. A. Williams');""",
    """INSERT INTO "artist" VALUES(33,'max shade fellwalker','Max Shade Fellwalker');""",
    """INSERT INTO "artist" VALUES(34,'jim pavelec','Jim Pavelec');""",
    """INSERT INTO "artist" VALUES(35,'rebecca guay','Rebecca Guay');""",
    """INSERT INTO "artist" VALUES(36,'anson maddocks','Anson Maddocks');""",
    """INSERT INTO "artist" VALUES(37,'sam araya','Sam Araya');""",
    """INSERT INTO "artist" VALUES(38,'roel wielinga','Roel Wielinga');""",
    """INSERT INTO "artist" VALUES(39,'william o''connor','William O''Connor');""",
    """INSERT INTO "artist" VALUES(40,'drew tucker','Drew Tucker');""",
    """INSERT INTO "artist" VALUES(41,'john scotello','John Scotello');""",
    """INSERT INTO "artist" VALUES(42,'melissa uran','Melissa Uran');""",
    """INSERT INTO "artist" VALUES(43,'brian snoddy','Brian Snoddy');""",
    """INSERT INTO "artist" VALUES(44,'dan frazier','Dan Frazier');""",
    """INSERT INTO "artist" VALUES(45,'stuart beel','Stuart Beel');""",
    """INSERT INTO "artist" VALUES(46,'kari christensen','Kari Christensen');""",
    """INSERT INTO "artist" VALUES(47,'joel biske','Joel Biske');""",
    """INSERT INTO "artist" VALUES(48,'heather kreiter','Heather Kreiter');""",
    """CREATE TABLE keyword (    id INTEGER PRIMARY KEY AUTOINCREMENT,    keyword VARCHAR(512) NOT NULL UNIQUE);""",
    """INSERT INTO "keyword" VALUES(1,'weapon');""",
    """INSERT INTO "keyword" VALUES(2,'gun');""",
    """INSERT INTO "keyword" VALUES(3,'0 stealth');""",
    """INSERT INTO "keyword" VALUES(4,'1 strength');""",
    """INSERT INTO "keyword" VALUES(5,'1 bleed');""",
    """INSERT INTO "keyword" VALUES(6,'0 intercept');""",
    """INSERT INTO "keyword" VALUES(7,'non-unique');""",
    """INSERT INTO "keyword" VALUES(8,'unique');""",
    """INSERT INTO "keyword" VALUES(9,'blood cursed');""",
    """INSERT INTO "keyword" VALUES(10,'discipline');""",
    """INSERT INTO "keyword" VALUES(11,'trifle');""",
    """INSERT INTO "keyword" VALUES(12,'advanced');""",
    """INSERT INTO "keyword" VALUES(13,'3 bleed');""",
    """INSERT INTO "keyword" VALUES(14,'2 bleed');""",
    """INSERT INTO "keyword" VALUES(15,'location');""",
    """INSERT INTO "keyword" VALUES(16,'mortal');""",
    """INSERT INTO "keyword" VALUES(17,'archetype');""",
    """INSERT INTO "keyword" VALUES(18,'not for legal play');""",
    """INSERT INTO "keyword" VALUES(19,'3 strength');""",
    """INSERT INTO "keyword" VALUES(20,'red list');""",
    """INSERT INTO "keyword" VALUES(21,'0 strength');""",
    """INSERT INTO "keyword" VALUES(22,'ghoul');""",
    """INSERT INTO "keyword" VALUES(23,'1 stealth');""",
    """INSERT INTO "keyword" VALUES(24,'werewolf');""",
    """INSERT INTO "keyword" VALUES(25,'0 bleed');""",
    """INSERT INTO "keyword" VALUES(26,'1 intercept');""",
    """INSERT INTO "keyword" VALUES(27,'2 strength');""",
    """INSERT INTO "keyword" VALUES(28,'scarce');""",
    """INSERT INTO "keyword" VALUES(29,'sterile');""",
    """INSERT INTO "keyword" VALUES(30,'burn option');""",
    """INSERT INTO "keyword" VALUES(31,'hunting ground');""",
    """INSERT INTO "keyword" VALUES(32,'investment');""",
    """INSERT INTO "keyword" VALUES(33,'animal');""",
    """INSERT INTO "keyword" VALUES(34,'gargoyle creature');""",
    """INSERT INTO "keyword" VALUES(35,'demon');""",
    """INSERT INTO "keyword" VALUES(36,'out-of-turn');""",
    """CREATE TABLE abs_rarity_pair_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    rarity_pair_id INT NOT NULL CONSTRAINT rarity_pair_id_exists REFERENCES rarity_pair(id) );""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(1,1,1);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(2,1,2);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(3,1,3);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(4,1,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(5,1,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(6,1,6);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(7,2,8);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(8,3,9);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(9,4,10);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(10,5,11);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(11,5,12);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(12,6,13);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(13,6,14);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(14,6,15);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(15,6,16);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(16,7,15);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(17,7,17);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(18,8,18);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(19,9,19);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(20,9,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(21,10,21);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(22,11,22);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(23,12,23);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(24,13,24);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(25,13,25);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(26,13,17);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(27,14,26);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(28,14,6);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(29,15,27);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(30,16,28);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(31,16,29);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(32,17,30);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(33,17,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(34,17,31);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(35,17,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(36,17,32);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(37,17,33);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(38,18,19);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(39,18,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(40,19,7);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(41,19,34);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(42,20,35);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(43,21,36);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(44,21,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(45,22,7);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(46,22,34);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(47,23,9);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(48,24,19);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(49,24,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(50,25,7);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(51,25,33);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(52,25,34);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(53,26,11);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(54,26,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(55,27,37);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(56,27,38);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(57,27,39);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(58,28,40);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(59,29,41);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(60,29,42);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(61,29,43);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(62,30,44);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(63,31,11);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(64,31,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(65,32,22);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(66,32,29);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(67,33,6);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(68,34,41);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(69,34,42);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(70,34,38);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(71,34,32);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(72,34,45);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(73,35,40);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(74,36,46);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(75,36,33);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(76,37,47);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(77,38,13);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(78,38,14);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(79,38,15);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(80,38,39);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(81,38,16);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(82,39,7);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(83,39,34);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(84,40,48);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(85,40,49);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(86,41,50);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(87,41,51);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(88,42,40);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(89,43,21);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(90,44,46);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(91,45,19);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(92,45,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(93,46,24);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(94,46,25);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(95,46,17);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(96,47,30);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(97,47,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(98,47,52);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(99,48,53);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(100,48,16);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(101,49,46);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(102,50,50);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(103,50,51);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(104,51,30);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(105,51,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(106,51,52);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(107,52,54);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(108,52,20);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(109,52,52);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(110,53,12);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(111,53,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(112,53,18);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(113,53,39);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(114,54,55);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(115,54,12);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(116,54,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(117,54,29);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(118,55,26);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(119,56,1);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(120,56,2);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(121,56,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(122,57,48);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(123,57,49);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(124,57,38);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(125,57,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(126,57,32);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(127,57,45);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(128,57,33);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(129,57,56);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(130,57,52);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(131,57,39);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(132,58,36);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(133,58,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(134,59,50);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(135,59,51);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(136,59,29);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(137,60,57);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(138,61,55);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(139,61,4);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(140,62,10);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(141,63,47);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(142,64,58);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(143,64,26);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(144,65,59);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(145,66,60);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(146,66,6);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(147,67,7);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(148,67,5);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(149,67,34);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(150,68,61);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(151,68,29);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(152,69,62);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(153,69,63);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(154,70,48);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(155,70,49);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(156,70,38);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(157,70,32);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(158,70,33);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(159,70,18);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(160,70,63);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(161,71,23);""",
    """INSERT INTO "abs_rarity_pair_map" VALUES(162,72,64);""",
    """CREATE TABLE abs_ruling_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    ruling_id INT NOT NULL CONSTRAINT ruling_id_exists REFERENCES ruling(id) );""",
    """INSERT INTO "abs_ruling_map" VALUES(1,2,1);""",
    """INSERT INTO "abs_ruling_map" VALUES(2,13,2);""",
    """INSERT INTO "abs_ruling_map" VALUES(3,45,3);""",
    """CREATE TABLE abs_clan_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    clan_id INT NOT NULL CONSTRAINT clan_id_exists REFERENCES clan(id) );""",
    """INSERT INTO "abs_clan_map" VALUES(1,3,1);""",
    """INSERT INTO "abs_clan_map" VALUES(2,4,2);""",
    """INSERT INTO "abs_clan_map" VALUES(3,5,3);""",
    """INSERT INTO "abs_clan_map" VALUES(4,9,4);""",
    """INSERT INTO "abs_clan_map" VALUES(5,10,1);""",
    """INSERT INTO "abs_clan_map" VALUES(6,11,5);""",
    """INSERT INTO "abs_clan_map" VALUES(7,15,2);""",
    """INSERT INTO "abs_clan_map" VALUES(8,18,6);""",
    """INSERT INTO "abs_clan_map" VALUES(9,19,7);""",
    """INSERT INTO "abs_clan_map" VALUES(10,20,7);""",
    """INSERT INTO "abs_clan_map" VALUES(11,21,8);""",
    """INSERT INTO "abs_clan_map" VALUES(12,22,9);""",
    """INSERT INTO "abs_clan_map" VALUES(13,23,10);""",
    """INSERT INTO "abs_clan_map" VALUES(14,24,1);""",
    """INSERT INTO "abs_clan_map" VALUES(15,25,11);""",
    """INSERT INTO "abs_clan_map" VALUES(16,26,3);""",
    """INSERT INTO "abs_clan_map" VALUES(17,27,11);""",
    """INSERT INTO "abs_clan_map" VALUES(18,29,8);""",
    """INSERT INTO "abs_clan_map" VALUES(19,31,12);""",
    """INSERT INTO "abs_clan_map" VALUES(20,32,13);""",
    """INSERT INTO "abs_clan_map" VALUES(21,33,14);""",
    """INSERT INTO "abs_clan_map" VALUES(22,36,15);""",
    """INSERT INTO "abs_clan_map" VALUES(23,37,13);""",
    """INSERT INTO "abs_clan_map" VALUES(24,39,7);""",
    """INSERT INTO "abs_clan_map" VALUES(25,40,16);""",
    """INSERT INTO "abs_clan_map" VALUES(26,41,17);""",
    """INSERT INTO "abs_clan_map" VALUES(27,43,4);""",
    """INSERT INTO "abs_clan_map" VALUES(28,44,1);""",
    """INSERT INTO "abs_clan_map" VALUES(29,45,18);""",
    """INSERT INTO "abs_clan_map" VALUES(30,46,19);""",
    """INSERT INTO "abs_clan_map" VALUES(31,49,20);""",
    """INSERT INTO "abs_clan_map" VALUES(32,50,21);""",
    """INSERT INTO "abs_clan_map" VALUES(33,51,18);""",
    """INSERT INTO "abs_clan_map" VALUES(34,52,4);""",
    """INSERT INTO "abs_clan_map" VALUES(35,54,3);""",
    """INSERT INTO "abs_clan_map" VALUES(36,58,11);""",
    """INSERT INTO "abs_clan_map" VALUES(37,59,13);""",
    """INSERT INTO "abs_clan_map" VALUES(38,60,10);""",
    """INSERT INTO "abs_clan_map" VALUES(39,62,19);""",
    """INSERT INTO "abs_clan_map" VALUES(40,63,17);""",
    """INSERT INTO "abs_clan_map" VALUES(41,64,22);""",
    """INSERT INTO "abs_clan_map" VALUES(42,67,8);""",
    """CREATE TABLE abs_discipline_pair_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    discipline_pair_id INT NOT NULL CONSTRAINT discipline_pair_id_exists REFERENCES discipline_pair(id) );""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(1,3,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(2,3,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(3,3,3);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(4,4,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(5,4,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(6,4,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(7,5,6);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(8,7,7);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(9,9,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(10,9,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(11,9,9);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(12,10,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(13,10,10);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(14,10,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(15,10,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(16,10,3);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(17,11,10);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(18,11,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(19,11,11);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(20,13,12);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(21,15,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(22,15,14);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(23,15,15);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(24,15,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(25,15,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(26,17,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(27,18,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(28,18,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(29,18,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(30,18,9);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(31,19,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(32,19,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(33,19,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(34,19,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(35,20,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(36,20,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(37,20,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(38,20,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(39,21,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(40,21,15);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(41,21,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(42,21,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(43,21,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(44,22,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(45,22,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(46,22,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(47,22,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(48,23,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(49,23,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(50,23,23);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(51,23,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(52,23,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(53,24,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(54,24,14);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(55,24,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(56,24,24);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(57,25,25);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(58,25,26);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(59,25,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(60,25,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(61,25,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(62,26,26);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(63,26,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(64,26,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(65,26,27);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(66,26,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(67,29,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(68,29,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(69,29,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(70,29,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(71,31,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(72,31,6);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(73,31,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(74,31,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(75,31,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(76,32,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(77,32,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(78,32,28);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(79,32,12);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(80,32,29);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(81,33,25);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(82,33,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(83,33,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(84,33,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(85,33,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(86,33,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(87,36,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(88,36,15);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(89,36,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(90,36,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(91,36,17);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(92,36,30);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(93,37,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(94,37,31);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(95,37,28);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(96,37,29);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(97,39,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(98,39,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(99,39,20);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(100,39,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(101,43,32);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(102,43,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(103,43,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(104,43,8);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(105,43,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(106,43,9);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(107,44,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(108,44,21);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(109,44,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(110,44,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(111,44,24);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(112,44,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(113,45,1);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(114,49,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(115,49,2);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(116,49,16);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(117,49,30);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(118,55,33);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(119,57,15);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(120,58,5);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(121,58,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(122,58,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(123,58,22);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(124,61,27);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(125,62,4);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(126,62,31);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(127,62,15);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(128,62,19);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(129,62,34);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(130,62,35);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(131,63,25);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(132,63,14);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(133,63,18);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(134,63,36);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(135,67,13);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(136,67,26);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(137,68,37);""",
    """INSERT INTO "abs_discipline_pair_map" VALUES(138,68,19);""",
    """CREATE TABLE abs_type_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    card_type_id INT NOT NULL CONSTRAINT card_type_id_exists REFERENCES card_type(id) );""",
    """INSERT INTO "abs_type_map" VALUES(1,1,1);""",
    """INSERT INTO "abs_type_map" VALUES(2,2,1);""",
    """INSERT INTO "abs_type_map" VALUES(3,3,2);""",
    """INSERT INTO "abs_type_map" VALUES(4,4,2);""",
    """INSERT INTO "abs_type_map" VALUES(5,5,2);""",
    """INSERT INTO "abs_type_map" VALUES(6,6,1);""",
    """INSERT INTO "abs_type_map" VALUES(7,7,3);""",
    """INSERT INTO "abs_type_map" VALUES(8,7,4);""",
    """INSERT INTO "abs_type_map" VALUES(9,8,5);""",
    """INSERT INTO "abs_type_map" VALUES(10,9,2);""",
    """INSERT INTO "abs_type_map" VALUES(11,10,2);""",
    """INSERT INTO "abs_type_map" VALUES(12,11,2);""",
    """INSERT INTO "abs_type_map" VALUES(13,12,6);""",
    """INSERT INTO "abs_type_map" VALUES(14,13,5);""",
    """INSERT INTO "abs_type_map" VALUES(15,14,7);""",
    """INSERT INTO "abs_type_map" VALUES(16,15,2);""",
    """INSERT INTO "abs_type_map" VALUES(17,16,7);""",
    """INSERT INTO "abs_type_map" VALUES(18,17,8);""",
    """INSERT INTO "abs_type_map" VALUES(19,18,2);""",
    """INSERT INTO "abs_type_map" VALUES(20,19,2);""",
    """INSERT INTO "abs_type_map" VALUES(21,20,2);""",
    """INSERT INTO "abs_type_map" VALUES(22,21,2);""",
    """INSERT INTO "abs_type_map" VALUES(23,22,2);""",
    """INSERT INTO "abs_type_map" VALUES(24,23,2);""",
    """INSERT INTO "abs_type_map" VALUES(25,24,2);""",
    """INSERT INTO "abs_type_map" VALUES(26,25,2);""",
    """INSERT INTO "abs_type_map" VALUES(27,26,2);""",
    """INSERT INTO "abs_type_map" VALUES(28,27,1);""",
    """INSERT INTO "abs_type_map" VALUES(29,28,9);""",
    """INSERT INTO "abs_type_map" VALUES(30,29,2);""",
    """INSERT INTO "abs_type_map" VALUES(31,30,7);""",
    """INSERT INTO "abs_type_map" VALUES(32,31,2);""",
    """INSERT INTO "abs_type_map" VALUES(33,32,2);""",
    """INSERT INTO "abs_type_map" VALUES(34,33,2);""",
    """INSERT INTO "abs_type_map" VALUES(35,34,10);""",
    """INSERT INTO "abs_type_map" VALUES(36,35,9);""",
    """INSERT INTO "abs_type_map" VALUES(37,36,2);""",
    """INSERT INTO "abs_type_map" VALUES(38,37,2);""",
    """INSERT INTO "abs_type_map" VALUES(39,38,11);""",
    """INSERT INTO "abs_type_map" VALUES(40,39,2);""",
    """INSERT INTO "abs_type_map" VALUES(41,40,12);""",
    """INSERT INTO "abs_type_map" VALUES(42,41,12);""",
    """INSERT INTO "abs_type_map" VALUES(43,42,9);""",
    """INSERT INTO "abs_type_map" VALUES(44,43,2);""",
    """INSERT INTO "abs_type_map" VALUES(45,44,2);""",
    """INSERT INTO "abs_type_map" VALUES(46,45,2);""",
    """INSERT INTO "abs_type_map" VALUES(47,46,1);""",
    """INSERT INTO "abs_type_map" VALUES(48,47,7);""",
    """INSERT INTO "abs_type_map" VALUES(49,48,12);""",
    """INSERT INTO "abs_type_map" VALUES(50,49,2);""",
    """INSERT INTO "abs_type_map" VALUES(51,50,7);""",
    """INSERT INTO "abs_type_map" VALUES(52,51,7);""",
    """INSERT INTO "abs_type_map" VALUES(53,52,7);""",
    """INSERT INTO "abs_type_map" VALUES(54,53,1);""",
    """INSERT INTO "abs_type_map" VALUES(55,54,7);""",
    """INSERT INTO "abs_type_map" VALUES(56,55,3);""",
    """INSERT INTO "abs_type_map" VALUES(57,55,13);""",
    """INSERT INTO "abs_type_map" VALUES(58,56,7);""",
    """INSERT INTO "abs_type_map" VALUES(59,57,11);""",
    """INSERT INTO "abs_type_map" VALUES(60,58,2);""",
    """INSERT INTO "abs_type_map" VALUES(61,59,12);""",
    """INSERT INTO "abs_type_map" VALUES(62,60,12);""",
    """INSERT INTO "abs_type_map" VALUES(63,61,11);""",
    """INSERT INTO "abs_type_map" VALUES(64,62,2);""",
    """INSERT INTO "abs_type_map" VALUES(65,63,2);""",
    """INSERT INTO "abs_type_map" VALUES(66,64,7);""",
    """INSERT INTO "abs_type_map" VALUES(67,65,7);""",
    """INSERT INTO "abs_type_map" VALUES(68,66,7);""",
    """INSERT INTO "abs_type_map" VALUES(69,67,2);""",
    """INSERT INTO "abs_type_map" VALUES(70,68,3);""",
    """INSERT INTO "abs_type_map" VALUES(71,69,7);""",
    """INSERT INTO "abs_type_map" VALUES(72,70,7);""",
    """INSERT INTO "abs_type_map" VALUES(73,71,4);""",
    """INSERT INTO "abs_type_map" VALUES(74,72,7);""",
    """CREATE TABLE abs_sect_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    sect_id INT NOT NULL CONSTRAINT sect_id_exists REFERENCES sect(id) );""",
    """INSERT INTO "abs_sect_map" VALUES(1,3,1);""",
    """INSERT INTO "abs_sect_map" VALUES(2,4,2);""",
    """INSERT INTO "abs_sect_map" VALUES(3,5,2);""",
    """INSERT INTO "abs_sect_map" VALUES(4,9,1);""",
    """INSERT INTO "abs_sect_map" VALUES(5,10,1);""",
    """INSERT INTO "abs_sect_map" VALUES(6,11,1);""",
    """INSERT INTO "abs_sect_map" VALUES(7,15,2);""",
    """INSERT INTO "abs_sect_map" VALUES(8,18,3);""",
    """INSERT INTO "abs_sect_map" VALUES(9,19,3);""",
    """INSERT INTO "abs_sect_map" VALUES(10,20,3);""",
    """INSERT INTO "abs_sect_map" VALUES(11,21,3);""",
    """INSERT INTO "abs_sect_map" VALUES(12,22,2);""",
    """INSERT INTO "abs_sect_map" VALUES(13,23,1);""",
    """INSERT INTO "abs_sect_map" VALUES(14,24,1);""",
    """INSERT INTO "abs_sect_map" VALUES(15,25,3);""",
    """INSERT INTO "abs_sect_map" VALUES(16,26,2);""",
    """INSERT INTO "abs_sect_map" VALUES(17,29,3);""",
    """INSERT INTO "abs_sect_map" VALUES(18,31,2);""",
    """INSERT INTO "abs_sect_map" VALUES(19,32,3);""",
    """INSERT INTO "abs_sect_map" VALUES(20,33,4);""",
    """INSERT INTO "abs_sect_map" VALUES(21,36,2);""",
    """INSERT INTO "abs_sect_map" VALUES(22,37,3);""",
    """INSERT INTO "abs_sect_map" VALUES(23,39,3);""",
    """INSERT INTO "abs_sect_map" VALUES(24,43,4);""",
    """INSERT INTO "abs_sect_map" VALUES(25,44,1);""",
    """INSERT INTO "abs_sect_map" VALUES(26,45,1);""",
    """INSERT INTO "abs_sect_map" VALUES(27,49,1);""",
    """INSERT INTO "abs_sect_map" VALUES(28,58,3);""",
    """INSERT INTO "abs_sect_map" VALUES(29,62,2);""",
    """INSERT INTO "abs_sect_map" VALUES(30,63,2);""",
    """INSERT INTO "abs_sect_map" VALUES(31,67,3);""",
    """CREATE TABLE abs_title_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    title_id INT NOT NULL CONSTRAINT title_id_exists REFERENCES title(id) );""",
    """INSERT INTO "abs_title_map" VALUES(1,15,1);""",
    """INSERT INTO "abs_title_map" VALUES(2,18,2);""",
    """INSERT INTO "abs_title_map" VALUES(3,21,3);""",
    """INSERT INTO "abs_title_map" VALUES(4,22,4);""",
    """INSERT INTO "abs_title_map" VALUES(5,23,5);""",
    """INSERT INTO "abs_title_map" VALUES(6,24,6);""",
    """INSERT INTO "abs_title_map" VALUES(7,25,7);""",
    """INSERT INTO "abs_title_map" VALUES(8,26,8);""",
    """INSERT INTO "abs_title_map" VALUES(9,29,9);""",
    """INSERT INTO "abs_title_map" VALUES(10,31,10);""",
    """INSERT INTO "abs_title_map" VALUES(11,33,11);""",
    """INSERT INTO "abs_title_map" VALUES(12,39,2);""",
    """INSERT INTO "abs_title_map" VALUES(13,43,11);""",
    """INSERT INTO "abs_title_map" VALUES(14,62,12);""",
    """CREATE TABLE abs_virtue_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    virtue_id INT NOT NULL CONSTRAINT virtue_id_exists REFERENCES virtue(id) );""",
    """INSERT INTO "abs_virtue_map" VALUES(1,12,1);""",
    """INSERT INTO "abs_virtue_map" VALUES(2,28,2);""",
    """INSERT INTO "abs_virtue_map" VALUES(3,28,1);""",
    """INSERT INTO "abs_virtue_map" VALUES(4,28,3);""",
    """INSERT INTO "abs_virtue_map" VALUES(5,35,4);""",
    """INSERT INTO "abs_virtue_map" VALUES(6,35,2);""",
    """INSERT INTO "abs_virtue_map" VALUES(7,35,3);""",
    """INSERT INTO "abs_virtue_map" VALUES(8,42,5);""",
    """INSERT INTO "abs_virtue_map" VALUES(9,71,6);""",
    """CREATE TABLE abs_creed_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    creed_id INT NOT NULL CONSTRAINT creed_id_exists REFERENCES creed(id) );""",
    """INSERT INTO "abs_creed_map" VALUES(1,28,1);""",
    """INSERT INTO "abs_creed_map" VALUES(2,35,2);""",
    """INSERT INTO "abs_creed_map" VALUES(3,42,3);""",
    """CREATE TABLE abs_artist_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    artist_id INT NOT NULL CONSTRAINT artist_id_exists REFERENCES artist(id) );""",
    """INSERT INTO "abs_artist_map" VALUES(1,1,1);""",
    """INSERT INTO "abs_artist_map" VALUES(2,1,2);""",
    """INSERT INTO "abs_artist_map" VALUES(3,2,3);""",
    """INSERT INTO "abs_artist_map" VALUES(4,3,4);""",
    """INSERT INTO "abs_artist_map" VALUES(5,4,5);""",
    """INSERT INTO "abs_artist_map" VALUES(6,5,6);""",
    """INSERT INTO "abs_artist_map" VALUES(7,6,7);""",
    """INSERT INTO "abs_artist_map" VALUES(8,6,8);""",
    """INSERT INTO "abs_artist_map" VALUES(9,7,9);""",
    """INSERT INTO "abs_artist_map" VALUES(10,8,10);""",
    """INSERT INTO "abs_artist_map" VALUES(11,9,11);""",
    """INSERT INTO "abs_artist_map" VALUES(12,10,12);""",
    """INSERT INTO "abs_artist_map" VALUES(13,11,13);""",
    """INSERT INTO "abs_artist_map" VALUES(14,12,14);""",
    """INSERT INTO "abs_artist_map" VALUES(15,13,15);""",
    """INSERT INTO "abs_artist_map" VALUES(16,14,12);""",
    """INSERT INTO "abs_artist_map" VALUES(17,15,12);""",
    """INSERT INTO "abs_artist_map" VALUES(18,16,16);""",
    """INSERT INTO "abs_artist_map" VALUES(19,17,2);""",
    """INSERT INTO "abs_artist_map" VALUES(20,18,17);""",
    """INSERT INTO "abs_artist_map" VALUES(21,19,18);""",
    """INSERT INTO "abs_artist_map" VALUES(22,20,19);""",
    """INSERT INTO "abs_artist_map" VALUES(23,21,4);""",
    """INSERT INTO "abs_artist_map" VALUES(24,22,20);""",
    """INSERT INTO "abs_artist_map" VALUES(25,23,21);""",
    """INSERT INTO "abs_artist_map" VALUES(26,24,22);""",
    """INSERT INTO "abs_artist_map" VALUES(27,25,21);""",
    """INSERT INTO "abs_artist_map" VALUES(28,26,23);""",
    """INSERT INTO "abs_artist_map" VALUES(29,27,2);""",
    """INSERT INTO "abs_artist_map" VALUES(30,27,14);""",
    """INSERT INTO "abs_artist_map" VALUES(31,28,24);""",
    """INSERT INTO "abs_artist_map" VALUES(32,29,25);""",
    """INSERT INTO "abs_artist_map" VALUES(33,30,26);""",
    """INSERT INTO "abs_artist_map" VALUES(34,31,12);""",
    """INSERT INTO "abs_artist_map" VALUES(35,32,27);""",
    """INSERT INTO "abs_artist_map" VALUES(36,33,28);""",
    """INSERT INTO "abs_artist_map" VALUES(37,34,29);""",
    """INSERT INTO "abs_artist_map" VALUES(38,34,30);""",
    """INSERT INTO "abs_artist_map" VALUES(39,35,27);""",
    """INSERT INTO "abs_artist_map" VALUES(40,36,31);""",
    """INSERT INTO "abs_artist_map" VALUES(41,37,21);""",
    """INSERT INTO "abs_artist_map" VALUES(42,38,32);""",
    """INSERT INTO "abs_artist_map" VALUES(43,38,15);""",
    """INSERT INTO "abs_artist_map" VALUES(44,39,33);""",
    """INSERT INTO "abs_artist_map" VALUES(45,40,22);""",
    """INSERT INTO "abs_artist_map" VALUES(46,41,31);""",
    """INSERT INTO "abs_artist_map" VALUES(47,42,34);""",
    """INSERT INTO "abs_artist_map" VALUES(48,43,12);""",
    """INSERT INTO "abs_artist_map" VALUES(49,44,4);""",
    """INSERT INTO "abs_artist_map" VALUES(50,45,35);""",
    """INSERT INTO "abs_artist_map" VALUES(51,46,25);""",
    """INSERT INTO "abs_artist_map" VALUES(52,47,36);""",
    """INSERT INTO "abs_artist_map" VALUES(53,47,37);""",
    """INSERT INTO "abs_artist_map" VALUES(54,48,38);""",
    """INSERT INTO "abs_artist_map" VALUES(55,49,15);""",
    """INSERT INTO "abs_artist_map" VALUES(56,50,39);""",
    """INSERT INTO "abs_artist_map" VALUES(57,51,22);""",
    """INSERT INTO "abs_artist_map" VALUES(58,51,37);""",
    """INSERT INTO "abs_artist_map" VALUES(59,52,40);""",
    """INSERT INTO "abs_artist_map" VALUES(60,52,16);""",
    """INSERT INTO "abs_artist_map" VALUES(61,53,18);""",
    """INSERT INTO "abs_artist_map" VALUES(62,54,41);""",
    """INSERT INTO "abs_artist_map" VALUES(63,54,42);""",
    """INSERT INTO "abs_artist_map" VALUES(64,55,27);""",
    """INSERT INTO "abs_artist_map" VALUES(65,56,43);""",
    """INSERT INTO "abs_artist_map" VALUES(66,57,16);""",
    """INSERT INTO "abs_artist_map" VALUES(67,57,44);""",
    """INSERT INTO "abs_artist_map" VALUES(68,58,36);""",
    """INSERT INTO "abs_artist_map" VALUES(69,59,16);""",
    """INSERT INTO "abs_artist_map" VALUES(70,60,15);""",
    """INSERT INTO "abs_artist_map" VALUES(71,61,45);""",
    """INSERT INTO "abs_artist_map" VALUES(72,62,15);""",
    """INSERT INTO "abs_artist_map" VALUES(73,63,4);""",
    """INSERT INTO "abs_artist_map" VALUES(74,64,39);""",
    """INSERT INTO "abs_artist_map" VALUES(75,65,19);""",
    """INSERT INTO "abs_artist_map" VALUES(76,66,21);""",
    """INSERT INTO "abs_artist_map" VALUES(77,67,19);""",
    """INSERT INTO "abs_artist_map" VALUES(78,68,46);""",
    """INSERT INTO "abs_artist_map" VALUES(79,69,47);""",
    """INSERT INTO "abs_artist_map" VALUES(80,70,22);""",
    """INSERT INTO "abs_artist_map" VALUES(81,70,18);""",
    """INSERT INTO "abs_artist_map" VALUES(82,71,48);""",
    """CREATE TABLE abs_keyword_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    abstract_card_id INT NOT NULL CONSTRAINT abstract_card_id_exists REFERENCES abstract_card(id) ,    keyword_id INT NOT NULL CONSTRAINT keyword_id_exists REFERENCES keyword(id) );""",
    """INSERT INTO "abs_keyword_map" VALUES(1,1,1);""",
    """INSERT INTO "abs_keyword_map" VALUES(2,1,2);""",
    """INSERT INTO "abs_keyword_map" VALUES(3,2,1);""",
    """INSERT INTO "abs_keyword_map" VALUES(4,2,2);""",
    """INSERT INTO "abs_keyword_map" VALUES(5,3,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(6,3,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(7,3,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(8,3,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(9,3,7);""",
    """INSERT INTO "abs_keyword_map" VALUES(10,4,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(11,4,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(12,4,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(13,4,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(14,5,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(15,5,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(16,5,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(17,5,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(18,6,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(19,9,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(20,9,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(21,9,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(22,9,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(23,9,9);""",
    """INSERT INTO "abs_keyword_map" VALUES(24,10,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(25,10,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(26,10,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(27,10,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(28,11,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(29,11,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(30,11,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(31,11,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(32,14,10);""",
    """INSERT INTO "abs_keyword_map" VALUES(33,14,11);""",
    """INSERT INTO "abs_keyword_map" VALUES(34,15,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(35,15,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(36,15,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(37,15,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(38,16,10);""",
    """INSERT INTO "abs_keyword_map" VALUES(39,16,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(40,16,11);""",
    """INSERT INTO "abs_keyword_map" VALUES(41,18,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(42,18,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(43,18,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(44,18,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(45,19,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(46,19,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(47,19,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(48,19,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(49,20,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(50,20,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(51,20,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(52,20,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(53,20,12);""",
    """INSERT INTO "abs_keyword_map" VALUES(54,21,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(55,21,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(56,21,13);""",
    """INSERT INTO "abs_keyword_map" VALUES(57,21,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(58,22,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(59,22,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(60,22,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(61,22,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(62,23,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(63,23,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(64,23,14);""",
    """INSERT INTO "abs_keyword_map" VALUES(65,23,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(66,24,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(67,24,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(68,24,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(69,24,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(70,25,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(71,25,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(72,25,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(73,25,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(74,26,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(75,26,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(76,26,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(77,26,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(78,27,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(79,27,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(80,28,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(81,28,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(82,28,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(83,28,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(84,28,16);""",
    """INSERT INTO "abs_keyword_map" VALUES(85,29,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(86,29,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(87,29,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(88,29,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(89,30,17);""",
    """INSERT INTO "abs_keyword_map" VALUES(90,31,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(91,31,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(92,31,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(93,31,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(94,32,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(95,32,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(96,32,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(97,32,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(98,33,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(99,33,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(100,33,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(101,33,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(102,34,18);""",
    """INSERT INTO "abs_keyword_map" VALUES(103,35,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(104,35,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(105,35,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(106,35,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(107,35,16);""",
    """INSERT INTO "abs_keyword_map" VALUES(108,36,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(109,36,19);""",
    """INSERT INTO "abs_keyword_map" VALUES(110,36,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(111,36,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(112,36,20);""",
    """INSERT INTO "abs_keyword_map" VALUES(113,37,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(114,37,21);""",
    """INSERT INTO "abs_keyword_map" VALUES(115,37,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(116,37,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(117,38,22);""",
    """INSERT INTO "abs_keyword_map" VALUES(118,38,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(119,39,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(120,39,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(121,39,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(122,39,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(123,40,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(124,40,16);""",
    """INSERT INTO "abs_keyword_map" VALUES(125,40,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(126,40,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(127,40,23);""",
    """INSERT INTO "abs_keyword_map" VALUES(128,41,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(129,41,24);""",
    """INSERT INTO "abs_keyword_map" VALUES(130,41,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(131,41,25);""",
    """INSERT INTO "abs_keyword_map" VALUES(132,41,26);""",
    """INSERT INTO "abs_keyword_map" VALUES(133,42,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(134,42,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(135,42,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(136,42,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(137,42,16);""",
    """INSERT INTO "abs_keyword_map" VALUES(138,43,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(139,43,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(140,43,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(141,43,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(142,44,23);""",
    """INSERT INTO "abs_keyword_map" VALUES(143,44,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(144,44,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(145,44,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(146,44,20);""",
    """INSERT INTO "abs_keyword_map" VALUES(147,44,12);""",
    """INSERT INTO "abs_keyword_map" VALUES(148,45,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(149,45,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(150,45,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(151,45,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(152,46,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(153,47,10);""",
    """INSERT INTO "abs_keyword_map" VALUES(154,48,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(155,48,24);""",
    """INSERT INTO "abs_keyword_map" VALUES(156,48,27);""",
    """INSERT INTO "abs_keyword_map" VALUES(157,48,25);""",
    """INSERT INTO "abs_keyword_map" VALUES(158,48,20);""",
    """INSERT INTO "abs_keyword_map" VALUES(159,49,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(160,49,27);""",
    """INSERT INTO "abs_keyword_map" VALUES(161,49,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(162,49,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(163,49,28);""",
    """INSERT INTO "abs_keyword_map" VALUES(164,49,29);""",
    """INSERT INTO "abs_keyword_map" VALUES(165,50,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(166,50,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(167,50,30);""",
    """INSERT INTO "abs_keyword_map" VALUES(168,51,31);""",
    """INSERT INTO "abs_keyword_map" VALUES(169,51,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(170,51,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(171,52,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(172,53,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(173,53,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(174,54,31);""",
    """INSERT INTO "abs_keyword_map" VALUES(175,54,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(176,54,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(177,56,32);""",
    """INSERT INTO "abs_keyword_map" VALUES(178,57,33);""",
    """INSERT INTO "abs_keyword_map" VALUES(179,58,23);""",
    """INSERT INTO "abs_keyword_map" VALUES(180,58,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(181,58,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(182,58,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(183,59,34);""",
    """INSERT INTO "abs_keyword_map" VALUES(184,59,19);""",
    """INSERT INTO "abs_keyword_map" VALUES(185,59,25);""",
    """INSERT INTO "abs_keyword_map" VALUES(186,60,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(187,60,16);""",
    """INSERT INTO "abs_keyword_map" VALUES(188,60,21);""",
    """INSERT INTO "abs_keyword_map" VALUES(189,60,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(190,61,35);""",
    """INSERT INTO "abs_keyword_map" VALUES(191,62,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(192,62,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(193,62,13);""",
    """INSERT INTO "abs_keyword_map" VALUES(194,62,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(195,63,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(196,63,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(197,63,14);""",
    """INSERT INTO "abs_keyword_map" VALUES(198,63,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(199,63,29);""",
    """INSERT INTO "abs_keyword_map" VALUES(200,64,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(201,64,30);""",
    """INSERT INTO "abs_keyword_map" VALUES(202,65,11);""",
    """INSERT INTO "abs_keyword_map" VALUES(203,65,36);""",
    """INSERT INTO "abs_keyword_map" VALUES(204,66,36);""",
    """INSERT INTO "abs_keyword_map" VALUES(205,67,3);""",
    """INSERT INTO "abs_keyword_map" VALUES(206,67,4);""",
    """INSERT INTO "abs_keyword_map" VALUES(207,67,5);""",
    """INSERT INTO "abs_keyword_map" VALUES(208,67,6);""",
    """INSERT INTO "abs_keyword_map" VALUES(209,69,8);""",
    """INSERT INTO "abs_keyword_map" VALUES(210,69,15);""",
    """INSERT INTO "abs_keyword_map" VALUES(211,72,18);""",
    """CREATE TABLE physical_card_set (    id INTEGER PRIMARY KEY AUTOINCREMENT,    name VARCHAR(512) NOT NULL UNIQUE,    author TEXT,    comment TEXT,    annotations TEXT,    inuse BOOLEAN,    parent_id INT CONSTRAINT parent_id_exists REFERENCES physical_card_set(id) );""",
    """CREATE TABLE physical_map (    id INTEGER PRIMARY KEY AUTOINCREMENT,    physical_card_id INT NOT NULL CONSTRAINT physical_card_id_exists REFERENCES physical_card(id) ,    physical_card_set_id INT NOT NULL CONSTRAINT physical_card_set_id_exists REFERENCES physical_card_set(id) );""",
    """CREATE INDEX physical_card_abstractCardIndex ON physical_card (abstract_card_id);""",
    """CREATE UNIQUE INDEX rarity_pair_expansionRarityIndex ON rarity_pair (expansion_id, rarity_id);""",
    """CREATE UNIQUE INDEX discipline_pair_disciplineLevelIndex ON discipline_pair (discipline_id, level);""",
    """CREATE INDEX abs_rarity_pair_map_abstractCardIndex ON abs_rarity_pair_map (abstract_card_id);""",
    """CREATE INDEX abs_rarity_pair_map_rarityPairIndex ON abs_rarity_pair_map (rarity_pair_id);""",
    """CREATE INDEX abs_ruling_map_abstractCardIndex ON abs_ruling_map (abstract_card_id);""",
    """CREATE INDEX abs_ruling_map_rulingIndex ON abs_ruling_map (ruling_id);""",
    """CREATE INDEX abs_clan_map_abstractCardIndex ON abs_clan_map (abstract_card_id);""",
    """CREATE INDEX abs_clan_map_clanIndex ON abs_clan_map (clan_id);""",
    """CREATE INDEX abs_discipline_pair_map_abstractCardIndex ON abs_discipline_pair_map (abstract_card_id);""",
    """CREATE INDEX abs_discipline_pair_map_disciplinePairIndex ON abs_discipline_pair_map (discipline_pair_id);""",
    """CREATE INDEX abs_type_map_abstractCardIndex ON abs_type_map (abstract_card_id);""",
    """CREATE INDEX abs_type_map_cardTypeIndex ON abs_type_map (card_type_id);""",
    """CREATE INDEX abs_sect_map_abstractCardIndex ON abs_sect_map (abstract_card_id);""",
    """CREATE INDEX abs_sect_map_sectIndex ON abs_sect_map (sect_id);""",
    """CREATE INDEX abs_title_map_abstractCardIndex ON abs_title_map (abstract_card_id);""",
    """CREATE INDEX abs_title_map_titleIndex ON abs_title_map (title_id);""",
    """CREATE INDEX abs_virtue_map_abstractCardIndex ON abs_virtue_map (abstract_card_id);""",
    """CREATE INDEX abs_virtue_map_virtueIndex ON abs_virtue_map (virtue_id);""",
    """CREATE INDEX abs_creed_map_abstractCardIndex ON abs_creed_map (abstract_card_id);""",
    """CREATE INDEX abs_creed_map_creedIndex ON abs_creed_map (creed_id);""",
    """CREATE INDEX abs_artist_map_abstractCardIndex ON abs_artist_map (abstract_card_id);""",
    """CREATE INDEX abs_artist_map_artistIndex ON abs_artist_map (artist_id);""",
    """CREATE INDEX abs_keyword_map_abstractCardIndex ON abs_keyword_map (abstract_card_id);""",
    """CREATE INDEX abs_keyword_map_keywordIndex ON abs_keyword_map (keyword_id);""",
    """CREATE INDEX physical_map_physicalCardIndex ON physical_map (physical_card_id);""",
    """CREATE INDEX physical_map_physicalCardSetIndex ON physical_map (physical_card_set_id);""",
    """CREATE INDEX physical_map_jointIndex ON physical_map (physical_card_id, physical_card_set_id);""",
    """COMMIT;""",
]
# pylint: enable=line-too-long


class DatabaseUpgradeTests(SutekhTest):
    """Class for the database upgrade tests."""
    # pylint: disable=too-many-public-methods
    # unittest.TestCase, so many public methods

    def test_copy_to_new_ac_db(self):
        """Test copying an existing database to a freshly created one using
           copy_to_new_abstract_card_db."""
        # Create some database content

        oMyCollection = PhysicalCardSet(name="My Collection")
        oMyCollection.comment = "test comment"
        oMyCollection.author = "test author"

        oPCS1 = PhysicalCardSet(name="PCS1", parent=oMyCollection)

        oPC = make_card(".44 magnum", "Jyhad")
        # pylint: disable=no-member
        # SQLObject confuses pylint
        oMyCollection.addPhysicalCard(oPC)

        # pylint: enable=no-member

        assert list(PhysicalCardSet.select())

        iPCSCount = PhysicalCardSet.select().count()
        iACCount = AbstractCard.select().count()

        iExpCnt = Expansion.select().count()
        iPrintCnt = Printing.select().count()

        # Attempt upgrade

        oOrigConn = sqlhub.processConnection

        sDbFile = self._create_tmp_file()
        # windows is different, since we don't have a starting / for the path
        # We exclude this because of the platform specific branches
        if sys.platform.startswith("win"):  # pragma: no cover
            oNewConn = connectionForURI("sqlite:///%s" % sDbFile)
        else:
            oNewConn = connectionForURI("sqlite://%s" % sDbFile)
        sqlhub.processConnection = oNewConn

        create_db()

        assert list(AbstractCard.select())

        oCardLookup = SimpleLookup()
        oLogHandler = make_null_handler()

        copy_to_new_abstract_card_db(oOrigConn, oNewConn, oCardLookup,
                                     oLogHandler)

        assert list(AbstractCard.select())
        assert list(PhysicalCardSet.select())

        self.assertEqual(AbstractCard.select().count(), iACCount)
        self.assertEqual(PhysicalCardSet.select().count(), iPCSCount)

        self.assertEqual(Expansion.select().count(), iExpCnt)
        self.assertEqual(Printing.select().count(), iPrintCnt)

        sqlhub.processConnection = oOrigConn
        oDBUpgrade = DBUpgradeManager()
        bResult, _aMsgs = oDBUpgrade.create_final_copy(oNewConn, oLogHandler)

        # Check
        self.assertTrue(bResult)

        assert list(AbstractCard.select())
        assert list(PhysicalCardSet.select())

        self.assertEqual(AbstractCard.select().count(), iACCount)
        self.assertEqual(PhysicalCardSet.select().count(), iPCSCount)

        self.assertEqual(Expansion.select().count(), iExpCnt)
        self.assertEqual(Printing.select().count(), iPrintCnt)

        oMagnum = IAbstractCard('.44 magnum')
        assert oMagnum

        oImmortal = IAbstractCard("Immortal Grapple")
        assert oImmortal

        oKoT = IExpansion("Keepers of Tradition")

        oDefPrint = IPrinting((oKoT, None))
        assert oDefPrint

        assert IPhysicalCard((oImmortal, oDefPrint))

        oNoDraft = IPrinting((oKoT, "No Draft Text"))
        assert oNoDraft

        assert IPhysicalCard((oImmortal, oNoDraft))

        oMyCollection = IPhysicalCardSet("My Collection")
        assert oMyCollection.comment == "test comment"
        assert oMyCollection.author == "test author"
        assert list(oMyCollection.cards)

        oPCS1 = IPhysicalCardSet("PCS1")
        assert oPCS1.parent == oMyCollection

        for sExp in ('Jyhad', 'SW'):
            oExp = IExpansion(sExp)
            oDefPrint = IPrinting((oExp, None))
            assert len(oDefPrint.properties) == 2
            bBack = False
            bDate = False
            for oProp in oDefPrint.properties:
                if oProp.value.startswith('Back Type:'):
                    bBack = True
                    continue
                if oProp.value.startswith('Release Date:'):
                    bDate = True
                    continue
                # We don't expect to trigger this
                # pylint: disable: line-too-long
                # formatting this to fit the line length doesn't improve clarity
                self.fail(f"Unexpected property name {oProp.value}")  # pragma: no cover
            self.assertTrue(bBack)
            self.assertTrue(bDate)

        oNewConn.close()

    def test_upgrade_old_version(self):
        """Test upgrading from 0.8"""
        # We only run this test if using sqlite, since iterdump isn't part
        # of the standard DBAPI
        sDBuri = sqlhub.processConnection.uri()
        if not sDBuri.startswith('sqlite:'):
            self.skipTest("Not running on sqlite database")  # pragma: no cover

        oConn = sqlhub.processConnection

        # Save current state to restore later
        aCurData = list(oConn.getConnection().iterdump())

        # Create the database to upgrade
        sDbFile = self._create_tmp_file()
        # windows is different, since we don't have a starting / for the path
        if sys.platform.startswith("win"): # pragma: no cover
            oOldDB = connectionForURI("sqlite:///%s" % sDbFile)
        else:  # pragma: no cover
            oOldDB = connectionForURI("sqlite://%s" % sDbFile)
        sqlhub.processConnection = oOldDB

        oCursor = oOldDB.getConnection().cursor()
        for sSQL in OLD_VERSION_DUMP:
            oCursor.execute(sSQL)
        oCursor.close()

        # Assert that the versions fail
        oVer = DatabaseVersion(oConn=oOldDB)
        oVer.expire_cache()

        aTables = [VersionTable] + TABLE_LIST
        aVersions = [x.tableversion for x in aTables]

        self.assertFalse(oVer.check_tables_and_versions(aTables, aVersions))
        aLowerTables, aHigherTables = oVer.get_bad_tables(aTables,
                                                          aVersions)

        self.assertEqual(len(aHigherTables), 0)
        self.assertEqual(len(aLowerTables), 10)

        # Run the upgrade code
        oDBManager = DBUpgradeManager()
        oLogBuffer = StringIO()
        oLogHandler = StreamHandler(oLogBuffer)
        bRet = oDBManager.attempt_database_upgrade(oLogHandler)
        self.assertTrue(bRet)

        oLogBuffer.seek(0)
        sLogs = oLogBuffer.read()

        self.assertTrue("information to fill the LookupHints" in sLogs)
        self.assertTrue("information to fill the Printing" in sLogs)
        self.assertTrue("Missing date information" in sLogs)
        self.assertTrue("Everything seems to have gone OK" in sLogs)

        self.assertEqual(Expansion.select().count(), 25)
        self.assertEqual(AbstractCard.select().count(), 72)
        self.assertEqual(PhysicalCard.select().count(), 225)
        self.assertEqual(Printing.select().count(), Expansion.select().count())

        oMagnum = IAbstractCard(".44 Magnum")
        oJyhad = IExpansion("Jyhad")

        assert oMagnum
        assert oJyhad
        assert IPhysicalCard((oMagnum, None))
        oDefJyhad = IPrinting((oJyhad, None))
        assert oDefJyhad
        assert IPhysicalCard((oMagnum, oDefJyhad))

        oOldDB.close()

        # Restore old state
        oVer.expire_cache()
        sqlhub.processConnection = oConn
        oConn.cache.clear()
        aTables.reverse()
        for cCls in aTables:
            cCls.dropTable(ifExists=True, connection=oConn)

        oCursor = oConn.getConnection().cursor()
        for sSQL in aCurData:
            oCursor.execute(sSQL)
        oCursor.close()
        oConn.cache.clear()
        init_cache()

        for sExp in ('Jyhad', 'SW'):
            oExp = IExpansion(sExp)
            oDefPrint = IPrinting((oExp, None))
            assert len(oDefPrint.properties) == 2
            bBack = False
            bDate = False
            for oProp in oDefPrint.properties:
                if oProp.value.startswith('Back Type:'):
                    bBack = True
                    continue
                if oProp.value.startswith('Release Date:'):
                    bDate = True
                    continue
                # We don't expect to trigger this
                # pylint: disable: line-too-long
                # formatting this to fit the line length doesn't improve clarity
                self.fail(f"Unexpected property name {oProp.value}")  # pragma: no cover
            self.assertTrue(bBack)
            self.assertTrue(bDate)
