"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const INI = require("ini");
const __1 = require("..");
const util_1 = require("./util");
test('ini object can be mutated before synthesis', () => {
    const prj = new util_1.TestProject();
    const obj = {
        hello: 'world',
    };
    new __1.IniFile(prj, 'my/ini/file.ini', { obj });
    // mutate obj (should be reflected in the output)
    obj.anotherField = {
        foo: 1234,
    };
    const out = util_1.synthSnapshot(prj);
    expect(INI.parse(out['my/ini/file.ini'])).toMatchObject({
        hello: 'world',
        anotherField: { foo: '1234' },
    });
});
test('ini file can contain projen marker', () => {
    const prj = new util_1.TestProject();
    const obj = {};
    new __1.IniFile(prj, 'my/ini/file-marker.ini', { obj, marker: true });
    const output = util_1.synthSnapshot(prj)['my/ini/file-marker.ini'];
    const firstLine = output.split('\n')[0];
    expect(firstLine).toBe(`# ${__1.IniFile.PROJEN_MARKER}`);
});
//# sourceMappingURL=data:application/json;base64,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