<!--
*** Thanks for checking out the Best-README-Template. If you have a suggestion
*** that would make this better, please fork the repo and create a pull request
*** or simply open an issue with the tag "enhancement".
*** Thanks again! Now go create something AMAZING! :D
***
***
***
*** To avoid retyping too much info. Do a search and replace for the following:
*** github_username, repo_name, twitter_handle, email, project_title, project_description
-->



<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->
[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
[![LinkedIn][linkedin-shield]][linkedin-url]


<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://www.botblox.io/">
    <img src="https://github.com/botblox/botblox-manager-software/blob/main/images/logo.png?raw=true" alt="Logo" width="160" height="160">
  </a>

  <h3 align="center">BotBlox software</h3>

  <p align="center">
    Software created by BotBlox to configure settings on our products
    <br />
    <a href="https://botblox.atlassian.net/wiki/spaces/HARDWARE/overview"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://botblox.atlassian.net/wiki/spaces/HARDWARE/overview">View Demo</a>
    ·
    <a href="https://github.com/botblox/botblox-manager-software/issues">Report Bug</a>
    ·
    <a href="https://github.com/botblox/botblox-manager-software/issues">Request Feature</a>
  </p>
</p>



<!-- TABLE OF CONTENTS -->
<details open="open">
  <summary><h2 style="display: inline-block">Table of Contents</h2></summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#installation">Installation</a>
      <ul>
        <li><a href="#getting-started">Getting Started</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#roadmap">Roadmap</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgements">Acknowledgements</a></li>
  </ol>
</details>


<!-- ABOUT THE PROJECT -->
## About The Project

Welcome to BotBlox Software. We designed this software to go along with our [firmware](https://github.com/botblox/botblox-manager-firmware) to allow our community of customers and developers to manually configure custom settings on BotBlox products, such as the SwitchBlox: our flagship Ethernet switch. For a while now, our customers have requested that they want to be able to program VLAN membership, Quality-of-service, Port mirroring, etc on our products. The software comes as a packaged module that you can use as a CLI application. This can be further extended on request to an application that can be used cleanly with a Python codebase. This application was designed with developers in mind; to make developing features for this application as simple as possible. We very much encourage people to point out improvements, bugs or missing features they want implemented as we want to be very responsive to the needs of both the developer and customer.   


### Built With

* [PySerial](https://github.com/pyserial/pyserial)

<!-- Installation -->
## Installation

You'll need to install Python version 3.6+ in order to use this application.

```sh
  pip install botblox
```

<!-- USAGE EXAMPLES -->
## Usage

Use this space to see useful examples of how this project can be used. Additional screenshots, code examples and demos may be added in this space as necessary. Link to full resouces below.

_For more examples, please refer to the [Documentation](https://botblox.atlassian.net/wiki/spaces/HARDWARE/overview)_


<!-- ROADMAP -->
## Roadmap

See the [open issues](https://github.com/botblox/botblox-manager-software/issues) for a list of proposed features (and known issues).


<!-- CONTRIBUTING -->
## Contributing

Contributions are what make the open source community such an amazing place to be learn, inspire, and create. Any contributions you make are **greatly appreciated**.

1. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
2. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
3. Push to the Branch (`git push origin feature/AmazingFeature`)
4. Open a Pull Request

Please also note the [Developer Guidelines](https://botblox.atlassian.net/wiki/spaces/HARDWARE/overview) that BotBlox kindly asks of all those who are generous enough to devote their time using or developing on this product.


<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE` for more information.

<!-- CONTACT -->
## Contact

Project Link: [https://github.com/botblox/botblox-manager-software](https://github.com/botblox/botblox-manager-software)


<!-- ACKNOWLEDGEMENTS -->
## Acknowledgements
* [Christopher McClellan](https://dev.to/rubberduck/using-usb-with-docker-for-mac-3fdd)
* [Milad Alizadeh](https://mil.ad/docker/2018/05/06/access-usb-devices-in-container-in-mac.html)

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors-anon/botblox/botblox-manager-software?style=for-the-badge
[contributors-url]: https://github.com/botblox/botblox-manager-software/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/botblox/botblox-manager-software?style=for-the-badge
[forks-url]: https://github.com/botblox/botblox-manager-software/network/members
[stars-shield]: https://img.shields.io/github/stars/botblox/botblox-manager-software?style=for-the-badge
[stars-url]: https://github.com/botblox/botblox-manager-software/stargazers
[issues-shield]: https://img.shields.io/github/issues/botblox/botblox-manager-software?style=for-the-badge
[issues-url]: https://github.com/botblox/botblox-manager-software/issues
[license-shield]: https://img.shields.io/github/license/botblox/botblox-manager-software?style=for-the-badge
[license-url]: https://github.com/botblox/botblox-manager-software/blob/main/LICENSE
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://www.linkedin.com/company/botblox/

