# Generated by Django 2.1.7 on 2019-07-03 13:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import fabric2.runners
import minke.utils


class Migration(migrations.Migration):

    dependencies = [
        ('minke', '0003_auto_20190326_1648'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommandResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('command', models.TextField(help_text='The command which was executed.', verbose_name='Command')),
                ('exited', models.SmallIntegerField(help_text='Exit-status returned by the command.', verbose_name='Exit-status')),
                ('stdout', models.TextField(blank=True, help_text='Standard-output of the command.', null=True, verbose_name='Stdout')),
                ('stderr', models.TextField(blank=True, help_text='Standard-error of the command. (unless the process was invoked via a pty, in which case stderr and stdout are merged into stdout)', null=True, verbose_name='Stderr')),
                ('shell', models.CharField(help_text='The shell binary used for execution.', max_length=128, verbose_name='Shell')),
                ('encoding', models.CharField(help_text='The string encoding used by the local shell environment.', max_length=128, verbose_name='Encoding')),
                ('pty', models.BooleanField(help_text='A boolean describing whether the command was invoked with a pty or not', verbose_name='Pty')),
                ('created_time', models.DateTimeField(auto_now_add=True, help_text='The datetime this command-result were added.', verbose_name='Time of creation')),
            ],
            options={
                'verbose_name_plural': 'Command-Results',
                'ordering': ('session_id', 'created_time'),
                'verbose_name': 'Command-Result',
            },
            bases=(fabric2.runners.Result, models.Model),
        ),
        migrations.AlterModelOptions(
            name='basemessage',
            options={'ordering': ('session_id', 'created_time'), 'verbose_name': 'Message', 'verbose_name_plural': 'Messages'},
        ),
        migrations.AlterModelOptions(
            name='host',
            options={'ordering': ['name'], 'verbose_name': 'Host', 'verbose_name_plural': 'Hosts'},
        ),
        migrations.AlterModelOptions(
            name='hostgroup',
            options={'ordering': ['name'], 'verbose_name': 'Host-Group', 'verbose_name_plural': 'Host-Groups'},
        ),
        migrations.AlterModelOptions(
            name='minkesession',
            options={'ordering': ('minkeobj_type_id', 'minkeobj_id', '-created_time'), 'verbose_name': 'Session', 'verbose_name_plural': 'Sessions'},
        ),
        migrations.AddField(
            model_name='basemessage',
            name='created_time',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now, help_text='The datetime this message were added.', verbose_name='Time of creation'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='host',
            name='config',
            field=models.CharField(blank=True, help_text='Use config as specified in MINKE_HOST_CONFIG.', max_length=255, null=True, verbose_name='Fabric-/Invoke-config'),
        ),
        migrations.AddField(
            model_name='host',
            name='port',
            field=models.IntegerField(blank=True, help_text='Port number to connect on the remote host.', null=True, verbose_name='Port number.'),
        ),
        migrations.AddField(
            model_name='hostgroup',
            name='config',
            field=models.CharField(blank=True, help_text='Use config as specified in MINKE_HOST_CONFIG.', max_length=255, null=True, verbose_name='Fabric-/Invoke-config'),
        ),
        migrations.AddField(
            model_name='minkesession',
            name='created_time',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now, help_text='Time the session has been initiated.', verbose_name='Created-time'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='minkesession',
            name='task_id',
            field=models.CharField(blank=True, help_text='ID of the celery-task that run the session.', max_length=128, null=True, verbose_name='Task-ID'),
        ),
        migrations.AlterField(
            model_name='basemessage',
            name='html',
            field=models.TextField(help_text='Message as HTML', verbose_name='HTML'),
        ),
        migrations.AlterField(
            model_name='basemessage',
            name='level',
            field=models.CharField(choices=[('info', 'info'), ('warning', 'warning'), ('error', 'error')], help_text='Level with which the message were added.', max_length=128, verbose_name='Message-level'),
        ),
        migrations.AlterField(
            model_name='basemessage',
            name='session',
            field=models.ForeignKey(help_text='Session the message belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='minke.MinkeSession', verbose_name='Session'),
        ),
        migrations.AlterField(
            model_name='basemessage',
            name='text',
            field=models.TextField(help_text='Message-Text', verbose_name='Text'),
        ),
        migrations.AlterField(
            model_name='host',
            name='comment',
            field=models.TextField(blank=True, help_text='Something about the host.', null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='host',
            name='disabled',
            field=models.BooleanField(default=False, help_text="Disabled hosts won't be accessed by minke.", verbose_name='Disabled'),
        ),
        migrations.AlterField(
            model_name='host',
            name='group',
            field=models.ForeignKey(blank=True, help_text='The group this host belongs to.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='minke.HostGroup', verbose_name='Hostgroup'),
        ),
        migrations.AlterField(
            model_name='host',
            name='hostname',
            field=models.CharField(blank=True, help_text='HostName could be either a ssh-config-lookup-pattern or a real hostname to log into.', max_length=255, null=True, verbose_name='HostName'),
        ),
        migrations.AlterField(
            model_name='host',
            name='lock',
            field=models.CharField(blank=True, help_text="Locked hosts won't be accessed by minke.To prevent intersection a host will be locked while sessions are executed on it.", max_length=20, null=True, verbose_name='Lock'),
        ),
        migrations.AlterField(
            model_name='host',
            name='name',
            field=models.SlugField(help_text="Unique name of the host. If Hostname is not specified fabric's Connection-class will be initialized with this Name instead. Specifying a Name only could be a sufficient Host-setup if there is a valid ssh_config for it as lookup-pattern.", max_length=128, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='host',
            name='username',
            field=models.CharField(blank=True, help_text='User to login as.', max_length=255, null=True, verbose_name='User'),
        ),
        migrations.AlterField(
            model_name='host',
            name='verbose_name',
            field=models.CharField(blank=True, help_text='Verbose Host-Name.', max_length=255, null=True, verbose_name='Verbose Name'),
        ),
        migrations.AlterField(
            model_name='hostgroup',
            name='comment',
            field=models.TextField(blank=True, help_text='Something about the group.', null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='hostgroup',
            name='name',
            field=models.CharField(help_text='Unique group-name.', max_length=255, unique=True, verbose_name='Group-Name'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='end_time',
            field=models.DateTimeField(blank=True, help_text='Time the session finished.', null=True, verbose_name='End-time'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='proc_status',
            field=models.CharField(choices=[('initialized', 'initialized'), ('running', 'running'), ('completed', 'completed'), ('stopping', 'stopping'), ('stopped', 'stopped'), ('canceled', 'canceled'), ('failed', 'failed')], help_text='Status of session-processing.', max_length=128, verbose_name='Process-status'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='run_time',
            field=models.DurationField(blank=True, help_text="Session's runtime.", null=True, verbose_name='Run-time'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='session_data',
            field=minke.utils.JSONField(blank=True, help_text='Data coming from a session-form.', null=True, verbose_name="Session's extra-data"),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='session_description',
            field=models.TextField(blank=True, help_text='Doc-string of the session-class.', max_length=128, null=True, verbose_name="Session's description"),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='session_name',
            field=models.CharField(help_text='Class-name of the session-class.', max_length=128, verbose_name='Session-name'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='session_status',
            field=models.CharField(choices=[('success', 'success'), ('warning', 'warning'), ('error', 'error')], help_text='Mostly set by the session-code itself.', max_length=128, verbose_name='Session-status'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='session_verbose_name',
            field=models.CharField(help_text='Verbose-name-attribute of the session-class.', max_length=128, verbose_name="Session's verbose-name"),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='start_time',
            field=models.DateTimeField(blank=True, help_text='Time the session has been started.', null=True, verbose_name='Start-time'),
        ),
        migrations.AlterField(
            model_name='minkesession',
            name='user',
            field=models.ForeignKey(help_text='User that run this session.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='commandresult',
            name='session',
            field=models.ForeignKey(help_text='Session whereas this command where executed.', on_delete=django.db.models.deletion.CASCADE, related_name='commands', to='minke.MinkeSession', verbose_name='Session'),
        ),
    ]
