# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2019-03-26 16:48
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import minke.messages
import minke.utils


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('minke', '0002_auto_20180619_1703'),
    ]

    operations = [
        migrations.CreateModel(
            name='BaseMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.CharField(choices=[('info', 'info'), ('warning', 'warning'), ('error', 'error')], max_length=128)),
                ('text', models.TextField()),
                ('html', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='HostGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('comment', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MinkeSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_name', models.CharField(max_length=128)),
                ('session_verbose_name', models.CharField(max_length=128)),
                ('session_description', models.TextField(blank=True, null=True)),
                ('session_status', models.CharField(choices=[('success', 'success'), ('warning', 'warning'), ('error', 'error')], max_length=128)),
                ('session_data', minke.utils.JSONField(blank=True, null=True)),
                ('minkeobj_id', models.PositiveIntegerField()),
                ('current', models.BooleanField(default=True)),
                ('proc_status', models.CharField(choices=[('initialized', 'initialized'), ('running', 'running'), ('done', 'done'), ('aborted', 'aborted')], max_length=128)),
                ('start_time', models.DateTimeField(blank=True, null=True)),
                ('end_time', models.DateTimeField(blank=True, null=True)),
                ('run_time', models.DurationField(blank=True, null=True)),
                ('minkeobj_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AlterModelOptions(
            name='host',
            options={'ordering': ['name']},
        ),
        migrations.RenameField(
            model_name='host',
            old_name='host',
            new_name='name',
        ),
        migrations.RemoveField(
            model_name='host',
            name='hoststring',
        ),
        migrations.RemoveField(
            model_name='host',
            name='locked',
        ),
        migrations.RemoveField(
            model_name='host',
            name='port',
        ),
        migrations.RemoveField(
            model_name='host',
            name='user',
        ),
        migrations.AddField(
            model_name='host',
            name='comment',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='host',
            name='lock',
            field=models.CharField(blank=True, max_length=20, null=True),
        ),
        migrations.AddField(
            model_name='host',
            name='username',
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='host',
            name='verbose_name',
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='host',
            name='hostname',
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='basemessage',
            name='session',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='minke.MinkeSession'),
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=(minke.messages.ProxyMixin, 'minke.basemessage'),
        ),
        migrations.AddField(
            model_name='host',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='minke.HostGroup'),
        ),
        migrations.CreateModel(
            name='PreMessage',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('minke.message',),
        ),
        migrations.CreateModel(
            name='ExceptionMessage',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('minke.premessage',),
        ),
        migrations.CreateModel(
            name='ExecutionMessage',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('minke.premessage',),
        ),
        migrations.CreateModel(
            name='TableMessage',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('minke.premessage',),
        ),
    ]
