/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2020 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 9.0.3
 * @date    2020-08-02
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(window,function(){return n={},r.m=i=[function(e,t,i){"use strict";i.r(t),i.d(t,"parse",function(){return g}),i.d(t,"repair",function(){return p}),i.d(t,"escapeUnicodeChars",function(){return m}),i.d(t,"validate",function(){return f}),i.d(t,"extend",function(){return C}),i.d(t,"clear",function(){return v}),i.d(t,"getType",function(){return I}),i.d(t,"isUrl",function(){return b}),i.d(t,"isArray",function(){return y}),i.d(t,"getAbsoluteLeft",function(){return w}),i.d(t,"getAbsoluteTop",function(){return S}),i.d(t,"addClassName",function(){return x}),i.d(t,"removeAllClassNames",function(){return k}),i.d(t,"removeClassName",function(){return E}),i.d(t,"stripFormatting",function(){return R}),i.d(t,"setEndOfContentEditable",function(){return _}),i.d(t,"selectContentEditable",function(){return T}),i.d(t,"getSelection",function(){return $}),i.d(t,"setSelection",function(){return L}),i.d(t,"getSelectionOffset",function(){return B}),i.d(t,"setSelectionOffset",function(){return W}),i.d(t,"getInnerText",function(){return O}),i.d(t,"hasParentNode",function(){return N}),i.d(t,"getInternetExplorerVersion",function(){return G}),i.d(t,"isFirefox",function(){return H}),i.d(t,"addEventListener",function(){return V}),i.d(t,"removeEventListener",function(){return F}),i.d(t,"isChildOf",function(){return Z}),i.d(t,"parsePath",function(){return M}),i.d(t,"stringifyPath",function(){return j}),i.d(t,"improveSchemaError",function(){return D}),i.d(t,"isPromise",function(){return K}),i.d(t,"isValidValidationError",function(){return z}),i.d(t,"insideRect",function(){return X}),i.d(t,"debounce",function(){return J}),i.d(t,"textDiff",function(){return Y}),i.d(t,"getInputSelection",function(){return U}),i.d(t,"getIndexForPosition",function(){return Q}),i.d(t,"getPositionForPath",function(){return q}),i.d(t,"compileJSONPointer",function(){return ee}),i.d(t,"getColorCSS",function(){return te}),i.d(t,"isValidColor",function(){return ie}),i.d(t,"makeFieldTooltip",function(){return ne}),i.d(t,"get",function(){return re}),i.d(t,"findUniqueName",function(){return oe}),i.d(t,"getChildPaths",function(){return se}),i.d(t,"sort",function(){return ae}),i.d(t,"sortObjectKeys",function(){return le}),i.d(t,"parseString",function(){return ce}),i.d(t,"isTimestamp",function(){return he}),i.d(t,"formatSize",function(){return de}),i.d(t,"limitCharacters",function(){return ue}),i.d(t,"isObject",function(){return ge}),i.d(t,"contains",function(){return pe}),i.d(t,"isValidationErrorChanged",function(){return me});i(24);var n=i(11),o=i.n(n),r=i(22),s=i.n(r),a=i(33),l=i.n(a),c=i(1);function h(e){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var d=1e4,u=9466848e5;function g(t){try{return JSON.parse(t)}catch(e){throw f(t),e}}function p(n){var i=[],r=0,e=0,t=!1,o=n.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);o&&(n=o[3]);var s,a={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"},l={None:"null",True:"true",False:"false"};function c(){return n.charAt(r)}function h(){return n.charAt(r+1)}function d(e){return" "===e||"\n"===e||"\r"===e||"\t"===e}function u(){if("/"===c()&&"*"===h()){for(r+=2;r<n.length&&("*"!==c()||"/"!==h());)r++;r+=2,"\n"===c()&&r++}}function g(e){var t="";t+='"',r++;for(var i=c();r<n.length&&i!==e;)'"'===i&&"\\"!==n.charAt(r-1)?t+='\\"':i in a?t+=a[i]:("\\"===i&&(r++,"'"!==(i=c())&&(t+="\\")),t+=i),r++,i=c();return i===e&&(t+='"',r++),t}for(;r<n.length;){u(),function(){if("/"===c()&&"/"===h())for(r+=2;r<n.length&&"\n"!==c();)r++}();var p,m=c();"{"===m&&e++,"}"===m&&e--," "===(s=m)||" "<=s&&s<=" "||" "===s||" "===s||"　"===s?(i.push(" "),r++):"'"===m?i.push(g(m)):'"'===m?i.push(g('"')):"`"===m?i.push(g("´")):"‘"===m?i.push(g("’")):"“"===m?i.push(g("”")):"}"===m?(i.push(m),r++,p=function(){for(var e="";r<n.length&&d(c());)e+=c(),r++;return e}(),u(),"{"===function(){for(var e=r;e<n.length&&d(n[e]);)e++;return n[e]}()&&(i.push(","),0===e&&(t=!0)),i.push(p)):","===m&&-1!==["]","}"].indexOf(function(){for(var e=r+1;e<n.length&&d(n[e]);)e++;return n[e]}())?r++:/[a-zA-Z_$]/.test(m)&&-1!==["{",","].indexOf(function(){for(var e=i.length-1;0<=e;){var t=i[e];if(!d(t))return t;e--}return""}())?i.push(function(){for(var e="",t=c(),i=/[a-zA-Z_$\d]/;i.test(t);)e+=t,r++,t=c();return e in l?l[e]:-1===["null","true","false"].indexOf(e)?'"'+e+'"':e}()):/\w/.test(m)?i.push(function(){for(var e,t=c(),i="";/\w/.test(t);)i+=t,r++,t=c();if(0<i.length&&"("===t){if(r++,'"'===(t=c()))e=g(t),t=c();else for(e="";")"!==t&&""!==t;)e+=t,r++,t=c();return")"===t?(r++,e):i+"("+e+t}return"string"==typeof l[i]?l[i]:i}()):(i.push(m),r++)}return t&&(i.unshift("[\n"),i.push("\n]")),i.join("")}function m(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function f(e){void 0!==s.a?s.a.parse(e):JSON.parse(e)}function C(e,t){for(var i in t)fe(t,i)&&(e[i]=t[i]);return e}function v(e){for(var t in e)fe(e,t)&&delete e[t];return e}function I(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":y(e)?"array":"object"}var A=/^https?:\/\/\S+$/;function b(e){return("string"==typeof e||e instanceof String)&&A.test(e)}function y(e){return"[object Array]"===Object.prototype.toString.call(e)}function w(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function S(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function x(e,t){var i=e.className.split(" ");-1===i.indexOf(t)&&(i.push(t),e.className=i.join(" "))}function k(e){e.className=""}function E(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!==n&&(i.splice(n,1),e.className=i.join(" "))}function R(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var r=t[i];r.style&&r.removeAttribute("style");var o=r.attributes;if(o)for(var s=o.length-1;0<=s;s--){var a=o[s];!0===a.specified&&r.removeAttribute(a.name)}R(r)}}function _(e){var t,i;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t))}function T(e){var t,i;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((i=document.createRange()).selectNodeContents(e),(t=window.getSelection()).removeAllRanges(),t.addRange(i))}function $(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function L(e){var t;e&&window.getSelection&&((t=window.getSelection()).removeAllRanges(),t.addRange(e))}function B(){var e=$();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function W(e){var t;document.createRange&&window.getSelection&&window.getSelection()&&(t=document.createRange(),e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),L(t))}function O(e,t){if(void 0===t&&(t={_text:"",flush:function(){var e=this._text;return this._text="",e},set:function(e){this._text=e}}),e.nodeValue){var i=e.nodeValue.replace(/\s*\n\s*/g,"");return""!==i?t.flush()+i:""}if(e.hasChildNodes()){for(var n=e.childNodes,r="",o=0,s=n.length;o<s;o++){var a,l,c=n[o];"DIV"===c.nodeName||"P"===c.nodeName?((l=(a=n[o-1])?a.nodeName:void 0)&&"DIV"!==l&&"P"!==l&&"BR"!==l&&(""!==r&&(r+="\n"),t.flush()),r+=O(c,t),t.set("\n")):"BR"===c.nodeName?(r+=t.flush(),t.set("\n")):r+=O(c,t)}return r}return""}function N(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1}function G(){var e,t;return-1===P&&(e=-1,"undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&(t=navigator.userAgent,null!=new RegExp("MSIE ([0-9]+[.0-9]+)").exec(t)&&(e=parseFloat(RegExp.$1))),P=e),P}function H(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}var P=-1;function V(e,t,i,n){if(e.addEventListener)return void 0===n&&(n=!1),"mousewheel"===t&&H()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i;if(e.attachEvent){var r=function(){return i.call(e,window.event)};return e.attachEvent("on"+t,r),r}}function F(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&H()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)}function Z(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1}function M(i){var e=[],n=0;function t(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(function(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var r=i[n];if(n++,e.push(t(r)),i[n]!==r)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{var o=t("]").trim();if(0===o.length)throw new Error("Invalid JSON path: array value expected at index "+n);o="*"===o?o:JSON.parse(o),e.push(o)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e}function j(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function D(e){var t,i;return"enum"!==e.keyword||!Array.isArray(e.schema)||(i=e.schema)&&(5<(i=i.map(function(e){return JSON.stringify(e)})).length&&(t=["("+(i.length-5)+" more...)"],(i=i.slice(0,5)).push(t)),e.message="should be equal to one of: "+i.join(", ")),"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function K(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function z(e){return"object"===h(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function X(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom}function J(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}}function Y(e,t){for(var i=t.length,n=0,r=e.length,o=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(o-1)===e.charAt(r-1)&&n<o&&0<r;)o--,r--;return{start:n,end:o}}function U(i){var e,t,n,r,o,s=0,a=0;return"number"==typeof i.selectionStart&&"number"==typeof i.selectionEnd?(s=i.selectionStart,a=i.selectionEnd):(t=document.selection.createRange())&&t.parentElement()===i&&(r=i.value.length,e=i.value.replace(/\r\n/g,"\n"),(n=i.createTextRange()).moveToBookmark(t.getBookmark()),(o=i.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",o)?s=a=r:(s=-n.moveStart("character",-r),s+=e.slice(0,s).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",o)?a=r:(a=-n.moveEnd("character",-r),a+=e.slice(0,a).split("\n").length-1))),{startIndex:s,endIndex:a,start:l(s),end:l(a)};function l(e){var t=i.value.substring(0,e);return{row:(t.match(/\n/g)||[]).length+1,column:t.length-t.lastIndexOf("\n")}}}function Q(e,t,i){var n=e.value||"";if(0<t&&0<i){var r=n.split("\n",t);t=Math.min(r.length,t),i=Math.min(r[t-1].length,i-1);var o=1===t?i:i+1;return r.slice(0,t-1).join("\n").length+o}return-1}function q(e,t){var n,r=[];if(!t||!t.length)return r;try{n=l.a.parse(e)}catch(e){return r}return t.forEach(function(e){var t=ee(M(e)),i=n.pointers[t];i&&r.push({path:e,line:i.key?i.key.line:i.value?i.value.line:0,column:i.key?i.key.column:i.value?i.value.column:0})}),r}function ee(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function te(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function ie(e){return!!te(e)}function ne(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("default",void 0,e)+"\n",n+=JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=Object(c.c)("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n}function re(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i}function oe(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,r=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<r?" "+r:""))+")";r++}return n}function se(e,t){var i={};if(Array.isArray(e))for(var n=Math.min(e.length,d),r=0;r<n;r++){!function t(i,n,r,o){(Array.isArray(i)||ge(i))&&!o||(n[r||""]=!0),ge(i)&&Object.keys(i).forEach(function(e){t(i[e],n,r+"."+e,o)})}(e[r],i,"",t)}else i[""]=!0;return Object.keys(i).sort()}function ae(e,t,i){var r=t&&"."!==t?M(t):[],o="desc"===i?-1:1,n=e.slice();return n.sort(function(e,t){var i=re(e,r),n=re(t,r);return o*(n<i?1:i<n?-1:0)}),n}function le(t,e){var i="desc"===e?-1:1,n=Object.keys(t).sort(function(e,t){return i*o()(e,t)}),r={};return n.forEach(function(e){r[e]=t[e]}),r}function ce(e){if(""===e)return"";var t=e.toLowerCase();if("null"===t)return null;if("true"===t)return!0;if("false"===t)return!1;var i=Number(e),n=parseFloat(e);return isNaN(i)||isNaN(n)?e:i}function he(e,t){return"number"==typeof t&&u<t&&isFinite(t)&&Math.floor(t)===t&&!isNaN(new Date(t).valueOf())}function de(e){if(e<900)return e.toFixed()+" B";var t=e/1e3;if(t<900)return t.toFixed(1)+" KB";var i=t/1e3;if(i<900)return i.toFixed(1)+" MB";var n=i/1e3;return n<900?n.toFixed(1)+" GB":(n/1e3).toFixed(1)+" TB"}function ue(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function ge(e){return"object"===h(e)&&null!==e&&!Array.isArray(e)}function pe(e,t){return-1!==e.indexOf(t)}function me(i,e){if(!e&&!i)return!1;if(e&&!i||!e&&i)return!0;if(e.length!==i.length)return!0;for(var t=0;t<i.length;++t){var n=function(t){if(!("error"===i[t].type?e.find(function(e){return e.line===i[t].line}):e.find(function(e){return e.dataPath===i[t].dataPath&&e.schemaPath===i[t].schemaPath})))return{v:!0}}(t);if("object"===h(n))return n.v}return!1}function fe(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},function(e,t,i){"use strict";i.d(t,"a",function(){return l}),i.d(t,"b",function(){return c}),i.d(t,"c",function(){return h});i(24);var n=["en","pt-BR","zh-CN","tr","ja","fr-FR"],o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+\\)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+\\)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+\\)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+\\)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+\\)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut"}},s="en",r="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=n.find(function(e){return e===r})||s;function l(t){var e;t&&((e=n.find(function(e){return e===t}))?a=e:console.error("Language not found"))}function c(e){if(e){for(var t in e)!function(t){n.find(function(e){return e===t})||n.push(t),o[t]=Object.assign({},o[s],o[t],e[t])}(t)}}function h(e,t,i){var n=o[i=i||a][e]||o[s][e]||e;if(t)for(var r in t)n=n.replace("${"+r+"}",t[r]);return n}},function(e,t,i){"use strict";i.d(t,"a",function(){return n}),i.d(t,"d",function(){return r}),i.d(t,"b",function(){return o}),i.d(t,"c",function(){return s});var n=document.body,r=10485760,o=2e4,s=2147483648},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var u=i(12),g=i(0),A=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function d(i,e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,d),this.dom={};var I=this,t=this.dom;this.anchor=void 0,this.items=i,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0;var n=document.createElement("div");n.className="jsoneditor-contextmenu-root",t.root=n;var r=document.createElement("div");r.className="jsoneditor-contextmenu",t.menu=r,n.appendChild(r);var o=document.createElement("ul");o.className="jsoneditor-menu",r.appendChild(o),t.list=o,t.items=[];var s=document.createElement("button");s.type="button",t.focusButton=s;var a=document.createElement("li");a.style.overflow="hidden",a.style.height="0",a.appendChild(s),o.appendChild(a),function f(C,v,e){e.forEach(function(t){var e,i,n,r,o,s,a,l,c,h,d,u,g,p,m;"separator"===t.type?((e=document.createElement("div")).className="jsoneditor-separator",(i=document.createElement("li")).appendChild(e),C.appendChild(i)):(n={},r=document.createElement("li"),C.appendChild(r),(o=document.createElement("button")).type="button",o.className=t.className,n.button=o,t.title&&(o.title=t.title),t.click&&(o.onclick=function(e){e.preventDefault(),I.hide(),t.click()}),r.appendChild(o),t.submenu?((s=document.createElement("div")).className="jsoneditor-icon",o.appendChild(s),(a=document.createElement("div")).className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),a.appendChild(document.createTextNode(t.text)),o.appendChild(a),(l=t.click?(o.className+=" jsoneditor-default",(c=document.createElement("button")).type="button",(n.buttonExpand=c).className="jsoneditor-expand",(h=document.createElement("div")).className="jsoneditor-expand",c.appendChild(h),r.appendChild(c),t.submenuTitle&&(c.title=t.submenuTitle),c):((d=document.createElement("div")).className="jsoneditor-expand",o.appendChild(d),o)).onclick=function(e){e.preventDefault(),I._onExpandItem(n),l.focus()},u=[],n.subItems=u,g=document.createElement("ul"),(n.ul=g).className="jsoneditor-menu",g.style.height="0",r.appendChild(g),f(g,u,t.submenu)):((p=document.createElement("div")).className="jsoneditor-icon",o.appendChild(p),(m=document.createElement("div")).className="jsoneditor-text",m.appendChild(document.createTextNode(Object(A.c)(t.text))),o.appendChild(m)),v.push(n))})}(o,this.dom.items,i),this.maxHeight=0,i.forEach(function(e){var t=24*(i.length+(e.submenu?e.submenu.length:0));I.maxHeight=Math.max(I.maxHeight,t)})}var e,t,i;return e=d,(t=[{key:"_getVisibleButtons",value:function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,i){this.hide();var n=!0,r=e.parentNode,o=e.getBoundingClientRect(),s=r.getBoundingClientRect(),a=t.getBoundingClientRect(),l=this;this.dom.absoluteAnchor=Object(u.a)(e,t,function(){l.hide()}),o.bottom+this.maxHeight<a.bottom||o.top-this.maxHeight>a.top&&(n=!1);var c,h=i?0:o.top-s.top;n?(c=e.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=h+c+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=Object(g.getSelection)(),this.anchor=e,setTimeout(function(){l.dom.focusButton.focus()},0),d.visibleMenu&&d.visibleMenu.hide(),d.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),d.visibleMenu===this&&(d.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(i){var n,r=this,e=i===this.expandedItem,t=this.expandedItem;t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){r.expandedItem!==t&&(t.ul.style.display="",Object(g.removeClassName)(t.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),e||((n=i.ul).style.display="block",n.clientHeight,setTimeout(function(){if(r.expandedItem===i){for(var e=0,t=0;t<n.childNodes.length;t++)e+=n.childNodes[t].clientHeight;n.style.height=e+"px",n.style.padding="5px 10px"}},0),Object(g.addClassName)(n.parentNode,"jsoneditor-selected"),this.expandedItem=i)}},{key:"_onKeyDown",value:function(e){var t,i,n,r,o=e.target,s=e.which,a=!1;27===s?(this.selection&&Object(g.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(i=(t=this._getVisibleButtons()).indexOf(o))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(o))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===o.className&&(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&n.focus()),a=!0):38===s?(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&"jsoneditor-expand"===n.className&&(n=t[i-2]),(n=n||t[t.length-1])&&n.focus(),a=!0):39===s?(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"===r.className&&r.focus(),a=!0):40===s&&(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"===r.className&&(r=t[i+2]),(r=r||t[0])&&(r.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}])&&n(e.prototype,t),i&&n(e,i),d}();r.visibleMenu=void 0},function(e,t,i){"use strict";i.d(t,"a",function(){return o}),i.d(t,"b",function(){return s});var n=i(34),r=i.n(n),l=i(0);function o(e,t){var i,n,r=t.sort,o=t.filter,s=t.projection,a="";return o?(i="@"!==o.field?["0"].concat(Object(l.parsePath)("."+o.field)):["0"],n="string"==typeof Object(l.get)(e,i)?o.value:Object(l.parseString)(o.value),a+="[? "+o.field+" "+o.relation+" `"+JSON.stringify(n)+"`]"):a+=Array.isArray(e)?"[*]":"@",r&&("desc"===r.direction?a+=" | reverse(sort_by(@, &"+r.field+"))":a+=" | sort_by(@, &"+r.field+")"),s&&("]"!==a[a.length-1]&&(a+=" | [*]"),1===s.fields.length?a+="."+s.fields[0]:1<s.fields.length&&(a+=".{"+s.fields.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")),a}function s(e,t){return r.a.search(e,t)}},function(e,t,i){"use strict";i.r(t),i.d(t,"showSortModal",function(){return s});var n=i(14),r=i.n(n),o=i(1),h=i(0);function s(e,t,s,i){var a=Array.isArray(t)?Object(h.getChildPaths)(t):[""],l=i&&i.path&&Object(h.contains)(a,i.path)?i.path:a[0],c=i&&i.direction||"asc",n='<div class="pico-modal-contents"><div class="pico-modal-header">'+Object(o.c)("sort")+"</div><form><table><tbody><tr>  <td>"+Object(o.c)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+Object(o.c)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+Object(o.c)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+Object(o.c)("sortAscending")+'" title="'+Object(o.c)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+Object(o.c)("sortDescending")+'" title="'+Object(o.c)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(o.c)("ok")+'" /></td></tr></tbody></table></form></div>';r()({parent:e,content:n,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),i=t.modalElem().querySelector("#ok"),n=t.modalElem().querySelector("#field"),r=t.modalElem().querySelector("#direction");function o(e){r.value=e,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}a.forEach(function(e){var t,i=document.createElement("option");i.text=""===(t=e)?"@":"."===t[0]?t.slice(1):t,i.value=e,n.appendChild(i)}),n.value=l||a[0],o(c||"asc"),r.onclick=function(e){o(e.target.getAttribute("data-value"))},i.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:n.value,direction:r.value})},e&&(e.onsubmit=i.onclick)}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";i.r(t),i.d(t,"showTransformModal",function(){return c});var n=i(14),o=i.n(n),r=i(10),R=i.n(r),s=i(1);function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function _(e,t,i,n){return"boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date?JSON.stringify(e):Array.isArray(e)?function(e,t,i,n){for(var r=t?i+t:void 0,o=t?"[\n":"[",s=0;s<e.length;s++){var a=e[s];if(t&&(o+=r),o+=void 0!==a&&"function"!=typeof a?_(a,t,r,n):"null",s<e.length-1&&(o+=t?",\n":","),o.length>n)return o+"..."}return o+=t?"\n"+i+"]":"]"}(e,t,i,n):e&&"object"===a(e)?function(e,t,i,n){var r=t?i+t:void 0,o=!0,s=t?"{\n":"{";if("function"==typeof e.toJSON)return _(e.toJSON(),t,i,n);for(var a in e)if(function(e,t){return Object.prototype.hasOwnProperty.call(e,t)}(e,a)){var l=e[a];if(o?o=!1:s+=t?",\n":",",s+=t?r+'"'+a+'": ':'"'+a+'":',(s+=_(l,t,r,n)).length>n)return s+"..."}return s+=t?"\n"+i+"}":"}"}(e,t,i,n):void 0}function T(e,t){for(var i="";0<t--;)i+=e;return i}var $=i(0),L=i(2),l='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function c(e){var t=e.container,w=e.json,i=e.queryDescription,n=void 0===i?l:i,S=e.createQuery,x=e.executeQuery,k=e.onTransform,E=w,r='<label class="pico-modal-contents"><div class="pico-modal-header">'+Object(s.c)("transform")+"</div><p>"+n+'</p><div class="jsoneditor-jmespath-label">'+Object(s.c)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+Object(s.c)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+Object(s.c)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+Object(s.c)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+Object(s.c)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+Object(s.c)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+Object(s.c)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+Object(s.c)("ok")+'" autofocus /></div></div>';o()({parent:t,content:r,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),i=e.querySelector("#wizard"),n=e.querySelector("#ok"),r=e.querySelector("#filterField"),o=e.querySelector("#filterRelation"),s=e.querySelector("#filterValue"),a=e.querySelector("#sortField"),l=e.querySelector("#sortOrder"),c=e.querySelector("#selectFields"),h=e.querySelector("#query"),d=e.querySelector("#preview");Array.isArray(E)||(i.style.fontStyle="italic",i.textContent="(wizard not available for objects, only for arrays)"),Object($.getChildPaths)(w).forEach(function(e){var t=I(e),i=document.createElement("option");i.text=t,i.value=t,r.appendChild(i);var n=document.createElement("option");n.text=t,n.value=t,a.appendChild(n)});var u,g=Object($.getChildPaths)(w,!0).filter(function(e){return""!==e});0<g.length?g.forEach(function(e){var t=I(e),i=document.createElement("option");i.text=t,i.value=t,c.appendChild(i)}):(u=e.querySelector("#selectFieldsPart"))&&(u.style.display="none");var p=new R.a(r,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new R.a(o,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),f=new R.a(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),C=new R.a(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),v=new R.a(c,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function I(e){return""===e?"@":"."===e[0]?e.slice(1):e}p.on("selectr.change",y),m.on("selectr.change",y),s.oninput=y,f.on("selectr.change",y),C.on("selectr.change",y),v.on("selectr.change",y),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()};var A=Object($.debounce)(function(){try{var e=x(E,h.value);d.className="jsoneditor-transform-preview",d.value=function(e,t,i){var n;"number"==typeof t?10<t?n=T(" ",10):1<=t&&(n=T(" ",t)):"string"==typeof t&&""!==t&&(n=t);var r,o,s=_(e,n,"",i);return s.length>i?(r=s,("number"==typeof(o=i)?r.slice(0,o):r)+"..."):s}(e,2,L.b),n.disabled=!1}catch(e){d.className="jsoneditor-transform-preview jsoneditor-error",d.value=e.toString(),n.disabled=!0}},300);function b(e,t){try{h.value=S(e,t),n.disabled=!1,A()}catch(e){var i='Error: an error happened when executing "createQuery": '+(e.message||e.toString());h.value="",n.disabled=!0,d.className="jsoneditor-transform-preview jsoneditor-error",d.value=i}}function y(){var e={};if(r.value&&o.value&&s.value&&(e.filter={field:r.value,relation:o.value,value:s.value}),a.value&&l.value&&(e.sort={field:a.value,direction:l.value}),c.value){for(var t,i=[],n=0;n<c.options.length;n++){c.options[n].selected&&(t=c.options[n].value,i.push(t))}e.projection={fields:i}}b(w,e)}h.oninput=A,n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),k(h.value)},b(w,{}),setTimeout(function(){h.select(),h.focus(),h.selectionStart=3,h.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";function s(e,t,i,n){var r=n?" !== ":" === ",o=n?" || ":" && ",s=n?"!":"",a=n?"":"!";switch(e){case"null":return t+r+"null";case"array":return s+"Array.isArray("+t+")";case"object":return"("+s+t+o+"typeof "+t+r+'"object"'+o+a+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+r+'"number"'+o+a+"("+t+" % 1)"+o+t+r+t+(i?o+s+"isFinite("+t+")":"")+")";case"number":return"(typeof "+t+r+'"'+e+'"'+(i?o+s+"isFinite("+t+")":"")+")";default:return"typeof "+t+r+'"'+e+'"'}}e.exports={copy:function(e,t){for(var i in t=t||{},e)t[i]=e[i];return t},checkDataType:s,checkDataTypes:function(e,t,i){switch(e.length){case 1:return s(e[0],t,i,!0);default:var n="",r=a(e);for(var o in r.array&&r.object&&(n=r.null?"(":"(!"+t+" || ",n+="typeof "+t+' !== "object")',delete r.null,delete r.array,delete r.object),r.number&&delete r.integer,r)n+=(n?" && ":"")+s(o,t,i,!0);return n}},coerceToTypes:function(e,t){if(Array.isArray(t)){for(var i=[],n=0;n<t.length;n++){var r=t[n];(o[r]||"array"===e&&"array"===r)&&(i[i.length]=r)}if(i.length)return i}else{if(o[t])return[t];if("array"===e&&"array"===t)return["array"]}},toHash:a,getProperty:d,escapeQuotes:l,equal:i(18),ucs2length:i(47),varOccurences:function(e,t){t+="[^0-9]";var i=e.match(new RegExp(t,"g"));return i?i.length:0},varReplace:function(e,t,i){return t+="([^0-9])",i=i.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),i+"$1")},schemaHasRules:function(e,t){if("boolean"==typeof e)return!e;for(var i in e)if(t[i])return!0},schemaHasRulesExcept:function(e,t,i){if("boolean"==typeof e)return!e&&"not"!=i;for(var n in e)if(n!=i&&t[n])return!0},schemaUnknownRules:function(e,t){if("boolean"==typeof e)return;for(var i in e)if(!t[i])return i},toQuotedString:c,getPathExpr:function(e,t,i,n){return h(e,i?"'/' + "+t+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function(e,t,i){var n=c(i?"/"+p(t):d(t));return h(e,n)},getData:function(e,t,i){var n,r,o,s;if(""===e)return"rootData";if("/"==e[0]){if(!u.test(e))throw new Error("Invalid JSON-pointer: "+e);r=e,o="rootData"}else{if(!(s=e.match(g)))throw new Error("Invalid JSON-pointer: "+e);if(n=+s[1],"#"==(r=s[2])){if(t<=n)throw new Error("Cannot access property/index "+n+" levels up, current level is "+t);return i[t-n]}if(t<n)throw new Error("Cannot access data "+n+" levels up, current level is "+t);if(o="data"+(t-n||""),!r)return o}for(var a=o,l=r.split("/"),c=0;c<l.length;c++){var h=l[c];h&&(o+=d(m(h)),a+=" && "+o)}return a},unescapeFragment:function(e){return m(decodeURIComponent(e))},unescapeJsonPointer:m,escapeFragment:function(e){return encodeURIComponent(p(e))},escapeJsonPointer:p};var o=a(["string","number","integer","boolean","null"]);function a(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=!0;return t}var n=/^[a-z$_][a-z$_0-9]*$/i,r=/'|\\/g;function d(e){return"number"==typeof e?"["+e+"]":n.test(e)?"."+e:"['"+l(e)+"']"}function l(e){return e.replace(r,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function c(e){return"'"+l(e)+"'"}var u=/^\/(?:[^~]|~0|~1)*$/,g=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function h(e,t){return'""'==e?t:(e+" + "+t).replace(/([^\\])' \+ '/g,"$1")}function p(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function m(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},function(e,t,i){"use strict";i.d(t,"a",function(){return r});var p=i(3),m=i(1);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function g(e,t,i,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,g);for(var r={code:{text:Object(m.c)("modeCodeText"),title:Object(m.c)("modeCodeTitle"),click:function(){n("code")}},form:{text:Object(m.c)("modeFormText"),title:Object(m.c)("modeFormTitle"),click:function(){n("form")}},text:{text:Object(m.c)("modeTextText"),title:Object(m.c)("modeTextTitle"),click:function(){n("text")}},tree:{text:Object(m.c)("modeTreeText"),title:Object(m.c)("modeTreeTitle"),click:function(){n("tree")}},view:{text:Object(m.c)("modeViewText"),title:Object(m.c)("modeViewTitle"),click:function(){n("view")}},preview:{text:Object(m.c)("modePreviewText"),title:Object(m.c)("modePreviewTitle"),click:function(){n("preview")}}},o=[],s=0;s<t.length;s++){var a=t[s],l=r[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(i===a?" jsoneditor-selected":""),o.push(l)}var c=r[i];if(!c)throw new Error('Unknown mode "'+i+'"');var h=c.text,d=document.createElement("button");d.type="button",d.className="jsoneditor-modes jsoneditor-separator",d.textContent=h+" ▾",d.title=Object(m.c)("modeEditorTitle"),d.onclick=function(){new p.a(o).show(d,e)};var u=document.createElement("div");u.className="jsoneditor-modes",u.style.position="relative",u.appendChild(d),e.appendChild(u),this.dom={container:e,box:d,frame:u}}var e,t,i;return e=g,(t=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&n(e.prototype,t),i&&n(e,i),g}()},function(e,t,i){"use strict";function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,"a",function(){return n});var n=function(){function t(e){if(!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),this.target=e.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"==typeof e.onFocus?e.onFocus:null,this.onBlur="function"==typeof e.onBlur?e.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=function(e){9!==e.which&&9!==e.keyCode||this._onEvent(e)}.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp))}var e,i,n;return e=t,(i=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(e){var t=e.target,i=t===this.target||!(!this.target.contains(t)&&!this.target.contains(document.activeElement));i?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag&&(this.firstEventFlag=!1))}}])&&r(e.prototype,i),n&&r(e,n),t}()},function(e,t,i){"use strict";function n(){}var r={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."};n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e};var l={extend:function(e,t){var i;for(i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var r=0,o=e.length;r<o;r++)t.call(i,r,e[r],e)},createElement:function(e,t){var i,n,r=document,o=r.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t){i in o?o[i]=t[i]:"html"===i?o.textContent=t[i]:"text"===i?(n=r.createTextNode(t[i]),o.appendChild(n)):o.setAttribute(i,t[i])}return o},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){l.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){l.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:l.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),r=t?i.pageXOffset:0,o=t?i.pageYOffset:0;return{bottom:n.bottom+o,height:n.height,left:n.left+r,right:n.right+r,top:n.top+o,width:n.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function c(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function a(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),l.removeClass(e,"excluded"),i||(e.textContent=e.textContent+"")}function h(){var i,e;this.items.length&&(i=document.createDocumentFragment(),this.config.pagination?(e=this.pages.slice(0,this.pageIndex),l.each(e,function(e,t){l.each(t,function(e,t){a(t,i,this.customOption)},this)},this)):l.each(this.items,function(e,t){a(t,i,this.customOption)},this),i.childElementCount&&(l.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,l.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i))}function d(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=l.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,l.addClass(n,"disabled")),n}function o(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&l.removeClass(this.inputContainer,"active"),l.hasClass(this.container,"notice")&&(l.removeClass(this.container,"notice"),l.addClass(this.container,"open"),this.input.focus()),l.each(this.items,function(e,t){l.removeClass(t,"excluded"),this.customOption||(t.textContent=t.textContent+"")},this))}function s(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}var u=function(){var i,e=this.tree,t=e.scrollTop;e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length&&(i=document.createDocumentFragment(),l.each(this.pages[this.pageIndex],function(e,t){a(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))};s.prototype.render=function(e){var t;this.rendered||(this.config=l.extend(r,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=c(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,c(this.config,"width")&&(l.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":l.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=l.createElement("div",{class:"selectr-container"}),this.config.customClass&&l.addClass(this.container,this.config.customClass),this.mobileDevice?l.addClass(this.container,"selectr-mobile"):l.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,
this.config.nativeDropdown||this.mobileDevice?l.addClass(this.el,"selectr-visible"):l.addClass(this.el,"selectr-hidden"),this.selected=l.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=l.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e,t=l.createElement("div",{class:"selectr-options-container"});this.tree=l.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=l.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(l.addClass(this.label,"selectr-tags"),l.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=l.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),l.addClass(this.container,"clearable")),this.config.taggable&&(e=l.createElement("li",{class:"input-tag"}),this.input=l.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),e.appendChild(this.input),this.label.appendChild(e),l.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))),this.config.searchable&&(this.input=l.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=l.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=l.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),t.appendChild(this.inputContainer)),t.appendChild(this.notice),t.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var i,n,r,o=!1,s=0;this.el.children.length&&l.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(o=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),l.each(t.children,function(e,t){t.idx=s,o.appendChild(d.call(this,t,o)),s++},this)):(t.idx=s,d.call(this,t),s++)},this),this.config.data&&Array.isArray(this.config.data)&&(i=!(this.data=[]),o=!1,s=0,l.each(this.config.data,function(e,t){c(t,"children")?(i=l.createElement("optgroup",{label:t.text}),o=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),l.each(t.children,function(e,t){(n=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(n),i.appendChild(n),n.idx=s,o.appendChild(d.call(this,n,t)),this.data[s]=t,s++},this)):((n=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(n),n.idx=s,d.call(this,n,t),this.data[s]=t,s++)},this)),this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(r=this.items[a],!l.hasClass(r,"disabled")){l.addClass(r,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(t),this.placeEl=l.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=l.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),t=this,setTimeout(function(){t.emit("selectr.init")},20))},s.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},s.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},s.prototype.bindEvents=function(){var n=this;this.events={},this.events.dismiss=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!l.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&l.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;l.hasClass(this.items[this.navIndex],"disabled")||l.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=l.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&u.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&l.removeClass(i,"active"),l.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()}),this.el.addEventListener("change",function(e){var t,i;n.el.multiple?(t=n.getSelectedProperties("idx"),i=function(e,t){for(var i,n=[],r=e.slice(0),o=0;o<t.length;o++)-1<(i=r.indexOf(t[o]))?r.splice(i,1):n.push(t[o]);return[n,r]}(n.selectedIndexes,t),l.each(i[0],function(e,t){n.select(t)},n),l.each(i[1],function(e,t){n.deselect(t)},n)):-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){l.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();var t=l.closest(e.target,function(e){return e&&l.hasClass(e,"selectr-option")});t&&(l.hasClass(t,"disabled")||(l.hasClass(t,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(t.idx):n.select(t.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){l.hasClass(e.target,"selectr-option")&&(l.hasClass(e.target,"disabled")||(l.removeClass(n.items[n.navIndex],"active"),l.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?l.addClass(this.parentNode,"active"):l.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,o.call(n),n.tree.childElementCount||h.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){var i;n.search(),n.config.taggable&&this.value.length&&(i=this.value.trim(),13!==e.which&&!l.includes(n.tagSeperators,e.key)||(l.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),o.call(n)):(this.value="",n.setMessage("That tag is already in use."))))}),this.update=l.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=l.debounce(function(){u.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},s.prototype.setSelected=function(e){var i;this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),l.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0),i=0,l.each(this.config.data,function(e,t){c(t,"children")?l.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this))},s.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.textContent=""),l.removeClass(this.el,"selectr-hidden"),this.el.form&&l.off(this.el.form,"reset",this.events.reset),l.off(document,"click",this.events.dismiss),l.off(document,"keydown",this.events.navigate),l.off(window,"resize",this.update),l.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},s.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&l.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},s.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(l.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var t,c,h=this,i=document.createDocumentFragment(),n=this.options[e.idx],r=this.data?this.data[e.idx]:n,o=this.customSelected?this.config.renderSelection(r):n.textContent,s=l.createElement("li",{class:"selectr-tag",html:o}),a=l.createElement("button",{class:"selectr-tag-remove",type:"button"});s.appendChild(a),s.idx=e.idx,s.tag=n.value,this.tags.push(s),this.config.sortSelected?(t=this.tags.slice(),c=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},t.sort(function(e,t){var i,n,r=[],o=[];for(!0===h.config.sortSelected?(i=e.tag,n=t.tag):"text"===h.config.sortSelected&&(i=e.textContent,n=t.textContent),c(i,r),c(n,o);r.length&&o.length;){var s=r.shift(),a=o.shift(),l=s[0]-a[0]||s[1].localeCompare(a[1]);if(l)return l}return r.length-o.length}),l.each(t,function(e,t){i.appendChild(t)}),this.label.textContent=""):i.appendChild(s),this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var r=this.data?this.data[n]:i;this.label.textContent=this.customSelected?this.config.renderSelection(r):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,l.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&l.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}l.includes(t,i)||this.el.add(i),e.setAttribute("aria-selected",!0),l.addClass(e,"selected"),l.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},s.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var r=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(r,1);var o=this.selectedValues.indexOf(n.value);this.selectedValues.splice(o,1),function(i){var n=!1;l.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||l.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.textContent="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,l.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),l.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},s.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;l.each(this.options,function(e,t){(n&&l.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},s.prototype.getValue=function(e,t){var i,n;return this.el.multiple?e?this.selectedIndexes.length&&(n={values:[]},l.each(this.selectedIndexes,function(e,t){var i=this.options[t];n.values[e]={value:i.value,text:i.textContent}},this)):n=this.selectedValues.slice():n=e?{value:(i=this.options[this.selectedIndex]).value,text:i.textContent}:this.selectedValue,e&&t&&(n=JSON.stringify(n)),n},s.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))l.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var r=!1;if(l.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(r=!0)}),r)return!1}var e=l.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,d.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},s.prototype.remove=function(i){var n,r=[];Array.isArray(i)?l.each(i,function(e,t){l.isInt(t)?r.push(this.getOptionByIndex(t)):"string"==typeof i&&r.push(this.getOptionByValue(t))},this):l.isInt(i)?r.push(this.getOptionByIndex(i)):"string"==typeof i&&r.push(this.getOptionByValue(i)),r.length&&(l.each(r,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);var i=this.items[n].parentNode;i&&i.removeChild(this.items[n]),this.items.splice(n,1),l.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},s.prototype.removeAll=function(){this.clear(!0),l.each(this.el.options,function(e,t){this.el.remove(t)},this),l.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},s.prototype.search=function(o){var s,e,t;this.navigating||(o=o||this.input.value,s=document.createDocumentFragment(),this.removeMessage(),l.truncate(this.tree),1<o.length?(l.each(this.options,function(e,t){var i,n,r=this.items[t.idx];l.includes(t.textContent.toLowerCase(),o.toLowerCase())&&!t.disabled?(a(r,s,this.customOption),l.removeClass(r,"excluded"),this.customOption||(r.textContent="",(i=function(e,t){var i=new RegExp(e,"i").exec(t);if(i){var n=i.index,r=i.index+i[0].length;return{before:t.substring(0,n),match:t.substring(n,r),after:t.substring(r)}}return null}(o,t.textContent))&&(r.appendChild(document.createTextNode(i.before)),(n=document.createElement("span")).className="selectr-match",n.appendChild(document.createTextNode(i.match)),r.appendChild(n),r.appendChild(document.createTextNode(i.after))))):l.addClass(r,"excluded")},this),s.childElementCount?(e=this.items[this.navIndex],t=s.firstElementChild,l.removeClass(e,"active"),this.navIndex=t.idx,l.addClass(t,"active")):this.config.taggable||this.setMessage("no results.")):h.call(this),this.tree.appendChild(s))},s.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},s.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(l.addClass(this.container,"native-open"),void(this.config.data&&l.each(this.options,function(e,t){this.el.add(t)},this))):(l.addClass(this.container,"open"),h.call(this),this.invert(),this.tree.scrollTop=0,l.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},s.prototype.close=function(){var e;this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown?l.removeClass(this.container,"native-open"):(e=l.hasClass(this.container,"notice"),this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(l.removeClass(this.container,"notice"),this.notice.textContent=""),l.removeClass(this.container,"open"),l.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),l.truncate(this.tree),o.call(this))},s.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),l.removeClass(this.container,"selectr-disabled")},s.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,l.addClass(this.container,"selectr-disabled")},s.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),l.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},s.prototype.clear=function(e){var t;this.el.multiple?this.selectedIndexes.length&&(t=this.selectedIndexes.slice(),l.each(t,function(e,t){this.deselect(t)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,e),this.emit("selectr.clear")},s.prototype.serialise=function(e){var n=[];return l.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},s.prototype.serialize=function(e){return this.serialise(e)},s.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.textContent=e},s.prototype.paginate=function(){if(this.items.length){var i=this;return this.pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages}},s.prototype.setMessage=function(e,t){t&&this.close(),l.addClass(this.container,"notice"),this.notice.textContent=e},s.prototype.removeMessage=function(){l.removeClass(this.container,"notice"),this.notice.textContent=""},s.prototype.invert=function(){var e=l.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(l.addClass(this.container,"inverted"),this.isInverted=!0):(l.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=l.rect(this.tree)},s.prototype.getOptionByIndex=function(e){return this.options[e]},s.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=s},function(e,t){e.exports=function t(e,i){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var r,o,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,h=/^0/,d=n(e).replace(a,"")||"",u=n(i).replace(a,"")||"",g=d.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=u.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(d.match(c),16)||1!==g.length&&d.match(l)&&Date.parse(d),f=parseInt(u.match(c),16)||m&&u.match(l)&&Date.parse(u)||null;if(f){if(m<f)return-1;if(f<m)return 1}for(var C=0,v=Math.max(g.length,p.length);C<v;C++){if(r=!(g[C]||"").match(h)&&parseFloat(g[C])||g[C]||0,o=!(p[C]||"").match(h)&&parseFloat(p[C])||p[C]||0,isNaN(r)!==isNaN(o))return isNaN(r)?1:-1;if(typeof r!=typeof o&&(r+="",o+=""),r<o)return-1;if(o<r)return 1}return 0}},function(e,t,i){"use strict";i.d(t,"a",function(){return n});var g=i(0);function n(r,e,o){var t,i,n=3<arguments.length&&void 0!==arguments[3]&&arguments[3],s="function"==typeof(t=r).getRootNode?t.getRootNode():window,a={},l=r.getBoundingClientRect(),c=e.getBoundingClientRect(),h=document.createElement("div");function d(){if(h&&h.parentNode){for(var e in h.parentNode.removeChild(h),a){var t;i=a,n=e,Object.prototype.hasOwnProperty.call(i,n)&&((t=a[e])&&Object(g.removeEventListener)(s,e,t),delete a[e])}"function"==typeof o&&o(r)}var i,n}function u(e){var t;(t=e.target)===h||Object(g.isChildOf)(t,h)||d()}return h.className="jsoneditor-anchor",h.style.position="absolute",h.style.left=l.left-c.left+"px",h.style.top=l.top-c.top+"px",h.style.width=l.width-2+"px",h.style.height=l.height-2+"px",h.style.boxSizing="border-box",e.appendChild(h),a.mousedown=Object(g.addEventListener)(s,"mousedown",u),a.mousewheel=Object(g.addEventListener)(s,"mousewheel",u),n&&(i=null,h.onmouseover=function(){clearTimeout(i),i=null},h.onmouseout=function(){i=i||setTimeout(d,200)}),h.destroy=d,h}},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(41)}catch(e){}e.exports=n},function(e,t,i){var n,r,o;!function(){"use strict";r=[],void 0===(o="function"==typeof(n=function(){"use strict";function k(e){if(typeof Node==="object"){return e instanceof Node}else{return e&&typeof e==="object"&&typeof e.nodeType==="number"}}function e(e){return"string"==typeof e}function E(){var o=[];return{watch:o.push.bind(o),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var r=0;r<o.length;r++){o[r](e,n)}return i}}}function R(e){return window.getComputedStyle(e).display==="none"}function _(e){this.elem=e}function t(e,t){return _.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}_.make=function(e,t){if(typeof e==="string"){e=document.querySelector(e)}var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new _(i)},_.prototype={child:function(e){return _.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined"){e.filter="alpha(opacity="+e.opacity*100+")"}for(var t in e){if(e.hasOwnProperty(t)){this.elem.style[t]=e[t]}}return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(k(e)){this.elem.appendChild(e)}else{this.elem.innerHTML=e}return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined){this.elem.setAttribute(e,t)}return this},anyAncestor:function(e){var t=this.elem;while(t){if(e(new _(t))){return true}else{t=t.parentNode}}return false},isVisible:function(){return!R(this.elem)}};var T=1;function i(e,t){var i=e("width","auto");if("number"==typeof i)i+="px";var n=e("modalId","pico-"+T++);return _.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new _(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function n(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function $(e){return function(){return e().elem}}var L=E(),B=E();function r(e,t){function w(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function S(e){return!(R(e)||w(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||w(e,"input,select,textarea,button,a[href],area[href],iframe"))}function x(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(S(t[i]))return t[i]}function o(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(S(t[i]))return t[i]}var e;h.beforeShow(function(){e=document.activeElement}),h.afterShow(function(){var e;!d()||(e=x(h.modalElem()))&&e.focus()}),h.afterClose(function(){d()&&e&&e.focus(),e=null}),B.watch(function(e){var t,i;d()&&h.isVisible()&&(t=x(h.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(S(t[i]))return t[i]}(h.modalElem()),(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault()))})}function o(e,t){var p,m=new _(document.body);u.beforeShow(function(){p=m.elem.style.overflow,g()&&m.stylize({overflow:"hidden"})}),u.afterClose(function(){m.stylize({overflow:p})})}return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?L.trigger():9===t&&B.trigger(e)}),function(n){"string"!=typeof n&&!k(n)||(n={content:n});var o=E(),t=E(),i=E(),r=E(),s=E();function a(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}var l,c,h,d,e,u,g,p,m,f=y.bind(window,"modal"),C=y.bind(window,"overlay"),v=y.bind(window,"close");function I(e){C().hide(),f().hide(),s.trigger(l,e)}function A(e){r.trigger(l,e)&&I(e)}function b(e){return function(){return e.apply(this,arguments),l}}function y(e,t){var i,n,r;return c||(i=function(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+T++);return _.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new _(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}(a,A),c={modal:i,overlay:(r=A,_.make((n=a)("parent")).clazz("pico-overlay").clazz(n("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(n("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){n("overlayClose",!0)&&r()})),close:function(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}(i,a)},o.trigger(l,t)),c[e]}function w(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function S(e){return!(R(e)||w(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||w(e,"input,select,textarea,button,a[href],area[href],iframe"))}function x(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(S(t[i]))return t[i]}return l={modalElem:$(f),closeElem:$(v),overlayElem:$(C),buildDom:b(y.bind(null,null)),isVisible:function(){return!!(c&&f&&f().isVisible())},show:function(e){return t.trigger(l,e)&&(C().show(),v(),f().show(),i.trigger(l,e)),this},close:b(A),forceClose:b(I),destroy:function(){f().destroy(),C().destroy(),C=f=v=void 0},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:b(o.watch),beforeShow:b(t.watch),afterShow:b(i.watch),beforeClose:b(r.watch),afterClose:b(s.watch)},h=l,d=a.bind(null,"focus",!0),h.beforeShow(function(){e=document.activeElement}),h.afterShow(function(){var e;!d()||(e=x(h.modalElem()))&&e.focus()}),h.afterClose(function(){d()&&e&&e.focus(),e=null}),B.watch(function(e){var t,i;d()&&h.isVisible()&&(t=x(h.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(S(t[i]))return t[i]}(h.modalElem()),(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault()))}),u=l,g=a.bind(null,"bodyOverflow",!0),m=new _(document.body),u.beforeShow(function(){p=m.elem.style.overflow,g()&&m.stylize({overflow:"hidden"})}),u.afterClose(function(){m.stylize({overflow:p})}),L.watch(function(){a("escCloses",!0)&&l.isVisible()&&l.close()}),l}})?n.apply(t,r):n)||(e.exports=o)}()},function(e,t,i){"use strict";function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,"a",function(){return r});var r=function(){function o(e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,o),this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var t=document.createElement("div");t.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=t;var i=document.createElement("div");i.style.display="none",i.className="jsoneditor-additional-errors fadein",i.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=i,t.appendChild(i);var n=document.createElement("span");n.className="jsoneditor-validation-error-icon",n.style.display="none",this.dom.validationErrorIcon=n;var r=document.createElement("span");r.className="jsoneditor-validation-error-count",r.style.display="none",this.dom.validationErrorCount=r,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var e,t,i;return e=o,(t=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,u){var t,i,g,n,p=this;this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length?((t=document.createElement("div")).className="jsoneditor-validation-errors",(i=document.createElement("table")).className="jsoneditor-text-errors",t.appendChild(i),g=document.createElement("tbody"),i.appendChild(g),e.forEach(function(t){var e,i;isNaN(t.line)?!t.dataPath||(i=u.find(function(e){return e.path===t.dataPath}))&&(e=i.line+1):e=t.line;var n=document.createElement("tr");n.className=isNaN(e)?"":"jump-to-line","error"===t.type?n.className+=" parse-error":n.className+=" validation-error";var r=document.createElement("td"),o=document.createElement("button");o.className="jsoneditor-schema-error",r.appendChild(o),n.appendChild(r);var s,a,l,c,h,d=document.createElement("td");d.style="white-space: nowrap;",d.textContent=isNaN(e)?"":"Ln "+e,n.appendChild(d),"string"==typeof t?((s=document.createElement("td")).colSpan=2,(a=document.createElement("pre")).appendChild(document.createTextNode(t)),s.appendChild(a),n.appendChild(s)):((l=document.createElement("td")).appendChild(document.createTextNode(t.dataPath||"")),n.appendChild(l),c=document.createElement("td"),(h=document.createElement("pre")).appendChild(document.createTextNode(t.message)),c.appendChild(h),n.appendChild(c)),n.onclick=function(){p.onFocusLine(e)},g.appendChild(n)}),this.dom.validationErrors=t,this.dom.validationErrorsContainer.appendChild(t),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){p.dom.additionalErrorsIndication.style.display=0<p.dom.validationErrorsContainer.clientHeight&&0===p.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,n=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(n)):this.onChangeHeight(0);var r,o=e.filter(function(e){return"error"!==e.type}).length;0<o?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=o,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=o+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})?(r=e[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(r)?"parse error - check that the json is valid":"parse error on line "+r,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&n(e.prototype,t),i&&n(e,i),o}()},function(e,t){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children||(e.children=[]),Object.defineProperty(e,"loaded",{enumerable:!0,get:function(){return e.l}}),Object.defineProperty(e,"id",{enumerable:!0,get:function(){return e.i}}),e.webpackPolyfill=1),e}},function(e,t,i){"use strict";var m=i(46),f=i(18),C=i(7),l=i(25),n=i(48);function c(e,t,i){var n=this._refs[i];if("string"==typeof n){if(!this._refs[n])return c.call(this,e,t,n);n=this._refs[n]}if((n=n||this._schemas[i])instanceof l)return u(n.schema,this._opts.inlineRefs)?n.schema:n.validate||this._compile(n);var r,o,s,a=h.call(this,t,i);return a&&(r=a.schema,t=a.root,s=a.baseId),r instanceof l?o=r.validate||e.call(this,r.schema,t,void 0,s):void 0!==r&&(o=u(r,this._opts.inlineRefs)?r:e.call(this,r,t,void 0,s)),o}function h(e,t){var i=m.parse(t),n=g(i),r=v(this._getId(e.schema));if(0===Object.keys(e.schema).length||n!==r){var o=I(n),s=this._refs[o];if("string"==typeof s)return function(e,t,i){var n=h.call(this,e,t);if(n){var r=n.schema,o=n.baseId;e=n.root;var s=this._getId(r);return s&&(o=p(o,s)),a.call(this,i,o,r,e)}}.call(this,e,s,i);if(s instanceof l)s.validate||this._compile(s),e=s;else{if(!((s=this._schemas[o])instanceof l))return;if(s.validate||this._compile(s),o==I(t))return{schema:s,root:e,baseId:r};e=s}if(!e.schema)return;r=v(this._getId(e.schema))}return a.call(this,i,r,e.schema,e)}(e.exports=c).normalizeId=I,c.fullPath=v,c.url=p,c.ids=function(e){var t=I(this._getId(e)),d={"":t},u={"":v(t,!1)},g={},p=this;return n(e,{allKeys:!0},function(e,t,i,n,r,o,s){if(""!==t){var a=p._getId(e),l=d[n],c=u[n]+"/"+r;if(void 0!==s&&(c+="/"+("number"==typeof s?s:C.escapeFragment(s))),"string"==typeof a){a=l=I(l?m.resolve(l,a):a);var h=p._refs[a];if("string"==typeof h&&(h=p._refs[h]),h&&h.schema){if(!f(e,h.schema))throw new Error('id "'+a+'" resolves to more than one schema')}else if(a!=I(c))if("#"==a[0]){if(g[a]&&!f(e,g[a]))throw new Error('id "'+a+'" resolves to more than one schema');g[a]=e}else p._refs[a]=c}d[t]=l,u[t]=c}}),g},c.inlineRef=u,c.schema=h;var d=C.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function a(e,t,i,n){if(e.fragment=e.fragment||"","/"==e.fragment.slice(0,1)){for(var r=e.fragment.split("/"),o=1;o<r.length;o++){var s,a,l,c=r[o];if(c){if(void 0===(i=i[c=C.unescapeFragment(c)]))break;d[c]||((l=this._getId(i))&&(t=p(t,l)),i.$ref&&(s=p(t,i.$ref),(a=h.call(this,n,s))&&(i=a.schema,n=a.root,t=a.baseId)))}}return void 0!==i&&i!==n.schema?{schema:i,root:n,baseId:t}:void 0}}var s=C.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function u(e,t){return!1!==t&&(void 0===t||!0===t?function e(t){var i;if(Array.isArray(t)){for(var n=0;n<t.length;n++)if("object"==typeof(i=t[n])&&!e(i))return!1}else for(var r in t){if("$ref"==r)return!1;if("object"==typeof(i=t[r])&&!e(i))return!1}return!0}(e):t?function e(t){var i,n=0;if(Array.isArray(t)){for(var r=0;r<t.length;r++)if("object"==typeof(i=t[r])&&(n+=e(i)),n==1/0)return 1/0}else for(var o in t){if("$ref"==o)return 1/0;if(s[o])n++;else if("object"==typeof(i=t[o])&&(n+=e(i)+1),n==1/0)return 1/0}return n}(e)<=t:void 0)}function v(e,t){return!1!==t&&(e=I(e)),g(m.parse(e))}function g(e){return m.serialize(e).split("#")[0]+"#"}var r=/#\/?$/;function I(e){return e?e.replace(r,""):""}function p(e,t){return t=I(t),m.resolve(e,t)}},function(e,t,i){"use strict";e.exports=function e(t,i){if(t===i)return!0;if(t&&i&&"object"==typeof t&&"object"==typeof i){if(t.constructor!==i.constructor)return!1;var n,r,o;if(Array.isArray(t)){if((n=t.length)!=i.length)return!1;for(r=n;0!=r--;)if(!e(t[r],i[r]))return!1;return!0}if(t.constructor===RegExp)return t.source===i.source&&t.flags===i.flags;if(t.valueOf!==Object.prototype.valueOf)return t.valueOf()===i.valueOf();if(t.toString!==Object.prototype.toString)return t.toString()===i.toString();if((n=(o=Object.keys(t)).length)!==Object.keys(i).length)return!1;for(r=n;0!=r--;)if(!Object.prototype.hasOwnProperty.call(i,o[r]))return!1;for(r=n;0!=r--;){var s=o[r];if(!e(t[s],i[s]))return!1}return!0}return t!=t&&i!=i}},function(e,t,i){"use strict";var n=i(17);function r(e,t,i){this.message=i||r.message(e,t),this.missingRef=n.url(e,t),this.missingSchema=n.normalizeId(n.fullPath(this.missingRef))}function o(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e}e.exports={Validation:o(function(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}),MissingRef:o(r)},r.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(37),i(38),i(39);var r=i(40);n.config.setModuleUrl("ace/mode/json_worker",r)}catch(e){}e.exports=n},function(e,t,i){"use strict";i.r(t),i.d(t,"textModeMixins",function(){return c});var n=i(20),k=i.n(n),E=i(1),R=i(8),_=i(15),T=i(0);var o=i(5),a=i(6),$=i(9),l=i(2),L=i(35),B=i(4);function W(e){return(W="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var r={},O="ace/theme/jsoneditor";function s(){try{this.format()}catch(e){}}r.create=function(e){var t=this,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===i.statusBar&&(i.statusBar=!0),i.mainMenuBar=!1!==i.mainMenuBar,i.enableSort=!1!==i.enableSort,i.enableTransform=!1!==i.enableTransform,i.createQuery=i.createQuery||B.a,i.executeQuery=i.executeQuery||B.b,"number"==typeof(this.options=i).indentation?this.indentation=Number(i.indentation):this.indentation=2,Object(E.b)(this.options.languages),Object(E.a)(this.options.language);var n=i.ace?i.ace:k.a;this.mode="code"===i.mode?"code":"text","code"===this.mode&&void 0===n&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=i.theme||O,this.theme===O&&n&&Object(L.tryRequireThemeJsonEditor)(),i.onTextSelectionChange&&this.onTextSelectionChange(i.onTextSelectionChange);var r=this;this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=Object(T.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){r._onKeyDown(e)};var o,s,a,l,c,h,d,u,g={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new $.a(g),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&(Object(T.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(o=document.createElement("button")).type="button",o.className="jsoneditor-format",o.title=Object(E.c)("formatTitle"),this.menu.appendChild(o),o.onclick=function(){try{r.format(),r._onChange()}catch(e){r._onError(e)}},(s=document.createElement("button")).type="button",s.className="jsoneditor-compact",s.title=Object(E.c)("compactTitle"),this.menu.appendChild(s),s.onclick=function(){try{r.compact(),r._onChange()}catch(e){r._onError(e)}},this.options.enableSort&&((a=document.createElement("button")).type="button",a.className="jsoneditor-sort",a.title=Object(E.c)("sortTitleShort"),a.onclick=function(){r._showSortModal()},this.menu.appendChild(a)),this.options.enableTransform&&((l=document.createElement("button")).type="button",l.title=Object(E.c)("transformTitleShort"),l.className="jsoneditor-transform",l.onclick=function(){r._showTransformModal()},this.menu.appendChild(l)),(c=document.createElement("button")).type="button",c.className="jsoneditor-repair",c.title=Object(E.c)("repairTitle"),this.menu.appendChild(c),c.onclick=function(){try{r.repair(),r._onChange()}catch(e){r._onError(e)}},"code"===this.mode&&((h=document.createElement("button")).type="button",h.className="jsoneditor-undo jsoneditor-separator",h.title=Object(E.c)("undo"),h.onclick=function(){t.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(h),this.dom.undo=h,(d=document.createElement("button")).type="button",d.className="jsoneditor-redo",d.title=Object(E.c)("redo"),d.onclick=function(){t.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(d),this.dom.redo=d),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new R.a(this.menu,this.options.modes,this.options.mode,function(e){r.setMode(e),r.modeSwitcher.focus()})),"code"===this.mode&&((u=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),u.href="https://ace.c9.io/",u.target="_blank",u.className="jsoneditor-poweredBy",u.onclick=function(){window.open(u.href,u.target)},this.menu.appendChild(u)));var p,m,f,C,v,I,A,b,y,w,S,x=this.options.onEditable&&W("function"===this.options.onEditable)&&!this.options.onEditable({});this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),m=(p=n.edit(this.editorDom)).getSession(),p.$blockScrolling=1/0,p.setTheme(this.theme),p.setOptions({readOnly:x}),p.setShowPrintMargin(!1),p.setFontSize("13px"),m.setMode("ace/mode/json"),m.setTabSize(this.indentation),m.setUseSoftTabs(!0),m.setUseWrapMode(!0),f=m.setAnnotations,m.setAnnotations=function(e){f.call(this,e&&e.length?e:r.annotations)},p.commands.bindKey("Ctrl-L",null),p.commands.bindKey("Command-L",null),(this.aceEditor=p).on("change",this._onChange.bind(this)),p.on("changeSelection",this._onSelect.bind(this))):((C=document.createElement("textarea")).className="jsoneditor-text",C.spellcheck=!1,this.content.appendChild(C),this.textarea=C,this.textarea.readOnly=x,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),C.onselect=this._onSelect.bind(this),C.onmousedown=this._onMouseDown.bind(this),C.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),this.errorTable=new _.a({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){r.validate()},onFocusLine:function(e){r.isFocused=!0,isNaN(e)||r.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){var t=e+(r.dom.statusBar?r.dom.statusBar.clientHeight:0)+1;r.content.style.marginBottom=-t+"px",r.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),i.statusBar&&(Object(T.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},v=document.createElement("div"),(this.dom.statusBar=v).className="jsoneditor-statusbar",this.frame.appendChild(v),(I=document.createElement("span")).className="jsoneditor-curserinfo-label",I.innerText="Ln:",(A=document.createElement("span")).className="jsoneditor-curserinfo-val",A.innerText="1",v.appendChild(I),v.appendChild(A),(b=document.createElement("span")).className="jsoneditor-curserinfo-label",b.innerText="Col:",(y=document.createElement("span")).className="jsoneditor-curserinfo-val",y.innerText="1",v.appendChild(b),v.appendChild(y),this.curserInfoElements.colVal=y,this.curserInfoElements.lnVal=A,(w=document.createElement("span")).className="jsoneditor-curserinfo-label",w.innerText="characters selected",w.style.display="none",(S=document.createElement("span")).className="jsoneditor-curserinfo-count",S.innerText="0",S.style.display="none",this.curserInfoElements.countLabel=w,this.curserInfoElements.countVal=S,v.appendChild(S),v.appendChild(w),v.appendChild(this.errorTable.getErrorCounter()),v.appendChild(this.errorTable.getWarningIcon()),v.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},r._onChange=function(){var e=this;if(!this.onChangeDisabled){if(setTimeout(function(){return e._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},r._updateHistoryButtons=function(){var e;this.aceEditor&&this.dom.undo&&this.dom.redo&&((e=this.aceEditor.getSession().getUndoManager())&&e.hasUndo&&e.hasRedo&&(this.dom.undo.disabled=!e.hasUndo(),this.dom.redo.disabled=!e.hasRedo()))},r._showSortModal=function(){var n=this,e=this.options.modalAnchor||l.a,r=this.get();Object(o.showSortModal)(e,r,function(e){var t,i;Array.isArray(r)&&(t=Object(T.sort)(r,e.path,e.direction),n.sortedBy=e,n.update(t)),Object(T.isObject)(r)&&(i=Object(T.sortObjectKeys)(r,e.direction),n.sortedBy=e,n.update(i))},n.sortedBy)},r._showTransformModal=function(){var i=this,e=this.options,t=e.modalAnchor,n=e.createQuery,r=e.executeQuery,o=e.queryDescription,s=this.get();Object(a.showTransformModal)({anchor:t||l.a,json:s,queryDescription:o,createQuery:n,executeQuery:r,onTransform:function(e){var t=r(s,e);i.update(t)}})},r._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},r._onKeyDown=function(e){var t=!1;220===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},r._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},r._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},r._updateCursorInfo=function(){var e,t,i,n,r,o=this;function s(){o.curserInfoElements.countVal.innerText!==r&&(o.curserInfoElements.countVal.innerText=r,o.curserInfoElements.countVal.style.display=r?"inline":"none",o.curserInfoElements.countLabel.style.display=r?"inline":"none"),o.curserInfoElements.lnVal.innerText=i,o.curserInfoElements.colVal.innerText=n}this.textarea?setTimeout(function(){var e=Object(T.getInputSelection)(o.textarea);e.startIndex!==e.endIndex&&(r=e.endIndex-e.startIndex),n=r&&o.cursorInfo&&o.cursorInfo.line===e.end.row&&o.cursorInfo.column===e.end.column?(i=e.start.row,e.start.column):(i=e.end.row,e.end.column),o.cursorInfo={line:i,column:n,count:r},o.options.statusBar&&s()},0):this.aceEditor&&this.curserInfoElements&&(e=this.aceEditor.getCursorPosition(),t=this.aceEditor.getSelectedText(),i=e.row+1,n=e.column+1,r=t.length,o.cursorInfo={line:i,column:n,count:r},this.options.statusBar&&s())},r._emitSelectionChange=function(){var e;this._selectionChangedHandler&&(e=this.getTextSelection(),this._selectionChangedHandler(e.start,e.end,e.text))},r._refreshAnnotations=function(){var e,t=this.aceEditor&&this.aceEditor.getSession();t&&(e=t.getAnnotations().filter(function(e){return"error"===e.type}),t.setAnnotations(e))},r.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},r.compact=function(){var e=this.get(),t=JSON.stringify(e);this.updateText(t)},r.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.updateText(t)},r.repair=function(){var e=this.getText(),t=Object(T.repair)(e);this.updateText(t)},r.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},r.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},r.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},r.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},r.get=function(){var e=this.getText();return Object(T.parse)(e)},r.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},r._setText=function(e,t){var i,n=this,r=!0===this.options.escapeUnicode?Object(T.escapeUnicodeChars)(e):e;this.textarea&&(this.textarea.value=r),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(r,-1),this.onChangeDisabled=!1,t&&(i=this,setTimeout(function(){i.aceEditor&&i.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){return n._updateHistoryButtons()})),this._debouncedValidate()},r.setText=function(e){this._setText(e,!0)},r.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},r.validate=function(){var t,i,n=this,r=[],o=[];try{var e=this.get();this.validateSchema&&(this.validateSchema(e)||(r=this.validateSchema.errors.map(function(e){return e.type="validation",Object(T.improveSchemaError)(e)}))),this.validationSequence=(this.validationSequence||0)+1;var s=this,a=this.validationSequence;(function(e,t){if(!t)return Promise.resolve([]);try{var i=t(e);return(Object(T.isPromise)(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(T.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:Object(T.stringifyPath)(e.path),message:e.message,type:"customValidation"}}):[]})}catch(e){return Promise.reject(e)}})(e,this.options.onValidate).then(function(e){var t;a===s.validationSequence&&(t=r.concat(o).concat(e),s._renderErrors(t),"function"==typeof n.options.onValidationError&&(Object(T.isValidationErrorChanged)(t,n.lastSchemaErrors)&&n.options.onValidationError.call(n,t),n.lastSchemaErrors=t))}).catch(function(e){console.error("Custom validation function did throw an error",e)})}catch(e){this.getText()&&((t=/\w*line\s*(\d+)\w*/g.exec(e.message))&&(i=+t[1]),o=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:i}]),this._renderErrors(o),"function"==typeof this.options.onValidationError&&(Object(T.isValidationErrorChanged)(o,this.lastSchemaErrors)&&this.options.onValidationError.call(this,o),this.lastSchemaErrors=o)}},r._renderErrors=function(n){var e=this.getText(),t=[];n.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t);var i=Object(T.getPositionForPath)(e,t);this.aceEditor&&(this.annotations=i.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(n,i),this.aceEditor&&this.aceEditor.resize(!1)},r.getTextSelection=function(){var e={};if(this.textarea){var t=Object(T.getInputSelection)(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),r=i.getRange(),o=i.getSelectionLead();return o.row===r.end.row&&o.column===r.end.column?e=r:(e.start=r.end,e.end=r.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},r.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(T.debounce)(e,this.DEBOUNCE_INTERVAL))},r.setTextSelection=function(e,t){var i,n,r,o,s,a,l;e&&t&&(this.textarea?(i=Object(T.getIndexForPosition)(this.textarea,e.row,e.column),n=Object(T.getIndexForPosition)(this.textarea,t.row,t.column),-1<i&&-1<n&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(i,n)):this.textarea.createTextRange&&((r=this.textarea.createTextRange()).collapse(!0),r.moveEnd("character",n),r.moveStart("character",i),r.select()),o=(this.textarea.value.match(/\n/g)||[]).length+1,s=this.textarea.scrollHeight/o,a=e.row*s,this.textarea.scrollTop=a>this.textarea.clientHeight?a-this.textarea.clientHeight/2:0)):this.aceEditor&&(l={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}},this.aceEditor.selection.setRange(l),this.aceEditor.scrollToLine(e.row-1,!0)))};var c=[{mode:"text",mixin:r,data:"text",load:s},{mode:"code",mixin:r,data:"text",load:s}]},function(e,t,i){var n,r=((n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,r,o){var s=o.length-1;switch(r){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=o[s-1];case 13:this.$={};break;case 14:this.$=o[s-1];break;case 15:this.$=[o[s-2],o[s]];break;case 16:this.$={},this.$[o[s][0]]=o[s][1];break;case 17:this.$=o[s-2],o[s-2][o[s][0]]=o[s][1];break;case 18:this.$=[];break;case 19:this.$=o[s-1];break;case 20:this.$=[o[s]];break;case 21:this.$=o[s-2],o[s-2].push(o[s])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e){throw new Error(e)},parse:function(e){var t=this,i=[0],n=[null],r=[],o=this.table,s="",a=0,l=0,c=0;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var h=this.lexer.yylloc;function d(){var e=t.lexer.lex()||1;return"number"!=typeof e&&(e=t.symbols_[e]||e),e}r.push(h),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,g,p,m,f,C,v,I,A,b,y={};;){if(p=i[i.length-1],void 0===(m=this.defaultActions[p]?this.defaultActions[p]:(null==u&&(u=d()),o[p]&&o[p][u]))||!m.length||!m[0]){if(!c){for(C in A=[],o[p])this.terminals_[C]&&2<C&&A.push("'"+this.terminals_[C]+"'");var w="",w=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+A.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'");this.parseError(w,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:h,expected:A})}if(3==c){if(1==u)throw new Error(w||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,u=d()}for(;!(2..toString()in o[p]);){if(0==p)throw new Error(w||"Parsing halted.");b=1,i.length=i.length-2*b,n.length=n.length-b,r.length=r.length-b,p=i[i.length-1]}g=u,u=2,m=o[p=i[i.length-1]]&&o[p][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+p+", token: "+u);switch(m[0]){case 1:i.push(u),n.push(this.lexer.yytext),r.push(this.lexer.yylloc),i.push(m[1]),u=null,g?(u=g,g=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,0<c&&c--);break;case 2:if(v=this.productions_[m[1]][1],y.$=n[n.length-v],y._$={first_line:r[r.length-(v||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(v||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(f=this.performAction.call(y,s,l,a,this.yy,m[1],n,r)))return f;v&&(i=i.slice(0,-1*v*2),n=n.slice(0,-1*v),r=r.slice(0,-1*v)),i.push(this.productions_[m[1]][0]),n.push(y.$),r.push(y._$),I=o[i[i.length-2]][i[i.length-1]],i.push(I);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;var e,t,i,n,r;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var o=this._currentRules(),s=0;s<o.length&&(!(i=this._input.match(this.rules[o[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?((r=t[0].match(/\n.*/g))&&(this.yylineno+=r.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:r?r[r.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){
return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}},n);t.parser=r,t.parse=r.parse.bind(r)},function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t){function i(e){"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&(void 0!==window.Element&&i(window.Element.prototype),void 0!==window.CharacterData&&i(window.CharacterData.prototype),void 0!==window.DocumentType&&i(window.DocumentType.prototype)),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return t}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){var t=this.findIndex(e);return this[t]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},function(e,t,i){"use strict";var n=i(7);e.exports=function(e){n.copy(e,this)}},function(e,t,i){"use strict";e.exports=function(e,t){"function"==typeof(t=t||{})&&(t={cmp:t});var o,l="boolean"==typeof t.cycles&&t.cycles,c=t.cmp&&(o=t.cmp,function(r){return function(e,t){var i={key:e,value:r[e]},n={key:t,value:r[t]};return o(i,n)}}),h=[];return function e(t){if(t&&t.toJSON&&"function"==typeof t.toJSON&&(t=t.toJSON()),void 0!==t){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);if(Array.isArray(t)){for(r="[",o=0;o<t.length;o++)o&&(r+=","),r+=e(t[o])||"null";return r+"]"}if(null===t)return"null";if(-1!==h.indexOf(t)){if(l)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var i=h.push(t)-1,n=Object.keys(t).sort(c&&c(t)),r="",o=0;o<n.length;o++){var s=n[o],a=e(t[s]);a&&(r&&(r+=","),r+=JSON.stringify(s)+":"+a)}return h.splice(i,1),"{"+r+"}"}}(e)}},function(e,t,i){"use strict";e.exports=function(n,e){var t="",i=!0===n.schema.$async,r=n.util.schemaHasRulesExcept(n.schema,n.RULES.all,"$ref"),o=n.self._getId(n.schema);if(n.opts.strictKeywords){var s=n.util.schemaUnknownRules(n.schema,n.RULES.keywords);if(s){var a="unknown keyword: "+s;if("log"!==n.opts.strictKeywords)throw new Error(a);n.logger.warn(a)}}if(n.isTop&&(t+=" var validate = ",i&&(n.async=!0,t+="async "),t+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",o&&(n.opts.sourceCode||n.opts.processCode)&&(t+=" /*# sourceURL="+o+" */ ")),"boolean"==typeof n.schema||!r&&!n.schema.$ref){var e="false schema",l=n.level,c=n.dataLevel,h=n.schema[e],d=n.schemaPath+n.util.getProperty(e),u=n.errSchemaPath+"/"+e,g=!n.opts.allErrors,p="data"+(c||""),m="valid"+l;return!1===n.schema?(n.isTop?g=!0:t+=" var "+m+" = false; ",(D=D||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: {} ",!1!==n.opts.messages&&(t+=" , message: 'boolean schema is false' "),n.opts.verbose&&(t+=" , schema: false , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ",L=t,t=D.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+L+"]); ":t+=" validate.errors = ["+L+"]; return false; ":t+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):n.isTop?t+=i?" return data; ":" validate.errors = null; return true; ":t+=" var "+m+" = true; ",n.isTop&&(t+=" }; return validate; "),t}if(n.isTop){var f=n.isTop,l=n.level=0,c=n.dataLevel=0,p="data";if(n.rootId=n.resolve.fullPath(n.self._getId(n.root.schema)),n.baseId=n.baseId||n.rootId,delete n.isTop,n.dataPathArr=[void 0],void 0!==n.schema.default&&n.opts.useDefaults&&n.opts.strictDefaults){var C="default is ignored in the schema root";if("log"!==n.opts.strictDefaults)throw new Error(C);n.logger.warn(C)}t+=" var vErrors = null; ",t+=" var errors = 0;     ",t+=" if (rootData === undefined) rootData = data; "}else{l=n.level,p="data"+((c=n.dataLevel)||"");if(o&&(n.baseId=n.resolve.url(n.baseId,o)),i&&!n.async)throw new Error("async schema in sync schema");t+=" var errs_"+l+" = errors;"}var v,m="valid"+l,g=!n.opts.allErrors,I="",A="",b=n.schema.type,y=Array.isArray(b);if(b&&n.opts.nullable&&!0===n.schema.nullable&&(y?-1==b.indexOf("null")&&(b=b.concat("null")):"null"!=b&&(b=[b,"null"],y=!0)),y&&1==b.length&&(b=b[0],y=!1),n.schema.$ref&&r){if("fail"==n.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+n.errSchemaPath+'" (see option extendRefs)');!0!==n.opts.extendRefs&&(r=!1,n.logger.warn('$ref: keywords ignored in schema at path "'+n.errSchemaPath+'"'))}if(n.schema.$comment&&n.opts.$comment&&(t+=" "+n.RULES.all.$comment.code(n,"$comment")),b){n.opts.coerceTypes&&(v=n.util.coerceToTypes(n.opts.coerceTypes,b));var w=n.RULES.types[b];if(v||y||!0===w||w&&!U(w)){var d=n.schemaPath+".type",u=n.errSchemaPath+"/type",d=n.schemaPath+".type",u=n.errSchemaPath+"/type",S=y?"checkDataTypes":"checkDataType";if(t+=" if ("+n.util[S](b,p,n.opts.strictNumbers,!0)+") { ",v){var x="dataType"+l,k="coerced"+l;t+=" var "+x+" = typeof "+p+"; ","array"==n.opts.coerceTypes&&(t+=" if ("+x+" == 'object' && Array.isArray("+p+")) "+x+" = 'array'; "),t+=" var "+k+" = undefined; ";var E="",R=v;if(R)for(var _,T=-1,$=R.length-1;T<$;)_=R[T+=1],T&&(t+=" if ("+k+" === undefined) { ",E+="}"),"array"==n.opts.coerceTypes&&"array"!=_&&(t+=" if ("+x+" == 'array' && "+p+".length == 1) { "+k+" = "+p+" = "+p+"[0]; "+x+" = typeof "+p+";  } "),"string"==_?t+=" if ("+x+" == 'number' || "+x+" == 'boolean') "+k+" = '' + "+p+"; else if ("+p+" === null) "+k+" = ''; ":"number"==_||"integer"==_?(t+=" if ("+x+" == 'boolean' || "+p+" === null || ("+x+" == 'string' && "+p+" && "+p+" == +"+p+" ","integer"==_&&(t+=" && !("+p+" % 1)"),t+=")) "+k+" = +"+p+"; "):"boolean"==_?t+=" if ("+p+" === 'false' || "+p+" === 0 || "+p+" === null) "+k+" = false; else if ("+p+" === 'true' || "+p+" === 1) "+k+" = true; ":"null"==_?t+=" if ("+p+" === '' || "+p+" === 0 || "+p+" === false) "+k+" = null; ":"array"==n.opts.coerceTypes&&"array"==_&&(t+=" if ("+x+" == 'string' || "+x+" == 'number' || "+x+" == 'boolean' || "+p+" == null) "+k+" = ["+p+"]; ");(D=D||[]).push(t+=" "+E+" if ("+k+" === undefined) {   "),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";var L=t;t=D.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+L+"]); ":t+=" validate.errors = ["+L+"]; return false; ":t+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } else {  ";var B=c?"data"+(c-1||""):"parentData";t+=" "+p+" = "+k+"; ",c||(t+="if ("+B+" !== undefined)"),t+=" "+B+"["+(c?n.dataPathArr[c]:"parentDataProperty")+"] = "+k+"; } "}else{(D=D||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ";L=t;t=D.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+L+"]); ":t+=" validate.errors = ["+L+"]; return false; ":t+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}t+=" } "}}if(n.schema.$ref&&!r)t+=" "+n.RULES.all.$ref.code(n,"$ref")+" ",g&&(t+=" } if (errors === ",t+=f?"0":"errs_"+l,t+=") { ",A+="}");else{var W=n.RULES;if(W)for(var O=-1,N=W.length-1;O<N;)if(U(w=W[O+=1])){if(w.type&&(t+=" if ("+n.util.checkDataType(w.type,p,n.opts.strictNumbers)+") { "),n.opts.useDefaults)if("object"==w.type&&n.schema.properties){var h=n.schema.properties,G=Object.keys(h);if(G)for(var H,P=-1,V=G.length-1;P<V;){if(void 0!==(M=h[H=G[P+=1]]).default){var F=p+n.util.getProperty(H);if(n.compositeRule){if(n.opts.strictDefaults){C="default is ignored for: "+F;if("log"!==n.opts.strictDefaults)throw new Error(C);n.logger.warn(C)}}else t+=" if ("+F+" === undefined ","empty"==n.opts.useDefaults&&(t+=" || "+F+" === null || "+F+" === '' "),t+=" ) "+F+" = ","shared"==n.opts.useDefaults?t+=" "+n.useDefault(M.default)+" ":t+=" "+JSON.stringify(M.default)+" ",t+="; "}}}else if("array"==w.type&&Array.isArray(n.schema.items)){var Z=n.schema.items;if(Z)for(var M,T=-1,j=Z.length-1;T<j;)if(void 0!==(M=Z[T+=1]).default){F=p+"["+T+"]";if(n.compositeRule){if(n.opts.strictDefaults){C="default is ignored for: "+F;if("log"!==n.opts.strictDefaults)throw new Error(C);n.logger.warn(C)}}else t+=" if ("+F+" === undefined ","empty"==n.opts.useDefaults&&(t+=" || "+F+" === null || "+F+" === '' "),t+=" ) "+F+" = ","shared"==n.opts.useDefaults?t+=" "+n.useDefault(M.default)+" ":t+=" "+JSON.stringify(M.default)+" ",t+="; "}}var D,K=w.rules;if(K)for(var z,X,J=-1,Y=K.length-1;J<Y;){!Q(X=K[J+=1])||(z=X.code(n,X.keyword,w.type))&&(t+=" "+z+" ",g&&(I+="}"))}g&&(t+=" "+I+" ",I=""),w.type&&(t+=" } ",b&&b===w.type&&!v&&(t+=" else { ",d=n.schemaPath+".type",u=n.errSchemaPath+"/type",(D=D||[]).push(t),t="",!1!==n.createErrors?(t+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(u)+" , params: { type: '",t+=y?""+b.join(","):""+b,t+="' } ",!1!==n.opts.messages&&(t+=" , message: 'should be ",t+=y?""+b.join(","):""+b,t+="' "),n.opts.verbose&&(t+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+p+" "),t+=" } "):t+=" {} ",L=t,t=D.pop(),!n.compositeRule&&g?n.async?t+=" throw new ValidationError(["+L+"]); ":t+=" validate.errors = ["+L+"]; return false; ":t+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } ")),g&&(t+=" if (errors === ",t+=f?"0":"errs_"+l,t+=") { ",A+="}")}}function U(e){for(var t=e.rules,i=0;i<t.length;i++)if(Q(t[i]))return 1}function Q(e){return void 0!==n.schema[e.keyword]||e.implements&&function(e){for(var t=e.implements,i=0;i<t.length;i++)if(void 0!==n.schema[t[i]])return 1}(e)}return g&&(t+=" "+A+" "),f?(i?(t+=" if (errors === 0) return data;           ",t+=" else throw new ValidationError(vErrors); "):(t+=" validate.errors = vErrors; ",t+=" return errors === 0;       "),t+=" }; return validate;"):t+=" var "+m+" = errors === errs_"+l+";",t}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r,o,s,a,l,c=" ",h=e.level,d=e.dataLevel,u=e.schema[t],g=e.schemaPath+e.util.getProperty(t),p=e.errSchemaPath+"/"+t,m=!e.opts.allErrors,f="data"+(d||""),C=e.opts.$data&&u&&u.$data,v=C?(c+=" var schema"+h+" = "+e.util.getData(u.$data,d,e.dataPathArr)+"; ","schema"+h):u,I="maximum"==t,A=I?"exclusiveMaximum":"exclusiveMinimum",b=e.schema[A],y=e.opts.$data&&b&&b.$data,w=I?"<":">",S=I?">":"<",x=void 0;if(!C&&"number"!=typeof u&&void 0!==u)throw new Error(t+" must be number");if(!y&&void 0!==b&&"number"!=typeof b&&"boolean"!=typeof b)throw new Error(A+" must be number or boolean");y?(o="exclIsNumber"+h,s="' + "+(a="op"+h)+" + '",c+=" var schemaExcl"+h+" = "+(i=e.util.getData(b.$data,d,e.dataPathArr))+"; ",x=A,(l=l||[]).push(c+=" var "+(n="exclusive"+h)+"; var "+(r="exclType"+h)+" = typeof "+(i="schemaExcl"+h)+"; if ("+r+" != 'boolean' && "+r+" != 'undefined' && "+r+" != 'number') { "),c="",!1!==e.createErrors?(c+=" { keyword: '"+(x||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: {} ",!1!==e.opts.messages&&(c+=" , message: '"+A+" should be boolean' "),e.opts.verbose&&(c+=" , schema: validate.schema"+g+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+f+" "),c+=" } "):c+=" {} ",k=c,c=l.pop(),!e.compositeRule&&m?e.async?c+=" throw new ValidationError(["+k+"]); ":c+=" validate.errors = ["+k+"]; return false; ":c+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c+=" } else if ( ",C&&(c+=" ("+v+" !== undefined && typeof "+v+" != 'number') || "),c+=" "+r+" == 'number' ? ( ("+n+" = "+v+" === undefined || "+i+" "+w+"= "+v+") ? "+f+" "+S+"= "+i+" : "+f+" "+S+" "+v+" ) : ( ("+n+" = "+i+" === true) ? "+f+" "+S+"= "+v+" : "+f+" "+S+" "+v+" ) || "+f+" !== "+f+") { var op"+h+" = "+n+" ? '"+w+"' : '"+w+"='; ",void 0===u&&(x=A,p=e.errSchemaPath+"/"+A,v=i,C=y)):(s=w,(o="number"==typeof b)&&C?(a="'"+s+"'",c+=" if ( ",C&&(c+=" ("+v+" !== undefined && typeof "+v+" != 'number') || "),c+=" ( "+v+" === undefined || "+b+" "+w+"= "+v+" ? "+f+" "+S+"= "+b+" : "+f+" "+S+" "+v+" ) || "+f+" !== "+f+") { "):(o&&void 0===u?(n=!0,x=A,p=e.errSchemaPath+"/"+A,v=b,S+="="):(o&&(v=Math[I?"min":"max"](b,u)),b===(!o||v)?(n=!0,x=A,p=e.errSchemaPath+"/"+A,S+="="):(n=!1,s+="=")),a="'"+s+"'",c+=" if ( ",C&&(c+=" ("+v+" !== undefined && typeof "+v+" != 'number') || "),c+=" "+f+" "+S+" "+v+" || "+f+" !== "+f+") { ")),x=x||t,(l=l||[]).push(c),c="",!1!==e.createErrors?(c+=" { keyword: '"+(x||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: { comparison: "+a+", limit: "+v+", exclusive: "+n+" } ",!1!==e.opts.messages&&(c+=" , message: 'should be "+s+" ",c+=C?"' + "+v:v+"'"),e.opts.verbose&&(c+=" , schema:  ",c+=C?"validate.schema"+g:""+u,c+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+f+" "),c+=" } "):c+=" {} ";var k=c;return c=l.pop(),!e.compositeRule&&m?e.async?c+=" throw new ValidationError(["+k+"]); ":c+=" validate.errors = ["+k+"]; return false; ":c+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c+=" } ",m&&(c+=" else { "),c}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&o&&o.$data,d=h?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!h&&"number"!=typeof o)throw new Error(t+" must be number");i+="if ( ",h&&(i+=" ("+d+" !== undefined && typeof "+d+" != 'number') || "),i+=" "+c+".length "+("maxItems"==t?">":"<")+" "+d+") { ";var u=t,g=g||[];g.push(i),i="",!1!==e.createErrors?(i+=" { keyword: '"+(u||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { limit: "+d+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have ",i+="maxItems"==t?"more":"fewer",i+=" than ",i+=h?"' + "+d+" + '":""+o,i+=" items' "),e.opts.verbose&&(i+=" , schema:  ",i+=h?"validate.schema"+s:""+o,i+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var p=i,i=g.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+p+"]); ":i+=" validate.errors = ["+p+"]; return false; ":i+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&o&&o.$data,d=h?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!h&&"number"!=typeof o)throw new Error(t+" must be number");var u="maxLength"==t?">":"<";i+="if ( ",h&&(i+=" ("+d+" !== undefined && typeof "+d+" != 'number') || "),!1===e.opts.unicode?i+=" "+c+".length ":i+=" ucs2length("+c+") ",i+=" "+u+" "+d+") { ";var g=t,p=p||[];p.push(i),i="",!1!==e.createErrors?(i+=" { keyword: '"+(g||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { limit: "+d+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT be ",i+="maxLength"==t?"longer":"shorter",i+=" than ",i+=h?"' + "+d+" + '":""+o,i+=" characters' "),e.opts.verbose&&(i+=" , schema:  ",i+=h?"validate.schema"+s:""+o,i+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var m=i,i=p.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+m+"]); ":i+=" validate.errors = ["+m+"]; return false; ":i+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&o&&o.$data,d=h?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!h&&"number"!=typeof o)throw new Error(t+" must be number");i+="if ( ",h&&(i+=" ("+d+" !== undefined && typeof "+d+" != 'number') || "),i+=" Object.keys("+c+").length "+("maxProperties"==t?">":"<")+" "+d+") { ";var u=t,g=g||[];g.push(i),i="",!1!==e.createErrors?(i+=" { keyword: '"+(u||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { limit: "+d+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have ",i+="maxProperties"==t?"more":"fewer",i+=" than ",i+=h?"' + "+d+" + '":""+o,i+=" properties' "),e.opts.verbose&&(i+=" , schema:  ",i+=h?"validate.schema"+s:""+o,i+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var p=i,i=g.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+p+"]); ":i+=" validate.errors = ["+p+"]; return false; ":i+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')},function(e,t,i){"use strict";var b={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},y="a".charCodeAt();t.parse=function(r,e,t){var n={},i=0,o=0,s=0,a=t&&t.bigint&&"undefined"!=typeof BigInt;return{data:l("",!0),pointers:n};function l(e,t){var i;c(),m(e,"value");var n=u();switch(n){case"t":d("rue"),i=!0;break;case"f":d("alse"),i=!1;break;case"n":d("ull"),i=null;break;case'"':i=h();break;case"[":i=function(e){c();var t=[],i=0;if("]"==u())return t;g();for(;;){var n=e+"/"+i;t.push(l(n)),c();var r=u();if("]"==r)break;","!=r&&I(),c(),i++}return t}(e);break;case"{":i=function(e){c();var t={};if("}"==u())return t;g();for(;;){var i=C();'"'!=u()&&I();var n=h(),r=e+"/"+w(n);f(r,"key",i),m(r,"keyEnd"),c(),":"!=u()&&I(),c(),t[n]=l(r),c();var o=u();if("}"==o)break;","!=o&&I(),c()}return t}(e);break;default:g(),0<="-0123456789".indexOf(n)?i=function(){var e="",t=!0;"-"==r[s]&&(e+=u());e+=("0"==r[s]?u:p)(),"."==r[s]&&(e+=u()+p(),t=!1);"e"!=r[s]&&"E"!=r[s]||(e+=u(),"+"!=r[s]&&"-"!=r[s]||(e+=u()),e+=p(),t=!1);var i=+e;return a&&t&&(i>Number.MAX_SAFE_INTEGER||i<Number.MIN_SAFE_INTEGER)?BigInt(e):i}():v()}return m(e,"valueEnd"),c(),t&&s<r.length&&v(),i}function c(){e:for(;s<r.length;){switch(r[s]){case" ":o++;break;case"\t":o+=4;break;case"\r":o=0;break;case"\n":o=0,i++;break;default:break e}s++}}function h(){for(var e,t="";'"'!=(e=u());)"\\"==e?(e=u())in b?t+=b[e]:"u"==e?t+=function(){var e=4,t=0;for(;e--;){t<<=4;var i=u().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-y+10:"0"<=i&&i<="9"?t+=+i:I()}return String.fromCharCode(t)}():I():t+=e;return t}function d(e){for(var t=0;t<e.length;t++)u()!==e[t]&&I()}function u(){A();var e=r[s];return s++,o++,e}function g(){s--,o--}function p(){for(var e="";"0"<=r[s]&&r[s]<="9";)e+=u();if(e.length)return e;A(),v()}function m(e,t){f(e,t,C())}function f(e,t,i){n[e]=n[e]||{},n[e][t]=i}function C(){return{line:i,column:o,pos:s}}function v(){throw new SyntaxError("Unexpected token "+r[s]+" in JSON at position "+s)}function I(){g(),v()}function A(){if(s>=r.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,i){if(I(e)){var n=0;switch(typeof(g="object"==typeof i?i.space:i)){case"number":var r=10<g?10:g<0?0:Math.floor(g),g=r&&v(r," "),o=r,s=r;break;case"string":g=g.slice(0,10);for(var a=s=o=0;a<g.length;a++){switch(g[a]){case" ":s++;break;case"\t":s+=4;break;case"\r":s=0;break;case"\n":s=0,n++;break;default:throw new Error("whitespace characters not allowed in JSON")}o++}break;default:g=void 0}var l="",c={},h=0,d=0,u=0,p=i&&i.es6&&"function"==typeof Map;return function c(h,d,u){C(u,"value");switch(typeof h){case"number":case"bigint":case"boolean":m(""+h);break;case"string":m(A(h));break;case"object":null===h?m("null"):"function"==typeof h.toJSON?m(A(h.toJSON())):Array.isArray(h)?e():p?h.constructor.BYTES_PER_ELEMENT?e():h instanceof Map?i():h instanceof Set?i(!0):t():t()}C(u,"valueEnd");function e(){if(h.length){m("[");for(var e=d+1,t=0;t<h.length;t++){t&&m(","),f(e);var i=I(h[t])?h[t]:null,n=u+"/"+t;c(i,e,n)}f(d),m("]")}else m("[]")}function t(){var e=Object.keys(h);if(e.length){m("{");for(var t=d+1,i=0;i<e.length;i++){var n,r=e[i],o=h[r];I(o)&&(i&&m(","),n=u+"/"+w(r),f(t),C(n,"key"),m(A(r)),C(n,"keyEnd"),m(":"),g&&m(" "),c(o,t,n))}f(d),m("}")}else m("{}")}function i(e){if(h.size){m("{");for(var t=d+1,i=!0,n=h.entries(),r=n.next();!r.done;){var o,s=r.value,a=s[0],l=!!e||s[1];I(l)&&(i||m(","),i=!1,o=u+"/"+w(a),f(t),C(o,"key"),m(A(a)),C(o,"keyEnd"),m(":"),g&&m(" "),c(l,t,o)),r=n.next()}f(d),m("}")}else m("{}")}}(e,0,""),{json:l,pointers:c}}function m(e){d+=e.length,u+=e.length,l+=e}function f(e){if(g){for(l+="\n"+v(e,g),h++,d=0;e--;)n?(h+=n,d=s):d+=s,u+=o;u+=1}}function C(e,t){c[e]=c[e]||{},c[e][t]={line:h,column:d,pos:u}}function v(e,t){return Array(e+1).join(t)}};var n=["number","bigint","boolean","string","object"];function I(e){return 0<=n.indexOf(typeof e)}var r=/"|\\/g,o=/[\b]/g,s=/\f/g,a=/\n/g,l=/\r/g,c=/\t/g;function A(e){return'"'+(e=e.replace(r,"\\$&").replace(s,"\\f").replace(o,"\\b").replace(a,"\\n").replace(l,"\\r").replace(c,"\\t"))+'"'}var h=/~/g,d=/\//g;function w(e){return e.replace(h,"~0").replace(d,"~1")}},function(e,t,i){!function(e){"use strict";function E(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function R(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function _(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===E(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===_(e[i],t[i]))return!1;return!0}if(!0!==R(e))return!1;var n={};for(var r in e)if(hasOwnProperty.call(e,r)){if(!1===_(e[r],t[r]))return!1;n[r]=!0}for(var o in t)if(hasOwnProperty.call(t,o)&&!0!==n[o])return!1;return!0}function T(e){if(""===e||!1===e||null===e)return!0;if(E(e)&&0===e.length)return!0;if(R(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var s="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]},c=0,o=1,h=2,a=3,t=4,i=6,l=8,d=9,u="UnquotedIdentifier",g="QuotedIdentifier",p="Rbracket",m="Rparen",f="Comma",C="Colon",v="Rbrace",I="Number",$="Current",L="Expref",B="Pipe",W="GTE",O="LTE",N="Flatten",A="Star",b="Filter",y="Dot",w="Lbrace",S="Lbracket",x="Lparen",k="Literal",G={".":y,"*":A,",":f,":":C,"{":w,"}":v,"]":p,"(":x,")":m,"@":$},H={"<":!0,">":!0,"=":!0,"!":!0},P={" ":!0,"\t":!0,"\n":!0};function V(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,i,n,r,o=[];for(this._current=0;this._current<e.length;)if("a"<=(r=e[this._current])&&r<="z"||"A"<=r&&r<="Z"||"_"===r)t=this._current,i=this._consumeUnquotedIdentifier(e),o.push({type:u,value:i,start:t});else if(void 0!==G[e[this._current]])o.push({type:G[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(V(e[this._current]))n=this._consumeNumber(e),o.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),o.push(n);else if('"'===e[this._current])t=this._current,i=this._consumeQuotedIdentifier(e),o.push({type:g,value:i,start:t});else if("'"===e[this._current])t=this._current,i=this._consumeRawStringLiteral(e),o.push({type:k,value:i,start:t});else if("`"===e[this._current]){t=this._current;var s=this._consumeLiteral(e);o.push({type:k,value:s,start:t})}else if(void 0!==H[e[this._current]])o.push(this._consumeOperator(e));else if(void 0!==P[e[this._current]])this._current++;else if("&"===e[this._current])t=this._current,this._current++,"&"===e[this._current]?(this._current++,o.push({type:"And",value:"&&",start:t})):o.push({type:L,value:"&",start:t});else{if("|"!==e[this._current]){var a=new Error("Unknown character:"+e[this._current]);throw a.name="LexerError",a}t=this._current,this._current++,"|"===e[this._current]?(this._current++,o.push({type:"Or",value:"||",start:t})):o.push({type:B,value:"|",start:t})}return o},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;V(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:I,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:b,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:N,value:"[]",start:t}):{type:S,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:O,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:W,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t=this._current,i=e.length;"`"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"`"!==e[n+1]?n++:n+=2,this._current=n}var r=(r=s(e.slice(t,this._current))).replace("\\`","`"),o=this._looksLikeJSON(r)?JSON.parse(r):JSON.parse('"'+r+'"');return this._current++,o},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var F={};function Z(){}function M(e){this.runtime=e}function j(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[c]}]},avg:{_func:this._functionAvg,_signature:[{types:[l]}]},ceil:{_func:this._functionCeil,_signature:[{types:[c]}]},contains:{_func:this._functionContains,_signature:[{types:[h,a]},{types:[o]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[h]},{types:[h]}]},floor:{_func:this._functionFloor,_signature:[{types:[c]}]},length:{_func:this._functionLength,_signature:[{types:[h,a,t]}]},map:{_func:this._functionMap,_signature:[{types:[i]},{types:[a]}]},max:{_func:this._functionMax,_signature:[{types:[l,d]}]},merge:{_func:this._functionMerge,_signature:[{types:[t],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[a]},{types:[i]}]},sum:{_func:this._functionSum,_signature:[{types:[l]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[h]},{types:[h]}]},min:{_func:this._functionMin,_signature:[{types:[l,d]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[a]},{types:[i]}]},type:{_func:this._functionType,_signature:[{types:[o]}]},keys:{_func:this._functionKeys,_signature:[{types:[t]}]},values:{_func:this._functionValues,_signature:[{types:[t]}]},sort:{_func:this._functionSort,_signature:[{types:[d,l]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[a]},{types:[i]}]},join:{_func:this._functionJoin,_signature:[{types:[h]},{types:[d]}]},reverse:{_func:this._functionReverse,_signature:[{types:[h,a]}]},to_array:{_func:this._functionToArray,_signature:[{types:[o]}]},to_string:{_func:this._functionToString,_signature:[{types:[o]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[o]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[o],variadic:!0}]}}}F.EOF=0,F[u]=0,F[g]=0,F[p]=0,F[m]=0,F[f]=0,F[v]=0,F[I]=0,F[$]=0,F[L]=0,F[B]=1,F.Or=2,F.And=3,F.EQ=5,F.GT=5,F.LT=5,F.GTE=5,F.LTE=5,F.NE=5,F[N]=9,F[A]=20,F[b]=21,F.Dot=40,F.Not=45,F[w]=50,F[S]=55,F[x]=60,Z.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"===this._lookahead(0))return t;var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<F[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case k:return{type:"Literal",value:e.value};case u:return{type:"Field",name:e.value};case g:var n={type:"Field",name:e.value};if(this._lookahead(0)===x)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(F.Not)]};case A:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===p?{type:"Identity"}:this._parseProjectionRHS(F.Star)]};case b:return this.led(e.type,{type:"Identity"});case w:return this._parseMultiselectHash();case N:return{type:"Projection",children:[{type:N,children:[{type:"Identity"}]},t=this._parseProjectionRHS(F.Flatten)]};case S:return this._lookahead(0)===I||this._lookahead(0)===C?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===A&&this._lookahead(1)===p?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(F.Star)]}):this._parseMultiselectList();case $:return{type:$};case L:return{type:"ExpressionReference",children:[i=this.expression(F.Expref)]};case x:for(var r=[];this._lookahead(0)!==m;)this._lookahead(0)===$?(i={type:$},this._advance()):i=this.expression(0),r.push(i);return this._match(m),r[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case y:var n=F.Dot;return this._lookahead(0)!==A?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case B:return i=this.expression(F.Pipe),{type:B,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(F.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(F.And)]};case x:for(var r,o=t.name,s=[];this._lookahead(0)!==m;)this._lookahead(0)===$?(r={type:$},this._advance()):r=this.expression(0),this._lookahead(0)===f&&this._match(f),s.push(r);return this._match(m),{type:"Function",name:o,children:s};case b:var a=this.expression(0);return this._match(p),{type:"FilterProjection",children:[t,i=this._lookahead(0)===N?{type:"Identity"}:this._parseProjectionRHS(F.Filter),a]};case N:return{type:"Projection",children:[{type:N,children:[t]},this._parseProjectionRHS(F.Flatten)]};case"EQ":case"NE":case"GT":case W:case"LT":case O:return this._parseComparator(t,e);case S:var l=this._lookaheadToken(0);return l.type===I||l.type===C?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(A),this._match(p),{type:"Projection",children:[t,i=this._parseProjectionRHS(F.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if(this._lookahead(0)===C||this._lookahead(1)===C)return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match(p),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(F.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);i!==p&&t<3;){if(i===C)t++,this._advance();else{if(i!==I){var n=this._lookahead(0),r=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw r.name="Parsererror",r}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match(p),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(F[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[u,g,A].indexOf(t)?this.expression(e):t===S?(this._match(S),this._parseMultiselectList()):t===w?(this._match(w),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(F[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===S)t=this.expression(e);else if(this._lookahead(0)===b)t=this.expression(e);else{if(this._lookahead(0)!==y){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match(y),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==p;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===f&&(this._match(f),this._lookahead(0)===p))throw new Error("Unexpected token Rbracket")}return this._match(p),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n=[],r=[u,g];;){if(e=this._lookaheadToken(0),r.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match(C),i={type:"KeyValuePair",name:t,value:this.expression(0)},n.push(i),this._lookahead(0)===f)this._match(f);else if(this._lookahead(0)===v){this._match(v);break}}return{type:"MultiSelectHash",children:n}}},M.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var i,n,r,o,s,a;switch(e.type){case"Field":return null===t||!R(t)||void 0===(s=t[e.name])?null:s;case"Subexpression":for(p=this.visit(e.children[0],t),C=1;C<e.children.length;C++)if(null===(p=this.visit(e.children[1],p)))return null;return p;case"IndexExpression":return a=this.visit(e.children[0],t),this.visit(e.children[1],a);case"Index":if(!E(t))return null;var l=e.value;return l<0&&(l=t.length+l),void 0===(p=t[l])&&(p=null),p;case"Slice":if(!E(t))return null;var c=e.children.slice(0),h=this.computeSliceParams(t.length,c),d=h[0],u=h[1],g=h[2],p=[];if(0<g)for(C=d;C<u;C+=g)p.push(t[C]);else for(C=d;u<C;C+=g)p.push(t[C]);return p;case"Projection":var m=this.visit(e.children[0],t);if(!E(m))return null;for(S=[],C=0;C<m.length;C++)null!==(n=this.visit(e.children[1],m[C]))&&S.push(n);return S;case"ValueProjection":if(!R(m=this.visit(e.children[0],t)))return null;S=[];for(var f=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(m),C=0;C<f.length;C++)null!==(n=this.visit(e.children[1],f[C]))&&S.push(n);return S;case"FilterProjection":if(!E(m=this.visit(e.children[0],t)))return null;var v=[],I=[];for(C=0;C<m.length;C++)T(i=this.visit(e.children[2],m[C]))||v.push(m[C]);for(var A=0;A<v.length;A++)null!==(n=this.visit(e.children[1],v[A]))&&I.push(n);return I;case"Comparator":switch(r=this.visit(e.children[0],t),o=this.visit(e.children[1],t),e.name){case"EQ":p=_(r,o);break;case"NE":p=!_(r,o);break;case"GT":p=o<r;break;case W:p=o<=r;break;case"LT":p=r<o;break;case O:p=r<=o;break;default:throw new Error("Unknown comparator: "+e.name)}return p;case N:var b=this.visit(e.children[0],t);if(!E(b))return null;var y=[];for(C=0;C<b.length;C++)E(n=b[C])?y.push.apply(y,n):y.push(n);return y;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(S=[],C=0;C<e.children.length;C++)S.push(this.visit(e.children[C],t));return S;case"MultiSelectHash":if(null===t)return null;var w,S={};for(C=0;C<e.children.length;C++)S[(w=e.children[C]).name]=this.visit(w.value,t);return S;case"OrExpression":return T(i=this.visit(e.children[0],t))&&(i=this.visit(e.children[1],t)),i;case"AndExpression":return!0===T(r=this.visit(e.children[0],t))?r:this.visit(e.children[1],t);case"NotExpression":return T(r=this.visit(e.children[0],t));case"Literal":return e.value;case B:return a=this.visit(e.children[0],t),this.visit(e.children[1],a);case $:return t;case"Function":var x=[];for(C=0;C<e.children.length;C++)x.push(this.visit(e.children[C],t));return this.runtime.callFunction(e.name,x);case"ExpressionReference":var k=e.children[0];return k.jmespathType=L,k;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],r=t[2],o=[null,null,null];if(null===r)r=1;else if(0===r){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=r<0,i=null===i?a?e-1:0:this.capSliceRange(e,i,r),n=null===n?a?-1:e:this.capSliceRange(e,n,r);return o[0]=i,o[1]=n,o[2]=r,o},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},j.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n,r,o,s;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var a=0;a<i.length;a++){s=!1,r=i[a].types,o=this._getTypeName(t[a]);for(var l=0;l<r.length;l++)if(this._typeMatches(o,r[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+r+" but received type "+o+" instead.")}},_typeMatches:function(e,t,i){if(t===o)return!0;if(t!==d&&t!==l&&t!==a)return e===t;if(t===a)return e===a;if(e===a){var n;t===l?n=c:t===d&&(n=h);for(var r=0;r<i.length;r++)if(!this._typeMatches(this._getTypeName(i[r]),n,i[r]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return h;case"[object Number]":return c;case"[object Array]":return a;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===L?i:t}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===h){for(var t=e[0],i="",n=t.length-1;0<=n;n--)i+=t[n];return i}var r=e[0].slice(0);return r.reverse(),r},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return R(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],r=e[1],o=0;o<r.length;o++)t.push(i.visit(n,r[o]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var r in n)t[r]=n[r]}return t},_functionMax:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case c:return"number";case h:return"string";case a:return"array";case t:return"object";case 5:return"boolean";case i:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],r=0;r<i.length;r++)n.push(t[i[r]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===a?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===h?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===c?e[0]:i!==h||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var r=this._interpreter,o=e[1],s=this._getTypeName(r.visit(o,t[0]));if([c,h].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=r.visit(o,e[1]),n=r.visit(o,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=-1/0,a=0;a<r.length;a++)s<(i=o(r[a]))&&(s=i,t=r[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=1/0,a=0;a<r.length;a++)(i=o(r[a]))<s&&(s=i,t=r[a]);return t},createKeyFunction:function(n,r){var o=this,s=this._interpreter;return function(e){var t=s.visit(n,e);if(r.indexOf(o._getTypeName(t))<0){var i="TypeError: expected one of "+r+", received "+o._getTypeName(t);throw new Error(i)}return t}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new Z).parse(e)},e.search=function(e,t){var i=new Z,n=new j,r=new M(n);n._interpreter=r;var o=i.parse(t);return r.search(o,e)},e.strictDeepEqual=_}(t)},function(e,t,i){t.tryRequireThemeJsonEditor=function(){try{i(42)}catch(e){console.error(e)}}},function(e,t,r){"use strict";var i=r(20),n=r(13),o=r(80).treeModeMixins,s=r(21).textModeMixins,a=r(81).previewModeMixins,l=r(0),c=l.clear,h=l.extend,d=l.getInnerText,u=l.getInternetExplorerVersion,g=l.parse,p=r(43).tryRequireAjv,m=r(6).showTransformModal,f=r(5).showSortModal,C=p();function v(e,t,i){if(!(this instanceof v))throw new Error('JSONEditor constructor called without "new".');var n=u();if(-1!==n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===v.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),v.modes={},v.prototype.DEBOUNCE_INTERVAL=150,v.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription"],v.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},v.prototype.destroy=function(){},v.prototype.set=function(e){this.json=e},v.prototype.get=function(){return this.json},v.prototype.setText=function(e){this.json=g(e)},v.prototype.getText=function(){return JSON.stringify(this.json)},v.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},v.prototype.getName=function(){return this.options&&this.options.name},v.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t=this.container,i=h({},this.options),n=i.mode;i.mode=e;var r=v.modes[e];if(!r)throw new Error('Unknown mode "'+i.mode+'"');try{var o="text"===r.data,s=this.getName(),a=this[o?"getText":"get"]();if(this.destroy(),c(this),h(this,r.mixin),this.create(t,i),this.setName(s),this[o?"setText":"set"](a),"function"==typeof r.load)try{r.load.call(this)}catch(e){console.error(e)}if("function"==typeof i.onModeChange&&e!==n)try{i.onModeChange(e,n)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},v.prototype.getMode=function(){return this.options.mode},v.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},v.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=C({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(r(78)),i.addMetaSchema(r(79)))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},v.prototype.validate=function(){},v.prototype.refresh=function(){},v.registerMode=function(e){var t;if(Array.isArray(e))for(r=0;r<e.length;r++)v.registerMode(e[r]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var i=e.mode;if(i in v.modes)throw new Error('Mode "'+i+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');for(var n=["setMode","registerMode","modes"],r=0;r<n.length;r++)if((t=n[r])in e.mixin)throw new Error('Reserved property "'+t+'" not allowed in mixin');v.modes[i]=e}},v.registerMode(o),v.registerMode(s),v.registerMode(a),v.ace=i,v.Ajv=C,v.VanillaPicker=n,v.showTransformModal=m,v.showSortModal=f,v.getInnerText=d,v.default=v,e.exports=v},function(e,t,I){(function(i){!function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var o=function(e,t,i){"string"==typeof e?(2==arguments.length&&(i=t),o.modules[e]||(o.payloads[e]=i,o.modules[e]=null)):o.original?o.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())};o.modules={},o.payloads={};function s(e,t,i){if("string"==typeof t){var n=c(e,t);if(null!=n)return i&&i(),n}else if("[object Array]"===Object.prototype.toString.call(t)){for(var r=[],o=0,s=t.length;o<s;++o){var a=c(e,t[o]);if(null==a&&l.original)return;r.push(a)}return i&&i.apply(null,r)||!0}}var t,i,l=function(e,t){var i=s("",e,t);return null==i&&l.original?l.original.apply(this,arguments):i},a=function(e,t){if(-1!==t.indexOf("!")){var i=t.split("!");return a(e,i[0])+"!"+a(e,i[1])}if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&n!=t;){var n=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},c=function(e,i){i=a(e,i);var t,n,r=o.modules[i];return r||("function"==typeof(r=o.payloads[i])&&(t={id:i,uri:"",exports:n={},packaged:!0},n=r(function(e,t){return s(i,e,t)},n,t)||t.exports,o.modules[i]=n,delete o.payloads[i]),r=o.modules[i]=n||r),r};i=e,(t="ace")&&(e[t]||(e[t]={}),i=e[t]),i.define&&i.define.packaged||(o.original=i.define,i.define=o,i.define.packaged=!0),i.require&&i.require.packaged||(l.original=i.require,i.require=l,i.require.packaged=!0)}(),ace.define("ace/lib/fixoldbrowsers",["require","exports","module"],function(e,t,i){"use strict";"undefined"==typeof Element||Element.prototype.remove||Object.defineProperty(Element.prototype,"remove",{enumerable:!1,writable:!0,configurable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,i){"use strict";t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS};var n="object"==typeof navigator?navigator:{},r=(/mac|win|linux/i.exec(n.platform)||["other"])[0].toLowerCase(),o=n.userAgent||"",s=n.appName||"";t.isWin="win"==r,t.isMac="mac"==r,t.isLinux="linux"==r,t.isIE="Microsoft Internet Explorer"==s||0<=s.indexOf("MSAppHost")?parseFloat((o.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((o.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=o.match(/ Gecko\/\d+/),t.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(o.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(o.split(" Chrome/")[1])||void 0,t.isEdge=parseFloat(o.split(" Edge/")[1])||void 0,t.isAIR=0<=o.indexOf("AdobeAIR"),t.isAndroid=0<=o.indexOf("Android"),t.isChromeOS=0<=o.indexOf(" CrOS "),t.isIOS=/iPad|iPhone|iPod/.test(o)&&!window.MSStream,t.isIOS&&(t.isMac=!0),t.isMobile=t.isIOS||t.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(e,a,t){"use strict";var i,n=e("./useragent");a.buildDom=function e(t,i,n){if("string"==typeof t&&t){var r=document.createTextNode(t);return i&&i.appendChild(r),r}if(!Array.isArray(t))return t&&t.appendChild&&i&&i.appendChild(t),t;if("string"!=typeof t[0]||!t[0]){for(var o=[],s=0;s<t.length;s++){var a=e(t[s],i,n);a&&o.push(a)}return o}var l=document.createElement(t[0]),c=t[1],h=1;c&&"object"==typeof c&&!Array.isArray(c)&&(h=2);for(s=h;s<t.length;s++)e(t[s],l,n);return 2==h&&Object.keys(c).forEach(function(e){var t=c[e];"class"===e?l.className=Array.isArray(t)?t.join(" "):t:"function"==typeof t||"value"==e||"$"==e[0]?l[e]=t:"ref"===e?n&&(n[t]=l):null!=t&&l.setAttribute(e,t)}),i&&i.appendChild(l),l},a.getDocumentHead=function(e){return(e=e||document).head||e.getElementsByTagName("head")[0]||e.documentElement},a.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},a.removeChildren=function(e){e.innerHTML=""},a.createTextNode=function(e,t){return(t?t.ownerDocument:document).createTextNode(e)},a.createFragment=function(e){return(e?e.ownerDocument:document).createDocumentFragment()},a.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},a.addCssClass=function(e,t){a.hasCssClass(e,t)||(e.className+=" "+t)},a.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},a.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var r=i.indexOf(t);if(-1==r)break;n=!1,i.splice(r,1)}return n&&i.push(t),e.className=i.join(" "),n},a.setCssClass=function(e,t,i){i?a.addCssClass(e,t):a.removeCssClass(e,t)},a.hasCssString=function(e,t){var i,n=0;if(i=(t=t||document).querySelectorAll("style"))for(;n<i.length;)if(i[n++].id===e)return!0},a.importCssString=function(e,t,i){var n=i;i&&i.getRootNode&&(n=i.getRootNode())&&n!=i||(n=document);var r=n.ownerDocument||n;if(t&&a.hasCssString(t,n))return null;t&&(e+="\n/*# sourceURL=ace/css/"+t+" */");var o=a.createElement("style");o.appendChild(r.createTextNode(e)),t&&(o.id=t),n==r&&(n=a.getDocumentHead(r)),n.insertBefore(o,n.firstChild)},a.importCssStylsheet=function(e,t){a.buildDom(["link",{rel:"stylesheet",href:e}],a.getDocumentHead(t))},a.scrollbarWidth=function(e){var t=a.createElement("ace_inner");t.style.width="100%",t.style.minWidth="0px",t.style.height="200px",t.style.display="block";var i=a.createElement("ace_outer"),n=i.style;n.position="absolute",n.left="-10000px",n.overflow="hidden",n.width="200px",n.minWidth="0px",n.height="150px",n.display="block",i.appendChild(t);var r=e.documentElement;r.appendChild(i);var o=t.offsetWidth;n.overflow="scroll";var s=t.offsetWidth;return o==s&&(s=i.clientWidth),r.removeChild(i),o-s},"undefined"==typeof document&&(a.importCssString=function(){}),a.computedStyle=function(e,t){return window.getComputedStyle(e,"")||{}},a.setStyle=function(e,t,i){e[t]!==i&&(e[t]=i)},a.HAS_CSS_ANIMATION=!1,a.HAS_CSS_TRANSFORMS=!1,a.HI_DPI=!n.isWin||"undefined"!=typeof window&&1.5<=window.devicePixelRatio,"undefined"!=typeof document&&(i=document.createElement("div"),a.HI_DPI&&void 0!==i.style.transform&&(a.HAS_CSS_TRANSFORMS=!0),n.isEdge||void 0===i.style.animationName||(a.HAS_CSS_ANIMATION=!0),i=null),a.HAS_CSS_TRANSFORMS?a.translate=function(e,t,i){e.style.transform="translate("+Math.round(t)+"px, "+Math.round(i)+"px)"}:a.translate=function(e,t,i){e.style.top=Math.round(i)+"px",e.style.left=Math.round(t)+"px"}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,i,t){"use strict";i.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},i.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},i.implement=function(e,t){i.mixin(e,t)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(e,t,i){"use strict";var n=e("./oop"),r=function(){var e,t,i={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in i.FUNCTION_KEYS)e=i.FUNCTION_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);for(t in i.PRINTABLE_KEYS)e=i.PRINTABLE_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);return n.mixin(i,i.MODIFIER_KEYS),n.mixin(i,i.PRINTABLE_KEYS),n.mixin(i,i.FUNCTION_KEYS),i.enter=i.return,i.escape=i.esc,i.del=i.delete,i[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)i.KEY_MODS[t]=e.filter(function(e){return t&i.KEY_MODS[e]}).join("-")+"-"}(),i.KEY_MODS[0]="",i.KEY_MODS[-1]="input-",i}();n.mixin(t,r),t.keyCodeToString=function(e){var t=r[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,d,t){"use strict";var i,o=e("./keys"),u=e("./useragent"),s=null,a=0;function r(){return null==i&&function(){i=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){i={passive:!1}}})}catch(e){}}(),i}function l(e,t,i){this.elem=e,this.type=t,this.callback=i}l.prototype.destroy=function(){c(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};var g=d.addListener=function(e,t,i,n){e.addEventListener(t,i,r()),n&&n.$toDestroy.push(new l(e,t,i))},c=d.removeListener=function(e,t,i){e.removeEventListener(t,i,r())};d.stopEvent=function(e){return d.stopPropagation(e),d.preventDefault(e),!1},d.stopPropagation=function(e){e.stopPropagation&&e.stopPropagation()},d.preventDefault=function(e){e.preventDefault&&e.preventDefault()},d.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||u.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.button},d.capture=function(e,t,i){var n=e&&e.ownerDocument||document;function r(e){t&&t(e),i&&i(e),c(n,"mousemove",t),c(n,"mouseup",r),c(n,"dragstart",r)}return g(n,"mousemove",t),g(n,"mouseup",r),g(n,"dragstart",r),r},d.addMouseWheelListener=function(e,t,i){"onmousewheel"in e?g(e,"mousewheel",function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),t(e)},i):"onwheel"in e?g(e,"wheel",function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}t(e)},i):g(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),t(e)},i)},d.addMultiMouseDownListener=function(e,i,n,r,t){var o,s,a,l=0,c={2:"dblclick",3:"tripleclick",4:"quadclick"};function h(e){var t;if(0!==d.getButton(e)?l=0:1<e.detail&&!(4<++l)||(l=1),u.isIE&&(t=5<Math.abs(e.clientX-o)||5<Math.abs(e.clientY-s),a&&!t||(l=1),a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),1==l&&(o=e.clientX,s=e.clientY)),e._clicks=l,n[r]("mousedown",e),4<l)l=0;else if(1<l)return n[r](c[l],e)}Array.isArray(e)||(e=[e]),e.forEach(function(e){g(e,"mousedown",h,t)})};function h(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}var p;function m(e,t,i){var n,r=h(t);if(!u.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(r|=8),s.altGr){if(3==(3&r))return;s.altGr=0}18!==i&&17!==i||(n="location"in t?t.location:t.keyLocation,17===i&&1===n?1==s[i]&&(a=t.timeStamp):18===i&&3===r&&2===n&&t.timeStamp-a<50&&(s.altGr=!0))}if((i in o.MODIFIER_KEYS&&(i=-1),!r&&13===i)&&(3===(n="location"in t?t.location:t.keyLocation)&&(e(t,r,-i),t.defaultPrevented)))return;if(u.isChromeOS&&8&r){if(e(t,r,i),t.defaultPrevented)return;r&=-9}return!!(r||i in o.FUNCTION_KEYS||i in o.PRINTABLE_KEYS)&&e(t,r,i)}function f(){
s=Object.create(null)}d.getModifierString=function(e){return o.KEY_MODS[h(e)]},d.addCommandKeyListener=function(e,i,t){var n,r;u.isOldGecko||u.isOpera&&!("KeyboardEvent"in window)?(n=null,g(e,"keydown",function(e){n=e.keyCode},t),g(e,"keypress",function(e){return m(i,e,n)},t)):(r=null,g(e,"keydown",function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=m(i,e,e.keyCode);return r=e.defaultPrevented,t},t),g(e,"keypress",function(e){r&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(d.stopEvent(e),r=null)},t),g(e,"keyup",function(e){s[e.keyCode]=null},t),s||(f(),g(window,"focus",f)))},"object"==typeof window&&window.postMessage&&!u.isOldIE&&(p=1,d.nextTick=function(t,i){i=i||window;var n="zero-timeout-message-"+p++,r=function(e){e.data==n&&(d.stopPropagation(e),c(i,"message",r),t())};g(i,"message",r),i.postMessage(n,"*")}),d.$idleBlocked=!1,d.onIdle=function(t,e){return setTimeout(function e(){d.$idleBlocked?setTimeout(e,100):t()},e)},d.$idleBlockId=null,d.blockIdle=function(e){d.$idleBlockId&&clearTimeout(d.$idleBlockId),d.$idleBlocked=!0,d.$idleBlockId=setTimeout(function(){d.$idleBlocked=!1},e||100)},d.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),d.nextFrame?d.nextFrame=d.nextFrame.bind(window):d.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/range",["require","exports","module"],function(e,t,i){"use strict";function o(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}}(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t=e.end,i=e.start,n=this.compare(t.row,t.column);return 1==n?1==(n=this.compare(i.row,i.column))?2:0==n?1:0:-1==n?-2:-1==(n=this.compare(i.row,i.column))?-1:1==n?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row!==e||t<=this.end.column?0:1:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){var i,n;return this.end.row>t?i={row:t+1,column:0}:this.end.row<e&&(i={row:e,column:0}),this.start.row>t?n={row:t+1,column:0}:this.start.row<e&&(n={row:e,column:0}),o.fromPoints(n||this.start,i||this.end)},this.extend=function(e,t){var i,n,r=this.compare(e,t);return 0==r?this:(-1==r?i={row:e,column:t}:n={row:e,column:t},o.fromPoints(i||this.start,n||this.end))},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return o.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new o(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new o(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),i=e.documentToScreenPosition(this.end);return new o(t.row,t.column,i.row,i.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(o.prototype),o.fromPoints=function(e,t){return new o(e.row,e.column,t.row,t.column)},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=o}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t,i){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";0<t;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};var n=/^\s\s*/,r=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(n,"")},t.stringTrimRight=function(e){return e.replace(r,"")},t.copyObject=function(e){var t={};for(var i in e)t[i]=e[i];return t},t.copyArray=function(e){for(var t=[],i=0,n=e.length;i<n;i++)e[i]&&"object"==typeof e[i]?t[i]=this.copyObject(e[i]):t[i]=e[i];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var i;if(Array.isArray(t)){i=[];for(var n=0;n<t.length;n++)i[n]=e(t[n]);return i}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var n in i={},t)i[n]=e(t[n]);return i},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var i in e)t[i]=e[i];return t},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return(""+e).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){function t(){i=null,e()}var i=null,n=function(e){return n.cancel(),i=setTimeout(t,e||0),n};return(n.schedule=n).call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(i),i=null,n},n.isPending=function(){return i},n},t.delayedCall=function(e,t){function i(){r=null,e()}function n(e){null==r&&(r=setTimeout(i,e||t))}var r=null;return n.delay=function(e){r&&clearTimeout(r),r=setTimeout(i,e||t)},(n.schedule=n).call=function(){this.cancel(),e()},n.cancel=function(){r&&clearTimeout(r),r=null},n.isPending=function(){return r},n}}),ace.define("ace/clipboard",["require","exports","module"],function(e,t,i){"use strict";var n;i.exports={lineMode:!1,pasteCancelled:function(){return!!(n&&n>Date.now()-50)||(n=!1)},cancel:function(){n=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(e,t,i){"use strict";var L=e("../lib/event"),B=e("../lib/useragent"),W=e("../lib/dom"),O=e("../lib/lang"),N=e("../clipboard"),G=B.isChrome<18,H=B.isIE,P=63<B.isChrome,V=e("../lib/keys"),F=V.KEY_MODS,Z=B.isIOS,M=Z?/\s/:/\n/,j=B.isMobile;t.TextInput=function(e,u){var g=W.createElement("textarea");g.className="ace_text-input",g.setAttribute("wrap","off"),g.setAttribute("autocorrect","off"),g.setAttribute("autocapitalize","off"),g.setAttribute("spellcheck",!1),g.style.opacity="0",e.insertBefore(g,e.firstChild);var c=!1,p=!1,h=!1,m=!1,l="";j||(g.style.fontSize="1px");var f=!1,t=!1,C="",v=0,I=0,A=0;try{var d=document.activeElement===g}catch(e){}L.addListener(g,"blur",function(e){t||(u.onBlur(e),d=!1)},u),L.addListener(g,"focus",function(e){if(!t){if(d=!0,B.isEdge)try{if(!document.hasFocus())return}catch(e){}u.onFocus(e),B.isEdge?setTimeout(b):b()}},u),this.$focusScroll=!1,this.focus=function(){if(l||P||"browser"==this.$focusScroll)return g.focus({preventScroll:!0});var e=g.style.top;g.style.position="fixed",g.style.top="0px";try{var t=0!=g.getBoundingClientRect().top}catch(e){return}var i=[];if(t)for(var n=g.parentElement;n&&1==n.nodeType;)i.push(n),n.setAttribute("ace_nocontext",!0),n=!n.parentElement&&n.getRootNode?n.getRootNode().host:n.parentElement;g.focus({preventScroll:!0}),t&&i.forEach(function(e){e.removeAttribute("ace_nocontext")}),setTimeout(function(){g.style.position="","0px"==g.style.top&&(g.style.top=e)},0)},this.blur=function(){g.blur()},this.isFocused=function(){return d},u.on("beforeEndOperation",function(){var e,t=u.curOp,i=t&&t.command&&t.command.name;"insertstring"!=i&&(e=i&&(t.docChanged||t.selectionChanged),h&&e&&(C=g.value="",k()),b())});var b=Z?function(e){var t,i;!d||c&&!e||m||((t="\n ab"+(e=e||"")+"cde fg\n")!=g.value&&(g.value=C=t),i=4+(e.length||(u.selection.isEmpty()?0:1)),4==v&&I==i||g.setSelectionRange(4,i),v=4,I=i)}:function(){if(!h&&!m&&(d||w)){h=!0;var e,t,i,n,r,o=0,s=0,a="";u.session&&(t=(e=u.selection).getRange(),i=e.cursor.row,o=t.start.column,s=t.end.column,a=u.session.getLine(i),t.start.row!=i?(n=u.session.getLine(i-1),o=t.start.row<i-1?0:o,s+=n.length+1,a=n+"\n"+a):t.end.row!=i?(r=u.session.getLine(i+1),s=t.end.row>i+1?r.length:s,s+=a.length+1,a=a+"\n"+r):j&&0<i&&(a="\n"+a,s+=1,o+=1),400<a.length&&(o<400&&s<400?a=a.slice(0,400):(a="\n",o==s?o=s=0:(o=0,s=1))));var l=a+"\n\n";if(l!=C&&(g.value=C=l,v=I=l.length),w&&(v=g.selectionStart,I=g.selectionEnd),I!=s||v!=o||g.selectionEnd!=I)try{g.setSelectionRange(o,s),v=o,I=s}catch(e){}h=!1}};this.resetSelection=b,d&&u.onFocus();var i=null;this.setInputHandler=function(e){i=e};function n(e,t){if(w=w&&!1,p)return b(),e&&u.onPaste(e),p=!1,"";for(var i=g.selectionStart,n=g.selectionEnd,r=v,o=C.length-I,s=e,a=e.length-i,l=e.length-n,c=0;0<r&&C[c]==e[c];)c++,r--;for(s=s.slice(c),c=1;0<o&&C.length-c>v-1&&C[C.length-c]==e[e.length-c];)c++,o--;a-=c-1,l-=c-1;var h=s.length-c+1;if(h<0&&(r=-h,h=0),s=s.slice(0,h),!(t||s||a||r||o||l))return"";var d=!(m=!0);return B.isAndroid&&". "==s&&(s="  ",d=!0),s&&!r&&!o&&!a&&!l||f?u.onTextInput(s):u.onTextInput(s,{extendLeft:r,extendRight:o,restoreStart:a,restoreEnd:l}),m=!1,C=e,v=i,I=n,A=l,d?"\n":s}function r(e){if(h)return x();if(e&&e.inputType){if("historyUndo"==e.inputType)return u.execCommand("undo");if("historyRedo"==e.inputType)return u.execCommand("redo")}var t=g.value,i=n(t,!0);(500<t.length||M.test(i)||j&&v<1&&v==I)&&b()}function o(e,t){var i=u.getCopyText();if(!i)return L.preventDefault(e);S(e,i)?(Z&&(b(i),c=i,setTimeout(function(){c=!1},10)),t?u.onCut():u.onCopy(),L.preventDefault(e)):(c=!0,g.value=i,g.select(),setTimeout(function(){c=!1,b(),t?u.onCut():u.onCopy()}))}function s(e){o(e,!0)}function a(e){o(e,!1)}function y(e){var t=S(e);N.pasteCancelled()||("string"==typeof t?(t&&u.onPaste(t,e),B.isIE&&setTimeout(b),L.preventDefault(e)):(g.value="",p=!0))}var w=!(this.getInputHandler=function(){return i}),S=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!G){var r=H||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return S(e,t,!0)}}};L.addCommandKeyListener(g,u.onCommandKey.bind(u),u),L.addListener(g,"select",function(e){var t;h||(c?c=!1:0===(t=g).selectionStart&&t.selectionEnd>=C.length&&t.value===C&&C&&t.selectionEnd!==I?(u.selectAll(),b()):j&&g.selectionStart!=v&&b())},u),L.addListener(g,"input",r,u),L.addListener(g,"cut",s,u),L.addListener(g,"copy",a,u),L.addListener(g,"paste",y,u),"oncut"in g&&"oncopy"in g&&"onpaste"in g||L.addListener(e,"keydown",function(e){if((!B.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:a(e);break;case 86:y(e);break;case 88:s(e)}},u);var x=function(){var e;if(h&&u.onCompositionUpdate&&!u.$readOnly)return f?E():void(h.useTextareaForIME?u.onCompositionUpdate(g.value):(e=g.value,n(e),h.markerRange&&(h.context&&(h.markerRange.start.column=h.selectionStart=h.context.compositionStartOffset),h.markerRange.end.column=h.markerRange.start.column+I-h.selectionStart+A)))},k=function(e){u.onCompositionEnd&&!u.$readOnly&&(h=!1,u.onCompositionEnd(),u.off("mousedown",E),e&&r())};function E(){t=!0,g.blur(),g.focus(),t=!1}var R,_=O.delayedCall(x,50).schedule.bind(null,null);function T(){clearTimeout(R),R=setTimeout(function(){l&&(g.style.cssText=l,l=""),u.renderer.$isMousePressed=!1,u.renderer.$keepTextAreaAtCursor&&u.renderer.$moveTextAreaToCursor()},0)}L.addListener(g,"compositionstart",function(e){var t;h||!u.onCompositionStart||u.$readOnly||(h={},f||(e.data&&(h.useTextareaForIME=!1),setTimeout(x,0),u._signal("compositionStart"),u.on("mousedown",E),(t=u.getSelectionRange()).end.row=t.start.row,t.end.column=t.start.column,h.markerRange=t,h.selectionStart=v,u.onCompositionStart(h),h.useTextareaForIME?(C=g.value="",I=v=0):(g.msGetInputContext&&(h.context=g.msGetInputContext()),g.getInputContext&&(h.context=g.getInputContext()))))},u),L.addListener(g,"compositionupdate",x,u),L.addListener(g,"keyup",function(e){27==e.keyCode&&g.value.length<g.selectionStart&&(h||(C=g.value),v=I=-1,b()),_()},u),L.addListener(g,"keydown",_,u),L.addListener(g,"compositionend",k,u),this.getElement=function(){return g},this.setCommandMode=function(e){f=e,g.readOnly=!1},this.setReadOnly=function(e){f||(g.readOnly=e)},this.setCopyWithEmptySelection=function(e){},this.onContextMenu=function(e){w=!0,b(),u._emit("nativecontextmenu",{target:u,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){l=l||g.style.cssText,g.style.cssText=(t?"z-index:100000;":"")+(B.isIE?"opacity:0.1;":"")+"text-indent: -"+(v+I)*u.renderer.characterWidth*.5+"px;";function i(e){W.translate(g,e.clientX-s-2,Math.min(e.clientY-o-2,a))}var n=u.container.getBoundingClientRect(),r=W.computedStyle(u.container),o=n.top+(parseInt(r.borderTopWidth)||0),s=n.left+(parseInt(n.borderLeftWidth)||0),a=n.bottom-o-g.clientHeight-2;i(e),"mousedown"==e.type&&(u.renderer.$isMousePressed=!0,clearTimeout(R),B.isWin&&L.capture(u.container,i,T))},this.onContextMenuClose=T;function $(e){u.textInput.onContextMenu(e),T()}L.addListener(g,"mouseup",$,u),L.addListener(g,"mousedown",function(e){e.preventDefault(),T()},u),L.addListener(u.renderer.scroller,"contextmenu",$,u),L.addListener(g,"contextmenu",$,u),Z&&function(s,a){var t=null,l=!1;a.addEventListener("keydown",function(e){t&&clearTimeout(t),l=!0},!0),a.addEventListener("keyup",function(e){t=setTimeout(function(){l=!1},100)},!0);function e(e){var t,i,n,r,o;document.activeElement===a&&(l||h||s.$mouseHandler.isMousePressed||c||(t=a.selectionStart,i=a.selectionEnd,n=null,(r=0)==t?n=V.up:1==t?n=V.home:I<i&&"\n"==C[i]?n=V.end:t<v&&" "==C[t-1]?(n=V.left,r=F.option):t<v||t==v&&I!=v&&t==i?n=V.left:I<i&&2<C.slice(0,i).split("\n").length?n=V.down:I<i&&" "==C[i-1]?(n=V.right,r=F.option):(I<i||i==I&&I!=v&&t==i)&&(n=V.right),t!==i&&(r|=F.shift),n&&(!s.onCommandKey({},r,n)&&s.commands&&(n=V.keyCodeToString(n),(o=s.commands.findKeyCommand(r,n))&&s.execCommand(o)),v=t,I=i,b(""))))}document.addEventListener("selectionchange",e),s.on("destroy",function(){document.removeEventListener("selectionchange",e)})}(u,g)},t.$setUserAgentForTests=function(e,t){j=e,Z=t}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(e,t,i){"use strict";var o=e("../lib/useragent");function n(t){t.$clickSelection=null;var e=t.editor;e.setDefaultHandler("mousedown",this.onMouseDown.bind(t)),e.setDefaultHandler("dblclick",this.onDoubleClick.bind(t)),e.setDefaultHandler("tripleclick",this.onTripleClick.bind(t)),e.setDefaultHandler("quadclick",this.onQuadClick.bind(t)),e.setDefaultHandler("mousewheel",this.onMouseWheel.bind(t));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(e){t[e]=this[e]},this),t.selectByLines=this.extendSelectionBy.bind(t,"getLineRange"),t.selectByWords=this.extendSelectionBy.bind(t,"getWordRange")}function l(e,t){return(e.start.row==e.end.row?2*t.column-e.start.column-e.end.column:e.start.row!=e.end.row-1||e.start.column||e.end.column?2*t.row-e.start.row-e.end.row:t.column-4)<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}(function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition();this.mousedownEvent=e;var n=this.editor,r=e.getButton();return 0!==r?(!n.getSelectionRange().isEmpty()&&1!=r||n.selection.moveToPosition(i),void(2==r&&(n.textInput.onContextMenu(e.domEvent),o.isMozilla||e.preventDefault()))):(this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimeout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,1<e.domEvent._clicks),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e)))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"))},this.select=function(){var e,t,i,n=this.editor,r=n.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(i=-1==(e=this.$clickSelection.comparePoint(r))?this.$clickSelection.end:1==e?this.$clickSelection.start:(r=(t=l(this.$clickSelection,r)).cursor,t.anchor),n.selection.setSelectionAnchor(i.row,i.column)),n.selection.selectToPosition(r),n.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i,n,r,o=this.editor,s=o.renderer.screenToTextCoordinates(this.x,this.y),a=o.selection[e](s.row,s.column);this.$clickSelection&&(t=this.$clickSelection.comparePoint(a.start),i=this.$clickSelection.comparePoint(a.end),-1==t&&i<=0?(r=this.$clickSelection.end,a.end.row==s.row&&a.end.column==s.column||(s=a.start)):1==i&&0<=t?(r=this.$clickSelection.start,a.start.row==s.row&&a.start.column==s.column||(s=a.end)):r=-1==t&&1==i?(s=a.end,a.start):(s=(n=l(this.$clickSelection,s)).cursor,n.anchor),o.selection.setSelectionAnchor(r.row,r.column)),o.selection.selectToPosition(s),o.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e,t,i,n,r=(e=this.mousedownEvent.x,t=this.mousedownEvent.y,i=this.x,n=this.y,Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))),o=Date.now();(0<r||o-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),i=this.editor,n=i.session.getBracketRange(t);n?(n.isEmpty()&&(n.start.column--,n.end.column++),this.setState("select")):(n=i.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=n,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),i=this.editor;this.setState("selectByLines");var n=i.getSelectionRange();n.isMultiLine()&&n.contains(t.row,t.column)?(this.$clickSelection=i.selection.getLineRange(n.start.row),this.$clickSelection.end=i.selection.getLineRange(n.end.row).end):this.$clickSelection=i.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var i=this.$lastScroll,n=e.domEvent.timeStamp,r=n-i.t,o=r?e.wheelX/r:i.vx,s=r?e.wheelY/r:i.vy;r<550&&(o=(o+i.vx)/2,s=(s+i.vy)/2);var a=Math.abs(o/s),l=!1;return 1<=a&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(l=!0),a<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(l=!0),l?i.allowed=n:n-i.allowed<550&&(Math.abs(o)<=1.5*Math.abs(i.vx)&&Math.abs(s)<=1.5*Math.abs(i.vy)?(l=!0,i.allowed=n):i.allowed=0),i.t=n,i.vx=o,i.vy=s,l?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}}}).call(n.prototype),t.DefaultHandlers=n}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t,i){"use strict";e("./lib/oop");var n=e("./lib/dom");function r(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}(function(){this.$init=function(){return this.$element=n.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){this.getElement().textContent=e},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){n.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(r.prototype),t.Tooltip=r}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t,i){"use strict";var n=e("../lib/dom"),r=e("../lib/oop"),o=e("../lib/event"),s=e("../tooltip").Tooltip;function p(e){s.call(this,e)}r.inherits(p,s),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),o=this.getHeight();i<(e+=15)+r&&(e-=e+r-i),n<(t+=15)+o&&(t-=20+o),s.prototype.setPosition.call(this,e,t)}}.call(p.prototype),t.GutterHandler=function(s){var i,a,l,c=s.editor,h=c.renderer.$gutterLayer,d=new p(c.container);function u(){i=i&&clearTimeout(i),l&&(d.hide(),l=null,c._signal("hideGutterTooltip",d),c.off("mousewheel",u))}function g(e){d.setPosition(e.x,e.y)}s.editor.setDefaultHandler("guttermousedown",function(e){if(c.isFocused()&&0==e.getButton()&&"foldWidgets"!=h.getRegion(e)){var t=e.getDocumentPosition().row,i=c.session.selection;if(e.getShiftKey())i.selectTo(t,0);else{if(2==e.domEvent.detail)return c.selectAll(),e.preventDefault();s.$clickSelection=c.selection.getLineRange(t)}return s.setState("selectByLines"),s.captureMouse(e),e.preventDefault()}}),s.editor.setDefaultHandler("guttermousemove",function(e){var t=e.domEvent.target||e.domEvent.srcElement;if(n.hasCssClass(t,"ace_fold-widget"))return u();l&&s.$tooltipFollowsMouse&&g(e),a=e,i=i||setTimeout(function(){i=null,(a&&!s.isMousePressed?function(){var e,t,i=a.getDocumentPosition().row,n=h.$annotations[i];if(!n)return u();if(i==c.session.getLength()){var r=c.renderer.pixelToScreenCoordinates(0,a.y).row,o=a.$pos;if(r>c.session.documentToScreenRow(o.row,o.column))return u()}l!=n&&(l=n.text.join("<br/>"),d.setHtml(l),d.show(),c._signal("showGutterTooltip",d),c.on("mousewheel",u),s.$tooltipFollowsMouse?g(a):(e=a.domEvent.target.getBoundingClientRect(),(t=d.getElement().style).left=e.right+"px",t.top=e.bottom+"px"))}:u)()},50)}),o.addListener(c.renderer.$gutter,"mouseout",function(e){a=null,l&&!i&&(i=setTimeout(function(){i=null,u()},50))},c),c.on("changeSession",u)}}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){n.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){n.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e,t=this.editor.getSelectionRange();return t.isEmpty()?this.$inSelection=!1:(e=this.getDocumentPosition(),this.$inSelection=t.contains(e.row,e.column)),this.$inSelection},this.getButton=function(){return n.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var w=e("../lib/dom"),S=e("../lib/event"),x=e("../lib/useragent");function n(t){var g=t.editor,n=w.createElement("img");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",x.isOpera&&(n.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(e){t[e]=this[e]},this),g.on("mousedown",this.onMouseDown.bind(t));var i,p,m,e,r,s,o,a,f,l,c,h=g.container,d=0;function u(){var e,t,i,n,r,o=s;s=g.renderer.screenToTextCoordinates(p,m),e=s,t=o,i=Date.now(),n=!t||e.row!=t.row,r=!t||e.column!=t.column,!l||n||r?(g.moveCursorToPosition(e),l=i,c={x:p,y:m}):5<k(c.x,c.y,p,m)?l=null:200<=i-l&&(g.renderer.scrollCursorIntoView(),l=null),function(e,t){var i=Date.now(),n=g.renderer.layerConfig.lineHeight,r=g.renderer.layerConfig.characterWidth,o=g.renderer.scroller.getBoundingClientRect(),s={x:{left:p-o.left,right:o.right-p},y:{top:m-o.top,bottom:o.bottom-m}},a=Math.min(s.x.left,s.x.right),l=Math.min(s.y.top,s.y.bottom),c={row:e.row,column:e.column};a/r<=2&&(c.column+=s.x.left<s.x.right?-3:2),l/n<=1&&(c.row+=s.y.top<s.y.bottom?-1:1);var h=e.row!=c.row,d=e.column!=c.column,u=!t||e.row!=t.row;h||d&&!u?f?200<=i-f&&g.renderer.scrollCursorIntoView(c):f=i:f=null}(s,o)}function C(){r=g.selection.toOrientedRange(),i=g.session.addMarker(r,"ace_selection",g.getSelectionStyle()),g.clearSelection(),g.isFocused()&&g.renderer.$cursorLayer.setBlinking(!1),clearInterval(e),u(),e=setInterval(u,20),d=0,S.addListener(document,"mousemove",A)}function v(){clearInterval(e),g.session.removeMarker(i),i=null,g.selection.fromOrientedRange(r),g.isFocused()&&!a&&g.$resetCursorStyle(),d=0,l=f=s=r=null,S.removeListener(document,"mousemove",A)}this.onDragStart=function(e){if(this.cancelDrag||!h.draggable){var t=this;return setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault()}r=g.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=g.getReadOnly()?"copy":"copyMove",x.isOpera&&(g.container.appendChild(n),n.scrollTop=0),i.setDragImage&&i.setDragImage(n,0,0),x.isOpera&&g.container.removeChild(n),i.clearData(),i.setData("Text",g.session.getTextRange()),a=!0,this.setState("drag")},this.onDragEnd=function(e){var t;h.draggable=!1,a=!1,this.setState(null),g.getReadOnly()||(t=e.dataTransfer.dropEffect,o||"move"!=t||g.session.remove(g.getSelectionRange()),g.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return p=e.clientX,m=e.clientY,i||C(),d++,e.dataTransfer.dropEffect=o=y(e),S.preventDefault(e)},this.onDragOver=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return p=e.clientX,m=e.clientY,i||(C(),d++),null!==I&&(I=null),e.dataTransfer.dropEffect=o=y(e),S.preventDefault(e)},this.onDragLeave=function(e){if(--d<=0&&i)return v(),o=null,S.preventDefault(e)},this.onDrop=function(e){if(s){var t=e.dataTransfer;if(a)switch(o){case"move":r=r.contains(s.row,s.column)?{start:s,end:s}:g.moveText(r,s);break;case"copy":r=g.moveText(r,s,!0)}else{var i=t.getData("Text");r={start:s,end:g.session.insert(s,i)},g.focus(),o=null}return v(),S.preventDefault(e)}},S.addListener(h,"dragstart",this.onDragStart.bind(t),g),S.addListener(h,"dragend",this.onDragEnd.bind(t),g),S.addListener(h,"dragenter",this.onDragEnter.bind(t),g),S.addListener(h,"dragover",this.onDragOver.bind(t),g),S.addListener(h,"dragleave",this.onDragLeave.bind(t),g),S.addListener(h,"drop",this.onDrop.bind(t),g);var I=null;function A(){null==I&&(I=setTimeout(function(){null!=I&&i&&v()},20))}function b(e){var t=e.types;return!t||Array.prototype.some.call(t,function(e){return"text/plain"==e||"Text"==e})}function y(e){var t=["copy","copymove","all","uninitialized"],i=x.isMac?e.altKey:e.ctrlKey,n="uninitialized";try{n=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return i&&0<=t.indexOf(n)?r="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(n)?r="move":0<=t.indexOf(n)&&(r="copy"),r}}function k(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=x.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;x.isIE&&"dragReady"==this.state&&3<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop(),"dragWait"===this.state&&0<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,i=e.inSelection(),n=e.getButton();if(1===(e.domEvent.detail||1)&&0===n&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;"unselectable"in r&&(r.unselectable="on"),t.getDragDelay()?(x.isWebKit&&(this.cancelDrag=!0,t.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(n.prototype),t.DragdropHandler=n}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(e,t,i){"use strict";var B=e("./mouse_event").MouseEvent,n=e("../lib/event"),l=e("../lib/dom");t.addTouchListeners=function(e,I){var A,b,y,w,S,t,x,k,s,E="scroll",R=0,_=0,T=0,$=0;function o(){function t(e){var t,i,n=e.target.getAttribute("action");if("more"==n||!o)return o=!o,t=I.getCopyText(),i=I.session.getUndoManager().hasUndo(),void s.replaceChild(l.buildDom(o?["span",!t&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],t&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],t&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],r&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],i&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),s.firstChild);"paste"==n?r.readText().then(function(e){I.execCommand(n,e)}):n&&("cut"!=n&&"copy"!=n||(r?r.writeText(I.getCopyText()):document.execCommand("copy")),I.execCommand(n)),s.firstChild.style.display="none",o=!1,"openCommandPallete"!=n&&I.focus()}var r=window.navigator&&window.navigator.clipboard,o=!1;s=l.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){E="menu",e.stopPropagation(),e.preventDefault(),I.textInput.focus()},ontouchend:function(e){e.stopPropagation(),e.preventDefault(),t(e)},onclick:t},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],I.container)}function i(){s||o();var e=I.selection.cursor,t=I.renderer.textToScreenCoordinates(e.row,e.column),i=I.renderer.textToScreenCoordinates(0,0).pageX,n=I.renderer.scrollLeft,r=I.container.getBoundingClientRect();s.style.top=t.pageY-r.top-3+"px",t.pageX-r.left<r.width-70?(s.style.left="",s.style.right="10px"):(s.style.right="",s.style.left=i+n-r.left+"px"),s.style.display="",s.firstChild.style.display="none",I.on("input",a)}function a(e){s&&(s.style.display="none"),I.off("input",a)}function L(){S=null,clearTimeout(S);var e=I.selection.getRange(),t=e.contains(x.row,x.column);!e.isEmpty()&&t||(I.selection.moveToPosition(x),I.selection.selectWord()),E="wait",i()}n.addListener(e,"contextmenu",function(e){k&&I.textInput.getElement().focus()},I),n.addListener(e,"touchstart",function(e){var t=e.touches;if(S||1<t.length)return clearTimeout(S),S=null,y=-1,void(E="zoom");k=I.$mouseHandler.isMousePressed=!0;var i=I.renderer.layerConfig.lineHeight,n=I.renderer.layerConfig.lineHeight,r=e.timeStamp;w=r;var o=t[0],s=o.clientX,a=o.clientY;Math.abs(A-s)+Math.abs(b-a)>i&&(y=-1),A=e.clientX=s,b=e.clientY=a,T=$=0;var l=new B(e,I);if(x=l.getDocumentPosition(),r-y<500&&1==t.length&&!R)_++,e.preventDefault(),e.button=0,function(){S=null,clearTimeout(S),I.selection.moveToPosition(x);var e=2<=_?I.selection.getLineRange(x.row):I.session.getBracketRange(x);e&&!e.isEmpty()?I.selection.setRange(e):I.selection.selectWord(),E="wait"}();else{_=0;var c=I.selection.cursor,h=I.selection.isEmpty()?c:I.selection.anchor,d=I.renderer.$cursorLayer.getPixelPosition(c,!0),u=I.renderer.$cursorLayer.getPixelPosition(h,!0),g=I.renderer.scroller.getBoundingClientRect(),p=I.renderer.layerConfig.offset,m=I.renderer.scrollLeft,f=function(e,t){return(e/=n)*e+(t=t/i-.75)*t};if(e.clientX<g.left)return void(E="zoom");var C=f(e.clientX-g.left-d.left+m,e.clientY-g.top-d.top+p),v=f(e.clientX-g.left-u.left+m,e.clientY-g.top-u.top+p);C<3.5&&v<3.5&&(E=v<C?"cursor":"anchor"),E=v<3.5?"anchor":C<3.5?"cursor":"scroll",S=setTimeout(L,450)}y=r},I),n.addListener(e,"touchend",function(e){k=I.$mouseHandler.isMousePressed=!1,t&&clearInterval(t),"zoom"==E?(E="",R=0):S?(I.selection.moveToPosition(x),R=0,i()):"scroll"==E?(R+=60,t=setInterval(function(){R--<=0&&(clearInterval(t),t=null),Math.abs(T)<.01&&(T=0),Math.abs($)<.01&&($=0),R<20&&(T*=.9),R<20&&($*=.9);var e=I.session.getScrollTop();I.renderer.scrollBy(10*T,10*$),e==I.session.getScrollTop()&&(R=0)},10),a()):i(),clearTimeout(S),S=null},I),n.addListener(e,"touchmove",function(e){S&&(clearTimeout(S),S=null);var t=e.touches;if(!(1<t.length||"zoom"==E)){var i=t[0],n=A-i.clientX,r=b-i.clientY;if("wait"==E){if(!(4<n*n+r*r))return e.preventDefault();E="cursor"}A=i.clientX,b=i.clientY,e.clientX=i.clientX,e.clientY=i.clientY;var o,s,a=e.timeStamp,l=a-w;w=a,"scroll"==E?((o=new B(e,I)).speed=1,o.wheelX=n,o.wheelY=r,10*Math.abs(n)<Math.abs(r)&&(n=0),10*Math.abs(r)<Math.abs(n)&&(r=0),0!=l&&(T=n/l,$=r/l),I._emit("mousewheel",o),o.propagationStopped||(T=$=0)):(s=new B(e,I).getDocumentPosition(),"cursor"==E?I.selection.moveCursorToPosition(s):"anchor"==E&&I.selection.setSelectionAnchor(s.row,s.column),I.renderer.scrollCursorIntoView(s),e.preventDefault())}},I)}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,i){var t=r.getDocumentHead(),n=document.createElement("script");n.src=e,t.appendChild(n),n.onload=n.onreadystatechange=function(e,t){!t&&n.readyState&&"loaded"!=n.readyState&&"complete"!=n.readyState||(n=n.onload=n.onreadystatechange=null,t||i())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,i){"use strict";function o(){this.propagationStopped=!0}function s(){this.defaultPrevented=!0}var n={};n._emit=n._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],n=this._defaultHandlers[e];if(i.length||n){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=o),t.preventDefault||(t.preventDefault=s),i=i.slice();for(var r=0;r<i.length&&(i[r](t,this),!t.propagationStopped);r++);return n&&!t.defaultPrevented?n(t,this):void 0}},n._signal=function(e,t){var i=(this._eventRegistry||{})[e];if(i){i=i.slice();for(var n=0;n<i.length;n++)i[n](t,this)}},n.once=function(t,i){var n=this;if(this.on(t,function e(){n.off(t,e),i.apply(null,arguments)}),!i)return new Promise(function(e){i=e})},n.setDefaultHandler=function(e,t){var i,n,r,o=this._defaultHandlers;(o=o||(this._defaultHandlers={_disabled_:{}}))[e]&&(i=o[e],(n=o._disabled_[e])||(o._disabled_[e]=n=[]),n.push(i),-1!=(r=n.indexOf(t))&&n.splice(r,1)),o[e]=t},n.removeDefaultHandler=function(e,t){var i,n,r=this._defaultHandlers;r&&(i=r._disabled_[e],r[e]==t?i&&this.setDefaultHandler(e,i.pop()):!i||-1!=(n=i.indexOf(t))&&i.splice(n,1))},n.on=n.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return-1==(n=n||(this._eventRegistry[e]=[])).indexOf(t)&&n[i?"unshift":"push"](t),t},n.off=n.removeListener=n.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var i,n=this._eventRegistry[e];!n||-1!==(i=n.indexOf(t))&&n.splice(i,1)},n.removeAllListeners=function(e){e||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[e]=void 0),this._defaultHandlers&&(this._defaultHandlers[e]=void 0)},t.EventEmitter=n}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){var r=e("./oop"),n=e("./event_emitter").EventEmitter,o={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(e){var t,i={};return e?Array.isArray(e)||(i=e,e=Object.keys(i)):(t=this.$options,e=Object.keys(t).filter(function(e){return!t[e].hidden})),e.forEach(function(e){i[e]=this.getOption(e)},this),i},setOption:function(e,t){if(this["$"+e]!==t){var i=this.$options[e];if(!i)return s('misspelled option "'+e+'"');if(i.forwardTo)return this[i.forwardTo]&&this[i.forwardTo].setOption(e,t);i.handlesSet||(this["$"+e]=t),i&&i.set&&i.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:s('misspelled option "'+e+'"')}};function s(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function a(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}function l(){this.$defaultOptions={}}(function(){r.implement(this,n),this.defineOptions=function(i,e,n){return i.$options||(this.$defaultOptions[e]=i.$options={}),Object.keys(n).forEach(function(e){var t=n[e];"string"==typeof t&&(t={forwardTo:t}),t.name||(t.name=e),"initialValue"in(i.$options[t.name]=t)&&(i["$"+t.name]=t.initialValue)}),r.implement(i,o),this},this.resetOptions=function(i){Object.keys(i.$options).forEach(function(e){var t=i.$options[e];"value"in t&&i.setOption(e,t.value)})},this.setDefaultValue=function(e,t,i){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][t])break;if(!this.$defaultOptions[e][t])return!1}var n=this.$defaultOptions[e]||(this.$defaultOptions[e]={});n[t]&&(n.forwardTo?this.setDefaultValue(n.forwardTo,t,i):n[t].value=i)},this.setDefaultValues=function(t,i){Object.keys(i).forEach(function(e){this.setDefaultValue(t,e,i[e])},this)},this.warn=s,this.reportError=a}).call(l.prototype),t.AppConfig=l}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],function(p,m,f){var e=p("./lib/lang"),o=(p("./lib/oop"),p("./lib/net")),t=p("./lib/app_config").AppConfig;f.exports=m=new t;var C=function(){return this||"undefined"!=typeof window&&window}(),v={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1};m.get=function(e){if(!v.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return v[e]},m.set=function(e,t){if(v.hasOwnProperty(e))v[e]=t;else if(0==this.setDefaultValue("",e,t))throw new Error("Unknown config key: "+e)},m.all=function(){return e.copyObject(v)},m.$modes={},m.moduleUrl=function(e,t){if(v.$moduleUrls[e])return v.$moduleUrls[e];var i,n=e.split("/"),r="snippets"==(t=t||n[n.length-2]||"")?"/":"-",o=n[n.length-1];"worker"==t&&"-"==r&&(i=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g"),o=o.replace(i,"")),(!o||o==t)&&1<n.length&&(o=n[n.length-2]);var s=v[t+"Path"];return null==s?s=v.basePath:"/"==r&&(t=r=""),s&&"/"!=s.slice(-1)&&(s+="/"),s+t+r+o+this.get("suffix")},m.setModuleUrl=function(e,t){return v.$moduleUrls[e]=t},m.$loading={},m.loadModule=function(i,e){var t,n;Array.isArray(i)&&(n=i[0],i=i[1]);try{t=p(i)}catch(e){}if(t&&!m.$loading[i])return e&&e(t);if(m.$loading[i]||(m.$loading[i]=[]),m.$loading[i].push(e),!(1<m.$loading[i].length)){function r(){p([i],function(t){m._emit("load.module",{name:i,module:t});var e=m.$loading[i];m.$loading[i]=null,e.forEach(function(e){e&&e(t)})})}if(!m.get("packaged"))return r();o.loadScript(m.moduleUrl(i,n),r),s()}};var s=function(){v.basePath||v.workerPath||v.modePath||v.themePath||Object.keys(v.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),s=function(){})};function i(e){if(C&&C.document){v.packaged=e||p.packaged||f.packaged||C.define&&I(23).packaged;for(var t={},i="",n=document.currentScript||document._currentScript,r=(n&&n.ownerDocument||document).getElementsByTagName("script"),o=0;o<r.length;o++){var s=r[o],a=s.src||s.getAttribute("src");if(a){for(var l=s.attributes,c=0,h=l.length;c<h;c++){var d=l[c];0===d.name.indexOf("data-ace-")&&(t[d.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(e,t){return t.toUpperCase()})]=d.value)}var u=a.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);u&&(i=u[1])}}for(var g in i&&(t.base=t.base||i,t.packaged=!0),t.basePath=t.base,t.workerPath=t.workerPath||t.base,t.modePath=t.modePath||t.base,t.themePath=t.themePath||t.base,delete t.base,t)void 0!==t[g]&&m.set(g,t[g])}}i(!0),m.init=i,m.version="1.4.12"}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(e,t,i){"use strict";function n(r){var o=this;function e(e){document.hasFocus&&document.hasFocus()&&(r.isFocused()||document.activeElement!=(r.textInput&&r.textInput.getElement()))||window.focus(),r.focus()}this.editor=r,new s(this),new a(this),new l(this);var t=r.renderer.getMouseEventTarget();h.addListener(t,"click",this.onMouseEvent.bind(this,"click"),r),h.addListener(t,"mousemove",this.onMouseMove.bind(this,"mousemove"),r),h.addMultiMouseDownListener([t,r.renderer.scrollBarV&&r.renderer.scrollBarV.inner,r.renderer.scrollBarH&&r.renderer.scrollBarH.inner,r.textInput&&r.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",r),h.addMouseWheelListener(r.container,this.onMouseWheel.bind(this,"mousewheel"),r),c(r.container,r);var i=r.renderer.$gutter;h.addListener(i,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),r),h.addListener(i,"click",this.onMouseEvent.bind(this,"gutterclick"),r),h.addListener(i,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),r),h.addListener(i,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),r),h.addListener(t,"mousedown",e,r),h.addListener(i,"mousedown",e,r),d.isIE&&r.renderer.scrollBarV&&(h.addListener(r.renderer.scrollBarV.element,"mousedown",e,r),h.addListener(r.renderer.scrollBarH.element,"mousedown",e,r)),r.on("mousemove",function(e){var t,i,n;o.state||o.$dragDelay||!o.$dragEnabled||(t=r.renderer.screenToTextCoordinates(e.x,e.y),i=r.session.selection.getRange(),n=r.renderer,!i.isEmpty()&&i.insideStart(t.row,t.column)?n.setCursorStyle("default"):n.setCursorStyle(""))},r)}var h=e("../lib/event"),d=e("../lib/useragent"),s=e("./default_handlers").DefaultHandlers,a=e("./default_gutter_handler").GutterHandler,u=e("./mouse_event").MouseEvent,l=e("./dragdrop_handler").DragdropHandler,c=e("./touch_handler").addTouchListeners,r=e("../config");(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new u(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new u(t,this.editor))},this.onMouseWheel=function(e,t){var i=new u(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var i=this.editor,n=this.editor.renderer;n.$isMousePressed=!0;function r(e){if(e){if(d.isWebKit&&!e.which&&s.releaseMouse)return s.releaseMouse();s.x=e.clientX,s.y=e.clientY,t&&t(e),s.mouseEvent=new u(e,s.editor),s.$mouseMoved=!0}}function o(e){i.off("beforeEndOperation",l),clearInterval(c),a(),s[s.state+"End"]&&s[s.state+"End"](e),s.state="",s.isMousePressed=n.$isMousePressed=!1,n.$keepTextAreaAtCursor&&n.$moveTextAreaToCursor(),s.$onCaptureMouseMove=s.releaseMouse=null,e&&s.onMouseEvent("mouseup",e),i.endOperation()}var s=this,a=function(){s[s.state]&&s[s.state](),s.$mouseMoved=!1};if(d.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){o(e)});var l=function(e){s.releaseMouse&&i.curOp.command.name&&i.curOp.selectionChanged&&(s[s.state+"End"]&&s[s.state+"End"](),s.state="",s.releaseMouse())};i.on("beforeEndOperation",l),i.startOperation({command:{name:"mouse"}}),s.$onCaptureMouseMove=r,s.releaseMouse=h.capture(this.editor.container,r,o);var c=setInterval(a,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var t=function(e){e&&e.domEvent&&"contextmenu"!=e.domEvent.type||(this.editor.off("nativecontextmenu",t),e&&e.domEvent&&h.stopEvent(e.domEvent))}.bind(this);setTimeout(t,10),this.editor.on("nativecontextmenu",t)},this.destroy=function(){this.releaseMouse&&this.releaseMouse()}}).call(n.prototype),r.defineOptions(n.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:d.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=n}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var o=e("../lib/dom");t.FoldHandler=function(s){s.on("click",function(e){var t=e.getDocumentPosition(),i=s.session,n=i.getFoldAt(t.row,t.column,1);n&&(e.getAccelKey()?i.removeFold(n):i.expandFold(n),e.stop());var r=e.domEvent&&e.domEvent.target;r&&o.hasCssClass(r,"ace_inline_button")&&o.hasCssClass(r,"ace_toggle_wrap")&&(i.setOption("wrap",!i.getUseWrapMode()),s.renderer.scrollCursorIntoView())}),s.on("gutterclick",function(e){var t,i;"foldWidgets"==s.renderer.$gutterLayer.getRegion(e)&&(t=e.getDocumentPosition().row,(i=s.session).foldWidgets&&i.foldWidgets[t]&&s.session.onFoldWidgetClick(t,e),s.isFocused()||s.focus(),e.stop())}),s.on("gutterdblclick",function(e){var t,i,n,r,o;"foldWidgets"==s.renderer.$gutterLayer.getRegion(e)&&(t=e.getDocumentPosition().row,(r=(n=(i=s.session).getParentFoldRangeData(t,!0)).range||n.firstRange)&&(t=r.start.row,(o=i.getFoldAt(t,i.getLine(t).length,1))?i.removeFold(o):(i.addFold("...",r),s.renderer.scrollCursorIntoView({row:r.start.row,column:0}))),e.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,i){"use strict";function n(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)}var r=e("../lib/keys"),l=e("../lib/event");(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){var i;e&&("function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e),-1!=(i=this.$handlers.indexOf(e))&&this.$handlers.splice(i,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor))},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var t=this.$data,i=t.editor;return this.$handlers.map(function(e){return e.getStatusText&&e.getStatusText(i,t)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,n){for(var r,o=!1,s=this.$editor.commands,a=this.$handlers.length;a--&&!((r=this.$handlers[a].handleKeyboard(this.$data,e,t,i,n))&&r.command&&((o="null"==r.command||s.exec(r.command,this.$editor,r.args,n))&&n&&-1!=e&&1!=r.passEvent&&1!=r.command.passEvent&&l.stopEvent(n),o)););return o||-1!=e||(r={command:"insertstring"},o=s.exec("insertstring",this.$editor,t)),o&&this.$editor._signal&&this.$editor._signal("keyboardActivity",r),o},this.onCommandKey=function(e,t,i){var n=r.keyCodeToString(i);return this.$callKeyboardHandlers(t,n,i,e)},this.onTextInput=function(e){return this.$callKeyboardHandlers(-1,e)}}).call(n.prototype),t.KeyBinding=n}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,l,t){"use strict";var m=0,f=0,C=!1,v=!1,I=!1,A=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],b=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],y=0,w=1,S=2,x=3,k=4,E=5,R=6,_=7,T=8,$=9,L=10,B=11,W=12,O=13,N=14,G=15,H=16,P=17,V=18,n=[V,V,V,V,V,V,V,V,V,R,E,R,T,E,V,V,V,V,V,V,V,V,V,V,V,V,V,V,E,E,E,R,T,k,k,B,B,B,k,k,k,k,k,L,$,L,$,$,S,S,S,S,S,S,S,S,S,S,$,k,k,k,k,k,k,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,k,k,k,k,k,k,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,k,k,k,k,V,V,V,V,V,V,E,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,V,$,k,B,B,B,B,k,k,k,k,y,k,k,V,k,k,B,B,S,S,k,y,k,k,k,S,y,k,k,k,k,k],r=[T,T,T,T,T,T,T,T,T,T,T,V,V,V,y,w,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,T,E,O,N,G,H,P,$,B,B,B,B,B,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,$,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,k,T];function c(e,t,i,n){var r,o,s,a,l=m?b:A,c=0,h=-1,d=null,u=null,g=[];if(!n)for(d=0,n=[];d<i;d++)n[d]=F(e[d]);for(f=m,I=v=C=!1,u=0;u<i;u++){if(r=c,g[u]=o=function(e,t,i,n){var r,o,s,a,l=t[n];switch(l){case y:case w:C=!1;case k:case x:return l;case S:return C?x:S;case _:return C=!0,w;case T:return k;case $:return n<1||n+1>=t.length||(r=i[n-1])!=S&&r!=x||(o=t[n+1])!=S&&o!=x?k:(C&&(o=x),o==r?o:k);case L:return(r=0<n?i[n-1]:E)==S&&n+1<t.length&&t[n+1]==S?S:k;case B:if(0<n&&i[n-1]==S)return S;if(C)return k;for(a=n+1,s=t.length;a<s&&t[a]==B;)a++;return a<s&&t[a]==S?S:k;case W:for(s=t.length,a=n+1;a<s&&t[a]==W;)a++;if(a<s){var c=e[n],h=1425<=c&&c<=2303||64286==c;if(r=t[a],h&&(r==w||r==_))return w}return n<1||(r=t[n-1])==E?k:i[n-1];case E:return v=!(C=!1),m;case R:return I=!0,k;case O:case N:case H:case P:case G:C=!1;case V:return k}}(e,n,g,u),a=240&(c=l[r][o]),c&=15,t[u]=s=l[c][5],0<a)if(16==a){for(d=h;d<u;d++)t[d]=1;h=-1}else h=-1;if(l[c][6])-1==h&&(h=u);else if(-1<h){for(d=h;d<u;d++)t[d]=s;h=-1}n[u]==E&&(t[u]=0),f|=s}if(I)for(d=0;d<i;d++)if(n[d]==R){t[d]=m;for(var p=d-1;0<=p&&n[p]==T;p--)t[p]=m}}function h(e,t,i){if(!(f<e))if(1!=e||1!=m||v)for(var n,r,o,s,a=i.length,l=0;l<a;){if(t[l]>=e){for(n=l+1;n<a&&t[n]>=e;)n++;for(r=l,o=n-1;r<o;r++,o--)s=i[r],i[r]=i[o],i[o]=s;l=n}l++}else i.reverse()}function F(e){var t=e.charCodeAt(0),i=t>>8;return 0==i?191<t?y:n[t]:5==i?/[\u0591-\u05f4]/.test(e)?w:y:6==i?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?W:/[\u0660-\u0669\u066b-\u066c]/.test(e)?x:1642==t?B:/[\u06f0-\u06f9]/.test(e)?S:_:32==i&&t<=8287?r[255&t]:254==i&&65136<=t?_:k}l.L=y,l.R=w,l.EN=S,l.ON_R=3,l.AN=4,l.R_H=5,l.B=6,l.RLE=7,l.DOT="·",l.doBidiReorder=function(e,t,i){if(e.length<2)return{};var n=e.split(""),r=new Array(n.length),o=new Array(n.length),s=[];m=i?1:0,c(n,s,n.length,t);for(var a=0;a<r.length;r[a]=a,a++);h(2,s,r),h(1,s,r);for(a=0;a<r.length-1;a++)t[a]===x?s[a]=l.AN:s[a]===w&&(t[a]>_&&t[a]<O||t[a]===k||t[a]===V)?s[a]=l.ON_R:0<a&&"ل"===n[a-1]&&/\u0622|\u0623|\u0625|\u0627/.test(n[a])&&(s[a-1]=s[a]=l.R_H,a++);n[n.length-1]===l.DOT&&(s[n.length-1]=l.B),"‫"===n[0]&&(s[0]=l.RLE);for(a=0;a<r.length;a++)o[a]=s[r[a]];return{logicalFromVisual:r,bidiLevels:o}},l.hasBidiCharacters=function(e,t){for(var i=!1,n=0;n<e.length;n++)t[n]=F(e.charAt(n)),i||t[n]!=w&&t[n]!=_&&t[n]!=x||(i=!0);return i},l.getVisualFromLogicalIdx=function(e,t){for(var i=0;i<t.logicalFromVisual.length;i++)if(t.logicalFromVisual[i]==e)return i;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(e,t,i){"use strict";function n(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=a,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=r.test(e.getValue())}var a=e("./lib/bidiutil"),l=e("./lib/lang"),r=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;(function(){this.isBidiRow=function(e,t,i){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,i),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&r.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e,t=0,i=this.session.$screenRowCache;return!i.length||0<=(e=this.session.$getRowCacheIndex(i,this.currentRow))&&(t=this.session.$docRowCache[e]),t},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var i,n=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-e&&(i=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===n;)n=i,e++;else e=this.currentRow;return e},this.updateRowLine=function(e,t){void 0===e&&(e=this.getDocumentRow());var i,n=e===this.session.getLength()-1?this.EOF:this.EOL;this.wrapIndent=0,this.line=this.session.getLine(e),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,this.session.$useWrapMode?((i=this.session.$wrapData[e])&&(void 0===t&&(t=this.getSplitIndex()),0<t&&i.length?(this.wrapIndent=i.indent,this.wrapOffset=this.wrapIndent*this.charWidths[a.L],this.line=t<i.length?this.line.substring(i[t-1],i[t]):this.line.substring(i[i.length-1])):this.line=this.line.substring(0,i[t])),t==i.length&&(this.line+=this.showInvisibles?n:a.DOT)):this.line+=this.showInvisibles?n:a.DOT;var r,o=this.session,s=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||o.isFullWidth(e.charCodeAt(0))?(r="\t"===e?o.getScreenTabSize(t+s):2,s+=r-1,l.stringRepeat(a.DOT,r)):e}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==a.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},this.updateBidiMap=function(){var e=[];a.hasBidiCharacters(this.line,e)||this.isRtlDir?this.bidiMap=a.doBidiReorder(this.line,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){var t,i;this.characterWidth!==e.$characterSize.width&&(this.fontMetrics=e,t=this.characterWidth=e.$characterSize.width,i=e.$measureCharWidth("ה"),this.charWidths[a.L]=this.charWidths[a.EN]=this.charWidths[a.ON_R]=t,this.charWidths[a.R]=this.charWidths[a.AN]=i,this.charWidths[a.R_H]=.45*i,this.charWidths[a.B]=this.charWidths[a.RLE]=0,this.currentRow=null)},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setContentWidth=function(e){this.contentWidth=e},this.isRtlLine=function(e){return!!this.$isRtl||(null!=e?this.session.getLine(e).charAt(0)==this.RLE:this.isRtlDir)},this.setRtlDirection=function(e,t){for(var i=e.getCursorPosition(),n=e.selection.getSelectionAnchor().row;n<=i.row;n++)t||e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE?t&&e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE&&e.session.doc.insert({column:0,row:n},e.session.$bidiHandler.RLE):e.session.doc.removeInLine(n,0,1)},this.getPosLeft=function(e){e-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,i=t<e?this.session.getOverwrite()?e:e-1:t,n=a.getVisualFromLogicalIdx(i,this.bidiMap),r=this.bidiMap.bidiLevels,o=0;!this.session.getOverwrite()&&e<=t&&r[n]%2!=0&&n++;for(var s=0;s<n;s++)o+=this.charWidths[r[s]];return!this.session.getOverwrite()&&t<e&&r[n]%2==0&&(o+=this.charWidths[r[n]]),this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(o+=this.rtlLineOffset),o},this.getSelections=function(e,t){var i,n=this.bidiMap,r=n.bidiLevels,o=[],s=0,a=Math.min(e,t)-this.wrapIndent,l=Math.max(e,t)-this.wrapIndent,c=!1,h=!1,d=0;this.wrapIndent&&(s+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var u,g=0;g<r.length;g++)u=n.logicalFromVisual[g],i=r[g],(c=a<=u&&u<l)&&!h?d=s:!c&&h&&o.push({left:d,width:s-d}),s+=this.charWidths[i],h=c;if(c&&g===r.length&&o.push({left:d,width:s-d}),this.isRtlDir)for(var p=0;p<o.length;p++)o[p].left+=this.rtlLineOffset;return o},this.offsetToCol=function(e){this.isRtlDir&&(e-=this.rtlLineOffset);var t=0,e=Math.max(e,0),i=0,n=0,r=this.bidiMap.bidiLevels,o=this.charWidths[r[n]];for(this.wrapIndent&&(e-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);i+o/2<e;){if(i+=o,n===r.length-1){o=0;break}o=this.charWidths[r[++n]]}return 0===(t=0<n&&r[n-1]%2!=0&&r[n]%2==0?(e<i&&n--,this.bidiMap.logicalFromVisual[n]):0<n&&r[n-1]%2==0&&r[n]%2!=0?1+(i<e?this.bidiMap.logicalFromVisual[n]:this.bidiMap.logicalFromVisual[n-1]):this.isRtlDir&&n===r.length-1&&0===o&&r[n-1]%2==0||!this.isRtlDir&&0===n&&r[n]%2!=0?1+this.bidiMap.logicalFromVisual[n]:(0<n&&r[n-1]%2!=0&&0!==o&&n--,this.bidiMap.logicalFromVisual[n]))&&this.isRtlDir&&t++,t+this.wrapIndent}}).call(n.prototype),t.BidiHandler=n}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,i){"use strict";function n(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.anchor.on("change",function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")})}var r=e("./lib/oop"),s=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,a=e("./range").Range;(function(){r.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.$isEmpty=!1,this.anchor.setPosition(e,t)},this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.$isEmpty?a.fromPoints(t,t):this.isBackwards()?a.fromPoints(t,e):a.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(e,t){var i=t?e.end:e.start,n=t?e.start:e.end;this.$setSelection(i.row,i.column,n.row,n.column)},this.$setSelection=function(e,t,i,n){var r,o;this.$silent||(r=this.$isEmpty,o=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(e,t),this.cursor.setPosition(i,n),this.$isEmpty=!a.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),(this.$cursorChanged||this.$anchorChanged||r!=this.$isEmpty||o)&&this._emit("changeSelection"))},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){var i;return void 0===t&&(e=(i=e||this.lead).row,t=i.column),this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var i="number"==typeof e?e:this.lead.row,n=this.session.getFoldLine(i),r=n?(i=n.start.row,n.end.row):i;return!0===t?new a(i,0,r,this.session.getLine(r).length):new a(i,0,r+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,i){var n=e.column,r=e.column+t;return i<0&&(n=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(n,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t,i=this.lead.getPosition();(e=this.session.getFoldAt(i.row,
i.column,-1))?this.moveCursorTo(e.start.row,e.start.column):0===i.column?0<i.row&&this.moveCursorTo(i.row-1,this.doc.getLine(i.row-1).length):(t=this.session.getTabSize(),this.wouldMoveIntoSoftTab(i,t,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-t):this.moveCursorBy(0,-1))},this.moveCursorRight=function(){var e,t,i=this.lead.getPosition();(e=this.session.getFoldAt(i.row,i.column,1))?this.moveCursorTo(e.end.row,e.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(t=this.session.getTabSize(),i=this.lead,this.wouldMoveIntoSoftTab(i,t,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,t):this.moveCursorBy(0,1))},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(i,0),r=this.session.getDisplayLine(e,null,n.row,n.column).match(/^\s*/);r[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=r[0].length),this.moveCursorToPosition(n)},this.moveCursorLineEnd=function(){var e,t,i=this.lead,n=this.session.getDocumentLastRowColumnPosition(i.row,i.column);this.lead.column==n.column&&(e=this.session.getLine(n.row),n.column!=e.length||0<(t=e.search(/\s+$/))&&(n.column=t)),this.moveCursorTo(n.row,n.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(e,t,1);if(r)this.moveCursorTo(r.end.row,r.end.column);else{if(this.session.nonTokenRe.exec(n)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=i.substring(t)),t>=i.length)return this.moveCursorTo(e,i.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(n)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))this.moveCursorTo(e.start.row,e.start.column);else{var n=this.session.getFoldStringAt(t,i,-1);null==n&&(n=this.doc.getLine(t).substring(0,i));var r=s.stringReverse(n);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(r)&&(i-=this.session.nonTokenRe.lastIndex,r=r.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),i<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(0<t&&this.moveCursorWordLeft());this.session.tokenRe.exec(r)&&(i-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,i)}},this.$shortWordEndIndex=function(e){var t,i=0,n=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))i=this.session.tokenRe.lastIndex;else{for(;(t=e[i])&&n.test(t);)i++;if(i<1)for(r.lastIndex=0;(t=e[i])&&!r.test(t);)if(r.lastIndex=0,i++,n.test(t)){if(2<i){i--;break}for(;(t=e[i])&&n.test(t);)i++;if(2<i)break}}return r.lastIndex=0,i},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==i.length){for(var o=this.doc.getLength();e++,n=this.doc.getLine(e),e<o&&/^\s*$/.test(n););/^\s+/.test(n)||(n=""),t=0}var s=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+s)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return this.moveCursorTo(e.start.row,e.start.column);var n=this.session.getLine(t).substring(0,i);if(0===i){for(;t--,n=this.doc.getLine(t),0<t&&/^\s*$/.test(n););i=n.length,/\s+$/.test(n)||(n="")}var r=s.stringReverse(n),o=this.$shortWordEndIndex(r);return this.moveCursorTo(t,i-o)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i,n,r=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(r.row,this.lead.row)?(i=this.session.$bidiHandler.getPosLeft(r.column),r.column=Math.round(i/this.session.$bidiHandler.charWidths[0])):i=r.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?r.column=this.$desiredColumn:this.$desiredColumn=r.column),0!=e&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(n=this.session.lineWidgets[this.lead.row],e<0?e-=n.rowsAbove||0:0<e&&(e+=n.rowCount-(n.rowsAbove||0)));var o=this.session.screenToDocumentPosition(r.row+e,r.column,i);0!==e&&0===t&&o.row===this.lead.row&&(o.column,this.lead.column),this.moveCursorTo(o.row,o.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1);n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0;var r=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?--t:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){var n=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(n.row,n.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var i=this.getCursor();return a.fromPoints(t,i)}catch(e){return a.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){var e;return this.rangeCount?e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t}):(e=this.getRange()).isBackwards=this.isBackwards(),e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList&&1<e.length){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=a.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(n.prototype),t.Selection=n}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(e,t,i){"use strict";function n(e){for(var t in this.states=e,this.regExps={},this.matchMappings={},this.states){for(var i=this.states[t],n=[],r=0,o=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<i.length;l++){var c,h,d=i[l];d.defaultToken&&(o.defaultToken=d.defaultToken),d.caseInsensitive&&(s="gi"),null!=d.regex&&(d.regex instanceof RegExp&&(d.regex=d.regex.toString().slice(1,-1)),c=d.regex,h=new RegExp("(?:("+c+")|(.))").exec("a").length-2,Array.isArray(d.token)?1==d.token.length||1==h?d.token=d.token[0]:h-1!=d.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:d,groupCount:h-1}),d.token=d.token[0]):(d.tokenArray=d.token,d.token=null,d.onMatch=this.$arrayTokens):"function"!=typeof d.token||d.onMatch||(d.onMatch=1<h?this.$applyToken:d.token),1<h&&(c=/\\\d/.test(d.regex)?d.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+r+1)}):(h=1,this.removeCapturingGroups(d.regex)),d.splitRegex||"string"==typeof d.token||a.push(d)),o[r]=l,r+=h,n.push(c),d.onMatch||(d.onMatch=null))}n.length||(o[0]=0,n.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+n.join(")|(")+")|($)",s)}}var r=e("./config"),v=2e3;(function(){this.$setMaxTokenCount=function(e){v=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],r=0,o=i.length;r<o;r++)t[r]&&(n[n.length]={type:i[r],value:t[r]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,r=0,o=n.length;r<o;r++)t[r+1]&&(i[i.length]={type:n[r],value:t[r+1]});return i},this.removeCapturingGroups=function(e){return e.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!]|(\()/g,function(e,t){return t?"(?:":e})},this.createSplitterRegexp=function(e,t){var s,a,l;return-1!=e.indexOf("(?=")&&(s=0,a=!1,l={},e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,i,n,r,o){return a?a="]"!=r:r?a=!0:n?(s==l.stack&&(l.end=o+1,l.stack=-1),s--):i&&(s++,1!=i.length&&(l.stack=s,l.start=o)),e}),null!=l.end&&/^\)*$/.test(e.substr(l.end))&&(e=e.substring(0,l.start)+e.substr(l.end))),"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){var i;t&&"string"!=typeof t?"#tmp"===(t=(i=t.slice(0))[0])&&(i.shift(),t=i.shift()):i=[];var n=t||"start",r=this.states[n];r||(n="start",r=this.states[n]);for(var o,s=this.matchMappings[n],a=this.regExps[n],l=[],c=a.lastIndex=0,h=0,d={type:null,value:""};o=a.exec(e);){var u,g=s.defaultToken,p=null,m=o[0],f=a.lastIndex;f-m.length>c&&(u=e.substring(c,f-m.length),d.type==g?d.value+=u:(d.type&&l.push(d),d={type:g,value:u}));for(var C=0;C<o.length-2;C++)if(void 0!==o[C+1]){g=(p=r[s[C]]).onMatch?p.onMatch(m,n,i,e):p.token,p.next&&(n="string"==typeof p.next?p.next:p.next(n,i),(r=this.states[n])||(this.reportError("state doesn't exist",n),n="start",r=this.states[n]),s=this.matchMappings[n],c=f,(a=this.regExps[n]).lastIndex=f),p.consumeLineEnd&&(c=f);break}if(m)if("string"==typeof g)p&&!1===p.merge||d.type!==g?(d.type&&l.push(d),d={type:g,value:m}):d.value+=m;else if(g){d.type&&l.push(d),d={type:null,value:""};for(C=0;C<g.length;C++)l.push(g[C])}if(c==e.length)break;if(c=f,h++>v){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});c<e.length;)d.type&&l.push(d),d={value:e.substring(c,c+=500),type:"overflow"};n="start",i=[];break}}return d.type&&l.push(d),1<i.length&&i[0]!==n&&i.unshift("#tmp",n),{tokens:l,state:i.length?i:n}},this.reportError=r.reportError}).call(n.prototype),t.Tokenizer=n}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var c=e("../lib/lang");(function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],r=0;r<n.length;r++){var o=n[r];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,i,n,r){var o="function"==typeof e?(new e).getRules():e;if(n)for(var s=0;s<n.length;s++)n[s]=t+n[s];else for(var a in n=[],o)n.push(t+a);if(this.addRules(o,t),i)for(var l=Array.prototype[r?"push":"unshift"],s=0;s<n.length;s++)l.apply(this.$rules[n[s]],c.deepCopy(i));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function g(e,t){return"start"==e&&!t.length||t.unshift(this.nextState,e),this.nextState}function p(e,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var d=0,u=this.$rules;Object.keys(u).forEach(function e(t){var i=u[t];i.processed=!0;for(var n=0;n<i.length;n++){var r=i[n],o=null;Array.isArray(r)&&(o=r,r={}),!r.regex&&r.start&&(r.regex=r.start,r.next||(r.next=[]),r.next.push({defaultToken:r.token},{token:r.token+".end",regex:r.end||r.start,next:"pop"}),r.token=r.token+".start",r.push=!0);var s,a=r.next||r.push;if(a&&Array.isArray(a)?((s=r.stateName)||("string"!=typeof(s=r.token)&&(s=s[0]||""),u[s]&&(s+=d++)),u[s]=a,e(r.next=s)):"pop"==a&&(r.next=p),r.push&&(r.nextState=r.next||r.push,r.next=g,delete r.push),r.rules)for(var l in r.rules)u[l]?u[l].push&&u[l].push.apply(u[l],r.rules[l]):u[l]=r.rules[l];var c,h="string"==typeof r?r:r.include;h&&(o=Array.isArray(h)?h.map(function(e){return u[e]}):u[h]),o&&(c=[n,1].concat(o),r.noEscape&&(c=c.filter(function(e){return!e.next})),i.splice.apply(i,c),n--),r.keywordMap&&(r.token=this.createKeywordMapper(r.keywordMap,r.defaultToken||"text",r.caseInsensitive),delete r.defaultToken)}},this)},this.createKeywordMapper=function(r,t,o,s){var a=Object.create(null);return this.$keywordList=[],Object.keys(r).forEach(function(e){for(var t=r[e].split(s||"|"),i=t.length;i--;){var n=t[i];this.$keywordList.push(n),o&&(n=n.toLowerCase()),a[n]=e}},this),r=null,o?function(e){return a[e.toLowerCase()]||t}:function(e){return a[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(n.prototype),t.TextHighlightRules=n}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,i){"use strict";function n(){this.$behaviours={}}(function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){var i;i="function"==typeof e?(new e).getBehaviours(t):e.getBehaviours(t),this.addBehaviours(i)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}).call(n.prototype),t.Behaviour=n}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var n=e.getTokenAt(t,i);this.$tokenIndex=n?n.index:-1}var r=e("./range").Range;(function(){this.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e=e||this.$session.getLength(),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;0<t;)i+=e[--t].value.length;return i},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new r(this.$row,t,this.$row,t+e.value.length)}}).call(n.prototype),t.TokenIterator=n}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,i){"use strict";function y(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,l.rangeCount!=e.multiSelect.rangeCount&&(l={rangeCount:e.multiSelect.rangeCount})),l[t])return p=l[t];p=l[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function w(e,t,i,n){var r=e.end.row-e.start.row;return{text:i+t+n,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}}var p,n=e("../../lib/oop"),r=e("../behaviour").Behaviour,o=e("../../token_iterator").TokenIterator,m=e("../../lib/lang"),s=["text","paren.rparen","rparen","paren","punctuation.operator"],a=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],l={},S={'"':'"',"'":"'"},f=function(g){this.add("braces","insertion",function(e,t,i,n,r){var o=i.getCursorPosition(),s=n.doc.getLine(o.row);if("{"==r){y(i);var a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(""!==l&&"{"!==l&&i.getWrapBehavioursEnabled())return w(a,l,"{","}");if(f.isSaneInsertion(i,n))return/[\]\}\)]/.test(s[o.column])||i.inMultiSelectMode||g&&g.braces?(f.recordAutoInsert(i,n,"}"),{text:"{}",selection:[1,1]}):(f.recordMaybeInsert(i,n,"{"),{text:"{",selection:[1,1]})}else if("}"==r){if(y(i),"}"==s.substring(o.column,o.column+1))if(null!==n.$findOpeningBracket("}",{column:o.column+1,row:o.row})&&f.isAutoInsertedClosing(o,s,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==r||"\r\n"==r){y(i);var c="";if(f.isMaybeInsertedClosing(o,s)&&(c=m.stringRepeat("}",p.maybeInsertedBrackets),f.clearMaybeInsertedClosing()),"}"===s.substring(o.column,o.column+1)){var h=n.findMatchingBracket({row:o.row,column:o.column+1},"}");if(!h)return null;var d=this.$getIndent(n.getLine(h.row))}else{if(!c)return void f.clearMaybeInsertedClosing();d=this.$getIndent(s)}var u=d+n.getTabString();return{text:"\n"+u+"\n"+d+c,selection:[1,u.length,1,u.length]}}f.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"{"==o){if(y(i),"}"==n.doc.getLine(r.start.row).substring(r.end.column,r.end.column+1))return r.end.column++,r;p.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,r){if("("==r){y(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return w(o,s,"(",")");if(f.isSaneInsertion(i,n))return f.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}}else if(")"==r){y(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if(")"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket(")",{column:a.column+1,row:a.row})&&f.isAutoInsertedClosing(a,l,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"("==o&&(y(i),")"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("brackets","insertion",function(e,t,i,n,r){if("["==r){y(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return w(o,s,"[","]");if(f.isSaneInsertion(i,n))return f.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}}else if("]"==r){y(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if("]"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket("]",{column:a.column+1,row:a.row})&&f.isAutoInsertedClosing(a,l,r))return f.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"["==o&&(y(i),"]"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("string_dquotes","insertion",function(e,t,i,n,r){var o=n.$mode.$quotes||S;if(1==r.length&&o[r]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(r))return;y(i);var s=r,a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(!(""===l||1==l.length&&o[l])&&i.getWrapBehavioursEnabled())return w(a,l,s,s);if(!l){var c=i.getCursorPosition(),h=n.doc.getLine(c.row),d=h.substring(c.column-1,c.column),u=h.substring(c.column,c.column+1),g=n.getTokenAt(c.row,c.column),p=n.getTokenAt(c.row,c.column+1);if("\\"==d&&g&&/escape/.test(g.type))return null;var m,f=g&&/string|escape/.test(g.type),C=!p||/string|escape/.test(p.type);if(u==s)(m=f!==C)&&/string\.end/.test(p.type)&&(m=!1);else{if(f&&!C)return null;if(f&&C)return null;var v=n.$mode.tokenRe;v.lastIndex=0;var I=v.test(d);v.lastIndex=0;var A=v.test(d);if(I||A)return null;if(u&&!/[\s;,.})\]\\]/.test(u))return null;var b=h[c.column-2];if(d==s&&(b==s||v.test(b)))return null;m=!0}return{text:m?s+s:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,r){var o=n.$mode.$quotes||S,s=n.doc.getTextRange(r);if(!r.isMultiLine()&&o.hasOwnProperty(s)&&(y(i),n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==s))return r.end.column++,r})};f.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new o(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",s)){if(/[)}\]]/.test(e.session.getLine(i.row)[i.column]))return!0;var r=new o(t,i.row,i.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",s))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",a)},f.$matchTokenType=function(e,t){return-1<t.indexOf(e.type||e)},f.recordAutoInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isAutoInsertedClosing(n,r,p.autoInsertedLineEnd[0])||(p.autoInsertedBrackets=0),p.autoInsertedRow=n.row,p.autoInsertedLineEnd=i+r.substr(n.column),p.autoInsertedBrackets++},f.recordMaybeInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isMaybeInsertedClosing(n,r)||(p.maybeInsertedBrackets=0),p.maybeInsertedRow=n.row,p.maybeInsertedLineStart=r.substr(0,n.column)+i,p.maybeInsertedLineEnd=r.substr(n.column),p.maybeInsertedBrackets++},f.isAutoInsertedClosing=function(e,t,i){return 0<p.autoInsertedBrackets&&e.row===p.autoInsertedRow&&i===p.autoInsertedLineEnd[0]&&t.substr(e.column)===p.autoInsertedLineEnd},f.isMaybeInsertedClosing=function(e,t){return 0<p.maybeInsertedBrackets&&e.row===p.maybeInsertedRow&&t.substr(e.column)===p.maybeInsertedLineEnd&&t.substr(0,e.column)==p.maybeInsertedLineStart},f.popAutoInsertedClosing=function(){p.autoInsertedLineEnd=p.autoInsertedLineEnd.substr(1),p.autoInsertedBrackets--},f.clearMaybeInsertedClosing=function(){p&&(p.maybeInsertedBrackets=0,p.maybeInsertedRow=-1)},n.inherits(f,r),t.CstyleBehaviour=f}),ace.define("ace/unicode",["require","exports","module"],function(e,t,i){"use strict";for(var n=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],r=0,o=[],s=0;s<n.length;s+=2)o.push(r+=n[s]),n[s+1]&&o.push(45,r+=n[s+1]);t.wordChars=String.fromCharCode.apply(null,o)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,i){"use strict";function n(){this.HighlightRules=o}var s=e("../config"),r=e("../tokenizer").Tokenizer,o=e("./text_highlight_rules").TextHighlightRules,a=e("./behaviour/cstyle").CstyleBehaviour,l=e("../unicode"),b=e("../lib/lang"),m=e("../token_iterator").TokenIterator,f=e("../range").Range;(function(){this.$defaultBehaviour=new a,this.tokenRe=new RegExp("^["+l.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+l.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new r(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,r,i,n){var o=r.doc,s=!0,a=!0,l=1/0,c=r.getTabSize(),t=!1;if(this.lineCommentStart){m=Array.isArray(this.lineCommentStart)?(C=this.lineCommentStart.map(b.escapeRegExp).join("|"),this.lineCommentStart[0]):(C=b.escapeRegExp(this.lineCommentStart),this.lineCommentStart),C=new RegExp("^(\\s*)(?:"+C+") ?"),t=r.getUseSoftTabs();var h=function(e,t){var i,n,r=e.match(C);r&&(i=r[1].length,n=r[0].length,p(e,i,n)||" "!=r[0][n-1]||n--,o.removeInLine(t,i,n))},d=m+" ",u=function(e,t){s&&!/\S/.test(e)||(p(e,l,l)?o.insertInLine({row:t,column:l},d):o.insertInLine({row:t,column:l},m))},g=function(e,t){return C.test(e)},p=function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%c!=0)return!1;for(n=0;" "==e.charAt(i++);)n++;return 2<c?n%c!=c-1:n%c==0}}else{if(!this.blockComment)return!1;var m=this.blockComment.start,f=this.blockComment.end,C=new RegExp("^(\\s*)(?:"+b.escapeRegExp(m)+")"),v=new RegExp("(?:"+b.escapeRegExp(f)+")\\s*$"),u=function(e,t){g(e,t)||s&&!/\S/.test(e)||(o.insertInLine({row:t,column:e.length},f),o.insertInLine({row:t,column:l},m))},h=function(e,t){var i;(i=e.match(v))&&o.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(C))&&o.removeInLine(t,i[1].length,i[0].length)},g=function(e,t){if(C.test(e))return!0;for(var i=r.getTokens(t),n=0;n<i.length;n++)if("comment"===i[n].type)return!0}}function I(e){for(var t=i;t<=n;t++)e(o.getLine(t),t)}var A=1/0;I(function(e,t){var i=e.search(/\S/);-1!==i?(i<l&&(l=i),a&&!g(e,t)&&(a=!1)):A>e.length&&(A=e.length)}),l==1/0&&(l=A,a=s=!1),t&&l%c!=0&&(l=Math.floor(l/c)*c),I(a?h:u)},this.toggleBlockComment=function(e,t,i,n){var r=this.blockComment;if(r){!r.start&&r[0]&&(r=r[0]);var o,s,a=(u=new m(t,n.row,n.column)).getCurrentToken(),l=(t.selection,t.selection.toOrientedRange());if(a&&/comment/.test(a.type)){for(;a&&/comment/.test(a.type);){if(-1!=(g=a.value.indexOf(r.start))){var c=u.getCurrentTokenRow(),h=u.getCurrentTokenColumn()+g,d=new f(c,h,c,h+r.start.length);break}a=u.stepBackward()}for(var u,g,a=(u=new m(t,n.row,n.column)).getCurrentToken();a&&/comment/.test(a.type);){if(-1!=(g=a.value.indexOf(r.end))){var c=u.getCurrentTokenRow(),h=u.getCurrentTokenColumn()+g,p=new f(c,h,c,h+r.end.length);break}a=u.stepForward()}p&&t.remove(p),d&&(t.remove(d),o=d.start.row,s=-r.start.length)}else s=r.start.length,o=i.start.row,t.insert(i.end,r.end),t.insert(i.start,r.start);l.start.row==o&&(l.start.column+=s),l.end.row==o&&(l.end.column+=s),t.selection.fromOrientedRange(l)}},this.getNextLineIndent=function(e,t,i){return this.$getIndent(t)},this.checkOutdent=function(e,t,i){return!1},this.autoOutdent=function(e,t,i){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var n in this.$embeds=[],this.$modes={},e){var t,i,r;e[n]&&(i=(t=e[n]).prototype.$id,(r=s.$modes[i])||(s.$modes[i]=r=new t),s.$modes[n]||(s.$modes[n]=r),this.$embeds.push(n),this.$modes[n]=r)}for(var o=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],n=0;n<o.length;n++)!function(e){var t=o[n],i=e[t];e[o[n]]=function(){return this.$delegator(t,arguments,i)}}(this)},this.$delegator=function(e,t,i){var n=t[0]||"start";if("string"!=typeof n){if(Array.isArray(n[2])){var r=n[2][n[2].length-1];if(s=this.$modes[r])return s[e].apply(s,[n[1]].concat([].slice.call(t,1)))}n=n[0]||"start"}for(var o=0;o<this.$embeds.length;o++)if(this.$modes[this.$embeds[o]]){var s,a=n.split(this.$embeds[o]);if(!a[0]&&a[1])return t[0]=a[1],(s=this.$modes[this.$embeds[o]])[e].apply(s,t)}var l=i.apply(this,t);return i?l:void 0},this.transformAction=function(e,t,i,n,r){if(this.$behaviour){var o=this.$behaviour.getBehaviours();for(var s in o)if(o[s][t]){var a=o[s][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(var n in t)for(var r=t[n],o=0,s=r.length;o<s;o++)if("string"==typeof r[o].token)/keyword|support|storage/.test(r[o].token)&&i.push(r[o].regex);else if("object"==typeof r[o].token)for(var a=0,l=r[o].token.length;a<l;a++){/keyword|support|storage/.test(r[o].token[a])&&(n=r[o].regex.match(/\(.+?\)/g)[a],i.push(n.substr(1,n.length-2)))}this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,i,n){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(n.prototype),t.Mode=n}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,i){"use strict";t.applyDelta=function(e,t,i){var n,r=t.start.row,o=t.start.column,s=e[r]||"";switch(t.action){case"insert":1===t.lines.length?e[r]=s.substring(0,o)+t.lines[0]+s.substring(o):(n=[r,1].concat(t.lines),e.splice.apply(e,n),e[r]=s.substring(0,o)+e[r],e[r+t.lines.length-1]+=s.substring(o));break;case"remove":var a=t.end.column,l=t.end.row;r===l?e[r]=s.substring(0,o)+s.substring(a):e.splice(r,l-r+1,s.substring(0,o)+e[l].substring(a))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,i){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===i?this.setPosition(t.row,t.column):this.setPosition(t,i)};(function(){function l(e,t,i){var n=i?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&n}n.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){var t;e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row||(t=function(e,t,i){var n="insert"==e.action,r=(n?1:-1)*(e.end.row-e.start.row),o=(n?1:-1)*(e.end.column-e.start.column),s=e.start,a=n?s:e.end;if(l(t,s,i))return{row:t.row,column:t.column};if(l(a,t,!i))return{row:t.row+r,column:t.column+(t.row==a.row?o:0)};return{row:s.row,column:s.column}}(e,{row:this.row,column:this.column},this.$insertRight),this.setPosition(t.row,t.column,!0))},this.setPosition=function(e,t,i){var n,r=i?{row:e,column:t}:this.$clipPositionToDocument(e,t);this.row==r.row&&this.column==r.column||(n={row:this.row,column:this.column},this.row=r.row,this.column=r.column,this._signal("change",{old:n,value:r}))},this.detach=function(){this.document.off("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):e<0?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),t<0&&(i.column=0),i}}).call(o.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,i){"use strict";function n(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}var r=e("./lib/oop"),o=e("./apply_delta").applyDelta,s=e("./lib/event_emitter").EventEmitter,h=e("./range").Range,a=e("./anchor").Anchor;(function(){r.implement(this,s),this.setValue=function(e){var t=this.getLength()-1;this.remove(new h(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new a(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t,i;return e.start.row===e.end.row?t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)]:((t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column),i=t.length-1,e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column))),t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var i=this.clippedPos(e.row,e.column),n=this.pos(e.row,e.column+t.length);return this.applyDelta({start:i,end:n,action:"insert",lines:[t]},!0),this.clonePos(n)},this.clippedPos=function(e,t){var i=this.getLength();void 0===e?e=i:e<0?e=0:i<=e&&(e=i-1,t=void 0);var n=this.getLine(e);return null==t&&(t=n.length),{row:e,column:t=Math.min(Math.max(t,0),n.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var i=0,i=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),0):(t=[""].concat(t),e--,this.$lines[e].length);this.insertMergedLines({row:e,column:i},t)},this.insertMergedLines=function(e,t){var i=this.clippedPos(e.row,e.column),n={row:i.row+t.length-1,column:(1==t.length?i.column:0)+t[t.length-1].length};return this.applyDelta({start:i,end:n,action:"insert",lines:t}),this.clonePos(n)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),i=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:i,action:"remove",lines:this.getLinesForRange({start:t,end:i})}),this.clonePos(t)},this.removeInLine=function(e,t,i){var n=this.clippedPos(e,t),r=this.clippedPos(e,i);return this.applyDelta({start:n,end:r,action:"remove",lines:this.getLinesForRange({start:n,end:r})},!0),this.clonePos(n)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var i=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&0<e,n=t<this.getLength()-1,r=i?e-1:e,o=i?this.getLine(r).length:0,s=n?t+1:t,a=n?0:this.getLine(s).length,l=new h(r,o,s,a),c=this.$lines.slice(e,t+1);return this.applyDelta({start:l.start,end:l.end,action:"remove",lines:this.getLinesForRange(l)}),c},this.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof h||(e=h.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;0<=t;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var i="insert"==e.action;(i?e.lines.length<=1&&!e.lines[0]:!h.comparePoints(e.start,e.end))||(i&&2e4<e.lines.length?this.$splitAndapplyLargeDelta(e,2e4):(o(this.$lines,e,t),this._signal("change",e)))},this.$safeApplyDelta=function(e){var t=this.$lines.length;("remove"==e.action&&e.start.row<t&&e.end.row<t||"insert"==e.action&&e.start.row<=t)&&this.applyDelta(e)},this.$splitAndapplyLargeDelta=function(e,t){for(var i=e.lines,n=i.length-t+1,r=e.start.row,o=e.start.column,s=0,a=0;s<n;s=a){a+=t-1;var l=i.slice(s,a);l.push(""),this.applyDelta({start:this.pos(r+s,o),end:this.pos(r+a,o=0),action:e.action,lines:l},!0)}e.lines=i.slice(s),e.start.row=r+s,e.start.column=o,this.applyDelta(e,!0)},this.revertDelta=function(e){this.$safeApplyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=t||0,o=i.length;r<o;r++)if((e-=i[r].length+n)<0)return{row:r,column:e+i[r].length+n};return{row:o-1,column:e+i[o-1].length+n}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=0,o=Math.min(e.row,i.length),s=t||0;s<o;++s)r+=i[s].length+n;return r+e.column}}).call(n.prototype),t.Document=n}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var a=this;this.$worker=function(){if(a.running){for(var e=new Date,t=a.currentLine,i=-1,n=a.doc,r=t;a.lines[t];)t++;var o=n.getLength(),s=0;for(a.running=!1;t<o;){for(a.$tokenizeRow(t),i=t;t++,a.lines[t];);if(++s%5==0&&20<new Date-e){a.running=setTimeout(a.$worker,20);break}}a.currentLine=t,-1==i&&(i=t),r<=i&&a.fireUpdateEvent(r,i)}}}var r=e("./lib/oop"),o=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,o),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var i={first:e,last:t};this._signal("update",{data:i})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t,i=e.start.row,n=e.end.row-i;0==n?this.lines[i]=null:"remove"==e.action?(this.lines.splice(i,1+n,null),this.states.splice(i,1+n,null)):((t=Array(1+n)).unshift(i,1),this.lines.splice.apply(this.lines,t),this.states.splice.apply(this.states,t)),this.currentLine=Math.min(i,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],n=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=n.state+""?(this.states[e]=n.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=n.tokens}}).call(n.prototype),t.BackgroundTokenizer=n}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"}var c=e("./lib/lang"),h=(e("./lib/oop"),e("./range").Range);(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,i,n){if(this.regExp)for(var r=n.firstRow,o=n.lastRow,s=r;s<=o;s++){var a=this.cache[s];null==a&&((a=c.getMatchOffsets(i.getLine(s),this.regExp)).length>this.MAX_RANGES&&(a=a.slice(0,this.MAX_RANGES)),a=a.map(function(e){return new h(s,e.offset,s,e.offset+e.length)}),this.cache[s]=a.length?a:"");for(var l=a.length;l--;)t.drawSingleLineMarker(e,a[l].toScreenRange(i),this.clazz,n)}}}).call(n.prototype),t.SearchHighlight=n}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range;function c(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var i=t[t.length-1];this.range=new n(t[0].start.row,t[0].start.column,i.end.row,i.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}(function(){this.shiftRow=function(t){this.start.row+=t,this.end.row+=t,this.folds.forEach(function(e){e.start.row+=t,e.end.row+=t})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),0<this.range.compareEnd(e.start.row,e.start.column)?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,r,o=0,s=this.folds,a=!0;null==t&&(t=this.end.row,i=this.end.column);for(var l=0;l<s.length;l++){if(-1==(r=(n=s[l]).range.compareStart(t,i)))return void e(null,t,i,o,a);if(!e(null,n.start.row,n.start.column,o,a)&&e(n.placeholder,n.start.row,n.start.column,o)||0===r)return;a=!n.sameRow,o=n.end.column}e(null,t,i,o,a)},this.getNextFoldTo=function(e,t){for(var i,n,r=0;r<this.folds.length;r++){if(-1==(n=(i=this.folds[r]).range.compareEnd(e,t)))return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,r,o=this.getNextFoldTo(e,t);if(o)if(n=o.fold,"inside"==o.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){var s=(r=this.folds).indexOf(n);for(0===s&&(this.start.column+=i);s<r.length;s++){if((n=r[s]).start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){var i=this.getNextFoldTo(e,t);if(!i||"inside"==i.kind)return null;var n=i.fold,r=this.folds,o=this.foldData,s=r.indexOf(n),a=r[s-1];this.end.row=a.end.row,this.end.column=a.end.column;var l=new c(o,r=r.splice(s,r.length-s));return o.splice(o.indexOf(this)+1,0,l),l},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var t=[this.range.toString()+": ["];return this.folds.forEach(function(e){t.push("  "+e.toString())}),t.push("]"),t.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if((e-=n.start.column-t)<0)return{row:n.start.row,column:n.start.column+e};if((e-=n.placeholder.length)<0)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(c.prototype),t.FoldLine=c}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.ranges=[],this.$bias=1}var l=e("./range").Range.comparePoints;(function(){this.comparePoints=l,this.pointIndex=function(e,t,i){for(var n=this.ranges,r=i||0;r<n.length;r++){var o=n[r],s=l(e,o.end);if(!(0<s)){var a=l(e,o.start);return 0===s?t&&0!==a?-r-2:r:0<a||0===a&&!t?r:-r-1}}return-r-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t);i<0&&(i=-i-1);var n=this.pointIndex(e.end,t,i);return n<0?n=-n-1:n++,this.ranges.splice(i,n-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.apply(t,this.add(e[i]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges.splice(t,1)},this.merge=function(){for(var e,t=[],i=this.ranges,n=(i=i.sort(function(e,t){return l(e.start,t.start)}))[0],r=1;r<i.length;r++){e=n,n=i[r];var o=l(e.end,n.start);o<0||(0!=o||e.isEmpty()||n.isEmpty())&&(l(e.end,n.end)<0&&(e.end.row=n.end.row,e.end.column=n.end.column),i.splice(r,1),t.push(n),n=e,r--)}return this.ranges=i,t},this.contains=function(e,t){return 0<=this.pointIndex({row:e,column:t})},this.containsPoint=function(e){return 0<=this.pointIndex(e)},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges[t]},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];var n=this.pointIndex({row:e,column:0});n<0&&(n=-n-1);var r=this.pointIndex({row:t,column:0},n);r<0&&(r=-r-1);for(var o=[],s=n;s<r;s++)o.push(i[s]);return o},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){for(var t=e.start,i=e.end,n=t.row,r=i.row,o=this.ranges,s=0,a=o.length;s<a;s++){if((h=o[s]).end.row>=n)break}if("insert"==e.action)for(var l=r-n,c=-t.column+i.column;s<a;s++){if((h=o[s]).start.row>n)break;if(h.start.row==n&&h.start.column>=t.column&&(h.start.column==t.column&&this.$bias<=0||(h.start.column+=c,h.start.row+=l)),h.end.row==n&&h.end.column>=t.column){if(h.end.column==t.column&&this.$bias<0)continue;h.end.column==t.column&&0<c&&s<a-1&&h.end.column>h.start.column&&h.end.column==o[s+1].start.column&&(h.end.column-=c),h.end.column+=c,h.end.row+=l}}else for(var h,l=n-r,c=t.column-i.column;s<a;s++){if((h=o[s]).start.row>r)break;h.end.row<r&&(n<h.end.row||n==h.end.row&&t.column<h.end.column)?(h.end.row=n,h.end.column=t.column):h.end.row==r?h.end.column<=i.column?(l||h.end.column>t.column)&&(h.end.column=t.column,h.end.row=t.row):(h.end.column+=c,h.end.row+=l):h.end.row>r&&(h.end.row+=l),h.start.row<r&&(n<h.start.row||n==h.start.row&&t.column<h.start.column)?(h.start.row=n,h.start.column=t.column):h.start.row==r?h.start.column<=i.column?(l||h.start.column>t.column)&&(h.start.column=t.column,h.start.row=t.row):(h.start.column+=c,h.start.row+=l):h.start.row>r&&(h.start.row+=l)}if(0!=l&&s<a)for(;s<a;s++){(h=o[s]).start.row+=l,h.end.row+=l}}}).call(n.prototype),t.RangeList=n}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],function(e,t,i){"use strict";var n=e("../range_list").RangeList,r=e("../lib/oop"),o=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function g(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function s(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}r.inherits(o,n),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(t){this.foldLine=t,this.subFolds.forEach(function(e){e.setFoldLine(t)})},this.clone=function(){var e=this.range.clone(),t=new o(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){var t,i;t=e,i=this.start,g(t.start,i),g(t.end,i);for(var n=e.start.row,r=e.start.column,o=0,s=-1;o<this.subFolds.length&&1==(s=this.subFolds[o].range.compare(n,r));o++);var a=this.subFolds[o],l=0;if(0==s){if(a.range.containsRange(e))return a.addSubFold(e);l=1}for(var n=e.range.end.row,r=e.range.end.column,c=o,s=-1;c<this.subFolds.length&&1==(s=this.subFolds[c].range.compare(n,r));c++);0==s&&c++;for(var h=this.subFolds.splice(o,c-o,e),d=0==s?h.length-1:h.length,u=l;u<d;u++)e.addSubFold(h[u]);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return t=e,i=this.start,s(t.start,i),void s(t.end,i);var t,i}}.call(o.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t,i){"use strict";var h=e("../range").Range,m=e("./fold_line").FoldLine,f=e("./fold").Fold,d=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var r=n.folds,o=0;o<r.length;o++){var s=r[o].range;if(s.contains(e,t)){if(1==i&&s.isEnd(e,t)&&!s.isEmpty())continue;if(-1==i&&s.isStart(e,t)&&!s.isEmpty())continue;return r[o]}}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,r=[];t.column+=1,--i.column;for(var o=0;o<n.length;o++){if(2!=(l=n[o].range.compareRange(e))){if(-2==l)break;for(var s=n[o].folds,a=0;a<s.length;a++){var l,c=s[a];if(-2==(l=c.range.compareRange(e)))break;if(2!=l){if(42==l)break;r.push(c)}}}}return--t.column,i.column+=1,r},this.getFoldsInRangeList=function(e){var t;return Array.isArray(e)?(t=[],e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)):t=this.getFoldsInRange(e),t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(!(n=n||this.getFoldLine(e)))return null;for(var r,o,s={end:{column:0}},a=0;a<n.folds.length;a++){var l=(o=n.folds[a]).range.compareEnd(e,t);if(-1==l){r=this.getLine(o.start.row).substring(s.end.column,o.start.column);break}if(0===l)return null;s=o}return r=r||this.getLine(o.start.row).substring(s.end.column),-1==i?r.substring(0,t-s.end.column):1==i?r.substring(t-s.end.column):r},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,r=0;r<i.length;r++){var o=i[r],s=o.end.row,a=o.start.row;if(t<=s){a<t&&(e<=a?n-=t-a:n=0);break}e<=s&&(n-=e<=a?s-a:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,r=!1;e instanceof f?i=e:(i=new f(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(i.range);var o=i.start.row,s=i.start.column,a=i.end.row,l=i.end.column,c=this.getFoldAt(o,s,1),h=this.getFoldAt(a,l,-1);if(c&&h==c)return c.addSubFold(i);c&&!c.range.isStart(o,s)&&this.removeFold(c),h&&!h.range.isEnd(a,l)&&this.removeFold(h);var d=this.getFoldsInRange(i.range);0<d.length&&(this.removeFolds(d),i.collapseChildren||d.forEach(function(e){i.addSubFold(e)}));for(var u=0;u<n.length;u++){var g=n[u];if(a==g.start.row){g.addFold(i),r=!0;break}if(o==g.end.row){if(g.addFold(i),r=!0,!i.sameRow){var p=n[u+1];if(p&&p.start.row==a){g.merge(p);break}}break}if(a<=g.start.row)break}return r||(g=this.$addFoldLine(new m(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(g.start.row,g.start.row):this.$updateRowLengthCache(g.start.row,g.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t,i=e.foldLine,n=i.start.row,r=i.end.row,o=this.$foldData,s=i.folds;1==s.length?o.splice(o.indexOf(i),1):i.range.isEnd(e.end.row,e.end.column)?(s.pop(),i.end.row=s[s.length-1].end.row,i.end.column=s[s.length-1].end.column):i.range.isStart(e.start.row,e.start.column)?(s.shift(),i.start.row=s[0].start.row,i.start.column=s[0].start.column):e.sameRow?s.splice(s.indexOf(e),1):((s=(t=i.split(e.start.row,e.start.column)).folds).shift(),t.start.row=s[0].start.row,t.start.column=s[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(n,r):this.$updateRowLengthCache(n,r)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(e){t.restoreRange(e),this.addFold(e)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i,n;if(null==e?(i=new h(0,0,this.getLength(),0),null==t&&(t=!0)):i="number"==typeof e?new h(e,0,e,this.getLine(e).length):"row"in e?h.fromPoints(e,e):e,n=this.getFoldsInRangeList(i),0!=t?this.removeFolds(n):this.expandFolds(n),n.length)return n},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var i=this.getFoldLine(e,t);return i?i.end.row:e},this.getRowFoldStart=function(e,t){var i=this.getFoldLine(e,t);return i?i.start.row:e},this.getFoldDisplayLine=function(e,t,i,r,o){null==r&&(r=e.start.row),null==o&&(o=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var s=this.doc,a="";return e.walk(function(e,t,i,n){if(!(t<r)){if(t==r){if(i<o)return;n=Math.max(o,n)}a+=null!=e?e:s.getLine(t).substring(n,i)}},t,i),a},this.getDisplayLine=function(e,t,i,n){var r=this.getFoldLine(e);if(r)return this.getFoldDisplayLine(r,e,t,i,n);var o=this.doc.getLine(e);return o.substring(n||0,t||o.length)},this.$cloneFoldData=function(){var i=[];return i=this.$foldData.map(function(e){var t=e.folds.map(function(e){return e.clone()});return new m(i,t)})},this.toggleFold=function(e){var t,i=this.selection.getRange();if(i.isEmpty()){var n,r=i.start;if(n=this.getFoldAt(r.row,r.column))return void this.expandFold(n);(t=this.findMatchingBracket(r))?1==i.comparePoint(t)?i.end=t:(i.start=t,i.start.column++,i.end.column--):(t=this.findMatchingBracket({row:r.row,column:r.column+1}))?(1==i.comparePoint(t)?i.end=t:i.start=t,i.start.column++):i=this.getCommentFoldRange(r.row,r.column)||i}else{var o=this.getFoldsInRange(i);if(e&&o.length)return void this.expandFolds(o);1==o.length&&(n=o[0])}if((n=n||this.getFoldAt(i.start.row,i.start.column))&&n.range.toString()==i.toString())this.expandFold(n);else{var s="...";if(!i.isMultiLine()){if((s=this.getTextRange(i)).length<4)return;s=s.trim().substring(0,2)+".."}this.addFold(s,i)}},this.getCommentFoldRange=function(e,t,i){var n=new d(this,e,t),r=n.getCurrentToken(),o=r&&r.type;if(r&&/^comment|string/.test(o)){"comment"==(o=o.match(/comment|string/)[0])&&(o+="|doc-start");var s=new RegExp(o),a=new h;if(1!=i){for(;(r=n.stepBackward())&&s.test(r.type););n.stepForward()}if(a.start.row=n.getCurrentTokenRow(),a.start.column=n.getCurrentTokenColumn()+2,n=new d(this,e,t),-1!=i){var l=-1;do{if(r=n.stepForward(),-1==l){var c=this.getState(n.$row);s.test(c)||(l=n.$row)}else if(n.$row>l)break}while(r&&s.test(r.type));r=n.stepBackward()}else r=n.getCurrentToken();return a.end.row=n.getCurrentTokenRow(),a.end.column=n.getCurrentTokenColumn()+r.value.length-2,a}},this.foldAll=function(e,t,i,n){null==i&&(i=1e5);var r=this.foldWidgets;if(r){t=t||this.getLength();for(var o,s=e=e||0;s<t;s++){null==r[s]&&(r[s]=this.getFoldWidget(s)),"start"==r[s]&&(n&&!n(s)||(o=this.getFoldWidgetRange(s))&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e&&(s=o.end.row,o.collapseChildren=i,this.addFold("...",o)))}}},this.foldToLevel=function(e){for(this.foldAll();0<e--;)this.unfold(null,!1)},this.foldAllComments=function(){var r=this;this.foldAll(null,null,null,function(e){for(var t=r.getTokens(e),i=0;i<t.length;i++){var n=t[i];if("text"!=n.type||!/^\s+$/.test(n.value))return!!/comment/.test(n.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");var t;this.$foldStyle!=e&&("manual"==(this.$foldStyle=e)&&this.unfold(),t=this.$foldMode,this.$setFolding(null),this.$setFolding(t))},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n=e-1;0<=n;){var r=i[n];if(null==r&&(r=i[n]=this.getFoldWidget(n)),"start"==r){var o=this.getFoldWidgetRange(n),s=s||o;if(o&&o.end.row>=e)break}n--}return{range:-1!==n&&o,firstRange:s}},this.onFoldWidgetClick=function(e,t){var i,n={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};this.$toggleFoldWidget(e,n)||(i=t.target||t.srcElement)&&/ace_fold-widget/.test(i.className)&&(i.className+=" ace_invalid")},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),r="end"===i?-1:1,o=this.getFoldAt(e,-1==r?0:n.length,r);if(o)return t.children||t.all?this.removeFold(o):this.expandFold(o),o;var s,a,l,c=this.getFoldWidgetRange(e,!0);return c&&!c.isMultiLine()&&(o=this.getFoldAt(c.start.row,c.start.column,1))&&c.isEqual(o.range)?(this.removeFold(o),o):(t.siblings?((s=this.getParentFoldRangeData(e)).range&&(a=s.range.start.row+1,l=s.range.end.row),this.foldAll(a,l,t.all?1e4:0)):t.children?(l=c?c.end.row:this.getLength(),this.foldAll(e+1,l,t.all?1e4:0)):c&&(t.all&&(c.collapseChildren=1e4),this.addFold("...",c)),c)}},this.toggleFoldWidget=function(e){var t,i,n=this.selection.getCursor().row,n=this.getRowFoldStart(n),r=this.$toggleFoldWidget(n,{});r||(r=(t=this.getParentFoldRangeData(n,!0)).range||t.firstRange)&&(n=r.start.row,(i=this.getFoldAt(n,this.getLine(n).length,1))?this.removeFold(i):this.addFold("...",r))},this.updateFoldWidgets=function(e){var t,i=e.start.row,n=e.end.row-i;0==n?this.foldWidgets[i]=null:"remove"==e.action?this.foldWidgets.splice(i,1+n,null):((t=Array(1+n)).unshift(i,1),this.foldWidgets.splice.apply(this.foldWidgets,t))},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,i){"use strict";var d=e("../token_iterator").TokenIterator,a=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var i=t||this.getLine(e.row).charAt(e.column-1);if(""==i)return null;var n=i.match(/([\(\[\{])|([\)\]\}])/);return n?n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e):null},this.getBracketRange=function(e){var t,i,n=this.getLine(e.row),r=!0,o=n.charAt(e.column-1),s=o&&o.match(/([\(\[\{])|([\)\]\}])/);if(s||(o=n.charAt(e.column),e={row:e.row,column:e.column+1},s=o&&o.match(/([\(\[\{])|([\)\]\}])/),r=!1),!s)return null;if(s[1]){if(!(i=this.$findClosingBracket(s[1],e)))return null;t=a.fromPoints(e,i),r||(t.end.column++,t.start.column--),t.cursor=t.end}else{if(!(i=this.$findOpeningBracket(s[2],e)))return null;t=a.fromPoints(i,e),r||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.getMatchingBracketRanges=function(e){var t=this.getLine(e.row),i=t.charAt(e.column-1),n=i&&i.match(/([\(\[\{])|([\)\]\}])/);if(n||(i=t.charAt(e.column),e={row:e.row,column:e.column+1},n=i&&i.match(/([\(\[\{])|([\)\]\}])/)),!n)return null;var r=new a(e.row,e.column-1,e.row,e.column),o=n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e);return o?[r,new a(o.row,o.column,o.row,o.column+1)]:[r]},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn()-2,l=s.value;;){for(;0<=a;){var c=l.charAt(a);if(c==n){if(0==--r)return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else c==e&&(r+=1);--a}for(;(s=o.stepBackward())&&!i.test(s.type););if(null==s)break;a=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn();;){for(var l=s.value,c=l.length;a<c;){var h=l.charAt(a);if(h==n){if(0==--r)return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else h==e&&(r+=1);a+=1}for(;(s=o.stepForward())&&!i.test(s.type););if(null==s)break;a=0}return null}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document",
"ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./bidihandler").BidiHandler,s=e("./config"),l=e("./lib/event_emitter").EventEmitter,a=e("./selection").Selection,c=e("./mode/text").Mode,h=e("./range").Range,d=e("./document").Document,u=e("./background_tokenizer").BackgroundTokenizer,g=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new d(e)),this.setDocument(e),this.selection=new a(this),this.$bidiHandler=new o(this),s.resetOptions(this),this.setMode(t),s._signal("session",this)};p.$uid=0,function(){n.implement(this,l),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),(this.doc=e).on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,i=this.$getRowCacheIndex(this.$docRowCache,e)+1;i<t&&(this.$docRowCache.splice(i,t),this.$screenRowCache.splice(i,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;i<=n;){var r=i+n>>1,o=e[r];if(o<t)i=1+r;else{if(!(t<o))return r;n=r-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);!this.$fromUndo&&this.$undoManager&&(t&&t.length&&(this.$undoManager.add({action:"removeFolds",folds:t},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(e,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i,n=this.bgTokenizer.getTokens(e),r=0;if(null==t)var o=n.length-1,r=this.getLine(e).length;else for(o=0;o<n.length&&!(t<=(r+=n[o].value.length));o++);return(i=n[o])?(i.index=o,i.start=r-i.value.length,i):null},this.setUndoManager=function(e){var t;this.$undoManager=e,this.$informUndoManager&&this.$informUndoManager.cancel(),e?(t=this,e.addSession(this),this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.mergeUndoDeltas=!1},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var r=this.$markerId++,o={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:r};return n?(this.$frontMarkers[r]=o,this._signal("changeFrontMarker")):(this.$backMarkers[r]=o,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){if(e.update){var i=this.$markerId++;return e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];t&&(delete(t.inFront?this.$frontMarkers:this.$backMarkers)[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){var t;this.$searchHighlight||(t=new g(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(t)),this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i=i||"ace_step";var r=new h(e,0,t,1/0);return r.id=this.addMarker(r,i,"fullLine",n),r},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var i,n=this.getLine(e),r=!1;0<t&&(r=!!n.charAt(t-1).match(this.tokenRe)),i=(r=r||!!n.charAt(t).match(this.tokenRe))?this.tokenRe:/^\s+$/.test(n.slice(t-1,t+1))?/\s/:this.nonTokenRe;var o=t;if(0<o){for(;0<=--o&&n.charAt(o).match(i););o++}for(var s=t;s<n.length&&n.charAt(s).match(i);)s++;return new h(e,o,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes=s.$modes,this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[n]&&!i)return this.$onChangeMode(this.$modes[n]),void(t&&t());this.$modeId=n,s.loadModule(["mode",n],function(e){if(this.$modeId!==n)return t&&t();this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):e&&e.Mode&&(e=new e.Mode(i),i||((this.$modes[n]=e).$id=n),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){var i,n,r,o;t||(this.$modeId=e.$id),this.$mode!==e&&(i=this.$mode,this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker(),void 0!==(n=e.getTokenizer()).on&&(r=this.onReloadTokenizer.bind(this),n.on("update",r)),this.bgTokenizer?this.bgTokenizer.setTokenizer(n):(this.bgTokenizer=new u(n),(o=this).bgTokenizer.on("update",function(e){o._signal("tokenizerUpdate",e)})),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:i,mode:e})))},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var t=0;return this.lineWidgets.forEach(function(e){e&&e.screenWidth>t&&(t=e.screenWidth)}),this.lineWidgetWidth=t},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,r=0,o=this.$foldData[r],s=o?o.start.row:1/0,a=t.length,l=0;l<a;l++){if(s<l){if(a<=(l=o.end.row+1))break;s=(o=this.$foldData[r++])?o.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=e.length-1;-1!=i;i--){var n=e[i];"insert"==n.action||"remove"==n.action?this.doc.revertDelta(n):n.folds&&this.addFolds(n.folds)}!t&&this.$undoSelect&&(e.selectionBefore?this.selection.fromJSON(e.selectionBefore):this.selection.setRange(this.$getUndoSelection(e,!0))),this.$fromUndo=!1}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=0;i<e.length;i++){var n=e[i];"insert"!=n.action&&"remove"!=n.action||this.doc.$safeApplyDelta(n)}!t&&this.$undoSelect&&(e.selectionAfter?this.selection.fromJSON(e.selectionAfter):this.selection.setRange(this.$getUndoSelection(e,!1))),this.$fromUndo=!1}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t){function i(e){return t?"insert"!==e.action:"insert"===e.action}for(var n,r,o=0;o<e.length;o++){var s=e[o];s.start&&(n?i(s)?(r=s.start,-1==n.compare(r.row,r.column)&&n.setStart(r),r=s.end,1==n.compare(r.row,r.column)&&n.setEnd(r)):(r=s.start,-1==n.compare(r.row,r.column)&&(n=h.fromPoints(s.start,s.start))):n=i(s)?h.fromPoints(s.start,s.end):h.fromPoints(s.start,s.start))}return n},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n,r,o,s,a=this.getTextRange(e),l=this.getFoldsInRange(e),c=h.fromPoints(t,t);return i||(this.remove(e),o=e.start.row-e.end.row,(s=o?-e.end.column:e.start.column-e.end.column)&&(c.start.row==e.end.row&&c.start.column>e.end.column&&(c.start.column+=s),c.end.row==e.end.row&&c.end.column>e.end.column&&(c.end.column+=s)),o&&c.start.row>=e.end.row&&(c.start.row+=o,c.end.row+=o)),c.end=this.insert(c.start,a),l.length&&(n=e.start,r=c.start,o=r.row-n.row,s=r.column-n.column,this.addFolds(l.map(function(e){return(e=e.clone()).start.row==n.row&&(e.start.column+=s),e.end.row==n.row&&(e.end.column+=s),e.start.row+=o,e.end.row+=o,e}))),c},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;n<=t;n++)this.doc.insertInLine({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new h(0,0,0,0),n=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var o=this.getLine(r);i.start.row=r,i.end.row=r;for(var s=0;s<n&&" "==o.charAt(s);++s);s<n&&"\t"==o.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),i<0){if((r=this.getRowFoldStart(e+i))<0)return 0;var n=r-e}else if(0<i){var r;if((r=this.getRowFoldEnd(t+i))>this.doc.getLength()-1)return 0;n=r-t}else{e=this.$clipRowToDocument(e);n=(t=this.$clipRowToDocument(t))-e+1}var o=new h(e,0,t,Number.MAX_VALUE),s=this.getFoldsInRange(o).map(function(e){return(e=e.clone()).start.row+=n,e.end.row+=n,e}),a=0==i?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+n,a),s.length&&this.addFolds(s),n},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){var i;return t=Math.max(0,t),t=e<0?e=0:(i=this.doc.getLength())<=e?(e=i-1,this.doc.getLine(i-1).length):Math.min(this.doc.getLine(e).length,t),{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){var t;e!=this.$useWrapMode&&(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e&&(t=this.getLength(),this.$wrapData=Array(t),this.$updateWrapData(0,t-1)),this._signal("changeWrapMode"))},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange;i.max<0&&(i={min:t,max:t});var n=this.$constrainWrapLimit(e,i.min,i.max);return n!=this.$wrapLimit&&1<n&&(this.$wrapLimit=n,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),i&&(e=Math.min(i,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,i=e.action,n=e.start,r=e.end,o=n.row,s=r.row,a=s-o,l=null;if(this.$updating=!0,0!=a)if("remove"===i){this[t?"$wrapData":"$rowLengthCache"].splice(o,a);var c=this.$foldData,l=this.getFoldsInRange(e);this.removeFolds(l);var h,d=0;for((m=this.getFoldLine(r.row))&&(m.addRemoveChars(r.row,r.column,n.column-r.column),m.shiftRow(-a),(h=this.getFoldLine(o))&&h!==m&&(h.merge(m),m=h),d=c.indexOf(m)+1);d<c.length;d++){(m=c[d]).start.row>=r.row&&m.shiftRow(-a)}s=o}else{var u=Array(a);u.unshift(o,0);var g=t?this.$wrapData:this.$rowLengthCache;g.splice.apply(g,u);var p,c=this.$foldData,d=0;for((m=this.getFoldLine(o))&&(0==(p=m.range.compareInside(n.row,n.column))?(m=m.split(n.row,n.column))&&(m.shiftRow(a),m.addRemoveChars(s,0,r.column-n.column)):-1==p&&(m.addRemoveChars(o,0,r.column-n.column),m.shiftRow(a)),d=c.indexOf(m)+1);d<c.length;d++){(m=c[d]).start.row>=o&&m.shiftRow(a)}}else{var m,a=Math.abs(e.start.column-e.end.column);"remove"===i&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a),(m=this.getFoldLine(o))&&m.addRemoveChars(o,n.column,a)}return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(o,s):this.$updateRowLengthCache(o,s),l},this.$updateRowLengthCache=function(e,t,i){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,t){var s,i,a=this.doc.getAllLines(),n=this.getTabSize(),r=this.$wrapData,o=this.$wrapLimit,l=e;for(t=Math.min(t,a.length-1);l<=t;)(i=this.getFoldLine(l,i))?(s=[],i.walk(function(e,t,i,n){var r;if(null!=e){(r=this.$getDisplayTokens(e,s.length))[0]=p;for(var o=1;o<r.length;o++)r[o]=m}else r=this.$getDisplayTokens(a[t].substring(n,i),s.length);s=s.concat(r)}.bind(this),i.end.row,a[i.end.row].length+1),r[i.start.row]=this.$computeWrapSplits(s,o,n),l=i.end.row+1):(s=this.$getDisplayTokens(a[l]),r[l]=this.$computeWrapSplits(s,o,n),l++)};var p=3,m=4;function a(e){return!(e<4352)&&(4352<=e&&e<=4447||4515<=e&&e<=4519||4602<=e&&e<=4607||9001<=e&&e<=9002||11904<=e&&e<=11929||11931<=e&&e<=12019||12032<=e&&e<=12245||12272<=e&&e<=12283||12288<=e&&e<=12350||12353<=e&&e<=12438||12441<=e&&e<=12543||12549<=e&&e<=12589||12593<=e&&e<=12686||12688<=e&&e<=12730||12736<=e&&e<=12771||12784<=e&&e<=12830||12832<=e&&e<=12871||12880<=e&&e<=13054||13056<=e&&e<=19903||19968<=e&&e<=42124||42128<=e&&e<=42182||43360<=e&&e<=43388||44032<=e&&e<=55203||55216<=e&&e<=55238||55243<=e&&e<=55291||63744<=e&&e<=64255||65040<=e&&e<=65049||65072<=e&&e<=65106||65108<=e&&e<=65126||65128<=e&&e<=65131||65281<=e&&e<=65376||65504<=e&&e<=65510)}this.$computeWrapSplits=function(r,e,o){if(0==r.length)return[];var s=[],t=r.length,a=0,l=0,c=this.$wrapAsCode,h=this.$indentedSoftWrap,d=e<=Math.max(2*o,8)||!1===h?0:Math.floor(e/2);function i(e){for(var t=e-a,i=a;i<e;i++){var n=r[i];12!==n&&2!==n||--t}s.length||(u=function(){var e=0;if(0===d)return e;if(h)for(var t=0;t<r.length;t++){var i=r[t];if(10==i)e+=1;else{if(11!=i){if(12==i)continue;break}e+=o}}return c&&!1!==h&&(e+=o),Math.min(e,d)}(),s.indent=u),l+=t,s.push(l),a=e}for(var u=0;e-u<t-a;){var n=a+e-u;if(10<=r[n-1]&&10<=r[n])i(n);else if(r[n]!=p&&r[n]!=m){for(var g=Math.max(n-(e-(e>>2)),a-1);g<n&&r[n]<p;)n--;if(c){for(;g<n&&r[n]<p;)n--;for(;g<n&&9==r[n];)n--}else for(;g<n&&r[n]<10;)n--;g<n?i(++n):(2==r[n=a+e]&&n--,i(n-u))}else{for(;n!=a-1&&r[n]!=p;n--);if(a<n){i(n);continue}for(n=a+e;n<r.length&&r[n]==m;n++);if(n==r.length)break;i(n)}}return s},this.$getDisplayTokens=function(e,t){var i,n=[];t=t||0;for(var r=0;r<e.length;r++){var o=e.charCodeAt(r);if(9==o){i=this.getScreenTabSize(n.length+t),n.push(11);for(var s=1;s<i;s++)n.push(12)}else 32==o?n.push(10):39<o&&o<48||57<o&&o<64?n.push(9):4352<=o&&a(o)?n.push(1,2):n.push(1)}return n},this.$getStringScreenWidth=function(e,t,i){if(0==t)return[0,0];var n,r;for(null==t&&(t=1/0),i=i||0,r=0;r<e.length&&(9==(n=e.charCodeAt(r))?i+=this.getScreenTabSize(i):4352<=n&&a(n)?i+=2:i+=1,!(t<i));r++);return[i,r]},this.lineWidgets=null,this.getRowLength=function(e){var t=1;return this.lineWidgets&&(t+=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0),this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+t:t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),i=this.$wrapData[t.row];return i.length&&i[0]<t.column?i.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var i=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(i)},this.getDocumentLastRowColumnPosition=function(e,t){var i=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(i,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-(e%this.$tabSize|0)},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,i){if(e<0)return{row:0,column:0};var n,r,o,s=0,a=0,l=0,c=0,h=this.$screenRowCache,d=this.$getRowCacheIndex(h,e),u=h.length;o=u&&0<=d?(l=h[d],s=this.$docRowCache[d],e>h[u-1]):!u;for(var g=this.getLength()-1,p=this.getNextFoldLine(s),m=p?p.start.row:1/0;l<=e&&!(e<l+(c=this.getRowLength(s))||g<=s);)l+=c,m<++s&&(s=p.end.row+1,m=(p=this.getNextFoldLine(s,p))?p.start.row:1/0),o&&(this.$docRowCache.push(s),this.$screenRowCache.push(l));if(p&&p.start.row<=s)n=this.getFoldDisplayLine(p),s=p.start.row;else{if(l+c<=e||g<s)return{row:g,column:this.getLine(g).length};n=this.getLine(s),p=null}var f,C=0,v=Math.floor(e-l);return!this.$useWrapMode||(f=this.$wrapData[s])&&(r=f[v],0<v&&f.length&&(C=f.indent,a=f[v-1]||f[f.length-1],n=n.substring(a))),void 0!==i&&this.$bidiHandler.isBidiRow(l+v,s,v)&&(t=this.$bidiHandler.offsetToCol(i)),a+=this.$getStringScreenWidth(n,t-C)[1],this.$useWrapMode&&r<=a&&(a=r-1),p?p.idxToPosition(a):{row:s,column:a}},this.documentToScreenPosition=function(e,t){var i=void 0===t?this.$clipPositionToDocument(e.row,e.column):this.$clipPositionToDocument(e,t);e=i.row,t=i.column;var n=0,r=null,o=null;(o=this.getFoldAt(e,t,1))&&(e=o.start.row,t=o.start.column);var s,a,l=0,c=this.$docRowCache,h=this.$getRowCacheIndex(c,e),d=c.length;a=d&&0<=h?(l=c[h],n=this.$screenRowCache[h],e>c[d-1]):!d;for(var u=this.getNextFoldLine(l),g=u?u.start.row:1/0;l<e;){if(g<=l){if(e<(s=u.end.row+1))break;g=(u=this.getNextFoldLine(s,u))?u.start.row:1/0}else s=l+1;n+=this.getRowLength(l),l=s,a&&(this.$docRowCache.push(l),this.$screenRowCache.push(n))}var p="",r=u&&g<=l?(p=this.getFoldDisplayLine(u,e,t),u.start.row):(p=this.getLine(e).substring(0,t),e),m=0;if(this.$useWrapMode){var f=this.$wrapData[r];if(f){for(var C=0;p.length>=f[C];)n++,C++;p=p.substring(f[C-1]||0,p.length),m=0<C?f.indent:0}}return this.lineWidgets&&this.lineWidgets[l]&&this.lineWidgets[l].rowsAbove&&(n+=this.lineWidgets[l].rowsAbove),{row:n,column:m+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,r=0,o=(t=this.$foldData[r++])?t.start.row:1/0;n<i;){var s=this.$wrapData[n];e+=s?s.length+1:1,o<++n&&(n=t.end.row+1,o=(t=this.$foldData[r++])?t.start.row:1/0)}else{e=this.getLength();for(var a=this.$foldData,r=0;r<a.length;r++)e-=(t=a[r]).end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(o){this.$enableVarChar&&(this.$getStringScreenWidth=function(e,t,i){if(0===t)return[0,0];var n,r;for(t=t||1/0,i=i||0,r=0;r<e.length&&!(t<(i+="\t"===(n=e.charAt(r))?this.getScreenTabSize(i):o.getCharacterWidth(n)));r++);return[i,r]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker(),this.removeAllListeners(),this.selection.detach()},this.isFullWidth=a}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),s.defineOptions(p.prototype,"session",{wrap:{set:function(e){var t;e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e&&((this.$wrap=e)?(t="number"==typeof e?e:null,this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){0<(e=parseInt(e))&&this.$tabSize!==e&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(e){this.setFoldStyle(e)},handlesSet:!0},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId},handlesSet:!0}}),t.EditSession=p}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(){this.$options={}}var A=e("./lib/lang"),r=e("./lib/oop"),b=e("./range").Range;(function(){this.set=function(e){return r.mixin(this.$options,e),this},this.getOptions=function(){return A.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var r=this.$options,t=this.$matchIterator(e,r);if(!t)return!1;var o=null;return t.forEach(function(e,t,i,n){return o=new b(e,t,i,n),!(t==n&&r.start&&r.start.start&&0!=r.skipCurrent&&o.isEqual(r.start))||(o=null,!1)}),o},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var i=t.range,n=i?e.getLines(i.start.row,i.end.row):e.doc.getAllLines(),r=[],o=t.re;if(t.$isMultiLine){var s,a=o.length,l=n.length-a;e:for(var c=o.offset||0;c<=l;c++){for(var h=0;h<a;h++)if(-1==n[c+h].search(o[h]))continue e;var d=n[c],u=n[c+a-1],g=d.length-d.match(o[0])[0].length,p=u.match(o[a-1])[0].length;s&&s.end.row===c&&s.end.column>g||(r.push(s=new b(c,g,c+a-1,p)),2<a&&(c=c+a-2))}}else for(var m=0;m<n.length;m++)for(var f=A.getMatchOffsets(n[m],o),h=0;h<f.length;h++){var C=f[h];r.push(new b(m,C.offset,m,C.offset+C.length))}if(i){for(var v=i.start.column,I=i.start.column,m=0,h=r.length-1;m<h&&r[m].start.column<v&&r[m].start.row==i.start.row;)m++;for(;m<h&&r[h].end.column>I&&r[h].end.row==i.end.row;)h--;for(r=r.slice(m,h+1),m=0,h=r.length;m<h;m++)r[m].start.row+=i.start.row,r[m].end.row+=i.start.row}return r},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var r=n.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var s=e[o];s&&s.toLowerCase()!=s?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var i,n,r=e.needle;if(!e.needle)return e.re=!1;function o(e){return/\w/.test(e)||n.regExp?"\\b":""}e.regExp||(r=A.escapeRegExp(r)),e.wholeWord&&(n=e,r=o((i=r)[0])+i+o(i[i.length-1]));var s=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(r),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(r,s);try{var a=new RegExp(r,s)}catch(e){a=!1}return e.re=a},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],r=0;r<i.length;r++)try{n.push(new RegExp(i[r],t))}catch(e){return!1}return n},this.$matchIterator=function(h,i){var d=this.$assembleRegExp(i);if(!d)return!1;var l=1==i.backwards,e=0!=i.skipCurrent,t=i.range,n=i.start;(n=n||(t?t[l?"end":"start"]:h.selection.getRange())).start&&(n=n[e!=l?"end":"start"]);var r,c,o,s=t?t.start.row:0,a=t?t.end.row:h.getLength()-1;return r=l?function(e){var t=n.row;if(!o(t,n.column,e)){for(t--;s<=t;t--)if(o(t,Number.MAX_VALUE,e))return;if(0!=i.wrap)for(t=a,s=n.row;s<=t;t--)if(o(t,Number.MAX_VALUE,e))return}}:function(e){var t=n.row;if(!o(t,n.column,e)){for(t+=1;t<=a;t++)if(o(t,0,e))return;if(0!=i.wrap)for(t=s,a=n.row;t<=a;t++)if(o(t,0,e))return}},o=i.$isMultiLine?(c=d.length,function(e,t,i){var n=l?e-c+1:e;if(!(n<0)){var r=h.getLine(n),o=r.search(d[0]);if(!(!l&&o<t||-1===o)){for(var s=1;s<c;s++)if(-1==(r=h.getLine(n+s)).search(d[s]))return;var a=r.match(d[c-1])[0].length;if(!(l&&t<a))return!!i(n,o,n+c-1,a)||void 0}}}):l?function(e,t,i){var n,r=h.getLine(e),o=[];for(d.lastIndex=0;n=d.exec(r);){var s=n[0].length,a=n.index;if(!s){if(a>=r.length)break;d.lastIndex=a+=1}if(n.index+s>t)break;o.push(n.index,s)}for(var l=o.length-1;0<=l;l-=2){var c=o[l-1];if(i(e,c,e,c+(s=o[l])))return!0}}:function(e,t,i){var n,r=h.getLine(e);for(d.lastIndex=t;n=d.exec(r);){var o,s=n[0].length;if(i(e,o=n.index,e,o+s))return!0;if(!s&&(d.lastIndex=o+=1,o>=r.length))return!1}},{forEach:r}}}).call(n.prototype),t.Search=n}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";var a=e("../lib/keys"),n=e("../lib/useragent"),l=a.KEY_MODS;function r(e,t){this.platform=t||(n.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function o(e,t){r.call(this,e,t),this.$singleCommand=!1}o.prototype=r.prototype,function(){function s(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),(this.commands[e.name]=e).bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i=e&&("string"==typeof e?e:e.name);e=this.commands[i],t||delete this.commands[i];var n=this.commandKeyBinding;for(var r in n){var o,s=n[r];s==e?delete n[r]:!Array.isArray(s)||-1!=(o=s.indexOf(e))&&(s.splice(o,1),1==s.length&&(n[r]=s[0]))}},this.bindKey=function(e,o,s){if("object"==typeof e&&e&&(null==s&&(s=e.position),e=e[this.platform]),e)return"function"==typeof o?this.addCommand({exec:o,bindKey:e,name:o.name||e}):void e.split("|").forEach(function(e){var t,n="";-1!=e.indexOf(" ")&&(e=(t=e.split(/\s+/)).pop(),t.forEach(function(e){var t=this.parseKeys(e),i=l[t.hashId]+t.key;n+=(n?" ":"")+i,this._addCommandToBinding(n,"chainKeys")},this),n+=" ");var i=this.parseKeys(e),r=l[i.hashId]+i.key;this._addCommandToBinding(n+r,o,s)},this)},this._addCommandToBinding=function(e,t,i){var n=this.commandKeyBinding;if(t)if(!n[e]||this.$singleCommand)n[e]=t;else{Array.isArray(n[e])?-1!=(o=n[e].indexOf(t))&&n[e].splice(o,1):n[e]=[n[e]],"number"!=typeof i&&(i=s(t));for(var r=n[e],o=0;o<r.length;o++){if(i<s(r[o]))break}r.splice(o,0,t)}else delete n[e]},this.addCommands=function(i){i&&Object.keys(i).forEach(function(e){var t=i[e];if(t){if("string"==typeof t)return this.bindKey(t,e);"function"==typeof t&&(t={exec:t}),"object"==typeof t&&(t.name||(t.name=e),this.addCommand(t))}},this)},this.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},this.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=a[i];if(a.FUNCTION_KEYS[n])i=a.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,o=t.length;o--;){var s=a.KEY_MODS[t[o]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[o]+" in "+e),!1;r|=s}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){var i=l[e]+t;return this.commandKeyBinding[i]},this.handleKeyboard=function(e,t,i,n){if(!(n<0)){var r=l[t]+i,o=this.commandKeyBinding[r];return(e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1])?(e.$keyChain&&(t&&4!=t||1!=i.length?(-1==t||0<n)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(r.prototype),t.HashHandler=r,t.MultiHashHandler=o}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){o.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})}var r=e("../lib/oop"),o=e("../keyboard/hash_handler").MultiHashHandler,s=e("../lib/event_emitter").EventEmitter;r.inherits(n,o),function(){r.implement(this,s),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(0!=this.$checkCommandState&&e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:i};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(t){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(t);try{this.$inReplay=!0,this.macro.forEach(function(e){"string"==typeof e?this.exec(e,t):this.exec(e[0],t,e[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e})}}.call(n.prototype),t.CommandManager=n}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,i){"use strict";var c=e("../lib/lang"),n=e("../config"),h=e("../range").Range;function r(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",bindKey:r("Ctrl-,","Command-,"),exec:function(t){n.loadModule("ace/ext/settings_menu",function(e){e.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:r("Alt-E","F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:r("Alt-Shift-E","Shift-F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:r("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:r(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:r("Ctrl-L","Command-L"),exec:function(e,t){"number"!=typeof t||isNaN(t)||e.gotoLine(t),e.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:r("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:r("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:r("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:r("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:r("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:r("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:r("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:r("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:r("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:r("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:r("Ctrl-F","Command-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:r("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:r("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:r("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:r("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:r("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:r("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:r("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:r("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:r("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:r("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:r("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:r("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:r("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:r("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:r("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:r("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:r("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:r("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:r("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:r("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:r(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:r("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:r(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:r("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:r("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:r("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:r("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:r("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:r("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:r("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:r(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(e){},readOnly:!0},{name:"cut",description:"Cut",exec:function(e){var t=e.$copyWithEmptySelection&&e.selection.isEmpty()?e.selection.getLineRange():e.selection.getRange();e._emit("cut",t),t.isEmpty()||e.session.remove(t),e.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:r("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:r("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:r("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:r("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:r("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:r("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:r("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:r("Ctrl-H","Command-Option-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t,!0)})}},{name:"undo",description:"Undo",bindKey:r("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",description:"Redo",bindKey:r("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:r("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:r("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:r("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:r("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:r("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:r("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:r("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:r("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:r("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:r("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:r("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:r("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:r("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:r("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:r("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:r("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:r("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,t){e.insert(c.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:r(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:r("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:r("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:r("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:r(null,null),exec:function(e){e.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:r("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:r(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),n=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),r=e.session.doc.getLine(i.row).length,o=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,s=e.session.doc.getLine(i.row),a=i.row+1;a<=n.row+1;a++){var l=c.stringTrimLeft(c.stringTrimRight(e.session.doc.getLine(a)));0!==l.length&&(l=" "+l),s+=l}n.row+1<e.session.doc.getLength()-1&&(s+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new h(i.row,0,n.row+2,0),s),0<o?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+o)):(r=e.session.doc.getLine(i.row).length>r?r+1:r,e.selection.moveCursorTo(i.row,r))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:r(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,r=[];n.length<1&&(n=[e.selection.getRange()]);for(var o=0;o<n.length;o++)o==n.length-1&&(n[o].end.row===t&&n[o].end.column===i||r.push(new h(n[o].end.row,n[o].end.column,t,i))),0===o?0===n[o].start.row&&0===n[o].start.column||r.push(new h(0,0,n[o].start.row,n[o].start.column)):r.push(new h(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));e.exitMultiSelectMode(),e.clearSelection();for(o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",exec:function(e){e.selection.clearSelection(),e.navigateLineEnd(),e.insert("\n")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",exec:function(e){e.selection.clearSelection();var t=e.getCursorPosition();e.selection.moveTo(t.row-1,Number.MAX_VALUE),e.insert("\n"),0===t.row&&e.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command pallete",bindKey:r("F1","F1"),exec:function(e){e.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:r(null,null),exec:function(e){e.prompt({$type:"modes"})},readOnly:!0}];for(var o=1;o<9;o++)t.commands.push({name:"foldToLevel"+o,description:"Fold To Level "+o,level:o,exec:function(e){e.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/clipboard"],function(e,t,i){"use strict";e("./lib/fixoldbrowsers");var o=e("./lib/oop"),n=e("./lib/dom"),f=e("./lib/lang"),r=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,a=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,c=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,d=e("./search").Search,C=e("./range").Range,u=e("./lib/event_emitter").EventEmitter,g=e("./commands/command_manager").CommandManager,p=e("./commands/default_commands").commands,m=e("./config"),v=e("./token_iterator").TokenIterator,I=e("./clipboard"),A=function(e,t,i){this.$toDestroy=[];var n=e.getContainerElement();this.container=n,this.renderer=e,this.id="editor"+ ++A.$uid,this.commands=new g(r.isMac?"mac":"win",p),"object"==typeof document&&(this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new a(this),new l(this)),this.keyBinding=new c(this),this.$search=(new d).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=f.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||i&&i.session||new h("")),m.resetOptions(this),i&&this.setOptions(i),m._signal("editor",this)};A.$uid=0,function(){o.implement(this,u),this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=f.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},this.endOperation=function(e){if(this.curOp&&this.session){if(e&&!1===e.returnValue||!this.session)return this.curOp=null;if(1==e&&this.curOp.command&&"mouse"==this.curOp.command.name)return;if(this._signal("beforeEndOperation"),!this.curOp)return;var t=this.curOp.command,i=t&&t.scrollIntoView;if(i){switch(i){case"center-animate":i="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var n=this.selection.getRange(),r=this.renderer.layerConfig;(n.start.row>=r.lastRow||n.end.row<=r.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==i&&this.renderer.animateScrolling(this.curOp.scrollTop)}var o=this.selection.toJSON();this.curOp.selectionAfter=o,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(o),this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){var t,i,n,r;this.$mergeUndoDeltas&&(t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name,"insertstring"==e.command.name?(r=e.args,void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0):n=n&&-1!==i.indexOf(e.command.name),"always"!=this.$mergeUndoDeltas&&2e3<Date.now()-this.sequenceStartTime&&(n=!1),n?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now()))},this.setKeyboardHandler=function(t,i){var n;t&&"string"==typeof t&&"ace"!=t?(this.$keybindingId=t,n=this,m.loadModule(["keybinding",t],function(e){n.$keybindingId==t&&n.keyBinding.setKeyboardHandler(e&&e.handler),i&&i()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(t),i&&i())},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){var t,i;this.session!=e&&(this.curOp&&this.endOperation(),this.curOp={},(t=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(i=this.session.getSelection()).off("changeCursor",this.$onCursorChange),i.off("changeSelection",this.$onSelectionChange)),(this.session=e)?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart())},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||n.computedStyle(this.container).fontSize},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){var n;this.$highlightPending||((n=this).$highlightPending=!0,setTimeout(function(){n.$highlightPending=!1;var e,t,i=n.session;i&&i.bgTokenizer&&(i.$bracketHighlight&&(i.$bracketHighlight.markerIds.forEach(function(e){i.removeMarker(e)}),i.$bracketHighlight=null),!(e=i.getMatchingBracketRanges(n.getCursorPosition()))&&i.$mode.getMatching&&(e=i.$mode.getMatching(n.session)),e&&(t="ace_bracket",Array.isArray(e)?1==e.length&&(t="ace_error_bracket"):e=[e],2==e.length&&(0==C.comparePoints(e[0].end,e[1].start)?e=[
C.fromPoints(e[0].start,e[1].end)]:0==C.comparePoints(e[0].start,e[1].end)&&(e=[C.fromPoints(e[1].start,e[0].end)])),i.$bracketHighlight={ranges:e,markerIds:e.map(function(e){return i.addMarker(e,t,"text")})}))},50))},this.$highlightTags=function(){var m;this.$highlightTagPending||((m=this).$highlightTagPending=!0,setTimeout(function(){m.$highlightTagPending=!1;var e=m.session;if(e&&e.bgTokenizer){var t=m.getCursorPosition(),i=new v(m.session,t.row,t.column),n=i.getCurrentToken();if(!n||!/\b(?:tag-open|tag-name)/.test(n.type))return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);if(-1===n.type.indexOf("tag-open")||(n=i.stepForward())){var r=n.value,o=n.value,s=0,a=i.stepBackward();if("<"===a.value)for(;a=n,(n=i.stepForward())&&(-1!==n.type.indexOf("tag-name")?r===(o=n.value)&&("<"===a.value?s++:"</"===a.value&&s--):r===o&&"/>"===n.value&&s--),n&&0<=s;);else{do{if(n=a,a=i.stepBackward(),n)if(-1!==n.type.indexOf("tag-name"))r===n.value&&("<"===a.value?s++:"</"===a.value&&s--);else if("/>"===n.value){for(var l=0,c=a;c;){if(-1!==c.type.indexOf("tag-name")&&c.value===r){s--;break}if("<"===c.value)break;c=i.stepBackward(),l++}for(var h=0;h<l;h++)i.stepForward()}}while(a&&s<=0);i.stepForward()}if(!n)return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);var d=i.getCurrentTokenRow(),u=i.getCurrentTokenColumn(),g=new C(d,u,d,u+n.value.length),p=e.$backMarkers[e.$tagHighlight];e.$tagHighlight&&null!=p&&0!==g.compareRange(p.range)&&(e.removeMarker(e.$tagHighlight),e.$tagHighlight=null),e.$tagHighlight||(e.$tagHighlight=e.addMarker(g,"ace_bracket","text"))}}},50))},this.focus=function(){var e=this;setTimeout(function(){e.isFocused()||e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,i=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,i,t),this._signal("change",e),this.$cursorChange()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t,i=this.getSession();this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(e=!1),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(e=!1)),i.$highlightLineMarker&&!e?(i.removeMarker(i.$highlightLineMarker.id),i.$highlightLineMarker=null):!i.$highlightLineMarker&&e?((t=new C(e.row,e.column,e.row,1/0)).id=i.addMarker(t,"ace_active-line","screenLine"),i.$highlightLineMarker=t):e&&(i.$highlightLineMarker.start.row=e.row,i.$highlightLineMarker.end.row=e.row,i.$highlightLineMarker.start.column=e.column,i._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t,i,n=this.session;n.$selectionMarker&&n.removeMarker(n.$selectionMarker),n.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():(t=this.selection.getRange(),i=this.getSelectionStyle(),n.$selectionMarker=n.addMarker(t,"ace_selection",i));var r=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(r),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column,n=t.end.column,r=e.getLine(t.start.row),o=r.substring(i,n);if(!(5e3<o.length)&&/[\w\d]/.test(o)){var s=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:o}),a=r.substring(i-1,n+1);if(s.test(a))return s}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText(),t=this.session.doc.getNewLineCharacter(),i=!1;if(!e&&this.$copyWithEmptySelection){i=!0;for(var n=this.selection.getAllRanges(),r=0;r<n.length;r++){var o=n[r];r&&n[r-1].start.row==o.start.row||(e+=this.session.getLine(o.start.row)+t)}}var s={text:e};return this._signal("copy",s),I.lineMode=i?s.text:"",s.text},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var i={text:e,event:t};this.commands.exec("paste",this,i)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text,i=t==I.lineMode,n=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)i?n.insert({row:this.selection.lead.row,column:0},t):this.insert(t);else if(i)this.selection.rangeList.ranges.forEach(function(e){n.insert({row:e.start.row,column:0},t)});else{var r=t.split(/\r\n|\r|\n/),o=this.selection.rangeList.ranges,s=!(2!=r.length||r[0]&&r[1]);if(r.length!=o.length||s)return this.commands.exec("insertstring",this,t);for(var a=o.length;a--;){var l=o[a];l.isEmpty()||n.remove(l),n.insert(l.start,r[a])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i,n,r,o=this.session,s=o.getMode(),a=this.getCursorPosition();!this.getBehavioursEnabled()||t||(i=s.transformAction(o.getState(a.row),"insertion",this,o,e))&&(e!==i.text&&(this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1)),e=i.text),"\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&-1==e.indexOf("\n")&&((n=new C.fromPoints(a,a)).end.column+=e.length,this.session.remove(n)):(n=this.getSelectionRange(),a=this.session.remove(n),this.clearSelection()),"\n"!=e&&"\r\n"!=e||(d=o.getLine(a.row),a.column>d.search(/\S|$/)&&(r=d.substr(a.column).search(/\S|$/),o.doc.removeInLine(a.row,a.column,a.column+r))),this.clearSelection();var l,c=a.column,h=o.getState(a.row),d=o.getLine(a.row),u=s.checkOutdent(h,d,e);o.insert(a,e),i&&i.selection&&(2==i.selection.length?this.selection.setSelectionRange(new C(a.row,c+i.selection[0],a.row,c+i.selection[1])):this.selection.setSelectionRange(new C(a.row+i.selection[0],i.selection[1],a.row+i.selection[2],i.selection[3]))),this.$enableAutoIndent&&(o.getDocument().isNewLine(e)&&(l=s.getNextLineIndent(h,d.slice(0,a.column),o.getTabString()),o.insert({row:a.row+1,column:0},l)),u&&s.autoOutdent(h,o,a.row))},this.autoIndent=function(){var e,t,i,n=this.session,r=n.getMode();i=this.selection.isEmpty()?(t=0,n.doc.getLength()-1):(t=(e=this.getSelectionRange()).start.row,e.end.row);for(var o,s,a,l,c="",h="",d=n.getTabString(),u=t;u<=i;u++)0<u&&(c=n.getState(u-1),o=n.getLine(u-1),h=r.getNextLineIndent(c,o,d)),s=n.getLine(u),h!==(a=r.$getIndent(s))&&(0<a.length&&(l=new C(u,0,u,a.length),n.remove(l)),0<h.length&&n.insert({row:u,column:0},h)),r.autoOutdent(c,n,u)},this.onTextInput=function(e,t){if(!t)return this.keyBinding.onTextInput(e);this.startOperation({command:{name:"insertstring"}});var i=this.applyComposition.bind(this,e,t);this.selection.rangeCount?this.forEachSelection(i):i(),this.endOperation()},this.applyComposition=function(e,t){var i;(t.extendLeft||t.extendRight)&&((i=this.selection.getRange()).start.column-=t.extendLeft,i.end.column+=t.extendRight,i.start.column<0&&(i.start.row--,i.start.column+=this.session.getLine(i.start.row).length+1),this.selection.setRange(i),e||i.isEmpty()||this.remove()),!e&&this.selection.isEmpty()||this.insert(e,!0),(t.restoreStart||t.restoreEnd)&&((i=this.selection.getRange()).start.column-=t.restoreStart,i.end.column-=t.restoreEnd,this.selection.setRange(i))},this.onCommandKey=function(e,t,i){return this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t,i,n,r,o,s=this.getSelectionRange();this.getBehavioursEnabled()&&(i=(t=this.session).getState(s.start.row),n=t.getMode().transformAction(i,"deletion",this,t,s),0!==s.end.column||"\n"==(r=t.getTextRange(s))[r.length-1]&&(o=t.getLine(s.end.row),/^\s+$/.test(o)&&(s.end.column=o.length)),n&&(s=n)),this.session.remove(s),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){var e,t,i,n,r;!this.selection.isEmpty()||0!==(t=(e=this.getCursorPosition()).column)&&(r=t<(i=this.session.getLine(e.row)).length?(n=i.charAt(t)+i.charAt(t-1),new C(e.row,t-1,e.row,t+1)):(n=i.charAt(t-1)+i.charAt(t-2),new C(e.row,t-2,e.row,t)),this.session.replace(r,n),this.session.selection.moveToPosition(r.end))},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var i=e.getTextRange(t);if(!/^\s+$/.test(i)){c=this.$getSelectedRows();return void e.indentRows(c.first,c.last,"\t")}}var n=e.getLine(t.start.row),r=t.start,o=e.getTabSize(),s=e.documentToScreenColumn(r.row,r.column);if(this.session.getUseSoftTabs())var a=o-s%o,l=f.stringRepeat(" ",a);else{for(a=s%o;" "==n[t.start.column-1]&&a;)t.start.column--,a--;this.selection.setSelectionRange(t),l="\t"}return this.insert(l)}var c=this.$getSelectedRows();e.indentRows(c.first,c.last,"\t")},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,i=[],n=e.first;n<=e.last;n++)i.push(t.getLine(n));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});for(var r=new C(0,0,0,0),n=e.first;n<=e.last;n++){var o=t.getLine(n);r.start.row=n,r.end.row=n,r.end.column=o.length,t.replace(r,i[n-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g;i.lastIndex=0;for(var n=this.session.getLine(e);i.lastIndex<t;){var r=i.exec(n);if(r.index<=t&&r.index+r[0].length>=t)return{value:r[0],start:r.index,end:r.index+r[0].length}}return null},this.modifyNumber=function(e){var t,i,n,r,o,s,a=this.selection.getCursor().row,l=this.selection.getCursor().column,c=new C(a,l-1,a,l),h=this.session.getTextRange(c);!isNaN(parseFloat(h))&&isFinite(h)?(t=this.getNumberAt(a,l))&&(i=0<=t.value.indexOf(".")?t.start+t.value.indexOf(".")+1:t.end,n=t.start+t.value.length-i,r=parseFloat(t.value),r*=Math.pow(10,n),i!==t.end&&l<i?e*=Math.pow(10,t.end-l-1):e*=Math.pow(10,t.end-l),r+=e,o=(r/=Math.pow(10,n)).toFixed(n),s=new C(a,t.start,a,t.end),this.session.replace(s,o),this.moveCursorTo(a,Math.max(t.start+1,l+o.length-t.value.length))):this.toggleWord()},this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],this.toggleWord=function(){var i=this.selection.getCursor().row,e=this.selection.getCursor().column;this.selection.selectWord();var n=this.getSelectedText(),r=this.selection.getWordRange().start.column,t=n.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),o=e-r-1;o<0&&(o=0);var s,a=0,l=this;n.match(/[A-Za-z0-9_]+/)&&t.forEach(function(e,t){s=a+e.length,a<=o&&o<=s&&(n=e,l.selection.clearSelection(),l.moveCursorTo(i,a+r),l.selection.selectTo(i,s+r)),a=s});for(var c,h=this.$toggleWordPairs,d=0;d<h.length;d++)for(var u=h[d],g=0;g<=1;g++){var p=+!g,m=n.match(new RegExp("^\\s?_?("+f.escapeRegExp(u[g])+")\\s?$","i"));m&&n.match(new RegExp("([_]|^|\\s)("+f.escapeRegExp(m[1])+")($|\\s)","g"))&&(c=n.replace(new RegExp(f.escapeRegExp(u[g]),"i"),function(e){var t=u[p];return e.toUpperCase()==e?t=t.toUpperCase():e.charAt(0).toUpperCase()==e.charAt(0)&&(t=t.substr(0,0)+u[p].charAt(0).toUpperCase()+t.substr(1)),t}),this.insert(c))}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e,t,i,n=this.selection,r=this.session,o=n.getRange(),s=n.isBackwards();o.isEmpty()?(e=o.start.row,r.duplicateLines(e,e)):(t=s?o.start:o.end,i=r.insert(t,r.getTextRange(o),!1),o.start=t,o.end=i,n.setSelectionRange(o,s))},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var i=this.selection;if(!i.inMultiSelectMode||this.inVirtualSelectionMode){var n=i.toOrientedRange(),r=this.$getSelectedRows(n),o=this.session.$moveLines(r.first,r.last,t?0:e);t&&-1==e&&(o=0),n.moveBy(o,0),i.fromOrientedRange(n)}else{var s=i.rangeList.ranges;i.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var a=0,l=0,c=s.length,h=0;h<c;h++){var d=h;s[h].moveBy(a,0);for(var u=(r=this.$getSelectedRows(s[h])).first,g=r.last;++h<c;){l&&s[h].moveBy(l,0);var p=this.$getSelectedRows(s[h]);if(t&&p.first!=g)break;if(!t&&p.first>g+1)break;g=p.last}for(h--,a=this.session.$moveLines(u,g,t?0:e),t&&-1==e&&(d=h+1);d<=h;)s[d].moveBy(a,0),d++;t||(a=0),l+=a}i.fromOrientedRange(i.ranges[0]),i.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(e)},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,r=e*Math.floor(n.height/n.lineHeight);!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(r,0)}):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection());var o=i.scrollTop;i.scrollBy(0,r*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(o)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.selection.selectAll()},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var i=this.getCursorPosition(),n=new v(this.session,i.row,i.column),r=n.getCurrentToken(),o=r||n.stepForward();if(o){var s,a,l,c=!1,h={},d=i.column-o.start,u={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(o.value.match(/[{}()\[\]]/g)){for(;d<o.value.length&&!c;d++)if(u[o.value[d]])switch(a=u[o.value[d]]+"."+o.type.replace("rparen","lparen"),isNaN(h[a])&&(h[a]=0),o.value[d]){case"(":case"[":case"{":h[a]++;break;case")":case"]":case"}":h[a]--,-1===h[a]&&(s="bracket",c=!0)}}else-1!==o.type.indexOf("tag-name")&&(isNaN(h[o.value])&&(h[o.value]=0),"<"===r.value?h[o.value]++:"</"===r.value&&h[o.value]--,-1===h[o.value]&&(s="tag",c=!0));c||(r=o,o=n.stepForward(),d=0)}while(o&&!c);if(s){if("bracket"===s)(g=this.session.getBracketRange(i))||(l=(g=new C(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+d-1,n.getCurrentTokenRow(),n.getCurrentTokenColumn()+d-1)).start,(t||l.row===i.row&&Math.abs(l.column-i.column)<2)&&(g=this.session.getBracketRange(l)));else if("tag"===s){if(!o||-1===o.type.indexOf("tag-name"))return;var g,p=o.value;if(0===(g=new C(n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2,n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2)).compare(i.row,i.column))for(c=!1;o=r,(r=n.stepBackward())&&(-1!==r.type.indexOf("tag-close")&&g.setEnd(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+1),o.value===p&&-1!==o.type.indexOf("tag-name")&&("<"===r.value?h[p]++:"</"===r.value&&h[p]--,0===h[p]&&(c=!0))),r&&!c;);o&&o.type.indexOf("tag-name")&&(l=g.start).row==i.row&&Math.abs(l.column-i.column)<2&&(l=g.end)}(l=g&&g.cursor||l)&&(e?g&&t?this.selection.setRange(g):g&&g.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(l.row,l.column):this.selection.moveTo(l.row,l.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var i=this.$search.find(this.session),n=0;return i&&(this.$tryReplace(i,e)&&(n=1),this.selection.setSelectionRange(i),this.renderer.scrollSelectionIntoView(i.start,i.end)),n},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;var r=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=i.length-1;0<=o;--o)this.$tryReplace(i[o],e)&&n++;return this.selection.setSelectionRange(r),n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return null!==(t=this.$search.replace(i,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,i){t=t||{},"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&o.mixin(t,e);var n=this.selection.getRange();null==t.needle&&((e=this.session.getTextRange(n)||this.$search.$options.needle)||(n=this.session.getWordRange(n.start.row,n.start.column),e=this.session.getTextRange(n)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:n});var r=this.$search.find(this.session);return t.preventScroll?r:r?(this.revealRange(r,i),r):(t.backwards?n.start=n.end:n.end=n.start,void this.selection.setRange(n))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.session.unfold(e),this.selection.setSelectionRange(e);var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(i)},this.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(e){e.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},this.setAutoScrollEditorIntoView=function(e){var r,o,s,a,t,i,n;e&&(s=!1,(o=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(a=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(a,this.container.firstChild),t=this.on("changeSelection",function(){s=!0}),i=this.renderer.on("beforeRender",function(){s&&(r=o.renderer.container.getBoundingClientRect())}),n=this.renderer.on("afterRender",function(){var e,t,i,n;s&&r&&(o.isFocused()||o.searchBox&&o.searchBox.isFocused())&&(t=(e=o.renderer).$cursorLayer.$pixelPos,i=e.layerConfig,n=t.top-i.offset,null!=(s=0<=t.top&&n+r.top<0||!(t.top<i.height&&t.top+r.top+i.lineHeight>window.innerHeight)&&null)&&(a.style.top=n+"px",a.style.left=t.left+"px",a.style.height=i.lineHeight+"px",a.scrollIntoView(s)),s=r=null)}),this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",t),this.renderer.off("afterRender",n),this.renderer.off("beforeRender",i))})},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,n.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))},this.prompt=function(t,i,n){var r=this;m.loadModule("./ext/prompt",function(e){e.prompt(r,t,i,n)})}}.call(A.prototype),m.defineOptions(A.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.textInput.setReadOnly(e),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(e){this.textInput.setCopyWithEmptySelection(e)},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(e){this.session.setValue(e)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(e){this.setSession(e)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(e){this.renderer.$gutterLayer.setShowLineNumbers(e),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),e&&this.$relativeLineNumbers?b.attach(this):b.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(e){this.$showLineNumbers&&e?b.attach(this):b.detach(this)}},placeholder:{set:function(e){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var e,t=this.session&&(this.renderer.$composition||this.getValue());t&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),n.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):t||this.renderer.placeholderNode?!t&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),n.addCssClass(this.container,"ace_hasPlaceholder"),(e=n.createElement("div")).className="ace_placeholder",e.textContent=this.$placeholder||"",this.renderer.placeholderNode=e,this.renderer.content.appendChild(this.renderer.placeholderNode))}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var b={getText:function(e,t){return(Math.abs(e.selection.lead.row-t)||t+1+(t<9?"·":""))+""},getWidth:function(e,t,i){return Math.max(t.toString().length,(i.lastRow+1).toString().length,2)*i.characterWidth},update:function(e,t){t.renderer.$loop.schedule(t.renderer.CHANGE_GUTTER)},attach:function(e){e.renderer.$gutterLayer.$renderer=this,e.on("changeSelection",this.update),this.update(null,e)},detach:function(e){e.renderer.$gutterLayer.$renderer==this&&(e.renderer.$gutterLayer.$renderer=null),e.off("changeSelection",this.update),this.update(null,e)}};t.Editor=A}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.$maxRev=0,this.$fromUndo=!1,this.reset()}(function(){this.addSession=function(e){this.$session=e},this.add=function(e,t,i){this.$fromUndo||e!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),!1!==t&&this.lastDeltas||(this.lastDeltas=[],this.$undoStack.push(this.lastDeltas),e.id=this.$rev=++this.$maxRev),"remove"!=e.action&&"insert"!=e.action||(this.$lastDelta=e),this.lastDeltas.push(e))},this.addSelection=function(e,t){this.selections.push({value:e,rev:t||this.$rev})},this.startNewGroup=function(){return this.lastDeltas=null,this.$rev},this.markIgnored=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=i.length;n--;){var r=i[n][0];if(r.id<=e)break;r.id<t&&(r.ignore=!0)}this.lastDeltas=null},this.getSelection=function(e,t){for(var i=this.selections,n=i.length;n--;){var r=i[n];if(r.rev<e)return t&&(r=i[n+1]),r}},this.getRevision=function(){return this.$rev},this.getDeltas=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=null,r=0,o=i.length;o--;){var s=i[o][0];if(s.id<t&&!n&&(n=o+1),s.id<=e){r=o+1;break}}return i.slice(r,n)},this.getChangedRanges=function(e,t){null==t&&(t=this.$rev+1)},this.getChangedLines=function(e,t){null==t&&(t=this.$rev+1)},this.undo=function(e,t){this.lastDeltas=null;var i=this.$undoStack;if(function(e,t){for(var i=t;i--;){var n=e[i];if(n&&!n[0].ignore){for(;i<t-1;){var r=function(e,t){for(var i=e.length;i--;)for(var n=0;n<t.length;n++)if(!c(e[i],t[n])){for(;i<e.length;){for(;n--;)c(t[n],e[i]);n=t.length,i++}return[e,t]}return e.selectionBefore=t.selectionBefore=e.selectionAfter=t.selectionAfter=null,[t,e]}(e[i],e[i+1]);e[i]=r[0],e[i+1]=r[1],i++}return!0}}}(i,i.length)){e=e||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0;var n=i.pop(),r=null;return n&&(r=e.undoChanges(n,t),this.$redoStack.push(n),this.$syncRev()),this.$fromUndo=!1,r}},this.redo=function(e,t){var i;this.lastDeltas=null,e=e||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev&&(i=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),function(e,t){for(var i=0;i<t.length;i++)for(var n=t[i],r=0;r<n.length;r++)!function(e,t){t=function(e){return{start:l(e.start),end:l(e.end),action:e.action,lines:e.lines.slice()}}(t);for(var i=e.length;i--;){for(var n=e[i],r=0;r<n.length;r++){var o=function(e,t){var i,n,r="insert"==e.action,o="insert"==t.action;if(r&&o)a(e.start,t.start)<0?h(t,e,1):h(e,t,1);else if(r&&!o)0<=a(e.start,t.end)?h(e,t,-1):(a(e.start,t.start)<=0||h(e,s.fromPoints(t.start,e.start),-1),h(t,e,1));else if(!r&&o)0<=a(t.start,e.end)?h(t,e,-1):(a(t.start,e.start)<=0||h(t,s.fromPoints(e.start,t.start),-1),h(e,t,1));else if(!r&&!o)if(0<=a(t.start,e.end))h(t,e,-1);else{if(!(a(t.end,e.start)<=0))return a(e.start,t.start)<0&&(e=u(i=e,t.start)),0<a(e.end,t.end)&&(n=u(e,t.end)),d(t.end,e.start,e.end,-1),n&&!i&&(e.lines=n.lines,e.start=n.start,e.end=n.end,n=e),[t,i,n].filter(Boolean);h(e,t,-1)}return[t,e]}(n[r],t);t=o[0],2!=o.length&&(o[2]?(n.splice(r+1,1,o[1],o[2]),r++):o[1]||(n.splice(r,1),r--))}n.length||e.splice(i,1)}}(e,n[r])}(this.$redoStack,i),this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(e){e[0].id=++this.$maxRev},this));var n=this.$redoStack.pop(),r=null;return n&&(r=e.redoChanges(n,t),this.$undoStack.push(n),this.$syncRev()),this.$fromUndo=!1,r},this.$syncRev=function(){var e=this.$undoStack,t=e[e.length-1],i=t&&t[0].id||0;this.$redoStackBaseRev=i,this.$rev=i},this.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},this.canUndo=function(){return 0<this.$undoStack.length},this.canRedo=function(){return 0<this.$redoStack.length},this.bookmark=function(e){null==e&&(e=this.$rev),this.mark=e},this.isAtBookmark=function(){return this.$rev===this.mark},this.toJSON=function(){},this.fromJSON=function(){},this.hasUndo=this.canUndo,this.hasRedo=this.canRedo,this.isClean=this.isAtBookmark,this.markClean=this.bookmark,this.$prettyPrint=function(e){return e?r(e):r(this.$undoStack)+"\n---\n"+r(this.$redoStack)}}).call(n.prototype);var s=e("./range").Range,a=s.comparePoints;s.comparePoints;function l(e){return{row:e.row,column:e.column}}function r(e){if(e=e||this,Array.isArray(e))return e.map(r).join("\n");var t="";return e.action?(t="insert"==e.action?"+":"-",t+="["+e.lines+"]"):e.value&&(t=Array.isArray(e.value)?e.value.map(o).join("\n"):o(e.value)),e.start&&(t+=o(e)),(e.id||e.rev)&&(t+="\t("+(e.id||e.rev)+")"),t}function o(e){return e.start.row+":"+e.start.column+"=>"+e.end.row+":"+e.end.column}function c(e,t){var i="insert"==e.action,n="insert"==t.action;if(i&&n)if(0<=a(t.start,e.end))h(t,e,-1);else{if(!(a(t.start,e.start)<=0))return;h(e,t,1)}else if(i&&!n)if(0<=a(t.start,e.end))h(t,e,-1);else{if(!(a(t.end,e.start)<=0))return;h(e,t,-1)}else if(!i&&n)if(0<=a(t.start,e.start))h(t,e,1);else{if(!(a(t.start,e.start)<=0))return;h(e,t,1)}else if(!i&&!n)if(0<=a(t.start,e.start))h(t,e,1);else{if(!(a(t.end,e.start)<=0))return;h(e,t,-1)}return 1}function h(e,t,i){d(e.start,t.start,t.end,i),d(e.end,t.start,t.end,i)}function d(e,t,i,n){e.row==(1==n?t:i).row&&(e.column+=n*(i.column-t.column)),e.row+=n*(i.row-t.row)}function u(e,t){var i=e.lines,n=e.end;e.end=l(t);var r=e.end.row-e.start.row,o=i.splice(r,i.length),s=r?t.column:t.column-e.start.column;return i.push(o[0].substring(0,s)),o[0]=o[0].substr(s),{start:l(t),end:n,lines:o,action:e.action}}t.UndoManager=n}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e,t){this.element=e,this.canvasHeight=t||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}var s=e("../lib/dom");(function(){this.moveContainer=function(e){s.translate(this.element,0,-(e.firstRowScreen*e.lineHeight%this.canvasHeight)-e.offset*this.$offsetCoefficient)},this.pageChanged=function(e,t){return Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight)!==Math.floor(t.firstRowScreen*t.lineHeight/this.canvasHeight)},this.computeLineTop=function(e,t,i){var n=t.firstRowScreen*t.lineHeight,r=Math.floor(n/this.canvasHeight);return i.documentToScreenRow(e,0)*t.lineHeight-r*this.canvasHeight},this.computeLineHeight=function(e,t,i){return t.lineHeight*i.getRowLineCount(e)},this.getLength=function(){return this.cells.length},this.get=function(e){return this.cells[e]},this.shift=function(){this.$cacheCell(this.cells.shift())},this.pop=function(){this.$cacheCell(this.cells.pop())},this.push=function(e){if(Array.isArray(e)){this.cells.push.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.appendChild(t)}else this.cells.push(e),this.element.appendChild(e.element)},this.unshift=function(e){if(Array.isArray(e)){this.cells.unshift.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.firstChild?this.element.insertBefore(t,this.element.firstChild):this.element.appendChild(t)}else this.cells.unshift(e),this.element.insertAdjacentElement("afterbegin",e.element)},this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},this.$cacheCell=function(e){e&&(e.element.remove(),this.cellCache.push(e))},this.createCell=function(e,t,i,n){var r,o=this.cellCache.pop();return o||(r=s.createElement("div"),n&&n(r),this.element.appendChild(r),o={element:r,text:"",row:e}),o.row=e,o}}).call(n.prototype),t.Lines=n}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines"],function(e,t,i){"use strict";function n(e){this.element=v.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new s(this.element),this.$lines.$offsetCoefficient=1}var v=e("../lib/dom"),r=e("../lib/oop"),a=e("../lib/lang"),o=e("../lib/event_emitter").EventEmitter,s=e("./lines").Lines;function c(e){var t=document.createTextNode("");e.appendChild(t);var i=v.createElement("span");return e.appendChild(i),e}(function(){r.implement(this,o),this.setSession=function(e){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=(r=this.$annotations[n])||(this.$annotations[n]={text:[]}),o=(o=i.text)?a.escapeHTML(o):i.html||"";-1===r.text.indexOf(o)&&r.text.push(o);var s=i.type;"error"==s?r.className=" ace_error":"warning"==s&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=s||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){var t,i,n;this.$annotations.length&&(t=e.start.row,0==(i=e.end.row-t)||("remove"==e.action?this.$annotations.splice(t,1+i,null):((n=new Array(1+i)).unshift(t,1),this.$annotations.splice.apply(this.$annotations,n))))},this.update=function(e){this.config=e;var t=this.session,i=e.firstRow,n=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1);this.oldLastRow=n,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow();for(var r=t.getNextFoldLine(i),o=r?r.start.row:1/0,s=null,a=-1,l=i;;){if(o<l&&(l=r.end.row+1,o=(r=t.getNextFoldLine(l,r))?r.start.row:1/0),n<l){for(;this.$lines.getLength()>a+1;)this.$lines.pop();break}(s=this.$lines.get(++a))?s.row=l:(s=this.$lines.createCell(l,e,this.session,c),this.$lines.push(s)),this.$renderCell(s,e,r,l),l++}this._signal("afterRender"),this.$updateGutterWidth(e)},this.$updateGutterWidth=function(e){var t=this.session,i=t.gutterRenderer||this.$renderer,n=t.$firstLineNumber,r=this.$lines.last()?this.$lines.last().text:"";(this.$fixedWidth||t.$useWrapMode)&&(r=t.getLength()+n-1);var o=i?i.getWidth(t,r,e):r.toString().length*e.characterWidth,s=this.$padding||this.$computePadding();(o+=s.left+s.right)===this.gutterWidth||isNaN(o)||(this.gutterWidth=o,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",o))},this.$updateCursorRow=function(){var e;this.$highlightGutterLine&&(e=this.session.selection.getCursor(),this.$cursorRow!==e.row&&(this.$cursorRow=e.row))},this.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var t=this.$lines.cells;this.$cursorCell=null;for(var i=0;i<t.length;i++){var n=t[i];if(n.row>=this.$cursorRow){if(n.row>this.$cursorRow){var r=this.session.getFoldLine(this.$cursorRow);if(!(0<i&&r&&r.start.row==t[i-1].row))break;n=t[i-1]}n.element.className="ace_gutter-active-line "+n.element.className,this.$cursorCell=n;break}}}}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),n=this.oldLastRow;if(this.oldLastRow=i,!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(i<n)for(r=this.session.getFoldedRowCount(i+1,n);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,t.firstRow-1)),n<i&&this.$lines.push(this.$renderLines(e,n+1,i)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},this.$renderLines=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session,c);this.$renderCell(a,e,o,r),n.push(a),r++}return n},this.$renderCell=function(e,t,i,n){var r,o,s=e.element,a=this.session,l=s.childNodes[0],c=s.childNodes[1],h=a.$firstLineNumber,d=a.$breakpoints,u=a.$decorations,g=a.gutterRenderer||this.$renderer,p=this.$showFoldWidgets&&a.foldWidgets,m=i?i.start.row:Number.MAX_VALUE,f="ace_gutter-cell ";this.$highlightGutterLine&&(n==this.$cursorRow||i&&n<this.$cursorRow&&m<=n&&this.$cursorRow<=i.end.row)&&(f+="ace_gutter-active-line ",this.$cursorCell!=e&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e)),d[n]&&(f+=d[n]),u[n]&&(f+=u[n]),this.$annotations[n]&&(f+=this.$annotations[n].className),s.className!=f&&(s.className=f),!p||null==(r=p[n])&&(r=p[n]=a.getFoldWidget(n)),r?(f="ace_fold-widget ace_"+r,"start"==r&&n==m&&n<i.end.row?f+=" ace_closed":f+=" ace_open",c.className!=f&&(c.className=f),o=t.lineHeight+"px",v.setStyle(c.style,"height",o),v.setStyle(c.style,"display","inline-block")):c&&v.setStyle(c.style,"display","none");var C=(g?g.getText(a,n):n+h).toString();return C!==l.data&&(l.data=C),v.setStyle(e.element.style,"height",this.$lines.computeLineHeight(n,t,a)+"px"),v.setStyle(e.element.style,"top",this.$lines.computeLineTop(n,t,a)+"px"),e.text=C,e},this.$fixedWidth=!1,this.$highlightGutterLine=!0,this.$renderer="",this.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?v.addCssClass(this.element,"ace_folding-enabled"):v.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=v.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}).call(n.prototype),t.Gutter=n}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)}var g=e("../range").Range,r=e("../lib/dom");(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.elt=function(e,t){var i=-1!=this.i&&this.element.childNodes[this.i];i?this.i++:(i=document.createElement("div"),this.element.appendChild(i),this.i=-1),i.style.cssText=t,i.className=e},this.update=function(e){if(e){var t;for(var i in this.config=e,this.i=0,this.markers){var n,r,o,s=this.markers[i];s.range?(o=s.range.clipRows(e.firstRow,e.lastRow)).isEmpty()||(o=o.toScreenRange(this.session),s.renderer?(n=this.$getTop(o.start.row,e),r=this.$padding+o.start.column*e.characterWidth,s.renderer(t,o,r,n,e)):"fullLine"==s.type?this.drawFullLineMarker(t,o,s.clazz,e):"screenLine"==s.type?this.drawScreenLineMarker(t,o,s.clazz,e):o.isMultiLine()?"text"==s.type?this.drawTextMarker(t,o,s.clazz,e):this.drawMultiLineMarker(t,o,s.clazz,e):this.drawSingleLineMarker(t,o,s.clazz+" ace_start ace_br15",e)):s.update(t,this,this.session,e)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,i,n,r){for(var o,s=this.session,a=t.start.row,l=t.end.row,c=a,h=0,d=s.getScreenLastRowColumn(c),u=new g(c,t.start.column,c,h);c<=l;c++)u.start.row=u.end.row=c,u.start.column=c==a?t.start.column:s.getRowWrapIndent(c),o=h,h=u.end.column=d,d=c+1<l?s.getScreenLastRowColumn(c+1):c==l?0:t.end.column,this.drawSingleLineMarker(e,u,i+(c==a?" ace_start":"")+" ace_br"+((c==a||c==a+1&&t.start.column?1:0)|(o<h?2:0)|(d<h?4:0)|(c==l?8:0)),n,c==l?0:1,r)},this.drawMultiLineMarker=function(e,t,i,n,r){var o,s,a,l=this.$padding,c=n.lineHeight,h=this.$getTop(t.start.row,n),d=l+t.start.column*n.characterWidth;r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row)?((o=t.clone()).end.row=o.start.row,o.end.column=this.session.getLine(o.start.row).length,this.drawBidiSingleLineMarker(e,o,i+" ace_br1 ace_start",n,null,r)):this.elt(i+" ace_br1 ace_start","height:"+c+"px;right:0;top:"+h+"px;left:"+d+"px;"+(r||"")),this.session.$bidiHandler.isBidiRow(t.end.row)?((o=t.clone()).start.row=o.end.row,o.start.column=0,this.drawBidiSingleLineMarker(e,o,i+" ace_br12",n,null,r)):(h=this.$getTop(t.end.row,n),s=t.end.column*n.characterWidth,this.elt(i+" ace_br12","height:"+c+"px;width:"+s+"px;top:"+h+"px;left:"+l+"px;"+(r||""))),(c=(t.end.row-t.start.row-1)*n.lineHeight)<=0||(h=this.$getTop(t.start.row+1,n),a=(t.start.column?1:0)|(t.end.column?0:8),this.elt(i+(a?" ace_br"+a:""),"height:"+c+"px;right:0;top:"+h+"px;left:"+l+"px;"+(r||"")))},this.drawSingleLineMarker=function(e,t,i,n,r,o){if(this.session.$bidiHandler.isBidiRow(t.start.row))return this.drawBidiSingleLineMarker(e,t,i,n,r,o);var s=n.lineHeight,a=(t.end.column+(r||0)-t.start.column)*n.characterWidth,l=this.$getTop(t.start.row,n),c=this.$padding+t.start.column*n.characterWidth;this.elt(i,"height:"+s+"px;width:"+a+"px;top:"+l+"px;left:"+c+"px;"+(o||""))},this.drawBidiSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=this.$getTop(t.start.row,n),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(e){this.elt(i,"height:"+s+"px;width:"+e.width+(r||0)+"px;top:"+a+"px;left:"+(l+e.left)+"px;"+(o||""))},this)},this.drawFullLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-o),this.elt(i,"height:"+s+"px;top:"+o+"px;left:0;right:0;"+(r||""))},this.drawScreenLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;this.elt(i,"height:"+s+"px;top:"+o+"px;left:0;right:0;"+(r||""))}}).call(n.prototype),t.Marker=n}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.dom=c,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new o(this.element)}var r=e("../lib/oop"),c=e("../lib/dom"),v=e("../lib/lang"),o=e("./lines").Lines,s=e("../lib/event_emitter").EventEmitter;(function(){r.implement(this,s),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.MAX_LINE_LENGTH=1e4,this.$updateEolChar=function(){var e=this.session.doc,t="\n"==e.getNewLineCharacter()&&"windows"!=e.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=t)return this.EOL_CHAR=t,!0},this.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){(this.session=e)&&this.$computeTabString()},this.showInvisibles=!1,this.showSpaces=!1,this.showTabs=!1,this.showEOL=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&("string"==typeof(this.showInvisibles=e)?(this.showSpaces=/tab/i.test(e),this.showTabs=/space/i.test(e),this.showEOL=/eol/i.test(e)):this.showSpaces=this.showTabs=this.showEOL=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t,i,n,r,o,s,a=this.$tabStrings=[0],l=1;l<e+1;l++){this.showTabs?((s=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",s.textContent=v.stringRepeat(this.TAB_CHAR,l),a.push(s)):a.push(this.dom.createTextNode(v.stringRepeat(" ",l),this.element))}this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,t="ace_indent-guide",i=this.showSpaces?" ace_invisible ace_invisible_space":"",n=this.showSpaces?v.stringRepeat(this.SPACE_CHAR,this.tabSize):v.stringRepeat(" ",this.tabSize),r=this.showTabs?" ace_invisible ace_invisible_tab":"",o=this.showTabs?v.stringRepeat(this.TAB_CHAR,this.tabSize):n,(s=this.dom.createElement("span")).className=t+i,s.textContent=n,this.$tabStrings[" "]=s,(s=this.dom.createElement("span")).className=t+r,s.textContent=o,this.$tabStrings["\t"]=s)},this.updateLines=function(e,t,i){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var n=Math.max(t,e.firstRow),r=Math.min(i,e.lastRow),o=this.element.childNodes,s=0,a=e.firstRow;a<n;a++){if(l=this.session.getFoldLine(a)){if(l.containsRow(n)){n=l.start.row;break}a=l.end.row}s++}for(var l,c=!1,a=n,h=(l=this.session.getNextFoldLine(a))?l.start.row:1/0;h<a&&(a=l.end.row+1,h=(l=this.session.getNextFoldLine(a,l))?l.start.row:1/0),!(r<a);){var d,u=o[s++];u&&(this.dom.removeChildren(u),this.$renderLine(u,a,a==h&&l),c&&(u.style.top=this.$lines.computeLineTop(a,e,this.session)+"px"),d=e.lineHeight*this.session.getRowLength(a)+"px",u.style.height!=d&&(c=!0,u.style.height=d)),a++}if(c)for(;s<this.$lines.cells.length;){var g=this.$lines.cells[s++];g.element.style.top=this.$lines.computeLineTop(g.row,e,this.session)+"px"}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=e.lastRow,n=t?t.lastRow:-1;if(!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(t.lastRow>e.lastRow)for(r=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,t.firstRow-1)),e.lastRow>t.lastRow&&this.$lines.push(this.$renderLinesFragment(e,t.lastRow+1,e.lastRow))},this.$renderLinesFragment=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session),l=a.element;this.dom.removeChildren(l),c.setStyle(l.style,"height",this.$lines.computeLineHeight(r,e,this.session)+"px"),c.setStyle(l.style,"top",this.$lines.computeLineTop(r,e,this.session)+"px"),this.$renderLine(l,r,r==s&&o),this.$useLineGroups()?l.className="ace_line_group":l.className="ace_line",n.push(a),r++}return n},this.update=function(e){this.$lines.moveContainer(e);for(var t=(this.config=e).firstRow,i=e.lastRow,n=this.$lines;n.getLength();)n.pop();n.push(this.$renderLinesFragment(e,t,i))},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,i,n){for(var r,o,s=this,a=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,l=this.dom.createFragment(this.element),c=0;r=a.exec(n);){var h,d,u,g=r[1],p=r[2],m=r[3],f=r[4],C=r[5];!s.showSpaces&&p||(h=c!=r.index?n.slice(c,r.index):"",c=r.index+r[0].length,h&&l.appendChild(this.dom.createTextNode(h,this.element)),g?(d=s.session.getScreenTabSize(t+r.index),l.appendChild(s.$tabStrings[d].cloneNode(!0)),t+=d-1):p?s.showSpaces?((u=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",u.textContent=v.stringRepeat(s.SPACE_CHAR,p.length),l.appendChild(u)):l.appendChild(this.com.createTextNode(p,this.element)):m?((u=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",u.textContent=v.stringRepeat(s.SPACE_CHAR,m.length),l.appendChild(u)):f?(t+=1,(u=this.dom.createElement("span")).style.width=2*s.config.characterWidth+"px",u.className=s.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",u.textContent=s.showSpaces?s.SPACE_CHAR:f,l.appendChild(u)):C&&(t+=1,(u=this.dom.createElement("span")).style.width=2*s.config.characterWidth+"px",u.className="ace_cjk",u.textContent=C,l.appendChild(u)))}return l.appendChild(this.dom.createTextNode(c?n.slice(c):n,this.element)),this.$textToken[i.type]?e.appendChild(l):(o="ace_"+i.type.replace(/\./g," ace_"),u=this.dom.createElement("span"),"fold"==i.type&&(u.style.width=i.value.length*this.config.characterWidth+"px"),u.className=o,u.appendChild(l),e.appendChild(u)),t+n.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);if(n<=0||i<=n)return t;if(" "==t[0]){for(var r=(n-=n%this.tabSize)/this.tabSize,o=0;o<r;o++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return t.substr(n)}if("\t"!=t[0])return t;for(o=0;o<n;o++)e.appendChild(this.$tabStrings["\t"].cloneNode(!0));return t.substr(n)},this.$createLineElement=function(e){var t=this.dom.createElement("div");return t.className="ace_line",t.style.height=this.config.lineHeight+"px",t},this.$renderWrappedLine=function(e,t,i){var n=0,r=0,o=i[0],s=0,a=this.$createLineElement();e.appendChild(a);for(var l=0;l<t.length;l++){var c=t[l],h=c.value;if(0==l&&this.displayIndentGuides){if(n=h.length,!(h=this.renderIndentGuide(a,h,o)))continue;n-=h.length}if(n+h.length<o)s=this.$renderToken(a,s,c,h),n+=h.length;else{for(;n+h.length>=o;)s=this.$renderToken(a,s,c,h.substring(0,o-n)),h=h.substring(o-n),n=o,a=this.$createLineElement(),e.appendChild(a),a.appendChild(this.dom.createTextNode(v.stringRepeat(" ",i.indent),this.element)),s=0,o=i[++r]||Number.MAX_VALUE;0!=h.length&&(n+=h.length,s=this.$renderToken(a,s,c,h))}}i[i.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(a,s,null,"",!0)},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],r=n.value;this.displayIndentGuides&&(r=this.renderIndentGuide(e,r)),r&&(i=this.$renderToken(e,i,n,r));for(var o=1;o<t.length;o++){if(i+(r=(n=t[o]).value).length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,i,n,r);i=this.$renderToken(e,i,n,r)}},this.$renderOverflowMessage=function(e,t,i,n,r){i&&this.$renderToken(e,t,i,n.slice(0,this.MAX_LINE_LENGTH-t));var o=this.dom.createElement("span");o.className="ace_inline_button ace_keyword ace_toggle_wrap",o.textContent=r?"<hide>":"<click to see more...>",e.appendChild(o)},this.$renderLine=function(e,t,i){var n;i||0==i||(i=this.session.getFoldLine(t));var r,o,s=e;(n=i?this.$getFoldLineTokens(t,i):this.session.getTokens(t)).length?(r=this.session.getRowSplitData(t))&&r.length?(this.$renderWrappedLine(e,n,r),s=e.lastChild):(s=e,this.$useLineGroups()&&(s=this.$createLineElement(),e.appendChild(s)),this.$renderSimpleLine(s,n)):this.$useLineGroups()&&(s=this.$createLineElement(),e.appendChild(s)),this.showEOL&&s&&(i&&(t=i.end.row),(o=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",o.textContent=t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,s.appendChild(o))},this.$getFoldLineTokens=function(e,t){var o=this.session,s=[];var a=o.getTokens(e);return t.walk(function(e,t,i,n,r){null!=e?s.push({type:"fold",value:e}):(r&&(a=o.getTokens(t)),a.length&&function(e,t,i){for(var n,r=0,o=0;o+e[r].value.length<t;)if(o+=e[r].value.length,++r==e.length)return;for(o!=t&&((n=e[r].value.substring(t-o)).length>i-t&&(n=n.substring(0,i-t)),s.push({type:e[r].type,value:n}),o=t+n.length,r+=1);o<i&&r<e.length;){(n=e[r].value).length+o>i?s.push({type:e[r].type,value:n.substring(0,i-o)}):s.push(e[r]),o+=n.length,r+=1}}(a,n,i))},t.end.row,this.session.getLine(t.end.row).length),s},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){}}).call(n.prototype),t.Text=n}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=c.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),c.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}var c=e("../lib/dom");(function(){this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)c.setStyle(t[i].style,"opacity",e?"":"0")},this.$startCssAnimation=function(){for(var e=this.cursors,t=e.length;t--;)e[t].style.animationDuration=this.blinkInterval+"ms";setTimeout(function(){c.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},this.$stopCssAnimation=function(){c.removeCssClass(this.element,"ace_animate-blinking")},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e!=this.smoothBlinking&&(this.smoothBlinking=e,c.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.restartTimer())},this.addCursor=function(){var e=c.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(1<this.cursors.length){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,
c.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,c.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e,t=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&c.removeCssClass(this.element,"ace_smooth-blinking"),t(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&setTimeout(function(){c.addCssClass(this.element,"ace_smooth-blinking")}.bind(this)),c.HAS_CSS_ANIMATION?this.$startCssAnimation():(e=function(){this.timeoutId=setTimeout(function(){t(!1)},.6*this.blinkInterval)}.bind(this),this.intervalId=setInterval(function(){t(!0),e()},this.blinkInterval),e())):this.$stopCssAnimation()},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e=e||this.session.selection.getCursor();var i=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e.row)?this.session.$bidiHandler.getPosLeft(i.column):i.column*this.config.characterWidth),top:(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.isCursorInView=function(e,t){return 0<=e.top&&e.top<t.maxHeight},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,i=0,n=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]);for(var i=0,r=t.length;i<r;i++){var o,s,a=this.getPixelPosition(t[i].cursor,!0);(a.top>e.height+e.offset||a.top<0)&&1<i||(s=(o=this.cursors[n++]||this.addCursor()).style,this.drawCursor?this.drawCursor(o,a,e,t[i],this.session):this.isCursorInView(a,e)?(c.setStyle(s,"display","block"),c.translate(o,a.left,a.top),c.setStyle(s,"width",Math.round(e.characterWidth)+"px"),c.setStyle(s,"height",e.lineHeight+"px")):c.setStyle(s,"display","none"))}for(;this.cursors.length>n;)this.removeCursor();var l=this.session.getOverwrite();this.$setOverwrite(l),this.$pixelPos=a,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&((this.overwrite=e)?c.addCssClass(this.element,"ace_overwrite-cursors"):c.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(n.prototype),t.Cursor=n}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.element=o.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=o.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,s.addListener(this.element,"scroll",this.onScroll.bind(this)),s.addListener(this.element,"mousedown",s.preventDefault)}var r=e("./lib/oop"),o=e("./lib/dom"),s=e("./lib/event"),a=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,a),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(n.prototype);function l(e,t){n.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=o.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0}r.inherits(l,n),function(){this.classSuffix="-v",this.onScroll=function(){var e;this.skipEvent||(this.scrollTop=this.element.scrollTop,1!=this.coeff&&(e=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(l.prototype);function c(e,t){n.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"}r.inherits(c,n),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(c.prototype),t.ScrollBar=l,t.ScrollBarV=l,t.ScrollBarH=c,t.VScrollBar=l,t.HScrollBar=c}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,i){"use strict";function n(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=t||window;var i=this;this._flush=function(e){i.pending=!1;var t=i.changes;if(t&&(r.blockIdle(100),i.changes=0,i.onRender(t)),i.changes){if(i.$recursionLimit--<0)return;i.schedule()}else i.$recursionLimit=2}}var r=e("./lib/event");(function(){this.schedule=function(e){this.changes=this.changes|e,this.changes&&!this.pending&&(r.nextFrame(this._flush),this.pending=!0)},this.clear=function(e){var t=this.changes;return this.changes=0,t}}).call(n.prototype),t.RenderLoop=n}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){var n=e("../lib/oop"),r=e("../lib/dom"),o=e("../lib/lang"),s=e("../lib/event"),a=e("../lib/useragent"),l=e("../lib/event_emitter").EventEmitter,c="function"==typeof ResizeObserver,h=t.FontMetrics=function(e){this.el=r.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=r.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=r.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),this.$measureNode.textContent=o.stringRepeat("X",256),this.$characterSize={width:0,height:0},c?this.$addObserver():this.checkForSizeChanges()};(function(){n.implement(this,l),this.$characterSize={width:0,height:0},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",a.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(e){var t;void 0===e&&(e=this.$measureSizes()),!e||this.$characterSize.width===e.width&&this.$characterSize.height===e.height||(this.$measureNode.style.fontWeight="bold",t=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e}))},this.$addObserver=function(){var t=this;this.$observer=new window.ResizeObserver(function(e){t.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var t=this;return this.$pollSizeChangesTimer=s.onIdle(function e(){t.checkForSizeChanges(),s.onIdle(e,500)},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(e){var t={height:(e||this.$measureNode).clientHeight,width:(e||this.$measureNode).clientWidth/256};return 0===t.width||0===t.height?null:t},this.$measureCharWidth=function(e){return this.$main.textContent=o.stringRepeat(e,256),this.$main.getBoundingClientRect().width/256},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},this.$getZoom=function e(t){return t&&t.parentElement?(window.getComputedStyle(t).zoom||1)*e(t.parentElement):1},this.$initTransformMeasureNodes=function(){function e(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]}this.els=r.buildDom([e(0,0),e(200,0),e(0,200),e(200,200)],this.el)},this.transformCoordinates=function(e,t){function i(e,t,i){var n=e[1]*t[0]-e[0]*t[1];return[(-t[1]*i[0]+t[0]*i[1])/n,(e[1]*i[0]-e[0]*i[1])/n]}function n(e,t){return[e[0]-t[0],e[1]-t[1]]}function r(e,t){return[e[0]+t[0],e[1]+t[1]]}function o(e,t){return[e*t[0],e*t[1]]}function s(e){var t=e.getBoundingClientRect();return[t.left,t.top]}e=e&&o(1/this.$getZoom(this.el),e),this.els||this.$initTransformMeasureNodes();var a=s(this.els[0]),l=s(this.els[1]),c=s(this.els[2]),h=s(this.els[3]),d=i(n(h,l),n(h,c),n(r(l,c),r(h,a))),u=o(1+d[0],n(l,a)),g=o(1+d[1],n(c,a));if(t){var p=d[0]*t[0]/200+d[1]*t[1]/200+1,m=r(o(t[0],u),o(t[1],g));return r(o(1/p/200,m),a)}var f=n(e,a),C=i(n(u,o(d[0],f)),n(g,o(d[1],f)),f);return o(200,C)}}).call(h.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("./lib/oop"),h=e("./lib/dom"),o=e("./config"),r=e("./layer/gutter").Gutter,s=e("./layer/marker").Marker,a=e("./layer/text").Text,l=e("./layer/cursor").Cursor,c=e("./scrollbar").HScrollBar,d=e("./scrollbar").VScrollBar,u=e("./renderloop").RenderLoop,g=e("./layer/font_metrics").FontMetrics,p=e("./lib/event_emitter").EventEmitter,m='.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;padding: 0;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;font-variant-ligatures: no-common-ligatures;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_error_bracket {position: absolute;border-bottom: 1px solid #DE5555;border-radius: 0;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);transform-origin: left;white-space: pre;opacity: 0.7;margin: 0 10px;}',f=e("./lib/useragent"),C=f.isIE;h.importCssString(m,"ace_editor.css");function v(e,t){var i=this;this.container=e||h.createElement("div"),h.addCssClass(this.container,"ace_editor"),h.HI_DPI&&h.addCssClass(this.container,"ace_hidpi"),this.setTheme(t),this.$gutter=h.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=h.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=h.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new r(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new s(this.content);var n=this.$textLayer=new a(this.content);this.canvas=n.element,this.$markerFront=new s(this.content),this.$cursorLayer=new l(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new d(this.container,this),this.scrollBarH=new c(this.container,this),this.scrollBarV.on("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.on("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new g(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!f.isIOS,this.$loop=new u(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._signal("renderer",this)}(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,n.implement(this,p),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),h.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=e)&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=e?1:0;var r=this.container;n=n||(r.clientHeight||r.scrollHeight),i=i||(r.clientWidth||r.scrollWidth);var o=this.$updateCachedSize(e,t,i,n);if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var r,o=0,s=this.$size,a={width:s.width,height:s.height,scrollerHeight:s.scrollerHeight,scrollerWidth:s.scrollerWidth};return n&&(e||s.height!=n)&&(s.height=n,o|=this.CHANGE_SIZE,s.scrollerHeight=s.height,this.$horizScroll&&(s.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",o|=this.CHANGE_SCROLL),i&&(e||s.width!=i)&&(o|=this.CHANGE_SIZE,s.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,h.setStyle(this.scrollBarH.element.style,"left",t+"px"),h.setStyle(this.scroller.style,"left",t+this.margin.left+"px"),s.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()-this.margin.h),h.setStyle(this.$gutter.style,"left",this.margin.left+"px"),r=this.scrollBarV.getWidth()+"px",h.setStyle(this.scrollBarH.element.style,"right",r),h.setStyle(this.scroller.style,"right",r),h.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(o|=this.CHANGE_FULL)),s.$dirty=!i||!n,o&&this._signal("resize",a),o},this.onGutterResize=function(e){var t=this.$showGutter?e:0;t!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,t,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updatePrintMargin=function(){var e,t;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((e=h.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=h.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)),(t=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit())},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){var e,t,i,n,r,o,s,a,l,c;this.$isMousePressed||(e=this.textarea.style,t=this.$composition,this.$keepTextAreaAtCursor||t?(i=this.$cursorLayer.$pixelPos)&&(t&&t.markerRange&&(i=this.$cursorLayer.getPixelPosition(t.markerRange.start,!0)),n=this.layerConfig,r=i.top,o=i.left,r-=n.offset,s=t&&t.useTextareaForIME?this.lineHeight:C?0:1,r<0||r>n.height-s?h.translate(this.textarea,0,0):(c=1,a=this.$size.height-s,t?t.useTextareaForIME?(l=this.textarea.value,c=this.characterWidth*this.session.$getStringScreenWidth(l)[0]):r+=this.lineHeight+2:r+=this.lineHeight,(o-=this.scrollLeft)>this.$size.scrollerWidth-c&&(o=this.$size.scrollerWidth-c),o+=this.gutterWidth+this.margin.left,h.setStyle(e,"height",s+"px"),h.setStyle(e,"width",c+"px"),h.translate(this.textarea,Math.min(o,this.$size.scrollerWidth-c),Math.min(r,a)))):h.translate(this.textarea,-100,0))},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.setMargin=function(e,t,i,n){var r=this.margin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",e),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var i,n,r,o=this.layerConfig;if((e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL)&&(e|=this.$computeLayerConfig()|this.$loop.clear(),o.firstRow==this.layerConfig.firstRow||o.firstRowScreen!=this.layerConfig.firstRowScreen||0<(i=this.scrollTop+(o.firstRow-this.layerConfig.firstRow)*this.lineHeight)&&(this.scrollTop=i,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig()|this.$loop.clear()),o=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),h.translate(this.content,-this.scrollLeft,-o.offset),n=o.width+2*this.$padding+"px",r=o.minHeight+"px",h.setStyle(this.content.style,"width",n),h.setStyle(this.content.style,"height",r)),e&this.CHANGE_H_SCROLL&&(h.translate(this.content,-this.scrollLeft,-o.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)return this.$changedLines=null,this.$textLayer.update(o),this.$showGutter&&this.$gutterLayer.update(o),this.$markerBack.update(o),this.$markerFront.update(o),this.$cursorLayer.update(o),this.$moveTextAreaToCursor(),void this._signal("afterRender",e);if(e&this.CHANGE_SCROLL)return this.$changedLines=null,e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(o):this.$textLayer.scrollLines(o),this.$showGutter&&(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES?this.$gutterLayer.update(o):this.$gutterLayer.scrollLines(o)),this.$markerBack.update(o),this.$markerFront.update(o),this.$cursorLayer.update(o),this.$moveTextAreaToCursor(),void this._signal("afterRender",e);e&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(o),this.$showGutter&&this.$gutterLayer.update(o)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(o):e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(o):e&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(o),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(o),this.$moveTextAreaToCursor()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(o),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(o),this._signal("afterRender",e)}else this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(i+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&i>this.$maxPixelHeight&&(i=this.$maxPixelHeight);var n,r=!(i<=2*this.lineHeight)&&t<e;i==this.desiredHeight&&this.$size.height==this.desiredHeight&&r==this.$vScroll||(r!=this.$vScroll&&(this.$vScroll=r,this.scrollBarV.setVisible(r)),n=this.container.clientWidth,this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,n,i),this.desiredHeight=i,this._signal("autosize"))},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),o=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-r-2*this.$padding<0),s=this.$horizScroll!==o;s&&(this.$horizScroll=o,this.scrollBarH.setVisible(o));var a=this.$vScroll;this.$maxLines&&1<this.lineHeight&&this.$autosize();var l=t.scrollerHeight+this.lineHeight,c=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;n+=c;var h=this.scrollMargin;this.session.setScrollTop(Math.max(-h.top,Math.min(this.scrollTop,n-t.scrollerHeight+h.bottom))),this.session.setScrollLeft(Math.max(-h.left,Math.min(this.scrollLeft,r+2*this.$padding-t.scrollerWidth+h.right)));var d=!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-n+c<0||this.scrollTop>h.top),u=a!==d;u&&(this.$vScroll=d,this.scrollBarV.setVisible(d));var g,p,m=this.scrollTop%this.lineHeight,f=Math.ceil(l/this.lineHeight)-1,C=(I=Math.max(0,Math.round((this.scrollTop-m)/this.lineHeight)))+f,v=this.lineHeight,I=e.screenToDocumentRow(I,0),A=e.getFoldLine(I);A&&(I=A.start.row),g=e.documentToScreenRow(I,0),p=e.getRowLength(I)*v,C=Math.min(e.screenToDocumentRow(C,0),e.getLength()-1),l=t.scrollerHeight+e.getRowLength(C)*v+p,m=this.scrollTop-g*v;var b=0;return this.layerConfig.width==r&&!s||(b=this.CHANGE_H_SCROLL),(s||u)&&(b|=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),u&&(r=this.$getLongestLine())),this.layerConfig={width:r,padding:this.$padding,firstRow:I,firstRowScreen:g,lastRow:C,lineHeight:v,characterWidth:this.characterWidth,minHeight:l,maxHeight:n,offset:m,gutterOffset:v?Math.max(0,Math.ceil((m+t.height-t.scrollerHeight)/v)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(r-this.$padding),b},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var i=this.layerConfig;if(!(e>i.lastRow+1||t<i.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH&&(e=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){var n,r,o,s,a,l,c;0!==this.$size.scrollerHeight&&(r=(n=this.$cursorLayer.getPixelPosition(e)).left,o=n.top,s=i&&i.top||0,a=i&&i.bottom||0,o<(l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+s?(t&&l+s>o+this.lineHeight&&(o-=t*this.$size.scrollerHeight),0===o&&(o=-this.scrollMargin.top),this.session.setScrollTop(o)):l+this.$size.scrollerHeight-a<o+this.lineHeight&&(t&&l+this.$size.scrollerHeight-a<o-this.lineHeight&&(o+=t*this.$size.scrollerHeight),this.session.setScrollTop(o+this.lineHeight+a-this.$size.scrollerHeight)),r<(c=this.scrollLeft)?(r<this.$padding+2*this.layerConfig.characterWidth&&(r=-this.scrollMargin.left),this.session.setScrollLeft(r)):c+this.$size.scrollerWidth<r+this.characterWidth?this.session.setScrollLeft(Math.round(r+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&r-c<this.characterWidth&&this.session.setScrollLeft(0))},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var i=this.$cursorLayer.getPixelPosition(e),n=this.$size.scrollerHeight-this.lineHeight,r=i.top-n*(t||0);return this.session.setScrollTop(r),r},this.STEPS=8,this.$calcSteps=function(e,t){for(var i,n,r=0,o=this.STEPS,s=[],r=0;r<o;++r)s.push((i=r/this.STEPS,(t-(n=e))*(Math.pow(i-1,3)+1)+n));return s},this.scrollToLine=function(e,t,i,n){var r=this.$cursorLayer.getPixelPosition({row:e,column:0}).top;t&&(r-=this.$size.scrollerHeight/2);var o=this.scrollTop;this.session.setScrollTop(r),!1!==i&&this.animateScrolling(o,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==i)return}var o=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:o},clearInterval(this.$timer),n.session.setScrollTop(o.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){return n.session?void(o.length?(n.session.setScrollTop(o.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())):clearInterval(n.$timer)},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(0<t&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(0<e&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){var i,n;this.$hasCssTransforms?(i={top:0,left:0},e=(n=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=n[0]):i=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-i.left-this.$padding,o=r/this.characterWidth,s=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),a=this.$blockCursor?Math.floor(o):Math.round(o);return{row:s,column:a,side:0<o-a?1:-1,offsetX:r}},this.screenToTextCoordinates=function(e,t){var i,n;this.$hasCssTransforms?(i={top:0,left:0},e=(n=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=n[0]):i=this.scroller.getBoundingClientRect();var r=e+this.scrollLeft-i.left-this.$padding,o=r/this.characterWidth,s=this.$blockCursor?Math.floor(o):Math.round(o),a=Math.floor((t+this.scrollTop-i.top)/this.lineHeight);return this.session.screenToDocumentPosition(a,Math.max(s,0),r)},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=this.session.documentToScreenPosition(e,t),r=this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e)?this.session.$bidiHandler.getPosLeft(n.column):Math.round(n.column*this.characterWidth)),o=n.row*this.lineHeight;return{pageX:i.left+r-this.scrollLeft,pageY:i.top+o-this.scrollTop}},this.visualizeFocus=function(){h.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){h.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){(this.$composition=e).cssText||(e.cssText=this.textarea.style.cssText),null==e.useTextareaForIME&&(e.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(h.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text")},this.setCompositionText=function(e){var t=this.session.selection.cursor;this.addToken(e,"composition_placeholder",t.row,t.column),this.$moveTextAreaToCursor()},this.hideComposition=function(){var e;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),h.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,e=this.session.selection.cursor,this.removeExtraToken(e.row,e.column),this.$composition=null,this.$cursorLayer.element.style.display="")},this.addToken=function(e,t,i,n){var r=this.session;r.bgTokenizer.lines[i]=null;var o={type:t,value:e},s=r.getTokens(i);if(null==n)s.push(o);else for(var a=0,l=0;l<s.length;l++){var c=s[l];if(n<=(a+=c.value.length)){var h=c.value.length-(a-n),d=c.value.slice(0,h),u=c.value.slice(h);s.splice(l,1,{type:c.type,value:d},o,{type:c.type,value:u});break}}this.updateLines(i,i)},this.removeExtraToken=function(e,t){this.updateLines(e,e)},this.setTheme=function(i,n){var e,r=this;function t(e){if(r.$themeId!=i)return n&&n();if(!e||!e.cssClass)throw new Error("couldn't load module "+i+" or it didn't call define");e.$id&&(r.$themeId=e.$id),h.importCssString(e.cssText,e.cssClass,r.container),r.theme&&h.removeCssClass(r.container,r.theme.cssClass);var t="padding"in e?e.padding:"padding"in(r.theme||{})?4:r.$padding;r.$padding&&t!=r.$padding&&r.setPadding(t),r.$theme=e.cssClass,r.theme=e,h.addCssClass(r.container,e.cssClass),h.setCssClass(r.container,"ace_dark",e.isDark),r.$size&&(r.$size.width=0,r.$updateSizeAsync()),r._dispatchEvent("themeLoaded",{theme:e}),n&&n()}this.$themeId=i,r._dispatchEvent("themeChange",{theme:i}),i&&"string"!=typeof i?t(i):(e=i||this.$options.theme.initialValue,o.loadModule(["theme",e],t))},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){h.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){h.removeCssClass(this.container,e)},this.setCursorStyle=function(e){h.setStyle(this.scroller.style,"cursor",e)},this.setMouseCursor=function(e){h.setStyle(this.scroller.style,"cursor",e)},this.attachToShadowRoot=function(){h.importCssString(m,"ace_editor.css",this.container)},this.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent=""}}).call(v.prototype),o.defineOptions(v.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){h.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){this.$gutterLayer.setHighlightGutterLine(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!f.isMobile&&!f.isIE}}),t.VirtualRenderer=v}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(a,e,t){"use strict";var i=a("../lib/oop"),n=a("../lib/net"),c=a("../lib/event_emitter").EventEmitter,h=a("../config");function l(e){if("undefined"==typeof Worker)return{postMessage:function(){},terminate:function(){}};if(h.get("loadWorkerFromBlob")){var t=function(e){var t="importScripts('"+n.qualifyURL(e)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(e){var i=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return i.append(t),i.getBlob("application/javascript")}}(e),i=(window.URL||window.webkitURL).createObjectURL(t);return new Worker(i)}return new Worker(e)}function d(e){e.postMessage||(e=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=e,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){i.implement(this,c),this.$createWorkerFromOldConfig=function(e,t,i,n,r){var o,s;return a.nameToUrl&&!a.toUrl&&(a.toUrl=a.nameToUrl),h.get("packaged")||!a.toUrl?n=n||h.moduleUrl(t,"worker"):(o=this.$normalizePath,n=n||o(a.toUrl("ace/worker/worker.js",null,"_")),s={},e.forEach(function(e){s[e]=o(a.toUrl(e,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=l(n),r&&this.send("importScripts",r),this.$worker.postMessage({init:!0,tlns:s,module:t,classname:i}),this.$worker},this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return n.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){var n;i&&(n=this.callbackId++,this.callbacks[n]=i,t.push(n)),this.send(e,t)},this.emit=function(e,t){try{t.data&&t.data.err&&(t.data.err={message:t.data.err.message,stack:t.data.err.stack,code:t.data.err.code}),this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,50<e.length&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(d.prototype);e.UIWorkerClient=function(e,t,i){var n=null,r=!1,o=Object.create(c),s=[],a=new d({messageBuffer:s,terminate:function(){},postMessage:function(e){s.push(e),n&&(r?setTimeout(l):l())}});a.setEmitSync=function(e){r=e};var l=function(){var e=s.shift();e.command?n[e.command].apply(n,e.args):e.event&&o._signal(e.event,e.data)};return o.postMessage=function(e){a.onMessage({data:e})},o.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},o.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},h.loadModule(["worker",t],function(e){for(n=new e[i](o);s.length;)l()}),a},e.WorkerClient=d,e.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,i){"use strict";function n(e,t,i,n,r,o){var s=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)}var l=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop");(function(){o.implement(this,r),this.setup=function(){var i=this,n=this.doc,e=this.session;this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=n.createAnchor(this.$pos.row,this.$pos.column);var t=this.pos;t.$insertRight=!0,t.detach(),t.markerId=e.addMarker(new l(t.row,t.column,t.row,t.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(e){var t=n.createAnchor(e.row,e.column);t.$insertRight=!0,t.detach(),i.others.push(t)}),e.setUndoSelect(!1)},this.showOtherMarkers=function(){var t,i;this.othersActive||(t=this.session,(i=this).othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new l(e.row,e.column,e.row,e.column+i.length),i.othersClass,null,!1)}))},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var i="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,n=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,r=t.start.column-this.pos.column;if(this.updateAnchors(e),n&&(this.length+=i),n&&!this.session.$fromUndo)if("insert"===e.action)for(var o=this.others.length-1;0<=o;o--){var s={row:(a=this.others[o]).row,column:a.column+r};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(o=this.others.length-1;0<=o;o--){var a,s={row:(a=this.others[o]).row,column:a.column+r};this.doc.remove(new l(s.row,s.column,s.row,s.column-i))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var i=this,n=this.session,e=function(e,t){n.removeMarker(e.markerId),e.markerId=n.addMarker(new l(e.row,e.column,e.row,e.column+i.length),t,null,!1)};e(this.pos,this.mainClass);for(var t=this.others.length;t--;)e(this.others[t],this.othersClass)}},this.onCursorChange=function(e){var t;!this.$updating&&this.session&&((t=this.session.selection.getCursor()).row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e)))},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;i<t;i++)e.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(n.prototype),t.PlaceHolder=n}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){var k=e("../lib/event"),E=e("../lib/useragent");function R(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,i=t.altKey,n=t.shiftKey,r=t.ctrlKey,o=e.getAccelKey(),s=e.getButton();if(r&&E.isMac&&(s=t.button),e.editor.inMultiSelectMode&&2==s)e.editor.textInput.onContextMenu(e.domEvent);else if(r||i||o){if(0===s){var a,l,c,h=e.editor,d=h.selection,u=h.inMultiSelectMode,g=e.getDocumentPosition(),p=d.getCursor(),m=e.inSelection()||d.isEmpty()&&R(g,p),f=e.x,C=e.y,v=h.session,I=h.renderer.pixelToScreenCoordinates(f,C),A=I;if(h.$mouseHandler.$enableJumpToDef)r&&i||o&&i?a=n?"block":"add":i&&h.$blockSelectEnabled&&(a="block");else if(o&&!i){if(a="add",!u&&n)return}else i&&h.$blockSelectEnabled&&(a="block");if(a&&E.isMac&&t.ctrlKey&&h.$mouseHandler.cancelContextMenu(),"add"==a){if(!u&&m)return;u||(l=d.toOrientedRange(),h.addSelectionMarker(l));var b=d.rangeList.rangeAtPoint(g);h.inVirtualSelectionMode=!0,n&&(b=null,l=d.ranges[0]||l,h.removeSelectionMarker(l)),h.once("mouseup",function(){var e=d.toOrientedRange();b&&e.isEmpty()&&R(b.cursor,e.cursor)?d.substractPoint(e.cursor):(n?d.substractPoint(l.cursor):l&&(h.removeSelectionMarker(l),d.addRange(l)),d.addRange(e)),h.inVirtualSelectionMode=!1})}else if("block"==a){e.stop(),h.inVirtualSelectionMode=!0;function y(){var e=h.renderer.pixelToScreenCoordinates(f,C),t=v.screenToDocumentPosition(e.row,e.column,e.offsetX);R(A,e)&&R(t,d.lead)||(A=e,h.selection.moveToPosition(t),h.renderer.scrollCursorIntoView(),h.removeSelectionMarkers(w),w=d.rectangularRangeBlock(A,I),h.$mouseHandler.$clickSelection&&1==w.length&&w[0].isEmpty()&&(w[0]=h.$mouseHandler.$clickSelection.clone()),w.forEach(h.addSelectionMarker,h),h.updateSelectionMarkers())}var w=[];u&&!o?d.toSingleRange():!u&&o&&(c=d.toOrientedRange(),h.addSelectionMarker(c)),n?I=v.documentToScreenPosition(d.lead):d.moveToPosition(g),A={row:-1,column:-1};var S=y;k.capture(h.container,function(e){f=e.clientX,C=e.clientY},function(e){y(),clearInterval(x),h.removeSelectionMarkers(w),w.length||(w=[d.toOrientedRange()]),c&&(h.removeSelectionMarker(c),d.toSingleRange(c));for(var t=0;t<w.length;t++)d.addRange(w[t]);h.inVirtualSelectionMode=!1,h.$mouseHandler.$clickSelection=null});var x=setInterval(function(){S()},20);return e.preventDefault()}}}else 0===s&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,i){t.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",
description:"Add cursor below (skip current)",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split into lines",exec:function(e){1<e.multiSelect.rangeCount?e.multiSelect.joinSelections():e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(e){e.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var n=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new n(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,t,i){var n=e("./range_list").RangeList,A=e("./range").Range,m=e("./selection").Selection,r=e("./mouse/multi_select_handler").onMouseDown,o=e("./lib/event"),f=e("./lib/lang"),s=e("./commands/multi_select_commands");t.commands=s.defaultCommands.concat(s.multiSelectCommands);var h=new(e("./search").Search);var a=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(a.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);var n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){var t;this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode&&(t=this.rangeList.ranges.pop(),e.push(t),this.rangeCount=0);for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new n,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var e=this.ranges.length?this.ranges:[this.getRange()],t=[],i=0;i<e.length;i++){var n=e[i],r=n.start.row,o=n.end.row;if(r===o)t.push(n.clone());else{for(t.push(new A(r,n.start.column,r,this.session.getLine(r).length));++r<o;)t.push(this.getLineRange(r,!0));t.push(new A(o,0,o,n.end.column))}0!=i||this.isBackwards()||(t=t.reverse())}this.toSingleRange();for(i=t.length;i--;)this.addRange(t[i])},this.joinSelections=function(){var e=this.rangeList.ranges,t=e[e.length-1],i=A.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)},this.toggleBlockSelection=function(){var e,t,i,n,r;1<this.rangeCount?(t=(e=this.rangeList.ranges)[e.length-1],i=A.fromPoints(e[0].start,t.end),this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)):(n=this.session.documentToScreenPosition(this.cursor),r=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(n,r).forEach(this.addRange,this))},this.rectangularRangeBlock=function(e,t,i){var n,r,o,s,a=[],l=e.column<t.column;s=l?(n=e.column,r=t.column,o=e.offsetX,t.offsetX):(n=t.column,r=e.column,o=t.offsetX,e.offsetX);var c,h,d,u=e.row<t.row;h=u?(c=e.row,t.row):(c=t.row,e.row),n<0&&(n=0),c<0&&(c=0),c==h&&(i=!0);for(var g,p,m=c;m<=h;m++){var f=A.fromPoints(this.session.screenToDocumentPosition(m,n,o),this.session.screenToDocumentPosition(m,r,s));if(f.isEmpty()){if(d&&(g=f.end,p=d,g.row==p.row&&g.column==p.column))break;d=f.end}f.cursor=l?f.start:f.end,a.push(f)}if(u&&a.reverse(),!i){for(var C=a.length-1;a[C].isEmpty()&&0<C;)C--;if(0<C)for(var v=0;a[v].isEmpty();)v++;for(var I=C;v<=I;I--)a[I].isEmpty()&&a.splice(I,1)}return a}}.call(m.prototype);var l=e("./editor").Editor;function c(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",r),e.commands.addCommands(s.defaultCommands),function(i){if(!i.textInput)return;var e=i.textInput.getElement(),n=!1;function r(e){n&&(i.renderer.setMouseCursor(""),n=!1)}o.addListener(e,"keydown",function(e){var t=18==e.keyCode&&!(e.ctrlKey||e.shiftKey||e.metaKey);i.$blockSelectEnabled&&t?n||(i.renderer.setMouseCursor("crosshair"),n=!0):n&&r()},i),o.addListener(e,"keyup",r,i),o.addListener(e,"blur",r,i)}(e))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){var t;e.marker&&(this.session.removeMarker(e.marker),-1!=(t=this.session.$selectionMarkers.indexOf(e))&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n,r=e[i];r.marker&&(this.session.removeMarker(r.marker),-1!=(n=t.indexOf(r))&&t.splice(n,1))}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(s.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(s.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t,i=e.command,n=e.editor;if(n.multiSelect)return i.multiSelectAction?t="forEach"==i.multiSelectAction?n.forEachSelection(i,e.args):"forEachLine"==i.multiSelectAction?n.forEachSelection(i,e.args,!0):"single"==i.multiSelectAction?(n.exitMultiSelectMode(),i.exec(n,e.args||{})):i.multiSelectAction(n,e.args||{}):(t=i.exec(n,e.args||{}),n.multiSelect.addRange(n.multiSelect.toOrientedRange()),n.multiSelect.mergeOverlappingRanges()),t},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,r=i&&i.keepOrder,o=1==i||i&&i.$byLines,s=this.session,a=this.selection,l=a.rangeList,c=(r?a:l).ranges;if(!c.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var h=a._eventRegistry;a._eventRegistry={};var d=new m(s);this.inVirtualSelectionMode=!0;for(var u=c.length;u--;){if(o)for(;0<u&&c[u].start.row==c[u-1].end.row;)u--;d.fromOrientedRange(c[u]),d.index=u,this.selection=s.selection=d;var g=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===g||(n=g),d.toOrientedRange(c[u])}d.detach(),this.selection=s.selection=a,this.inVirtualSelectionMode=!1,a._eventRegistry=h,a.mergeOverlappingRanges(),a.ranges[0]&&a.fromOrientedRange(a.ranges[0]);var p=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),p&&p.from==p.to&&this.renderer.animateScrolling(p.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var r=this.session.getDocument().getNewLineCharacter();(e=i.join(r)).length==(i.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var i=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var n=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor;n.row!=t.row||this.session.$clipPositionToDocument(n.row,n.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()}},this.findAll=function(e,t,i){var n;(t=t||{}).needle=e||t.needle,null==t.needle&&(n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),t.needle=this.session.getTextRange(n)),this.$search.set(t);var r=this.$search.findAll(this.session);if(!r.length)return 0;var o=this.multiSelect;i||o.toSingleRange(r[0]);for(var s=r.length;s--;)o.addRange(r[s],!0);return n&&o.rangeList.rangeAtPoint(n.start)&&o.addRange(n,!0),r.length},this.selectMoreLines=function(e,t){var i=this.selection.toOrientedRange(),n=i.cursor==i.end,r=this.session.documentToScreenPosition(i.cursor);this.selection.$desiredColumn&&(r.column=this.selection.$desiredColumn);var o,s,a,l,c=this.session.screenToDocumentPosition(r.row+e,r.column);s=i.isEmpty()?c:(o=this.session.documentToScreenPosition(n?i.end:i.start),this.session.screenToDocumentPosition(o.row+e,o.column)),n?(a=A.fromPoints(c,s)).cursor=a.start:(a=A.fromPoints(s,c)).cursor=a.end,a.desiredColumn=r.column,this.selection.inMultiSelectMode?t&&(l=i.cursor):this.selection.addRange(i),this.selection.addRange(a),l&&this.selection.substractPoint(l)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,r=n.length;r--;){(s=n[r]).isEmpty()&&(a=t.getWordRange(s.start.row,s.start.column),s.start.row=a.start.row,s.start.column=a.start.column,s.end.row=a.end.row,s.end.column=a.end.column)}i.mergeOverlappingRanges();for(var o=[],r=n.length;r--;){var s=n[r];o.unshift(t.getTextRange(s))}e<0?o.unshift(o.pop()):o.push(o.shift());for(r=n.length;r--;){var a=(s=n[r]).clone();t.replace(s,o[r]),s.start.row=a.start.row,s.start.column=a.start.column}i.fromOrientedRange(i.ranges[0])},this.selectMore=function(e,t,i){var n,r,o,s,a,l=this.session,c=l.multiSelect.toOrientedRange();c.isEmpty()&&((c=l.getWordRange(c.start.row,c.start.column)).cursor=-1==e?c.start:c.end,this.multiSelect.addRange(c),i)||(n=l.getTextRange(c),o=l,s=n,a=e,h.$options.wrap=!0,h.$options.needle=s,h.$options.backwards=-1==a,(r=h.find(o))&&(r.cursor=-1==e?r.start:r.end,this.session.unfold(r),this.multiSelect.addRange(r),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(c.cursor))},this.alignCursors=function(){var o=this.session,t=o.multiSelect,e=t.ranges,i=-1,n=e.filter(function(e){return e.cursor.row==i||void(i=e.cursor.row)});if(e.length&&n.length!=e.length-1){n.forEach(function(e){t.substractPoint(e.cursor)});var s=0,a=1/0,l=e.map(function(e){var t=e.cursor,i=o.getLine(t.row).substr(t.column).search(/\S/g);return-1==i&&(i=0),t.column>s&&(s=t.column),i<a&&(a=i),i});e.forEach(function(e,t){var i=e.cursor,n=s-i.column,r=l[t]-a;r<n?o.insert(i,f.stringRepeat(" ",n-r)):o.remove(new A(i.row,i.column,i.row,i.column-n+r)),e.start.column=e.end.column=s,e.start.row=e.end.row=i.row,e.cursor=e.end}),t.fromOrientedRange(e[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var r=this.selection.getRange(),c=r.start.row,h=r.end.row,d=c==h;if(d){for(var u,g=this.session.getLength();u=this.session.getLine(h),/[=:]/.test(u)&&++h<g;);for(;u=this.session.getLine(c),/[=:]/.test(u)&&0<--c;);c<0&&(c=0),g<=h&&(h=g-1)}var p=this.session.removeFullLines(c,h),p=this.$reAlignText(p,d);this.session.insert({row:c,column:0},p.join("\n")+"\n"),d||(r.start.column=0,r.end.column=p[p.length-1].length),this.selection.setRange(r)}},this.$reAlignText=function(e,t){var i,n,r,o=!0,s=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?(null==i?(i=t[1].length,n=t[2].length,r=t[3].length):(i+n+r!=t[1].length+t[2].length+t[3].length&&(s=!1),i!=t[1].length&&(o=!1),i>t[1].length&&(i=t[1].length),n<t[2].length&&(n=t[2].length),r>t[3].length&&(r=t[3].length)),t):[e]}).map(t?l:o?s?function(e){return e[2]?a(i+n-e[2].length)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?a(i)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return f.stringRepeat(" ",e)}function l(e){return e[2]?a(i)+e[2]+a(n-e[2].length+r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}).call(l.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var i=e.oldSession;i&&(i.multiSelect.off("addRange",this.$onAddRange),i.multiSelect.off("removeRange",this.$onRemoveRange),i.multiSelect.off("multiSelect",this.$onMultiSelect),i.multiSelect.off("singleSelect",this.$onSingleSelect),i.multiSelect.lead.off("change",this.$checkMultiselectChange),i.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=c,e("./config").defineOptions(l.prototype,"editor",{enableMultiselect:{set:function(e){c(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",r)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",r))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,i){"use strict";var g=e("../../range").Range,n=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);return this.foldingStartMarker.test(n)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(n)?"end":""},this.getFoldWidgetRange=function(e,t,i){return null},this.indentationBlock=function(e,t,i){var n=/\S/,r=e.getLine(t),o=r.search(n);if(-1!=o){for(var s=i||r.length,a=e.getLength(),l=t,c=t;++t<a;){var h=e.getLine(t).search(n);if(-1!=h){if(h<=o){var d=e.getTokenAt(t,0);if(!d||"string"!==d.type)break}c=t}}if(l<c){var u=e.getLine(c).length;return new g(l,s,c,u)}}},this.openingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n+1},s=e.$findClosingBracket(t,o,r);if(s){var a=e.foldWidgets[s.row];return null==a&&(a=e.getFoldWidget(s.row)),"start"==a&&s.row>o.row&&(s.row--,s.column=e.getLine(s.row).length),g.fromPoints(o,s)}},this.closingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n},s=e.$findOpeningBracket(t,o);if(s)return s.column++,o.column--,g.fromPoints(s,o)}}).call(n.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',t.$id="ace/theme/textmate",e("../lib/dom").importCssString(t.cssText,t.cssClass)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./lib/dom");function n(e){this.session=e,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}(function(){this.getRowLength=function(e){var t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var t=0;return this.lineWidgets.forEach(function(e){e&&e.rowCount&&!e.hidden&&(t+=e.rowCount)}),t},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),(this.editor=e)&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t,i=this.editor;i&&(this.editor=null,i.widgetManager=null,i.renderer.off("beforeRender",this.measureWidgets),i.renderer.off("afterRender",this.renderWidgets),(t=this.session.lineWidgets)&&t.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))}))},this.updateOnFold=function(e,t){var i=t.lineWidgets;if(i&&e.action){for(var n=e.data,r=n.start.row,o=n.end.row,s="add"==e.action,a=r+1;a<o;a++)i[a]&&(i[a].hidden=s);i[o]&&(s?i[r]?i[o].hidden=s:i[r]=i[o]:(i[r]==i[o]&&(i[r]=void 0),i[o].hidden=s))}},this.updateOnChange=function(e){var t,i,n,r,o=this.session.lineWidgets;o&&(t=e.start.row,0==(i=e.end.row-t)||("remove"==e.action?(n=o.splice(t+1,i),!o[t]&&n[n.length-1]&&(o[t]=n.pop()),n.forEach(function(e){e&&this.removeLineWidget(e)},this)):(r=new Array(i),o[t]&&null!=o[t].column&&e.start.column>o[t].column&&t++,r.unshift(t,0),o.splice.apply(o,r)),this.$updateRows()))},this.$updateRows=function(){var i,e=this.session.lineWidgets;e&&(i=!0,e.forEach(function(e,t){if(e)for(i=!1,e.row=t;e.$oldWidget;)e.$oldWidget.row=t,e=e.$oldWidget}),i&&(this.session.lineWidgets=null))},this.$registerLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];return t&&(e.$oldWidget=t).el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1),this.session.lineWidgets[e.row]=e},this.addLineWidget=function(e){if(this.$registerLineWidget(e),e.session=this.session,!this.editor)return e;var t=this.editor.renderer;e.html&&!e.el&&(e.el=r.createElement("div"),e.el.innerHTML=e.html),e.el&&(r.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,t.container.appendChild(e.el),e._inDocument=!0,e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight)),null==e.rowCount&&(e.rowCount=e.pixelHeight/t.layerConfig.lineHeight);var i,n=this.session.getFoldAt(e.row,0);return(e.$fold=n)&&(i=this.session.lineWidgets,e.row!=n.end.row||i[n.start.row]?e.hidden=!0:i[n.start.row]=e),this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,t),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,i=t&&t[e],n=[];i;)n.push(i),i=i.$oldWidget;return n},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var r=1/0,o=0;o<i.length;o++){var s=i[o];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<r&&(r=s.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var r=Math.min(this.firstRow,i.firstRow),o=Math.max(this.lastRow,i.lastRow,n.length);0<r&&!n[r];)r--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=r;s<=o;s++){var a,l,c=n[s];c&&c.el&&(c.hidden?c.el.style.top=-100-(c.pixelHeight||0)+"px":(c._inDocument||(c._inDocument=!0,t.container.appendChild(c.el)),a=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top,c.coverLine||(a+=i.lineHeight*this.session.getRowLineCount(c.row)),c.el.style.top=a-i.offset+"px",l=c.coverGutter?0:t.gutterWidth,c.fixedWidth||(l-=t.scrollLeft),c.el.style.left=l+"px",c.fullWidth&&c.screenWidth&&(c.el.style.minWidth=i.width+2*i.padding+"px"),c.fixedWidth?c.el.style.right=t.scrollBar.getWidth()+"px":c.el.style.right=""))}}}}).call(n.prototype),t.LineWidgets=n}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t,i){"use strict";var p=e("../line_widgets").LineWidgets,m=e("../lib/dom"),a=e("../range").Range;function f(e,t,i){var n=e.getAnnotations().sort(a.comparePoints);if(n.length){var r=function(e,t,i){for(var n=0,r=e.length-1;n<=r;){var o=n+r>>1,s=i(t,e[o]);if(0<s)n=1+o;else{if(!(s<0))return o;r=o-1}}return-(n+1)}(n,{row:t,column:-1},a.comparePoints);r<0&&(r=-r-1),r>=n.length?r=0<i?0:n.length-1:0===r&&i<0&&(r=n.length-1);var o=n[r];if(o&&i){if(o.row===t){for(;(o=n[r+=i])&&o.row===t;);if(!o)return n.slice()}var s=[];for(t=o.row;s[i<0?"unshift":"push"](o),(o=n[r+=i])&&o.row==t;);return s.length&&s}}}t.showErrorMarker=function(e,t){var i=e.session;i.widgetManager||(i.widgetManager=new p(i),i.widgetManager.attach(e));var n=e.getCursorPosition(),r=n.row,o=i.widgetManager.getWidgetsAtRow(r).filter(function(e){return"errorMarker"==e.type})[0];o?o.destroy():r-=t;var s,a=f(i,r,t);if(a){var l=a[0];n.column=(l.pos&&"number"!=typeof l.column?l.pos.sc:l.column)||0,n.row=l.row,s=e.renderer.$gutterLayer.$annotations[n.row]}else{if(o)return;s={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(n.row),e.selection.moveToPosition(n);var c={row:n.row,fixedWidth:!0,coverGutter:!0,el:m.createElement("div"),type:"errorMarker"},h=c.el.appendChild(m.createElement("div")),d=c.el.appendChild(m.createElement("div"));d.className="error_widget_arrow "+s.className;var u=e.renderer.$cursorLayer.getPixelPosition(n).left;d.style.left=u+e.renderer.gutterWidth-5+"px",c.el.className="error_widget_wrapper",h.className="error_widget "+s.className,h.innerHTML=s.text.join("<br>"),h.appendChild(m.createElement("div"));function g(e,t,i){if(0===t&&("esc"===i||"return"===i))return c.destroy(),{command:"null"}}c.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(g),i.widgetManager.removeLineWidget(c),e.off("changeSelection",c.destroy),e.off("changeSession",c.destroy),e.off("mouseup",c.destroy),e.off("change",c.destroy))},e.keyBinding.addKeyboardHandler(g),e.on("changeSelection",c.destroy),e.on("changeSession",c.destroy),e.on("mouseup",c.destroy),e.on("change",c.destroy),e.session.widgetManager.addLineWidget(c),c.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:c.el.offsetHeight})},m.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","")}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,l,t){"use strict";e("./lib/fixoldbrowsers");var c=e("./lib/dom"),h=e("./lib/event"),i=e("./range").Range,d=e("./editor").Editor,n=e("./edit_session").EditSession,r=e("./undomanager").UndoManager,u=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),l.config=e("./config"),l.require=e,l.define=I(23),l.edit=function(e,t){if("string"==typeof e){var i=e;if(!(e=document.getElementById(i)))throw new Error("ace.edit can't find div #"+i)}if(e&&e.env&&e.env.editor instanceof d)return e.env.editor;var n,r="";e&&/input|textarea/i.test(e.tagName)?(r=(n=e).value,e=c.createElement("pre"),n.parentNode.replaceChild(e,n)):e&&(r=e.textContent,e.innerHTML="");var o=l.createEditSession(r),s=new d(new u(e),o,t),a={document:o,editor:s,onResize:s.resize.bind(s,null)};return n&&(a.textarea=n),h.addListener(window,"resize",a.onResize),s.on("destroy",function(){h.removeListener(window,"resize",a.onResize),a.editor.container.env=null}),s.container.env=s.env=a,s},l.createEditSession=function(e,t){var i=new n(e,t);return i.setUndoManager(new r),i},l.Range=i,l.Editor=d,l.EditSession=n,l.UndoManager=r,l.VirtualRenderer=u,l.version=l.config.version}),ace.require(["ace/ace"],function(e){for(var t in e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e),e)e.hasOwnProperty(t)&&(window.ace[t]=e[t]);window.ace.default=window.ace,i&&(i.exports=window.ace)})}).call(this,I(16)(e))},function(e,t,i){(function(t){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var r=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules;r.inherits(n,o),t.JsonHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){}var s=e("../range").Range;(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t).match(/^(\s*\})/);if(!i)return 0;var n=i[1].length,r=e.findMatchingBracket({row:t,column:n});if(!r||r.row==t)return 0;var o=this.$getIndent(e.getLine(r.row));e.replace(new s(t,0,t,n-1),o)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),h=e("../../range").Range,r=e("./fold_mode").FoldMode,o=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(o,r),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var r=this._getFoldWidgetBase(e,t,i);return!r&&this.startRegionRe.test(n)?"start":r},this.getFoldWidgetRange=function(e,t,i,n){var r=e.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(e,r,i);var o=r.match(this.foldingStartMarker);if(o){var s=o.index;if(o[1])return this.openingBracketBlock(e,o[1],i,s);var a=e.getCommentFoldRange(i,s+o[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t&&(o=r.match(this.foldingStopMarker))){s=o.index+o[0].length;return o[1]?this.closingBracketBlock(e,o[1],i,s):e.getCommentFoldRange(i,s,-1)}},this.getSectionRange=function(e,t){for(var i=e.getLine(t),n=i.search(/\S/),r=t,o=i.length,s=t+=1,a=e.getLength();++t<a;){var l=(i=e.getLine(t)).search(/\S/);if(-1!==l){if(l<n)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=r)break;if(c.isMultiLine())t=c.end.row;else if(n==l)break}s=t}}return new h(r,o,s,e.getLine(s).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),o=i,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++i<r;){t=e.getLine(i);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(o<i)return new h(o,n,i,t.length)}}.call(o.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,i){"use strict";function n(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c}var r=e("../lib/oop"),o=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient;r.inherits(n,o),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);return"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(n+=i),n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(t){var e=new h(["ace"],"ace/mode/json_worker","JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(n.prototype),t.Mode=n}),ace.require(["ace/mode/json"],function(e){t&&(t.exports=e)})}).call(this,i(16)(e))},function(e,t,i){(function(t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var r=e("../lib/dom"),n=e("../lib/lang"),s=e("../lib/event"),o='.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',a=e("../keyboard/hash_handler").HashHandler,l=e("../lib/keys");r.importCssString(o,"ace_searchbox");function c(e,t,i){var n=r.createElement("div");r.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],n),this.element=n.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e),r.importCssString(o,"ace_searchbox",e.container)}(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var o=this;s.addListener(e,"mousedown",function(e){setTimeout(function(){o.activeInput.focus()},0),s.stopPropagation(e)}),s.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute("action");t&&o[t]?o[t]():o.$searchBarKb.commands[t]&&o.$searchBarKb.commands[t].exec(o),s.stopPropagation(e)}),s.addCommandKeyListener(e,function(e,t,i){var n=l.keyCodeToString(i),r=o.$searchBarKb.findKeyCommand(t,n);r&&r.exec&&(r.exec(o),s.stopEvent(e))}),this.$onChange=n.delayedCall(function(){o.find(!1,!1)}),s.addListener(this.searchInput,"input",function(){o.$onChange.schedule(20)}),s.addListener(this.searchInput,"focus",function(){o.activeInput=o.searchInput,o.searchInput.value&&o.highlight()}),s.addListener(this.replaceInput,"focus",function(){o.activeInput=o.replaceInput,o.searchInput.value&&o.highlight()})},this.$closeSearchBarKb=new a([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new a,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.editor.getReadOnly()||(e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus())},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){r.setCssClass(this.replaceOption,"checked",this.searchRange),r.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",r.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),r.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),r.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var t=this.editor.getReadOnly();this.replaceOption.style.display=t?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!t?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var n=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",n),this.editor._emit("findSearchBox",{match:!n}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var r=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),o=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(o-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(r))&&(i++,(a=s.index)<=o&&n++,!(999<i))&&(s[0]||(t.lastIndex=a+=1,!(a>=r.length))););}this.searchCounter.textContent=n+" of "+(999<i?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),ace.require(["ace/ext/searchbox"],function(e){t&&(t.exports=e)})}).call(this,i(16)(e))},function(e,t){
e.exports="data:application/javascript;base64,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"
},function(e,t,i){e.exports=function(){"use strict";var s=function(e,t){if(!(e instanceof t)){throw new TypeError("Cannot call a class as a function")}},e=function(){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,t,i){if(t)n(e.prototype,t);if(i)n(e,i);return e}}(),m=function(){function i(e,t){var i=[];var n=true;var r=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){i.push(a.value);if(t&&i.length===t)break}}catch(e){r=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(r)throw o}}return i}return function(e,t){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return i(e,t)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();String.prototype.startsWith=String.prototype.startsWith||function(e){return this.indexOf(e)===0},String.prototype.padStart=String.prototype.padStart||function(e,t){var i=this;while(i.length<e){i=t+i}return i};var r={cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"};function a(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;var i=t>0?e.toFixed(t).replace(/0+$/,"").replace(/\.$/,""):e.toString();return i||"0"}var o=function(){function p(e,t,i,n){s(this,p);var g=this;function r(e){if(e.startsWith("hsl")){var t=e.match(/([\-\d\.e]+)/g).map(Number),i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];if(s===undefined){s=1}n/=360;r/=100;o/=100;g.hsla=[n,r,o,s]}else if(e.startsWith("rgb")){var a=e.match(/([\-\d\.e]+)/g).map(Number),l=m(a,4),c=l[0],h=l[1],d=l[2],u=l[3];if(u===undefined){u=1}g.rgba=[c,h,d,u]}else{if(e.startsWith("#")){g.rgba=p.hexToRgb(e)}else{g.rgba=p.nameToRgb(e)||p.hexToRgb(e)}}}if(e===undefined);else if(Array.isArray(e)){this.rgba=e}else if(i===undefined){var o=e&&""+e;if(o){r(o.toLowerCase())}}else{this.rgba=[e,t,i,n===undefined?1:n]}}e(p,[{key:"printRGB",value:function e(t){var i=t?this.rgba:this.rgba.slice(0,3),n=i.map(function(e,t){return a(e,t===3?3:0)});return t?"rgba("+n+")":"rgb("+n+")"}},{key:"printHSL",value:function e(t){var i=[360,100,100,1],n=["","%","%",""];var r=t?this.hsla:this.hsla.slice(0,3),o=r.map(function(e,t){return a(e*i[t],t===3?3:1)+n[t]});return t?"hsla("+o+")":"hsl("+o+")"}},{key:"printHex",value:function e(t){var i=this.hex;return t?i:i.substring(0,7)}},{key:"rgba",get:function e(){if(this._rgba){return this._rgba}if(!this._hsla){throw new Error("No color is set")}return this._rgba=p.hslToRgb(this._hsla)},set:function e(t){if(t.length===3){t[3]=1}this._rgba=t;this._hsla=null}},{key:"rgbString",get:function e(){return this.printRGB()}},{key:"rgbaString",get:function e(){return this.printRGB(true)}},{key:"hsla",get:function e(){if(this._hsla){return this._hsla}if(!this._rgba){throw new Error("No color is set")}return this._hsla=p.rgbToHsl(this._rgba)},set:function e(t){if(t.length===3){t[3]=1}this._hsla=t;this._rgba=null}},{key:"hslString",get:function e(){return this.printHSL()}},{key:"hslaString",get:function e(){return this.printHSL(true)}},{key:"hex",get:function e(){var t=this.rgba,i=t.map(function(e,t){return t<3?e.toString(16):Math.round(e*255).toString(16)});return"#"+i.map(function(e){return e.padStart(2,"0")}).join("")},set:function e(t){this.rgba=p.hexToRgb(t)}}],[{key:"hexToRgb",value:function e(t){var i=(t.startsWith("#")?t.slice(1):t).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!i.match(/^([0-9a-fA-F]{8})$/)){throw new Error("Unknown hex color; "+t)}var n=i.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});n[3]=n[3]/255;return n}},{key:"nameToRgb",value:function e(t){var i=t.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),n=r[i];return n===undefined?n:p.hexToRgb(n.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function e(t){var i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];n/=255;r/=255;o/=255;var a=Math.max(n,r,o),l=Math.min(n,r,o);var c=void 0,h=void 0,d=(a+l)/2;if(a===l){c=h=0}else{var u=a-l;h=d>.5?u/(2-a-l):u/(a+l);switch(a){case n:c=(r-o)/u+(r<o?6:0);break;case r:c=(o-n)/u+2;break;case o:c=(n-r)/u+4;break}c/=6}return[c,h,d,s]}},{key:"hslToRgb",value:function e(t){var i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];var a=void 0,l=void 0,c=void 0;if(r===0){a=l=c=o}else{var h=function e(t,i,n){if(n<0)n+=1;if(n>1)n-=1;if(n<1/6)return t+(i-t)*6*n;if(n<1/2)return i;if(n<2/3)return t+(i-t)*(2/3-n)*6;return t};var d=o<.5?o*(1+r):o+r-o*r,u=2*o-d;a=h(u,d,n+1/3);l=h(u,d,n);c=h(u,d,n-1/3)}var g=[a*255,l*255,c*255].map(Math.round);g[3]=s;return g}}]);return p}(),i=function(){function o(){s(this,o);this._events=[]}e(o,[{key:"add",value:function e(t,i,n){t.addEventListener(i,n,false);this._events.push({target:t,type:i,handler:n})}},{key:"remove",value:function e(i,n,r){this._events=this._events.filter(function(e){var t=true;if(i&&i!==e.target){t=false}if(n&&n!==e.type){t=false}if(r&&r!==e.handler){t=false}if(t){o._doRemove(e.target,e.type,e.handler)}return!t})}},{key:"destroy",value:function e(){this._events.forEach(function(e){return o._doRemove(e.target,e.type,e.handler)});this._events=[]}}],[{key:"_doRemove",value:function e(t,i,n){t.removeEventListener(i,n,false)}}]);return o}();function t(e){var i=document.createElement("div");return t.innerHTML=e,t.firstElementChild}function l(e,h,d){var u=false;function g(e,t,i){return Math.max(t,Math.min(e,i))}function n(e,t,i){if(i){u=true}if(!u){return}e.preventDefault();var n=h.getBoundingClientRect(),r=n.width,o=n.height,s=t.clientX,a=t.clientY;var l=g(s-n.left,0,r),c=g(a-n.top,0,o);d(l/r,c/o)}function t(e,t){var i=e.buttons===undefined?e.which:e.buttons;if(i===1){n(e,e,t)}else{u=false}}function i(e,t){if(e.touches.length===1){n(e,e.touches[0],t)}else{u=false}}e.add(h,"mousedown",function(e){t(e,true)});e.add(h,"touchstart",function(e){i(e,true)});e.add(window,"mousemove",t);e.add(h,"touchmove",i);e.add(window,"mouseup",function(e){u=false});e.add(h,"touchend",function(e){u=false});e.add(h,"touchcancel",function(e){u=false})}var n="url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")",c=360,h="keydown",d="mousedown",u="focusin";function A(e,t){return(t||document).querySelector(e)}function g(e){e.preventDefault();e.stopPropagation()}function p(e,t,i,n,r){e.add(t,h,function(e){if(i.indexOf(e.key)>=0){if(r){g(e)}n(e)}})}var f=document.createElement("style"),C;return f.textContent=".picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:-webkit-box;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;flex-flow:row wrap;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:stretch;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:'';display:block;width:100%;height:0;-webkit-box-ordinal-group:2;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_sl::before{content:'';display:block;padding-bottom:100%}.layout_default .picker_editor{-webkit-box-ordinal-group:2;order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{-webkit-box-ordinal-group:2;order:1;-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{-webkit-box-ordinal-group:2;order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px dodgerblue}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:whitesmoke;background-image:-webkit-gradient(linear, left bottom, left top, from(gainsboro), to(transparent));background-image:-webkit-linear-gradient(bottom, gainsboro, transparent);background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:-webkit-gradient(linear, left bottom, left top, from(transparent), to(gainsboro));background-image:-webkit-linear-gradient(bottom, transparent, gainsboro);background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:white}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:-webkit-gradient(linear, left top, right top, from(red), color-stop(yellow), color-stop(lime), color-stop(cyan), color-stop(blue), color-stop(magenta), to(red));background-image:-webkit-linear-gradient(left, red, yellow, lime, cyan, blue, magenta, red);background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:-webkit-gradient(linear, left top, left bottom, from(white), color-stop(50%, rgba(255,255,255,0))),-webkit-gradient(linear, left bottom, left top, from(black), color-stop(50%, rgba(0,0,0,0))),-webkit-gradient(linear, left top, right top, from(gray), to(rgba(128,128,128,0)));background-image:-webkit-linear-gradient(top, white, rgba(255,255,255,0) 50%),-webkit-linear-gradient(bottom, black, rgba(0,0,0,0) 50%),-webkit-linear-gradient(left, gray, rgba(128,128,128,0));background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:'';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}",document.documentElement.firstElementChild.appendChild(f),function(){function t(e){s(this,t),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1,defaultColor:"#0cf"},this._events=new i,this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return e(t,[{key:"setOptions",value:function(e){var t,i,n,r,o=this;e&&(t=this.settings,e instanceof HTMLElement?t.parent=e:(t.parent&&e.parent&&t.parent!==e.parent&&(this._events.remove(t.parent),this._popupInited=!1),function(e,t,i){for(var n in e)i&&0<=i.indexOf(n)||(t[n]=e[n])}(e,t),e.onChange&&(this.onChange=e.onChange),e.onDone&&(this.onDone=e.onDone),e.onOpen&&(this.onOpen=e.onOpen),e.onClose&&(this.onClose=e.onClose),(i=e.color||e.colour)&&this._setColor(i)),(n=t.parent)&&t.popup&&!this._popupInited?(r=function(e){return o.openHandler(e)},this._events.add(n,"click",r),p(this._events,n,[" ","Spacebar","Enter"],r),this._popupInited=!0):e.parent&&!t.popup&&this.show())}},{key:"openHandler",value:function(e){var t;this.show()&&(e&&e.preventDefault(),this.settings.parent.style.pointerEvents="none",t=e&&"keydown"===e.type?this._domEdit:this.domElement,setTimeout(function(){return t.focus()},100),this.onOpen&&this.onOpen(this.colour))}},{key:"closeHandler",value:function(e){var t,i=e&&e.type,n=!1;e?i===d||i===u?(t=(this.__containedEvent||0)+100,e.timeStamp>t&&(n=!0)):(g(e),n=!0):n=!0,n&&this.hide()&&(this.settings.parent.style.pointerEvents="",i!==d&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(e,t){this.closeHandler(),this.setOptions(e),t&&this.openHandler()}},{key:"setColor",value:function(e,t){this._setColor(e,{silent:t})}},{key:"_setColor",value:function(e,t){if("string"==typeof e&&(e=e.trim()),e){t=t||{};var i,n=void 0;try{n=new o(e)}catch(e){if(t.failSilently)return;throw e}this.settings.alpha||((i=n.hsla)[3]=1,n.hsla=i),this.colour=this.color=n,this._setHSLA(null,null,null,null,t)}}},{key:"setColour",value:function(e,t){this.setColor(e,t)}},{key:"show",value:function(){if(!this.settings.parent)return!1;if(this.domElement){var e=this._toggleDOM(!0);return this._setPosition(),e}var t,i,n=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>',r=(t=n,(i=document.createElement("div")).innerHTML=t,i.firstElementChild);return this.domElement=r,this._domH=A(".picker_hue",r),this._domSL=A(".picker_sl",r),this._domA=A(".picker_alpha",r),this._domEdit=A(".picker_editor input",r),this._domSample=A(".picker_sample",r),this._domOkay=A(".picker_done button",r),this._domCancel=A(".picker_cancel button",r),r.classList.add("layout_"+this.settings.layout),this.settings.alpha||r.classList.add("no_alpha"),this.settings.editor||r.classList.add("no_editor"),this.settings.cancelButton||r.classList.add("no_cancel"),this._ifPopup(function(){return r.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor(this.settings.defaultColor),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy(),this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){var i=this,n=this,r=this.domElement,o=this._events;function s(e,t,i){o.add(e,t,i)}s(r,"click",function(e){return e.preventDefault()}),l(o,this._domH,function(e,t){return n._setHSLA(e)}),l(o,this._domSL,function(e,t){return n._setHSLA(null,e,1-t)}),this.settings.alpha&&l(o,this._domA,function(e,t){return n._setHSLA(null,null,null,1-t)});var e=this._domEdit;s(e,"input",function(e){n._setColor(this.value,{fromEditor:!0,failSilently:!0})}),s(e,"focus",function(e){this.selectionStart===this.selectionEnd&&this.select()}),this._ifPopup(function(){function e(e){return i.closeHandler(e)}s(window,d,e),s(window,u,e),p(o,r,["Esc","Escape"],e);function t(e){i.__containedEvent=e.timeStamp}s(r,d,t),s(r,u,t),s(i._domCancel,"click",e)});function t(e){i._ifPopup(function(){return i.closeHandler(e)}),i.onDone&&i.onDone(i.colour)}s(this._domOkay,"click",t),p(o,r,["Enter"],t)}},{key:"_setPosition",value:function(){var i=this.settings.parent,n=this.domElement;i!==n.parentNode&&i.appendChild(n),this._ifPopup(function(e){"static"===getComputedStyle(i).position&&(i.style.position="relative");var t=!0===e?"popup_right":"popup_"+e;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(e){e===t?n.classList.add(e):n.classList.remove(e)}),n.classList.add(t)})}},{key:"_setHSLA",value:function(e,t,i,n,r){r=r||{};var o=this.colour,s=o.hsla;[e,t,i,n].forEach(function(e,t){!e&&0!==e||(s[t]=e)}),o.hsla=s,this._updateUI(r),this.onChange&&!r.silent&&this.onChange(o)}},{key:"_updateUI",value:function(e){if(this.domElement){e=e||{};var t=this.colour,i=t.hsla,n="hsl("+360*i[0]+", 100%, 50%)",r=t.hslString,o=t.hslaString,s=this._domH,a=this._domSL,l=this._domA,c=A(".picker_selector",s),h=A(".picker_selector",a),d=A(".picker_selector",l);v(0,c,i[0]),this._domSL.style.backgroundColor=this._domH.style.color=n,v(0,h,i[1]),I(0,h,1-i[2]),a.style.color=r,I(0,d,1-i[3]);var u=r,g=u.replace("hsl","hsla").replace(")",", 0)"),p="linear-gradient("+[u,g]+")";if(this._domA.style.backgroundImage=p+", url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")",!e.fromEditor){var m=this.settings.editorFormat,f=this.settings.alpha,C=void 0;switch(m){case"rgb":C=t.printRGB(f);break;case"hsl":C=t.printHSL(f);break;default:C=t.printHex(f)}this._domEdit.value=C}this._domSample.style.color=o}function v(e,t,i){t.style.left=100*i+"%"}function I(e,t,i){t.style.top=100*i+"%"}}},{key:"_ifPopup",value:function(e,t){this.settings.parent&&this.settings.popup?e&&e(this.settings.popup):t&&t()}},{key:"_toggleDOM",value:function(e){var t=this.domElement;if(!t)return!1;var i=e?"":"none",n=t.style.display!==i;return n&&(t.style.display=i),n}}],[{key:"StyleElement",get:function(){return f}}]),t}()}()},function(e,t){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},function(e,t,i){t.tryRequireAjv=function(){try{return i(44)}catch(e){}}},function(e,t,n){"use strict";var a=n(45),u=n(17),i=n(49),g=n(25),r=n(26),o=n(50),s=n(51),l=n(72),c=n(7);(e.exports=C).prototype.validate=function(e,t){var i;if("string"==typeof e){if(!(i=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var n=this._addSchema(e);i=n.validate||this._compile(n)}var r=i(t);!0!==i.$async&&(this.errors=i.errors);return r},C.prototype.compile=function(e,t){var i=this._addSchema(e,void 0,t);return i.validate||this._compile(i)},C.prototype.addSchema=function(e,t,i,n){if(Array.isArray(e)){for(var r=0;r<e.length;r++)this.addSchema(e[r],void 0,i,n);return this}var o=this._getId(e);if(void 0!==o&&"string"!=typeof o)throw new Error("schema id must be string");return w(this,t=u.normalizeId(t||o)),this._schemas[t]=this._addSchema(e,i,n,!0),this},C.prototype.addMetaSchema=function(e,t,i){return this.addSchema(e,t,i,!0),this},C.prototype.validateSchema=function(e,t){var i=e.$schema;if(void 0!==i&&"string"!=typeof i)throw new Error("$schema must be a string");if(!(i=i||this._opts.defaultMeta||function(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(p)?p:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);var n=this.validate(i,e);if(!n&&t){var r="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(r);this.logger.error(r)}return n},C.prototype.getSchema=function(e){var t=v(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(e,t){var i=u.schema.call(e,{schema:{}},t);if(i){var n=i.schema,r=i.root,o=i.baseId,s=a.call(e,n,r,void 0,o);return e._fragments[t]=new g({ref:t,fragment:!0,schema:n,root:r,baseId:o,validate:s}),s}}(this,e)}},C.prototype.removeSchema=function(e){if(e instanceof RegExp)return I(this,this._schemas,e),I(this,this._refs,e),this;switch(typeof e){case"undefined":return I(this,this._schemas),I(this,this._refs),this._cache.clear(),this;case"string":var t=v(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var i=this._opts.serialize,n=i?i(e):e;this._cache.del(n);var r=this._getId(e);r&&(r=u.normalizeId(r),delete this._schemas[r],delete this._refs[r])}return this},C.prototype.addFormat=function(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},C.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var i=void 0===(t=t||{}).separator?", ":t.separator,n=void 0===t.dataVar?"data":t.dataVar,r="",o=0;o<e.length;o++){var s=e[o];s&&(r+=n+s.dataPath+" "+s.message+i)}return r.slice(0,-i.length)},C.prototype._addSchema=function(e,t,i,n){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var r=this._opts.serialize,o=r?r(e):e,s=this._cache.get(o);if(s)return s;n=n||!1!==this._opts.addUsedSchema;var a=u.normalizeId(this._getId(e));a&&n&&w(this,a);var l,c=!1!==this._opts.validateSchema&&!t;c&&!(l=a&&a==u.normalizeId(e.$schema))&&this.validateSchema(e,!0);var h=u.ids.call(this,e),d=new g({id:a,schema:e,localRefs:h,cacheKey:o,meta:i});"#"!=a[0]&&n&&(this._refs[a]=d);this._cache.put(o,d),c&&l&&this.validateSchema(e,!0);return d},C.prototype._compile=function(i,e){if(i.compiling)return(i.validate=r).schema=i.schema,r.errors=null,r.root=e||r,!0===i.schema.$async&&(r.$async=!0),r;var t,n;i.compiling=!0,i.meta&&(t=this._opts,this._opts=this._metaOpts);try{n=a.call(this,i.schema,e,i.localRefs)}catch(e){throw delete i.validate,e}finally{i.compiling=!1,i.meta&&(this._opts=t)}return i.validate=n,i.refs=n.refs,i.refVal=n.refVal,i.root=n.root,n;function r(){var e=i.validate,t=e.apply(this,arguments);return r.errors=e.errors,t}},C.prototype.compileAsync=n(73);var h=n(74);C.prototype.addKeyword=h.add,C.prototype.getKeyword=h.get,C.prototype.removeKeyword=h.remove,C.prototype.validateKeyword=h.validate;var d=n(19);C.ValidationError=d.Validation,C.MissingRefError=d.MissingRef,C.$dataMetaSchema=l;var p="http://json-schema.org/draft-07/schema",m=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],f=["/properties"];function C(e){if(!(this instanceof C))return new C(e);e=this._opts=c.copy(e)||{},function(e){var t=e._opts.logger;if(!1===t)e.logger={log:S,warn:S,error:S};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}(this),this._schemas={},this._refs={},this._fragments={},this._formats=o(e.format),this._cache=e.cache||new i,this._loadingSchemas={},this._compilations=[],this.RULES=s(),this._getId=function(e){switch(e.schemaId){case"auto":return y;case"id":return A;default:return b}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=r),this._metaOpts=function(e){for(var t=c.copy(e._opts),i=0;i<m.length;i++)delete t[m[i]];return t}(this),e.formats&&function(e){for(var t in e._opts.formats){var i=e._opts.formats[t];e.addFormat(t,i)}}(this),e.keywords&&function(e){for(var t in e._opts.keywords){var i=e._opts.keywords[t];e.addKeyword(t,i)}}(this),function(e){var t;e._opts.$data&&(t=n(77),e.addMetaSchema(t,t.$id,!0));if(!1===e._opts.meta)return;var i=n(32);e._opts.$data&&(i=l(i,f));e.addMetaSchema(i,p,!0),e._refs["http://json-schema.org/schema"]=p}(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),function(e){var t=e._opts.schemas;if(!t)return;if(Array.isArray(t))e.addSchema(t);else for(var i in t)e.addSchema(t[i],i)}(this)}function v(e,t){return t=u.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function I(e,t,i){for(var n in t){var r=t[n];r.meta||i&&!i.test(n)||(e._cache.del(r.cacheKey),delete t[n])}}function A(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function b(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function y(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function w(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function S(){}},function(e,t,i){"use strict";var E=i(17),R=i(7),_=i(19),T=i(26),$=i(27),L=R.ucs2length,B=i(18),W=_.Validation;function O(e,d,u,t){var g=this,p=this._opts,m=[void 0],f={},l=[],i={},c=[],n={},C=[],r=function(e,t,i){var n=N.call(this,e,t,i);return 0<=n?{index:n,compiling:!0}:(n=this._compilations.length,this._compilations[n]={schema:e,root:t,baseId:i},{index:n,compiling:!1})}.call(this,e,d=d||{schema:e,refVal:m,refs:f},t),o=this._compilations[r.index];if(r.compiling)return o.callValidate=I;var h=this._formats,v=this.RULES;try{var s=A(e,d,u,t);o.validate=s;var a=o.callValidate;return a&&(a.schema=s.schema,a.errors=null,a.refs=s.refs,a.refVal=s.refVal,a.root=s.root,a.$async=s.$async,p.sourceCode&&(a.source=s.source)),s}finally{(function(e,t,i){var n=N.call(this,e,t,i);0<=n&&this._compilations.splice(n,1)}).call(this,e,d,t)}function I(){var e=o.validate,t=e.apply(this,arguments);return I.errors=e.errors,t}function A(e,t,i,n){var r=!t||t&&t.schema==e;if(t.schema!=d.schema)return O.call(g,e,t,i,n);var o=!0===e.$async,s=$({isTop:!0,schema:e,isRoot:r,baseId:n,root:t,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:_.MissingRef,RULES:v,validate:$,util:R,resolve:E,resolveRef:b,usePattern:S,useDefault:x,useCustomRule:k,opts:p,formats:h,logger:g.logger,self:g}),s=F(m,P)+F(l,G)+F(c,H)+F(C,V)+s;p.processCode&&(s=p.processCode(s,e));try{var a=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",s)(g,v,h,d,m,c,C,B,L,W);m[0]=a}catch(e){throw g.logger.error("Error compiling schema, function code:",s),e}return a.schema=e,a.errors=null,a.refs=f,a.refVal=m,a.root=r?a:t,o&&(a.$async=!0),!0===p.sourceCode&&(a.source={code:s,patterns:l,defaults:c}),a}function b(e,t,i){t=E.url(e,t);var n,r,o=f[t];if(void 0!==o)return w(n=m[o],r="refVal["+o+"]");if(!i&&d.refs){var s=d.refs[t];if(void 0!==s)return w(n=d.refVal[s],r=y(t,n))}r=y(t);var a,l,c,h=E.call(g,A,d,t);if(void 0!==h||(a=u&&u[t])&&(h=E.inlineRef(a,p.inlineRefs)?a:O.call(g,a,d,u,e)),void 0!==h)return l=h,c=f[t],m[c]=l,w(h,r);delete f[t]}function y(e,t){var i=m.length;return m[i]=t,"refVal"+(f[e]=i)}function w(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function S(e){var t=i[e];return void 0===t&&(t=i[e]=l.length,l[t]=e),"pattern"+t}function x(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return R.toQuotedString(e);case"object":if(null===e)return"null";var t=T(e),i=n[t];return void 0===i&&(i=n[t]=c.length,c[i]=e),"default"+i}}function k(e,t,i,n){if(!1!==g._opts.validateSchema){var r=e.definition.dependencies;if(r&&!r.every(function(e){return Object.prototype.hasOwnProperty.call(i,e)}))throw new Error("parent schema must have all required keywords: "+r.join(","));var o=e.definition.validateSchema;if(o)if(!o(t)){var s="keyword schema is invalid: "+g.errorsText(o.errors);if("log"!=g._opts.validateSchema)throw new Error(s);g.logger.error(s)}}var a,l=e.definition.compile,c=e.definition.inline,h=e.definition.macro;if(l)a=l.call(g,t,i,n);else if(h)a=h.call(g,t,i,n),!1!==p.validateSchema&&g.validateSchema(a,!0);else if(c)a=c.call(g,n,e.keyword,t,i);else if(!(a=e.definition.validate))return;if(void 0===a)throw new Error('custom keyword "'+e.keyword+'"failed to compile');var d=C.length;return{code:"customRule"+d,validate:C[d]=a}}}function N(e,t,i){for(var n=0;n<this._compilations.length;n++){var r=this._compilations[n];if(r.schema==e&&r.root==t&&r.baseId==i)return n}return-1}function G(e,t){return"var pattern"+e+" = new RegExp("+R.toQuotedString(t[e])+");"}function H(e){return"var default"+e+" = defaults["+e+"];"}function P(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function V(e){return"var customRule"+e+" = customRules["+e+"];"}function F(e,t){if(!e.length)return"";for(var i="",n=0;n<e.length;n++)i+=t(n,e);return i}e.exports=O},function(e,t,i){
/** @license URI.js v4.2.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
!function(e){"use strict";function he(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++){t[i]=arguments[i]}if(t.length>1){t[0]=t[0].slice(0,-1);var n=t.length-1;for(var r=1;r<n;++r){t[r]=t[r].slice(1,-1)}t[n]=t[n].slice(1);return t.join("")}else{return t[0]}}function de(e){return"(?:"+e+")"}function n(e){return e===undefined?"undefined":e===null?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function p(e){return e.toUpperCase()}function m(e){return e!==undefined&&e!==null?e instanceof Array?e:typeof e.length!=="number"||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}function r(e,t){var i=e;if(t){for(var n in t){i[n]=t[n]}}return i}function t(e){var t="[A-Za-z]",i="[\\x0D]",n="[0-9]",r="[\\x22]",o=he(n,"[A-Fa-f]"),s="[\\x0A]",a="[\\x20]",l=de(de("%[EFef]"+o+"%"+o+o+"%"+o+o)+"|"+de("%[89A-Fa-f]"+o+"%"+o+o)+"|"+de("%"+o+o)),c="[\\:\\/\\?\\#\\[\\]\\@]",h="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",d=he(c,h),u=e?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",g=e?"[\\uE000-\\uF8FF]":"[]",p=he(t,n,"[\\-\\.\\_\\~]",u),m=de(t+he(t,n,"[\\+\\-\\.]")+"*"),f=de(de(l+"|"+he(p,h,"[\\:]"))+"*"),C=de(de("25[0-5]")+"|"+de("2[0-4]"+n)+"|"+de("1"+n+n)+"|"+de("[1-9]"+n)+"|"+n),v=de(de("25[0-5]")+"|"+de("2[0-4]"+n)+"|"+de("1"+n+n)+"|"+de("0?[1-9]"+n)+"|0?0?"+n),I=de(v+"\\."+v+"\\."+v+"\\."+v),A=de(o+"{1,4}"),b=de(de(A+"\\:"+A)+"|"+I),y=de(de(A+"\\:")+"{6}"+b),w=de("\\:\\:"+de(A+"\\:")+"{5}"+b),S=de(de(A)+"?\\:\\:"+de(A+"\\:")+"{4}"+b),x=de(de(de(A+"\\:")+"{0,1}"+A)+"?\\:\\:"+de(A+"\\:")+"{3}"+b),k=de(de(de(A+"\\:")+"{0,2}"+A)+"?\\:\\:"+de(A+"\\:")+"{2}"+b),E=de(de(de(A+"\\:")+"{0,3}"+A)+"?\\:\\:"+A+"\\:"+b),R=de(de(de(A+"\\:")+"{0,4}"+A)+"?\\:\\:"+b),_=de(de(de(A+"\\:")+"{0,5}"+A)+"?\\:\\:"+A),T=de(de(de(A+"\\:")+"{0,6}"+A)+"?\\:\\:"),$=de([y,w,S,x,k,E,R,_,T].join("|")),L=de(de(p+"|"+l)+"+"),B=de($+"\\%25"+L),W=de($+de("\\%25|\\%(?!"+o+"{2})")+L),O=de("[vV]"+o+"+\\."+he(p,h,"[\\:]")+"+"),N=de("\\["+de(W+"|"+$+"|"+O)+"\\]"),G=de(de(l+"|"+he(p,h))+"*"),H=de(N+"|"+I+"(?!"+G+")"+"|"+G),P=de(n+"*"),V=de(de(f+"@")+"?"+H+de("\\:"+P)+"?"),F=de(l+"|"+he(p,h,"[\\:\\@]")),Z=de(F+"*"),M=de(F+"+"),j=de(de(l+"|"+he(p,h,"[\\@]"))+"+"),D=de(de("\\/"+Z)+"*"),K=de("\\/"+de(M+D)+"?"),z=de(j+D),X=de(M+D),J="(?!"+F+")",Y=de(D+"|"+K+"|"+z+"|"+X+"|"+J),U=de(de(F+"|"+he("[\\/\\?]",g))+"*"),Q=de(de(F+"|[\\/\\?]")+"*"),q=de(de("\\/\\/"+V+D)+"|"+K+"|"+X+"|"+J),ee=de(m+"\\:"+q+de("\\?"+U)+"?"+de("\\#"+Q)+"?"),te=de(de("\\/\\/"+V+D)+"|"+K+"|"+z+"|"+J),ie=de(te+de("\\?"+U)+"?"+de("\\#"+Q)+"?"),ne=de(ee+"|"+ie),re=de(m+"\\:"+q+de("\\?"+U)+"?"),oe="^("+m+")\\:"+de(de("\\/\\/("+de("("+f+")@")+"?("+H+")"+de("\\:("+P+")")+"?)")+"?("+D+"|"+K+"|"+X+"|"+J+")")+de("\\?("+U+")")+"?"+de("\\#("+Q+")")+"?$",se="^(){0}"+de(de("\\/\\/("+de("("+f+")@")+"?("+H+")"+de("\\:("+P+")")+"?)")+"?("+D+"|"+K+"|"+z+"|"+J+")")+de("\\?("+U+")")+"?"+de("\\#("+Q+")")+"?$",ae="^("+m+")\\:"+de(de("\\/\\/("+de("("+f+")@")+"?("+H+")"+de("\\:("+P+")")+"?)")+"?("+D+"|"+K+"|"+X+"|"+J+")")+de("\\?("+U+")")+"?$",le="^"+de("\\#("+Q+")")+"?$",ce="^"+de("("+f+")@")+"?("+H+")"+de("\\:("+P+")")+"?$";return{NOT_SCHEME:new RegExp(he("[^]",t,n,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(he("[^\\%\\:]",p,h),"g"),NOT_HOST:new RegExp(he("[^\\%\\[\\]\\:]",p,h),"g"),NOT_PATH:new RegExp(he("[^\\%\\/\\:\\@]",p,h),"g"),NOT_PATH_NOSCHEME:new RegExp(he("[^\\%\\/\\@]",p,h),"g"),NOT_QUERY:new RegExp(he("[^\\%]",p,h,"[\\:\\@\\/\\?]",g),"g"),NOT_FRAGMENT:new RegExp(he("[^\\%]",p,h,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(he("[^]",p,h),"g"),UNRESERVED:new RegExp(p,"g"),OTHER_CHARS:new RegExp(he("[^\\%]",p,d),"g"),PCT_ENCODED:new RegExp(l,"g"),IPV4ADDRESS:new RegExp("^("+I+")$"),IPV6ADDRESS:new RegExp("^\\[?("+$+")"+de(de("\\%25|\\%(?!"+o+"{2})")+"("+L+")")+"?\\]?$")}}var a=t(false),l=t(true),y=function(){function i(e,t){var i=[];var n=true;var r=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){i.push(a.value);if(t&&i.length===t)break}}catch(e){r=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(r)throw o}}return i}return function(e,t){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return i(e,t)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}(),i=function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}else{return Array.from(e)}},W=2147483647,O=36,N=1,G=26,o=38,s=700,H=72,P=128,V="-",c=/^xn--/,h=/[^\0-\x7E]/,d=/[\x2E\u3002\uFF0E\uFF61]/g,u={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},g=O-N,F=Math.floor,Z=String.fromCharCode;function M(e){throw new RangeError(u[e])}function f(e,t){var i=[];var n=e.length;while(n--){i[n]=t(e[n])}return i}function C(e,t){var i=e.split("@");var n="";if(i.length>1){n=i[0]+"@";e=i[1]}e=e.replace(d,".");var r=e.split(".");var o=f(r,t).join(".");return n+o}function j(e){var t=[];var i=0;var n=e.length;while(i<n){var r=e.charCodeAt(i++);if(r>=55296&&r<=56319&&i<n){var o=e.charCodeAt(i++);if((o&64512)==56320){t.push(((r&1023)<<10)+(o&1023)+65536)}else{t.push(r);i--}}else{t.push(r)}}return t}var v,I=function e(t){if(t-48<10){return t-22}if(t-65<26){return t-65}if(t-97<26){return t-97}return O},D=function e(t,i){return t+22+75*(t<26)-((i!=0)<<5)},K=function e(t,i,n){var r=0;t=n?F(t/s):t>>1;t+=F(t/i);for(;t>g*G>>1;r+=O){t=F(t/g)}return F(r+(g+1)*t/(t+o))},A=function e(t){var i=[];var n=t.length;var r=0;var o=P;var s=H;var a=t.lastIndexOf(V);if(a<0){a=0}for(var l=0;l<a;++l){if(t.charCodeAt(l)>=128){M("not-basic")}i.push(t.charCodeAt(l))}for(var c=a>0?a+1:0;c<n;){var h=r;for(var d=1,u=O;;u+=O){if(c>=n){M("invalid-input")}var g=I(t.charCodeAt(c++));if(g>=O||g>F((W-r)/d)){M("overflow")}r+=g*d;var p=u<=s?N:u>=s+G?G:u-s;if(g<p){break}var m=O-p;if(d>F(W/m)){M("overflow")}d*=m}var f=i.length+1;s=K(r-h,f,h==0);if(F(r/f)>W-o){M("overflow")}o+=F(r/f);r%=f;i.splice(r++,0,o)}return String.fromCodePoint.apply(String,i)},b=function e(t){var i=[];t=j(t);var n=t.length;var r=P;var o=0;var s=H;var a=true;var l=false;var c=undefined;try{for(var h=t[Symbol.iterator](),d;!(a=(d=h.next()).done);a=true){var u=d.value;if(u<128){i.push(Z(u))}}}catch(e){l=true;c=e}finally{try{if(!a&&h.return){h.return()}}finally{if(l){throw c}}}var g=i.length;var p=g;if(g){i.push(V)}while(p<n){var m=W;var f=true;var C=false;var v=undefined;try{for(var I=t[Symbol.iterator](),A;!(f=(A=I.next()).done);f=true){var b=A.value;if(b>=r&&b<m){m=b}}}catch(e){C=true;v=e}finally{try{if(!f&&I.return){I.return()}}finally{if(C){throw v}}}var y=p+1;if(m-r>F((W-o)/y)){M("overflow")}o+=(m-r)*y;r=m;var w=true;var S=false;var x=undefined;try{for(var k=t[Symbol.iterator](),E;!(w=(E=k.next()).done);w=true){var R=E.value;if(R<r&&++o>W){M("overflow")}if(R==r){var _=o;for(var T=O;;T+=O){var $=T<=s?N:T>=s+G?G:T-s;if(_<$){break}var L=_-$;var B=O-$;i.push(Z(D($+L%B,0)));_=F(L/B)}i.push(Z(D(_,0)));s=K(o,y,p==g);o=0;++p}}}catch(e){S=true;x=e}finally{try{if(!w&&k.return){k.return()}}finally{if(S){throw x}}}++o;++r}return i.join("")},w,S,x={version:"2.1.0",ucs2:{decode:j,encode:function e(t){return String.fromCodePoint.apply(String,i(t))}},decode:A,encode:b,toASCII:function e(t){return C(t,function(e){return h.test(e)?"xn--"+b(e):e})},toUnicode:function e(t){return C(t,function(e){return c.test(e)?A(e.slice(4).toLowerCase()):e})}},k={};function E(e){var t=e.charCodeAt(0);var i=void 0;if(t<16)i="%0"+t.toString(16).toUpperCase();else if(t<128)i="%"+t.toString(16).toUpperCase();else if(t<2048)i="%"+(t>>6|192).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();else i="%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();return i}function R(e){var t="";var i=0;var n=e.length;while(i<n){var r=parseInt(e.substr(i+1,2),16);if(r<128){t+=String.fromCharCode(r);i+=3}else if(r>=194&&r<224){if(n-i>=6){var o=parseInt(e.substr(i+4,2),16);t+=String.fromCharCode((r&31)<<6|o&63)}else{t+=e.substr(i,6)}i+=6}else if(r>=224){if(n-i>=9){var s=parseInt(e.substr(i+4,2),16);var a=parseInt(e.substr(i+7,2),16);t+=String.fromCharCode((r&15)<<12|(s&63)<<6|a&63)}else{t+=e.substr(i,9)}i+=9}else{t+=e.substr(i,3);i+=3}}return t}function _(e,i){function t(e){var t=R(e);return!t.match(i.UNRESERVED)?e:t}if(e.scheme)e.scheme=String(e.scheme).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_SCHEME,"");if(e.userinfo!==undefined)e.userinfo=String(e.userinfo).replace(i.PCT_ENCODED,t).replace(i.NOT_USERINFO,E).replace(i.PCT_ENCODED,p);if(e.host!==undefined)e.host=String(e.host).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_HOST,E).replace(i.PCT_ENCODED,p);if(e.path!==undefined)e.path=String(e.path).replace(i.PCT_ENCODED,t).replace(e.scheme?i.NOT_PATH:i.NOT_PATH_NOSCHEME,E).replace(i.PCT_ENCODED,p);if(e.query!==undefined)e.query=String(e.query).replace(i.PCT_ENCODED,t).replace(i.NOT_QUERY,E).replace(i.PCT_ENCODED,p);if(e.fragment!==undefined)e.fragment=String(e.fragment).replace(i.PCT_ENCODED,t).replace(i.NOT_FRAGMENT,E).replace(i.PCT_ENCODED,p);return e}function T(e){return e.replace(/^0*(.*)/,"$1")||"0"}function $(e,t){var i=e.match(t.IPV4ADDRESS)||[];var n=y(i,2),r=n[1];if(r){return r.split(".").map(T).join(".")}else{return e}}function L(e,t){var i=e.match(t.IPV6ADDRESS)||[];var n=y(i,3),r=n[1],o=n[2];if(r){var s=r.toLowerCase().split("::").reverse(),a=y(s,2),l=a[0],c=a[1];var h=c?c.split(":").map(T):[];var d=l.split(":").map(T);var u=t.IPV4ADDRESS.test(d[d.length-1]);var g=u?7:8;var p=d.length-g;var m=Array(g);for(var f=0;f<g;++f){m[f]=h[f]||d[p+f]||""}if(u){m[g-1]=$(m[g-1],t)}var C=m.reduce(function(e,t,i){if(!t||t==="0"){var n=e[e.length-1];if(n&&n.index+n.length===i){n.length++}else{e.push({index:i,length:1})}}return e},[]);var v=C.sort(function(e,t){return t.length-e.length})[0];var I=void 0;if(v&&v.length>1){var A=m.slice(0,v.index);var b=m.slice(v.index+v.length);I=A.join(":")+"::"+b.join(":")}else{I=m.join(":")}if(o){I+="%"+o}return I}else{return e}}var B=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,z="".match(/(){0}/)[1]===undefined;function X(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var i={};var n=t.iri!==false?l:a;if(t.reference==="suffix")e=(t.scheme?t.scheme+":":"")+"//"+e;var r=e.match(B);if(r){if(z){i.scheme=r[1];i.userinfo=r[3];i.host=r[4];i.port=parseInt(r[5],10);i.path=r[6]||"";i.query=r[7];i.fragment=r[8];if(isNaN(i.port)){i.port=r[5]}}else{i.scheme=r[1]||undefined;i.userinfo=e.indexOf("@")!==-1?r[3]:undefined;i.host=e.indexOf("//")!==-1?r[4]:undefined;i.port=parseInt(r[5],10);i.path=r[6]||"";i.query=e.indexOf("?")!==-1?r[7]:undefined;i.fragment=e.indexOf("#")!==-1?r[8]:undefined;if(isNaN(i.port)){i.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?r[4]:undefined}}if(i.host){i.host=L($(i.host,n),n)}if(i.scheme===undefined&&i.userinfo===undefined&&i.host===undefined&&i.port===undefined&&!i.path&&i.query===undefined){i.reference="same-document"}else if(i.scheme===undefined){i.reference="relative"}else if(i.fragment===undefined){i.reference="absolute"}else{i.reference="uri"}if(t.reference&&t.reference!=="suffix"&&t.reference!==i.reference){i.error=i.error||"URI is not a "+t.reference+" reference."}var o=k[(t.scheme||i.scheme||"").toLowerCase()];if(!t.unicodeSupport&&(!o||!o.unicodeSupport)){if(i.host&&(t.domainHost||o&&o.domainHost)){try{i.host=x.toASCII(i.host.replace(n.PCT_ENCODED,R).toLowerCase())}catch(e){i.error=i.error||"Host's domain name can not be converted to ASCII via punycode: "+e}}_(i,a)}else{_(i,n)}if(o&&o.parse){o.parse(i,t)}}else{i.error=i.error||"URI can not be parsed."}return i}function J(e,t){var i=t.iri!==false?l:a;var n=[];if(e.userinfo!==undefined){n.push(e.userinfo);n.push("@")}if(e.host!==undefined){n.push(L($(String(e.host),i),i).replace(i.IPV6ADDRESS,function(e,t,i){return"["+t+(i?"%25"+i:"")+"]"}))}if(typeof e.port==="number"){n.push(":");n.push(e.port.toString(10))}return n.length?n.join(""):undefined}var Y=/^\.\.?\//,U=/^\/\.(\/|$)/,Q=/^\/\.\.(\/|$)/,q=/^\/?(?:.|\n)*?(?=\/|$)/;function ee(e){var t=[];while(e.length){if(e.match(Y)){e=e.replace(Y,"")}else if(e.match(U)){e=e.replace(U,"/")}else if(e.match(Q)){e=e.replace(Q,"/");t.pop()}else if(e==="."||e===".."){e=""}else{var i=e.match(q);if(i){var n=i[0];e=e.slice(n.length);t.push(n)}else{throw new Error("Unexpected dot segment condition")}}}return t.join("")}function te(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var e=i.iri?l:a;var n=[];var r=k[(i.scheme||t.scheme||"").toLowerCase()];if(r&&r.serialize)r.serialize(t,i);if(t.host){if(e.IPV6ADDRESS.test(t.host)){}else if(i.domainHost||r&&r.domainHost){try{t.host=!i.iri?x.toASCII(t.host.replace(e.PCT_ENCODED,R).toLowerCase()):x.toUnicode(t.host)}catch(e){t.error=t.error||"Host's domain name can not be converted to "+(!i.iri?"ASCII":"Unicode")+" via punycode: "+e}}}_(t,e);if(i.reference!=="suffix"&&t.scheme){n.push(t.scheme);n.push(":")}var o=J(t,i);if(o!==undefined){if(i.reference!=="suffix"){n.push("//")}n.push(o);if(t.path&&t.path.charAt(0)!=="/"){n.push("/")}}if(t.path!==undefined){var s=t.path;if(!i.absolutePath&&(!r||!r.absolutePath)){s=ee(s)}if(o===undefined){s=s.replace(/^\/\//,"/%2F")}n.push(s)}if(t.query!==undefined){n.push("?");n.push(t.query)}if(t.fragment!==undefined){n.push("#");n.push(t.fragment)}return n.join("")}function ie(e,t){var i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var n=arguments[3];var r={};if(!n){e=X(te(e,i),i);t=X(te(t,i),i)}i=i||{};if(!i.tolerant&&t.scheme){r.scheme=t.scheme;r.userinfo=t.userinfo;r.host=t.host;r.port=t.port;r.path=ee(t.path||"");r.query=t.query}else{if(t.userinfo!==undefined||t.host!==undefined||t.port!==undefined){r.userinfo=t.userinfo;r.host=t.host;r.port=t.port;r.path=ee(t.path||"");r.query=t.query}else{if(!t.path){r.path=e.path;if(t.query!==undefined){r.query=t.query}else{r.query=e.query}}else{if(t.path.charAt(0)==="/"){r.path=ee(t.path)}else{if((e.userinfo!==undefined||e.host!==undefined||e.port!==undefined)&&!e.path){r.path="/"+t.path}else if(!e.path){r.path=t.path}else{r.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path}r.path=ee(r.path)}r.query=t.query}r.userinfo=e.userinfo;r.host=e.host;r.port=e.port}r.scheme=e.scheme}r.fragment=t.fragment;return r}function ne(e,t,i){var n=r({scheme:"null"},i);return te(ie(X(e,n),X(t,n),n,true),n)}function re(e,t){if(typeof e==="string"){e=te(X(e,t),t)}else if(n(e)==="object"){e=X(te(e,t),t)}return e}function oe(e,t,i){if(typeof e==="string"){e=te(X(e,i),i)}else if(n(e)==="object"){e=te(e,i)}if(typeof t==="string"){t=te(X(t,i),i)}else if(n(t)==="object"){t=te(t,i)}return e===t}function se(e,t){return e&&e.toString().replace(!t||!t.iri?a.ESCAPE:l.ESCAPE,E)}function ae(e,t){return e&&e.toString().replace(!t||!t.iri?a.PCT_ENCODED:l.PCT_ENCODED,R)}var le={scheme:"http",domainHost:true,parse:function e(t,i){if(!t.host){t.error=t.error||"HTTP URIs must have a host."}return t},serialize:function e(t,i){if(t.port===(String(t.scheme).toLowerCase()!=="https"?80:443)||t.port===""){t.port=undefined}if(!t.path){t.path="/"}return t}},ce={scheme:"https",domainHost:le.domainHost,parse:le.parse,serialize:le.serialize},ue={},ge,pe="[A-Za-z0-9\\-\\.\\_\\~"+(true?"\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF":"")+"]",me="[0-9A-Fa-f]",fe=de(de("%[EFef]"+me+"%"+me+me+"%"+me+me)+"|"+de("%[89A-Fa-f]"+me+"%"+me+me)+"|"+de("%"+me+me)),Ce="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",ve,Ie=he("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),Ae="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",be=new RegExp(pe,"g"),ye=new RegExp(fe,"g"),we=new RegExp(he("[^]",Ce,"[\\.]",'[\\"]',Ie),"g"),Se=new RegExp(he("[^]",pe,Ae),"g"),xe=Se;function ke(e){var t=R(e);return!t.match(be)?e:t}var Ee={scheme:"mailto",parse:function e(t,i){var n=t;var r=n.to=n.path?n.path.split(","):[];n.path=undefined;if(n.query){var o=false;var s={};var a=n.query.split("&");for(var l=0,c=a.length;l<c;++l){var h=a[l].split("=");switch(h[0]){case"to":var d=h[1].split(",");for(var u=0,g=d.length;u<g;++u){r.push(d[u])}break;case"subject":n.subject=ae(h[1],i);break;case"body":n.body=ae(h[1],i);break;default:o=true;s[ae(h[0],i)]=ae(h[1],i);break}}if(o)n.headers=s}n.query=undefined;for(var p=0,m=r.length;p<m;++p){var f=r[p].split("@");f[0]=ae(f[0]);if(!i.unicodeSupport){try{f[1]=x.toASCII(ae(f[1],i).toLowerCase())}catch(e){n.error=n.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}}else{f[1]=ae(f[1],i).toLowerCase()}r[p]=f.join("@")}return n},serialize:function e(t,i){var n=t;var r=m(t.to);if(r){for(var o=0,s=r.length;o<s;++o){var a=String(r[o]);var l=a.lastIndexOf("@");var c=a.slice(0,l).replace(ye,ke).replace(ye,p).replace(we,E);var h=a.slice(l+1);try{h=!i.iri?x.toASCII(ae(h,i).toLowerCase()):x.toUnicode(h)}catch(e){n.error=n.error||"Email address's domain name can not be converted to "+(!i.iri?"ASCII":"Unicode")+" via punycode: "+e}r[o]=c+"@"+h}n.path=r.join(",")}var d=t.headers=t.headers||{};if(t.subject)d["subject"]=t.subject;if(t.body)d["body"]=t.body;var u=[];for(var g in d){if(d[g]!==ue[g]){u.push(g.replace(ye,ke).replace(ye,p).replace(Se,E)+"="+d[g].replace(ye,ke).replace(ye,p).replace(xe,E))}}if(u.length){n.query=u.join("&")}return n}},Re=/^([^\:]+)\:(.*)/,_e={scheme:"urn",parse:function e(t,i){var n=t.path&&t.path.match(Re);var r=t;if(n){var o=i.scheme||r.scheme||"urn";var s=n[1].toLowerCase();var a=n[2];var l=o+":"+(i.nid||s);var c=k[l];r.nid=s;r.nss=a;r.path=undefined;if(c){r=c.parse(r,i)}}else{r.error=r.error||"URN can not be parsed."}return r},serialize:function e(t,i){var n=i.scheme||t.scheme||"urn";var r=t.nid;var o=n+":"+(i.nid||r);var s=k[o];if(s){t=s.serialize(t,i)}var a=t;var l=t.nss;a.path=(r||i.nid)+":"+l;return a}},Te=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,$e={scheme:"urn:uuid",parse:function e(t,i){var n=t;n.uuid=n.nss;n.nss=undefined;if(!i.tolerant&&(!n.uuid||!n.uuid.match(Te))){n.error=n.error||"UUID is not valid."}return n},serialize:function e(t,i){var n=t;n.nss=(t.uuid||"").toLowerCase();return n}};k[le.scheme]=le,k[ce.scheme]=ce,k[Ee.scheme]=Ee,k[_e.scheme]=_e,k[$e.scheme]=$e,e.SCHEMES=k,e.pctEncChar=E,e.pctDecChars=R,e.parse=X,e.removeDotSegments=ee,e.serialize=te,e.resolveComponents=ie,e.resolve=ne,e.normalize=re,e.equal=oe,e.escapeComponent=se,e.unescapeComponent=ae,Object.defineProperty(e,"__esModule",{value:true})}(t)},function(e,t,i){"use strict";e.exports=function(e){for(var t,i=0,n=e.length,r=0;r<n;)i++,55296<=(t=e.charCodeAt(r++))&&t<=56319&&r<n&&56320==(64512&(t=e.charCodeAt(r)))&&r++;return i}},function(e,t,i){"use strict";var m=e.exports=function(e,t,i){"function"==typeof t&&(i=t,t={}),function e(t,i,n,r,o,s,a,l,c,h){if(r&&"object"==typeof r&&!Array.isArray(r)){for(var d in i(r,o,s,a,l,c,h),r){var u=r[d];if(Array.isArray(u)){if(d in m.arrayKeywords)for(var g=0;g<u.length;g++)e(t,i,n,u[g],o+"/"+d+"/"+g,s,o,d,r,g)}else if(d in m.propsKeywords){if(u&&"object"==typeof u)for(var p in u)e(t,i,n,u[p],o+"/"+d+"/"+p.replace(/~/g,"~0").replace(/\//g,"~1"),s,o,d,r,p)}else(d in m.keywords||t.allKeys&&!(d in m.skipKeywords))&&e(t,i,n,u,o+"/"+d,s,o,d,r)}n(r,o,s,a,l,c,h)}}(t,"function"==typeof(i=t.cb||i)?i:i.pre||function(){},i.post||function(){},e,"",e)};m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},function(e,t,i){"use strict";var n=e.exports=function(){this._cache={}};n.prototype.put=function(e,t){this._cache[e]=t},n.prototype.get=function(e){return this._cache[e]},n.prototype.del=function(e){delete this._cache[e]},n.prototype.clear=function(){this._cache={}}},function(e,t,i){"use strict";var n=i(7),s=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,a=[0,31,28,31,30,31,30,31,31,30,31,30,31],l=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,r=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,o=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,c=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,h=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,d=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,u=/^(?:\/(?:[^~/]|~0|~1)*)*$/,g=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,p=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function m(e){return e="full"==e?"full":"fast",n.copy(m[e])}function f(e){var t=e.match(s);if(!t)return!1;var i,n=+t[1],r=+t[2],o=+t[3];return 1<=r&&r<=12&&1<=o&&o<=(2!=r||((i=n)%4!=0||i%100==0&&i%400!=0)?a[r]:29)}function C(e,t){var i=e.match(l);if(!i)return!1;var n=i[1],r=i[2],o=i[3],s=i[5];return(n<=23&&r<=59&&o<=59||23==n&&59==r&&60==o)&&(!t||s)}(e.exports=m).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:r,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:b,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":g,"relative-json-pointer":p},m.full={date:f,time:C,"date-time":function(e){var t=e.split(v);return 2==t.length&&f(t[0])&&C(t[1],!0)},uri:function(e){return I.test(e)&&o.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:r,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:b,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":g,"relative-json-pointer":p};var v=/t|\s/i;var I=/\/|:/;var A=/[^\\]\\Z/;function b(e){if(A.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},function(e,t,i){"use strict";var o=i(52),s=i(7).toHash;e.exports=function(){var n=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],r=["type","$comment"];return n.all=s(r),n.types=s(["number","integer","string","array","object","boolean","null"]),n.forEach(function(e){e.rules=e.rules.map(function(e){var t,i;return"object"==typeof e&&(i=e[t=Object.keys(e)[0]],e=t,i.forEach(function(e){r.push(e),n.all[e]=!0})),r.push(e),n.all[e]={keyword:e,code:o[e],implements:i}}),n.all.$comment={keyword:"$comment",code:o.$comment},e.type&&(n.types[e.type]=e)}),n.keywords=s(r.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),n.custom={},n}},function(e,t,i){"use strict";e.exports={$ref:i(53),allOf:i(54),anyOf:i(55),$comment:i(56),const:i(57),contains:i(58),dependencies:i(59),enum:i(60),format:i(61),if:i(62),items:i(63),maximum:i(28),minimum:i(28),maxItems:i(29),minItems:i(29),maxLength:i(30),minLength:i(30),maxProperties:i(31),minProperties:i(31),multipleOf:i(64),not:i(65),oneOf:i(66),pattern:i(67),properties:i(68),propertyNames:i(69),required:i(70),uniqueItems:i(71),validate:i(27)}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(s||""),d="valid"+o;if("#"==a||"#/"==a)n=e.isRoot?(i=e.async,"validate"):(i=!0===e.root.schema.$async,"root.refVal[0]");else{var u,g,p=e.resolveRef(e.baseId,a,e.isRoot);if(void 0===p){var m,f=e.MissingRefError.message(e.baseId,a);if("fail"==e.opts.missingRefs){e.logger.error(f),(m=m||[]).push(r),r="",!1!==e.createErrors?(r+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { ref: '"+e.util.escapeQuotes(a)+"' } ",!1!==e.opts.messages&&(r+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(a)+"' "),e.opts.verbose&&(r+=" , schema: "+e.util.toQuotedString(a)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),r+=" } "):r+=" {} ";var C=r,r=m.pop();!e.compositeRule&&c?e.async?r+=" throw new ValidationError(["+C+"]); ":r+=" validate.errors = ["+C+"]; return false; ":r+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c&&(r+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,a,f);e.logger.warn(f),c&&(r+=" if (true) { ")}}else{p.inline?((u=e.util.copy(e)).level++,g="valid"+u.level,u.schema=p.schema,u.schemaPath="",u.errSchemaPath=a,r+=" "+e.validate(u).replace(/validate\.schema/g,p.code)+" ",c&&(r+=" if ("+g+") { ")):(i=!0===p.$async||e.async&&!1!==p.$async,n=p.code)}}if(n){(m=m||[]).push(r),r="",e.opts.passContext?r+=" "+n+".call(this, ":r+=" "+n+"( ",r+=" "+h+", (dataPath || '')",'""'!=e.errorPath&&(r+=" + "+e.errorPath);var v=r+=" , "+(s?"data"+(s-1||""):"parentData")+" , "+(s?e.dataPathArr[s]:"parentDataProperty")+", rootData)  ";if(r=m.pop(),i){if(!e.async)throw new Error("async schema referenced by sync schema");c&&(r+=" var "+d+"; "),r+=" try { await "+v+"; ",c&&(r+=" "+d+" = true; "),r+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",c&&(r+=" "+d+" = false; "),r+=" } ",c&&(r+=" if ("+d+") { ")}else r+=" if (!"+v+") { if (vErrors === null) vErrors = "+n+".errors; else vErrors = vErrors.concat("+n+".errors); errors = vErrors.length; } ",c&&(r+=" else { ")}return r}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.schema[t],r=e.schemaPath+e.util.getProperty(t),o=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a=e.util.copy(e),l="";a.level++;var c="valid"+a.level,h=a.baseId,d=!0,u=n;if(u)for(var g,p=-1,m=u.length-1;p<m;)g=u[p+=1],(e.opts.strictKeywords?"object"==typeof g&&0<Object.keys(g).length:e.util.schemaHasRules(g,e.RULES.all))&&(d=!1,a.schema=g,a.schemaPath=r+"["+p+"]",a.errSchemaPath=o+"/"+p,i+="  "+e.validate(a)+" ",a.baseId=h,s&&(i+=" if ("+c+") { ",l+="}"));return s&&(i+=d?" if (true) { ":" "+l.slice(0,-1)+" "),i}},function(e,t,i){"use strict";e.exports=function(t,e){var i=" ",n=t.level,r=t.dataLevel,o=t.schema[e],s=t.schemaPath+t.util.getProperty(e),a=t.errSchemaPath+"/"+e,l=!t.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=t.util.copy(t),g="";u.level++;var p="valid"+u.level;if(o.every(function(e){return t.opts.strictKeywords?"object"==typeof e&&0<Object.keys(e).length:t.util.schemaHasRules(e,t.RULES.all)})){var m=u.baseId;i+=" var "+d+" = errors; var "+h+" = false;  ";var f=t.compositeRule;t.compositeRule=u.compositeRule=!0;var C=o;if(C)for(var v,I=-1,A=C.length-1;I<A;)v=C[I+=1],u.schema=v,u.schemaPath=s+"["+I+"]",u.errSchemaPath=a+"/"+I,i+="  "+t.validate(u)+" ",u.baseId=m,i+=" "+h+" = "+h+" || "+p+"; if (!"+h+") { ",g+="}";t.compositeRule=u.compositeRule=f,i+=" "+g+" if (!"+h+") {   var err =   ",!1!==t.createErrors?(i+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+t.errorPath+" , schemaPath: "+t.util.toQuotedString(a)+" , params: {} ",!1!==t.opts.messages&&(i+=" , message: 'should match some schema in anyOf' "),t.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+t.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!t.compositeRule&&l&&(t.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" } else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } ",t.opts.allErrors&&(i+=" } ")}else l&&(i+=" if (true) { ");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.schema[t],r=e.errSchemaPath+"/"+t,o=(e.opts.allErrors,e.util.toQuotedString(n));return!0===e.opts.$comment?i+=" console.log("+o+");":"function"==typeof e.opts.$comment&&(i+=" self._opts.$comment("+o+", "+e.util.toQuotedString(r)+", validate.root.schema);"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data;d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ");d||(i+=" var schema"+n+" = validate.schema"+s+";"),i+="var "+h+" = equal("+c+", schema"+n+"); if (!"+h+") {   ";var u=u||[];u.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { allowedValue: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to constant' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var g=i,i=u.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+g+"]); ":i+=" validate.errors = ["+g+"]; return false; ":i+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e);u.level++;var g,p,m,f="valid"+u.level,C="i"+n,v=u.dataLevel=e.dataLevel+1,I="data"+v,A=e.baseId,b=e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all);i+="var "+d+" = errors;var "+h+";",b?(g=e.compositeRule,e.compositeRule=u.compositeRule=!0,u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+=" var "+f+" = false; for (var "+C+" = 0; "+C+" < "+c+".length; "+C+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,C,e.opts.jsonPointers,!0),p=c+"["+C+"]",u.dataPathArr[v]=C,m=e.validate(u),u.baseId=A,e.util.varOccurences(m,I)<2?i+=" "+e.util.varReplace(m,I,p)+" ":i+=" var "+I+" = "+p+"; "+m+" ",i+=" if ("+f+") break; }  ",e.compositeRule=u.compositeRule=g,i+="  if (!"+f+") {"):i+=" if ("+c+".length == 0) {";var y=y||[];y.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should contain a valid item' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var w=i,i=y.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { ",b&&(i+="  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } "),e.opts.allErrors&&(i+=" } "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e),u="";d.level++;var g,p="valid"+d.level,m={},f={},C=e.opts.ownProperties;for(I in o){"__proto__"!=I&&(W=o[I],(g=Array.isArray(W)?f:m)[I]=W)}i+="var "+h+" = errors;";var v=e.errorPath;for(var I in i+="var missing"+n+";",f)if((g=f[I]).length){if(i+=" if ( "+c+e.util.getProperty(I)+" !== undefined ",C&&(i+=" && Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(I)+"') "),l){i+=" && ( ";var A=g;if(A)for(var b=-1,y=A.length-1;b<y;){R=A[b+=1],b&&(i+=" || "),i+=" ( ( "+(L=c+($=e.util.getProperty(R)))+" === undefined ",C&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(R)+"') "),i+=") && (missing"+n+" = "+e.util.toQuotedString(e.opts.jsonPointers?R:$)+") ) "}i+=")) {  ";var w="missing"+n,S="' + "+w+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(v,w,!0):v+" + "+w);var x=x||[];x.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { property: '"+e.util.escapeQuotes(I)+"', missingProperty: '"+S+"', depsCount: "+g.length+", deps: '"+e.util.escapeQuotes(1==g.length?g[0]:g.join(", "))+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should have ",1==g.length?i+="property "+e.util.escapeQuotes(g[0]):i+="properties "+e.util.escapeQuotes(g.join(", ")),i+=" when property "+e.util.escapeQuotes(I)+" is present' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var k=i,i=x.pop();!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+k+"]); ":i+=" validate.errors = ["+k+"]; return false; ":i+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{i+=" ) { ";var E=g;if(E)for(var R,_=-1,T=E.length-1;_<T;){R=E[_+=1];var $=e.util.getProperty(R),S=e.util.escapeQuotes(R),L=c+$;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(v,R,e.opts.jsonPointers)),i+=" if ( "+L+" === undefined ",C&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(R)+"') "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { property: '"+e.util.escapeQuotes(I)+"', missingProperty: '"+S+"', depsCount: "+g.length+", deps: '"+e.util.escapeQuotes(1==g.length?g[0]:g.join(", "))+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should have ",1==g.length?i+="property "+e.util.escapeQuotes(g[0]):i+="properties "+e.util.escapeQuotes(g.join(", ")),i+=" when property "+e.util.escapeQuotes(I)+" is present' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}i+=" }   ",l&&(u+="}",i+=" else { ")}e.errorPath=v;var B=d.baseId;for(var I in m){var W=m[I];(e.opts.strictKeywords?"object"==typeof W&&0<Object.keys(W).length:e.util.schemaHasRules(W,e.RULES.all))&&(i+=" "+p+" = true; if ( "+c+e.util.getProperty(I)+" !== undefined ",C&&(i+=" && Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(I)+"') "),i+=") { ",d.schema=W,d.schemaPath=s+e.util.getProperty(I),d.errSchemaPath=a+"/"+e.util.escapeFragment(I),i+="  "+e.validate(d)+" ",d.baseId=B,i+=" }  ",l&&(i+=" if ("+p+") { ",u+="}"))}return l&&(i+="   "+u+" if ("+h+" == errors) {"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data,u=(d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; "),"i"+n),g="schema"+n;d||(i+=" var "+g+" = validate.schema"+s+";"),i+="var "+h+";",d&&(i+=" if (schema"+n+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+n+")) "+h+" = false; else {"),i+=h+" = false;for (var "+u+"=0; "+u+"<"+g+".length; "+u+"++) if (equal("+c+", "+g+"["+u+"])) { "+h+" = true; break; }",d&&(i+="  }  "),i+=" if (!"+h+") {   ";var p=p||[];p.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { allowedValues: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var m=i,i=p.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+m+"]); ":i+=" validate.errors = ["+m+"]; return false; ":i+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||"");if(!1===e.opts.format)return c&&(n+=" if (true) { "),n;var d,u=e.opts.$data&&s&&s.$data,g=u?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s,p=e.opts.unknownFormats,m=Array.isArray(p);if(u){n+=" var "+(d="format"+r)+" = formats["+g+"]; var "+(f="isObject"+r)+" = typeof "+d+" == 'object' && !("+d+" instanceof RegExp) && "+d+".validate; var "+(v="formatType"+r)+" = "+f+" && "+d+".type || 'string'; if ("+f+") { ",e.async&&(n+=" var async"+r+" = "+d+".async; "),n+=" "+d+" = "+d+".validate; } if (  ",u&&(n+=" ("+g+" !== undefined && typeof "+g+" != 'string') || "),n+=" (","ignore"!=p&&(n+=" ("+g+" && !"+d+" ",m&&(n+=" && self._opts.unknownFormats.indexOf("+g+") == -1 "),n+=") || "),n+=" ("+d+" && "+v+" == '"+i+"' && !(typeof "+d+" == 'function' ? ",e.async?n+=" (async"+r+" ? await "+d+"("+h+") : "+d+"("+h+")) ":n+=" "+d+"("+h+") ",n+=" : "+d+".test("+h+"))))) {"}else{if(!(d=e.formats[s])){if("ignore"==p)return e.logger.warn('unknown format "'+s+'" ignored in schema at path "'+e.errSchemaPath+'"'),c&&(n+=" if (true) { "),n;if(m&&0<=p.indexOf(s))return c&&(n+=" if (true) { "),n;throw new Error('unknown format "'+s+'" is used in schema at path "'+e.errSchemaPath+'"')}var f,C,v=(f="object"==typeof d&&!(d instanceof RegExp)&&d.validate)&&d.type||"string";if(f&&(C=!0===d.async,d=d.validate),v!=i)return c&&(n+=" if (true) { "),n;if(C){if(!e.async)throw new Error("async format in sync schema");n+=" if (!(await "+(I="formats"+e.util.getProperty(s)+".validate")+"("+h+"))) { "}else{n+=" if (! ";var I="formats"+e.util.getProperty(s);f&&(I+=".validate"),n+="function"==typeof d?" "+I+"("+h+") ":" "+I+".test("+h+") ",n+=") { "}}var A=A||[];A.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { format:  ",n+=u?""+g:""+e.util.toQuotedString(s),n+="  } ",!1!==e.opts.messages&&(n+=" , message: 'should match format \"",n+=u?"' + "+g+" + '":""+e.util.escapeQuotes(s),n+="\"' "),e.opts.verbose&&(n+=" , schema:  ",n+=u?"validate.schema"+a:""+e.util.toQuotedString(s),n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var b=n,n=A.pop();return!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+b+"]); ":n+=" validate.errors = ["+b+"]; return false; ":n+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e);u.level++;var g,p,m="valid"+u.level,f=e.schema.then,C=e.schema.else,v=void 0!==f&&(e.opts.strictKeywords?"object"==typeof f&&0<Object.keys(f).length:e.util.schemaHasRules(f,e.RULES.all)),I=void 0!==C&&(e.opts.strictKeywords?"object"==typeof C&&0<Object.keys(C).length:e.util.schemaHasRules(C,e.RULES.all)),A=u.baseId;return v||I?(u.createErrors=!1,u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+=" var "+d+" = errors; var "+h+" = true;  ",p=e.compositeRule,e.compositeRule=u.compositeRule=!0,i+="  "+e.validate(u)+" ",u.baseId=A,u.createErrors=!0,i+="  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; }  ",e.compositeRule=u.compositeRule=p,v?(i+=" if ("+m+") {  ",u.schema=e.schema.then,u.schemaPath=e.schemaPath+".then",u.errSchemaPath=e.errSchemaPath+"/then",i+="  "+e.validate(u)+" ",u.baseId=A,i+=" "+h+" = "+m+"; ",v&&I?i+=" var "+(g="ifClause"+n)+" = 'then'; ":g="'then'",i+=" } ",I&&(i+=" else { ")):i+=" if (!"+m+") { ",I&&(u.schema=e.schema.else,u.schemaPath=e.schemaPath+".else",u.errSchemaPath=e.errSchemaPath+"/else",i+="  "+e.validate(u)+" ",u.baseId=A,i+=" "+h+" = "+m+"; ",v&&I?i+=" var "+(g="ifClause"+n)+" = 'else'; ":g="'else'",i+=" } "),i+=" if (!"+h+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { failingKeyword: "+g+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match \"' + "+g+" + '\" schema' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" }   ",l&&(i+=" else { ")):l&&(i+=" if (true) { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e),g="";u.level++;var p="valid"+u.level,m="i"+n,f=u.dataLevel=e.dataLevel+1,C="data"+f,v=e.baseId;if(i+="var "+d+" = errors;var "+h+";",Array.isArray(o)){var I,A,b,y=e.schema.additionalItems;!1===y&&(i+=" "+h+" = "+c+".length <= "+o.length+"; ",I=a,a=e.errSchemaPath+"/additionalItems",(A=A||[]).push(i+="  if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { limit: "+o.length+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have more than "+o.length+" items' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",b=i,i=A.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+b+"]); ":i+=" validate.errors = ["+b+"]; return false; ":i+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } ",a=I,l&&(g+="}",i+=" else { "));var w=o;if(w)for(var S=-1,x=w.length-1;S<x;){var k,E,R=w[S+=1];(e.opts.strictKeywords?"object"==typeof R&&0<Object.keys(R).length:e.util.schemaHasRules(R,e.RULES.all))&&(i+=" "+p+" = true; if ("+c+".length > "+S+") { ",k=c+"["+S+"]",u.schema=R,u.schemaPath=s+"["+S+"]",u.errSchemaPath=a+"/"+S,u.errorPath=e.util.getPathExpr(e.errorPath,S,e.opts.jsonPointers,!0),u.dataPathArr[f]=S,E=e.validate(u),u.baseId=v,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,k)+" ":i+=" var "+C+" = "+k+"; "+E+" ",i+=" }  ",l&&(i+=" if ("+p+") { ",g+="}"))}"object"==typeof y&&(e.opts.strictKeywords?"object"==typeof y&&0<Object.keys(y).length:e.util.schemaHasRules(y,e.RULES.all))&&(u.schema=y,u.schemaPath=e.schemaPath+".additionalItems",u.errSchemaPath=e.errSchemaPath+"/additionalItems",i+=" "+p+" = true; if ("+c+".length > "+o.length+") {  for (var "+m+" = "+o.length+"; "+m+" < "+c+".length; "+m+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0),k=c+"["+m+"]",u.dataPathArr[f]=m,E=e.validate(u),u.baseId=v,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,k)+" ":i+=" var "+C+" = "+k+"; "+E+" ",l&&(i+=" if (!"+p+") break; "),i+=" } }  ",l&&(i+=" if ("+p+") { ",g+="}"))}else{(e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all))&&(u.schema=o,u.schemaPath=s,u.errSchemaPath=a,i+="  for (var "+m+" = 0; "+m+" < "+c+".length; "+m+"++) { ",u.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0),k=c+"["+m+"]",u.dataPathArr[f]=m,E=e.validate(u),u.baseId=v,e.util.varOccurences(E,C)<2?i+=" "+e.util.varReplace(E,C,k)+" ":i+=" var "+C+" = "+k+"; "+E+" ",l&&(i+=" if (!"+p+") break; "),i+=" }")}return l&&(i+=" "+g+" if ("+d+" == errors) {"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&o&&o.$data,d=h?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!h&&"number"!=typeof o)throw new Error(t+" must be number");i+="var division"+n+";if (",h&&(i+=" "+d+" !== undefined && ( typeof "+d+" != 'number' || "),i+=" (division"+n+" = "+c+" / "+d+", ",e.opts.multipleOfPrecision?i+=" Math.abs(Math.round(division"+n+") - division"+n+") > 1e-"+e.opts.multipleOfPrecision+" ":i+=" division"+n+" !== parseInt(division"+n+") ",i+=" ) ",h&&(i+="  )  "),i+=" ) {   ";var u=u||[];u.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { multipleOf: "+d+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be multiple of ",i+=h?"' + "+d:d+"'"),e.opts.verbose&&(i+=" , schema:  ",i+=h?"validate.schema"+s:""+o,i+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var g=i,i=u.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+g+"]); ":i+=" validate.errors = ["+g+"]; return false; ":i+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e);d.level++;var u,g,p,m,f="valid"+d.level;return(e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all))?(d.schema=o,d.schemaPath=s,d.errSchemaPath=a,i+=" var "+h+" = errors;  ",u=e.compositeRule,e.compositeRule=d.compositeRule=!0,d.createErrors=!1,d.opts.allErrors&&(g=d.opts.allErrors,d.opts.allErrors=!1),i+=" "+e.validate(d)+" ",d.createErrors=!0,g&&(d.opts.allErrors=g),e.compositeRule=d.compositeRule=u,(p=p||[]).push(i+=" if ("+f+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should NOT be valid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",m=i,i=p.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+m+"]); ":i+=" validate.errors = ["+m+"]; return false; ":i+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else {  errors = "+h+"; if (vErrors !== null) { if ("+h+") vErrors.length = "+h+"; else vErrors = null; } ",e.opts.allErrors&&(i+=" } ")):(i+="  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should NOT be valid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l&&(i+=" if (false) { ")),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d="errs__"+n,u=e.util.copy(e),g="";u.level++;var p="valid"+u.level,m=u.baseId,f="prevValid"+n,C="passingSchemas"+n;i+="var "+d+" = errors , "+f+" = false , "+h+" = false , "+C+" = null; ";var v=e.compositeRule;e.compositeRule=u.compositeRule=!0;var I=o;if(I)for(var A,b=-1,y=I.length-1;b<y;)A=I[b+=1],(e.opts.strictKeywords?"object"==typeof A&&0<Object.keys(A).length:e.util.schemaHasRules(A,e.RULES.all))?(u.schema=A,u.schemaPath=s+"["+b+"]",u.errSchemaPath=a+"/"+b,i+="  "+e.validate(u)+" ",u.baseId=m):i+=" var "+p+" = true; ",b&&(i+=" if ("+p+" && "+f+") { "+h+" = false; "+C+" = ["+C+", "+b+"]; } else { ",g+="}"),i+=" if ("+p+") { "+h+" = "+f+" = true; "+C+" = "+b+"; }";return e.compositeRule=u.compositeRule=v,i+=g+"if (!"+h+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { passingSchemas: "+C+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+="} else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; }",e.opts.allErrors&&(i+=" } "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h=e.opts.$data&&o&&o.$data,d=h?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;i+="if ( ",h&&(i+=" ("+d+" !== undefined && typeof "+d+" != 'string') || "),i+=" !"+(h?"(new RegExp("+d+"))":e.usePattern(o))+".test("+c+") ) {   ";var u=u||[];u.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { pattern:  ",i+=h?""+d:""+e.util.toQuotedString(o),i+="  } ",!1!==e.opts.messages&&(i+=" , message: 'should match pattern \"",i+=h?"' + "+d+" + '":""+e.util.escapeQuotes(o),i+="\"' "),e.opts.verbose&&(i+=" , schema:  ",i+=h?"validate.schema"+s:""+e.util.toQuotedString(o),i+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var g=i,i=u.pop();return!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+g+"]); ":i+=" validate.errors = ["+g+"]; return false; ":i+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",l&&(i+=" else { "),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e),u="";d.level++;var g,p,m,f="valid"+d.level,C="key"+n,v="idx"+n,I=d.dataLevel=e.dataLevel+1,A="data"+I,b="dataProperties"+n,y=Object.keys(o||{}).filter(W),w=e.schema.patternProperties||{},S=Object.keys(w).filter(W),x=e.schema.additionalProperties,k=y.length||S.length,E=!1===x,R="object"==typeof x&&Object.keys(x).length,_=e.opts.removeAdditional,T=E||R||_,$=e.opts.ownProperties,L=e.baseId,B=e.schema.required;function W(e){return"__proto__"!==e}if(B&&(!e.opts.$data||!B.$data)&&B.length<e.opts.loopRequired&&(g=e.util.toHash(B)),i+="var "+h+" = errors;var "+f+" = true;",$&&(i+=" var "+b+" = undefined;"),T){if(i+=$?" "+b+" = "+b+" || Object.keys("+c+"); for (var "+v+"=0; "+v+"<"+b+".length; "+v+"++) { var "+C+" = "+b+"["+v+"]; ":" for (var "+C+" in "+c+") { ",k){if(i+=" var isAdditional"+n+" = !(false ",y.length)if(8<y.length)i+=" || validate.schema"+s+".hasOwnProperty("+C+") ";else{var O=y;if(O)for(var N=-1,G=O.length-1;N<G;)M=O[N+=1],i+=" || "+C+" == "+e.util.toQuotedString(M)+" "}if(S.length){var H=S;if(H)for(var P=-1,V=H.length-1;P<V;)ie=H[P+=1],i+=" || "+e.usePattern(ie)+".test("+C+") "}i+=" ); if (isAdditional"+n+") { "}"all"==_?i+=" delete "+c+"["+C+"]; ":(J=e.errorPath,p="' + "+C+" + '",e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,C,e.opts.jsonPointers)),E?_?i+=" delete "+c+"["+C+"]; ":(i+=" "+f+" = false; ",Y=a,a=e.errSchemaPath+"/additionalProperties",(Q=Q||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { additionalProperty: '"+p+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is an invalid additional property":i+="should NOT have additional properties",i+="' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",q=i,i=Q.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+q+"]); ":i+=" validate.errors = ["+q+"]; return false; ":i+=" var err = "+q+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=Y,l&&(i+=" break; ")):R&&("failing"==_?(i+=" var "+h+" = errors;  ",m=e.compositeRule,e.compositeRule=d.compositeRule=!0,d.schema=x,d.schemaPath=e.schemaPath+".additionalProperties",d.errSchemaPath=e.errSchemaPath+"/additionalProperties",d.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,C,e.opts.jsonPointers),oe=c+"["+C+"]",d.dataPathArr[I]=C,se=e.validate(d),d.baseId=L,e.util.varOccurences(se,A)<2?i+=" "+e.util.varReplace(se,A,oe)+" ":i+=" var "+A+" = "+oe+"; "+se+" ",i+=" if (!"+f+") { errors = "+h+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+c+"["+C+"]; }  ",e.compositeRule=d.compositeRule=m):(d.schema=x,d.schemaPath=e.schemaPath+".additionalProperties",d.errSchemaPath=e.errSchemaPath+"/additionalProperties",d.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,C,e.opts.jsonPointers),oe=c+"["+C+"]",d.dataPathArr[I]=C,se=e.validate(d),d.baseId=L,e.util.varOccurences(se,A)<2?i+=" "+e.util.varReplace(se,A,oe)+" ":i+=" var "+A+" = "+oe+"; "+se+" ",l&&(i+=" if (!"+f+") break; "))),e.errorPath=J),k&&(i+=" } "),i+=" }  ",l&&(i+=" if ("+f+") { ",u+="}")}var F=e.opts.useDefaults&&!e.compositeRule;if(y.length){var Z=y;if(Z)for(var M,j=-1,D=Z.length-1;j<D;){var K,z,X,J,Y,U,Q,q,ee=o[M=Z[j+=1]];(e.opts.strictKeywords?"object"==typeof ee&&0<Object.keys(ee).length:e.util.schemaHasRules(ee,e.RULES.all))&&(oe=c+(K=e.util.getProperty(M)),z=F&&void 0!==ee.default,d.schema=ee,d.schemaPath=s+K,d.errSchemaPath=a+"/"+e.util.escapeFragment(M),d.errorPath=e.util.getPath(e.errorPath,M,e.opts.jsonPointers),d.dataPathArr[I]=e.util.toQuotedString(M),se=e.validate(d),d.baseId=L,e.util.varOccurences(se,A)<2?(se=e.util.varReplace(se,A,oe),X=oe):i+=" var "+(X=A)+" = "+oe+"; ",z?i+=" "+se+" ":(g&&g[M]?(i+=" if ( "+X+" === undefined ",$&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(M)+"') "),i+=") { "+f+" = false; ",J=e.errorPath,Y=a,U=e.util.escapeQuotes(M),e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(J,M,e.opts.jsonPointers)),a=e.errSchemaPath+"/required",(Q=Q||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+U+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+U+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",q=i,i=Q.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+q+"]); ":i+=" validate.errors = ["+q+"]; return false; ":i+=" var err = "+q+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=Y,e.errorPath=J,i+=" } else { "):l?(i+=" if ( "+X+" === undefined ",$&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(M)+"') "),i+=") { "+f+" = true; } else { "):(i+=" if ("+X+" !== undefined ",$&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(M)+"') "),i+=" ) { "),i+=" "+se+" } ")),l&&(i+=" if ("+f+") { ",u+="}")}}if(S.length){var te=S;if(te)for(var ie,ne=-1,re=te.length-1;ne<re;){var oe,se,ee=w[ie=te[ne+=1]];(e.opts.strictKeywords?"object"==typeof ee&&0<Object.keys(ee).length:e.util.schemaHasRules(ee,e.RULES.all))&&(d.schema=ee,d.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(ie),d.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(ie),i+=$?" "+b+" = "+b+" || Object.keys("+c+"); for (var "+v+"=0; "+v+"<"+b+".length; "+v+"++) { var "+C+" = "+b+"["+v+"]; ":" for (var "+C+" in "+c+") { ",i+=" if ("+e.usePattern(ie)+".test("+C+")) { ",d.errorPath=e.util.getPathExpr(e.errorPath,C,e.opts.jsonPointers),oe=c+"["+C+"]",d.dataPathArr[I]=C,se=e.validate(d),d.baseId=L,e.util.varOccurences(se,A
)<2?i+=" "+e.util.varReplace(se,A,oe)+" ":i+=" var "+A+" = "+oe+"; "+se+" ",l&&(i+=" if (!"+f+") break; "),i+=" } ",l&&(i+=" else "+f+" = true; "),i+=" }  ",l&&(i+=" if ("+f+") { ",u+="}"))}}return l&&(i+=" "+u+" if ("+h+" == errors) {"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="errs__"+n,d=e.util.copy(e);d.level++;var u,g,p,m,f,C,v,I,A,b,y,w="valid"+d.level;return i+="var "+h+" = errors;",(e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length:e.util.schemaHasRules(o,e.RULES.all))&&(d.schema=o,d.schemaPath=s,d.errSchemaPath=a,g="idx"+n,p="i"+n,m="' + "+(u="key"+n)+" + '",f="data"+(d.dataLevel=e.dataLevel+1),C="dataProperties"+n,v=e.opts.ownProperties,I=e.baseId,v&&(i+=" var "+C+" = undefined; "),i+=v?" "+C+" = "+C+" || Object.keys("+c+"); for (var "+g+"=0; "+g+"<"+C+".length; "+g+"++) { var "+u+" = "+C+"["+g+"]; ":" for (var "+u+" in "+c+") { ",i+=" var startErrs"+n+" = errors; ",A=u,b=e.compositeRule,e.compositeRule=d.compositeRule=!0,y=e.validate(d),d.baseId=I,e.util.varOccurences(y,f)<2?i+=" "+e.util.varReplace(y,f,A)+" ":i+=" var "+f+" = "+A+"; "+y+" ",e.compositeRule=d.compositeRule=b,i+=" if (!"+w+") { for (var "+p+"=startErrs"+n+"; "+p+"<errors; "+p+"++) { vErrors["+p+"].propertyName = "+u+"; }   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { propertyName: '"+m+"' } ",!1!==e.opts.messages&&(i+=" , message: 'property name \\'"+m+"\\' is invalid' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),l&&(i+=" break; "),i+=" } }"),l&&(i+="  if ("+h+" == errors) {"),i}},function(e,t,i){"use strict";e.exports=function(e,t){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),a=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,c="data"+(r||""),h="valid"+n,d=e.opts.$data&&o&&o.$data,u=(d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; "),"schema"+n);if(!d)if(o.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var g=[],p=o;if(p)for(var m,f=-1,C=p.length-1;f<C;){m=p[f+=1];var v=e.schema.properties[m];v&&(e.opts.strictKeywords?"object"==typeof v&&0<Object.keys(v).length:e.util.schemaHasRules(v,e.RULES.all))||(g[g.length]=m)}}else g=o;if(d||g.length){var I=e.errorPath,A=d||g.length>=e.opts.loopRequired,b=e.opts.ownProperties;if(l)if(i+=" var missing"+n+"; ",A){d||(i+=" var "+u+" = validate.schema"+s+"; ");var y="' + "+(R="schema"+n+"["+(x="i"+n)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(I,R,e.opts.jsonPointers)),i+=" var "+h+" = true; ",d&&(i+=" if (schema"+n+" === undefined) "+h+" = true; else if (!Array.isArray(schema"+n+")) "+h+" = false; else {"),i+=" for (var "+x+" = 0; "+x+" < "+u+".length; "+x+"++) { "+h+" = "+c+"["+u+"["+x+"]] !== undefined ",b&&(i+=" &&   Object.prototype.hasOwnProperty.call("+c+", "+u+"["+x+"]) "),i+="; if (!"+h+") break; } ",d&&(i+="  }  "),(E=E||[]).push(i+="  if (!"+h+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";var w=i,i=E.pop();!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { "}else{i+=" if ( ";var S=g;if(S)for(var x=-1,k=S.length-1;x<k;){T=S[x+=1],x&&(i+=" || "),i+=" ( ( "+(W=c+(B=e.util.getProperty(T)))+" === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(T)+"') "),i+=") && (missing"+n+" = "+e.util.toQuotedString(e.opts.jsonPointers?T:B)+") ) "}i+=") {  ";var E,y="' + "+(R="missing"+n)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(I,R,!0):I+" + "+R),(E=E||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ";w=i;i=E.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { "}else if(A){d||(i+=" var "+u+" = validate.schema"+s+"; ");var R,y="' + "+(R="schema"+n+"["+(x="i"+n)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(I,R,e.opts.jsonPointers)),d&&(i+=" if ("+u+" && !Array.isArray("+u+")) {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+u+" !== undefined) { "),i+=" for (var "+x+" = 0; "+x+" < "+u+".length; "+x+"++) { if ("+c+"["+u+"["+x+"]] === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", "+u+"["+x+"]) "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",d&&(i+="  }  ")}else{var _=g;if(_)for(var T,$=-1,L=_.length-1;$<L;){T=_[$+=1];var B=e.util.getProperty(T),y=e.util.escapeQuotes(T),W=c+B;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(I,T,e.opts.jsonPointers)),i+=" if ( "+W+" === undefined ",b&&(i+=" || ! Object.prototype.hasOwnProperty.call("+c+", '"+e.util.escapeQuotes(T)+"') "),i+=") {  var err =   ",!1!==e.createErrors?(i+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(a)+" , params: { missingProperty: '"+y+"' } ",!1!==e.opts.messages&&(i+=" , message: '",e.opts._errorDataPathProperty?i+="is a required property":i+="should have required property \\'"+y+"\\'",i+="' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+c+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=I}else l&&(i+=" if (true) {");return i}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r,o,s,a=" ",l=e.level,c=e.dataLevel,h=e.schema[t],d=e.schemaPath+e.util.getProperty(t),u=e.errSchemaPath+"/"+t,g=!e.opts.allErrors,p="data"+(c||""),m="valid"+l,f=e.opts.$data&&h&&h.$data,C=f?(a+=" var schema"+l+" = "+e.util.getData(h.$data,c,e.dataPathArr)+"; ","schema"+l):h;return(h||f)&&!1!==e.opts.uniqueItems?(f&&(a+=" var "+m+"; if ("+C+" === false || "+C+" === undefined) "+m+" = true; else if (typeof "+C+" != 'boolean') "+m+" = false; else { "),a+=" var i = "+p+".length , "+m+" = true , j; if (i > 1) { ",i=e.schema.items&&e.schema.items.type,n=Array.isArray(i),!i||"object"==i||"array"==i||n&&(0<=i.indexOf("object")||0<=i.indexOf("array"))?a+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+p+"[i], "+p+"[j])) { "+m+" = false; break outer; } } } ":(a+=" var itemIndices = {}, item; for (;i--;) { var item = "+p+"[i]; ",r="checkDataType"+(n?"s":""),a+=" if ("+e.util[r](i,"item",e.opts.strictNumbers,!0)+") continue; ",n&&(a+=" if (typeof item == 'string') item = '\"' + item; "),a+=" if (typeof itemIndices[item] == 'number') { "+m+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),a+=" } ",f&&(a+="  }  "),(o=o||[]).push(a+=" if (!"+m+") {   "),a="",!1!==e.createErrors?(a+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(a+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(a+=" , schema:  ",a+=f?"validate.schema"+d:""+h,a+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+p+" "),a+=" } "):a+=" {} ",s=a,a=o.pop(),!e.compositeRule&&g?e.async?a+=" throw new ValidationError(["+s+"]); ":a+=" validate.errors = ["+s+"]; return false; ":a+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a+=" } ",g&&(a+=" else { ")):g&&(a+=" if (true) { "),a}},function(e,t,i){"use strict";var l=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var i=0;i<t.length;i++){e=JSON.parse(JSON.stringify(e));for(var n=t[i].split("/"),r=e,o=1;o<n.length;o++)r=r[n[o]];for(o=0;o<l.length;o++){var s=l[o],a=r[s];a&&(r[s]={anyOf:[a,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return e}},function(e,t,i){"use strict";var n=i(19).MissingRef;function r(t,a,i){var l=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof a&&(i=a,a=void 0);var e=c(t).then(function(){var e=l._addSchema(t,void 0,a);return e.validate||function o(s){try{return l._compile(s)}catch(e){if(e instanceof n)return t(e);throw e}function t(e){var t=e.missingSchema;if(r(t))throw new Error("Schema "+t+" is loaded but "+e.missingRef+" cannot be resolved");var i=l._loadingSchemas[t];return i||(i=l._loadingSchemas[t]=l._opts.loadSchema(t)).then(n,n),i.then(function(e){if(!r(t))return c(e).then(function(){r(t)||l.addSchema(e,t,void 0,a)})}).then(function(){return o(s)});function n(){delete l._loadingSchemas[t]}function r(e){return l._refs[e]||l._schemas[e]}}}(e)});return i&&e.then(function(e){i(null,e)},i),e;function c(e){var t=e.$schema;return t&&!l.getSchema(t)?r.call(l,{$ref:t},!0):Promise.resolve()}}e.exports=r},function(e,t,i){"use strict";var s=/^[a-z_$][a-z0-9_$-]*$/i,l=i(75),n=i(76);function r(e,t){r.errors=null;var i=this._validateKeyword=this._validateKeyword||this.compile(n,!0);if(i(e))return!0;if(r.errors=i.errors,t)throw new Error("custom keyword definition is invalid: "+this.errorsText(i.errors));return!1}e.exports={add:function(e,t){var a=this.RULES;if(a.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!s.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){this.validateKeyword(t,!0);var i=t.type;if(Array.isArray(i))for(var n=0;n<i.length;n++)o(e,i[n],t);else o(e,i,t);var r=t.metaSchema;r&&(t.$data&&this._opts.$data&&(r={anyOf:[r,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),t.validateSchema=this.compile(r,!0))}function o(e,t,i){for(var n,r=0;r<a.length;r++){var o=a[r];if(o.type==t){n=o;break}}n||(n={type:t,rules:[]},a.push(n));var s={keyword:e,definition:i,custom:!0,code:l,implements:i.implements};n.rules.push(s),a.custom[e]=s}return a.keywords[e]=a.all[e]=!0,this},get:function(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1},remove:function(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var i=0;i<t.length;i++)for(var n=t[i].rules,r=0;r<n.length;r++)if(n[r].keyword==e){n.splice(r,1);break}return this},validate:r}},function(e,t,i){"use strict";e.exports=function(e,t){var i,n,r,o,s,a,l=" ",c=e.level,h=e.dataLevel,d=e.schema[t],u=e.schemaPath+e.util.getProperty(t),g=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,m="data"+(h||""),f="valid"+c,C="errs__"+c,v=e.opts.$data&&d&&d.$data,I=v?(l+=" var schema"+c+" = "+e.util.getData(d.$data,h,e.dataPathArr)+"; ","schema"+c):d,A="definition"+c,b=this.definition,y="";if(v&&b.$data){a="keywordValidate"+c;var w=b.validateSchema;l+=" var "+A+" = RULES.custom['"+t+"'].definition; var "+a+" = "+A+".validate;"}else{if(!(s=e.useCustomRule(this,d,e.schema,e)))return;I="validate.schema"+u,a=s.code,n=b.compile,r=b.inline,o=b.macro}var S,x,k,E,R,_,T,$,L,B,W=a+".errors",O="i"+c,N="ruleErr"+c,G=b.async;if(G&&!e.async)throw new Error("async keyword in sync schema");return r||o||(l+=W+" = null;"),l+="var "+C+" = errors;var "+f+";",v&&b.$data&&(y+="}",l+=" if ("+I+" === undefined) { "+f+" = true; } else { ",w&&(y+="}",l+=" "+f+" = "+A+".validateSchema("+I+"); if ("+f+") { ")),r?b.statements?l+=" "+s.validate+" ":l+=" "+f+" = "+s.validate+"; ":o?(y="",(S=e.util.copy(e)).level++,x="valid"+S.level,S.schema=s.validate,S.schemaPath="",k=e.compositeRule,e.compositeRule=S.compositeRule=!0,E=e.validate(S).replace(/validate\.schema/g,a),e.compositeRule=S.compositeRule=k,l+=" "+E):(($=$||[]).push(l),l="",l+="  "+a+".call( ",e.opts.passContext?l+="this":l+="self",n||!1===b.schema?l+=" , "+m+" ":l+=" , "+I+" , "+m+" , validate.schema"+e.schemaPath+" ",l+=" , (dataPath || '')",'""'!=e.errorPath&&(l+=" + "+e.errorPath),T=l+=" , "+(R=h?"data"+(h-1||""):"parentData")+" , "+(_=h?e.dataPathArr[h]:"parentDataProperty")+" , rootData )  ",l=$.pop(),!1===b.errors?(l+=" "+f+" = ",G&&(l+="await "),l+=T+"; "):l+=G?" var "+(W="customErrors"+c)+" = null; try { "+f+" = await "+T+"; } catch (e) { "+f+" = false; if (e instanceof ValidationError) "+W+" = e.errors; else throw e; } ":" "+W+" = null; "+f+" = "+T+"; "),b.modifying&&(l+=" if ("+R+") "+m+" = "+R+"["+_+"];"),l+=""+y,b.valid?p&&(l+=" if (true) { "):(l+=" if ( ",void 0===b.valid?(l+=" !",l+=o?""+x:f):l+=" "+!b.valid+" ",l+=") { ",i=this.keyword,($=$||[]).push(l),($=$||[]).push(l=""),l="",!1!==e.createErrors?(l+=" { keyword: '"+(i||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(l+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(l+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),l+=" } "):l+=" {} ",L=l,l=$.pop(),!e.compositeRule&&p?e.async?l+=" throw new ValidationError(["+L+"]); ":l+=" validate.errors = ["+L+"]; return false; ":l+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",B=l,l=$.pop(),r?b.errors?"full"!=b.errors&&(l+="  for (var "+O+"="+C+"; "+O+"<errors; "+O+"++) { var "+N+" = vErrors["+O+"]; if ("+N+".dataPath === undefined) "+N+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+N+".schemaPath === undefined) { "+N+'.schemaPath = "'+g+'"; } ',e.opts.verbose&&(l+=" "+N+".schema = "+I+"; "+N+".data = "+m+"; "),l+=" } "):!1===b.errors?l+=" "+B+" ":(l+=" if ("+C+" == errors) { "+B+" } else {  for (var "+O+"="+C+"; "+O+"<errors; "+O+"++) { var "+N+" = vErrors["+O+"]; if ("+N+".dataPath === undefined) "+N+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+N+".schemaPath === undefined) { "+N+'.schemaPath = "'+g+'"; } ',e.opts.verbose&&(l+=" "+N+".schema = "+I+"; "+N+".data = "+m+"; "),l+=" } } "):o?(l+="   var err =   ",!1!==e.createErrors?(l+=" { keyword: '"+(i||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(l+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(l+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),l+=" } "):l+=" {} ",l+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&p&&(e.async?l+=" throw new ValidationError(vErrors); ":l+=" validate.errors = vErrors; return false; ")):!1===b.errors?l+=" "+B+" ":(l+=" if (Array.isArray("+W+")) { if (vErrors === null) vErrors = "+W+"; else vErrors = vErrors.concat("+W+"); errors = vErrors.length;  for (var "+O+"="+C+"; "+O+"<errors; "+O+"++) { var "+N+" = vErrors["+O+"]; if ("+N+".dataPath === undefined) "+N+".dataPath = (dataPath || '') + "+e.errorPath+";  "+N+'.schemaPath = "'+g+'";  ',e.opts.verbose&&(l+=" "+N+".schema = "+I+"; "+N+".data = "+m+"; "),l+=" } } else { "+B+" } "),l+=" } ",p&&(l+=" else { ")),l}},function(e,t,i){"use strict";var n=i(32);e.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:n.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:n.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},function(e){e.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')},function(e,t,i){"use strict";i.r(t),i.d(t,"treeModeMixins",function(){return P});var n=i(13),o=i.n(n);function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.locked=!1}var t,i,n;return t=e,(i=[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var e;this.locked||(e=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&r(t.prototype,i),n&&r(t,n),e}(),W=i(0);function a(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var l=function(){function e(t){function o(e){return t.node.findNodeByInternalPath(e)}!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){o(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){o(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){o(e.path).updateValue(e.oldValue)},redo:function(e){o(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){o(e.path).changeType(e.oldType)},redo:function(e){o(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=o(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=o(e.parentPath);e.clonePaths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=o(e.parentPath),r=o(e.afterPath);e.paths.map(o).forEach(function(e){var t,i=e.clone();"object"===n.type&&(t=n.getFieldNames(),i.field=Object(W.findUniqueName)(e.field,t)),n.insertAfter(i,r),r=i})}},moveNodes:{undo:function(i){var n=o(i.oldParentPath),e=o(i.newParentPath),r=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=o(i.oldParentPathRedo),n=o(i.newParentPathRedo),r=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)})}},sort:{undo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){o(e.path).setInternalValue(e.oldValue)},redo:function(e){o(e.path).setInternalValue(e.newValue)}}}}var t,i,n;return t=e,(i=[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&a(t.prototype,i),n&&a(t,n),e}(),d=i(1);function c(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var h=function(){function h(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,h);var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t;var n=document.createElement("div");(this.dom.wrapper=n).className="jsoneditor-search",t.appendChild(n);var r=document.createElement("div");(this.dom.results=r).className="jsoneditor-results",n.appendChild(r);var o=document.createElement("div");(this.dom.input=o).className="jsoneditor-frame",o.title=Object(d.c)("searchTitle"),n.appendChild(o);var s=document.createElement("button");s.type="button",s.className="jsoneditor-refresh",o.appendChild(s);var a=document.createElement("input");a.type="text",(this.dom.search=a).oninput=function(e){i._onDelayedSearch(e)},a.onchange=function(e){i._onSearch()},a.onkeydown=function(e){i._onKeyDown(e)},a.onkeyup=function(e){i._onKeyUp(e)},s.onclick=function(e){a.select()},o.appendChild(a);var l=document.createElement("button");l.type="button",l.title=Object(d.c)("searchNextResultTitle"),l.className="jsoneditor-next",l.onclick=function(){i.next()},o.appendChild(l);var c=document.createElement("button");c.type="button",c.title=Object(d.c)("searchPreviousResultTitle"),c.className="jsoneditor-previous",c.onclick=function(){i.previous()},o.appendChild(c)}var e,t,i;return e=h,(t=[{key:"next",value:function(e){var t;this.results&&((t=null!==this.resultIndex?this.resultIndex+1:0)>this.results.length-1&&(t=0),this._setActiveResult(t,e))}},{key:"previous",value:function(e){var t,i;this.results&&(t=this.results.length-1,(i=null!==this.resultIndex?this.resultIndex-1:t)<0&&(i=t),this._setActiveResult(i,e))}},{key:"_setActiveResult",value:function(e,t){var i;if(this.activeResult&&(i=this.activeResult.node,"field"===this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()),!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"===r?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(r)})}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,i=0<t.length?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n,r=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,o=0;if(this.activeResult)for(var s=0;s<this.results.length;s++)if(this.results[s].node===this.activeResult.node){o=s;break}this._setActiveResult(o,!1),void 0!==i?(n=this.results.length,this.dom.results.textContent=0===n?"no results":1===n?"1 result":r<n?r+"+ results":n+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&c(e.prototype,t),i&&c(e,i),h}(),u=i(3);function g(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var p=function(){function i(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}var e,t,n;return e=i,(t=[{key:"reset",value:function(){this.path.textContent=Object(d.c)("selectNode")}},{key:"setPath",value:function(s){var a=this;this.path.textContent="",s&&s.length&&s.forEach(function(i,n){var e,t,r,o=document.createElement("span");o.className="jsoneditor-treepath-element",o.innerText=i.name,o.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(a,i),a.path.appendChild(o),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.textContent="►",e.onclick=function(){a.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(s[n+1]+1&&s[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(a,i,e.name)})}),new u.a(t).show(e,a.root,!0)},a.path.appendChild(e)),n===s.length-1&&(t=(e||o).getBoundingClientRect().right,a.path.offsetWidth<t&&(a.path.scrollLeft=t),a.path.scrollLeft&&((r=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",r.title="show all path",r.textContent="...",r.onclick=function(e){a.contentMenuClicked=!1,Object(W.addClassName)(a.path,"show-all"),a.path.style.width=a.path.parentNode.getBoundingClientRect().width-10+"px",a.path.onblur=function(){if(a.contentMenuClicked)return a.contentMenuClicked=!1,void a.path.focus();Object(W.removeClassName)(a.path,"show-all"),a.path.onblur=void 0,a.path.style.width="",a.setPath(e)}}.bind(a,s),a.path.insertBefore(r,a.path.firstChild)))})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}])&&g(e.prototype,t),n&&g(e,n),i}(),m=i(11),f=i.n(m),C=i(12);var v=i(5),I=i(6),A=i(2),b=void 0;function y(e){return(y="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function w(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var E=function(){function B(e,t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,B),this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=Object(W.debounce)(this._onChangeValue.bind(this),B.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=Object(W.debounce)(this._onChangeField.bind(this),B.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var e,t,i;return e=B,(t=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:S}},{key:"_updateEditability",value:function(){var e;this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,"tree"!==this.editor.options.mode&&"form"!==this.editor.options.mode||"function"!=typeof this.editor.options.onEditable||("boolean"==typeof(e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()}))?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))))}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++)var n=e[i],t=t.childs[n];return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var i=Object(W.parsePath)(e),n=this;n&&0<i.length;)!function(){var t=i.shift();if("number"==typeof t){if("array"!==n.type)throw new Error("Cannot get child node at index "+t+": node is no array");n=n.childs[t]}else{if("object"!==n.type)throw new Error("Cannot get child node "+t+": node is no object");n=n.childs.filter(function(e){return e.field===t})[0]}}();return n}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var o=this,s=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(s&&this.dom&&this.dom.tr){Object(W.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var a=document.createElement("button");a.type="button",a.className="jsoneditor-button jsoneditor-schema-error";var t=function(){o.dom.popupAnchor&&o.dom.popupAnchor.destroy()},l=function(){delete o.dom.popupAnchor},i=function(e){var t=o.editor.frame;o.dom.popupAnchor=Object(C.a)(a,o.editor.getPopupAnchor(),l,e);var i=a.getBoundingClientRect(),n=120<t.getBoundingClientRect().width-i.x?"jsoneditor-above":"jsoneditor-left",r=document.createElement("div");r.className="jsoneditor-popover "+n,r.appendChild(document.createTextNode(s.message)),o.dom.popupAnchor.appendChild(r)};a.onmouseover=function(){o.dom.popupAnchor||i(!0)},a.onfocus=function(){t(),i(!1)},a.onblur=function(){t()};var n=this.errorChild;for(n&&(a.onclick=function(){n.findParents().forEach(function(e){e.expand(!1)}),n.scrollTo(function(){n.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(a)}else this.dom.tr&&Object(W.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var i,n,r,o,s,a,l,c,h=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),n=0;n<e.length;n++){void 0===(s=e[n])||s instanceof Function||(n<this.childs.length?((i=this.childs[n]).fieldEditable=!1,i.index=n,i.setValue(s)):(i=new B(this.editor,{value:s}),o=n<this.getMaxVisibleChilds(),this.appendChild(i,o,!1)))}for(r=this.childs.length;r>=e.length;r--)this.removeChild(this.childs[r],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),r=this.childs.length-1;0<=r;r--)k(e,this.childs[r].field)||this.removeChild(this.childs[r],!1);for(var d in n=0,e){k(e,d)&&(void 0===(s=e[d])||s instanceof Function||((a=this.findChildByProperty(d))?(a.setField(d,!0),a.setValue(s)):(l=new B(this.editor,{field:d,value:s}),c=n<this.getMaxVisibleChilds(),this.appendChild(l,c,!1))),n++)}!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(h)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,i,n,r,o,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?((i=this.childs[r]).fieldEditable=!1,i.index=r,i.setInternalValue(t)):(i=new B(this.editor,{internalValue:t}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?(delete(i=this.childs[r]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new B(this.editor,{field:t.field,internalValue:t.value}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var e;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(e=this._detachFromDom(),this.clearDom(),this._attachToDom(e)):this.clearDom()}},{key:"getValue",value:function(){if("array"===this.type){var t=[];return this.childs.forEach(function(e){t.push(e.getValue())}),t}if("object"!==this.type)return void 0===this.value&&this._getDomValue(),this.value;var i={};return this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var i,n=new B(this.editor);return n.type=this.type,n.field=this.field,n.fieldInnerText=this.fieldInnerText,n.fieldEditable=this.fieldEditable,n.previousField=this.previousField,n.value=this.value,n.valueInnerText=this.valueInnerText,n.previousValue=this.previousValue,n.expanded=this.expanded,n.visibleChilds=this.visibleChilds,this.childs?(i=[],this.childs.forEach(function(e){var t=e.clone();t.setParent(n),i.push(t)}),n.childs=i):n.childs=void 0,n}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppendDom();i.parentNode||((r=e.nextSibling)?t.insertBefore(i,r):t.appendChild(i));for(var n=Math.min(this.childs.length,this.visibleChilds),r=this._getNextTr(),o=0;o<n;o++){var s=this.childs[o];s.getDom().parentNode||t.insertBefore(s.getDom(),r),s.showChilds()}var a=this.getShowMoreDom();r=this._getNextTr(),a.parentNode||t.insertBefore(a,r),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){var t,i;this.childs&&this.expanded&&((t=this.getAppendDom()).parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()}),(i=this.getShowMoreDom()).parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var e;this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree&&(Object(W.removeAllClassNames)(this.dom.tree),e=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"",Object(W.addClassName)(this.dom.tree,"jsoneditor-values "+e))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,i){var n,r,o;this._hasChilds()&&(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t&&(n=e.getDom(),o=(r=this._getNextTr())?r.parentNode:void 0,r&&o&&o.insertBefore(n,r),e.showChilds(),this.visibleChilds++),!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})))}},{key:"moveBefore",value:function(e,t,i){var n,r,o;this._hasChilds()&&((n=this.dom.tr?this.dom.tr.parentNode:void 0)&&((r=document.createElement("tr")).style.height=n.clientHeight+"px",n.appendChild(r)),e.parent&&e.parent.removeChild(e),t instanceof N||!t?this.childs.length+1>this.visibleChilds?(o=this.childs[this.visibleChilds-1],this.insertBefore(e,o,i)):this.appendChild(e,!0,i):this.insertBefore(e,t,i),n&&n.removeChild(r))}},{key:"insertBefore",value:function(e,t,i){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var n=this.childs.indexOf(t);if(-1===n)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(n,0,e)}var r,o,s;this.expanded&&(r=e.getDom(),s=(o=t.getDom())?o.parentNode:void 0,o&&s&&s.insertBefore(r,o),e.showChilds(),this.showChilds()),!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(e,t){var i,n;this._hasChilds()&&(i=this.childs.indexOf(t),(n=this.childs[i+1])?this.insertBefore(e,n):this.appendChild(e))}},{key:"search",value:function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue()),i}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(B.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),Object(W.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(W.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),Object(W.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),Object(W.selectContentEditable)(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),Object(W.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),Object(W.selectContentEditable)(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t,i=this.type;i!==e&&("string"!==e&&"auto"!==e||"string"!==i&&"auto"!==i?(t=this._detachFromDom(),this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==i&&"auto"!==i||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==i&&"auto"!==i||(this.expanded=!0)):this.expanded=!1,this._attachToDom(t)):this.type=e,"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):Object(W.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==y(e)||!e)return!1;var i=Object.keys(e);if(this.childs.length!==i.length)return!1;for(t=0;t<i.length;t++){var n=this.childs[t];if(n.field!==i[t]||!n.deepEqual(e[n.field]))return!1}}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=Object(W.getInnerText)(this.dom.value),""===this.valueInnerText&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent="")),void 0!==this.valueInnerText)try{var e,t;(t="string"===this.type?this._unescapeHTML(this.valueInnerText):(e=this._unescapeHTML(this.valueInnerText),Object(W.parseString)(e)))!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(e){this._setValueError(Object(d.c)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e,t=this.editor.getDomSelection();t.range&&(e=Object(W.textDiff)(String(this.value),String(this.previousValue)),t.range.startOffset=e.start,t.range.endOffset=e.end);var i,n=this.editor.getDomSelection();n.range&&(i=Object(W.textDiff)(String(this.previousValue),String(this.value)),n.range.startOffset=i.start,n.range.endOffset=i.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:t,newSelection:n}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e,t=this.editor.getDomSelection(),i=this.previousField||"";t.range&&(e=Object(W.textDiff)(this.field,i),t.range.startOffset=e.start,t.range.endOffset=e.end);var n,r=this.editor.getDomSelection();r.range&&(n=Object(W.textDiff)(i,this.field),r.range.startOffset=n.start,r.range.endOffset=n.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:t,newSelection:r}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t,i=["jsoneditor-value"],n=this.value,r="auto"===this.type?Object(W.getType)(n):this.type,o="string"===r&&Object(W.isUrl)(n);if(i.push("jsoneditor-"+r),o&&i.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&i.push("jsoneditor-empty"),this.searchValueActive&&i.push("jsoneditor-highlight-active"),this.searchValue&&i.push("jsoneditor-highlight"),e.className=i.join(" "),"array"===r||"object"===r?(t=this.childs?this.childs.length:0,e.title=this.type+" containing "+t+" items"):o&&this.editable.value?e.title=Object(d.c)("openUrl"):e.title="","boolean"===r&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.textContent="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.textContent=this.enum[s],this.dom.select.option.value===this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||k(this.schema,"oneOf")||k(this.schema,"anyOf")||k(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);if(this.editable.value&&this.editor.options.colorPicker&&"string"==typeof n&&Object(W.isValidColor)(n)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),Object(W.addClassName)(this.dom.value,"jsoneditor-color-value"),this.dom.color.style.backgroundColor=n):this._deleteDomColor(),this._showTimestampTag()){this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));var a=null;if("function"==typeof this.editor.options.timestampFormat&&(a=this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()})),a){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(a))}else this.dom.date.textContent=new Date(n).toISOString();this.dom.date.title=new Date(n).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);Object(W.stripFormatting)(e),this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,Object(W.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var e,t=this.dom.field;t&&((e=Object(W.makeFieldTooltip)(this.schema,this.editor.options.language))&&(t.title=e),(""===String(this.field)&&"array"!==this.parent.type?Object(W.addClassName):Object(W.removeClassName))(t,"jsoneditor-empty"),(this.searchFieldActive?Object(W.addClassName):Object(W.removeClassName))(t,"jsoneditor-highlight-active"),(this.searchField?Object(W.addClassName):Object(W.removeClassName))(t,"jsoneditor-highlight"),Object(W.stripFormatting)(t))}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=Object(W.getInnerText)(this.dom.field),""===this.fieldInnerText&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent="")),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=Object(W.findUniqueName)(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError(Object(d.c)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError(Object(d.c)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var e;!this.schema||void 0===this.schema.default||this._hasChilds()||(e=this.dom.select?this.dom.select:this.dom.value)&&(this.value===this.schema.default?(e.title=Object(d.c)("default"),Object(W.addClassName)(e,"jsoneditor-is-default"),Object(W.removeClassName)(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),Object(W.removeClassName)(e,"jsoneditor-is-default"),Object(W.addClassName)(e,"jsoneditor-is-not-default")))}},{key:"_showTimestampTag",value:function(){if("number"!=typeof this.value)return!1;var e=this.editor.options.timestampTag;if("function"!=typeof e)return!0===e&&Object(W.isTimestamp)(this.field,this.value);var t=e({field:this.field,value:this.value,path:this.getPath()});return"boolean"==typeof t?t:Object(W.isTimestamp)(this.field,this.value)}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e,t,i,n,r=this.dom;if(r.tr)return r.tr;this._updateEditability(),r.tr=document.createElement("tr"),"tree"===(r.tr.node=this).editor.options.mode&&(e=document.createElement("td"),this.editable.field&&this.parent&&((t=document.createElement("button")).type="button",(r.drag=t).className="jsoneditor-button jsoneditor-dragarea",t.title=Object(d.c)("drag"),e.appendChild(t)),r.tr.appendChild(e),i=document.createElement("td"),(n=document.createElement("button")).type="button",(r.menu=n).className="jsoneditor-button jsoneditor-contextmenu-button",n.title=Object(d.c)("actionsMenu"),i.appendChild(r.menu),r.tr.appendChild(i));var o=document.createElement("td");return r.tr.appendChild(o),r.tree=this._createDomTree(),o.appendChild(r.tree),this.updateDom({updateIndexes:!0}),r.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&((t?Object(W.addClassName):Object(W.removeClassName))(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&((t?Object(W.addClassName):Object(W.removeClassName))(this.dom.tr,"jsoneditor-selected"),(e?Object(W.addClassName):Object(W.removeClassName))(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e=this.dom.tree;e&&(e.style.marginLeft=24*this.getLevel()+"px");var i,n,r,o=this.dom.field;o&&(this.fieldEditable?(o.contentEditable=this.editable.field,o.spellcheck=!1,o.className="jsoneditor-field"):(o.contentEditable=!1,o.className="jsoneditor-readonly"),n=void 0!==this.index?this.index:void 0!==this.field?this.field:(i=this.editor.options.schema?B._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&i.title?i.title:this._hasChilds()?this.type:"",r=this._escapeHTML(n),document.activeElement===o&&r===this._unescapeHTML(Object(W.getInnerText)(o))||(o.innerHTML=r),this._updateSchema());var s,a=this.dom.value;a&&("array"===this.type||"object"===this.type?this.updateNodeName():(s=this._escapeHTML(this.value),document.activeElement===a&&s===this._unescapeHTML(Object(W.getInnerText)(a))||(a.innerHTML=s)));var l=this.dom.tr;l&&("array"===this.type||"object"===this.type?(Object(W.addClassName)(l,"jsoneditor-expandable"),this.expanded?(Object(W.addClassName)(l,"jsoneditor-expanded"),Object(W.removeClassName)(l,"jsoneditor-collapsed")):(Object(W.addClassName)(l,"jsoneditor-collapsed"),Object(W.removeClassName)(l,"jsoneditor-expanded"))):(Object(W.removeClassName)(l,"jsoneditor-expandable"),Object(W.removeClassName)(l,"jsoneditor-expanded"),Object(W.removeClassName)(l,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),
this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?B._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=B._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.textContent=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field&&(e.field=""))}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).textContent="[...]":"object"===this.type?(e=document.createElement("div")).textContent="{...}":(!this.editable.value&&Object(W.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=Object(d.c)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.expand=this._createDomExpandButton(),r.appendChild(e.expand),e.tdExpand=r;var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.field=this._createDomField(),o.appendChild(e.field),e.tdField=o;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!==this.type&&"array"!==this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t}},{key:"onEvent",value:function(e){var t,i,n=e.type,r=e.target||e.srcElement,o=this.dom,s=this,a=this._hasChilds();"function"==typeof this.editor.options.onEvent&&this._onEvent(e),r!==o.drag&&r!==o.menu||("mouseover"===n?this.editor.highlighter.highlight(this):"mouseout"===n&&this.editor.highlighter.unhighlight()),"click"===n&&r===o.menu&&((t=s.editor.highlighter).highlight(s),t.lock(),Object(W.addClassName)(o.menu,"jsoneditor-selected"),this.showContextMenu(o.menu,function(){Object(W.removeClassName)(o.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"click"===n&&r===o.expand&&a&&(i=e.ctrlKey,this._onExpand(i)),"click"!==n||e.target!==s.dom.tdColor&&e.target!==s.dom.color||this._showColorPicker(),"change"===n&&r===o.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),"change"===n&&r===o.select&&(this.dom.value.innerHTML=this._escapeHTML(o.select.value),this._getDomValue(),this._updateDomValue());var l=o.value;if(r===l)switch(n){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var c=this._escapeHTML(this.value);c!==this._unescapeHTML(Object(W.getInnerText)(l))&&(l.innerHTML=c);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&Object(W.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){s._getDomValue(),s._updateDomValue()},1)}var h=o.field;if(r===h)switch(n){case"blur":this._getDomField(!0),this._updateDomField();var d=this._escapeHTML(this.field);d!==this._unescapeHTML(Object(W.getInnerText)(h))&&(h.innerHTML=d);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){s._getDomField(),s._updateDomField()},1)}var u=o.tree;u&&r===u.parentNode&&"click"===n&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<Object(W.getAbsoluteLeft)(o.tdSeparator))||a?h&&(Object(W.setEndOfContentEditable)(h),h.focus()):l&&!this.enum&&(Object(W.setEndOfContentEditable)(l),l.focus())),(r!==o.tdExpand||a)&&r!==o.tdField&&r!==o.tdSeparator||"click"!==n||e.hasMoved||h&&(Object(W.setEndOfContentEditable)(h),h.focus()),"keydown"===n&&this.onKeyDown(e)}},{key:"_onEvent",value:function(e){var t,i=e.target;i!==this.dom.field&&i!==this.dom.value||(t={field:this.getField(),path:this.getPath()},this._hasChilds()||i!==this.dom.value||(t.value=this.getValue()),this.editor.options.onEvent(t,e))}},{key:"onKeyDown",value:function(e){var t,i,n,r,o,s,a,l,c,h,d,u,g,p,m,f,C,v,I,A,b,y,w=e.which||e.keyCode,S=e.target||e.srcElement,x=e.ctrlKey,k=e.shiftKey,E=e.altKey,R=!1,_="tree"===this.editor.options.mode,T=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],$=T[0],L=T[T.length-1];13===w?S===this.dom.value?this.editable.value&&!e.ctrlKey||Object(W.isUrl)(this.value)&&(window.open(this.value,"_blank"),R=!0):S===this.dom.expand&&this._hasChilds()&&(g=e.ctrlKey,this._onExpand(g),S.focus(),R=!0):68===w?x&&_&&(B.onDuplicate(T),R=!0):69===w?x&&(this._onExpand(k),S.focus(),R=!0):77===w&&_?x&&(this.showContextMenu(S),R=!0):46===w&&_?x&&(B.onRemove(T),R=!0):45===w&&_?x&&!k?(this._onInsertBefore(),R=!0):x&&k&&(this._onInsertAfter(),R=!0):35===w?E&&((p=this._lastNode())&&p.focus(B.focusElement||this._getElementName(S)),R=!0):36===w?E&&((m=this._firstNode())&&m.focus(B.focusElement||this._getElementName(S)),R=!0):37===w?E&&!k?((f=this._previousElement(S))&&this.focus(this._getElementName(f)),R=!0):E&&k&&_&&(v=L.expanded?(C=L.getAppendDom())?C.nextSibling:void 0:L.getDom().nextSibling)&&(i=B.getNodeFromTarget(v),n=v.nextSibling,I=B.getNodeFromTarget(n),i&&i instanceof N&&1!==L.parent.childs.length&&I&&I.parent&&(r=this.editor.getDomSelection(),o=(s=$.parent).childs[L.getIndex()+1]||s.append,a=$.getIndex(),l=I.getIndex(),c=s.getInternalPath(),h=I.parent.getInternalPath(),T.forEach(function(e){I.parent.moveBefore(e,I)}),this.focus(B.focusElement||this._getElementName(S)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(O),oldParentPath:s.getInternalPath(),newParentPath:$.parent.getInternalPath(),oldIndex:o.getIndex(),newIndex:$.getIndex(),oldIndexRedo:a,newIndexRedo:l,oldParentPathRedo:c,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()}))):38===w?E&&!k?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(B.focusElement||this._getElementName(S))),R=!0):!E&&x&&k&&_?((t=this._previousNode())&&((u=this.editor.multiselection).start=u.start||this,u.end=t,d=this.editor._findTopLevelNodes(u.start,u.end),this.editor.select(d),t.focus("field")),R=!0):E&&k&&_&&((t=$._previousNode())&&t.parent&&(r=this.editor.getDomSelection(),o=(s=$.parent).childs[L.getIndex()+1]||s.append,a=$.getIndex(),l=t.getIndex(),c=s.getInternalPath(),h=t.parent.getInternalPath(),T.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(B.focusElement||this._getElementName(S)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(O),oldParentPath:s.getInternalPath(),newParentPath:$.parent.getInternalPath(),oldIndex:o.getIndex(),newIndex:$.getIndex(),oldIndexRedo:a,newIndexRedo:l,oldParentPathRedo:c,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()})),R=!0):39===w?E&&!k?((A=this._nextElement(S))&&this.focus(this._getElementName(A)),R=!0):E&&k&&_&&((b=$.getDom().previousSibling)&&(t=B.getNodeFromTarget(b))&&t.parent&&!t.isVisible()&&(r=this.editor.getDomSelection(),o=(s=$.parent).childs[L.getIndex()+1]||s.append,a=$.getIndex(),l=t.getIndex(),c=s.getInternalPath(),h=t.parent.getInternalPath(),T.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(B.focusElement||this._getElementName(S)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(O),oldParentPath:s.getInternalPath(),newParentPath:$.parent.getInternalPath(),oldIndex:o.getIndex(),newIndex:$.getIndex(),oldIndexRedo:a,newIndexRedo:l,oldParentPathRedo:c,newParentPathRedo:h,oldSelection:r,newSelection:this.editor.getDomSelection()}))):40===w&&(E&&!k?((i=this._nextNode())&&(this.editor.deselect(!0),i.focus(B.focusElement||this._getElementName(S))),R=!0):!E&&x&&k&&_?((i=this._nextNode())&&((u=this.editor.multiselection).start=u.start||this,u.end=i,d=this.editor._findTopLevelNodes(u.start,u.end),this.editor.select(d),i.focus("field")),R=!0):E&&k&&_&&((i=L.expanded?L.append?L.append._nextNode():void 0:L._nextNode())&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof N&&(i=L),(y=i&&(i._nextNode()||i.parent.append))&&y.parent&&(r=this.editor.getDomSelection(),o=(s=$.parent).childs[L.getIndex()+1]||s.append,a=$.getIndex(),l=y.getIndex(),c=s.getInternalPath(),h=y.parent.getInternalPath(),T.forEach(function(e){y.parent.moveBefore(e,y)}),this.focus(B.focusElement||this._getElementName(S)),this.editor._onAction("moveNodes",{count:T.length,fieldNames:T.map(O),oldParentPath:s.getInternalPath(),newParentPath:$.parent.getInternalPath(),oldParentPathRedo:c,newParentPathRedo:h,oldIndexRedo:a,newIndexRedo:l,oldIndex:o.getIndex(),newIndex:$.getIndex(),oldSelection:r,newSelection:this.editor.getDomSelection()})),R=!0)),R&&(e.preventDefault(),e.stopPropagation())}},{key:"_onExpand",value:function(e){var t,i,n;e&&(n=(i=(t=this.dom.tr.parentNode).parentNode).scrollTop,i.removeChild(t)),this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)}},{key:"_showColorPicker",value:function(){var t,e;"function"==typeof this.editor.options.onColorPicker&&this.dom.color&&((t=this)._deleteDomColor(),t.updateDom(),e=Object(C.a)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new B(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0);var o=this.getInternalPath();this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],paths:[r.getInternalPath()],beforePath:o,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:s})}},{key:"_onInsertAfter",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new B(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],paths:[r.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})}},{key:"_onAppend",value:function(e,t,i){var n=this.editor.getDomSelection(),r=new B(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[r],paths:[r.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})}},{key:"_onChangeType",value:function(e){var t,i,n=this.type;e!==n&&(t=this.editor.getDomSelection(),this.changeType(e),i=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:n,newType:e,oldSelection:t,newSelection:i}))}},{key:"sort",value:function(s,e,t){var i,a,n=!(2<arguments.length&&void 0!==t)||t;"string"==typeof s&&(s=Object(W.parsePath)(s)),this._hasChilds()&&(this.hideChilds(),i=this.childs,this.childs=this.childs.concat(),a="desc"===e?-1:1,"object"===this.type?this.childs.sort(function(e,t){return a*f()(e.field,t.field)}):this.childs.sort(function(e,t){var i=e.getNestedChild(s),n=t.getNestedChild(s);if(!i)return a;if(!n)return-a;var r=i.value,o=n.value;return"string"!=typeof r&&"string"!=typeof o?o<r?a:r<o?-a:0:a*f()(r,o)}),this._updateDomIndexes(),this.showChilds(),!0===n&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:i,newChilds:this.childs}))}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e=this.dom.tr?this.dom.tr.parentNode:void 0,t=this.expanded?this.getAppendDom():this.getDom(),i=t&&t.parentNode?t.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:e,nextTr:i}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=this.editor.options.executeQuery(i,e);this.setValue(n);var r=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:r}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue();this.editor._setRoot(this);var t=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new N(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new _(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=B.getNodeFromTarget(i),i&&e&&e instanceof N&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=B.getNodeFromTarget(i),i&&e&&e instanceof N&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e,t=null,i=this.getDom();return i&&i.parentNode&&(e=i.parentNode.firstChild,t=B.getNodeFromTarget(e)),t}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t.parentNode.lastChild,e=B.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=B.getNodeFromTarget(i);return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var i=this;return Object.keys(this.dom).find(function(e){return i.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,i){var n=this,e=n.editor.options.templates;null!=e&&(e.length&&t.push({type:"separator"}),e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:i?function(e,t){n._onAppend(e,t)}.bind(this,e.field,e.value):function(e,t){n._onInsertBefore(e,t)}.bind(this,e.field,e.value)})}))}},{key:"showContextMenu",value:function(e,t){var i,n,r,o,s=this,a=[];this.editable.value&&a.push({text:Object(d.c)("type"),title:Object(d.c)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:Object(d.c)("autoType"),click:function(){s._onChangeType("auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:Object(d.c)("arrayType"),click:function(){s._onChangeType("array")}},{text:Object(d.c)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:Object(d.c)("objectType"),click:function(){s._onChangeType("object")}},{text:Object(d.c)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:Object(d.c)("stringType"),click:function(){s._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&a.push({text:Object(d.c)("sort"),title:Object(d.c)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){s.showSortModal()}}),this.editor.options.enableTransform&&a.push({text:Object(d.c)("transform"),title:Object(d.c)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){s.showTransformModal()}}),this.parent&&a.push({text:Object(d.c)("extract"),title:Object(d.c)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){s.extract()}})),this.parent&&this.parent._hasChilds()&&(a.length&&a.push({type:"separator"}),i=s.parent.childs,s===i[i.length-1]&&(n=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:Object(d.c)("autoType"),click:function(){s._onAppend("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:Object(d.c)("arrayType"),click:function(){s._onAppend("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:Object(d.c)("objectType"),click:function(){s._onAppend("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:Object(d.c)("stringType"),click:function(){s._onAppend("","","string")}}],s.addTemplates(n,!0),a.push({text:Object(d.c)("appendText"),title:Object(d.c)("appendTitle"),submenuTitle:Object(d.c)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){s._onAppend("","","auto")},submenu:n})),r=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:Object(d.c)("autoType"),click:function(){s._onInsertBefore("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:Object(d.c)("arrayType"),click:function(){s._onInsertBefore("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:Object(d.c)("objectType"),click:function(){s._onInsertBefore("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:Object(d.c)("stringType"),click:function(){s._onInsertBefore("","","string")}}],s.addTemplates(r,!1),a.push({text:Object(d.c)("insert"),title:Object(d.c)("insertTitle"),submenuTitle:Object(d.c)("insertSub"),className:"jsoneditor-insert",click:function(){s._onInsertBefore("","","auto")},submenu:r}),this.editable.field&&(a.push({text:Object(d.c)("duplicateText"),title:Object(d.c)("duplicateField"),className:"jsoneditor-duplicate",click:function(){B.onDuplicate(s)}}),a.push({text:Object(d.c)("removeText"),title:Object(d.c)("removeField"),className:"jsoneditor-remove",click:function(){B.onRemove(s)}}))),this.editor.options.onCreateMenu&&(o=s.getPath(),a=this.editor.options.onCreateMenu(a,{type:"single",path:o,paths:[o]})),new u.a(a,{close:t}).show(e,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var n=this,e=this.editor.options.modalAnchor||A.a,t=this.getValue();Object(v.showSortModal)(e,t,function(e){var t=e.path,i=Object(W.parsePath)(t);n.sortedBy=e,n.sort(i,e.direction)},n.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options,i=e.modalAnchor,n=e.createQuery,r=e.executeQuery,o=e.queryDescription,s=this.getValue();Object(I.showTransformModal)({anchor:i||A.a,json:s,queryDescription:o,createQuery:n,executeQuery:r,onTransform:function(e){t.transform(e)}})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof Object(W.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=Object(W.escapeUnicodeChars)(n)),n}},{key:"_unescapeHTML",value:function(e){var t='"'+this._escapeJSON(e)+'"';return Object(W.parse)(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"===n?t+="\\n":"\\"===n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!=='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'===n?'\\"':n,i++}return t}},{key:"updateNodeName",value:function(){var e,t=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{e=this.editor.options.onNodeName({path:this.getPath(),size:t,type:this.type})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.textContent="object"===this.type?"{"+(e||t)+"}":"["+(e||t)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){var e;if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}])&&w(e.prototype,t),i&&w(e,i),B}();E.prototype.DEBOUNCE_INTERVAL=150,E.prototype.MAX_SEARCH_RESULTS=999;var S=100;function x(e){return e.getInternalPath()}function O(e){return e.getField()}function k(e,t){return Object.prototype.hasOwnProperty.call(e,t)}E.focusElement=void 0,E.select=function(e){setTimeout(function(){Object(W.selectContentEditable)(e)},0)},E.onDragStart=function(t,e){if(!Array.isArray(t))return E.onDragStart([t],e);var i,n,r,o,s,a;0!==t.length&&(i=t[0],n=t[t.length-1],r=i.parent,o=E.getNodeFromTarget(e.target),s=i.editor,a=Object(W.getAbsoluteTop)(o.dom.tr)-Object(W.getAbsoluteTop)(i.dom.tr),s.mousemove||(s.mousemove=Object(W.addEventListener)(window,"mousemove",function(e){E.onDrag(t,e)})),s.mouseup||(s.mouseup=Object(W.addEventListener)(window,"mouseup",function(e){E.onDragEnd(t,e)})),s.highlighter.lock(),s.drag={oldCursor:document.body.style.cursor,oldSelection:s.getDomSelection(),oldPaths:t.map(x),oldParent:r,oldNextNode:r.childs[n.getIndex()+1]||r.append,oldParentPathRedo:r.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:a,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault())},E.onDrag=function(e,t){if(!Array.isArray(e))return E.onDrag([e],t);if(0!==e.length){var i,n,r,o,s,a,l,c=e[0].editor,h=t.pageY-c.drag.offsetY,d=t.pageX,u=!1,g=e[0],p=g.dom.tr,m=Object(W.getAbsoluteTop)(p),f=p.offsetHeight;if(h<m){for(S=p;S=S.previousSibling,x=E.getNodeFromTarget(S),o=S?Object(W.getAbsoluteTop)(S):0,S&&h<o;);x&&!x.parent&&(x=void 0),x||(S=(n=p.parentNode.firstChild)?n.nextSibling:void 0,(x=E.getNodeFromTarget(S))===g&&(x=void 0)),x&&x.isVisible()&&(o=(S=x.dom.tr)?Object(W.getAbsoluteTop)(S):0)+f<h&&(x=void 0),!x||!1!==c.options.limitDragging&&x.parent!==e[0].parent||(e.forEach(function(e){x.parent.moveBefore(e,x)}),u=!0)}else{var C,v,I=e[e.length-1];if(v=(C=I.expanded&&I.append?I.append.getDom():I.dom.tr)?C.nextSibling:void 0){for(s=Object(W.getAbsoluteTop)(v),i=v;r=E.getNodeFromTarget(i),i&&(a=i.nextSibling?Object(W.getAbsoluteTop)(i.nextSibling):0,l=i?a-s:0,r&&r.parent.childs.length===e.length&&r.parent.childs[e.length-1]===I&&(m+=27),i=i.nextSibling),i&&m+l<h;);if(r&&r.parent){for(var A=d-c.drag.mouseX,b=Math.round(A/24/2),y=c.drag.level+b,w=r.getLevel(),S=r.dom.tr&&r.dom.tr.previousSibling;w<y&&S;){var x=E.getNodeFromTarget(S);if(!e.some(function(e){return e===x||x.isDescendantOf(e)})){if(!(x instanceof N))break;var k=x.parent.childs;if(k.length===e.length&&k[e.length-1]===I)break;w=(r=E.getNodeFromTarget(S)).getLevel()}S=S.previousSibling}r instanceof N&&!r.isVisible()&&r.parent.showMore.isVisible()&&(r=r._nextNode()),r&&(!1===c.options.limitDragging||r.parent===e[0].parent)&&r.dom.tr&&r.dom.tr!==C.nextSibling&&(e.forEach(function(e){r.parent.moveBefore(e,r)}),u=!0)}}}u&&(c.drag.mouseX=d,c.drag.level=g.getLevel()),c.startAutoScroll(h),t.preventDefault()}},E.onDragEnd=function(e,t){if(!Array.isArray(e))return E.onDrag([e],t);var i,n,r,o,s,a,l,c,h,d;0!==e.length&&(i=e[0],n=i.editor,e[0]&&e[0].dom.menu.focus(),r=n.drag.oldParent.getInternalPath(),o=i.parent.getInternalPath(),s=n.drag.oldParent===i.parent,a=n.drag.oldNextNode.getIndex(),l=i.getIndex(),c=n.drag.oldParentPathRedo,h=n.drag.oldIndexRedo,d=s&&h<l?l+e.length:l,s&&h===l||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(O),oldParentPath:r,newParentPath:o,oldIndex:a,newIndex:l,oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:c,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&(Object(W.removeEventListener)(window,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&(Object(W.removeEventListener)(window,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault())},E._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(0<i.length)return i[0].enum}return null},E._findSchema=function(e,t,i){for(var n=e,r=n,o=(o=e.oneOf||e.anyOf||e.allOf)||[e],s=0;s<o.length;s++){"$ref"in(n=o[s])&&"string"==typeof n.$ref&&(n=t[n.$ref])&&(r=E._findSchema(n,t,i));for(var a=0;a<i.length&&n;a++){var l=i.slice(a+1,i.length),c=i[a];if("string"!=typeof c||!n.patternProperties||n.properties&&c in n.properties)"string"==typeof c&&n.properties?c in n.properties?(n=n.properties[c])&&(r=E._findSchema(n,t,l)):r=null:"number"==typeof c&&n.items&&(n=n.items)&&(r=E._findSchema(n,t,l));else for(var h in n.patternProperties)c.match(h)&&(r=E._findSchema(n.patternProperties[h],t,l))}}return r===e&&0<i.length?null:r},E.onRemove=function(e){if(!Array.isArray(e))return E.onRemove([e]);var t,i,n,r,o,s,a;e&&0<e.length&&(i=(t=e[0]).parent,n=t.editor,r=t.getIndex(),n.highlighter.unhighlight(),o=n.getDomSelection(),E.blurNodes(e),s=n.getDomSelection(),a=e.map(x),e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:a,parentPath:i.getInternalPath(),index:r,oldSelection:o,newSelection:s}))},E.onDuplicate=function(e){if(!Array.isArray(e))return E.onDuplicate([e]);var t,n,i,r,o,s,a;e&&0<e.length&&(t=e[e.length-1],n=t.parent,(i=t.editor).deselect(i.multiselection.nodes),r=i.getDomSelection(),o=t,s=e.map(function(e){var t,i=e.clone();return"object"===e.parent.type&&(t=e.parent.getFieldNames(),i.field=Object(W.findUniqueName)(e.field,t)),n.insertAfter(i,o),o=i}),1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=b._escapeHTML(e[0].field),s[0].focus("field")):s[0].focus():i.select(s),a=i.getDomSelection(),i._onAction("duplicateNodes",{paths:e.map(x),clonePaths:s.map(x),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:r,newSelection:a}))},E.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},E.targetIsColorPicker=function(e){var t=E.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},E.blurNodes=function(e){var t,i,n;Array.isArray(e)?(i=(t=e[0]).parent,n=t.getIndex(),i.childs[n+e.length]?i.childs[n+e.length].focus():i.childs[n-1]?i.childs[n-1].focus():i.focus()):E.blurNodes([e])};var N=((R.prototype=new E).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t,i,n=document.createElement("tr");n.className="jsoneditor-append",n.node=this,e.tr=n,"tree"===this.editor.options.mode&&(e.tdDrag=document.createElement("td"),t=document.createElement("td"),e.tdMenu=t,(i=document.createElement("button")).type="button",i.className="jsoneditor-button jsoneditor-contextmenu-button",i.title="Click to open the actions menu (Ctrl+M)",e.menu=i,t.appendChild(e.menu));var r=document.createElement("td"),o=document.createElement("div");return o.appendChild(document.createTextNode("("+Object(d.c)("empty")+")")),o.className="jsoneditor-readonly",r.appendChild(o),e.td=r,e.text=o,this.updateDom(),n},R.prototype.getPath=function(){return null},R.prototype.getIndex=function(){return null},R.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.firstChild.nodeValue="("+Object(d.c)("empty")+" "+this.parent.type+")");var r=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&r.appendChild(t.tdDrag),t.tdMenu&&r.appendChild(t.tdMenu),r.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&r.removeChild(t.tdDrag),t.tdMenu&&r.removeChild(t.tdMenu),r.removeChild(i))},R.prototype.isVisible=function(){return 0===this.parent.childs.length},R.prototype.showContextMenu=function(e,t){var i=this,n=[{text:Object(d.c)("auto"),className:"jsoneditor-type-auto",title:Object(d.c)("autoType"),click:function(){i._onAppend("","","auto")}},{text:Object(d.c)("array"),className:"jsoneditor-type-array",title:Object(d.c)("arrayType"),click:function(){i._onAppend("",[])}},{text:Object(d.c)("object"),className:"jsoneditor-type-object",title:Object(d.c)("objectType"),click:function(){i._onAppend("",{})}},{text:Object(d.c)("string"),className:"jsoneditor-type-string",title:Object(d.c)("stringType"),click:function(){i._onAppend("","","string")}}];i.addTemplates(n,!0);var r,o=[{text:Object(d.c)("appendText"),title:Object(d.c)("appendTitleAuto"),submenuTitle:Object(d.c)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:n}];this.editor.options.onCreateMenu&&(r=i.parent.getPath(),o=this.editor.options.onCreateMenu(o,{type:"append",path:r,paths:[r]})),new u.a(o,{close:t}).show(e,this.editor.getPopupAnchor())},R.prototype.onEvent=function(e){var t,i=e.type,n=e.target||e.srcElement,r=this.dom;n===r.menu&&("mouseover"===i?this.editor.highlighter.highlight(this.parent):"mouseout"===i&&this.editor.highlighter.unhighlight()),"click"===i&&n===r.menu&&((t=this.editor.highlighter).highlight(this.parent),t.lock(),Object(W.addClassName)(r.menu,"jsoneditor-selected"),this.showContextMenu(r.menu,function(){Object(W.removeClassName)(r.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"keydown"===i&&this.onKeyDown(e)},R);function R(e){this.editor=e,this.dom={}}var _=((T.prototype=new E).getDom=function(){return this.dom.tr||(this._updateEditability(),this.dom.tr||(i=(t=this).parent,(e=document.createElement("a")).appendChild(document.createTextNode(Object(d.c)("showMore"))),e.href="#",e.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1},(n=document.createElement("a")).appendChild(document.createTextNode(Object(d.c)("showAll"))),n.href="#",n.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1},r=document.createElement("div"),o=document.createTextNode(this._getShowMoreText()),r.className="jsoneditor-show-more",r.appendChild(o),r.appendChild(e),r.appendChild(document.createTextNode(". ")),r.appendChild(n),r.appendChild(document.createTextNode(". ")),(s=document.createElement("td")).appendChild(r),a=document.createElement("tr"),"tree"===this.editor.options.mode&&(a.appendChild(document.createElement("td")),a.appendChild(document.createElement("td"))),a.appendChild(s),a.className="jsoneditor-show-more",this.dom.tr=a,this.dom.moreContents=r,this.dom.moreText=o),this.updateDom()),this.dom.tr;var t,i,e,n,r,o,s,a},T.prototype.updateDom=function(e){var t;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(t=this.parent._getNextTr())&&t.parentNode.insertBefore(this.dom.tr,t),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},T.prototype._getShowMoreText=function(){return Object(d.c)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},T.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},T.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},T);function T(e,t){this.editor=e,this.parent=t,this.dom={}}var $=i(8),L=i(9),B={start:function(e,t){return 0===t.indexOf(e)},contain:function(e,t){return-1<t.indexOf(e)}};var G=i(4),H={};H.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new s,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=function(l){(l=l||{}).filter=l.filter||"start",l.trigger=l.trigger||"keydown",l.confirmKeys=l.confirmKeys||[39,35,9],l.caseSensitive=l.caseSensitive||!1;var r="",o="",s=document.createElement("div");s.style.position="relative",s.style.outline="0",s.style.border="0",s.style.margin="0",s.style.padding="0";var t,c,h=document.createElement("div");function d(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function a(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=r,t.style.fontFamily=o,t.style.fontWeight="normal",document.body.appendChild(t)),t.textContent=e,t.getBoundingClientRect().right}h.className="autocomplete dropdown",h.style.position="absolute",h.style.visibility="hidden";var u,g,p,i,m,f={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:s,show:function(e,t,i){var n=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===r&&(r=window.getComputedStyle(e).getPropertyValue("font-size")),""===o&&(o=window.getComputedStyle(e).getPropertyValue("font-family")),h.style.marginLeft="0",h.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i.map(String),this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){n.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",b),this.element.addEventListener("keydown",b,!1),this.element.removeEventListener("blur",y),this.element.addEventListener("blur",y,!1)),s.appendChild(this.elementHint),s.appendChild(h),e.parentElement.appendChild(s),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,C.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var t=(t=e.innerText).replace("\n",""),i=this.options.length,n=t.substring(this.startFrom);c=t.substring(0,this.startFrom);for(var r=0;r<i;r++){var o=this.options[r];if(!l.caseSensitive&&0===o.toLowerCase().indexOf(n.toLowerCase())||l.caseSensitive&&0===o.indexOf(n)){this.elementHint.innerText=c+n+o.substring(n.length),this.elementHint.realInnerText=c+o;break}}h.style.left=a(c)+"px",C.refresh(n,this.options),this.elementHint.style.width=a(this.elementHint.innerText)+10+"px","hidden"===h.style.visibility||(this.elementHint.style.width=a(this.elementHint.innerText)+h.clientWidth+"px")}},C=(u=h,g=[],p=0,i=-1,m={rs:f,hide:function(){u.style.visibility="hidden"},refresh:function(n,e){u.style.visibility="hidden",p=0,u.textContent="";var t=window.innerHeight||document.documentElement.clientHeight,i=u.parentNode.getBoundingClientRect(),r=i.top-6,o=t-i.bottom-6;g=[];var s="function"==typeof l.filter?l.filter:B[l.filter],a=s?e.filter(function(e){return s(l.caseSensitive?n:n.toLowerCase(),l.caseSensitive?e:e.toLowerCase(),l)}):[];0!==(g=a.map(function(e){var t=document.createElement("div");t.className="item",t.onmouseover=v,t.onmouseout=I,t.onmousedown=A,t.__hint=e,t.textContent="",t.appendChild(document.createTextNode(e.substring(0,n.length)));var i=document.createElement("b");return i.appendChild(document.createTextNode(e.substring(n.length))),t.appendChild(i),u.appendChild(t),t})).length&&(1===g.length&&(n.toLowerCase()===g[0].__hint.toLowerCase()&&!l.caseSensitive||n===g[0].__hint&&l.caseSensitive)||g.length<2||(m.highlight(0),3*o<r?(u.style.maxHeight=r+"px",u.style.top="",u.style.bottom="100%"):(u.style.top="100%",u.style.bottom="",u.style.maxHeight=o+"px"),u.style.visibility="visible"))},highlight:function(e){-1!==i&&g[i]&&(g[i].className="item"),g[e].className="item hover",i=e},move:function(e){return"hidden"===u.style.visibility?"":(p+e===-1||p+e===g.length||(p+=e,m.highlight(p)),g[p].__hint)},onmouseselection:function(){}});function v(){this.style.backgroundColor="#ddd"}function I(){this.style.backgroundColor=""}function A(){m.hide(),m.onmouseselection(this.__hint,m.rs)}var b=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t){if(27===t)return f.hideDropDown(),f.element.focus(),e.preventDefault(),void e.stopPropagation();var i,n,r=(r=this.element.innerText).replace("\n","");if(0<=l.confirmKeys.indexOf(t))return 9===t&&0===this.elementHint.innerText.length&&f.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,f.hideDropDown(),d(this.element),9===t&&(f.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!==t){if(40===t){var o=r.substring(this.startFrom),s=C.move(1);return""===s&&f.onArrowDown(),this.elementHint.innerText=c+o+s.substring(o.length),this.elementHint.realInnerText=c+s,e.preventDefault(),void e.stopPropagation()}38===t&&(i=r.substring(this.startFrom),""===(n=C.move(-1))&&f.onArrowUp(),this.elementHint.innerText=c+i+n.substring(i.length),this.elementHint.realInnerText=c+n,e.preventDefault(),e.stopPropagation())}else if(0===this.elementHint.innerText.length)f.onEnter();else{var a="hidden"===h.style.visibility;if(C.hide(),a)return f.hideDropDown(),f.element.focus(),void f.onEnter();this.element.innerText=this.elementHint.realInnerText,f.hideDropDown(),d(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(f),y=function(){f.hideDropDown()};return C.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=c+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),d(t.element)},1)},f}(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new l(this)),this._createFrame(),this._createTable()},H.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},H._setOptions=function(t){var i=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){var n,r;o.a?(n=e.getBoundingClientRect().top,r=window.innerHeight-n<300&&300<n,new o.a({parent:e,color:t,popup:r?"top":"bottom",onDone:function(e){var t=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(t)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:G.a,executeQuery:G.b,onEvent:null,enableSort:!0,enableTransform:!0},t&&(Object.keys(t).forEach(function(e){i.options[e]=t[e]}),null==t.limitDragging&&null!=t.schema&&(this.options.limitDragging=!0)),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=Object(W.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),Object(d.b)(this.options.languages),Object(d.a)(this.options.language)},H.set=function(e){var t,i;e instanceof Function||void 0===e?this.clear():(this.content.removeChild(this.table),t={field:this.options.name,value:e},i=new E(this,t),this._setRoot(i),this.validate(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},H.update=function(e){var t,i,n;this.node.deepEqual(e)||(t=this.getSelection(),this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end?(i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path),i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})):this.setSelection({},{}))},H.get=function(){return this.node?this.node.getValue():void 0},H.getText=function(){return JSON.stringify(this.get())},H.setText=function(t){try{this.set(Object(W.parse)(t))}catch(e){var i=Object(W.repair)(t);this.set(Object(W.parse)(i))}},H.updateText=function(t){try{this.update(Object(W.parse)(t))}catch(e){var i=Object(W.repair)(t);this.update(Object(W.parse)(i))}},H.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},H.getName=function(){return this.options.name},H.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},H.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},H._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},H.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},H.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},H.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},H._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},H._onChange=function(){if(!this.onChangeDisabled){var e;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(e.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},H.validate=function(){var i=this,t=this.node;if(t){var e=t.getValue(),n=[];this.validateSchema&&(this.validateSchema(e)||(n=this.validateSchema.errors.map(function(e){return Object(W.improveSchemaError)(e)}).map(function(e){return{node:t.findNode(e.dataPath),error:e,type:"validation"}}).filter(function(e){return null!=e.node})));try{this.validationSequence++;var r=this,o=this.validationSequence;this._validateCustom(e).then(function(e){var t;o===r.validationSequence&&(t=[].concat(n,e||[]),r._renderValidationErrors(t),"function"==typeof i.options.onValidationError&&(Object(W.isValidationErrorChanged)(t,i.lastSchemaErrors)&&i.options.onValidationError.call(i,t),i.lastSchemaErrors=t))}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},H._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},H._validateCustom=function(e){try{if(this.options.onValidate){var i=this.node,t=this.options.onValidate(e);return(Object(W.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=Object(W.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e,type:"customValidation"}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},H.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},H.startAutoScroll=function(e){var t=this,i=this.scrollableContent,n=Object(W.getAbsoluteTop)(i),r=i.clientHeight,o=n+r;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:o-24<e&&r+i.scrollTop<i.scrollHeight?this.autoScrollStep=(o-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},H.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},H.setDomSelection=function(e){var t,i,n,r,o;e&&("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths?(t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)}),this.select(i)):(r=(n=e.path?this.node.findNodeByInternalPath(e.path):null)&&e.domName?n.dom[e.domName]:null,e.range&&r?(o=Object.assign({},e.range,{container:r}),Object(W.setSelectionOffset)(o)):n&&n.focus()))},H.getDomSelection=function(){var t=E.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=Object(W.getSelectionOffset)();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==i&&(n=null),n&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},H.scrollTo=function(e,n){var r,t,i,o,s=this.scrollableContent;s?((r=this).animateTimeout&&(clearTimeout(r.animateTimeout),delete r.animateTimeout),r.animateCallback&&(r.animateCallback(!1),delete r.animateCallback),t=s.clientHeight,i=s.scrollHeight-t,o=Math.min(Math.max(e-t/4,0),i),function e(){var t=s.scrollTop,i=o-t;3<Math.abs(i)?(s.scrollTop+=i/3,r.animateCallback=n,r.animateTimeout=setTimeout(e,50)):(n&&n(!0),s.scrollTop=o,delete r.animateTimeout,delete r.animateCallback)}()):n&&n(!1)},H._createFrame=function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}var e,n,r,o,s,a,l,c={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new L.a(c),this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,Object(W.addEventListener)(this.frame,"focus",i,!0),Object(W.addEventListener)(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar&&(Object(W.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-expand-all",e.title=Object(d.c)("expandAll"),e.onclick=function(){t.expandAll()},this.menu.appendChild(e),(n=document.createElement("button")).type="button",n.title=Object(d.c)("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.options.enableSort&&((r=document.createElement("button")).type="button",r.className="jsoneditor-sort",r.title=Object(d.c)("sortTitleShort"),r.onclick=function(){t.node.showSortModal()},this.menu.appendChild(r)),this.options.enableTransform&&((o=document.createElement("button")).type="button",o.title=Object(d.c)("transformTitleShort"),o.className="jsoneditor-transform",o.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(o)),this.history&&((s=document.createElement("button")).type="button",s.className="jsoneditor-undo jsoneditor-separator",s.title=Object(d.c)("undo"),s.onclick=function(){t._onUndo()},this.menu.appendChild(s),this.dom.undo=s,(a=document.createElement("button")).type="button",a.className="jsoneditor-redo",a.title=Object(d.c)("redo"),a.onclick=function(){t._onRedo()},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange=function(){s.disabled=!t.history.canUndo(),a.disabled=!t.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((l=this).modeSwitcher=new $.a(this.menu,this.options.modes,this.options.mode,function(e){l.setMode(e),l.modeSwitcher.focus()})),this.options.search&&(this.searchBox=new h(this,this.menu))),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new p(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},H._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},H._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},H._onEvent=function(e){if(!E.targetIsColorPicker(e.target)){var t,i=E.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),i&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),i&&this.options&&this.options.navigationBar&&i&&("keydown"===e.type||"mousedown"===e.type)&&(t=this,setTimeout(function(){t._updateTreePath(i.getNodePath())})),i&&i.selected){if("click"===e.type){if(e.target===i.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&E.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&Object(W.hasParentNode)(e.target,this.content)&&(this.deselect(),i&&e.target===i.dom.drag?E.onDragStart(i,e):i&&(e.target===i.dom.field||e.target===i.dom.value||e.target===i.dom.select)||this._onMultiSelectStart(e));i&&i.onEvent(e)}},H._updateTreePath=function(e){var i;function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.field||e.type}e&&e.length?(Object(W.removeClassName)(this.navBar,"nav-bar-empty"),i=[],e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)):Object(W.addClassName)(this.navBar,"nav-bar-empty")},H._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},H._onTreePathMenuItemSelected=function(e,t){var i;e&&e.children.length&&((i=e.children.find(function(e){return e.name===t}))&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus()))},H._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},H._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},H._onMultiSelectStart=function(e){var t,i=E.getNodeFromTarget(e.target);"tree"===this.options.mode&&void 0===this.options.onEditable&&(this.multiselection={start:i||null,end:null,nodes:[]},this._startDragDistance(e),(t=this).mousemove||(this.mousemove=Object(W.addEventListener)(window,"mousemove",function(e){t._onMultiSelect(e)})),this.mouseup||(this.mouseup=Object(W.addEventListener)(window,"mouseup",function(e){t._onMultiSelectEnd(e)})),e.preventDefault())},H._onMultiSelect=function(e){var t,i,n,r;e.preventDefault(),this._updateDragDistance(e),e.hasMoved&&((t=E.getNodeFromTarget(e.target))&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect(),i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start,i&&n&&(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length&&(r=this.multiselection.nodes[0],this.multiselection.start===r||this.multiselection.start.isDescendantOf(r)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes)))},H._onMultiSelectEnd=function(){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(Object(W.removeEventListener)(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(Object(W.removeEventListener)(window,"mouseup",this.mouseup),delete this.mouseup)},H.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},H.select=function(e){if(!Array.isArray(e))return this.select([e]);var t,i;e&&(this.deselect(),this.multiselection.nodes=e.slice(0),t=e[0],e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler&&(i=this.getSelection(),this._selectionChangedHandler(i.start,i.end)))},H._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),r=0;r<i.length&&i[r]===n[r];)r++;var o=i[r-1],s=i[r],a=n[r];if(s&&a||(o.parent?o=(a=s=o).parent:(s=o.childs[0],a=o.childs[o.childs.length-1])),o&&s&&a){var l=o.childs.indexOf(s),c=o.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return o.childs.slice(h,d+1)}return[]},H._showAutoComplete=function(t){var i=E.getNodeFromTarget(t),n="";0<=t.className.indexOf("jsoneditor-value")&&(n="value"),0<=t.className.indexOf("jsoneditor-field")&&(n="field");var r=this;setTimeout(function(){var e;!i||!("focus"===r.options.autocomplete.trigger||0<t.innerText.length)||null===(e=r.options.autocomplete.getOptions(t.innerText,i.getPath(),n,i.editor))?r.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?r.autocomplete.hideDropDown():e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)},50)},H._onKeyDown=function(e){var t,i=e.which||e.keyCode,n=e.altKey,r=e.ctrlKey,o=e.metaKey,s=e.shiftKey,a=!1,l=this.focusTarget;9===i&&(t=this,setTimeout(function(){t.focusTarget!==l&&Object(W.selectContentEditable)(t.focusTarget)},0)),this.searchBox&&(r&&70===i?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),a=!0):(114===i||r&&71===i)&&(s?this.searchBox.previous(!0):this.searchBox.next(!0),a=!0)),this.history&&(r&&!s&&90===i?(this._onUndo(),a=!0):r&&s&&90===i&&(this._onRedo(),a=!0)),this.options.autocomplete&&!a&&(r||n||o||1!==e.key.length&&8!==i&&46!==i||(a=!1,this._showAutoComplete(e.target))),a&&(e.preventDefault(),e.stopPropagation())},H._createTable=function(){var e;this.options.navigationBar&&Object(W.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},H.showContextMenu=function(e,t){var i,n=[],r=this.multiselection.nodes.slice();n.push({text:Object(d.c)("duplicateText"),title:Object(d.c)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){E.onDuplicate(r)}}),n.push({text:Object(d.c)("remove"),title:Object(d.c)("removeTitle"),className:"jsoneditor-remove",click:function(){E.onRemove(r)}}),this.options.onCreateMenu&&(i=r.map(function(e){return e.getPath()}),n=this.options.onCreateMenu(n,{type:"multiple",path:i[0],paths:i})),new u.a(n,{close:t}).show(e,this.getPopupAnchor())},H.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},H.getSelection=function(){var e,t,i={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],t=this.multiselection.nodes[this.multiselection.nodes.length-1],"down"===this.multiselection.direction?(i.start=e.serialize(),i.end=t.serialize()):(i.start=t.serialize(),i.end=e.serialize())),i},H.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=Object(W.debounce)(e,this.DEBOUNCE_INTERVAL))},H.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},H._getNodeInstancesByRange=function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var r=[];if(i instanceof E)if(n instanceof E&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var o=e;for(r.push(o);o=o.nextSibling(),r.push(o),o&&o!==t;);}else r=this._findTopLevelNodes(i,n);else r.push(i);return r},H.getNodesByRange=function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n};var P=[{mode:"tree",mixin:H,data:"json"},{mode:"view",mixin:H,data:"json"},{mode:"form",mixin:H,data:"json"}]},function(e,t,i){"use strict";i.r(t),i.d(t,"previewModeMixins",function(){return c});var u=i(1),g=i(8),p=i(15),n=i(5),a=i(6),r=i(21),m=i(2),f=i(9),C=i(0);function o(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var v=function(){function n(e,t,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,n),this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=i,this.items=[],this.index=-1}var e,t,i;return e=n,(t=[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,i=0;return this.items.forEach(function(e){i+=t(e)}),i}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,
this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&o(e.prototype,t),i&&o(e,i),n}(),I=i(4),s=r.textModeMixins[0].mixin,l={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,t.createQuery=t.createQuery||I.a,t.executeQuery=t.executeQuery||I.b,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,Object(u.b)(this.options.languages),Object(u.a)(this.options.language),this.mode="preview";var i=this;this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=Object(C.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()};var n,r,o,s,a,l,c,h,d={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new f.a(d),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&(Object(C.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(n=document.createElement("button")).type="button",n.className="jsoneditor-format",n.title=Object(u.c)("formatTitle"),this.menu.appendChild(n),n.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(e){i._onError(e)}},"formatting...")},(r=document.createElement("button")).type="button",r.className="jsoneditor-compact",r.title=Object(u.c)("compactTitle"),this.menu.appendChild(r),r.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(e){i._onError(e)}},"compacting...")},this.options.enableSort&&((o=document.createElement("button")).type="button",o.className="jsoneditor-sort",o.title=Object(u.c)("sortTitleShort"),o.onclick=function(){i._showSortModal()},this.menu.appendChild(o)),this.options.enableTransform&&((s=document.createElement("button")).type="button",s.title=Object(u.c)("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){i._showTransformModal()},this.dom.transform=s,this.menu.appendChild(s)),(a=document.createElement("button")).type="button",a.className="jsoneditor-repair",a.title=Object(u.c)("repairTitle"),this.menu.appendChild(a),!(a.onclick=function(){void 0===i.json&&i.executeWithBusyMessage(function(){try{i.repair()}catch(e){i._onError(e)}},"repairing...")})!==this.options.history&&(this.history=new v(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(e){return 2*e.text.length},m.c),(l=document.createElement("button")).type="button",l.className="jsoneditor-undo jsoneditor-separator",l.title=Object(u.c)("undo"),l.onclick=function(){var e=i.history.undo();e&&i._applyHistory(e)},this.menu.appendChild(l),this.dom.undo=l,(c=document.createElement("button")).type="button",c.className="jsoneditor-redo",c.title=Object(u.c)("redo"),c.onclick=function(){var e=i.history.redo();e&&i._applyHistory(e)},this.menu.appendChild(c),this.dom.redo=c,this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new g.a(this.menu,this.options.modes,this.options.mode,function(e){i.setMode(e),i.modeSwitcher.focus()}))),this.errorTable=new p.a({errorTableVisible:!0,onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(e){var t=e+(i.dom.statusBar?i.dom.statusBar.clientHeight:0)+1;i.content.style.marginBottom=-t+"px",i.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar&&(Object(C.addClassName)(this.content,"has-status-bar"),h=document.createElement("div"),(this.dom.statusBar=h).className="jsoneditor-statusbar",this.frame.appendChild(h),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",h.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",h.appendChild(this.dom.arrayInfo),h.appendChild(this.errorTable.getErrorCounter()),h.appendChild(this.errorTable.getWarningIcon()),h.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=Object(C.limitCharacters)(e,m.b),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+Object(C.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}};l._showSortModal=function(){var s=this;this.executeWithBusyMessage(function(){var e=s.options.modalAnchor||m.a,o=s.get();s._renderPreview(),Object(n.showSortModal)(e,o,function(r){s.executeWithBusyMessage(function(){var e,t,i,n;e=o,t=r,Array.isArray(e)&&(i=Object(C.sort)(e,t.path,t.direction),s.sortedBy=t,s._setAndFireOnChange(i)),Object(C.isObject)(e)&&(n=Object(C.sortObjectKeys)(e,t.direction),s.sortedBy=t,s._setAndFireOnChange(n))},"sorting...")},s.sortedBy)},"parsing...")},l._showTransformModal=function(){var s=this;this.executeWithBusyMessage(function(){var e=s.options,t=e.createQuery,i=e.executeQuery,n=e.modalAnchor,r=e.queryDescription,o=s.get();s._renderPreview(),Object(a.showTransformModal)({anchor:n||m.a,json:o,queryDescription:r,createQuery:t,executeQuery:i,onTransform:function(t){s.executeWithBusyMessage(function(){var e=i(o,t);s._setAndFireOnChange(e)},"transforming...")}})},"parsing...")},l.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},l.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},l.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},l.repair=function(){var e=this.getText(),t=Object(C.repair)(e);this._setTextAndFireOnChange(t)},l.focus=function(){this.dom.transform.focus()},l.set=function(e){this.history&&this.history.clear(),this._set(e)},l.update=function(e){this._set(e)},l._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},l._setAndFireOnChange=function(e){this._set(e),this._onChange()},l.get=function(){var e;return void 0===this.json&&(e=this.getText(),this.json=Object(C.parse)(e)),this.json},l.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=Object(C.escapeUnicodeChars)(this.text))),this.text},l.setText=function(e){this.history&&this.history.clear(),this._setText(e)},l.updateText=function(e){this.getText()!==e&&this._setText(e)},l._setText=function(e,t){var i;!0===this.options.escapeUnicode?this.text=Object(C.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json?(i=this).executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch(e){}},"parsing..."):this._pushHistory(),this._debouncedValidate()},l._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},l._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},l._pushHistory=function(){var e;this.history&&(e={text:this.text,json:this.json},this.history.add(e))},l.executeWithBusyMessage=function(e,t){var i;this.getText().length>m.d?(i=this,Object(C.addClassName)(i.frame,"busy"),i.dom.busyContent.innerText=t,setTimeout(function(){e(),Object(C.removeClassName)(i.frame,"busy"),i.dom.busyContent.innerText=""},100)):e()},l.validate=s.validate,l._renderErrors=s._renderErrors;var c=[{mode:"preview",mixin:l,data:"json"}]}],r.c=n,r.d=function(e,t,i){r.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r.t=function(t,e){if(1&e&&(t=r(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(r.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)r.d(i,n,function(e){return t[e]}.bind(null,n));return i},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=36);function r(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return i[e].call(t.exports,t,t.exports,r),t.l=!0,t.exports}var i,n});
//# sourceMappingURL=jsoneditor.map