#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['recon']

package_data = \
{'': ['*']}

install_requires = \
['pydantic == 1.4', 'spacy >= 2.2.1, <3.0.0', 'typer >= 0.0.8', 'tqdm']

extras_require = \
{'all': ['colorama', 'click-completion'],
 'dev': ['jupyterlab >= 1.2.0, <1.3'],
 'doc': ['mkdocs', 'mkdocs-material', 'markdown-include', 'mkautodoc'],
 'test': ['pytest >=4.4.0',
          'pytest-cov',
          'coverage',
          'pytest-xdist',
          'pytest-sugar',
          'mypy',
          'black',
          'isort']}

setup(name='reconner',
      version='0.1.2',
      description='ReconNER, Debug annotated Named Entity Recognition (NER) data for inconsitencies and get insights on improving the quality of your data.',
      author='Kabir Khan',
      author_email='kakh@microsoft.com',
      url='https://github.com/microsoft/reconner',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
