# Generated by Django 4.0.3 on 2022-03-02 19:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import rules.contrib.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Quote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('public', models.BooleanField(default=False, help_text='Is this a public source available for any user to view?')),
                ('allow_submissions', models.BooleanField(default=False, help_text='Allow submissions from other users?')),
                ('quote', models.CharField(help_text='Plain text representation of quote. You can use Markdown here.', max_length=280)),
                ('quote_rendered', models.TextField(blank=True, help_text='HTML rendered version of quote generated from quote plain text.', null=True)),
                ('citation', models.CharField(blank=True, help_text='Where is this quote from? Episode #, book?', max_length=250, null=True)),
                ('citation_url', models.URLField(blank=True, help_text='URL for citation, if applicable.', null=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            bases=(rules.contrib.models.RulesModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('public', models.BooleanField(default=False, help_text='Is this a public source available for any user to view?')),
                ('allow_submissions', models.BooleanField(default=False, help_text='Allow submissions from other users?')),
                ('name', models.CharField(help_text='Name of the character', max_length=100)),
                ('slug', models.SlugField(blank=True, help_text='Global slug of the character, will be auto generated from name and group if not overridden.', max_length=250, unique=True)),
                ('description', models.TextField(blank=True, help_text='Description of this character. You can style this with Markdown.', null=True)),
                ('description_rendered', models.TextField(blank=True, help_text='Automatically generated from description.', null=True)),
                ('allow_markov', models.BooleanField(default=False, help_text='Allow to be used in markov chains?')),
            ],
            bases=(rules.contrib.models.RulesModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='SourceStats',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('quotes_requested', models.PositiveIntegerField(default=0, help_text='Number of time child quotes have been requested.')),
                ('quotes_generated', models.PositiveIntegerField(default=0, help_text='Number of times markov generated quotes have been requested.')),
                ('source', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='stats', to='django_quotes.source')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SourceMarkovModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('data', models.JSONField(blank=True, null=True)),
                ('source', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='django_quotes.source')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SourceGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('public', models.BooleanField(default=False, help_text='Is this a public source available for any user to view?')),
                ('allow_submissions', models.BooleanField(default=False, help_text='Allow submissions from other users?')),
                ('name', models.CharField(db_index=True, help_text='A source for individuals making the quotes. Use as an abstract grouping.', max_length=50, unique=True, verbose_name='Source Name')),
                ('description', models.TextField(blank=True, help_text='Description for the source. You can style using Markdown.', null=True)),
                ('description_rendered', models.TextField(blank=True, help_text='Automatically generated from description', null=True)),
                ('slug', models.SlugField(blank=True, help_text='Unique slug for this group.', max_length=70, unique=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['name'],
            },
            bases=(rules.contrib.models.RulesModelMixin, models.Model),
        ),
        migrations.AddField(
            model_name='source',
            name='group',
            field=models.ForeignKey(help_text='The group this character belongs to.', on_delete=django.db.models.deletion.CASCADE, to='django_quotes.sourcegroup'),
        ),
        migrations.AddField(
            model_name='source',
            name='owner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='QuoteStats',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('times_used', models.PositiveIntegerField(default=0, help_text='Times used for random quotes, etc.')),
                ('quote', models.OneToOneField(help_text='The Quote the stats related to.', on_delete=django.db.models.deletion.CASCADE, related_name='stats', to='django_quotes.quote')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='quote',
            name='source',
            field=models.ForeignKey(help_text='The source of this quote, i.e. name.', on_delete=django.db.models.deletion.CASCADE, to='django_quotes.source'),
        ),
        migrations.CreateModel(
            name='GroupStats',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('quotes_requested', models.PositiveIntegerField(default=0, help_text='Number of time child quotes have been requested.')),
                ('quotes_generated', models.PositiveIntegerField(default=0, help_text='Number of times markov generated quotes have been requested.')),
                ('group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='stats', to='django_quotes.sourcegroup')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMarkovModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('data', models.JSONField(blank=True, help_text='The cached markov model as JSON.', null=True)),
                ('group', models.OneToOneField(help_text='The character group this model belongs to.', on_delete=django.db.models.deletion.CASCADE, to='django_quotes.sourcegroup')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
