# Generated by Finn Stutzenstein on 2020-11-24 06:44

from django.db import migrations


def votes_to_y(apps, schema_editor):
    AssignmentPoll = apps.get_model("assignments", "AssignmentPoll")
    for poll in AssignmentPoll.objects.all():
        changed = False
        if poll.pollmethod == "votes":
            poll.pollmethod = "Y"
            changed = True

        if poll.onehundred_percent_base == "votes":
            poll.onehundred_percent_base = "Y"
            changed = True

        if changed:
            poll.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [
        ("assignments", "0016_negative_votes"),
    ]

    operations = [
        migrations.RunPython(votes_to_y),
    ]
