# Generated by Django 2.1.7 on 2019-04-25 07:00

from django.db import migrations


def move_speakers_to_own_model(apps, schema_editor):
    """
    Create a list of speaker for every item that exists. Move the speakers over to
    the new list of speakers.
    """
    Item = apps.get_model("agenda", "Item")
    Speaker = apps.get_model("agenda", "Speaker")
    ListOfSpeakers = apps.get_model("agenda", "ListOfSpeakers")

    for item in Item.objects.all():
        los = ListOfSpeakers(
            content_type=item.content_type,
            object_id=item.object_id,
            closed=item.speaker_list_closed,
        )
        los.save(skip_autoupdate=True)

    for speaker in Speaker.objects.all():
        speaker.list_of_speakers = ListOfSpeakers.objects.get(
            object_id=speaker.item.object_id, content_type=speaker.item.content_type
        )
        speaker.save(skip_autoupdate=True)


def add_speakers_to_mediafiles(apps, schema_editor):
    """
    Adds lists of speakers for all mediafiles.
    """
    ListOfSpeakers = apps.get_model("agenda", "ListOfSpeakers")
    ContentType = apps.get_model("contenttypes", "ContentType")
    Mediafile = apps.get_model("mediafiles", "Mediafile")

    mediafile_content_type = ContentType.objects.get_for_model(Mediafile)
    for mediafile in Mediafile.objects.all():
        los = ListOfSpeakers(
            content_type=mediafile_content_type, object_id=mediafile.pk
        )
        los.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [
        ("agenda", "0007_list_of_speakers_1"),
        ("mediafiles", "0003_auto_20190119_1425"),
    ]

    operations = [
        migrations.RunPython(move_speakers_to_own_model),
        migrations.RunPython(add_speakers_to_mediafiles),
    ]
