# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/023_CLI.ipynb.

# %% auto 0
__all__ = ['logger', 'run']

# %% ../nbs/023_CLI.ipynb 1
import asyncio
import multiprocessing
from typing import *

import typer

from . import _cli_docs, _cli_testing
from ._components.logger import get_logger
from ._server import run_fastkafka_server

# %% ../nbs/023_CLI.ipynb 5
logger = get_logger(__name__)

# %% ../nbs/023_CLI.ipynb 8
_app = typer.Typer(help="")

# %% ../nbs/023_CLI.ipynb 9
@_app.command(
    help="Runs Fast Kafka API application",
)
def run(
    num_workers: int = typer.Option(
        multiprocessing.cpu_count(),
        help="Number of FastKafka instances to run, defaults to number of CPU cores.",
    ),
    app: str = typer.Argument(
        ...,
        help="input in the form of 'path:app', where **path** is the path to a python file and **app** is an object of type **FastKafka**.",
    ),
    kafka_broker: str = typer.Option(
        ...,
        help="kafka_broker, one of the keys of the kafka_brokers dictionary passed in the constructor of FastaKafka class.",
    ),
) -> None:
    try:
        asyncio.run(
            run_fastkafka_server(
                num_workers=num_workers, app=app, kafka_broker=kafka_broker
            )
        )
    except Exception as e:
        typer.secho(f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)

# %% ../nbs/023_CLI.ipynb 13
_app.add_typer(_cli_docs._docs_app, name="docs")

# %% ../nbs/023_CLI.ipynb 21
_app.add_typer(_cli_testing._testing_app, name="testing")
