"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const assert_1 = require("@aws-cdk/assert");
const kms = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const secret = require("../lib");
test('Create key pair based on RSA private key', () => {
    const stack = new core_1.Stack();
    const key = new kms.Key(stack, 'TestKey', {
        enableKeyRotation: false,
        description: 'Key to encrypt all secrets with',
        alias: 'alias/test/key',
    });
    const secretProvider = new secret.Provider(stack, 'SecretProvider', {});
    if (secretProvider.fn.role) {
        key.grantEncryptDecrypt(secretProvider.fn.role);
    }
    const privateKey = secretProvider.rsaKey(stack, 'PrivateKey', {
        name: 'PrivateKey',
        version: 'v1',
        keyAlias: 'alias/test/key',
    });
    privateKey.node.addDependency(key);
    secretProvider.keyPair(stack, 'KeyPair', {
        name: 'KeyPair',
        publicKeyMaterial: privateKey.publicKey,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
    expect(stack).toHaveResource('Custom::RSAKey', {
        'KeyAlias': 'alias/test/key',
        'Name': 'PrivateKey',
        'Version': 'v1',
    });
    expect(stack).toHaveResource('Custom::KeyPair', {
        'Name': 'KeyPair',
    });
});
//# sourceMappingURL=data:application/json;base64,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