"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const secret = require("../lib");
test('Create Secret provider', () => {
    const stack = new core_1.Stack();
    new secret.Provider(stack, 'SecretProvider', {});
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
    expect(stack).toHaveResource('AWS::KMS::Key');
    expect(stack).toHaveResource('AWS::KMS::Alias', {
        'AliasName': 'alias/cmk/cfn-secrets'
    });
    expect(stack).toHaveResource('AWS::Lambda::Function', {
        'Code': {
            'S3Bucket': 'binxio-public',
            'S3Key': 'lambdas/cfn-secret-provider-1.0.0.zip',
        }
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvdmlkZXIudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInByb3ZpZGVyLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFFOUIsNENBQTZDO0FBQzdDLHdDQUFzQztBQUV0QyxpQ0FBa0M7QUFFbEMsSUFBSSxDQUFDLHdCQUF3QixFQUFFLEdBQUcsRUFBRTtJQUNoQyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO0lBRTFCLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsZ0JBQWdCLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFFakQsTUFBTSxDQUFDLG1CQUFVLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztJQUU3RCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQzlDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxjQUFjLENBQUMsaUJBQWlCLEVBQUU7UUFDNUMsV0FBVyxFQUFFLHVCQUF1QjtLQUN2QyxDQUFDLENBQUM7SUFDSCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLHVCQUF1QixFQUFFO1FBQ2xELE1BQU0sRUFBRTtZQUNKLFVBQVUsRUFBRSxlQUFlO1lBQzNCLE9BQU8sRUFBRSx1Q0FBdUM7U0FDbkQ7S0FDSixDQUFDLENBQUM7QUFFUCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuXG5pbXBvcnQgeyBTeW50aFV0aWxzIH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmltcG9ydCBzZWNyZXQgPSByZXF1aXJlKCcuLi9saWInKTtcblxudGVzdCgnQ3JlYXRlIFNlY3JldCBwcm92aWRlcicsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgbmV3IHNlY3JldC5Qcm92aWRlcihzdGFjaywgJ1NlY3JldFByb3ZpZGVyJywge30pO1xuXG4gICAgZXhwZWN0KFN5bnRoVXRpbHMudG9DbG91ZEZvcm1hdGlvbihzdGFjaykpLnRvTWF0Y2hTbmFwc2hvdCgpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50b0hhdmVSZXNvdXJjZSgnQVdTOjpLTVM6OktleScpO1xuICAgIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2UoJ0FXUzo6S01TOjpBbGlhcycsIHtcbiAgICAgICAgJ0FsaWFzTmFtZSc6ICdhbGlhcy9jbWsvY2ZuLXNlY3JldHMnXG4gICAgfSk7XG4gICAgZXhwZWN0KHN0YWNrKS50b0hhdmVSZXNvdXJjZSgnQVdTOjpMYW1iZGE6OkZ1bmN0aW9uJywge1xuICAgICAgICAnQ29kZSc6IHtcbiAgICAgICAgICAgICdTM0J1Y2tldCc6ICdiaW54aW8tcHVibGljJyxcbiAgICAgICAgICAgICdTM0tleSc6ICdsYW1iZGFzL2Nmbi1zZWNyZXQtcHJvdmlkZXItMS4wLjAuemlwJyxcbiAgICAgICAgfVxuICAgIH0pO1xuXG59KTtcbiJdfQ==