"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class SecretManagerSecret extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        this.versionId = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const key = new cfn.CustomResource(this, 'SecretsManagerSecret', {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: 'Custom::SecretsManagerSecret',
            properties: common.makeProperties(props),
        });
        this.versionId = key.getAttString('VersionId');
    }
}
exports.SecretManagerSecret = SecretManagerSecret;
//# sourceMappingURL=data:application/json;base64,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