"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class Secret extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        this.arn = '';
        this.secret = '';
        this.hash = '';
        this.version = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const key = new cfn.CustomResource(this, 'Secret', {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: 'Custom::Secret',
            properties: common.makeProperties(props),
        });
        this.arn = key.getAttString('Arn');
        this.secret = key.getAttString('Secret');
        this.hash = key.getAttString('Hash');
        this.version = key.getAttString('Version');
    }
    grantRead(grantee) {
        const result = iam.Grant.addToPrincipal({
            grantee,
            actions: ['ssm:GetParameter'],
            resourceArns: [this.arn],
            scope: this
        });
        return result;
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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