import iam = require('@aws-cdk/aws-iam');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import common = require('./common');
export interface SecretProps extends common.CommonProps {
    /**
    * The name of the secret in the parameter store
    */
    readonly name: string;
    /**
    * The description of the secret in the parameter store
    * @default - ''
    */
    readonly description?: string;
    /**
    * The alphabet of characters from which to generate a secret
    * @default - Defaults to ASCII letters, digits and punctuation characters
    */
    readonly alphabet?: string;
    /**
    * The length of the secret
    * @default - 30
    */
    readonly length?: number;
    /**
    * The KMS key to use to encrypt the secret with
    * @default - 'alias/aws/ssm'
    */
    readonly keyAlias?: string;
    /**
    * Return the secret as an attribute
    * @default - false
    */
    readonly returnSecret?: boolean;
    /**
    * Generate a new secret on update
    * @default - false
    */
    readonly refreshOnUpdate?: boolean;
    /**
    * Indicates whether output of the return values is replaced by *****
    * @default - true
    */
    readonly noEcho?: boolean;
    /**
    * Base64 encoded KMS encoded secret, to be decrypted before stored
    * @default - ''
    */
    readonly encryptedContent?: string;
    /**
    * Plain text secret to be stored
    * @default - ''
    */
    readonly content?: string;
}
export declare class Secret extends cdk.Construct {
    readonly arn: string;
    readonly secret: string;
    readonly hash: string;
    readonly version: string;
    constructor(scope: cdk.Construct, id: string, props: SecretProps, provider?: lambda.IFunction);
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
