"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class RSAKey extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        this.arn = '';
        this.publicKey = '';
        this.publicKeyPEM = '';
        this.hash = '';
        this.version = '';
        this.name = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const key = new cfn.CustomResource(this, 'RSAKey', {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: 'Custom::RSAKey',
            properties: common.makeProperties(props),
        });
        this.arn = key.getAttString('Arn');
        this.publicKey = key.getAttString('PublicKey');
        this.publicKeyPEM = key.getAttString('PublicKeyPEM');
        this.hash = key.getAttString('Hash');
        this.version = key.getAttString('Version');
        this.name = props.name;
    }
    grantRead(grantee) {
        const result = iam.Grant.addToPrincipal({
            grantee,
            actions: ['ssm:GetParameter'],
            resourceArns: [this.arn],
            scope: this
        });
        return result;
    }
}
exports.RSAKey = RSAKey;
//# sourceMappingURL=data:application/json;base64,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