import iam = require('@aws-cdk/aws-iam');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import dsaKey = require('./dsa-key');
export declare enum KeyFormat {
    PKCS8 = "PKCS8",
    TRADITIONAL_OPEN_SSL = "TraditionalOpenSSL"
}
export interface RSAKeyProps extends dsaKey.DSAKeyProps {
    /**
    * Encoding type of the private key
    *
    * @default - 2048
    */
    readonly keyFormat?: KeyFormat;
}
export declare class RSAKey extends cdk.Construct {
    readonly arn: string;
    readonly publicKey: string;
    readonly publicKeyPEM: string;
    readonly hash: string;
    readonly version: string;
    readonly name: string;
    constructor(scope: cdk.Construct, id: string, props: RSAKeyProps, provider?: lambda.IFunction);
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
