"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class KeyPair extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        this.arn = '';
        this.name = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const keyPair = new cfn.CustomResource(this, "KeyPair", {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: "Custom::KeyPair",
            properties: common.makeProperties(props)
        });
        this.arn = keyPair.getAttString('Arn');
        this.name = keyPair.getAttString('Name');
    }
}
exports.KeyPair = KeyPair;
//# sourceMappingURL=data:application/json;base64,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