import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import common = require('./common');
export interface KeyPairProps extends common.CommonProps {
    /**
    * The name of the value in the parameters store
    */
    readonly name: string;
    /**
    * The public key to import
    */
    readonly publicKeyMaterial: string;
}
export declare class KeyPair extends cdk.Construct {
    readonly arn: string;
    readonly name: string;
    constructor(scope: cdk.Construct, id: string, props: KeyPairProps, provider?: lambda.IFunction);
}
