"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const kms = require("@aws-cdk/aws-kms");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const accessKey = require("./access-key");
const dsaKey = require("./dsa-key");
const keyPair = require("./key-pair");
const rsaKey = require("./rsa-key");
const secret = require("./secret");
const secretManagerSecret = require("./secretmanager-secret");
__export(require("./access-key"));
__export(require("./dsa-key"));
__export(require("./rsa-key"));
__export(require("./key-pair"));
__export(require("./secret"));
__export(require("./secretmanager-secret"));
__export(require("./common"));
class Provider extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.key = new kms.Key(this, 'Key', {
            enableKeyRotation: true,
            description: 'Used for encryption of secrets in CloudFormation templates',
            alias: 'alias/cmk/cfn-secrets',
            removalPolicy: cdk.RemovalPolicy.DESTROY
        });
        let code = props.code;
        if (!code) {
            const bucket = s3.Bucket.fromBucketName(this, 'binxio-public', 'binxio-public');
            code = new lambda.S3Code(bucket, 'lambdas/cfn-secret-provider-1.0.0.zip');
        }
        this.fn = new lambda.SingletonFunction(this, 'Provider', {
            uuid: '2328c719-05b8-4945-84c1-82c4142f0997',
            description: 'CloudFormation Custom:Secret implementation',
            runtime: lambda.Runtime.PYTHON_3_7,
            handler: 'secrets.handler',
            code: code,
        });
        if (this.fn.role) {
            this.fn.role.attachInlinePolicy(new iam.Policy(this, 'Policy', {
                statements: [
                    new iam.PolicyStatement({
                        actions: [
                            'iam:CreateAccessKey',
                            'iam:DeleteAccessKey',
                            'iam:UpdateAccessKey',
                            'ssm:PutParameter',
                            'ssm:GetParameter',
                            'ssm:DeleteParameter',
                            'ec2:ImportKeyPair',
                            'ec2:DeleteKeyPair',
                            'secretsmanager:DeleteSecret',
                            'secretsmanager:CreateSecret',
                            'secretsmanager:UpdateSecret',
                        ],
                        resources: ['*'],
                    }),
                    new iam.PolicyStatement({
                        actions: ['logs:*',],
                        resources: ['*'],
                    }),
                ]
            }));
            this.key.grantEncrypt(this.fn.role);
        }
    }
    dsaKey(scope, id, props) {
        return new dsaKey.DSAKey(scope, id, props, this.fn);
    }
    rsaKey(scope, id, props) {
        return new rsaKey.RSAKey(scope, id, props, this.fn);
    }
    keyPair(scope, id, props) {
        return new keyPair.KeyPair(scope, id, props, this.fn);
    }
    accessKey(scope, id, props) {
        return new accessKey.AccessKey(scope, id, props, this.fn);
    }
    secret(scope, id, props) {
        return new secret.Secret(scope, id, props, this.fn);
    }
    secretManagerSecret(scope, id, props) {
        return new secretManagerSecret.SecretManagerSecret(scope, id, props, this.fn);
    }
}
exports.Provider = Provider;
//# sourceMappingURL=data:application/json;base64,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