import kms = require('@aws-cdk/aws-kms');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import accessKey = require('./access-key');
import dsaKey = require('./dsa-key');
import keyPair = require('./key-pair');
import rsaKey = require('./rsa-key');
import secret = require('./secret');
import secretManagerSecret = require('./secretmanager-secret');
export * from './access-key';
export * from './dsa-key';
export * from './rsa-key';
export * from './key-pair';
export * from './secret';
export * from './secretmanager-secret';
export * from './common';
export interface ProviderProps {
    /**
    * Code for the Provider lambda function
    *
    * @default - Use code from s3 bucket binxio-public
    */
    readonly code?: lambda.Code;
}
export declare class Provider extends cdk.Construct {
    readonly key: kms.Key;
    readonly fn: lambda.SingletonFunction;
    constructor(scope: cdk.Construct, id: string, props: ProviderProps);
    dsaKey(scope: cdk.Construct, id: string, props: dsaKey.DSAKeyProps): dsaKey.DSAKey;
    rsaKey(scope: cdk.Construct, id: string, props: rsaKey.RSAKeyProps): rsaKey.RSAKey;
    keyPair(scope: cdk.Construct, id: string, props: keyPair.KeyPairProps): keyPair.KeyPair;
    accessKey(scope: cdk.Construct, id: string, props: accessKey.AccessKeyProps): accessKey.AccessKey;
    secret(scope: cdk.Construct, id: string, props: secret.SecretProps): secret.Secret;
    secretManagerSecret(scope: cdk.Construct, id: string, props: secretManagerSecret.SecretManagerSecretProps): secretManagerSecret.SecretManagerSecret;
}
