"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class DSAKey extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        this.arn = '';
        this.publicKey = '';
        this.publicKeyPEM = '';
        this.hash = '';
        this.version = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const key = new cfn.CustomResource(this, 'DSAKey', {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: 'Custom::DSAKey',
            properties: common.makeProperties(props),
        });
        this.arn = key.getAttString('Arn');
        this.publicKey = key.getAttString('PublicKey');
        this.publicKeyPEM = key.getAttString('PublicKeyPEM');
        this.hash = key.getAttString('Hash');
        this.version = key.getAttString('Version');
    }
    grantRead(grantee) {
        const result = iam.Grant.addToPrincipal({
            grantee,
            actions: ['ssm:GetParameter'],
            resourceArns: [this.arn],
            scope: this
        });
        return result;
    }
}
exports.DSAKey = DSAKey;
//# sourceMappingURL=data:application/json;base64,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