import iam = require('@aws-cdk/aws-iam');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import common = require('./common');
export interface DSAKeyProps extends common.CommonProps {
    /**
    * The name of the private key in the parameter store
    */
    readonly name: string;
    /**
    * The description of the key in the parameter store
    * @default - ''
    */
    readonly description?: string;
    /**
    * The KMS key to use to encrypt the key with
    * @default - 'alias/aws/ssm'
    */
    readonly keyAlias?: string;
    /**
    * Number of bits in the key
    *
    * @default - 2048
    */
    readonly keySize?: number;
    /**
    * Generate a new secret on update
    *
    * @default - false
    */
    readonly refreshOnUpdate?: boolean;
}
export declare class DSAKey extends cdk.Construct {
    readonly arn: string;
    readonly publicKey: string;
    readonly publicKeyPEM: string;
    readonly hash: string;
    readonly version: string;
    constructor(scope: cdk.Construct, id: string, props: DSAKeyProps, provider?: lambda.IFunction);
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
