"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const cdk = require("@aws-cdk/core");
const common = require("./common");
class AccessKey extends cdk.Construct {
    constructor(scope, id, props, provider) {
        super(scope, id);
        //public readonly AccessKeyId: string;
        this.smtpPassword = '';
        this.secretAccessKey = '';
        if (!provider) {
            provider = props.provider;
        }
        if (!provider) {
            this.node.addError('provider is required');
            return;
        }
        const key = new cfn.CustomResource(this, 'AccessKey', {
            provider: cfn.CustomResourceProvider.fromLambda(provider),
            resourceType: 'Custom::AccessKey',
            properties: common.makeProperties(props),
        });
        //this.AccessKeyId = key.getAttString('AccessKeyId'); //currently missing in lambda
        this.smtpPassword = key.getAttString('SMTPPassword');
        this.secretAccessKey = key.getAttString('SecretAccessKey');
    }
}
exports.AccessKey = AccessKey;
//# sourceMappingURL=data:application/json;base64,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