"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const secret = require("../../lib");
class KeyPairStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // we want to create a KMS key first, which will be used to encrypt all secrets
        const key = new kms.Key(this, 'EncryptionKey', {
            enableKeyRotation: false,
            description: 'Key to encrypt all secrets with',
            alias: 'alias/test/key',
        });
        // now we create the provider and allow it to use the previously created KMS key
        const secretProvider = new secret.Provider(this, 'SecretProvider', {});
        if (secretProvider.fn.role) {
            key.grantEncryptDecrypt(secretProvider.fn.role);
        }
        // the secretProvider object now provides methods for creating secrets
        // first let's create an RSA key
        const privateKey = secretProvider.rsaKey(this, 'RsaKey', {
            name: 'RsaKey',
            keyAlias: 'alias/test/key',
        });
        // because the KMS key is (currently) referenced by its alias name there
        // ain't to implicit dependency and we need to set an explicit one
        privateKey.node.addDependency(key);
        // using the above RSA key we now can create a key pair
        secretProvider.keyPair(this, 'KeyPair', {
            name: 'KeyPair',
            publicKeyMaterial: privateKey.publicKey,
        });
    }
}
exports.KeyPairStack = KeyPairStack;
//# sourceMappingURL=data:application/json;base64,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