# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.10.0
    Contact: me@ariesclark.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class CurrentUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accepted_tos_version': 'int',
        'account_deletion_date': 'date',
        'active_friends': 'list[str]',
        'allow_avatar_copying': 'bool',
        'bio': 'str',
        'bio_links': 'list[str]',
        'current_avatar': 'str',
        'current_avatar_asset_url': 'str',
        'current_avatar_image_url': 'str',
        'current_avatar_thumbnail_image_url': 'str',
        'date_joined': 'date',
        'developer_type': 'DeveloperType',
        'display_name': 'str',
        'email_verified': 'bool',
        'fallback_avatar': 'str',
        'friend_group_names': 'list[str]',
        'friend_key': 'str',
        'friends': 'list[str]',
        'has_birthday': 'bool',
        'has_email': 'bool',
        'has_logged_in_from_client': 'bool',
        'has_pending_email': 'bool',
        'home_location': 'str',
        'id': 'str',
        'is_friend': 'bool',
        'last_login': 'datetime',
        'last_platform': 'str',
        'obfuscated_email': 'str',
        'obfuscated_pending_email': 'str',
        'oculus_id': 'str',
        'offline_friends': 'list[str]',
        'online_friends': 'list[str]',
        'past_display_names': 'list[PastDisplayName]',
        'profile_pic_override': 'str',
        'state': 'UserState',
        'status': 'UserStatus',
        'status_description': 'str',
        'status_first_time': 'bool',
        'status_history': 'list[str]',
        'steam_details': 'object',
        'steam_id': 'str',
        'tags': 'list[str]',
        'two_factor_auth_enabled': 'bool',
        'two_factor_auth_enabled_date': 'datetime',
        'unsubscribe': 'bool',
        'user_icon': 'str',
        'username': 'str'
    }

    attribute_map = {
        'accepted_tos_version': 'acceptedTOSVersion',
        'account_deletion_date': 'accountDeletionDate',
        'active_friends': 'activeFriends',
        'allow_avatar_copying': 'allowAvatarCopying',
        'bio': 'bio',
        'bio_links': 'bioLinks',
        'current_avatar': 'currentAvatar',
        'current_avatar_asset_url': 'currentAvatarAssetUrl',
        'current_avatar_image_url': 'currentAvatarImageUrl',
        'current_avatar_thumbnail_image_url': 'currentAvatarThumbnailImageUrl',
        'date_joined': 'date_joined',
        'developer_type': 'developerType',
        'display_name': 'displayName',
        'email_verified': 'emailVerified',
        'fallback_avatar': 'fallbackAvatar',
        'friend_group_names': 'friendGroupNames',
        'friend_key': 'friendKey',
        'friends': 'friends',
        'has_birthday': 'hasBirthday',
        'has_email': 'hasEmail',
        'has_logged_in_from_client': 'hasLoggedInFromClient',
        'has_pending_email': 'hasPendingEmail',
        'home_location': 'homeLocation',
        'id': 'id',
        'is_friend': 'isFriend',
        'last_login': 'last_login',
        'last_platform': 'last_platform',
        'obfuscated_email': 'obfuscatedEmail',
        'obfuscated_pending_email': 'obfuscatedPendingEmail',
        'oculus_id': 'oculusId',
        'offline_friends': 'offlineFriends',
        'online_friends': 'onlineFriends',
        'past_display_names': 'pastDisplayNames',
        'profile_pic_override': 'profilePicOverride',
        'state': 'state',
        'status': 'status',
        'status_description': 'statusDescription',
        'status_first_time': 'statusFirstTime',
        'status_history': 'statusHistory',
        'steam_details': 'steamDetails',
        'steam_id': 'steamId',
        'tags': 'tags',
        'two_factor_auth_enabled': 'twoFactorAuthEnabled',
        'two_factor_auth_enabled_date': 'twoFactorAuthEnabledDate',
        'unsubscribe': 'unsubscribe',
        'user_icon': 'userIcon',
        'username': 'username'
    }

    def __init__(self, accepted_tos_version=None, account_deletion_date=None, active_friends=None, allow_avatar_copying=None, bio=None, bio_links=None, current_avatar=None, current_avatar_asset_url=None, current_avatar_image_url=None, current_avatar_thumbnail_image_url=None, date_joined=None, developer_type=None, display_name=None, email_verified=None, fallback_avatar=None, friend_group_names=None, friend_key=None, friends=None, has_birthday=None, has_email=None, has_logged_in_from_client=None, has_pending_email=None, home_location=None, id=None, is_friend=False, last_login=None, last_platform=None, obfuscated_email=None, obfuscated_pending_email=None, oculus_id=None, offline_friends=None, online_friends=None, past_display_names=None, profile_pic_override=None, state=None, status=None, status_description=None, status_first_time=None, status_history=None, steam_details=None, steam_id=None, tags=None, two_factor_auth_enabled=None, two_factor_auth_enabled_date=None, unsubscribe=None, user_icon=None, username=None, local_vars_configuration=None):  # noqa: E501
        """CurrentUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._accepted_tos_version = None
        self._account_deletion_date = None
        self._active_friends = None
        self._allow_avatar_copying = None
        self._bio = None
        self._bio_links = None
        self._current_avatar = None
        self._current_avatar_asset_url = None
        self._current_avatar_image_url = None
        self._current_avatar_thumbnail_image_url = None
        self._date_joined = None
        self._developer_type = None
        self._display_name = None
        self._email_verified = None
        self._fallback_avatar = None
        self._friend_group_names = None
        self._friend_key = None
        self._friends = None
        self._has_birthday = None
        self._has_email = None
        self._has_logged_in_from_client = None
        self._has_pending_email = None
        self._home_location = None
        self._id = None
        self._is_friend = None
        self._last_login = None
        self._last_platform = None
        self._obfuscated_email = None
        self._obfuscated_pending_email = None
        self._oculus_id = None
        self._offline_friends = None
        self._online_friends = None
        self._past_display_names = None
        self._profile_pic_override = None
        self._state = None
        self._status = None
        self._status_description = None
        self._status_first_time = None
        self._status_history = None
        self._steam_details = None
        self._steam_id = None
        self._tags = None
        self._two_factor_auth_enabled = None
        self._two_factor_auth_enabled_date = None
        self._unsubscribe = None
        self._user_icon = None
        self._username = None
        self.discriminator = None

        self.accepted_tos_version = accepted_tos_version
        self.account_deletion_date = account_deletion_date
        if active_friends is not None:
            self.active_friends = active_friends
        self.allow_avatar_copying = allow_avatar_copying
        self.bio = bio
        self.bio_links = bio_links
        self.current_avatar = current_avatar
        self.current_avatar_asset_url = current_avatar_asset_url
        self.current_avatar_image_url = current_avatar_image_url
        self.current_avatar_thumbnail_image_url = current_avatar_thumbnail_image_url
        self.date_joined = date_joined
        self.developer_type = developer_type
        self.display_name = display_name
        self.email_verified = email_verified
        if fallback_avatar is not None:
            self.fallback_avatar = fallback_avatar
        self.friend_group_names = friend_group_names
        self.friend_key = friend_key
        self.friends = friends
        self.has_birthday = has_birthday
        self.has_email = has_email
        self.has_logged_in_from_client = has_logged_in_from_client
        self.has_pending_email = has_pending_email
        self.home_location = home_location
        self.id = id
        self.is_friend = is_friend
        self.last_login = last_login
        self.last_platform = last_platform
        self.obfuscated_email = obfuscated_email
        self.obfuscated_pending_email = obfuscated_pending_email
        self.oculus_id = oculus_id
        if offline_friends is not None:
            self.offline_friends = offline_friends
        if online_friends is not None:
            self.online_friends = online_friends
        self.past_display_names = past_display_names
        self.profile_pic_override = profile_pic_override
        self.state = state
        self.status = status
        self.status_description = status_description
        self.status_first_time = status_first_time
        self.status_history = status_history
        self.steam_details = steam_details
        self.steam_id = steam_id
        self.tags = tags
        self.two_factor_auth_enabled = two_factor_auth_enabled
        self.two_factor_auth_enabled_date = two_factor_auth_enabled_date
        self.unsubscribe = unsubscribe
        self.user_icon = user_icon
        if username is not None:
            self.username = username

    @property
    def accepted_tos_version(self):
        """Gets the accepted_tos_version of this CurrentUser.  # noqa: E501


        :return: The accepted_tos_version of this CurrentUser.  # noqa: E501
        :rtype: int
        """
        return self._accepted_tos_version

    @accepted_tos_version.setter
    def accepted_tos_version(self, accepted_tos_version):
        """Sets the accepted_tos_version of this CurrentUser.


        :param accepted_tos_version: The accepted_tos_version of this CurrentUser.  # noqa: E501
        :type accepted_tos_version: int
        """
        if self.local_vars_configuration.client_side_validation and accepted_tos_version is None:  # noqa: E501
            raise ValueError("Invalid value for `accepted_tos_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                accepted_tos_version is not None and accepted_tos_version < 0):  # noqa: E501
            raise ValueError("Invalid value for `accepted_tos_version`, must be a value greater than or equal to `0`")  # noqa: E501

        self._accepted_tos_version = accepted_tos_version

    @property
    def account_deletion_date(self):
        """Gets the account_deletion_date of this CurrentUser.  # noqa: E501


        :return: The account_deletion_date of this CurrentUser.  # noqa: E501
        :rtype: date
        """
        return self._account_deletion_date

    @account_deletion_date.setter
    def account_deletion_date(self, account_deletion_date):
        """Sets the account_deletion_date of this CurrentUser.


        :param account_deletion_date: The account_deletion_date of this CurrentUser.  # noqa: E501
        :type account_deletion_date: date
        """

        self._account_deletion_date = account_deletion_date

    @property
    def active_friends(self):
        """Gets the active_friends of this CurrentUser.  # noqa: E501


        :return: The active_friends of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._active_friends

    @active_friends.setter
    def active_friends(self, active_friends):
        """Sets the active_friends of this CurrentUser.


        :param active_friends: The active_friends of this CurrentUser.  # noqa: E501
        :type active_friends: list[str]
        """

        self._active_friends = active_friends

    @property
    def allow_avatar_copying(self):
        """Gets the allow_avatar_copying of this CurrentUser.  # noqa: E501


        :return: The allow_avatar_copying of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._allow_avatar_copying

    @allow_avatar_copying.setter
    def allow_avatar_copying(self, allow_avatar_copying):
        """Sets the allow_avatar_copying of this CurrentUser.


        :param allow_avatar_copying: The allow_avatar_copying of this CurrentUser.  # noqa: E501
        :type allow_avatar_copying: bool
        """
        if self.local_vars_configuration.client_side_validation and allow_avatar_copying is None:  # noqa: E501
            raise ValueError("Invalid value for `allow_avatar_copying`, must not be `None`")  # noqa: E501

        self._allow_avatar_copying = allow_avatar_copying

    @property
    def bio(self):
        """Gets the bio of this CurrentUser.  # noqa: E501


        :return: The bio of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._bio

    @bio.setter
    def bio(self, bio):
        """Sets the bio of this CurrentUser.


        :param bio: The bio of this CurrentUser.  # noqa: E501
        :type bio: str
        """
        if self.local_vars_configuration.client_side_validation and bio is None:  # noqa: E501
            raise ValueError("Invalid value for `bio`, must not be `None`")  # noqa: E501

        self._bio = bio

    @property
    def bio_links(self):
        """Gets the bio_links of this CurrentUser.  # noqa: E501


        :return: The bio_links of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._bio_links

    @bio_links.setter
    def bio_links(self, bio_links):
        """Sets the bio_links of this CurrentUser.


        :param bio_links: The bio_links of this CurrentUser.  # noqa: E501
        :type bio_links: list[str]
        """
        if self.local_vars_configuration.client_side_validation and bio_links is None:  # noqa: E501
            raise ValueError("Invalid value for `bio_links`, must not be `None`")  # noqa: E501

        self._bio_links = bio_links

    @property
    def current_avatar(self):
        """Gets the current_avatar of this CurrentUser.  # noqa: E501


        :return: The current_avatar of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._current_avatar

    @current_avatar.setter
    def current_avatar(self, current_avatar):
        """Sets the current_avatar of this CurrentUser.


        :param current_avatar: The current_avatar of this CurrentUser.  # noqa: E501
        :type current_avatar: str
        """
        if self.local_vars_configuration.client_side_validation and current_avatar is None:  # noqa: E501
            raise ValueError("Invalid value for `current_avatar`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                current_avatar is not None and not re.search(r'avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', current_avatar)):  # noqa: E501
            raise ValueError(r"Invalid value for `current_avatar`, must be a follow pattern or equal to `/avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/`")  # noqa: E501

        self._current_avatar = current_avatar

    @property
    def current_avatar_asset_url(self):
        """Gets the current_avatar_asset_url of this CurrentUser.  # noqa: E501


        :return: The current_avatar_asset_url of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._current_avatar_asset_url

    @current_avatar_asset_url.setter
    def current_avatar_asset_url(self, current_avatar_asset_url):
        """Sets the current_avatar_asset_url of this CurrentUser.


        :param current_avatar_asset_url: The current_avatar_asset_url of this CurrentUser.  # noqa: E501
        :type current_avatar_asset_url: str
        """
        if self.local_vars_configuration.client_side_validation and current_avatar_asset_url is None:  # noqa: E501
            raise ValueError("Invalid value for `current_avatar_asset_url`, must not be `None`")  # noqa: E501

        self._current_avatar_asset_url = current_avatar_asset_url

    @property
    def current_avatar_image_url(self):
        """Gets the current_avatar_image_url of this CurrentUser.  # noqa: E501

        When profilePicOverride is not empty, use it instead.  # noqa: E501

        :return: The current_avatar_image_url of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._current_avatar_image_url

    @current_avatar_image_url.setter
    def current_avatar_image_url(self, current_avatar_image_url):
        """Sets the current_avatar_image_url of this CurrentUser.

        When profilePicOverride is not empty, use it instead.  # noqa: E501

        :param current_avatar_image_url: The current_avatar_image_url of this CurrentUser.  # noqa: E501
        :type current_avatar_image_url: str
        """
        if self.local_vars_configuration.client_side_validation and current_avatar_image_url is None:  # noqa: E501
            raise ValueError("Invalid value for `current_avatar_image_url`, must not be `None`")  # noqa: E501

        self._current_avatar_image_url = current_avatar_image_url

    @property
    def current_avatar_thumbnail_image_url(self):
        """Gets the current_avatar_thumbnail_image_url of this CurrentUser.  # noqa: E501

        When profilePicOverride is not empty, use it instead.  # noqa: E501

        :return: The current_avatar_thumbnail_image_url of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._current_avatar_thumbnail_image_url

    @current_avatar_thumbnail_image_url.setter
    def current_avatar_thumbnail_image_url(self, current_avatar_thumbnail_image_url):
        """Sets the current_avatar_thumbnail_image_url of this CurrentUser.

        When profilePicOverride is not empty, use it instead.  # noqa: E501

        :param current_avatar_thumbnail_image_url: The current_avatar_thumbnail_image_url of this CurrentUser.  # noqa: E501
        :type current_avatar_thumbnail_image_url: str
        """
        if self.local_vars_configuration.client_side_validation and current_avatar_thumbnail_image_url is None:  # noqa: E501
            raise ValueError("Invalid value for `current_avatar_thumbnail_image_url`, must not be `None`")  # noqa: E501

        self._current_avatar_thumbnail_image_url = current_avatar_thumbnail_image_url

    @property
    def date_joined(self):
        """Gets the date_joined of this CurrentUser.  # noqa: E501


        :return: The date_joined of this CurrentUser.  # noqa: E501
        :rtype: date
        """
        return self._date_joined

    @date_joined.setter
    def date_joined(self, date_joined):
        """Sets the date_joined of this CurrentUser.


        :param date_joined: The date_joined of this CurrentUser.  # noqa: E501
        :type date_joined: date
        """
        if self.local_vars_configuration.client_side_validation and date_joined is None:  # noqa: E501
            raise ValueError("Invalid value for `date_joined`, must not be `None`")  # noqa: E501

        self._date_joined = date_joined

    @property
    def developer_type(self):
        """Gets the developer_type of this CurrentUser.  # noqa: E501


        :return: The developer_type of this CurrentUser.  # noqa: E501
        :rtype: DeveloperType
        """
        return self._developer_type

    @developer_type.setter
    def developer_type(self, developer_type):
        """Sets the developer_type of this CurrentUser.


        :param developer_type: The developer_type of this CurrentUser.  # noqa: E501
        :type developer_type: DeveloperType
        """
        if self.local_vars_configuration.client_side_validation and developer_type is None:  # noqa: E501
            raise ValueError("Invalid value for `developer_type`, must not be `None`")  # noqa: E501

        self._developer_type = developer_type

    @property
    def display_name(self):
        """Gets the display_name of this CurrentUser.  # noqa: E501


        :return: The display_name of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this CurrentUser.


        :param display_name: The display_name of this CurrentUser.  # noqa: E501
        :type display_name: str
        """
        if self.local_vars_configuration.client_side_validation and display_name is None:  # noqa: E501
            raise ValueError("Invalid value for `display_name`, must not be `None`")  # noqa: E501

        self._display_name = display_name

    @property
    def email_verified(self):
        """Gets the email_verified of this CurrentUser.  # noqa: E501


        :return: The email_verified of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._email_verified

    @email_verified.setter
    def email_verified(self, email_verified):
        """Sets the email_verified of this CurrentUser.


        :param email_verified: The email_verified of this CurrentUser.  # noqa: E501
        :type email_verified: bool
        """
        if self.local_vars_configuration.client_side_validation and email_verified is None:  # noqa: E501
            raise ValueError("Invalid value for `email_verified`, must not be `None`")  # noqa: E501

        self._email_verified = email_verified

    @property
    def fallback_avatar(self):
        """Gets the fallback_avatar of this CurrentUser.  # noqa: E501


        :return: The fallback_avatar of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._fallback_avatar

    @fallback_avatar.setter
    def fallback_avatar(self, fallback_avatar):
        """Sets the fallback_avatar of this CurrentUser.


        :param fallback_avatar: The fallback_avatar of this CurrentUser.  # noqa: E501
        :type fallback_avatar: str
        """
        if (self.local_vars_configuration.client_side_validation and
                fallback_avatar is not None and not re.search(r'avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', fallback_avatar)):  # noqa: E501
            raise ValueError(r"Invalid value for `fallback_avatar`, must be a follow pattern or equal to `/avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/`")  # noqa: E501

        self._fallback_avatar = fallback_avatar

    @property
    def friend_group_names(self):
        """Gets the friend_group_names of this CurrentUser.  # noqa: E501

        Always empty array.  # noqa: E501

        :return: The friend_group_names of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._friend_group_names

    @friend_group_names.setter
    def friend_group_names(self, friend_group_names):
        """Sets the friend_group_names of this CurrentUser.

        Always empty array.  # noqa: E501

        :param friend_group_names: The friend_group_names of this CurrentUser.  # noqa: E501
        :type friend_group_names: list[str]
        """
        if self.local_vars_configuration.client_side_validation and friend_group_names is None:  # noqa: E501
            raise ValueError("Invalid value for `friend_group_names`, must not be `None`")  # noqa: E501

        self._friend_group_names = friend_group_names

    @property
    def friend_key(self):
        """Gets the friend_key of this CurrentUser.  # noqa: E501


        :return: The friend_key of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._friend_key

    @friend_key.setter
    def friend_key(self, friend_key):
        """Sets the friend_key of this CurrentUser.


        :param friend_key: The friend_key of this CurrentUser.  # noqa: E501
        :type friend_key: str
        """
        if self.local_vars_configuration.client_side_validation and friend_key is None:  # noqa: E501
            raise ValueError("Invalid value for `friend_key`, must not be `None`")  # noqa: E501

        self._friend_key = friend_key

    @property
    def friends(self):
        """Gets the friends of this CurrentUser.  # noqa: E501


        :return: The friends of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._friends

    @friends.setter
    def friends(self, friends):
        """Sets the friends of this CurrentUser.


        :param friends: The friends of this CurrentUser.  # noqa: E501
        :type friends: list[str]
        """
        if self.local_vars_configuration.client_side_validation and friends is None:  # noqa: E501
            raise ValueError("Invalid value for `friends`, must not be `None`")  # noqa: E501

        self._friends = friends

    @property
    def has_birthday(self):
        """Gets the has_birthday of this CurrentUser.  # noqa: E501


        :return: The has_birthday of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._has_birthday

    @has_birthday.setter
    def has_birthday(self, has_birthday):
        """Sets the has_birthday of this CurrentUser.


        :param has_birthday: The has_birthday of this CurrentUser.  # noqa: E501
        :type has_birthday: bool
        """
        if self.local_vars_configuration.client_side_validation and has_birthday is None:  # noqa: E501
            raise ValueError("Invalid value for `has_birthday`, must not be `None`")  # noqa: E501

        self._has_birthday = has_birthday

    @property
    def has_email(self):
        """Gets the has_email of this CurrentUser.  # noqa: E501


        :return: The has_email of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._has_email

    @has_email.setter
    def has_email(self, has_email):
        """Sets the has_email of this CurrentUser.


        :param has_email: The has_email of this CurrentUser.  # noqa: E501
        :type has_email: bool
        """
        if self.local_vars_configuration.client_side_validation and has_email is None:  # noqa: E501
            raise ValueError("Invalid value for `has_email`, must not be `None`")  # noqa: E501

        self._has_email = has_email

    @property
    def has_logged_in_from_client(self):
        """Gets the has_logged_in_from_client of this CurrentUser.  # noqa: E501


        :return: The has_logged_in_from_client of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._has_logged_in_from_client

    @has_logged_in_from_client.setter
    def has_logged_in_from_client(self, has_logged_in_from_client):
        """Sets the has_logged_in_from_client of this CurrentUser.


        :param has_logged_in_from_client: The has_logged_in_from_client of this CurrentUser.  # noqa: E501
        :type has_logged_in_from_client: bool
        """
        if self.local_vars_configuration.client_side_validation and has_logged_in_from_client is None:  # noqa: E501
            raise ValueError("Invalid value for `has_logged_in_from_client`, must not be `None`")  # noqa: E501

        self._has_logged_in_from_client = has_logged_in_from_client

    @property
    def has_pending_email(self):
        """Gets the has_pending_email of this CurrentUser.  # noqa: E501


        :return: The has_pending_email of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._has_pending_email

    @has_pending_email.setter
    def has_pending_email(self, has_pending_email):
        """Sets the has_pending_email of this CurrentUser.


        :param has_pending_email: The has_pending_email of this CurrentUser.  # noqa: E501
        :type has_pending_email: bool
        """
        if self.local_vars_configuration.client_side_validation and has_pending_email is None:  # noqa: E501
            raise ValueError("Invalid value for `has_pending_email`, must not be `None`")  # noqa: E501

        self._has_pending_email = has_pending_email

    @property
    def home_location(self):
        """Gets the home_location of this CurrentUser.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The home_location of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._home_location

    @home_location.setter
    def home_location(self, home_location):
        """Sets the home_location of this CurrentUser.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param home_location: The home_location of this CurrentUser.  # noqa: E501
        :type home_location: str
        """
        if self.local_vars_configuration.client_side_validation and home_location is None:  # noqa: E501
            raise ValueError("Invalid value for `home_location`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                home_location is not None and not re.search(r'(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})', home_location)):  # noqa: E501
            raise ValueError(r"Invalid value for `home_location`, must be a follow pattern or equal to `/(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})/`")  # noqa: E501

        self._home_location = home_location

    @property
    def id(self):
        """Gets the id of this CurrentUser.  # noqa: E501

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :return: The id of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CurrentUser.

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :param id: The id of this CurrentUser.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def is_friend(self):
        """Gets the is_friend of this CurrentUser.  # noqa: E501


        :return: The is_friend of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._is_friend

    @is_friend.setter
    def is_friend(self, is_friend):
        """Sets the is_friend of this CurrentUser.


        :param is_friend: The is_friend of this CurrentUser.  # noqa: E501
        :type is_friend: bool
        """
        if self.local_vars_configuration.client_side_validation and is_friend is None:  # noqa: E501
            raise ValueError("Invalid value for `is_friend`, must not be `None`")  # noqa: E501

        self._is_friend = is_friend

    @property
    def last_login(self):
        """Gets the last_login of this CurrentUser.  # noqa: E501


        :return: The last_login of this CurrentUser.  # noqa: E501
        :rtype: datetime
        """
        return self._last_login

    @last_login.setter
    def last_login(self, last_login):
        """Sets the last_login of this CurrentUser.


        :param last_login: The last_login of this CurrentUser.  # noqa: E501
        :type last_login: datetime
        """
        if self.local_vars_configuration.client_side_validation and last_login is None:  # noqa: E501
            raise ValueError("Invalid value for `last_login`, must not be `None`")  # noqa: E501

        self._last_login = last_login

    @property
    def last_platform(self):
        """Gets the last_platform of this CurrentUser.  # noqa: E501

        This can be `standalonewindows` or `android`, but can also pretty much be any random Unity verison such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.  # noqa: E501

        :return: The last_platform of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._last_platform

    @last_platform.setter
    def last_platform(self, last_platform):
        """Sets the last_platform of this CurrentUser.

        This can be `standalonewindows` or `android`, but can also pretty much be any random Unity verison such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.  # noqa: E501

        :param last_platform: The last_platform of this CurrentUser.  # noqa: E501
        :type last_platform: str
        """
        if self.local_vars_configuration.client_side_validation and last_platform is None:  # noqa: E501
            raise ValueError("Invalid value for `last_platform`, must not be `None`")  # noqa: E501

        self._last_platform = last_platform

    @property
    def obfuscated_email(self):
        """Gets the obfuscated_email of this CurrentUser.  # noqa: E501


        :return: The obfuscated_email of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._obfuscated_email

    @obfuscated_email.setter
    def obfuscated_email(self, obfuscated_email):
        """Sets the obfuscated_email of this CurrentUser.


        :param obfuscated_email: The obfuscated_email of this CurrentUser.  # noqa: E501
        :type obfuscated_email: str
        """
        if self.local_vars_configuration.client_side_validation and obfuscated_email is None:  # noqa: E501
            raise ValueError("Invalid value for `obfuscated_email`, must not be `None`")  # noqa: E501

        self._obfuscated_email = obfuscated_email

    @property
    def obfuscated_pending_email(self):
        """Gets the obfuscated_pending_email of this CurrentUser.  # noqa: E501


        :return: The obfuscated_pending_email of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._obfuscated_pending_email

    @obfuscated_pending_email.setter
    def obfuscated_pending_email(self, obfuscated_pending_email):
        """Sets the obfuscated_pending_email of this CurrentUser.


        :param obfuscated_pending_email: The obfuscated_pending_email of this CurrentUser.  # noqa: E501
        :type obfuscated_pending_email: str
        """
        if self.local_vars_configuration.client_side_validation and obfuscated_pending_email is None:  # noqa: E501
            raise ValueError("Invalid value for `obfuscated_pending_email`, must not be `None`")  # noqa: E501

        self._obfuscated_pending_email = obfuscated_pending_email

    @property
    def oculus_id(self):
        """Gets the oculus_id of this CurrentUser.  # noqa: E501


        :return: The oculus_id of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._oculus_id

    @oculus_id.setter
    def oculus_id(self, oculus_id):
        """Sets the oculus_id of this CurrentUser.


        :param oculus_id: The oculus_id of this CurrentUser.  # noqa: E501
        :type oculus_id: str
        """
        if self.local_vars_configuration.client_side_validation and oculus_id is None:  # noqa: E501
            raise ValueError("Invalid value for `oculus_id`, must not be `None`")  # noqa: E501

        self._oculus_id = oculus_id

    @property
    def offline_friends(self):
        """Gets the offline_friends of this CurrentUser.  # noqa: E501


        :return: The offline_friends of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._offline_friends

    @offline_friends.setter
    def offline_friends(self, offline_friends):
        """Sets the offline_friends of this CurrentUser.


        :param offline_friends: The offline_friends of this CurrentUser.  # noqa: E501
        :type offline_friends: list[str]
        """

        self._offline_friends = offline_friends

    @property
    def online_friends(self):
        """Gets the online_friends of this CurrentUser.  # noqa: E501


        :return: The online_friends of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._online_friends

    @online_friends.setter
    def online_friends(self, online_friends):
        """Sets the online_friends of this CurrentUser.


        :param online_friends: The online_friends of this CurrentUser.  # noqa: E501
        :type online_friends: list[str]
        """

        self._online_friends = online_friends

    @property
    def past_display_names(self):
        """Gets the past_display_names of this CurrentUser.  # noqa: E501

           # noqa: E501

        :return: The past_display_names of this CurrentUser.  # noqa: E501
        :rtype: list[PastDisplayName]
        """
        return self._past_display_names

    @past_display_names.setter
    def past_display_names(self, past_display_names):
        """Sets the past_display_names of this CurrentUser.

           # noqa: E501

        :param past_display_names: The past_display_names of this CurrentUser.  # noqa: E501
        :type past_display_names: list[PastDisplayName]
        """
        if self.local_vars_configuration.client_side_validation and past_display_names is None:  # noqa: E501
            raise ValueError("Invalid value for `past_display_names`, must not be `None`")  # noqa: E501

        self._past_display_names = past_display_names

    @property
    def profile_pic_override(self):
        """Gets the profile_pic_override of this CurrentUser.  # noqa: E501


        :return: The profile_pic_override of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._profile_pic_override

    @profile_pic_override.setter
    def profile_pic_override(self, profile_pic_override):
        """Sets the profile_pic_override of this CurrentUser.


        :param profile_pic_override: The profile_pic_override of this CurrentUser.  # noqa: E501
        :type profile_pic_override: str
        """
        if self.local_vars_configuration.client_side_validation and profile_pic_override is None:  # noqa: E501
            raise ValueError("Invalid value for `profile_pic_override`, must not be `None`")  # noqa: E501

        self._profile_pic_override = profile_pic_override

    @property
    def state(self):
        """Gets the state of this CurrentUser.  # noqa: E501


        :return: The state of this CurrentUser.  # noqa: E501
        :rtype: UserState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CurrentUser.


        :param state: The state of this CurrentUser.  # noqa: E501
        :type state: UserState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def status(self):
        """Gets the status of this CurrentUser.  # noqa: E501


        :return: The status of this CurrentUser.  # noqa: E501
        :rtype: UserStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CurrentUser.


        :param status: The status of this CurrentUser.  # noqa: E501
        :type status: UserStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def status_description(self):
        """Gets the status_description of this CurrentUser.  # noqa: E501


        :return: The status_description of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._status_description

    @status_description.setter
    def status_description(self, status_description):
        """Sets the status_description of this CurrentUser.


        :param status_description: The status_description of this CurrentUser.  # noqa: E501
        :type status_description: str
        """
        if self.local_vars_configuration.client_side_validation and status_description is None:  # noqa: E501
            raise ValueError("Invalid value for `status_description`, must not be `None`")  # noqa: E501

        self._status_description = status_description

    @property
    def status_first_time(self):
        """Gets the status_first_time of this CurrentUser.  # noqa: E501


        :return: The status_first_time of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._status_first_time

    @status_first_time.setter
    def status_first_time(self, status_first_time):
        """Sets the status_first_time of this CurrentUser.


        :param status_first_time: The status_first_time of this CurrentUser.  # noqa: E501
        :type status_first_time: bool
        """
        if self.local_vars_configuration.client_side_validation and status_first_time is None:  # noqa: E501
            raise ValueError("Invalid value for `status_first_time`, must not be `None`")  # noqa: E501

        self._status_first_time = status_first_time

    @property
    def status_history(self):
        """Gets the status_history of this CurrentUser.  # noqa: E501


        :return: The status_history of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._status_history

    @status_history.setter
    def status_history(self, status_history):
        """Sets the status_history of this CurrentUser.


        :param status_history: The status_history of this CurrentUser.  # noqa: E501
        :type status_history: list[str]
        """
        if self.local_vars_configuration.client_side_validation and status_history is None:  # noqa: E501
            raise ValueError("Invalid value for `status_history`, must not be `None`")  # noqa: E501

        self._status_history = status_history

    @property
    def steam_details(self):
        """Gets the steam_details of this CurrentUser.  # noqa: E501


        :return: The steam_details of this CurrentUser.  # noqa: E501
        :rtype: object
        """
        return self._steam_details

    @steam_details.setter
    def steam_details(self, steam_details):
        """Sets the steam_details of this CurrentUser.


        :param steam_details: The steam_details of this CurrentUser.  # noqa: E501
        :type steam_details: object
        """
        if self.local_vars_configuration.client_side_validation and steam_details is None:  # noqa: E501
            raise ValueError("Invalid value for `steam_details`, must not be `None`")  # noqa: E501

        self._steam_details = steam_details

    @property
    def steam_id(self):
        """Gets the steam_id of this CurrentUser.  # noqa: E501


        :return: The steam_id of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._steam_id

    @steam_id.setter
    def steam_id(self, steam_id):
        """Sets the steam_id of this CurrentUser.


        :param steam_id: The steam_id of this CurrentUser.  # noqa: E501
        :type steam_id: str
        """
        if self.local_vars_configuration.client_side_validation and steam_id is None:  # noqa: E501
            raise ValueError("Invalid value for `steam_id`, must not be `None`")  # noqa: E501

        self._steam_id = steam_id

    @property
    def tags(self):
        """Gets the tags of this CurrentUser.  # noqa: E501


        :return: The tags of this CurrentUser.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this CurrentUser.


        :param tags: The tags of this CurrentUser.  # noqa: E501
        :type tags: list[str]
        """
        if self.local_vars_configuration.client_side_validation and tags is None:  # noqa: E501
            raise ValueError("Invalid value for `tags`, must not be `None`")  # noqa: E501

        self._tags = tags

    @property
    def two_factor_auth_enabled(self):
        """Gets the two_factor_auth_enabled of this CurrentUser.  # noqa: E501


        :return: The two_factor_auth_enabled of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._two_factor_auth_enabled

    @two_factor_auth_enabled.setter
    def two_factor_auth_enabled(self, two_factor_auth_enabled):
        """Sets the two_factor_auth_enabled of this CurrentUser.


        :param two_factor_auth_enabled: The two_factor_auth_enabled of this CurrentUser.  # noqa: E501
        :type two_factor_auth_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and two_factor_auth_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `two_factor_auth_enabled`, must not be `None`")  # noqa: E501

        self._two_factor_auth_enabled = two_factor_auth_enabled

    @property
    def two_factor_auth_enabled_date(self):
        """Gets the two_factor_auth_enabled_date of this CurrentUser.  # noqa: E501


        :return: The two_factor_auth_enabled_date of this CurrentUser.  # noqa: E501
        :rtype: datetime
        """
        return self._two_factor_auth_enabled_date

    @two_factor_auth_enabled_date.setter
    def two_factor_auth_enabled_date(self, two_factor_auth_enabled_date):
        """Sets the two_factor_auth_enabled_date of this CurrentUser.


        :param two_factor_auth_enabled_date: The two_factor_auth_enabled_date of this CurrentUser.  # noqa: E501
        :type two_factor_auth_enabled_date: datetime
        """

        self._two_factor_auth_enabled_date = two_factor_auth_enabled_date

    @property
    def unsubscribe(self):
        """Gets the unsubscribe of this CurrentUser.  # noqa: E501


        :return: The unsubscribe of this CurrentUser.  # noqa: E501
        :rtype: bool
        """
        return self._unsubscribe

    @unsubscribe.setter
    def unsubscribe(self, unsubscribe):
        """Sets the unsubscribe of this CurrentUser.


        :param unsubscribe: The unsubscribe of this CurrentUser.  # noqa: E501
        :type unsubscribe: bool
        """
        if self.local_vars_configuration.client_side_validation and unsubscribe is None:  # noqa: E501
            raise ValueError("Invalid value for `unsubscribe`, must not be `None`")  # noqa: E501

        self._unsubscribe = unsubscribe

    @property
    def user_icon(self):
        """Gets the user_icon of this CurrentUser.  # noqa: E501


        :return: The user_icon of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._user_icon

    @user_icon.setter
    def user_icon(self, user_icon):
        """Sets the user_icon of this CurrentUser.


        :param user_icon: The user_icon of this CurrentUser.  # noqa: E501
        :type user_icon: str
        """
        if self.local_vars_configuration.client_side_validation and user_icon is None:  # noqa: E501
            raise ValueError("Invalid value for `user_icon`, must not be `None`")  # noqa: E501

        self._user_icon = user_icon

    @property
    def username(self):
        """Gets the username of this CurrentUser.  # noqa: E501

        -| **DEPRECATED:** VRChat API no longer return usernames of other users. [See issue by Tupper for more information](https://github.com/pypy-vrc/VRCX/issues/429).  # noqa: E501

        :return: The username of this CurrentUser.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this CurrentUser.

        -| **DEPRECATED:** VRChat API no longer return usernames of other users. [See issue by Tupper for more information](https://github.com/pypy-vrc/VRCX/issues/429).  # noqa: E501

        :param username: The username of this CurrentUser.  # noqa: E501
        :type username: str
        """

        self._username = username

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CurrentUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CurrentUser):
            return True

        return self.to_dict() != other.to_dict()
