# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.10.0
    Contact: me@ariesclark.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class APIConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'voice_enable_degradation': 'bool',
        'voice_enable_receiver_limiting': 'bool',
        'address': 'str',
        'announcements': 'list[APIConfigAnnouncement]',
        'api_key': 'str',
        'app_name': 'str',
        'build_version_tag': 'str',
        'client_api_key': 'str',
        'client_bps_ceiling': 'int',
        'client_disconnect_timeout': 'int',
        'client_reserved_player_bps': 'int',
        'client_sent_count_allowance': 'int',
        'contact_email': 'str',
        'copyright_email': 'str',
        'current_tos_version': 'int',
        'default_avatar': 'str',
        'deployment_group': 'DeploymentGroup',
        'dev_app_version_standalone': 'str',
        'dev_download_link_windows': 'str',
        'dev_sdk_url': 'str',
        'dev_sdk_version': 'str',
        'dev_server_version_standalone': 'str',
        'dis_countdown': 'datetime',
        'disable_avatar_copying': 'bool',
        'disable_avatar_gating': 'bool',
        'disable_community_labs': 'bool',
        'disable_community_labs_promotion': 'bool',
        'disable_email': 'bool',
        'disable_event_stream': 'bool',
        'disable_feedback_gating': 'bool',
        'disable_frontend_builds': 'bool',
        'disable_hello': 'bool',
        'disable_oculus_subs': 'bool',
        'disable_registration': 'bool',
        'disable_steam_networking': 'bool',
        'disable_two_factor_auth': 'bool',
        'disable_udon': 'bool',
        'disable_upgrade_account': 'bool',
        'download_link_windows': 'str',
        'download_urls': 'APIConfigDownloadURLList',
        'dynamic_world_rows': 'list[DynamicContentRow]',
        'events': 'APIConfigEvents',
        'gear_demo_room_id': 'str',
        'home_world_id': 'str',
        'homepage_redirect_target': 'str',
        'hub_world_id': 'str',
        'jobs_email': 'str',
        'message_of_the_day': 'str',
        'moderation_email': 'str',
        'moderation_query_period': 'int',
        'not_allowed_to_select_avatar_in_private_world_message': 'str',
        'plugin': 'str',
        'release_app_version_standalone': 'str',
        'release_sdk_url': 'str',
        'release_sdk_version': 'str',
        'release_server_version_standalone': 'str',
        'sdk_developer_faq_url': 'str',
        'sdk_discord_url': 'str',
        'sdk_not_allowed_to_publish_message': 'str',
        'sdk_unity_version': 'str',
        'server_name': 'str',
        'support_email': 'str',
        'time_out_world_id': 'str',
        'tutorial_world_id': 'str',
        'update_rate_ms_maximum': 'int',
        'update_rate_ms_minimum': 'int',
        'update_rate_ms_normal': 'int',
        'update_rate_ms_udon_manual': 'int',
        'upload_analysis_percent': 'int',
        'url_list': 'list[str]',
        'use_reliable_udp_for_voice': 'bool',
        'user_update_period': 'int',
        'user_verification_delay': 'int',
        'user_verification_retry': 'int',
        'user_verification_timeout': 'int',
        'vive_windows_url': 'str',
        'white_listed_asset_urls': 'list[str]',
        'world_update_period': 'int',
        'player_url_resolver_hash': 'str',
        'player_url_resolver_version': 'str'
    }

    attribute_map = {
        'voice_enable_degradation': 'VoiceEnableDegradation',
        'voice_enable_receiver_limiting': 'VoiceEnableReceiverLimiting',
        'address': 'address',
        'announcements': 'announcements',
        'api_key': 'apiKey',
        'app_name': 'appName',
        'build_version_tag': 'buildVersionTag',
        'client_api_key': 'clientApiKey',
        'client_bps_ceiling': 'clientBPSCeiling',
        'client_disconnect_timeout': 'clientDisconnectTimeout',
        'client_reserved_player_bps': 'clientReservedPlayerBPS',
        'client_sent_count_allowance': 'clientSentCountAllowance',
        'contact_email': 'contactEmail',
        'copyright_email': 'copyrightEmail',
        'current_tos_version': 'currentTOSVersion',
        'default_avatar': 'defaultAvatar',
        'deployment_group': 'deploymentGroup',
        'dev_app_version_standalone': 'devAppVersionStandalone',
        'dev_download_link_windows': 'devDownloadLinkWindows',
        'dev_sdk_url': 'devSdkUrl',
        'dev_sdk_version': 'devSdkVersion',
        'dev_server_version_standalone': 'devServerVersionStandalone',
        'dis_countdown': 'dis-countdown',
        'disable_avatar_copying': 'disableAvatarCopying',
        'disable_avatar_gating': 'disableAvatarGating',
        'disable_community_labs': 'disableCommunityLabs',
        'disable_community_labs_promotion': 'disableCommunityLabsPromotion',
        'disable_email': 'disableEmail',
        'disable_event_stream': 'disableEventStream',
        'disable_feedback_gating': 'disableFeedbackGating',
        'disable_frontend_builds': 'disableFrontendBuilds',
        'disable_hello': 'disableHello',
        'disable_oculus_subs': 'disableOculusSubs',
        'disable_registration': 'disableRegistration',
        'disable_steam_networking': 'disableSteamNetworking',
        'disable_two_factor_auth': 'disableTwoFactorAuth',
        'disable_udon': 'disableUdon',
        'disable_upgrade_account': 'disableUpgradeAccount',
        'download_link_windows': 'downloadLinkWindows',
        'download_urls': 'downloadUrls',
        'dynamic_world_rows': 'dynamicWorldRows',
        'events': 'events',
        'gear_demo_room_id': 'gearDemoRoomId',
        'home_world_id': 'homeWorldId',
        'homepage_redirect_target': 'homepageRedirectTarget',
        'hub_world_id': 'hubWorldId',
        'jobs_email': 'jobsEmail',
        'message_of_the_day': 'messageOfTheDay',
        'moderation_email': 'moderationEmail',
        'moderation_query_period': 'moderationQueryPeriod',
        'not_allowed_to_select_avatar_in_private_world_message': 'notAllowedToSelectAvatarInPrivateWorldMessage',
        'plugin': 'plugin',
        'release_app_version_standalone': 'releaseAppVersionStandalone',
        'release_sdk_url': 'releaseSdkUrl',
        'release_sdk_version': 'releaseSdkVersion',
        'release_server_version_standalone': 'releaseServerVersionStandalone',
        'sdk_developer_faq_url': 'sdkDeveloperFaqUrl',
        'sdk_discord_url': 'sdkDiscordUrl',
        'sdk_not_allowed_to_publish_message': 'sdkNotAllowedToPublishMessage',
        'sdk_unity_version': 'sdkUnityVersion',
        'server_name': 'serverName',
        'support_email': 'supportEmail',
        'time_out_world_id': 'timeOutWorldId',
        'tutorial_world_id': 'tutorialWorldId',
        'update_rate_ms_maximum': 'updateRateMsMaximum',
        'update_rate_ms_minimum': 'updateRateMsMinimum',
        'update_rate_ms_normal': 'updateRateMsNormal',
        'update_rate_ms_udon_manual': 'updateRateMsUdonManual',
        'upload_analysis_percent': 'uploadAnalysisPercent',
        'url_list': 'urlList',
        'use_reliable_udp_for_voice': 'useReliableUdpForVoice',
        'user_update_period': 'userUpdatePeriod',
        'user_verification_delay': 'userVerificationDelay',
        'user_verification_retry': 'userVerificationRetry',
        'user_verification_timeout': 'userVerificationTimeout',
        'vive_windows_url': 'viveWindowsUrl',
        'white_listed_asset_urls': 'whiteListedAssetUrls',
        'world_update_period': 'worldUpdatePeriod',
        'player_url_resolver_hash': 'player-url-resolver-hash',
        'player_url_resolver_version': 'player-url-resolver-version'
    }

    def __init__(self, voice_enable_degradation=False, voice_enable_receiver_limiting=True, address=None, announcements=None, api_key=None, app_name='VrChat', build_version_tag=None, client_api_key=None, client_bps_ceiling=18432, client_disconnect_timeout=30000, client_reserved_player_bps=7168, client_sent_count_allowance=15, contact_email=None, copyright_email=None, current_tos_version=None, default_avatar=None, deployment_group=None, dev_app_version_standalone=None, dev_download_link_windows=None, dev_sdk_url=None, dev_sdk_version=None, dev_server_version_standalone=None, dis_countdown=None, disable_avatar_copying=False, disable_avatar_gating=False, disable_community_labs=False, disable_community_labs_promotion=False, disable_email=False, disable_event_stream=False, disable_feedback_gating=False, disable_frontend_builds=False, disable_hello=False, disable_oculus_subs=False, disable_registration=False, disable_steam_networking=True, disable_two_factor_auth=False, disable_udon=False, disable_upgrade_account=False, download_link_windows=None, download_urls=None, dynamic_world_rows=None, events=None, gear_demo_room_id=None, home_world_id=None, homepage_redirect_target='https://hello.vrchat.com', hub_world_id=None, jobs_email=None, message_of_the_day=None, moderation_email=None, moderation_query_period=None, not_allowed_to_select_avatar_in_private_world_message=None, plugin=None, release_app_version_standalone=None, release_sdk_url=None, release_sdk_version=None, release_server_version_standalone=None, sdk_developer_faq_url=None, sdk_discord_url=None, sdk_not_allowed_to_publish_message=None, sdk_unity_version=None, server_name=None, support_email=None, time_out_world_id=None, tutorial_world_id=None, update_rate_ms_maximum=None, update_rate_ms_minimum=None, update_rate_ms_normal=None, update_rate_ms_udon_manual=None, upload_analysis_percent=None, url_list=None, use_reliable_udp_for_voice=False, user_update_period=None, user_verification_delay=None, user_verification_retry=None, user_verification_timeout=None, vive_windows_url=None, white_listed_asset_urls=None, world_update_period=None, player_url_resolver_hash=None, player_url_resolver_version=None, local_vars_configuration=None):  # noqa: E501
        """APIConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._voice_enable_degradation = None
        self._voice_enable_receiver_limiting = None
        self._address = None
        self._announcements = None
        self._api_key = None
        self._app_name = None
        self._build_version_tag = None
        self._client_api_key = None
        self._client_bps_ceiling = None
        self._client_disconnect_timeout = None
        self._client_reserved_player_bps = None
        self._client_sent_count_allowance = None
        self._contact_email = None
        self._copyright_email = None
        self._current_tos_version = None
        self._default_avatar = None
        self._deployment_group = None
        self._dev_app_version_standalone = None
        self._dev_download_link_windows = None
        self._dev_sdk_url = None
        self._dev_sdk_version = None
        self._dev_server_version_standalone = None
        self._dis_countdown = None
        self._disable_avatar_copying = None
        self._disable_avatar_gating = None
        self._disable_community_labs = None
        self._disable_community_labs_promotion = None
        self._disable_email = None
        self._disable_event_stream = None
        self._disable_feedback_gating = None
        self._disable_frontend_builds = None
        self._disable_hello = None
        self._disable_oculus_subs = None
        self._disable_registration = None
        self._disable_steam_networking = None
        self._disable_two_factor_auth = None
        self._disable_udon = None
        self._disable_upgrade_account = None
        self._download_link_windows = None
        self._download_urls = None
        self._dynamic_world_rows = None
        self._events = None
        self._gear_demo_room_id = None
        self._home_world_id = None
        self._homepage_redirect_target = None
        self._hub_world_id = None
        self._jobs_email = None
        self._message_of_the_day = None
        self._moderation_email = None
        self._moderation_query_period = None
        self._not_allowed_to_select_avatar_in_private_world_message = None
        self._plugin = None
        self._release_app_version_standalone = None
        self._release_sdk_url = None
        self._release_sdk_version = None
        self._release_server_version_standalone = None
        self._sdk_developer_faq_url = None
        self._sdk_discord_url = None
        self._sdk_not_allowed_to_publish_message = None
        self._sdk_unity_version = None
        self._server_name = None
        self._support_email = None
        self._time_out_world_id = None
        self._tutorial_world_id = None
        self._update_rate_ms_maximum = None
        self._update_rate_ms_minimum = None
        self._update_rate_ms_normal = None
        self._update_rate_ms_udon_manual = None
        self._upload_analysis_percent = None
        self._url_list = None
        self._use_reliable_udp_for_voice = None
        self._user_update_period = None
        self._user_verification_delay = None
        self._user_verification_retry = None
        self._user_verification_timeout = None
        self._vive_windows_url = None
        self._white_listed_asset_urls = None
        self._world_update_period = None
        self._player_url_resolver_hash = None
        self._player_url_resolver_version = None
        self.discriminator = None

        self.voice_enable_degradation = voice_enable_degradation
        self.voice_enable_receiver_limiting = voice_enable_receiver_limiting
        self.address = address
        self.announcements = announcements
        self.api_key = api_key
        self.app_name = app_name
        self.build_version_tag = build_version_tag
        self.client_api_key = client_api_key
        self.client_bps_ceiling = client_bps_ceiling
        self.client_disconnect_timeout = client_disconnect_timeout
        self.client_reserved_player_bps = client_reserved_player_bps
        self.client_sent_count_allowance = client_sent_count_allowance
        self.contact_email = contact_email
        self.copyright_email = copyright_email
        self.current_tos_version = current_tos_version
        self.default_avatar = default_avatar
        self.deployment_group = deployment_group
        self.dev_app_version_standalone = dev_app_version_standalone
        self.dev_download_link_windows = dev_download_link_windows
        self.dev_sdk_url = dev_sdk_url
        self.dev_sdk_version = dev_sdk_version
        self.dev_server_version_standalone = dev_server_version_standalone
        self.dis_countdown = dis_countdown
        self.disable_avatar_copying = disable_avatar_copying
        self.disable_avatar_gating = disable_avatar_gating
        self.disable_community_labs = disable_community_labs
        self.disable_community_labs_promotion = disable_community_labs_promotion
        self.disable_email = disable_email
        self.disable_event_stream = disable_event_stream
        self.disable_feedback_gating = disable_feedback_gating
        self.disable_frontend_builds = disable_frontend_builds
        self.disable_hello = disable_hello
        self.disable_oculus_subs = disable_oculus_subs
        self.disable_registration = disable_registration
        self.disable_steam_networking = disable_steam_networking
        self.disable_two_factor_auth = disable_two_factor_auth
        self.disable_udon = disable_udon
        self.disable_upgrade_account = disable_upgrade_account
        self.download_link_windows = download_link_windows
        self.download_urls = download_urls
        self.dynamic_world_rows = dynamic_world_rows
        self.events = events
        self.gear_demo_room_id = gear_demo_room_id
        self.home_world_id = home_world_id
        self.homepage_redirect_target = homepage_redirect_target
        self.hub_world_id = hub_world_id
        self.jobs_email = jobs_email
        self.message_of_the_day = message_of_the_day
        self.moderation_email = moderation_email
        self.moderation_query_period = moderation_query_period
        self.not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message
        self.plugin = plugin
        self.release_app_version_standalone = release_app_version_standalone
        self.release_sdk_url = release_sdk_url
        self.release_sdk_version = release_sdk_version
        self.release_server_version_standalone = release_server_version_standalone
        self.sdk_developer_faq_url = sdk_developer_faq_url
        self.sdk_discord_url = sdk_discord_url
        self.sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message
        self.sdk_unity_version = sdk_unity_version
        self.server_name = server_name
        self.support_email = support_email
        self.time_out_world_id = time_out_world_id
        self.tutorial_world_id = tutorial_world_id
        self.update_rate_ms_maximum = update_rate_ms_maximum
        self.update_rate_ms_minimum = update_rate_ms_minimum
        self.update_rate_ms_normal = update_rate_ms_normal
        self.update_rate_ms_udon_manual = update_rate_ms_udon_manual
        self.upload_analysis_percent = upload_analysis_percent
        self.url_list = url_list
        self.use_reliable_udp_for_voice = use_reliable_udp_for_voice
        self.user_update_period = user_update_period
        self.user_verification_delay = user_verification_delay
        self.user_verification_retry = user_verification_retry
        self.user_verification_timeout = user_verification_timeout
        self.vive_windows_url = vive_windows_url
        self.white_listed_asset_urls = white_listed_asset_urls
        self.world_update_period = world_update_period
        self.player_url_resolver_hash = player_url_resolver_hash
        self.player_url_resolver_version = player_url_resolver_version

    @property
    def voice_enable_degradation(self):
        """Gets the voice_enable_degradation of this APIConfig.  # noqa: E501

        Unknown, probably voice optimization testing  # noqa: E501

        :return: The voice_enable_degradation of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._voice_enable_degradation

    @voice_enable_degradation.setter
    def voice_enable_degradation(self, voice_enable_degradation):
        """Sets the voice_enable_degradation of this APIConfig.

        Unknown, probably voice optimization testing  # noqa: E501

        :param voice_enable_degradation: The voice_enable_degradation of this APIConfig.  # noqa: E501
        :type voice_enable_degradation: bool
        """
        if self.local_vars_configuration.client_side_validation and voice_enable_degradation is None:  # noqa: E501
            raise ValueError("Invalid value for `voice_enable_degradation`, must not be `None`")  # noqa: E501

        self._voice_enable_degradation = voice_enable_degradation

    @property
    def voice_enable_receiver_limiting(self):
        """Gets the voice_enable_receiver_limiting of this APIConfig.  # noqa: E501

        Unknown, probably voice optimization testing  # noqa: E501

        :return: The voice_enable_receiver_limiting of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._voice_enable_receiver_limiting

    @voice_enable_receiver_limiting.setter
    def voice_enable_receiver_limiting(self, voice_enable_receiver_limiting):
        """Sets the voice_enable_receiver_limiting of this APIConfig.

        Unknown, probably voice optimization testing  # noqa: E501

        :param voice_enable_receiver_limiting: The voice_enable_receiver_limiting of this APIConfig.  # noqa: E501
        :type voice_enable_receiver_limiting: bool
        """
        if self.local_vars_configuration.client_side_validation and voice_enable_receiver_limiting is None:  # noqa: E501
            raise ValueError("Invalid value for `voice_enable_receiver_limiting`, must not be `None`")  # noqa: E501

        self._voice_enable_receiver_limiting = voice_enable_receiver_limiting

    @property
    def address(self):
        """Gets the address of this APIConfig.  # noqa: E501

        VRChat's office address  # noqa: E501

        :return: The address of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this APIConfig.

        VRChat's office address  # noqa: E501

        :param address: The address of this APIConfig.  # noqa: E501
        :type address: str
        """
        if self.local_vars_configuration.client_side_validation and address is None:  # noqa: E501
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                address is not None and len(address) < 1):
            raise ValueError("Invalid value for `address`, length must be greater than or equal to `1`")  # noqa: E501

        self._address = address

    @property
    def announcements(self):
        """Gets the announcements of this APIConfig.  # noqa: E501

        Public Announcements  # noqa: E501

        :return: The announcements of this APIConfig.  # noqa: E501
        :rtype: list[APIConfigAnnouncement]
        """
        return self._announcements

    @announcements.setter
    def announcements(self, announcements):
        """Sets the announcements of this APIConfig.

        Public Announcements  # noqa: E501

        :param announcements: The announcements of this APIConfig.  # noqa: E501
        :type announcements: list[APIConfigAnnouncement]
        """
        if self.local_vars_configuration.client_side_validation and announcements is None:  # noqa: E501
            raise ValueError("Invalid value for `announcements`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                announcements is not None and len(announcements) < 0):
            raise ValueError("Invalid value for `announcements`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._announcements = announcements

    @property
    def api_key(self):
        """Gets the api_key of this APIConfig.  # noqa: E501

        apiKey to be used for all other requests  # noqa: E501

        :return: The api_key of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._api_key

    @api_key.setter
    def api_key(self, api_key):
        """Sets the api_key of this APIConfig.

        apiKey to be used for all other requests  # noqa: E501

        :param api_key: The api_key of this APIConfig.  # noqa: E501
        :type api_key: str
        """
        if self.local_vars_configuration.client_side_validation and api_key is None:  # noqa: E501
            raise ValueError("Invalid value for `api_key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                api_key is not None and len(api_key) < 1):
            raise ValueError("Invalid value for `api_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._api_key = api_key

    @property
    def app_name(self):
        """Gets the app_name of this APIConfig.  # noqa: E501

        Game name  # noqa: E501

        :return: The app_name of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._app_name

    @app_name.setter
    def app_name(self, app_name):
        """Sets the app_name of this APIConfig.

        Game name  # noqa: E501

        :param app_name: The app_name of this APIConfig.  # noqa: E501
        :type app_name: str
        """
        if self.local_vars_configuration.client_side_validation and app_name is None:  # noqa: E501
            raise ValueError("Invalid value for `app_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                app_name is not None and len(app_name) < 1):
            raise ValueError("Invalid value for `app_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._app_name = app_name

    @property
    def build_version_tag(self):
        """Gets the build_version_tag of this APIConfig.  # noqa: E501

        Build tag of the API server  # noqa: E501

        :return: The build_version_tag of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._build_version_tag

    @build_version_tag.setter
    def build_version_tag(self, build_version_tag):
        """Sets the build_version_tag of this APIConfig.

        Build tag of the API server  # noqa: E501

        :param build_version_tag: The build_version_tag of this APIConfig.  # noqa: E501
        :type build_version_tag: str
        """
        if self.local_vars_configuration.client_side_validation and build_version_tag is None:  # noqa: E501
            raise ValueError("Invalid value for `build_version_tag`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                build_version_tag is not None and len(build_version_tag) < 1):
            raise ValueError("Invalid value for `build_version_tag`, length must be greater than or equal to `1`")  # noqa: E501

        self._build_version_tag = build_version_tag

    @property
    def client_api_key(self):
        """Gets the client_api_key of this APIConfig.  # noqa: E501

        apiKey to be used for all other requests  # noqa: E501

        :return: The client_api_key of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._client_api_key

    @client_api_key.setter
    def client_api_key(self, client_api_key):
        """Sets the client_api_key of this APIConfig.

        apiKey to be used for all other requests  # noqa: E501

        :param client_api_key: The client_api_key of this APIConfig.  # noqa: E501
        :type client_api_key: str
        """
        if self.local_vars_configuration.client_side_validation and client_api_key is None:  # noqa: E501
            raise ValueError("Invalid value for `client_api_key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                client_api_key is not None and len(client_api_key) < 1):
            raise ValueError("Invalid value for `client_api_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._client_api_key = client_api_key

    @property
    def client_bps_ceiling(self):
        """Gets the client_bps_ceiling of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_bps_ceiling of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_bps_ceiling

    @client_bps_ceiling.setter
    def client_bps_ceiling(self, client_bps_ceiling):
        """Sets the client_bps_ceiling of this APIConfig.

        Unknown  # noqa: E501

        :param client_bps_ceiling: The client_bps_ceiling of this APIConfig.  # noqa: E501
        :type client_bps_ceiling: int
        """
        if self.local_vars_configuration.client_side_validation and client_bps_ceiling is None:  # noqa: E501
            raise ValueError("Invalid value for `client_bps_ceiling`, must not be `None`")  # noqa: E501

        self._client_bps_ceiling = client_bps_ceiling

    @property
    def client_disconnect_timeout(self):
        """Gets the client_disconnect_timeout of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_disconnect_timeout of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_disconnect_timeout

    @client_disconnect_timeout.setter
    def client_disconnect_timeout(self, client_disconnect_timeout):
        """Sets the client_disconnect_timeout of this APIConfig.

        Unknown  # noqa: E501

        :param client_disconnect_timeout: The client_disconnect_timeout of this APIConfig.  # noqa: E501
        :type client_disconnect_timeout: int
        """
        if self.local_vars_configuration.client_side_validation and client_disconnect_timeout is None:  # noqa: E501
            raise ValueError("Invalid value for `client_disconnect_timeout`, must not be `None`")  # noqa: E501

        self._client_disconnect_timeout = client_disconnect_timeout

    @property
    def client_reserved_player_bps(self):
        """Gets the client_reserved_player_bps of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_reserved_player_bps of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_reserved_player_bps

    @client_reserved_player_bps.setter
    def client_reserved_player_bps(self, client_reserved_player_bps):
        """Sets the client_reserved_player_bps of this APIConfig.

        Unknown  # noqa: E501

        :param client_reserved_player_bps: The client_reserved_player_bps of this APIConfig.  # noqa: E501
        :type client_reserved_player_bps: int
        """
        if self.local_vars_configuration.client_side_validation and client_reserved_player_bps is None:  # noqa: E501
            raise ValueError("Invalid value for `client_reserved_player_bps`, must not be `None`")  # noqa: E501

        self._client_reserved_player_bps = client_reserved_player_bps

    @property
    def client_sent_count_allowance(self):
        """Gets the client_sent_count_allowance of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_sent_count_allowance of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_sent_count_allowance

    @client_sent_count_allowance.setter
    def client_sent_count_allowance(self, client_sent_count_allowance):
        """Sets the client_sent_count_allowance of this APIConfig.

        Unknown  # noqa: E501

        :param client_sent_count_allowance: The client_sent_count_allowance of this APIConfig.  # noqa: E501
        :type client_sent_count_allowance: int
        """
        if self.local_vars_configuration.client_side_validation and client_sent_count_allowance is None:  # noqa: E501
            raise ValueError("Invalid value for `client_sent_count_allowance`, must not be `None`")  # noqa: E501

        self._client_sent_count_allowance = client_sent_count_allowance

    @property
    def contact_email(self):
        """Gets the contact_email of this APIConfig.  # noqa: E501

        VRChat's contact email  # noqa: E501

        :return: The contact_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._contact_email

    @contact_email.setter
    def contact_email(self, contact_email):
        """Sets the contact_email of this APIConfig.

        VRChat's contact email  # noqa: E501

        :param contact_email: The contact_email of this APIConfig.  # noqa: E501
        :type contact_email: str
        """
        if self.local_vars_configuration.client_side_validation and contact_email is None:  # noqa: E501
            raise ValueError("Invalid value for `contact_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                contact_email is not None and len(contact_email) < 1):
            raise ValueError("Invalid value for `contact_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._contact_email = contact_email

    @property
    def copyright_email(self):
        """Gets the copyright_email of this APIConfig.  # noqa: E501

        VRChat's copyright-issues-related email  # noqa: E501

        :return: The copyright_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._copyright_email

    @copyright_email.setter
    def copyright_email(self, copyright_email):
        """Sets the copyright_email of this APIConfig.

        VRChat's copyright-issues-related email  # noqa: E501

        :param copyright_email: The copyright_email of this APIConfig.  # noqa: E501
        :type copyright_email: str
        """
        if self.local_vars_configuration.client_side_validation and copyright_email is None:  # noqa: E501
            raise ValueError("Invalid value for `copyright_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                copyright_email is not None and len(copyright_email) < 1):
            raise ValueError("Invalid value for `copyright_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._copyright_email = copyright_email

    @property
    def current_tos_version(self):
        """Gets the current_tos_version of this APIConfig.  # noqa: E501

        Current version number of the Terms of Service  # noqa: E501

        :return: The current_tos_version of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._current_tos_version

    @current_tos_version.setter
    def current_tos_version(self, current_tos_version):
        """Sets the current_tos_version of this APIConfig.

        Current version number of the Terms of Service  # noqa: E501

        :param current_tos_version: The current_tos_version of this APIConfig.  # noqa: E501
        :type current_tos_version: int
        """
        if self.local_vars_configuration.client_side_validation and current_tos_version is None:  # noqa: E501
            raise ValueError("Invalid value for `current_tos_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                current_tos_version is not None and current_tos_version < 0):  # noqa: E501
            raise ValueError("Invalid value for `current_tos_version`, must be a value greater than or equal to `0`")  # noqa: E501

        self._current_tos_version = current_tos_version

    @property
    def default_avatar(self):
        """Gets the default_avatar of this APIConfig.  # noqa: E501


        :return: The default_avatar of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_avatar

    @default_avatar.setter
    def default_avatar(self, default_avatar):
        """Sets the default_avatar of this APIConfig.


        :param default_avatar: The default_avatar of this APIConfig.  # noqa: E501
        :type default_avatar: str
        """
        if self.local_vars_configuration.client_side_validation and default_avatar is None:  # noqa: E501
            raise ValueError("Invalid value for `default_avatar`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                default_avatar is not None and not re.search(r'avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', default_avatar)):  # noqa: E501
            raise ValueError(r"Invalid value for `default_avatar`, must be a follow pattern or equal to `/avtr_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/`")  # noqa: E501

        self._default_avatar = default_avatar

    @property
    def deployment_group(self):
        """Gets the deployment_group of this APIConfig.  # noqa: E501


        :return: The deployment_group of this APIConfig.  # noqa: E501
        :rtype: DeploymentGroup
        """
        return self._deployment_group

    @deployment_group.setter
    def deployment_group(self, deployment_group):
        """Sets the deployment_group of this APIConfig.


        :param deployment_group: The deployment_group of this APIConfig.  # noqa: E501
        :type deployment_group: DeploymentGroup
        """
        if self.local_vars_configuration.client_side_validation and deployment_group is None:  # noqa: E501
            raise ValueError("Invalid value for `deployment_group`, must not be `None`")  # noqa: E501

        self._deployment_group = deployment_group

    @property
    def dev_app_version_standalone(self):
        """Gets the dev_app_version_standalone of this APIConfig.  # noqa: E501

        Version number for game development build  # noqa: E501

        :return: The dev_app_version_standalone of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_app_version_standalone

    @dev_app_version_standalone.setter
    def dev_app_version_standalone(self, dev_app_version_standalone):
        """Sets the dev_app_version_standalone of this APIConfig.

        Version number for game development build  # noqa: E501

        :param dev_app_version_standalone: The dev_app_version_standalone of this APIConfig.  # noqa: E501
        :type dev_app_version_standalone: str
        """
        if self.local_vars_configuration.client_side_validation and dev_app_version_standalone is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_app_version_standalone`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_app_version_standalone is not None and len(dev_app_version_standalone) < 1):
            raise ValueError("Invalid value for `dev_app_version_standalone`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_app_version_standalone = dev_app_version_standalone

    @property
    def dev_download_link_windows(self):
        """Gets the dev_download_link_windows of this APIConfig.  # noqa: E501

        Developer Download link  # noqa: E501

        :return: The dev_download_link_windows of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_download_link_windows

    @dev_download_link_windows.setter
    def dev_download_link_windows(self, dev_download_link_windows):
        """Sets the dev_download_link_windows of this APIConfig.

        Developer Download link  # noqa: E501

        :param dev_download_link_windows: The dev_download_link_windows of this APIConfig.  # noqa: E501
        :type dev_download_link_windows: str
        """
        if self.local_vars_configuration.client_side_validation and dev_download_link_windows is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_download_link_windows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_download_link_windows is not None and len(dev_download_link_windows) < 1):
            raise ValueError("Invalid value for `dev_download_link_windows`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_download_link_windows = dev_download_link_windows

    @property
    def dev_sdk_url(self):
        """Gets the dev_sdk_url of this APIConfig.  # noqa: E501

        Link to download the development SDK, use downloadUrls instead  # noqa: E501

        :return: The dev_sdk_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_sdk_url

    @dev_sdk_url.setter
    def dev_sdk_url(self, dev_sdk_url):
        """Sets the dev_sdk_url of this APIConfig.

        Link to download the development SDK, use downloadUrls instead  # noqa: E501

        :param dev_sdk_url: The dev_sdk_url of this APIConfig.  # noqa: E501
        :type dev_sdk_url: str
        """
        if self.local_vars_configuration.client_side_validation and dev_sdk_url is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_sdk_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_sdk_url is not None and len(dev_sdk_url) < 1):
            raise ValueError("Invalid value for `dev_sdk_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_sdk_url = dev_sdk_url

    @property
    def dev_sdk_version(self):
        """Gets the dev_sdk_version of this APIConfig.  # noqa: E501

        Version of the development SDK  # noqa: E501

        :return: The dev_sdk_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_sdk_version

    @dev_sdk_version.setter
    def dev_sdk_version(self, dev_sdk_version):
        """Sets the dev_sdk_version of this APIConfig.

        Version of the development SDK  # noqa: E501

        :param dev_sdk_version: The dev_sdk_version of this APIConfig.  # noqa: E501
        :type dev_sdk_version: str
        """
        if self.local_vars_configuration.client_side_validation and dev_sdk_version is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_sdk_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_sdk_version is not None and len(dev_sdk_version) < 1):
            raise ValueError("Invalid value for `dev_sdk_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_sdk_version = dev_sdk_version

    @property
    def dev_server_version_standalone(self):
        """Gets the dev_server_version_standalone of this APIConfig.  # noqa: E501

        Version number for server development build  # noqa: E501

        :return: The dev_server_version_standalone of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_server_version_standalone

    @dev_server_version_standalone.setter
    def dev_server_version_standalone(self, dev_server_version_standalone):
        """Sets the dev_server_version_standalone of this APIConfig.

        Version number for server development build  # noqa: E501

        :param dev_server_version_standalone: The dev_server_version_standalone of this APIConfig.  # noqa: E501
        :type dev_server_version_standalone: str
        """
        if self.local_vars_configuration.client_side_validation and dev_server_version_standalone is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_server_version_standalone`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_server_version_standalone is not None and len(dev_server_version_standalone) < 1):
            raise ValueError("Invalid value for `dev_server_version_standalone`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_server_version_standalone = dev_server_version_standalone

    @property
    def dis_countdown(self):
        """Gets the dis_countdown of this APIConfig.  # noqa: E501

        Unknown, \"dis\" maybe for disconnect?  # noqa: E501

        :return: The dis_countdown of this APIConfig.  # noqa: E501
        :rtype: datetime
        """
        return self._dis_countdown

    @dis_countdown.setter
    def dis_countdown(self, dis_countdown):
        """Sets the dis_countdown of this APIConfig.

        Unknown, \"dis\" maybe for disconnect?  # noqa: E501

        :param dis_countdown: The dis_countdown of this APIConfig.  # noqa: E501
        :type dis_countdown: datetime
        """
        if self.local_vars_configuration.client_side_validation and dis_countdown is None:  # noqa: E501
            raise ValueError("Invalid value for `dis_countdown`, must not be `None`")  # noqa: E501

        self._dis_countdown = dis_countdown

    @property
    def disable_avatar_copying(self):
        """Gets the disable_avatar_copying of this APIConfig.  # noqa: E501

        Toggles if copying avatars should be disabled  # noqa: E501

        :return: The disable_avatar_copying of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_avatar_copying

    @disable_avatar_copying.setter
    def disable_avatar_copying(self, disable_avatar_copying):
        """Sets the disable_avatar_copying of this APIConfig.

        Toggles if copying avatars should be disabled  # noqa: E501

        :param disable_avatar_copying: The disable_avatar_copying of this APIConfig.  # noqa: E501
        :type disable_avatar_copying: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_avatar_copying is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_avatar_copying`, must not be `None`")  # noqa: E501

        self._disable_avatar_copying = disable_avatar_copying

    @property
    def disable_avatar_gating(self):
        """Gets the disable_avatar_gating of this APIConfig.  # noqa: E501

        Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag  # noqa: E501

        :return: The disable_avatar_gating of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_avatar_gating

    @disable_avatar_gating.setter
    def disable_avatar_gating(self, disable_avatar_gating):
        """Sets the disable_avatar_gating of this APIConfig.

        Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag  # noqa: E501

        :param disable_avatar_gating: The disable_avatar_gating of this APIConfig.  # noqa: E501
        :type disable_avatar_gating: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_avatar_gating is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_avatar_gating`, must not be `None`")  # noqa: E501

        self._disable_avatar_gating = disable_avatar_gating

    @property
    def disable_community_labs(self):
        """Gets the disable_community_labs of this APIConfig.  # noqa: E501

        Toggles if the Community Labs should be disabled  # noqa: E501

        :return: The disable_community_labs of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_community_labs

    @disable_community_labs.setter
    def disable_community_labs(self, disable_community_labs):
        """Sets the disable_community_labs of this APIConfig.

        Toggles if the Community Labs should be disabled  # noqa: E501

        :param disable_community_labs: The disable_community_labs of this APIConfig.  # noqa: E501
        :type disable_community_labs: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_community_labs is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_community_labs`, must not be `None`")  # noqa: E501

        self._disable_community_labs = disable_community_labs

    @property
    def disable_community_labs_promotion(self):
        """Gets the disable_community_labs_promotion of this APIConfig.  # noqa: E501

        Toggles if promotion out of Community Labs should be disabled  # noqa: E501

        :return: The disable_community_labs_promotion of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_community_labs_promotion

    @disable_community_labs_promotion.setter
    def disable_community_labs_promotion(self, disable_community_labs_promotion):
        """Sets the disable_community_labs_promotion of this APIConfig.

        Toggles if promotion out of Community Labs should be disabled  # noqa: E501

        :param disable_community_labs_promotion: The disable_community_labs_promotion of this APIConfig.  # noqa: E501
        :type disable_community_labs_promotion: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_community_labs_promotion is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_community_labs_promotion`, must not be `None`")  # noqa: E501

        self._disable_community_labs_promotion = disable_community_labs_promotion

    @property
    def disable_email(self):
        """Gets the disable_email of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_email of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_email

    @disable_email.setter
    def disable_email(self, disable_email):
        """Sets the disable_email of this APIConfig.

        Unknown  # noqa: E501

        :param disable_email: The disable_email of this APIConfig.  # noqa: E501
        :type disable_email: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_email is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_email`, must not be `None`")  # noqa: E501

        self._disable_email = disable_email

    @property
    def disable_event_stream(self):
        """Gets the disable_event_stream of this APIConfig.  # noqa: E501

        Toggles if Analytics should be disabled.  # noqa: E501

        :return: The disable_event_stream of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_event_stream

    @disable_event_stream.setter
    def disable_event_stream(self, disable_event_stream):
        """Sets the disable_event_stream of this APIConfig.

        Toggles if Analytics should be disabled.  # noqa: E501

        :param disable_event_stream: The disable_event_stream of this APIConfig.  # noqa: E501
        :type disable_event_stream: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_event_stream is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_event_stream`, must not be `None`")  # noqa: E501

        self._disable_event_stream = disable_event_stream

    @property
    def disable_feedback_gating(self):
        """Gets the disable_feedback_gating of this APIConfig.  # noqa: E501

        Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.  # noqa: E501

        :return: The disable_feedback_gating of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_feedback_gating

    @disable_feedback_gating.setter
    def disable_feedback_gating(self, disable_feedback_gating):
        """Sets the disable_feedback_gating of this APIConfig.

        Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.  # noqa: E501

        :param disable_feedback_gating: The disable_feedback_gating of this APIConfig.  # noqa: E501
        :type disable_feedback_gating: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_feedback_gating is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_feedback_gating`, must not be `None`")  # noqa: E501

        self._disable_feedback_gating = disable_feedback_gating

    @property
    def disable_frontend_builds(self):
        """Gets the disable_frontend_builds of this APIConfig.  # noqa: E501

        Unknown, probably toggles compilation of frontend web builds? So internal flag?  # noqa: E501

        :return: The disable_frontend_builds of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_frontend_builds

    @disable_frontend_builds.setter
    def disable_frontend_builds(self, disable_frontend_builds):
        """Sets the disable_frontend_builds of this APIConfig.

        Unknown, probably toggles compilation of frontend web builds? So internal flag?  # noqa: E501

        :param disable_frontend_builds: The disable_frontend_builds of this APIConfig.  # noqa: E501
        :type disable_frontend_builds: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_frontend_builds is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_frontend_builds`, must not be `None`")  # noqa: E501

        self._disable_frontend_builds = disable_frontend_builds

    @property
    def disable_hello(self):
        """Gets the disable_hello of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_hello of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_hello

    @disable_hello.setter
    def disable_hello(self, disable_hello):
        """Sets the disable_hello of this APIConfig.

        Unknown  # noqa: E501

        :param disable_hello: The disable_hello of this APIConfig.  # noqa: E501
        :type disable_hello: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_hello is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_hello`, must not be `None`")  # noqa: E501

        self._disable_hello = disable_hello

    @property
    def disable_oculus_subs(self):
        """Gets the disable_oculus_subs of this APIConfig.  # noqa: E501

        Toggles if signing up for Subscriptions in Oculus is disabled or not.  # noqa: E501

        :return: The disable_oculus_subs of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_oculus_subs

    @disable_oculus_subs.setter
    def disable_oculus_subs(self, disable_oculus_subs):
        """Sets the disable_oculus_subs of this APIConfig.

        Toggles if signing up for Subscriptions in Oculus is disabled or not.  # noqa: E501

        :param disable_oculus_subs: The disable_oculus_subs of this APIConfig.  # noqa: E501
        :type disable_oculus_subs: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_oculus_subs is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_oculus_subs`, must not be `None`")  # noqa: E501

        self._disable_oculus_subs = disable_oculus_subs

    @property
    def disable_registration(self):
        """Gets the disable_registration of this APIConfig.  # noqa: E501

        Toggles if new user account registration should be disabled.  # noqa: E501

        :return: The disable_registration of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_registration

    @disable_registration.setter
    def disable_registration(self, disable_registration):
        """Sets the disable_registration of this APIConfig.

        Toggles if new user account registration should be disabled.  # noqa: E501

        :param disable_registration: The disable_registration of this APIConfig.  # noqa: E501
        :type disable_registration: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_registration is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_registration`, must not be `None`")  # noqa: E501

        self._disable_registration = disable_registration

    @property
    def disable_steam_networking(self):
        """Gets the disable_steam_networking of this APIConfig.  # noqa: E501

        Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.  # noqa: E501

        :return: The disable_steam_networking of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_steam_networking

    @disable_steam_networking.setter
    def disable_steam_networking(self, disable_steam_networking):
        """Sets the disable_steam_networking of this APIConfig.

        Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.  # noqa: E501

        :param disable_steam_networking: The disable_steam_networking of this APIConfig.  # noqa: E501
        :type disable_steam_networking: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_steam_networking is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_steam_networking`, must not be `None`")  # noqa: E501

        self._disable_steam_networking = disable_steam_networking

    @property
    def disable_two_factor_auth(self):
        """Gets the disable_two_factor_auth of this APIConfig.  # noqa: E501

        Toggles if 2FA should be disabled.  # noqa: E501

        :return: The disable_two_factor_auth of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_two_factor_auth

    @disable_two_factor_auth.setter
    def disable_two_factor_auth(self, disable_two_factor_auth):
        """Sets the disable_two_factor_auth of this APIConfig.

        Toggles if 2FA should be disabled.  # noqa: E501

        :param disable_two_factor_auth: The disable_two_factor_auth of this APIConfig.  # noqa: E501
        :type disable_two_factor_auth: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_two_factor_auth is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_two_factor_auth`, must not be `None`")  # noqa: E501

        self._disable_two_factor_auth = disable_two_factor_auth

    @property
    def disable_udon(self):
        """Gets the disable_udon of this APIConfig.  # noqa: E501

        Toggles if Udon should be universally disabled in-game.  # noqa: E501

        :return: The disable_udon of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_udon

    @disable_udon.setter
    def disable_udon(self, disable_udon):
        """Sets the disable_udon of this APIConfig.

        Toggles if Udon should be universally disabled in-game.  # noqa: E501

        :param disable_udon: The disable_udon of this APIConfig.  # noqa: E501
        :type disable_udon: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_udon is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_udon`, must not be `None`")  # noqa: E501

        self._disable_udon = disable_udon

    @property
    def disable_upgrade_account(self):
        """Gets the disable_upgrade_account of this APIConfig.  # noqa: E501

        Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.  # noqa: E501

        :return: The disable_upgrade_account of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_upgrade_account

    @disable_upgrade_account.setter
    def disable_upgrade_account(self, disable_upgrade_account):
        """Sets the disable_upgrade_account of this APIConfig.

        Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.  # noqa: E501

        :param disable_upgrade_account: The disable_upgrade_account of this APIConfig.  # noqa: E501
        :type disable_upgrade_account: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_upgrade_account is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_upgrade_account`, must not be `None`")  # noqa: E501

        self._disable_upgrade_account = disable_upgrade_account

    @property
    def download_link_windows(self):
        """Gets the download_link_windows of this APIConfig.  # noqa: E501

        Download link for game on the Oculus Rift website.  # noqa: E501

        :return: The download_link_windows of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._download_link_windows

    @download_link_windows.setter
    def download_link_windows(self, download_link_windows):
        """Sets the download_link_windows of this APIConfig.

        Download link for game on the Oculus Rift website.  # noqa: E501

        :param download_link_windows: The download_link_windows of this APIConfig.  # noqa: E501
        :type download_link_windows: str
        """
        if self.local_vars_configuration.client_side_validation and download_link_windows is None:  # noqa: E501
            raise ValueError("Invalid value for `download_link_windows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                download_link_windows is not None and len(download_link_windows) < 1):
            raise ValueError("Invalid value for `download_link_windows`, length must be greater than or equal to `1`")  # noqa: E501

        self._download_link_windows = download_link_windows

    @property
    def download_urls(self):
        """Gets the download_urls of this APIConfig.  # noqa: E501


        :return: The download_urls of this APIConfig.  # noqa: E501
        :rtype: APIConfigDownloadURLList
        """
        return self._download_urls

    @download_urls.setter
    def download_urls(self, download_urls):
        """Sets the download_urls of this APIConfig.


        :param download_urls: The download_urls of this APIConfig.  # noqa: E501
        :type download_urls: APIConfigDownloadURLList
        """
        if self.local_vars_configuration.client_side_validation and download_urls is None:  # noqa: E501
            raise ValueError("Invalid value for `download_urls`, must not be `None`")  # noqa: E501

        self._download_urls = download_urls

    @property
    def dynamic_world_rows(self):
        """Gets the dynamic_world_rows of this APIConfig.  # noqa: E501

        Array of DynamicWorldRow objects, used by the game to display the list of world rows  # noqa: E501

        :return: The dynamic_world_rows of this APIConfig.  # noqa: E501
        :rtype: list[DynamicContentRow]
        """
        return self._dynamic_world_rows

    @dynamic_world_rows.setter
    def dynamic_world_rows(self, dynamic_world_rows):
        """Sets the dynamic_world_rows of this APIConfig.

        Array of DynamicWorldRow objects, used by the game to display the list of world rows  # noqa: E501

        :param dynamic_world_rows: The dynamic_world_rows of this APIConfig.  # noqa: E501
        :type dynamic_world_rows: list[DynamicContentRow]
        """
        if self.local_vars_configuration.client_side_validation and dynamic_world_rows is None:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_world_rows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dynamic_world_rows is not None and len(dynamic_world_rows) < 1):
            raise ValueError("Invalid value for `dynamic_world_rows`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._dynamic_world_rows = dynamic_world_rows

    @property
    def events(self):
        """Gets the events of this APIConfig.  # noqa: E501


        :return: The events of this APIConfig.  # noqa: E501
        :rtype: APIConfigEvents
        """
        return self._events

    @events.setter
    def events(self, events):
        """Sets the events of this APIConfig.


        :param events: The events of this APIConfig.  # noqa: E501
        :type events: APIConfigEvents
        """
        if self.local_vars_configuration.client_side_validation and events is None:  # noqa: E501
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501

        self._events = events

    @property
    def gear_demo_room_id(self):
        """Gets the gear_demo_room_id of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The gear_demo_room_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._gear_demo_room_id

    @gear_demo_room_id.setter
    def gear_demo_room_id(self, gear_demo_room_id):
        """Sets the gear_demo_room_id of this APIConfig.

        Unknown  # noqa: E501

        :param gear_demo_room_id: The gear_demo_room_id of this APIConfig.  # noqa: E501
        :type gear_demo_room_id: str
        """
        if self.local_vars_configuration.client_side_validation and gear_demo_room_id is None:  # noqa: E501
            raise ValueError("Invalid value for `gear_demo_room_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                gear_demo_room_id is not None and len(gear_demo_room_id) < 1):
            raise ValueError("Invalid value for `gear_demo_room_id`, length must be greater than or equal to `1`")  # noqa: E501

        self._gear_demo_room_id = gear_demo_room_id

    @property
    def home_world_id(self):
        """Gets the home_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The home_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._home_world_id

    @home_world_id.setter
    def home_world_id(self, home_world_id):
        """Sets the home_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param home_world_id: The home_world_id of this APIConfig.  # noqa: E501
        :type home_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and home_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `home_world_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                home_world_id is not None and not re.search(r'(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})', home_world_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `home_world_id`, must be a follow pattern or equal to `/(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})/`")  # noqa: E501

        self._home_world_id = home_world_id

    @property
    def homepage_redirect_target(self):
        """Gets the homepage_redirect_target of this APIConfig.  # noqa: E501

        Redirect target if you try to open the base API domain in your browser  # noqa: E501

        :return: The homepage_redirect_target of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._homepage_redirect_target

    @homepage_redirect_target.setter
    def homepage_redirect_target(self, homepage_redirect_target):
        """Sets the homepage_redirect_target of this APIConfig.

        Redirect target if you try to open the base API domain in your browser  # noqa: E501

        :param homepage_redirect_target: The homepage_redirect_target of this APIConfig.  # noqa: E501
        :type homepage_redirect_target: str
        """
        if self.local_vars_configuration.client_side_validation and homepage_redirect_target is None:  # noqa: E501
            raise ValueError("Invalid value for `homepage_redirect_target`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                homepage_redirect_target is not None and len(homepage_redirect_target) < 1):
            raise ValueError("Invalid value for `homepage_redirect_target`, length must be greater than or equal to `1`")  # noqa: E501

        self._homepage_redirect_target = homepage_redirect_target

    @property
    def hub_world_id(self):
        """Gets the hub_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The hub_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._hub_world_id

    @hub_world_id.setter
    def hub_world_id(self, hub_world_id):
        """Sets the hub_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param hub_world_id: The hub_world_id of this APIConfig.  # noqa: E501
        :type hub_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and hub_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `hub_world_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                hub_world_id is not None and not re.search(r'(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})', hub_world_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `hub_world_id`, must be a follow pattern or equal to `/(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})/`")  # noqa: E501

        self._hub_world_id = hub_world_id

    @property
    def jobs_email(self):
        """Gets the jobs_email of this APIConfig.  # noqa: E501

        VRChat's job application email  # noqa: E501

        :return: The jobs_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._jobs_email

    @jobs_email.setter
    def jobs_email(self, jobs_email):
        """Sets the jobs_email of this APIConfig.

        VRChat's job application email  # noqa: E501

        :param jobs_email: The jobs_email of this APIConfig.  # noqa: E501
        :type jobs_email: str
        """
        if self.local_vars_configuration.client_side_validation and jobs_email is None:  # noqa: E501
            raise ValueError("Invalid value for `jobs_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                jobs_email is not None and len(jobs_email) < 1):
            raise ValueError("Invalid value for `jobs_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._jobs_email = jobs_email

    @property
    def message_of_the_day(self):
        """Gets the message_of_the_day of this APIConfig.  # noqa: E501

        MOTD  # noqa: E501

        :return: The message_of_the_day of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._message_of_the_day

    @message_of_the_day.setter
    def message_of_the_day(self, message_of_the_day):
        """Sets the message_of_the_day of this APIConfig.

        MOTD  # noqa: E501

        :param message_of_the_day: The message_of_the_day of this APIConfig.  # noqa: E501
        :type message_of_the_day: str
        """
        if self.local_vars_configuration.client_side_validation and message_of_the_day is None:  # noqa: E501
            raise ValueError("Invalid value for `message_of_the_day`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                message_of_the_day is not None and len(message_of_the_day) < 1):
            raise ValueError("Invalid value for `message_of_the_day`, length must be greater than or equal to `1`")  # noqa: E501

        self._message_of_the_day = message_of_the_day

    @property
    def moderation_email(self):
        """Gets the moderation_email of this APIConfig.  # noqa: E501

        VRChat's moderation related email  # noqa: E501

        :return: The moderation_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._moderation_email

    @moderation_email.setter
    def moderation_email(self, moderation_email):
        """Sets the moderation_email of this APIConfig.

        VRChat's moderation related email  # noqa: E501

        :param moderation_email: The moderation_email of this APIConfig.  # noqa: E501
        :type moderation_email: str
        """
        if self.local_vars_configuration.client_side_validation and moderation_email is None:  # noqa: E501
            raise ValueError("Invalid value for `moderation_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                moderation_email is not None and len(moderation_email) < 1):
            raise ValueError("Invalid value for `moderation_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._moderation_email = moderation_email

    @property
    def moderation_query_period(self):
        """Gets the moderation_query_period of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The moderation_query_period of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._moderation_query_period

    @moderation_query_period.setter
    def moderation_query_period(self, moderation_query_period):
        """Sets the moderation_query_period of this APIConfig.

        Unknown  # noqa: E501

        :param moderation_query_period: The moderation_query_period of this APIConfig.  # noqa: E501
        :type moderation_query_period: int
        """
        if self.local_vars_configuration.client_side_validation and moderation_query_period is None:  # noqa: E501
            raise ValueError("Invalid value for `moderation_query_period`, must not be `None`")  # noqa: E501

        self._moderation_query_period = moderation_query_period

    @property
    def not_allowed_to_select_avatar_in_private_world_message(self):
        """Gets the not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501

        Used in-game to notify a user they aren't allowed to select avatars in private worlds  # noqa: E501

        :return: The not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._not_allowed_to_select_avatar_in_private_world_message

    @not_allowed_to_select_avatar_in_private_world_message.setter
    def not_allowed_to_select_avatar_in_private_world_message(self, not_allowed_to_select_avatar_in_private_world_message):
        """Sets the not_allowed_to_select_avatar_in_private_world_message of this APIConfig.

        Used in-game to notify a user they aren't allowed to select avatars in private worlds  # noqa: E501

        :param not_allowed_to_select_avatar_in_private_world_message: The not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501
        :type not_allowed_to_select_avatar_in_private_world_message: str
        """
        if self.local_vars_configuration.client_side_validation and not_allowed_to_select_avatar_in_private_world_message is None:  # noqa: E501
            raise ValueError("Invalid value for `not_allowed_to_select_avatar_in_private_world_message`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not_allowed_to_select_avatar_in_private_world_message is not None and len(not_allowed_to_select_avatar_in_private_world_message) < 1):
            raise ValueError("Invalid value for `not_allowed_to_select_avatar_in_private_world_message`, length must be greater than or equal to `1`")  # noqa: E501

        self._not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message

    @property
    def plugin(self):
        """Gets the plugin of this APIConfig.  # noqa: E501

        Extra [plugin](https://doc.photonengine.com/en-us/server/current/plugins/manual) to run in each instance  # noqa: E501

        :return: The plugin of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._plugin

    @plugin.setter
    def plugin(self, plugin):
        """Sets the plugin of this APIConfig.

        Extra [plugin](https://doc.photonengine.com/en-us/server/current/plugins/manual) to run in each instance  # noqa: E501

        :param plugin: The plugin of this APIConfig.  # noqa: E501
        :type plugin: str
        """
        if self.local_vars_configuration.client_side_validation and plugin is None:  # noqa: E501
            raise ValueError("Invalid value for `plugin`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                plugin is not None and len(plugin) < 1):
            raise ValueError("Invalid value for `plugin`, length must be greater than or equal to `1`")  # noqa: E501

        self._plugin = plugin

    @property
    def release_app_version_standalone(self):
        """Gets the release_app_version_standalone of this APIConfig.  # noqa: E501

        Version number for game release build  # noqa: E501

        :return: The release_app_version_standalone of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._release_app_version_standalone

    @release_app_version_standalone.setter
    def release_app_version_standalone(self, release_app_version_standalone):
        """Sets the release_app_version_standalone of this APIConfig.

        Version number for game release build  # noqa: E501

        :param release_app_version_standalone: The release_app_version_standalone of this APIConfig.  # noqa: E501
        :type release_app_version_standalone: str
        """
        if self.local_vars_configuration.client_side_validation and release_app_version_standalone is None:  # noqa: E501
            raise ValueError("Invalid value for `release_app_version_standalone`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                release_app_version_standalone is not None and len(release_app_version_standalone) < 1):
            raise ValueError("Invalid value for `release_app_version_standalone`, length must be greater than or equal to `1`")  # noqa: E501

        self._release_app_version_standalone = release_app_version_standalone

    @property
    def release_sdk_url(self):
        """Gets the release_sdk_url of this APIConfig.  # noqa: E501

        Link to download the release SDK  # noqa: E501

        :return: The release_sdk_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._release_sdk_url

    @release_sdk_url.setter
    def release_sdk_url(self, release_sdk_url):
        """Sets the release_sdk_url of this APIConfig.

        Link to download the release SDK  # noqa: E501

        :param release_sdk_url: The release_sdk_url of this APIConfig.  # noqa: E501
        :type release_sdk_url: str
        """
        if self.local_vars_configuration.client_side_validation and release_sdk_url is None:  # noqa: E501
            raise ValueError("Invalid value for `release_sdk_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                release_sdk_url is not None and len(release_sdk_url) < 1):
            raise ValueError("Invalid value for `release_sdk_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._release_sdk_url = release_sdk_url

    @property
    def release_sdk_version(self):
        """Gets the release_sdk_version of this APIConfig.  # noqa: E501

        Version of the release SDK  # noqa: E501

        :return: The release_sdk_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._release_sdk_version

    @release_sdk_version.setter
    def release_sdk_version(self, release_sdk_version):
        """Sets the release_sdk_version of this APIConfig.

        Version of the release SDK  # noqa: E501

        :param release_sdk_version: The release_sdk_version of this APIConfig.  # noqa: E501
        :type release_sdk_version: str
        """
        if self.local_vars_configuration.client_side_validation and release_sdk_version is None:  # noqa: E501
            raise ValueError("Invalid value for `release_sdk_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                release_sdk_version is not None and len(release_sdk_version) < 1):
            raise ValueError("Invalid value for `release_sdk_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._release_sdk_version = release_sdk_version

    @property
    def release_server_version_standalone(self):
        """Gets the release_server_version_standalone of this APIConfig.  # noqa: E501

        Version number for server release build  # noqa: E501

        :return: The release_server_version_standalone of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._release_server_version_standalone

    @release_server_version_standalone.setter
    def release_server_version_standalone(self, release_server_version_standalone):
        """Sets the release_server_version_standalone of this APIConfig.

        Version number for server release build  # noqa: E501

        :param release_server_version_standalone: The release_server_version_standalone of this APIConfig.  # noqa: E501
        :type release_server_version_standalone: str
        """
        if self.local_vars_configuration.client_side_validation and release_server_version_standalone is None:  # noqa: E501
            raise ValueError("Invalid value for `release_server_version_standalone`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                release_server_version_standalone is not None and len(release_server_version_standalone) < 1):
            raise ValueError("Invalid value for `release_server_version_standalone`, length must be greater than or equal to `1`")  # noqa: E501

        self._release_server_version_standalone = release_server_version_standalone

    @property
    def sdk_developer_faq_url(self):
        """Gets the sdk_developer_faq_url of this APIConfig.  # noqa: E501

        Link to the developer FAQ  # noqa: E501

        :return: The sdk_developer_faq_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_developer_faq_url

    @sdk_developer_faq_url.setter
    def sdk_developer_faq_url(self, sdk_developer_faq_url):
        """Sets the sdk_developer_faq_url of this APIConfig.

        Link to the developer FAQ  # noqa: E501

        :param sdk_developer_faq_url: The sdk_developer_faq_url of this APIConfig.  # noqa: E501
        :type sdk_developer_faq_url: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_developer_faq_url is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_developer_faq_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_developer_faq_url is not None and len(sdk_developer_faq_url) < 1):
            raise ValueError("Invalid value for `sdk_developer_faq_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_developer_faq_url = sdk_developer_faq_url

    @property
    def sdk_discord_url(self):
        """Gets the sdk_discord_url of this APIConfig.  # noqa: E501

        Link to the official VRChat Discord  # noqa: E501

        :return: The sdk_discord_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_discord_url

    @sdk_discord_url.setter
    def sdk_discord_url(self, sdk_discord_url):
        """Sets the sdk_discord_url of this APIConfig.

        Link to the official VRChat Discord  # noqa: E501

        :param sdk_discord_url: The sdk_discord_url of this APIConfig.  # noqa: E501
        :type sdk_discord_url: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_discord_url is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_discord_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_discord_url is not None and len(sdk_discord_url) < 1):
            raise ValueError("Invalid value for `sdk_discord_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_discord_url = sdk_discord_url

    @property
    def sdk_not_allowed_to_publish_message(self):
        """Gets the sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501

        Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet  # noqa: E501

        :return: The sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_not_allowed_to_publish_message

    @sdk_not_allowed_to_publish_message.setter
    def sdk_not_allowed_to_publish_message(self, sdk_not_allowed_to_publish_message):
        """Sets the sdk_not_allowed_to_publish_message of this APIConfig.

        Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet  # noqa: E501

        :param sdk_not_allowed_to_publish_message: The sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501
        :type sdk_not_allowed_to_publish_message: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_not_allowed_to_publish_message is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_not_allowed_to_publish_message`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_not_allowed_to_publish_message is not None and len(sdk_not_allowed_to_publish_message) < 1):
            raise ValueError("Invalid value for `sdk_not_allowed_to_publish_message`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message

    @property
    def sdk_unity_version(self):
        """Gets the sdk_unity_version of this APIConfig.  # noqa: E501

        Unity version supported by the SDK  # noqa: E501

        :return: The sdk_unity_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_unity_version

    @sdk_unity_version.setter
    def sdk_unity_version(self, sdk_unity_version):
        """Sets the sdk_unity_version of this APIConfig.

        Unity version supported by the SDK  # noqa: E501

        :param sdk_unity_version: The sdk_unity_version of this APIConfig.  # noqa: E501
        :type sdk_unity_version: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_unity_version is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_unity_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_unity_version is not None and len(sdk_unity_version) < 1):
            raise ValueError("Invalid value for `sdk_unity_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_unity_version = sdk_unity_version

    @property
    def server_name(self):
        """Gets the server_name of this APIConfig.  # noqa: E501

        Server name of the API server currently responding  # noqa: E501

        :return: The server_name of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._server_name

    @server_name.setter
    def server_name(self, server_name):
        """Sets the server_name of this APIConfig.

        Server name of the API server currently responding  # noqa: E501

        :param server_name: The server_name of this APIConfig.  # noqa: E501
        :type server_name: str
        """
        if self.local_vars_configuration.client_side_validation and server_name is None:  # noqa: E501
            raise ValueError("Invalid value for `server_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                server_name is not None and len(server_name) < 1):
            raise ValueError("Invalid value for `server_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._server_name = server_name

    @property
    def support_email(self):
        """Gets the support_email of this APIConfig.  # noqa: E501

        VRChat's support email  # noqa: E501

        :return: The support_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._support_email

    @support_email.setter
    def support_email(self, support_email):
        """Sets the support_email of this APIConfig.

        VRChat's support email  # noqa: E501

        :param support_email: The support_email of this APIConfig.  # noqa: E501
        :type support_email: str
        """
        if self.local_vars_configuration.client_side_validation and support_email is None:  # noqa: E501
            raise ValueError("Invalid value for `support_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                support_email is not None and len(support_email) < 1):
            raise ValueError("Invalid value for `support_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._support_email = support_email

    @property
    def time_out_world_id(self):
        """Gets the time_out_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The time_out_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._time_out_world_id

    @time_out_world_id.setter
    def time_out_world_id(self, time_out_world_id):
        """Sets the time_out_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param time_out_world_id: The time_out_world_id of this APIConfig.  # noqa: E501
        :type time_out_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and time_out_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `time_out_world_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                time_out_world_id is not None and not re.search(r'(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})', time_out_world_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `time_out_world_id`, must be a follow pattern or equal to `/(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})/`")  # noqa: E501

        self._time_out_world_id = time_out_world_id

    @property
    def tutorial_world_id(self):
        """Gets the tutorial_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The tutorial_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._tutorial_world_id

    @tutorial_world_id.setter
    def tutorial_world_id(self, tutorial_world_id):
        """Sets the tutorial_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param tutorial_world_id: The tutorial_world_id of this APIConfig.  # noqa: E501
        :type tutorial_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and tutorial_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `tutorial_world_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                tutorial_world_id is not None and not re.search(r'(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})', tutorial_world_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `tutorial_world_id`, must be a follow pattern or equal to `/(^$|offline|(wrld|wld)_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})/`")  # noqa: E501

        self._tutorial_world_id = tutorial_world_id

    @property
    def update_rate_ms_maximum(self):
        """Gets the update_rate_ms_maximum of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_maximum of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_maximum

    @update_rate_ms_maximum.setter
    def update_rate_ms_maximum(self, update_rate_ms_maximum):
        """Sets the update_rate_ms_maximum of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_maximum: The update_rate_ms_maximum of this APIConfig.  # noqa: E501
        :type update_rate_ms_maximum: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_maximum is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_maximum`, must not be `None`")  # noqa: E501

        self._update_rate_ms_maximum = update_rate_ms_maximum

    @property
    def update_rate_ms_minimum(self):
        """Gets the update_rate_ms_minimum of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_minimum of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_minimum

    @update_rate_ms_minimum.setter
    def update_rate_ms_minimum(self, update_rate_ms_minimum):
        """Sets the update_rate_ms_minimum of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_minimum: The update_rate_ms_minimum of this APIConfig.  # noqa: E501
        :type update_rate_ms_minimum: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_minimum is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_minimum`, must not be `None`")  # noqa: E501

        self._update_rate_ms_minimum = update_rate_ms_minimum

    @property
    def update_rate_ms_normal(self):
        """Gets the update_rate_ms_normal of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_normal of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_normal

    @update_rate_ms_normal.setter
    def update_rate_ms_normal(self, update_rate_ms_normal):
        """Sets the update_rate_ms_normal of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_normal: The update_rate_ms_normal of this APIConfig.  # noqa: E501
        :type update_rate_ms_normal: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_normal is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_normal`, must not be `None`")  # noqa: E501

        self._update_rate_ms_normal = update_rate_ms_normal

    @property
    def update_rate_ms_udon_manual(self):
        """Gets the update_rate_ms_udon_manual of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_udon_manual of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_udon_manual

    @update_rate_ms_udon_manual.setter
    def update_rate_ms_udon_manual(self, update_rate_ms_udon_manual):
        """Sets the update_rate_ms_udon_manual of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_udon_manual: The update_rate_ms_udon_manual of this APIConfig.  # noqa: E501
        :type update_rate_ms_udon_manual: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_udon_manual is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_udon_manual`, must not be `None`")  # noqa: E501

        self._update_rate_ms_udon_manual = update_rate_ms_udon_manual

    @property
    def upload_analysis_percent(self):
        """Gets the upload_analysis_percent of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The upload_analysis_percent of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._upload_analysis_percent

    @upload_analysis_percent.setter
    def upload_analysis_percent(self, upload_analysis_percent):
        """Sets the upload_analysis_percent of this APIConfig.

        Unknown  # noqa: E501

        :param upload_analysis_percent: The upload_analysis_percent of this APIConfig.  # noqa: E501
        :type upload_analysis_percent: int
        """
        if self.local_vars_configuration.client_side_validation and upload_analysis_percent is None:  # noqa: E501
            raise ValueError("Invalid value for `upload_analysis_percent`, must not be `None`")  # noqa: E501

        self._upload_analysis_percent = upload_analysis_percent

    @property
    def url_list(self):
        """Gets the url_list of this APIConfig.  # noqa: E501

        List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game  # noqa: E501

        :return: The url_list of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._url_list

    @url_list.setter
    def url_list(self, url_list):
        """Sets the url_list of this APIConfig.

        List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game  # noqa: E501

        :param url_list: The url_list of this APIConfig.  # noqa: E501
        :type url_list: list[str]
        """
        if self.local_vars_configuration.client_side_validation and url_list is None:  # noqa: E501
            raise ValueError("Invalid value for `url_list`, must not be `None`")  # noqa: E501

        self._url_list = url_list

    @property
    def use_reliable_udp_for_voice(self):
        """Gets the use_reliable_udp_for_voice of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The use_reliable_udp_for_voice of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._use_reliable_udp_for_voice

    @use_reliable_udp_for_voice.setter
    def use_reliable_udp_for_voice(self, use_reliable_udp_for_voice):
        """Sets the use_reliable_udp_for_voice of this APIConfig.

        Unknown  # noqa: E501

        :param use_reliable_udp_for_voice: The use_reliable_udp_for_voice of this APIConfig.  # noqa: E501
        :type use_reliable_udp_for_voice: bool
        """
        if self.local_vars_configuration.client_side_validation and use_reliable_udp_for_voice is None:  # noqa: E501
            raise ValueError("Invalid value for `use_reliable_udp_for_voice`, must not be `None`")  # noqa: E501

        self._use_reliable_udp_for_voice = use_reliable_udp_for_voice

    @property
    def user_update_period(self):
        """Gets the user_update_period of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The user_update_period of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._user_update_period

    @user_update_period.setter
    def user_update_period(self, user_update_period):
        """Sets the user_update_period of this APIConfig.

        Unknown  # noqa: E501

        :param user_update_period: The user_update_period of this APIConfig.  # noqa: E501
        :type user_update_period: int
        """
        if self.local_vars_configuration.client_side_validation and user_update_period is None:  # noqa: E501
            raise ValueError("Invalid value for `user_update_period`, must not be `None`")  # noqa: E501

        self._user_update_period = user_update_period

    @property
    def user_verification_delay(self):
        """Gets the user_verification_delay of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The user_verification_delay of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._user_verification_delay

    @user_verification_delay.setter
    def user_verification_delay(self, user_verification_delay):
        """Sets the user_verification_delay of this APIConfig.

        Unknown  # noqa: E501

        :param user_verification_delay: The user_verification_delay of this APIConfig.  # noqa: E501
        :type user_verification_delay: int
        """
        if self.local_vars_configuration.client_side_validation and user_verification_delay is None:  # noqa: E501
            raise ValueError("Invalid value for `user_verification_delay`, must not be `None`")  # noqa: E501

        self._user_verification_delay = user_verification_delay

    @property
    def user_verification_retry(self):
        """Gets the user_verification_retry of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The user_verification_retry of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._user_verification_retry

    @user_verification_retry.setter
    def user_verification_retry(self, user_verification_retry):
        """Sets the user_verification_retry of this APIConfig.

        Unknown  # noqa: E501

        :param user_verification_retry: The user_verification_retry of this APIConfig.  # noqa: E501
        :type user_verification_retry: int
        """
        if self.local_vars_configuration.client_side_validation and user_verification_retry is None:  # noqa: E501
            raise ValueError("Invalid value for `user_verification_retry`, must not be `None`")  # noqa: E501

        self._user_verification_retry = user_verification_retry

    @property
    def user_verification_timeout(self):
        """Gets the user_verification_timeout of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The user_verification_timeout of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._user_verification_timeout

    @user_verification_timeout.setter
    def user_verification_timeout(self, user_verification_timeout):
        """Sets the user_verification_timeout of this APIConfig.

        Unknown  # noqa: E501

        :param user_verification_timeout: The user_verification_timeout of this APIConfig.  # noqa: E501
        :type user_verification_timeout: int
        """
        if self.local_vars_configuration.client_side_validation and user_verification_timeout is None:  # noqa: E501
            raise ValueError("Invalid value for `user_verification_timeout`, must not be `None`")  # noqa: E501

        self._user_verification_timeout = user_verification_timeout

    @property
    def vive_windows_url(self):
        """Gets the vive_windows_url of this APIConfig.  # noqa: E501

        Download link for game on the Steam website.  # noqa: E501

        :return: The vive_windows_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._vive_windows_url

    @vive_windows_url.setter
    def vive_windows_url(self, vive_windows_url):
        """Sets the vive_windows_url of this APIConfig.

        Download link for game on the Steam website.  # noqa: E501

        :param vive_windows_url: The vive_windows_url of this APIConfig.  # noqa: E501
        :type vive_windows_url: str
        """
        if self.local_vars_configuration.client_side_validation and vive_windows_url is None:  # noqa: E501
            raise ValueError("Invalid value for `vive_windows_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                vive_windows_url is not None and len(vive_windows_url) < 1):
            raise ValueError("Invalid value for `vive_windows_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._vive_windows_url = vive_windows_url

    @property
    def white_listed_asset_urls(self):
        """Gets the white_listed_asset_urls of this APIConfig.  # noqa: E501

        List of allowed URLs that are allowed to host avatar assets  # noqa: E501

        :return: The white_listed_asset_urls of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._white_listed_asset_urls

    @white_listed_asset_urls.setter
    def white_listed_asset_urls(self, white_listed_asset_urls):
        """Sets the white_listed_asset_urls of this APIConfig.

        List of allowed URLs that are allowed to host avatar assets  # noqa: E501

        :param white_listed_asset_urls: The white_listed_asset_urls of this APIConfig.  # noqa: E501
        :type white_listed_asset_urls: list[str]
        """
        if self.local_vars_configuration.client_side_validation and white_listed_asset_urls is None:  # noqa: E501
            raise ValueError("Invalid value for `white_listed_asset_urls`, must not be `None`")  # noqa: E501

        self._white_listed_asset_urls = white_listed_asset_urls

    @property
    def world_update_period(self):
        """Gets the world_update_period of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The world_update_period of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._world_update_period

    @world_update_period.setter
    def world_update_period(self, world_update_period):
        """Sets the world_update_period of this APIConfig.

        Unknown  # noqa: E501

        :param world_update_period: The world_update_period of this APIConfig.  # noqa: E501
        :type world_update_period: int
        """
        if self.local_vars_configuration.client_side_validation and world_update_period is None:  # noqa: E501
            raise ValueError("Invalid value for `world_update_period`, must not be `None`")  # noqa: E501

        self._world_update_period = world_update_period

    @property
    def player_url_resolver_hash(self):
        """Gets the player_url_resolver_hash of this APIConfig.  # noqa: E501

        Currently used youtube-dl.exe hash in SHA-256-delimited format  # noqa: E501

        :return: The player_url_resolver_hash of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._player_url_resolver_hash

    @player_url_resolver_hash.setter
    def player_url_resolver_hash(self, player_url_resolver_hash):
        """Sets the player_url_resolver_hash of this APIConfig.

        Currently used youtube-dl.exe hash in SHA-256-delimited format  # noqa: E501

        :param player_url_resolver_hash: The player_url_resolver_hash of this APIConfig.  # noqa: E501
        :type player_url_resolver_hash: str
        """
        if self.local_vars_configuration.client_side_validation and player_url_resolver_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `player_url_resolver_hash`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                player_url_resolver_hash is not None and len(player_url_resolver_hash) < 1):
            raise ValueError("Invalid value for `player_url_resolver_hash`, length must be greater than or equal to `1`")  # noqa: E501

        self._player_url_resolver_hash = player_url_resolver_hash

    @property
    def player_url_resolver_version(self):
        """Gets the player_url_resolver_version of this APIConfig.  # noqa: E501

        Currently used youtube-dl.exe version  # noqa: E501

        :return: The player_url_resolver_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._player_url_resolver_version

    @player_url_resolver_version.setter
    def player_url_resolver_version(self, player_url_resolver_version):
        """Sets the player_url_resolver_version of this APIConfig.

        Currently used youtube-dl.exe version  # noqa: E501

        :param player_url_resolver_version: The player_url_resolver_version of this APIConfig.  # noqa: E501
        :type player_url_resolver_version: str
        """
        if self.local_vars_configuration.client_side_validation and player_url_resolver_version is None:  # noqa: E501
            raise ValueError("Invalid value for `player_url_resolver_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                player_url_resolver_version is not None and len(player_url_resolver_version) < 1):
            raise ValueError("Invalid value for `player_url_resolver_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._player_url_resolver_version = player_url_resolver_version

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, APIConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, APIConfig):
            return True

        return self.to_dict() != other.to_dict()
