# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.10.0
    Contact: me@ariesclark.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vrchatapi.api_client import ApiClient
from vrchatapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorldsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_world(self, **kwargs):  # noqa: E501
        """Create World  # noqa: E501

        Create a new world. This endpoint requires `assetUrl` to be a valid File object with `.vrcw` file extension, and `imageUrl` to be a valid File object with an image file extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_world(async_req=True)
        >>> result = thread.get()

        :param create_world_request: 
        :type create_world_request: CreateWorldRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: World
        """
        kwargs['_return_http_data_only'] = True
        return self.create_world_with_http_info(**kwargs)  # noqa: E501

    def create_world_with_http_info(self, **kwargs):  # noqa: E501
        """Create World  # noqa: E501

        Create a new world. This endpoint requires `assetUrl` to be a valid File object with `.vrcw` file extension, and `imageUrl` to be a valid File object with an image file extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_world_with_http_info(async_req=True)
        >>> result = thread.get()

        :param create_world_request: 
        :type create_world_request: CreateWorldRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(World, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_world_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_world_request' in local_var_params:
            body_params = local_var_params['create_world_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "World",
            400: "Error",
            401: "Error",
        }

        return self.api_client.call_api(
            '/worlds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_world(self, world_id, **kwargs):  # noqa: E501
        """Delete World  # noqa: E501

        Delete a world. Notice a world is never fully \"deleted\", only its ReleaseStatus is set to \"hidden\" and the linked Files are deleted. The WorldID is permanently reserved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_world(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_world_with_http_info(world_id, **kwargs)  # noqa: E501

    def delete_world_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Delete World  # noqa: E501

        Delete a world. Notice a world is never fully \"deleted\", only its ReleaseStatus is set to \"hidden\" and the linked Files are deleted. The WorldID is permanently reserved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_world_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `delete_world`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/worlds/{worldId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_active_worlds(self, **kwargs):  # noqa: E501
        """List Active Worlds  # noqa: E501

        Search and list currently Active worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_worlds(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LimitedWorld]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_worlds_with_http_info(**kwargs)  # noqa: E501

    def get_active_worlds_with_http_info(self, **kwargs):  # noqa: E501
        """List Active Worlds  # noqa: E501

        Search and list currently Active worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_worlds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LimitedWorld], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'featured',
            'sort',
            'n',
            'order',
            'offset',
            'search',
            'tag',
            'notag',
            'release_status',
            'max_unity_version',
            'min_unity_version',
            'platform'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_worlds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_active_worlds`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_active_worlds`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_active_worlds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('featured') is not None:  # noqa: E501
            query_params.append(('featured', local_var_params['featured']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('order') is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('search') is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if local_var_params.get('tag') is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if local_var_params.get('notag') is not None:  # noqa: E501
            query_params.append(('notag', local_var_params['notag']))  # noqa: E501
        if local_var_params.get('release_status') is not None:  # noqa: E501
            query_params.append(('releaseStatus', local_var_params['release_status']))  # noqa: E501
        if local_var_params.get('max_unity_version') is not None:  # noqa: E501
            query_params.append(('maxUnityVersion', local_var_params['max_unity_version']))  # noqa: E501
        if local_var_params.get('min_unity_version') is not None:  # noqa: E501
            query_params.append(('minUnityVersion', local_var_params['min_unity_version']))  # noqa: E501
        if local_var_params.get('platform') is not None:  # noqa: E501
            query_params.append(('platform', local_var_params['platform']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "list[LimitedWorld]",
            401: "Error",
        }

        return self.api_client.call_api(
            '/worlds/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_favorited_worlds(self, **kwargs):  # noqa: E501
        """List Favorited Worlds  # noqa: E501

        Search and list favorited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorited_worlds(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param user_id: Target user to see information on, admin-only.
        :type user_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LimitedWorld]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_favorited_worlds_with_http_info(**kwargs)  # noqa: E501

    def get_favorited_worlds_with_http_info(self, **kwargs):  # noqa: E501
        """List Favorited Worlds  # noqa: E501

        Search and list favorited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorited_worlds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param user_id: Target user to see information on, admin-only.
        :type user_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LimitedWorld], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'featured',
            'sort',
            'n',
            'order',
            'offset',
            'search',
            'tag',
            'notag',
            'release_status',
            'max_unity_version',
            'min_unity_version',
            'platform',
            'user_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_favorited_worlds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_favorited_worlds`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_favorited_worlds`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_favorited_worlds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('featured') is not None:  # noqa: E501
            query_params.append(('featured', local_var_params['featured']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('order') is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('search') is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if local_var_params.get('tag') is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if local_var_params.get('notag') is not None:  # noqa: E501
            query_params.append(('notag', local_var_params['notag']))  # noqa: E501
        if local_var_params.get('release_status') is not None:  # noqa: E501
            query_params.append(('releaseStatus', local_var_params['release_status']))  # noqa: E501
        if local_var_params.get('max_unity_version') is not None:  # noqa: E501
            query_params.append(('maxUnityVersion', local_var_params['max_unity_version']))  # noqa: E501
        if local_var_params.get('min_unity_version') is not None:  # noqa: E501
            query_params.append(('minUnityVersion', local_var_params['min_unity_version']))  # noqa: E501
        if local_var_params.get('platform') is not None:  # noqa: E501
            query_params.append(('platform', local_var_params['platform']))  # noqa: E501
        if local_var_params.get('user_id') is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "list[LimitedWorld]",
            401: "Error",
            403: "Error",
        }

        return self.api_client.call_api(
            '/worlds/favorites', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_recent_worlds(self, **kwargs):  # noqa: E501
        """List Recent Worlds  # noqa: E501

        Search and list recently visited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_recent_worlds(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param user_id: Target user to see information on, admin-only.
        :type user_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LimitedWorld]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_recent_worlds_with_http_info(**kwargs)  # noqa: E501

    def get_recent_worlds_with_http_info(self, **kwargs):  # noqa: E501
        """List Recent Worlds  # noqa: E501

        Search and list recently visited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_recent_worlds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param user_id: Target user to see information on, admin-only.
        :type user_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LimitedWorld], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'featured',
            'sort',
            'n',
            'order',
            'offset',
            'search',
            'tag',
            'notag',
            'release_status',
            'max_unity_version',
            'min_unity_version',
            'platform',
            'user_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recent_worlds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_recent_worlds`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_recent_worlds`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_recent_worlds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('featured') is not None:  # noqa: E501
            query_params.append(('featured', local_var_params['featured']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('order') is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('search') is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if local_var_params.get('tag') is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if local_var_params.get('notag') is not None:  # noqa: E501
            query_params.append(('notag', local_var_params['notag']))  # noqa: E501
        if local_var_params.get('release_status') is not None:  # noqa: E501
            query_params.append(('releaseStatus', local_var_params['release_status']))  # noqa: E501
        if local_var_params.get('max_unity_version') is not None:  # noqa: E501
            query_params.append(('maxUnityVersion', local_var_params['max_unity_version']))  # noqa: E501
        if local_var_params.get('min_unity_version') is not None:  # noqa: E501
            query_params.append(('minUnityVersion', local_var_params['min_unity_version']))  # noqa: E501
        if local_var_params.get('platform') is not None:  # noqa: E501
            query_params.append(('platform', local_var_params['platform']))  # noqa: E501
        if local_var_params.get('user_id') is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "list[LimitedWorld]",
            401: "Error",
            403: "Error",
        }

        return self.api_client.call_api(
            '/worlds/recent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_world(self, world_id, **kwargs):  # noqa: E501
        """Get World by ID  # noqa: E501

        Get information about a specific World. Works unauthenticated but when so will always return `0` for certain fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: World
        """
        kwargs['_return_http_data_only'] = True
        return self.get_world_with_http_info(world_id, **kwargs)  # noqa: E501

    def get_world_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Get World by ID  # noqa: E501

        Get information about a specific World. Works unauthenticated but when so will always return `0` for certain fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(World, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `get_world`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie']  # noqa: E501

        response_types_map = {
            200: "World",
            404: "Error",
        }

        return self.api_client.call_api(
            '/worlds/{worldId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_world_instance(self, world_id, instance_id, **kwargs):  # noqa: E501
        """Get World Instance  # noqa: E501

        Returns a worlds instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_instance(world_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param instance_id: Must be a valid instance ID. (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Instance
        """
        kwargs['_return_http_data_only'] = True
        return self.get_world_instance_with_http_info(world_id, instance_id, **kwargs)  # noqa: E501

    def get_world_instance_with_http_info(self, world_id, instance_id, **kwargs):  # noqa: E501
        """Get World Instance  # noqa: E501

        Returns a worlds instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_instance_with_http_info(world_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param instance_id: Must be a valid instance ID. (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Instance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'world_id',
            'instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_world_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `get_world_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `get_world_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instanceId'] = local_var_params['instance_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "Instance",
            401: "Error",
        }

        return self.api_client.call_api(
            '/worlds/{worldId}/{instanceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_world_metadata(self, world_id, **kwargs):  # noqa: E501
        """Get World Metadata  # noqa: E501

        Return a worlds custom metadata. This is currently believed to be unused. Metadata can be set with `updateWorld` and can be any arbitrary object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_metadata(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorldMetadata
        """
        kwargs['_return_http_data_only'] = True
        return self.get_world_metadata_with_http_info(world_id, **kwargs)  # noqa: E501

    def get_world_metadata_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Get World Metadata  # noqa: E501

        Return a worlds custom metadata. This is currently believed to be unused. Metadata can be set with `updateWorld` and can be any arbitrary object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_metadata_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorldMetadata, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_world_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `get_world_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "WorldMetadata",
            404: "Error",
        }

        return self.api_client.call_api(
            '/worlds/{worldId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_world_publish_status(self, world_id, **kwargs):  # noqa: E501
        """Get World Publish Status  # noqa: E501

        Returns a worlds publish status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_publish_status(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorldPublishStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_world_publish_status_with_http_info(world_id, **kwargs)  # noqa: E501

    def get_world_publish_status_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Get World Publish Status  # noqa: E501

        Returns a worlds publish status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_publish_status_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorldPublishStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_world_publish_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `get_world_publish_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "WorldPublishStatus",
            401: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/worlds/{worldId}/publish', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def publish_world(self, world_id, **kwargs):  # noqa: E501
        """Publish World  # noqa: E501

        Publish a world. You can only publish one world per week.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.publish_world(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.publish_world_with_http_info(world_id, **kwargs)  # noqa: E501

    def publish_world_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Publish World  # noqa: E501

        Publish a world. You can only publish one world per week.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.publish_world_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `publish_world`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/worlds/{worldId}/publish', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def search_worlds(self, **kwargs):  # noqa: E501
        """Search All Worlds  # noqa: E501

        Search and list any worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_worlds(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param user: Set to `me` for searching own worlds.
        :type user: str
        :param user_id: Filter by UserID.
        :type user_id: str
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LimitedWorld]
        """
        kwargs['_return_http_data_only'] = True
        return self.search_worlds_with_http_info(**kwargs)  # noqa: E501

    def search_worlds_with_http_info(self, **kwargs):  # noqa: E501
        """Search All Worlds  # noqa: E501

        Search and list any worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_worlds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param featured: Filters on featured results.
        :type featured: bool
        :param sort: The sort order of the results.
        :type sort: SortOption
        :param user: Set to `me` for searching own worlds.
        :type user: str
        :param user_id: Filter by UserID.
        :type user_id: str
        :param n: The number of objects to return.
        :type n: int
        :param order: Result ordering
        :type order: OrderOption
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param search: Filters by world name.
        :type search: str
        :param tag: Tags to include (comma-separated). Any of the tags needs to be present.
        :type tag: str
        :param notag: Tags to exclude (comma-separated).
        :type notag: str
        :param release_status: Filter by ReleaseStatus.
        :type release_status: ReleaseStatus
        :param max_unity_version: The maximum Unity version supported by the asset.
        :type max_unity_version: str
        :param min_unity_version: The minimum Unity version supported by the asset.
        :type min_unity_version: str
        :param platform: The platform the asset supports.
        :type platform: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LimitedWorld], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'featured',
            'sort',
            'user',
            'user_id',
            'n',
            'order',
            'offset',
            'search',
            'tag',
            'notag',
            'release_status',
            'max_unity_version',
            'min_unity_version',
            'platform'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_worlds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `search_worlds`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `search_worlds`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `search_worlds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('featured') is not None:  # noqa: E501
            query_params.append(('featured', local_var_params['featured']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if local_var_params.get('user') is not None:  # noqa: E501
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if local_var_params.get('user_id') is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('order') is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('search') is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if local_var_params.get('tag') is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if local_var_params.get('notag') is not None:  # noqa: E501
            query_params.append(('notag', local_var_params['notag']))  # noqa: E501
        if local_var_params.get('release_status') is not None:  # noqa: E501
            query_params.append(('releaseStatus', local_var_params['release_status']))  # noqa: E501
        if local_var_params.get('max_unity_version') is not None:  # noqa: E501
            query_params.append(('maxUnityVersion', local_var_params['max_unity_version']))  # noqa: E501
        if local_var_params.get('min_unity_version') is not None:  # noqa: E501
            query_params.append(('minUnityVersion', local_var_params['min_unity_version']))  # noqa: E501
        if local_var_params.get('platform') is not None:  # noqa: E501
            query_params.append(('platform', local_var_params['platform']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "list[LimitedWorld]",
            401: "Error",
        }

        return self.api_client.call_api(
            '/worlds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def unpublish_world(self, world_id, **kwargs):  # noqa: E501
        """Unpublish World  # noqa: E501

        Unpublish a world.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unpublish_world(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.unpublish_world_with_http_info(world_id, **kwargs)  # noqa: E501

    def unpublish_world_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Unpublish World  # noqa: E501

        Unpublish a world.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unpublish_world_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'world_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unpublish_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `unpublish_world`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/worlds/{worldId}/publish', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_world(self, world_id, **kwargs):  # noqa: E501
        """Update World  # noqa: E501

        Update information about a specific World.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_world(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param update_world_request:
        :type update_world_request: UpdateWorldRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: World
        """
        kwargs['_return_http_data_only'] = True
        return self.update_world_with_http_info(world_id, **kwargs)  # noqa: E501

    def update_world_with_http_info(self, world_id, **kwargs):  # noqa: E501
        """Update World  # noqa: E501

        Update information about a specific World.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_world_with_http_info(world_id, async_req=True)
        >>> result = thread.get()

        :param world_id: Must be a valid world ID. (required)
        :type world_id: str
        :param update_world_request:
        :type update_world_request: UpdateWorldRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(World, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'world_id',
            'update_world_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_world" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'world_id' is set
        if self.api_client.client_side_validation and local_var_params.get('world_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `world_id` when calling `update_world`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'world_id' in local_var_params:
            path_params['worldId'] = local_var_params['world_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_world_request' in local_var_params:
            body_params = local_var_params['update_world_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['apiKeyCookie', 'authCookie']  # noqa: E501

        response_types_map = {
            200: "World",
            401: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/worlds/{worldId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
