"""
Auto-generated on 2017-08-16T19:33:15.566595
"""

from .value_set import ValueSet


class ComfortMeasures(ValueSet):
    """

    Clinical Focus: This set of values contains care regimes used to define comfort measure care.
    Data Element Scope: The intent of this data element is to identify patients receiving comfort measures care. Using the Quality Data Model, this particular element would map to the Intervention category.
    Inclusion Criteria: Include SNOMEDCT regime and therapy codes for comfort measures, terminal care, dying care, and hospice care.
    Exclusion Criteria: None.
    """

    OID = '1.3.6.1.4.1.33895.1.3.0.45'
    VALUE_SET_NAME = 'Comfort Measures'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'133918004', '182964004', '385736008', '385763009'}


class OncAdministrativeSex(ValueSet):
    """

    Clinical Focus: Gender identity restricted to only Male and Female used in administrative situations requiring a restriction to these two categories.
    Data Element Scope: Gender
    Inclusion Criteria: Male and Female only.
    Exclusion Criteria: Any gender identity that is not male or female.
    """

    OID = '2.16.840.1.113762.1.4.1'
    VALUE_SET_NAME = 'ONC Administrative Sex'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ADMINISTRATIVEGENDER = {'F', 'M'}


class WarfarinOnlyIngredientSpecific(ValueSet):
    """

    Clinical Focus: Warfarin as independent ingredients for use in noting the most general idea of warfarin ingredient. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of warfarin
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.10'
    VALUE_SET_NAME = 'Warfarin-only ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'11289'}


class InjectableFactorXaInhibitorForVteProphylaxisIngredientSpecific(ValueSet):
    """

    Clinical Focus: Injectable factor Xa inhibitors for VTE prophylaxis as independent ingredients for use in noting the most general idea of this type of therapy. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of Injectable factor Xa inhibitors for VTE prophylaxis.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1021.11'
    VALUE_SET_NAME = 'Injectable factor Xa inhibitor for VTE prophylaxis ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'321208'}


class LowMolecularWeightHeparinForVteProphylaxisIngredientSpecific(ValueSet):
    """

    Clinical Focus: Low Molecular Weight Heparins (LMWH) for VTE prophylaxis as independent ingredients for use in noting the most general idea of this type of therapy. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of LMWHs for VTE prophylaxis
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.12'
    VALUE_SET_NAME = 'Low Molecular Weight Heparin for VTE prophylaxis ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'67108', '67109', '69646'}


class UnfractionatedHeparinForVteProphylaxisIngredientSpecific(ValueSet):
    """

    Clinical Focus: Unfractionated Heparin for VTE prophylaxis as an independent ingredient for use in noting the most general idea of this type of therapy. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of Unfractionated Heparin for VTE prophylaxis. PIN TTY is allowed for this value set.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.13'
    VALUE_SET_NAME = 'Unfractionated Heparin for VTE prophylaxis ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'235473'}


class AspirinIngredientSpecific(ValueSet):
    """

    Clinical Focus: Aspirin alone as an ingredient for use in noting the most general idea of aspirin medication. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge, NOT DONE
    Inclusion Criteria: Only single ingredient aspirin
    Exclusion Criteria: No multiple ingredient representations that include aspirin
    """

    OID = '2.16.840.1.113762.1.4.1021.3'
    VALUE_SET_NAME = 'Aspirin ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1191'}


class ParenteralAnticoagulantIngredientSpecific(ValueSet):
    """

    Clinical Focus: Anticoagulants acceptable for parenteral route use as independent ingredients for use in noting the most general idea of a parenteral anticoagulant medication. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge, NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of parenteral anticoagulant medications.
    Exclusion Criteria: Anticoagulants not acceptable for parenteral route. Any form not a single ingredient type.
    """

    OID = '2.16.840.1.113762.1.4.1021.4'
    VALUE_SET_NAME = 'Parenteral anticoagulant ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'15202', '235473', '237057', '321208', '60819', '67108', '67109', '69646'}


class TPaIngredientSpecific(ValueSet):
    """

    Clinical Focus: Tissue plasminogen activator (t-PA) drugs as independent ingredients for use in noting the most general idea of t-PA ingredients appropriate for treatment of ischemic stroke. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of t-PA drugs
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.6'
    VALUE_SET_NAME = 't-PA ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'8410'}


class StatinIngredientSpecific(ValueSet):
    """

    Clinical Focus: HMG-CoA reductase inhibitors (statin) drugs as independent ingredients for use in noting the most general idea of statin ingredients. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of statin drugs
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.7'
    VALUE_SET_NAME = 'Statin ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'301542', '36567', '41127', '42463', '6472', '83367', '861634'}


class AntithromboticIngredientSpecific(ValueSet):
    """

    Clinical Focus: Drugs that specifically inhibit thrombosis as independent ingredients for use in noting the most general idea of antithrombotic ingredients. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of antithrombotic drugs
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.8'
    VALUE_SET_NAME = 'Antithrombotic ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1037042', '10594', '1114195', '11289', '1191', '1364430', '15202', '235473', '237057',
        '321208', '32968', '67108', '67109'
    }


class AnticoagulantIngredientSpecific(ValueSet):
    """

    Clinical Focus: Drugs that specifically inhibit coagulation as independent ingredients for use in noting the most general idea of anticoagulant ingredients. Initial use is for representation of a medication "not done". The desire is to have a single choice.
    Data Element Scope: Medication order or discharge NOT DONE
    Inclusion Criteria: Only single ingredient, ingredient-level representation of anticoagulant drugs
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1021.9'
    VALUE_SET_NAME = 'Anticoagulant ingredient specific'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1037042', '1114195', '11289', '1364430', '15202', '235473', '237057', '321208', '67108',
        '67109', '69646'
    }


class TimeOfSymptomOnset(ValueSet):
    """

    Clinical Focus: This set of  values represent the concept of the time of symptom onset.
    Data Element Scope: The intent of this data element is to identify the time of symptom onset.  Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Include SNOMED CT codes that identify  the time of symptom onset.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.14'
    VALUE_SET_NAME = 'Time of Symptom Onset'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'405795006'}


class RehabilitationAssessment(ValueSet):
    """

    Clinical Focus: This set of  values contains procedures that represent rehabilitation assessment of patients post stroke.
    Data Element Scope: The intent of this data element is to identify assessments for rehabilitation assessment  following a stroke. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include SNOMED CT codes that identify a rehabilitation assessment procedures post stroke.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113762.1.4.1045.18'
    VALUE_SET_NAME = 'Rehabilitation Assessment'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '165189005', '165193004', '165194005', '268388007', '32908001', '33849009', '385816003',
        '410075001', '410081009', '410087008', '410155007', '410158009', '410161005', '410173005',
        '423040001', '424505000', '430481008', '63780003', '64374001', '712492003', '71318009',
        '77837000', '84478008', '8552003'
    }


class RehabilitationTherapy(ValueSet):
    """

    Clinical Focus: This set of values contain procedures that represent rehabilitation therapy post stroke.
    Data Element Scope: The intent of this data element is to identify stroke rehabilitation therapies. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include SNOMED CT codes that identify rehabilitation therapies used appropriate for stroke rehabilitation.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113762.1.4.1045.19'
    VALUE_SET_NAME = 'Rehabilitation Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '108305003', '1121002', '113129008', '11624006', '12799001', '12895002', '14490000',
        '15057003', '16709005', '169421008', '169422001', '169431001', '178272006', '182550007',
        '182623007', '182624001', '183273007', '183274001', '183295006', '183301007', '183302000',
        '183307006', '183311000', '183314008', '183326003', '183364001', '183365000', '183366004',
        '183367008', '183368003', '183376001', '18463003', '19432007', '225702009', '225926000',
        '226027003', '226029000', '226039006', '226052001', '226065005', '228526008', '228528009',
        '228529001', '228530006', '228531005', '228532003', '228541008', '228542001', '228633002',
        '229064008', '229065009', '229066005', '229067001', '229070002', '229071003', '229078009',
        '229080003', '229095001', '229096000', '229102007', '229107001', '229108006', '229109003',
        '229110008', '229111007', '229112000', '229113005', '229114004', '229115003', '229116002',
        '229117006', '229118001', '229119009', '229121004', '229122006', '229123001', '229124007',
        '229125008', '229126009', '229127000', '229128005', '229129002', '229130007', '229131006',
        '229132004', '229133009', '229134003', '229135002', '229136001', '229137005', '229138000',
        '229140005', '229141009', '229142002', '229143007', '229144001', '229145000', '229147008',
        '229148003', '229149006', '229150006', '229151005', '229152003', '229153008', '229154002',
        '229155001', '229156000', '229157009', '229158004', '229159007', '229160002', '229161003',
        '229162005', '229163000', '229167004', '229168009', '229169001', '229170000', '229171001',
        '229172008', '229175005', '229176006', '229178007', '229179004', '229180001', '229181002',
        '229182009', '229183004', '229184005', '229185006', '229186007', '229187003', '229188008',
        '229189000', '229190009', '229191008', '229192001', '229193006', '229194000', '229195004',
        '229197007', '229198002', '229199005', '229201007', '229205003', '229206002', '229207006',
        '229229005', '229239004', '229240002', '229241003', '229242005', '229243000', '229244006',
        '229246008', '229248009', '229249001', '229251002', '229252009', '229253004', '229254005',
        '229255006', '229256007', '229258008', '229259000', '229260005', '229261009', '229262002',
        '229263007', '229264001', '229265000', '229266004', '229267008', '229268003', '229269006',
        '229270007', '229271006', '229272004', '229285001', '229288004', '229289007', '229290003',
        '229291004', '229292006', '229293001', '229298005', '229299002', '229314005', '229315006',
        '229321005', '229322003', '229323008', '229324002', '229330002', '229331003', '229332005',
        '229333000', '229334006', '229335007', '229336008', '229337004', '229338009', '229339001',
        '229340004', '229341000', '229342007', '229344008', '229345009', '229346005', '229347001',
        '229348006', '229349003', '229350003', '229351004', '229352006', '229353001', '229354007',
        '229355008', '229356009', '229357000', '229358005', '229359002', '229360007', '229361006',
        '229362004', '229363009', '229364003', '229365002', '229366001', '229367005', '229368000',
        '229369008', '229370009', '229371008', '229374000', '229375004', '229376003', '229377007',
        '229378002', '229379005', '229380008', '229381007', '229382000', '229383005', '229384004',
        '229385003', '229386002', '229387006', '229388001', '229389009', '229390000', '229391001',
        '229392008', '229393003', '229394009', '229395005', '229396006', '229397002', '229398007',
        '229399004', '229400006', '229401005', '229402003', '229403008', '229404002', '229405001',
        '229406000', '229407009', '229408004', '229409007', '229410002', '229411003', '229412005',
        '229413000', '229414006', '229415007', '229416008', '229417004', '229418009', '229419001',
        '229420007', '229421006', '229422004', '229423009', '229424003', '229425002', '229426001',
        '229427005', '229428000', '229429008', '229431004', '229433001', '229559001', '229578001',
        '229594008', '229595009', '229596005', '229597001', '229598006', '229599003', '229600000',
        '229601001', '229602008', '229603003', '229604009', '229605005', '229606006', '229607002',
        '229608007', '229615004', '229619005', '229809001', '23027005', '2517002', '252763008',
        '25855006', '25902004', '266741004', '266742006', '266743001', '271421005', '273405006',
        '273406007', '273655005', '28150003', '282835008', '288558009', '302259009', '302280003',
        '302281004', '303079004', '303083004', '303084005', '303091008', '303352009', '304458004',
        '304459007', '304460002', '304461003', '304462005', '304477002', '306173009', '307053009',
        '308931006', '311509005', '311555007', '311556008', '311557004', '311558009', '311559001',
        '311560006', '311561005', '311562003', '311563008', '311564002', '311565001', '311566000',
        '311567009', '311568004', '311571007', '311572000', '311575003', '311576002', '311577006',
        '311578001', '311579009', '311580007', '311581006', '311583009', '311584003', '311585002',
        '311586001', '311587005', '311588000', '311589008', '311590004', '311591000', '311592007',
        '311593002', '311594008', '311596005', '311597001', '311598006', '311599003', '311600000',
        '311601001', '311634004', '311641005', '311642003', '311643008', '311644002', '311645001',
        '311646000', '311647009', '311648004', '311650007', '311651006', '311652004', '311653009',
        '311654003', '311655002', '311656001', '311657005', '311658000', '311659008', '311660003',
        '311661004', '311662006', '311663001', '311664007', '311665008', '311666009', '311667000',
        '311668005', '311669002', '311670001', '311672009', '311673004', '311674005', '311675006',
        '311676007', '311678008', '311680002', '311683000', '311684006', '311685007', '311686008',
        '311687004', '311688009', '311689001', '311690005', '311691009', '311692002', '311693007',
        '311694001', '311695000', '311697008', '311698003', '311699006', '311700007', '311701006',
        '311702004', '311703009', '311704003', '311705002', '311706001', '311707005', '311708000',
        '311709008', '311710003', '311711004', '311712006', '311713001', '311714007', '311715008',
        '311716009', '311717000', '311785000', '313128003', '313129006', '33536007', '33943006',
        '34213005', '34431008', '35044000', '350681005', '351685006', '359665005', '360742002',
        '37030005', '370867005', '370871008', '371605008', '386293009', '386295002', '39317007',
        '39609006', '398259002', '40454005', '404928000', '40497000', '408869004', '410089006',
        '410160006', '410384009', '416790000', '424291000', '425927007', '441827009', '448275004',
        '448276003', '46903006', '4827002', '48530002', '5154007', '51998003', '52052004',
        '52341004', '5391008', '55172000', '55947001', '57139001', '57942008', '60256002',
        '60659001', '60955009', '61502001', '6226000', '62868009', '6397004', '64623003',
        '64838004', '65943000', '66337003', '66488001', '66500008', '69212005', '71937005',
        '72628009', '72736008', '72817007', '7334004', '74251004', '74914000', '75067006',
        '76260005', '77728007', '79536006', '79844003', '80504003', '82124003', '83439001',
        '85680003', '86516002', '88532006', '88607004', '88965008', '90196004', '9044004',
        '91251008'
    }


class IntravenousOrIntraArterialThrombolyticTPaTherapy(ValueSet):
    """

    Clinical Focus: This grouping value set contain procedures that represent intravenous or intra-arterial thrombolytic (t-PA) therapy.
    Data Element Scope: The intent of this data element is to identify intravenous or intra-arterial  thrombolytic (t-PA) therapy procedures.  Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include SNOMED CT codes that identify  intravenous or intra-arterial  thrombolytic (t-PA) therapy procedures.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.21'
    VALUE_SET_NAME = 'Intravenous or Intra-arterial Thrombolytic (t-PA) Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'307521008', '69245005'}


class ProthrombinTime(ValueSet):
    """

    Clinical Focus: This set of  values contains laboratory tests that represent prothrombin time.
    Data Element Scope: The intent of this data element is to identify a prothrombin time laboratory test. Using the Quality Data Model, this particular element will map to the "Laboratory Test" category.
    Inclusion Criteria: Include LOINC codes that identify prothrombin time.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.24'
    VALUE_SET_NAME = 'Prothrombin Time'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'46417-2', '5902-2', '5964-2'}


class PartialThromboplastinTime(ValueSet):
    """

    Clinical Focus: This set includes coded for a Parial Thromboplastin Time lab test
    Data Element Scope: The intent of this data element is to identify partial thromboplastin time laboratory tests. Using the Quality Data Model, this particular element will map to the "Laboratory Test" category.
    Inclusion Criteria: Include LOINC codes that identify partial thromboplastin time.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.25'
    VALUE_SET_NAME = 'Partial Thromboplastin Time'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '14979-9', '30323-0', '3173-2', '33890-5', '33891-3', '34189-1', '38276-2', '40100-0',
        '43734-3', '52123-7', '5946-9', '5950-1'
    }


class EstimatedGestationalAgeAtDelivery(ValueSet):
    """

    Clinical Focus: This set of values contains "observable entities" that represent the estimated gestational age at delivery.
    Data Element Scope: The intent of this data element is to identify the fetus's estimated length of gestation at delivery. Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Include SNOMED CT codes that identify the estimated gestational age at delivery.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.26'
    VALUE_SET_NAME = 'Estimated Gestational Age at Delivery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'444135009'}


class TimeOfDelivery(ValueSet):
    """

    Clinical Focus: This set of  values that represent the time of delivery.
    Data Element Scope: The intent of this data element is to identify the time of delivery.  Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Include SNOMED CT codes that identify time of delivery.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.28'
    VALUE_SET_NAME = 'Time of Delivery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'397836004'}


class IvCeftriaxone(ValueSet):
    """

    Clinical Focus: This set of values includes select antibiotics that are used in an inpatient setting for surgical prophylaxis.  These antibiotic is Ceftriaxone only.  These are not dose specific, however, they must only be given intravenously.
    Data Element Scope: The intent of this data element is to identify patients who are on the antibiotic Ceftriaxone for surgical prophylaxis.  Using the Quality Data Model, this element will map to the Medication category.
    Inclusion Criteria: Only use codes which represent the antibiotic Ceftriaxone which is given intravenously.  Codes used are to be RxNorm codes only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.3'
    VALUE_SET_NAME = 'IV Ceftriaxone'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1665005', '1665021', '1665046', '309090', '309092'}


class OtherAnticoagulantsForAcuteMyocardialInfarctionAmi(ValueSet):
    """

    Clinical Focus: This set of values contains medications that are prescribed for anticoagulant therapy at hospital discharge for patients following acute myocardial infarction.
    Data Element Scope: The intent of this data element is to identify patients who are prescribed anticoagulant therapy at discharge following acute myocardial infarction. Using the Quality Data Model, this particular element would map to the Medication, Discharge data type.
    Inclusion Criteria: The following list of medications should be included: apixaban dabigatran Eliquis Pradaxa rivaroxiban Xarelto
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.31'
    VALUE_SET_NAME = 'Other Anticoagulants for Acute Myocardial Infarction (AMI)'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1037045', '1037179', '1114198', '1232082', '1232086', '1364435', '1364445', '1723476'
    }


class StemiExclusions(ValueSet):
    """

    Clinical Focus: This grouping value set contains disorders and diagnoses used to define NSTEMI or non-ST segment elevation myocardial infarction.
    Data Element Scope: The intent of this data element is to identify patients with a type of myocardial infarction that does not include the electrocardiography (ECG) change of ST-segment elevation. Using the Quality Data Model, this particular element would map to the Result attribute.
    Inclusion Criteria: Include codes that identify patients with non-ST segment elevation myocardial infarction. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.36'
    VALUE_SET_NAME = 'STEMI Exclusions'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'I214', 'I222'}

    ICD9CM = {'41070', '41071'}

    SNOMEDCT = {
        '233826005', '233828006', '233830008', '233832000', '233834004', '233835003', '233837006',
        '30277009', '307140009', '314207007', '401314000', '428750005', '57054005', '703360004',
        '70422006'
    }


class LowDoseUnfractionatedHeparinForVteProphylaxis(ValueSet):
    """

    Clinical Focus: This set of values contains unfractionated heparin medications with strengths that could reasonably be used for VTE prophylaxis.
    Data Element Scope: The intent of this data element is to identify patients who are on low-dose unfractionated heparin as VTE prophylaxis. Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Injectable products that could reasonably be used to achieve a dose of at least 5000 units when administered subcutaneously.
    Exclusion Criteria: Concentrations less than 250 UNT/ML.
    """

    OID = '2.16.840.1.113762.1.4.1045.39'
    VALUE_SET_NAME = 'Low Dose Unfractionated Heparin for VTE Prophylaxis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1361574', '1361577', '1361615', '1361853', '1362831', '1658634', '1658637', '1659260',
        '1659263'
    }


class GlycoproteinIibiiiaInhibitors(ValueSet):
    """

    Clinical Focus: This set of values contains codes which identify a select medication-a Glycoprotein Iib/IIIa inhibitor.
    Data Element Scope: The intent of this data element is to identify patients who are on a Glycoprotein Iib/IIIa inhibitor.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Only include codes which represent a Glycoprotein Iib/IIIa inhibitor.  These are RxNorm codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.41'
    VALUE_SET_NAME = 'Glycoprotein IIb/IIIa Inhibitors'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'200326', '200348', '200349', '205253', '241162'}


class Thrombocytopenia(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have thrombocytopenia.
    Data Element Scope: The intent of this data element is to identify patients who have thrombocytopenia.  Using the Quality Data Model, this particular element will map to the Diagnosis category.
    Inclusion Criteria: Disorders of thrombocytopenia, heparin induced or otherwise.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.45'
    VALUE_SET_NAME = 'Thrombocytopenia'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'D693', 'D6949', 'D6959', 'D696', 'D7582', 'D820', 'M311'}

    SNOMEDCT = {
        '111588002', '127034005', '128091003', '128092005', '128093000', '13172003', '191322006',
        '191323001', '19307009', '234482009', '234483004', '234487003', '234489000', '267534000',
        '2897005', '30182008', '302215000', '302873008', '307342006', '323079008', '34395002',
        '36070007', '371074009', '371106008', '37492005', '416902009', '421766003', '48788004',
        '49886003', '51624005', '54569005', '60628003', '63444004', '73397007', '74576004',
        '78345002', '82190001', '85589009', '86635005', '87902006'
    }


class EstimatedGestationalAgeAtBirth(ValueSet):
    """

    Clinical Focus: This value set represents the concept of estimated gestational age at birth.
    Data Element Scope: The intent of this data element is to identify estimated gestational age at birth. Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Include SNOMED CT codes that identify estimated gestational age at birth.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.47'
    VALUE_SET_NAME = 'Estimated Gestational Age at Birth'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'412726003'}


class ImOrPoAntimicrobialMedications(ValueSet):
    """

    Clinical Focus: This set of values identifies patients who are administered antibiotics during the inpatient encounter which are administered via an intramuscular or oral route.
    Data Element Scope: The intent of this data element is to identify patients who are on antibiotics during the inpatient encounter which are administered via an intramuscular or oral route.  Using the Quality Data Model, this element will map to the Medication category.
    Inclusion Criteria: Only use codes which represent select antibiotics which are given via an intramuscular or oral route.  Codes used are to be RxNorm codes only.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.5'
    VALUE_SET_NAME = 'IM or PO Antimicrobial medications'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1013659', '1013662', '1013665', '1043022', '1043030', '105152', '105170', '105171',
        '108449', '1088677', '1111106', '1113433', '1294619', '1302650', '1302659', '1302664',
        '1302669', '1302674', '141962', '141963', '142118', '1648755', '1648759', '1649401',
        '1649405', '1649425', '1649429', '1649988', '1649990', '1650030', '1650142', '1650143',
        '1650444', '1650446', '1652673', '1652674', '197389', '197449', '197451', '197452',
        '197453', '197454', '197511', '197512', '197516', '197517', '197518', '197595', '197596',
        '197650', '197898', '197899', '197984', '197985', '198044', '198048', '198049', '198050',
        '198201', '198202', '198250', '198252', '198332', '198334', '198335', '198337', '199055',
        '199326', '199327', '199332', '199370', '199620', '199802', '199884', '199885', '199997',
        '200346', '204844', '207362', '207364', '226633', '239191', '239210', '239211', '240741',
        '245240', '245242', '246282', '247673', '248656', '283535', '284215', '308177', '308181',
        '308182', '308188', '308189', '308191', '308192', '308194', '308210', '308212', '308429',
        '308459', '308460', '308985', '309040', '309042', '309043', '309044', '309045', '309047',
        '309048', '309049', '309054', '309058', '309076', '309077', '309078', '309079', '309080',
        '309081', '309085', '309086', '309087', '309095', '309096', '309097', '309098', '309110',
        '309112', '309113', '309114', '309115', '309308', '309309', '309310', '309322', '309329',
        '309860', '309956', '310026', '310028', '310154', '310155', '310157', '311296', '311345',
        '311347', '311364', '311370', '311371', '311681', '311787', '311989', '311994', '311995',
        '312190', '313134', '313251', '313570', '313571', '313797', '313799', '313800', '313850',
        '313888', '313926', '314079', '314106', '314108', '315090', '317570', '348869', '348870',
        '351121', '351127', '359383', '359385', '388510', '403840', '403921', '403945', '406524',
        '406696', '419849', '429662', '434018', '476322', '476325', '476327', '476576', '476623',
        '477391', '562251', '562253', '562266', '562508', '562707', '577378', '597455', '597761',
        '598006', '598025', '617296', '617302', '617304', '617309', '617316', '617322', '617423',
        '617430', '617993', '617995', '629695', '629697', '629699', '636559', '637173', '637560',
        '645617', '700408', '728207', '799048', '802550', '834040', '834046', '834061', '834102',
        '847360', '854818', '856664', '858062', '858372', '861416', '866042', '877486', '900424',
        '901399', '905341', '905347', '905350'
    }


class ScopeProcedures(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have a surgical procedure which is performed using a scope.
    Data Element Scope: The intent of this data element is to identify patient who have a surgical procedure which is performed using a scope.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent procedures performed with a scope.  Codes used are to be ICD10PCS, ICD9CM or SNOMED-CT codes only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.52'
    VALUE_SET_NAME = 'Scope Procedures'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0BUR47Z', '0BUR4JZ', '0BUR4KZ', '0BUS47Z', '0BUS4JZ', '0BUS4KZ', '0D16479', '0D1647A',
        '0D1647B', '0D1647L', '0D164J9', '0D164JA', '0D164JB', '0D164JL', '0D164K9', '0D164KA',
        '0D164KB', '0D164KL', '0D164Z9', '0D164ZA', '0D164ZB', '0D164ZL', '0DB64Z3', '0DBE4ZZ',
        '0DBF4ZZ', '0DBG4ZZ', '0DBH4ZZ', '0DBK4ZZ', '0DBL4ZZ', '0DBM4ZZ', '0DBN4ZZ', '0DN84ZZ',
        '0DN94ZZ', '0DNA4ZZ', '0DNB4ZZ', '0DNC4ZZ', '0DNE4ZZ', '0DNF4ZZ', '0DNG4ZZ', '0DNH4ZZ',
        '0DNJ4ZZ', '0DNK4ZZ', '0DNL4ZZ', '0DNM4ZZ', '0DNN4ZZ', '0DNS4ZZ', '0DNT4ZZ', '0DNV4ZZ',
        '0DNW4ZZ', '0DP643Z', '0DP64CZ', '0DQ64ZZ', '0DTE4ZZ', '0DTF4ZZ', '0DTG4ZZ', '0DTH4ZZ',
        '0DTJ4ZZ', '0DTK4ZZ', '0DTL4ZZ', '0DTM4ZZ', '0DTN4ZZ', '0DV44CZ', '0DV44DZ', '0DV44ZZ',
        '0DV64CZ', '0DW643Z', '0DW64CZ', '0F504ZZ', '0F514ZZ', '0F524ZZ', '0F544ZZ', '0FB04ZX',
        '0FB14ZX', '0FB24ZX', '0FB44ZZ', '0FC54ZZ', '0FC58ZZ', '0FC64ZZ', '0FC68ZZ', '0FC84ZZ',
        '0FC88ZZ', '0FC94ZZ', '0FC98ZZ', '0FCC4ZZ', '0FCC8ZZ', '0FF48ZZ', '0FF58ZZ', '0FF68ZZ',
        '0FF88ZZ', '0FF98ZZ', '0FFC8ZZ', '0FN04ZZ', '0FN14ZZ', '0FN24ZZ', '0FN44ZZ', '0FN54ZZ',
        '0FN64ZZ', '0FN84ZZ', '0FN94ZZ', '0FNC4ZZ', '0FND4ZZ', '0FNF4ZZ', '0FNG4ZZ', '0FT44ZZ',
        '0T504ZZ', '0T514ZZ', '0T534ZZ', '0T544ZZ', '0TN04ZZ', '0TN14ZZ', '0TN34ZZ', '0TN44ZZ',
        '0TN64ZZ', '0TN74ZZ', '0TNB4ZZ', '0TNC4ZZ', '0U504ZZ', '0U514ZZ', '0U524ZZ', '0U9040Z',
        '0U904ZX', '0U904ZZ', '0U9140Z', '0U914ZX', '0U914ZZ', '0U9240Z', '0U924ZX', '0U924ZZ',
        '0UB04ZX', '0UB04ZZ', '0UB14ZX', '0UB14ZZ', '0UB24ZX', '0UB24ZZ', '0UC04ZZ', '0UC14ZZ',
        '0UC24ZZ', '0UJ34ZZ', '0UM04ZZ', '0UM14ZZ', '0UM24ZZ', '0UN04ZZ', '0UN14ZZ', '0UN24ZZ',
        '0UN54ZZ', '0UN64ZZ', '0UN74ZZ', '0UP340Z', '0UP343Z', '0UQ04ZZ', '0UQ14ZZ', '0UQ24ZZ',
        '0US04ZZ', '0US14ZZ', '0US24ZZ', '0UT04ZZ', '0UT14ZZ', '0UT24ZZ', '0UT94ZZ', '0UT9FZZ',
        '0UW340Z', '0UW343Z', '0WUF47Z', '0WUF4JZ', '0WUF4KZ', '0YU547Z', '0YU54JZ', '0YU54KZ',
        '0YU647Z', '0YU64JZ', '0YU64KZ', '0YUA47Z', '0YUA4JZ', '0YUA4KZ'
    }

    ICD9CM = {
        '4497', '4581', '4701', '4711', '4842', '4851', '5014', '5025', '5123', '5124', '5188',
        '5342', '5343', '5359', '5362', '5363', '5371', '5383', '5451', '5534', '5903', '5912',
        '6501', '6513', '6514', '6523', '6524', '6525', '6531', '6541', '6553', '6554', '6563',
        '6564', '6574', '6575', '6576', '6581', '6831', '6841', '6851', '6861', '6871'
    }

    SNOMEDCT = {
        '1390003', '15018006', '15050001', '16226000', '174041007', '174456006', '174457002',
        '174458007', '174461008', '174462001', '176989003', '176994003', '177048007', '177052007',
        '177063005', '177992007', '20475008', '20630000', '233451003', '236887006', '236888001',
        '236889009', '236890000', '236891001', '265082003', '281258002', '307190008', '307195003',
        '307581005', '307586000', '307619009', '307621004', '309451008', '314118002', '314128006',
        '314608008', '315059002', '315066001', '31726006', '32001009', '397404002', '413115009',
        '413146008', '413181005', '414574004', '414575003', '416155004', '427074001', '42843004',
        '431316002', '438341004', '439171005', '439235001', '439368006', '439739008', '439808002',
        '439825000', '439826004', '439832009', '439946008', '439964001', '440032004', '440033009',
        '440078007', '440111005', '440118004', '440183002', '440238005', '440446009', '440539003',
        '440581009', '440711002', '443480008', '444624003', '444866000', '445168005', '445838004',
        '445917006', '446075001', '446126004', '446222007', '446223002', '446228006', '446255002',
        '446296004', '446316001', '446408009', '446450009', '446544001', '446585006', '446586007',
        '446598002', '446677005', '446678000', '446679008', '446713007', '446714001', '446715000',
        '446805001', '446830003', '446844009', '446855009', '446863005', '446891002', '446892009',
        '446893004', '446894005', '446921005', '446942007', '446959002', '446960007', '446990000',
        '447076008', '447077004', '447078009', '447082006', '447166008', '447307008', '447344008',
        '447347001', '447422004', '447423009', '447427005', '447480009', '447494005', '447495006',
        '447505004', '447509005', '447527008', '447532009', '447581006', '447582004', '447602008',
        '447603003', '448166005', '448540000', '450487000', '450499007', '450500003', '450502006',
        '450559006', '450560001', '450562009', '450563004', '450824002', '45595009', '473277000',
        '50774009', '51316009', '55542002', '57922004', '6025007', '608789001', '608790005',
        '608791009', '608792002', '608793007', '608794001', '608795000', '608805000', '608806004',
        '608807008', '608814005', '608833000', '608834006', '608835007', '608885003', '608887006',
        '608888001', '608889009', '608890000', '608891001', '608892008', '608893003', '609230000',
        '609257003', '609258008', '609259000', '609260005', '609261009', '609262002', '609263007',
        '609264001', '609265000', '609266004', '609267008', '609273009', '609274003', '609275002',
        '609293001', '609294007', '609295008', '609296009', '61893009', '63185002', '63343006',
        '63596003', '67557008', '73632009', '75835007', '76735009', '78656005', '81803007',
        '9540004'
    }


class Oxytocin(ValueSet):
    """

    Clinical Focus: This set of values contains medications that represent Oxytocin.
    Data Element Scope: The intent of this data element is to identify medications that  represent Oxytocin. Using the Quality Data Model, this particular element will map to the "Medication" category.
    Inclusion Criteria: Include RxNorm codes that identify medications that represent  Oxytocin as a single ingredient, administered in an injectable form.
    Exclusion Criteria: Exclude drugs that have multiple ingredients. In addition, drugs with dose forms not consistent with injectable administration should not be included. The codes should be limited to those which are for human use and which are able to be prescribed in the US.
    """

    OID = '2.16.840.1.113762.1.4.1045.55'
    VALUE_SET_NAME = 'Oxytocin'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'238013', '312191', '317139', '486591', '486593', '486596', '486598'}


class Dinoprostone(ValueSet):
    """

    Clinical Focus: This set of values contains medications that represent Dinoprostone, commonly used in the delivery setting for induction of labor.
    Data Element Scope: The intent of this data element is to identify patients who receive dinoprostone for the purpose of inducing labor. Using the Quality Data Model, this particular element will map to the "Medication" category.
    Inclusion Criteria: Include RxNorm codes that identify medications that contain Dinoprostone as the single ingredient. Drug forms consistent with vaginal administration should be included.
    Exclusion Criteria: Medications that have multiple ingredients should be excluded. Drug forms that are not consistent with vaginal administration should not be included. The codes should be limited to those which are for human use and which are able to be prescribed in the US.
    """

    OID = '2.16.840.1.113762.1.4.1045.56'
    VALUE_SET_NAME = 'Dinoprostone'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'309922', '597957'}


class ArtificialRuptureOfMembranes(ValueSet):
    """

    Clinical Focus: This set of values contains procedures that represent the artificial rupture of membranes.
    Data Element Scope: The intent of this data element is to identify artificial rupture of membranes as a mechanism to induce labor.  Using the Quality Data Model, this particular element will map to the "procedure" category.
    Inclusion Criteria: Include SNOMED CT codes that identify artificial rupture of membranes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.57'
    VALUE_SET_NAME = 'Artificial Rupture of Membranes'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'408816000', '408818004'}


class DeliveryProcedures(ValueSet):
    """

    Clinical Focus: This group of value sets contain procedures that represent delivery procedures.
    Data Element Scope: The intent of this data element is to identify delivery procedures.  Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include codes that identify delivery procedures.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.59'
    VALUE_SET_NAME = 'Delivery Procedures'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '10D00Z0', '10D00Z1', '10D00Z2', '10D07Z3', '10D07Z4', '10D07Z5', '10D07Z6', '10D07Z7',
        '10D07Z8', '10E0XZZ'
    }

    SNOMEDCT = {
        '11466000', '14119008', '15413009', '177141003', '177142005', '177143000', '177152009',
        '177157003', '177158008', '177161009', '177162002', '177164001', '177167008', '177168003',
        '177170007', '177173009', '177174003', '177175002', '177176001', '177179008', '177180006',
        '177181005', '177184002', '17744000', '17860005', '18625004', '19390001', '199771001',
        '22633006', '236974004', '236975003', '236976002', '236977006', '236978001', '236980007',
        '236985002', '236986001', '236987005', '236988000', '237311001', '25296001', '25828002',
        '26313002', '265639000', '274130007', '275168001', '275169009', '287976008', '288039005',
        '288193006', '29613008', '302382009', '302383004', '30476003', '306727001', '33807004',
        '359940006', '359943008', '38479009', '398307005', '40704000', '41059002', '416055001',
        '417121007', '4504004', '45718005', '48204000', '54973000', '5556001', '57271003',
        '61586001', '62508004', '69422002', '71166009', '72492007', '84195007', '89053004',
        '89346004', '89849000'
    }


class IntramuscularOrPoRoute(ValueSet):
    """

    Clinical Focus: This set of values represents routes by which a medication can be administered.  This particular value set contains codes for intramuscular and oral routes.
    Data Element Scope: The intent of this data element is to identify the route by which a medication is administered.  The route identified must be an intramuscular or oral route.  Using the Quality Data Model, this element will map to an attribute.
    Inclusion Criteria: Only use codes which represent an intramuscular or oral route for medication administration.  Codes used are to be SNOMED-CT only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.6'
    VALUE_SET_NAME = 'Intramuscular or PO route'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '127490009', '127492001', '255559005', '26643006', '372454008', '372473007', '417985001',
        '418136008', '418162004', '418730005', '419954003', '78421000'
    }


class Pci(ValueSet):
    """

    Clinical Focus: This grouping value set contains procedures used to define percutaneous coronary intervention (PCI).
    Data Element Scope: The intent of this data element is to identify patients who had percutaneous coronary intervention (PCI) during an episode of acute myocardial infarction. Using the Quality Data Model, this particular element would map to the Procedure, Performed datatype.
    Inclusion Criteria: Include codes that identify patients receiving percutaneous coronary intervention (PCI). This is a grouping of ICD10PCS, ICD9CM and SNOMEDCT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.67'
    VALUE_SET_NAME = 'PCI'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0270346', '027034Z', '0270356', '027035Z', '0270366', '027036Z', '0270376', '027037Z',
        '02703D6', '02703DZ', '02703E6', '02703EZ', '02703F6', '02703FZ', '02703G6', '02703GZ',
        '02703T6', '02703TZ', '02703Z6', '02703ZZ', '0270446', '027044Z', '0270456', '027045Z',
        '0270466', '027046Z', '0270476', '027047Z', '02704D6', '02704DZ', '02704E6', '02704EZ',
        '02704F6', '02704FZ', '02704G6', '02704GZ', '02704T6', '02704TZ', '02704Z6', '02704ZZ',
        '0271346', '027134Z', '0271356', '027135Z', '0271366', '027136Z', '0271376', '027137Z',
        '02713D6', '02713DZ', '02713E6', '02713EZ', '02713F6', '02713FZ', '02713G6', '02713GZ',
        '02713T6', '02713TZ', '02713Z6', '02713ZZ', '0271446', '027144Z', '0271456', '027145Z',
        '0271466', '027146Z', '0271476', '027147Z', '02714D6', '02714DZ', '02714E6', '02714EZ',
        '02714F6', '02714FZ', '02714G6', '02714GZ', '02714T6', '02714TZ', '02714Z6', '02714ZZ',
        '0272346', '027234Z', '0272356', '027235Z', '0272366', '027236Z', '0272376', '027237Z',
        '02723D6', '02723DZ', '02723E6', '02723EZ', '02723F6', '02723FZ', '02723G6', '02723GZ',
        '02723T6', '02723TZ', '02723Z6', '02723ZZ', '0272446', '027244Z', '0272456', '027245Z',
        '0272466', '027246Z', '0272476', '027247Z', '02724D6', '02724DZ', '02724E6', '02724EZ',
        '02724F6', '02724FZ', '02724G6', '02724GZ', '02724T6', '02724TZ', '02724Z6', '02724ZZ',
        '0273346', '027334Z', '0273356', '027335Z', '0273366', '027336Z', '0273376', '027337Z',
        '02733D6', '02733DZ', '02733E6', '02733EZ', '02733F6', '02733FZ', '02733G6', '02733GZ',
        '02733T6', '02733TZ', '02733Z6', '02733ZZ', '0273446', '027344Z', '0273456', '027345Z',
        '0273466', '027346Z', '0273476', '027347Z', '02734D6', '02734DZ', '02734E6', '02734EZ',
        '02734F6', '02734FZ', '02734G6', '02734GZ', '02734T6', '02734TZ', '02734Z6', '02734ZZ'
    }

    ICD9CM = {'0066'}

    SNOMEDCT = {
        '11101003', '175066001', '36969009', '397193006', '397431004', '414089002', '415070008',
        '428488008', '429499003', '429639007', '429809004', '609153008', '609154002', '68466008',
        '85053006'
    }


class EndotrachealIntubation(ValueSet):
    """

    Clinical Focus: This grouping value set contains procedures used to define endotracheal intubation.
    Data Element Scope: The intent of this data element is to identify patients who receive endotracheal intubation as a medical procedure. Using the Quality Data Model, this particular element would map to the Procedure, Performed datatype.
    Inclusion Criteria: Include codes that identify patients receiving an endotracheal airway inserted into the trachea. This is a grouping of ICD10PCS and SNOMEDCT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.69'
    VALUE_SET_NAME = 'Endotracheal Intubation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'0BH13EZ', '0BH17EZ', '0BH18EZ', '5A1935Z', '5A1945Z', '5A1955Z'}

    ICD9CM = {'9604', '9670', '9671', '9672'}

    SNOMEDCT = {
        '112798008', '16883004', '182682004', '232674004', '232675003', '232677006', '232678001',
        '232679009', '232680007', '232682004', '232685002', '232686001', '243141005', '304341005',
        '418613003', '429161001'
    }


class IvCefazolin(ValueSet):
    """

    Clinical Focus: This set of values includes select antibiotics that are used in an inpatient setting for surgical prophylaxis.  This antibiotic is Cefazolin only.  These are not dose specific, however, they must only be given intravenously.
    Data Element Scope: The intent of this data element is to identify patients who are on the antibiotic Cefazolin for surgical prophylaxis.  Using the Quality Data Model, this element will map to the Medication category.
    Inclusion Criteria: Only use codes which represent the antibiotic Cefazolin which is given intravenously.  Codes used are to be RxNorm codes only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.7'
    VALUE_SET_NAME = 'IV Cefazolin'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1665050', '1665052', '1665060', '313920'}


class TracheostomyCare(ValueSet):
    """

    Clinical Focus: This set of values contains procedure codes used for tracheostomy care.
    Data Element Scope: The intent of this data element is to identify patients who have had a procedure for tracheostomy care.  Using the Quality Data Model, this particular element will map to the Intervention category.
    Inclusion Criteria: Include codes representing a procedure related to tracheostomy care utilizing the ICD 10CM, ICD9 and SNOMED CT code systems.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.77'
    VALUE_SET_NAME = 'Tracheostomy care'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'Z430'}

    ICD9CM = {'9723'}

    SNOMEDCT = {'385858000', '410213006'}


class IvCefuroxime(ValueSet):
    """

    Clinical Focus: This set of values includes select antibiotics that are used in an inpatient setting for surgical prophylaxis.  This antibiotic is Cefuroxime only.  These are not dose specific, however, they must only be given intravenously.
    Data Element Scope: The intent of this data element is to identify patients who are on the antibiotic Cefuroxime for surgical prophylaxis.  Using the Quality Data Model, this element will map to the Medication category.
    Inclusion Criteria: Only use codes which represent the antibiotic Cefuroxime which is given intravenously.  Codes used are to be RxNorm codes only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.8'
    VALUE_SET_NAME = 'IV Cefuroxime'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1665444', '1665449', '309101'}


class DiagnosesAsReasonsForAdmissionToIcuDueToPneumonia(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses for which the patient was admitted to ICU.
    Data Element Scope: The intent of this data element is to identify the reason patients were admitted to ICU.  Using the Quality Data Model, this particular element will map to the Diagnosis category.
    Inclusion Criteria: Include codes representing reason for admission to ICU due to pneumonia using the SNOMED CT,  ICD 10 CM and ICD 9 CM code systems.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1045.84'
    VALUE_SET_NAME = 'Diagnoses as Reasons For Admission to ICU due to Pneumonia'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I950', 'I951', 'I952', 'I953', 'I9581', 'I9589', 'I959', 'J80', 'J95821', 'J95822',
        'J9600', 'J9601', 'J9602', 'J9610', 'J9611', 'J9612', 'J9620', 'J9621', 'J9622', 'J9690',
        'J9691', 'J9692', 'R000', 'R0600', 'R0682', 'R0902', 'R6521'
    }

    ICD9CM = {
        '4580', '4581', '45821', '45829', '4588', '4589', '51881', '51882', '51884', '7850',
        '78552', '78606', '78609', '79902'
    }

    SNOMEDCT = {
        '101301000119106', '11092001', '12983003', '15765005', '162892000', '162916002',
        '162992001', '162993006', '18613002', '195506001', '213255003', '213256002', '230664009',
        '234171009', '234173007', '234174001', '24051007', '25691001', '271823003', '271825005',
        '28651003', '286963007', '3424008', '361206004', '371769008', '373895009', '389087006',
        '397767007', '39871006', '408667000', '408668005', '426896000', '427084000', '428173007',
        '429561008', '442515000', '45007003', '61933008', '65710008', '67905004', '70247006',
        '709110009', '709111008', '70993000', '75181005', '76571007', '77545000', '82338001',
        '86651002'
    }


class LiveBirthNewbornBornInHospital(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses that are commonly used in the inpatient setting for newborn live born, and born in hospital. This value set is a grouping value set composed of  ICD-10-CM and SNOMED CT value sets.
    Data Element Scope: The intent of this data element is to identify patients who have active diagnosis, mapped to QDM "Diagnosis" or to the "Principal Diagnosis" or "Diagnosis" attributes of the QDM "Encounter" datatype.
    Inclusion Criteria: This value set includes ICD-10-CM  and SNOMED CT value sets.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1046.6'
    VALUE_SET_NAME = 'Live Birth Newborn Born in Hospital'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'Z3800', 'Z3801', 'Z3830', 'Z3831', 'Z3861', 'Z3868', 'Z3869'}

    SNOMEDCT = {
        '10760661000119109', '10760701000119102', '10760741000119100', '10760781000119105',
        '10760821000119100', '10760861000119105', '10760901000119104', '112075006', '15467003',
        '169826009', '169828005', '169829002', '169831006', '169832004', '169833009', '22514005',
        '25192009', '281050002', '30165006', '34100008', '38257001', '390959009', '39213008',
        '87662006'
    }


class AbdominalAorticAneurysm(ValueSet):
    """

    Clinical Focus: The general purpose of this value set is to capture the active diagnosis of an abdominal aortic aneurysm.
    Data Element Scope:
    Inclusion Criteria: Any disorders or situations that indicate a patient has an abdominal aortic aneurysm are included. A history of repair of this specific aneurysm is also included in the set of values.
    Exclusion Criteria: Other aneurysms not specific to abdominal aortic aneurysms are excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.17'
    VALUE_SET_NAME = 'Abdominal Aortic Aneurysm'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'A5201', 'I713', 'I714', 'I715', 'I716'}

    ICD9CM = {'0930', '4413', '4414', '4416', '4417'}

    SNOMEDCT = {
        '139941000119104', '140631000119109', '14336007', '195268001', '233984007', '233985008',
        '314186008', '315295003', '408666009', '425771001', '444569004', '75878002'
    }


class AtherosclerosisAndPeripheralArterialDisease(ValueSet):
    """

    Clinical Focus: This set of values is intended to capture that a patient has a diagnosis, condition, or disorder of Atherosclerosis or Peripheral Arterial Disease (PAD).
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Conditions that indicate arterial blood flow is restricted putting patients at higher risk for heart disease are included.
    Exclusion Criteria: Other vascular conditions that are not diagnosed as part of Atherosclerosis and Peripheral Artery Disease are excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.21'
    VALUE_SET_NAME = 'Atherosclerosis and Peripheral Arterial Disease'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'E0851', 'E0852', 'E0951', 'E0952', 'I2510', 'I25110', 'I25111', 'I25118', 'I25119',
        'I25700', 'I25701', 'I25708', 'I25709', 'I25710', 'I25711', 'I25718', 'I25719', 'I25720',
        'I25721', 'I25728', 'I25729', 'I25730', 'I25731', 'I25738', 'I25739', 'I25750', 'I25751',
        'I25758', 'I25759', 'I25760', 'I25761', 'I25768', 'I25769', 'I25790', 'I25791', 'I25798',
        'I25799', 'I25810', 'I25811', 'I25812', 'I2583', 'I2584', 'I2589', 'I700', 'I701',
        'I70201', 'I70202', 'I70203', 'I70208', 'I70209', 'I70211', 'I70212', 'I70213', 'I70218',
        'I70219', 'I70229', 'I70235', 'I70245', 'I7025', 'I70261', 'I70262', 'I70263', 'I70268',
        'I70269', 'I70308', 'I70393', 'I70398', 'I70399', 'I708', 'I7090', 'I7091'
    }

    ICD9CM = {
        '41407', '4143', '4144', '4370', '4400', '4401', '44020', '44021', '44022', '44023',
        '44024', '44029', '44030', '4404', '4408', '4409'
    }

    SNOMEDCT = {
        '127014009', '13954005', '145891000119104', '149841000119109', '238793001', '238794007',
        '399957001', '413838009', '421365002', '421895002', '422166005', '429768000', '441574008',
        '442701004', '442735001', '443502000', '45281005', '5111000119102', '51274000', '55382008',
        '5561000119107', '63491006', '8001000119106', '81817003'
    }


class DeliveryProcedure(ValueSet):
    """

    Clinical Focus: This set of values contain codes commonly used in the outpatient setting to identify patients who had a live birth or delivery.
    Data Element Scope: The intent of this data element is identify patients who had a live birth or delivery.  Using the Quality Data Model, this particular element would map to the "Procedure, Performed" element.
    Inclusion Criteria: The codes used in this value set can be reasonably used to identify patients who had a live birth or delivery.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1078.5'
    VALUE_SET_NAME = 'Delivery - Procedure'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '59400', '59409', '59410', '59510', '59514', '59515', '59610', '59612', '59614', '59618',
        '59620', '59622'
    }

    ICD10PCS = {
        '10D00Z0', '10D00Z1', '10D00Z2', '10D07Z3', '10D07Z4', '10D07Z5', '10D07Z6', '10D07Z7',
        '10D07Z8', '10D17ZZ', '10D18ZZ', '10D27ZZ', '10D28ZZ', '10E0XZZ'
    }

    ICD9CM = {
        '720', '721', '7221', '7229', '7231', '7239', '724', '7251', '7252', '7253', '7254', '726',
        '7271', '7279', '728', '729', '7301', '7309', '731', '7321', '7322', '733', '734', '7351',
        '7359', '736', '738', '7391', '7392', '7393', '7394', '7399', '740', '741', '742', '744',
        '7499'
    }

    SNOMEDCT = {
        '10745001', '11466000', '14119008', '15413009', '16819009', '177128002', '177141003',
        '177142005', '177143000', '177152009', '177157003', '177158008', '177161009', '177162002',
        '177164001', '177167008', '177168003', '177170007', '177173009', '177174003', '177175002',
        '177176001', '177179008', '177180006', '177181005', '177184002', '177203002', '17860005',
        '18625004', '19390001', '22633006', '236973005', '236974004', '236975003', '236976002',
        '236977006', '236978001', '236985002', '236986001', '236989008', '237311001', '25296001',
        '25828002', '26313002', '265639000', '274130007', '275168001', '275169009', '287976008',
        '29613008', '302382009', '302383004', '30476003', '306727001', '359940006', '359943008',
        '384729004', '38479009', '386622003', '387711001', '398307005', '40219000', '416055001',
        '417121007', '45718005', '54973000', '5556001', '57271003', '61586001', '62508004',
        '69162008', '69422002', '71166009', '72492007', '84195007', '85403009', '89053004',
        '89346004', '89849000', '90438006'
    }


class FaceToFaceInteractionNoEd(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113762.1.4.1080.1'
    VALUE_SET_NAME = 'Face to Face Interaction - No ED'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class IvAntihypertensives(ValueSet):
    """

    Clinical Focus: This set of values contains IV anti-hypertensive medications allowable as a reason for extending the initiation of IV thrombolytic medications.
    Data Element Scope: The intent of this data element is to identify patients who are prescribed IV anti-hypertensive medications. Using the Quality Data Model, this particular element would map to the Medication category.
    Inclusion Criteria: Include single ingredient prescribable anti-hypertensive medications. Ingectable dose forms should be included. Generic only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1110.10'
    VALUE_SET_NAME = 'IV AntiHypertensives'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1234256', '204404', '237205', '240793', '245276', '312002', '312004', '312006', '858599',
        '858603', '858607', '966571', '977865'
    }


class CornualEctopicPregnancy(ValueSet):
    """

    Clinical Focus: This set of values contains diagnosis that represent a cornual ectopic pregnancy
    Data Element Scope: The intent of this data element is to identify a cornual ectopic pregnancy.
    Inclusion Criteria: Includes codes representing cornual ectopic pregancy
    Exclusion Criteria: Excludes codes representing ectopic pregnancies other than cornual ectopic pregnancies, such as tubal ectopic pregnancies.
    """

    OID = '2.16.840.1.113762.1.4.1110.12'
    VALUE_SET_NAME = 'Cornual Ectopic Pregnancy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'O008', 'O0080', 'O0081'}

    SNOMEDCT = {'87605005'}


class PerforationOfUterus(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses that represent perforation of the uterus.
    Data Element Scope: The intent of this data element is to identify perforation of the uterus.
    Inclusion Criteria: Includes codes that identify perforation of the uterus.
    Exclusion Criteria: Excludes codes indentifying perforation to body structures other than the uterus.
    """

    OID = '2.16.840.1.113762.1.4.1110.14'
    VALUE_SET_NAME = 'Perforation of Uterus'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'O7181'}

    SNOMEDCT = {'15809008', '20216003', '236722007', '50726009', '7395000', '77099001'}


class UterineRupture(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses that represent a uterine rupture
    Data Element Scope: The intent of this data element is to identify a uterine rupture.
    Inclusion Criteria: Include codes that identify a uterine rupture.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1110.16'
    VALUE_SET_NAME = 'Uterine Rupture'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'O7100', 'O7102', 'O7103', 'O711'}

    SNOMEDCT = {
        '15504009', '199960005', '199961009', '199964001', '199965000', '34430009', '370500003',
        '49561003', '69270005'
    }


class TransabdominalCerclage(ValueSet):
    """

    Clinical Focus: This set of values contains cervical cerclage procedures performed by the abdominal approach.
    Data Element Scope: The intent of this value set is to identify patients who have had a transabdominal cerclage.
    Inclusion Criteria: Cervical cerclage procedures performed by the abdominal approach should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1110.18'
    VALUE_SET_NAME = 'Transabdominal Cerclage'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0UVC0CZ', '0UVC0DZ', '0UVC0ZZ', '0UVC3CZ', '0UVC3DZ', '0UVC3ZZ', '0UVC4CZ', '0UVC4DZ',
        '0UVC4ZZ', '0UVC7DZ', '0UVC7ZZ', '0UVC8DZ', '0UVC8ZZ'
    }

    SNOMEDCT = {'46681009'}


class StatinGrouper(ValueSet):
    """

    Clinical Focus: This set of values contains statin medications that are prescribed for therapy at hospital discharge.
    Data Element Scope: The intent of this data element is to identify patients who are prescribed statin medications at discharge. Using the Quality Data Model, this particular element would map to the Medication category.
    Inclusion Criteria: Include single and multiple ingredient prescribable statin medications. Oral dose forms should be included. Generic only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1110.19'
    VALUE_SET_NAME = 'Statin Grouper'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1189804', '1189808', '1189821', '1312409', '1312416', '1312423', '1422086', '1422093',
        '1422096', '1422099', '1439888', '1439897', '197903', '197904', '197905', '198211',
        '200345', '259255', '310404', '310405', '312961', '312962', '314231', '359731', '359732',
        '360507', '404011', '404013', '433848', '433849', '476345', '476349', '476350', '476351',
        '582041', '582042', '582043', '597967', '597971', '597974', '597977', '597980', '597984',
        '597987', '597990', '597993', '617310', '617311', '617312', '644112', '757702', '757703',
        '757704', '757705', '761907', '761909', '762970', '859419', '859424', '859747', '859751',
        '861643', '861648', '861652', '904458', '904467', '904475', '904481', '999935', '999942'
    }


class Dabigatran(ValueSet):
    """

    Clinical Focus: This set of values contains codes which identify a select the oral direct thrombin inhibitor dabigatran.
    Data Element Scope: The intent of this data element is to identify patients who are on the direct thrombin inhibitor dabigatran.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Only include RxNorm codes which represent dabigatran.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1110.4'
    VALUE_SET_NAME = 'Dabigatran'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1037045', '1037179', '1723476'}


class HospitalSettings(ValueSet):
    """

    Clinical Focus: This set of values identifies hospital environments where a patient may receive inpatient or outpatient care.
    Data Element Scope: The intent of this data element is to identify hospital environments where a patient may receive inpatient or outpatient care.  Using the Quality Data Model, this particular element will map to the Transfer category.
    Inclusion Criteria: Use the concept of hospital environment (22232009) and all its children.  Codes used are to be SNOMED-CT codes only.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.126'
    VALUE_SET_NAME = 'Hospital Settings'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '18095007', '20078004', '20316001', '2081004', '22232009', '224687002', '224924009',
        '224929004', '225728007', '225732001', '274516006', '284548004', '288561005', '309895006',
        '309896007', '309897003', '309898008', '309899000', '309900005', '32074000', '33022008',
        '34304006', '36125001', '405608006', '4322002', '434771000124107', '435821000124103',
        '435831000124100', '435841000124105', '440654001', '440655000', '443750004', '448399001',
        '45131006', '46111000', '48120004', '48311003', '54372004', '56109004', '62480006',
        '69362002', '73770003', '79993009', '80522000', '82242000'
    }


class DevicesIndicatingUrinaryDiversion(ValueSet):
    """

    Clinical Focus: This set of values contains  urinary diversion devices.
    Data Element Scope: The intent of this data element is to identify patients who have have a urinary diversion device. Using the Quality Data Model, this particular element will map to the Device category.
    Inclusion Criteria: Include codes that identify urinary diversion devices utilizing  SNOMED CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1111.133'
    VALUE_SET_NAME = 'Devices indicating urinary diversion'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '286861005', '337488000', '344088002', '344575009', '401607008', '401608003', '401609006',
        '401610001', '401611002', '401612009', '401613004', '401614005', '401615006', '401616007',
        '463806001', '470207000', '712481004'
    }


class DevicesIndicatingIntermittentCatheterization(ValueSet):
    """

    Clinical Focus: This set of values contains Devices used to identify patients receiving intermittent catheterization.
    Data Element Scope: The intent of this data element is to identify patients receiving intermittent catheterization. Using the Quality Data Model, this particular element will map to the Device category.
    Inclusion Criteria: Include SNOMED CT codes that identify the Devices for intermittent urethral catheterization.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.135'
    VALUE_SET_NAME = 'Devices indicating intermittent catheterization'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'469561009', '469672008', '469715007', '469859009', '470027009'}


class DevicesIndicatingUrethralCatheter(ValueSet):
    """

    Clinical Focus: This set of values contains urethral catheter devices.
    Data Element Scope: The intent of this data element is to identify patients with a urethral catheter. Using the Quality Data Model, this particular element will map to the Device category.
    Inclusion Criteria: Include SNOMED CT codes that identify patients with devices related to urethral catheterization.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.136'
    VALUE_SET_NAME = 'Devices indicating urethral catheter'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '266737003', '335406004', '34759008', '391691003', '395318009', '395336009', '395337000',
        '395338005', '395339002', '395340000', '395341001', '395342008', '395343003', '395344009',
        '395345005', '395346006', '395347002', '395355009', '395356005', '395357001', '395358006',
        '395359003', '395360008', '395361007', '395362000', '395367006', '395368001', '395369009',
        '395370005', '395371009', '395372002', '395373007', '395374001', '395375000', '395376004',
        '395377008', '395378003', '395383006', '395384000', '395385004', '395386003'
    }


class EmergencyDepartmentLocation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113762.1.4.1111.14'
    VALUE_SET_NAME = 'Emergency department location'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'225728007', '73770003'}


class UrineAntigenTestForLegionellaPneumophilaOrStreptococcusPneumoniae(ValueSet):
    """

    Clinical Focus: This value set contains codes which represent a urine antigen lab test for Legionella pneumophila.
    Data Element Scope: The intent of this data element is to identify patients who have had a urine antigen laboratory test for a Legionella pneumophila.  Using the Quality Data Model, this particular element will map to the "Laboratory test, performed datatype.
    Inclusion Criteria: Include codes representing a urine antigen test for Legionella pneumophila using the LOINC code system.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.20'
    VALUE_SET_NAME = 'Urine antigen test for Legionella pneumophila or Streptococcus pneumoniae'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'17058-9', '17059-7', '24027-5', '31870-9', '6447-7', '6448-5'}


class BacterialCulture(ValueSet):
    """

    Clinical Focus: This set of concepts identifies possible results of a bacterial culture from various bodily fluids including bone marrow, tissue, gastric fluid, body fluid, sputum, stool, peritoneal fluid and others as well as from various devices in body such as central lines.
    Data Element Scope:
    Inclusion Criteria: This set of concepts includes codes identifying if bacteria are identified in the sites or bodily fluid identified in the clinical focus.  These codes are LOINC codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.22'
    VALUE_SET_NAME = 'Bacterial culture'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '13315-7', '17956-4', '19126-2', '20474-3', '21020-3', '23667-9', '32367-5', '42803-7',
        '43408-4', '43409-2', '43411-8', '52967-7', '600-7', '60258-1', '610-6', '611-4', '621-3',
        '622-1', '625-4', '630-4', '6460-0', 'LP37205-9', 'LP45637-3', 'LP45639-9', 'LP45641-5',
        'LP45643-1', 'LP46092-0', 'LP52758-7', 'LP63349-2', 'LP69924-6'
    }


class PcrTestForLegionellaPneumophila(ValueSet):
    """

    Clinical Focus: This value set contains codes which represent a lab test for Legionella pneumophila.
    Data Element Scope: The intent of this data element is to identify patients who have had a laboratory test for a Legionella pneumophila.  Using the Quality Data Model, this particular element will map to the "Laboratory test, performed datatype.
    Inclusion Criteria: Include codes representing a PCR test for Legionella pneumophila using the LOINC code system.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.23'
    VALUE_SET_NAME = 'PCR Test for Legionella pneumophila'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'21363-7'}


class ProceduresAsReasonsForAdmissionToIcuDueToPneumonia(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses for which the patient was admitted to ICU.
    Data Element Scope: The intent of this data element is to identify the reason patients were admitted to ICU.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Include codes representing procedures that are reason for admission to ICU due to pneumonia using the SNOMED CT and ICD-10-PCS code systems.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.26'
    VALUE_SET_NAME = 'Procedures as Reasons for Admission to ICU Due to Pneumonia'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '5A09357', '5A09358', '5A09359', '5A0935B', '5A0935Z', '5A09457', '5A09458', '5A09459',
        '5A0945B', '5A0945Z', '5A09557', '5A09558', '5A09559', '5A0955B', '5A0955Z'
    }

    SNOMEDCT = {
        '243141005', '243143008', '243147009', '243148004', '243149007', '243150007', '243152004',
        '243153009', '243155002', '243156001', '243159008', '243174005', '26763009', '397899008',
        '397998001', '405609003', '40617009', '410208007', '410210009'
    }


class OrganTransplantRecipient(ValueSet):
    """

    Clinical Focus: The purpose of this value set is to identify patients who have received an organ transplant at some time.
    Data Element Scope: The intent of this data element is to identify patients who have had an organ transplant.  Using the Quality Data Model, this particular element will map to the Diagnosis category
    Inclusion Criteria: Include codes/concepts which represent an organ transplant in SNOMEDCT, ICD9 or ICD10.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.27'
    VALUE_SET_NAME = 'Organ Transplant Recipient'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'Z940', 'Z941', 'Z942', 'Z943', 'Z944', 'Z945', 'Z946', 'Z947', 'Z9481', 'Z9482', 'Z9483',
        'Z9484', 'Z9489', 'Z949'
    }

    ICD9CM = {
        'V420', 'V421', 'V422', 'V423', 'V424', 'V425', 'V426', 'V427', 'V4281', 'V4282', 'V4283',
        'V4284', 'V4289', 'V429'
    }

    SNOMEDCT = {'702773008', '702774002', '702775001', '702776000', '702777009'}


class AnotherSourceOfInfection(ValueSet):
    """

    Clinical Focus: This set of value represents another source of infection using concepts defined in the data element "Another Source of Infection" in the IQR data dictionary.
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.28'
    VALUE_SET_NAME = 'Another Source of Infection'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A000', 'A001', 'A009', 'A0100', 'A0101', 'A0102', 'A0104', 'A0105', 'A0109', 'A011',
        'A012', 'A013', 'A014', 'A020', 'A0220', 'A0221', 'A0223', 'A0224', 'A0225', 'A0229',
        'A028', 'A029', 'A030', 'A031', 'A032', 'A033', 'A038', 'A039', 'A040', 'A041', 'A042',
        'A043', 'A044', 'A045', 'A046', 'A047', 'A048', 'A049', 'A060', 'A063', 'A064', 'A066',
        'A0681', 'A0682', 'A0689', 'A069', 'A071', 'A088', 'A09', 'A1801', 'A1803', 'A1814',
        'A1884', 'A200', 'A201', 'A202', 'A203', 'A207', 'A208', 'A209', 'A210', 'A211', 'A212',
        'A213', 'A217', 'A218', 'A219', 'A220', 'A222', 'A228', 'A229', 'A230', 'A231', 'A232',
        'A233', 'A238', 'A239', 'A240', 'A241', 'A242', 'A243', 'A249', 'A250', 'A251', 'A259',
        'A260', 'A268', 'A269', 'A270', 'A2781', 'A2789', 'A279', 'A280', 'A281', 'A282', 'A288',
        'A289', 'A311', 'A312', 'A318', 'A319', 'A320', 'A3211', 'A3212', 'A3281', 'A3282',
        'A3289', 'A329', 'A34', 'A35', 'A363', 'A3681', 'A3682', 'A3683', 'A3684', 'A3685',
        'A3686', 'A3689', 'A369', 'A3700', 'A3710', 'A3780', 'A3790', 'A380', 'A381', 'A388',
        'A389', 'A390', 'A391', 'A392', 'A394', 'A3950', 'A3951', 'A3952', 'A3953', 'A3981',
        'A3982', 'A3983', 'A3984', 'A3989', 'A399', 'A421', 'A422', 'A427', 'A4281', 'A4282',
        'A4289', 'A429', 'A431', 'A438', 'A439', 'A440', 'A441', 'A448', 'A449', 'A46', 'A480',
        'A482', 'A483', 'A484', 'A488', 'A4901', 'A4902', 'A493', 'A5001', 'A5002', 'A5003',
        'A5005', 'A5006', 'A5007', 'A5008', 'A5009', 'A501', 'A502', 'A5030', 'A5031', 'A5032',
        'A5039', 'A5040', 'A5041', 'A5042', 'A5043', 'A5044', 'A5045', 'A5049', 'A5052', 'A5053',
        'A5054', 'A5055', 'A5056', 'A5057', 'A5059', 'A506', 'A507', 'A509', 'A510', 'A511',
        'A512', 'A5131', 'A5132', 'A5139', 'A5141', 'A5142', 'A5143', 'A5144', 'A5145', 'A5146',
        'A5149', 'A515', 'A519', 'A5200', 'A5201', 'A5202', 'A5203', 'A5204', 'A5205', 'A5206',
        'A5209', 'A5210', 'A5211', 'A5212', 'A5213', 'A5214', 'A5215', 'A5217', 'A5219', 'A522',
        'A523', 'A5271', 'A5274', 'A5275', 'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529',
        'A530', 'A539', 'A5400', 'A5401', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423',
        'A5424', 'A5429', 'A5430', 'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442',
        'A5443', 'A5449', 'A546', 'A5481', 'A5482', 'A5483', 'A5485', 'A5489', 'A549', 'A55',
        'A5600', 'A5601', 'A5602', 'A5609', 'A5611', 'A5619', 'A562', 'A563', 'A568', 'A57', 'A58',
        'A5900', 'A5901', 'A5902', 'A5903', 'A5909', 'A598', 'A599', 'A638', 'A64', 'A65', 'A660',
        'A661', 'A662', 'A663', 'A664', 'A665', 'A666', 'A667', 'A668', 'A669', 'A670', 'A671',
        'A672', 'A673', 'A679', 'A690', 'A691', 'A6920', 'A6921', 'A6922', 'A698', 'A699', 'A70',
        'A710', 'A711', 'A719', 'A7481', 'A7489', 'A749', 'A7740', 'A7741', 'A7749', 'A778',
        'A791', 'A7981', 'A7989', 'A799', 'B088', 'B09', 'B471', 'B479', 'B5800', 'B5801', 'B5809',
        'B581', 'B582', 'B5881', 'B5882', 'B5883', 'B5889', 'B950', 'B951', 'B952', 'B954', 'B955',
        'B9561', 'B9562', 'B957', 'B958', 'B9620', 'B9621', 'B9622', 'B9623', 'B9629', 'B964',
        'B965', 'B966', 'B967', 'B9681', 'B9682', 'B9689', 'G000', 'G001', 'G002', 'G003', 'G008',
        'G009', 'G01', 'G039', 'G042', 'G053', 'G054', 'G060', 'G061', 'G062', 'G07', 'H05023',
        'H05029', 'H6000', 'H6001', 'H6002', 'H6003', 'H6010', 'H6011', 'H6012', 'H6013', 'H6020',
        'H6021', 'H6022', 'H6023', 'H60311', 'H60312', 'H60313', 'H60319', 'H60321', 'H60322',
        'H60323', 'H60329', 'H60391', 'H60392', 'H60393', 'H60399', 'H60511', 'H60512', 'H60513',
        'H60519', 'H60521', 'H60522', 'H60523', 'H60529', 'H60531', 'H60532', 'H60533', 'H60539',
        'H60541', 'H60542', 'H60543', 'H60549', 'H60551', 'H60552', 'H60553', 'H60559', 'H6240',
        'H6241', 'H6242', 'H6243', 'H66001', 'H66002', 'H66003', 'H66004', 'H66005', 'H66006',
        'H66007', 'H66009', 'H66011', 'H66012', 'H66013', 'H66014', 'H66015', 'H66016', 'H66017',
        'H66019', 'I330', 'J36', 'K122', 'K50014', 'K50114', 'K50814', 'K50914', 'K51014',
        'K51214', 'K51314', 'K51414', 'K51514', 'K51814', 'K51914', 'K5700', 'K5701', 'K5712',
        'K5720', 'K5721', 'K5732', 'K5733', 'K5740', 'K5741', 'K5752', 'K5753', 'K5780', 'K5781',
        'K5792', 'K5793', 'K610', 'K611', 'K612', 'K613', 'K614', 'K630', 'K650', 'K651', 'K652',
        'K653', 'K654', 'K658', 'K659', 'K6811', 'K6812', 'K6819', 'K810', 'K9081', 'K9402',
        'K9412', 'K9501', 'K9581', 'L0100', 'L0101', 'L0102', 'L0103', 'L0109', 'L011', 'L0201',
        'L0202', 'L0203', 'L0211', 'L0212', 'L0213', 'L02211', 'L02212', 'L02213', 'L02214',
        'L02215', 'L02216', 'L02219', 'L02221', 'L02222', 'L02223', 'L02224', 'L02225', 'L02226',
        'L02229', 'L02231', 'L02232', 'L02233', 'L02234', 'L02235', 'L02236', 'L02239', 'L0231',
        'L0232', 'L0233', 'L02411', 'L02412', 'L02413', 'L02414', 'L02415', 'L02416', 'L02419',
        'L02421', 'L02422', 'L02423', 'L02424', 'L02425', 'L02426', 'L02429', 'L02431', 'L02432',
        'L02433', 'L02434', 'L02435', 'L02436', 'L02439', 'L02511', 'L02512', 'L02519', 'L02521',
        'L02522', 'L02529', 'L02531', 'L02532', 'L02539', 'L02611', 'L02612', 'L02619', 'L02621',
        'L02622', 'L02629', 'L02631', 'L02632', 'L02639', 'L02811', 'L02818', 'L02821', 'L02828',
        'L02831', 'L02838', 'L0291', 'L0292', 'L0293', 'L03011', 'L03012', 'L03019', 'L03021',
        'L03022', 'L03029', 'L03031', 'L03032', 'L03039', 'L03041', 'L03042', 'L03049', 'L03111',
        'L03112', 'L03113', 'L03114', 'L03115', 'L03116', 'L03119', 'L03121', 'L03122', 'L03123',
        'L03124', 'L03125', 'L03126', 'L03129', 'L03211', 'L03212', 'L03221', 'L03222', 'L03311',
        'L03312', 'L03313', 'L03314', 'L03315', 'L03316', 'L03317', 'L03319', 'L03321', 'L03322',
        'L03323', 'L03324', 'L03325', 'L03326', 'L03327', 'L03329', 'L03811', 'L03818', 'L03891',
        'L03898', 'L0390', 'L0391', 'L040', 'L041', 'L042', 'L043', 'L048', 'L049', 'L0501',
        'L0591', 'L080', 'L081', 'L0881', 'L0889', 'L089', 'L88', 'L928', 'L980', 'L983', 'M0010',
        'M00111', 'M00112', 'M00119', 'M00121', 'M00122', 'M00129', 'M00131', 'M00132', 'M00139',
        'M00141', 'M00142', 'M00149', 'M00151', 'M00152', 'M00159', 'M00161', 'M00162', 'M00169',
        'M00171', 'M00172', 'M00179', 'M0018', 'M0019', 'M009', 'M01X0', 'M01X19', 'M01X29',
        'M01X39', 'M01X49', 'M01X59', 'M01X69', 'M01X79', 'M01X8', 'M01X9', 'M0230', 'M02311',
        'M02312', 'M02319', 'M02321', 'M02322', 'M02329', 'M02331', 'M02332', 'M02339', 'M02341',
        'M02342', 'M02349', 'M02351', 'M02352', 'M02359', 'M02361', 'M02362', 'M02369', 'M02371',
        'M02372', 'M02379', 'M0238', 'M0239', 'M4620', 'M4621', 'M4622', 'M4623', 'M4624', 'M4625',
        'M4626', 'M4627', 'M4628', 'M4630', 'M4631', 'M4632', 'M4633', 'M4634', 'M4635', 'M4636',
        'M4637', 'M4638', 'M4639', 'M60009', 'M8600', 'M86011', 'M86012', 'M86019', 'M86021',
        'M86022', 'M86029', 'M86031', 'M86032', 'M86039', 'M86041', 'M86042', 'M86049', 'M86051',
        'M86052', 'M86059', 'M86061', 'M86062', 'M86069', 'M86071', 'M86072', 'M86079', 'M8608',
        'M8609', 'M8610', 'M86111', 'M86112', 'M86119', 'M86121', 'M86122', 'M86129', 'M86131',
        'M86132', 'M86139', 'M86141', 'M86142', 'M86149', 'M86151', 'M86152', 'M86159', 'M86161',
        'M86162', 'M86169', 'M86171', 'M86172', 'M86179', 'M8618', 'M8619', 'M8620', 'M86211',
        'M86212', 'M86219', 'M86221', 'M86222', 'M86229', 'M86231', 'M86232', 'M86239', 'M86241',
        'M86242', 'M86249', 'M86251', 'M86252', 'M86259', 'M86261', 'M86262', 'M86269', 'M86271',
        'M86272', 'M86279', 'M8628', 'M8629', 'M868X7', 'M869', 'N10', 'N110', 'N111', 'N119',
        'N12', 'N136', 'N151', 'N159', 'N16', 'N2884', 'N2885', 'N2886', 'N3000', 'N3001', 'N341',
        'N390', 'N410', 'N412', 'N413', 'N414', 'N418', 'N419', 'N7001', 'N7002', 'N7003', 'N730',
        'N731', 'N732', 'N733', 'N734', 'N751', 'N758', 'N764', 'N99511', 'O080', 'O2300', 'O2301',
        'O2302', 'O2303', 'O2310', 'O2311', 'O2312', 'O2313', 'O2320', 'O2321', 'O2322', 'O2323',
        'O2330', 'O2331', 'O2332', 'O2333', 'O2340', 'O2341', 'O2342', 'O2343', 'O23511', 'O23512',
        'O23513', 'O23519', 'O23521', 'O23522', 'O23523', 'O23529', 'O23591', 'O23592', 'O23593',
        'O23599', 'O2390', 'O2391', 'O2392', 'O2393', 'O860', 'O8611', 'O8619', 'O8620', 'O8621',
        'O8622', 'O8629', 'O8689', 'T80212A', 'T814XXA', 'T826XXA', 'T8450XA', 'T8451XA',
        'T8452XA', 'T8453XA', 'T8454XA', 'T8459XA', 'T8460XA', 'T84610A', 'T84611A', 'T84612A',
        'T84613A', 'T84614A', 'T84615A', 'T84620A', 'T84621A', 'T84622A', 'T84623A', 'T84624A',
        'T84625A', 'T8463XA', 'T8469XA', 'T8571XA', 'T8572XA', 'T86822', 'T86842'
    }

    ICD9CM = {
        '0010', '0011', '0019', '0020', '0021', '0022', '0023', '0029', '0030', '00320', '00321',
        '00323', '00324', '00329', '0038', '0039', '0040', '0041', '0042', '0043', '0048', '0049',
        '0060', '0061', '0062', '0063', '0065', '0066', '0068', '0069', '0071', '00800', '00801',
        '00802', '00803', '00804', '00809', '0081', '0082', '0083', '00841', '00842', '00843',
        '00844', '00845', '00846', '00847', '00849', '0085', '0088', '0090', '0092', '0200',
        '0201', '0202', '0203', '0204', '0205', '0209', '0210', '0211', '0212', '0213', '0218',
        '0219', '0220', '0222', '0228', '0229', '0230', '0231', '0232', '0233', '0238', '0239',
        '0260', '0261', '0269', '0270', '0271', '0272', '0278', '0279', '0300', '0301', '0302',
        '0303', '0308', '0309', '0311', '0312', '0318', '0319', '03281', '03282', '03283', '03284',
        '03285', '03289', '0329', '0341', '035', '0360', '0361', '0362', '0363', '03640', '03641',
        '03642', '03643', '03681', '03682', '03689', '0369', '037', '0390', '0392', '0393', '0398',
        '0399', '0400', '0402', '04081', '04082', '04089', '04100', '04101', '04102', '04103',
        '04104', '04105', '04109', '04110', '04111', '04112', '04119', '0412', '0413', '04141',
        '04142', '04143', '04149', '0416', '0417', '04181', '04182', '04183', '04184', '04185',
        '04186', '04189', '0419', '0737', '0738', '0739', '0760', '0761', '0769', '0782', '0783',
        '0786', '07888', '07988', '07998', '08240', '08241', '08249', '0828', '0829', '0832',
        '0838', '0839', '0880', '08881', '0900', '0901', '0902', '0903', '09040', '09041', '09042',
        '09049', '0905', '0906', '0907', '0909', '0910', '0911', '0912', '0913', '0914', '09150',
        '09151', '09152', '09161', '09162', '09169', '0917', '09181', '09182', '09189', '0919',
        '0920', '0929', '0930', '0931', '09320', '09321', '09322', '09323', '09381', '09382',
        '09389', '0939', '0940', '0941', '0942', '0943', '09481', '09482', '09483', '09484',
        '09485', '09486', '09487', '09489', '0949', '0950', '0952', '0953', '0954', '0955', '0956',
        '0957', '0958', '0959', '096', '0970', '0971', '0979', '0980', '09810', '09811', '09812',
        '09813', '09814', '09815', '09816', '09817', '09819', '0982', '09830', '09831', '09832',
        '09833', '09834', '09835', '09836', '09837', '09839', '09840', '09841', '09842', '09843',
        '09849', '09850', '09851', '09852', '09853', '09859', '0987', '09881', '09882', '09883',
        '09884', '09885', '09886', '09889', '0990', '0991', '0992', '0993', '09940', '09941',
        '09949', '09950', '09952', '09953', '09954', '09955', '09956', '09959', '0998', '0999',
        '1000', '10081', '10089', '1009', '101', '1020', '1021', '1022', '1023', '1024', '1025',
        '1026', '1027', '1028', '1029', '1030', '1031', '1032', '1033', '1039', '1040', '1048',
        '1049', '1300', '1301', '1302', '1303', '1304', '1305', '1307', '1308', '13100', '13102',
        '13103', '13109', '1318', '1319', '3200', '3201', '3202', '3203', '3207', '32081', '32082',
        '32089', '3209', '3229', '3231', '32341', '32342', '3240', '3241', '3249', '38010',
        '38011', '38013', '38014', '38016', '38021', '38022', '38023', '38200', '38201', '38202',
        '3821', '3822', '4210', '4211', '4219', '4220', '42290', '42291', '42293', '42299', '475',
        '5131', '53901', '53981', '5401', '56201', '56211', '56213', '566', '56722', '56723',
        '56729', '56731', '56738', '56739', '56781', '56782', '56789', '5679', '5695', '56961',
        '5750', '59000', '59001', '59010', '59011', '5902', '5903', '59080', '59081', '5909',
        '5950', '59681', '5990', '6010', '6011', '6012', '6013', '6014', '6018', '6019', '6140',
        '6141', '6142', '6143', '6144', '6145', '6147', '6163', '6164', '6390', '64660', '64661',
        '64662', '64663', '64664', '67000', '67002', '67004', '6800', '6801', '6802', '6803',
        '6804', '6805', '6806', '6807', '6808', '6809', '68100', '68101', '68102', '68110',
        '68111', '6819', '6820', '6821', '6822', '6823', '6824', '6825', '6826', '6827', '6828',
        '6829', '683', '684', '6850', '68600', '68601', '68609', '6861', '6868', '6869', '71190',
        '71191', '71192', '71193', '71194', '71195', '71196', '71197', '71198', '71199', '73000',
        '73001', '73002', '73003', '73004', '73005', '73006', '73007', '73008', '73009', '73010',
        '73011', '73012', '73013', '73014', '73015', '73016', '73017', '73018', '73019', '73020',
        '73021', '73022', '73023', '73024', '73025', '73026', '73027', '73028', '73029', '73030',
        '73031', '73032', '73033', '73034', '73035', '73080', '73081', '73082', '73083', '73084',
        '73085', '73086', '73087', '73088', '73089', '73090', '73091', '73092', '73093', '73094',
        '73095', '73096', '73097', '73098', '73099', '99660', '99661', '99662', '99663', '99664',
        '99665', '99666', '99667', '99668', '99669', '99851', '99859', '99932', '99933', '99934'
    }

    SNOMEDCT = {
        '10188004', '102452004', '102455002', '10321002', '10453005', '105629000', '109242000',
        '109243005', '109244004', '109327001', '109328006', '109331007', '109602002', '109603007',
        '109604001', '109631003', '109686002', '109781001', '109791007', '109809009', '111183001',
        '111252006', '111253001', '111359004', '111367007', '111422001', '111425004', '111751003',
        '111798006', '111806005', '111807001', '111817006', '111839008', '111898002', '111910009',
        '11338007', '11389007', '11817007', '11836002', '11857005', '1197005', '12008008',
        '12115003', '12166008', '12232008', '122862008', '122864009', '12430003', '128045006',
        '128273004', '128936008', '128944008', '128945009', '129128006', '129129003', '13325005',
        '13596001', '13802001', '14268002', '1427008', '14386001', '14948001', '15033003',
        '151004', '15628003', '16119006', '16698000', '1685005', '17028003', '17379000',
        '17438000', '17653001', '17741008', '18071005', '18081009', '18089006', '18504008',
        '186104004', '186105003', '186116005', '186136006', '186156007', '186231006', '186431008',
        '186435004', '186464008', '186729003', '186731007', '186833000', '186847001', '186850003',
        '186854007', '186861006', '186863009', '186867005', '186868000', '186875004', '186877007',
        '186893003', '186899004', '186903006', '186915005', '186931002', '186932009', '186939000',
        '186946009', '186968004', '186973005', '186975003', '187192000', '187194004', '187196002',
        '187197006', '18892009', '18901009', '18929007', '19043005', '19044004', '19206003',
        '19213003', '192643004', '192644005', '19265001', '192701001', '192737006', '19284003',
        '194281003', '19471005', '194926000', '194942007', '194948006', '194950003', '195951007',
        '197092000', '197164008', '197166005', '197172005', '197180003', '197348008', '197768004',
        '197772000', '197963001', '198159006', '198161002', '198227006', '198235009', '198236005',
        '19824006', '19905009', '199106001', '199107005', '199108000', '199109008', '199110003',
        '199112006', '199205008', '199206009', '19956000', '200190007', '200195002', '20025003',
        '200582002', '200586004', '200588003', '200589006', '200594006', '200595007', '200600003',
        '200610007', '200628009', '200630006', '200638004', '200645004', '200648002', '200649005',
        '200650005', '200651009', '200655000', '200656004', '200657008', '200658003', '200659006',
        '200660001', '200661002', '200662009', '200663004', '200666007', '200667003', '200668008',
        '200669000', '200670004', '200674008', '200676005', '200678006', '200679003', '200680000',
        '200681001', '200682008', '200686006', '200751004', '200755008', '201467001', '202756004',
        '202987008', '202988003', '202989006', '202990002', '202991003', '202992005', '202995007',
        '202996008', '202997004', '202998009', '202999001', '203000000', '203001001', '203019005',
        '203153007', '203164005', '203179003', '203184009', '203185005', '203186006', '203189004',
        '203198001', '203199009', '203200007', '203201006', '203202004', '203240001', '203245006',
        '203249000', '203250000', '203263006', '203264000', '203266003', '203267007', '203269005',
        '203270006', '203271005', '203272003', '203274002', '203278004', '203279007', '203280005',
        '203282002', '20372007', '20735004', '20943002', '20965002', '21092002', '21120002',
        '212438008', '213124002', '213137004', '213138009', '21382004', '21560005', '21869003',
        '22064009', '22386003', '22540004', '23014006', '230211002', '23160005', '232212002',
        '232224009', '23502006', '23511006', '235983003', '23640001', '236683007', '23874000',
        '23975003', '240272004', '240352006', '240353001', '240354007', '240355008', '240383005',
        '240557004', '240573005', '240589008', '240661004', '24078009', '24557004', '24868007',
        '25626000', '26039008', '2606006', '26117009', '26135000', '26535009', '266071000',
        '266073002', '266074008', '266077001', '266096002', '266123003', '266125005', '266126006',
        '266127002', '266133006', '266138002', '266143009', '266147005', '266237004', '266463007',
        '266581008', '267204006', '267777001', '267778006', '267779003', '267780000', '267783003',
        '268016009', '268017000', '268018005', '268019002', '271426000', '271449003', '271503005',
        '27351007', '27614006', '27717006', '27836007', '278480000', '27908001', '279324004',
        '28004004', '28061009', '28432003', '28438004', '287001000', '28769004', '28867007',
        '2918000', '29199007', '29689003', '29723007', '299709002', '29976007', '29989001',
        '30080002', '300941005', '300950007', '301086002', '30116001', '30140009', '30168008',
        '301706005', '301711007', '301770000', '301811001', '302013002', '302016005', '302131003',
        '302231008', '30242009', '302809008', '302814007', '307759003', '308660004', '308661000',
        '309083007', '31015008', '310609005', '31137003', '312099009', '312108008', '312154004',
        '312215006', '3135009', '316841006', '31871009', '31993003', '31999004', '32636009',
        '32735002', '32999002', '3321001', '33261009', '33618002', '3419005', '34335000',
        '34684001', '34845009', '34964002', '35089004', '35247001', '35339003', '35490003',
        '35526001', '35742006', '35876006', '3589003', '359747000', '36102002', '36175004',
        '36188001', '36254004', '36276008', '36309003', '36688000', '367434002', '36857002',
        '37246009', '37396007', '37560007', '37589009', '37660004', '37722001', '37754005',
        '37779008', '38279006', '38307006', '38523005', '388982007', '388983002', '38976008',
        '396234004', '39629007', '397428000', '398067003', '398222003', '398599000', '399893000',
        '400008009', '400086005', '40125005', '40149008', '402697000', '405582003', '40603000',
        '406602003', '4082005', '408866006', '4089001', '409498004', '40970001', '409780002',
        '410040001', '41116009', '41174002', '41370002', '41394002', '414529006', '414530001',
        '41545003', '416675009', '416829003', '416893007', '41910004', '41954005', '419868009',
        '421429008', '423271002', '42338000', '423451008', '423590009', '4241002', '42522007',
        '425887005', '426933007', '427795000', '427999003', '428111003', '428174001', '428385007',
        '428437005', '429600003', '430348006', '430958003', '43240000', '43484003', '4359001',
        '43894001', '44361004', '444150000', '44428005', '444646006', '44568006', '44653001',
        '44743006', '449702005', '449717009', '4510004', '45126009', '45348006', '45377007',
        '4559000', '45816000', '46235002', '46355004', '4639008', '4669001', '46699001',
        '46701001', '473047000', '473050002', '473052005', '473053000', '473056008', '473065001',
        '473072000', '473076002', '473083009', '47375003', '47763005', '48277006', '48278001',
        '4834000', '48661000', '48759000', '48903002', '48934003', '49442000', '49736003',
        '49908003', '50528008', '50797007', '50970007', '51036000', '51169003', '51254007',
        '51928006', '52023002', '52138004', '52508001', '52542005', '52681002', '52812002',
        '52890006', '53453008', '53529004', '53664003', '53734002', '53770004', '54825009',
        '55023005', '56165008', '56269007', '56335008', '56663002', '56672005', '57027007',
        '58126003', '58227000', '58265007', '58540009', '58554001', '58750007', '59307008',
        '59530001', '59867002', '59934002', '59967003', '60168000', '60198007', '60335002',
        '6066007', '60893000', '60926001', '61048000', '61585002', '61974008', '62224002',
        '6267005', '62994001', '63302006', '63475008', '63650001', '6365004', '63767001',
        '64043005', '64369009', '64375000', '64576003', '64681004', '64786000', '65049003',
        '65110003', '65154009', '65208005', '65275009', '65295003', '65844007', '65968003',
        '66186006', '66281009', '66301008', '66356008', '66634003', '66704002', '67224007',
        '67272008', '67372006', '67391006', '67525007', '67624004', '67685000', '6803002',
        '68202005', '68226007', '68566005', '69430001', '69595007', '69698001', '69794009',
        '70143003', '70190001', '70647001', '70759006', '70983007', '71057007', '71085009'
    }


class ChestXrayDiagnosticTest(ValueSet):
    """

    Clinical Focus: This set of values contains codes/concepts for chest x-rays.
    Data Element Scope: The intent of this data element is to identify patients who have had a chest x-ray. Using the Quality Data Model, this particular element will map to the Diagnostic Study category.
    Inclusion Criteria: Include codes representing a chest xray test using LOINC, ICD9 or ICD10 code system.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.41'
    VALUE_SET_NAME = 'Chest XRay Diagnostic Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'BW03ZZZ'}

    ICD9CM = {'8744', '8749'}

    LOINC = {
        '24632-2', '24634-8', '24635-5', '24636-3', '24637-1', '24638-9', '24639-7', '24640-5',
        '24641-3', '24642-1', '24643-9', '24644-7', '24645-4', '24646-2', '24647-0', '24648-8',
        '24649-6', '24650-4', '24651-2', '24652-0', '24653-8', '24654-6', '30733-0', '30734-8',
        '30735-5', '30736-3', '30737-1', '30738-9', '30739-7', '30740-5', '30741-3', '30742-1',
        '30743-9', '30744-7', '30745-4', '30746-2', '36298-8', '36320-0', '36554-4', '36572-6',
        '36589-0', '36620-3', '36643-5', '36687-2', '36750-8', '36758-1', '36759-9', '36960-3',
        '37008-0', '37010-6', '37141-9', '37143-5', '37144-3', '37145-0', '37146-8', '37147-6',
        '37150-0', '38001-4', '38002-2', '38068-3', '38181-4', '39051-8', '39070-8', '39074-0',
        '39341-3', '41792-3', '42009-1', '42011-7', '42272-5', '42699-9', '43463-9', '43466-2',
        '43467-0', '43778-0', 'LA16043-4', 'LP68582-3'
    }


class CtScanIncludingChestDiagnosticTest(ValueSet):
    """

    Clinical Focus: This grouping of value sets contains procedures for CT scan which includes the chest.
    Data Element Scope: The intent of this data element is to identify patients who have had a CT scan. Using the Quality Data Model, this particular element will map to the Diagnostic Study category.
    Inclusion Criteria: Include codes representing  a CT scan which includes the chest using ICD9, ICD10 or LOINC code system.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113762.1.4.1111.42'
    VALUE_SET_NAME = 'CT Scan Including Chest Diagnostic Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        'BB2400Z', 'BB240ZZ', 'BB2410Z', 'BB241ZZ', 'BB24Y0Z', 'BB24YZZ', 'BB24ZZZ', 'BB2700Z',
        'BB270ZZ', 'BB2710Z', 'BB271ZZ', 'BB27Y0Z', 'BB27YZZ', 'BB27ZZZ', 'BB2800Z', 'BB280ZZ',
        'BB2810Z', 'BB281ZZ', 'BB28Y0Z', 'BB28YZZ', 'BB28ZZZ', 'BB2900Z', 'BB290ZZ', 'BB2910Z',
        'BB291ZZ', 'BB29Y0Z', 'BB29YZZ', 'BB29ZZZ', 'BP2W0ZZ', 'BP2W1ZZ', 'BP2WYZZ', 'BW2400Z',
        'BW240ZZ', 'BW2410Z', 'BW241ZZ', 'BW24Y0Z', 'BW24YZZ', 'BW24ZZZ', 'BW2500Z', 'BW250ZZ',
        'BW2510Z', 'BW251ZZ', 'BW25Y0Z', 'BW25YZZ', 'BW25ZZZ'
    }

    ICD9CM = {'8741'}

    LOINC = {
        '24627-2', '24628-0', '29252-4', '30598-7', '36054-5', '36089-1', '37439-7', '37440-5',
        '37441-3', '42275-8', '42276-6', '42277-4', '46317-4', '46327-3', '47366-0', '69096-6',
        '72252-0', '72253-8', '72254-6'
    }


class AsthmaManagementPlan(ValueSet):
    """

    Clinical Focus: This value set contains codes representing an asthma management plan document commonly provided to patients, parents and others. It provides guidance for three situations that can occur for asthmatics.
    Data Element Scope: The intent of this data element is to identify asthma management plan documents to determine their communication to the patient/caregiver.  Using the Quality Data Model, this data element maps to the Communication category.
    Inclusion Criteria: Codes representing asthma management plan documents, including the following components: 1) Methods and timing of rescue actions; 2) Appropriate use of long-term asthma medications (controllers); 3) Appropriate use of rescue, quick-relief, or short acting medications of choice to quickly relieve asthma exacerbations (relievers); 4) information on avoidance or mitigation of environmental and other triggers; 5) information regarding arrangements for referral or follow-up care with a healthcare provider.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.131'
    VALUE_SET_NAME = 'Asthma Management Plan'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'69981-9'}


class DischargedToRehabilitationFacility(ValueSet):
    """

    Clinical Focus: This set of values contains procedures that represent the discharge of a patient to rehabilitation facility.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who where discharged to a rehabilitation facility. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing  rehabilitation facilities should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.132'
    VALUE_SET_NAME = 'Discharged to Rehabilitation Facility'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'433591000124103'}


class OralFactorXaInhibitorForVteProphylaxisOrVteTreatment(ValueSet):
    """

    Clinical Focus: This set of values identifies oral Factor Xa inhibitors indicated for VTE prophylaxis and treatment.
    Data Element Scope: The intent of this data element is to identify patients who receive oral factor Xa inhibitors for VTE prophylaxis.  Using the Quality Data Model, this particular element will map to the Medication category.
    Inclusion Criteria: Oral forms of factor Xa inhibitors.
    Exclusion Criteria: Other dose forms of factor Xa inhibitors.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.134'
    VALUE_SET_NAME = 'Oral Factor Xa Inhibitor for VTE Prophylaxis or VTE Treatment'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1114198', '1232082', '1232086', '1364435', '1364445', '1599543', '1599551', '1599555'
    }


class UterineWindow(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses that represent a uterine window.
    Data Element Scope: The intent of this data element is to identify a uterine window. Using the Quality Data Model, this particular element will map to the "Diagnosis" category.
    Inclusion Criteria: Include SNOMED CT codes that identify a uterine window.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.137'
    VALUE_SET_NAME = 'Uterine Window'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'434591000124100'}


class AspirinAllergen(ValueSet):
    """

    Clinical Focus: This set of values contains aspirin medication ingredients that are used to describe allergy to aspirin medications.
    Data Element Scope: The intent of this data element is to identify patients with an allergy to aspirin medications. Using the Quality Data Model, this particular element would map to the Medication, Allergy data type.
    Inclusion Criteria: Include single and multi-ingredient prescribable drugs. Include brand names and precise ingredient prescribable drugs.
    Exclusion Criteria: Exclude codes that represent the data type Medication, order or Medication, discharge not done.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.139'
    VALUE_SET_NAME = 'Aspirin Allergen'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1008791', '1052413', '1052436', '1052442', '1053120', '1053324', '1111420', '1147493',
        '1191', '1193079', '1245474', '1247393', '1247398', '1297834', '1303154', '135095',
        '1358848', '1361397', '1423839', '1438292', '1593109', '17315', '18385', '202554',
        '214159', '214160', '214250', '214251', '214254', '214255', '214256', '214257', '214258',
        '215256', '215431', '215451', '215568', '215575', '215770', '216919', '217020', '217127',
        '217481', '218776', '218783', '219010', '219779', '219980', '220011', '220143', '220751',
        '226716', '227773', '24292', '25027', '353447', '466549', '466584', '669119', '687078',
        '689512', '689518', '689519', '689522', '689524', '689551', '689552', '689554', '701317',
        '702317', '707765', '721973', '724441', '763112', '763117', '817958', '818496', '847088',
        '848763', '848769'
    }


class Principal(ValueSet):
    """

    Clinical Focus: This set of values contains the qualifier value used to identify the term principal.
    Data Element Scope: The intent of this data element is to identify and define the qualifier value principal. Using the Quality Data Model, this particular element would map to the ordinality attribute.
    Inclusion Criteria: Include SNOMEDCT codes that define the principal qualifier value.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.14'
    VALUE_SET_NAME = 'Principal'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'63161005'}


class ScipMajorSurgicalProcedure(ValueSet):
    """

    Clinical Focus: This set of values contains procedures to identify selected major surgeries.
    Data Element Scope: The intent of this data element is to identify patients who have had  a selected major surgery.   Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Include codes that identify selected major surgeries. This is a grouping of ICD 10 PCS, ICD 9 CM and SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.2'
    VALUE_SET_NAME = 'SCIP Major Surgical Procedure'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '00500ZZ', '00510ZZ', '00520ZZ', '00570ZZ', '00580ZZ', '00590ZZ', '005A0ZZ', '005B0ZZ',
        '005C0ZZ', '005D0ZZ', '00800ZZ', '00870ZZ', '00880ZZ', '008Q0ZZ', '009000Z', '00900ZZ',
        '009100Z', '00910ZZ', '009200Z', '00920ZZ', '009300Z', '00930ZZ', '009400Z', '00940ZZ',
        '009500Z', '00950ZZ', '00960ZZ', '009700Z', '00970ZZ', '009800Z', '00980ZZ', '009900Z',
        '00990ZZ', '009A00Z', '009A0ZZ', '009B00Z', '009B0ZZ', '009C00Z', '009C0ZZ', '009D00Z',
        '009D0ZZ', '00B00ZZ', '00B10ZZ', '00B20ZZ', '00B60ZZ', '00B70ZZ', '00B80ZZ', '00B90ZZ',
        '00BA0ZZ', '00BB0ZZ', '00BC0ZZ', '00BD0ZZ', '00C00ZZ', '00C10ZZ', '00C20ZZ', '00C30ZZ',
        '00C40ZZ', '00C50ZZ', '00C60ZZ', '00C70ZZ', '00C80ZZ', '00C90ZZ', '00CA0ZZ', '00CB0ZZ',
        '00CC0ZZ', '00CD0ZZ', '00D10ZZ', '00D20ZZ', '00H002Z', '00H003Z', '00H602Z', '00H603Z',
        '00J00ZZ', '00N90ZZ', '00NA0ZZ', '00P000Z', '00P002Z', '00P003Z', '00P007Z', '00P00JZ',
        '00P00KZ', '00P600Z', '00P602Z', '00P603Z', '00P6X2Z', '00Q90ZZ', '00QA0ZZ', '00T70ZZ',
        '00W000Z', '00W002Z', '00W003Z', '00W007Z', '00W00JZ', '00W00KZ', '00W00MZ', '00W600Z',
        '00W602Z', '00W603Z', '00W60MZ', '0210093', '0210098', '0210099', '021009C', '021009F',
        '021009W', '02100A3', '02100A8', '02100A9', '02100AC', '02100AF', '02100AW', '02100J3',
        '02100J8', '02100J9', '02100JC', '02100JF', '02100JW', '02100K3', '02100K8', '02100K9',
        '02100KC', '02100KF', '02100KW', '02100Z3', '02100Z8', '02100Z9', '02100ZC', '02100ZF',
        '0211093', '0211098', '0211099', '021109C', '021109F', '021109W', '02110A3', '02110A8',
        '02110A9', '02110AC', '02110AF', '02110AW', '02110J3', '02110J8', '02110J9', '02110JC',
        '02110JF', '02110JW', '02110K3', '02110K8', '02110K9', '02110KC', '02110KF', '02110KW',
        '02110Z3', '02110Z8', '02110Z9', '02110ZC', '02110ZF', '0212093', '0212098', '0212099',
        '021209C', '021209F', '021209W', '02120A3', '02120A8', '02120A9', '02120AC', '02120AF',
        '02120AW', '02120J3', '02120J8', '02120J9', '02120JC', '02120JF', '02120JW', '02120K3',
        '02120K8', '02120K9', '02120KC', '02120KF', '02120KW', '02120Z3', '02120Z8', '02120Z9',
        '02120ZC', '02120ZF', '0213093', '0213098', '0213099', '021309C', '021309F', '021309W',
        '02130A3', '02130A8', '02130A9', '02130AC', '02130AF', '02130AW', '02130J3', '02130J8',
        '02130J9', '02130JC', '02130JF', '02130JW', '02130K3', '02130K8', '02130K9', '02130KC',
        '02130KF', '02130KW', '02130Z3', '02130Z8', '02130Z9', '02130ZC', '02130ZF', '021609P',
        '021609Q', '021609R', '02160AP', '02160AQ', '02160AR', '02160JP', '02160JQ', '02160JR',
        '02160KP', '02160KQ', '02160KR', '02160Z7', '02160ZP', '02160ZQ', '02160ZR', '021709P',
        '021709Q', '021709R', '02170AP', '02170AQ', '02170AR', '02170JP', '02170JQ', '02170JR',
        '02170KP', '02170KQ', '02170KR', '02170ZP', '02170ZQ', '02170ZR', '021K09P', '021K09Q',
        '021K09R', '021K0AP', '021K0AQ', '021K0AR', '021K0JP', '021K0JQ', '021K0JR', '021K0KP',
        '021K0KQ', '021K0KR', '021K0Z5', '021K0ZP', '021K0ZQ', '021K0ZR', '021L0Z5', '021L0ZW',
        '02540ZZ', '02550ZZ', '02560ZZ', '02570ZK', '02570ZZ', '02580ZZ', '02590ZZ', '025D0ZZ',
        '025F0ZZ', '025G0ZZ', '025H0ZZ', '025J0ZZ', '025K0ZZ', '025L0ZZ', '025M0ZZ', '0270046',
        '027004Z', '02700D6', '02700DZ', '02700T6', '02700TZ', '02700Z6', '02700ZZ', '0271046',
        '027104Z', '02710D6', '02710DZ', '02710T6', '02710TZ', '02710Z6', '02710ZZ', '0272046',
        '027204Z', '02720D6', '02720DZ', '02720T6', '02720TZ', '02720Z6', '02720ZZ', '0273046',
        '027304Z', '02730D6', '02730DZ', '02730T6', '02730TZ', '02730Z6', '02730ZZ', '027F04Z',
        '027F0DZ', '027F0ZZ', '027G04Z', '027G0DZ', '027G0ZZ', '027H04Z', '027H0DZ', '027H0ZZ',
        '027J04Z', '027J0DZ', '027J0ZZ', '027K04Z', '027K0DZ', '027K0ZZ', '027R04T', '027R0DT',
        '027R0ZT', '02890ZZ', '028D0ZZ', '02B40ZZ', '02B50ZZ', '02B60ZZ', '02B70ZK', '02B70ZZ',
        '02B80ZZ', '02B90ZZ', '02BD0ZZ', '02BF0ZZ', '02BG0ZZ', '02BH0ZZ', '02BJ0ZZ', '02BK0ZZ',
        '02BL0ZZ', '02BM0ZZ', '02BW0ZZ', '02C00ZZ', '02C10ZZ', '02C20ZZ', '02C30ZZ', '02C40ZZ',
        '02C60ZZ', '02C70ZZ', '02C80ZZ', '02C90ZZ', '02CD0ZZ', '02CF0ZZ', '02CG0ZZ', '02CH0ZZ',
        '02CJ0ZZ', '02CK0ZZ', '02CL0ZZ', '02CW0ZZ', '02FN0ZZ', '02H402Z', '02H403Z', '02H40DZ',
        '02H602Z', '02H603Z', '02H60DZ', '02H702Z', '02H703Z', '02H70DZ', '02HA0QZ', '02HA0RS',
        '02HK03Z', '02HK0DZ', '02HL02Z', '02HL03Z', '02HL0DZ', '02HN0MZ', '02L70CK', '02L70DK',
        '02L70ZK', '02LR0ZT', '02LS0ZZ', '02LT0ZZ', '02N40ZZ', '02N60ZZ', '02N70ZZ', '02N80ZZ',
        '02N90ZZ', '02ND0ZZ', '02NF0ZZ', '02NG0ZZ', '02NH0ZZ', '02NJ0ZZ', '02NK0ZZ', '02NL0ZZ',
        '02PA02Z', '02PA03Z', '02PA07Z', '02PA08Z', '02PA0CZ', '02PA0DZ', '02PA0JZ', '02PA0KZ',
        '02PA0QZ', '02PA0RZ', '02Q00ZZ', '02Q10ZZ', '02Q20ZZ', '02Q30ZZ', '02Q40ZZ', '02Q50ZZ',
        '02Q60ZZ', '02Q70ZZ', '02Q80ZZ', '02Q90ZZ', '02QA0ZZ', '02QB0ZZ', '02QC0ZZ', '02QD0ZZ',
        '02QF0ZZ', '02QG0ZZ', '02QH0ZZ', '02QJ0ZZ', '02QK0ZZ', '02QL0ZZ', '02QM0ZZ', '02QN0ZZ',
        '02R507Z', '02R508Z', '02R50JZ', '02R50KZ', '02R607Z', '02R608Z', '02R60JZ', '02R60KZ',
        '02R707Z', '02R708Z', '02R70JZ', '02R70KZ', '02R907Z', '02R908Z', '02R90JZ', '02R90KZ',
        '02RD07Z', '02RD08Z', '02RD0JZ', '02RD0KZ', '02RF07Z', '02RF08Z', '02RF0JZ', '02RF0KZ',
        '02RG07Z', '02RG08Z', '02RG0JZ', '02RG0KZ', '02RH07Z', '02RH08Z', '02RH0JZ', '02RH0KZ',
        '02RJ07Z', '02RJ08Z', '02RJ0JZ', '02RJ0KZ', '02RK07Z', '02RK08Z', '02RK0JZ', '02RK0KZ',
        '02RL07Z', '02RL08Z', '02RL0JZ', '02RL0KZ', '02RM07Z', '02RM08Z', '02RM0JZ', '02RM0KZ',
        '02RN07Z', '02RN08Z', '02RN0JZ', '02RN0KZ', '02RP0JZ', '02RQ07Z', '02RQ0JZ', '02RR07Z',
        '02RR0JZ', '02SP0ZZ', '02SW0ZZ', '02T80ZZ', '02T90ZZ', '02TD0ZZ', '02TH0ZZ', '02U507Z',
        '02U508Z', '02U50JZ', '02U50KZ', '02U607Z', '02U608Z', '02U60JZ', '02U60KZ', '02U707Z',
        '02U708Z', '02U70JZ', '02U70KZ', '02U907Z', '02U908Z', '02U90JZ', '02U90KZ', '02UA07Z',
        '02UA08Z', '02UA0JZ', '02UA0KZ', '02UD07Z', '02UD08Z', '02UD0JZ', '02UD0KZ', '02UF07Z',
        '02UF08Z', '02UF0JZ', '02UF0KZ', '02UG07Z', '02UG08Z', '02UG0JZ', '02UG0KZ', '02UH07Z',
        '02UH08Z', '02UH0JZ', '02UH0KZ', '02UJ07Z', '02UJ08Z', '02UJ0JZ', '02UJ0KZ', '02UK07Z',
        '02UK08Z', '02UK0JZ', '02UK0KZ', '02UL07Z', '02UL08Z', '02UL0JZ', '02UL0KZ', '02UM07Z',
        '02UM08Z', '02UM0JZ', '02UM0KZ', '02UN07Z', '02UN08Z', '02UN0JZ', '02UN0KZ', '02VA0CZ',
        '02VA0ZZ', '02VR0ZT', '02WA02Z', '02WA03Z', '02WA07Z', '02WA08Z', '02WA0CZ', '02WA0DZ',
        '02WA0KZ', '02WA0QZ', '02WA0RZ', '02YA0Z0', '02YA0Z1', '02YA0Z2', '0312090', '0312091',
        '0312092', '0312093', '0312094', '0312095', '0312096', '0312097', '0312098', '0312099',
        '031209B', '031209C', '031209D', '031209F', '031209J', '031209K', '03120A0', '03120A1',
        '03120A2', '03120A3', '03120A4', '03120A5', '03120A6', '03120A7', '03120A8', '03120A9',
        '03120AB', '03120AC', '03120AD', '03120AF', '03120AJ', '03120AK', '03120J0', '03120J1',
        '03120J2', '03120J3', '03120J4', '03120J5', '03120J6', '03120J7', '03120J8', '03120J9',
        '03120JB', '03120JC', '03120JD', '03120JF', '03120JJ', '03120JK', '03120K0', '03120K1',
        '03120K2', '03120K3', '03120K4', '03120K5', '03120K6', '03120K7', '03120K8', '03120K9',
        '03120KB', '03120KC', '03120KD', '03120KF', '03120KJ', '03120KK', '03120Z0', '03120Z1',
        '03120Z2', '03120Z3', '03120Z4', '03120Z5', '03120Z6', '03120Z7', '03120Z8', '03120Z9',
        '03120ZB', '03120ZC', '03120ZD', '03120ZF', '03120ZJ', '03120ZK', '0313090', '0313091',
        '0313092', '0313093', '0313094', '0313095', '0313096', '0313097', '0313098', '0313099',
        '031309B', '031309C', '031309D', '031309F', '031309J', '031309K', '03130A0', '03130A1',
        '03130A2', '03130A3', '03130A4', '03130A5', '03130A6', '03130A7', '03130A8', '03130A9',
        '03130AB', '03130AC', '03130AD', '03130AF', '03130AJ', '03130AK', '03130J0', '03130J1',
        '03130J2', '03130J3', '03130J4', '03130J5', '03130J6', '03130J7', '03130J8', '03130J9',
        '03130JB', '03130JC', '03130JD', '03130JF', '03130JJ', '03130JK', '03130K0', '03130K1',
        '03130K2', '03130K3', '03130K4', '03130K5', '03130K6', '03130K7', '03130K8', '03130K9',
        '03130KB', '03130KC', '03130KD', '03130KF', '03130KJ', '03130KK', '03130Z0', '03130Z1',
        '03130Z2', '03130Z3', '03130Z4', '03130Z5', '03130Z6', '03130Z7', '03130Z8', '03130Z9',
        '03130ZB', '03130ZC', '03130ZD', '03130ZF', '03130ZJ', '03130ZK', '0314090', '0314091',
        '0314092', '0314093', '0314094', '0314095', '0314096', '0314097', '0314098', '0314099',
        '031409B', '031409C', '031409D', '031409F', '031409J', '031409K', '03140A0', '03140A1',
        '03140A2', '03140A3', '03140A4', '03140A5', '03140A6', '03140A7', '03140A8', '03140A9',
        '03140AB', '03140AC', '03140AD', '03140AF', '03140AJ', '03140AK', '03140J0', '03140J1',
        '03140J2', '03140J3', '03140J4', '03140J5', '03140J6', '03140J7', '03140J8', '03140J9',
        '03140JB', '03140JC', '03140JD', '03140JF', '03140JJ', '03140JK', '03140K0', '03140K1',
        '03140K2', '03140K3', '03140K4', '03140K5', '03140K6', '03140K7', '03140K8', '03140K9',
        '03140KB', '03140KC', '03140KD', '03140KF', '03140KJ', '03140KK', '03140Z0', '03140Z1',
        '03140Z2', '03140Z3', '03140Z4', '03140Z5', '03140Z6', '03140Z7', '03140Z8', '03140Z9',
        '03140ZB', '03140ZC', '03140ZD', '03140ZF', '03140ZJ', '03140ZK', '0315090', '0315091',
        '0315092', '0315093', '0315094', '0315095', '0315096', '0315097', '0315098', '0315099',
        '031509B', '031509C', '031509D', '031509F', '031509J', '031509K', '03150A0', '03150A1',
        '03150A2', '03150A3', '03150A4', '03150A5', '03150A6', '03150A7', '03150A8', '03150A9',
        '03150AB', '03150AC', '03150AD', '03150AF', '03150AJ', '03150AK', '03150J0', '03150J1',
        '03150J2', '03150J3', '03150J4', '03150J5', '03150J6', '03150J7', '03150J8', '03150J9',
        '03150JB', '03150JC', '03150JD', '03150JF', '03150JJ', '03150JK', '03150K0', '03150K1',
        '03150K2', '03150K3', '03150K4', '03150K5', '03150K6', '03150K7', '03150K8', '03150K9',
        '03150KB', '03150KC', '03150KD', '03150KF', '03150KJ', '03150KK', '03150Z0', '03150Z1',
        '03150Z2', '03150Z3', '03150Z4', '03150Z5', '03150Z6', '03150Z7', '03150Z8', '03150Z9',
        '03150ZB', '03150ZC', '03150ZD', '03150ZF', '03150ZJ', '03150ZK', '0316090', '0316091',
        '0316092', '0316093', '0316094', '0316095', '0316096', '0316097', '0316098', '0316099',
        '031609B', '031609C', '031609D', '031609F', '031609J', '031609K', '03160A0', '03160A1',
        '03160A2', '03160A3', '03160A4', '03160A5', '03160A6', '03160A7', '03160A8', '03160A9',
        '03160AB', '03160AC', '03160AD', '03160AF', '03160AJ', '03160AK', '03160J0', '03160J1',
        '03160J2', '03160J3', '03160J4', '03160J5', '03160J6', '03160J7', '03160J8', '03160J9',
        '03160JB', '03160JC', '03160JD', '03160JF', '03160JJ', '03160JK', '03160K0', '03160K1',
        '03160K2', '03160K3', '03160K4', '03160K5', '03160K6', '03160K7', '03160K8', '03160K9',
        '03160KB', '03160KC', '03160KD', '03160KF', '03160KJ', '03160KK', '03160Z0', '03160Z1',
        '03160Z2', '03160Z3', '03160Z4', '03160Z5', '03160Z6', '03160Z7', '03160Z8', '03160Z9',
        '03160ZB', '03160ZC', '03160ZD', '03160ZF', '03160ZJ', '03160ZK', '0317090', '0317093',
        '031709D', '031709F', '03170A0', '03170A3', '03170AD', '03170AF', '03170J0', '03170J3',
        '03170JD', '03170JF', '03170K0', '03170K3', '03170KD', '03170KF', '03170Z0', '03170Z3',
        '03170ZD', '03170ZF', '0318091', '0318094', '031809D', '031809F', '03180A1', '03180A4',
        '03180AD', '03180AF', '03180J1', '03180J4', '03180JD', '03180JF', '03180K1', '03180K4',
        '03180KD', '03180KF', '03180Z1', '03180Z4', '03180ZD', '03180ZF', '0319093', '031909F',
        '03190A3', '03190AF', '03190J3', '03190JF', '03190K3', '03190KF', '03190Z3', '03190ZF',
        '031A094', '031A09F', '031A0A4', '031A0AF', '031A0J4', '031A0JF', '031A0K4', '031A0KF',
        '031A0Z4', '031A0ZF', '031B093', '031B09F', '031B0A3', '031B0AF', '031B0J3', '031B0JF',
        '031B0K3', '031B0KF', '031B0Z3', '031B0ZF', '031C094', '031C09F', '031C0A4', '031C0AF',
        '031C0J4', '031C0JF', '031C0K4', '031C0KF', '031C0Z4', '031C0ZF', '031G09G', '031G0AG',
        '031G0JG', '031G0KG', '031G0ZG', '031H09G', '031H0AG', '031H0JG', '031H0KG', '031H0ZG',
        '031J09G', '031J0AG', '031J0JG', '031J0KG', '031J0ZG', '0410090', '0410092', '0410096',
        '0410097', '0410098', '0410099', '041009B', '041009C', '041009D', '041009F', '041009G',
        '041009H', '041009J', '041009K', '041009Q', '041009R', '04100A0', '04100A1', '04100A2',
        '04100A6', '04100A7', '04100A8', '04100A9', '04100AB', '04100AC', '04100AD', '04100AF',
        '04100AG', '04100AH', '04100AJ', '04100AK', '04100AQ', '04100AR', '04100J0', '04100J1',
        '04100J2', '04100J6', '04100J7', '04100J8', '04100J9', '04100JB', '04100JC', '04100JD',
        '04100JF', '04100JG', '04100JH', '04100JJ', '04100JK', '04100JQ', '04100JR', '04100K0',
        '04100K1', '04100K2', '04100K6', '04100K7', '04100K8', '04100K9', '04100KB', '04100KC',
        '04100KD', '04100KF', '04100KG', '04100KH', '04100KJ', '04100KK', '04100KQ', '04100KR',
        '04100Z0', '04100Z1', '04100Z2', '04100Z6', '04100Z7', '04100Z8', '04100Z9', '04100ZB',
        '04100ZC', '04100ZD', '04100ZF', '04100ZG', '04100ZH', '04100ZJ', '04100ZK', '04100ZQ',
        '04100ZR', '0414093', '0414094', '0414095', '04140A3', '04140A4', '04140A5', '04140J3',
        '04140J4', '04140J5', '04140K3', '04140K4', '04140K5', '04140Z3', '04140Z4', '04140Z5',
        '041C090', '041C091', '041C092', '041C093', '041C094', '041C095', '041C096', '041C097',
        '041C098', '041C099', '041C09B', '041C09C', '041C09D', '041C09F', '041C09G', '041C09H',
        '041C09J', '041C09K', '041C09Q', '041C09R', '041C0A0', '041C0A1', '041C0A2', '041C0A3',
        '041C0A4', '041C0A5', '041C0A6', '041C0A7', '041C0A8', '041C0A9', '041C0AB', '041C0AC',
        '041C0AD', '041C0AF', '041C0AG', '041C0AH', '041C0AJ', '041C0AK', '041C0AQ', '041C0AR',
        '041C0J0', '041C0J1', '041C0J2', '041C0J3', '041C0J4', '041C0J5', '041C0J6', '041C0J7',
        '041C0J8', '041C0J9', '041C0JB', '041C0JC', '041C0JD', '041C0JF', '041C0JG', '041C0JH',
        '041C0JJ', '041C0JK', '041C0JQ', '041C0JR', '041C0K0', '041C0K1', '041C0K2', '041C0K3',
        '041C0K4', '041C0K5', '041C0K6', '041C0K7', '041C0K8', '041C0K9', '041C0KB', '041C0KC',
        '041C0KD', '041C0KF', '041C0KG', '041C0KH', '041C0KJ', '041C0KK', '041C0KQ', '041C0KR',
        '041C0Z0', '041C0Z1', '041C0Z2', '041C0Z3', '041C0Z4', '041C0Z5', '041C0Z6', '041C0Z7',
        '041C0Z8', '041C0Z9', '041C0ZB', '041C0ZC', '041C0ZD', '041C0ZF', '041C0ZG', '041C0ZH',
        '041C0ZJ', '041C0ZK', '041C0ZQ', '041C0ZR', '041D090', '041D091', '041D092', '041D093',
        '041D094', '041D095', '041D096', '041D097', '041D098', '041D099', '041D09B', '041D09C',
        '041D09D', '041D09F', '041D09G', '041D09H', '041D09J', '041D09K', '041D09Q', '041D09R',
        '041D0A0', '041D0A1', '041D0A2', '041D0A3', '041D0A4', '041D0A5', '041D0A6', '041D0A7',
        '041D0A8', '041D0A9', '041D0AB', '041D0AC', '041D0AD', '041D0AF', '041D0AG', '041D0AH',
        '041D0AJ', '041D0AK', '041D0AQ', '041D0AR', '041D0J0', '041D0J1', '041D0J2', '041D0J3',
        '041D0J4', '041D0J5', '041D0J6', '041D0J7', '041D0J8', '041D0J9', '041D0JB', '041D0JC',
        '041D0JD', '041D0JF', '041D0JG', '041D0JH', '041D0JJ', '041D0JK', '041D0JQ', '041D0JR',
        '041D0K0', '041D0K1', '041D0K2', '041D0K3', '041D0K4', '041D0K5', '041D0K6', '041D0K7',
        '041D0K8', '041D0K9', '041D0KB', '041D0KC', '041D0KD', '041D0KF', '041D0KG', '041D0KH',
        '041D0KJ', '041D0KK', '041D0KQ', '041D0KR', '041D0Z0', '041D0Z1', '041D0Z2', '041D0Z3',
        '041D0Z4', '041D0Z5', '041D0Z6', '041D0Z7', '041D0Z8', '041D0Z9', '041D0ZB', '041D0ZC',
        '041D0ZD', '041D0ZF', '041D0ZG', '041D0ZH', '041D0ZJ', '041D0ZK', '041D0ZQ', '041D0ZR',
        '041E099', '041E09B', '041E09C', '041E09D', '041E09F', '041E09G', '041E09H', '041E09J',
        '041E09K', '041E09P', '041E09Q', '041E0A9', '041E0AB', '041E0AC', '041E0AD', '041E0AF',
        '041E0AG', '041E0AH', '041E0AJ', '041E0AK', '041E0AP', '041E0AQ', '041E0J9', '041E0JB',
        '041E0JC', '041E0JD', '041E0JF', '041E0JG', '041E0JH', '041E0JJ', '041E0JK', '041E0JP',
        '041E0JQ', '041E0K9', '041E0KB', '041E0KC', '041E0KD', '041E0KF', '041E0KG', '041E0KH',
        '041E0KJ', '041E0KK', '041E0KP', '041E0KQ', '041E0Z9', '041E0ZB', '041E0ZC', '041E0ZD',
        '041E0ZF', '041E0ZG', '041E0ZH', '041E0ZJ', '041E0ZK', '041E0ZP', '041E0ZQ', '041F099',
        '041F09B', '041F09C', '041F09D', '041F09F', '041F09G', '041F09H', '041F09J', '041F09K',
        '041F09P', '041F09Q', '041F0A9', '041F0AB', '041F0AC', '041F0AD', '041F0AF', '041F0AG',
        '041F0AH', '041F0AJ', '041F0AK', '041F0AP', '041F0AQ', '041F0J9', '041F0JB', '041F0JC',
        '041F0JD', '041F0JF', '041F0JG', '041F0JH', '041F0JJ', '041F0JK', '041F0JP', '041F0JQ',
        '041F0K9', '041F0KB', '041F0KC', '041F0KD', '041F0KF', '041F0KG', '041F0KH', '041F0KJ',
        '041F0KK', '041F0KP', '041F0KQ', '041F0Z9', '041F0ZB', '041F0ZC', '041F0ZD', '041F0ZF',
        '041F0ZG', '041F0ZH', '041F0ZJ', '041F0ZK', '041F0ZP', '041F0ZQ', '041H099', '041H09B',
        '041H09C', '041H09D', '041H09F', '041H09G', '041H09H', '041H09J', '041H09K', '041H09P',
        '041H09Q', '041H0A9', '041H0AB', '041H0AC', '041H0AD', '041H0AF', '041H0AG', '041H0AH',
        '041H0AJ', '041H0AK', '041H0AP', '041H0AQ', '041H0J9', '041H0JB', '041H0JC', '041H0JD',
        '041H0JF', '041H0JG', '041H0JH', '041H0JJ', '041H0JK', '041H0JP', '041H0JQ', '041H0K9',
        '041H0KB', '041H0KC', '041H0KD', '041H0KF', '041H0KG', '041H0KH', '041H0KJ', '041H0KK',
        '041H0KP', '041H0KQ', '041H0Z9', '041H0ZB', '041H0ZC', '041H0ZD', '041H0ZF', '041H0ZG',
        '041H0ZH', '041H0ZJ', '041H0ZK', '041H0ZP', '041H0ZQ', '041J099', '041J09B', '041J09C',
        '041J09D', '041J09F', '041J09G', '041J09H', '041J09J', '041J09K', '041J09P', '041J09Q',
        '041J0A9', '041J0AB', '041J0AC', '041J0AD', '041J0AF', '041J0AG', '041J0AH', '041J0AJ',
        '041J0AK', '041J0AP', '041J0AQ', '041J0J9', '041J0JB', '041J0JC', '041J0JD', '041J0JF',
        '041J0JG', '041J0JH', '041J0JJ', '041J0JK', '041J0JP', '041J0JQ', '041J0K9', '041J0KB',
        '041J0KC', '041J0KD', '041J0KF', '041J0KG', '041J0KH', '041J0KJ', '041J0KK', '041J0KP',
        '041J0KQ', '041J0Z9', '041J0ZB', '041J0ZC', '041J0ZD', '041J0ZF', '041J0ZG', '041J0ZH',
        '041J0ZJ', '041J0ZK', '041J0ZP', '041J0ZQ', '041K09H', '041K09J', '041K09K', '041K09L',
        '041K09M', '041K09N', '041K09P', '041K09Q', '041K09S', '041K0AH', '041K0AJ', '041K0AK',
        '041K0AL', '041K0AM', '041K0AN', '041K0AP', '041K0AQ', '041K0AS', '041K0JH', '041K0JJ',
        '041K0JK', '041K0JL', '041K0JM', '041K0JN', '041K0JP', '041K0JQ', '041K0JS', '041K0KH',
        '041K0KJ', '041K0KK', '041K0KL', '041K0KM', '041K0KN', '041K0KP', '041K0KQ', '041K0KS',
        '041K0ZH', '041K0ZJ', '041K0ZK', '041K0ZL', '041K0ZM', '041K0ZN', '041K0ZP', '041K0ZQ',
        '041K0ZS', '041L09H', '041L09J', '041L09K', '041L09L', '041L09M', '041L09N', '041L09P',
        '041L09Q', '041L09S', '041L0AH', '041L0AJ', '041L0AK', '041L0AL', '041L0AM', '041L0AN',
        '041L0AP', '041L0AQ', '041L0AS', '041L0JH', '041L0JJ', '041L0JK', '041L0JL', '041L0JM',
        '041L0JN', '041L0JP', '041L0JQ', '041L0JS', '041L0KH', '041L0KJ', '041L0KK', '041L0KL',
        '041L0KM', '041L0KN', '041L0KP', '041L0KQ', '041L0KS', '041L0ZH', '041L0ZJ', '041L0ZK',
        '041L0ZL', '041L0ZM', '041L0ZN', '041L0ZP', '041L0ZQ', '041L0ZS', '041M09L', '041M09M',
        '041M09P', '041M09Q', '041M09S', '041M0AL', '041M0AM', '041M0AP', '041M0AQ', '041M0AS',
        '041M0JL', '041M0JM', '041M0JP', '041M0JQ', '041M0JS', '041M0KL', '041M0KM', '041M0KP',
        '041M0KQ', '041M0KS', '041M0ZL', '041M0ZM', '041M0ZP', '041M0ZQ', '041M0ZS', '041N09L',
        '041N09M', '041N09P', '041N09Q', '041N09S', '041N0AL', '041N0AM', '041N0AP', '041N0AQ',
        '041N0AS', '041N0JL', '041N0JM', '041N0JP', '041N0JQ', '041N0JS', '041N0KL', '041N0KM',
        '041N0KP', '041N0KQ', '041N0KS', '041N0ZL', '041N0ZM', '041N0ZP', '041N0ZQ', '041N0ZS',
        '04500ZZ', '04B00ZZ', '04B10ZZ', '04B20ZZ', '04B30ZZ', '04B40ZZ', '04B50ZZ', '04B60ZZ',
        '04B70ZZ', '04B80ZZ', '04B90ZZ', '04BA0ZZ', '04BB0ZZ', '04BC0ZZ', '04BD0ZZ', '04BE0ZZ',
        '04BF0ZZ', '04BH0ZZ', '04BJ0ZZ', '04C00ZZ', '04C10ZZ', '04C20ZZ', '04C30ZZ', '04C40ZZ',
        '04C50ZZ', '04C60ZZ', '04C70ZZ', '04C80ZZ', '04C90ZZ', '04CA0ZZ', '04CB0ZZ', '04CC0ZZ',
        '04CD0ZZ', '04CE0ZZ', '04CF0ZZ', '04CH0ZZ', '04CJ0ZZ', '04CK0ZZ', '04CL0ZZ', '04CM0ZZ',
        '04CN0ZZ', '04CP0ZZ', '04CQ0ZZ', '04CR0ZZ', '04CS0ZZ', '04CT0ZZ', '04CU0ZZ', '04CV0ZZ',
        '04CW0ZZ', '04CY0ZZ', '04R007Z', '04R00JZ', '04R00KZ', '04RK07Z', '04RK0JZ', '04RK0KZ',
        '04RL07Z', '04RL0JZ', '04RL0KZ', '04RM07Z', '04RM0JZ', '04RM0KZ', '04RN07Z', '04RN0JZ',
        '04RN0KZ', '04RP07Z', '04RP0JZ', '04RP0KZ', '04RQ07Z', '04RQ0JZ', '04RQ0KZ', '04RR07Z',
        '04RR0JZ', '04RR0KZ', '04RS07Z', '04RS0JZ', '04RS0KZ', '04RT07Z', '04RT0JZ', '04RT0KZ',
        '04RU07Z', '04RU0JZ', '04RU0KZ', '04RV07Z', '04RV0JZ', '04RV0KZ', '04RW07Z', '04RW0JZ',
        '04RW0KZ', '04RY07Z', '04RY0JZ', '04RY0KZ', '051707Y', '051709Y', '05170AY', '05170JY',
        '05170KY', '05170ZY', '051807Y', '051809Y', '05180AY', '05180JY', '05180KY', '05180ZY',
        '051907Y', '051909Y', '05190AY', '05190JY', '05190KY', '05190ZY', '051A07Y', '051A09Y',
        '051A0AY', '051A0JY', '051A0KY', '051A0ZY', '051B07Y', '051B09Y', '051B0AY', '051B0JY',
        '051B0KY', '051B0ZY', '051C07Y', '051C09Y', '051C0AY', '051C0JY', '051C0KY', '051C0ZY',
        '051D07Y', '051D09Y', '051D0AY', '051D0JY', '051D0KY', '051D0ZY', '051F07Y', '051F09Y',
        '051F0AY', '051F0JY', '051F0KY', '051F0ZY', '051G07Y', '051G09Y', '051G0AY', '051G0JY',
        '051G0KY', '051G0ZY', '051H07Y', '051H09Y', '051H0AY', '051H0JY', '051H0KY', '051H0ZY',
        '051L07Y', '051L09Y', '051L0AY', '051L0JY', '051L0KY', '051L0ZY', '051M07Y', '051M09Y',
        '051M0AY', '051M0JY', '051M0KY', '051M0ZY', '051N07Y', '051N09Y', '051N0AY', '051N0JY',
        '051N0KY', '051N0ZY', '051P07Y', '051P09Y', '051P0AY', '051P0JY', '051P0KY', '051P0ZY',
        '051Q07Y', '051Q09Y', '051Q0AY', '051Q0JY', '051Q0KY', '051Q0ZY', '051R07Y', '051R09Y',
        '051R0AY', '051R0JY', '051R0KY', '051R0ZY', '051S07Y', '051S09Y', '051S0AY', '051S0JY',
        '051S0KY', '051S0ZY', '051T07Y', '051T09Y', '051T0AY', '051T0JY', '051T0KY', '051T0ZY',
        '051V07Y', '051V09Y', '051V0AY', '051V0JY', '051V0KY', '051V0ZY', '061307Y', '061309Y',
        '06130AY', '06130JY', '06130KY', '06130ZY', '061C07Y', '061C09Y', '061C0AY', '061C0JY',
        '061C0KY', '061C0ZY', '061D07Y', '061D09Y', '061D0AY', '061D0JY', '061D0KY', '061D0ZY',
        '061F07Y', '061F09Y', '061F0AY', '061F0JY', '061F0KY', '061F0ZY', '061G07Y', '061G09Y',
        '061G0AY', '061G0JY', '061G0KY', '061G0ZY', '061H07Y', '061H09Y', '061H0AY', '061H0JY',
        '061H0KY', '061H0ZY', '061M07Y', '061M09Y', '061M0AY', '061M0JY', '061M0KY', '061M0ZY',
        '061N07Y', '061N09Y', '061N0AY', '061N0JY', '061N0KY', '061N0ZY', '061P07Y', '061P09Y',
        '061P0AY', '061P0JY', '061P0KY', '061P0ZY', '061Q07Y', '061Q09Y', '061Q0AY', '061Q0JY',
        '061Q0KY', '061Q0ZY', '061R07Y', '061R09Y', '061R0AY', '061R0JY', '061R0KY', '061R0ZY',
        '061S07Y', '061S09Y', '061S0AY', '061S0JY', '061S0KY', '061S0ZY', '061T07Y', '061T09Y',
        '061T0AY', '061T0JY', '061T0KY', '061T0ZY', '061V07Y', '061V09Y', '061V0AY', '061V0JY',
        '061V0KY', '061V0ZY', '06B00ZZ', '06B10ZZ', '06B20ZZ', '06B40ZZ', '06B50ZZ', '06B60ZZ',
        '06B70ZZ', '06B80ZZ', '06B90ZZ', '06BB0ZZ', '06BC0ZZ', '06BD0ZZ', '06BF0ZZ', '06BG0ZZ',
        '06BH0ZZ', '06BJ0ZZ', '06L20ZZ', '06RM07Z', '06RM0JZ', '06RM0KZ', '06RN07Z', '06RN0JZ',
        '06RN0KZ', '06RP07Z', '06RP0JZ', '06RP0KZ', '06RQ07Z', '06RQ0JZ', '06RQ0KZ', '06RR07Z',
        '06RR0JZ', '06RR0KZ', '06RS07Z', '06RS0JZ', '06RS0KZ', '06RT07Z', '06RT0JZ', '06RT0KZ',
        '06RV07Z', '06RV0JZ', '06RV0KZ', '06RY07Z', '06RY0JZ', '06RY0KZ', '07JP0ZZ', '07TP0ZZ',
        '0B5R0ZZ', '0B5S0ZZ', '0B9R00Z', '0B9R0ZZ', '0B9S00Z', '0B9S0ZZ', '0BBR0ZZ', '0BBS0ZZ',
        '0BCR0ZZ', '0BCS0ZZ', '0BDN0ZX', '0BDN0ZZ', '0BDP0ZX', '0BDP0ZZ', '0BHR02Z', '0BHS02Z',
        '0BMR0ZZ', '0BMS0ZZ', '0BNR0ZZ', '0BNS0ZZ', '0BPT00Z', '0BPT02Z', '0BPT07Z', '0BPT0JZ',
        '0BPT0KZ', '0BPT0MZ', '0BPT70Z', '0BPT72Z', '0BPT77Z', '0BPT7JZ', '0BPT7KZ', '0BPT7MZ',
        '0BQR0ZZ', '0BQS0ZZ', '0BSR0ZZ', '0BSS0ZZ', '0BTC0ZZ', '0BTD0ZZ', '0BTF0ZZ', '0BTG0ZZ',
        '0BTH0ZZ', '0BTJ0ZZ', '0BTK0ZZ', '0BTL0ZZ', '0BTM0ZZ', '0BUR07Z', '0BUR0JZ', '0BUR0KZ',
        '0BUS07Z', '0BUS0JZ', '0BUS0KZ', '0BWT00Z', '0BWT02Z', '0BWT07Z', '0BWT0JZ', '0BWT0KZ',
        '0BWT0MZ', '0BWT70Z', '0BWT72Z', '0BWT77Z', '0BWT7JZ', '0BWT7KZ', '0BWT7MZ', '0D11074',
        '0D11076', '0D11079', '0D1107A', '0D1107B', '0D110J4', '0D110J6', '0D110J9', '0D110JA',
        '0D110JB', '0D110K4', '0D110K6', '0D110K9', '0D110KA', '0D110KB', '0D110Z4', '0D110Z6',
        '0D110Z9', '0D110ZA', '0D110ZB', '0D12074', '0D12076', '0D12079', '0D1207A', '0D1207B',
        '0D120J4', '0D120J6', '0D120J9', '0D120JA', '0D120JB', '0D120K4', '0D120K6', '0D120K9',
        '0D120KA', '0D120KB', '0D120Z4', '0D120Z6', '0D120Z9', '0D120ZA', '0D120ZB', '0D13074',
        '0D13076', '0D13079', '0D1307A', '0D1307B', '0D130J4', '0D130J6', '0D130J9', '0D130JA',
        '0D130JB', '0D130K4', '0D130K6', '0D130K9', '0D130KA', '0D130KB', '0D130Z4', '0D130Z6',
        '0D130Z9', '0D130ZA', '0D130ZB', '0D15074', '0D15076', '0D15079', '0D1507A', '0D1507B',
        '0D150J4', '0D150J6', '0D150J9', '0D150JA', '0D150JB', '0D150K4', '0D150K6', '0D150K9',
        '0D150KA', '0D150KB', '0D150Z4', '0D150Z6', '0D150Z9', '0D150ZA', '0D150ZB', '0D16079',
        '0D1607A', '0D1607B', '0D1607L', '0D160J9', '0D160JA', '0D160JB', '0D160JL', '0D160K9',
        '0D160KA', '0D160KB', '0D160KL', '0D160Z9', '0D160ZA', '0D160ZB', '0D160ZL', '0D19074',
        '0D19079', '0D1907A', '0D1907B', '0D1907L', '0D190J4', '0D190J9', '0D190JA', '0D190JB',
        '0D190JL', '0D190K4', '0D190K9', '0D190KA', '0D190KB', '0D190KL', '0D190Z4', '0D190Z9',
        '0D190ZA', '0D190ZB', '0D190ZL', '0D1A074', '0D1A07A', '0D1A07B', '0D1A07H', '0D1A07K',
        '0D1A07L', '0D1A07M', '0D1A07N', '0D1A07P', '0D1A07Q', '0D1A0J4', '0D1A0JA', '0D1A0JB',
        '0D1A0JH', '0D1A0JK', '0D1A0JL', '0D1A0JM', '0D1A0JN', '0D1A0JP', '0D1A0JQ', '0D1A0K4',
        '0D1A0KA', '0D1A0KB', '0D1A0KH', '0D1A0KK', '0D1A0KL', '0D1A0KM', '0D1A0KN', '0D1A0KP',
        '0D1A0KQ', '0D1A0Z4', '0D1A0ZA', '0D1A0ZB', '0D1A0ZH', '0D1A0ZK', '0D1A0ZL', '0D1A0ZM',
        '0D1A0ZN', '0D1A0ZP', '0D1A0ZQ', '0D1B07B', '0D1B07H', '0D1B07K', '0D1B07L', '0D1B07M',
        '0D1B07N', '0D1B07P', '0D1B07Q', '0D1B0JB', '0D1B0JH', '0D1B0JK', '0D1B0JL', '0D1B0JM',
        '0D1B0JN', '0D1B0JP', '0D1B0JQ', '0D1B0KB', '0D1B0KH', '0D1B0KK', '0D1B0KL', '0D1B0KM',
        '0D1B0KN', '0D1B0KP', '0D1B0KQ', '0D1B0Z4', '0D1B0ZB', '0D1B0ZH', '0D1B0ZK', '0D1B0ZL',
        '0D1B0ZM', '0D1B0ZN', '0D1B0ZP', '0D1B0ZQ', '0D1H07H', '0D1H07K', '0D1H07L', '0D1H07M',
        '0D1H07N', '0D1H07P', '0D1H0JH', '0D1H0JK', '0D1H0JL', '0D1H0JM', '0D1H0JN', '0D1H0JP',
        '0D1H0KH', '0D1H0KK', '0D1H0KL', '0D1H0KM', '0D1H0KN', '0D1H0KP', '0D1H0ZH', '0D1H0ZK',
        '0D1H0ZL', '0D1H0ZM', '0D1H0ZN', '0D1H0ZP', '0D1K07K', '0D1K07L', '0D1K07M', '0D1K07N',
        '0D1K07P', '0D1K0JK', '0D1K0JL', '0D1K0JM', '0D1K0JN', '0D1K0JP', '0D1K0KK', '0D1K0KL',
        '0D1K0KM', '0D1K0KN', '0D1K0KP', '0D1K0ZK', '0D1K0ZL', '0D1K0ZM', '0D1K0ZN', '0D1K0ZP',
        '0D1L07L', '0D1L07M', '0D1L07N', '0D1L07P', '0D1L0JL', '0D1L0JM', '0D1L0JN', '0D1L0JP',
        '0D1L0KL', '0D1L0KM', '0D1L0KN', '0D1L0KP', '0D1L0ZL', '0D1L0ZM', '0D1L0ZN', '0D1L0ZP',
        '0D1M07M', '0D1M07N', '0D1M07P', '0D1M0JM', '0D1M0JN', '0D1M0JP', '0D1M0KM', '0D1M0KN',
        '0D1M0KP', '0D1M0ZM', '0D1M0ZN', '0D1M0ZP', '0D1N07N', '0D1N07P', '0D1N0JN', '0D1N0JP',
        '0D1N0KN', '0D1N0KP', '0D1N0Z4', '0D1N0ZN', '0D1N0ZP', '0D590ZZ', '0D597ZZ', '0D5E0ZZ',
        '0D5E7ZZ', '0D5F0ZZ', '0D5F7ZZ', '0D5G0ZZ', '0D5G7ZZ', '0D5H0ZZ', '0D5H7ZZ', '0D5K0ZZ',
        '0D5K7ZZ', '0D5L0ZZ', '0D5L7ZZ', '0D5M0ZZ', '0D5M7ZZ', '0D5N0ZZ', '0D5N7ZZ', '0D710DZ',
        '0D710ZZ', '0D720DZ', '0D720ZZ', '0D730DZ', '0D730ZZ', '0D740DZ', '0D740ZZ', '0D750DZ',
        '0D750ZZ', '0D760DZ', '0D760ZZ', '0D767DZ', '0D767ZZ', '0D770DZ', '0D770ZZ', '0D777DZ',
        '0D777ZZ', '0D780ZZ', '0D790ZZ', '0D7A0ZZ', '0D7B0ZZ', '0D7C0ZZ', '0D7E0ZZ', '0D7F0ZZ',
        '0D7G0ZZ', '0D7H0ZZ', '0D7K0ZZ', '0D7L0ZZ', '0D7M0ZZ', '0D7N0ZZ', '0D7P0DZ', '0D7P0ZZ',
        '0D840ZZ', '0D847ZZ', '0D9100Z', '0D910ZZ', '0D9170Z', '0D917ZZ', '0D9200Z', '0D920ZZ',
        '0D9270Z', '0D927ZZ', '0D9300Z', '0D930ZZ', '0D9370Z', '0D937ZZ', '0D9400Z', '0D940ZZ',
        '0D9470Z', '0D947ZZ', '0D9500Z', '0D950ZZ', '0D9570Z', '0D957ZZ', '0D9800Z', '0D980ZZ',
        '0D987ZZ', '0D9900Z', '0D990ZZ', '0D997ZZ', '0D9A00Z', '0D9A0ZZ', '0D9A7ZZ', '0D9B00Z',
        '0D9B0ZZ', '0D9B7ZZ', '0D9C00Z', '0D9C0ZZ', '0D9C70Z', '0D9C7ZZ', '0D9E00Z', '0D9E0ZZ',
        '0D9E7ZZ', '0D9F00Z', '0D9F0ZZ', '0D9F7ZZ', '0D9G00Z', '0D9G0ZZ', '0D9G7ZZ', '0D9H00Z',
        '0D9H0ZZ', '0D9H7ZZ', '0D9K00Z', '0D9K0ZZ', '0D9K7ZZ', '0D9L00Z', '0D9L0ZZ', '0D9L7ZZ',
        '0D9M00Z', '0D9M0ZZ', '0D9M7ZZ', '0D9N00Z', '0D9N0ZZ', '0D9N7ZZ', '0D9P00Z', '0D9P0ZZ',
        '0D9P7ZZ', '0D9S00Z', '0D9S0ZZ', '0D9T00Z', '0D9T0ZZ', '0D9V00Z', '0D9V0ZZ', '0D9W00Z',
        '0D9W0ZZ', '0DB10ZZ', '0DB17ZZ', '0DB20ZZ', '0DB27ZZ', '0DB30ZZ', '0DB37ZZ', '0DB40ZZ',
        '0DB47ZZ', '0DB50ZZ', '0DB57ZZ', '0DB60Z3', '0DB60ZZ', '0DB67Z3', '0DB67ZZ', '0DB80ZZ',
        '0DB87ZZ', '0DB90ZZ', '0DB97ZZ', '0DBA0ZZ', '0DBA7ZZ', '0DBB0ZZ', '0DBB7ZZ', '0DBC0ZZ',
        '0DBC7ZZ', '0DBE0ZZ', '0DBE4ZZ', '0DBE7ZZ', '0DBF0ZZ', '0DBF4ZZ', '0DBF7ZZ', '0DBG0ZZ',
        '0DBG4ZZ', '0DBG7ZZ', '0DBH0ZZ', '0DBH4ZZ', '0DBH7ZZ', '0DBK0ZZ', '0DBK4ZZ', '0DBK7ZZ',
        '0DBL0ZZ', '0DBL4ZZ', '0DBL7ZZ', '0DBM0ZZ', '0DBM4ZZ', '0DBM7ZZ', '0DBN0ZZ', '0DBN4ZZ',
        '0DBN7ZZ', '0DBP0ZZ', '0DBP7ZZ', '0DC10ZZ', '0DC20ZZ', '0DC30ZZ', '0DC40ZZ', '0DC50ZZ',
        '0DC80ZZ', '0DC90ZZ', '0DCA0ZZ', '0DCB0ZZ', '0DCC0ZZ', '0DCE0ZZ', '0DCF0ZZ', '0DCG0ZZ',
        '0DCH0ZZ', '0DCK0ZZ', '0DCL0ZZ', '0DCM0ZZ', '0DCN0ZZ', '0DCP0ZZ', '0DCS0ZZ', '0DCT0ZZ',
        '0DCV0ZZ', '0DCW0ZZ', '0DF50ZZ', '0DF57ZZ', '0DF60ZZ', '0DF67ZZ', '0DF80ZZ', '0DF87ZZ',
        '0DF90ZZ', '0DF97ZZ', '0DFA0ZZ', '0DFA7ZZ', '0DFB0ZZ', '0DFB7ZZ', '0DFE0ZZ', '0DFE7ZZ',
        '0DFF0ZZ', '0DFF7ZZ', '0DFG0ZZ', '0DFG7ZZ', '0DFH0ZZ', '0DFH7ZZ', '0DFK0ZZ', '0DFK7ZZ',
        '0DFL0ZZ', '0DFL7ZZ', '0DFM0ZZ', '0DFM7ZZ', '0DFN0ZZ', '0DFN7ZZ', '0DH502Z', '0DH503Z',
        '0DH572Z', '0DH573Z', '0DH60DZ', '0DH67DZ', '0DH802Z', '0DH803Z', '0DH872Z', '0DH873Z',
        '0DH902Z', '0DH903Z', '0DH972Z', '0DH973Z', '0DHA02Z', '0DHA03Z', '0DHA72Z', '0DHA73Z',
        '0DHB02Z', '0DHB03Z', '0DHB72Z', '0DHB73Z', '0DJ00ZZ', '0DJ60ZZ', '0DJD0ZZ', '0DJU0ZZ',
        '0DJV0ZZ', '0DJW0ZZ', '0DL60CZ', '0DL60DZ', '0DL60ZZ', '0DL67DZ', '0DL67ZZ', '0DL70CZ',
        '0DL70DZ', '0DL70ZZ', '0DL77DZ', '0DL77ZZ', '0DM50ZZ', '0DM60ZZ', '0DM80ZZ', '0DM90ZZ',
        '0DMA0ZZ', '0DMB0ZZ', '0DME0ZZ', '0DMF0ZZ', '0DMG0ZZ', '0DMH0ZZ', '0DMK0ZZ', '0DML0ZZ',
        '0DMM0ZZ', '0DMN0ZZ', '0DMP0ZZ', '0DN10ZZ', '0DN17ZZ', '0DN20ZZ', '0DN27ZZ', '0DN30ZZ',
        '0DN37ZZ', '0DN40ZZ', '0DN47ZZ', '0DN50ZZ', '0DN57ZZ', '0DN60ZZ', '0DN67ZZ', '0DN70ZZ',
        '0DN77ZZ', '0DN80ZZ', '0DN90ZZ', '0DNA0ZZ', '0DNB0ZZ', '0DNC0ZZ', '0DNC7ZZ', '0DNE0ZZ',
        '0DNF0ZZ', '0DNG0ZZ', '0DNH0ZZ', '0DNJ0ZZ', '0DNK0ZZ', '0DNL0ZZ', '0DNM0ZZ', '0DNN0ZZ',
        '0DNS0ZZ', '0DNT0ZZ', '0DNV0ZZ', '0DNW0ZZ', '0DP000Z', '0DP002Z', '0DP003Z', '0DP007Z',
        '0DP00CZ', '0DP00DZ', '0DP00JZ', '0DP00KZ', '0DP00UZ', '0DP070Z', '0DP072Z', '0DP073Z',
        '0DP077Z', '0DP07CZ', '0DP07DZ', '0DP07JZ', '0DP07KZ', '0DP07UZ', '0DP501Z', '0DP502Z',
        '0DP503Z', '0DP50UZ', '0DP57DZ', '0DPD00Z', '0DPD02Z', '0DPD03Z', '0DPD07Z', '0DPD0CZ',
        '0DPD0DZ', '0DPD0JZ', '0DPD0KZ', '0DPD0UZ', '0DPD70Z', '0DPD72Z', '0DPD73Z', '0DPD77Z',
        '0DPD7CZ', '0DPD7DZ', '0DPD7JZ', '0DPD7KZ', '0DPD7UZ', '0DPP01Z', '0DPU00Z', '0DPU01Z',
        '0DPU07Z', '0DPU0JZ', '0DPU0KZ', '0DPV00Z', '0DPV01Z', '0DPV07Z', '0DPV0JZ', '0DPV0KZ',
        '0DPW00Z', '0DPW01Z', '0DPW07Z', '0DPW0JZ', '0DPW0KZ', '0DQ10ZZ', '0DQ17ZZ', '0DQ20ZZ',
        '0DQ27ZZ', '0DQ30ZZ', '0DQ37ZZ', '0DQ40ZZ', '0DQ47ZZ', '0DQ50ZZ', '0DQ57ZZ', '0DQ60ZZ',
        '0DQ67ZZ', '0DQ70ZZ', '0DQ77ZZ', '0DQ80ZZ', '0DQ87ZZ', '0DQ90ZZ', '0DQ97ZZ', '0DQA0ZZ',
        '0DQA7ZZ', '0DQB0ZZ', '0DQB7ZZ', '0DQC0ZZ', '0DQC7ZZ', '0DQE0ZZ', '0DQE7ZZ', '0DQF0ZZ',
        '0DQF7ZZ', '0DQG0ZZ', '0DQG7ZZ', '0DQH0ZZ', '0DQH7ZZ', '0DQK0ZZ', '0DQK7ZZ', '0DQL0ZZ',
        '0DQL7ZZ', '0DQM0ZZ', '0DQM7ZZ', '0DQN0ZZ', '0DQN7ZZ', '0DQP0ZZ', '0DQP7ZZ', '0DQQ0ZZ',
        '0DQQ7ZZ', '0DQS0ZZ', '0DQT0ZZ', '0DQV0ZZ', '0DQW0ZZ', '0DR507Z', '0DR50JZ', '0DR50KZ',
        '0DR577Z', '0DR57JZ', '0DR57KZ', '0DRS07Z', '0DRS0JZ', '0DRS0KZ', '0DRT07Z', '0DRT0JZ',
        '0DRT0KZ', '0DRV07Z', '0DRV0JZ', '0DRV0KZ', '0DRW07Z', '0DRW0JZ', '0DRW0KZ', '0DS50ZZ',
        '0DS57ZZ', '0DS5XZZ', '0DS60ZZ', '0DS67ZZ', '0DS6XZZ', '0DS90ZZ', '0DS97ZZ', '0DSA0ZZ',
        '0DSA7ZZ', '0DSB0ZZ', '0DSB7ZZ', '0DSH0ZZ', '0DSH7ZZ', '0DSK0ZZ', '0DSK7ZZ', '0DSL0ZZ',
        '0DSL7ZZ', '0DSM0ZZ', '0DSM7ZZ', '0DSN0ZZ', '0DSN7ZZ', '0DSP0ZZ', '0DSP7ZZ', '0DT10ZZ',
        '0DT17ZZ', '0DT20ZZ', '0DT27ZZ', '0DT30ZZ', '0DT37ZZ', '0DT40ZZ', '0DT47ZZ', '0DT50ZZ',
        '0DT57ZZ', '0DT60ZZ', '0DT67ZZ', '0DT70ZZ', '0DT77ZZ', '0DT80ZZ', '0DT87ZZ', '0DT90ZZ',
        '0DT97ZZ', '0DTA0ZZ', '0DTA7ZZ', '0DTB0ZZ', '0DTB7ZZ', '0DTC0ZZ', '0DTC7ZZ', '0DTE0ZZ',
        '0DTE7ZZ', '0DTF0ZZ', '0DTF4ZZ', '0DTF7ZZ', '0DTG0ZZ', '0DTG4ZZ', '0DTG7ZZ', '0DTH0ZZ',
        '0DTH4ZZ', '0DTH7ZZ', '0DTK0ZZ', '0DTK4ZZ', '0DTK7ZZ', '0DTL0ZZ', '0DTL4ZZ', '0DTL7ZZ',
        '0DTM0ZZ', '0DTM4ZZ', '0DTM7ZZ', '0DTN0ZZ', '0DTN4ZZ', '0DTN7ZZ', '0DTP0ZZ', '0DTP7ZZ',
        '0DU107Z', '0DU10JZ', '0DU10KZ', '0DU177Z', '0DU17JZ', '0DU17KZ', '0DU207Z', '0DU20JZ',
        '0DU20KZ', '0DU277Z', '0DU27JZ', '0DU27KZ', '0DU307Z', '0DU30JZ', '0DU30KZ', '0DU377Z',
        '0DU37JZ', '0DU37KZ', '0DU407Z', '0DU40JZ', '0DU40KZ', '0DU477Z', '0DU47JZ', '0DU47KZ',
        '0DU507Z', '0DU50JZ', '0DU50KZ', '0DU577Z', '0DU57JZ', '0DU57KZ', '0DU607Z', '0DU60JZ',
        '0DU60KZ', '0DU677Z', '0DU67JZ', '0DU67KZ', '0DU707Z', '0DU70JZ', '0DU70KZ', '0DU777Z',
        '0DU77JZ', '0DU77KZ', '0DU807Z', '0DU80JZ', '0DU80KZ', '0DU877Z', '0DU87JZ', '0DU87KZ',
        '0DU907Z', '0DU90JZ', '0DU90KZ', '0DU977Z', '0DU97JZ', '0DU97KZ', '0DUA07Z', '0DUA0JZ',
        '0DUA0KZ', '0DUA77Z', '0DUA7JZ', '0DUA7KZ', '0DUB07Z', '0DUB0JZ', '0DUB0KZ', '0DUB77Z',
        '0DUB7JZ', '0DUB7KZ', '0DUC07Z', '0DUC0JZ', '0DUC0KZ', '0DUC77Z', '0DUC7JZ', '0DUC7KZ',
        '0DUE07Z', '0DUE0JZ', '0DUE0KZ', '0DUE77Z', '0DUE7JZ', '0DUE7KZ', '0DUF07Z', '0DUF0JZ',
        '0DUF0KZ', '0DUF77Z', '0DUF7JZ', '0DUF7KZ', '0DUG07Z', '0DUG0JZ', '0DUG0KZ', '0DUG77Z',
        '0DUG7JZ', '0DUG7KZ', '0DUH07Z', '0DUH0JZ', '0DUH0KZ', '0DUH77Z', '0DUH7JZ', '0DUH7KZ',
        '0DUK07Z', '0DUK0JZ', '0DUK0KZ', '0DUK77Z', '0DUK7JZ', '0DUK7KZ', '0DUL07Z', '0DUL0JZ',
        '0DUL0KZ', '0DUL77Z', '0DUL7JZ', '0DUL7KZ', '0DUM07Z', '0DUM0JZ', '0DUM0KZ', '0DUM77Z',
        '0DUM7JZ', '0DUM7KZ', '0DUN07Z', '0DUN0JZ', '0DUN0KZ', '0DUN77Z', '0DUN7JZ', '0DUN7KZ',
        '0DUS07Z', '0DUS0JZ', '0DUS0KZ', '0DUT07Z', '0DUT0JZ', '0DUT0KZ', '0DUV07Z', '0DUV0JZ',
        '0DUV0KZ', '0DUW07Z', '0DUW0JZ', '0DUW0KZ', '0DV10CZ', '0DV10DZ', '0DV10ZZ', '0DV17DZ',
        '0DV17ZZ', '0DV20CZ', '0DV20DZ', '0DV20ZZ', '0DV27DZ', '0DV27ZZ', '0DV30CZ', '0DV30DZ',
        '0DV30ZZ', '0DV37DZ', '0DV37ZZ', '0DV40CZ', '0DV40DZ', '0DV40ZZ', '0DV47DZ', '0DV47ZZ',
        '0DV50CZ', '0DV50DZ', '0DV50ZZ', '0DV57DZ', '0DV57ZZ', '0DV60CZ', '0DV60DZ', '0DV60ZZ',
        '0DV67ZZ', '0DV70CZ', '0DV70DZ', '0DV70ZZ', '0DV77DZ', '0DV77ZZ', '0DV80CZ', '0DV80DZ',
        '0DV80ZZ', '0DV87DZ', '0DV87ZZ', '0DV90CZ', '0DV90DZ', '0DV90ZZ', '0DV97DZ', '0DV97ZZ',
        '0DVA0CZ', '0DVA0DZ', '0DVA0ZZ', '0DVA7DZ', '0DVA7ZZ', '0DVB0CZ', '0DVB0DZ', '0DVB0ZZ',
        '0DVB7DZ', '0DVB7ZZ', '0DVC0CZ', '0DVC0DZ', '0DVC0ZZ', '0DVC7DZ', '0DVC7ZZ', '0DVE0CZ',
        '0DVE0DZ', '0DVE0ZZ', '0DVE7DZ', '0DVE7ZZ', '0DVF0CZ', '0DVF0DZ', '0DVF0ZZ', '0DVF7DZ',
        '0DVF7ZZ', '0DVG0CZ', '0DVG0DZ', '0DVG0ZZ', '0DVG7DZ', '0DVG7ZZ', '0DVH0CZ', '0DVH0DZ',
        '0DVH0ZZ', '0DVH7DZ', '0DVH7ZZ', '0DVK0CZ', '0DVK0DZ', '0DVK0ZZ', '0DVK7DZ', '0DVK7ZZ',
        '0DVL0CZ', '0DVL0DZ', '0DVL0ZZ', '0DVL7DZ', '0DVL7ZZ', '0DVM0CZ', '0DVM0DZ', '0DVM0ZZ',
        '0DVM7DZ', '0DVM7ZZ', '0DVN0CZ', '0DVN0DZ', '0DVN0ZZ', '0DVN7DZ', '0DVN7ZZ', '0DW000Z',
        '0DW002Z', '0DW003Z', '0DW007Z', '0DW00CZ', '0DW00DZ', '0DW00JZ', '0DW00KZ', '0DW00UZ',
        '0DW070Z', '0DW072Z', '0DW073Z', '0DW077Z', '0DW07CZ', '0DW07DZ', '0DW07JZ', '0DW07KZ',
        '0DW07UZ', '0DW57DZ', '0DWD00Z', '0DWD02Z', '0DWD03Z', '0DWD07Z', '0DWD0CZ', '0DWD0DZ',
        '0DWD0JZ', '0DWD0KZ', '0DWD0UZ', '0DWD70Z', '0DWD72Z', '0DWD73Z', '0DWD77Z', '0DWD7CZ',
        '0DWD7DZ', '0DWD7JZ', '0DWD7KZ', '0DWD7UZ', '0DWE07Z', '0DWE0JZ', '0DWE0KZ', '0DWE77Z',
        '0DWE7JZ', '0DWE7KZ', '0DWU07Z', '0DWU0JZ', '0DWU0KZ', '0DWV07Z', '0DWV0JZ', '0DWV0KZ',
        '0DWW07Z', '0DWW0JZ', '0DWW0KZ', '0DX60Z5', '0DX80Z5', '0DXE0Z5', '0DY60Z0', '0DY60Z1',
        '0DY60Z2', '0F140D3', '0F140D4', '0F140D5', '0F140D6', '0F140D7', '0F140D8', '0F140D9',
        '0F140DB', '0F140Z3', '0F140Z4', '0F140Z5', '0F140Z6', '0F140Z7', '0F140Z8', '0F140Z9',
        '0F140ZB', '0F150D3', '0F150D4', '0F150D5', '0F150D6', '0F150D7', '0F150D8', '0F150D9',
        '0F150DB', '0F150Z3', '0F150Z4', '0F150Z5', '0F150Z6', '0F150Z7', '0F150Z8', '0F150Z9',
        '0F150ZB', '0F160D3', '0F160D4', '0F160D5', '0F160D6', '0F160D7', '0F160D8', '0F160D9',
        '0F160DB', '0F160Z3', '0F160Z4', '0F160Z5', '0F160Z6', '0F160Z7', '0F160Z8', '0F160Z9',
        '0F160ZB', '0F180D3', '0F180D4', '0F180D5', '0F180D6', '0F180D7', '0F180D8', '0F180D9',
        '0F180DB', '0F180Z3', '0F180Z4', '0F180Z5', '0F180Z6', '0F180Z7', '0F180Z8', '0F180Z9',
        '0F180ZB', '0F190D3', '0F190D4', '0F190D5', '0F190D6', '0F190D7', '0F190D8', '0F190D9',
        '0F190DB', '0F190Z3', '0F190Z4', '0F190Z5', '0F190Z6', '0F190Z7', '0F190Z8', '0F190Z9',
        '0F190ZB', '0F1D0D3', '0F1D0DB', '0F1D0DC', '0F1D0Z3', '0F1D0ZB', '0F1D0ZC', '0F1F0D3',
        '0F1F0DB', '0F1F0DC', '0F1F0Z3', '0F1F0ZB', '0F1F0ZC', '0F1G0D3', '0F1G0DB', '0F1G0DC',
        '0F1G0Z3', '0F1G0ZB', '0F1G0ZC', '0F500ZZ', '0F510ZZ', '0F520ZZ', '0F550ZZ', '0F557ZZ',
        '0F560ZZ', '0F567ZZ', '0F580ZZ', '0F587ZZ', '0F590ZZ', '0F597ZZ', '0F5C0ZZ', '0F5C7ZZ',
        '0F5D0ZZ', '0F5D7ZZ', '0F5F0ZZ', '0F5F7ZZ', '0F5G0ZZ', '0F750DZ', '0F750ZZ', '0F757DZ',
        '0F757ZZ', '0F760DZ', '0F760ZZ', '0F767DZ', '0F767ZZ', '0F780DZ', '0F780ZZ', '0F787DZ',
        '0F787ZZ', '0F790DZ', '0F790ZZ', '0F797DZ', '0F797ZZ', '0F7C0DZ', '0F7C0ZZ', '0F7C7DZ',
        '0F7C7ZZ', '0F7D0DZ', '0F7D0ZZ', '0F7D7DZ', '0F7D7ZZ', '0F7F0DZ', '0F7F0ZZ', '0F7F7DZ',
        '0F7F7ZZ', '0F8G0ZZ', '0F9000Z', '0F900ZZ', '0F9100Z', '0F910ZZ', '0F9200Z', '0F920ZZ',
        '0F9500Z', '0F950ZZ', '0F9570Z', '0F957ZZ', '0F9600Z', '0F960ZZ', '0F9670Z', '0F967ZZ',
        '0F9800Z', '0F980ZZ', '0F9870Z', '0F987ZZ', '0F9900Z', '0F990ZZ', '0F9C00Z', '0F9C0ZZ',
        '0F9C70Z', '0F9C7ZZ', '0F9D0ZZ', '0F9D7ZZ', '0F9F0ZZ', '0F9F7ZZ', '0F9G0ZZ', '0FB00ZZ',
        '0FB10ZZ', '0FB20ZZ', '0FB50ZZ', '0FB57ZZ', '0FB60ZZ', '0FB67ZZ', '0FB80ZZ', '0FB87ZZ',
        '0FB90ZZ', '0FB97ZZ', '0FBC0ZZ', '0FBC7ZZ', '0FBD0ZZ', '0FBD7ZZ', '0FBF0ZZ', '0FBF7ZZ',
        '0FBG0ZZ', '0FC00ZZ', '0FC10ZZ', '0FC20ZZ', '0FC50ZZ', '0FC60ZZ', '0FC80ZZ', '0FC90ZZ',
        '0FCC0ZZ', '0FCC7ZZ', '0FCD0ZZ', '0FCD7ZZ', '0FCF0ZZ', '0FCF7ZZ', '0FCG0ZZ', '0FF50ZZ',
        '0FF57ZZ', '0FF60ZZ', '0FF67ZZ', '0FF80ZZ', '0FF87ZZ', '0FF90ZZ', '0FF97ZZ', '0FFC0ZZ',
        '0FFC7ZZ', '0FFD0ZZ', '0FFD7ZZ', '0FFF0ZZ', '0FFF7ZZ', '0FH002Z', '0FH102Z', '0FH202Z',
        '0FHB02Z', '0FHB0DZ', '0FHB72Z', '0FHB7DZ', '0FHD02Z', '0FHD0DZ', '0FHD72Z', '0FHD7DZ',
        '0FHG02Z', '0FJ00ZZ', '0FJB0ZZ', '0FJB7ZZ', '0FL50CZ', '0FL50DZ', '0FL50ZZ', '0FL60CZ',
        '0FL60DZ', '0FL60ZZ', '0FL80CZ', '0FL80DZ', '0FL80ZZ', '0FL90CZ', '0FL90DZ', '0FL90ZZ',
        '0FLC0CZ', '0FLC0DZ', '0FLC0ZZ', '0FLC7DZ', '0FLC7ZZ', '0FLD0CZ', '0FLD0DZ', '0FLD0ZZ',
        '0FLD7DZ', '0FLD7ZZ', '0FLF0CZ', '0FLF0DZ', '0FLF0ZZ', '0FLF7DZ', '0FLF7ZZ', '0FM40ZZ',
        '0FM50ZZ', '0FM60ZZ', '0FM80ZZ', '0FM90ZZ', '0FMC0ZZ', '0FMD0ZZ', '0FMF0ZZ', '0FMG0ZZ',
        '0FN00ZZ', '0FN10ZZ', '0FN20ZZ', '0FN40ZZ', '0FN50ZZ', '0FN57ZZ', '0FN60ZZ', '0FN67ZZ',
        '0FN80ZZ', '0FN87ZZ', '0FN90ZZ', '0FN97ZZ', '0FNC0ZZ', '0FNC7ZZ', '0FND0ZZ', '0FND7ZZ',
        '0FNF0ZZ', '0FNF7ZZ', '0FNG0ZZ', '0FP000Z', '0FP002Z', '0FP003Z', '0FP40DZ', '0FPB00Z',
        '0FPB01Z', '0FPB02Z', '0FPB03Z', '0FPB07Z', '0FPB0CZ', '0FPB0DZ', '0FPB0JZ', '0FPB0KZ',
        '0FPB70Z', '0FPB71Z', '0FPB72Z', '0FPB73Z', '0FPB77Z', '0FPB7CZ', '0FPB7DZ', '0FPB7JZ',
        '0FPB7KZ', '0FPD00Z', '0FPD01Z', '0FPD02Z', '0FPD03Z', '0FPD07Z', '0FPD0CZ', '0FPD0DZ',
        '0FPD0JZ', '0FPD0KZ', '0FPD70Z', '0FPD71Z', '0FPD72Z', '0FPD73Z', '0FPD77Z', '0FPD7CZ',
        '0FPD7DZ', '0FPD7JZ', '0FPD7KZ', '0FPG00Z', '0FPG02Z', '0FPG03Z', '0FPG0DZ', '0FPGXDZ',
        '0FQ40ZZ', '0FQ50ZZ', '0FQ57ZZ', '0FQ60ZZ', '0FQ67ZZ', '0FQ80ZZ', '0FQ87ZZ', '0FQ90ZZ',
        '0FQ97ZZ', '0FQC0ZZ', '0FQC7ZZ', '0FQD0ZZ', '0FQD7ZZ', '0FQF0ZZ', '0FQF7ZZ', '0FQG0ZZ',
        '0FR507Z', '0FR50JZ', '0FR50KZ', '0FR607Z', '0FR60JZ', '0FR60KZ', '0FR807Z', '0FR80JZ',
        '0FR80KZ', '0FR907Z', '0FR90JZ', '0FR90KZ', '0FRC07Z', '0FRC0JZ', '0FRC0KZ', '0FRD07Z',
        '0FRD0JZ', '0FRD0KZ', '0FRF07Z', '0FRF0JZ', '0FRF0KZ', '0FS40ZZ', '0FS50ZZ', '0FS60ZZ',
        '0FS80ZZ', '0FS90ZZ', '0FSC0ZZ', '0FSD0ZZ', '0FSF0ZZ', '0FT10ZZ', '0FT20ZZ', '0FT50ZZ',
        '0FT57ZZ', '0FT60ZZ', '0FT67ZZ', '0FT80ZZ', '0FT87ZZ', '0FT90ZZ', '0FT97ZZ', '0FTC0ZZ',
        '0FTC7ZZ', '0FTD0ZZ', '0FTD7ZZ', '0FTF0ZZ', '0FTF7ZZ', '0FTG0ZZ', '0FU507Z', '0FU50JZ',
        '0FU50KZ', '0FU607Z', '0FU60JZ', '0FU60KZ', '0FU807Z', '0FU80JZ', '0FU80KZ', '0FU907Z',
        '0FU90JZ', '0FU90KZ', '0FUC07Z', '0FUC0JZ', '0FUC0KZ', '0FUD07Z', '0FUD0JZ', '0FUD0KZ',
        '0FUF07Z', '0FUF0JZ', '0FUF0KZ', '0FV50CZ', '0FV50DZ', '0FV50ZZ', '0FV60CZ', '0FV60DZ',
        '0FV60ZZ', '0FV80CZ', '0FV80DZ', '0FV80ZZ', '0FV90CZ', '0FV90DZ', '0FV90ZZ', '0FVC0CZ',
        '0FVC0DZ', '0FVC0ZZ', '0FVC7DZ', '0FVC7ZZ', '0FVD0CZ', '0FVD0DZ', '0FVD0ZZ', '0FVD7DZ',
        '0FVD7ZZ', '0FVF0CZ', '0FVF0DZ', '0FVF0ZZ', '0FVF7DZ', '0FVF7ZZ', '0FW000Z', '0FW002Z',
        '0FW003Z', '0FWB00Z', '0FWB02Z', '0FWB03Z', '0FWB07Z', '0FWB0CZ', '0FWB0DZ', '0FWB0JZ',
        '0FWB0KZ', '0FWB70Z', '0FWB72Z', '0FWB73Z', '0FWB77Z', '0FWB7CZ', '0FWB7DZ', '0FWB7JZ',
        '0FWB7KZ', '0FWD00Z', '0FWD02Z', '0FWD03Z', '0FWD07Z', '0FWD0CZ', '0FWD0DZ', '0FWD0JZ',
        '0FWD0KZ', '0FWD70Z', '0FWD72Z', '0FWD73Z', '0FWD77Z', '0FWD7CZ', '0FWD7DZ', '0FWD7JZ',
        '0FWD7KZ', '0FWG00Z', '0FWG02Z', '0FWG03Z', '0FWG0DZ', '0HQ4XZZ', '0HQ5XZZ', '0HQ9XZZ',
        '0KXF0ZZ', '0KXG0ZZ', '0N500ZZ', '0N510ZZ', '0N520ZZ', '0N530ZZ', '0N540ZZ', '0N550ZZ',
        '0N560ZZ', '0N570ZZ', '0N580ZZ', '0N800ZZ', '0N810ZZ', '0N820ZZ', '0N830ZZ', '0N840ZZ',
        '0N850ZZ', '0N860ZZ', '0N870ZZ', '0N880ZZ', '0N9000Z', '0N900ZZ', '0N9100Z', '0N910ZZ',
        '0N9200Z', '0N920ZZ', '0N9300Z', '0N930ZZ', '0N9400Z', '0N940ZZ', '0N9500Z', '0N950ZZ',
        '0N9600Z', '0N960ZZ', '0N9700Z', '0N970ZZ', '0N9800Z', '0N980ZZ', '0NB00ZZ', '0NB10ZZ',
        '0NB20ZZ', '0NB30ZZ', '0NB40ZZ', '0NB50ZZ', '0NB60ZZ', '0NB70ZZ', '0NB80ZZ', '0NC10ZZ',
        '0NC20ZZ', '0NC30ZZ', '0NC40ZZ', '0NC50ZZ', '0NC60ZZ', '0NC70ZZ', '0NC80ZZ', '0NH00MZ',
        '0NP000Z', '0NP004Z', '0NP005Z', '0NP007Z', '0NP00KZ', '0NP00SZ', '0NP0X4Z', '0NP0XSZ',
        '0NT10ZZ', '0NT20ZZ', '0NT30ZZ', '0NT40ZZ', '0NT50ZZ', '0NT60ZZ', '0NT70ZZ', '0NT80ZZ',
        '0NW000Z', '0NW004Z', '0NW005Z', '0NW007Z', '0NW00JZ', '0NW00KZ', '0NW00MZ', '0NW00NZ',
        '0NW00SZ', '0PT10ZZ', '0PT20ZZ', '0QPD0JZ', '0QPF0JZ', '0QRD0JZ', '0QRF0JZ', '0QUD0JZ',
        '0QUF0JZ', '0SP909Z', '0SP90JZ', '0SPB09Z', '0SPB0JZ', '0SPC09Z', '0SPC0JZ', '0SPD09Z',
        '0SPD0JZ', '0SQ90ZZ', '0SQ9XZZ', '0SQB0ZZ', '0SQBXZZ', '0SR9019', '0SR901A', '0SR901Z',
        '0SR9029', '0SR902A', '0SR902Z', '0SR9039', '0SR903A', '0SR903Z', '0SR9049', '0SR904A',
        '0SR904Z', '0SR907Z', '0SR90J9', '0SR90JA', '0SR90JZ', '0SR90KZ', '0SRA009', '0SRA00A',
        '0SRA00Z', '0SRA019', '0SRA01A', '0SRA01Z', '0SRA039', '0SRA03A', '0SRA03Z', '0SRA07Z',
        '0SRA0J9', '0SRA0JA', '0SRA0JZ', '0SRA0KZ', '0SRB019', '0SRB01A', '0SRB01Z', '0SRB029',
        '0SRB02A', '0SRB02Z', '0SRB039', '0SRB03A', '0SRB03Z', '0SRB049', '0SRB04A', '0SRB04Z',
        '0SRB07Z', '0SRB0J9', '0SRB0JA', '0SRB0JZ', '0SRB0KZ', '0SRC07Z', '0SRC0J9', '0SRC0JA',
        '0SRC0JZ', '0SRC0KZ', '0SRD07Z', '0SRD0J9', '0SRD0JA', '0SRD0JZ', '0SRD0KZ', '0SRE009',
        '0SRE00A', '0SRE00Z', '0SRE019', '0SRE01A', '0SRE01Z', '0SRE039', '0SRE03A', '0SRE03Z',
        '0SRE07Z', '0SRE0J9', '0SRE0JA', '0SRE0JZ', '0SRE0KZ', '0SRR019', '0SRR01A', '0SRR01Z',
        '0SRR039', '0SRR03A', '0SRR03Z', '0SRR07Z', '0SRR0J9', '0SRR0JA', '0SRR0JZ', '0SRR0KZ',
        '0SRS019', '0SRS01A', '0SRS01Z', '0SRS039', '0SRS03A', '0SRS03Z', '0SRS07Z', '0SRS0J9',
        '0SRS0JA', '0SRS0JZ', '0SRS0KZ', '0SRT07Z', '0SRT0J9', '0SRT0JA', '0SRT0JZ', '0SRT0KZ',
        '0SRU07Z', '0SRU0J9', '0SRU0JA', '0SRU0JZ', '0SRU0KZ', '0SRV07Z', '0SRV0J9', '0SRV0JA',
        '0SRV0JZ', '0SRV0KZ', '0SRW07Z', '0SRW0J9', '0SRW0JA', '0SRW0JZ', '0SRW0KZ', '0SU909Z',
        '0SU90BZ', '0SUA09Z', '0SUA0BZ', '0SUB09Z', '0SUB0BZ', '0SUC09C', '0SUC0JZ', '0SUD09C',
        '0SUD0JZ', '0SUE09Z', '0SUE0BZ', '0SUR09Z', '0SUR0BZ', '0SUS09Z', '0SUS0BZ', '0SUT09Z',
        '0SUU09Z', '0SUV09Z', '0SUW09Z', '0SW90JZ', '0SWB0JZ', '0SWC0JZ', '0SWD0JZ', '0T1307B',
        '0T130JB', '0T130KB', '0T130ZB', '0T1407B', '0T140JB', '0T140KB', '0T140ZB', '0T16076',
        '0T16077', '0T16078', '0T1607A', '0T1607B', '0T1607C', '0T160J6', '0T160J7', '0T160J8',
        '0T160JA', '0T160JB', '0T160JC', '0T160K6', '0T160K7', '0T160K8', '0T160KA', '0T160KB',
        '0T160KC', '0T160Z6', '0T160Z7', '0T160Z8', '0T160ZA', '0T160ZB', '0T160ZC', '0T17076',
        '0T17077', '0T17078', '0T1707A', '0T1707B', '0T1707C', '0T170J6', '0T170J7', '0T170J8',
        '0T170JA', '0T170JB', '0T170JC', '0T170K6', '0T170K7', '0T170K8', '0T170KA', '0T170KB',
        '0T170KC', '0T170Z6', '0T170Z7', '0T170Z8', '0T170ZA', '0T170ZB', '0T170ZC', '0T18076',
        '0T18077', '0T18078', '0T1807A', '0T1807B', '0T1807C', '0T180J6', '0T180J7', '0T180J8',
        '0T180JA', '0T180JB', '0T180JC', '0T180K6', '0T180K7', '0T180K8', '0T180KA', '0T180KB',
        '0T180KC', '0T180Z6', '0T180Z7', '0T180Z8', '0T180ZA', '0T180ZB', '0T180ZC', '0T1B079',
        '0T1B07C', '0T1B07D', '0T1B0J9', '0T1B0JC', '0T1B0JD', '0T1B0K9', '0T1B0KC', '0T1B0KD',
        '0T1B0Z9', '0T1B0ZC', '0T7B0DZ', '0T7B0ZZ', '0T7B7DZ', '0T7B7ZZ', '0T9300Z', '0T930ZZ',
        '0T9400Z', '0T940ZZ', '0TB00ZZ', '0TB07ZZ', '0TB10ZZ', '0TB17ZZ', '0TB30ZZ', '0TB37ZZ',
        '0TB40ZZ', '0TB47ZZ', '0TBB0ZZ', '0TBC0ZZ', '0TJ50ZZ', '0TMB0ZZ', '0TMC0ZZ', '0TN00ZZ',
        '0TN07ZZ', '0TN10ZZ', '0TN17ZZ', '0TN30ZZ', '0TN37ZZ', '0TN40ZZ', '0TN47ZZ', '0TN60ZZ',
        '0TN70ZZ', '0TQ60ZZ', '0TQ67ZZ', '0TQ70ZZ', '0TQ77ZZ', '0TQB0ZZ', '0TQB7ZZ', '0TQC0ZZ',
        '0TQC7ZZ', '0TRB07Z', '0TRB0JZ', '0TRB0KZ', '0TRB77Z', '0TRB7JZ', '0TRB7KZ', '0TRC07Z',
        '0TRC0JZ', '0TRC0KZ', '0TRC77Z', '0TRC7JZ', '0TRC7KZ', '0TSB0ZZ', '0TT00ZZ', '0TT10ZZ',
        '0TT20ZZ', '0TT30ZZ', '0TT37ZZ', '0TT40ZZ', '0TT47ZZ', '0TTB0ZZ', '0TTB7ZZ', '0TTC0ZZ',
        '0TTC7ZZ', '0TTD0ZZ', '0TTD7ZZ', '0TUB07Z', '0TUB0JZ', '0TUB0KZ', '0TUB77Z', '0TUB7JZ',
        '0TUB7KZ', '0TVB0CZ', '0TVB0DZ', '0TVB0ZZ', '0TVB7DZ', '0TVB7ZZ', '0TVC0CZ', '0TVC0DZ',
        '0TVC0ZZ', '0TVC7DZ', '0TVC7ZZ', '0U500ZZ', '0U510ZZ', '0U520ZZ', '0U550ZZ', '0U557ZZ',
        '0U560ZZ', '0U567ZZ', '0U570ZZ', '0U577ZZ', '0U800ZZ', '0U810ZZ', '0U820ZZ', '0UB00ZZ',
        '0UB07ZZ', '0UB10ZZ', '0UB17ZZ', '0UB20ZZ', '0UB27ZZ', '0UB50ZZ', '0UB57ZZ', '0UB60ZZ',
        '0UB67ZZ', '0UB70ZZ', '0UB77ZZ', '0UQM0ZZ', '0UQMXZZ', '0UT00ZZ', '0UT07ZZ', '0UT10ZZ',
        '0UT17ZZ', '0UT20ZZ', '0UT27ZZ', '0UT40ZZ', '0UT47ZZ', '0UT50ZZ', '0UT57ZZ', '0UT60ZZ',
        '0UT67ZZ', '0UT70ZZ', '0UT77ZZ', '0UT90ZZ', '0UT97ZZ', '0UT9FZZ', '0UTC0ZZ', '0UTC7ZZ',
        '0VT00ZZ', '0VT07ZZ', '0VT30ZZ', '0W1G0JY', '0W3G0ZZ', '0W3H0ZZ', '0W3P0ZZ', '0W9100Z',
        '0W910ZZ', '0W9G00Z', '0W9G0ZZ', '0W9J00Z', '0W9J0ZZ', '0WBH0ZZ', '0WC10ZZ', '0WCG0ZZ',
        '0WCJ0ZZ', '0WCP0ZZ', '0WCR0ZZ', '0WFD0ZZ', '0WFDXZZ', '0WFG0ZZ', '0WH10YZ', '0WHG03Z',
        '0WHG0YZ', '0WHH03Z', '0WHH0YZ', '0WHJ03Z', '0WHJ0YZ', '0WHP03Z', '0WJ10ZZ', '0WJG0ZZ',
        '0WJJ0ZZ', '0WJP0ZZ', '0WJR0ZZ', '0WMF0ZZ', '0WP100Z', '0WP101Z', '0WP10JZ', '0WP10YZ',
        '0WPG00Z', '0WPG01Z', '0WPG03Z', '0WPG0JZ', '0WPG0YZ', '0WPH00Z', '0WPH01Z', '0WPH03Z',
        '0WPH0YZ', '0WPP01Z', '0WPP03Z', '0WPP0YZ', '0WQ6XZ2', '0WQF0ZZ', '0WQFXZ2', '0WQFXZZ',
        '0WW100Z', '0WW101Z', '0WW103Z', '0WW10JZ', '0WW10YZ', '0WWG00Z', '0WWG01Z', '0WWG03Z',
        '0WWG0JZ', '0WWG0YZ', '0WWH00Z', '0WWH01Z', '0WWH03Z', '0WWH0YZ', '0WWJ00Z', '0WWJ01Z',
        '0WWJ03Z', '0WWJ0JZ', '0WWJ0YZ', '0WWP01Z', '0WWP03Z', '0WWP0YZ', '10T20ZZ', '10T27ZZ',
        '5A02116', '5A02216'
    }

    ICD9CM = {
        '0070', '0071', '0072', '0073', '0077', '0080', '0081', '0082', '0083', '0084', '0085',
        '0086', '0087', '0121', '0123', '0124', '0125', '0131', '0132', '0139', '0141', '0142',
        '0151', '0152', '0153', '0159', '1731', '1732', '1733', '1734', '1735', '1736', '1739',
        '3239', '3249', '3259', '3451', '3481', '3482', '3483', '3484', '3489', '3510', '3511',
        '3512', '3513', '3514', '3520', '3521', '3522', '3523', '3524', '3525', '3526', '3527',
        '3528', '3531', '3532', '3533', '3534', '3535', '3539', '3542', '3550', '3551', '3553',
        '3554', '3560', '3561', '3562', '3563', '3570', '3571', '3572', '3573', '3581', '3582',
        '3583', '3584', '3591', '3592', '3593', '3594', '3599', '3603', '3610', '3611', '3612',
        '3613', '3614', '3615', '3616', '3617', '3619', '3631', '3691', '3699', '3710', '3711',
        '3732', '3733', '3736', '3741', '3749', '3751', '3755', '3760', '3762', '3763', '3764',
        '3766', '3767', '3814', '3816', '3818', '3834', '3836', '3837', '3844', '3848', '3849',
        '3864', '3925', '3926', '3929', '415', '4201', '4209', '4210', '4211', '4212', '4219',
        '4240', '4241', '4242', '4251', '4252', '4253', '4254', '4255', '4256', '4258', '4259',
        '4261', '4262', '4263', '4264', '4265', '4266', '4268', '4269', '4282', '4283', '4284',
        '4285', '4286', '4287', '4289', '435', '436', '437', '4381', '4389', '4391', '4399',
        '4400', '4401', '4402', '4403', '4421', '4429', '4431', '4439', '4440', '4441', '4442',
        '445', '4461', '4463', '4464', '4465', '4466', '4469', '4491', '4492', '4499', '4500',
        '4501', '4502', '4503', '4531', '4532', '4533', '4541', '4549', '4550', '4551', '4552',
        '4561', '4562', '4563', '4571', '4572', '4573', '4574', '4575', '4576', '4579', '4582',
        '4583', '4590', '4591', '4592', '4593', '4594', '4595', '4601', '4602', '4604', '4621',
        '4622', '4623', '4642', '4643', '4650', '4652', '4660', '4661', '4662', '4663', '4664',
        '4671', '4672', '4675', '4676', '4679', '4691', '4692', '4694', '480', '481', '4841',
        '4849', '4850', '4852', '4859', '4861', '4862', '4863', '4864', '4865', '4869', '4872',
        '4873', '4874', '4875', '4876', '500', '5021', '5022', '5029', '503', '5131', '5132',
        '5133', '5134', '5135', '5136', '5137', '5139', '5141', '5142', '5149', '5151', '5159',
        '5161', '5162', '5163', '5169', '5171', '5172', '5179', '5181', '5182', '5183', '5189',
        '5191', '5192', '5193', '5194', '5195', '5199', '5209', '5222', '523', '524', '5251',
        '5252', '5253', '5259', '526', '527', '5292', '5295', '5296', '5299', '5372', '5375',
        '5380', '5381', '5382', '5384', '5411', '5412', '5419', '5459', '5461', '5462', '5463',
        '5464', '5471', '5472', '5473', '5474', '5475', '5492', '5494', '5495', '554', '5551',
        '5552', '5553', '5554', '5651', '5652', '5671', '5672', '5673', '5674', '5675', '5679',
        '576', '5771', '5779', '5781', '5782', '5783', '5784', '5785', '5786', '5787', '5788',
        '5789', '5900', '5902', '5909', '603', '604', '605', '6522', '6529', '6539', '6549',
        '6551', '6552', '6561', '6562', '664', '6651', '6652', '6661', '6662', '6663', '6669',
        '6831', '6849', '6851', '6859', '6869', '6879', '8140', '8151', '8152', '8153', '8154',
        '8155'
    }

    SNOMEDCT = {
        '10190003', '10259007', '10272008', '107936001', '107938000', '107963000', '108034003',
        '108184008', '10985002', '11127003', '112727005', '112728000', '112811009', '112816004',
        '112827002', '112871003', '112872005', '112877004', '112883001', '112902005', '112917009',
        '112918004', '112929000', '116027003', '116028008', '116031009', '116033007', '116142003',
        '116143008', '116166009', '116173004', '116175006', '116241004', '11748006', '118156007',
        '119560006', '119564002', '119614000', '119755005', '119766003', '119769005', '119773008',
        '119777009', '119815001', '119824005', '119880004', '119884008', '119888006', '119893009',
        '119903001', '119926008', '119927004', '119937009', '119983003', '119988007', '120053002',
        '120075000', '120172004', '120186000', '120187009', '120188004', '120216002', '12074006',
        '12445005', '12605005', '12827003', '128399009', '13721004', '1390003', '14037006',
        '14072009', '1411001', '14201006', '14247003', '14259004', '14687003', '15044006',
        '15051002', '15213007', '16117008', '16156002', '16280008', '16564004', '17073005',
        '171443003', '171553000', '171692002', '17203000', '172887003', '173171007', '17339009',
        '173566008', '173571001', '173572008', '173573003', '173576006', '173764008', '173980008',
        '174059005', '174080004', '174165008', '174241004', '174286001', '174310002', '174430004',
        '174431000', '174432007', '174439003', '174444005', '174702000', '174776001', '174830006',
        '174916002', '174994000', '174997007', '175021005', '175022003', '175024002', '175025001',
        '175026000', '175029007', '175094009', '175339005', '175396000', '175472009', '175474005',
        '175485007', '175905003', '175907006', '175912007', '175913002', '175917001', '175918006',
        '175921008', '175925004', '175987009', '176024008', '176106009', '176107000', '176108005',
        '176123000', '176139007', '176143006', '176212006', '176220008', '176227006', '176234008',
        '176261008', '176262001', '176263006', '177784006', '177956008', '178373004', '178376007',
        '178732003', '179295006', '179304004', '179305003', '179306002', '179351002', '17988003',
        '18133004', '1866009', '186648008', '18692006', '1871002', '18995005', '19235006',
        '192461000', '19606007', '19954002', '2002009', '20246000', '20357008', '20880009',
        '20912009', '21526003', '21756005', '21832001', '22174005', '22595005', '22953008',
        '22997007', '230810008', '232527001', '232641004', '232643001', '232647000', '232717009',
        '232720001', '232721002', '232735000', '232736004', '232739006', '232740008', '232744004',
        '232745003', '232747006', '232748001', '232749009', '232751008', '232754000', '232756003',
        '232758002', '232772006', '232774007', '232778005', '232782007', '232783002', '232785009',
        '232786005', '232787001', '232789003', '232793009', '232795002', '232797005', '232811004',
        '232812006', '232816009', '232820008', '232822000', '232823005', '232824004', '232825003',
        '232839003', '232843004', '232853003', '232854009', '232859004', '232860009', '232872003',
        '232875001', '232879007', '232884001', '232885000', '232886004', '232887008', '232888003',
        '232889006', '232891003', '232895007', '232897004', '232899001', '232902003', '232909007',
        '232919001', '232924003', '232928000', '232932006', '232933001', '232935008', '232952007',
        '232960008', '232961007', '232964004', '232966002', '232967006', '232968001', '232970005',
        '232976004', '232985004', '232986003', '232994005', '233004008', '233010008', '233015003',
        '233021004', '233022006', '233024007', '233028005', '233029002', '233036001', '233037005',
        '233038000', '233043007', '233046004', '233050006', '233051005', '233055001', '233057009',
        '233058004', '233060002', '233061003', '233062005', '233063000', '233064006', '233065007',
        '233068009', '233076006', '233082009', '233084005', '233085006', '233086007', '233087003',
        '233089000', '233090009', '233093006', '233094000', '233098002', '233101003', '233105007',
        '233106008', '233108009', '233109001', '233110006', '233111005', '233114002', '233127003',
        '233133007', '233134001', '233136004', '233139006', '233142000', '233153006', '233155004',
        '233156003', '233157007', '233158002', '233159005', '233164009', '233165005', '233166006',
        '233193009', '233194003', '233195002', '233196001', '233206000', '233207009', '233208004',
        '233213000', '233217004', '233219001', '233230003', '233233001', '233238005', '233412008',
        '233444007', '235160002', '235161003', '235162005', '235163000', '235164006', '235165007',
        '235166008', '235168009', '235170000', '235184005', '235366001', '235463005', '235467006',
        '235468001', '235469009', '235481008', '235485004', '235580007', '235581006', '235582004',
        '236140002', '236889009', '238212008', '238213003', '238214009', '238215005', '238217002',
        '238218007', '238219004', '239989009', '24355008', '243775002', '249210007', '25236004',
        '25353009', '25466008', '25811000', '26212005', '26294005', '26390003', '26447000',
        '26452005', '265056007', '265157000', '265158005', '265159002', '265160007', '265161006',
        '265170009', '265172001', '265223003', '265340005', '265341009', '265367004', '265379004',
        '265414003', '265467003', '265473002', '265480000', '265488007', '265511008', '265516003',
        '265528006', '265540006', '265550007', '265565008', '265571002', '265574005', '26565004',
        '26578004', '26586004', '26633008', '26925005', '27010001', '271414005', '271416007',
        '271489009', '27185000', '27190002', '27191003', '2745006', '275014009', '275017002',
        '277182002', '278500000', '27950001', '283377009', '28345000', '287293004', '287334009',
        '287716007', '287718008', '287721005', '287722003', '287723008', '287810009', '287846000',
        '287847009', '287859008', '287861004', '287935004', '288014001', '288042004', '28933001',
        '289754003', '290691008', '29114001', '29672006', '29712008', '29819009', '29827000',
        '30160001', '30215008', '30456009', '307009004', '30706000', '307259004', '307260009',
        '307263006', '307264000', '307330001', '307331002', '307332009', '307583008', '307586000',
        '307644001', '307645000', '307771009', '30803004', '308665009', '308678009', '308679001',
        '309814006', '312406002', '314489006', '314491003', '314592008', '314636003', '315319006',
        '315328007', '31545000', '32359009', '32413006', '32581000', '3287002', '32918006',
        '331865000', '33187003', '3360004', '33649007', '34068001', '340922009', '340926007',
        '34414001', '35129004', '35653006', '357579002', '35955002', '359571009', '359579006',
        '359591002', '359597003', '359604006', '360370002', '360374006', '361152000', '361249003',
        '36192008', '36253005', '363742001', '364682008', '366741003', '367436000', '367453007',
        '367485005', '36889006', '36910002', '36917004', '37412006', '37499001', '37572001',
        '37577007', '386649003', '39083009', '39166002', '397108006', '39724006', '397956004',
        '3980006', '40053007', '400988008', '4010009', '401004', '40250003', '40455006',
        '405397001', '405598005', '405599002', '40667002', '41293005', '413145007', '41330009',
        '41371003', '41416003', '41457005', '418551006', '425443008', '42560003', '425603008',
        '42593007', '426067000', '426618001', '42699003', '427198005', '42767002', '427700000',
        '427728006', '428401000', '428622003', '428652006', '429156003', '429595007', '429616001',
        '430698003', '43344006', '43791001', '438369007', '438488001', '439071008', '439493007',
        '44076002', '44119001', '44167006', '442102003', '442655008', '442919002', '443435007',
        '443543000', '443658004', '443681002', '443682009', '44378008', '444051004', '444165004',
        '444463001', '444593009', '445185007', '445746008', '445831005', '445884009', '445912000',
        '445942002', '44619000', '446571001', '446683008', '446816008', '446848007', '446865003',
        '447107001', '447363009', '447517002', '44777001', '44793005', '447947007', '447982008',
        '447992000', '448013009', '448143009', '448187000', '448190006', '448340001', '448474003',
        '448653006', '448940006', '448941005', '449039004', '45010005', '450813004', '450818008',
        '45134003', '45220009', '45274003', '4558008', '45602008', '45692002', '45900003',
        '46070005', '47353000', '47458005', '47789005', '48007004', '4862007', '48859006',
        '4891005', '49187005', '49209004', '49326008', '49795001', '49942007', '50216001',
        '50225007', '50774009', '51346007', '51396008', '51684008', '52247003', '52734007',
        '52930005', '53059001', '53087005', '53139002', '53423001', '5348003', '54033009',
        '5415002', '54153006', '54164009', '54357003', '54490004', '54747001', '54987000',
        '55253009', '56527009', '56614001', '5745003', '58094005', '58204008', '58303000',
        '58506009', '58709004', '59372001', '59656001', '59750000', '60581003', '60758002',
        '60954008', '609588000', '61236006', '6146001', '61524001', '61667000', '6190006',
        '62402000', '62692004', '62779009', '62820003', '62858004', '63016009', '63296004',
        '63322005', '63361002', '63516002', '63697000', '6402000', '64063003', '64253000',
        '64492005', '64887002', '65184001', '65291007', '65310005', '65657001', '65666002',
        '66343001', '66633009', '6704000', '67212000', '67598001', '68188002', '68255004',
        '69191006', '69455007', '699789005', '71145001', '71198003', '71273005', '71308004',
        '71309007', '71550003', '71588001', '71890008', '72261007', '72388004', '72583007',
        '73038007', '73380001', '73536002', '73544002', '73554003', '73713008', '73921006',
        '73927005', '73978003', '73996007', '74146001', '74284004', '74406002', '74770008',
        '7495004', '75506009', '75894009', '75916006', '75942006', '76062007', '76144001',
        '76192001', '7642007', '76443003', '76504000', '76580007', '76876009', '76961002',
        '77100009', '77163008', '77371000', '77615009', '77773000', '77902002', '78233008',
        '78268008', '78915009', '78925004', '79025009', '79093007', '79433000', '79553004',
        '79695004', '7981009', '80173001', '80637009', '807005', '8093000', '81092009', '81232004',
        '81259007', '81266008', '81516001', '81849003', '81913003', '82293009', '82619000',
        '82744000', '82900007', '82917000', '83152002', '83599002', '83985009', '84179007',
        '84262009', '84604002', '84824001', '84840003', '84952009', '85175006', '85217002',
        '8550006', '85735005', '85946004', '8645007', '86477000', '86481000', '86642005',
        '86789002', '86868001', '8703004', '87060004', '87150006', '87192001', '87231001',
        '87279008', '87289007', '87604009', '87618002', '87677003', '8782006', '88045004',
        '8876004', '88849006', '88865007', '88888008', '88930008', '88994001', '89438004',
        '89587004', '89642006', '8979005', '89814007', '90090007', '90410003', '90856004',
        '91621005', '91625001', '91679005', '9524002', '9666005', '9895003'
    }


class AnticoagulantTherapy(ValueSet):
    """

    Clinical Focus: This set of values contains medications that are prescribed for anticoagulant therapy at hospital discharge for patients following acute ischemic stroke.
    Data Element Scope: The intent of this data element is to identify patients who are prescribed anticoagulant therapy at discharge following acute ischemic stroke. Using the Quality Data Model, this particular element would map to the Medication category.
    Inclusion Criteria: Include oral and injectable drug forms. Include Warfarin, heparins and direct thrombin inhibitors.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.200'
    VALUE_SET_NAME = 'Anticoagulant Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1037045', '1037179', '1110708', '1114198', '1232082', '1232086', '1361029', '1361226',
        '1361568', '1361574', '1361577', '1361607', '1361615', '1361853', '1362024', '1362026',
        '1362027', '1362029', '1362030', '1362048', '1362052', '1362054', '1362055', '1362057',
        '1362059', '1362060', '1362061', '1362062', '1362063', '1362065', '1362831', '1362935',
        '1364435', '1364445', '1366636', '1659195', '1659197', '308351', '854228', '854235',
        '854238', '854241', '854245', '854248', '854252', '854255', '855288', '855296', '855302',
        '855308', '855312', '855318', '855324', '855332', '855338', '855344', '861356', '861360',
        '861363', '861365', '978725', '978733', '978736', '978738', '978740', '978744', '978746',
        '978755', '978759', '978777'
    }


class AntithromboticTherapy(ValueSet):
    """

    Clinical Focus: This set of values contains anticoagulant and antiplatelet drugs used to reduce stroke mortality and morbidity.
    Data Element Scope: The intent of this data element is to identify patients who receive antithombotic therapy following stroke. Using the Quality Data Model, this particular element would map to the Medication category.
    Inclusion Criteria: Include single and multi-ingredient drugs. Oral, rectal, and injectable dose forms should be included. Antithrombotic medications include anticoagulants and antiplatelet drugs.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.201'
    VALUE_SET_NAME = 'Antithrombotic Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1037045', '1037179', '103863', '1110708', '1114198', '1232082', '1232086', '1361029',
        '1361226', '1361568', '1361574', '1361577', '1361607', '1361615', '1361853', '1362024',
        '1362026', '1362027', '1362029', '1362030', '1362048', '1362052', '1362054', '1362055',
        '1362057', '1362059', '1362060', '1362061', '1362062', '1362063', '1362065', '1362831',
        '1362935', '1364435', '1364445', '1366636', '1536670', '1536675', '1536815', '1536833',
        '1537021', '1659195', '1659197', '198463', '198464', '198466', '198467', '198471',
        '198473', '198475', '198477', '198479', '198480', '199274', '205251', '205281', '212033',
        '243670', '243685', '243694', '259081', '308278', '308287', '308297', '308351', '308363',
        '308370', '308409', '308411', '308414', '308416', '308417', '309362', '313406', '318272',
        '349516', '359221', '432638', '545871', '605252', '637540', '646434', '647869', '692836',
        '702316', '724614', '747211', '749196', '763111', '763116', '797050', '806446', '827318',
        '853499', '854238', '854241', '854245', '854248', '854252', '854255', '855288', '855296',
        '855302', '855308', '855312', '855318', '855324', '855332', '855338', '855344', '861356',
        '861360', '861363', '861365', '863186', '896884', '900528', '978725', '978733', '978736',
        '978738', '978740', '978744', '978746', '978755', '978759', '978777', '994430', '994435'
    }


class AtrialFibrillationflutter(ValueSet):
    """

    Clinical Focus: This grouping value set contains diagnoses used to identify patients with a history of atrial fibrillation/flutter or a current finding of atrial fibrillation/flutter.
    Data Element Scope: The intent of this data element is to identify patients with a diagnosis of atrial fibrillation or flutter. Using the Quality Data Model, this particular element would map to the Diagnosis category or the Diagnosis attribute for the Encounter category.
    Inclusion Criteria: Include codes that identify patients with a history of atrial fibrillation/flutter or a current finding of atrial fibrillation/flutter. This is a grouping of ICD10CM, ICD9CM and SNOMEDCT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.202'
    VALUE_SET_NAME = 'Atrial Fibrillation/Flutter'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'I480', 'I481', 'I482', 'I483', 'I484', 'I4891', 'I4892'}

    ICD9CM = {'42731', '42732'}

    SNOMEDCT = {
        '195080001', '233910005', '233911009', '282825002', '300996004', '314208002', '425615007',
        '426749004', '426814001', '427665004', '440028005', '440059007', '49436004', '5370000'
    }


class AtrialAblation(ValueSet):
    """

    Clinical Focus: This grouping value set represents atrial ablation procedures.
    Data Element Scope: The intent of this data element is to identify patients with a history of atrial ablation procedure. Using the Quality Data Model, this particular element would map to the Procedure category.
    Inclusion Criteria: Include codes that identify patients with a history of atrial ablation procedure. This is a grouping of ICD10CM and SNOMEDCT codes.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.203'
    VALUE_SET_NAME = 'Atrial Ablation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'02560ZZ', '02563ZZ', '02564ZZ', '02580ZZ', '02583ZZ', '02584ZZ'}

    SNOMEDCT = {'175095005', '175125003', '428290007', '428663009', '429211003'}


class CarotidIntervention(ValueSet):
    """

    Clinical Focus: This set of values identifies patients who have undergone a carotid artery surgical procedure.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by procedure codes.
    Inclusion Criteria: Included are codes that represent carotid intervention surgical procedures.
    Exclusion Criteria: Excluded are codes that would not indicate a carotid intervention has been surgically performed.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.204'
    VALUE_SET_NAME = 'Carotid Intervention'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '031H09G', '031H09J', '031H0AG', '031H0AJ', '031H0JG', '031H0JJ', '031H0KG', '031H0KJ',
        '031H0ZG', '031H0ZJ', '031J09G', '031J09K', '031J0AG', '031J0AK', '031J0JG', '031J0JK',
        '031J0KG', '031J0KK', '031J0ZG', '031J0ZK', '031K09J', '031K0AJ', '031K0JJ', '031K0KJ',
        '031K0ZJ', '031L09K', '031L0AK', '031L0JK', '031L0KK', '031L0ZK', '031M09J', '031M0AJ',
        '031M0JJ', '031M0KJ', '031M0ZJ', '031N09K', '031N0AK', '031N0JK', '031N0KK', '031N0ZK',
        '035H0ZZ', '035H3ZZ', '035H4ZZ', '035J0ZZ', '035J3ZZ', '035J4ZZ', '035K0ZZ', '035K3ZZ',
        '035K4ZZ', '035L0ZZ', '035L3ZZ', '035L4ZZ', '035M0ZZ', '035M3ZZ', '035M4ZZ', '035N0ZZ',
        '035N3ZZ', '035N4ZZ', '037H04Z', '037H0DZ', '037H0ZZ', '037H34Z', '037H3DZ', '037H3ZZ',
        '037H44Z', '037H4DZ', '037H4ZZ', '037J04Z', '037J0DZ', '037J0ZZ', '037J34Z', '037J3DZ',
        '037J3ZZ', '037J44Z', '037J4DZ', '037J4ZZ', '037K04Z', '037K0DZ', '037K0ZZ', '037K34Z',
        '037K3DZ', '037K3ZZ', '037K44Z', '037K4DZ', '037K4ZZ', '037L04Z', '037L0DZ', '037L0ZZ',
        '037L34Z', '037L3DZ', '037L3ZZ', '037L44Z', '037L4DZ', '037L4ZZ', '037M04Z', '037M0DZ',
        '037M0ZZ', '037M34Z', '037M3DZ', '037M3ZZ', '037M44Z', '037M4DZ', '037M4ZZ', '037N04Z',
        '037N0DZ', '037N0ZZ', '037N34Z', '037N3DZ', '037N3ZZ', '037N44Z', '037N4DZ', '037N4ZZ',
        '039H00Z', '039H0ZX', '039H0ZZ', '039H30Z', '039H3ZX', '039H3ZZ', '039H40Z', '039H4ZX',
        '039H4ZZ', '039J00Z', '039J0ZX', '039J0ZZ', '039J30Z', '039J3ZX', '039J3ZZ', '039J40Z',
        '039J4ZX', '039J4ZZ', '039K00Z', '039K0ZX', '039K0ZZ', '039K30Z', '039K3ZX', '039K3ZZ',
        '039K40Z', '039K4ZX', '039K4ZZ', '039L00Z', '039L0ZX', '039L0ZZ', '039L30Z', '039L3ZX',
        '039L3ZZ', '039L40Z', '039L4ZX', '039L4ZZ', '039M00Z', '039M0ZX', '039M0ZZ', '039M30Z',
        '039M3ZX', '039M3ZZ', '039M40Z', '039M4ZX', '039M4ZZ', '039N00Z', '039N0ZX', '039N0ZZ',
        '039N30Z', '039N3ZX', '039N3ZZ', '039N40Z', '039N4ZX', '039N4ZZ', '03BH0ZX', '03BH0ZZ',
        '03BH3ZX', '03BH3ZZ', '03BH4ZX', '03BH4ZZ', '03BJ0ZX', '03BJ0ZZ', '03BJ3ZX', '03BJ3ZZ',
        '03BJ4ZX', '03BJ4ZZ', '03BK0ZX', '03BK0ZZ', '03BK3ZX', '03BK3ZZ', '03BK4ZX', '03BK4ZZ',
        '03BL0ZX', '03BL0ZZ', '03BL3ZX', '03BL3ZZ', '03BL4ZX', '03BL4ZZ', '03BM0ZX', '03BM0ZZ',
        '03BM3ZX', '03BM3ZZ', '03BM4ZX', '03BM4ZZ', '03BN0ZX', '03BN0ZZ', '03BN3ZX', '03BN3ZZ',
        '03BN4ZX', '03BN4ZZ', '03CH0ZZ', '03CH3ZZ', '03CH4ZZ', '03CJ0ZZ', '03CJ3ZZ', '03CJ4ZZ',
        '03CK0ZZ', '03CK3ZZ', '03CK4ZZ', '03CL0ZZ', '03CL3ZZ', '03CL4ZZ', '03CM0ZZ', '03CM3ZZ',
        '03CM4ZZ', '03CN0ZZ', '03CN3ZZ', '03CN4ZZ', '03HH03Z', '03HH0DZ', '03HH33Z', '03HH3DZ',
        '03HH43Z', '03HH4DZ', '03HJ03Z', '03HJ0DZ', '03HJ33Z', '03HJ3DZ', '03HJ43Z', '03HJ4DZ',
        '03HK03Z', '03HK0DZ', '03HK0MZ', '03HK33Z', '03HK3DZ', '03HK3MZ', '03HK43Z', '03HK4DZ',
        '03HK4MZ', '03HL03Z', '03HL0DZ', '03HL0MZ', '03HL33Z', '03HL3DZ', '03HL3MZ', '03HL43Z',
        '03HL4DZ', '03HL4MZ', '03HM03Z', '03HM0DZ', '03HM33Z', '03HM3DZ', '03HM43Z', '03HM4DZ',
        '03HN03Z', '03HN0DZ', '03HN33Z', '03HN3DZ', '03HN43Z', '03HN4DZ', '03LH0BZ', '03LH0CZ',
        '03LH0DZ', '03LH0ZZ', '03LH3BZ', '03LH3CZ', '03LH3DZ', '03LH3ZZ', '03LH4BZ', '03LH4CZ',
        '03LH4DZ', '03LH4ZZ', '03LJ0BZ', '03LJ0CZ', '03LJ0DZ', '03LJ0ZZ', '03LJ3BZ', '03LJ3CZ',
        '03LJ3DZ', '03LJ3ZZ', '03LJ4BZ', '03LJ4CZ', '03LJ4DZ', '03LJ4ZZ', '03LK0BZ', '03LK0CZ',
        '03LK0DZ', '03LK0ZZ', '03LK3BZ', '03LK3CZ', '03LK3DZ', '03LK3ZZ', '03LK4BZ', '03LK4CZ',
        '03LK4DZ', '03LK4ZZ', '03LL0BZ', '03LL0CZ', '03LL0DZ', '03LL0ZZ', '03LL3BZ', '03LL3CZ',
        '03LL3DZ', '03LL3ZZ', '03LL4BZ', '03LL4CZ', '03LL4DZ', '03LL4ZZ', '03LM0BZ', '03LM0CZ',
        '03LM0DZ', '03LM0ZZ', '03LM3BZ', '03LM3CZ', '03LM3DZ', '03LM3ZZ', '03LM4BZ', '03LM4CZ',
        '03LM4DZ', '03LM4ZZ', '03LN0BZ', '03LN0CZ', '03LN0DZ', '03LN0ZZ', '03LN3BZ', '03LN3CZ',
        '03LN3DZ', '03LN3ZZ', '03LN4BZ', '03LN4CZ', '03LN4DZ', '03LN4ZZ', '03NH0ZZ', '03NH3ZZ',
        '03NH4ZZ', '03NJ0ZZ', '03NJ3ZZ', '03NJ4ZZ', '03NK0ZZ', '03NK3ZZ', '03NK4ZZ', '03NL0ZZ',
        '03NL3ZZ', '03NL4ZZ', '03NM0ZZ', '03NM3ZZ', '03NM4ZZ', '03NN0ZZ', '03NN3ZZ', '03NN4ZZ',
        '03QH0ZZ', '03QH3ZZ', '03QH4ZZ', '03QJ0ZZ', '03QJ3ZZ', '03QJ4ZZ', '03QK0ZZ', '03QK3ZZ',
        '03QK4ZZ', '03QL0ZZ', '03QL3ZZ', '03QL4ZZ', '03QM0ZZ', '03QM3ZZ', '03QM4ZZ', '03QN0ZZ',
        '03QN3ZZ', '03QN4ZZ', '03RH07Z', '03RH0JZ', '03RH0KZ', '03RH47Z', '03RH4JZ', '03RH4KZ',
        '03RJ07Z', '03RJ0JZ', '03RJ0KZ', '03RJ47Z', '03RJ4JZ', '03RJ4KZ', '03RK07Z', '03RK0JZ',
        '03RK0KZ', '03RK47Z', '03RK4JZ', '03RK4KZ', '03RL07Z', '03RL0JZ', '03RL0KZ', '03RL47Z',
        '03RL4JZ', '03RL4KZ', '03RM07Z', '03RM0JZ', '03RM0KZ', '03RM47Z', '03RM4JZ', '03RM4KZ',
        '03RN07Z', '03RN0JZ', '03RN0KZ', '03RN47Z', '03RN4JZ', '03RN4KZ', '03SH0ZZ', '03SH3ZZ',
        '03SH4ZZ', '03SJ0ZZ', '03SJ3ZZ', '03SJ4ZZ', '03SK0ZZ', '03SK3ZZ', '03SK4ZZ', '03SL0ZZ',
        '03SL3ZZ', '03SL4ZZ', '03SM0ZZ', '03SM3ZZ', '03SM4ZZ', '03SN0ZZ', '03SN3ZZ', '03SN4ZZ',
        '03UH07Z', '03UH0JZ', '03UH0KZ', '03UH37Z', '03UH3JZ', '03UH3KZ', '03UH47Z', '03UH4JZ',
        '03UH4KZ', '03UJ07Z', '03UJ0JZ', '03UJ0KZ', '03UJ37Z', '03UJ3JZ', '03UJ3KZ', '03UJ47Z',
        '03UJ4JZ', '03UJ4KZ', '03UK07Z', '03UK0JZ', '03UK0KZ', '03UK37Z', '03UK3JZ', '03UK3KZ',
        '03UK47Z', '03UK4JZ', '03UK4KZ', '03UL07Z', '03UL0JZ', '03UL0KZ', '03UL37Z', '03UL3JZ',
        '03UL3KZ', '03UL47Z', '03UL4JZ', '03UL4KZ', '03UM07Z', '03UM0JZ', '03UM0KZ', '03UM37Z',
        '03UM3JZ', '03UM3KZ', '03UM47Z', '03UM4JZ', '03UM4KZ', '03UN07Z', '03UN0JZ', '03UN0KZ',
        '03UN37Z', '03UN3JZ', '03UN3KZ', '03UN47Z', '03UN4JZ', '03UN4KZ', '03VH0BZ', '03VH0CZ',
        '03VH0DZ', '03VH0ZZ', '03VH3BZ', '03VH3CZ', '03VH3DZ', '03VH3ZZ', '03VH4BZ', '03VH4CZ',
        '03VH4DZ', '03VH4ZZ', '03VJ0BZ', '03VJ0CZ', '03VJ0DZ', '03VJ0ZZ', '03VJ3BZ', '03VJ3CZ',
        '03VJ3DZ', '03VJ3ZZ', '03VJ4BZ', '03VJ4CZ', '03VJ4DZ', '03VJ4ZZ', '03VK0BZ', '03VK0CZ',
        '03VK0DZ', '03VK0ZZ', '03VK3BZ', '03VK3CZ', '03VK3DZ', '03VK3ZZ', '03VK4BZ', '03VK4CZ',
        '03VK4DZ', '03VK4ZZ', '03VL0BZ', '03VL0CZ', '03VL0DZ', '03VL0ZZ', '03VL3BZ', '03VL3CZ',
        '03VL3DZ', '03VL3ZZ', '03VL4BZ', '03VL4CZ', '03VL4DZ', '03VL4ZZ', '03VM0BZ', '03VM0CZ',
        '03VM0DZ', '03VM0ZZ', '03VM3BZ', '03VM3CZ', '03VM3DZ', '03VM3ZZ', '03VM4BZ', '03VM4CZ',
        '03VM4DZ', '03VM4ZZ', '03VN0BZ', '03VN0CZ', '03VN0DZ', '03VN0ZZ', '03VN3BZ', '03VN3CZ',
        '03VN3DZ', '03VN3ZZ', '03VN4BZ', '03VN4CZ', '03VN4DZ', '03VN4ZZ', '0G560ZZ', '0G563ZZ',
        '0G564ZZ', '0G570ZZ', '0G573ZZ', '0G574ZZ', '0G580ZZ', '0G583ZZ', '0G584ZZ', '0G9600Z',
        '0G960ZX', '0G960ZZ', '0G9630Z', '0G963ZX', '0G963ZZ', '0G9640Z', '0G964ZX', '0G964ZZ',
        '0G9700Z', '0G970ZX', '0G970ZZ', '0G9730Z', '0G973ZX', '0G973ZZ', '0G9740Z', '0G974ZX',
        '0G974ZZ', '0G9800Z', '0G980ZX', '0G980ZZ', '0G9830Z', '0G983ZX', '0G983ZZ', '0G9840Z',
        '0G984ZX', '0G984ZZ', '0GB60ZX', '0GB60ZZ', '0GB63ZX', '0GB63ZZ', '0GB64ZX', '0GB64ZZ',
        '0GB70ZX', '0GB70ZZ', '0GB73ZX', '0GB73ZZ', '0GB74ZX', '0GB74ZZ', '0GB80ZX', '0GB80ZZ',
        '0GB83ZX', '0GB83ZZ', '0GB84ZX', '0GB84ZZ', '0GC60ZZ', '0GC63ZZ', '0GC64ZZ', '0GC70ZZ',
        '0GC73ZZ', '0GC74ZZ', '0GC80ZZ', '0GC83ZZ', '0GC84ZZ', '0GN60ZZ', '0GN63ZZ', '0GN64ZZ',
        '0GN70ZZ', '0GN73ZZ', '0GN74ZZ', '0GN80ZZ', '0GN83ZZ', '0GN84ZZ', '0GQ60ZZ', '0GQ63ZZ',
        '0GQ64ZZ', '0GQ70ZZ', '0GQ73ZZ', '0GQ74ZZ', '0GQ80ZZ', '0GQ83ZZ', '0GQ84ZZ', '0GT60ZZ',
        '0GT64ZZ', '0GT70ZZ', '0GT74ZZ', '0GT80ZZ', '0GT84ZZ', 'B3060ZZ', 'B3061ZZ', 'B306YZZ',
        'B3070ZZ', 'B3071ZZ', 'B307YZZ', 'B3080ZZ', 'B3081ZZ', 'B308YZZ', 'B3160ZZ', 'B3161ZZ',
        'B316YZZ', 'B3170ZZ', 'B3171ZZ', 'B317YZZ', 'B3180ZZ', 'B3181ZZ', 'B318YZZ'
    }

    ICD9CM = {
        '0061', '0062', '0063', '0064', '0065', '3802', '3812', '3822', '3830', '3831', '3832',
        '3842', '3928', '8841'
    }

    SNOMEDCT = {
        '112823003', '15023006', '175363002', '175364008', '175365009', '175367001', '175373000',
        '175374006', '175376008', '175379001', '175380003', '175398004', '18674003', '209760000',
        '22928005', '233259003', '233260008', '233296007', '233297003', '233298008', '233405004',
        '241219006', '25007007', '276949008', '276950008', '276951007', '287606009', '302053004',
        '303161001', '31573003', '34214004', '39887009', '405326004', '405379009', '405407008',
        '405408003', '405409006', '405411002', '405412009', '405415006', '417884003', '418405008',
        '418838006', '419014003', '420026003', '420046008', '420171008', '425611003', '427486009',
        '428802000', '429287007', '431515004', '431519005', '431535003', '431659001', '432039002',
        '432785007', '433056003', '433061001', '433591001', '433683001', '433690006', '433711000',
        '433734009', '434159001', '434378006', '434433007', '43628009', '438615003', '440221006',
        '440453000', '440518005', '449242004', '46912008', '51382002', '53412000', '55493009',
        '59012002', '59109003', '66951008', '74720005', '75538004', '79507006', '80102005',
        '80104006', '87314005', '90931006', '9339002'
    }


class DirectThrombinInhibitor(ValueSet):
    """

    Clinical Focus: This set of values contains codes which identify a select medication-a direct thrombin inhibitor.
    Data Element Scope: The intent of this data element is to identify patients who are on a direct thrombin inhibitor.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Only include codes which represent direct thrombin inhibitors.  These are RxNorm codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.205'
    VALUE_SET_NAME = 'Direct Thrombin Inhibitor'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1037045', '1037179', '1110708', '308351', '308769'}


class DischargedToHealthCareFacilityForHospiceCare(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to a health care facility for hospice care.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular  inpatient encounter. This particular value set intends to identify patients who where discharged to a health care facility for hospice care. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing  health care facilities for hospice care  should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.207'
    VALUE_SET_NAME = 'Discharged to Health Care Facility for Hospice Care'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428371000124100'}


class DischargedToHomeForHospiceCare(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to home for hospice care.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular  inpatient encounter. This particular value set intends to identify patients who where discharged to home for hospice care.  Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing discharge to home for hospice care should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.209'
    VALUE_SET_NAME = 'Discharged to Home for Hospice Care'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428361000124107'}


class InjectableFactorXaInhibitorForVteProphylaxis(ValueSet):
    """

    Clinical Focus: This set of values contains codes which identify a select medication-an injectable Factor Xa inhibitor-which is used for VTE prophylaxis.
    Data Element Scope: The intent of this data element is to identify patients who are on a select Injectable Factor Xa Inhibitor as prophylaxis for VTE.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Only include codes which represent injectable Factor Xa inhibitor medications.  These are RxNorm codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.211'
    VALUE_SET_NAME = 'Injectable Factor Xa Inhibitor for VTE Prophylaxis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'861356', '861360', '861363', '861365'}


class HemorrhagicStroke(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have had a hemorrhagic stroke, or stroke caused by hemorrhage.
    Data Element Scope: The intent of this data element is to identify patients who have a diagnosis of hemorrhagic stroke, or stroke caused by a hemorrhage.  Using the Quality Data Model, this particular element would map to the Principal Diagnosis attribute for the Encounter category.
    Inclusion Criteria: Only use codes which represent a diagnosis of hemorrhagic stroke, or stroke caused by hemorrhage.  This is a grouping of ICD9CM, ICD10CM and SNOMED-CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.212'
    VALUE_SET_NAME = 'Hemorrhagic Stroke'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I6000', 'I6001', 'I6002', 'I6010', 'I6011', 'I6012', 'I602', 'I6030', 'I6031', 'I6032',
        'I604', 'I6050', 'I6051', 'I6052', 'I606', 'I607', 'I608', 'I609', 'I610', 'I611', 'I612',
        'I613', 'I614', 'I615', 'I616', 'I618', 'I619'
    }

    ICD9CM = {'430', '431'}

    SNOMEDCT = {
        '195155004', '195160000', '195165005', '195167002', '195168007', '195169004', '20908003',
        '230706003', '230707007', '230708002', '230709005', '230710000', '230711001', '230712008',
        '23276006', '270907008', '274100004', '276277008', '276278003', '276280009', '276281008',
        '276282001', '276283006', '276284000', '276285004', '276286003', '276722003', '28318001',
        '28837001', '42429001', '425957003', '449020009', '49422009', '52201006', '73020009',
        '75038005', '7713009', '95454007'
    }


class Inr(ValueSet):
    """

    Clinical Focus: This set of values contains codes for laboratory test for INR, or International Normalized Ratio.
    Data Element Scope: The intent of this data element is to identify INR laboratory tests.  Using the Quality Data Model, this data element maps to the Laboratory Test category.
    Inclusion Criteria: Only include codes which represent a laboratory test of INR (International Normalized Ratio).  These are LOINC codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.213'
    VALUE_SET_NAME = 'INR'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'34714-6', '38875-1', '46418-0', '52129-4', '6301-6'}


class IntermittentPneumaticCompressionDevicesIpc(ValueSet):
    """

    Clinical Focus: This set of values represents the different types of intermittent pneumatic compression devices used for VTE prophylaxis.
    Data Element Scope: The intent of this data element is to represent the application of certain intermittent pneumatic compression devices. Using the Quality Data Model, this data element will map to the Device category.
    Inclusion Criteria: Only include codes which represent different types of intermittent pneumatic compression devices.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.214'
    VALUE_SET_NAME = 'Intermittent pneumatic compression devices (IPC)'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428411000124104', '428421000124107', '442111003', '469317002', '469365001'}


class LdlC(ValueSet):
    """

    Clinical Focus: This set of values contains lab tests commonly used for LDL cholesterol measurement.
    Data Element Scope: The intent of this data element is to identify patients who had a lab test on a source of serum or plasma. Using the Quality Data Model, this particular element would map to Laboratory Test category.
    Inclusion Criteria: Include LDL c tests using the source of serum or plasma based on a measurement scale of mass per volume.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.215'
    VALUE_SET_NAME = 'LDL-c'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'13457-7', '18261-8', '18262-6', '2089-1', '49132-4', '55440-2'}


class UnfractionatedHeparin(ValueSet):
    """

    Clinical Focus: This value set identifies heparin formulations that could reasonably be used to treat venous thromboembolism as a continuous infusion.
    Data Element Scope: The intent of this data element is to identify patients who receive unfractionated heparin as an intravenous infusion. Using the Quality Data Model, this particular element will map to the Medication category.
    Inclusion Criteria: Injectable products that could reasonably be used for continuous infusion of heparin and achieve therapeutic levels.
    Exclusion Criteria: Concentrations < 250 UNT/ML (except those representing premixed heparin infusion bags, per inclusion criteria).
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.218'
    VALUE_SET_NAME = 'Unfractionated Heparin'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'1361607', '1658717', '1658720', '1659195', '1659197'}


class LowMolecularWeightHeparinForVteProphylaxis(ValueSet):
    """

    Clinical Focus: This set of values represents medications used for VTE prophylaxis.  The medications are low molecular weight heparins.  The medications included in this value set are administered parenterally.
    Data Element Scope: The intent of this data element is to identify patients who are on low molecular weight heparin therapy as VTE prophylaxis.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Only include RxNorm codes which specifically represent low molecular weight heparins which are administered parenterally.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.219'
    VALUE_SET_NAME = 'Low Molecular Weight Heparin for VTE Prophylaxis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '854228', '854235', '854238', '854241', '854245', '854248', '854252', '854255', '978713',
        '978725', '978733', '978736', '978738', '978740', '978744', '978746', '978755', '978759',
        '978777'
    }


class IntravenousRoute(ValueSet):
    """

    Clinical Focus: This set of values identifies the route by which a medication is administered, in this case an intravenous route.
    Data Element Scope: The intent of this data element is to identify the route by which a medication is administered, in this case an intravenous route.  Using the Quality Data Model, this particular element is an attribute.
    Inclusion Criteria: Only use codes which identify an intravenous route for giving a medication. Codes used are to be SNOMED-CT codes only.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.222'
    VALUE_SET_NAME = 'Intravenous route'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'418114005', '419993007', '47625008'}


class SubcutaneousRoute(ValueSet):
    """

    Clinical Focus: This set of values identifies the route by which a medication is administered, in this case a subcutaneous route.
    Data Element Scope: The intent of this data element is to identify the route by which a medication is administered, in this case a subcutaneous route.  Using the Quality Data Model, this particular element is an attribute.
    Inclusion Criteria: Only use codes which identify a subcutaneous route for giving a medication.  These are SNOMED-CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.223'
    VALUE_SET_NAME = 'Subcutaneous route'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'34206005'}


class ThrombolyticTPaTherapy(ValueSet):
    """

    Clinical Focus: This set of values contains medications that are prescribed for Thrombolytic (t-PA) Therapy for treatment of ischemic stroke.
    Data Element Scope: The intent of this data element is to identify patients who are administered  appropriate Thrombolytic (t-PA) Therapy for stroke. Using the Quality Data Model, this particular element would map to the "Medication" category.
    Inclusion Criteria: Include RxNorm  thombolytic medications appropriate for stroke treatment consistent with administration by IV route.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.226'
    VALUE_SET_NAME = 'Thrombolytic (t-PA) Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {'308056'}


class VenousFootPumpsVfp(ValueSet):
    """

    Clinical Focus: This set of values identifies patients who have a venous foot pump device applied for VTE prophylaxis.
    Data Element Scope: The intent of this data element is to identify patients who have a venous foot pump device applied for VTE prophylaxis. Using the Quality Data Model, this particular element will map to the Device category.
    Inclusion Criteria: Only use codes which represent venous foot pump devices which are used for VTE prophylaxis.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.230'
    VALUE_SET_NAME = 'Venous foot pumps (VFP)'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'442023007'}


class Warfarin(ValueSet):
    """

    Clinical Focus: This set of values contains Warfarin medications that are administered to patients to reduce the risk of blood clot formation.
    Data Element Scope: The intent of this data element is to identify patients who are prescribed warfarin therapy at discharge following acute myocardial infarction. Using the Quality Data Model, this particular element would map to the Medication category.
    Inclusion Criteria: Drug forms that are consistent with oral administration should be included: tablets. Only single ingredient.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.232'
    VALUE_SET_NAME = 'Warfarin'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '855288', '855296', '855302', '855312', '855318', '855324', '855332', '855338', '855344'
    }


class IschemicStroke(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have had a stroke caused by ischemia, where the blood supply is restricted to an area of the brain by something like thrombosis or an embolism.
    Data Element Scope: The intent of this data element is to identify patients who have a diagnosis of ischemic stroke, or stroke caused by ischemia.  Using the Quality Data Model, this particular element would map to the Principal Diagnosis attribute for the Encounter category or to the Diagnosis Category.
    Inclusion Criteria: Only use codes which represent a diagnosis of ischemic stroke, or stroke caused by ischemia.  This is a grouping of ICD9CM, ICD10CM and SNOMED-CT codes and concepts.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.247'
    VALUE_SET_NAME = 'Ischemic Stroke'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I6300', 'I63011', 'I63012', 'I63013', 'I63019', 'I6302', 'I63031', 'I63032', 'I63033',
        'I63039', 'I6309', 'I6310', 'I63111', 'I63112', 'I63113', 'I63119', 'I6312', 'I63131',
        'I63132', 'I63133', 'I63139', 'I6319', 'I6320', 'I63211', 'I63212', 'I63213', 'I63219',
        'I6322', 'I63231', 'I63232', 'I63233', 'I63239', 'I6329', 'I6330', 'I63311', 'I63312',
        'I63313', 'I63319', 'I63321', 'I63322', 'I63323', 'I63329', 'I63331', 'I63332', 'I63333',
        'I63339', 'I63341', 'I63342', 'I63343', 'I63349', 'I6339', 'I6340', 'I63411', 'I63412',
        'I63413', 'I63419', 'I63421', 'I63422', 'I63423', 'I63429', 'I63431', 'I63432', 'I63433',
        'I63439', 'I63441', 'I63442', 'I63443', 'I63449', 'I6349', 'I6350', 'I63511', 'I63512',
        'I63513', 'I63519', 'I63521', 'I63522', 'I63523', 'I63529', 'I63531', 'I63532', 'I63533',
        'I63539', 'I63541', 'I63542', 'I63543', 'I63549', 'I6359', 'I636', 'I638', 'I639'
    }

    ICD9CM = {
        '43301', '43310', '43311', '43321', '43331', '43381', '43391', '43400', '43401', '43411',
        '43491', '436'
    }

    SNOMEDCT = {
        '111297002', '116288000', '195185009', '195186005', '195189003', '195190007', '195212005',
        '195213000', '195216008', '195217004', '195230003', '230690007', '230691006', '230692004',
        '230693009', '230694003', '230695002', '230696001', '230698000', '230699008', '230700009',
        '230701008', '307363008', '426107000'
    }


class SingleLiveBirth(ValueSet):
    """

    Clinical Focus: This set of values contains types of delivery that represent the single live birth.
    Data Element Scope: The intent of this data element is to identify a single live born newborn. Using the Quality Data Model, this particular element will map to the "Diagnosis" category.
    Inclusion Criteria: Include SNOMED CT codes that identify single live birth.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.25'
    VALUE_SET_NAME = 'Single Live Birth'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'169826009'}


class ClinicalPathwayProtocol(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a regime or therapy that is commonly used in the inpatient setting to follow clinical pathway protocol.
    Data Element Scope: The intent of this data element is to identify patients who have received therapy following a clinical pathway protocol. Using the Quality Data Model, this element is mapped to the "Procedure" category.
    Inclusion Criteria: Only use codes which represent the regime or therapy of a clinical pathway protocol.  Codes used are SNOMED CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.253'
    VALUE_SET_NAME = 'Clinical Pathway Protocol'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'370858005'}


class GeneralSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets contains value sets which identify patients who have a general surgery procedure. These surgical procedures are thoracic and abdominal procedures, except for cardiac procedures.
    Data Element Scope: The intent of this data element is to identify patients who have general surgery procedures. Using the Quality Data Model, this data element maps to the Procedure category.
    Inclusion Criteria: Only include codes which represent general surgery. These surgical procedures are thoracic and abdominal procedures, except for cardiac procedures.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.255'
    VALUE_SET_NAME = 'General Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '008Q0ZZ', '06L20ZZ', '07JP0ZZ', '07TP0ZZ', '0B5R0ZZ', '0B5S0ZZ', '0B9R00Z', '0B9R0ZZ',
        '0B9S00Z', '0B9S0ZZ', '0BBR0ZZ', '0BBS0ZZ', '0BCR0ZZ', '0BCS0ZZ', '0BDN0ZX', '0BDN0ZZ',
        '0BDP0ZX', '0BDP0ZZ', '0BHR02Z', '0BHS02Z', '0BMR0ZZ', '0BMS0ZZ', '0BNR0ZZ', '0BNS0ZZ',
        '0BPT00Z', '0BPT02Z', '0BPT07Z', '0BPT0JZ', '0BPT0KZ', '0BPT0MZ', '0BPT70Z', '0BPT72Z',
        '0BPT77Z', '0BPT7JZ', '0BPT7KZ', '0BPT7MZ', '0BPT80Z', '0BPT82Z', '0BPT87Z', '0BPT8JZ',
        '0BPT8KZ', '0BPT8MZ', '0BQR0ZZ', '0BQS0ZZ', '0BSR0ZZ', '0BSS0ZZ', '0BTC0ZZ', '0BTD0ZZ',
        '0BTF0ZZ', '0BTG0ZZ', '0BTH0ZZ', '0BTJ0ZZ', '0BTK0ZZ', '0BTL0ZZ', '0BTM0ZZ', '0BUR07Z',
        '0BUR0JZ', '0BUR0KZ', '0BUS07Z', '0BUS0JZ', '0BUS0KZ', '0BWT00Z', '0BWT02Z', '0BWT07Z',
        '0BWT0JZ', '0BWT0KZ', '0BWT0MZ', '0BWT70Z', '0BWT72Z', '0BWT77Z', '0BWT7JZ', '0BWT7KZ',
        '0BWT7MZ', '0BWT80Z', '0BWT82Z', '0BWT87Z', '0BWT8JZ', '0BWT8KZ', '0BWT8MZ', '0D11074',
        '0D11076', '0D11079', '0D1107A', '0D1107B', '0D110J4', '0D110J6', '0D110J9', '0D110JA',
        '0D110JB', '0D110K4', '0D110K6', '0D110K9', '0D110KA', '0D110KB', '0D110Z4', '0D110Z6',
        '0D110Z9', '0D110ZA', '0D110ZB', '0D11874', '0D11876', '0D11879', '0D1187A', '0D1187B',
        '0D118J4', '0D118J6', '0D118J9', '0D118JA', '0D118JB', '0D118K4', '0D118K6', '0D118K9',
        '0D118KA', '0D118KB', '0D118Z4', '0D118Z6', '0D118Z9', '0D118ZA', '0D118ZB', '0D12074',
        '0D12076', '0D12079', '0D1207A', '0D1207B', '0D120J4', '0D120J6', '0D120J9', '0D120JA',
        '0D120JB', '0D120K4', '0D120K6', '0D120K9', '0D120KA', '0D120KB', '0D120Z4', '0D120Z6',
        '0D120Z9', '0D120ZA', '0D120ZB', '0D12874', '0D12876', '0D12879', '0D1287A', '0D1287B',
        '0D128J4', '0D128J6', '0D128J9', '0D128JA', '0D128JB', '0D128K4', '0D128K6', '0D128K9',
        '0D128KA', '0D128KB', '0D128Z4', '0D128Z6', '0D128Z9', '0D128ZA', '0D128ZB', '0D13074',
        '0D13076', '0D13079', '0D1307A', '0D1307B', '0D130J4', '0D130J6', '0D130J9', '0D130JA',
        '0D130JB', '0D130K4', '0D130K6', '0D130K9', '0D130KA', '0D130KB', '0D130Z4', '0D130Z6',
        '0D130Z9', '0D130ZA', '0D130ZB', '0D13874', '0D13876', '0D13879', '0D1387A', '0D1387B',
        '0D138J4', '0D138J6', '0D138J9', '0D138JA', '0D138JB', '0D138K4', '0D138K6', '0D138K9',
        '0D138KA', '0D138KB', '0D138Z4', '0D138Z6', '0D138Z9', '0D138ZA', '0D138ZB', '0D15074',
        '0D15076', '0D15079', '0D1507A', '0D1507B', '0D150J4', '0D150J6', '0D150J9', '0D150JA',
        '0D150JB', '0D150K4', '0D150K6', '0D150K9', '0D150KA', '0D150KB', '0D150Z4', '0D150Z6',
        '0D150Z9', '0D150ZA', '0D150ZB', '0D15874', '0D15876', '0D15879', '0D1587A', '0D1587B',
        '0D158J4', '0D158J6', '0D158J9', '0D158JA', '0D158JB', '0D158K4', '0D158K6', '0D158K9',
        '0D158KA', '0D158KB', '0D158Z4', '0D158Z6', '0D158Z9', '0D158ZA', '0D158ZB', '0D16074',
        '0D16079', '0D1607A', '0D1607B', '0D1607L', '0D160J4', '0D160J9', '0D160JA', '0D160JB',
        '0D160JL', '0D160K4', '0D160K9', '0D160KA', '0D160KB', '0D160KL', '0D160Z4', '0D160Z9',
        '0D160ZA', '0D160ZB', '0D160ZL', '0D16874', '0D16879', '0D1687A', '0D1687B', '0D1687L',
        '0D168J9', '0D168JA', '0D168JB', '0D168JL', '0D168K9', '0D168KA', '0D168KB', '0D168KL',
        '0D168Z9', '0D168ZA', '0D168ZB', '0D168ZL', '0D19074', '0D19079', '0D1907A', '0D1907B',
        '0D1907L', '0D190J4', '0D190J9', '0D190JA', '0D190JB', '0D190JL', '0D190K4', '0D190K9',
        '0D190KA', '0D190KB', '0D190KL', '0D190Z4', '0D190Z9', '0D190ZA', '0D190ZB', '0D190ZL',
        '0D19874', '0D19879', '0D1987A', '0D1987B', '0D1987L', '0D198J4', '0D198J9', '0D198JA',
        '0D198JB', '0D198JL', '0D198K4', '0D198K9', '0D198KA', '0D198KB', '0D198KL', '0D198Z4',
        '0D198Z9', '0D198ZA', '0D198ZB', '0D198ZL', '0D1A074', '0D1A07A', '0D1A07B', '0D1A07H',
        '0D1A07K', '0D1A07L', '0D1A07M', '0D1A07N', '0D1A07P', '0D1A07Q', '0D1A0J4', '0D1A0JA',
        '0D1A0JB', '0D1A0JH', '0D1A0JK', '0D1A0JL', '0D1A0JM', '0D1A0JN', '0D1A0JP', '0D1A0JQ',
        '0D1A0K4', '0D1A0KA', '0D1A0KB', '0D1A0KH', '0D1A0KK', '0D1A0KL', '0D1A0KM', '0D1A0KN',
        '0D1A0KP', '0D1A0KQ', '0D1A0Z4', '0D1A0ZA', '0D1A0ZB', '0D1A0ZH', '0D1A0ZK', '0D1A0ZL',
        '0D1A0ZM', '0D1A0ZN', '0D1A0ZP', '0D1A0ZQ', '0D1A874', '0D1A87A', '0D1A87B', '0D1A87H',
        '0D1A87K', '0D1A87L', '0D1A87M', '0D1A87N', '0D1A87P', '0D1A87Q', '0D1A8J4', '0D1A8JA',
        '0D1A8JB', '0D1A8JH', '0D1A8JK', '0D1A8JL', '0D1A8JM', '0D1A8JN', '0D1A8JP', '0D1A8JQ',
        '0D1A8K4', '0D1A8KA', '0D1A8KB', '0D1A8KH', '0D1A8KK', '0D1A8KL', '0D1A8KM', '0D1A8KN',
        '0D1A8KP', '0D1A8KQ', '0D1A8Z4', '0D1A8ZA', '0D1A8ZB', '0D1A8ZH', '0D1A8ZK', '0D1A8ZL',
        '0D1A8ZM', '0D1A8ZN', '0D1A8ZP', '0D1A8ZQ', '0D1B074', '0D1B07B', '0D1B07H', '0D1B07K',
        '0D1B07L', '0D1B07M', '0D1B07N', '0D1B07P', '0D1B07Q', '0D1B0J4', '0D1B0JB', '0D1B0JH',
        '0D1B0JK', '0D1B0JL', '0D1B0JM', '0D1B0JN', '0D1B0JP', '0D1B0JQ', '0D1B0K4', '0D1B0KB',
        '0D1B0KH', '0D1B0KK', '0D1B0KL', '0D1B0KM', '0D1B0KN', '0D1B0KP', '0D1B0KQ', '0D1B0Z4',
        '0D1B0ZB', '0D1B0ZH', '0D1B0ZK', '0D1B0ZL', '0D1B0ZM', '0D1B0ZN', '0D1B0ZP', '0D1B0ZQ',
        '0D1B874', '0D1B87B', '0D1B87H', '0D1B87K', '0D1B87L', '0D1B87M', '0D1B87N', '0D1B87P',
        '0D1B87Q', '0D1B8J4', '0D1B8JB', '0D1B8JH', '0D1B8JK', '0D1B8JL', '0D1B8JM', '0D1B8JN',
        '0D1B8JP', '0D1B8JQ', '0D1B8K4', '0D1B8KB', '0D1B8KH', '0D1B8KK', '0D1B8KL', '0D1B8KM',
        '0D1B8KN', '0D1B8KP', '0D1B8KQ', '0D1B8Z4', '0D1B8ZB', '0D1B8ZH', '0D1B8ZK', '0D1B8ZL',
        '0D1B8ZM', '0D1B8ZN', '0D1B8ZP', '0D1B8ZQ', '0D1H074', '0D1H07H', '0D1H07K', '0D1H07L',
        '0D1H07M', '0D1H07N', '0D1H07P', '0D1H0J4', '0D1H0JH', '0D1H0JK', '0D1H0JL', '0D1H0JM',
        '0D1H0JN', '0D1H0JP', '0D1H0K4', '0D1H0KH', '0D1H0KK', '0D1H0KL', '0D1H0KM', '0D1H0KN',
        '0D1H0KP', '0D1H0Z4', '0D1H0ZH', '0D1H0ZK', '0D1H0ZL', '0D1H0ZM', '0D1H0ZN', '0D1H0ZP',
        '0D1H874', '0D1H87H', '0D1H87K', '0D1H87L', '0D1H87M', '0D1H87N', '0D1H87P', '0D1H8J4',
        '0D1H8JH', '0D1H8JK', '0D1H8JL', '0D1H8JM', '0D1H8JN', '0D1H8JP', '0D1H8K4', '0D1H8KH',
        '0D1H8KK', '0D1H8KL', '0D1H8KM', '0D1H8KN', '0D1H8KP', '0D1H8Z4', '0D1H8ZH', '0D1H8ZK',
        '0D1H8ZL', '0D1H8ZM', '0D1H8ZN', '0D1H8ZP', '0D1K074', '0D1K07K', '0D1K07L', '0D1K07M',
        '0D1K07N', '0D1K07P', '0D1K0J4', '0D1K0JK', '0D1K0JL', '0D1K0JM', '0D1K0JN', '0D1K0JP',
        '0D1K0K4', '0D1K0KK', '0D1K0KL', '0D1K0KM', '0D1K0KN', '0D1K0KP', '0D1K0Z4', '0D1K0ZK',
        '0D1K0ZL', '0D1K0ZM', '0D1K0ZN', '0D1K0ZP', '0D1K874', '0D1K87K', '0D1K87L', '0D1K87M',
        '0D1K87N', '0D1K87P', '0D1K8J4', '0D1K8JK', '0D1K8JL', '0D1K8JM', '0D1K8JN', '0D1K8JP',
        '0D1K8K4', '0D1K8KK', '0D1K8KL', '0D1K8KM', '0D1K8KN', '0D1K8KP', '0D1K8Z4', '0D1K8ZK',
        '0D1K8ZL', '0D1K8ZM', '0D1K8ZN', '0D1K8ZP', '0D1L074', '0D1L07L', '0D1L07M', '0D1L07N',
        '0D1L07P', '0D1L0J4', '0D1L0JL', '0D1L0JM', '0D1L0JN', '0D1L0JP', '0D1L0K4', '0D1L0KL',
        '0D1L0KM', '0D1L0KN', '0D1L0KP', '0D1L0Z4', '0D1L0ZL', '0D1L0ZM', '0D1L0ZN', '0D1L0ZP',
        '0D1L874', '0D1L87L', '0D1L87M', '0D1L87N', '0D1L87P', '0D1L8J4', '0D1L8JL', '0D1L8JM',
        '0D1L8JN', '0D1L8JP', '0D1L8K4', '0D1L8KL', '0D1L8KM', '0D1L8KN', '0D1L8KP', '0D1L8Z4',
        '0D1L8ZL', '0D1L8ZM', '0D1L8ZN', '0D1L8ZP', '0D1M074', '0D1M07M', '0D1M07N', '0D1M07P',
        '0D1M0J4', '0D1M0JM', '0D1M0JN', '0D1M0JP', '0D1M0K4', '0D1M0KM', '0D1M0KN', '0D1M0KP',
        '0D1M0Z4', '0D1M0ZM', '0D1M0ZN', '0D1M0ZP', '0D1M874', '0D1M87M', '0D1M87N', '0D1M87P',
        '0D1M8J4', '0D1M8JM', '0D1M8JN', '0D1M8JP', '0D1M8K4', '0D1M8KM', '0D1M8KN', '0D1M8KP',
        '0D1M8Z4', '0D1M8ZM', '0D1M8ZN', '0D1M8ZP', '0D1N074', '0D1N07N', '0D1N07P', '0D1N0J4',
        '0D1N0JN', '0D1N0JP', '0D1N0K4', '0D1N0KN', '0D1N0KP', '0D1N0Z4', '0D1N0ZN', '0D1N0ZP',
        '0D1N874', '0D1N87N', '0D1N87P', '0D1N8J4', '0D1N8JN', '0D1N8JP', '0D1N8K4', '0D1N8KN',
        '0D1N8KP', '0D1N8Z4', '0D1N8ZN', '0D1N8ZP', '0D590ZZ', '0D597ZZ', '0D5E0ZZ', '0D5E7ZZ',
        '0D5F0ZZ', '0D5F7ZZ', '0D5G0ZZ', '0D5G7ZZ', '0D5H0ZZ', '0D5H7ZZ', '0D5K0ZZ', '0D5K7ZZ',
        '0D5L0ZZ', '0D5L7ZZ', '0D5M0ZZ', '0D5M7ZZ', '0D5N0ZZ', '0D5N7ZZ', '0D710DZ', '0D710ZZ',
        '0D720DZ', '0D720ZZ', '0D730DZ', '0D730ZZ', '0D740DZ', '0D740ZZ', '0D750DZ', '0D750ZZ',
        '0D760DZ', '0D760ZZ', '0D767DZ', '0D767ZZ', '0D768DZ', '0D768ZZ', '0D770DZ', '0D770ZZ',
        '0D777DZ', '0D777ZZ', '0D840ZZ', '0D847ZZ', '0D848ZZ', '0D9100Z', '0D910ZZ', '0D9170Z',
        '0D917ZZ', '0D9180Z', '0D918ZZ', '0D9200Z', '0D920ZZ', '0D9270Z', '0D927ZZ', '0D9280Z',
        '0D928ZZ', '0D9300Z', '0D930ZZ', '0D9370Z', '0D937ZZ', '0D9380Z', '0D938ZZ', '0D9400Z',
        '0D940ZZ', '0D9470Z', '0D947ZZ', '0D9480Z', '0D948ZZ', '0D9500Z', '0D950ZZ', '0D9570Z',
        '0D957ZZ', '0D9580Z', '0D958ZZ', '0D9600Z', '0D960ZZ', '0D967ZZ', '0D968ZZ', '0D9700Z',
        '0D970ZZ', '0D977ZZ', '0D978ZZ', '0D9800Z', '0D980ZZ', '0D987ZZ', '0D988ZZ', '0D9900Z',
        '0D990ZZ', '0D997ZZ', '0D998ZZ', '0D9A00Z', '0D9A0ZZ', '0D9A7ZZ', '0D9A8ZZ', '0D9B00Z',
        '0D9B0ZZ', '0D9B7ZZ', '0D9B8ZZ', '0D9C00Z', '0D9C0ZZ', '0D9C70Z', '0D9C7ZZ', '0D9C80Z',
        '0D9C8ZZ', '0D9E00Z', '0D9E0ZZ', '0D9E7ZZ', '0D9E8ZZ', '0D9F00Z', '0D9F0ZZ', '0D9F70Z',
        '0D9F7ZZ', '0D9F8ZZ', '0D9G00Z', '0D9G0ZZ', '0D9G7ZZ', '0D9G8ZZ', '0D9H00Z', '0D9H0ZZ',
        '0D9H7ZZ', '0D9H8ZZ', '0D9J00Z', '0D9J0ZZ', '0D9J70Z', '0D9J7ZZ', '0D9J80Z', '0D9J8ZZ',
        '0D9K00Z', '0D9K0ZZ', '0D9K7ZZ', '0D9K8ZZ', '0D9L00Z', '0D9L0ZZ', '0D9L7ZZ', '0D9L8ZZ',
        '0D9M00Z', '0D9M0ZZ', '0D9M7ZZ', '0D9M8ZZ', '0D9N00Z', '0D9N0ZZ', '0D9N7ZZ', '0D9N8ZZ',
        '0D9P00Z', '0D9P0ZZ', '0D9P7ZZ', '0D9P8ZZ', '0D9S00Z', '0D9S0ZZ', '0D9T00Z', '0D9T0ZZ',
        '0D9V00Z', '0D9V0ZZ', '0D9W00Z', '0D9W0ZZ', '0DB10ZZ', '0DB17ZZ', '0DB20ZZ', '0DB27ZZ',
        '0DB30ZZ', '0DB37ZZ', '0DB40ZZ', '0DB47ZZ', '0DB50ZZ', '0DB57ZZ', '0DB60Z3', '0DB60ZZ',
        '0DB67Z3', '0DB67ZZ', '0DB68Z3', '0DB68ZZ', '0DB80ZZ', '0DB87ZZ', '0DB88ZZ', '0DB90ZZ',
        '0DB97ZZ', '0DBA0ZZ', '0DBA7ZZ', '0DBA8ZZ', '0DBB0ZZ', '0DBB7ZZ', '0DBB8ZZ', '0DBC0ZZ',
        '0DBC7ZZ', '0DBC8ZZ', '0DBE0ZZ', '0DBE7ZZ', '0DBE8ZZ', '0DBF0ZZ', '0DBF7ZZ', '0DBF8ZZ',
        '0DBG0ZZ', '0DBG7ZZ', '0DBG8ZZ', '0DBH0ZZ', '0DBH7ZZ', '0DBH8ZZ', '0DBK0ZZ', '0DBK7ZZ',
        '0DBK8ZZ', '0DBL0ZZ', '0DBL7ZZ', '0DBL8ZZ', '0DBM0ZZ', '0DBM7ZZ', '0DBM8ZZ', '0DBN0ZZ',
        '0DBN7ZZ', '0DBN8ZZ', '0DBP0ZZ', '0DBP7ZZ', '0DBP8ZZ', '0DC10ZZ', '0DC20ZZ', '0DC30ZZ',
        '0DC40ZZ', '0DC50ZZ', '0DC80ZZ', '0DC90ZZ', '0DCA0ZZ', '0DCB0ZZ', '0DCC0ZZ', '0DCE0ZZ',
        '0DCF0ZZ', '0DCG0ZZ', '0DCH0ZZ', '0DCK0ZZ', '0DCL0ZZ', '0DCM0ZZ', '0DCN0ZZ', '0DCP0ZZ',
        '0DCS0ZZ', '0DCT0ZZ', '0DCV0ZZ', '0DCW0ZZ', '0DF50ZZ', '0DF57ZZ', '0DF58ZZ', '0DF60ZZ',
        '0DF67ZZ', '0DF68ZZ', '0DF80ZZ', '0DF87ZZ', '0DF88ZZ', '0DF90ZZ', '0DF97ZZ', '0DF98ZZ',
        '0DFA0ZZ', '0DFA7ZZ', '0DFA8ZZ', '0DFB0ZZ', '0DFB7ZZ', '0DFB8ZZ', '0DFE0ZZ', '0DFE7ZZ',
        '0DFE8ZZ', '0DFF0ZZ', '0DFF7ZZ', '0DFF8ZZ', '0DFG0ZZ', '0DFG7ZZ', '0DFG8ZZ', '0DFH0ZZ',
        '0DFH7ZZ', '0DFH8ZZ', '0DFK0ZZ', '0DFK7ZZ', '0DFK8ZZ', '0DFL0ZZ', '0DFL7ZZ', '0DFL8ZZ',
        '0DFM0ZZ', '0DFM7ZZ', '0DFM8ZZ', '0DFN0ZZ', '0DFN7ZZ', '0DFN8ZZ', '0DH502Z', '0DH503Z',
        '0DH572Z', '0DH573Z', '0DH582Z', '0DH583Z', '0DH60DZ', '0DH67DZ', '0DH68DZ', '0DH802Z',
        '0DH803Z', '0DH872Z', '0DH873Z', '0DH882Z', '0DH883Z', '0DH902Z', '0DH903Z', '0DH972Z',
        '0DH973Z', '0DH982Z', '0DH983Z', '0DHA02Z', '0DHA03Z', '0DHA72Z', '0DHA73Z', '0DHA82Z',
        '0DHA83Z', '0DHB02Z', '0DHB03Z', '0DHB72Z', '0DHB73Z', '0DHB82Z', '0DHB83Z', '0DJ00ZZ',
        '0DJ60ZZ', '0DJD0ZZ', '0DJU0ZZ', '0DJV0ZZ', '0DJW0ZZ', '0DL60CZ', '0DL60DZ', '0DL60ZZ',
        '0DL67DZ', '0DL67ZZ', '0DL68DZ', '0DL68ZZ', '0DL70CZ', '0DL70DZ', '0DL70ZZ', '0DL77DZ',
        '0DL77ZZ', '0DL78DZ', '0DL78ZZ', '0DM50ZZ', '0DM60ZZ', '0DM80ZZ', '0DM90ZZ', '0DMA0ZZ',
        '0DMB0ZZ', '0DME0ZZ', '0DMF0ZZ', '0DMG0ZZ', '0DMH0ZZ', '0DMK0ZZ', '0DML0ZZ', '0DMM0ZZ',
        '0DMN0ZZ', '0DMP0ZZ', '0DN10ZZ', '0DN17ZZ', '0DN18ZZ', '0DN20ZZ', '0DN27ZZ', '0DN28ZZ',
        '0DN30ZZ', '0DN37ZZ', '0DN38ZZ', '0DN40ZZ', '0DN47ZZ', '0DN48ZZ', '0DN50ZZ', '0DN57ZZ',
        '0DN58ZZ', '0DN60ZZ', '0DN67ZZ', '0DN68ZZ', '0DN70ZZ', '0DN77ZZ', '0DN78ZZ', '0DN80ZZ',
        '0DN90ZZ', '0DNA0ZZ', '0DNB0ZZ', '0DNC0ZZ', '0DNC7ZZ', '0DNC8ZZ', '0DNE0ZZ', '0DNF0ZZ',
        '0DNG0ZZ', '0DNH0ZZ', '0DNJ0ZZ', '0DNK0ZZ', '0DNL0ZZ', '0DNM0ZZ', '0DNN0ZZ', '0DNS0ZZ',
        '0DNT0ZZ', '0DNV0ZZ', '0DNW0ZZ', '0DP000Z', '0DP002Z', '0DP003Z', '0DP007Z', '0DP00CZ',
        '0DP00DZ', '0DP00JZ', '0DP00KZ', '0DP00UZ', '0DP070Z', '0DP072Z', '0DP073Z', '0DP077Z',
        '0DP07CZ', '0DP07DZ', '0DP07JZ', '0DP07KZ', '0DP07UZ', '0DP080Z', '0DP082Z', '0DP083Z',
        '0DP087Z', '0DP08CZ', '0DP08DZ', '0DP08JZ', '0DP08KZ', '0DP08UZ', '0DP501Z', '0DP502Z',
        '0DP503Z', '0DP50UZ', '0DP57DZ', '0DP58DZ', '0DP600Z', '0DP602Z', '0DP603Z', '0DP607Z',
        '0DP60CZ', '0DP60DZ', '0DP60JZ', '0DP60KZ', '0DP60MZ', '0DP60UZ', '0DP670Z', '0DP672Z',
        '0DP673Z', '0DP677Z', '0DP67CZ', '0DP67JZ', '0DP67KZ', '0DP67UZ', '0DP680Z', '0DP682Z',
        '0DP683Z', '0DP687Z', '0DP68CZ', '0DP68JZ', '0DP68KZ', '0DP68UZ', '0DPD00Z', '0DPD02Z',
        '0DPD03Z', '0DPD07Z', '0DPD0CZ', '0DPD0DZ', '0DPD0JZ', '0DPD0KZ', '0DPD0UZ', '0DPD70Z',
        '0DPD72Z', '0DPD73Z', '0DPD77Z', '0DPD7CZ', '0DPD7DZ', '0DPD7JZ', '0DPD7KZ', '0DPD7UZ',
        '0DPD80Z', '0DPD82Z', '0DPD83Z', '0DPD87Z', '0DPD8CZ', '0DPD8DZ', '0DPD8JZ', '0DPD8KZ',
        '0DPD8UZ', '0DPP01Z', '0DPU00Z', '0DPU01Z', '0DPU07Z', '0DPU0JZ', '0DPU0KZ', '0DPV00Z',
        '0DPV01Z', '0DPV07Z', '0DPV0JZ', '0DPV0KZ', '0DPW00Z', '0DPW01Z', '0DPW07Z', '0DPW0JZ',
        '0DPW0KZ', '0DQ10ZZ', '0DQ17ZZ', '0DQ18ZZ', '0DQ20ZZ', '0DQ27ZZ', '0DQ28ZZ', '0DQ30ZZ',
        '0DQ37ZZ', '0DQ38ZZ', '0DQ40ZZ', '0DQ47ZZ', '0DQ48ZZ', '0DQ50ZZ', '0DQ57ZZ', '0DQ58ZZ',
        '0DQ60ZZ', '0DQ67ZZ', '0DQ68ZZ', '0DQ70ZZ', '0DQ77ZZ', '0DQ78ZZ', '0DQ80ZZ', '0DQ87ZZ',
        '0DQ88ZZ', '0DQ90ZZ', '0DQ97ZZ', '0DQ98ZZ', '0DQA0ZZ', '0DQA7ZZ', '0DQA8ZZ', '0DQB0ZZ',
        '0DQB7ZZ', '0DQB8ZZ', '0DQC0ZZ', '0DQC7ZZ', '0DQC8ZZ', '0DQE0ZZ', '0DQE7ZZ', '0DQE8ZZ',
        '0DQF0ZZ', '0DQF7ZZ', '0DQF8ZZ', '0DQG0ZZ', '0DQG7ZZ', '0DQG8ZZ', '0DQH0ZZ', '0DQH7ZZ',
        '0DQH8ZZ', '0DQK0ZZ', '0DQK7ZZ', '0DQK8ZZ', '0DQL0ZZ', '0DQL7ZZ', '0DQL8ZZ', '0DQM0ZZ',
        '0DQM7ZZ', '0DQM8ZZ', '0DQN0ZZ', '0DQN7ZZ', '0DQN8ZZ', '0DQS0ZZ', '0DQT0ZZ', '0DQV0ZZ',
        '0DQW0ZZ', '0DR507Z', '0DR50JZ', '0DR50KZ', '0DR577Z', '0DR57JZ', '0DR57KZ', '0DR587Z',
        '0DR58JZ', '0DR58KZ', '0DRS07Z', '0DRS0JZ', '0DRS0KZ', '0DRT07Z', '0DRT0JZ', '0DRT0KZ',
        '0DRV07Z', '0DRV0JZ', '0DRV0KZ', '0DRW07Z', '0DRW0JZ', '0DRW0KZ', '0DS50ZZ', '0DS57ZZ',
        '0DS58ZZ', '0DS5XZZ', '0DS60ZZ', '0DS67ZZ', '0DS68ZZ', '0DS6XZZ', '0DS90ZZ', '0DS97ZZ',
        '0DS98ZZ', '0DSA0ZZ', '0DSA7ZZ', '0DSA8ZZ', '0DSB0ZZ', '0DSB7ZZ', '0DSB8ZZ', '0DSH0ZZ',
        '0DSH7ZZ', '0DSH8ZZ', '0DSK0ZZ', '0DSK7ZZ', '0DSK8ZZ', '0DSL0ZZ', '0DSL7ZZ', '0DSL8ZZ',
        '0DSM0ZZ', '0DSM7ZZ', '0DSM8ZZ', '0DSN0ZZ', '0DSN7ZZ', '0DSN8ZZ', '0DSP0ZZ', '0DSP7ZZ',
        '0DSP8ZZ', '0DT10ZZ', '0DT17ZZ', '0DT18ZZ', '0DT20ZZ', '0DT27ZZ', '0DT28ZZ', '0DT30ZZ',
        '0DT37ZZ', '0DT38ZZ', '0DT40ZZ', '0DT47ZZ', '0DT48ZZ', '0DT50ZZ', '0DT57ZZ', '0DT58ZZ',
        '0DT60ZZ', '0DT67ZZ', '0DT68ZZ', '0DT70ZZ', '0DT77ZZ', '0DT78ZZ', '0DT80ZZ', '0DT87ZZ',
        '0DT88ZZ', '0DT90ZZ', '0DT97ZZ', '0DT98ZZ', '0DTA0ZZ', '0DTA7ZZ', '0DTA8ZZ', '0DTB0ZZ',
        '0DTB7ZZ', '0DTB8ZZ', '0DTC0ZZ', '0DTC7ZZ', '0DTC8ZZ', '0DTE0ZZ', '0DTE7ZZ', '0DTE8ZZ',
        '0DTF0ZZ', '0DTF7ZZ', '0DTF8ZZ', '0DTG0ZZ', '0DTG7ZZ', '0DTG8ZZ', '0DTH0ZZ', '0DTH7ZZ',
        '0DTH8ZZ', '0DTK0ZZ', '0DTK7ZZ', '0DTK8ZZ', '0DTL0ZZ', '0DTL7ZZ', '0DTL8ZZ', '0DTM0ZZ',
        '0DTM7ZZ', '0DTM8ZZ', '0DTN0ZZ', '0DTN7ZZ', '0DTN8ZZ', '0DTP0ZZ', '0DTP7ZZ', '0DTP8ZZ',
        '0DU107Z', '0DU10JZ', '0DU10KZ', '0DU177Z', '0DU17JZ', '0DU17KZ', '0DU187Z', '0DU18JZ',
        '0DU18KZ', '0DU207Z', '0DU20JZ', '0DU20KZ', '0DU277Z', '0DU27JZ', '0DU27KZ', '0DU287Z',
        '0DU28JZ', '0DU28KZ', '0DU307Z', '0DU30JZ', '0DU30KZ', '0DU377Z', '0DU37JZ', '0DU37KZ',
        '0DU387Z', '0DU38JZ', '0DU38KZ', '0DU407Z', '0DU40JZ', '0DU40KZ', '0DU477Z', '0DU47JZ',
        '0DU47KZ', '0DU487Z', '0DU48JZ', '0DU48KZ', '0DU507Z', '0DU50JZ', '0DU50KZ', '0DU577Z',
        '0DU57JZ', '0DU57KZ', '0DU587Z', '0DU58JZ', '0DU58KZ', '0DU607Z', '0DU60JZ', '0DU60KZ',
        '0DU677Z', '0DU67JZ', '0DU67KZ', '0DU687Z', '0DU68JZ', '0DU68KZ', '0DU707Z', '0DU70JZ',
        '0DU70KZ', '0DU777Z', '0DU77JZ', '0DU77KZ', '0DU787Z', '0DU78JZ', '0DU78KZ', '0DU807Z',
        '0DU80JZ', '0DU80KZ', '0DU877Z', '0DU87JZ', '0DU87KZ', '0DU887Z', '0DU88JZ', '0DU88KZ',
        '0DU907Z', '0DU90JZ', '0DU90KZ', '0DU977Z', '0DU97JZ', '0DU97KZ', '0DU987Z', '0DU98JZ',
        '0DU98KZ', '0DUA07Z', '0DUA0JZ', '0DUA0KZ', '0DUA77Z', '0DUA7JZ', '0DUA7KZ', '0DUA87Z',
        '0DUA8JZ', '0DUA8KZ', '0DUB07Z', '0DUB0JZ', '0DUB0KZ', '0DUB77Z', '0DUB7JZ', '0DUB7KZ',
        '0DUB87Z', '0DUB8JZ', '0DUB8KZ', '0DUC07Z', '0DUC0JZ', '0DUC0KZ', '0DUC77Z', '0DUC7JZ',
        '0DUC7KZ', '0DUC87Z', '0DUC8JZ', '0DUC8KZ', '0DUE07Z', '0DUE0JZ', '0DUE0KZ', '0DUE77Z',
        '0DUE7JZ', '0DUE7KZ', '0DUE87Z', '0DUE8JZ', '0DUE8KZ', '0DUF07Z', '0DUF0JZ', '0DUF0KZ',
        '0DUF77Z', '0DUF7JZ', '0DUF7KZ', '0DUF87Z', '0DUF8JZ', '0DUF8KZ', '0DUG07Z', '0DUG0JZ',
        '0DUG0KZ', '0DUG77Z', '0DUG7JZ', '0DUG7KZ', '0DUG87Z', '0DUG8JZ', '0DUG8KZ', '0DUH07Z',
        '0DUH0JZ', '0DUH0KZ', '0DUH77Z', '0DUH7JZ', '0DUH7KZ', '0DUH87Z', '0DUH8JZ', '0DUH8KZ',
        '0DUK07Z', '0DUK0JZ', '0DUK0KZ', '0DUK77Z', '0DUK7JZ', '0DUK7KZ', '0DUK87Z', '0DUK8JZ',
        '0DUK8KZ', '0DUL07Z', '0DUL0JZ', '0DUL0KZ', '0DUL77Z', '0DUL7JZ', '0DUL7KZ', '0DUL87Z',
        '0DUL8JZ', '0DUL8KZ', '0DUM07Z', '0DUM0JZ', '0DUM0KZ', '0DUM77Z', '0DUM7JZ', '0DUM7KZ',
        '0DUM87Z', '0DUM8JZ', '0DUM8KZ', '0DUN07Z', '0DUN0JZ', '0DUN0KZ', '0DUN77Z', '0DUN7JZ',
        '0DUN7KZ', '0DUN87Z', '0DUN8JZ', '0DUN8KZ', '0DUS07Z', '0DUS0JZ', '0DUS0KZ', '0DUT07Z',
        '0DUT0JZ', '0DUT0KZ', '0DUV07Z', '0DUV0JZ', '0DUV0KZ', '0DUW07Z', '0DUW0JZ', '0DUW0KZ',
        '0DV10CZ', '0DV10DZ', '0DV10ZZ', '0DV17DZ', '0DV17ZZ', '0DV18DZ', '0DV18ZZ', '0DV20CZ',
        '0DV20DZ', '0DV20ZZ', '0DV27DZ', '0DV27ZZ', '0DV28DZ', '0DV28ZZ', '0DV30CZ', '0DV30DZ',
        '0DV30ZZ', '0DV37DZ', '0DV37ZZ', '0DV38DZ', '0DV38ZZ', '0DV40CZ', '0DV40DZ', '0DV40ZZ',
        '0DV47DZ', '0DV47ZZ', '0DV48DZ', '0DV48ZZ', '0DV50CZ', '0DV50DZ', '0DV50ZZ', '0DV57DZ',
        '0DV57ZZ', '0DV58DZ', '0DV58ZZ', '0DV60CZ', '0DV60DZ', '0DV60ZZ', '0DV67ZZ', '0DV68ZZ',
        '0DV70CZ', '0DV70DZ', '0DV70ZZ', '0DV77DZ', '0DV77ZZ', '0DV78DZ', '0DV78ZZ', '0DV80CZ',
        '0DV80DZ', '0DV80ZZ', '0DV87DZ', '0DV87ZZ', '0DV88DZ', '0DV88ZZ', '0DV90CZ', '0DV90DZ',
        '0DV90ZZ', '0DV97DZ', '0DV97ZZ', '0DV98DZ', '0DV98ZZ', '0DVA0CZ', '0DVA0DZ', '0DVA0ZZ',
        '0DVA7DZ', '0DVA7ZZ', '0DVA8DZ', '0DVA8ZZ', '0DVB0CZ', '0DVB0DZ', '0DVB0ZZ', '0DVB7DZ',
        '0DVB7ZZ', '0DVB8DZ', '0DVB8ZZ', '0DVC0CZ', '0DVC0DZ', '0DVC0ZZ', '0DVC7DZ', '0DVC7ZZ',
        '0DVC8DZ', '0DVC8ZZ', '0DVE0CZ', '0DVE0DZ', '0DVE0ZZ', '0DVE7DZ', '0DVE7ZZ', '0DVE8DZ',
        '0DVE8ZZ', '0DVF0CZ', '0DVF0DZ', '0DVF0ZZ', '0DVF7DZ', '0DVF7ZZ', '0DVF8DZ', '0DVF8ZZ',
        '0DVG0CZ', '0DVG0DZ', '0DVG0ZZ', '0DVG7DZ', '0DVG7ZZ', '0DVG8DZ', '0DVG8ZZ', '0DVH0CZ',
        '0DVH0DZ', '0DVH0ZZ', '0DVH7DZ', '0DVH7ZZ', '0DVH8DZ', '0DVH8ZZ', '0DVK0CZ', '0DVK0DZ',
        '0DVK0ZZ', '0DVK7DZ', '0DVK7ZZ', '0DVK8DZ', '0DVK8ZZ', '0DVL0CZ', '0DVL0DZ', '0DVL0ZZ',
        '0DVL7DZ', '0DVL7ZZ', '0DVL8DZ', '0DVL8ZZ', '0DVM0CZ', '0DVM0DZ', '0DVM0ZZ', '0DVM7DZ',
        '0DVM7ZZ', '0DVM8DZ', '0DVM8ZZ', '0DVN0CZ', '0DVN0DZ', '0DVN0ZZ', '0DVN7DZ', '0DVN7ZZ',
        '0DVN8DZ', '0DVN8ZZ', '0DW000Z', '0DW002Z', '0DW003Z', '0DW007Z', '0DW00CZ', '0DW00DZ',
        '0DW00JZ', '0DW00KZ', '0DW00UZ', '0DW070Z', '0DW072Z', '0DW073Z', '0DW077Z', '0DW07CZ',
        '0DW07DZ', '0DW07JZ', '0DW07KZ', '0DW07UZ', '0DW080Z', '0DW082Z', '0DW083Z', '0DW087Z',
        '0DW08CZ', '0DW08DZ', '0DW08JZ', '0DW08KZ', '0DW08UZ', '0DW57DZ', '0DW58DZ', '0DW600Z',
        '0DW602Z', '0DW603Z', '0DW607Z', '0DW60CZ', '0DW60DZ', '0DW60JZ', '0DW60KZ', '0DW60MZ',
        '0DW60UZ', '0DW670Z', '0DW672Z', '0DW673Z', '0DW677Z', '0DW67CZ', '0DW67DZ', '0DW67JZ',
        '0DW67KZ', '0DW67UZ', '0DW680Z', '0DW682Z', '0DW683Z', '0DW687Z', '0DW68CZ', '0DW68DZ',
        '0DW68JZ', '0DW68KZ', '0DW68UZ', '0DW807Z', '0DW80JZ', '0DW80KZ', '0DW877Z', '0DW87JZ',
        '0DW87KZ', '0DW887Z', '0DW88JZ', '0DW88KZ', '0DWD00Z', '0DWD02Z', '0DWD03Z', '0DWD07Z',
        '0DWD0CZ', '0DWD0DZ', '0DWD0JZ', '0DWD0KZ', '0DWD0UZ', '0DWD70Z', '0DWD72Z', '0DWD73Z',
        '0DWD77Z', '0DWD7CZ', '0DWD7DZ', '0DWD7JZ', '0DWD7KZ', '0DWD7UZ', '0DWD80Z', '0DWD82Z',
        '0DWD83Z', '0DWD87Z', '0DWD8CZ', '0DWD8DZ', '0DWD8JZ', '0DWD8KZ', '0DWD8UZ', '0DWE07Z',
        '0DWE0JZ', '0DWE0KZ', '0DWE77Z', '0DWE7JZ', '0DWE7KZ', '0DWE87Z', '0DWE8JZ', '0DWE8KZ',
        '0DWU07Z', '0DWU0JZ', '0DWU0KZ', '0DWV07Z', '0DWV0JZ', '0DWV0KZ', '0DWW00Z', '0DWW07Z',
        '0DWW0JZ', '0DWW0KZ', '0DX60Z5', '0DX80Z5', '0DXE0Z5', '0DY60Z0', '0DY60Z1', '0DY60Z2',
        '0F140D3', '0F140D4', '0F140D5', '0F140D6', '0F140D7', '0F140D8', '0F140D9', '0F140DB',
        '0F140Z3', '0F140Z4', '0F140Z5', '0F140Z6', '0F140Z7', '0F140Z8', '0F140Z9', '0F140ZB',
        '0F150D3', '0F150D4', '0F150D5', '0F150D6', '0F150D7', '0F150D8', '0F150D9', '0F150DB',
        '0F150Z3', '0F150Z4', '0F150Z5', '0F150Z6', '0F150Z7', '0F150Z8', '0F150Z9', '0F150ZB',
        '0F160D3', '0F160D4', '0F160D5', '0F160D6', '0F160D7', '0F160D8', '0F160D9', '0F160DB',
        '0F160Z3', '0F160Z4', '0F160Z5', '0F160Z6', '0F160Z7', '0F160Z8', '0F160Z9', '0F160ZB',
        '0F180D3', '0F180D4', '0F180D5', '0F180D6', '0F180D7', '0F180D8', '0F180D9', '0F180DB',
        '0F180Z3', '0F180Z4', '0F180Z5', '0F180Z6', '0F180Z7', '0F180Z8', '0F180Z9', '0F180ZB',
        '0F190D3', '0F190D4', '0F190D5', '0F190D6', '0F190D7', '0F190D8', '0F190D9', '0F190DB',
        '0F190Z3', '0F190Z4', '0F190Z5', '0F190Z6', '0F190Z7', '0F190Z8', '0F190Z9', '0F190ZB',
        '0F1D0D3', '0F1D0DB', '0F1D0DC', '0F1D0Z3', '0F1D0ZB', '0F1D0ZC', '0F1F0D3', '0F1F0DB',
        '0F1F0DC', '0F1F0Z3', '0F1F0ZB', '0F1F0ZC', '0F1G0D3', '0F1G0DB', '0F1G0DC', '0F1G0Z3',
        '0F1G0ZB', '0F1G0ZC', '0F500ZZ', '0F510ZZ', '0F520ZZ', '0F550ZZ', '0F557ZZ', '0F560ZZ',
        '0F567ZZ', '0F580ZZ', '0F587ZZ', '0F590ZZ', '0F597ZZ', '0F5C0ZZ', '0F5C7ZZ', '0F5D0ZZ',
        '0F5D7ZZ', '0F5F0ZZ', '0F5F7ZZ', '0F5G0ZZ', '0F750DZ', '0F750ZZ', '0F757DZ', '0F757ZZ',
        '0F760DZ', '0F760ZZ', '0F767DZ', '0F767ZZ', '0F780DZ', '0F780ZZ', '0F787DZ', '0F787ZZ',
        '0F790DZ', '0F790ZZ', '0F797DZ', '0F797ZZ', '0F7C0DZ', '0F7C0ZZ', '0F7C7DZ', '0F7C7ZZ',
        '0F7D0DZ', '0F7D0ZZ', '0F7D7DZ', '0F7D7ZZ', '0F7F0DZ', '0F7F0ZZ', '0F7F7DZ', '0F7F7ZZ',
        '0F8G0ZZ', '0F9000Z', '0F900ZZ', '0F9100Z', '0F910ZZ', '0F9200Z', '0F920ZZ', '0F9500Z',
        '0F950ZZ', '0F9570Z', '0F957ZZ', '0F9580Z', '0F958ZZ', '0F9600Z', '0F960ZZ', '0F9670Z',
        '0F967ZZ', '0F9680Z', '0F968ZZ', '0F9800Z', '0F980ZZ', '0F9870Z', '0F987ZZ', '0F9880Z',
        '0F988ZZ', '0F9900Z', '0F990ZZ', '0F9C00Z', '0F9C0ZZ', '0F9C70Z', '0F9C7ZZ', '0F9D0ZZ',
        '0F9D7ZZ', '0F9D8ZZ', '0F9F0ZZ', '0F9F7ZZ', '0F9F8ZZ', '0F9G0ZZ', '0FB00ZZ', '0FB10ZZ',
        '0FB20ZZ', '0FB50ZZ', '0FB57ZZ', '0FB60ZZ', '0FB67ZZ', '0FB80ZZ', '0FB87ZZ', '0FB90ZZ',
        '0FB97ZZ', '0FBC0ZZ', '0FBC7ZZ', '0FBD0ZZ', '0FBD7ZZ', '0FBF0ZZ', '0FBF7ZZ', '0FBG0ZZ',
        '0FC00ZZ', '0FC10ZZ', '0FC20ZZ', '0FC50ZZ', '0FC60ZZ', '0FC80ZZ', '0FC90ZZ', '0FCC0ZZ',
        '0FCC7ZZ', '0FCD0ZZ', '0FCD7ZZ', '0FCF0ZZ', '0FCF7ZZ', '0FCG0ZZ', '0FF50ZZ', '0FF57ZZ',
        '0FF60ZZ', '0FF67ZZ', '0FF80ZZ', '0FF87ZZ', '0FF90ZZ', '0FF97ZZ', '0FFC0ZZ', '0FFC7ZZ',
        '0FFD0ZZ', '0FFD7ZZ', '0FFD8ZZ', '0FFF0ZZ', '0FFF7ZZ', '0FFF8ZZ', '0FH002Z', '0FH102Z',
        '0FH202Z', '0FHB02Z', '0FHB0DZ', '0FHB72Z', '0FHB7DZ', '0FHB82Z', '0FHD02Z', '0FHD0DZ',
        '0FHD72Z', '0FHD7DZ', '0FHD82Z', '0FHG02Z', '0FJ00ZZ', '0FJB0ZZ', '0FJB7ZZ', '0FJB8ZZ',
        '0FL50CZ', '0FL50DZ', '0FL50ZZ', '0FL60CZ', '0FL60DZ', '0FL60ZZ', '0FL80CZ', '0FL80DZ',
        '0FL80ZZ', '0FL90CZ', '0FL90DZ', '0FL90ZZ', '0FLC0CZ', '0FLC0DZ', '0FLC0ZZ', '0FLC7DZ',
        '0FLC7ZZ', '0FLC8DZ', '0FLC8ZZ', '0FLD0CZ', '0FLD0DZ', '0FLD0ZZ', '0FLD7DZ', '0FLD7ZZ',
        '0FLD8DZ', '0FLD8ZZ', '0FLF0CZ', '0FLF0DZ', '0FLF0ZZ', '0FLF7DZ', '0FLF7ZZ', '0FLF8DZ',
        '0FLF8ZZ', '0FM40ZZ', '0FM50ZZ', '0FM60ZZ', '0FM80ZZ', '0FM90ZZ', '0FMC0ZZ', '0FMD0ZZ',
        '0FMF0ZZ', '0FMG0ZZ', '0FN00ZZ', '0FN10ZZ', '0FN20ZZ', '0FN40ZZ', '0FN50ZZ', '0FN57ZZ',
        '0FN58ZZ', '0FN60ZZ', '0FN67ZZ', '0FN68ZZ', '0FN80ZZ', '0FN87ZZ', '0FN88ZZ', '0FN90ZZ',
        '0FN97ZZ', '0FN98ZZ', '0FNC0ZZ', '0FNC7ZZ', '0FNC8ZZ', '0FND0ZZ', '0FND7ZZ', '0FND8ZZ',
        '0FNF0ZZ', '0FNF7ZZ', '0FNF8ZZ', '0FNG0ZZ', '0FP000Z', '0FP002Z', '0FP003Z', '0FP40DZ',
        '0FPB00Z', '0FPB01Z', '0FPB02Z', '0FPB03Z', '0FPB07Z', '0FPB0CZ', '0FPB0DZ', '0FPB0JZ',
        '0FPB0KZ', '0FPB70Z', '0FPB71Z', '0FPB72Z', '0FPB73Z', '0FPB77Z', '0FPB7CZ', '0FPB7DZ',
        '0FPB7JZ', '0FPB7KZ', '0FPB80Z', '0FPB81Z', '0FPB82Z', '0FPB83Z', '0FPB87Z', '0FPB8CZ',
        '0FPB8DZ', '0FPB8JZ', '0FPB8KZ', '0FPD00Z', '0FPD01Z', '0FPD02Z', '0FPD03Z', '0FPD07Z',
        '0FPD0CZ', '0FPD0DZ', '0FPD0JZ', '0FPD0KZ', '0FPD70Z', '0FPD71Z', '0FPD72Z', '0FPD73Z',
        '0FPD77Z', '0FPD7CZ', '0FPD7DZ', '0FPD7JZ', '0FPD7KZ', '0FPD80Z', '0FPD81Z', '0FPD82Z',
        '0FPD83Z', '0FPD87Z', '0FPD8CZ', '0FPD8DZ', '0FPD8JZ', '0FPD8KZ', '0FPG00Z', '0FPG02Z',
        '0FPG03Z', '0FPG0DZ', '0FPGXDZ', '0FQ40ZZ', '0FQ50ZZ', '0FQ57ZZ', '0FQ58ZZ', '0FQ60ZZ',
        '0FQ67ZZ', '0FQ68ZZ', '0FQ80ZZ', '0FQ87ZZ', '0FQ88ZZ', '0FQ90ZZ', '0FQ97ZZ', '0FQ98ZZ',
        '0FQC0ZZ', '0FQC7ZZ', '0FQC8ZZ', '0FQD0ZZ', '0FQD7ZZ', '0FQD8ZZ', '0FQF0ZZ', '0FQF7ZZ',
        '0FQF8ZZ', '0FQG0ZZ', '0FR507Z', '0FR50JZ', '0FR50KZ', '0FR607Z', '0FR60JZ', '0FR60KZ',
        '0FR807Z', '0FR80JZ', '0FR80KZ', '0FR907Z', '0FR90JZ', '0FR90KZ', '0FRC07Z', '0FRC0JZ',
        '0FRC0KZ', '0FRD07Z', '0FRD0JZ', '0FRD0KZ', '0FRF07Z', '0FRF0JZ', '0FRF0KZ', '0FS40ZZ',
        '0FS50ZZ', '0FS60ZZ', '0FS80ZZ', '0FS90ZZ', '0FSC0ZZ', '0FSD0ZZ', '0FSF0ZZ', '0FT10ZZ',
        '0FT20ZZ', '0FT50ZZ', '0FT57ZZ', '0FT58ZZ', '0FT60ZZ', '0FT67ZZ', '0FT68ZZ', '0FT80ZZ',
        '0FT87ZZ', '0FT88ZZ', '0FT90ZZ', '0FT97ZZ', '0FT98ZZ', '0FTC0ZZ', '0FTC7ZZ', '0FTC8ZZ',
        '0FTD0ZZ', '0FTD7ZZ', '0FTF0ZZ', '0FTF7ZZ', '0FTG0ZZ', '0FU507Z', '0FU50JZ', '0FU50KZ',
        '0FU607Z', '0FU60JZ', '0FU60KZ', '0FU807Z', '0FU80JZ', '0FU80KZ', '0FU907Z', '0FU90JZ',
        '0FU90KZ', '0FUC07Z', '0FUC0JZ', '0FUC0KZ', '0FUD07Z', '0FUD0JZ', '0FUD0KZ', '0FUF07Z',
        '0FUF0JZ', '0FUF0KZ', '0FV50CZ', '0FV50DZ', '0FV50ZZ', '0FV60CZ', '0FV60DZ', '0FV60ZZ',
        '0FV80CZ', '0FV80DZ', '0FV80ZZ', '0FV90CZ', '0FV90DZ', '0FV90ZZ', '0FVC0CZ', '0FVC0DZ',
        '0FVC0ZZ', '0FVC7DZ', '0FVC7ZZ', '0FVC8DZ', '0FVC8ZZ', '0FVD0CZ', '0FVD0DZ', '0FVD0ZZ',
        '0FVD7DZ', '0FVD7ZZ', '0FVD8DZ', '0FVD8ZZ', '0FVF0CZ', '0FVF0DZ', '0FVF0ZZ', '0FVF7DZ',
        '0FVF7ZZ', '0FVF8DZ', '0FVF8ZZ', '0FW000Z', '0FW002Z', '0FW003Z', '0FWB00Z', '0FWB02Z',
        '0FWB03Z', '0FWB07Z', '0FWB0CZ', '0FWB0DZ', '0FWB0JZ', '0FWB0KZ', '0FWB70Z', '0FWB72Z',
        '0FWB73Z', '0FWB77Z', '0FWB7CZ', '0FWB7DZ', '0FWB7JZ', '0FWB7KZ', '0FWB80Z', '0FWB82Z',
        '0FWB83Z', '0FWB87Z', '0FWB8CZ', '0FWB8DZ', '0FWB8JZ', '0FWB8KZ', '0FWD00Z', '0FWD02Z',
        '0FWD03Z', '0FWD07Z', '0FWD0CZ', '0FWD0DZ', '0FWD0JZ', '0FWD0KZ', '0FWD70Z', '0FWD72Z',
        '0FWD73Z', '0FWD77Z', '0FWD7CZ', '0FWD7DZ', '0FWD7JZ', '0FWD7KZ', '0FWD80Z', '0FWD82Z',
        '0FWD83Z', '0FWD87Z', '0FWD8CZ', '0FWD8DZ', '0FWD8JZ', '0FWD8KZ', '0FWG00Z', '0FWG02Z',
        '0FWG03Z', '0FWG0DZ', '0HQ4XZZ', '0HQ5XZZ', '0TRB07Z', '0W1G0JY', '0W3G0ZZ', '0W3H0ZZ',
        '0W3P0ZZ', '0W9G00Z', '0W9G0ZZ', '0W9J00Z', '0W9J0ZZ', '0WCG0ZZ', '0WCJ0ZZ', '0WCP0ZZ',
        '0WCR0ZZ', '0WFG0ZZ', '0WHG03Z', '0WHG0YZ', '0WHH03Z', '0WHH0YZ', '0WHJ03Z', '0WHJ0YZ',
        '0WHP03Z', '0WJG0ZZ', '0WJJ0ZZ', '0WJP0ZZ', '0WJR0ZZ', '0WMF0ZZ', '0WPG00Z', '0WPG01Z',
        '0WPG03Z', '0WPG0JZ', '0WPG0YZ', '0WPH00Z', '0WPH01Z', '0WPH03Z', '0WPH0YZ', '0WPP01Z',
        '0WPP03Z', '0WPP0YZ', '0WQ6XZ2', '0WQF0ZZ', '0WQFXZ2', '0WQFXZZ', '0WWG00Z', '0WWG01Z',
        '0WWG03Z', '0WWG0JZ', '0WWG0YZ', '0WWH00Z', '0WWH01Z', '0WWH03Z', '0WWH0YZ', '0WWJ00Z',
        '0WWJ01Z', '0WWJ03Z', '0WWJ0JZ', '0WWJ0YZ', '0WWP01Z', '0WWP03Z', '0WWP0YZ'
    }

    SNOMEDCT = {
        '10002003', '10107006', '10254002', '10259007', '10272008', '10388006', '1054002',
        '10590008', '107938000', '107944001', '108184008', '10869008', '10985002', '11127003',
        '11236009', '112860004', '112864008', '112871003', '112873000', '112875007', '112877004',
        '112883001', '112884007', '112977000', '112982007', '11574002', '116026007', '116027003',
        '116031009', '116165008', '116175006', '116215005', '116241004', '116242006', '11626008',
        '11682008', '119288004', '119746007', '119879002', '119880004', '119883002', '119884008',
        '119887001', '119888006', '119892004', '119915002', '119916001', '119925007', '119926008',
        '119927004', '119928009', '119936000', '119937009', '120167008', '120168003', '120183008',
        '120184002', '120186000', '120188004', '12074006', '12092003', '12102007', '12324002',
        '12421006', '12666009', '12827003', '128399009', '128400002', '128401003', '128406008',
        '12959006', '13327002', '1337002', '133871003', '13403003', '13811001', '1390003',
        '14037006', '14072009', '14335006', '14352005', '14403007', '1457004', '14599002',
        '14622006', '14687003', '14690009', '14759003', '1501006', '15051002', '15213007',
        '15257006', '15457008', '16079003', '16224002', '16280008', '1645004', '16564004',
        '17254000', '172938001', '173170008', '173171007', '173172000', '17319005', '173560002',
        '173566008', '173571001', '173572008', '173573003', '173576006', '173586007', '173587003',
        '173588008', '173590009', '173600008', '173605003', '173619003', '173685001', '173705006',
        '173714001', '173715000', '173716004', '173720000', '173722008', '173734000', '173740007',
        '173743009', '173744003', '173747005', '173748000', '173750008', '173751007', '173778009',
        '173788005', '173793008', '173794002', '173795001', '173800006', '173842008', '173848007',
        '173849004', '173853002', '173856005', '173857001', '173858006', '173860008', '173889005',
        '173895006', '173896007', '173897003', '173898008', '173899000', '173903007', '173904001',
        '173911002', '173913004', '173923008', '173947001', '173948006', '173949003', '173950003',
        '173955008', '173958005', '173959002', '173960007', '173961006', '173962004', '173967005',
        '173973006', '173977007', '173980008', '173994009', '174000002', '174002005', '174003000',
        '174005007', '174018004', '174059005', '174071004', '174072006', '174073001', '174080004',
        '174081000', '174086005', '174087001', '174093009', '174094003', '174100000', '174101001',
        '174121000', '174123002', '174124008', '174125009', '174126005', '174132000', '174164007',
        '174165008', '174240003', '174241004', '174273005', '174278001', '174286001', '174309007',
        '174349004', '174416009', '174430004', '174431000', '174432007', '174495007', '174503007',
        '174504001', '174507008', '174508003', '174542007', '174543002', '174545009', '174546005',
        '174549003', '174550003', '174551004', '174557000', '174558005', '174561006', '174562004',
        '174564003', '174565002', '174578002', '174582000', '174588001', '174589009', '174594009',
        '174595005', '174596006', '174602009', '174697009', '174702000', '174710004', '174712007',
        '174717001', '174718006', '174720009', '17473003', '174734009', '174735005', '174740002',
        '174758008', '174776001', '174778000', '17478007', '176003', '17671008', '177784006',
        '177835007', '177836008', '177837004', '177846005', '177916006', '177919004', '177920005',
        '177970008', '177977006', '178732003', '17988003', '18047003', '18133004', '18319008',
        '184687006', '18561003', '186648008', '18692006', '18878003', '191532000', '1924009',
        '192461000', '193289008', '195115001', '195767005', '195969003', '19612002', '19639005',
        '196505006', '19725004', '198144000', '199001009', '20241005', '20246000', '20357008',
        '20460000', '20880009', '21118000', '21400005', '21482000', '21538007', '21832001',
        '21991006', '22094003', '22216006', '22324003', '2234009', '22853007', '22997007',
        '23167008', '232635006', '232636007', '232637003', '232638008', '232639000', '232640003',
        '232641004', '232642006', '232643001', '232644007', '232645008', '232646009', '232647000',
        '23281002', '234319005', '235152003', '235159007', '235160002', '235161003', '235162005',
        '235163000', '235164006', '235165007', '235166008', '235168009', '235169001', '235170000',
        '235171001', '235173003', '235174009', '235175005', '235176006', '235177002', '235178007',
        '235179004', '235186007', '235187003', '235188008', '235189000', '235190009', '235191008',
        '235192001', '235193006', '235214008', '235215009', '235216005', '235217001', '235218006',
        '235219003', '235225004', '235226003', '235227007', '235228002', '235229005', '235230000',
        '235231001', '235232008', '235245007', '235253004', '235254005', '235255006', '235259000',
        '235260005', '235265000', '235266004', '235267008', '235270007', '235271006', '235279008',
        '235280006', '235281005', '235282003', '235287009', '235288004', '235289007', '235291004',
        '235298005', '235299002', '235300005', '235302002', '235305000', '235306004', '235307008',
        '235325001', '235326000', '235331003', '235332005', '235333000', '235340004', '235345009',
        '235346005', '235348006', '235355008', '235360007', '235364003', '235366001', '235367005',
        '235371008', '235372001', '235373006', '235374000', '235376003', '235377007', '235378002',
        '235407009', '235408004', '235409007', '235460008', '235466002', '235467006', '235468001',
        '235469009', '235470005', '235472002', '235476004', '235477008', '235479006', '235480009',
        '235481008', '235482001', '235483006', '235484000', '235485004', '235489005', '235490001',
        '235491002', '235493004', '235498008', '235499000', '235501008', '235509005', '235510000',
        '235511001', '235520005', '235521009', '235522002', '235528003', '235529006', '235530001',
        '235531002', '235532009', '235533004', '235534005', '235536007', '235537003', '235538008',
        '235540003', '235547000', '235570008', '235571007', '235573005', '235574004', '235581006',
        '235582004', '235584003', '235585002', '235586001', '235588000', '235589008', '235590004',
        '235591000', '235860000', '23797008', '238203006', '238210000', '238211001', '238212008',
        '238213003', '238214009', '238215005', '238217002', '238218007', '238219004', '238221009',
        '238236007', '238240003', '238255007', '238335008', '238358006', '239005002', '23968004',
        '239879006', '239989009', '240294007', '240962009', '241560003', '242519008', '243287005',
        '24431004', '24506003', '245667003', '247501005', '24792005', '248352005', '24883002',
        '249210007', '25187007', '25196007', '25321000', '257909005', '260645006', '261502004',
        '261766001', '26187001', '26268001', '262794006', '26390003', '26452005', '264963003',
        '264969004', '265340005', '265341009', '265344001', '265345000', '265356000', '265358004',
        '265359007', '265360002', '265364006', '265365007', '265380001', '265381002', '265411006',
        '265412004', '265414003', '265417005', '265418000', '265420002', '265429001', '265458003',
        '265459006', '265461002', '265462009', '26565004', '26619008', '26732005', '26925005',
        '26993008', '27010001', '27041000', '27056009', '27063009', '271564001', '271565000',
        '27191003', '271996001', '27210007', '274025005', '274029004', '274032001', '274448007',
        '275007007', '275011001', '275014009', '275015005', '275016006', '275017002', '275019004',
        '275024001', '275162000', '275194005', '275230005', '275231009', '276190007', '277578005',
        '278500000', '27892007', '281413005', '281567001', '282400002', '283377009', '28345000',
        '28467003', '286079005', '28658009', '287315009', '287330000', '287334009', '287783005',
        '287788001', '287793003', '287794009', '287809004', '287810009', '287815004', '287816003',
        '287818002', '287819005', '287824008', '287827001', '287828006', '287829003', '287834004',
        '287844002', '287846000', '287847009', '287848004', '287850007', '287853009', '287861004',
        '287866009', '287867000', '287994002', '287995001', '288019006', '28851001', '28890002',
        '289060008', '28933001', '28981008', '290017007', '29065006', '29205000', '294034007',
        '29453004', '29630005', '298799004', '29952004', '299681007', '299682000', '3001009',
        '301087006', '301425009', '30161002', '301698008', '301699000', '301704008', '30215008',
        '302354002', '302619004', '30273008', '303395008', '303396009', '303398005', '303401008',
        '303565004', '303566003', '303582002', '303584001', '30402002', '304060006', '3041000',
        '304583001', '304585008', '304587000', '305621000', '307009004', '307010009', '307011008',
        '30706000', '307183003', '307185005', '307190008', '307192000', '307193005', '307196002',
        '307197006', '307259004', '307260009', '307261008', '307281009', '307302001', '307303006',
        '307304000', '307330001', '307331002', '307332009', '307364002', '307367009', '307368004',
        '307510004', '307511000', '307512007', '307555006', '307561009', '307562002', '307568003',
        '307569006', '307583008', '307584002', '307586000', '307615003', '307620003', '307621004',
        '307626009', '307638000', '307639008', '307640005', '307642002', '307643007', '307644001',
        '307645000', '307648003', '307654002', '307655001', '307656000', '307657009', '307658004',
        '307659007', '307662005', '307665007', '307666008', '307667004', '307669001', '307709007',
        '30803004', '30947006', '310223003', '310224009', '310420002', '310421003', '31048008',
        '31078004', '310803009', '310804003', '31130001', '31158009', '312340001', '312341002',
        '312406002', '312407006', '312497000', '31256001', '312694003', '314118002', '314511002',
        '314592008', '314593003', '314594009', '31461001', '314617008', '314632001', '314636003',
        '314638002', '31521004', '315319006', '315321001', '315322008', '315323003', '315324009',
        '315325005', '315326006', '315327002', '315328007', '31738002', '31774006', '3183007',
        '32044008', '32091001', '32325005', '328895009', '32918006', '329884007', '330857008',
        '33149006', '331865000', '33187003', '33479006', '3360004', '33639009', '33649007',
        '34130000', '34414001', '35083003', '35129004', '35535008', '355610001', '3562008',
        '357579002', '358575006', '35892001', '359529008', '359567006', '359571009', '359572002',
        '359574001', '359575000', '359579006', '359581008', '359584000', '359585004', '359587007',
        '359588002', '359591002', '359594005', '359596007', '359604006', '359605007', '359606008',
        '359615001', '359618004', '359623004', '359887003', '359890009', '359893006', '359902008',
        '359908007', '359911008', '360363002', '360368006', '360370002', '360372005', '360377004',
        '361152000', '361153005', '36192008', '363742001', '364682008', '36482008', '36508007',
        '3654008', '366741003', '367365007', '367405008', '367436000', '367453007', '367509004',
        '36788006', '36889006', '36917004', '37179000', '37412006', '37572001', '37593003',
        '37903002', '3796003', '38213000', '38507005', '386196007', '386197003', '386578009',
        '386651004', '386695005', '386697002', '386828002', '386829005', '387606008', '387607004',
        '387867004', '38841005', '38971003', '39027008', '39083009', '39166002', '395136002',
        '395140006', '395151006', '395152004', '39536003', '395724000', '39620006', '39655008',
        '397108006', '397159007', '397160002', '397161003', '397162005', '39738004', '3980006',
        '398246005', '398261006', '398740003', '399472007', '40053007', '400988008', '401004',
        '40234006', '4044002', '40543003', '40667002', '40801000', '40875005', '40902008',
        '40995000', '41200003', '41214003', '41276005', '41330009', '41436002', '41457005',
        '41536004', '42246001', '42268006', '42301000', '42332004', '425904004', '425964001',
        '426150005', '426267007', '426344007', '42645008', '426738005', '427029008', '427158008',
        '427980007', '427997001', '428784009', '43075005', '430798009', '43082009', '431836005',
        '43196001', '43232006', '43256005', '43344006', '4336007', '43519002', '438338008',
        '43868005', '438836003', '439008003', '43907003', '439171005', '439712000', '439878001',
        '440032004', '440033009', '440070000', '440118004', '440549000', '440581009', '440715006',
        '44076002', '44119001', '44192009', '442338001', '442805003', '442806002', '442912006',
        '443480008', '443665007', '44378008', '443906008', '443908009', '443909001', '444165004',
        '444593009', '445831005', '445884009', '445934003', '445935002', '445938000', '445971001',
        '445975005', '446222007', '446223002', '446228006', '44642007', '446472006', '446652009',
        '446733006', '446734000', '446740007', '446746001', '447166008', '447281005', '44751009',
        '447517002', '447787008', '447936000', '447946003', '447978006', '447982008', '448013009',
        '448050005', '448053007', '448125005', '448143009', '448156002', '448190006', '448352008',
        '448369005', '448474003', '448596007', '448653006', '449396003', '4520009', '45220009',
        '45228002', '45274003', '45314005', '45464004', '4558008', '45584003', '456004',
        '45602008', '45608007', '45692002', '45753003', '45900003', '45993005', '46070005',
        '46295004', '46381000', '46412002', '46599009', '46936007', '47041005', '47202004',
        '47302001', '47353000', '474008', '47696003', '47705001', '47789005', '47934001',
        '4811009', '4829004', '48371009', '4862007', '48630009', '48783008', '48835001',
        '48855000', '48859006', '4891005', '48920003', '49209004', '49245001', '4930005',
        '49440008', '49674003', '49795001', '49826001', '49942007', '50012009', '50774009',
        '50824001', '51233000', '51346007', '51396008', '51452009', '51582001', '51684008',
        '51977003', '52667004', '52917009', '53003006', '53087005', '53133001', '53150004',
        '53266006', '53442002', '5415002', '54153006', '54154000', '54164009', '543008',
        '54357003', '54629001', '54747001', '54987000', '55286008', '55517006', '55586007',
        '55966001', '56614001', '5722009', '57236003', '5745003', '57632009', '58090001',
        '5809008', '58303000', '58365005', '58685000', '5870006', '58709004', '59164006',
        '59372001', '59411003', '59567009', '59656001', '59657005', '59912004', '60055006',
        '60194009', '60228007', '60305009', '60465006', '60523002', '60581003', '60606003',
        '60892005', '60954008', '61218006', '61326000', '61417004', '61477008', '61524001',
        '61667000', '6190006', '62069000', '62572002', '62755007', '62807001', '63003009',
        '63322005', '63499008', '63816008', '6402000', '64271007', '64492005', '64906005',
        '65291007', '65310005', '65657001', '65666002', '65788008', '65954005', '65960005',
        '66343001', '66361005', '66444008', '66513002', '66545007', '66740000', '66896000',
        '6704000', '67075000', '67160005', '67389003', '67557008', '6759001', '67706006',
        '67997001', '68141001', '68188002', '68342003', '68911004', '68960009', '69036001',
        '6915004', '69191006', '69455007', '69538006', '70110002', '70172002', '70243005',
        '70263003', '70377003', '70553005', '70676003', '71102008', '71145001', '71273005',
        '71309007', '71827004', '7223004', '72261007', '72583007', '72811008', '72971003',
        '73509004', '73554003', '73713008', '73759005', '73886004', '73921006', '73978003',
        '73996007', '74180003', '74770008', '7495004', '75142005', '75190003', '75312003',
        '75389003', '75420000', '75479001', '75639003', '75894009', '75905004', '76062007',
        '76077004', '76192001', '76443003', '76967003', '77071005', '77539008', '77878003',
        '77959002', '78017003', '7813002', '78233008', '78824001', '78905003', '78925004',
        '79170004', '79433000', '79572004', '79695004', '80028005', '80173001', '80200006',
        '80285004', '80294005', '80319003', '80443001', '80444007', '80772001', '81092009',
        '81569000', '81714000', '8174004', '81913003', '82293009', '82619000', '82744000',
        '82780000', '82900007', '82967007', '83101004', '8322005', '8324006', '83371007',
        '83462004', '83599002', '83840007', '83857006', '83985009', '84262009', '84354004',
        '84477003', '84510006', '84604002', '84824001', '84840003', '84952009', '85217002',
        '85759000', '85849005', '85946004', '86369000', '86481000', '86620009', '86789002',
        '87231001', '87260005', '87279008', '87289007', '87389009', '87602008', '87604009',
        '87659008', '87677003', '8777004', '87879002', '88187000', '88314007', '88354009',
        '88849006', '88865007', '88888008', '8903007', '8906004', '8929007', '89300004',
        '89339008', '89441008', '89522007', '89642006', '89646009', '89951000', '90021002',
        '90063003', '90297001', '90410003', '90524002', '90838004', '90856004', '9102008',
        '9121000', '91516004', '91596000', '91621005', '91625001', '91679005', '9175006', '9215005',
        '9238008', '9292007', '9429009', '9524002', '9666005', '9735005', '9895003', '9905009'
    }


class GraduatedCompressionStockingsGcs(ValueSet):
    """

    Clinical Focus: This set of values contains codes and concepts for graduated compression stocking devices which are used to prevent VTEs in patients.
    Data Element Scope: The intent of this data element is to identify patients who have a graduated compression stocking device applied.  It may also be used to identify patients who did not have a graduated compression stocking device applied for VTE prophylaxis for an allowable reason when used with a negation rationale attribute. Using the Quality Data Model, this data element maps to the Device category.
    Inclusion Criteria: Only include codes which represent graduated compression stockings.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.256'
    VALUE_SET_NAME = 'Graduated compression stockings (GCS)'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '348681001', '401621005', '401622003', '401623008', '401624002', '401625001', '401626000',
        '401627009', '401628004', '401629007', '401630002', '401631003', '401632005', '401633000',
        '401634006', '401635007', '401636008', '401637004', '401638009', '401639001', '401640004',
        '401641000', '401642007', '401643002', '401644008', '401645009', '401646005', '401647001',
        '401648006', '401649003', '401650003', '401651004', '401652006', '401653001', '401654007',
        '401655008', '401656009', '401657000', '401776005', '401777001', '401778006', '408127000',
        '408128005', '408129002', '408130007', '408131006', '408132004'
    }


class GynecologicalSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have  procedures of gynecologic surgery.
    Data Element Scope: The intent of this data element is to identify patients who have a gynecologic surgery procedure.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent gynecologic surgery procedures.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.257'
    VALUE_SET_NAME = 'Gynecological Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0U500ZZ', '0U510ZZ', '0U520ZZ', '0U540ZZ', '0U550ZZ', '0U557ZZ', '0U558ZZ', '0U560ZZ',
        '0U567ZZ', '0U568ZZ', '0U570ZZ', '0U577ZZ', '0U578ZZ', '0U800ZZ', '0U810ZZ', '0U820ZZ',
        '0U840ZZ', '0UB00ZZ', '0UB07ZZ', '0UB08ZZ', '0UB10ZZ', '0UB17ZZ', '0UB18ZZ', '0UB20ZZ',
        '0UB27ZZ', '0UB28ZZ', '0UB40ZZ', '0UB47ZZ', '0UB48ZZ', '0UB50ZZ', '0UB57ZZ', '0UB58ZZ',
        '0UB60ZZ', '0UB67ZZ', '0UB68ZZ', '0UB70ZZ', '0UB77ZZ', '0UB78ZZ', '0UT00ZZ', '0UT07ZZ',
        '0UT08ZZ', '0UT10ZZ', '0UT17ZZ', '0UT18ZZ', '0UT20ZZ', '0UT27ZZ', '0UT28ZZ', '0UT40ZZ',
        '0UT47ZZ', '0UT48ZZ', '0UT50ZZ', '0UT57ZZ', '0UT58ZZ', '0UT60ZZ', '0UT67ZZ', '0UT68ZZ',
        '0UT70ZZ', '0UT77ZZ', '0UT78ZZ', '0UT90ZZ', '0UT97ZZ', '0UT98ZZ', '0UTC0ZZ', '0UTC7ZZ',
        '0UTC8ZZ', '10T20ZZ', '10T27ZZ', '10T28ZZ'
    }

    SNOMEDCT = {
        '112917009', '112918004', '116028008', '116141005', '116142003', '116143008', '116144002',
        '116167000', '116173004', '118865002', '120053002', '120064004', '13254001', '14353000',
        '15306005', '1689004', '176909001', '176914002', '176915001', '176916000', '176917009',
        '177018009', '177019001', '177046006', '177055009', '177056005', '214173000', '223306006',
        '22699007', '23575009', '236889009', '236890000', '236932009', '236935006', '236987005',
        '236988000', '25344002', '25811000', '265056007', '27185000', '276189003', '27950001',
        '287931008', '287935004', '287945002', '29529008', '29672006', '29827000', '300897007',
        '30160001', '30172007', '302190000', '302191001', '302376006', '302377002', '307263006',
        '307264000', '307771009', '309879006', '309880009', '315059002', '315060007', '31545000',
        '33015000', '35887003', '35955002', '359971002', '359974005', '359977003', '359980002',
        '359983000', '361222003', '361223008', '387739000', '387740003', '387741004', '4010009',
        '41058005', '41059002', '413144006', '413145007', '41393008', '414575003', '42349006',
        '431316002', '43791001', '441820006', '4443002', '445912000', '44619000', '446446002',
        '446526009', '447771005', '44793005', '448539002', '47045001', '49493009', '53139002',
        '54080001', '54490004', '59750000', '60158005', '62692004', '63516002', '63596003',
        '66169000', '71225000', '75835007', '76876009', '77902002', '82269004', '83152002',
        '83416007', '84093003', '8550006', '85855000', '86477000', '87102007', '89325008'
    }


class HipFractureSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have  procedures of hip fracture surgery.
    Data Element Scope: The intent of this data element is to identify patients who have a hip fracture surgery procedure.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent hip fracture surgery.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.258'
    VALUE_SET_NAME = 'Hip Fracture Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'0SQ90ZZ', '0SQ9XZZ', '0SQB0ZZ', '0SQBXZZ'}

    SNOMEDCT = {
        '16174006', '239499008', '239500004', '265745003', '32972004', '44167006', '47458005',
        '61509005', '73764009', '83381006', '87618002'
    }


class HipReplacementSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have  total hip replacement procedures.
    Data Element Scope: The intent of this data element is to identify patients who have a total hip replacement procedure.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent the surgical procedure of a total hip replacement.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.259'
    VALUE_SET_NAME = 'Hip Replacement Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0SP909Z', '0SP90JZ', '0SPA0JZ', '0SPB09Z', '0SPB0JZ', '0SPE0JZ', '0SPR0JZ', '0SPS0JZ',
        '0SR9019', '0SR901A', '0SR901Z', '0SR9029', '0SR902A', '0SR902Z', '0SR9039', '0SR903A',
        '0SR903Z', '0SR9049', '0SR904A', '0SR904Z', '0SR907Z', '0SR90J9', '0SR90JA', '0SR90JZ',
        '0SR90KZ', '0SRA009', '0SRA00A', '0SRA00Z', '0SRA019', '0SRA01A', '0SRA01Z', '0SRA039',
        '0SRA03A', '0SRA03Z', '0SRA07Z', '0SRA0J9', '0SRA0JA', '0SRA0JZ', '0SRA0KZ', '0SRB019',
        '0SRB01A', '0SRB01Z', '0SRB029', '0SRB02A', '0SRB02Z', '0SRB039', '0SRB03A', '0SRB03Z',
        '0SRB049', '0SRB04A', '0SRB04Z', '0SRB07Z', '0SRB0J9', '0SRB0JA', '0SRB0JZ', '0SRB0KZ',
        '0SRE009', '0SRE00A', '0SRE00Z', '0SRE019', '0SRE01A', '0SRE01Z', '0SRE039', '0SRE03A',
        '0SRE03Z', '0SRE07Z', '0SRE0J9', '0SRE0JA', '0SRE0JZ', '0SRE0KZ', '0SRR019', '0SRR01A',
        '0SRR01Z', '0SRR039', '0SRR03A', '0SRR03Z', '0SRR07Z', '0SRR0J9', '0SRR0JA', '0SRR0JZ',
        '0SRR0KZ', '0SRS019', '0SRS01A', '0SRS01Z', '0SRS039', '0SRS03A', '0SRS03Z', '0SRS07Z',
        '0SRS0J9', '0SRS0JA', '0SRS0JZ', '0SRS0KZ', '0SU907Z', '0SU909Z', '0SU90BZ', '0SU90JZ',
        '0SU90KZ', '0SUA09Z', '0SUA0BZ', '0SUB07Z', '0SUB09Z', '0SUB0BZ', '0SUB0JZ', '0SUB0KZ',
        '0SUE09Z', '0SUE0BZ', '0SUR09Z', '0SUR0BZ', '0SUS09Z', '0SUS0BZ', '0SW907Z', '0SW909Z',
        '0SW90JZ', '0SW90KZ', '0SWA0JZ', '0SWB07Z', '0SWB09Z', '0SWB0JZ', '0SWB0KZ', '0SWE0JZ',
        '0SWR0JZ', '0SWS0JZ'
    }

    SNOMEDCT = {
        '112727005', '112728000', '15036006', '179294005', '179295006', '179304004', '179305003',
        '179306002', '179326003', '19954002', '265157000', '265158005', '265160007', '265161006',
        '276178005', '29969002', '307814001', '307815000', '309853002', '314489006', '314491003',
        '32581000', '33788003', '339905004', '340922009', '386649003', '397956004', '425443008',
        '426618001', '426904006', '427728006', '428622003', '429156003', '430688009', '430694001',
        '443435007', '444051004', '445185007', '447947007', '447992000', '449039004', '450813004',
        '47596009', '52734007', '53081006', '57589001', '62402000', '68491008', '76116002',
        '76915002', '7989006'
    }


class SingleLiveBornNewbornBornInHospital(ValueSet):
    """

    Clinical Focus: This set of values contains types of delivery that represent the single live birth.
    Data Element Scope: The intent of this data element is to identify single live born newborn. Using the Quality Data Model, this particular element will map to the "Diagnosis" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 CM, and SNOMED CT codes that identify single live born newborn.
    Exclusion Criteria: Exclude IDC-9-CM and ICD-10-CM codes indicating the birth took place outside of the hospital.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.26'
    VALUE_SET_NAME = 'Single Live Born Newborn Born in Hospital'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'Z3800', 'Z3801'}

    ICD9CM = {'V3000', 'V3001'}


class IntracranialNeurosurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have  procedures of intracranial neurosurgery.
    Data Element Scope: The intent of this data element is to identify patients who have an intracranial neurosurgery procedure.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent intracranial neurosurgery.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.260'
    VALUE_SET_NAME = 'Intracranial Neurosurgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '00500ZZ', '00510ZZ', '00520ZZ', '00560ZZ', '00570ZZ', '00580ZZ', '00590ZZ', '005A0ZZ',
        '005B0ZZ', '005C0ZZ', '005D0ZZ', '00800ZZ', '00870ZZ', '00880ZZ', '009000Z', '00900ZZ',
        '009100Z', '00910ZZ', '009200Z', '00920ZZ', '009300Z', '00930ZZ', '009400Z', '00940ZZ',
        '009500Z', '00950ZZ', '009600Z', '00960ZZ', '009700Z', '00970ZZ', '009800Z', '00980ZZ',
        '009900Z', '00990ZZ', '009A00Z', '009A0ZZ', '009B00Z', '009B0ZZ', '009C00Z', '009C0ZZ',
        '009D00Z', '009D0ZZ', '00B00ZZ', '00B10ZZ', '00B20ZZ', '00B60ZZ', '00B70ZZ', '00B80ZZ',
        '00B90ZZ', '00BA0ZZ', '00BB0ZZ', '00BC0ZZ', '00BD0ZZ', '00C00ZZ', '00C10ZZ', '00C20ZZ',
        '00C30ZZ', '00C40ZZ', '00C50ZZ', '00C60ZZ', '00C70ZZ', '00C80ZZ', '00C90ZZ', '00CA0ZZ',
        '00CB0ZZ', '00CC0ZZ', '00CD0ZZ', '00D10ZZ', '00D20ZZ', '00H002Z', '00H003Z', '00H602Z',
        '00H603Z', '00J00ZZ', '00N90ZZ', '00NA0ZZ', '00P000Z', '00P002Z', '00P003Z', '00P007Z',
        '00P00JZ', '00P00KZ', '00P600Z', '00P602Z', '00P603Z', '00P6X2Z', '00Q90ZZ', '00QA0ZZ',
        '00T70ZZ', '00W000Z', '00W002Z', '00W003Z', '00W007Z', '00W00JZ', '00W00KZ', '00W00MZ',
        '00W600Z', '00W602Z', '00W603Z', '00W60MZ', '0N9000Z', '0N900ZZ', '0N9100Z', '0N910ZZ',
        '0N9200Z', '0N920ZZ', '0N9300Z', '0N930ZZ', '0N9400Z', '0N940ZZ', '0N9500Z', '0N950ZZ',
        '0N9600Z', '0N960ZZ', '0N9700Z', '0N970ZZ', '0N9800Z', '0N980ZZ', '0W9100Z', '0W910ZZ',
        '0WC10ZZ', '0WH10YZ', '0WJ10ZZ', '0WP100Z', '0WP101Z', '0WP10JZ', '0WP10YZ', '0WW100Z',
        '0WW101Z', '0WW103Z', '0WW10JZ', '0WW10YZ'
    }

    SNOMEDCT = {
        '10458001', '112929000', '13431007', '13433005', '13666002', '14247003', '14554005',
        '1583007', '171442008', '171443003', '171446006', '171447002', '171448007', '171449004',
        '171450004', '171451000', '171455009', '171471009', '171472002', '171473007', '171474001',
        '171479006', '171495006', '171540003', '171554006', '171692002', '171693007', '171694001',
        '171695000', '171696004', '171697008', '171698003', '171722000', '178373004', '178375006',
        '178376007', '178391009', '1868005', '1995001', '19994000', '21205002', '21551002',
        '22480005', '230810008', '230811007', '230814004', '230837005', '230838000', '230839008',
        '230840005', '230841009', '230859007', '230886007', '230888008', '230890009', '230892001',
        '230893006', '234064002', '234915008', '243570009', '244238001', '25353009', '2552005',
        '260643004', '260644005', '26096003', '27181009', '27190002', '2737001', '273991000',
        '27968003', '28264008', '287205001', '287208004', '29063004', '29114001', '2968008',
        '30195003', '304848009', '304849001', '307299001', '31746001', '32606000', '34097003',
        '34719005', '36910002', '37380009', '38512006', '39667005', '39704007', '4045001',
        '42699003', '427037000', '427599009', '429314008', '429510003', '438369007', '438614004',
        '439493007', '439499006', '440062005', '441832005', '442616007', '445746008', '44589002',
        '445926009', '445942002', '446103006', '446115005', '446209004', '446210009', '446440008',
        '446570000', '446571001', '446683008', '446705006', '446816008', '446848007', '446850004',
        '446865003', '446868001', '447107001', '447115003', '447156000', '447362004', '447363009',
        '447469009', '447518007', '447529006', '447594008', '45322003', '4570007', '51991009',
        '53423001', '5384005', '54872009', '54891009', '56143008', '56959007', '58337008',
        '58515002', '59696004', '59712006', '61327009', '61965006', '67402009', '67864003',
        '68346000', '68731005', '69086007', '69788001', '71722001', '73006002', '75626002',
        '76961002', '77697000', '789003', '79093007', '79272003', '80460006', '807005', '81259007',
        '8155007', '81849003', '82443007', '82678002', '82917000', '87060004', '87192001',
        '90287005', '91652006', '9257004', '9372002', '9580008', '9888007'
    }


class KneeReplacementSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have total knee replacement procedures.
    Data Element Scope: The intent of this data element is to identify patients who have a total knee replacement procedure. Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent the surgical procedure of a total knee replacement.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.261'
    VALUE_SET_NAME = 'Knee Replacement Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0QPD0JZ', '0QPF0JZ', '0QRD0JZ', '0QRF0JZ', '0QUD0JZ', '0QUF0JZ', '0SPC09Z', '0SPC0JC',
        '0SPC0JZ', '0SPD09Z', '0SPD0JC', '0SPD0JZ', '0SPT0JZ', '0SPU0JZ', '0SPV0JZ', '0SPW0JZ',
        '0SRC07Z', '0SRC0J9', '0SRC0JA', '0SRC0JZ', '0SRC0KZ', '0SRC0L9', '0SRC0LA', '0SRC0LZ',
        '0SRD07Z', '0SRD0J9', '0SRD0JA', '0SRD0JZ', '0SRD0KZ', '0SRD0L9', '0SRD0LA', '0SRD0LZ',
        '0SRT07Z', '0SRT0J9', '0SRT0JA', '0SRT0JZ', '0SRT0KZ', '0SRU07Z', '0SRU0J9', '0SRU0JA',
        '0SRU0JZ', '0SRU0KZ', '0SRV07Z', '0SRV0J9', '0SRV0JA', '0SRV0JZ', '0SRV0KZ', '0SRW07Z',
        '0SRW0J9', '0SRW0JA', '0SRW0JZ', '0SRW0KZ', '0SUC07Z', '0SUC09C', '0SUC09Z', '0SUC0JZ',
        '0SUC0KZ', '0SUD07Z', '0SUD09C', '0SUD09Z', '0SUD0JZ', '0SUD0KZ', '0SUT09Z', '0SUU09Z',
        '0SUV09Z', '0SUW09Z', '0SWC09Z', '0SWC0JC', '0SWC0JZ', '0SWD09Z', '0SWD0JC', '0SWD0JZ',
        '0SWT0JZ', '0SWU0JZ', '0SWV0JZ', '0SWW0JZ'
    }

    SNOMEDCT = {
        '179344006', '179345007', '179351002', '179352009', '179406003', '179411001', '179416006',
        '265170009', '265172001', '27748003', '29712008', '430698003', '443543000', '443658004',
        '443681002', '443682009', '445091006', '88056004', '90827004'
    }


class Obstetrics(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have a condition related to pregnancy or obstetrics.
    Data Element Scope: The intent of this data element is to identify patients who have a condition, problem or diagnosis related to pregnancy or obstetrics.  Using the Quality Data Model, this particular element will map to either the Diagnosis category.
    Inclusion Criteria: Only use codes which represent a condition, problem or diagnosis related to pregnancy or obstetrics.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.263'
    VALUE_SET_NAME = 'Obstetrics'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'O000', 'O0000', 'O0001', 'O001', 'O0010', 'O0011', 'O002', 'O0020', 'O0021', 'O008',
        'O0080', 'O0081', 'O009', 'O0090', 'O0091', 'O010', 'O011', 'O019', 'O020', 'O021',
        'O0281', 'O0289', 'O029', 'O045', 'O046', 'O047', 'O0480', 'O0481', 'O0482', 'O0483',
        'O0484', 'O0485', 'O0486', 'O0487', 'O0488', 'O0489', 'O070', 'O071', 'O072', 'O0730',
        'O0731', 'O0732', 'O0733', 'O0734', 'O0735', 'O0736', 'O0737', 'O0738', 'O0739', 'O074',
        'O080', 'O081', 'O082', 'O083', 'O084', 'O085', 'O086', 'O087', 'O0881', 'O0882', 'O0883',
        'O0889', 'O089', 'O0900', 'O0901', 'O0902', 'O0903', 'O0910', 'O0911', 'O0912', 'O0913',
        'O09211', 'O09212', 'O09213', 'O09219', 'O09291', 'O09292', 'O09293', 'O09299', 'O0930',
        'O0931', 'O0932', 'O0933', 'O0940', 'O0941', 'O0942', 'O0943', 'O09511', 'O09512',
        'O09513', 'O09519', 'O09521', 'O09522', 'O09523', 'O09529', 'O09611', 'O09612', 'O09613',
        'O09619', 'O09621', 'O09622', 'O09623', 'O09629', 'O0970', 'O0971', 'O0972', 'O0973',
        'O09811', 'O09812', 'O09813', 'O09A0', 'O09A1', 'O09A2', 'O09A3', 'O10011', 'O10012',
        'O10013', 'O10019', 'O1002', 'O1003', 'O10111', 'O10112', 'O10113', 'O10119', 'O1012',
        'O1013', 'O10211', 'O10212', 'O10213', 'O10219', 'O1022', 'O1023', 'O10311', 'O10312',
        'O10313', 'O10319', 'O1032', 'O1033', 'O10411', 'O10412', 'O10413', 'O10419', 'O1042',
        'O1043', 'O10911', 'O10912', 'O10913', 'O10919', 'O1092', 'O1093', 'O111', 'O112', 'O113',
        'O114', 'O115', 'O119', 'O1200', 'O1201', 'O1202', 'O1203', 'O1204', 'O1205', 'O1210',
        'O1211', 'O1212', 'O1213', 'O1214', 'O1215', 'O1220', 'O1221', 'O1222', 'O1223', 'O1224',
        'O1225', 'O131', 'O132', 'O133', 'O134', 'O135', 'O139', 'O1400', 'O1402', 'O1403',
        'O1404', 'O1405', 'O1410', 'O1412', 'O1413', 'O1414', 'O1415', 'O1420', 'O1422', 'O1423',
        'O1424', 'O1425', 'O1490', 'O1492', 'O1493', 'O1494', 'O1495', 'O1500', 'O1502', 'O1503',
        'O151', 'O152', 'O159', 'O161', 'O162', 'O163', 'O164', 'O165', 'O169', 'O200', 'O208',
        'O209', 'O210', 'O211', 'O212', 'O218', 'O219', 'O2200', 'O2201', 'O2202', 'O2203',
        'O2210', 'O2211', 'O2212', 'O2213', 'O2220', 'O2221', 'O2222', 'O2223', 'O2240', 'O2241',
        'O2242', 'O2243', 'O228X1', 'O228X2', 'O228X3', 'O228X9', 'O2300', 'O2301', 'O2302',
        'O2303', 'O2310', 'O2311', 'O2312', 'O2313', 'O2320', 'O2321', 'O2322', 'O2323', 'O2330',
        'O2331', 'O2332', 'O2333', 'O2340', 'O2341', 'O2342', 'O2343', 'O23511', 'O23512',
        'O23513', 'O23519', 'O23521', 'O23522', 'O23523', 'O23529', 'O23591', 'O23592', 'O23593',
        'O23599', 'O2390', 'O2391', 'O2392', 'O2393', 'O24011', 'O24012', 'O24013', 'O24019',
        'O2402', 'O24111', 'O24112', 'O24113', 'O24119', 'O2412', 'O24311', 'O24312', 'O24313',
        'O24319', 'O2432', 'O24410', 'O24414', 'O24415', 'O24419', 'O24420', 'O24424', 'O24425',
        'O24429', 'O24430', 'O24434', 'O24435', 'O24811', 'O24812', 'O24813', 'O24819', 'O2482',
        'O24911', 'O24912', 'O24913', 'O24919', 'O2492', 'O2493', 'O2510', 'O2511', 'O2512',
        'O2513', 'O252', 'O2600', 'O2601', 'O2602', 'O2603', 'O2610', 'O2611', 'O2612', 'O2613',
        'O2620', 'O2621', 'O2622', 'O2623', 'O2630', 'O2631', 'O2632', 'O2633', 'O2640', 'O2641',
        'O2642', 'O2643', 'O2650', 'O2651', 'O2652', 'O2653', 'O26611', 'O26612', 'O26613',
        'O26619', 'O2662', 'O2663', 'O26711', 'O26712', 'O26713', 'O26719', 'O2672', 'O2673',
        'O26811', 'O26812', 'O26813', 'O26819', 'O26821', 'O26822', 'O26823', 'O26829', 'O26831',
        'O26832', 'O26833', 'O26839', 'O26841', 'O26842', 'O26843', 'O26849', 'O26851', 'O26852',
        'O26853', 'O26859', 'O2686', 'O26891', 'O26892', 'O26893', 'O26899', 'O2690', 'O2691',
        'O2692', 'O2693', 'O29011', 'O29012', 'O29013', 'O29019', 'O29021', 'O29022', 'O29023',
        'O29029', 'O29091', 'O29092', 'O29093', 'O29099', 'O29111', 'O29112', 'O29113', 'O29119',
        'O29121', 'O29122', 'O29123', 'O29129', 'O29191', 'O29192', 'O29193', 'O29199', 'O29211',
        'O29212', 'O29213', 'O29219', 'O29291', 'O29292', 'O29293', 'O29299', 'O293X1', 'O293X2',
        'O293X3', 'O293X9', 'O2940', 'O2941', 'O2942', 'O2943', 'O295X1', 'O295X2', 'O295X3',
        'O295X9', 'O2960', 'O2961', 'O2962', 'O2963', 'O298X1', 'O298X2', 'O298X3', 'O298X9',
        'O2990', 'O2991', 'O2992', 'O2993', 'O30001', 'O30002', 'O30003', 'O30009', 'O30011',
        'O30012', 'O30013', 'O30019', 'O30031', 'O30032', 'O30033', 'O30039', 'O30041', 'O30042',
        'O30043', 'O30049', 'O30091', 'O30092', 'O30093', 'O30099', 'O30101', 'O30102', 'O30103',
        'O30109', 'O30111', 'O30112', 'O30113', 'O30119', 'O30121', 'O30122', 'O30123', 'O30129',
        'O30191', 'O30192', 'O30193', 'O30199', 'O30201', 'O30202', 'O30203', 'O30209', 'O30211',
        'O30212', 'O30213', 'O30219', 'O30221', 'O30222', 'O30223', 'O30229', 'O30291', 'O30292',
        'O30293', 'O30299', 'O30801', 'O30802', 'O30803', 'O30809', 'O30811', 'O30812', 'O30813',
        'O30819', 'O30821', 'O30822', 'O30823', 'O30829', 'O30891', 'O30892', 'O30893', 'O30899',
        'O3090', 'O3091', 'O3092', 'O3093', 'O3100X0', 'O3100X1', 'O3100X2', 'O3100X3', 'O3100X4',
        'O3100X5', 'O3100X9', 'O3101X0', 'O3101X1', 'O3101X2', 'O3101X3', 'O3101X4', 'O3101X5',
        'O3101X9', 'O3102X0', 'O3102X1', 'O3102X2', 'O3102X3', 'O3102X4', 'O3102X5', 'O3102X9',
        'O3103X0', 'O3103X1', 'O3103X2', 'O3103X3', 'O3103X4', 'O3103X5', 'O3103X9', 'O3110X0',
        'O3110X1', 'O3110X2', 'O3110X3', 'O3110X4', 'O3110X5', 'O3110X9', 'O3111X0', 'O3111X1',
        'O3111X2', 'O3111X3', 'O3111X4', 'O3111X5', 'O3111X9', 'O3112X0', 'O3112X1', 'O3112X2',
        'O3112X3', 'O3112X4', 'O3112X5', 'O3112X9', 'O3113X0', 'O3113X1', 'O3113X2', 'O3113X3',
        'O3113X4', 'O3113X5', 'O3113X9', 'O3120X0', 'O3120X1', 'O3120X2', 'O3120X3', 'O3120X4',
        'O3120X5', 'O3120X9', 'O3121X0', 'O3121X1', 'O3121X2', 'O3121X3', 'O3121X4', 'O3121X5',
        'O3121X9', 'O3122X0', 'O3122X1', 'O3122X2', 'O3122X3', 'O3122X4', 'O3122X5', 'O3122X9',
        'O3123X0', 'O3123X1', 'O3123X2', 'O3123X3', 'O3123X4', 'O3123X5', 'O3123X9', 'O3130X0',
        'O3130X1', 'O3130X2', 'O3130X3', 'O3130X4', 'O3130X5', 'O3130X9', 'O3131X0', 'O3131X1',
        'O3131X2', 'O3131X3', 'O3131X4', 'O3131X5', 'O3131X9', 'O3132X0', 'O3132X1', 'O3132X2',
        'O3132X3', 'O3132X4', 'O3132X5', 'O3132X9', 'O3133X0', 'O3133X1', 'O3133X2', 'O3133X3',
        'O3133X4', 'O3133X5', 'O3133X9', 'O318X10', 'O318X11', 'O318X12', 'O318X13', 'O318X14',
        'O318X15', 'O318X19', 'O318X20', 'O318X21', 'O318X22', 'O318X23', 'O318X24', 'O318X25',
        'O318X29', 'O318X30', 'O318X31', 'O318X32', 'O318X33', 'O318X34', 'O318X35', 'O318X39',
        'O318X90', 'O318X91', 'O318X92', 'O318X93', 'O318X94', 'O318X95', 'O318X99', 'O320XX0',
        'O320XX1', 'O320XX2', 'O320XX3', 'O320XX4', 'O320XX5', 'O320XX9', 'O321XX0', 'O321XX1',
        'O321XX2', 'O321XX3', 'O321XX4', 'O321XX5', 'O321XX9', 'O322XX0', 'O322XX1', 'O322XX2',
        'O322XX3', 'O322XX4', 'O322XX5', 'O322XX9', 'O323XX0', 'O323XX1', 'O323XX2', 'O323XX3',
        'O323XX4', 'O323XX5', 'O323XX9', 'O324XX0', 'O324XX1', 'O324XX2', 'O324XX3', 'O324XX4',
        'O324XX5', 'O324XX9', 'O326XX0', 'O326XX1', 'O326XX2', 'O326XX3', 'O326XX4', 'O326XX5',
        'O326XX9', 'O328XX0', 'O328XX1', 'O328XX2', 'O328XX3', 'O328XX4', 'O328XX5', 'O328XX9',
        'O329XX0', 'O329XX1', 'O329XX2', 'O329XX3', 'O329XX4', 'O329XX5', 'O329XX9', 'O330',
        'O331', 'O332', 'O333XX0', 'O333XX1', 'O333XX2', 'O333XX3', 'O333XX4', 'O333XX5',
        'O333XX9', 'O334XX0', 'O334XX1', 'O334XX2', 'O334XX3', 'O334XX4', 'O334XX5', 'O334XX9',
        'O335XX0', 'O335XX1', 'O335XX2', 'O335XX3', 'O335XX4', 'O335XX5', 'O335XX9', 'O336XX0',
        'O336XX1', 'O336XX2', 'O336XX3', 'O336XX4', 'O336XX5', 'O336XX9', 'O337', 'O337XX0',
        'O337XX1', 'O337XX2', 'O337XX3', 'O337XX4', 'O337XX5', 'O337XX9', 'O338', 'O339', 'O3400',
        'O3401', 'O3402', 'O3403', 'O3410', 'O3411', 'O3412', 'O3413', 'O3421', 'O34211', 'O34212',
        'O34219', 'O3429', 'O3430', 'O3431', 'O3432', 'O3433', 'O3440', 'O3441', 'O3442', 'O3443',
        'O34511', 'O34512', 'O34513', 'O34519', 'O34521', 'O34522', 'O34523', 'O34529', 'O34531',
        'O34532', 'O34533', 'O34539', 'O34591', 'O34592', 'O34593', 'O34599', 'O3460', 'O3461',
        'O3462', 'O3463', 'O3470', 'O3471', 'O3472', 'O3473', 'O3480', 'O3481', 'O3482', 'O3483',
        'O3490', 'O3491', 'O3492', 'O3493', 'O350XX0', 'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4',
        'O350XX5', 'O350XX9', 'O351XX0', 'O351XX1', 'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5',
        'O351XX9', 'O352XX0', 'O352XX1', 'O352XX2', 'O352XX3', 'O352XX4', 'O352XX5', 'O352XX9',
        'O353XX0', 'O353XX1', 'O353XX2', 'O353XX3', 'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0',
        'O354XX1', 'O354XX2', 'O354XX3', 'O354XX4', 'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1',
        'O355XX2', 'O355XX3', 'O355XX4', 'O355XX5', 'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2',
        'O356XX3', 'O356XX4', 'O356XX5', 'O356XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3',
        'O358XX4', 'O358XX5', 'O358XX9', 'O359XX0', 'O359XX1', 'O359XX2', 'O359XX3', 'O359XX4',
        'O359XX5', 'O359XX9', 'O360110', 'O360111', 'O360112', 'O360113', 'O360114', 'O360115',
        'O360119', 'O360120', 'O360121', 'O360122', 'O360123', 'O360124', 'O360125', 'O360129',
        'O360130', 'O360131', 'O360132', 'O360133', 'O360134', 'O360135', 'O360139', 'O360190',
        'O360191', 'O360192', 'O360193', 'O360194', 'O360195', 'O360199', 'O360910', 'O360911',
        'O360912', 'O360913', 'O360914', 'O360915', 'O360919', 'O360920', 'O360921', 'O360922',
        'O360923', 'O360924', 'O360925', 'O360929', 'O360930', 'O360931', 'O360932', 'O360933',
        'O360934', 'O360935', 'O360939', 'O360990', 'O360991', 'O360992', 'O360993', 'O360994',
        'O360995', 'O360999', 'O361110', 'O361111', 'O361112', 'O361113', 'O361114', 'O361115',
        'O361119', 'O361120', 'O361121', 'O361122', 'O361123', 'O361124', 'O361125', 'O361129',
        'O361130', 'O361131', 'O361132', 'O361133', 'O361134', 'O361135', 'O361139', 'O361190',
        'O361191', 'O361192', 'O361193', 'O361194', 'O361195', 'O361199', 'O361910', 'O361911',
        'O361912', 'O361913', 'O361914', 'O361915', 'O361919', 'O361920', 'O361921', 'O361922',
        'O361923', 'O361924', 'O361925', 'O361929', 'O361930', 'O361931', 'O361932', 'O361933',
        'O361934', 'O361935', 'O361939', 'O361990', 'O361991', 'O361992', 'O361993', 'O361994',
        'O361995', 'O361999', 'O3620X0', 'O3620X1', 'O3620X2', 'O3620X3', 'O3620X4', 'O3620X5',
        'O3620X9', 'O3621X0', 'O3621X1', 'O3621X2', 'O3621X3', 'O3621X4', 'O3621X5', 'O3621X9',
        'O3622X0', 'O3622X1', 'O3622X2', 'O3622X3', 'O3622X4', 'O3622X5', 'O3622X9', 'O3623X0',
        'O3623X1', 'O3623X2', 'O3623X3', 'O3623X4', 'O3623X5', 'O3623X9', 'O364XX0', 'O364XX1',
        'O364XX2', 'O364XX3', 'O364XX4', 'O364XX5', 'O364XX9', 'O365110', 'O365111', 'O365112',
        'O365113', 'O365114', 'O365115', 'O365119', 'O365120', 'O365121', 'O365122', 'O365123',
        'O365124', 'O365125', 'O365129', 'O365130', 'O365131', 'O365132', 'O365133', 'O365134',
        'O365135', 'O365139', 'O365190', 'O365191', 'O365192', 'O365193', 'O365194', 'O365195',
        'O365199', 'O365910', 'O365911', 'O365912', 'O365913', 'O365914', 'O365915', 'O365919',
        'O365920', 'O365921', 'O365922', 'O365923', 'O365924', 'O365925', 'O365929', 'O365930',
        'O365931', 'O365932', 'O365933', 'O365934', 'O365935', 'O365939', 'O365990', 'O365991',
        'O365992', 'O365993', 'O365994', 'O365995', 'O365999', 'O3660X0', 'O3660X1', 'O3660X2',
        'O3660X3', 'O3660X4', 'O3660X5', 'O3660X9', 'O3661X0', 'O3661X1', 'O3661X2', 'O3661X3',
        'O3661X4', 'O3661X5', 'O3661X9', 'O3662X0', 'O3662X1', 'O3662X2', 'O3662X3', 'O3662X4',
        'O3662X5', 'O3662X9', 'O3663X0', 'O3663X1', 'O3663X2', 'O3663X3', 'O3663X4', 'O3663X5',
        'O3663X9', 'O3670X0', 'O3670X1', 'O3670X2', 'O3670X3', 'O3670X4', 'O3670X5', 'O3670X9',
        'O3671X0', 'O3671X1', 'O3671X2', 'O3671X3', 'O3671X4', 'O3671X5', 'O3671X9', 'O3672X0',
        'O3672X1', 'O3672X2', 'O3672X3', 'O3672X4', 'O3672X5', 'O3672X9', 'O3673X0', 'O3673X1',
        'O3673X2', 'O3673X3', 'O3673X4', 'O3673X5', 'O3673X9', 'O368120', 'O368121', 'O368122',
        'O368123', 'O368124', 'O368125', 'O368129', 'O368130', 'O368131', 'O368132', 'O368133',
        'O368134', 'O368135', 'O368139', 'O368190', 'O368191', 'O368192', 'O368193', 'O368194',
        'O368195', 'O368199', 'O368910', 'O368911', 'O368912', 'O368913', 'O368914', 'O368915',
        'O368919', 'O368920', 'O368921', 'O368922', 'O368923', 'O368924', 'O368925', 'O368929',
        'O368930', 'O368931', 'O368932', 'O368933', 'O368934', 'O368935', 'O368939', 'O368990',
        'O368991', 'O368992', 'O368993', 'O368994', 'O368995', 'O368999', 'O3690X0', 'O3690X1',
        'O3690X2', 'O3690X3', 'O3690X4', 'O3690X5', 'O3690X9', 'O3691X0', 'O3691X1', 'O3691X2',
        'O3691X3', 'O3691X4', 'O3691X5', 'O3691X9', 'O3692X0', 'O3692X1', 'O3692X2', 'O3692X3',
        'O3692X4', 'O3692X5', 'O3692X9', 'O3693X0', 'O3693X1', 'O3693X2', 'O3693X3', 'O3693X4',
        'O3693X5', 'O3693X9', 'O401XX0', 'O401XX1', 'O401XX2', 'O401XX3', 'O401XX4', 'O401XX5',
        'O401XX9', 'O402XX0', 'O402XX1', 'O402XX2', 'O402XX3', 'O402XX4', 'O402XX5', 'O402XX9',
        'O403XX0', 'O403XX1', 'O403XX2', 'O403XX3', 'O403XX4', 'O403XX5', 'O403XX9', 'O409XX0',
        'O409XX1', 'O409XX2', 'O409XX3', 'O409XX4', 'O409XX5', 'O409XX9', 'O4100X0', 'O4100X1',
        'O4100X2', 'O4100X3', 'O4100X4', 'O4100X5', 'O4100X9', 'O4101X0', 'O4101X1', 'O4101X2',
        'O4101X3', 'O4101X4', 'O4101X5', 'O4101X9', 'O4102X0', 'O4102X1', 'O4102X2', 'O4102X3',
        'O4102X4', 'O4102X5', 'O4102X9', 'O4103X0', 'O4103X1', 'O4103X2', 'O4103X3', 'O4103X4',
        'O4103X5', 'O4103X9', 'O411010', 'O411011', 'O411012', 'O411013', 'O411014', 'O411015',
        'O411019', 'O411020', 'O411021', 'O411022', 'O411023', 'O411024', 'O411025', 'O411029',
        'O411030', 'O411031', 'O411032', 'O411033', 'O411034', 'O411035', 'O411039', 'O411090',
        'O411091', 'O411092', 'O411093', 'O411094', 'O411095', 'O411099', 'O411210', 'O411211',
        'O411212', 'O411213', 'O411214', 'O411215', 'O411219', 'O411220', 'O411221', 'O411222',
        'O411223', 'O411224', 'O411225', 'O411229', 'O411230', 'O411231', 'O411232', 'O411233',
        'O411234', 'O411235', 'O411239', 'O411290', 'O411291', 'O411292', 'O411293', 'O411294',
        'O411295', 'O411299', 'O411410', 'O411411', 'O411412', 'O411413', 'O411414', 'O411415',
        'O411419', 'O411420', 'O411421', 'O411422', 'O411423', 'O411424', 'O411425', 'O411429',
        'O411430', 'O411431', 'O411432', 'O411433', 'O411434', 'O411435', 'O411439', 'O411490',
        'O411491', 'O411492', 'O411493', 'O411494', 'O411495', 'O411499', 'O418X10', 'O418X11',
        'O418X12', 'O418X13', 'O418X14', 'O418X15', 'O418X19', 'O418X20', 'O418X21', 'O418X22',
        'O418X23', 'O418X24', 'O418X25', 'O418X29', 'O418X30', 'O418X31', 'O418X32', 'O418X33',
        'O418X34', 'O418X35', 'O418X39', 'O418X90', 'O418X91', 'O418X92', 'O418X93', 'O418X94',
        'O418X95', 'O418X99', 'O4190X0', 'O4190X1', 'O4190X2', 'O4190X3', 'O4190X4', 'O4190X5',
        'O4190X9', 'O4191X0', 'O4191X1', 'O4191X2', 'O4191X3', 'O4191X4', 'O4191X5', 'O4191X9',
        'O4192X0', 'O4192X1', 'O4192X2', 'O4192X3', 'O4192X4', 'O4192X5', 'O4192X9', 'O4193X0',
        'O4193X1', 'O4193X2', 'O4193X3', 'O4193X4', 'O4193X5', 'O4193X9', 'O4200', 'O42011',
        'O42012', 'O42013', 'O42019', 'O4202', 'O4210', 'O42111', 'O42112', 'O42113', 'O42119',
        'O4212', 'O4290', 'O42911', 'O42912', 'O42913', 'O42919', 'O4292', 'O43011', 'O43012',
        'O43013', 'O43019', 'O43021', 'O43022', 'O43023', 'O43029', 'O43101', 'O43102', 'O43103',
        'O43109', 'O43111', 'O43112', 'O43113', 'O43119', 'O43121', 'O43122', 'O43123', 'O43129',
        'O43191', 'O43192', 'O43193', 'O43199', 'O43211', 'O43212', 'O43213', 'O43219', 'O43221',
        'O43222', 'O43223', 'O43229', 'O43231', 'O43232', 'O43233', 'O43239', 'O43811', 'O43812',
        'O43813', 'O43819', 'O43891', 'O43892', 'O43893', 'O43899', 'O4390', 'O4391', 'O4392',
        'O4393', 'O4400', 'O4401', 'O4402', 'O4403', 'O4410', 'O4411', 'O4412', 'O4413', 'O4420',
        'O4421', 'O4422', 'O4423', 'O4430', 'O4431', 'O4432', 'O4433', 'O4440', 'O4441', 'O4442',
        'O4443', 'O4450', 'O4451', 'O4452', 'O4453', 'O45001', 'O45002', 'O45003', 'O45009',
        'O45011', 'O45012', 'O45013', 'O45019', 'O45021', 'O45022', 'O45023', 'O45029', 'O45091',
        'O45092', 'O45093', 'O45099', 'O458X1', 'O458X2', 'O458X3', 'O458X9', 'O4590', 'O4591',
        'O4592', 'O4593', 'O46001', 'O46002', 'O46003', 'O46009', 'O46011', 'O46012', 'O46013',
        'O46019', 'O46021', 'O46022', 'O46023', 'O46029', 'O46091', 'O46092', 'O46093', 'O46099',
        'O468X1', 'O468X2', 'O468X3', 'O468X9', 'O4690', 'O4691', 'O4692', 'O4693', 'O4700',
        'O4702', 'O4703', 'O471', 'O479', 'O480', 'O481', 'O6000', 'O6002', 'O6003', 'O6010X0',
        'O6010X1', 'O6010X2', 'O6010X3', 'O6010X4', 'O6010X5', 'O6010X9', 'O6012X0', 'O6012X1',
        'O6012X2', 'O6012X3', 'O6012X4', 'O6012X5', 'O6012X9', 'O6013X0', 'O6013X1', 'O6013X2',
        'O6013X3', 'O6013X4', 'O6013X5', 'O6013X9', 'O6014X0', 'O6014X1', 'O6014X2', 'O6014X3',
        'O6014X4', 'O6014X5', 'O6014X9', 'O6020X0', 'O6020X1', 'O6020X2', 'O6020X3', 'O6020X4',
        'O6020X5', 'O6020X9', 'O6022X0', 'O6022X1', 'O6022X2', 'O6022X3', 'O6022X4', 'O6022X5',
        'O6022X9', 'O6023X0', 'O6023X1', 'O6023X2', 'O6023X3', 'O6023X4', 'O6023X5', 'O6023X9',
        'O610', 'O611', 'O618', 'O619', 'O620', 'O621', 'O622', 'O623', 'O624', 'O628', 'O629',
        'O630', 'O631', 'O632', 'O639', 'O640XX0', 'O640XX1', 'O640XX2', 'O640XX3', 'O640XX4',
        'O640XX5', 'O640XX9', 'O641XX0', 'O641XX1', 'O641XX2', 'O641XX3', 'O641XX4', 'O641XX5',
        'O641XX9', 'O642XX0', 'O642XX1', 'O642XX2', 'O642XX3', 'O642XX4', 'O642XX5', 'O642XX9',
        'O643XX0', 'O643XX1', 'O643XX2', 'O643XX3', 'O643XX4', 'O643XX5', 'O643XX9', 'O644XX0',
        'O644XX1', 'O644XX2', 'O644XX3', 'O644XX4', 'O644XX5', 'O644XX9', 'O645XX0', 'O645XX1',
        'O645XX2', 'O645XX3', 'O645XX4', 'O645XX5', 'O645XX9', 'O648XX0', 'O648XX1', 'O648XX2',
        'O648XX3', 'O648XX4', 'O648XX5', 'O648XX9', 'O649XX0', 'O649XX1', 'O649XX2', 'O649XX3',
        'O649XX4', 'O649XX5', 'O649XX9', 'O650', 'O651', 'O652', 'O653', 'O654', 'O655', 'O658',
        'O659', 'O660', 'O661', 'O662', 'O663', 'O6640', 'O6641', 'O665', 'O666', 'O668', 'O669',
        'O670', 'O678', 'O679', 'O68', 'O690XX0', 'O690XX1', 'O690XX2', 'O690XX3', 'O690XX4',
        'O690XX5', 'O690XX9', 'O691XX0', 'O691XX1', 'O691XX2', 'O691XX3', 'O691XX4', 'O691XX5',
        'O691XX9', 'O692XX0', 'O692XX1', 'O692XX2', 'O692XX3', 'O692XX4', 'O692XX5', 'O692XX9',
        'O693XX0', 'O693XX1', 'O693XX2', 'O693XX3', 'O693XX4', 'O693XX5', 'O693XX9', 'O694XX0',
        'O694XX1', 'O694XX2', 'O694XX3', 'O694XX4', 'O694XX5', 'O694XX9', 'O695XX0', 'O695XX1',
        'O695XX2', 'O695XX3', 'O695XX4', 'O695XX5', 'O695XX9', 'O6981X0', 'O6981X1', 'O6981X2',
        'O6981X3', 'O6981X4', 'O6981X5', 'O6981X9', 'O6982X0', 'O6982X1', 'O6982X2', 'O6982X3',
        'O6982X4', 'O6982X5', 'O6982X9', 'O6989X0', 'O6989X1', 'O6989X2', 'O6989X3', 'O6989X4',
        'O6989X5', 'O6989X9', 'O699XX0', 'O699XX1', 'O699XX2', 'O699XX3', 'O699XX4', 'O699XX5',
        'O699XX9', 'O700', 'O701', 'O702', 'O7020', 'O7021', 'O7022', 'O7023', 'O703', 'O709',
        'O7100', 'O7102', 'O7103', 'O711', 'O712', 'O713', 'O714', 'O715', 'O716', 'O717', 'O7181',
        'O7182', 'O7189', 'O719', 'O720', 'O721', 'O722', 'O723', 'O730', 'O731', 'O740', 'O741',
        'O742', 'O743', 'O744', 'O745', 'O746', 'O747', 'O748', 'O749', 'O750', 'O751', 'O752',
        'O753', 'O754', 'O755', 'O7581', 'O7582', 'O7589', 'O759', 'O76', 'O770', 'O771', 'O778',
        'O779', 'O80', 'O82', 'O860', 'O8611', 'O8613', 'O8619', 'O8620', 'O8621', 'O8622',
        'O8629', 'O864', 'O8689', 'O870', 'O872', 'O874', 'O878', 'O88011', 'O88012', 'O88013',
        'O88019', 'O8802', 'O8803', 'O88111', 'O88112', 'O88113', 'O88119', 'O8812', 'O8813',
        'O88311', 'O88312', 'O88313', 'O88319', 'O8832', 'O8833', 'O88811', 'O88812', 'O88813',
        'O88819', 'O8882', 'O8883', 'O8909', 'O893', 'O894', 'O895', 'O896', 'O898', 'O899',
        'O900', 'O901', 'O902', 'O903', 'O904', 'O905', 'O906', 'O9089', 'O909', 'O91011',
        'O91012', 'O91013', 'O91019', 'O9102', 'O91111', 'O91112', 'O91113', 'O91119', 'O9112',
        'O91211', 'O91212', 'O91213', 'O91219', 'O9122', 'O9123', 'O92011', 'O92012', 'O92013',
        'O92019', 'O9202', 'O9203', 'O92111', 'O92112', 'O92113', 'O92119', 'O9212', 'O9213',
        'O9220', 'O9229', 'O923', 'O924', 'O925', 'O926', 'O9270', 'O9279', 'O94', 'O98011',
        'O98012', 'O98013', 'O98019', 'O9802', 'O9803', 'O98111', 'O98112', 'O98113', 'O98119',
        'O9812', 'O9813', 'O98211', 'O98212', 'O98213', 'O98219', 'O9822', 'O9823', 'O98311',
        'O98312', 'O98313', 'O98319', 'O9832', 'O9833', 'O98411', 'O98412', 'O98413', 'O98419',
        'O9842', 'O9843', 'O98511', 'O98512', 'O98513', 'O98519', 'O9852', 'O9853', 'O98611',
        'O98612', 'O98613', 'O98619', 'O9862', 'O9863', 'O98711', 'O98712', 'O98713', 'O98719',
        'O9872', 'O9873', 'O98811', 'O98812', 'O98813', 'O98819', 'O9882', 'O9883', 'O98911',
        'O98912', 'O98913', 'O98919', 'O9892', 'O9893', 'O99011', 'O99012', 'O99013', 'O99019',
        'O9902', 'O9903', 'O99111', 'O99112', 'O99113', 'O99119', 'O9912', 'O9913', 'O99210',
        'O99211', 'O99212', 'O99213', 'O99214', 'O99215', 'O99280', 'O99281', 'O99282', 'O99283',
        'O99284', 'O99285', 'O99310', 'O99311', 'O99312', 'O99313', 'O99314', 'O99320', 'O99321',
        'O99322', 'O99323', 'O99324', 'O99325', 'O99330', 'O99331', 'O99332', 'O99333', 'O99334',
        'O99335', 'O99340', 'O99341', 'O99342', 'O99343', 'O99344', 'O99345', 'O99350'
    }

    SNOMEDCT = {
        '10217006', '102882004', '102885002', '10562009', '10573002', '106004004', '106005003',
        '106007006', '106008001', '106009009', '106010004', '106011000', '10742471000119108',
        '10743831000119100', '10749641000119106', '10749691000119103', '10749811000119108',
        '10750551000119100', '10752771000119100', '10756101000119107', '10756301000119105',
        '10759231000119102', '10759841000119105', '10759961000119102', '10760341000119101',
        '10760981000119107', '10761061000119107', '10835971000119109', '10853001', '10884004',
        '109562007', '109891004', '109892006', '109893001', '109894007', '109895008', '111208003',
        '111425004', '111431001', '111432008', '111438007', '111440002', '111443000', '111444006',
        '111445007', '111447004', '111451002', '111452009', '111453004', '111454005', '111458008',
        '111459000', '112073004', '11209007', '11246006', '1125006', '11454006', '11511004',
        '11612004', '11618000', '11669000', '11687002', '11763009', '11914001', '11942004',
        '12095001', '123667006', '124736009', '125586008', '12729009', '128076000', '128077009',
        '12867002', '129597002', '129598007', '12983003', '13010001', '130958001', '1343000',
        '13842006', '13866000', '13943000', '14022007', '14094001', '14331002', '1474004',
        '14918004', '15196006', '15230009', '1538006', '15394000', '15400003', '15406009',
        '15504009', '15539009', '15663008', '15692007', '1592005', '15938005', '16083003',
        '1621000119101', '163515002', '163516001', '1639007', '16574001', '16607004', '16756008',
        '16950007', '169581008', '169593004', '169958000', '171000119107', '17263003', '173300003',
        '17380002', '17382005', '17433009', '17532001', '17594002', '17787002', '178280004',
        '18237006', '18260003', '18416000', '18471004', '18559007', '18606002', '18656007',
        '19099008', '19117007', '19228003', '19236007', '19258009', '19363005', '1938002',
        '19569008', '196040003', '19729005', '19773009', '198347000', '198609003', '198620003',
        '198644001', '198645000', '198646004', '198648003', '198655001', '198656000', '19866007',
        '198705001', '198706000', '198707009', '198708004', '198709007', '198710002', '198711003',
        '198718009', '198719001', '198720007', '198721006', '198722004', '198723009', '198724003',
        '198744009', '198745005', '198756005', '198757001', '198806007', '198807003', '198808008',
        '198809000', '198810005', '198811009', '198812002', '198832001', '198874006', '198875007',
        '198876008', '198878009', '198899007', '198900002', '198903000', '198905007', '198906008',
        '198910006', '198911005', '198912003', '198917009', '198918004', '198920001', '198922009',
        '198923004', '198925006', '198927003', '198928008', '198941007', '198942000', '198944004',
        '198945003', '198946002', '198947006', '198949009', '198951008', '198952001', '198953006',
        '198954000', '198965005', '198966006', '198967002', '198968007', '198983002', '198984008',
        '198985009', '198986005', '198990007', '198991006', '198992004', '198993009', '198997005',
        '198999008', '199000005', '199002002', '199003007', '199004', '199005000', '199006004',
        '199007008', '199008003', '199022003', '199023008', '199025001', '199027009', '199028004',
        '199032005', '199033000', '199047001', '199049003', '199050003', '199063009', '199064003',
        '199069008', '199070009', '199093003', '199094009', '199095005', '199096006', '199099004',
        '199100007', '199101006', '199102004', '199106001', '199107005', '199108000', '199109008',
        '199110003', '199111004', '199112006', '199117000', '199118005', '199121007', '199122000',
        '199123005', '199124004', '199127006', '199128001', '199129009', '199130004', '199139003',
        '199141002', '199153003', '199154009', '199156006', '199157002', '199158007', '199159004',
        '199161008', '199163006', '199164000', '199165004', '199166003', '199175001', '199178004',
        '199179007', '199180005', '199181009', '199183007', '199185000', '199186004', '199187008',
        '199188003', '199192005', '199193000', '199194006', '199195007', '199203001', '199205008',
        '199206009', '199223000', '199225007', '199227004', '199244000', '199245004', '199257008',
        '199259006', '199261002', '199266007', '199267003', '199279003', '199281001', '199282008',
        '199283003', '199284009', '199293005', '199294004', '199295003', '199296002', '199297006',
        '199305006', '199306007', '199307003', '199308008', '199314001', '199318003', '199321001',
        '199322008', '199325005', '199326006', '199344003', '199345002', '199355003', '199358001',
        '199359009', '199362007', '199363002', '199373000', '199375007', '199376008', '199378009',
        '199380003', '199381004', '199384007', '199385008', '199397009', '199405005', '199406006',
        '199409004', '199410009', '199413006', '199414000', '199416003', '199418002', '199419005',
        '199422007', '199423002', '199425009', '199427001', '199428006', '199446000', '199461004',
        '199463001', '199464007', '199466009', '199468005', '199469002', '199470001', '199471002',
        '199482005', '199483000', '199484006', '199485007', '199511005', '199512003', '199513008',
        '199514002', '199531009', '199533007', '199534001', '199551008', '199560000', '199561001',
        '199577000', '199578005', '199582007', '199583002', '199595002', '199596001', '199597005',
        '199598000', '199607009', '199608004', '199646006', '199647002', '199653002', '199654008',
        '199658006', '199659003', '199660008', '199661007', '199662000', '199670005', '199672002',
        '199673007', '199677008', '199678003', '199694005', '199695006', '199710008', '199711007',
        '199714004', '199715003', '199718001', '199719009', '199741009', '199745000', '199746004',
        '199747008', '199749006', '199750006', '199751005', '199752003', '199753008', '199754002',
        '199755001', '199757009', '199759007', '199760002', '199761003', '199762005', '199763000',
        '199764006', '199765007', '199767004', '199769001', '199770000', '199774009', '199775005',
        '199783004', '199784005', '199806003', '199819004', '199821009', '199824001', '199825000',
        '199833004', '199834005', '199838008', '199839000', '199847000', '199848005', '199857004',
        '199858009', '199860006', '199862003', '199863008', '199869007', '199870008', '199874004',
        '199875003', '199880007', '199881006', '199889008', '199890004', '199895009', '199896005',
        '199900008', '199901007', '199916005', '199917001', '199925004', '199926003', '199930000',
        '199931001', '199934009', '199935005', '199958008', '199960005', '199961009', '199964001',
        '199965000', '199969006', '199970007', '199972004', '199974003', '199975002', '199977005',
        '199979008', '199980006', '199990003', '199991004', '199993001', '199997000', '200025008',
        '200030007', '200031006', '200038000', '200040005', '200043007', '200046004', '200049006',
        '200050006', '200051005', '200054002', '200056000', '200057009', '200058004', '200061003',
        '200063000', '200064006', '200065007', '200066008', '200068009', '200069001', '200070000',
        '200071001', '200072008', '200074009', '200075005', '200077002', '200078007', '200080001',
        '200099005', '200100002', '200101003', '200102005', '200105007', '200106008', '200111005',
        '200112003', '200113008', '200114002', '200117009', '200125006', '200146002', '200164009',
        '200173001', '200204002', '200206000', '200207009', '200215007', '200216008', '200222004',
        '200224003', '200249004', '200251000', '200252007', '200253002', '200254008', '200277008',
        '200280009', '200284000', '200286003', '200288002', '200289005', '200294005', '200295006',
        '200299000', '200301007', '200302000', '200308001', '200309009', '200310004', '200311000',
        '200330000', '200331001', '200337002', '200338007', '200342005', '200343000', '200351002',
        '200367008', '200368003', '200369006', '200370007', '200374003', '200375002', '200376001',
        '200377005', '200381005', '200382003', '200383008', '200385001', '200402001', '200404000',
        '200405004', '200406003', '200407007', '200411001', '200412008', '200413003', '200414009',
        '200439000', '200440003', '200441004', '200442006', '200444007', '200446009', '200447000',
        '200448005', '200449002', '200469007', '200471007', '200472000', '200473005', '200474004',
        '20391007', '204470001', '206079007', '206082002', '206089006', '206102001', '206148005',
        '206244002', '20625004', '206365006', '206366007', '20753005', '20845005', '20956009',
        '21280005', '2132004', '21334005', '21346009', '2138000', '21504004', '21737000',
        '21987001', '22033007', '22173004', '22271007', '22288000', '223003', '2261009',
        '22753004', '22846003', '22966008', '23001005', '23171006', '23332002', '234058009',
        '23431000119106', '23508005', '235888006', '23695007', '237088009', '23717007',
        '237186006', '237188007', '237189004', '237190008', '237198001', '237201006', '237202004',
        '237205002', '237206001', '237208000', '237209008', '237227006', '237235009', '237236005',
        '237237001', '237245006', '237246007', '237247003', '237249000', '237250000', '237254009',
        '237256006', '237257002', '237259004', '237260009', '237261008', '237266003', '237267007',
        '237270006', '237271005', '237272003', '237273008', '237274002', '237275001', '237276000',
        '237277009', '237279007', '237281009', '237282002', '237283007', '237284001', '237285000',
        '237286004', '237288003', '237292005', '237294006', '237296008', '237297004', '237300009',
        '237302001', '237303006', '237304000', '237305004', '237306003', '237307007', '237309005',
        '237310000', '237321009', '237325000', '237327008', '237328003', '237329006', '237336007',
        '237337003', '237338008', '237342006', '237343001', '237345008', '237346009', '237347000',
        '237348005', '237349002', '237350002', '237351003', '237352005', '237355007', '237357004',
        '237363008', '237627000', '23786008', '23885003', '239104000', '239105004', '23960006',
        '240167004', '240322003', '24042004', '24051007', '24082006', '24095001', '24258008',
        '24342007', '2437000', '24444009', '24536007', '24699006', '248996001', '249064003',
        '249065002', '249084004', '249085003', '249086002', '249087006', '249088001', '249089009',
        '249090000', '249091001', '249094009', '249095005', '249096006', '249098007', '249099004',
        '249100007', '249102004', '249103009', '249104003', '249105002', '249106001', '249107005',
        '249108000', '249109008', '249189006', '249196008', '249218000', '249219008', '249220002',
        '25032009', '25053000', '25113000', '25585008', '25691001', '25725007', '25749005',
        '25825004', '25922000', '26078007', '26158002', '26224003', '26358008', '26528001',
        '26623000', '26644000', '267197003', '267199000', '267204006', '267207004', '267219007',
        '267257007', '267262008', '267265005', '267266006', '267268007', '267271004', '267272006',
        '267273001', '267276009', '267280004', '267282007', '267283002', '267284008', '267289003',
        '267291006', '267317007', '267320004', '267322007', '267335003', '267340006', '267350007',
        '26741000', '26828006', '26840006', '26850007', '268585006', '268863005', '268864004',
        '268865003', '270498000', '270500004', '270502007', '27068000', '27075004', '271372000',
        '27152008', '27169005', '271954000', '27214003', '27215002', '27342004', '27388005',
        '273983009', '274117006', '274118001', '274119009', '274121004', '274126009', '275412000',
        '275426009', '275427000', '275429002', '275434003', '276369006', '276462003', '276479009',
        '276604007', '276879000', '276881003', '27696007', '2781009', '27921008', '280732008',
        '282020008', '28357009', '283963001', '284075002', '28608002', '286996009', '28735000',
        '28773001', '287979001', '288207006', '288208001', '288250001', '288261009', '28911003',
        '289240005', '289254002', '289311005', '289312003', '289355004', '289356003', '289357007',
        '289358002', '289365005', '289366006', '289367002', '289368007', '289399008', '29057008',
        '291665000', '29171003', '29259002', '29399001', '29421008', '29847008', '29950007',
        '300927001', '302078000', '302644007', '302929008', '302945005', '303063000', '3033000',
        '30506002', '307333004', '307534009', '307632004', '307734007', '307735008', '307749004',
        '307752007', '308133005', '308134004', '308135003', '308136002', '308137006', '308140006',
        '308187004', '30850008', '31026002', '310592002', '310594001', '310650002', '312652001',
        '312653006', '312654000', '312656003', '312657007', '312974005', '312977003', '312988009',
        '312989001', '312990005', '313017000', '313291009', '31383003', '31407004', '31481000',
        '31516002', '31563000', '31805001', '31821006', '32808002', '32999002', '33058001',
        '33128005', '33370009', '33490001', '33552005', '33627001', '34150001', '34165000',
        '34242002', '34262005', '34273003', '34327003', '34367002', '34430009', '34478009',
        '34530006', '34694006', '34801009', '34842007', '34981006', '35208003', '35255008',
        '35258005', '35303009', '35347003', '35381000119101', '35716006', '35746009', '35882009',
        '35999006', '361095003', '361096002', '36297009', '363093002', '36323001', '3634007',
        '364748006', '36497006', '36664002', '36697001', '367390009', '36801000119105', '36813001',
        '36854009', '36916008', '371374003', '371375002', '371380006', '37139009', '37141005',
        '371607000', '371614003', '373680009', '37382001', '37618003', '37762002', '38010008',
        '38049006', '38099005', '38176009', '38331001', '38451000119105', '38534008', '38720006',
        '3873005', '387692004', '387696001', '387699008', '387700009', '3885002', '388602007',
        '388604008', '388605009', '38951007', '39120007', '39208009', '392280004', '39246002',
        '39249009', '3944006', '39587000', '396544001', '39727004', '39763004', '397752008',
        '397949005', '397952002', '398019008', '39804004', '398254007', '398262004', '398276003',
        '399031001', '399363000', '4006006', '40096002', '40125005', '40193008', '4026005',
        '405736009', '40609001', '408812003', '41114007', '41215002', '413339006', '413567003',
        '415105001', '415810004', '416669000', '41679006', '417044008', '417150000', '417364008',
        '4174008', '417426005', '41962002', '41991004', '42070007', '42537006', '42553009',
        '425708006', '42571002', '42599006', '42686001', '426997005', '427139004', '428017002',
        '428165003', '428230005', '428252001', '428511009', '428707000', '429187001', '430881000',
        '430883002', '430933008', '43195002', '43293004', '43629001', '43651009', '43715006',
        '439107005', '43957006', '43970002', '43990006', '44216000', '44223004', '442478007',
        '443006', '443460007', '444661007', '44640004', '44772007', '44795003', '44918005',
        '449807005', '449808000', '449809008', '44992005', '45079001', '45759004', '45828008',
        '46273003', '46311005', '46365005', '46502006', '46764007', '46848006', '46894009',
        '47161002', '47200007', '472321009', '47236005', '4752007', '47780009', '47821001',
        '48194001', '48200009', '48287005', '48552006', '48782003', '48888007', '48906005',
        '4907004', '4910006', '49102001', '49168004', '49171007', '49177006', '49279000',
        '49342001', '49364005', '49416000', '49561003', '49815007', '50120008', '50557007',
        '50726009', '5074003', '50764006', '50844007', '51096002', '51154004', '51195001',
        '51495008', '51519001', '51920004', '52327008', '52700006', '52772002', '53024001',
        '53111003', '53419009', '53443007', '54048003', '54212005', '54213000', '54449002',
        '54486001', '54679003', '54844002', '55472006', '55565007', '55581002', '55613002',
        '55639004', '55704005', '5626004', '56313000', '56425003', '56451001', '56462001',
        '57220000', '57296000', '5740008', '57480000', '57576007', '57734001', '57759005',
        '57873008', '58071009', '58123006', '58261003', '5852008', '58703003', '58881007',
        '58903006', '59136001', '5939002', '5945005', '59534005', '59566000', '5973007',
        '59733002', '59795007', '59919008', '60574005', '60601008', '60755004', '60810003',
        '60854009', '609447002', '609448007', '609449004', '609451000', '609452007', '609453002',
        '609455009', '609457001', '609458006', '609459003', '609460008', '609465003', '609472002',
        '609479006', '609480009', '609485004', '609486003', '609487007', '609489005', '609491002',
        '609506003', '609525000', '609563008', '609564002', '609566000', '609567009', '6096002',
        '61007003', '61452007', '61714007', '61951009', '62023000', '62129004', '62131008',
        '6234006', '62377009', '62410004', '62531004', '62612003', '62657007', '63040001',
        '63287004', '63637002', '63662002', '63750008', '6383007', '64171002', '64181003',
        '64229006', '64230001', '64254006', '64433002', '64646001', '64954002', '65147003',
        '65377004', '65402008', '65409004', '65483000', '65539006', '6594005', '66064007',
        '66119008', '66294006', '663008', '6636004', '66709007', '66844003', '66892003',
        '66958002', '67042008', '67229002', '67359005', '67480003', '67802002', '67881007',
        '682004', '68214002', '6825008', '68635007', '6891008', '69018001', '69217004', '69270005',
        '698716002', '698717006', '69897008', '69909000', '699240001', '6995000', '699950009',
        '70068004', '70129008', '70137000', '702711004', '70603007', '71028008', '71151000119105',
        '71473008', '71531003', '71612002', '71639005', '71874008', '71901000', '72022006',
        '7245003', '7266006', '72860003', '73030000', '73161006', '73790007', '73837001',
        '73972002', '74955002', '75022004', '7504005', '75094005', '75150001', '75428007',
        '75798003', '75825001', '75836008', '75933004', '76037007', '76380008', '76751001',
        '76771005', '76871004', '76889003', '77186001', '77259008', '77278008', '77285007',
        '77376005', '77563000', '7768008', '77854008', '77913004', '7792000', '7822001',
        '78381004', '78408007', '78697003', '78789000', '78808002', '79133008', '79179003',
        '79222000', '79255005', '79355007', '79414005', '79586000', '79643007', '79668009',
        '79748007', '79839005', '79884007', '79888005', '79986005', '80002007', '80113008',
        '80190007', '80224003', '80256005', '8076000', '80818002', '80847009', '80997009',
        '81448000', '81521003', '81557008', '81626002', '81677009', '8218002', '82661006',
        '82664003', '83094001', '83243004', '83741001', '83787007', '83916000', '8393005',
        '84007008', '84235001', '84357006', '8445003', '84693004', '85076009', '85542007',
        '86041002', '86081009', '86196005', '86203003', '86256001', '86356004', '86687009',
        '86891002', '87043009', '871005', '87383005', '8762007', '87621000', '87814002',
        '87840008', '88697005', '8884000', '88887003', '88895004', '88980002', '88992002',
        '89244003', '89550007', '89672000', '89700002', '90009001', '90127001', '90188009',
        '90325002', '90532005', '90645002', '90968009', '9107002', '91153002', '91162000',
        '91217009', '91484005', '91948008', '92297008', '9293002', '9297001', '9442009',
        '95605009', '95606005', '95607001', '95608006', '97161000119106', '9720009', '9780006',
        '9864005', '9899009', '9901000'
    }


class ObstetricsVte(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have a venous thromboembolism related to pregnancy or obstetrics.
    Data Element Scope: The intent of this data element is to identify patients who have a venous thromboembolism related to pregnancy or obstetrics. Using the Quality Data Model, this particular element would map to the Diagnosis category or the Diagnosis attribute for the Encounter category.
    Inclusion Criteria: Only use codes which represent a venous thromboembolism related to pregnancy or obstetrics.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.264'
    VALUE_SET_NAME = 'Obstetrics VTE'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'O032', 'O0335', 'O037', 'O047', 'O072', 'O0735', 'O082', 'O2230', 'O2231', 'O2232',
        'O2233', 'O2250', 'O2251', 'O2252', 'O2253', 'O228X1', 'O228X2', 'O228X3', 'O228X9',
        'O2290', 'O2291', 'O2292', 'O2293', 'O870', 'O871', 'O873', 'O879', 'O88211', 'O88212',
        'O88213', 'O88219', 'O8822', 'O8823'
    }

    ICD9CM = {
        '63460', '63461', '63462', '63560', '63561', '63562', '63660', '63661', '63662', '63760',
        '63761', '63762', '6386', '6396', '67130', '67131', '67133', '67140', '67142', '67144',
        '67150', '67151', '67152', '67153', '67154', '67190', '67191', '67192', '67193', '67194',
        '67320', '67321', '67322', '67323', '67324'
    }

    SNOMEDCT = {
        '13943000', '19363005', '198876008', '200232006', '200233001', '200237000', '200238005',
        '200284000', '200299000', '200301007', '200302000', '200303005', '200304004', '21604008',
        '267280004', '26743002', '280966008', '37787009', '43306002', '49956009', '51096002',
        '55589000', '55976003', '56272000', '56462001', '57734001', '58123006', '609497003',
        '62583006', '63795001', '663008', '72044001', '82153002', '84216001', '88980002'
    }


class ParenteralAnticoagulant(ValueSet):
    """

    Clinical Focus: This set of values represents anticoagulant medications used for VTE treatment.  The medications included in this value set are administered parenterally.
    Data Element Scope: The intent of this data element is to identify patients who are on anticoagulant medications for VTE treatment.  These anticoagulants are only those which are administered parenterally.  Using the Quality Data Model, this data element maps to the Medication category.
    Inclusion Criteria: Include parenteral anticoagulants used to treat VTE, including low molecular weight heparins, unfractionated heaprin, direct thrombin inhibitors, and injectable oral factor Xa.  Include heparin injectable solutions with concentrations 40 UNT/ML, 50 UNT/ML and 100 UNT/ML, as these represent premixed heparin infusion bags.
    Exclusion Criteria: Exclude heparin products that would not reasonably be used to achieve a full therapeutic dose (at least 10000 units).
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.266'
    VALUE_SET_NAME = 'Parenteral Anticoagulant'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1110708', '1361574', '1361607', '1361615', '1362831', '1658637', '1658717', '1658720',
        '1659195', '1659197', '308351', '308769', '854228', '854235', '854238', '854241', '854245',
        '854248', '854252', '854255', '861356', '861360', '861363', '861365', '978713', '978725',
        '978733', '978736', '978738', '978740', '978744', '978746', '978755', '978759', '978777'
    }


class PlateletCount(ValueSet):
    """

    Clinical Focus: This set of values contains laboratory test most commonly used for platelet count.
    Data Element Scope: The intent of this data element is to identify laboratory test for a platelet count.  Using the Quality Data Model, this particular element will map to the "Laboratory test" category.
    Inclusion Criteria: Codes representing platelet count using the LOINC code system.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.267'
    VALUE_SET_NAME = 'Platelet Count'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'13056-7', '15201-7', '26515-7', '26516-5', '49497-1', '71692-8', '777-3', '778-1'}


class NationalInstituteOfHealthStrokeScale(ValueSet):
    """

    Clinical Focus: This set of includes the value of National Institute of Health Stroke Scale assessment.
    Data Element Scope: The intent of this data element is to identify patients who received an National Institute of Health Stroke Assessment. Using the Quality Data Model, this particular element will map to the "Risk Category Assessment" category.
    Inclusion Criteria: Codes representing the National Institute of Health Stroke Assessment using the LOINC code system.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.269'
    VALUE_SET_NAME = 'National Institute of Health Stroke Scale'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'72089-6'}


class DietaryIntakeOtherThanBreastMilk(ValueSet):
    """

    Clinical Focus: This set of values represent dietary intake other than breast milk.
    Data Element Scope: The intent of this data element is to identify dietary intake other than breast milk. Using the Quality Data Model, this particular element will map to the "substance" category.
    Inclusion Criteria: Include SNOMED CT codes that identify dietary intake other than breast milk.
    Exclusion Criteria: Exclude codes that represent breast milk.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.27'
    VALUE_SET_NAME = 'Dietary Intake Other than Breast Milk'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '11713004', '284458003', '284459006', '284461002', '346712003', '386127005', '412413001',
        '412414007', '67079006'
    }


class Asthma(ValueSet):
    """

    Clinical Focus: This grouping value set contains codes indicative of a diagnosis of asthma.
    Data Element Scope: The intent of this data element is to identify patients who have a diagnosis of asthma.  Using the Quality Data Model, this particular element will map to the Diagnosis attribute for the Encounter category.
    Inclusion Criteria: Include codes representing any form of asthma. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED-CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.271'
    VALUE_SET_NAME = 'Asthma'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'J4520', 'J4521', 'J4522', 'J4530', 'J4531', 'J4532', 'J4540', 'J4541', 'J4542', 'J4550',
        'J4551', 'J4552', 'J45901', 'J45902', 'J45909', 'J45990', 'J45991', 'J45998'
    }

    ICD9CM = {
        '49300', '49301', '49302', '49310', '49311', '49312', '49381', '49382', '49390', '49391',
        '49392'
    }

    SNOMEDCT = {
        '10674711000119105', '10675431000119106', '10675471000119109', '10675551000119104',
        '10675871000119106', '10675911000119109', '10675991000119100', '10676391000119108',
        '10676431000119103', '10676511000119109', '10692721000119102', '12428000',
        '124991000119109', '125001000119103', '125011000119100', '125021000119107',
        '135171000119106', '135181000119109', '1741000119102', '1751000119100', '195949008',
        '195967001', '195977004', '225057002', '233678006', '233679003', '233683003',
        '2360001000004109', '266361008', '281239006', '30352005', '304527002', '31387002',
        '370218001', '370219009', '370220003', '370221004', '389145006', '401000119107',
        '405944004', '409663006', '423889005', '424643009', '425969006', '426656000', '426979002',
        '427295004', '427603009', '427679007', '442025000', '445427006', '5281000124103',
        '55570000', '63088003', '641000119106', '707444001', '707445000', '707446004', '707447008',
        '707511009', '707512002', '707513007', '707979007', '707980005', '707981009', '708038006',
        '708090002', '708093000', '708094006', '708095007', '708096008', '901000119100',
        '99031000119107'
    }


class UrologicalSurgery(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have urologic surgery procedures.
    Data Element Scope: The intent of this data element is to identify patients who have a urologic surgery procedure.  Using the Quality Data Model, this particular element will map to the Procedure category.
    Inclusion Criteria: Only use codes which represent urologic surgery procedures.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.272'
    VALUE_SET_NAME = 'Urological Surgery'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0T1307B', '0T130JB', '0T130KB', '0T130ZB', '0T1407B', '0T140JB', '0T140KB', '0T140ZB',
        '0T16076', '0T16077', '0T16078', '0T1607A', '0T1607B', '0T1607C', '0T160J6', '0T160J7',
        '0T160J8', '0T160JA', '0T160JB', '0T160JC', '0T160K6', '0T160K7', '0T160K8', '0T160KA',
        '0T160KB', '0T160KC', '0T160Z6', '0T160Z7', '0T160Z8', '0T160ZA', '0T160ZB', '0T160ZC',
        '0T17076', '0T17077', '0T17078', '0T1707A', '0T1707B', '0T1707C', '0T170J6', '0T170J7',
        '0T170J8', '0T170JA', '0T170JB', '0T170JC', '0T170K6', '0T170K7', '0T170K8', '0T170KA',
        '0T170KB', '0T170KC', '0T170Z6', '0T170Z7', '0T170Z8', '0T170ZA', '0T170ZB', '0T170ZC',
        '0T18076', '0T18077', '0T18078', '0T1807A', '0T1807B', '0T1807C', '0T180J6', '0T180J7',
        '0T180J8', '0T180JA', '0T180JB', '0T180JC', '0T180K6', '0T180K7', '0T180K8', '0T180KA',
        '0T180KB', '0T180KC', '0T180Z6', '0T180Z7', '0T180Z8', '0T180ZA', '0T180ZB', '0T180ZC',
        '0T1B079', '0T1B07C', '0T1B07D', '0T1B0J9', '0T1B0JC', '0T1B0JD', '0T1B0K9', '0T1B0KC',
        '0T1B0KD', '0T1B0Z9', '0T1B0ZC', '0T7B0DZ', '0T7B0ZZ', '0T7B7DZ', '0T7B7ZZ', '0T7B8DZ',
        '0T7B8ZZ', '0T9300Z', '0T930ZZ', '0T9400Z', '0T940ZZ', '0TB00ZZ', '0TB07ZZ', '0TB08ZZ',
        '0TB10ZZ', '0TB17ZZ', '0TB18ZZ', '0TB30ZZ', '0TB37ZZ', '0TB38ZZ', '0TB40ZZ', '0TB47ZZ',
        '0TB48ZZ', '0TBB0ZZ', '0TBC0ZZ', '0TJ50ZZ', '0TMB0ZZ', '0TMC0ZZ', '0TN00ZZ', '0TN07ZZ',
        '0TN08ZZ', '0TN10ZZ', '0TN17ZZ', '0TN18ZZ', '0TN30ZZ', '0TN37ZZ', '0TN38ZZ', '0TN40ZZ',
        '0TN47ZZ', '0TN48ZZ', '0TN60ZZ', '0TN70ZZ', '0TQ60ZZ', '0TQ67ZZ', '0TQ68ZZ', '0TQ70ZZ',
        '0TQ77ZZ', '0TQ78ZZ', '0TQB0ZZ', '0TQB7ZZ', '0TQB8ZZ', '0TQC0ZZ', '0TQC7ZZ', '0TQC8ZZ',
        '0TRB07Z', '0TRB0JZ', '0TRB0KZ', '0TRB77Z', '0TRB7JZ', '0TRB7KZ', '0TRB87Z', '0TRB8JZ',
        '0TRB8KZ', '0TRC07Z', '0TRC0JZ', '0TRC0KZ', '0TRC77Z', '0TRC7JZ', '0TRC7KZ', '0TRC87Z',
        '0TRC8JZ', '0TRC8KZ', '0TSB0ZZ', '0TT00ZZ', '0TT10ZZ', '0TT20ZZ', '0TT30ZZ', '0TT37ZZ',
        '0TT38ZZ', '0TT40ZZ', '0TT47ZZ', '0TT48ZZ', '0TTB0ZZ', '0TTB7ZZ', '0TTB8ZZ', '0TTC0ZZ',
        '0TTC7ZZ', '0TTC8ZZ', '0TTD0ZZ', '0TTD7ZZ', '0TTD8ZZ', '0TUB07Z', '0TUB0JZ', '0TUB0KZ',
        '0TUB77Z', '0TUB7JZ', '0TUB7KZ', '0TUB87Z', '0TUB8JZ', '0TUB8KZ', '0TVB0CZ', '0TVB0DZ',
        '0TVB0ZZ', '0TVB7DZ', '0TVB7ZZ', '0TVB8DZ', '0TVB8ZZ', '0TVC0CZ', '0TVC0DZ', '0TVC0ZZ',
        '0TVC7DZ', '0TVC7ZZ', '0TVC8DZ', '0TVC8ZZ', '0VT00ZZ', '0VT07ZZ', '0VT08ZZ', '0VT30ZZ',
        '0WBH0ZZ', '0WQF0ZZ', '0WQFXZ2', '0WQFXZZ'
    }

    SNOMEDCT = {
        '108022006', '108034003', '11050006', '112902005', '116033007', '116166009', '119991007',
        '12976005', '13246003', '13991004', '15044006', '15918009', '16068008', '175905003',
        '175907006', '175908001', '175911000', '175912007', '175913002', '175916005', '175917001',
        '175918006', '176004009', '176024008', '176106009', '176107000', '176108005', '176117005',
        '176118000', '176123000', '176132003', '176144000', '176165006', '176234008', '176260009',
        '176275001', '176722004', '18008000', '18280002', '1866009', '19149007', '21338008',
        '21482000', '22783008', '22829001', '2344008', '236139004', '236140002', '236165000',
        '236167008', '236209003', '236210008', '236211007', '236213005', '236214004', '236215003',
        '236216002', '236219009', '236247008', '236251005', '240325001', '24221008', '243306000',
        '24677003', '25466008', '277837003', '2813008', '281416002', '28579000', '28609005',
        '287716007', '287718008', '287720006', '287721005', '287722003', '287723008', '288013007',
        '288014001', '289754003', '290691008', '32417007', '33654003', '34006000', '361249003',
        '361256009', '361257000', '36253005', '36432003', '36586008', '36935008', '386652006',
        '387707007', '39214002', '41416003', '439110003', '439235001', '439497008', '439739008',
        '439964001', '440076006', '440446009', '442919002', '443869003', '444083005', '446296004',
        '446586007', '446894005', '446990000', '447307008', '447308003', '447527008', '447531002',
        '48007004', '4895001', '49780003', '49935007', '51870000', '52969004', '533005', '535003',
        '54033009', '56256008', '56614001', '57212002', '63016009', '63361002', '64063003',
        '65551008', '66633009', '67113002', '67212000', '67598001', '68960009', '69926006',
        '71550003', '73380001', '73953002', '73966002', '74146001', '76414006', '78062004',
        '80945002', '81232004', '81516001', '83444008', '83483005', '83588004', '83809000',
        '84575008', '85175006', '88930008', '89230009', '89528006', '90648000', '91531008'
    }


class VteDiagnosticTest(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies a diagnostic test that is performed to determine if a patient has a VTE.
    Data Element Scope: The intent of this data element is to identify a diagnostic test for a VTE. Using the Quality Data Model, this particular element will map to the Diagnostic Study category.
    Inclusion Criteria: Only use codes which represent a select diagnostic test which is performed to determine if a patient has a VTE. These tests include CT with IV contrast, MRI, V/Q lung scan, specific ultrasounds of the lower extremities and venous doppler of lower extremities, venogram with IV contrast, and pulmonary arteriography/angiography.
    Exclusion Criteria: D-dimer test. Computed tomography without IV contrast.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.276'
    VALUE_SET_NAME = 'VTE Diagnostic Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '24533-2', '24556-3', '24557-1', '24628-0', '24629-8', '24659-5', '24820-3', '24824-5',
        '24866-6', '24867-4', '24873-2', '24887-2', '24888-0', '30616-7', '30623-3', '30668-8',
        '30673-8', '30674-6', '30697-7', '30830-4', '30862-7', '30864-3', '30871-8', '30874-2',
        '30881-7', '35974-5', '36079-2', '36095-8', '36098-2', '36134-5', '36147-7', '36156-8',
        '36237-6', '36266-5', '36283-0', '36284-8', '36416-6', '36420-8', '36442-2', '36450-5',
        '36547-8', '36781-3', '36784-7', '36785-4', '36789-6', '36791-2', '36795-3', '36796-1',
        '36803-5', '36813-4', '36824-1', '36825-8', '36831-6', '36846-4', '36848-0', '36849-8',
        '36850-6', '36854-8', '36855-5', '36863-9', '36878-7', '36882-9', '36883-7', '36942-1',
        '37182-3', '37416-5', '37426-4', '37440-5', '37779-6', '38773-8', '39057-5', '39420-5',
        '39422-1', '39430-4', '39431-2', '39432-0', '39441-1', '39442-9', '39443-7', '39498-1',
        '39504-6', '39619-2', '39695-2', '39696-0', '39697-8', '39833-9', '39834-7', '39835-4',
        '39836-2', '39837-0', '39838-8', '39898-2', '39940-2', '39941-0', '39942-8', '39943-6',
        '39944-4', '39945-1', '39946-9', '39947-7', '39948-5', '42275-8', '42294-9', '42394-7',
        '42461-4', '42462-2', '43445-6', '43454-8', '43512-3', '43513-1', '43556-0', '43656-8',
        '43657-6', '44128-7', '44129-5', '44135-2', '44174-1', '46307-5', '46308-3', '46313-3',
        '46324-0', '46329-9', '46330-7', '46361-2', '46363-8', '46364-6', '48691-0', '48692-8',
        '57822-9', '69096-6', '69162-6', '69212-9', '69252-5', '69399-4'
    }


class VteSuspected(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a situation that is commonly used to identify patients who have a suspected VTE.
    Data Element Scope: The intent of this data element is to identify patients who have a suspected VTE. Using the Quality Data Model, this data element will map to the "Diagnosis" category.
    Inclusion Criteria: Only include codes which represent a situation of a suspected VTE.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.277'
    VALUE_SET_NAME = 'VTE Suspected'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'417113001', '432805000'}


class TreatmentAdjustedByProtocol(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a situation that is commonly used in the inpatient setting to represent treatments adjusted by protocol.
    Data Element Scope: The intent of this data element is to identify patients who have a treatment adjusted by protocol. Using the Quality Data Model, this data element will map to the "Procedure" category.
    Inclusion Criteria: Only use codes which represent a situation for a treatment adjusted by protocol. Codes used are SNOMED CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.278'
    VALUE_SET_NAME = 'Treatment Adjusted by Protocol'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'417886001'}


class VenousThromboembolism(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies patients who have a venous thromboembolism, including those who have a pulmonary embolism.
    Data Element Scope: The intent of this data element is to identify patients who have a venous thromboembolism, including those who have a pulmonary embolism. Using the Quality Data Model, this particular element will map to the Diagnosis category, or the Diagnosis or Principal Diagnosis attribute for the Encounter category.
    Inclusion Criteria: Only use codes representing pulmonary embolism and proximal venous thromboembolisms, including specific proximal veins: popliteal vein, femoral/superficial femoral vein, deep femoral vein, ileofemoral vein, iliac vein and inferior vena cava.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.279'
    VALUE_SET_NAME = 'Venous Thromboembolism'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I2602', 'I2609', 'I2692', 'I2699', 'I8010', 'I8011', 'I8012', 'I8013', 'I80201', 'I80202',
        'I80203', 'I80209', 'I80211', 'I80212', 'I80213', 'I80219', 'I80221', 'I80222', 'I80223',
        'I80229', 'I80291', 'I80292', 'I80293', 'I80299', 'I803', 'I809', 'I82220', 'I82290',
        'I82401', 'I82402', 'I82403', 'I82409', 'I82411', 'I82412', 'I82413', 'I82419', 'I82421',
        'I82422', 'I82423', 'I82429', 'I82431', 'I82432', 'I82433', 'I82439', 'I824Y1', 'I824Y2',
        'I824Y3', 'I824Y9', 'I82890', 'I8290'
    }

    ICD9CM = {
        '41511', '41513', '41519', '45111', '45119', '4512', '45181', '4519', '4532', '45340',
        '45341', '45387', '45389', '4539'
    }

    SNOMEDCT = {
        '1001000119102', '11029002', '128053003', '128055005', '132251000119101',
        '132291000119106', '132301000119107', '134399007', '16750002', '1748006', '194883006',
        '195394007', '195405004', '195408002', '195410000', '195411001', '195421009', '195422002',
        '195423007', '195425000', '195426004', '195427008', '195437003', '213220000', '233935004',
        '233936003', '234044007', '234049002', '25114006', '266267005', '276494008', '281595001',
        '312584000', '312588002', '31295000', '35979000', '40198004', '404223003', '413956008',
        '427775006', '427776007', '42861008', '429098002', '441746000', '444325005', '46253008',
        '50817002', '52496006', '57834008', '58309001', '59282003', '64662007', '69357003',
        '7387004', '74315008', '77892009', '83727005', '83938003', '95448006', '95449003'
    }


class Labor(ValueSet):
    """

    Clinical Focus: This set of values represent the concept of labor.
    Data Element Scope: The intent of this data element is to identify that a patient is in labor. Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Include SNOMED CT codes that identify onset and establishment of labor.
    Exclusion Criteria: Exclude codes describing later stages of labor and latent labor.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.281'
    VALUE_SET_NAME = 'Labor'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'20236002', '289211007', '366325002', '6383007', '6893006', '84457005'}


class CesareanBirth(ValueSet):
    """

    Clinical Focus: This grouping of value sets contain procedures that represent a cesarean section.
    Data Element Scope: The intent of this data element is to identify cesarean section. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 CM, and SNOMED CT codes that identify cesarean section.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.282'
    VALUE_SET_NAME = 'Cesarean Birth'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'10D00Z0', '10D00Z1', '10D00Z2'}

    SNOMEDCT = {
        '11466000', '177141003', '177142005', '177143000', '236985002', '236986001', '236987005',
        '236988000', '236989008', '274130007', '288042004', '398307005', '41059002', '450483001',
        '450484007', '57271003', '84195007', '89053004'
    }


class ConditionsPossiblyJustifyingElectiveDeliveryPriorTo39WeeksGestation(ValueSet):
    """

    Clinical Focus: This set of values contains diagnoses that represent conditions possibly justifying elective delivery prior to 39 weeks gestation.
    Data Element Scope: The intent of this data element is to identify conditions possibly justifying elective delivery prior to 39 weeks gestation. Using the Quality Data Model, this particular element will map to the "Diagnosis" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 CM, and SNOMED CT codes that  identify conditions possibly justifying elective delivery prior to 39 weeks gestation.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.286'
    VALUE_SET_NAME = 'Conditions Possibly Justifying Elective Delivery Prior to 39 Weeks Gestation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'B20', 'K835', 'K838', 'K87', 'O10011', 'O10012', 'O10013', 'O1002', 'O1003', 'O10111',
        'O10112', 'O10113', 'O1012', 'O1013', 'O10211', 'O10212', 'O10213', 'O1022', 'O10311',
        'O10312', 'O10313', 'O1032', 'O10411', 'O10412', 'O10413', 'O1042', 'O1043', 'O10911',
        'O10912', 'O10913', 'O1092', 'O111', 'O112', 'O113', 'O114', 'O1211', 'O1212', 'O1213',
        'O1221', 'O1222', 'O1223', 'O131', 'O132', 'O133', 'O134', 'O1402', 'O1403', 'O1404',
        'O1412', 'O1413', 'O1414', 'O1422', 'O1423', 'O1424', 'O1492', 'O1493', 'O1494', 'O1502',
        'O1503', 'O151', 'O152', 'O161', 'O162', 'O163', 'O164', 'O169', 'O24011', 'O24012',
        'O24013', 'O2402', 'O24111', 'O24112', 'O24113', 'O2412', 'O24311', 'O24312', 'O24313',
        'O2432', 'O24410', 'O24414', 'O24415', 'O24419', 'O24420', 'O24424', 'O24425', 'O24429',
        'O24811', 'O24812', 'O24813', 'O2482', 'O24911', 'O24912', 'O24913', 'O2492', 'O26611',
        'O26612', 'O26613', 'O2662', 'O26831', 'O26832', 'O26833', 'O30001', 'O30002', 'O30003',
        'O30011', 'O30012', 'O30013', 'O30031', 'O30032', 'O30033', 'O30042', 'O30043', 'O30091',
        'O30092', 'O30093', 'O30101', 'O30102', 'O30103', 'O30111', 'O30112', 'O30113', 'O30121',
        'O30122', 'O30123', 'O30191', 'O30192', 'O30193', 'O30201', 'O30202', 'O30203', 'O30211',
        'O30212', 'O30213', 'O30221', 'O30222', 'O30223', 'O30291', 'O30292', 'O30293', 'O30801',
        'O30802', 'O30803', 'O30811', 'O30812', 'O30813', 'O30821', 'O30822', 'O30823', 'O30891',
        'O30892', 'O30893', 'O3091', 'O3092', 'O3093', 'O3111X0', 'O3111X1', 'O3111X2', 'O3111X3',
        'O3111X4', 'O3111X5', 'O3111X9', 'O3112X0', 'O3112X1', 'O3112X2', 'O3112X3', 'O3112X4',
        'O3112X5', 'O3112X9', 'O3113X0', 'O3113X1', 'O3113X2', 'O3113X3', 'O3113X4', 'O3113X5',
        'O3113X9', 'O3121X0', 'O3121X1', 'O3121X2', 'O3121X3', 'O3121X4', 'O3121X5', 'O3121X9',
        'O3122X0', 'O3122X1', 'O3122X2', 'O3122X3', 'O3122X4', 'O3122X5', 'O3122X9', 'O3123X0',
        'O3123X1', 'O3123X2', 'O3123X3', 'O3123X4', 'O3123X5', 'O3123X9', 'O3131X0', 'O3131X1',
        'O3131X2', 'O3131X3', 'O3131X4', 'O3131X5', 'O3131X9', 'O3132X0', 'O3132X1', 'O3132X2',
        'O3132X3', 'O3132X4', 'O3132X5', 'O3132X9', 'O3133X0', 'O3133X1', 'O3133X2', 'O3133X3',
        'O3133X4', 'O3133X5', 'O3133X9', 'O318X10', 'O318X11', 'O318X12', 'O318X13', 'O318X14',
        'O318X15', 'O318X19', 'O318X20', 'O318X21', 'O318X22', 'O318X23', 'O318X24', 'O318X25',
        'O318X29', 'O318X30', 'O318X31', 'O318X32', 'O318X33', 'O318X34', 'O318X35', 'O318X39',
        'O34212', 'O350XX0', 'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4', 'O350XX5', 'O350XX9',
        'O351XX0', 'O351XX1', 'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5', 'O351XX9', 'O353XX0',
        'O353XX1', 'O353XX2', 'O353XX3', 'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0', 'O354XX1',
        'O354XX2', 'O354XX3', 'O354XX4', 'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1', 'O355XX2',
        'O355XX3', 'O355XX4', 'O355XX5', 'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2', 'O356XX3',
        'O356XX4', 'O356XX5', 'O356XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4',
        'O358XX5', 'O358XX9', 'O360110', 'O360111', 'O360112', 'O360113', 'O360114', 'O360115',
        'O360119', 'O360120', 'O360121', 'O360122', 'O360123', 'O360124', 'O360125', 'O360129',
        'O360130', 'O360131', 'O360132', 'O360133', 'O360134', 'O360135', 'O360139', 'O360910',
        'O360911', 'O360912', 'O360913', 'O360914', 'O360915', 'O360919', 'O360920', 'O360921',
        'O360922', 'O360923', 'O360924', 'O360925', 'O360929', 'O360930', 'O360931', 'O360932',
        'O360933', 'O360934', 'O360935', 'O360939', 'O361110', 'O361111', 'O361112', 'O361113',
        'O361114', 'O361115', 'O361119', 'O361120', 'O361121', 'O361122', 'O361123', 'O361124',
        'O361125', 'O361129', 'O361130', 'O361131', 'O361132', 'O361133', 'O361134', 'O361135',
        'O361139', 'O361910', 'O361911', 'O361912', 'O361913', 'O361914', 'O361915', 'O361919',
        'O361920', 'O361921', 'O361922', 'O361923', 'O361924', 'O361925', 'O361929', 'O361930',
        'O361931', 'O361932', 'O361933', 'O361934', 'O361935', 'O361939', 'O364XX0', 'O364XX1',
        'O364XX2', 'O364XX3', 'O364XX4', 'O364XX5', 'O364XX9', 'O365110', 'O365111', 'O365112',
        'O365113', 'O365114', 'O365115', 'O365119', 'O365120', 'O365121', 'O365122', 'O365123',
        'O365124', 'O365125', 'O365129', 'O365130', 'O365131', 'O365132', 'O365133', 'O365134',
        'O365135', 'O365139', 'O365910', 'O365911', 'O365912', 'O365913', 'O365914', 'O365915',
        'O365919', 'O365920', 'O365921', 'O365922', 'O365923', 'O365924', 'O365925', 'O365929',
        'O365930', 'O365931', 'O365932', 'O365933', 'O365934', 'O365935', 'O365939', 'O368120',
        'O368121', 'O368122', 'O368123', 'O368124', 'O368125', 'O368129', 'O368130', 'O368131',
        'O368132', 'O368133', 'O368134', 'O368135', 'O368139', 'O401XX0', 'O401XX1', 'O401XX2',
        'O401XX3', 'O401XX4', 'O401XX5', 'O401XX9', 'O402XX0', 'O402XX1', 'O402XX2', 'O402XX3',
        'O402XX4', 'O402XX5', 'O402XX9', 'O403XX0', 'O403XX1', 'O403XX2', 'O403XX3', 'O403XX4',
        'O403XX5', 'O403XX9', 'O4101X0', 'O4101X1', 'O4101X2', 'O4101X3', 'O4101X4', 'O4101X5',
        'O4101X9', 'O4102X0', 'O4102X1', 'O4102X2', 'O4102X3', 'O4102X4', 'O4102X5', 'O4102X9',
        'O4103X0', 'O4103X1', 'O4103X2', 'O4103X3', 'O4103X4', 'O4103X5', 'O4103X9', 'O411010',
        'O411011', 'O411012', 'O411013', 'O411014', 'O411015', 'O411019', 'O411020', 'O411021',
        'O411022', 'O411023', 'O411024', 'O411025', 'O411029', 'O411030', 'O411031', 'O411032',
        'O411033', 'O411034', 'O411035', 'O411039', 'O411210', 'O411211', 'O411212', 'O411213',
        'O411214', 'O411215', 'O411219', 'O411220', 'O411221', 'O411222', 'O411223', 'O411224',
        'O411225', 'O411229', 'O411230', 'O411231', 'O411232', 'O411233', 'O411234', 'O411235',
        'O411239', 'O411410', 'O411411', 'O411412', 'O411413', 'O411414', 'O411415', 'O411419',
        'O411420', 'O411421', 'O411422', 'O411423', 'O411424', 'O411425', 'O411429', 'O411430',
        'O411431', 'O411432', 'O411433', 'O411434', 'O411435', 'O411439', 'O42011', 'O42012',
        'O42013', 'O4202', 'O42111', 'O42112', 'O42113', 'O4212', 'O42911', 'O42912', 'O42913',
        'O4292', 'O43011', 'O43012', 'O43013', 'O4401', 'O4402', 'O4403', 'O4411', 'O4412',
        'O4413', 'O4420', 'O4423', 'O4430', 'O4433', 'O4440', 'O4443', 'O4450', 'O4453', 'O45001',
        'O45002', 'O45003', 'O45011', 'O45012', 'O45013', 'O45021', 'O45022', 'O45023', 'O45091',
        'O45092', 'O45093', 'O458X1', 'O458X2', 'O458X3', 'O4591', 'O4592', 'O4593', 'O46001',
        'O46002', 'O46003', 'O46011', 'O46012', 'O46013', 'O46021', 'O46022', 'O46023', 'O46091',
        'O46092', 'O46093', 'O468X1', 'O468X2', 'O468X3', 'O4691', 'O4692', 'O4693', 'O480',
        'O666', 'O670', 'O678', 'O679', 'O68', 'O690XX0', 'O690XX1', 'O690XX2', 'O690XX3',
        'O690XX4', 'O690XX5', 'O690XX9', 'O694XX0', 'O694XX1', 'O694XX2', 'O694XX3', 'O694XX4',
        'O694XX5', 'O694XX9', 'O7102', 'O7103', 'O76', 'O903', 'O99111', 'O99112', 'O99113',
        'O9912', 'O9913', 'O99411', 'O99412', 'O99413', 'O9942', 'O9943', 'O99810', 'O99814',
        'O99815', 'Z21', 'Z371', 'Z7901'
    }

    ICD9CM = {
        '042', '64101', '64111', '64121', '64131', '64181', '64191', '64201', '64202', '64211',
        '64212', '64221', '64222', '64231', '64232', '64241', '64242', '64251', '64252', '64261',
        '64262', '64271', '64272', '64291', '64292', '64511', '64621', '64622', '64671', '64801',
        '64851', '64852', '64861', '64862', '64881', '64882', '64931', '64932', '65101', '65111',
        '65121', '65131', '65141', '65151', '65161', '65171', '65181', '65191', '65201', '65261',
        '65501', '65511', '65531', '65541', '65551', '65561', '65581', '65601', '65611', '65621',
        '65631', '65641', '65651', '65701', '65801', '65811', '65821', '65841', '65971', '66351',
        'V08', 'V235', 'V271'
    }

    SNOMEDCT = {
        '10562009', '10573002', '106007006', '111438007', '111880001', '112071002', '11687002',
        '12729009', '12867002', '13866000', '14022007', '15230009', '1538006', '15394000',
        '15663008', '15938005', '163540009', '16356006', '16756008', '169582001', '169827000',
        '17594002', '18416000', '198899007', '198900002', '198903000', '198905007', '198906008',
        '198910006', '198912003', '198917009', '198918004', '198920001', '198922009', '198923004',
        '198925006', '198927003', '198928008', '198941007', '198942000', '198944004', '198945003',
        '198946002', '198947006', '198949009', '198951008', '198952001', '198953006', '198954000',
        '198965005', '198966006', '198967002', '198968007', '198983002', '198984008', '198985009',
        '198986005', '198990007', '198991006', '198992004', '198993009', '198997005', '198999008',
        '199000005', '199002002', '199003007', '199005000', '199007008', '199063009', '199064003',
        '199117000', '199118005', '199223000', '199225007', '199226008', '199227004', '199266007',
        '199267003', '199268008', '199306007', '199307003', '199317008', '199318003', '199321001',
        '199322008', '199325005', '199326006', '199344003', '199345002', '199577000', '199578005',
        '199582007', '199583002', '199646006', '199647002', '199653002', '199654008', '199658006',
        '199659003', '199660008', '199661007', '199662000', '199670005', '199672002', '199673007',
        '199677008', '199678003', '199895009', '199896005', '200473005', '200474004', '22271007',
        '231958008', '235888006', '23717007', '237227006', '237230004', '237236005', '237237001',
        '237246007', '237247003', '237266003', '237267007', '237270006', '237271005', '237272003',
        '237273008', '237274002', '237275001', '237276000', '237277009', '237279007', '237281009',
        '237282002', '237283007', '237300009', '237625008', '237627000', '237628005', '239104000',
        '24042004', '240611008', '24095001', '26078007', '267197003', '267199000', '267207004',
        '267262008', '27388005', '276369006', '288207006', '288250001', '29259002', '307632004',
        '310592002', '310594001', '312974005', '33669002', '34165000', '34694006', '34818008',
        '34842007', '35347003', '367390009', '36813001', '37382001', '37618003', '38063000',
        '38720006', '3885002', '397949005', '398254007', '398276003', '4006006', '405736009',
        '41114007', '415105001', '41962002', '42686001', '427139004', '428511009', '429187001',
        '4307007', '430881000', '43990006', '44223004', '44795003', '46764007', '46894009',
        '4783006', '48194001', '48552006', '48888007', '54213000', '57480000', '59566000',
        '60810003', '62246005', '62479008', '62531004', '63287004', '64254006', '65147003',
        '65402008', '6636004', '67359005', '69897008', '69909000', '699950009', '71028008',
        '71874008', '72022006', '7266006', '75022004', '75150001', '76751001', '7792000',
        '78381004', '78808002', '79668009', '80190007', '80224003', '80997009', '81626002',
        '82141001', '8218002', '82260000', '82701004', '86041002', '86203003', '86356004',
        '86406008', '8762007', '87814002', '90968009', '91162000', '91923005', '91947003',
        '91948008', '95605009'
    }


class MedicalInductionOfLabor(ValueSet):
    """

    Clinical Focus: This set of values contains procedures that represent the medical induction of labor.
    Data Element Scope: The intent of this data element is to identify medical induction of labor. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include ICD 9 CM and SNOMED CT codes that identify the medical induction of labor.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.288'
    VALUE_SET_NAME = 'Medical Induction of Labor'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {
        '0U7C7DZ', '0U7C7ZZ', '10900ZC', '10903ZC', '10904ZC', '10907ZC', '10908ZC', '3E033VJ'
    }

    ICD9CM = {'7301', '731', '734'}

    SNOMEDCT = {
        '177129005', '177135005', '177136006', '237002008', '288189000', '288190009', '308037008',
        '31208007', '408818004'
    }


class EmergencyDepartmentVisit(ValueSet):
    """

    Clinical Focus: This set of values identifies procedures representing an emergency department encounter.
    Data Element Scope: The intent of this data element is to identify patients who have had an emergency department encounter.  Using the Quality Data Model, this particular element will map to the "Encounter" category.
    Inclusion Criteria: Include codes representing an emergency department visit encounter utilizing the SNOMED CT code system.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.292'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'4525004'}


class EmergencyDepartmentVisit_293(ValueSet):
    """

    Clinical Focus: This grouping value set identifies procedures that represent an emergency department encounter.
    Data Element Scope: The intent of this data element is to identify patients who have an emergency department encounter. Using the Quality Data Model, this particular element will map to the "Encounter" category.
    Inclusion Criteria: Include codes representing an emergency department encounter utilizing the SNOMED CT system.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.293'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'4525004'}


class DecisionToAdmitToHospitalInpatient(ValueSet):
    """

    Clinical Focus: This grouping of value sets identifies procedures that are commonly used for capturing an emergency decision to admit a patient to an inpatient hospital setting.
    Data Element Scope: The intent of this data element is to identify an emergency decision to admit a patient to an inpatient hospital setting. Using the Quality Data Model, this particular element will map to the "Encounter" category.
    Inclusion Criteria: Include codes representing an emergency decision to admit a patient to an inpatient hospital setting utilizing the SNOMED CT system.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.295'
    VALUE_SET_NAME = 'Decision to Admit to Hospital Inpatient'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'10378005', '19951005', '73607007', '76464004'}


class PsychiatricmentalHealthPatient(ValueSet):
    """

    Clinical Focus: This grouping value set identifies diagnoses that are commonly used in the inpatient setting for psychiatric and mental health disorders.
    Data Element Scope: The intent of this data element is to identify patients who have an active diagnosis for a psychiatric or mental health disorder.   Using the Quality Data Model, this particular element will map to the "diagnosis" category.
    Inclusion Criteria: Include codes representing an active diagnosis for psychiatric and mental health disorders utilizing  ICD 10 CM and SNOMED CT codes systems.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.299'
    VALUE_SET_NAME = 'Psychiatric/Mental Health Patient'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F0150', 'F0151', 'F0390', 'F0391', 'F04', 'F05', 'F060', 'F061', 'F062', 'F0630', 'F0631',
        'F0632', 'F0633', 'F0634', 'F064', 'F068', 'F070', 'F0781', 'F0789', 'F079', 'F09',
        'F1010', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159', 'F10180',
        'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F1021', 'F10220', 'F10221', 'F10229',
        'F10230', 'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259', 'F1026',
        'F1027', 'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921', 'F10929',
        'F1094', 'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981', 'F10982',
        'F10988', 'F1099', 'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150',
        'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F1121', 'F11220',
        'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281',
        'F11282', 'F11288', 'F1129', 'F1190', 'F11920', 'F11921', 'F11922', 'F11929', 'F1193',
        'F1194', 'F11950', 'F11951', 'F11959', 'F11981', 'F11982', 'F11988', 'F1199', 'F1210',
        'F12120', 'F12121', 'F12122', 'F12129', 'F12150', 'F12151', 'F12159', 'F12180', 'F12188',
        'F1219', 'F1220', 'F1221', 'F12220', 'F12221', 'F12222', 'F12229', 'F12250', 'F12251',
        'F12259', 'F12280', 'F12288', 'F1229', 'F1290', 'F12920', 'F12921', 'F12922', 'F12929',
        'F12950', 'F12951', 'F12959', 'F12980', 'F12988', 'F1299', 'F1310', 'F13120', 'F13121',
        'F13129', 'F1314', 'F13150', 'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188',
        'F1319', 'F1320', 'F1321', 'F13220', 'F13221', 'F13229', 'F13230', 'F13231', 'F13232',
        'F13239', 'F1324', 'F13250', 'F13251', 'F13259', 'F1326', 'F1327', 'F13280', 'F13281',
        'F13282', 'F13288', 'F1329', 'F1390', 'F13920', 'F13921', 'F13929', 'F13930', 'F13931',
        'F13932', 'F13939', 'F1394', 'F13950', 'F13951', 'F13959', 'F1396', 'F1397', 'F13980',
        'F13981', 'F13982', 'F13988', 'F1399', 'F1410', 'F14120', 'F14121', 'F14122', 'F14129',
        'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188', 'F1419',
        'F1420', 'F1421', 'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250',
        'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1490', 'F14920',
        'F14921', 'F14922', 'F14929', 'F1494', 'F14950', 'F14951', 'F14959', 'F14980', 'F14981',
        'F14982', 'F14988', 'F1499', 'F1510', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514',
        'F15150', 'F15151', 'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520',
        'F1521', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251',
        'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921',
        'F15922', 'F15929', 'F1593', 'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981',
        'F15982', 'F15988', 'F1599', 'F1610', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614',
        'F16150', 'F16151', 'F16159', 'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F1621',
        'F16220', 'F16221', 'F16229', 'F1624', 'F16250', 'F16251', 'F16259', 'F16280', 'F16283',
        'F16288', 'F1629', 'F1690', 'F16920', 'F16921', 'F16929', 'F1694', 'F16950', 'F16951',
        'F16959', 'F16980', 'F16983', 'F16988', 'F1699', 'F1810', 'F18120', 'F18121', 'F18129',
        'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188', 'F1819', 'F1820',
        'F1821', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259', 'F1827',
        'F18280', 'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894', 'F18950',
        'F18951', 'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F19120', 'F19121',
        'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917', 'F19180',
        'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F1921', 'F19220', 'F19221', 'F19222',
        'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259',
        'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929', 'F1990', 'F19920',
        'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939', 'F1994', 'F19950',
        'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982', 'F19988', 'F1999',
        'F200', 'F201', 'F202', 'F203', 'F205', 'F2081', 'F2089', 'F209', 'F21', 'F22', 'F23',
        'F24', 'F250', 'F251', 'F258', 'F259', 'F28', 'F29', 'F3010', 'F3011', 'F3012', 'F3013',
        'F302', 'F303', 'F304', 'F308', 'F309', 'F310', 'F3110', 'F3111', 'F3112', 'F3113', 'F312',
        'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160', 'F3161', 'F3162', 'F3163', 'F3164',
        'F3170', 'F3171', 'F3172', 'F3173', 'F3174', 'F3175', 'F3176', 'F3177', 'F3178', 'F3181',
        'F3189', 'F319', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325', 'F3281', 'F3289', 'F329',
        'F330', 'F331', 'F332', 'F333', 'F3340', 'F3341', 'F3342', 'F338', 'F339', 'F340', 'F341',
        'F3481', 'F3489', 'F349', 'F39', 'F4000', 'F4001', 'F4002', 'F4010', 'F4011', 'F40210',
        'F40218', 'F40220', 'F40228', 'F40230', 'F40231', 'F40232', 'F40233', 'F40240', 'F40241',
        'F40242', 'F40243', 'F40248', 'F40290', 'F40291', 'F40298', 'F408', 'F409', 'F410', 'F411',
        'F413', 'F418', 'F419', 'F422', 'F423', 'F424', 'F428', 'F429', 'F430', 'F4310', 'F4311',
        'F4312', 'F4320', 'F4321', 'F4322', 'F4323', 'F4324', 'F4325', 'F4329', 'F438', 'F439',
        'F440', 'F441', 'F442', 'F444', 'F445', 'F446', 'F447', 'F4481', 'F4489', 'F449', 'F450',
        'F451', 'F4520', 'F4521', 'F4522', 'F4529', 'F4541', 'F4542', 'F458', 'F459', 'F481',
        'F482', 'F488', 'F489', 'F5000', 'F5001', 'F5002', 'F502', 'F5081', 'F5089', 'F509',
        'F5101', 'F5102', 'F5103', 'F5104', 'F5105', 'F5109', 'F5111', 'F5112', 'F5113', 'F5119',
        'F513', 'F514', 'F515', 'F518', 'F519', 'F520', 'F521', 'F5221', 'F5222', 'F5231', 'F5232',
        'F524', 'F525', 'F526', 'F528', 'F529', 'F53', 'F550', 'F551', 'F552', 'F553', 'F554',
        'F558', 'F59', 'F600', 'F601', 'F602', 'F603', 'F604', 'F605', 'F606', 'F607', 'F6081',
        'F6089', 'F609', 'F630', 'F631', 'F632', 'F633', 'F6381', 'F6389', 'F639', 'F640', 'F641',
        'F642', 'F648', 'F649', 'F650', 'F651', 'F652', 'F653', 'F654', 'F6550', 'F6551', 'F6552',
        'F6581', 'F6589', 'F659', 'F66', 'F6810', 'F6811', 'F6812', 'F6813', 'F688', 'F69', 'F70',
        'F71', 'F72', 'F73', 'F78', 'F79', 'F800', 'F801', 'F802', 'F804', 'F8081', 'F8082',
        'F8089', 'F809', 'F810', 'F812', 'F8181', 'F8189', 'F819', 'F82', 'F840', 'F842', 'F843',
        'F845', 'F848', 'F849', 'F88', 'F89', 'F900', 'F901', 'F902', 'F908', 'F909', 'F910',
        'F911', 'F912', 'F913', 'F918', 'F919', 'F930', 'F938', 'F939', 'F940', 'F941', 'F942',
        'F948', 'F949', 'F950', 'F951', 'F952', 'F958', 'F959', 'F980', 'F981', 'F9821', 'F9829',
        'F983', 'F984', 'F985', 'F988', 'F989', 'F99', 'G2561', 'R37', 'R401', 'R404', 'R410',
        'R411', 'R412', 'R413', 'R4182', 'R4189', 'R440', 'R441', 'R442', 'R443', 'R448', 'R450',
        'R451', 'R452', 'R453', 'R454', 'R455', 'R456', 'R457', 'R4581', 'R4582', 'R4583', 'R4584',
        'R45850', 'R45851', 'R4587', 'R4589', 'R461', 'R462', 'R463', 'R465', 'R466', 'R467',
        'R4681', 'R4689', 'Z554', 'Z563', 'Z564', 'Z5681', 'Z592', 'Z600', 'Z603', 'Z604', 'Z605',
        'Z620', 'Z621', 'Z6222', 'Z6229', 'Z623', 'Z626', 'Z62810', 'Z62811', 'Z62812', 'Z62819',
        'Z62820', 'Z62821', 'Z62822', 'Z62890', 'Z62891', 'Z62898', 'Z629', 'Z630', 'Z631', 'Z634',
        'Z635', 'Z6371', 'Z6372', 'Z6379', 'Z638', 'Z644', 'Z658', 'Z69010', 'Z69011', 'Z69020',
        'Z69021', 'Z6911', 'Z6912', 'Z6981', 'Z6982', 'Z700', 'Z701', 'Z702', 'Z703', 'Z708',
        'Z709', 'Z7141', 'Z7142', 'Z7151', 'Z7152', 'Z7189', 'Z7251', 'Z7252', 'Z7253', 'Z726',
        'Z72810', 'Z72811', 'Z72820', 'Z72821', 'Z7289', 'Z730', 'Z731', 'Z733', 'Z734', 'Z735',
        'Z73810', 'Z73811', 'Z73812', 'Z73819', 'Z7389', 'Z8651', 'Z8659', 'Z87820', 'Z87890',
        'Z91410', 'Z91411', 'Z91412', 'Z91419', 'Z9149', 'Z915'
    }

    SNOMEDCT = {
        '10278007', '10327003', '10349009', '10532003', '105491000119107', '106013002',
        '106014008', '109006', '109805003', '109899002', '11003002', '110281001', '11061003',
        '111475002', '111476001', '111477005', '111479008', '111480006', '111482003', '111483008',
        '111484002', '111485001', '111487009', '111490003', '111491004', '111492006', '11387009',
        '1145003', '11806006', '11941006', '1196001', '12348006', '126943008', '128293007',
        '129104009', '12939007', '129562004', '129602009', '129604005', '12969000',
        '130121000119104', '13313007', '13438001', '13601005', '13670005', '13746004', '1376001',
        '1380006', '1383008', '14070001', '14077003', '14183003', '14291003', '14495005',
        '145841000119107', '1471000119103', '14784000', '1499003', '15193003', '15277004',
        '153501000119105', '15639000', '15662003', '1581000119101', '15945005', '15977008',
        '162004', '162204000', '162702000', '16295005', '16506000', '16805009', '1686006',
        '16966009', '16990005', '17226007', '17496003', '17782008', '17961008', '18003009',
        '18085000', '1816003', '18260003', '18393005', '18478005', '18541000119100', '18653004',
        '18689007', '18818009', '18941000', '191447007', '191449005', '191451009', '191452002',
        '191454001', '191455000', '191457008', '191458003', '191459006', '191461002', '191463004',
        '191464005', '191465006', '191466007', '191475009', '191476005', '191478006', '191480000',
        '191483003', '191484009', '191485005', '191486006', '191492000', '191493005', '191494004',
        '191495003', '191496002', '191499009', '191501001', '191502008', '191503003', '191504009',
        '191505005', '191507002', '191508007', '191509004', '191510009', '191511008', '191512001',
        '191519005', '191525009', '191526005', '191527001', '191530008', '191531007', '191536002',
        '191537006', '191538001', '191539009', '191540006', '191542003', '191547009', '191548004',
        '191554003', '191555002', '191559008', '191561004', '191562006', '191563001', '191564007',
        '191567000', '191569002', '191570001', '191571002', '191572009', '191574005', '191577003',
        '191583000', '191584006', '191586008', '191588009', '191590005', '191592002', '191593007',
        '191595000', '191597008', '191601008', '191602001', '191604000', '191606003', '191610000',
        '191611001', '191613003', '191615005', '191616006', '191618007', '191620005', '191621009',
        '191623007', '191625000', '191627008', '191629006', '191630001', '191632009', '191634005',
        '191636007', '191638008', '191639000', '191641004', '191643001', '191658009', '191659001',
        '191668004', '191670008', '191672000', '191676002', '191677006', '191680007', '191683009',
        '191687005', '191692007', '191693002', '191696005', '191697001', '191714002', '191722009',
        '191724005', '191725006', '191726007', '191736004', '191737008', '191738003', '191746002',
        '191753006', '191765005', '191772006', '191773001', '191774007', '191787001', '191804003',
        '191805002', '191811004', '191812006', '191813001', '191819002', '191820008', '191821007',
        '191825003', '191826002', '191831000', '191832007', '191833002', '191837001', '191838006',
        '191839003', '191843004', '191844005', '191845006', '191849000', '191853003', '191855005',
        '191865004', '191867007', '191868002', '191873008', '191874002', '191875001', '191887008',
        '191888003', '191889006', '191928000', '191952007', '191965003', '191970005', '191972002',
        '191973007', '191980009', '191990001', '191997003', '192003008', '192007009', '192014006',
        '192016008', '192017004', '192029008', '192037000', '192038005', '192041001', '192042008',
        '192044009', '192046006', '192049004', '192051000', '192056005', '192057001', '192058006',
        '192063005', '192064004', '192072002', '192073007', '192080009', '192082001', '192097003',
        '192099000', '192100008', '192108001', '192110004', '192118006', '192122001', '192123006',
        '192127007', '192138007', '192147004', '192362008', '192523000', '192527004', '192562009',
        '192575009', '192611004', '192616009', '192630004', '192631000', '19300006', '193462001',
        '193756007', '1938002', '194437008', '19445006', '1973000', '197480006', '19766004',
        '19922006', '199257008', '199259006', '199260001', '199261002', '199262009', '20010003',
        '20250007', '20385005', '20871009', '20876004', '20960007', '21000000', '21586000',
        '21647008', '21897009', '21900002', '22121000', '22230001', '22381000119105', '22407005',
        '22419002', '22574000', '229025005', '229621000', '229623002', '229629003', '229630008',
        '229632000', '229672009', '229683000', '229699006', '229700007', '229714007', '229715008',
        '229729009', '229733002', '229734008', '229736005', '229740001', '229744005', '229745006',
        '229750000', '229751001', '230258005', '230282000', '230286002', '230287006', '230288001',
        '230289009', '230290000', '230334008', '230335009', '230338006', '230455006', '230488004',
        '230497000', '2312009', '231437006', '231438001', '231439009', '231440006', '231442003',
        '231444002', '231445001', '231446000', '231449007', '231450007', '231451006', '231452004',
        '231454003', '231457005', '231458000', '231459008', '231461004', '231467000', '231470001',
        '231472009', '231473004', '231474005', '231475006', '231485007', '231487004', '231489001',
        '231494001', '231495000', '231496004', '231500002', '231504006', '231517009', '231518004',
        '231519007', '231520001', '231522009', '231523004', '231524005', '231525006', '231526007',
        '231527003', '231528008', '231532002', '231535000', '231536004', '231538003', '231539006',
        '231540008', '231541007', '231542000', '233690008', '23560001', '236074001', '23645006',
        '237349002', '237351003', '237352005', '23772009', '238959007', '238961003', '238967004',
        '238972008', '238973003', '238974009', '238975005', '238977002', '238979004', '2403008',
        '24121004', '24125008', '24315006', '247803002', '247804008', '24781009', '248118000',
        '248290002', '249520001', '25501002', '25753007', '25766007', '25772007', '25922000',
        '25971005', '26025008', '2618002', '26203008', '26416006', '26453000', '26516009',
        '26665006', '26714005', '26852004', '268612007', '268617001', '268619003', '268620009',
        '268621008', '268622001', '268624000', '268633003', '268640002', '268650001', '268651002',
        '268652009', '268654005', '268661009', '268664001', '268666004', '268667008', '268668003',
        '268669006', '268672004', '268715000', '268722008', '268727002', '268734000', '268957000',
        '270901009', '270902002', '270903007', '270905000', '271428004', '271952001', '27387000',
        '274948002', '274950005', '274952002', '274953007', '27544004', '275471001', '275474009',
        '276300008', '2776000', '278506006', '278508007', '278852008', '278853003', '278857002',
        '278919001', '27956007', '279982005', '280032002', '280377008', '280378003', '280982009',
        '280983004', '280984005', '280986007', '280994000', '281004', '2815001', '28357009',
        '28368009', '28475009', '28663008', '28676002', '286933003', '288081000119106',
        '288091000119109', '288101000119104', '288281000119100', '28857002', '28864000',
        '28884001', '29212009', '29599000', '29733004', '29929003', '30059008', '300706003',
        '30077003', '300960003', '300992002', '301643003', '30169000', '302507002', '30310000',
        '30336007', '30491001', '30509009', '30520009', '30605009', '30687003', '307417003',
        '30871003', '30935000', '310202009', '31027006', '310495003', '310496002', '310497006',
        '3109008', '311173003', '31177006', '312098001', '312936002', '312991009', '313182004',
        '31373002', '313915006', '31446002', '3158007', '31611000', '31658008', '31715000',
        '31781004', '317816007', '318784009', '319768000', '32009006', '320751009', '321717001',
        '32358001', '32388005', '32552001', '32721004', '32875003', '32880007', '3298001',
        '33078009', '33135002', '33323008', '33380008', '33449004', '33693007', '33736005',
        '33871004', '34116005', '34315001', '34938008', '3503000', '35218008', '35252006',
        '35253001', '35481005', '35489007', '35607004', '35722002', '35827000', '35846004',
        '35919005', '36124002', '361272001', '36158005', '36170009', '36217008', '36474008',
        '36583000', '36622002', '367515004', '36923009', '370143000', '371024007', '371026009',
        '371596008', '371599001', '371600003', '371604007', '371631005', '37224001', '37331004',
        '373618009', '37739004', '37746008', '37868008', '37872007', '38328002', '38368003',
        '38451003', '38547003', '386537007', '386805003', '386810004', '386821008', '386822001',
        '386823006', '386824000', '386825004', '38694004', '39003006', '3914008', '39465007',
        '3972004', '397923000', '398066007', '39807006', '39809009', '39951001', '40083003',
        '402732001', '402733006', '402735004', '402736003', '402737007', '403474003', '403582001',
        '403583006', '403586003', '403590001', '403593004', '403594005', '40379007', '40568001',
        '40571009', '406506008', '408856003', '408858002', '40926005', '40987004', '41083005',
        '41524005', '41526007', '41552001', '416073003', '416340002', '416714005', '416780008',
        '416975007', '417143004', '417360004', '41836007', '418475009', '420614009', '421023003',
        '421529006', '42344001', '425390006', '425476007', '425499006', '425533007', '425832009',
        '425881006', '425885002', '425914008', '425919003', '42594001', '426095000', '426174008',
        '426590003', '426824009', '426873000', '427205009', '427229002', '427327003', '427975003',
        '42868002', '428687006', '428703001', '42925002', '429458009', '429571005', '429672007',
        '429998004', '4306003', '430744005', '430751001', '430852001', '430909002', '43150009',
        '43497001', '43568002', '43614003', '43769008', '439960005', '44124003', '441527004',
        '441704009', '441711008', '441716003', '441833000', '442057004', '442059001', '442176004',
        '442243005', '442245003', '442344002', '442351006', '442406005', '443265004', '443735008',
        '44376007', '443919007', '4441000', '44433009', '444613000', '446175003', '446180007',
        '44966003', '45479006', '45677003', '45912004', '45924006', '46023009', '46206005',
        '46229002', '46244001', '46372006', '46432001', '46721000', '46762006', '46975003',
        '472981000', '47372000', '47447001', '47505003', '47664006', '47916000', '4817008',
        '48309007', '48500005', '48589009', '4863002', '48826008', '48937005', '4926007',
        '4932002', '49468007', '49512000', '49540005', '49564006', '5002000', '50026000',
        '50299009', '50320000', '50705009', '50722006', '50878001', '50933003', '5095008',
        '50983008', '51133006', '51443000', '51493001', '5158005', '51637008', '52448006',
        '52866005', '52910006', '52954000', '53049002', '53050002', '53333005', '53467004',
        '53607008', '53936005', '53956006', '54319003', '54417002', '5444000', '54502004',
        '54587008', '5464005', '54761006', '55009008', '5509004', '5510009', '55341008',
        '55516002', '55668003', '55728007', '55736003', '55967005', '56034001', '56267009',
        '56294008', '56573006', '56576003', '56627002', '5664002', '568005', '56882008', '5703000',
        '57194009', '57588009', '57715001', '58214004', '58329000', '58535001', '58647003',
        '58703003', '58727001', '59174009', '59216005', '59252009', '59617007', '59645001',
        '59651006', '59923000', '600009', '60099002', '60103007', '60123008', '609225004',
        '61104008', '61144001', '61180001', '61212007', '61403008', '61569007', '61771000119106',
        '61901004', '62351001', '62491004', '63181006', '63249007', '63393005', '6348008',
        '63649001', '63701002', '63778009', '63835008', '63909006', '63983005', '64060000',
        '64165008', '64731001', '6475002', '64905009', '65064003', '65096006', '65410009',
        '66108005', '66214007', '66307007', '66344007', '66347000', '66381006', '66590003',
        '66631006', '66936004', '67002003', '67123006', '67227000', '67711008', '68019004',
        '68569003', '68890003', '68963006', '68995007', '69322001', '69392006', '69479009',
        '698958008', '70043001', '7025000', '70328006', '70340006', '7052005', '70546001',
        '70691001', '7071007', '70747007', '70764005', '70814008', '70922000', '70932007',
        '70936005', '71103003', '71294008', '71328000', '71336009', '71959007', '71961003',
        '71984005', '7200002', '72861004', '7291006', '73097000', '73462009', '73867007',
        '7397008', '73972002', '74007000', '74010007', '74266001', '7461003', '74686005',
        '74732009', '74791000', '74850006', '74934004', '75084000', '75122001', '75360000',
        '75752004', '75837004', '76236006', '76441001', '76566000', '76812003', '76868007',
        '77355000', '77475008', '77486005', '77675002', '77815007', '77911002', '7794004',
        '78004001', '78269000', '78358001', '78640000', '78667006', '78689005', '79204003',
        '79298009', '79578000', '79584002', '79842004', '79866005', '80711002', '80868005',
        '81319007', '8185002', '81903006', '82096005', '82339009', '82415003', '82494000',
        '82636008', '82738004', '82959004', '82998009', '83168008', '83176005', '83225003',
        '83367009', '83458005', '83501007', '83631006', '83746006', '83890006', '84002002',
        '84209002', '84466009', '84758004', '84760002', '84788008', '84984002', '85061001',
        '85080004', '8511007', '85248005', '85821003', '85861002', '8635005', '87132004',
        '87203005', '87414006', '87798009', '87950005', '87991007', '88339003', '8837000',
        '88845000', '88939009', '88975006', '89415002', '89451009', '89618007', '89765005',
        '89948007', '90361000119105', '90755006', '90790003', '9083002', '91388009', '9167000',
        '92501000119101', '9340000', '9345005', '93461009', '95636001', '95637005', '95919007',
        '9674006'
    }


class BreastMilk(ValueSet):
    """

    Clinical Focus: This set of values represent the concept of breast milk.
    Data Element Scope: The intent of this data element is to identify breast milk.  Using the Quality Data Model, this particular element will map to the "substance" category.
    Inclusion Criteria: Include SNOMED CT codes that identify breast milk.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.30'
    VALUE_SET_NAME = 'Breast Milk'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'226789007'}


class MedicationComplianceEducation(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a regime or therapy that is commonly used to identify medication compliance education.
    Data Element Scope: The intent of this data element is to identify patients who have been given medication compliance education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the regime or therapy of medication compliance education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.301'
    VALUE_SET_NAME = 'Medication Compliance Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '385772001', '385774000', '410120005', '410123007', '410129006', '410264007', '415831001',
        '423076000', '442284008'
    }


class VitaminKDietaryManagement(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a procedure that is commonly used to identify vitamin K dietary management education.
    Data Element Scope: The intent of this data element is to identify patients who have been given vitamin k dietary management education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the procedure of vitamin K dietary management education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.302'
    VALUE_SET_NAME = 'Vitamin K Dietary Management'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428691000124107'}


class FollowUpMonitoring(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a regime or therapy that is commonly used to identify follow-up monitoring education for Venous Thromboembolism, specifically for follow up INR monitoring and warfarin assessment.
    Data Element Scope: The intent of this data element is to identify patients who have been given follow-up monitoring education for Venous Thromboembolism, specifically for follow up INR monitoring and warfarin assessment. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the regime or therapy of follow-up monitoring education for Venous Thromboembolism. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.303'
    VALUE_SET_NAME = 'Follow-up Monitoring'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'170916008', '183616001', '416754007'}


class AdverseDrugReactionsEducation(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a procedure that is commonly used to identify adverse drug reaction education.
    Data Element Scope: The intent of this data element is to identify patients who have been given adverse drug reaction education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the procedure of adverse drug reaction education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.304'
    VALUE_SET_NAME = 'Adverse Drug Reactions Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'396080005', '410264007'}


class IcuAdmissionOrTransfer(ValueSet):
    """

    Clinical Focus: This set of values contains encounters for admission or transfers to intensive care units (ICU).
    Data Element Scope: The intent of this data element is to identify patients who are transferred to intensive care units. Using the Quality Data Model, this particular elements will map to "Encounter, Performed".
    Inclusion Criteria: Codes representing admissions to ICU.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.305'
    VALUE_SET_NAME = 'ICU Admission or Transfer'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '183446009', '183447000', '183448005', '183449002', '305351004', '305352006', '397821002',
        '397945004', '406144005'
    }


class LeftAgainstMedicalAdvice(ValueSet):
    """

    Clinical Focus: This set of values represents a patient leaving against medical advice.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular  inpatient encounter. This particular value set intends to identify patients who left against medical advice. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing  leaving against medical advice should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.308'
    VALUE_SET_NAME = 'Left Against Medical Advice'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'445060000'}


class PatientExpired(ValueSet):
    """

    Clinical Focus: This value set identifies a patient who has died in the hospital.
    Data Element Scope: The intent of this data element is to identify the discharge status of patient expired as an attribute of the inpatient encounter.  Using the Quality Data Model, this value set is used for this attribute.
    Inclusion Criteria: Only include codes for a patient who had died in the hospital.  Codes used are to be SNOMED-CT codes only.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.309'
    VALUE_SET_NAME = 'Patient Expired'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'371828006'}


class Galactosemia(ValueSet):
    """

    Clinical Focus: This grouping value set include diagnoses that represent galactosemia.
    Data Element Scope: The intent of this data element is to identify galactosemia. Using the Quality Data Model, this particular element will map to the "Diagnosis" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 CM, and SNOMED CT codes that identify galactosemia.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.35'
    VALUE_SET_NAME = 'Galactosemia'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'E7420', 'E7421', 'E7429'}

    ICD9CM = {'2711'}

    SNOMEDCT = {'190745006'}


class VteRiskAssessment(ValueSet):
    """

    Clinical Focus: This set of values identify a tool used to assess the amount of risk that a patient has to develop a VTE.
    Data Element Scope: The intent of this data element is to identify patients who have an assessment of their risk to develop a VTE.  Using the Quality Data Model, this particular element will map to the Risk Category Assessment category with a result attribute.
    Inclusion Criteria: Only use codes which represent a risk assessment tool used to assess a patient's risk to develop a VTE.  Codes used are to be LOINC only.
    Exclusion Criteria: Exclude any codes which are not LOINC or which are LOINC, but which do not represent a risk assessment tool used to assess a patient's risk to develop a VTE.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.357'
    VALUE_SET_NAME = 'VTE Risk Assessment'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'72136-5'}


class ActivationOfEmergencyMedicalSystemEducation(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent patients who receives emergency medical system education.
    Data Element Scope: The intent of this data element is to identify patients who receive education on the activation of emergency medical system.  Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing  emergency medical system education should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.377'
    VALUE_SET_NAME = 'Activation of Emergency Medical System Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'385867000', '428551000124102'}


class InstructionsForFollowUpAfterDischarge(ValueSet):
    """

    Clinical Focus: This set of values is used to represent patients who receive instructions for follow up care after discharge or follow up care planned and scheduled.
    Data Element Scope: The intent of this data element is to identify patients who receive instructions for follow up after discharge or have follow up plans scheduled.  Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing  instructions for follow up after discharge or follow up care planned and scheduled should be included.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.378'
    VALUE_SET_NAME = 'Instructions for Follow Up After Discharge'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'183616001', '428521000124106'}


class PrescribedMedicationsEducation(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent patients who receive prescribed medications education.
    Data Element Scope: The intent of this data element is to identify patients who receive education on the medications they were prescribed to take. Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing  prescribed medications education should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.379'
    VALUE_SET_NAME = 'Prescribed Medications Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'386465007', '423076000'}


class ParenteralNutrition(ValueSet):
    """

    Clinical Focus: This grouping value set contains procedures that represent parenteral infusion.
    Data Element Scope: The intent of this data element is to identify parenteral infusion procedures. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 PCS, and SNOMED CT codes that identify parenteral infusion.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.38'
    VALUE_SET_NAME = 'Parenteral Nutrition'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'3E0336Z', '3E0436Z', '3E0536Z', '3E0636Z'}

    ICD9CM = {'9915'}

    SNOMEDCT = {'183027000', '225372007', '230114001', '230115000', '25156005', '304055007'}


class RiskFactorsEducation(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent patients who receive risk factor education.
    Data Element Scope: The intent of this data element is to identify patients who receive education on risk factors. Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing risk factor education should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.380'
    VALUE_SET_NAME = 'Risk Factors Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'415233007'}


class WarningSignsAndSymptomsEducation(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent patients who  receive warning signs and symptoms  education.
    Data Element Scope: The intent of this data element is to identify patients who receive education on stroke warnings signs and symptoms.  Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing  education on warning signs and symptoms should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.381'
    VALUE_SET_NAME = 'Warning Signs and Symptoms Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'223413005'}


class LowRisk(ValueSet):
    """

    Clinical Focus: This set of values represents the result of an assessment or other measurement or observation that is "low".  The concepts are represented using SNOMED-CT codes.
    Data Element Scope: The intent of this data element is to identify patients who have an observation or measurement of an assessment which is "low".  Using the Quality Data Model, this data element maps to an attribute.
    Inclusion Criteria: Only include SNOMED-CT codes which specifically represent a qualifier value of "low".
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.400'
    VALUE_SET_NAME = 'Low Risk'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'260362008', '62482003'}


class VteConfirmed(ValueSet):
    """

    Clinical Focus: This set of values identifies disorders for pulmonary emboli and proximal venous thromboembolisms, specifically in the  popliteal vein, femoral/superficial femoral vein, deep femoral vein, ileofemoral vein, iliac vein and inferior vena cava.
    Data Element Scope: The intent of this data element is to identify patients who have a confirmed VTE in specific locations in their body.  Using the Quality Data Model, this particular element will map to the Result attribute for a Diagnostic Study.
    Inclusion Criteria: Codes representing pulmonary emboli and proximal venous thromboembolisms in specific proximal veins, including the popliteal vein, femoral/superficial femoral vein, deep femoral vein, ileofemoral vein, iliac vein and inferior vena cava. These codes are represented in SNOMED-CT.
    Exclusion Criteria: Embolisms not caused by a thrombus (e.g. fat, air, amniotic fluid, tumor, septic); Thromboembolisms in locations other than the specified in the inclusion criteria (e.g. distal or upper extremity thromboembolisms); Non-vein specific venous thromboembolisms; Disorders described as subacute or chronic; Disorders with specific obstetrical context.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.407'
    VALUE_SET_NAME = 'VTE Confirmed'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '1001000119102', '132251000119101', '132291000119106', '132301000119107', '1748006',
        '195410000', '195411001', '195425000', '195426004', '195427008', '233935004', '233936003',
        '234044007', '281595001', '427775006', '427776007', '42861008', '57834008', '59282003',
        '74315008'
    }


class MedicalContraindication(ValueSet):
    """

    Clinical Focus: This set of values contains codes for findings and situations that are commonly used to identify medical contraindications.
    Data Element Scope: The intent of this data element is to identify patients who have a medical contraindication to a device or medication. This value set is a subset of the "Medical Reason" value set (2.16.840.1.113883.3.117.1.7.1.473). This subset does not include codes for "not needed" and "no indication". Using the Quality Data Model, the data element will map to the "Device" category  or "Medication" category with a negation rationale attribute.
    Inclusion Criteria: Only include codes which represent a medical contraindication related to medication, procedure, general care, and clinical trial participant. Codes used are SNOMED CT codes.
    Exclusion Criteria: Exclude codes that represent situations where a particular course of treatment is deemed to not be needed or indicated.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.412'
    VALUE_SET_NAME = 'Medical Contraindication'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '183932001', '266721009', '31438003', '35688006', '397745006', '407563006', '410536001',
        '416098002', '419511003', '428024001', '59037007', '62014003', '79899007'
    }


class RecommendationNotToChangeDiet(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a  procedure that is commonly used to identify recommendation to continue current diet education.
    Data Element Scope: The intent of this data element is to identify patients who have been given recommendation to continue current diet education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the procedure of recommendation to continue current diet education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.413'
    VALUE_SET_NAME = 'Recommendation not to change diet'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428501000124101'}


class DrugInteractionsEducation(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a  procedure that is commonly used to identify drug interaction education.
    Data Element Scope: The intent of this data element is to identify patients who have been given drug interaction education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the procedure of drug interaction education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.414'
    VALUE_SET_NAME = 'Drug Interactions Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428381000124102', '428391000124104'}


class WrittenInformationGiven(ValueSet):
    """

    Clinical Focus: This set of values contains qualifiers used to represent patients who receive written information.
    Data Element Scope: The intent of this data element is to identify patients who receive written information.  Using the Quality Data Model, this particular element will map to the "Communication" category.
    Inclusion Criteria: Only SNOMED CT codes representing  written information given should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.415'
    VALUE_SET_NAME = 'Written Information Given'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'413318004'}


class InrMonitoringEducation(ValueSet):
    """

    Clinical Focus: This set of values contains codes for a  procedure that is commonly used to identify INR monitoring education.
    Data Element Scope: The intent of this data element is to identify patients who have been given INR monitoring education. Using the Quality Data Model, this data element will map to the "Communication, From Provider to Patient" datatype.
    Inclusion Criteria: Only include codes which represent the procedure of INR monitoring education. Codes used are SNOMED CT codes.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.416'
    VALUE_SET_NAME = 'INR Monitoring Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428401000124102'}


class BaselineState(ValueSet):
    """

    Clinical Focus: This set contains a code representing the finding of baseline state of health.
    Data Element Scope: The intent of this data element is to identify patients' baseline state of health, i.e. when the patient was last known to be without the signs and symptoms of the current stroke. Using the Quality Data Model, this particular element will map to the "Physical Exam" category.
    Inclusion Criteria: Only SNOMED CT codes representing baseline state should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.417'
    VALUE_SET_NAME = 'Baseline State'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'128974000'}


class ClassicalCesareanBirth(ValueSet):
    """

    Clinical Focus: This grouping of value sets contain procedures that represent cesarean section.
    Data Element Scope: The intent of this data element is to identify classical cesarean section. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include ICD 9 CM, ICD 10 PCS, and SNOMED CT codes that identify the classical cesarean section.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.421'
    VALUE_SET_NAME = 'Classical Cesarean Birth'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10PCS = {'10D00Z0'}

    SNOMEDCT = {'177142005', '236986001', '84195007'}


class Myomectomy(ValueSet):
    """

    Clinical Focus: This set of values contains procedures that represent a myomectomy.
    Data Element Scope: The intent of this data element is to identify a myomectomy. Using the Quality Data Model, this particular element will map to the "Procedure" category.
    Inclusion Criteria: Include SNOMED CT codes that identify a myomectomy.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.422'
    VALUE_SET_NAME = 'Myomectomy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '236901008', '236902001', '265059000', '42010004', '428652006', '446804002', '84064003'
    }


class StatinAllergen(ValueSet):
    """

    Clinical Focus: Identifies patients with an allergy to statin medications.
    Data Element Scope: Statin Allergens as structured in RXNORM
    Inclusion Criteria: MIN, PIN, IN, and BN statin medication codes
    Exclusion Criteria: Does not include non-statin medications or statin SCD codes.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.423'
    VALUE_SET_NAME = 'Statin Allergen'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1189803', '1297766', '1372731', '1372754', '1422085', '1422087', '1430892', '1483793',
        '151972', '153165', '196503', '203144', '203333', '224938', '301542', '320864', '323828',
        '327008', '352387', '36567', '404773', '404914', '41127', '42463', '484211', '495215',
        '541841', '6472', '72875', '803516', '83366', '83367', '861612', '861634', '861640'
    }


class NonElectiveInpatientEncounter(ValueSet):
    """

    Clinical Focus: This set of values contains procedures that represent non-elective inpatient encounters.
    Data Element Scope: The intent of this data element is to identify non-elective inpatient encounters. Using the Quality Data Model, this particular element will map to the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing  non-elective inpatient encounter should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.424'
    VALUE_SET_NAME = 'Non-Elective Inpatient Encounter'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'183452005', '32485007'}


class MedicalReason(ValueSet):
    """

    Clinical Focus: This set of values contains situations that represent  medical reasons for not providing treatment.
    Data Element Scope: The intent of this data element is to identify medical reasons for not providing treatment. Using the Quality Data Model, this particular element will map to the "Reason" attribute.
    Inclusion Criteria: Only SNOMED CT codes representing  medical reasons for not providing treatment should be included.
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.473'
    VALUE_SET_NAME = 'Medical Reason'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '183932001', '183964008', '183966005', '266721009', '31438003', '35688006', '397745006',
        '407563006', '410529002', '410534003', '410536001', '416098002', '419511003', '428024001',
        '428119001', '59037007', '62014003', '79899007'
    }


class Birth(ValueSet):
    """

    Clinical Focus: This set of values represents the concept of birth.
    Data Element Scope: The intent of this data element is to identify birth as a qualifier for the inpatient encounter in which the patient was born. Using the Quality Data Model, this particular element will map as an attribute to "Feeding Intention".
    Inclusion Criteria: Include SNOMED CT codes that identify birth.
    Exclusion Criteria: Exclude codes that do not meet the inclusion criteria.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.70'
    VALUE_SET_NAME = 'Birth'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'3950001'}


class NeonatalIntensiveCareUnitNicu(ValueSet):
    """

    Clinical Focus: This set of  values represent a  neonatal intensive care unit (NICU) location.
    Data Element Scope: The intent of this data element is to identify the NICU. Using the Quality Data Model, this particular element will map   as an attribute to an encounter.
    Inclusion Criteria: Include SNOMED CT codes that identify the NICU.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.75'
    VALUE_SET_NAME = 'Neonatal Intensive Care Unit (NICU)'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'405269005'}


class DischargeToHomeOrPoliceCustody(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to home or police custody.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who were discharged to home or police custody. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: This value set includes concepts that identify a patient's discharge destination as either a home setting or police custody.
    Exclusion Criteria: Discharge concepts that identify a patient's discharge status as to anywhere else other than home or police custody.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.82'
    VALUE_SET_NAME = 'Discharge To Home Or Police Custody'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '10161009', '306689006', '306690002', '306691003', '306692005', '306705005', '65537008',
        '86400002'
    }


class DischargeToAcuteCareFacility(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to an acute care facility.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who where discharged to an acute care facility. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing short-term acute care hospitals, including specialty hospitals, should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.87'
    VALUE_SET_NAME = 'Discharge To Acute Care Facility'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'306701001', '306703003', '434781000124105'}


class PatientRefusal(ValueSet):
    """

    Clinical Focus: This set of values contains situations representing a patient's refusal for treatment.
    Data Element Scope: The intent of this data element is to identify reasons a patient refuses treatment.  Using the Quality Data Model, this particular element will map to the " reason" attribute.
    Inclusion Criteria: This value set includes concepts that identify refusal of any intervention (including procedures, treatment, medication, counseling, screening).​
    Exclusion Criteria: None.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.93'
    VALUE_SET_NAME = 'Patient Refusal'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '105480006', '182890002', '182895007', '182896008', '182897004', '182898009', '182900006',
        '182901005', '182903008', '183944003', '183945002', '183947005', '183948000', '275936005',
        '371138003', '385648002', '406149000', '413312003', '416432009', '443390004'
    }


class BhConditionInvolvingBipolarDisorder(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1504'
    VALUE_SET_NAME = 'BH Condition Involving Bipolar Disorder'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F3010', 'F3011', 'F3012', 'F3013', 'F302', 'F303', 'F308', 'F309', 'F310', 'F3110',
        'F3111', 'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160',
        'F3161', 'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3173', 'F3175', 'F3177', 'F3181',
        'F3189', 'F319', 'F340', 'F3489'
    }

    ICD9CM = {
        '29600', '29601', '29602', '29603', '29604', '29605', '29610', '29611', '29612', '29613',
        '29614', '29615', '29640', '29641', '29642', '29643', '29644', '29645', '29650', '29651',
        '29652', '29653', '29654', '29655', '29660', '29661', '29662', '29663', '29664', '29665',
        '2967', '29680', '29681', '29682', '29689', '30113'
    }

    SNOMEDCT = {
        '10875004', '10981006', '1196001', '13313007', '13581000', '13746004', '14495005',
        '1499003', '162004', '16295005', '16506000', '17782008', '191583000', '191584006',
        '191586008', '191590005', '191592002', '191593007', '191595000', '191618007', '191620005',
        '191621009', '191623007', '191627008', '191629006', '191630001', '191632009', '191636007',
        '191638008', '191639000', '191641004', '191658009', '192362008', '19300006', '20960007',
        '21900002', '22407005', '231444002', '231494001', '231495000', '231496004', '26203008',
        '26530004', '268619003', '28663008', '28884001', '29929003', '30520009', '30687003',
        '31446002', '33380008', '34315001', '35481005', '35722002', '35846004', '36583000',
        '371596008', '371599001', '371600003', '371604007', '40926005', '41552001', '41832009',
        '41932008', '43568002', '43769008', '4441000', '45479006', '46229002', '48937005',
        '49468007', '49512000', '51637008', '53049002', '53607008', '54761006', '55516002',
        '5703000', '59617007', '61403008', '63249007', '64731001', '65042007', '66631006',
        '67002003', '68569003', '70546001', '71294008', '71984005', '73471000', '74686005',
        '75360000', '75752004', '76105009', '78269000', '78640000', '79584002', '81319007',
        '82998009', '83225003', '85248005', '86058007', '87203005', '87950005', '9340000'
    }


class BhConditionInvolvingUnipolarDepression(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1505'
    VALUE_SET_NAME = 'BH Condition Involving Unipolar Depression'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F320', 'F321', 'F322', 'F323', 'F324', 'F3281', 'F3289', 'F329', 'F330', 'F331', 'F332',
        'F333', 'F3340', 'F3341', 'F338', 'F339', 'F341'
    }

    ICD9CM = {
        '29620', '29621', '29622', '29623', '29624', '29625', '29630', '29631', '29632', '29633',
        '29634', '29635', '3004', '311'
    }

    SNOMEDCT = {
        '14183003', '15193003', '15639000', '18818009', '191610000', '191611001', '191613003',
        '19527009', '20250007', '25922000', '2618002', '268621008', '28475009', '30605009',
        '319768000', '320751009', '33078009', '33135002', '33736005', '35489007', '36474008',
        '36923009', '370143000', '38694004', '39809009', '40379007', '42810003', '42925002',
        '430852001', '46244001', '60099002', '63412003', '63778009', '66344007', '68019004',
        '69392006', '70747007', '71336009', '73867007', '75084000', '76441001', '77911002',
        '78667006', '79298009', '832007', '87512008'
    }


class BhElectroconvulsiveTherapy(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1533'
    VALUE_SET_NAME = 'BH Electroconvulsive Therapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90870'}

    ICD10PCS = {'GZB0ZZZ', 'GZB1ZZZ', 'GZB2ZZZ', 'GZB3ZZZ', 'GZB4ZZZ'}

    ICD9CM = {'9426', '9427'}

    SNOMEDCT = {
        '11075005', '231079005', '231080008', '23835007', '284468008', '313019002', '313020008'
    }


class BhAssessmentForAlcoholOrOtherDrugs(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1604'
    VALUE_SET_NAME = 'BH Assessment for Alcohol or Other Drugs'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99408', '99409'}

    HCPCS = {'H0001', 'H0049'}

    SNOMEDCT = {
        '105355005', '117251007', '171208001', '252170002', '273347006', '408942001', '408946003',
        '428211000124100'
    }


class BhCounselingForDepression(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1616'
    VALUE_SET_NAME = 'BH Counseling for Depression'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428201000124103'}


class BhMedicalOrPsychiatricConsultation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.1257.1.1652'
    VALUE_SET_NAME = 'BH Medical or psychiatric consultation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99241', '99242', '99243', '99244', '99245'}

    ICD9CM = {'8906', '8907', '8908', '8909'}

    SNOMEDCT = {
        '17436001', '183654001', '185211000', '185387006', '185389009', '30346009', '371883000',
        '37894004', '390906007', '40274000', '86013001', '90526000'
    }


class BhMoodStabilizerMedication(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.950'
    VALUE_SET_NAME = 'BH Mood Stabilizer Medication'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1006801', '151226', '197535', '197536', '198075', '198076', '198077', '198078', '199888',
        '199889', '199890', '205315', '205316', '283536', '309374', '312136', '312137', '312138',
        '312325', '429212', '476177', '476179', '721773', '848722', '848728', '848732', '848736',
        '848740', '848744', '848748', '859824', '996921'
    }


class BhAntidepressantMedication(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.972'
    VALUE_SET_NAME = 'BH Antidepressant Medication'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    RXNORM = {
        '1000048', '1000054', '1000058', '1000064', '1000070', '1000076', '1000091', '1000097',
        '104837', '1098649', '1098666', '1098670', '1098674', '1098678', '1099288', '1099292',
        '1099296', '1099300', '1099304', '1099316', '1190110', '1232585', '1298857', '1298861',
        '1298870', '197363', '197364', '197365', '197366', '197889', '197890', '197891', '197892',
        '197893', '198045', '198046', '198047', '199283', '199324', '199461', '199462', '199484',
        '199485', '199487', '199488', '199761', '199820', '200371', '245373', '246588', '248642',
        '251200', '283406', '283407', '283485', '283672', '309313', '309314', '309671', '309672',
        '310384', '310385', '310386', '311355', '311725', '311726', '312036', '312239', '312240',
        '312241', '312242', '312243', '312244', '312347', '312938', '312940', '312941', '313447',
        '313496', '313497', '313498', '313499', '313580', '313581', '313582', '313583', '313584',
        '313585', '313586', '313989', '313990', '313995', '314111', '314199', '314277', '317136',
        '349332', '351249', '351250', '351285', '403969', '403970', '403971', '403972', '476809',
        '562790', '562791', '562815', '596926', '596930', '596934', '608328', '636664', '721787',
        '730440', '730441', '730442', '746073', '749153', '756059', '790264', '790288', '794947',
        '803293', '808744', '808748', '808751', '808753', '833135', '833141', '833144', '833147',
        '835564', '835568', '835572', '835577', '835582', '835589', '835591', '835593', '846386',
        '856364', '856369', '856373', '856377', '856706', '856720', '856762', '856769', '856773',
        '856783', '856792', '856797', '856825', '856834', '856840', '856845', '856853', '857291',
        '857296', '857297', '857301', '857305', '857315', '859186', '859190', '859193', '861064',
        '865206', '865210', '865214', '898697', '898704', '903873', '903879', '903884', '903887',
        '903891', '905168', '905172', '966787', '966793', '993503', '993518', '993536', '993541',
        '993550', '993557', '993567', '993681', '993687', '993691'
    }


class BhOutpatientPsychotherapy(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.973'
    VALUE_SET_NAME = 'BH Outpatient Psychotherapy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90791', '90792', '90832', '90834', '90837'}

    ICD10PCS = {
        'GZ50ZZZ', 'GZ51ZZZ', 'GZ52ZZZ', 'GZ53ZZZ', 'GZ54ZZZ', 'GZ55ZZZ', 'GZ56ZZZ', 'GZ58ZZZ',
        'GZ59ZZZ', 'GZ72ZZZ', 'GZHZZZZ'
    }

    ICD9CM = {
        '9431', '9432', '9433', '9434', '9435', '9436', '9437', '9438', '9439', '9441', '9442',
        '9443', '9444', '9445', '9446', '9449'
    }

    SNOMEDCT = {'108313002', '183382003', '183383008', '75516001', '76168009'}


class BhOutpatientEncounter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1.49'
    VALUE_SET_NAME = 'BH Outpatient encounter'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245'
    }

    ICD9CM = {'8901', '8902', '8903', '8904', '8905', '8906', '8907', '8908', '8909'}

    SNOMEDCT = {
        '17436001', '183654001', '185211000', '185387006', '185389009', '30346009', '371883000',
        '37894004', '390906007', '40274000', '86013001', '90526000'
    }


class OphthalmologicOutpatientVisit(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1206'
    VALUE_SET_NAME = 'Ophthalmologic Outpatient Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'92002', '92004', '92012', '92014'}


class OfficeVisit(ValueSet):
    """

    Clinical Focus: This value set identifies patients who have had an office or other outpatient visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1001'
    VALUE_SET_NAME = 'Office Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215'}


class HospitalObservationCareInitial(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1002'
    VALUE_SET_NAME = 'Hospital Observation Care - Initial'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99218', '99219', '99220'}


class HospitalInpatientVisitInitial(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1004'
    VALUE_SET_NAME = 'Hospital Inpatient Visit - Initial'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99221', '99222', '99223'}


class DischargeServicesHospitalInpatientSameDayDischarge(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1006'
    VALUE_SET_NAME = 'Discharge Services - Hospital Inpatient Same Day Discharge'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99234', '99235', '99236'}


class DischargeServicesHospitalInpatient(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1007'
    VALUE_SET_NAME = 'Discharge Services - Hospital Inpatient'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99238', '99239'}


class OutpatientConsultation(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had an outpatient interaction at an office with a member of their medical care team.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1008'
    VALUE_SET_NAME = 'Outpatient Consultation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99241', '99242', '99243', '99244', '99245'}


class EmergencyDepartmentVisit_1010(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1010'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99281', '99282', '99283', '99284', '99285'}


class NursingFacilityVisit(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1012'
    VALUE_SET_NAME = 'Nursing Facility Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99304', '99305', '99306', '99307', '99308', '99309', '99310'}


class DischargeServicesNursingFacility(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1013'
    VALUE_SET_NAME = 'Discharge Services - Nursing Facility'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99315', '99316'}


class CareServicesInLongTermResidentialFacility(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1014'
    VALUE_SET_NAME = 'Care Services in Long-Term Residential Facility'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337'}


class HomeHealthcareServices(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1016'
    VALUE_SET_NAME = 'Home Healthcare Services'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349', '99350'}


class PreventiveCareInitialOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1022'
    VALUE_SET_NAME = 'Preventive Care- Initial Office Visit, 0 to 17'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99381', '99382', '99383', '99384'}


class PreventiveCareServicesInitialOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set identifies patients over the age of 18 who have had an initial preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1023'
    VALUE_SET_NAME = 'Preventive Care Services-Initial Office Visit, 18 and Up'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99385', '99386', '99387'}


class PreventiveCareEstablishedOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1024'
    VALUE_SET_NAME = 'Preventive Care - Established Office Visit, 0 to 17'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99391', '99392', '99393', '99394'}


class PreventiveCareServicesEstablishedOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set identifies patients over the age of 18 who have had an established preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1025'
    VALUE_SET_NAME = 'Preventive Care Services - Established Office Visit, 18 and Up'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99395', '99396', '99397'}


class PreventiveCareServicesIndividualCounseling(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1026'
    VALUE_SET_NAME = 'Preventive Care Services-Individual Counseling'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99401', '99402', '99403', '99404'}


class PreventiveCareServicesGroupCounseling(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1027'
    VALUE_SET_NAME = 'Preventive Care Services - Group Counseling'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99411', '99412'}


class PreventiveCareServicesOther(ValueSet):
    """

    Clinical Focus: This value set identifies patients who patients who had an unlisted preventive medicine service.  Inclusion: Includes unlisted preventive medicine services
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes unlisted preventive medicine services.
    Exclusion Criteria: Excludes visits that are not performed in-person, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1030'
    VALUE_SET_NAME = 'Preventive Care Services - Other'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99420', '99429'}


class TelehealthServices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1031'
    VALUE_SET_NAME = 'Telehealth Services'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99441', '99442', '99443', '99444'}


class DischargeServicesObservationCare(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1039'
    VALUE_SET_NAME = 'Discharge Services- Observation Care'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99217'}


class Referral(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1046'
    VALUE_SET_NAME = 'Referral'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '103697008', '103699006', '183515008', '183517000', '183528001', '183529009', '183530004',
        '183541002', '183555005', '183557002', '183561008', '183567007', '183569005', '183591003',
        '183878008', '183879000', '183880002', '183881003', '183882005', '183884006', '183885007',
        '183886008', '183887004', '183888009', '183889001', '183890005', '183891009', '183892002',
        '183893007', '183894001', '183895000', '183896004', '183897008', '183899006', '183900001',
        '183901002', '183902009', '183903004', '183904005', '183905006', '183906007', '183907003',
        '183908008', '183909000', '183910005', '183911009', '183913007', '183914001', '183915000',
        '183916004', '266747000', '274410002', '306160005', '306161009', '306162002', '306253008',
        '306254002', '306255001', '306256000', '306257009', '306258004', '306259007', '306260002',
        '306261003', '306262005', '306263000', '306264006', '306265007', '306266008', '306267004',
        '306268009', '306269001', '306270000', '306271001', '306272008', '306273003', '306274009',
        '306275005', '306276006', '306277002', '306278007', '306279004', '306280001', '306281002',
        '306282009', '306284005', '306285006', '306286007', '306287003', '306288008', '306289000',
        '306290009', '306291008', '306293006', '306294000', '306295004', '306296003', '306297007',
        '306298002', '306299005', '306300002', '306301003', '306302005', '306303000', '306304006',
        '306305007', '306306008', '306307004', '306308009', '306309001', '306310006', '306311005',
        '306312003', '306313008', '306314002', '306315001', '306316000', '306317009', '306318004',
        '306320001', '306338003', '306351008', '306352001', '306353006', '306354000', '306355004',
        '306356003', '306357007', '306358002', '306359005', '306360000', '306361001', '306736002',
        '307063001', '307777008', '308447003', '308449000', '308450000', '308451001', '308452008',
        '308453003', '308465004', '308469005', '308470006', '308471005', '308472003', '308473008',
        '308474002', '308475001', '308476000', '308477009', '308478004', '308479007', '308480005',
        '308481009', '308482002', '308483007', '308484001', '308485000', '309046007', '309627007',
        '309629005', '310515004', '312487009', '312488004', '390807002', '406158007', '406159004',
        '408285001', '415277000', '416116000', '425971006', '428441000124100', '428451000124103',
        '428461000124101', '428471000124108', '428481000124106', '428491000124109',
        '428541000124104', '429365000', '54395008'
    }


class FaceToFaceInteraction(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had a face-to-face interaction with a member of their medical care team.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes both initial and follow up visits. Includes home visits, inpatient and outpatient visits, and nursing facility visits.
    Exclusion Criteria: Excludes visits that are not performed in-person, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1048'
    VALUE_SET_NAME = 'Face-to-Face Interaction'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class TelephoneManagement(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1053'
    VALUE_SET_NAME = 'Telephone Management'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'98966', '98967', '98968'}


class BehavioralHealthFollowUpVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1054'
    VALUE_SET_NAME = 'Behavioral Health Follow-up Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '96150', '96151', '96152', '96153', '96154', '98960', '98961', '98962', '99078', '99510'
    }


class PsychotherapyAndPharmacologicManagement(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1055'
    VALUE_SET_NAME = 'Psychotherapy and Pharmacologic Management'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90845', '90847', '90849', '90853', '90875', '90876'}


class BloodPressureVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1056'
    VALUE_SET_NAME = 'Blood Pressure Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99304', '99305', '99306', '99307', '99308', '99309',
        '99310', '99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337',
        '99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349', '99350', '99385',
        '99386', '99387', '99395', '99396', '99397'
    }

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class DetoxificationVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1059'
    VALUE_SET_NAME = 'Detoxification Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '182969009', '20093000', '23915005', '266707007', '310653000', '414054004', '414056002',
        '56876005', '61480009', '64297001', '67516001', '87106005'
    }


class InpatientEncounter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1060'
    VALUE_SET_NAME = 'Inpatient Encounter'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '112689000', '112690009', '1505002', '15584006', '18083007', '183452005', '183455007',
        '183457004', '183458009', '183459001', '183460006', '183461005', '183462003', '183463008',
        '183464002', '183465001', '183466000', '183467009', '183468004', '183469007', '183470008',
        '183471007', '183472000', '183473005', '183474004', '183475003', '183476002', '183477006',
        '183478001', '183481006', '183497001', '2252009', '23473000', '25986004', '2876009',
        '304568006', '305335007', '305337004', '305338009', '305339001', '305340004', '305341000',
        '305342007', '305343002', '305344008', '305345009', '305346005', '305347001', '305348006',
        '32485007', '36723004', '405614004', '417005', '432621000124105', '432661000124104',
        '4563007', '45702004', '47348005', '48183000', '50699000', '51032003', '51501005',
        '52748007', '55402005', '60059000', '63551005', '65043002', '70755000', '71290004',
        '74857009', '76464004', '81672003', '82942009', '8715000'
    }


class AmbulatoryedVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1061'
    VALUE_SET_NAME = 'Ambulatory/ED Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99217',
        '99218', '99219', '99220', '99241', '99242', '99243', '99244', '99245', '99281', '99282',
        '99283', '99284', '99285', '99341', '99342', '99343', '99344', '99345', '99347', '99348',
        '99349', '99350', '99381', '99382', '99383', '99384', '99385', '99386', '99387', '99391',
        '99392', '99393', '99394', '99395', '99396', '99397', '99401', '99402', '99403', '99404',
        '99411', '99412', '99420', '99429', '99455', '99456'
    }

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class AdultOutpatientVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1065'
    VALUE_SET_NAME = 'Adult Outpatient Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99341', '99342', '99343', '99344', '99345', '99347',
        '99348', '99349', '99350', '99385', '99386', '99387', '99395', '99396', '99397'
    }

    HCPCS = {'G0438', 'G0439'}

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class AudiologyVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1066'
    VALUE_SET_NAME = 'Audiology Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'92540', '92541', '92542', '92548'}


class CriticalCareManagement(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1067'
    VALUE_SET_NAME = 'Critical Care Management'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99291'}


class EmergencyDepartmentInteraction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1068'
    VALUE_SET_NAME = 'Emergency Department Interaction'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'4525004'}


class HospitalInpatientVisitSubsequent(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1069'
    VALUE_SET_NAME = 'Hospital Inpatient Visit Subsequent'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99231', '99232', '99233'}


class PostoperativeVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1070'
    VALUE_SET_NAME = 'Postoperative Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99024'}


class InpatientConsultation(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1071'
    VALUE_SET_NAME = 'Inpatient Consultation'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'99251', '99252', '99253', '99254', '99255'}


class OphthalmologicOutpatientVisit_1072(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1072'
    VALUE_SET_NAME = 'Ophthalmologic Outpatient Visit'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'92002', '92004', '92012', '92014'}

    SNOMEDCT = {
        '225687009', '252833009', '252835002', '252836001', '25434003', '268360001', '36228007',
        '397532009', '397533004', '66902005', '78831002'
    }


class CysticFibrosis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1002'
    VALUE_SET_NAME = 'Cystic Fibrosis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'E840', 'E8411', 'E8419', 'E848', 'E849'}

    ICD9CM = {'27700', '27701', '27702', '27703', '27709'}

    SNOMEDCT = {'190905008', '190909002', '235978006', '81423003', '86092005', '86555001'}


class Emphysema(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1004'
    VALUE_SET_NAME = 'Emphysema'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J430', 'J431', 'J432', 'J438', 'J439', 'J684', 'J982', 'J983'}

    ICD9CM = {'4920', '4928', '5064', '5181', '5182'}

    SNOMEDCT = {
        '16003001', '16838000', '16846004', '195957006', '195958001', '195959009', '195963002',
        '196026004', '21072009', '233674008', '233675009', '233677001', '23958009', '266355005',
        '266356006', '2912004', '31898008', '33325001', '47895001', '4981000', '57686001',
        '60805002', '66110007', '66987001', '68328006', '70756004', '77690003', '86680006',
        '87433001'
    }


class ChronicObstructivePulmonaryDisease(ValueSet):
    """

    Clinical Focus: This value set identifies patients with a diagnosis of chronic obstructive pulmonary disorder (COPD).
    Data Element Scope: This value set was intended to map to the QDM data type of diagnosis, but has the potential to be used in additional ways.
    Inclusion Criteria: This value set includes acute COPD exacerbations, and end stage COPD. It also includes mild through severe COPD classifications.
    Exclusion Criteria: This value set excludes concurrent infections. It also excludes diagnoses of bronchitis, bronchiolitis, and emphysema.
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1007'
    VALUE_SET_NAME = 'Chronic Obstructive Pulmonary Disease'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J440', 'J441', 'J449'}

    ICD9CM = {'49320', '49321', '49322', '496'}

    SNOMEDCT = {
        '135836000', '13645005', '195951007', '196001008', '285381006', '313296004', '313297008',
        '313299006'
    }


class AcutePharyngitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1011'
    VALUE_SET_NAME = 'Acute Pharyngitis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J020', 'J028', 'J029'}

    ICD9CM = {'0340', '462'}

    SNOMEDCT = {
        '1532007', '195655000', '195656004', '195657008', '195658003', '195659006', '195660001',
        '195662009', '232399005', '232400003', '363746003', '40766000', '43878008', '55355000',
        '58031004'
    }


class AcuteTonsillitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1012'
    VALUE_SET_NAME = 'Acute Tonsillitis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J0300', 'J0301', 'J0380', 'J0381', 'J0390', 'J0391'}

    ICD9CM = {'463'}

    SNOMEDCT = {
        '17741008', '195666007', '195667003', '195668008', '195669000', '195670004', '195671000',
        '195672007', '195673002', '195676005', '195677001', '302911003'
    }


class CompetingConditionsForRespiratoryConditions(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1017'
    VALUE_SET_NAME = 'Competing Conditions for Respiratory Conditions'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A000', 'A001', 'A009', 'A0100', 'A0101', 'A0102', 'A0103', 'A0104', 'A0105', 'A0109',
        'A011', 'A012', 'A013', 'A014', 'A020', 'A021', 'A0220', 'A0221', 'A0222', 'A0223',
        'A0224', 'A0225', 'A0229', 'A028', 'A029', 'A030', 'A031', 'A032', 'A033', 'A038', 'A039',
        'A040', 'A041', 'A042', 'A043', 'A044', 'A045', 'A046', 'A047', 'A048', 'A049', 'A050',
        'A051', 'A052', 'A053', 'A054', 'A055', 'A058', 'A059', 'A060', 'A061', 'A062', 'A063',
        'A064', 'A065', 'A066', 'A067', 'A0681', 'A0682', 'A0689', 'A069', 'A070', 'A071', 'A072',
        'A073', 'A074', 'A078', 'A079', 'A080', 'A0811', 'A0819', 'A082', 'A0831', 'A0832',
        'A0839', 'A084', 'A088', 'A09', 'A221', 'A3700', 'A3701', 'A3710', 'A3711', 'A3780',
        'A3781', 'A3790', 'A3791', 'A440', 'A441', 'A448', 'A449', 'A481', 'A499', 'A5009', 'A501',
        'A502', 'A5031', 'A5040', 'A5041', 'A5042', 'A5045', 'A5049', 'A5052', 'A5057', 'A5059',
        'A506', 'A507', 'A509', 'A510', 'A511', 'A512', 'A5131', 'A5132', 'A5139', 'A5141',
        'A5142', 'A5143', 'A5144', 'A5145', 'A5146', 'A5149', 'A515', 'A519', 'A5200', 'A5201',
        'A5202', 'A5203', 'A5204', 'A5205', 'A5206', 'A5209', 'A5210', 'A5211', 'A5212', 'A5213',
        'A5214', 'A5215', 'A5216', 'A5217', 'A5219', 'A522', 'A523', 'A5271', 'A5272', 'A5273',
        'A5274', 'A5275', 'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529', 'A530', 'A539',
        'A5400', 'A5401', 'A5402', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424',
        'A5429', 'A5430', 'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443',
        'A5449', 'A545', 'A546', 'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489',
        'A549', 'A5600', 'A5601', 'A5602', 'A5609', 'A5611', 'A57', 'A58', 'A5900', 'A5901',
        'A5902', 'A5903', 'A5909', 'A598', 'A599', 'A638', 'A64', 'A6920', 'A6921', 'A6922',
        'A6923', 'A6929', 'A7489', 'A749', 'B250', 'B440', 'B600', 'B608', 'B64', 'B781', 'B9689',
        'E832', 'H66001', 'H66002', 'H66003', 'H66004', 'H66005', 'H66006', 'H66007', 'H66009',
        'H66011', 'H66012', 'H66013', 'H66014', 'H66015', 'H66016', 'H66017', 'H66019', 'H6610',
        'H6611', 'H6612', 'H6613', 'H6620', 'H6621', 'H6622', 'H6623', 'H663X1', 'H663X2',
        'H663X3', 'H663X9', 'H6640', 'H6641', 'H6642', 'H6643', 'H6690', 'H6691', 'H6692', 'H6693',
        'H671', 'H672', 'H673', 'H679', 'H70001', 'H70002', 'H70003', 'H70009', 'H70011', 'H70012',
        'H70013', 'H70019', 'H70091', 'H70092', 'H70093', 'H70099', 'H7010', 'H7011', 'H7012',
        'H7013', 'H70201', 'H70202', 'H70203', 'H70209', 'H70211', 'H70212', 'H70213', 'H70219',
        'H70221', 'H70222', 'H70223', 'H70229', 'H70811', 'H70812', 'H70813', 'H70819', 'H70891',
        'H70892', 'H70893', 'H70899', 'H7090', 'H7091', 'H7092', 'H7093', 'H7500', 'H7501',
        'H7502', 'H7503', 'H7580', 'H7581', 'H7582', 'H7583', 'H9500', 'H9501', 'H9502', 'H9503',
        'H95111', 'H95112', 'H95113', 'H95119', 'H95121', 'H95122', 'H95123', 'H95129', 'H95131',
        'H95132', 'H95133', 'H95139', 'H95191', 'H95192', 'H95193', 'H95199', 'J0100', 'J0101',
        'J0110', 'J0111', 'J0120', 'J0121', 'J0130', 'J0131', 'J0140', 'J0141', 'J0180', 'J0181',
        'J0190', 'J0191', 'J020', 'J028', 'J029', 'J0300', 'J0301', 'J0380', 'J0381', 'J0390',
        'J0391', 'J0410', 'J0411', 'J042', 'J050', 'J0510', 'J0511', 'J13', 'J14', 'J150', 'J151',
        'J1520', 'J15211', 'J15212', 'J1529', 'J153', 'J154', 'J155', 'J156', 'J157', 'J158',
        'J159', 'J160', 'J168', 'J17', 'J180', 'J181', 'J189', 'J320', 'J321', 'J322', 'J323',
        'J324', 'J328', 'J329', 'J3501', 'J3502', 'J3503', 'J351', 'J352', 'J353', 'J390', 'J391',
        'J392', 'K122', 'L0100', 'L0101', 'L0102', 'L0103', 'L0109', 'L011', 'L0201', 'L0211',
        'L02211', 'L02212', 'L02213', 'L02214', 'L02215', 'L02216', 'L02219', 'L0231', 'L02411',
        'L02412', 'L02413', 'L02414', 'L02415', 'L02416', 'L02419', 'L02511', 'L02512', 'L02519',
        'L02611', 'L02612', 'L02619', 'L02811', 'L02818', 'L03011', 'L03012', 'L03019', 'L03021',
        'L03022', 'L03029', 'L03031', 'L03032', 'L03039', 'L03041', 'L03042', 'L03049', 'L03111',
        'L03112', 'L03113', 'L03114', 'L03115', 'L03116', 'L03119', 'L03121', 'L03122', 'L03123',
        'L03124', 'L03125', 'L03126', 'L03129', 'L03211', 'L03212', 'L03213', 'L03221', 'L03222',
        'L03311', 'L03312', 'L03313', 'L03314', 'L03315', 'L03316', 'L03317', 'L03319', 'L03321',
        'L03322', 'L03323', 'L03324', 'L03325', 'L03326', 'L03327', 'L03329', 'L03811', 'L03818',
        'L03891', 'L03898', 'L040', 'L041', 'L042', 'L043', 'L048', 'L049', 'L080', 'L0881',
        'L0882', 'L0889', 'L089', 'L700', 'L701', 'L702', 'L703', 'L704', 'L705', 'L708', 'L709',
        'L730', 'L88', 'L928', 'L980', 'M0230', 'M02311', 'M02312', 'M02319', 'M02321', 'M02322',
        'M02329', 'M02331', 'M02332', 'M02339', 'M02341', 'M02342', 'M02349', 'M02351', 'M02352',
        'M02359', 'M02361', 'M02362', 'M02369', 'M02371', 'M02372', 'M02379', 'M0238', 'M0239',
        'M4620', 'M4621', 'M4622', 'M4623', 'M4624', 'M4625', 'M4626', 'M4627', 'M4628', 'M4630',
        'M4631', 'M4632', 'M4633', 'M4634', 'M4635', 'M4636', 'M4637', 'M4638', 'M4639', 'M8600',
        'M86011', 'M86012', 'M86019', 'M86021', 'M86022', 'M86029', 'M86031', 'M86032', 'M86039',
        'M86041', 'M86042', 'M86049', 'M86051', 'M86052', 'M86059', 'M86061', 'M86062', 'M86069',
        'M86071', 'M86072', 'M86079', 'M8608', 'M8609', 'M8610', 'M86111', 'M86112', 'M86119',
        'M86121', 'M86122', 'M86129', 'M86131', 'M86132', 'M86139', 'M86141', 'M86142', 'M86149',
        'M86151', 'M86152', 'M86159', 'M86161', 'M86162', 'M86169', 'M86171', 'M86172', 'M86179',
        'M8618', 'M8619', 'M8620', 'M86211', 'M86212', 'M86219', 'M86221', 'M86222', 'M86229',
        'M86231', 'M86232', 'M86239', 'M86241', 'M86242', 'M86249', 'M86251', 'M86252', 'M86259',
        'M86261', 'M86262', 'M86269', 'M86271', 'M86272', 'M86279', 'M8628', 'M8629', 'M8630',
        'M86311', 'M86312', 'M86319', 'M86321', 'M86322', 'M86329', 'M86331', 'M86332', 'M86339',
        'M86341', 'M86342', 'M86349', 'M86351', 'M86352', 'M86359', 'M86361', 'M86362', 'M86369',
        'M86371', 'M86372', 'M86379', 'M8638', 'M8639', 'M8640', 'M86411', 'M86412', 'M86419',
        'M86421', 'M86422', 'M86429', 'M86431', 'M86432', 'M86439', 'M86441', 'M86442', 'M86449',
        'M86451', 'M86452', 'M86459', 'M86461', 'M86462', 'M86469', 'M86471', 'M86472', 'M86479',
        'M8648', 'M8649', 'M8650', 'M86511', 'M86512', 'M86519', 'M86521', 'M86522', 'M86529',
        'M86531', 'M86532', 'M86539', 'M86541', 'M86542', 'M86549', 'M86551', 'M86552', 'M86559',
        'M86571', 'M86572', 'M86579', 'M8658', 'M8659', 'M8660', 'M86611', 'M86612', 'M86619',
        'M86621', 'M86622', 'M86629', 'M86631', 'M86632', 'M86639', 'M86641', 'M86642', 'M86649',
        'M86651', 'M86652', 'M86659', 'M86661', 'M86662', 'M86669', 'M86671', 'M86672', 'M86679',
        'M8668', 'M8669', 'M868X0', 'M868X1', 'M868X2', 'M868X3', 'M868X4', 'M868X5', 'M868X6',
        'M868X7', 'M868X8', 'M868X9', 'M869', 'M8960', 'M89611', 'M89612', 'M89619', 'M89621',
        'M89622', 'M89629', 'M89631', 'M89632', 'M89639', 'M89641', 'M89642', 'M89649', 'M89651',
        'M89652', 'M89659', 'M89661', 'M89662', 'M89669', 'M89671', 'M89672', 'M89679', 'M8968',
        'M8969', 'M9080', 'M90811', 'M90812', 'M90819', 'M90821', 'M90822', 'M90829', 'M90831',
        'M90832', 'M90839', 'M90841', 'M90842', 'M90849', 'M90851', 'M90852', 'M90859', 'M90861',
        'M90862', 'M90869', 'M90871', 'M90872', 'M90879', 'M9088', 'N10', 'N110', 'N111', 'N118',
        'N119', 'N12', 'N136', 'N151', 'N159', 'N16', 'N2884', 'N2885', 'N2886', 'N3000', 'N3001',
        'N3010', 'N3011', 'N3020', 'N3021', 'N3030', 'N3031', 'N3040', 'N3041', 'N3080', 'N3081',
        'N3090', 'N3091', 'N341', 'N390', 'N410', 'N411', 'N412', 'N413', 'N414', 'N418', 'N419',
        'N51', 'N7001', 'N7002', 'N7003', 'N7011', 'N7012', 'N7013', 'N7091', 'N7092', 'N7093',
        'N710', 'N711', 'N719', 'N72', 'N730', 'N731', 'N732', 'N733', 'N734', 'N735', 'N736',
        'N738', 'N739', 'N74', 'N750', 'N751', 'N758', 'N759', 'N760', 'N761', 'N762', 'N763',
        'N764', 'N765', 'N766', 'N7681', 'N7689', 'N770', 'N771'
    }

    ICD9CM = {
        '0010', '0011', '0019', '0020', '0021', '0022', '0023', '0029', '0030', '0031', '00320',
        '00321', '00322', '00323', '00324', '00329', '0038', '0039', '0040', '0041', '0042',
        '0043', '0048', '0049', '0050', '0051', '0052', '0053', '0054', '00581', '00589', '0059',
        '0060', '0061', '0062', '0063', '0064', '0065', '0068', '0069', '0070', '0071', '0072',
        '0073', '0074', '0075', '0078', '0079', '00800', '00801', '00802', '00803', '00804',
        '00809', '0081', '0082', '0083', '00841', '00842', '00843', '00844', '00845', '00846',
        '00847', '00849', '0085', '00861', '00862', '00863', '00864', '00865', '00866', '00867',
        '00869', '0088', '0090', '0091', '0092', '0093', '0330', '0331', '0338', '0339', '0340',
        '0419', '07888', '07988', '07998', '0880', '08881', '08882', '08889', '0889', '0900',
        '0901', '0902', '0903', '09040', '09041', '09042', '09049', '0905', '0906', '0907', '0909',
        '0910', '0911', '0912', '0913', '0914', '09150', '09151', '09152', '09161', '09162',
        '09169', '0917', '09181', '09182', '09189', '0919', '0920', '0929', '0930', '0931',
        '09320', '09321', '09322', '09323', '09324', '09381', '09382', '09389', '0939', '0940',
        '0941', '0942', '0943', '09481', '09482', '09483', '09484', '09485', '09486', '09487',
        '09489', '0949', '0950', '0951', '0952', '0953', '0954', '0955', '0956', '0957', '0958',
        '0959', '096', '0970', '0971', '0979', '0980', '09810', '09811', '09812', '09813', '09814',
        '09815', '09816', '09817', '09819', '0982', '09830', '09831', '09832', '09833', '09834',
        '09835', '09836', '09837', '09839', '09840', '09841', '09842', '09843', '09849', '09850',
        '09851', '09852', '09853', '09859', '0986', '0987', '09881', '09882', '09883', '09884',
        '09885', '09886', '09889', '0990', '0991', '0992', '0993', '09940', '09941', '09949',
        '09950', '09951', '09952', '09953', '09954', '09955', '09956', '09959', '0998', '0999',
        '13100', '13101', '13102', '13103', '13109', '1318', '1319', '38200', '38201', '38202',
        '3821', '3822', '3823', '3824', '3829', '38300', '38301', '38302', '3831', '38320',
        '38321', '38322', '38330', '38331', '38332', '38333', '38381', '38389', '3839', '4610',
        '4611', '4612', '4613', '4618', '4619', '462', '463', '46410', '46411', '46420', '46421',
        '46430', '46431', '4730', '4731', '4732', '4733', '4738', '4739', '47400', '47401',
        '47402', '47410', '47411', '47412', '4742', '4748', '4749', '47821', '47822', '47824',
        '47829', '47871', '47879', '4789', '481', '4820', '4821', '4822', '48230', '48231',
        '48232', '48239', '48240', '48241', '48242', '48249', '48281', '48282', '48283', '48284',
        '48289', '4829', '4830', '4831', '4838', '4841', '4843', '4845', '4846', '4847', '4848',
        '485', '486', '59000', '59001', '59010', '59011', '5902', '5903', '59080', '59081', '5909',
        '5950', '5951', '5952', '5953', '5954', '59581', '59582', '59589', '5959', '5990', '6010',
        '6011', '6012', '6013', '6014', '6018', '6019', '6140', '6141', '6142', '6143', '6144',
        '6145', '6146', '6147', '6148', '6149', '6150', '6151', '6159', '6160', '61610', '61611',
        '6162', '6163', '6164', '61650', '61651', '61681', '61689', '6169', '68100', '68101',
        '68102', '68110', '68111', '6819', '6820', '6821', '6822', '6823', '6824', '6825', '6826',
        '6827', '6828', '6829', '683', '684', '68600', '68601', '68609', '6861', '6868', '6869',
        '7060', '7061', '73000', '73001', '73002', '73003', '73004', '73005', '73006', '73007',
        '73008', '73009', '73010', '73011', '73012', '73013', '73014', '73015', '73016', '73017',
        '73018', '73019', '73020', '73021', '73022', '73023', '73024', '73025', '73026', '73027',
        '73028', '73029', '73030', '73031', '73032', '73033', '73034', '73035', '73036', '73037',
        '73038', '73039', '73070', '73071', '73072', '73073', '73074', '73075', '73076', '73077',
        '73078', '73079', '73080', '73081', '73082', '73083', '73084', '73085', '73086', '73087',
        '73088', '73089', '73090', '73091', '73092', '73093', '73094', '73095', '73096', '73097',
        '73098', '73099'
    }

    SNOMEDCT = {
        '10065003', '10188004', '102452004', '102453009', '102455002', '10321002', '10345003',
        '10351008', '105628008', '105629000', '105977003', '10809006', '109242000', '109243005',
        '109244004', '109245003', '109246002', '109247006', '109302008', '109303003', '109304009',
        '109305005', '109306006', '109307002', '109308007', '109309004', '109310009', '109311008',
        '109312001', '109313006', '109314000', '109315004', '109316003', '109317007', '109318002',
        '109319005', '109320004', '109321000', '109322007', '109323002', '109324008', '109325009',
        '109326005', '109327001', '109328006', '109329003', '109330008', '109331007', '109332000',
        '109362006', '10954006', '109602002', '109603007', '109604001', '109611002', '109612009',
        '109631003', '109686002', '109687006', '109688001', '109689009', '109690000', '109691001',
        '109692008', '109693003', '109694009', '109695005', '109696006', '109697002', '109781001',
        '109782008', '109783003', '109784009', '109792000', '109802000', '109810004', '109811000',
        '10982004', '109867008', '109909008', '109910003', '1107004', '111183001', '111184007',
        '111274000', '111275004', '11134001', '111367007', '111409009', '111414008', '111415009',
        '111418006', '111538005', '111806005', '111807001', '111816002', '111819009', '111839008',
        '111843007', '111900000', '111911008', '111912001', '111938001', '111939009', '11251000',
        '11338007', '11381005', '11461005', '1156003', '11648002', '11840006', '11906007',
        '12062007', '12115003', '12232008', '123587001', '123588006', '123589003', '123590007',
        '123591006', '123592004', '123611003', '123613000', '12373006', '123754002', '123755001',
        '123951002', '12463005', '12713001', '127217009', '128045006', '1282001', '128220004',
        '128222007', '128276007', '128277003', '128278008', '128279000', '128280002', '128281003',
        '128282005', '12890007', '129128006', '129452008', '129458007', '129563009', '129670002',
        '13095005', '13101006', '13125003', '13177009', '13272007', '13277001', '13285005',
        '13301002', '13310005', '13325005', '13386009', '13680009', '13731006', '13802001',
        '14053009', '1415005', '14248008', '14255005', '14343001', '14405000', '14488001',
        '14800001', '14948001', '15033003', '151004', '15170009', '1532007', '15363000', '1551001',
        '15607007', '15628003', '15805002', '16036000', '16070004', '16119006', '16300007',
        '16486000', '16594005', '17028003', '17133001', '172001', '17305005', '17332000',
        '17354003', '17357005', '17365008', '17716001', '17732003', '17741008', '179101003',
        '18081009', '18099001', '181007', '186090001', '186104004', '186105003', '186116005',
        '186136006', '186137002', '186138007', '186150001', '186156007', '186342000', '186431008',
        '186675001', '186729003', '186731007', '186825001', '186826000', '186833000', '186842007',
        '186846005', '186847001', '186850003', '186854007', '186861006', '186863009', '186867005',
        '186868000', '186875004', '186877007', '186878002', '186899004', '186903006', '186915005',
        '186931002', '186932009', '186939000', '186946009', '187017007', '187042003', '188463006',
        '18900005', '189312004', '192008', '19206003', '19213003', '19240003', '192647003',
        '19272000', '19284003', '19290004', '19360008', '19372002', '193786000', '194005002',
        '194281003', '194282005', '194286008', '194287004', '194288009', '194289001', '194290005',
        '194339007', '19457002', '19471005', '194907008', '194947001', '195655000', '195656004',
        '195657008', '195658003', '195659006', '195660001', '195662009', '195666007', '195667003',
        '195668008', '195669000', '195670004', '195671000', '195672007', '195673002', '195676005',
        '195677001', '195756009', '195798007', '195811008', '195812001', '195813006', '195836002',
        '195878008', '195881003', '195886008', '195888009', '195889001', '195896004', '195902009',
        '195920000', '196067009', '196107009', '196108004', '196109007', '196112005', '196339009',
        '196341005', '196538002', '19670002', '197162007', '197163002', '197172005', '197176008',
        '197177004', '197178009', '197179001', '197180003', '197305002', '197324004', '197325003',
        '197326002', '197327006', '197328001', '197329009', '197330004', '197347003', '197348008',
        '197757004', '197760006', '197761005', '197762003', '197763008', '197764002', '197768004',
        '197769007', '197770008', '197834003', '197837005', '197845000', '197848003', '197849006',
        '197850006', '197853008', '197926005', '197927001', '197928006', '197963001', '197964007',
        '197965008', '197966009', '197967000', '197968005', '198130006', '198133008', '198135001',
        '198136000', '198137009', '198138004', '198141008', '198142001', '198143006', '198156004',
        '198159006', '198160001', '198161002', '198175009', '198176005', '198179003', '198180000',
        '198182008', '198183003', '198184009', '198185005', '198186006', '198188007', '198189004',
        '198199009', '198203009', '198206001', '198212006', '198216009', '198217000', '198218005',
        '198219002', '198220008', '198227006', '198230004', '198231000', '198235009', '198236005',
        '198241002', '198242009', '198824009', '19905009', '199111004', '199154009', '199156006',
        '199157002', '199158007', '199159004', '199161008', '199163006', '199164000', '199165004',
        '199166003', '199205008', '199206009', '19956000', '200181000', '200182007', '200185009',
        '200187001', '20025003', '200628009', '200630006', '200638004', '200645004', '200648002',
        '200649005', '200650005', '200651009', '200652002', '200655000', '200656004', '200657008',
        '200658003', '200659006', '200660001', '200661002', '200662009', '200663004', '200666007',
        '200667003', '200668008', '200669000', '200670004', '200674008', '200676005', '200678006',
        '200679003', '200680000', '200681001', '200682008', '200686006', '200687002', '200697006',
        '200698001', '200699009', '200700005', '200704001', '200705000', '200706004', '200707008',
        '200708003', '200709006', '200718008', '200722003', '200744008', '200751004', '200755008',
        '201215003', '201217006', '201218001', '201220003', '201222006', '201224007', '202933002',
        '203153007', '203157008', '203158003', '203159006', '203160001', '203161002', '203162009',
        '203163004', '203164005', '203165006', '203166007', '203167003', '203168008', '203169000',
        '203170004', '203171000', '203172007', '203173002', '203174008', '203175009', '203177001',
        '203178006', '203179003', '203184009', '203185005', '203186006', '203189004', '203193005',
        '203194004', '203195003', '203196002', '203197006', '203198001', '203199009', '203200007',
        '203201006', '203202004', '203221007', '203222000', '203226002', '203233002', '203241002',
        '203245006', '203249000', '203250000', '203251001', '203256006', '203257002', '203258007',
        '203259004', '203260009', '203296008', '203297004', '203298009', '203299001', '203300009',
        '20547008', '205717001', '206358003', '20735004', '207615004', '208545005', '20932005',
        '20943002', '21060003', '21061004', '21092002', '21120002', '21186006', '212438008',
        '21523006', '21711003', '2176006', '21780009', '21955004', '220145006', '222008',
        '22386003', '22399000', '22475001', '22557000', '22754005', '22775002', '22920003',
        '230150008', '230152000', '230182006', '230216007', '230402000', '230563005', '230605007',
        '230735006', '23160005', '23166004', '231796003', '231802001', '231858009', '232212002',
        '232214001', '232215000', '232251007', '232260004', '232268006', '232269003', '232270002',
        '232271003', '232313005', '232314004', '232363000', '232367004', '232391008', '232393006',
        '232394000', '232395004', '232397007', '232399005', '232400003', '232417005', '232420002',
        '232432003', '232433008', '23259007', '233604007', '233606009', '233607000', '233608005',
        '233609002', '233613009', '233617005', '233618000', '233620002', '233621003', '233622005',
        '233623000', '233624006', '233625007', '233713004', '233728004', '233730002', '233731003',
        '233785003', '233849007', '234017002', '234091000', '234096005', '23502006', '235032001',
        '235062007', '235064008', '235065009', '23550005', '235726002', '235747003', '235748008',
        '235749000', '235774002', '235795007', '235861001', '235863003', '235984009', '235994004',
        '235995003', '235996002', '235997006', '236063005', '236066002', '236076004', '236302005',
        '236373001', '236376009', '236377000', '236378005', '236379002', '23640001', '236620008',
        '236622000', '236623005', '236624004', '236625003', '236626002', '236627006', '236628001',
        '236629009', '236630004', '236672003', '236673008', '236682002', '236683007', '236687008',
        '236689006', '236702008', '236703003', '236704009', '236706006', '236766009', '236772009',
        '237037006', '237038001', '237039009', '237040006', '237042003', '237043008', '237044002',
        '237045001', '237046000', '237051006', '237069002', '237083000', '237084006', '237085007',
        '237091009', '237093007', '237094001', '237095000', '237096004', '237097008', '237103001',
        '237104007', '237106009', '237124006', '237446005', '237447001', '23754003', '238374001',
        '238375000', '238376004', '238377008', '238381008', '238386003', '238387007', '238388002',
        '238395006', '238396007', '238398008', '238401006', '238404003', '238405002', '238406001',
        '238419002', '2385003', '238530002', '238742005', '238743000', '238744006', '238745007',
        '238746008', '238752009', '23884004', '238921004', '238931006', '23894009', '238985006',
        '2390000', '239162003', '2396006', '23975003', '239785008', '239808004', '240039005',
        '240142002', '240143007', '240147008', '240148003', '240149006', '240150006', '240151005',
        '240152003', '240349003', '240350003', '240351004', '240352006', '240353001', '240354007',
        '240355008', '240356009', '240357000', '240365002', '240367005', '240368000', '240369008',
        '240370009', '240371008', '240372001', '240374000', '240375004', '240414006', '240444009',
        '240452007', '240453002', '240455009', '240456005', '240457001', '240458006', '240547000',
        '240552005', '240553000', '240554006', '240555007', '240556008', '240557004', '240558009',
        '240560006', '240562003', '240563008', '240564002', '240565001', '240566000', '240567009',
        '240568004', '240569007', '240571007', '240572000', '240573005', '240574004', '240575003',
        '240576002', '240577006', '240578001', '240579009', '240581006', '240582004', '240584003',
        '240589008', '240602008', '240603003', '240604009', '240635003', '240668005', '240669002',
        '240670001', '240671002', '240721007', '240736005', '240780005', '240802005', '24232008',
        '24288004', '24347001', '24520005', '24557004', '246956006', '24738006', '247467008',
        '247468003', '247517004', '24789006', '24868007', '249458000', '249463001', '251331003',
        '2523007', '254219004', '25764005', '26039008', '26135000', '262461007', '26249004',
        '26330000', '26466000', '26535009', '266071000', '266073002', '266074008', '266077001',
        '266078006', '266079003', '266123003', '266125005', '266126006', '266127002', '266128007',
        '266130009', '266133006', '266136003', '266138002', '266160004', '266162007', '266337001',
        '266350000', '266439004', '266463007', '26650005', '266564004', '266581008', '267759006',
        '267777001', '267778006', '267779003', '267780000', '267783003', '268016009', '268017000',
        '268018005', '268019002', '26883000', '270490007', '27174002', '271763005', '272006008',
        '272262003', '27278006', '274080003', '274081004', '274109003', '27420004', '27438001',
        '27460003', '275376007', '275412000', '275433009', '275441009', '275495004', '27561001',
        '27648007', '276677001', '276679003', '276700005', '27681008', '276877003', '27767004',
        '277678003', '277869007', '27787003', '278037002', '278038007', '278068003', '27836007',
        '278480000', '278481001', '278486006', '278516003', '27858009', '27916005', '279499002',
        '280483007', '280486004', '28198007', '283876006', '283877002', '28438004', '28572009',
        '28593007', '28653000', '286870008', '286977005', '286985001', '287000004', '287001000',
        '287002007', '287050006', '287052003', '287053008', '287054002', '287055001', '287056000',
        '28709001', '28769004', '28783002', '288242005', '289510007', '29608009', '297139009',
        '29864006', '29909004', '30080002', '300999006', '301000005', '301001009', '301002002',
        '301003007', '301004001', '301010001', '301011002', '301012009', '301013004', '30168008',
        '301706005', '301710008', '301711007', '301769001', '301771001', '301802001', '301824001',
        '301990003', '30239003', '302813001', '302911003', '3038009', '30406004', '30493003',
        '30584002', '3059002', '30635002', '307230004', '307231000', '307310000', '307423008',
        '307424002', '307425001', '307426000', '307534009', '30800001', '30806007', '308119005',
        '30833006', '308660004', '308661000', '308906005', '309083007', '309254003', '31015008',
        '3110003', '31137003', '312088007', '312099009', '312108008', '312109000', '312124009',
        '31218002', '312342009', '312400008', '312422001', '312934004', '312955002', '31302006',
        '31309002', '313352002', '31354001', '31412003', '314213003', '314214009', '314630009',
        '31474007', '314840009', '314978007', '315596001', '315597005', '31561003', '315826004',
        '316841006', '31999004', '32021005', '32038009', '32141002', '32226008', '32263004',
        '32286006', '32298001', '32392003', '32527003', '32580004', '32582007', '32636009',
        '32701000', '32735002', '32801008', '328488009', '32923006', '329489009', '33028007',
        '33134003', '3321001', '33261009', '335846001', '33655002', '33781009', '33924006',
        '33937009', '34020007', '34242002', '34543006', '34790005', '34997001', '3502005',
        '35037009', '3507004', '35168006', '35246005', '35255008', '35339003', '35377009',
        '35526001', '35542008', '35585004', '35708002', '35742006', '35876006', '3589003',
        '35923002', '35958000', '359613008', '359662008', '35974005', '359749002', '359751003',
        '360425009', '360595002', '36139001', '36188001', '36276008', '36281004', '3633001',
        '363746003', '36529003', '36616006', '36689008', '36699003', '36742000', '367504009',
        '36789003', '36857002', '37028008', '370518000', '37098000', '371061003', '371062005',
        '371237000', '371318006', '37133005', '371423007', '371551001', '37223007', '373135009',
        '373611003', '37430004', '37610005', '37649008', '37754005', '37830006', '37936001',
        '37948003', '38099005', '38176009', '38217004', '38297003', '385093006', '38523005',
        '38541002', '386034005', '38699009', '387665005', '387681000', '387682007', '387754006',
        '38822007', '388602007', '388604008', '38898003', '388982007', '388983002', '38961000',
        '38976008', '39085002', '390897008', '39120007', '39172002', '39341005', '396284006',
        '396285007', '396286008', '39747007', '397810006', '398319002', '398570005', '399095008',
        '399102002', '399183005', '3999002', '40055000', '4009004', '40113007', '40149008',
        '4016003', '4022007', '402201001', '402314003', '402338004', '402375009', '402437008',
        '402641003', '402642005', '402715000', '402797009', '402825002', '402828000', '402890001',
        '402896007', '402923008', '402927009', '402928004', '402929007', '402930002', '402931003',
        '402935007', '402939001', '402940004', '402941000', '402942007', '402943002', '402944008',
        '402945009', '402946005', '402947001', '402949003', '402950003', '402951004', '402957000',
        '403347003', '403348008', '403349000', '403350000', '403351001', '403352008', '403354009',
        '403355005', '403356006', '403357002', '403358007', '403359004', '403475002', '403477005',
        '403478000', '403479008', '403480006', '403482003', '403565003', '403702001', '403961004',
        '404174000', '40458008', '404907009', '405547004', '405548009', '405554005', '405562002',
        '405635002', '405950009', '405951008', '40635000', '406563003', '406581000', '406617004',
        '406618009', '407523005', '40766000', '407671000', '4082005', '408386002', '408679000',
        '408680002', '408682005', '409557008', '409648008', '409662001', '409664000', '409665004',
        '40970001', '409778008', '409780002', '410470003', '410472006', '410473001', '410474007',
        '410475008', '410478005', '41174002', '41207000', '41269000', '41381004', '414529006',
        '414530001', '415125002', '415141001', '41545003', '415724006', '41582007', '415822001',
        '416205001', '41700004', '417484006', '41789000', '418103007', '41910004', '419468003',
        '41954005', '419760006', '420544002', '420687005', '420787001', '420910002', '421047005',
        '421224000', '421454008', '421508002', '421671002', '42200001', '42228007', '422747000',
        '4232007', '423322005', '42338000', '423590009', '424551004', '42522007', '425464007',
        '425548001', '425562008', '425996009', '426121003', '426135001', '426137009', '426165006',
        '426247003', '426507006', '426637005', '426696003', '42680007', '426836003', '426874006',
        '427307004', '42746002', '427537009', '42770003', '427786008', '427787004', '427788009',
        '427909005', '428015005', '428091000', '428101005', '428193004', '428230005', '428252001',
        '428780000', '428783003', '428874003', '429437003', '429553003', '429767005', '430065009',
        '430395005', '430402003', '430404002', '430616003', '43114002', '431189009', '431231008',
        '431238002', '431261000', '431262007', '431308006', '431309003', '431467003', '4316006',
        '431709001', '431737008', '4324001', '432481004', '432992007', '435141000124102',
        '435201000124109', '43522000', '4359001', '43636000', '43830008', '43878008', '441590008',
        '441658007', '441942006', '442094008', '442506007', '443769009', '44412000', '444150000',
        '44428005', '444646006', '444760002', '444820005', '444834005', '445063003', '445096001',
        '445130008', '445152004', '445323009', '445408000', '445470006', '445506004', '44568006',
        '445918001', '446122002', '446292002', '446328009', '446543007', '446642005', '446672004',
        '446752000', '446754004', '446755003', '446756002', '446926000', '446988001', '447004005',
        '447044003', '447045002', '447102007', '447222001', '447282003', '447353001', '447354007',
        '447372001', '447386002', '447399004', '447402003', '44743006', '4483005', '44897000',
        '449671007', '449702005', '449710006', '449711005', '449717009', '449825003', '45022008',
        '45058001', '45312009', '45377007', '45629003', '45816000', '46235002', '46442004',
        '46536000', '4659007', '46689006', '46699001', '46799006', '46876003', '46970008',
        '47132003', '47493003', '47698002', '47756005', '47941007', '48036004', '48142003',
        '48153009', '48277006', '48278001', '4834000', '48503007', '48573006', '48631008',
        '48982009', '49249007', '49258000', '49298003', '49308005', '49558004', '49706007',
        '49736003', '49810002', '49908003', '49923008', '5028002', '50528008', '50675000',
        '5075002', '50804000', '5085001', '5093001', '50970007', '51030006', '51036000',
        '51152000', '51209006', '51211002', '51254007', '51530003', '51613008', '51707007',
        '51928006', '51960003', '52123000', '52190008', '52404001', '52414005', '52441000',
        '52478002', '52979002', '53084003', '53098006', '53116008', '53200002', '53277000',
        '53354003', '53396004', '53453008', '53502009', '53529004', '53664003', '53991003',
        '54026009', '54069001', '54084005', '54138003', '54274001', '54275000', '54287007',
        '54389007', '54672007', '54825009', '55023005', '55069005', '55083007', '55184003',
        '55355000', '55399009', '55551005', '55679008', '55768006', '56118002', '56321006',
        '56351000', '56644003', '56728002', '56937005', '57027007', '57468008', '57540006',
        '57593007', '57702005', '57725006', '58031004', '58056005', '58196009', '58227000',
        '58392004', '58763001', '58764007', '58890000', '58945008', '58949002', '58964002',
        '59172008', '59211000', '59221008', '59233003', '59307008', '59475000', '59530001',
        '59532009', '59663001', '59707005', '59721007', '59867002', '59883002', '59934002',
        '59967003', '60130002', '60165002', '60168000', '6033008', '60335002', '60350006',
        '60485005', '60528006', '60540006', '60684003', '60777000', '60867007', '60893000',
        '60967006', '61011009', '61048000', '6136003', '61500009', '61585002', '61612001',
        '61711004', '61884008', '6212009', '62199007', '62207008', '62224002', '62248006',
        '62394006', '6267005', '62819009', '62837005', '6284004', '62861003', '63064000',
        '63140003', '63144007', '63302006', '63375009', '63475008', '63530007', '63627007',
        '63650001', '63751007', '63870005', '63922003', '64102008', '64150007', '64366002',
        '64369009', '64375000', '64479007', '64532005', '64576003', '64667001', '64703005',
        '64740002', '64880000', '64917006', '64956000', '65049003', '65095005', '65127006',
        '65295003', '65363002', '65875003', '65967008', '65974003', '65984002', '66011008',
        '66160001', '66281009', '66429007', '66622006', '66634003', '66887000', '66898004',
        '66918004', '67125004', '67167008', '67224007', '67277002', '67322009', '67391006',
        '67525007', '67624004', '67667007', '67685000', '67832005', '67878002', '67915005',
        '6803002', '6815003', '68226007', '68272006', '68389001', '68409003', '68566005',
        '68640004', '68764005', '68843000', '6887003', '69430001', '69588003', '69595007',
        '69643006', '69651009', '69810009', '70036007', '700372006', '70120007', '702715008',
        '70385007', '7063008', '70637004', '7066000', '70718000', '70759006', '7079009',
        '70880006', '70983007', '71085009', '71255007', '71332006', '7138005', '71392009',
        '71746008', '71906005', '71926009', '72083004', '72102005', '72204002', '72222004',
        '72249004', '72369006', '7253006', '72605008', '72656004', '7272006', '72815004',
        '72899006', '72934000', '72936003', '72940007', '73237007', '7329003', '73345000',
        '73414003', '73452002', '736004', '73806001', '73908004', '73962000', '73970005',
        '7415003', '74372003', '74445007', '7448003', '74578003', '74598008', '74945001',
        '75100008', '75119003', '75286007', '75299005', '75375008', '7548000', '75498004',
        '75530006', '75548002', '75570004', '75585005', '75632007', '75817003', '75867005',
        '7587000', '75886002', '75947000', '75993002', '76035004', '76047005', '76090006',
        '76126009', '76151005', '76272004', '76366001', '7640004', '76549002', '76623002',
        '76653009', '7678002', '76782002', '76802005', '77028001', '77054009', '77106003',
        '77116006', '77360001', '77816008', '77863005', '77919000', '77939001', '78182002',
        '78420004', '78620007', '78623009', '78973009', '78996009', '7910003', '79216009',
        '79411002', '79560005', '80388004', '80437003', '80507005', '80600003', '80604007',
        '80640009', '80645004', '80770009', '81020007', '8107007', '81096007', '81125004',
        '81164001', '81339006', '81521003', '81598001', '82053000', '82126001', '82127005',
        '82323002', '82355002', '8258000', '82670009', '827006', '82770004', '82930004',
        '82959004', '83218005', '83271005', '83412009', '83684005', '83707009', '83774001',
        '83883001', '8414002', '84194006', '84224006', '84233008', '84261000119106', '84414000',
        '84490005', '84681008', '84724007', '84753008', '84889008', '85051008', '8519009',
        '85224001', '8549006', '85495007', '8555001', '85791004', '85857008', '85884009',
        '85904008', '86028001', '86070006', '86279000', '8628002', '86443005', '86479002',
        '86615009', '86709000', '87073000', '87117006', '87144001', '8725005', '87282003',
        '87318008', '87415007', '87665008', '87696004', '8771003', '87728001', '8776008',
        '87815001', '88027004', '88157006', '88220006', '88361008', '8838005', '88547002',
        '88616000', '8872002', '88813005', '88850006', '88943008', '88981003', '8912009',
        '89194009', '8954007', '89637003', '89933001', '90206003', '90271007', '9091006',
        '90979004', '91038008', '91155009', '91195006', '91538002', '91541006', '91554004',
        '91669008', '91862002', '9241004', '9516007', '95220008', '95423008', '95424002',
        '95425001', '9557000', '95593001', '95679004', '95746006', '95806007', '95811009',
        '95886009', '95889002', '9713002', '987007', '9941009'
    }


class AcuteRespiratoryFailure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1018'
    VALUE_SET_NAME = 'Acute Respiratory Failure'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J9600', 'J9601', 'J9602', 'J9620', 'J9621', 'J9622'}

    ICD9CM = {'51881'}

    SNOMEDCT = {'397767007', '65710008', '67905004'}


class UpperRespiratoryInfection(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1022'
    VALUE_SET_NAME = 'Upper Respiratory Infection'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J00', 'J060', 'J069'}

    ICD9CM = {'460', '4650', '4658', '4659'}

    SNOMEDCT = {
        '195708003', '281794004', '54150009', '54398005', '55355000', '78337007', '82272006'
    }


class PersistentAsthma(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1023'
    VALUE_SET_NAME = 'Persistent Asthma'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'J4530', 'J4531', 'J4532', 'J4540', 'J4541', 'J4542', 'J4550', 'J4551', 'J4552'}

    SNOMEDCT = {
        '426656000', '426979002', '427295004', '427354000', '5281000124103', '901000119100'
    }


class ObstructiveChronicBronchitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1024'
    VALUE_SET_NAME = 'Obstructive Chronic Bronchitis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD9CM = {'49120', '49121', '49122'}

    SNOMEDCT = {'185086009', '293241000119100'}


class Diabetes(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1001'
    VALUE_SET_NAME = 'Diabetes'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'E1010', 'E1011', 'E1021', 'E1022', 'E1029', 'E10311', 'E10319', 'E10321', 'E103211',
        'E103212', 'E103213', 'E103219', 'E10329', 'E103291', 'E103292', 'E103293', 'E103299',
        'E10331', 'E103311', 'E103312', 'E103313', 'E103319', 'E10339', 'E103391', 'E103392',
        'E103393', 'E103399', 'E10341', 'E103411', 'E103412', 'E103413', 'E103419', 'E10349',
        'E103491', 'E103492', 'E103493', 'E103499', 'E10351', 'E103511', 'E103512', 'E103513',
        'E103519', 'E103521', 'E103522', 'E103523', 'E103529', 'E103531', 'E103532', 'E103533',
        'E103539', 'E103541', 'E103542', 'E103543', 'E103549', 'E103551', 'E103552', 'E103553',
        'E103559', 'E10359', 'E103591', 'E103592', 'E103593', 'E103599', 'E1036', 'E1037X1',
        'E1037X2', 'E1037X3', 'E1037X9', 'E1039', 'E1040', 'E1041', 'E1042', 'E1043', 'E1044',
        'E1049', 'E1051', 'E1052', 'E1059', 'E10610', 'E10618', 'E10620', 'E10621', 'E10622',
        'E10628', 'E10630', 'E10638', 'E10641', 'E10649', 'E1065', 'E1069', 'E108', 'E109',
        'E1100', 'E1101', 'E1121', 'E1122', 'E1129', 'E11311', 'E11319', 'E11321', 'E113211',
        'E113212', 'E113213', 'E113219', 'E11329', 'E113291', 'E113292', 'E113293', 'E113299',
        'E11331', 'E113311', 'E113312', 'E113313', 'E113319', 'E11339', 'E113391', 'E113392',
        'E113393', 'E113399', 'E11341', 'E113411', 'E113412', 'E113413', 'E113419', 'E11349',
        'E113491', 'E113492', 'E113493', 'E113499', 'E11351', 'E113511', 'E113512', 'E113513',
        'E113519', 'E113521', 'E113522', 'E113523', 'E113529', 'E113531', 'E113532', 'E113533',
        'E113539', 'E113541', 'E113542', 'E113543', 'E113549', 'E113551', 'E113552', 'E113553',
        'E113559', 'E11359', 'E113591', 'E113592', 'E113593', 'E113599', 'E1136', 'E1137X1',
        'E1137X2', 'E1137X3', 'E1137X9', 'E1139', 'E1140', 'E1141', 'E1142', 'E1143', 'E1144',
        'E1149', 'E1151', 'E1152', 'E1159', 'E11610', 'E11618', 'E11620', 'E11621', 'E11622',
        'E11628', 'E11630', 'E11638', 'E11641', 'E11649', 'E1165', 'E1169', 'E118', 'E119',
        'E1300', 'E1301', 'E1310', 'E1311', 'E1321', 'E1322', 'E1329', 'E13311', 'E13319',
        'E13321', 'E133211', 'E133212', 'E133213', 'E133219', 'E13329', 'E133291', 'E133292',
        'E133293', 'E133299', 'E13331', 'E133311', 'E133312', 'E133313', 'E133319', 'E13339',
        'E133391', 'E133392', 'E133393', 'E133399', 'E13341', 'E133411', 'E133412', 'E133413',
        'E133419', 'E13349', 'E133491', 'E133492', 'E133493', 'E133499', 'E13351', 'E133511',
        'E133512', 'E133513', 'E133519', 'E133521', 'E133522', 'E133523', 'E133529', 'E133531',
        'E133532', 'E133533', 'E133539', 'E133541', 'E133542', 'E133543', 'E133549', 'E133551',
        'E133552', 'E133553', 'E133559', 'E13359', 'E133591', 'E133592', 'E133593', 'E133599',
        'E1336', 'E1337X1', 'E1337X2', 'E1337X3', 'E1337X9', 'E1339', 'E1340', 'E1341', 'E1342',
        'E1343', 'E1344', 'E1349', 'E1351', 'E1352', 'E1359', 'E13610', 'E13618', 'E13620',
        'E13621', 'E13622', 'E13628', 'E13630', 'E13638', 'E13641', 'E13649', 'E1365', 'E1369',
        'E138', 'E139', 'O24011', 'O24012', 'O24013', 'O24019', 'O2402', 'O2403', 'O24111',
        'O24112', 'O24113', 'O24119', 'O2412', 'O2413', 'O24311', 'O24312', 'O24313', 'O24319',
        'O2432', 'O2433', 'O24811', 'O24812', 'O24813', 'O24819', 'O2482', 'O2483'
    }

    ICD9CM = {
        '25000', '25001', '25002', '25003', '25010', '25011', '25012', '25013', '25020', '25021',
        '25022', '25023', '25030', '25031', '25032', '25033', '25040', '25041', '25042', '25043',
        '25050', '25051', '25052', '25053', '25060', '25061', '25062', '25063', '25070', '25071',
        '25072', '25073', '25080', '25081', '25082', '25083', '25090', '25091', '25092', '25093',
        '3572', '36201', '36202', '36203', '36204', '36205', '36206', '36207', '36641', '64800',
        '64801', '64802', '64803', '64804'
    }

    SNOMEDCT = {
        '190330002', '190331003', '190368000', '190369008', '190372001', '190389009', '190390000',
        '199223000', '199225007', '199226008', '199227004', '199228009', '199229001', '199230006',
        '23045005', '237599002', '237618001', '237627000', '28032008', '313435000', '313436004',
        '314771006', '314772004', '314893005', '314894004', '314902007', '314903002', '314904008',
        '359642000', '44054006', '46635009', '4783006', '75682002', '76751001', '81531005',
        '9859006'
    }


class VisualExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1013'
    VALUE_SET_NAME = 'Visual Exam of Foot'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'401191002'}


class SensoryExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1014'
    VALUE_SET_NAME = 'Sensory Exam of Foot'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'134388005'}


class PulseExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1015'
    VALUE_SET_NAME = 'Pulse Exam of Foot'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'91161007'}


class AcuteMyocardialInfarction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1001'
    VALUE_SET_NAME = 'Acute Myocardial Infarction'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I2101', 'I2102', 'I2109', 'I2111', 'I2119', 'I2121', 'I2129', 'I213', 'I214', 'I220',
        'I221', 'I222', 'I228', 'I229', 'I230', 'I231', 'I232', 'I233', 'I234', 'I235', 'I236',
        'I237', 'I238', 'I252'
    }

    ICD9CM = {
        '41000', '41001', '41002', '41010', '41011', '41012', '41020', '41021', '41022', '41030',
        '41031', '41032', '41040', '41041', '41042', '41050', '41051', '41052', '41060', '41061',
        '41062', '41070', '41071', '41072', '41080', '41081', '41082', '41090', '41091', '41092',
        '412'
    }

    SNOMEDCT = {
        '10273003', '15990001', '17531000119105', '194798004', '194802003', '194809007',
        '23311000119105', '233825009', '233826005', '233827001', '233828006', '233829003',
        '233830008', '233831007', '233832000', '233833005', '233834004', '233835003', '233836002',
        '233837006', '233838001', '282006', '285981000119103', '285991000119100', '30277009',
        '304914007', '307140009', '401303003', '401314000', '52035003', '54329005', '57054005',
        '58612006', '59063002', '62695002', '64627002', '65547006', '70211005', '70422006',
        '70998009', '73795002', '76593002', '79009004'
    }


class CoronaryArteryBypassGraft(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1002'
    VALUE_SET_NAME = 'Coronary Artery Bypass Graft'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '33510', '33511', '33512', '33513', '33514', '33516', '33517', '33518', '33519', '33521',
        '33522', '33523', '33533', '33534', '33535', '33536'
    }

    HCPCS = {'S2205', 'S2206', 'S2207', 'S2208', 'S2209'}

    SNOMEDCT = {
        '10190003', '10326007', '119564002', '119565001', '14323007', '175007008', '175008003',
        '175009006', '175011002', '175021005', '175022003', '175024002', '175025001', '175026000',
        '175029007', '175030002', '175031003', '175032005', '175033000', '175045009', '175047001',
        '175048006', '175050003', '232717009', '232719007', '232720001', '232721002', '232722009',
        '232723004', '232724005', '265481001', '275215001', '275216000', '275252001', '275253006',
        '29819009', '30670000', '309814006', '3546002', '359597003', '359601003', '39202005',
        '39724006', '414088005', '418551006', '418824004', '419132001', '48431000', '67166004',
        '74371005', '82247006', '90487008'
    }


class IschemicVascularDisease(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1003'
    VALUE_SET_NAME = 'Ischemic Vascular Disease'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'I200', 'I208', 'I209', 'I240', 'I241', 'I248', 'I249', 'I2510', 'I25110', 'I25111',
        'I25118', 'I25119', 'I255', 'I256', 'I25700', 'I25701', 'I25708', 'I25709', 'I25710',
        'I25711', 'I25718', 'I25719', 'I25720', 'I25721', 'I25728', 'I25729', 'I25730', 'I25731',
        'I25738', 'I25739', 'I25750', 'I25751', 'I25758', 'I25759', 'I25760', 'I25761', 'I25768',
        'I25769', 'I25790', 'I25791', 'I25798', 'I25799', 'I25810', 'I25811', 'I25812', 'I2582',
        'I2583', 'I2584', 'I2589', 'I259', 'I6300', 'I63011', 'I63012', 'I63019', 'I6302',
        'I63031', 'I63032', 'I63039', 'I6309', 'I6310', 'I63111', 'I63112', 'I63119', 'I6312',
        'I63131', 'I63132', 'I63139', 'I6319', 'I6320', 'I63211', 'I63212', 'I63213', 'I63219',
        'I6322', 'I63231', 'I63232', 'I63233', 'I63239', 'I6329', 'I6330', 'I63311', 'I63312',
        'I63319', 'I63321', 'I63322', 'I63329', 'I63331', 'I63332', 'I63339', 'I63341', 'I63342',
        'I63349', 'I6339', 'I6340', 'I63411', 'I63412', 'I63419', 'I63421', 'I63422', 'I63429',
        'I63431', 'I63432', 'I63439', 'I63441', 'I63442', 'I63449', 'I6349', 'I6350', 'I63511',
        'I63512', 'I63513', 'I63519', 'I63521', 'I63522', 'I63523', 'I63529', 'I63531', 'I63532',
        'I63533', 'I63539', 'I63541', 'I63542', 'I63543', 'I63549', 'I6359', 'I636', 'I638',
        'I639', 'I6501', 'I6502', 'I6503', 'I6509', 'I651', 'I6521', 'I6522', 'I6523', 'I6529',
        'I658', 'I659', 'I6601', 'I6602', 'I6603', 'I6609', 'I6611', 'I6612', 'I6613', 'I6619',
        'I6621', 'I6622', 'I6623', 'I6629', 'I663', 'I668', 'I669', 'I672', 'I700', 'I701',
        'I70201', 'I70202', 'I70203', 'I70208', 'I70209', 'I70211', 'I70212', 'I70213', 'I70218',
        'I70219', 'I70221', 'I70222', 'I70223', 'I70228', 'I70229', 'I70231', 'I70232', 'I70233',
        'I70234', 'I70235', 'I70238', 'I70239', 'I70241', 'I70242', 'I70243', 'I70244', 'I70245',
        'I70248', 'I70249', 'I7025', 'I70261', 'I70262', 'I70263', 'I70268', 'I70269', 'I70291',
        'I70292', 'I70293', 'I70298', 'I70299', 'I70301', 'I70302', 'I70303', 'I70308', 'I70309',
        'I70311', 'I70312', 'I70313', 'I70318', 'I70319', 'I70321', 'I70322', 'I70323', 'I70328',
        'I70329', 'I70331', 'I70332', 'I70333', 'I70334', 'I70335', 'I70338', 'I70339', 'I70341',
        'I70342', 'I70343', 'I70344', 'I70345', 'I70348', 'I70349', 'I7035', 'I70361', 'I70362',
        'I70363', 'I70368', 'I70369', 'I70391', 'I70392', 'I70393', 'I70398', 'I70399', 'I70401',
        'I70402', 'I70403', 'I70408', 'I70409', 'I70411', 'I70412', 'I70413', 'I70418', 'I70419',
        'I70421', 'I70422', 'I70423', 'I70428', 'I70429', 'I70431', 'I70432', 'I70433', 'I70434',
        'I70435', 'I70438', 'I70439', 'I70441', 'I70442', 'I70443', 'I70444', 'I70445', 'I70448',
        'I70449', 'I7045', 'I70461', 'I70462', 'I70463', 'I70468', 'I70469', 'I70491', 'I70492',
        'I70493', 'I70498', 'I70499', 'I70501', 'I70502', 'I70503', 'I70508', 'I70509', 'I70511',
        'I70512', 'I70513', 'I70518', 'I70519', 'I70521', 'I70522', 'I70523', 'I70528', 'I70529',
        'I70531', 'I70532', 'I70533', 'I70534', 'I70535', 'I70538', 'I70539', 'I70541', 'I70542',
        'I70543', 'I70544', 'I70545', 'I70548', 'I70549', 'I7055', 'I70561', 'I70562', 'I70563',
        'I70568', 'I70569', 'I70591', 'I70592', 'I70593', 'I70598', 'I70599', 'I70601', 'I70602',
        'I70603', 'I70608', 'I70609', 'I70611', 'I70612', 'I70613', 'I70618', 'I70619', 'I70621',
        'I70622', 'I70623', 'I70628', 'I70629', 'I70631', 'I70632', 'I70633', 'I70634', 'I70635',
        'I70638', 'I70639', 'I70641', 'I70642', 'I70643', 'I70644', 'I70645', 'I70648', 'I70649',
        'I7065', 'I70661', 'I70662', 'I70663', 'I70668', 'I70669', 'I70691', 'I70692', 'I70693',
        'I70698', 'I70699', 'I70701', 'I70702', 'I70703', 'I70708', 'I70709', 'I70711', 'I70712',
        'I70713', 'I70718', 'I70719', 'I70721', 'I70722', 'I70723', 'I70728', 'I70729', 'I70731',
        'I70732', 'I70733', 'I70734', 'I70735', 'I70738', 'I70739', 'I70741', 'I70742', 'I70743',
        'I70744', 'I70745', 'I70748', 'I70749', 'I7075', 'I70761', 'I70762', 'I70763', 'I70768',
        'I70769', 'I70791', 'I70792', 'I70793', 'I70798', 'I70799', 'I708', 'I7090', 'I7091',
        'I7092', 'I7401', 'I7409', 'I7410', 'I7411', 'I7419', 'I742', 'I743', 'I744', 'I745',
        'I748', 'I749', 'I75011', 'I75012', 'I75013', 'I75019', 'I75021', 'I75022', 'I75023',
        'I75029', 'I7581', 'I7589', 'T82855A', 'T82855D', 'T82855S', 'T82856A', 'T82856D',
        'T82856S'
    }

    ICD9CM = {
        '4110', '4111', '41181', '41189', '4130', '4139', '41400', '41401', '41402', '41403',
        '41404', '41405', '41406', '41407', '4142', '4143', '4144', '4148', '4149', '4292',
        '43300', '43301', '43310', '43311', '43320', '43321', '43330', '43331', '43380', '43381',
        '43390', '43391', '43400', '43401', '43410', '43411', '43490', '43491', '4370', '4400',
        '4401', '44020', '44021', '44022', '44023', '44024', '44029', '44030', '44031', '44032',
        '4404', '4408', '4409', '44401', '44409', '4441', '44421', '44422', '44481', '44489',
        '4449', '44501', '44502', '44581', '44589'
    }

    SNOMEDCT = {
        '1055001', '109381003', '111291001', '111296006', '111298007', '111299004', '123641001',
        '123642008', '129573006', '145891000119104', '14977000', '149821000119103',
        '1641000119107', '19057007', '194823009', '194828000', '194842008', '194843003',
        '194849004', '195182007', '195183002', '195185009', '195186005', '195189003', '195190007',
        '195200006', '195206000', '195230003', '195231004', '195232006', '195233001', '195234007',
        '195235008', '195236009', '195254008', '195317001', '195318006', '195319003', '195320009',
        '195321008', '195323006', '195324000', '195325004', '195326003', '195327007', '195335005',
        '195336006', '195337002', '195340002', '195341003', '195342005', '195343000', '20059004',
        '21000119103', '21470009', '21631000119105', '225566008', '230692004', '230693009',
        '230694003', '230695002', '230698000', '230699008', '230700009', '230701008', '230702001',
        '230703006', '230704000', '230706003', '230707007', '230708002', '230716006', '233817007',
        '233819005', '233821000', '233823002', '233844002', '233955003', '233956002', '233958001',
        '233959009', '233960004', '233961000', '233962007', '233964008', '233970002', '233972005',
        '233973000', '233974006', '236120009', '23687008', '251024009', '25106000', '266253001',
        '266254007', '266262004', '266263009', '26900001', '274101000', '276219001', '280871000',
        '281091000', '284871000119105', '284881000119108', '285141000119106', '285151000119108',
        '285161000119105', '285171000119104', '285191000119103', '285201000119100', '286959000',
        '287731003', '28790007', '297136002', '297138001', '297141005', '29899005', '300917007',
        '300920004', '300995000', '301755001', '302728008', '302904002', '302910002', '302930003',
        '307363008', '307406004', '307407008', '307408003', '307409006', '307766002', '307767006',
        '312375001', '312378004', '312822006', '314116003', '315025001', '315348000', '35928006',
        '361132001', '361133006', '363340006', '371039008', '371041009', '371803003', '371804009',
        '371805005', '371806006', '371807002', '371808007', '371809004', '371810009', '371811008',
        '371812001', '37943007', '394659003', '39823006', '40276003', '402861007', '408546009',
        '408665008', '413102000', '41334000', '413439005', '413444003', '413552002', '413758000',
        '413838009', '413844008', '414545008', '414795007', '420006002', '425527003', '426107000',
        '426651005', '427296003', '427567003', '428196007', '428507003', '429245005', '429559004',
        '429673002', '429811000124106', '429821000124103', '429831000124100', '429841000124105',
        '429851000124107', '429861000124109', '430721000124101', '430731000124103',
        '430781000124102', '430831000124106', '430841000124101', '430851000124104',
        '430861000124102', '431391000124106', '431401000124108', '431411000124106',
        '431421000124103', '431431000124100', '431466007', '432083006', '432504007',
        '433821000124102', '433891000124100', '433901000124101', '433911000124103',
        '433931000124109', '433941000124104', '433951000124102', '433961000124100',
        '434151000124101', '434821000124104', '434831000124101', '434881000124100',
        '434891000124102', '434951000124104', '434961000124102', '434991000124105',
        '435271000124103', '435281000124100', '436021000124100', '436031000124102',
        '436041000124107', '436781000124104', '437911000124106', '441574008', '442224005',
        '442240008', '442421004', '442439008', '442693003', '442701004', '442735001', '443502000',
        '443971004', '444855007', '444856008', '446712002', '45281005', '4557003', '48601002',
        '49176002', '50808002', '51274000', '51677000', '52674009', '53741008', '5431000124100',
        '5441000124105', '5451000124107', '54519002', '5461000124109', '54687002', '5534004',
        '55382008', '5581000124100', '5601000124105', '57357009', '59021001', '59062007',
        '60989005', '61490001', '63739005', '64586002', '64775002', '65084004', '65198009',
        '66189004', '6661000119101', '67682002', '67992007', '69742007', '71444005', '72092001',
        '73192008', '75543006', '791000119109', '8001000119106', '80383008', '80606009',
        '81817003', '85284003', '87343002', '88174006', '89323001', '90520006', '92517006',
        '95458005', '95459002', '95580006', '9901000119100', '99451000119105'
    }


class PercutaneousCoronaryInterventions(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1010'
    VALUE_SET_NAME = 'Percutaneous Coronary Interventions'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'92920', '92924', '92928', '92933', '92937', '92941', '92943'}

    SNOMEDCT = {
        '11101003', '15256002', '175066001', '232727003', '232728008', '232729000', '397193006',
        '397431004', '414089002', '414509005', '415070008', '428488008', '429499003', '429639007',
        '429809004', '431759005', '609152003', '609153008', '609154002', '698740005', '75761004',
        '80762004', '85053006', '91338001'
    }


class EssentialHypertension(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1011'
    VALUE_SET_NAME = 'Essential Hypertension'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'I10'}

    ICD9CM = {'4010', '4011', '4019'}

    SNOMEDCT = {
        '10725009', '1201005', '276789009', '371125006', '429457004', '46481004', '48146000',
        '56218007', '59621000', '59720008', '65518004', '78975002'
    }


class HdlCLaboratoryTest(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1012'
    VALUE_SET_NAME = 'HDL-C Laboratory Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'18263-4', '2085-9', '49130-8'}


class TotalCholesterolLaboratoryTest(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1013'
    VALUE_SET_NAME = 'Total Cholesterol Laboratory Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'2093-3', '48620-9'}


class TriglyceridesLaboratoryTest(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1014'
    VALUE_SET_NAME = 'Triglycerides Laboratory Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'12951-0', '2571-8'}


class ValvularHeartDisease(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1017'
    VALUE_SET_NAME = 'Valvular Heart Disease'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A5203', 'I011', 'I020', 'I050', 'I051', 'I052', 'I058', 'I059', 'I060', 'I061', 'I062',
        'I068', 'I069', 'I070', 'I071', 'I072', 'I078', 'I079', 'I080', 'I081', 'I082', 'I083',
        'I088', 'I089', 'I091', 'I0989', 'I234', 'I235', 'I340', 'I341', 'I342', 'I348', 'I349',
        'I350', 'I351', 'I352', 'I358', 'I359', 'I360', 'I361', 'I362', 'I368', 'I369', 'I370',
        'I371', 'I372', 'I378', 'I379', 'I38', 'I39', 'I511', 'I512', 'Q213', 'Q220', 'Q221',
        'Q222', 'Q223', 'Q224', 'Q225', 'Q226', 'Q228', 'Q229', 'Q230', 'Q231', 'Q232', 'Q233',
        'Q234', 'Q238', 'Q239', 'Q248', 'Q253', 'T8201XA', 'T8201XD', 'T8201XS', 'T8202XA',
        'T8202XD', 'T8202XS', 'T8203XA', 'T8203XD', 'T8203XS', 'T8209XA', 'T8209XD', 'T8209XS',
        'T826XXA', 'T826XXD', 'T826XXS'
    }

    ICD9CM = {
        '09320', '09321', '09322', '09323', '09324', '3911', '3940', '3941', '3942', '3949',
        '3950', '3951', '3952', '3959', '3960', '3961', '3962', '3963', '3968', '3969', '3970',
        '3971', '3979', '4240', '4241', '4242', '4243', '42490', '42499', '4253', '4295', '4296',
        '42981', '7452', '74600', '74601', '74602', '74609', '7461', '7462', '7463', '7464',
        '7465', '7466', '74689', '74722', '99602', '99661'
    }

    SNOMEDCT = {
        '10273003', '111287006', '1131009', '11851006', '12023003', '123643003', '123656005',
        '123657001', '123658006', '123801008', '123802001', '128599005', '13689005', '15096009',
        '16063004', '163092009', '163093004', '16440002', '16855001', '17394001', '17759006',
        '18192007', '18546004', '18687009', '186875004', '186877007', '186878002', '19036004',
        '194726006', '194727002', '194732001', '194733006', '194734000', '194735004', '194736003',
        '194737007', '194741006', '194866002', '194867006', '194978002', '194983005', '194984004',
        '194987006', '194989009', '194990000', '194991001', '194992008', '194995005', '194997002',
        '195000004', '195002007', '195003002', '195004008', '195005009', '195141007', '195142000',
        '19833008', '204306007', '204319006', '204339005', '204342004', '204343009', '204345002',
        '204346001', '204351007', '204352000', '204354004', '204357006', '204362007', '204363002',
        '204402008', '20721001', '213036006', '213038007', '21379009', '23063005', '233848004',
        '233849007', '233853009', '233856001', '233858000', '233859008', '233860003', '233861004',
        '233862006', '233863001', '233864007', '233865008', '233866009', '234181008', '234182001',
        '234183006', '234184000', '234185004', '234186003', '234187007', '234188002', '234189005',
        '248675005', '248678007', '248679004', '248680001', '248682009', '248684005', '248685006',
        '248686007', '248687003', '248688008', '248691008', '250973007', '250974001', '250975000',
        '250976004', '250978003', '250979006', '250982001', '250983006', '250984000', '250985004',
        '250987007', '250988002', '250989005', '250990001', '250991002', '250992009', '250993004',
        '250994005', '250995006', '250996007', '250997003', '250999000', '251001002', '251002009',
        '251003004', '251004005', '251006007', '251007003', '251036003', '251038002', '253374008',
        '253375009', '253376005', '253377001', '253378006', '253379003', '253380000', '253381001',
        '253382008', '253383003', '253384009', '253385005', '253386006', '253387002', '253388007',
        '253389004', '253390008', '253391007', '253392000', '253393005', '253394004', '253395003',
        '253396002', '253397006', '253398001', '253399009', '253400002', '253401003', '253402005',
        '253403000', '253404006', '253405007', '253406008', '253407004', '253408009', '253409001',
        '253410006', '253411005', '253412003', '253413008', '253427003', '253428008', '253429000',
        '253430005', '253431009', '253432002', '253433007', '253434001', '253435000', '253436004',
        '253437008', '253438003', '253439006', '253440008', '253441007', '253442000', '253443005',
        '253444004', '253445003', '253446002', '253447006', '253448001', '253449009', '253450009',
        '253451008', '253452001', '253453006', '253454000', '253455004', '253456003', '253457007',
        '253458002', '253459005', '253460000', '253461001', '253462008', '253463003', '253464009',
        '253465005', '253467002', '253468007', '253469004', '253470003', '253471004', '253472006',
        '253473001', '253474007', '253475008', '253476009', '253477000', '253478005', '253479002',
        '253480004', '253481000', '253482007', '253483002', '253484008', '253485009', '253486005',
        '253487001', '253488006', '253489003', '253490007', '253491006', '253492004', '253493009',
        '253494003', '253495002', '253496001', '253497005', '253498000', '253499008', '253500004',
        '253501000', '253502007', '253503002', '253504008', '253505009', '253506005', '253507001',
        '253508006', '253509003', '253510008', '253512000', '253513005', '253514004', '253515003',
        '253543007', '253562005', '253578007', '253579004', '253580001', '253581002', '253582009',
        '253583004', '253584005', '253585006', '253586007', '253587003', '253588008', '253593006',
        '253595004', '253596003', '253597007', '253598002', '253599005', '253600008', '253601007',
        '253602000', '253603005', '253604004', '253606002', '253607006', '253608001', '253609009',
        '253610004', '253611000', '253612007', '253641003', '253642005', '253647004', '253648009',
        '266250003', '266252006', '268185002', '27007008', '270906004', '271984008', '274097009',
        '274098004', '275282007', '276518005', '276790000', '276795005', '278480000', '278928000',
        '28284007', '28656008', '286947004', '286948009', '286950001', '29375001', '297197008',
        '297285002', '297286001', '29928006', '301105002', '301106001', '301109008', '301110003',
        '301184001', '301185000', '302943003', '308687000', '31085000', '315615007', '32615007',
        '33700007', '34126003', '35162007', '36079008', '36133000', '36222008', '36233006',
        '368009', '370141003', '37171002', '371813006', '371814000', '371815004', '371816003',
        '373116009', '373133002', '373134008', '373135009', '373136005', '373137001', '38230003',
        '398995000', '399228007', '40023000', '40445007', '405550001', '405551002', '405552009',
        '405553004', '405554005', '40964007', '409712001', '410068002', '417081007', '417094009',
        '417191003', '42069006', '427515002', '42770003', '428164004', '429347004', '430065009',
        '430402003', '430616003', '431189009', '43121002', '431238002', '431261000', '431262007',
        '43176009', '432992007', '4374004', '43873004', '44241007', '445270008', '445284003',
        '445285002', '445286001', '445298006', '445330003', '445373007', '445607003', '445636003',
        '445650008', '446628002', '446630000', '446633003', '446670007', '446699002', '446781004',
        '446786009', '447261009', '447670001', '447671002', '447672009', '447681003', '447682005',
        '447683000', '447695000', '447696004', '447697008', '447698003', '447774002', '447779007',
        '447822009', '447829000', '447830005', '447847006', '447875008', '447915002', '447937009',
        '448004007', '448026008', '448061002', '448073002', '448074008', '448085005', '448098001',
        '448099009', '448100001', '448102009', '448104005', '448115000', '448116004', '448117008',
        '448161000', '448280008', '448328001', '448413002', '448475002', '448497000', '448528000',
        '448576004', '448604006', '448618004', '448626007', '448634001', '448643005', '448684008',
        '448723007', '448724001', '448729006', '448743001', '448744007', '448745008', '448746009',
        '448777006', '448780007', '448790004', '448793002', '448819009', '448820003', '448821004',
        '448822006', '448827000', '448828005', '448836001', '448844001', '448903003', '448905005',
        '448946000', '448947009', '448948004', '449005003', '449008001', '449011000', '449029005',
        '449031001', '449032008', '449037002', '449040002', '449086000', '449087009', '449098005',
        '449099002', '449110001', '449111002', '449112009', '449116007', '449123008', '449124002',
        '449133000', '449136008', '449139001', '449140004', '449149003', '449158005', '449186002',
        '449189009', '449228007', '449270002', '449315003', '449316002', '449354002', '449382009',
        '449383004', '449388008', '449455000', '449511008', '449512001', '449529003', '449534004',
        '449544002', '449555002', '449563001', '449564007', '449567000', '449568005', '449601008',
        '449605004', '44993000', '45058001', '46165000', '48724000', '48872007', '49699002',
        '49915006', '50608004', '51442005', '5203004', '52048004', '52757001', '54073003',
        '54160000', '55836009', '56786000', '57373003', '58056005', '5919001', '59464004',
        '60232001', '60234000', '60573004', '61612001', '63042009', '65457005', '67278007',
        '67696008', '67754003', '6996004', '70320004', '7169009', '71799002', '72011007',
        '72352009', '75372006', '76257003', '76267008', '77696009', '78031003', '78196008',
        '78320000', '78495000', '787001', '79619009', '8074002', '81552002', '82355002', '8239009',
        '82458004', '83119008', '83898004', '84871007', '85971001', '86299006', '86466006',
        '86856005', '8722008', '88318005', '89456004', '89736004', '90154003', '91434003',
        '91442002', '91529004', '91634006', '92808004', '92830003', '92888002', '92923008',
        '92941000', '92944008', '92960007', '92963009', '92969008', '92974000', '92976003',
        '93069000', '93075009', '93076005', '93234006', '93237004', '93271008', '93287006',
        '94720001'
    }


class ComputedValueInrPercentTtr(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1018'
    VALUE_SET_NAME = 'Computed Value INR percent TTR'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'72281-9'}


class MentalHealthDiagnoses(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1004'
    VALUE_SET_NAME = 'Mental Health Diagnoses'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F0390', 'F0391', 'F200', 'F201', 'F202', 'F203', 'F205', 'F2081', 'F2089', 'F209', 'F21',
        'F22', 'F23', 'F24', 'F250', 'F251', 'F258', 'F259', 'F28', 'F29', 'F3010', 'F3011',
        'F3012', 'F3013', 'F302', 'F303', 'F304', 'F308', 'F309', 'F310', 'F3110', 'F3111',
        'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160', 'F3161',
        'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3172', 'F3173', 'F3174', 'F3175', 'F3176',
        'F3177', 'F3178', 'F3181', 'F3189', 'F319', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325',
        'F328', 'F3281', 'F3289', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3340', 'F3341',
        'F3342', 'F338', 'F339', 'F340', 'F341', 'F348', 'F3481', 'F3489', 'F349', 'F39', 'F4000',
        'F4001', 'F4002', 'F4010', 'F4011', 'F40210', 'F40218', 'F40220', 'F40228', 'F40230',
        'F40231', 'F40232', 'F40233', 'F40240', 'F40241', 'F40242', 'F40243', 'F40248', 'F40290',
        'F40291', 'F40298', 'F408', 'F409', 'F410', 'F411', 'F413', 'F418', 'F419', 'F42', 'F422',
        'F423', 'F424', 'F428', 'F429', 'F430', 'F4310', 'F4311', 'F4312', 'F4320', 'F4321',
        'F4322', 'F4323', 'F4324', 'F4325', 'F4329', 'F438', 'F439', 'F440', 'F441', 'F442',
        'F444', 'F445', 'F446', 'F447', 'F4481', 'F4489', 'F449', 'F450', 'F451', 'F4520', 'F4521',
        'F4522', 'F4529', 'F4541', 'F4542', 'F458', 'F459', 'F481', 'F482', 'F488', 'F489',
        'F5000', 'F5001', 'F5002', 'F502', 'F508', 'F5081', 'F5089', 'F509', 'F5101', 'F5102',
        'F5103', 'F5104', 'F5105', 'F5109', 'F5111', 'F5112', 'F5113', 'F5119', 'F513', 'F514',
        'F515', 'F518', 'F519', 'F520', 'F521', 'F5221', 'F5222', 'F5231', 'F5232', 'F524', 'F525',
        'F526', 'F528', 'F529', 'F53', 'F59', 'F600', 'F601', 'F602', 'F603', 'F604', 'F605',
        'F606', 'F607', 'F6081', 'F6089', 'F609', 'F630', 'F631', 'F632', 'F633', 'F6381', 'F6389',
        'F639', 'F640', 'F641', 'F642', 'F648', 'F649', 'F650', 'F651', 'F652', 'F653', 'F654',
        'F6550', 'F6551', 'F6552', 'F6581', 'F6589', 'F659', 'F66', 'F6810', 'F6811', 'F6812',
        'F6813', 'F688', 'F69', 'F800', 'F801', 'F802', 'F804', 'F8081', 'F8082', 'F8089', 'F809',
        'F810', 'F812', 'F8181', 'F8189', 'F819', 'F82', 'F840', 'F842', 'F843', 'F845', 'F848',
        'F849', 'F88', 'F89', 'F900', 'F901', 'F902', 'F908', 'F909', 'F910', 'F911', 'F912',
        'F913', 'F918', 'F919', 'F930', 'F938', 'F939', 'F940', 'F941', 'F942', 'F948', 'F949',
        'F950', 'F951', 'F952', 'F958', 'F959', 'F980', 'F981', 'F9821', 'F9829', 'F983', 'F984',
        'F985', 'F988', 'F989', 'F99'
    }

    ICD9CM = {
        '29010', '29011', '29012', '29013', '29020', '29021', '2903', '29040', '29041', '29042',
        '29043', '2908', '2909', '2930', '2931', '29381', '29382', '29383', '29384', '29389',
        '2939', '2940', '29410', '29411', '29420', '29421', '2948', '2949', '29500', '29501',
        '29502', '29503', '29504', '29505', '29510', '29511', '29512', '29513', '29514', '29515',
        '29520', '29521', '29522', '29523', '29524', '29525', '29530', '29531', '29532', '29533',
        '29534', '29535', '29540', '29541', '29542', '29543', '29544', '29545', '29550', '29551',
        '29552', '29553', '29554', '29555', '29560', '29561', '29562', '29563', '29564', '29565',
        '29570', '29571', '29572', '29573', '29574', '29575', '29580', '29581', '29582', '29583',
        '29584', '29585', '29590', '29591', '29592', '29593', '29594', '29595', '29600', '29601',
        '29602', '29603', '29604', '29605', '29606', '29610', '29611', '29612', '29613', '29614',
        '29615', '29616', '29620', '29621', '29622', '29623', '29624', '29625', '29626', '29630',
        '29631', '29632', '29633', '29634', '29635', '29636', '29640', '29641', '29642', '29643',
        '29644', '29645', '29646', '29650', '29651', '29652', '29653', '29654', '29655', '29656',
        '29660', '29661', '29662', '29663', '29664', '29665', '29666', '2967', '29680', '29681',
        '29682', '29689', '29690', '29699', '2970', '2971', '2972', '2973', '2978', '2979', '2980',
        '2981', '2982', '2983', '2984', '2988', '2989', '29900', '29901', '29910', '29911',
        '29980', '29981', '29990', '29991', '30000', '30001', '30002', '30009', '30010', '30011',
        '30012', '30013', '30014', '30015', '30016', '30019', '30020', '30021', '30022', '30023',
        '30029', '3003', '3004', '3005', '3006', '3007', '30081', '30082', '30089', '3009', '3010',
        '30110', '30111', '30112', '30113', '30120', '30121', '30122', '3013', '3014', '30150',
        '30151', '30159', '3016', '3017', '30181', '30182', '30183', '30184', '30189', '3019',
        '3020', '3021', '3022', '3023', '3024', '30250', '30251', '30252', '30253', '3026',
        '30270', '30271', '30272', '30273', '30274', '30275', '30276', '30279', '30281', '30282',
        '30283', '30284', '30285', '30289', '3029', '3060', '3061', '3062', '3063', '3064',
        '30650', '30651', '30652', '30653', '30659', '3066', '3067', '3068', '3069', '3070',
        '3071', '30720', '30721', '30722', '30723', '3073', '30740', '30741', '30742', '30743',
        '30744', '30745', '30746', '30747', '30748', '30749', '30750', '30751', '30752', '30753',
        '30754', '30759', '3076', '3077', '30780', '30781', '30789', '3079', '3080', '3081',
        '3082', '3083', '3084', '3089', '3090', '3091', '30921', '30922', '30923', '30924',
        '30928', '30929', '3093', '3094', '30981', '30982', '30983', '30989', '3099', '3100',
        '3101', '3102', '31081', '31089', '3109', '311', '31200', '31201', '31202', '31203',
        '31210', '31211', '31212', '31213', '31220', '31221', '31222', '31223', '31230', '31231',
        '31232', '31233', '31234', '31235', '31239', '3124', '31281', '31282', '31289', '3129',
        '3130', '3131', '31321', '31322', '31323', '3133', '31381', '31382', '31383', '31389',
        '3139', '31400', '31401', '3141', '3142', '3148', '3149', '31500', '31501', '31502',
        '31509', '3151', '3152', '31531', '31532', '31534', '31535', '31539', '3154', '3155',
        '3158', '3159', '316'
    }

    SNOMEDCT = {
        '10007009', '10278007', '10327003', '10349009', '10532003', '10586006', '106013002',
        '106014008', '106015009', '109006', '109478007', '109805003', '109896009', '109897000',
        '109898005', '109899002', '109900007', '109901006', '11061003', '111475002', '111476001',
        '111477005', '111479008', '111480006', '111482003', '111483008', '111484002', '111485001',
        '111487009', '111490003', '111491004', '1145003', '11806006', '11941006', '1196001',
        '12348006', '126943008', '128293007', '129104009', '12939007', '129602009', '129604005',
        '129606007', '130121000119104', '133091000119105', '133121000119109', '13313007',
        '13438001', '13601005', '13670005', '13746004', '1376001', '1380006', '1383008',
        '14070001', '14077003', '14144000', '14183003', '14291003', '14784000', '1499003',
        '15193003', '15277004', '15662003', '1581000119101', '1591000119103', '15945005',
        '15977008', '162004', '162313000', '162702000', '162722001', '16295005', '16506000',
        '16805009', '1686006', '16966009', '16990005', '17155009', '17226007', '17262008',
        '17496003', '17782008', '18003009', '18085000', '1816003', '18260003', '18478005',
        '18491000119109', '1855002', '18573003', '18653004', '18689007', '187921002', '18818009',
        '191447007', '191449005', '191451009', '191452002', '191454001', '191455000', '191457008',
        '191458003', '191459006', '191461002', '191463004', '191464005', '191465006', '191466007',
        '191471000', '191475009', '191476005', '191477001', '191478006', '191480000', '191483003',
        '191484009', '191485005', '191486006', '191492000', '191493005', '191494004', '191495003',
        '191496002', '191499009', '191501001', '191502008', '191503003', '191504009', '191505005',
        '191507002', '191508007', '191509004', '191510009', '191511008', '191512001', '191519005',
        '191525009', '191526005', '191527001', '191530008', '191531007', '191536002', '191537006',
        '191538001', '191539009', '191540006', '191542003', '191547009', '191548004', '191554003',
        '191555002', '191559008', '191564007', '191567000', '191569002', '191570001', '191571002',
        '191572009', '191574005', '191577003', '191590005', '191592002', '191593007', '191595000',
        '191597008', '191610000', '191611001', '191613003', '191615005', '191616006', '191618007',
        '191620005', '191621009', '191623007', '191625000', '191627008', '191629006', '191630001',
        '191632009', '191634005', '191636007', '191659001', '191667009', '191668004', '191670008',
        '191672000', '191676002', '191678001', '191680007', '191687005', '191689008', '191690004',
        '191692007', '191693002', '191696005', '191697001', '191714002', '191722009', '191724005',
        '191725006', '191726007', '191736004', '191737008', '191738003', '191753006', '191765005',
        '191766006', '191772006', '191773001', '191774007', '191787001', '191811004', '191812006',
        '191813001', '191928000', '191966002', '191983006', '191990001', '192014006', '192016008',
        '192017004', '192037000', '192038005', '192039002', '192041001', '192042008', '192044009',
        '192046006', '192049004', '192051000', '192052007', '192054008', '192056005', '192057001',
        '192058006', '192061007', '192063005', '192064004', '192065003', '192069009', '192072002',
        '192073007', '192079006', '192080009', '192097003', '192099000', '192108001', '192110004',
        '192122001', '192123006', '192127007', '192131001', '192132008', '192136006', '192147004',
        '192527004', '192562009', '192575009', '192611004', '192616009', '192631000', '193756007',
        '19445006', '19480005', '1973000', '197480006', '19766004', '199257008', '199259006',
        '199260001', '199261002', '199262009', '20010003', '20385005', '20876004', '21000000',
        '21071000119101', '21586000', '21634003', '21897009', '21900002', '22121000', '22230001',
        '22381000119105', '22407005', '22419002', '22641000119109', '229025005', '229621000',
        '229622007', '229623002', '229625009', '229631007', '229632000', '229683000', '229698003',
        '229699006', '229700007', '229701006', '229715008', '229721007', '229729009', '229733002',
        '229734008', '229736005', '229738006', '229740001', '229741002', '229742009', '229743004',
        '229744005', '229745006', '229748008', '22981000119106', '230265002', '230266001',
        '230267005', '230268000', '230269008', '230280008', '230285003', '230286002', '230287006',
        '230288001', '230289009', '230334008', '230335009', '230338006', '230438007', '230455006',
        '2312009', '231437006', '231438001', '231439009', '231440006', '231442003', '231443008',
        '231444002', '231445001', '231446000', '231448004', '231449007', '231450007', '231451006',
        '231452004', '231453009', '231454003', '231455002', '231456001', '231457005', '231458000',
        '231459008', '231467000', '23148009', '231485007', '231487004', '231489001', '231494001',
        '231496004', '231500002', '231504006', '231516000', '231520001', '231521002', '231522009',
        '231523004', '231524005', '231525006', '231526007', '231527003', '231528008', '231530005',
        '231532002', '231535000', '231536004', '231537008', '231538003', '231539006', '231542000',
        '232059000', '233690008', '23560001', '23601000119102', '23645006', '237351003',
        '237352005', '23741000119105', '23772009', '238110009', '238959007', '238960002',
        '238961003', '238965007', '238966008', '238967004', '238972008', '238973003', '238974009',
        '238975005', '238976006', '238977002', '238978007', '238979004', '2403008', '24121004',
        '24125008', '24315006', '247803002', '247804008', '24781009', '25029006', '251000119105',
        '25501002', '25766007', '25772007', '26025008', '261000119107', '2618002', '26203008',
        '26453000', '26472000', '26516009', '26665006', '26714005', '267320004', '26852004',
        '268612007', '268617001', '268621008', '268622001', '268624000', '268633003', '268634009',
        '268658008', '268664001', '268666004', '268667008', '268668003', '268669006', '268672004',
        '268673009', '268724009', '268727002', '268734000', '268738002', '26929004',
        '270291000119109', '270901009', '270902002', '270903007', '270905000', '271000119101',
        '271428004', '271952001', '27387000', '274948002', '274950005', '274952002', '274953007',
        '27544004', '275473003', '275474009', '27720003', '2776000', '278506006', '278508007',
        '278852008', '278853003', '278857002', '27956007', '279611005', '280032002', '280375000',
        '280377008', '280378003', '280949006', '280982009', '280983004', '280984005', '280986007',
        '280994000', '281000119103', '281004', '2815001', '28357009', '28368009', '28475009',
        '28663008', '28676002', '286933003', '288271000119103', '28857002', '28864000',
        '288751000119101', '28884001', '29212009', '29599000', '29657007', '29733004', '29929003',
        '30059008', '300706003', '301643003', '302507002', '30310000', '30336007', '30491001',
        '30509009', '30687003', '307417003', '30871003', '309279000', '30935000', '310202009',
        '31027006', '310495003', '310496002', '310497006', '310814007', '311173003', '31177006',
        '312098001', '312936002', '312991009', '313182004', '313224008', '313426007', '31358003',
        '31373002', '313915006', '31446002', '3158007', '31611000', '31658008', '31715000',
        '31781004', '317816007', '318784009', '319768000', '32009006', '32174002', '32358001',
        '32388005', '32552001', '32721004', '32875003', '32880007', '3298001', '33078009',
        '33135002', '33323008', '33380008', '33449004', '33693007', '33871004', '33982008',
        '34116005', '34315001', '34485008', '34938008', '3503000', '35218008', '35252006',
        '35253001', '35481005', '35489007', '35607004', '357705009', '35827000', '35919005',
        '359661001', '36039004', '36217008', '36262007', '36474008', '36583000', '36622002',
        '367515004', '36943003', '370143000', '371024007', '371026009', '371596008', '371600003',
        '371631005', '37331004', '373618009', '37739004', '37746008', '37868008', '37872007',
        '37941009', '38295006', '38328002', '38368003', '38547003', '386701004', '386810004',
        '386821008', '386822001', '386823006', '386824000', '386825004', '38694004', '39003006',
        '391099000', '3914008', '39465007', '39610001', '397803000', '398066007', '39807006',
        '39809009', '39951000119105', '39951001', '40083003', '402732001', '402733006',
        '402735004', '403170002', '403590001', '403593004', '403594005', '403595006', '40379007',
        '404906000', '40568001', '40571009', '406506008', '40673001', '408856003', '408857007',
        '408858002', '40987004', '41021005', '41083005', '412787009', '414673004', '41524005',
        '41526007', '41552001', '416073003', '416340002', '416714005', '416780008', '416975007',
        '417143004', '417360004', '41836007', '420774007', '421023003', '422437002', '42344001',
        '425914008', '425919003', '42594001', '426041005', '426174008', '426881004', '427145007',
        '427469003', '427975003', '428007007', '428051000124108', '428351000124105', '42868002',
        '428687006', '428703001', '429161000124103', '429672007', '429998004', '4306003',
        '430744005', '430751001', '430771000124100', '430909002', '43150009', '432091002',
        '43497001', '434971000124109', '43568002', '43614003', '439960005', '44031002', '44124003',
        '441704009', '441711008', '441716003', '441719005', '441833000', '442057004', '442243005',
        '442245003', '442314000', '442351006', '443735008', '443919007', '44433009', '44966003',
        '450714000', '45479006', '45677003', '45912004', '45924006', '45994004', '46206005',
        '46244001', '46372006', '46432001', '46721000', '46762006', '46975003', '472981000',
        '473020005', '473452003', '473456000', '473457009', '47372000', '47447001', '47505003',
        '47664006', '47916000', '4817008', '48500005', '48589009', '4926007', '49271002',
        '4932002', '49468007', '49481000', '4949009', '49512000', '49564006', '4997005',
        '50026000', '50299009', '50320000', '50705009', '50722006', '50878001', '50933003',
        '5095008', '50983008', '51133006', '51443000', '51493001', '5158005', '51637008',
        '51771007', '51928006', '52448006', '52702003', '52824009', '52866005', '52910006',
        '52954000', '53050002', '53467004', '53607008', '53936005', '53956006', '54319003',
        '54417002', '5444000', '54502004', '54587008', '5464005', '54761006', '55009008',
        '5507002', '5509004', '5510009', '55341008', '55516002', '55668003', '55728007',
        '55967005', '5619004', '56194001', '56267009', '56573006', '56576003', '56627002',
        '5664002', '56641006', '568005', '56882008', '5703000', '57194009', '57588009', '57715001',
        '58214004', '58329000', '58349009', '58535001', '58647003', '58703003', '59174009',
        '59216005', '59252009', '59617007', '59645001', '59651006', '59923000', '600009',
        '60103007', '60123008', '609225004', '61104008', '61144001', '61157009', '61180001',
        '61212007', '61403008', '61569007', '61771000119106', '61831009', '62211000119103',
        '62221000119105', '62231000119108', '62239001', '62351001', '62491004', '62792007',
        '63181006', '63204009', '63249007', '63393005', '6348008', '63649001', '63701002',
        '63835008', '63909006', '63983005', '64060000', '64165008', '64731001', '6475002',
        '64905009', '65064003', '65096006', '66108005', '66344007', '66347000', '66381006',
        '66590003', '66631006', '66936004', '67123006', '67195008', '68019004', '68569003',
        '68618008', '68890003', '68963006', '68995007', '69322001', '69361009', '69479009',
        '69482004', '7025000', '70328006', '7052005', '70546001', '70655008', '70691001',
        '70814008', '70932007', '70936005', '71103003', '71328000', '71336009', '71787009',
        '71959007', '71961003', '71984005', '7200002', '72366004', '72861004', '7291006',
        '73097000', '73462009', '7397008', '74007000', '74010007', '74142004', '74266001',
        '7461003', '74686005', '74732009', '74934004', '75122001', '75360000', '75752004',
        '75837004', '76105009', '76236006', '76566000', '76812003', '76868007', '77355000',
        '77383003', '77475008', '77486005', '77675002', '77815007', '7794004', '78004001',
        '78269000', '78358001', '78640000', '78667006', '79204003', '79341000119107', '79524000',
        '79578000', '79584002', '79842004', '79866005', '80711002', '80868005', '81463002',
        '8185002', '81903006', '82096005', '82218004', '82339009', '82415003', '82494000',
        '82636008', '82738004', '82959004', '82998009', '83168008', '83225003', '83253003',
        '83367009', '83458005', '83501007', '83631006', '83746006', '83890006', '84002002',
        '84466009', '84760002', '84788008', '84984002', '85061001', '8511007', '8522006',
        '85248005', '85561006', '85762002', '85821003', '85861002', '8635005', '87132004',
        '87203005', '87414006', '87798009', '87950005', '87991007', '88339003', '8837000',
        '88740003', '88845000', '88939009', '88975006', '89016005', '89381000119107', '89415002',
        '89451009', '89501000119108', '89618007', '899001', '89948007', '89989005', '90099008',
        '90755006', '90790003', '9167000', '9340000', '9345005', '93461009', '95635002',
        '95636001', '95637005', '9674006', '9760005'
    }


class MajorDepression(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1007'
    VALUE_SET_NAME = 'Major Depression'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F320', 'F321', 'F322', 'F323', 'F324', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3341',
        'F339'
    }

    ICD9CM = {
        '29620', '29621', '29622', '29623', '29624', '29625', '29630', '29631', '29632', '29633',
        '29634', '29635'
    }

    SNOMEDCT = {
        '14183003', '15193003', '15639000', '18818009', '191601008', '191602001', '191604000',
        '191610000', '191611001', '191613003', '20250007', '231499006', '251000119105', '25922000',
        '2618002', '268620009', '268621008', '274948002', '281000119103', '28475009', '300706003',
        '30605009', '319768000', '320751009', '321717001', '33078009', '33135002', '33736005',
        '36474008', '36923009', '370143000', '38694004', '39809009', '40379007', '42925002',
        '430852001', '450714000', '60099002', '63778009', '66344007', '69392006', '70747007',
        '71336009', '73867007', '75084000', '76441001', '77911002', '79298009', '832007',
        '87512008'
    }


class AlcoholAndDrugDependence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1001'
    VALUE_SET_NAME = 'Alcohol and Drug Dependence'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F1010', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159', 'F10180',
        'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F10220', 'F10221', 'F10229', 'F10230',
        'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259', 'F1026', 'F1027',
        'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921', 'F10929', 'F1094',
        'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981', 'F10982', 'F10988',
        'F1099', 'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150', 'F11151',
        'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F11220', 'F11221', 'F11222',
        'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281', 'F11282', 'F11288',
        'F1129', 'F1190', 'F11920', 'F11921', 'F11922', 'F11929', 'F1193', 'F1194', 'F11950',
        'F11951', 'F11959', 'F11981', 'F11982', 'F11988', 'F1199', 'F1210', 'F12120', 'F12121',
        'F12122', 'F12129', 'F12150', 'F12151', 'F12159', 'F12180', 'F12188', 'F1219', 'F1220',
        'F12220', 'F12221', 'F12222', 'F12229', 'F12250', 'F12251', 'F12259', 'F12280', 'F12288',
        'F1229', 'F1290', 'F12920', 'F12921', 'F12922', 'F12929', 'F12950', 'F12951', 'F12959',
        'F12980', 'F12988', 'F1299', 'F1310', 'F13120', 'F13121', 'F13129', 'F1314', 'F13150',
        'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188', 'F1319', 'F1320', 'F13220',
        'F13221', 'F13229', 'F13230', 'F13231', 'F13232', 'F13239', 'F1324', 'F13250', 'F13251',
        'F13259', 'F1326', 'F1327', 'F13280', 'F13281', 'F13282', 'F13288', 'F1329', 'F1390',
        'F13920', 'F13921', 'F13929', 'F13930', 'F13931', 'F13932', 'F13939', 'F1394', 'F13950',
        'F13951', 'F13959', 'F1396', 'F1397', 'F13980', 'F13981', 'F13982', 'F13988', 'F1399',
        'F1410', 'F14120', 'F14121', 'F14122', 'F14129', 'F1414', 'F14150', 'F14151', 'F14159',
        'F14180', 'F14181', 'F14182', 'F14188', 'F1419', 'F1420', 'F14220', 'F14221', 'F14222',
        'F14229', 'F1423', 'F1424', 'F14250', 'F14251', 'F14259', 'F14280', 'F14281', 'F14282',
        'F14288', 'F1429', 'F1490', 'F14920', 'F14921', 'F14922', 'F14929', 'F1494', 'F14950',
        'F14951', 'F14959', 'F14980', 'F14981', 'F14982', 'F14988', 'F1499', 'F1510', 'F15120',
        'F15121', 'F15122', 'F15129', 'F1514', 'F15150', 'F15151', 'F15159', 'F15180', 'F15181',
        'F15182', 'F15188', 'F1519', 'F1520', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523',
        'F1524', 'F15250', 'F15251', 'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529',
        'F1590', 'F15920', 'F15921', 'F15922', 'F15929', 'F1593', 'F1594', 'F15950', 'F15951',
        'F15959', 'F15980', 'F15981', 'F15982', 'F15988', 'F1599', 'F1610', 'F16120', 'F16121',
        'F16122', 'F16129', 'F1614', 'F16150', 'F16151', 'F16159', 'F16180', 'F16183', 'F16188',
        'F1619', 'F1620', 'F16220', 'F16221', 'F16229', 'F1624', 'F16250', 'F16251', 'F16259',
        'F16280', 'F16283', 'F16288', 'F1629', 'F1690', 'F16920', 'F16921', 'F16929', 'F1694',
        'F16950', 'F16951', 'F16959', 'F16980', 'F16983', 'F16988', 'F1699', 'F1810', 'F18120',
        'F18121', 'F18129', 'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188',
        'F1819', 'F1820', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259',
        'F1827', 'F18280', 'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894',
        'F18950', 'F18951', 'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F19120',
        'F19121', 'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917',
        'F19180', 'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F19220', 'F19221', 'F19222',
        'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259',
        'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929', 'F1990', 'F19920',
        'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939', 'F1994', 'F19950',
        'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982', 'F19988', 'F1999'
    }

    ICD9CM = {
        '2910', '2911', '2912', '2913', '2914', '2915', '29181', '29182', '29189', '2919', '30300',
        '30301', '30302', '30390', '30391', '30392', '30400', '30401', '30402', '30410', '30411',
        '30412', '30420', '30421', '30422', '30430', '30431', '30432', '30440', '30441', '30442',
        '30450', '30451', '30452', '30460', '30461', '30462', '30470', '30471', '30472', '30480',
        '30481', '30482', '30490', '30491', '30492', '30500', '30501', '30502', '30520', '30521',
        '30522', '30530', '30531', '30532', '30540', '30541', '30542', '30550', '30551', '30552',
        '30560', '30561', '30562', '30570', '30571', '30572', '30580', '30581', '30582', '30590',
        '30591', '30592', '53530', '53531', '5711'
    }

    SNOMEDCT = {
        '10028000', '10327003', '105546006', '105549004', '1081000119105', '110281001', '11061003',
        '111479008', '111480006', '11387009', '12380008', '125851000119106', '1383008',
        '145101000119102', '145841000119107', '1461000119109', '1471000119103', '14784000',
        '15167005', '15277004', '153491000119103', '153501000119105', '1686006', '18653004',
        '18689007', '191471000', '191475009', '191476005', '191477001', '191478006', '191480000',
        '191483003', '191484009', '191485005', '191486006', '191492000', '191493005', '191494004',
        '191495003', '191496002', '191802004', '191804003', '191805002', '191811004', '191812006',
        '191813001', '191816009', '191819002', '191820008', '191825003', '191826002', '191829009',
        '191831000', '191832007', '191837001', '191838006', '191843004', '191844005', '191849000',
        '191850000', '191853003', '191855005', '191856006', '191865004', '191867007', '191868002',
        '191871005', '191873008', '191874002', '191877009', '191928000', '191939002', '19303008',
        '19445006', '1973000', '199252002', '199253007', '199254001', '199255000', '20385005',
        '20876004', '21000000', '21647008', '226034001', '228371004', '228372006', '228373001',
        '228375008', '228376009', '228377000', '228378005', '228379002', '228380004', '228381000',
        '228382007', '228383002', '228384008', '228386005', '228387001', '228388006', '228389003',
        '230334008', '230443000', '231451006', '231458000', '231459008', '231461004', '231462006',
        '231467000', '231468005', '231469002', '231470001', '231472009', '231473004', '231474005',
        '231475006', '231477003', '231478008', '231479000', '231480002', '231481003', '231482005',
        '236751006', '237228001', '2403008', '25508008', '26714005', '267206008', '268640002',
        '268641003', '268727002', '27956007', '280982009', '280983004', '280984005', '280986007',
        '281004', '28368009', '284591009', '288281000119100', '28864000', '29212009', '29733004',
        '301643003', '302507002', '30310000', '30491001', '307052004', '30871003', '309279000',
        '310202009', '311173003', '312098001', '312936002', '313915006', '31715000', '31956009',
        '32009006', '32358001', '32552001', '32875003', '33845003', '33871004', '34938008',
        '361049005', '361150008', '361151007', '363101005', '37331004', '37344009', '38247002',
        '39003006', '396344000', '39807006', '39951001', '403590001', '40571009', '41083005',
        '416073003', '416714005', '417143004', '417360004', '42344001', '425339005', '425885002',
        '426001001', '426095000', '426873000', '427205009', '427229002', '427327003', '427975003',
        '428219007', '428370001', '428406005', '428493006', '428495004', '428561000124100',
        '428623008', '428659002', '428819003', '428823006', '429001000124103', '429179002',
        '429299000', '429512006', '429672007', '429692000', '429782000', '43497001', '441681009',
        '442351006', '442406005', '445273005', '46721000', '46975003', '47664006', '4863002',
        '5002000', '50026000', '50320000', '50722006', '50933003', '50983008', '51339003',
        '51443000', '51493001', '52866005', '53050002', '53936005', '5444000', '55967005',
        '5602001', '56194001', '57588009', '58727001', '59651006', '61104008', '61144001',
        '6348008', '63649001', '63983005', '64386003', '6525002', '66590003', '69482004',
        '70328006', '70340006', '7052005', '70545002', '70655008', '7071007', '70932007',
        '71328000', '7200002', '73097000', '74851005', '74934004', '75122001', '75544000',
        '77355000', '78267003', '78358001', '78524005', '79578000', '80868005', '82339009',
        '83168008', '83367009', '84758004', '85005007', '85561006', '8635005', '87132004',
        '8837000', '89451009', '90755006', '90790003', '91388009', '95635002', '95661003',
        '95918004'
    }


class IvDrugAbuse(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1003'
    VALUE_SET_NAME = 'IV Drug Abuse'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150', 'F11151', 'F11159',
        'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F1121', 'F11220', 'F11221', 'F11222',
        'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281', 'F11282', 'F11288',
        'F1129', 'F1190', 'F11920', 'F11921', 'F11922', 'F11929', 'F1193', 'F1194', 'F11950',
        'F11951', 'F11959', 'F11981', 'F11982', 'F11988', 'F1199', 'F1310', 'F13120', 'F13121',
        'F13129', 'F1314', 'F13150', 'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188',
        'F1319', 'F1320', 'F1321', 'F13220', 'F13221', 'F13229', 'F13230', 'F13231', 'F13232',
        'F13239', 'F1324', 'F13250', 'F13251', 'F13259', 'F1326', 'F1327', 'F13280', 'F13281',
        'F13282', 'F13288', 'F1329', 'F1390', 'F13920', 'F13921', 'F13929', 'F13930', 'F13931',
        'F13932', 'F13939', 'F1394', 'F13950', 'F13951', 'F13959', 'F1396', 'F1397', 'F13980',
        'F13981', 'F13982', 'F13988', 'F1399', 'F1410', 'F14120', 'F14121', 'F14122', 'F14129',
        'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188', 'F1419',
        'F1420', 'F1421', 'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250',
        'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1490', 'F14920',
        'F14921', 'F14922', 'F14929', 'F1494', 'F14950', 'F14951', 'F14959', 'F14980', 'F14981',
        'F14982', 'F14988', 'F1499', 'F1510', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514',
        'F15150', 'F15151', 'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520',
        'F1521', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251',
        'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921',
        'F15922', 'F15929', 'F1593', 'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981',
        'F15982', 'F15988', 'F1599'
    }

    ICD9CM = {
        '30400', '30401', '30402', '30403', '30410', '30411', '30412', '30413', '30420', '30421',
        '30422', '30423', '30440', '30441', '30442', '30443', '30540', '30541', '30542', '30543',
        '30550', '30551', '30552', '30553', '30560', '30561', '30562', '30563', '30570', '30571',
        '30572', '30573'
    }

    SNOMEDCT = {
        '1081000119105', '191819002', '191820008', '191821007', '191825003', '191826002',
        '191827006', '191831000', '191832007', '191833002', '191843004', '191844005', '191845006',
        '191905001', '191906000', '191907009', '191909007', '191912005', '191913000', '191914006',
        '191916008', '191918009', '191919001', '191920007', '191924003', '191925002', '21647008',
        '231461004', '231462006', '231470001', '231472009', '231473004', '231474005', '231475006',
        '231477003', '231478008', '231479000', '231480002', '268640002', '268647004', '268648009',
        '31956009', '414874007', '426001001', '426873000', '427205009', '427327003', '429692000',
        '5602001', '64386003', '75544000', '78267003', '84758004'
    }


class SubstanceAbuse(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1004'
    VALUE_SET_NAME = 'Substance Abuse'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'F1010', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159', 'F10180',
        'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F1021', 'F10220', 'F10221', 'F10229',
        'F10230', 'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259', 'F1026',
        'F1027', 'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921', 'F10929',
        'F1094', 'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981', 'F10982',
        'F10988', 'F1099', 'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150',
        'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F1121', 'F11220',
        'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281',
        'F11282', 'F11288', 'F1129', 'F1190', 'F11920', 'F11921', 'F11922', 'F11929', 'F1193',
        'F1194', 'F11950', 'F11951', 'F11959', 'F11981', 'F11982', 'F11988', 'F1199', 'F1210',
        'F12120', 'F12121', 'F12122', 'F12129', 'F12150', 'F12151', 'F12159', 'F12180', 'F12188',
        'F1219', 'F1220', 'F1221', 'F12220', 'F12221', 'F12222', 'F12229', 'F12250', 'F12251',
        'F12259', 'F12280', 'F12288', 'F1229', 'F1290', 'F12920', 'F12921', 'F12922', 'F12929',
        'F12950', 'F12951', 'F12959', 'F12980', 'F12988', 'F1299', 'F1310', 'F13120', 'F13121',
        'F13129', 'F1314', 'F13150', 'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188',
        'F1319', 'F1320', 'F1321', 'F13220', 'F13221', 'F13229', 'F13230', 'F13231', 'F13232',
        'F13239', 'F1324', 'F13250', 'F13251', 'F13259', 'F1326', 'F1327', 'F13280', 'F13281',
        'F13282', 'F13288', 'F1329', 'F1390', 'F13920', 'F13921', 'F13929', 'F13930', 'F13931',
        'F13932', 'F13939', 'F1394', 'F13950', 'F13951', 'F13959', 'F1396', 'F1397', 'F13980',
        'F13981', 'F13982', 'F13988', 'F1399', 'F1410', 'F14120', 'F14121', 'F14122', 'F14129',
        'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188', 'F1419',
        'F1420', 'F1421', 'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250',
        'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1490', 'F14920',
        'F14921', 'F14922', 'F14929', 'F1494', 'F14950', 'F14951', 'F14959', 'F14980', 'F14981',
        'F14982', 'F14988', 'F1499', 'F1510', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514',
        'F15150', 'F15151', 'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520',
        'F1521', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251',
        'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921',
        'F15922', 'F15929', 'F1593', 'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981',
        'F15982', 'F15988', 'F1599', 'F1610', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614',
        'F16150', 'F16151', 'F16159', 'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F1621',
        'F16220', 'F16221', 'F16229', 'F1624', 'F16250', 'F16251', 'F16259', 'F16280', 'F16283',
        'F16288', 'F1629', 'F1690', 'F16920', 'F16921', 'F16929', 'F1694', 'F16950', 'F16951',
        'F16959', 'F16980', 'F16983', 'F16988', 'F1699', 'F1810', 'F18120', 'F18121', 'F18129',
        'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188', 'F1819', 'F1820',
        'F1821', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259', 'F1827',
        'F18280', 'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894', 'F18950',
        'F18951', 'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F19120', 'F19121',
        'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917', 'F19180',
        'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F1921', 'F19220', 'F19221', 'F19222',
        'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259',
        'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929', 'F1990', 'F19920',
        'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939', 'F1994', 'F19950',
        'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982', 'F19988', 'F1999'
    }

    ICD9CM = {
        '2910', '2911', '2912', '2913', '2914', '2915', '29181', '29182', '29189', '2919', '2920',
        '29211', '29212', '2922', '29281', '29282', '29283', '29284', '29285', '29289', '2929',
        '30300', '30301', '30302', '30303', '30390', '30391', '30392', '30393', '30400', '30401',
        '30402', '30403', '30410', '30411', '30412', '30413', '30420', '30421', '30422', '30423',
        '30430', '30431', '30432', '30433', '30440', '30441', '30442', '30443', '30450', '30451',
        '30452', '30453', '30460', '30461', '30462', '30463', '30470', '30471', '30472', '30473',
        '30480', '30481', '30482', '30483', '30490', '30491', '30492', '30493', '30500', '30501',
        '30502', '30503', '30520', '30521', '30522', '30523', '30530', '30531', '30532', '30533',
        '30540', '30541', '30542', '30543', '30550', '30551', '30552', '30553', '30560', '30561',
        '30562', '30563', '30570', '30571', '30572', '30573', '30580', '30581', '30582', '30583',
        '30590', '30591', '30592', '30593', '53530', '53531', '5711'
    }

    SNOMEDCT = {
        '1081000119105', '110281001', '144981000119109', '145101000119102', '145841000119107',
        '1461000119109', '1471000119103', '15167005', '153501000119105', '191882002', '191883007',
        '191884001', '191891003', '191893000', '191894006', '191895007', '191899001', '191900006',
        '191901005', '191905001', '191906000', '191907009', '191909007', '191912005', '191913000',
        '191914006', '191916008', '191918009', '191919001', '191920007', '191924003', '191925002',
        '191928000', '191930003', '191931004', '191932006', '191934007', '191936009', '191937000',
        '191938005', '231458000', '231459008', '231461004', '231462006', '248119008', '26416006',
        '268645007', '268646008', '268647004', '268648009', '280982009', '280983004', '280984005',
        '280985006', '280986007', '284591009', '288281000119100', '304605000', '34111000119108',
        '37344009', '414874007', '425533007', '425885002', '426095000', '426590003', '427205009',
        '427229002', '428561000124100', '429001000124103', '429692000', '441527004', '445273005',
        '49540005', '5602001', '64386003', '6525002', '66214007', '70340006', '7071007',
        '74851005', '78267003', '84758004', '91388009', '9769006'
    }


class AlcoholAndDrugDependenceTreatment(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1005'
    VALUE_SET_NAME = 'Alcohol and Drug Dependence Treatment'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '171047005', '23915005', '24165007', '266707007', '310653000', '313071005', '370881007',
        '370884004', '385989002', '386448003', '386449006', '386450006', '386451005', '408933008',
        '408934002', '408935001', '408936000', '408941008', '408942001', '408943006', '408944000',
        '408945004', '408947007', '408948002', '410419007', '413473000', '423416000', '424148004',
        '424407005', '424589009', '426928008', '429291000124102', '56876005', '60112009'
    }


class MalignantNeoplasmOfColon(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1001'
    VALUE_SET_NAME = 'Malignant Neoplasm of Colon'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'C180', 'C181', 'C182', 'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19',
        'C20', 'C210', 'C211', 'C212', 'C218', 'C785'
    }

    ICD9CM = {
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1542', '1543', '1548', '1975'
    }

    SNOMEDCT = {
        '109838007', '123721000119108', '1701000119104', '187757001', '187758006', '269533000',
        '269544008', '285312008', '285611007', '301756000', '312111009', '312112002', '312113007',
        '312114001', '312115000', '314965007', '315058005', '363406005', '363407001', '363408006',
        '363409003', '363410008', '363412000', '363413005', '363414004', '363510005', '425178004',
        '449218003', '93683002', '93761005', '93771007', '93826009', '93980002', '94006002',
        '94072004', '94105000', '94179005', '94260004', '94271003', '94328005', '94509004',
        '94538001', '94604000', '94643001'
    }


class MalignantNeoplasmOfLymphaticAndHematopoieticTissue(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1009'
    VALUE_SET_NAME = 'Malignant Neoplasm of Lymphatic and Hematopoietic Tissue'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'C8100', 'C8101', 'C8102', 'C8103', 'C8104', 'C8105', 'C8106', 'C8107', 'C8108', 'C8109',
        'C8110', 'C8111', 'C8112', 'C8113', 'C8114', 'C8115', 'C8116', 'C8117', 'C8118', 'C8119',
        'C8120', 'C8121', 'C8122', 'C8123', 'C8124', 'C8125', 'C8126', 'C8127', 'C8128', 'C8129',
        'C8130', 'C8131', 'C8132', 'C8133', 'C8134', 'C8135', 'C8136', 'C8137', 'C8138', 'C8139',
        'C8140', 'C8141', 'C8142', 'C8143', 'C8144', 'C8145', 'C8146', 'C8147', 'C8148', 'C8149',
        'C8170', 'C8171', 'C8172', 'C8173', 'C8174', 'C8175', 'C8176', 'C8177', 'C8178', 'C8179',
        'C8190', 'C8191', 'C8192', 'C8193', 'C8194', 'C8195', 'C8196', 'C8197', 'C8198', 'C8199',
        'C8200', 'C8201', 'C8202', 'C8203', 'C8204', 'C8205', 'C8206', 'C8207', 'C8208', 'C8209',
        'C8210', 'C8211', 'C8212', 'C8213', 'C8214', 'C8215', 'C8216', 'C8217', 'C8218', 'C8219',
        'C8220', 'C8221', 'C8222', 'C8223', 'C8224', 'C8225', 'C8226', 'C8227', 'C8228', 'C8229',
        'C8230', 'C8231', 'C8232', 'C8233', 'C8234', 'C8235', 'C8236', 'C8237', 'C8238', 'C8239',
        'C8240', 'C8241', 'C8242', 'C8243', 'C8244', 'C8245', 'C8246', 'C8247', 'C8248', 'C8249',
        'C8250', 'C8251', 'C8252', 'C8253', 'C8254', 'C8255', 'C8256', 'C8257', 'C8258', 'C8259',
        'C8260', 'C8261', 'C8262', 'C8263', 'C8264', 'C8265', 'C8266', 'C8267', 'C8268', 'C8269',
        'C8280', 'C8281', 'C8282', 'C8283', 'C8284', 'C8285', 'C8286', 'C8287', 'C8288', 'C8289',
        'C8290', 'C8291', 'C8292', 'C8293', 'C8294', 'C8295', 'C8296', 'C8297', 'C8298', 'C8299',
        'C8300', 'C8301', 'C8302', 'C8303', 'C8304', 'C8305', 'C8306', 'C8307', 'C8308', 'C8309',
        'C8310', 'C8311', 'C8312', 'C8313', 'C8314', 'C8315', 'C8316', 'C8317', 'C8318', 'C8319',
        'C8330', 'C8331', 'C8332', 'C8333', 'C8334', 'C8335', 'C8336', 'C8337', 'C8338', 'C8339',
        'C8350', 'C8351', 'C8352', 'C8353', 'C8354', 'C8355', 'C8356', 'C8357', 'C8358', 'C8359',
        'C8370', 'C8371', 'C8372', 'C8373', 'C8374', 'C8375', 'C8376', 'C8377', 'C8378', 'C8379',
        'C8380', 'C8381', 'C8382', 'C8383', 'C8384', 'C8385', 'C8386', 'C8387', 'C8388', 'C8389',
        'C8390', 'C8391', 'C8392', 'C8393', 'C8394', 'C8395', 'C8396', 'C8397', 'C8398', 'C8399',
        'C8400', 'C8401', 'C8402', 'C8403', 'C8404', 'C8405', 'C8406', 'C8407', 'C8408', 'C8409',
        'C8410', 'C8411', 'C8412', 'C8413', 'C8414', 'C8415', 'C8416', 'C8417', 'C8418', 'C8419',
        'C8440', 'C8441', 'C8442', 'C8443', 'C8444', 'C8445', 'C8446', 'C8447', 'C8448', 'C8449',
        'C8460', 'C8461', 'C8462', 'C8463', 'C8464', 'C8465', 'C8466', 'C8467', 'C8468', 'C8469',
        'C8470', 'C8471', 'C8472', 'C8473', 'C8474', 'C8475', 'C8476', 'C8477', 'C8478', 'C8479',
        'C8490', 'C8491', 'C8492', 'C8493', 'C8494', 'C8495', 'C8496', 'C8497', 'C8498', 'C8499',
        'C84A0', 'C84A1', 'C84A2', 'C84A3', 'C84A4', 'C84A5', 'C84A6', 'C84A7', 'C84A8', 'C84A9',
        'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3', 'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7', 'C84Z8', 'C84Z9',
        'C8510', 'C8511', 'C8512', 'C8513', 'C8514', 'C8515', 'C8516', 'C8517', 'C8518', 'C8519',
        'C8520', 'C8521', 'C8522', 'C8523', 'C8524', 'C8525', 'C8526', 'C8527', 'C8528', 'C8529',
        'C8580', 'C8581', 'C8582', 'C8583', 'C8584', 'C8585', 'C8586', 'C8587', 'C8588', 'C8589',
        'C8590', 'C8591', 'C8592', 'C8593', 'C8594', 'C8595', 'C8596', 'C8597', 'C8598', 'C8599',
        'C860', 'C861', 'C862', 'C863', 'C864', 'C865', 'C866', 'C882', 'C883', 'C884', 'C888',
        'C889', 'C9000', 'C9001', 'C9002', 'C9010', 'C9011', 'C9012', 'C9020', 'C9021', 'C9022',
        'C9030', 'C9031', 'C9032', 'C9100', 'C9101', 'C9102', 'C9110', 'C9111', 'C9112', 'C9130',
        'C9131', 'C9132', 'C9140', 'C9141', 'C9142', 'C9150', 'C9151', 'C9152', 'C9160', 'C9161',
        'C9162', 'C9190', 'C9191', 'C9192', 'C91A0', 'C91A1', 'C91A2', 'C91Z0', 'C91Z1', 'C91Z2',
        'C9200', 'C9201', 'C9202', 'C9210', 'C9211', 'C9212', 'C9220', 'C9221', 'C9222', 'C9230',
        'C9231', 'C9232', 'C9240', 'C9241', 'C9242', 'C9250', 'C9251', 'C9252', 'C9260', 'C9261',
        'C9262', 'C9290', 'C9291', 'C9292', 'C92A0', 'C92A1', 'C92A2', 'C92Z0', 'C92Z1', 'C92Z2',
        'C9300', 'C9301', 'C9302', 'C9310', 'C9311', 'C9312', 'C9330', 'C9331', 'C9332', 'C9390',
        'C9391', 'C9392', 'C93Z0', 'C93Z1', 'C9400', 'C9401', 'C9402', 'C9420', 'C9421', 'C9422',
        'C9430', 'C9431', 'C9432', 'C9500', 'C9501', 'C9502', 'C9510', 'C9511', 'C9512', 'C9590',
        'C9591', 'C9592', 'C960', 'C962', 'C964', 'C969', 'C96A', 'C96Z'
    }

    ICD9CM = {
        '20000', '20001', '20002', '20003', '20004', '20005', '20006', '20007', '20008', '20010',
        '20011', '20012', '20013', '20014', '20015', '20016', '20017', '20018', '20020', '20021',
        '20022', '20023', '20024', '20025', '20026', '20027', '20028', '20030', '20031', '20032',
        '20033', '20034', '20035', '20036', '20037', '20038', '20040', '20041', '20042', '20043',
        '20044', '20045', '20046', '20047', '20048', '20050', '20051', '20052', '20053', '20054',
        '20055', '20056', '20057', '20058', '20060', '20061', '20062', '20063', '20064', '20065',
        '20066', '20067', '20068', '20070', '20071', '20072', '20073', '20074', '20075', '20076',
        '20077', '20078', '20080', '20081', '20082', '20083', '20084', '20085', '20086', '20087',
        '20088', '20100', '20101', '20102', '20103', '20104', '20105', '20106', '20107', '20108',
        '20110', '20111', '20112', '20113', '20114', '20115', '20116', '20117', '20118', '20120',
        '20121', '20122', '20123', '20124', '20125', '20126', '20127', '20128', '20140', '20141',
        '20142', '20143', '20144', '20145', '20146', '20147', '20148', '20150', '20151', '20152',
        '20153', '20154', '20155', '20156', '20157', '20158', '20160', '20161', '20162', '20163',
        '20164', '20165', '20166', '20167', '20168', '20170', '20171', '20172', '20173', '20174',
        '20175', '20176', '20177', '20178', '20190', '20191', '20192', '20193', '20194', '20195',
        '20196', '20197', '20198', '20200', '20201', '20202', '20203', '20204', '20205', '20206',
        '20207', '20208', '20210', '20211', '20212', '20213', '20214', '20215', '20216', '20217',
        '20218', '20220', '20221', '20222', '20223', '20224', '20225', '20226', '20227', '20228',
        '20230', '20231', '20232', '20233', '20234', '20235', '20236', '20237', '20238', '20240',
        '20241', '20242', '20243', '20244', '20245', '20246', '20247', '20248', '20250', '20251',
        '20252', '20253', '20254', '20255', '20256', '20257', '20258', '20260', '20261', '20262',
        '20263', '20264', '20265', '20266', '20267', '20268', '20270', '20271', '20272', '20273',
        '20274', '20275', '20276', '20277', '20278', '20280', '20281', '20282', '20283', '20284',
        '20285', '20286', '20287', '20288', '20290', '20291', '20292', '20293', '20294', '20295',
        '20296', '20297', '20298', '20300', '20301', '20302', '20310', '20311', '20312', '20380',
        '20381', '20382', '20400', '20401', '20410', '20411', '20420', '20421', '20480', '20481',
        '20490', '20491', '20500', '20501', '20510', '20511', '20520', '20521', '20530', '20531',
        '20580', '20581', '20590', '20591', '20600', '20601', '20610', '20611', '20620', '20621',
        '20680', '20681', '20690', '20691', '20700', '20701', '20710', '20711', '20720', '20721',
        '20780', '20781', '20800', '20801', '20810', '20811', '20820', '20821', '20880', '20881',
        '20890'
    }

    SNOMEDCT = {
        '109391009', '109962001', '109964000', '109965004', '109966003', '109967007', '109968002',
        '109969005', '109970006', '109971005', '109972003', '109975001', '109976000', '109977009',
        '109978004', '109979007', '109980005', '109988003', '109989006', '110002002', '110004001',
        '110005000', '110006004', '110007008', '118599009', '118600007', '118601006', '118602004',
        '118605002', '118606001', '118607005', '118608000', '118609008', '118610003', '118611004',
        '118612006', '118613001', '118614007', '118615008', '118618005', '127070008', '127213008',
        '127214002', '127220001', '127225006', '128874001', '128875000', '129000002', '187822008',
        '188487008', '188489006', '188492005', '188493000', '188498009', '188500005', '188501009',
        '188502002', '188503007', '188504001', '188505000', '188506004', '188507008', '188510001',
        '188511002', '188512009', '188513004', '188514005', '188515006', '188516007', '188517003',
        '188524002', '188526000', '188529007', '188531003', '188534006', '188536008', '188537004',
        '188538009', '188541000', '188544008', '188547001', '188548006', '188551004', '188554007',
        '188558005', '188559002', '188562004', '188565002', '188566001', '188567005', '188568000',
        '188569008', '188570009', '188572001', '188575004', '188576003', '188577007', '188578002',
        '188579005', '188580008', '188582000', '188585003', '188586002', '188587006', '188589009',
        '188590000', '188591001', '188592008', '188593003', '188609000', '188612002', '188613007',
        '188627002', '188630009', '188631008', '188632001', '188633006', '188634000', '188635004',
        '188637007', '188640007', '188641006', '188642004', '188645002', '188648000', '188649008',
        '188651007', '188660004', '188662007', '188663002', '188664008', '188665009', '188666005',
        '188667001', '188668006', '188669003', '188718006', '188725004', '188726003', '188728002',
        '188729005', '188732008', '188733003', '188734009', '188736006', '188737002', '188738007',
        '188741003', '188744006', '188745007', '188746008', '188748009', '188754005', '188768003',
        '188770007', '189509003', '190030009', '190955000', '232075002', '236512004', '236513009',
        '239147000', '254792006', '255101006', '269475001', '269476000', '276815004', '276836002',
        '277473004', '277474005', '277545003', '277549009', '277550009', '277551008', '277567002',
        '277568007', '277569004', '277570003', '277571004', '277572006', '277573001', '277574007',
        '277575008', '277577000', '277580004', '277587001', '277589003', '277597005', '277601005',
        '277602003', '277604002', '277606000', '277609007', '277610002', '277611003', '277612005',
        '277613000', '277614006', '277615007', '277616008', '277617004', '277618009', '277619001',
        '277626001', '277627005', '277637000', '277642008', '277643003', '277651000', '277653002',
        '277654008', '277664004', '278051002', '278052009', '278189009', '278453007', '285420006',
        '285421005', '285422003', '285423008', '285424002', '285426000', '285428004', '285769009',
        '285776004', '285839005', '302841002', '302855005', '302856006', '303017006', '303055001',
        '303056000', '303057009', '307340003', '307341004', '307592006', '307617006', '307622006',
        '307633009', '307634003', '307635002', '307650006', '307651005', '308121000', '313427003',
        '359631009', '359640008', '359648001', '371012000', '371134001', '373168002', '397008008',
        '397009000', '397011009', '397013007', '397015000', '398623004', '400001003', '400122007',
        '402880009', '402881008', '402882001', '404106004', '404107008', '404108003', '404109006',
        '404110001', '404111002', '404112009', '404113004', '404114005', '404115006', '404116007',
        '404117003', '404118008', '404119000', '404121005', '404122003', '404123008', '404124002',
        '404127009', '404128004', '404129007', '404132005', '404133000', '404134006', '404135007',
        '404136008', '404137004', '404138009', '404139001', '404140004', '404142007', '404143002',
        '404144008', '404147001', '404148006', '404149003', '404150003', '404151004', '404152006',
        '404153001', '404154007', '404155008', '404157000', '404160007', '404169008', '413389003',
        '413441006', '413442004', '413537009', '413587002', '413656006', '413842007', '413843002',
        '413847001', '414166008', '414780005', '414785000', '414791003', '414825006', '415110002',
        '415112005', '415285009', '415286005', '415287001', '420302007', '420519005', '420788006',
        '420890002', '421246008', '421283008', '421418009', '421696004', '421835000', '422052002',
        '422172005', '422853008', '423294001', '425657001', '425688002', '425749006', '425869007',
        '425941003', '426071002', '426124006', '426217000', '426248008', '426336007', '426370008',
        '426642002', '426885008', '427056005', '427141003', '427642009', '427658007', '430338009',
        '440422002', '441313008', '441559006', '441962003', '442537007', '443487006', '444597005',
        '444910004', '444911000', '445105005', '445227008', '445269007', '445406001', '445448008',
        '445738007', '446643000', '447100004', '447596005', '447656001', '447658000', '447766003',
        '447805007', '447806008', '447989004', '448212009', '448213004', '448217003', '448220006',
        '448231003', '448254007', '448269008', '448317000', '448319002', '448354009', '448371005',
        '448372003', '448376000', '448384001', '448386004', '448387008', '448447004', '448465000',
        '448468003', '448560008', '448561007', '448607004', '448609001', '448663003', '448666006',
        '448672006', '448709005', '448738008', '448774004', '448865007', '448867004', '448995000',
        '449058008', '449059000', '449063007', '449065000', '449108003', '449173006', '449176003',
        '449177007', '449216004', '449217008', '449219006', '449220000', '449221001', '449222008',
        '449292003', '449307001', '449318001', '449386007', '449418000', '449419008', '91855006',
        '91856007', '91857003', '91858008', '91860005', '91861009', '92508006', '92509003',
        '92510008', '92511007', '92512000', '92513005', '92515003', '92516002', '92811003',
        '92812005', '92813000', '92814006', '92818009', '93133006', '93134000', '93135004',
        '93136003', '93137007', '93138002', '93139005', '93140007', '93141006', '93143009',
        '93144003', '93145002', '93146001', '93147005', '93148000', '93149008', '93151007',
        '93152000', '93169003', '93182006', '93183001', '93184007', '93185008', '93186009',
        '93187000', '93188005', '93189002', '93190006', '93191005', '93192003', '93193008',
        '93194002', '93195001', '93196000', '93197009', '93198004', '93199007', '93200005',
        '93201009', '93202002', '93203007', '93204001', '93205000', '93206004', '93207008',
        '93208003', '93451002', '93487009', '93488004', '93489007', '93492006', '93493001',
        '93494007', '93495008', '93496009', '93497000', '93498005', '93500006', '93501005',
        '93505001', '93506000', '93507009', '93509007', '93510002', '93514006', '93515007',
        '93516008', '93518009', '93519001', '93520007', '93521006', '93522004', '93523009',
        '93524003', '93525002', '93526001', '93527005', '93528000', '93530003', '93531004',
        '93532006', '93533001', '93534007', '93536009', '93537000', '93541001', '93542008',
        '93543003', '93545005', '93546006', '93547002', '93548007', '93549004', '93550004',
        '93551000', '93552007', '93554008', '93555009', '93720005', '94071006', '94148006',
        '94686001', '94687005', '94688000', '94690004', '94707004', '94708009', '94709001',
        '94710006', '94711005', '94712003', '94714002', '94715001', '94716000', '94718004',
        '94719007', '95186006', '95187002', '95188007', '95192000', '95193005', '95194004',
        '95209008', '95210003', '95224004', '95225003', '95226002', '95230004', '95231000',
        '95260009', '95261008', '95263006', '95264000'
    }


class AllCancer(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1011'
    VALUE_SET_NAME = 'All Cancer'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'C000', 'C001', 'C002', 'C003', 'C004', 'C005', 'C006', 'C008', 'C009', 'C01', 'C020',
        'C021', 'C022', 'C023', 'C024', 'C028', 'C029', 'C030', 'C031', 'C039', 'C040', 'C041',
        'C048', 'C049', 'C050', 'C051', 'C052', 'C058', 'C059', 'C060', 'C061', 'C062', 'C0680',
        'C0689', 'C069', 'C07', 'C080', 'C081', 'C089', 'C090', 'C091', 'C098', 'C099', 'C100',
        'C101', 'C102', 'C103', 'C104', 'C108', 'C109', 'C110', 'C111', 'C112', 'C113', 'C118',
        'C119', 'C12', 'C130', 'C131', 'C132', 'C138', 'C139', 'C140', 'C142', 'C148', 'C153',
        'C154', 'C155', 'C158', 'C159', 'C160', 'C161', 'C162', 'C163', 'C164', 'C165', 'C166',
        'C168', 'C169', 'C170', 'C171', 'C172', 'C173', 'C178', 'C179', 'C180', 'C181', 'C182',
        'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19', 'C20', 'C210', 'C211',
        'C212', 'C218', 'C300', 'C301', 'C310', 'C311', 'C312', 'C313', 'C318', 'C319', 'C320',
        'C321', 'C322', 'C323', 'C328', 'C329', 'C33', 'C3400', 'C3401', 'C3402', 'C3410', 'C3411',
        'C3412', 'C342', 'C3430', 'C3431', 'C3432', 'C3480', 'C3481', 'C3482', 'C3490', 'C3491',
        'C3492', 'C37', 'C380', 'C381', 'C382', 'C383', 'C384', 'C388', 'C4000', 'C4001', 'C4002',
        'C4010', 'C4011', 'C4012', 'C4020', 'C4021', 'C4022', 'C4030', 'C4031', 'C4032', 'C4080',
        'C4081', 'C4082', 'C4090', 'C4091', 'C4092', 'C410', 'C411', 'C412', 'C413', 'C414',
        'C419', 'C430', 'C4310', 'C4311', 'C4312', 'C4320', 'C4321', 'C4322', 'C4330', 'C4331',
        'C4339', 'C434', 'C4351', 'C4352', 'C4359', 'C4360', 'C4361', 'C4362', 'C4370', 'C4371',
        'C4372', 'C438', 'C439', 'C450', 'C452', 'C457', 'C470', 'C4710', 'C4711', 'C4712',
        'C4720', 'C4721', 'C4722', 'C473', 'C474', 'C475', 'C476', 'C478', 'C479', 'C490', 'C4910',
        'C4911', 'C4912', 'C4920', 'C4921', 'C4922', 'C493', 'C494', 'C495', 'C496', 'C498',
        'C499', 'C49A0', 'C49A1', 'C49A2', 'C49A3', 'C49A4', 'C49A5', 'C49A9', 'C50011', 'C50012',
        'C50019', 'C50111', 'C50112', 'C50119', 'C50211', 'C50212', 'C50219', 'C50311', 'C50312',
        'C50319', 'C50411', 'C50412', 'C50419', 'C50511', 'C50512', 'C50519', 'C50611', 'C50612',
        'C50619', 'C50811', 'C50812', 'C50819', 'C50911', 'C50912', 'C50919', 'C510', 'C511',
        'C512', 'C518', 'C519', 'C52', 'C530', 'C531', 'C538', 'C539', 'C540', 'C541', 'C542',
        'C543', 'C549', 'C561', 'C562', 'C569', 'C5700', 'C5701', 'C5702', 'C5710', 'C5711',
        'C5712', 'C5720', 'C5721', 'C5722', 'C573', 'C574', 'C577', 'C578', 'C579', 'C58', 'C600',
        'C601', 'C602', 'C608', 'C609', 'C61', 'C6200', 'C6201', 'C6202', 'C6210', 'C6211',
        'C6212', 'C6290', 'C6291', 'C6300', 'C6301', 'C6302', 'C6310', 'C6311', 'C6312', 'C632',
        'C637', 'C638', 'C639', 'C641', 'C642', 'C649', 'C651', 'C652', 'C659', 'C670', 'C671',
        'C672', 'C673', 'C674', 'C675', 'C676', 'C677', 'C678', 'C679', 'C680', 'C681', 'C688',
        'C689', 'C6900', 'C6901', 'C6902', 'C6910', 'C6911', 'C6912', 'C6920', 'C6921', 'C6922',
        'C6930', 'C6931', 'C6932', 'C6940', 'C6941', 'C6942', 'C6950', 'C6951', 'C6952', 'C6960',
        'C6961', 'C6962', 'C6980', 'C6981', 'C6982', 'C700', 'C701', 'C709', 'C710', 'C711',
        'C712', 'C713', 'C714', 'C715', 'C716', 'C717', 'C718', 'C719', 'C720', 'C721', 'C7220',
        'C7221', 'C7222', 'C7230', 'C7231', 'C7232', 'C7240', 'C7241', 'C7242', 'C7250', 'C7259',
        'C729', 'C7400', 'C7401', 'C7402', 'C7410', 'C7411', 'C7412', 'C7490', 'C7491', 'C7492',
        'C750', 'C751', 'C752', 'C753', 'C754', 'C755', 'C758', 'C759', 'C760', 'C761', 'C762',
        'C763', 'C7640', 'C7641', 'C7642', 'C7650', 'C7651', 'C7652', 'C768', 'C770', 'C771',
        'C772', 'C773', 'C774', 'C775', 'C778', 'C779', 'C785', 'C8100', 'C8101', 'C8102', 'C8103',
        'C8104', 'C8105', 'C8106', 'C8107', 'C8108', 'C8109', 'C8110', 'C8111', 'C8112', 'C8113',
        'C8114', 'C8115', 'C8116', 'C8117', 'C8118', 'C8119', 'C8120', 'C8121', 'C8122', 'C8123',
        'C8124', 'C8125', 'C8126', 'C8127', 'C8128', 'C8129', 'C8130', 'C8131', 'C8132', 'C8133',
        'C8134', 'C8135', 'C8136', 'C8137', 'C8138', 'C8139', 'C8140', 'C8141', 'C8142', 'C8143',
        'C8144', 'C8145', 'C8146', 'C8147', 'C8148', 'C8149', 'C8170', 'C8171', 'C8172', 'C8173',
        'C8174', 'C8175', 'C8176', 'C8177', 'C8178', 'C8179', 'C8190', 'C8191', 'C8192', 'C8193',
        'C8194', 'C8195', 'C8196', 'C8197', 'C8198', 'C8199', 'C8200', 'C8201', 'C8202', 'C8203',
        'C8204', 'C8205', 'C8206', 'C8207', 'C8208', 'C8209', 'C8210', 'C8211', 'C8212', 'C8213',
        'C8214', 'C8215', 'C8216', 'C8217', 'C8218', 'C8219', 'C8220', 'C8221', 'C8222', 'C8223',
        'C8224', 'C8225', 'C8226', 'C8227', 'C8228', 'C8229', 'C8230', 'C8231', 'C8232', 'C8233',
        'C8234', 'C8235', 'C8236', 'C8237', 'C8238', 'C8239', 'C8240', 'C8241', 'C8242', 'C8243',
        'C8244', 'C8245', 'C8246', 'C8247', 'C8248', 'C8249', 'C8250', 'C8251', 'C8252', 'C8253',
        'C8254', 'C8255', 'C8256', 'C8257', 'C8258', 'C8259', 'C8260', 'C8261', 'C8262', 'C8263',
        'C8264', 'C8265', 'C8266', 'C8267', 'C8268', 'C8269', 'C8280', 'C8281', 'C8282', 'C8283',
        'C8284', 'C8285', 'C8286', 'C8287', 'C8288', 'C8289', 'C8290', 'C8291', 'C8292', 'C8293',
        'C8294', 'C8295', 'C8296', 'C8297', 'C8298', 'C8299', 'C8300', 'C8301', 'C8302', 'C8303',
        'C8304', 'C8305', 'C8306', 'C8307', 'C8308', 'C8309', 'C8310', 'C8311', 'C8312', 'C8313',
        'C8314', 'C8315', 'C8316', 'C8317', 'C8318', 'C8319', 'C8330', 'C8331', 'C8332', 'C8333',
        'C8334', 'C8335', 'C8336', 'C8337', 'C8338', 'C8339', 'C8350', 'C8351', 'C8352', 'C8353',
        'C8354', 'C8355', 'C8356', 'C8357', 'C8358', 'C8359', 'C8370', 'C8371', 'C8372', 'C8373',
        'C8374', 'C8375', 'C8376', 'C8377', 'C8378', 'C8379', 'C8380', 'C8381', 'C8382', 'C8383',
        'C8384', 'C8385', 'C8386', 'C8387', 'C8388', 'C8389', 'C8390', 'C8391', 'C8392', 'C8393',
        'C8394', 'C8395', 'C8396', 'C8397', 'C8398', 'C8399', 'C8400', 'C8401', 'C8402', 'C8403',
        'C8404', 'C8405', 'C8406', 'C8407', 'C8408', 'C8409', 'C8410', 'C8411', 'C8412', 'C8413',
        'C8414', 'C8415', 'C8416', 'C8417', 'C8418', 'C8419', 'C8440', 'C8441', 'C8442', 'C8443',
        'C8444', 'C8445', 'C8446', 'C8447', 'C8448', 'C8449', 'C8460', 'C8461', 'C8462', 'C8463',
        'C8464', 'C8465', 'C8466', 'C8467', 'C8468', 'C8469', 'C8470', 'C8471', 'C8472', 'C8473',
        'C8474', 'C8475', 'C8476', 'C8477', 'C8478', 'C8479', 'C8490', 'C8491', 'C8492', 'C8493',
        'C8494', 'C8495', 'C8496', 'C8497', 'C8498', 'C8499', 'C84A0', 'C84A1', 'C84A2', 'C84A3',
        'C84A4', 'C84A5', 'C84A6', 'C84A7', 'C84A8', 'C84A9', 'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3',
        'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7', 'C84Z8', 'C84Z9', 'C8510', 'C8511', 'C8512', 'C8513',
        'C8514', 'C8515', 'C8516', 'C8517', 'C8518', 'C8519', 'C8520', 'C8521', 'C8522', 'C8523',
        'C8524', 'C8525', 'C8526', 'C8527', 'C8528', 'C8529', 'C8580', 'C8581', 'C8582', 'C8583',
        'C8584', 'C8585', 'C8586', 'C8587', 'C8588', 'C8589', 'C8590', 'C8591', 'C8592', 'C8593',
        'C8594', 'C8595', 'C8596', 'C8597', 'C8598', 'C8599', 'C860', 'C861', 'C862', 'C863',
        'C864', 'C865', 'C866', 'C882', 'C883', 'C884', 'C888', 'C889', 'C9000', 'C9001', 'C9002',
        'C9010', 'C9011', 'C9012', 'C9020', 'C9021', 'C9022', 'C9030', 'C9031', 'C9032', 'C9100',
        'C9101', 'C9102', 'C9110', 'C9111', 'C9112', 'C9130', 'C9131', 'C9132', 'C9140', 'C9141',
        'C9142', 'C9150', 'C9151', 'C9152', 'C9160', 'C9161', 'C9162', 'C9190', 'C9191', 'C9192',
        'C91A0', 'C91A1', 'C91A2', 'C91Z0', 'C91Z1', 'C91Z2', 'C9200', 'C9201', 'C9202', 'C9210',
        'C9211', 'C9212', 'C9220', 'C9221', 'C9222', 'C9230', 'C9231', 'C9232', 'C9240', 'C9241',
        'C9242', 'C9250', 'C9251', 'C9252', 'C9260', 'C9261', 'C9262', 'C9290', 'C9291', 'C9292',
        'C92A0', 'C92A1', 'C92A2', 'C92Z0', 'C92Z1', 'C92Z2', 'C9300', 'C9301', 'C9302', 'C9310',
        'C9311', 'C9312', 'C9330', 'C9331', 'C9332', 'C9390', 'C9391', 'C9392', 'C93Z0', 'C93Z1',
        'C9400', 'C9401', 'C9402', 'C9420', 'C9421', 'C9422', 'C9430', 'C9431', 'C9432', 'C9440',
        'C9441', 'C9442', 'C946', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501', 'C9502', 'C9510',
        'C9511', 'C9512', 'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C964', 'C969', 'C96A',
        'C96Z', 'D030', 'D0310', 'D0311', 'D0312', 'D0320', 'D0321', 'D0322', 'D0330', 'D0339',
        'D034', 'D0351', 'D0352', 'D0359', 'D0360', 'D0361', 'D0362', 'D0370', 'D0371', 'D0372',
        'D038', 'D039', 'D47Z2', 'D49511', 'D49512', 'D49519', 'D4959'
    }

    ICD9CM = {
        '1410', '1411', '1412', '1413', '1414', '1415', '1416', '1418', '1419', '1420', '1421',
        '1422', '1428', '1429', '1430', '1431', '1438', '1439', '1440', '1441', '1448', '1449',
        '1450', '1451', '1452', '1453', '1454', '1455', '1456', '1458', '1459', '1460', '1461',
        '1462', '1463', '1464', '1465', '1466', '1467', '1468', '1469', '1470', '1471', '1472',
        '1473', '1478', '1479', '1480', '1481', '1482', '1483', '1488', '1489', '1490', '1491',
        '1498', '1499', '1500', '1501', '1502', '1503', '1504', '1505', '1508', '1509', '1510',
        '1511', '1512', '1513', '1514', '1515', '1516', '1518', '1519', '1520', '1521', '1522',
        '1523', '1528', '1529', '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537',
        '1538', '1539', '1540', '1541', '1542', '1543', '1548', '1600', '1601', '1602', '1603',
        '1604', '1605', '1608', '1609', '1610', '1611', '1612', '1613', '1618', '1619', '1620',
        '1622', '1623', '1624', '1625', '1628', '1629', '1630', '1631', '1638', '1639', '1640',
        '1641', '1642', '1643', '1648', '1649', '1700', '1701', '1702', '1703', '1704', '1705',
        '1706', '1707', '1708', '1709', '1710', '1712', '1713', '1714', '1715', '1716', '1717',
        '1718', '1719', '1720', '1721', '1722', '1723', '1724', '1725', '1726', '1727', '1728',
        '1729', '1740', '1741', '1742', '1743', '1744', '1745', '1746', '1748', '1749', '1800',
        '1801', '1808', '1809', '181', '1820', '1821', '1828', '1830', '1832', '1833', '1834',
        '1835', '1838', '1839', '1840', '1841', '1842', '1843', '1844', '1848', '1849', '185',
        '1860', '1869', '1871', '1872', '1873', '1874', '1875', '1876', '1877', '1878', '1879',
        '1880', '1881', '1882', '1883', '1884', '1885', '1886', '1887', '1888', '1889', '1890',
        '1891', '1892', '1893', '1894', '1898', '1900', '1901', '1902', '1903', '1904', '1905',
        '1906', '1907', '1908', '1909', '1910', '1911', '1912', '1913', '1914', '1915', '1916',
        '1917', '1918', '1919', '1920', '1921', '1922', '1923', '1928', '1929', '1940', '1941',
        '1943', '1944', '1945', '1946', '1948', '1949', '1950', '1951', '1952', '1953', '1954',
        '1955', '1958', '1960', '1961', '1962', '1963', '1965', '1966', '1968', '1969', '1975',
        '20000', '20001', '20002', '20003', '20004', '20005', '20006', '20007', '20008', '20010',
        '20011', '20012', '20013', '20014', '20015', '20016', '20017', '20018', '20020', '20021',
        '20022', '20023', '20024', '20025', '20026', '20027', '20028', '20030', '20031', '20032',
        '20033', '20034', '20035', '20036', '20037', '20038', '20040', '20041', '20042', '20043',
        '20044', '20045', '20046', '20047', '20048', '20050', '20051', '20052', '20053', '20054',
        '20055', '20056', '20057', '20058', '20060', '20061', '20062', '20063', '20064', '20065',
        '20066', '20067', '20068', '20070', '20071', '20072', '20073', '20074', '20075', '20076',
        '20077', '20078', '20080', '20081', '20082', '20083', '20084', '20085', '20086', '20087',
        '20088', '20100', '20101', '20102', '20103', '20104', '20105', '20106', '20107', '20108',
        '20110', '20111', '20112', '20113', '20114', '20115', '20116', '20117', '20118', '20120',
        '20121', '20122', '20123', '20124', '20125', '20126', '20127', '20128', '20140', '20141',
        '20142', '20143', '20144', '20145', '20146', '20147', '20148', '20150', '20151', '20152',
        '20153', '20154', '20155', '20156', '20157', '20158', '20160', '20161', '20162', '20163',
        '20164', '20165', '20166', '20167', '20168', '20170', '20171', '20172', '20173', '20174',
        '20175', '20176', '20177', '20178', '20190', '20191', '20192', '20193', '20194', '20195',
        '20196', '20197', '20198', '20200', '20201', '20202', '20203', '20204', '20205', '20206',
        '20207', '20208', '20210', '20211', '20212', '20213', '20214', '20215', '20216', '20217',
        '20218', '20220', '20221', '20222', '20223', '20224', '20225', '20226', '20227', '20228',
        '20230', '20231', '20232', '20233', '20234', '20235', '20236', '20237', '20238', '20240',
        '20241', '20242', '20243', '20244', '20245', '20246', '20247', '20248', '20250', '20251',
        '20252', '20253', '20254', '20255', '20256', '20257', '20258', '20260', '20261', '20262',
        '20263', '20264', '20265', '20266', '20267', '20268', '20270', '20271', '20272', '20273',
        '20274', '20275', '20276', '20277', '20278', '20280', '20281', '20282', '20283', '20284',
        '20285', '20286', '20287', '20288', '20290', '20291', '20292', '20293', '20294', '20295',
        '20296', '20297', '20298', '20300', '20301', '20302', '20310', '20311', '20312', '20380',
        '20381', '20382', '20400', '20401', '20410', '20411', '20420', '20421', '20480', '20481',
        '20490', '20491', '20500', '20501', '20510', '20511', '20520', '20521', '20530', '20531',
        '20580', '20581', '20590', '20591', '20600', '20601', '20610', '20611', '20620', '20621',
        '20680', '20681', '20690', '20691', '20700', '20701', '20710', '20711', '20720', '20721',
        '20780', '20781', '20800', '20801', '20810', '20811', '20820', '20821', '20880', '20881',
        '20890'
    }

    SNOMEDCT = {
        '109267002', '109348004', '109350007', '109351006', '109365008', '109366009', '109367000',
        '109368005', '109369002', '109370001', '109371002', '109374005', '109383000', '109384006',
        '109388009', '109390005', '109391009', '109822001', '109823006', '109824000', '109828002',
        '109830000', '109831001', '109832008', '109835005', '109836006', '109838007', '109839004',
        '109840002', '109851002', '109853004', '109854005', '109855006', '109856007', '109857003',
        '109858008', '109870007', '109874003', '109875002', '109876001', '109878000', '109879008',
        '109880006', '109882003', '109886000', '109911004', '109912006', '109915008', '109941002',
        '109948008', '109951001', '109962001', '109964000', '109965004', '109966003', '109967007',
        '109968002', '109969005', '109970006', '109971005', '109972003', '109975001', '109976000',
        '109977009', '109978004', '109979007', '109980005', '109988003', '109989006', '110002002',
        '110004001', '110005000', '110006004', '110007008', '110013004', '118599009', '118600007',
        '118601006', '118602004', '118605002', '118606001', '118607005', '118608000', '118609008',
        '118610003', '118611004', '118612006', '118613001', '118614007', '118615008', '118618005',
        '123721000119108', '123842006', '126948004', '127070008', '127213008', '127214002',
        '127220001', '127225006', '128874001', '128875000', '129000002', '13048006', '134312002',
        '1701000119104', '187601000', '187604008', '187606005', '187608006', '187613005',
        '187614004', '187622006', '187624007', '187631006', '187634003', '187635002', '187637005',
        '187640005', '187641009', '187644001', '187652003', '187653008', '187658004', '187659007',
        '187660002', '187661003', '187662005', '187666008', '187675005', '187681002', '187682009',
        '187683004', '187685006', '187688008', '187692001', '187693006', '187694000', '187697007',
        '187698002', '187700006', '187701005', '187702003', '187708004', '187709007', '187716008',
        '187722004', '187723009', '187724003', '187725002', '187726001', '187727005', '187732006',
        '187733001', '187734007', '187736009', '187738005', '187740000', '187741001', '187742008',
        '187757001', '187758006', '187786003', '187794005', '187801002', '187803004', '187807003',
        '187808008', '187809000', '187810005', '187811009', '187814001', '187822008', '187829004',
        '187830009', '187831008', '187833006', '187834000', '187835004', '187836003', '187838002',
        '187841006', '187842004', '187843009', '187844003', '187845002', '187846001', '187853005',
        '187854004', '187857006', '187861000', '187862007', '187864008', '187865009', '187866005',
        '187868006', '187869003', '187870002', '187881004', '187900002', '187903000', '187906008',
        '187916000', '187917009', '187918004', '187920001', '187925006', '187926007', '187927003',
        '187929000', '187932002', '187937008', '187938003', '187939006', '187940008', '187941007',
        '187942000', '187943005', '187944004', '187945003', '187946002', '187947006', '187948001',
        '187949009', '187950009', '187952001', '187956003', '187957007', '187967002', '187968007',
        '187969004', '187970003', '187972006', '187973001', '187974007', '187975008', '187976009',
        '187977000', '187978005', '187988006', '188010006', '188013008', '188030005', '188033007',
        '188049009', '188071004', '188072006', '188095002', '188107002', '188147009', '188151006',
        '188152004', '188153009', '188154003', '188155002', '188156001', '188159008', '188176007',
        '188177003', '188180002', '188183000', '188184006', '188189001', '188190005', '188191009',
        '188192002', '188193007', '188195000', '188196004', '188198003', '188204000', '188209005',
        '188219004', '188220005', '188230001', '188234005', '188235006', '188239000', '188240003',
        '188241004', '188242006', '188243001', '188244007', '188245008', '188247000', '188250002',
        '188251003', '188252005', '188253000', '188256008', '188261005', '188263008', '188264002',
        '188265001', '188266000', '188268004', '188269007', '188272000', '188273005', '188274004',
        '188280007', '188281006', '188282004', '188283009', '188285002', '188286001', '188287005',
        '188289008', '188290004', '188292007', '188293002', '188295009', '188296005', '188297001',
        '188298006', '188301005', '188302003', '188308004', '188312005', '188313000', '188315007',
        '188317004', '188318009', '188319001', '188325002', '188339002', '188340000', '188361007',
        '188487008', '188489006', '188492005', '188493000', '188498009', '188500005', '188501009',
        '188502002', '188503007', '188504001', '188505000', '188506004', '188507008', '188510001',
        '188511002', '188512009', '188513004', '188514005', '188515006', '188516007', '188517003',
        '188524002', '188526000', '188529007', '188531003', '188534006', '188536008', '188537004',
        '188538009', '188541000', '188544008', '188547001', '188548006', '188551004', '188554007',
        '188558005', '188559002', '188562004', '188565002', '188566001', '188567005', '188568000',
        '188569008', '188570009', '188572001', '188575004', '188576003', '188577007', '188578002',
        '188579005', '188580008', '188582000', '188585003', '188586002', '188587006', '188589009',
        '188590000', '188591001', '188592008', '188593003', '188609000', '188612002', '188613007',
        '188627002', '188630009', '188631008', '188632001', '188633006', '188634000', '188635004',
        '188637007', '188640007', '188641006', '188642004', '188645002', '188648000', '188649008',
        '188651007', '188660004', '188662007', '188663002', '188664008', '188665009', '188666005',
        '188667001', '188668006', '188669003', '188718006', '188725004', '188726003', '188728002',
        '188729005', '188732008', '188733003', '188734009', '188736006', '188737002', '188738007',
        '188741003', '188744006', '188745007', '188746008', '188748009', '188754005', '188768003',
        '188770007', '189164002', '189397006', '189406008', '189509003', '190030009', '190955000',
        '22288000', '223003', '230156002', '231829006', '231830001', '231831002', '231832009',
        '231833004', '231834005', '231835006', '232075002', '233854003', '233855002', '235686008',
        '236512004', '236513009', '237719001', '237795006', '239132009', '239147000', '240163000',
        '241861008', '252991009', '253003009', '254389005', '254390001', '254393004', '254398008',
        '254402004', '254404003', '254408000', '254412006', '254417000', '254423005', '254424004',
        '254425003', '254427006', '254431000', '254434008', '254435009', '254437001', '254441002',
        '254445006', '254450000', '254454009', '254457002', '254459004', '254462001', '254465004',
        '254466003', '254478004', '254481009', '254484001', '254501009', '254503007', '254509006',
        '254513004', '254517003', '254520006', '254526000', '254530002', '254535007', '254539001',
        '254543002', '254547001', '254549003', '254551004', '254553001', '254555008', '254557000',
        '254559002', '254561006', '254563009', '254567005', '254570009', '254574000', '254586002',
        '254609000', '254611009', '254612002', '254613007', '254615000', '254619006', '254620000',
        '254621001', '254622008', '254625005', '254626006', '254627002', '254628007', '254629004',
        '254630009', '254631008', '254632001', '254633006', '254634000', '254635004', '254637007',
        '254638002', '254641006', '254643009', '254644003', '254645002', '254730000', '254731001',
        '254732008', '254733003', '254734009', '254792006', '254849005', '254850005', '254851009',
        '254852002', '254856004', '254860001', '254861002', '254863004', '254864005', '254866007',
        '254867003', '254868008', '254869000', '254870004', '254871000', '254872007', '254874008',
        '254876005', '254877001', '254878006', '254883003', '254886006', '254887002', '254888007',
        '254889004', '254893005', '254894004', '254900004', '254901000', '254904008', '254908006',
        '254909003', '254912000', '254915003', '254916002', '254917006', '254918001', '254919009',
        '254920003', '254921004', '254922006', '254923001', '254934003', '254936001', '254937005',
        '254938000', '254940005', '254941009', '254944001', '254945000', '254946004', '254947008',
        '254948003', '254950006', '254951005', '254953008', '254954002', '254955001', '254956000',
        '254957009', '254958004', '254959007', '254960002', '254961003', '254962005', '254963000',
        '254964006', '254965007', '254966008', '254968009', '254969001', '254972008', '254973003',
        '254974009', '254975005', '254976006', '254978007', '254979004', '254987003', '254988008',
        '254989000', '254990009', '254993006', '254994000', '254995004', '254996003', '254997007',
        '254998002', '254999005', '255000005', '255003007', '255004001', '255008003', '255012009',
        '255015006', '255016007', '255017003', '255021005', '255028004', '255029007', '255030002',
        '255031003', '255032005', '255034006', '255035007', '255037004', '255044008', '255067005',
        '255070009', '255071008', '255072001', '255074000', '255075004', '255076003', '255078002',
        '255083005', '255084004', '255090000', '255091001', '255101006', '255108000', '255109008',
        '255110003', '255111004', '255112006', '255114007', '255115008', '255119002', '255121007',
        '255123005', '264906008', '269459004', '269460009', '269462001', '269463006', '269464000',
        '269467007', '269468002', '269475001', '269476000', '269515006', '269516007', '269533000',
        '269544008', '269581007', '271568003', '271943005', '274084007', '274085008', '274087000',
        '275394001', '275395000', '275396004', '275397008', '275399006', '275490009', '276419004',
        '276420005', '276751004', '276803003', '276804009', '276808007', '276809004', '276810009',
        '276811008', '276815004', '276821000', '276826005', '276827001', '276828006', '276829003',
        '276836002', '276852004', '276860003', '276870001', '276871002', '276872009', '276876007',
        '276952000', '276953005', '276954004', '276962007', '276968006', '276975007', '277456001',
        '277461004', '277473004', '277474005', '277505007', '277507004', '277508009', '277523004',
        '277526007', '277527003', '277530005', '277545003', '277549009', '277550009', '277551008',
        '277567002', '277568007', '277569004', '277570003', '277571004', '277572006', '277573001',
        '277574007', '277575008', '277577000', '277580004', '277587001', '277589003', '277597005',
        '277601005', '277602003', '277604002', '277606000', '277609007', '277610002', '277611003',
        '277612005', '277613000', '277614006', '277615007', '277616008', '277617004', '277618009',
        '277619001', '277626001', '277627005', '277637000', '277642008', '277643003', '277651000',
        '277653002', '277654008', '277664004', '277782009', '278024000', '278042005', '278043000',
        '278044006', '278046008', '278051002', '278052009', '278055006', '278057003', '278060005',
        '278189009', '278453007', '278491007', '280116003', '280959007', '28122003', '281560004',
        '281561000', '281562007', '281563002', '281566005', '281702006', '285307007', '285308002',
        '285309005', '285310000', '285311001', '285312008', '285420006', '285421005', '285422003',
        '285423008', '285424002', '285426000', '285428004', '285432005', '285598005', '285603002',
        '285604008', '285605009', '285606005', '285607001', '285608006', '285611007', '285616002',
        '285618001', '285619009', '285634003', '285635002', '285636001', '285637005', '285639008',
        '285640005', '285641009', '285642002', '285643007', '285644001', '285769009', '285776004',
        '285836003', '285838002', '285839005', '286889008', '286890004', '286900008', '300988009',
        '301756000', '302815008', '302820008', '302823005', '302824004', '302826002', '302837001',
        '302841002', '302849000', '302855005', '302856006', '303012000', '303017006', '303055001',
        '303056000', '303057009', '303194003', '303201005', '30664006', '307216009', '307340003',
        '307341004', '307502000', '307576001', '307592006', '307601000', '307603002', '307604008',
        '307605009', '307606005', '307607001', '307608006', '307609003', '307617006', '307618001',
        '307622006', '307633009', '307634003', '307635002', '307649006', '307650006', '307651005',
        '308006', '308121000', '309245001', '310599006', '312111009', '312112002', '312113007',
        '312114001', '312115000', '312949007', '313248004', '313249007', '313353007', '313354001',
        '313355000', '313356004', '313357008', '313427003', '313428008', '313429000', '31383003',
        '314191009', '314408000', '314418005', '314419002', '314947008', '314951005', '314952003',
        '314953008', '314954002', '314960002', '314961003', '314965007', '314967004', '314968009',
        '314969001', '314970000', '314973003', '314976006', '315058005', '359631009', '359640008',
        '359648001', '359782004', '359785002', '359987004', '363348004', '363349007', '363352004',
        '363354003', '363355002', '363358000', '363359008', '363360003', '363365008', '363370001',
        '363372009', '363373004', '363374005', '363375006', '363376007', '363377003', '363378008',
        '363379000', '363380002', '363381003', '363382005', '363383000', '363384006', '363385007',
        '363386008', '363387004', '363388009', '363389001', '363390005', '363391009', '363392002',
        '363393007', '363394001', '363395000', '363397008', '363398003', '363399006', '363400004',
        '363401000', '363402007', '363403002', '363406005', '363407001', '363408006', '363409003',
        '363410008', '363412000', '363413005', '363414004', '363417006', '363421004', '363422006',
        '363423001', '363424007', '363425008', '363426009', '363427000', '363428005', '363429002',
        '363430007', '363431006', '363432004', '363433009', '363434003', '363435002', '363436001',
        '363437005', '363438000', '363443007', '363444001', '363445000', '363446004', '363447008',
        '363449006', '363451005', '363452003', '363453008', '363454002', '363456000', '363457009',
        '363458004', '363459007', '363460002', '363461003', '363462005', '363463000', '363464006',
        '363465007', '363466008', '363467004', '363468009', '363469001', '363470000', '363471001',
        '363473003', '363474009', '363475005', '363476006', '363478007', '363481002', '363482009',
        '363483004', '363485006', '363486007', '363487003', '363488008', '363490009', '363491008',
        '363492001', '363493006', '363494000', '363497007', '363498002', '363502009', '363506007',
        '363507003', '363510005', '363514001', '363515000', '363516004', '363517008', '363518003',
        '369463005', '369464004', '369465003', '369466002', '369467006', '369468001', '369469009',
        '369470005', '369471009', '369472002', '369475000', '369476004', '369477008', '369478003',
        '369479006', '369480009', '369481008', '369482001', '369484000', '369485004', '369486003',
        '369487007', '369489005', '369490001', '369491002', '369492009', '369493004', '369494005',
        '369495006', '369496007', '369497003', '369498008', '369499000', '369500009', '369501008',
        '369502001', '369503006', '369504000', '369505004', '369506003', '369512008', '369513003',
        '369515005', '369516006', '369517002', '369518007', '369519004', '369520005', '369522002',
        '369524001', '369525000', '369526004', '369527008', '369528003', '369529006', '369531002',
        '369532009', '369533004', '369534005', '369537003', '369538008', '369539000', '369540003',
        '369541004', '369547000', '369548005', '369549002', '369550002', '369551003', '369552005',
        '369559001', '369566000', '369567009', '369574004', '369575003', '369576002', '369577006',
        '369578001', '369579009', '369580007', '370967009', '370987005', '371012000', '371134001',
        '371962007', '371963002', '371964008', '371965009', '371966005', '371967001', '371968006',
        '371969003', '371971003', '371972005', '371973000', '371974006', '371975007', '371976008',
        '371978009', '371979001', '371980003', '371981004', '371982006', '371983001', '371984007',
        '371986009', '371987000', '371988005', '371989002', '371990006', '371991005', '371993008',
        '371994002', '371995001', '371996000', '371997009', '371998004', '371999007', '372000001',
        '372001002', '372002009', '372004005', '372005006', '372006007', '372008008', '372009000',
        '372013007', '372014001', '372015000', '372016004', '372017008', '372018003', '372019006',
        '372020000', '372021001', '372022008', '372024009', '372025005', '372026006', '372027002',
        '372028007', '372030009', '372062007', '372064008', '372065009', '372097009', '372098004',
        '372099007', '372100004', '372103002', '372104008', '372105009', '372106005', '372107001',
        '372108006', '372110008', '372111007', '372112000', '372113005', '372115003', '372116002',
        '372120003', '372121004', '372131006', '372133009', '372135002', '372136001', '372138000',
        '372141009', '372143007', '373168002', '373627005', '385478001', '388871003', '396198006',
        '397008008', '397009000', '397011009', '397013007', '397015000', '398623004', '398679002',
        '398768004', '398831006', '399068003', '399326009', '399490008', '399590005', '399660006',
        '399967006', '400001003', '400092004', '400118002', '400122007', '401312001', '401313006',
        '402494003', '402495002', '402496001', '402503002', '402504008', '402505009', '402506005',
        '402507001', '402515003', '402819001', '402880009', '402881008', '402882001', '403467008',
        '403468003', '403714009', '403889000', '403919005', '403926005', '403950007', '404090003',
        '404094007', '404106004', '404107008', '404108003', '404109006', '404110001', '404111002',
        '404112009', '404113004', '404114005', '404115006', '404116007', '404117003', '404118008',
        '404119000', '404121005', '404122003', '404123008', '404124002', '404127009', '404128004',
        '404129007', '404132005', '404133000', '404134006', '404135007', '404136008', '404137004',
        '404138009', '404139001', '404140004', '404142007', '404143002', '404144008', '404147001',
        '404148006', '404149003', '404150003', '404151004', '404152006', '404153001', '404154007',
        '404155008', '404157000', '404160007', '404169008', '404653000', '404662003', '404664002',
        '405546008', '405822008', '405945003', '408642003', '408644002', '408647009', '408648004',
        '408649007', '413389003', '413441006', '413442004', '4135001', '413537009', '413587002',
        '413656006', '413842007', '413843002', '413847001', '414166008', '414250001', '414626005',
        '414666009', '414676007', '414780005', '414785000', '414791003', '414825006', '414950005',
        '415110002', '415112005', '415285009', '415286005', '415287001', '415653001', '416274001',
        '416351002', '416510003', '416712009', '416753001', '416842003', '416901002', '417417007',
        '417554000', '417619001', '418134006', '418372008', '419052002', '419240004', '419317000',
        '419327006', '419842002', '419889000', '420302007', '420519005', '420788006', '420835009',
        '420890002', '421246008', '421249001', '421283008', '421418009', '421696004', '421835000',
        '422052002', '422172005', '422541001', '422691006', '422758009', '422782004', '422833009',
        '422853008', '422886007', '422968005', '423005002', '423032007', '423038006', '423050000',
        '423106003', '423121009', '423158009', '423189008', '423195009', '423278008', '423280002',
        '423294001', '423295000', '423424005', '423425006', '423447006', '423464009', '423468007',
        '423494003', '423600008', '423607006', '423615009', '423619003', '423627007', '423673009',
        '423691004', '423708008', '423973006', '423987006', '424132000', '424151006', '424260006',
        '424276002', '424302003', '424334007', '424408000', '424422000', '424487008', '424549003',
        '424779008', '424849005', '424887002', '424938000', '424970000', '425048006', '425066001',
        '425127006', '425178004', '425225007', '425230006', '425231005', '425376008', '425657001',
        '425688002', '425749006', '425869007', '425941003', '426071002', '426124006', '426191007',
        '426217000', '426248008', '426336007', '426370008', '426642002', '426885008', '426964009',
        '427038005', '427056005', '427141003', '427492003', '427642009', '427658007', '428061005',
        '428100006', '428281000', '428753007', '428960009', '428964000', '428965004', '429033009',
        '429408002', '429565004', '430338009', '430621000', '432082001', '433067002', '438946002',
        '439478008', '440173001', '440397000', '440422002', '440501006', '440525003', '440527006',
        '441313008', '441559006', '441962003', '442537007', '443487006', '444545003', '444597005',
        '444869007', '444910004', '444911000', '445105005', '445227008', '445269007', '445406001',
        '445448008', '445513004', '445736006', '445738007', '446022000', '446076000', '446124001',
        '446593006', '446643000', '446710005', '446711009', '446887007', '446945009', '447100004',
        '447266004', '447389009', '447390000', '447596005', '447656001', '447658000', '447705002',
        '447707005', '447708000', '447711004', '447712006', '447738006', '447757002', '447766003',
        '447768002', '447781009', '447782002', '447783007', '447784001', '447785000', '447800002',
        '447805007', '447806008', '447949005', '447989004', '448148000', '448212009', '448213004',
        '448214005', '448215006', '448216007', '448217003', '448218008', '448220006', '448221005',
        '448229007', '448231003', '448233000', '448248006', '448250003', '448254007', '448258005',
        '448259002', '448269008', '448273006', '448298007', '448299004', '448300007', '448315008',
        '448317000', '448319002', '448354009', '448371005', '448372003', '448376000', '448377009',
        '448378004', '448384001', '448386004', '448387008', '448388003', '448401007', '448408001',
        '448435005', '448436006', '448447004', '448449001', '448450001', '448451002', '448465000',
        '448468003', '448509007', '448555009', '448558006', '448560008', '448561007', '448607004',
        '448609001', '448663003', '448665005', '448666006', '448668007', '448669004', '448670003',
        '448672006', '448674007', '448709005', '448710000', '448712008', '448738008', '448774004',
        '448775003', '448776002', '448863000', '448864006', '448865007', '448867004', '448868009',
        '448911008', '448952004', '448954003', '448989001', '448990005', '448993007', '448995000',
        '449034009', '449053004', '449054005', '449055006', '449058008', '449059000', '449063007',
        '449065000', '449066004', '449067008', '449073009', '449075002', '449077005', '449097000',
        '449100005', '449101009', '449108003', '449153001', '449156009', '449173006', '449176003',
        '449177007', '449206007', '449207003', '449208008', '449216004', '449217008', '449218003',
        '449219006', '449220000', '449221001', '449222008', '449223003', '449224009', '449248000',
        '449253005', '449254004', '449259009', '449260004', '449267001', '449268006', '449269003',
        '449292003', '449294002', '449295001', '449307001', '449308006', '449309003', '449318001',
        '449377002', '449386007', '449416001', '449417005', '449418000', '449419008', '449420002',
        '449421003', '449472007', '449487002', '449497006', '449578008', '449628003', '449636007',
        '449637003', '46724008', '53132006', '61530001', '61808009', '6331000', '64862009',
        '67944007', '7021009', '76564002', '8090002', '80914001', '81021006', '91855006',
        '91856007', '91857003', '91858008', '91860005', '91861009', '92087008', '92508006',
        '92509003', '92510008', '92511007', '92512000', '92513005', '92515003', '92516002',
        '92752000', '92793008', '92811003', '92812005', '92813000', '92814006', '92818009',
        '93133006', '93134000', '93135004', '93136003', '93137007', '93138002', '93139005',
        '93140007', '93141006', '93143009', '93144003', '93145002', '93146001', '93147005',
        '93148000', '93149008', '93151007', '93152000', '93169003', '93182006', '93183001',
        '93184007', '93185008', '93186009', '93187000', '93188005', '93189002', '93190006',
        '93191005', '93192003', '93193008', '93194002', '93195001', '93196000', '93197009',
        '93198004', '93199007', '93200005', '93201009', '93202002', '93203007', '93204001',
        '93205000', '93206004', '93207008', '93208003', '93209006', '93210001', '93211002',
        '93213004', '93214005', '93215006', '93216007', '93217003', '93218008', '93219000',
        '93220006', '93221005', '93222003', '93223008', '93224002', '93225001', '93226000',
        '93227009', '93228004', '93229007', '93230002', '93451002', '93487009', '93488004',
        '93489007', '93492006', '93493001', '93494007', '93495008', '93496009', '93497000',
        '93498005', '93500006', '93501005', '93505001', '93506000', '93507009', '93509007',
        '93510002', '93514006', '93515007', '93516008', '93518009', '93519001', '93520007',
        '93521006', '93522004', '93523009', '93524003', '93525002', '93526001', '93527005',
        '93528000', '93530003', '93531004', '93532006', '93533001', '93534007', '93536009',
        '93537000', '93541001', '93542008', '93543003', '93545005', '93546006', '93547002',
        '93548007', '93549004', '93550004', '93551000', '93552007', '93554008', '93555009',
        '93636004', '93637008', '93638003', '93640008', '93641007', '93642000', '93643005',
        '93644004', '93645003', '93646002', '93647006', '93648001', '93649009', '93650009',
        '93651008', '93652001', '93653006', '93654000', '93655004', '93659005', '93661001',
        '93662008', '93665005', '93667002', '93669004', '93670003', '93671004', '93672006',
        '93674007', '93676009', '93680004', '93683002', '93684008', '93687001', '93689003',
        '93692004', '93710000', '93716006', '93717002', '93720005', '93721009', '93722002',
        '93723007', '93724001', '93725000', '93726004', '93727008', '93728003', '93729006',
        '93730001', '93731002', '93732009', '93733004', '93734005', '93737003', '93738008',
        '93739000', '93741004', '93742006', '93744007', '93745008', '93746009', '93747000',
        '93748005', '93749002', '93753000', '93754006', '93755007', '93756008', '93757004',
        '93760006', '93761005', '93764002', '93766000', '93768004', '93769007', '93771007',
        '93772000', '93773005', '93775003', '93776002', '93778001', '93779009', '93781006',
        '93782004', '93783009', '93784003', '93786001', '93787005', '93788000', '93789008',
        '93796005', '93797001', '93798006', '93799003', '93800004', '93802007', '93806005',
        '93807001', '93808006', '93809003', '93812000', '93816002', '93818001', '93820003',
        '93825008', '93826009', '93827000', '93829002', '93830007', '93831006', '93833009',
        '93835002', '93836001', '93837005', '93841009', '93842002', '93843007', '93844001',
        '93845000', '93848003', '93849006', '93850006', '93851005', '93857009', '93858004',
        '93860002', '93861003', '93862005', '93864006', '93865007', '93867004', '93868009',
        '93871001', '93872008', '93874009', '93876006', '93879004', '93880001', '93882009',
        '93883004', '93885006', '93886007', '93887003', '93888008', '93889000', '93891008',
        '93892001', '93893006', '93894000', '93898002', '93910009', '93915004', '93916003',
        '93917007', '93918002', '93920004', '93924008', '93927001', '93928006', '93930008',
        '93931007', '93932000', '93933005', '93934004', '93936002', '93942003', '93943008',
        '93944002', '93945001', '93946000', '93947009', '93948004', '93950007', '93951006',
        '93952004', '93955002', '93957005', '93958000', '93959008', '93960003', '93961004',
        '93962006', '93963001', '93964007', '93965008', '93966009', '93967000', '93968005',
        '93969002', '93970001', '93971002', '93974005', '93975006', '93976007', '93977003',
        '93978008', '93979000', '93980002', '93981003', '93982005', '93983000', '93985007',
        '93986008', '93987004', '93989001', '93990005', '93991009', '93992002', '93993007',
        '93994001', '93996004', '93997008', '93998003', '94001007', '94002000', '94003005',
        '94006002', '94010004', '94014008', '94015009', '94020009', '94021008', '94049001',
        '94051002', '94062002', '94066004', '94067008', '94068003', '94069006', '94071006',
        '94072004', '94073009', '94075002', '94076001', '94077005', '94078000', '94080006',
        '94083008', '94084002', '94085001', '94086000', '94087009', '94089007', '94090003',
        '94094007', '94096009', '94098005', '94099002', '94101009', '94102002', '94103007',
        '94104001', '94105000', '94107008', '94109006', '94112009', '94113004', '94115006',
        '94117003', '94118008', '94120006', '94121005', '94122003', '94123008', '94124002',
        '94125001', '94128004', '94129007', '94132005', '94133000', '94134006', '94135007',
        '94138009', '94139001', '94140004', '94142007', '94143002', '94144008', '94145009',
        '94148006', '94179005', '94260004', '94271003', '94328005', '94509004', '94538001',
        '94604000', '94643001', '94686001', '94687005', '94688000', '94690004', '94707004',
        '94708009', '94709001', '94710006', '94711005', '94712003', '94714002', '94715001',
        '94716000', '94718004', '94719007', '94726007', '94745003', '94750009', '95186006',
        '95187002', '95188007', '95192000', '95193005', '95194004', '95209008', '95210003',
        '95224004', '95225003', '95226002', '95230004', '95231000', '95260009', '95261008',
        '95263006', '95264000', '95413004'
    }


class PapTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1017'
    VALUE_SET_NAME = 'Pap Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '10524-7', '18500-9', '19762-4', '19764-0', '19765-7', '19766-5', '19774-9', '33717-0',
        '47527-7', '47528-5'
    }


class Mammogram(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1018'
    VALUE_SET_NAME = 'Mammogram'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    HCPCS = {'G0202', 'G0204', 'G0206'}

    LOINC = {
        '24604-1', '24605-8', '24606-6', '24610-8', '26175-0', '26176-8', '26177-6', '26287-3',
        '26289-9', '26291-5', '26346-7', '26347-5', '26348-3', '26349-1', '26350-9', '26351-7',
        '36319-2', '36625-2', '36626-0', '36627-8', '36642-7', '36962-9', '37005-6', '37006-4',
        '37016-3', '37017-1', '37028-8', '37029-6', '37030-4', '37037-9', '37038-7', '37052-8',
        '37053-6', '37539-4', '37542-8', '37543-6', '37551-9', '37552-7', '37553-5', '37554-3',
        '37768-9', '37769-7', '37770-5', '37771-3', '37772-1', '37773-9', '37774-7', '37775-4',
        '38067-5', '38070-9', '38071-7', '38072-5', '38090-7', '38091-5', '38807-4', '38820-7',
        '38854-6', '38855-3', '39150-8', '39152-4', '39153-2', '39154-0', '42168-5', '42169-3',
        '42174-3', '42415-0', '42416-8', '46335-6', '46336-4', '46337-2', '46338-0', '46339-8',
        '46342-2', '46350-5', '46351-3', '46354-7', '46355-4', '46356-2', '46380-2', '48475-8',
        '48492-3', '69150-1', '69251-7', '69259-0'
    }


class Colonoscopy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1020'
    VALUE_SET_NAME = 'Colonoscopy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '44388', '44389', '44390', '44391', '44392', '44393', '44394', '44397', '45355', '45378',
        '45379', '45380', '45381', '45382', '45383', '45384', '45385', '45386', '45387', '45391',
        '45392'
    }

    HCPCS = {'G0105', 'G0121'}

    SNOMEDCT = {
        '12350003', '174158000', '174184006', '235150006', '235151005', '25732003', '303587008',
        '310634005', '34264006', '367535003', '427459009', '443998000', '444783004', '446521004',
        '446745002', '447021001', '73761001', '8180007'
    }


class DiabeticNephropathy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1004'
    VALUE_SET_NAME = 'Diabetic Nephropathy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'E0821', 'E0822', 'E0829', 'E0921', 'E0922', 'E0929', 'E1021', 'E1022', 'E1029', 'E1121',
        'E1122', 'E1129', 'E1321', 'E1322', 'E1329'
    }

    ICD9CM = {'25041', '25042', '25043'}

    SNOMEDCT = {
        '127013003', '236499007', '236500003', '38046004', '401110002', '420514000', '420715001',
        '421305000', '421986006', '445170001', '54181000'
    }


class VascularAccessForDialysis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1011'
    VALUE_SET_NAME = 'Vascular Access for Dialysis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '36147', '36148', '36800', '36810', '36815', '36818', '36819', '36820', '36821', '36831',
        '36832', '36833'
    }

    SNOMEDCT = {
        '180272001', '180277007', '225892009', '22800003', '233468004', '233471007', '233472000',
        '233547003', '238314006', '238315007', '271418008', '34163007', '426340003', '427992007',
        '428118009', '431418000', '431440009', '431781000', '432509002', '432654009', '434435000',
        '438341004', '438342006', '439241008', '439322008', '439349008', '439534001', '443683004',
        '448591002', '449400003', '450865002', '54817007', '61160002', '61740001', '63421002',
        '676002', '69380006', '7459007', '79827002', '80634002'
    }


class KidneyTransplant(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1012'
    VALUE_SET_NAME = 'Kidney Transplant'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'50340', '50360', '50365', '50370', '50380'}

    HCPCS = {'S2065'}

    SNOMEDCT = {
        '175899003', '175901007', '175902000', '236138007', '313030004', '48994000', '52213001',
        '70536003', '88930008'
    }


class DialysisServices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1013'
    VALUE_SET_NAME = 'Dialysis Services'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90920', '90921', '90924', '90925', '90935', '90937', '90940', '90945', '90947'}

    HCPCS = {'G0257'}

    SNOMEDCT = {
        '108241001', '10848006', '11932001', '14684005', '180273006', '225230008', '225231007',
        '233575001', '233576000', '233577009', '233578004', '233579007', '233580005', '233581009',
        '233582002', '233583007', '233584001', '233585000', '233586004', '233587008', '233588003',
        '233589006', '233590002', '238316008', '238317004', '238318009', '238319001', '238321006',
        '238322004', '238323009', '265764009', '288182009', '302497006', '34897002', '427053002',
        '428648006', '439278006', '439976001', '57274006', '676002', '67970008', '68341005',
        '71192002'
    }


class EsrdMonthlyOutpatientServices(ValueSet):
    """

    Clinical Focus: Under  Development
    Data Element Scope: Under  Development
    Inclusion Criteria: Under  Development
    Exclusion Criteria: Under  Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1014'
    VALUE_SET_NAME = 'ESRD Monthly Outpatient Services'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '90957', '90958', '90959', '90960', '90961', '90962', '90965', '90966', '90969', '90970',
        '90989', '90993', '90997', '90999', '99512'
    }


class OtherServicesRelatedToDialysis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1015'
    VALUE_SET_NAME = 'Other Services Related to Dialysis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {
        '233591003', '251000124108', '311000124103', '3257008', '385970002', '385971003',
        '385973000', '406168002', '73257006'
    }


class DialysisEducation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1016'
    VALUE_SET_NAME = 'Dialysis Education'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'28812006', '385972005', '59596005', '66402002'}


class HypertensiveChronicKidneyDisease(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1017'
    VALUE_SET_NAME = 'Hypertensive Chronic Kidney Disease'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'I120', 'I129', 'I130', 'I1310', 'I1311', 'I132'}

    ICD9CM = {
        '40301', '40310', '40311', '40390', '40391', '40400', '40401', '40402', '40403', '40410',
        '40411', '40412', '40413', '40490', '40491', '40492', '40493'
    }

    SNOMEDCT = {
        '111438007', '123799005', '123800009', '14973001', '193003', '194774006', '194783001',
        '19769006', '23130000', '28119000', '285831000119108', '285841000119104',
        '286371000119107', '32916005', '38481006', '39018007', '397748008', '427889009',
        '428575007', '473392002', '49220004', '57684003', '62240004', '65443008', '66052004',
        '66610008', '73410007', '78544004', '81363003', '86234004', '90493000'
    }


class GlomerulonephritisAndNephroticSyndrome(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1018'
    VALUE_SET_NAME = 'Glomerulonephritis and Nephrotic Syndrome'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'N000', 'N001', 'N002', 'N003', 'N004', 'N005', 'N006', 'N007', 'N008', 'N009', 'N010',
        'N011', 'N012', 'N013', 'N014', 'N015', 'N016', 'N017', 'N018', 'N019', 'N020', 'N021',
        'N022', 'N023', 'N024', 'N025', 'N026', 'N027', 'N028', 'N029', 'N030', 'N031', 'N032',
        'N033', 'N034', 'N035', 'N036', 'N037', 'N038', 'N039', 'N040', 'N041', 'N042', 'N043',
        'N044', 'N045', 'N046', 'N047', 'N048', 'N049', 'N050', 'N051', 'N052', 'N053', 'N054',
        'N055', 'N056', 'N057', 'N058', 'N059', 'N060', 'N061', 'N062', 'N063', 'N064', 'N065',
        'N066', 'N067', 'N068', 'N069', 'N070', 'N071', 'N072', 'N073', 'N074', 'N075', 'N076',
        'N077', 'N078', 'N079', 'N08', 'N250', 'N251', 'N2581', 'N2589', 'N259'
    }

    ICD9CM = {
        '5804', '58081', '58089', '5809', '5810', '5811', '5812', '5813', '58181', '58189', '5819',
        '5820', '5821', '5822', '5824', '58281', '58289', '5829', '5830', '5831', '5832', '5834',
        '5836', '5837', '58381', '58389', '5839', '5880', '5881', '58881', '58889', '5889'
    }

    SNOMEDCT = {
        '110996009', '111395007', '118951003', '123609007', '123610002', '123752003', '13335004',
        '1426004', '16726004', '1776003', '19351000', '197577008', '197579006', '197580009',
        '197582001', '197584000', '197585004', '197589005', '197590001', '197591002', '197593004',
        '197594005', '197595006', '197596007', '197597003', '197598008', '197599000', '197600002',
        '197601003', '197603000', '197605007', '197607004', '197613008', '197614002', '197616000',
        '197617009', '197618004', '197619007', '197626007', '197628008', '197629000', '197632002',
        '197661001', '197663003', '197664009', '197670003', '197671004', '197679002', '197681000',
        '197682007', '197683002', '197684008', '197685009', '197686005', '197687001', '197688006',
        '197689003', '197690007', '197691006', '197692004', '197693009', '197694003', '197695002',
        '197696001', '197697005', '197699008', '197700009', '197701008', '197702001', '197703006',
        '197704000', '197705004', '197706003', '197707007', '197708002', '197709005', '197712008',
        '197713003', '197714009', '197715005', '197716006', '197717002', '197719004', '197720005',
        '197721009', '197722002', '197723007', '197724001', '197725000', '197738008', '197739000',
        '20917003', '22702000', '234485006', '236380004', '236381000', '236382007', '236383002',
        '236384008', '236385009', '236391006', '236392004', '236393009', '236394003', '236395002',
        '236397005', '236398000', '236399008', '236400001', '236401002', '236402009', '236403004',
        '236404005', '236405006', '236407003', '236409000', '236410005', '236411009', '236412002',
        '236413007', '236414001', '236415000', '236416004', '236417008', '236418003', '236419006',
        '236420000', '236422008', '236437007', '236460004', '236461000', '236463002', '236479001',
        '236480003', '236508005', '236534002', '236535001', '236587002', '236588007', '236589004',
        '236590008', '239932005', '24790002', '253864004', '25821008', '266549004', '276585000',
        '282364005', '309426007', '35546006', '359694003', '36171008', '363234001', '3704008',
        '370494002', '37085009', '38046004', '399190000', '399340005', '40233000', '425384007',
        '425455002', '441815006', '444977005', '445258009', '445388002', '445404003', '446923008',
        '44785005', '48796009', '51055000', '52254009', '52845002', '54181000', '54879000',
        '55652009', '57965003', '58574008', '59479006', '61165007', '61503006', '62240004',
        '63510008', '64168005', '64212008', '68544003', '68779003', '73305009', '75888001',
        '7703001', '77182004', '7724006', '80321008', '81363003', '81475007', '8199003',
        '83866005', '86210009', '90493000'
    }


class UrineProteinTests(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1024'
    VALUE_SET_NAME = 'Urine Protein Tests'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '11218-5', '12842-1', '13705-9', '13801-6', '14585-4', '14956-7', '14957-5', '14958-3',
        '14959-1', '1753-3', '1754-1', '1755-8', '1757-4', '18373-1', '20454-5', '20621-9',
        '21059-1', '21482-5', '26801-1', '27298-9', '2887-8', '2888-6', '2889-4', '2890-2',
        '30000-4', '30001-2', '30003-8', '32209-9', '32294-1', '32551-4', '34366-5', '35663-4',
        '40486-3', '40662-9', '40663-7', '43605-5', '43606-3', '43607-1', '44292-1', '47558-2',
        '49023-5', '50561-0', '50949-7', '53121-0', '53525-2', '53530-2', '53531-0', '53532-8',
        '56553-1', '57369-1', '57735-3', '5804-0', '58448-2', '58992-9', '59159-4', '60678-0',
        '63474-1', '9318-7'
    }


class KidneyFailure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1028'
    VALUE_SET_NAME = 'Kidney Failure'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'N170', 'N171', 'N172', 'N178', 'N179', 'N181', 'N182', 'N183', 'N184', 'N185', 'N186',
        'N189', 'N19'
    }

    ICD9CM = {
        '5845', '5846', '5847', '5848', '5849', '5851', '5852', '5853', '5854', '5855', '5856',
        '5859', '586', '587'
    }

    SNOMEDCT = {
        '129151000119102', '129171000119106', '129181000119109', '140111000119107',
        '140131000119102', '145681000119101', '14669001', '236434000', '236435004', '236436003',
        '284981000119102', '285001000119105', '285861000119100', '285881000119109', '429224003',
        '431855005', '431857002', '433144002', '433146000', '46177005', '700378005', '700379002',
        '711000119100', '721000119107', '731000119105', '90741000119107', '90751000119109',
        '96721000119103', '96731000119100', '96741000119109'
    }


class DtapVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1022'
    VALUE_SET_NAME = 'DTaP Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90698', '90700', '90721', '90723'}

    SNOMEDCT = {
        '412755006', '412756007', '412757003', '414001002', '414259000', '414620004', '415507003',
        '415712004'
    }


class HepatitisA(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1024'
    VALUE_SET_NAME = 'Hepatitis A'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'B150', 'B159'}

    ICD9CM = {'0700', '0701'}

    SNOMEDCT = {
        '111879004', '16060001', '18917003', '206373002', '25102003', '40468003', '424758008',
        '43634002', '79031007'
    }


class HepatitisB(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1025'
    VALUE_SET_NAME = 'Hepatitis B'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'B160', 'B161', 'B162', 'B169', 'B170', 'B180', 'B181', 'B1910', 'B1911'}

    ICD9CM = {'07020', '07021', '07022', '07023', '07030', '07031', '07032', '07033', 'V0261'}

    SNOMEDCT = {
        '1116000', '111891008', '13265006', '186624004', '186626002', '186639003', '235864009',
        '235869004', '235871004', '26206000', '29062009', '38662009', '424099008', '424340000',
        '424460009', '442134007', '442374005', '446698005', '50167007', '53425008', '60498001',
        '61977001', '66071002', '76795007'
    }


class PneumococcalVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1027'
    VALUE_SET_NAME = 'Pneumococcal Vaccine'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CVX = {'133', '33'}


class HistoryOfPneumococcalVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1028'
    VALUE_SET_NAME = 'History of Pneumococcal Vaccine'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'310578008', '473165003'}


class MeaslesMumpsAndRubellaMmrVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1031'
    VALUE_SET_NAME = 'Measles, Mumps and Rubella (MMR) Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90707', '90710'}

    SNOMEDCT = {'170433008', '38598009', '432636005', '433733003'}


class Mumps(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1032'
    VALUE_SET_NAME = 'Mumps'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'B260', 'B261', 'B262', 'B263', 'B2681', 'B2682', 'B2683', 'B2684', 'B2685', 'B2689',
        'B269'
    }

    ICD9CM = {'0720', '0721', '0722', '0723', '07271', '07272', '07279', '0728', '0729'}

    SNOMEDCT = {
        '10665004', '111870000', '17121006', '235123001', '236771002', '237443002', '240526004',
        '240527008', '240529006', '31524007', '31646008', '36989005', '40099009', '44201003',
        '63462008', '72071001', '74717002', '75548002', '78580004', '89764009'
    }


class PneumococcalVaccineAdministered(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1034'
    VALUE_SET_NAME = 'Pneumococcal Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90670', '90732'}

    SNOMEDCT = {'12866006', '394678003'}


class Rubella(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1037'
    VALUE_SET_NAME = 'Rubella'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'B0600', 'B0601', 'B0602', 'B0609', 'B0681', 'B0682', 'B0689', 'B069'}

    ICD9CM = {'05600', '05601', '05609', '05671', '05679', '0568', '0569'}

    SNOMEDCT = {
        '10082001', '111867004', '111868009', '13225007', '186567003', '186570004', '19431000',
        '232312000', '240485004', '253227001', '36653000', '64190005', '79303006', '84611003'
    }


class VaricellaZoster(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1039'
    VALUE_SET_NAME = 'Varicella Zoster'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'B010', 'B0111', 'B0112', 'B012', 'B0181', 'B0189', 'B019', 'B020', 'B021', 'B0221',
        'B0222', 'B0223', 'B0224', 'B0229', 'B0230', 'B0231', 'B0232', 'B0233', 'B0234', 'B0239',
        'B027', 'B028', 'B029'
    }

    ICD9CM = {
        '0520', '0521', '0522', '0527', '0528', '0529', '0530', '05310', '05311', '05312', '05313',
        '05314', '05319', '05320', '05321', '05322', '05329', '05371', '05379', '0538', '0539'
    }

    SNOMEDCT = {
        '10491005', '10698009', '111859007', '111861003', '186524006', '186525007', '195911009',
        '21954000', '230176008', '230198004', '230262004', '230536009', '232400003', '235059009',
        '23737006', '240468001', '240470005', '240471009', '240472002', '240473007', '240474001',
        '24059009', '309465005', '36292003', '38907003', '397573005', '400020001', '402897003',
        '402898008', '410500004', '410509003', '421029004', '422127002', '422446008', '422471006',
        '422666006', '423333008', '423628002', '424353002', '424435009', '42448002', '424801004',
        '424941009', '425356002', '426570007', '428633000', '4740000', '49183009', '55560002',
        '87513003'
    }


class VaricellaZosterVaccineVzvAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1040'
    VALUE_SET_NAME = 'Varicella Zoster Vaccine (VZV) Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90710', '90716'}

    SNOMEDCT = {'425897001', '428502009', '68525005'}


class HepatitisAVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1041'
    VALUE_SET_NAME = 'Hepatitis A Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90633'}

    SNOMEDCT = {'170378007', '170379004', '243789007', '313188000', '313189008'}


class HepatitisBVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1042'
    VALUE_SET_NAME = 'Hepatitis B Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90723', '90740', '90744', '90747', '90748'}

    SNOMEDCT = {
        '116802006', '16584000', '170370000', '170371001', '170372008', '170373003', '170374009',
        '170434002', '170435001', '170436000', '170437009', '312868009', '396456003'
    }


class HaemophilusInfluenzaeTypeBHibVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1043'
    VALUE_SET_NAME = 'Haemophilus Influenzae Type B (HiB) Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90645', '90646', '90647', '90648', '90698', '90721', '90748'}

    SNOMEDCT = {
        '127787002', '170343007', '170344001', '170345000', '414001002', '414259000', '415507003',
        '415712004'
    }


class InfluenzaVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1044'
    VALUE_SET_NAME = 'Influenza Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90655', '90657', '90661', '90662', '90673', '90685'}

    SNOMEDCT = {'86198006'}


class InactivatedPolioVaccineIpvAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1045'
    VALUE_SET_NAME = 'Inactivated Polio Vaccine (IPV) Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90698', '90713', '90723'}

    SNOMEDCT = {
        '396456003', '414001002', '414259000', '414619005', '414620004', '415507003', '415712004',
        '416144004', '416591003', '417211006', '417384007', '417615007'
    }


class PneumococcalConjugateVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1046'
    VALUE_SET_NAME = 'Pneumococcal Conjugate Vaccine Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90669', '90670'}

    SNOMEDCT = {'434751000124102'}


class RotavirusVaccine3DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1047'
    VALUE_SET_NAME = 'Rotavirus Vaccine (3 dose schedule) Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90680'}


class RotavirusVaccine2DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1048'
    VALUE_SET_NAME = 'Rotavirus Vaccine (2 dose schedule) Administered'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'90681'}


class GenitalHerpes(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1049'
    VALUE_SET_NAME = 'Genital Herpes'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'A6000', 'A6003', 'A6004', 'A6009'}

    ICD9CM = {'05410', '05411', '05412', '05419'}

    SNOMEDCT = {
        '129670002', '27420004', '278068003', '33839006', '402888002', '402890001', '402894005',
        '402896007', '423391007', '427578006', '439912007', '439913002', '440714005', '59819007'
    }


class LabTestsForSexuallyTransmittedInfections(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1051'
    VALUE_SET_NAME = 'Lab Tests for Sexually Transmitted Infections'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '10705-2', '11083-3', '11084-1', '11481-9', '11597-2', '12222-6', '12223-4', '14499-8',
        '14500-3', '14502-9', '14503-7', '14504-5', '14506-0', '16280-0', '17398-9', '17399-7',
        '17400-3', '17401-1', '17402-9', '17403-7', '17404-5', '17405-2', '17406-0', '17407-8',
        '17408-6', '17409-4', '17410-2', '17411-0', '17412-8', '17723-8', '17724-6', '17725-3',
        '17726-1', '17727-9', '17728-7', '17729-5', '20507-0', '20508-8', '21414-8', '21415-5',
        '21416-3', '21440-3', '21441-1', '22461-8', '22462-6', '22587-0', '22590-4', '22592-0',
        '22594-6', '24110-9', '24111-7', '24312-1', '26009-1', '29311-8', '30167-1', '31147-2',
        '31905-3', '31906-1', '32198-4', '32199-2', '32705-6', '34147-9', '34382-2', '38372-9',
        '40679-3', '40680-1', '42481-2', '43305-2', '43403-5', '44543-7', '44544-5', '44546-0',
        '44547-8', '44549-4', '44550-2', '47236-5', '47237-3', '47238-1', '47387-6', '48560-7',
        '49891-5', '49896-4', '5028-6', '50388-8', '50690-7', '51838-1', '51839-9', '5291-0',
        '5292-8', '53605-2', '53762-1', '53879-3', '5392-6', '53927-0', '5393-4', '5394-2',
        '55299-2', '57032-5', '59263-4', '59264-2', '59420-0', '61372-9', '61373-7', '61374-5',
        '61375-2', '61376-0', '61377-8', '61378-6', '61379-4', '61380-2', '61381-0', '61382-8',
        '61383-6', '61384-4', '61385-1', '61386-9', '61387-7', '61388-5', '61389-3', '61390-1',
        '61391-9', '61392-7', '61393-5', '61394-3', '61395-0', '61396-8', '63464-2', '6487-3',
        '6488-1', '6489-9', '6510-2', '6511-0', '6514-4', '6516-9', '6561-5', '6562-3', '660-1',
        '688-2', '690-8', '69002-4', '691-6', '692-4', '693-2', '698-1', '71431-1', '71793-4',
        '73732-0', '73752-8', '73959-9', '7975-6', '8041-6'
    }


class ChlamydiaScreening(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1052'
    VALUE_SET_NAME = 'Chlamydia Screening'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '14463-4', '14464-2', '14467-5', '14470-9', '14471-7', '14474-1', '14509-4', '14510-2',
        '14513-6', '16600-9', '16601-7', '21189-6', '21190-4', '21191-2', '21192-0', '21613-5',
        '23838-6', '31771-9', '31772-7', '31775-0', '31777-6', '36902-5', '36903-3', '42931-6',
        '43304-5', '43404-3', '43406-8', '44806-8', '44807-6', '45067-6', '45068-4', '45069-2',
        '45070-0', '45074-2', '45076-7', '45078-3', '45080-9', '45084-1', '45091-6', '45095-7',
        '45098-1', '45100-5', '47211-8', '47212-6', '49096-1', '4993-2', '50387-0', '53925-4',
        '53926-2', '557-9', '560-3', '6349-5', '6354-5', '6355-2', '6356-0', '6357-8'
    }


class Measles(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1053'
    VALUE_SET_NAME = 'Measles'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'B050', 'B051', 'B052', 'B053', 'B054', 'B0581', 'B0589', 'B059'}

    ICD9CM = {'0550', '0551', '0552', '05571', '05579', '0558', '0559'}

    SNOMEDCT = {
        '111873003', '14189004', '186561002', '186562009', '192685000', '195900001', '233625007',
        '240483006', '240484000', '28463004', '38921001', '406592004', '60013002', '74918002'
    }


class Seropositive(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1054'
    VALUE_SET_NAME = 'Seropositive'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'4879001'}


class HpvTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1059'
    VALUE_SET_NAME = 'HPV Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {'21440-3', '30167-1', '38372-9', '49896-4', '59420-0', '75406-9', '75694-0'}


class OtherFemaleReproductiveConditions(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1006'
    VALUE_SET_NAME = 'Other Female Reproductive Conditions'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A630', 'B977', 'E230', 'E282', 'E2839', 'G4482', 'N881', 'N883', 'N898', 'N930', 'N970',
        'N971', 'N972', 'N978', 'N979', 'R85610', 'R85611', 'R85612', 'R85613', 'R85614', 'R85615',
        'R85616', 'R85618', 'R85619', 'R8581', 'R8582', 'R87610', 'R87611', 'R87612', 'R87613',
        'R87614', 'R87615', 'R87616', 'R87618', 'R87619', 'R87620', 'R87621', 'R87622', 'R87623',
        'R87624', 'R87625', 'R87628', 'R87629', 'T8331XA', 'T8331XD', 'T8331XS', 'T8332XA',
        'T8332XD', 'T8332XS', 'T8339XA', 'T8339XD', 'T8339XS'
    }

    ICD9CM = {
        '07811', '0794', '33982', '6223', '6234', '6267', '6280', '6281', '6282', '6283', '6284',
        '6288', '6289', '79500', '79501', '79502', '79503', '79504', '79505', '79506', '79507',
        '79508', '79509', '79510', '79511', '79512', '79513', '79514', '79515', '79516', '79518',
        '79519', '79670', '79671', '79672', '79673', '79674', '79675', '79676', '79677', '79678',
        '79679', '99632'
    }

    SNOMEDCT = {
        '103010005', '125157000', '168407000', '168472007', '198445009', '198446005', '198448006',
        '198449003', '198450003', '198452006', '198453001', '198456009', '198457000', '198459002',
        '198460007', '198464003', '198465002', '227561004', '237110007', '237139007', '237141008',
        '237142001', '237800001', '240542006', '266609001', '26899006', '286995008', '30238006',
        '30826006', '3160009', '35308000', '373877006', '391147004', '39446004', '395688005',
        '399599006', '414238007', '414239004', '415149004', '415168001', '416030007', '416031006',
        '416033009', '419266001', '426488001', '427547007', '428008002', '428017002', '439776006',
        '439855007', '439856008', '439888000', '439890004', '439891000', '441072002', '441086003',
        '441087007', '441088002', '441094005', '441098008', '441099000', '441114008', '441115009',
        '441219009', '441667007', '4667004', '48880000', '5084002', '52937008', '53821008',
        '58423003', '6303009', '65370002', '65454003', '6738008', '74294009', '80330000',
        '82593008', '84785006', '85078005'
    }


class LabTestsDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1007'
    VALUE_SET_NAME = 'Lab Tests During Pregnancy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '15019-3', '1832-5', '1834-1', '19171-8', '19176-7', '19177-5', '20403-2', '20404-0',
        '31993-9', '33773-3', '34493-7', '34656-9', '34718-7', '35457-1', '41273-4', '41274-2',
        '42316-0', '43798-8', '45273-0', '45331-6', '45332-4', '46731-6', '46989-0', '48030-1',
        '48039-2', '48781-9', '49246-2', '49318-9', '64088-8', '64094-6'
    }


class DiagnosticStudiesDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1008'
    VALUE_SET_NAME = 'Diagnostic Studies During Pregnancy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '11615-2', '11616-0', '11617-8', '11618-6', '11619-4', '11620-2', '11621-0', '11622-8',
        '11623-6', '11624-4', '11625-1', '11626-9', '11627-7', '11628-5', '11629-3', '11630-1',
        '11631-9', '11632-7', '11633-5', '11634-3', '11635-0', '11641-8', '11643-4', '11645-9',
        '11647-5', '11649-1', '11651-7', '11654-1', '11656-6', '11660-8', '11661-6', '11662-4',
        '11666-5', '11668-1', '11670-7', '11672-3', '11675-6', '11677-2', '11679-8', '11681-4',
        '11685-5', '11687-1', '11688-9', '11689-7', '11693-9', '11695-4', '11697-0', '11699-6',
        '11701-0', '11703-6', '11705-1', '11707-7', '11709-3', '11711-9', '11713-5', '11715-0',
        '11719-2', '11721-8', '11722-6', '11723-4', '11727-5', '11728-3', '11729-1', '11730-9',
        '11731-7', '11732-5', '11733-3', '11734-1', '11735-8', '11736-6', '11737-4', '11738-2',
        '11739-0', '11740-8', '11741-6', '11742-4', '11743-2', '11744-0', '11745-7', '11746-5',
        '11747-3', '11748-1', '11749-9', '11750-7', '11751-5', '11752-3', '11753-1', '11754-9',
        '11755-6', '11756-4', '11757-2', '11758-0', '11759-8', '11760-6', '11761-4', '11762-2',
        '11763-0', '11764-8', '11765-5', '11766-3', '11767-1', '11768-9', '11775-4', '11777-0',
        '11782-0', '11790-3', '11792-9', '11794-5', '11796-0', '11798-6', '11800-0', '11802-6',
        '11804-2', '11806-7', '11808-3', '11810-9', '11812-5', '11814-1', '11815-8', '11816-6',
        '11817-4', '11818-2', '11819-0', '11820-8', '11821-6', '11822-4', '11823-2', '11824-0',
        '11825-7', '11827-3', '11831-5', '11832-3', '11833-1', '11834-9', '11836-4', '11838-0',
        '11843-0', '11844-8', '11845-5', '11849-7', '11851-3', '11852-1', '11853-9', '11855-4',
        '11860-4', '11861-2', '11862-0', '11863-8', '11864-6', '11866-1', '11868-7', '11871-1',
        '11872-9', '11873-7', '11874-5', '11875-2', '11876-0', '11877-8', '11878-6', '11882-8',
        '11883-6', '11884-4', '11885-1', '11886-9', '11887-7', '11888-5', '11889-3', '11890-1',
        '11891-9', '11892-7', '11893-5', '11894-3', '11895-0', '11896-8', '11897-6', '11898-4',
        '11899-2', '11900-8', '11901-6', '11902-4', '11903-2', '11904-0', '11905-7', '11906-5',
        '11907-3', '11908-1', '11909-9', '11910-7', '11911-5', '11912-3', '11913-1', '11914-9',
        '11915-6', '11916-4', '11917-2', '11918-0', '11919-8', '11920-6', '11921-4', '11922-2',
        '11923-0', '11924-8', '11925-5', '11926-3', '11927-1', '11928-9', '11929-7', '11930-5',
        '11931-3', '11932-1', '11933-9', '11934-7', '11935-4', '11936-2', '11937-0', '11938-8',
        '11939-6', '11940-4', '11941-2', '11942-0', '11943-8', '11944-6', '11945-3', '11946-1',
        '11947-9', '11948-7', '11949-5', '11950-3', '11951-1', '11952-9', '11954-5', '11956-0',
        '11957-8', '11962-8', '11963-6', '11964-4', '11965-1', '11966-9', '11967-7', '11968-5',
        '11969-3', '11970-1', '11971-9', '11972-7', '11973-5', '11974-3', '11975-0', '11978-4',
        '11979-2', '11980-0', '11981-8', '11982-6', '11983-4', '11984-2', '11985-9', '11986-7',
        '11987-5', '11988-3', '11989-1', '11990-9', '11991-7', '11992-5', '11993-3', '11997-4',
        '11999-0', '12003-0', '12004-8', '12005-5', '12009-7', '12012-1', '12018-8', '12019-6',
        '12020-4', '12028-7', '12029-5', '12030-3', '12031-1', '12032-9', '12033-7', '12034-5',
        '12035-2', '12036-0', '12037-8', '12038-6', '12039-4', '12040-2', '12041-0', '12042-8',
        '12043-6', '12047-7', '12048-5', '12049-3', '12050-1', '12051-9', '12052-7', '12053-5',
        '12054-3', '12055-0', '12056-8', '12057-6', '12058-4', '12059-2', '12060-0', '12061-8',
        '12062-6', '12063-4', '12064-2', '12065-9', '12066-7', '12067-5', '12068-3', '12069-1',
        '12070-9', '12071-7', '12072-5', '12073-3', '12074-1', '12075-8', '12076-6', '12077-4',
        '12078-2', '12079-0', '12080-8', '12081-6', '12082-4', '12083-2', '12084-0', '12085-7',
        '12086-5', '12087-3', '12088-1', '12089-9', '12090-7', '12091-5', '12092-3', '12093-1',
        '12094-9', '12095-6', '12096-4', '12097-2', '12098-0', '12099-8', '12100-4', '12101-2',
        '12102-0', '12103-8', '12104-6', '12105-3', '12106-1', '12107-9', '12108-7', '12109-5',
        '12110-3', '12111-1', '12112-9', '12113-7', '12114-5', '12115-2', '12116-0', '12117-8',
        '12118-6', '12119-4', '12120-2', '12121-0', '12122-8', '12123-6', '12124-4', '12125-1',
        '12128-5', '12129-3', '12130-1', '12133-5', '12135-0', '12139-2', '12140-0', '12141-8',
        '12146-7', '12147-5', '12148-3', '12149-1', '12150-9', '12151-7', '12152-5', '12153-3',
        '12154-1', '12155-8', '12162-4', '12163-2', '12166-5', '12167-3', '12168-1', '12169-9',
        '12170-7', '12171-5', '18185-9', '18847-4', '18848-2', '18849-0', '18850-8', '18851-6',
        '21299-3', '24537-3', '30707-4', '30708-2', '33068-8', '33069-6', '33070-4', '33071-2',
        '33072-0', '33073-8', '33074-6', '33075-3', '33076-1', '33077-9', '33078-7', '33079-5',
        '33080-3', '33081-1', '33082-9', '33083-7', '33084-5', '33085-2', '33086-0', '33087-8',
        '33088-6', '33089-4', '33090-2', '33091-0', '33092-8', '33093-6', '33094-4', '33095-1',
        '33096-9', '33097-7', '33098-5', '33099-3', '33100-9', '33101-7', '33102-5', '33103-3',
        '33104-1', '33105-8', '33106-6', '33107-4', '33108-2', '33109-0', '33110-8', '33111-6',
        '33112-4', '33113-2', '33114-0', '33115-7', '33116-5', '33117-3', '33118-1', '33119-9',
        '33120-7', '33121-5', '33122-3', '33123-1', '33124-9', '33125-6', '33126-4', '33127-2',
        '33128-0', '33129-8', '33130-6', '33131-4', '33132-2', '33133-0', '33134-8', '33135-5',
        '33136-3', '33137-1', '33138-9', '33139-7', '33140-5', '33141-3', '33142-1', '33143-9',
        '33144-7', '33145-4', '33146-2', '33147-0', '33148-8', '33149-6', '33150-4', '33151-2',
        '33152-0', '33153-8', '33154-6', '33155-3', '33156-1', '33157-9', '33158-7', '33159-5',
        '33160-3', '33161-1', '33162-9', '33163-7', '33164-5', '33165-2', '33166-0', '33167-8',
        '33168-6', '33169-4', '33170-2', '33172-8', '33173-6', '33174-4', '33175-1', '33176-9',
        '33177-7', '33178-5', '33179-3', '33180-1', '33181-9', '33184-3', '33185-0', '33186-8',
        '33187-6', '33188-4', '33189-2', '33190-0', '33191-8', '33196-7', '33197-5', '33198-3',
        '33199-1', '33537-2', '33538-0', '33539-8', '33540-6', '33541-4', '33542-2', '33543-0',
        '33544-8', '33545-5', '33546-3', '33556-2', '42451-5', '42452-3', '42454-9', '42464-8',
        '42465-5', '42466-3', '42467-1', '42479-6', '49035-9', '49051-6', '49052-4', '49508-5',
        '49513-5', '53655-7', '53656-5', '53657-3', '53658-1', '53659-9', '53660-7', '53667-2',
        '53668-0', '53669-8', '53670-6', '53671-4', '53672-2', '53673-0', '53674-8', '53675-5',
        '53676-3', '53677-1', '53678-9', '53679-7', '53680-5', '53681-3', '53682-1', '53683-9',
        '53684-7', '53685-4', '53686-2', '53687-0', '53688-8', '53689-6', '53690-4', '53691-2',
        '53693-8', '53695-3', '53696-1', '53697-9', '53698-7', '53699-5', '53700-1', '53701-9',
        '57067-1', '60477-7', '69391-1', '69400-0', '72221-5'
    }


class ProceduresDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1009'
    VALUE_SET_NAME = 'Procedures During Pregnancy'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '58970', '58974', '58976', '59000', '59001', '59012', '59015', '59020', '59025', '59030',
        '59050', '59051', '59070', '59072', '59074', '59076', '59100', '59120', '59121', '59130',
        '59135', '59136', '59140', '59150', '59151', '59160', '59200', '59300', '59320', '59325',
        '59350', '59412', '59414', '59430', '59525', '59812', '59820', '59821', '59830', '59840',
        '59841', '59850', '59851', '59852', '59855', '59856', '59857', '59866', '59870', '59871',
        '59897', '59898', '59899'
    }

    SNOMEDCT = {
        '10455003', '10763001', '133875007', '176833006', '176850008', '176852000', '176854004',
        '176928008', '176929000', '176996001', '177037000', '177038005', '177039002', '177042008',
        '177091002', '177100008', '177101007', '177102000', '177106002', '177107006', '177112007',
        '177122001', '177136006', '177212000', '177222006', '17744000', '18302006', '18489003',
        '215192006', '216209009', '233560009', '233561008', '236894009', '236912008', '236913003',
        '236914009', '236915005', '236952005', '236953000', '236954006', '236955007', '236956008',
        '236966000', '236987005', '236988000', '236992007', '236993002', '236994008', '237017007',
        '237025009', '240278000', '240284002', '240285001', '240286000', '240288004', '240289007',
        '240290003', '240291004', '240292006', '24068006', '243773009', '243774003', '259863001',
        '265082003', '265635006', '265642006', '26578004', '274973002', '275222009', '275223004',
        '28107008', '281568006', '281570002', '28379004', '285409006', '285416007', '285417003',
        '285434006', '287954004', '288045002', '288194000', '29682007', '302375005', '302384005',
        '303720006', '309877008', '315308008', '36708009', '386276009', '386277000', '386639001',
        '386641000', '387615001', '387616000', '387673001', '387678005', '387708002', '387709005',
        '387710000', '391896006', '391897002', '391899004', '391998006', '392000009', '398221005',
        '40704000', '408804006', '408805007', '408806008', '408807004', '408808009', '408819007',
        '408840008', '408845003', '41058005', '41059002', '41780001', '425707001', '425939004',
        '426287008', '426737000', '427230007', '427320001', '429613009', '429737004', '43096003',
        '433153009', '440148001', '443005005', '445865006', '445912000', '446135006', '446341008',
        '446934006', '447214008', '447972007', '448543003', '450563004', '45460008', '46681009',
        '5048009', '5191001', '52660002', '56620000', '61893009', '62688006', '63407004',
        '63596003', '65378009', '6708002', '69621003', '700041001', '73341009', '75456002',
        '81130000', '81855008', '82688001', '84275009', '85179000', '85548006', '87431004',
        '87663001', '88144003', '88362001', '90442009', '9221009', '9724000'
    }


class ProceduresInvolvingContraceptiveDevices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1010'
    VALUE_SET_NAME = 'Procedures Involving Contraceptive Devices'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {'11976', '57170', '58300', '58301'}

    HCPCS = {'S4981'}

    SNOMEDCT = {
        '169553002', '176749004', '176839005', '225251006', '225256001', '225257005', '236892008',
        '274042004', '275811000', '301806003', '301807007', '440668008', '442490009', '450836008',
        '46706006', '472837007', '472838002', '58391006', '65200003', '68254000'
    }


class PregnancyTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1011'
    VALUE_SET_NAME = 'Pregnancy Test'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '19080-1', '19180-9', '20415-6', '20994-0', '2106-3', '2107-1', '2110-5', '2111-3',
        '2112-1', '2113-9', '2114-7', '2115-4', '2118-8', '2119-6', '21198-7', '25372-4',
        '25373-2', '34670-0', '45194-8', '55869-2', '55870-0', '56497-1'
    }


class ComplicationsOfPregnancyChildbirthAndThePuerperium(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1012'
    VALUE_SET_NAME = 'Complications of Pregnancy, Childbirth and the Puerperium'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'O0000', 'O0001', 'O001', 'O0010', 'O0011', 'O002', 'O0020', 'O0021', 'O008', 'O0080',
        'O0081', 'O009', 'O0090', 'O0091', 'O0900', 'O0901', 'O0902', 'O0903', 'O0910', 'O0911',
        'O0912', 'O0913', 'O09211', 'O09212', 'O09213', 'O09219', 'O09291', 'O09292', 'O09293',
        'O09299', 'O0930', 'O0931', 'O0932', 'O0933', 'O0940', 'O0941', 'O0942', 'O0943', 'O09511',
        'O09512', 'O09513', 'O09519', 'O09521', 'O09522', 'O09523', 'O09529', 'O09611', 'O09612',
        'O09613', 'O09619', 'O09621', 'O09622', 'O09623', 'O09629', 'O0970', 'O0971', 'O0972',
        'O0973', 'O09811', 'O09812', 'O09813', 'O09819', 'O09821', 'O09822', 'O09823', 'O09829',
        'O09891', 'O09892', 'O09893', 'O09899', 'O0990', 'O0991', 'O0992', 'O0993', 'O09A',
        'O09A0', 'O09A1', 'O09A2', 'O09A3', 'O10011', 'O10012', 'O10013', 'O10019', 'O10111',
        'O10112', 'O10113', 'O10119', 'O10211', 'O10212', 'O10213', 'O10219', 'O10311', 'O10312',
        'O10313', 'O10319', 'O10411', 'O10412', 'O10413', 'O10419', 'O10911', 'O10912', 'O10913',
        'O10919', 'O111', 'O112', 'O113', 'O114', 'O115', 'O119', 'O1200', 'O1201', 'O1202',
        'O1203', 'O1204', 'O1205', 'O1210', 'O1211', 'O1212', 'O1213', 'O1214', 'O1215', 'O1220',
        'O1221', 'O1222', 'O1223', 'O1224', 'O1225', 'O131', 'O132', 'O133', 'O134', 'O135',
        'O139', 'O1400', 'O1402', 'O1403', 'O1404', 'O1405', 'O1410', 'O1412', 'O1413', 'O1414',
        'O1415', 'O1420', 'O1422', 'O1423', 'O1424', 'O1425', 'O1490', 'O1492', 'O1493', 'O1494',
        'O1495', 'O1500', 'O1502', 'O1503', 'O161', 'O162', 'O163', 'O164', 'O165', 'O169', 'O200',
        'O208', 'O209', 'O210', 'O211', 'O212', 'O218', 'O219', 'O2200', 'O2201', 'O2202', 'O2203',
        'O2210', 'O2211', 'O2212', 'O2213', 'O2220', 'O2221', 'O2222', 'O2223', 'O2230', 'O2231',
        'O2232', 'O2233', 'O2240', 'O2241', 'O2242', 'O2243', 'O2250', 'O2251', 'O2252', 'O2253',
        'O228X1', 'O228X2', 'O228X3', 'O228X9', 'O2290', 'O2291', 'O2292', 'O2293', 'O2300',
        'O2301', 'O2302', 'O2303', 'O2310', 'O2311', 'O2312', 'O2313', 'O2320', 'O2321', 'O2322',
        'O2323', 'O2330', 'O2331', 'O2332', 'O2333', 'O2340', 'O2341', 'O2342', 'O2343', 'O23511',
        'O23512', 'O23513', 'O23519', 'O23521', 'O23522', 'O23523', 'O23529', 'O23591', 'O23592',
        'O23593', 'O23599', 'O2390', 'O2391', 'O2392', 'O2393', 'O24011', 'O24012', 'O24013',
        'O24019', 'O24111', 'O24112', 'O24113', 'O24119', 'O24311', 'O24312', 'O24313', 'O24319',
        'O24410', 'O24414', 'O24415', 'O24419', 'O24425', 'O24435', 'O24811', 'O24812', 'O24813',
        'O24819', 'O24911', 'O24912', 'O24913', 'O24919', 'O2510', 'O2511', 'O2512', 'O2513',
        'O2600', 'O2601', 'O2602', 'O2603', 'O2610', 'O2611', 'O2612', 'O2613', 'O2620', 'O2621',
        'O2622', 'O2623', 'O2630', 'O2631', 'O2632', 'O2633', 'O2640', 'O2641', 'O2642', 'O2643',
        'O2650', 'O2651', 'O2652', 'O2653', 'O26611', 'O26612', 'O26613', 'O26619', 'O26711',
        'O26712', 'O26713', 'O26719', 'O26811', 'O26812', 'O26813', 'O26819', 'O26821', 'O26822',
        'O26823', 'O26829', 'O26831', 'O26832', 'O26833', 'O26839', 'O26841', 'O26842', 'O26843',
        'O26849', 'O26851', 'O26852', 'O26853', 'O26859', 'O2686', 'O26872', 'O26873', 'O26879',
        'O26891', 'O26892', 'O26893', 'O26899', 'O2690', 'O2691', 'O2692', 'O2693', 'O280', 'O281',
        'O282', 'O283', 'O284', 'O285', 'O288', 'O289', 'O29011', 'O29012', 'O29013', 'O29019',
        'O29021', 'O29022', 'O29023', 'O29029', 'O29091', 'O29092', 'O29093', 'O29099', 'O29111',
        'O29112', 'O29113', 'O29119', 'O29121', 'O29122', 'O29123', 'O29129', 'O29191', 'O29192',
        'O29193', 'O29199', 'O29211', 'O29212', 'O29213', 'O29219', 'O29291', 'O29292', 'O29293',
        'O29299', 'O293X1', 'O293X2', 'O293X3', 'O293X9', 'O2940', 'O2941', 'O2942', 'O2943',
        'O295X1', 'O295X2', 'O295X3', 'O295X9', 'O2960', 'O2961', 'O2962', 'O2963', 'O298X1',
        'O298X2', 'O298X3', 'O298X9', 'O2990', 'O2991', 'O2992', 'O2993', 'O30001', 'O30002',
        'O30003', 'O30009', 'O30011', 'O30012', 'O30013', 'O30019', 'O30021', 'O30022', 'O30023',
        'O30029', 'O30031', 'O30032', 'O30033', 'O30039', 'O30041', 'O30042', 'O30043', 'O30049',
        'O30091', 'O30092', 'O30093', 'O30099', 'O30101', 'O30102', 'O30103', 'O30109', 'O30111',
        'O30112', 'O30113', 'O30119', 'O30121', 'O30122', 'O30123', 'O30129', 'O30191', 'O30192',
        'O30193', 'O30199', 'O30201', 'O30202', 'O30203', 'O30209', 'O30211', 'O30212', 'O30213',
        'O30219', 'O30221', 'O30222', 'O30223', 'O30229', 'O30291', 'O30292', 'O30293', 'O30299',
        'O30801', 'O30802', 'O30803', 'O30809', 'O30811', 'O30812', 'O30813', 'O30819', 'O30821',
        'O30822', 'O30823', 'O30829', 'O30891', 'O30892', 'O30893', 'O30899', 'O3090', 'O3091',
        'O3092', 'O3093', 'O3100X0', 'O3100X1', 'O3100X2', 'O3100X3', 'O3100X4', 'O3100X5',
        'O3100X9', 'O3101X0', 'O3101X1', 'O3101X2', 'O3101X3', 'O3101X4', 'O3101X5', 'O3101X9',
        'O3102X0', 'O3102X1', 'O3102X2', 'O3102X3', 'O3102X4', 'O3102X5', 'O3102X9', 'O3103X0',
        'O3103X1', 'O3103X2', 'O3103X3', 'O3103X4', 'O3103X5', 'O3103X9', 'O3110X0', 'O3110X1',
        'O3110X2', 'O3110X3', 'O3110X4', 'O3110X5', 'O3110X9', 'O3111X0', 'O3111X1', 'O3111X2',
        'O3111X3', 'O3111X4', 'O3111X5', 'O3111X9', 'O3112X0', 'O3112X1', 'O3112X2', 'O3112X3',
        'O3112X4', 'O3112X5', 'O3112X9', 'O3113X0', 'O3113X1', 'O3113X2', 'O3113X3', 'O3113X4',
        'O3113X5', 'O3113X9', 'O3120X0', 'O3120X1', 'O3120X2', 'O3120X3', 'O3120X4', 'O3120X5',
        'O3120X9', 'O3121X0', 'O3121X1', 'O3121X2', 'O3121X3', 'O3121X4', 'O3121X5', 'O3121X9',
        'O3122X0', 'O3122X1', 'O3122X2', 'O3122X3', 'O3122X4', 'O3122X5', 'O3122X9', 'O3123X0',
        'O3123X1', 'O3123X2', 'O3123X3', 'O3123X4', 'O3123X5', 'O3123X9', 'O3130X0', 'O3130X1',
        'O3130X2', 'O3130X3', 'O3130X4', 'O3130X5', 'O3130X9', 'O3131X0', 'O3131X1', 'O3131X2',
        'O3131X3', 'O3131X4', 'O3131X5', 'O3131X9', 'O3132X0', 'O3132X1', 'O3132X2', 'O3132X3',
        'O3132X4', 'O3132X5', 'O3132X9', 'O3133X0', 'O3133X1', 'O3133X2', 'O3133X3', 'O3133X4',
        'O3133X5', 'O3133X9', 'O318X10', 'O318X11', 'O318X12', 'O318X13', 'O318X14', 'O318X15',
        'O318X19', 'O318X20', 'O318X21', 'O318X22', 'O318X23', 'O318X24', 'O318X25', 'O318X29',
        'O318X30', 'O318X31', 'O318X32', 'O318X33', 'O318X34', 'O318X35', 'O318X39', 'O318X90',
        'O318X91', 'O318X92', 'O318X93', 'O318X94', 'O318X95', 'O318X99', 'O320XX0', 'O320XX1',
        'O320XX2', 'O320XX3', 'O320XX4', 'O320XX5', 'O320XX9', 'O321XX0', 'O321XX1', 'O321XX2',
        'O321XX3', 'O321XX4', 'O321XX5', 'O321XX9', 'O322XX0', 'O322XX1', 'O322XX2', 'O322XX3',
        'O322XX4', 'O322XX5', 'O322XX9', 'O323XX0', 'O323XX1', 'O323XX2', 'O323XX3', 'O323XX4',
        'O323XX5', 'O323XX9', 'O324XX0', 'O324XX1', 'O324XX2', 'O324XX3', 'O324XX4', 'O324XX5',
        'O324XX9', 'O326XX0', 'O326XX1', 'O326XX2', 'O326XX3', 'O326XX4', 'O326XX5', 'O326XX9',
        'O328XX0', 'O328XX1', 'O328XX2', 'O328XX3', 'O328XX4', 'O328XX5', 'O328XX9', 'O329XX0',
        'O329XX1', 'O329XX2', 'O329XX3', 'O329XX4', 'O329XX5', 'O329XX9', 'O330', 'O331', 'O332',
        'O333XX0', 'O333XX1', 'O333XX2', 'O333XX3', 'O333XX4', 'O333XX5', 'O333XX9', 'O334XX0',
        'O334XX1', 'O334XX2', 'O334XX3', 'O334XX4', 'O334XX5', 'O334XX9', 'O335XX0', 'O335XX1',
        'O335XX2', 'O335XX3', 'O335XX4', 'O335XX5', 'O335XX9', 'O336XX0', 'O336XX1', 'O336XX2',
        'O336XX3', 'O336XX4', 'O336XX5', 'O336XX9', 'O337', 'O337XX0', 'O337XX1', 'O337XX2',
        'O337XX3', 'O337XX4', 'O337XX5', 'O337XX9', 'O338', 'O339', 'O3400', 'O3401', 'O3402',
        'O3403', 'O3410', 'O3411', 'O3412', 'O3413', 'O3421', 'O34211', 'O34212', 'O34219',
        'O3429', 'O3430', 'O3431', 'O3432', 'O3433', 'O3440', 'O3441', 'O3442', 'O3443', 'O34511',
        'O34512', 'O34513', 'O34519', 'O34521', 'O34522', 'O34523', 'O34529', 'O34531', 'O34532',
        'O34533', 'O34539', 'O34591', 'O34592', 'O34593', 'O34599', 'O3460', 'O3461', 'O3462',
        'O3463', 'O3470', 'O3471', 'O3472', 'O3473', 'O3480', 'O3481', 'O3482', 'O3483', 'O3490',
        'O3491', 'O3492', 'O3493', 'O350XX0', 'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4',
        'O350XX5', 'O350XX9', 'O351XX0', 'O351XX1', 'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5',
        'O351XX9', 'O352XX0', 'O352XX1', 'O352XX2', 'O352XX3', 'O352XX4', 'O352XX5', 'O352XX9',
        'O353XX0', 'O353XX1', 'O353XX2', 'O353XX3', 'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0',
        'O354XX1', 'O354XX2', 'O354XX3', 'O354XX4', 'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1',
        'O355XX2', 'O355XX3', 'O355XX4', 'O355XX5', 'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2',
        'O356XX3', 'O356XX4', 'O356XX5', 'O356XX9', 'O357XX0', 'O357XX1', 'O357XX2', 'O357XX3',
        'O357XX4', 'O357XX5', 'O357XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4',
        'O358XX5', 'O358XX9', 'O359XX0', 'O359XX1', 'O359XX2', 'O359XX3', 'O359XX4', 'O359XX5',
        'O359XX9', 'O360110', 'O360111', 'O360112', 'O360113', 'O360114', 'O360115', 'O360119',
        'O360120', 'O360121', 'O360122', 'O360123', 'O360124', 'O360125', 'O360129', 'O360130',
        'O360131', 'O360132', 'O360133', 'O360134', 'O360135', 'O360139', 'O360190', 'O360191',
        'O360192', 'O360193', 'O360194', 'O360195', 'O360199', 'O360910', 'O360911', 'O360912',
        'O360913', 'O360914', 'O360915', 'O360919', 'O360920', 'O360921', 'O360922', 'O360923',
        'O360924', 'O360925', 'O360929', 'O360930', 'O360931', 'O360932', 'O360933', 'O360934',
        'O360935', 'O360939', 'O360990', 'O360991', 'O360992', 'O360993', 'O360994', 'O360995',
        'O360999', 'O361110', 'O361111', 'O361112', 'O361113', 'O361114', 'O361115', 'O361119',
        'O361120', 'O361121', 'O361122', 'O361123', 'O361124', 'O361125', 'O361129', 'O361130',
        'O361131', 'O361132', 'O361133', 'O361134', 'O361135', 'O361139', 'O361190', 'O361191',
        'O361192', 'O361193', 'O361194', 'O361195', 'O361199', 'O361910', 'O361911', 'O361912',
        'O361913', 'O361914', 'O361915', 'O361919', 'O361920', 'O361921', 'O361922', 'O361923',
        'O361924', 'O361925', 'O361929', 'O361930', 'O361931', 'O361932', 'O361933', 'O361934',
        'O361935', 'O361939', 'O361990', 'O361991', 'O361992', 'O361993', 'O361994', 'O361995',
        'O361999', 'O3620X0', 'O3620X1', 'O3620X2', 'O3620X3', 'O3620X4', 'O3620X5', 'O3620X9',
        'O3621X0', 'O3621X1', 'O3621X2', 'O3621X3', 'O3621X4', 'O3621X5', 'O3621X9', 'O3622X0',
        'O3622X1', 'O3622X2', 'O3622X3', 'O3622X4', 'O3622X5', 'O3622X9', 'O3623X0', 'O3623X1',
        'O3623X2', 'O3623X3', 'O3623X4', 'O3623X5', 'O3623X9', 'O364XX0', 'O364XX1', 'O364XX2',
        'O364XX3', 'O364XX4', 'O364XX5', 'O364XX9', 'O365110', 'O365111', 'O365112', 'O365113',
        'O365114', 'O365115', 'O365119', 'O365120', 'O365121', 'O365122', 'O365123', 'O365124',
        'O365125', 'O365129', 'O365130', 'O365131', 'O365132', 'O365133', 'O365134', 'O365135',
        'O365139', 'O365190', 'O365191', 'O365192', 'O365193', 'O365194', 'O365195', 'O365199',
        'O365910', 'O365911', 'O365912', 'O365913', 'O365914', 'O365915', 'O365919', 'O365920',
        'O365921', 'O365922', 'O365923', 'O365924', 'O365925', 'O365929', 'O365930', 'O365931',
        'O365932', 'O365933', 'O365934', 'O365935', 'O365939', 'O365990', 'O365991', 'O365992',
        'O365993', 'O365994', 'O365995', 'O365999', 'O3660X0', 'O3660X1', 'O3660X2', 'O3660X3',
        'O3660X4', 'O3660X5', 'O3660X9', 'O3661X0', 'O3661X1', 'O3661X2', 'O3661X3', 'O3661X4',
        'O3661X5', 'O3661X9', 'O3662X0', 'O3662X1', 'O3662X2', 'O3662X3', 'O3662X4', 'O3662X5',
        'O3662X9', 'O3663X0', 'O3663X1', 'O3663X2', 'O3663X3', 'O3663X4', 'O3663X5', 'O3663X9',
        'O3670X0', 'O3670X1', 'O3670X2', 'O3670X3', 'O3670X4', 'O3670X5', 'O3670X9', 'O3671X0',
        'O3671X1', 'O3671X2', 'O3671X3', 'O3671X4', 'O3671X5', 'O3671X9', 'O3672X0', 'O3672X1',
        'O3672X2', 'O3672X3', 'O3672X4', 'O3672X5', 'O3672X9', 'O3673X0', 'O3673X1', 'O3673X2',
        'O3673X3', 'O3673X4', 'O3673X5', 'O3673X9', 'O368120', 'O368121', 'O368122', 'O368123',
        'O368124', 'O368125', 'O368129', 'O368130', 'O368131', 'O368132', 'O368133', 'O368134',
        'O368135', 'O368139', 'O368190', 'O368191', 'O368192', 'O368193', 'O368194', 'O368195',
        'O368199', 'O368210', 'O368211', 'O368212', 'O368213', 'O368214', 'O368215', 'O368219',
        'O368220', 'O368221', 'O368222', 'O368223', 'O368224', 'O368225', 'O368229', 'O368230',
        'O368231', 'O368232', 'O368233', 'O368234', 'O368235', 'O368239', 'O368290', 'O368291',
        'O368292', 'O368293', 'O368294', 'O368295', 'O368299', 'O368910', 'O368911', 'O368912',
        'O368913', 'O368914', 'O368915', 'O368919', 'O368920', 'O368921', 'O368922', 'O368923',
        'O368924', 'O368925', 'O368929', 'O368930', 'O368931', 'O368932', 'O368933', 'O368934',
        'O368935', 'O368939', 'O368990', 'O368991', 'O368992', 'O368993', 'O368994', 'O368995',
        'O368999', 'O3690X0', 'O3690X1', 'O3690X2', 'O3690X3', 'O3690X4', 'O3690X5', 'O3690X9',
        'O3691X0', 'O3691X1', 'O3691X2', 'O3691X3', 'O3691X4', 'O3691X5', 'O3691X9', 'O3692X0',
        'O3692X1', 'O3692X2', 'O3692X3', 'O3692X4', 'O3692X5', 'O3692X9', 'O3693X0', 'O3693X1',
        'O3693X2', 'O3693X3', 'O3693X4', 'O3693X5', 'O3693X9', 'O401XX0', 'O401XX1', 'O401XX2',
        'O401XX3', 'O401XX4', 'O401XX5', 'O401XX9', 'O402XX0', 'O402XX1', 'O402XX2', 'O402XX3',
        'O402XX4', 'O402XX5', 'O402XX9', 'O403XX0', 'O403XX1', 'O403XX2', 'O403XX3', 'O403XX4',
        'O403XX5', 'O403XX9', 'O409XX0', 'O409XX1', 'O409XX2', 'O409XX3', 'O409XX4', 'O409XX5',
        'O409XX9', 'O4100X0', 'O4100X1', 'O4100X2', 'O4100X3', 'O4100X4', 'O4100X5', 'O4100X9',
        'O4101X0', 'O4101X1', 'O4101X2', 'O4101X3', 'O4101X4', 'O4101X5', 'O4101X9', 'O4102X0',
        'O4102X1', 'O4102X2', 'O4102X3', 'O4102X4', 'O4102X5', 'O4102X9', 'O4103X0', 'O4103X1',
        'O4103X2', 'O4103X3', 'O4103X4', 'O4103X5', 'O4103X9', 'O411010', 'O411011', 'O411012',
        'O411013', 'O411014', 'O411015', 'O411019', 'O411020', 'O411021', 'O411022', 'O411023',
        'O411024', 'O411025', 'O411029', 'O411030', 'O411031', 'O411032', 'O411033', 'O411034',
        'O411035', 'O411039', 'O411090', 'O411091', 'O411092', 'O411093', 'O411094', 'O411095',
        'O411099', 'O411210', 'O411211', 'O411212', 'O411213', 'O411214', 'O411215', 'O411219',
        'O411220', 'O411221', 'O411222', 'O411223', 'O411224', 'O411225', 'O411229', 'O411230',
        'O411231', 'O411232', 'O411233', 'O411234', 'O411235', 'O411239', 'O411290', 'O411291',
        'O411292', 'O411293', 'O411294', 'O411295', 'O411299', 'O411410', 'O411411', 'O411412',
        'O411413', 'O411414', 'O411415', 'O411419', 'O411420', 'O411421', 'O411422', 'O411423',
        'O411424', 'O411425', 'O411429', 'O411430', 'O411431', 'O411432', 'O411433', 'O411434',
        'O411435', 'O411439', 'O411490', 'O411491', 'O411492', 'O411493', 'O411494', 'O411495',
        'O411499', 'O418X10', 'O418X11', 'O418X12', 'O418X13', 'O418X14', 'O418X15', 'O418X19',
        'O418X20', 'O418X21', 'O418X22', 'O418X23', 'O418X24', 'O418X25', 'O418X29', 'O418X30',
        'O418X31', 'O418X32', 'O418X33', 'O418X34', 'O418X35', 'O418X39', 'O418X90', 'O418X91',
        'O418X92', 'O418X93', 'O418X94', 'O418X95', 'O418X99', 'O4190X0', 'O4190X1', 'O4190X2',
        'O4190X3', 'O4190X4', 'O4190X5', 'O4190X9', 'O4191X0', 'O4191X1', 'O4191X2', 'O4191X3',
        'O4191X4', 'O4191X5', 'O4191X9', 'O4192X0', 'O4192X1', 'O4192X2', 'O4192X3', 'O4192X4',
        'O4192X5', 'O4192X9', 'O4193X0', 'O4193X1', 'O4193X2', 'O4193X3', 'O4193X4', 'O4193X5',
        'O4193X9', 'O4200', 'O42011', 'O42012', 'O42013', 'O42019', 'O4202', 'O4210', 'O42111',
        'O42112', 'O42113', 'O42119', 'O4212', 'O4290', 'O42911', 'O42912', 'O42913', 'O42919',
        'O4292', 'O43011', 'O43012', 'O43013', 'O43019', 'O43021', 'O43022', 'O43023', 'O43029',
        'O43101', 'O43102', 'O43103', 'O43109', 'O43111', 'O43112', 'O43113', 'O43119', 'O43121',
        'O43122', 'O43123', 'O43129', 'O43191', 'O43192', 'O43193', 'O43199', 'O43211', 'O43212',
        'O43213', 'O43219', 'O43221', 'O43222', 'O43223', 'O43229', 'O43231', 'O43232', 'O43233',
        'O43239', 'O43811', 'O43812', 'O43813', 'O43819', 'O43891', 'O43892', 'O43893', 'O43899',
        'O4390', 'O4391', 'O4392', 'O4393', 'O4400', 'O4401', 'O4402', 'O4403', 'O4410', 'O4411',
        'O4412', 'O4413', 'O4420', 'O4421', 'O4422', 'O4423', 'O4430', 'O4431', 'O4432', 'O4433',
        'O4440', 'O4441', 'O4442', 'O4443', 'O4450', 'O4451', 'O4452', 'O4453', 'O45001', 'O45002',
        'O45003', 'O45009', 'O45011', 'O45012', 'O45013', 'O45019', 'O45021', 'O45022', 'O45023',
        'O45029', 'O45091', 'O45092', 'O45093', 'O45099', 'O458X1', 'O458X2', 'O458X3', 'O458X9',
        'O4590', 'O4591', 'O4592', 'O4593', 'O46001', 'O46002', 'O46003', 'O46009', 'O46011',
        'O46012', 'O46013', 'O46019', 'O46021', 'O46022', 'O46023', 'O46029', 'O46091', 'O46092',
        'O46093', 'O46099', 'O468X1', 'O468X2', 'O468X3', 'O468X9', 'O4690', 'O4691', 'O4692',
        'O4693', 'O4700', 'O4702', 'O4703', 'O471', 'O479', 'O480', 'O481', 'O6000', 'O6002',
        'O6003', 'O7020', 'O7021', 'O7022', 'O7023', 'O7100', 'O7102', 'O7103', 'O88011', 'O88012',
        'O88013', 'O88019', 'O88111', 'O88112', 'O88113', 'O88119', 'O88211', 'O88212', 'O88213',
        'O88219', 'O88311', 'O88312', 'O88313', 'O88319', 'O88811', 'O88812', 'O88813', 'O88819',
        'O903', 'O91011', 'O91012', 'O91013', 'O91019', 'O91111', 'O91112', 'O91113', 'O91119',
        'O91211', 'O91212', 'O91213', 'O91219', 'O92011', 'O92012', 'O92013', 'O92019', 'O92111',
        'O92112', 'O92113', 'O92119', 'O9220', 'O9229', 'O923', 'O924', 'O925', 'O926', 'O9270',
        'O9279', 'O98011', 'O98012', 'O98013', 'O98019', 'O98111', 'O98112', 'O98113', 'O98119',
        'O98211', 'O98212', 'O98213', 'O98219', 'O98311', 'O98312', 'O98313', 'O98319', 'O98411',
        'O98412', 'O98413', 'O98419', 'O98511', 'O98512', 'O98513', 'O98519', 'O98611', 'O98612',
        'O98613', 'O98619', 'O98711', 'O98712', 'O98713', 'O98719', 'O98811', 'O98812', 'O98813',
        'O98819', 'O98911', 'O98912', 'O98913', 'O98919', 'O99011', 'O99012', 'O99013', 'O99019',
        'O99111', 'O99112', 'O99113', 'O99119', 'O99210', 'O99211', 'O99212', 'O99213', 'O99280',
        'O99281', 'O99282', 'O99283', 'O99310', 'O99311', 'O99312', 'O99313', 'O99320', 'O99321',
        'O99322', 'O99323', 'O99330', 'O99331', 'O99332', 'O99333', 'O99340', 'O99341', 'O99342',
        'O99343', 'O99350', 'O99351', 'O99352', 'O99353', 'O99411', 'O99412', 'O99413', 'O99419',
        'O99511', 'O99512', 'O99513', 'O99519', 'O99611', 'O99612', 'O99613', 'O99619', 'O99711',
        'O99712', 'O99713', 'O99719', 'O99810', 'O99820', 'O99830', 'O99840', 'O99841', 'O99842',
        'O99843', 'O9989', 'O9A111', 'O9A112', 'O9A113', 'O9A119', 'O9A211', 'O9A212', 'O9A213',
        'O9A219', 'O9A311', 'O9A312', 'O9A313', 'O9A319', 'O9A411', 'O9A412', 'O9A413', 'O9A419',
        'O9A511', 'O9A512', 'O9A513', 'O9A519', 'Z331', 'Z333', 'Z3400', 'Z3401', 'Z3402', 'Z3403',
        'Z3480', 'Z3481', 'Z3482', 'Z3483', 'Z3490', 'Z3491', 'Z3492', 'Z3493', 'Z36'
    }

    ICD9CM = {
        '630', '6310', '6318', '632', '63300', '63301', '63310', '63311', '63320', '63321',
        '63380', '63381', '63390', '63391', '63400', '63401', '63402', '63410', '63411', '63412',
        '63420', '63421', '63422', '63430', '63431', '63432', '63440', '63441', '63442', '63450',
        '63451', '63452', '63460', '63461', '63462', '63470', '63471', '63472', '63480', '63481',
        '63482', '63490', '63491', '63492', '63500', '63501', '63502', '63510', '63511', '63512',
        '63520', '63521', '63522', '63530', '63531', '63532', '63540', '63541', '63542', '63550',
        '63551', '63552', '63560', '63561', '63562', '63570', '63571', '63572', '63580', '63581',
        '63582', '63590', '63591', '63592', '63600', '63601', '63602', '63610', '63611', '63612',
        '63620', '63621', '63622', '63630', '63631', '63632', '63640', '63641', '63642', '63650',
        '63651', '63652', '63660', '63661', '63662', '63670', '63671', '63672', '63680', '63681',
        '63682', '63690', '63691', '63692', '63700', '63701', '63702', '63710', '63711', '63712',
        '63720', '63721', '63722', '63730', '63731', '63732', '63740', '63741', '63742', '63750',
        '63751', '63752', '63760', '63761', '63762', '63770', '63771', '63772', '63780', '63781',
        '63782', '63790', '63791', '63792', '6380', '6381', '6382', '6383', '6384', '6385', '6386',
        '6387', '6388', '6389', '6390', '6391', '6392', '6393', '6394', '6395', '6396', '6398',
        '6399', '64000', '64001', '64003', '64080', '64081', '64083', '64090', '64091', '64093',
        '64100', '64101', '64103', '64110', '64111', '64113', '64120', '64121', '64123', '64130',
        '64131', '64133', '64180', '64181', '64183', '64190', '64191', '64193', '64200', '64201',
        '64202', '64203', '64204', '64210', '64211', '64212', '64213', '64214', '64220', '64221',
        '64222', '64223', '64224', '64230', '64231', '64232', '64233', '64234', '64240', '64241',
        '64242', '64243', '64244', '64250', '64251', '64252', '64253', '64254', '64260', '64261',
        '64262', '64263', '64264', '64270', '64271', '64272', '64273', '64274', '64290', '64291',
        '64292', '64293', '64294', '64300', '64301', '64303', '64310', '64311', '64313', '64320',
        '64321', '64323', '64380', '64381', '64383', '64390', '64391', '64393', '64400', '64403',
        '64410', '64413', '64420', '64421', '64510', '64511', '64513', '64520', '64521', '64523',
        '64600', '64601', '64603', '64610', '64611', '64612', '64613', '64614', '64620', '64621',
        '64622', '64623', '64624', '64630', '64631', '64633', '64640', '64641', '64642', '64643',
        '64644', '64650', '64651', '64652', '64653', '64654', '64660', '64661', '64662', '64663',
        '64664', '64670', '64671', '64673', '64680', '64681', '64682', '64683', '64684', '64690',
        '64691', '64693', '64700', '64701', '64702', '64703', '64704', '64710', '64711', '64712',
        '64713', '64714', '64720', '64721', '64722', '64723', '64724', '64730', '64731', '64732',
        '64733', '64734', '64740', '64741', '64742', '64743', '64744', '64750', '64751', '64752',
        '64753', '64754', '64760', '64761', '64762', '64763', '64764', '64780', '64781', '64782',
        '64783', '64784', '64790', '64791', '64792', '64793', '64794', '64800', '64801', '64802',
        '64803', '64804', '64810', '64811', '64812', '64813', '64814', '64820', '64821', '64822',
        '64823', '64824', '64830', '64831', '64832', '64833', '64834', '64840', '64841', '64842',
        '64843', '64844', '64850', '64851', '64852', '64853', '64854', '64860', '64861', '64862',
        '64863', '64864', '64870', '64871', '64872', '64873', '64874', '64880', '64881', '64882',
        '64883', '64884', '64890', '64891', '64892', '64893', '64894', '64900', '64901', '64902',
        '64903', '64904', '64910', '64911', '64912', '64913', '64914', '64920', '64921', '64922',
        '64923', '64924', '64930', '64931', '64932', '64933', '64934', '64940', '64941', '64942',
        '64943', '64944', '64950', '64951', '64953', '64960', '64961', '64962', '64963', '64964',
        '64970', '64971', '64973', '650', '65100', '65101', '65103', '65110', '65111', '65113',
        '65120', '65121', '65123', '65130', '65131', '65133', '65140', '65141', '65143', '65150',
        '65151', '65153', '65160', '65161', '65163', '65170', '65171', '65173', '65180', '65181',
        '65183', '65190', '65191', '65193', '65200', '65201', '65203', '65210', '65211', '65213',
        '65220', '65221', '65223', '65230', '65231', '65233', '65240', '65241', '65243', '65250',
        '65251', '65253', '65260', '65261', '65263', '65270', '65271', '65273', '65280', '65281',
        '65283', '65290', '65291', '65293', '65300', '65301', '65303', '65310', '65311', '65313',
        '65320', '65321', '65323', '65330', '65331', '65333', '65340', '65341', '65343', '65350',
        '65351', '65353', '65360', '65361', '65363', '65370', '65371', '65373', '65380', '65381',
        '65383', '65390', '65391', '65393', '65400', '65401', '65402', '65403', '65404', '65410',
        '65411', '65412', '65413', '65414', '65420', '65421', '65423', '65430', '65431', '65432',
        '65433', '65434', '65440', '65441', '65442', '65443', '65444', '65450', '65451', '65452',
        '65453', '65454', '65460', '65461', '65462', '65463', '65464', '65470', '65471', '65472',
        '65473', '65474', '65480', '65481', '65482', '65483', '65484', '65490', '65491', '65492',
        '65493', '65494', '65500', '65501', '65503', '65510', '65511', '65513', '65520', '65521',
        '65523', '65530', '65531', '65533', '65540', '65541', '65543', '65550', '65551', '65553',
        '65560', '65561', '65563', '65570', '65571', '65573', '65580', '65581', '65583', '65590',
        '65591', '65593', '65600', '65601', '65603', '65610', '65611', '65613', '65620', '65621',
        '65623', '65630', '65631', '65633', '65640', '65641', '65643', '65650', '65651', '65653',
        '65660', '65661', '65663', '65670', '65671', '65673', '65680', '65681', '65683', '65690',
        '65691', '65693', '65700', '65701', '65703', '65800', '65801', '65803', '65810', '65811',
        '65813', '65820', '65821', '65823', '65830', '65831', '65833', '65840', '65841', '65843',
        '65880', '65881', '65883', '65890', '65891', '65893', '65900', '65901', '65903', '65910',
        '65911', '65913', '65920', '65921', '65923', '65930', '65931', '65933', '65940', '65941',
        '65943', '65950', '65951', '65953', '65960', '65961', '65963', '65970', '65971', '65973',
        '65980', '65981', '65983', '65990', '65991', '65993', '66000', '66001', '66003', '66010',
        '66011', '66013', '66020', '66021', '66023', '66030', '66031', '66033', '66040', '66041',
        '66043', '66050', '66051', '66053', '66060', '66061', '66063', '66070', '66071', '66073',
        '66080', '66081', '66083', '66090', '66091', '66093', '66100', '66101', '66103', '66110',
        '66111', '66113', '66120', '66121', '66123', '66130', '66131', '66133', '66140', '66141',
        '66143', '66190', '66191', '66193', '66200', '66201', '66203', '66210', '66211', '66213',
        '66220', '66221', '66223', '66230', '66231', '66233', '66300', '66301', '66303', '66310',
        '66311', '66313', '66320', '66321', '66323', '66330', '66331', '66333', '66340', '66341',
        '66343', '66350', '66351', '66353', '66360', '66361', '66363', '66380', '66381', '66383',
        '66390', '66391', '66393', '66400', '66401', '66404', '66410', '66411', '66414', '66420',
        '66421', '66424', '66430', '66431', '66434', '66440', '66441', '66444', '66450', '66451',
        '66454', '66460', '66461', '66464', '66480', '66481', '66484', '66490', '66491', '66494',
        '66500', '66501', '66503', '66510', '66511', '66520', '66522', '66524', '66530', '66531',
        '66534', '66540', '66541', '66544', '66550', '66551', '66554', '66560', '66561', '66564',
        '66570', '66571', '66572', '66574', '66580', '66581', '66582', '66583', '66584', '66590',
        '66591', '66592', '66593', '66594', '66600', '66602', '66604', '66610', '66612', '66614',
        '66620', '66622', '66624', '66630', '66632', '66634', '66700', '66702', '66704', '66710',
        '66712', '66714', '66800', '66801', '66802', '66803', '66804', '66810', '66811', '66812',
        '66813', '66814', '66820', '66821', '66822', '66823', '66824', '66880', '66881', '66882',
        '66883', '66884', '66890', '66891', '66892', '66893', '66894', '66900', '66901', '66902',
        '66903', '66904', '66910', '66911', '66912', '66913', '66914', '66920', '66921', '66922',
        '66923', '66924', '66930', '66932', '66934', '66940', '66941', '66942', '66943', '66944',
        '66950', '66951', '66960', '66961', '66970', '66971', '66980', '66981', '66982', '66983',
        '66984', '66990', '66991', '66992', '66993', '66994', '67000', '67002', '67004', '67100',
        '67101', '67102', '67103', '67104', '67110', '67111', '67112', '67113', '67114', '67120',
        '67121', '67122', '67123', '67124', '67130', '67131', '67133', '67140', '67142', '67144',
        '67150', '67151', '67152', '67153', '67154', '67180', '67181', '67182', '67183', '67184',
        '67190', '67191', '67192', '67193', '67194', '67200', '67202', '67204', '67300', '67301',
        '67302', '67303', '67304', '67310', '67311', '67312', '67313', '67314', '67320', '67321',
        '67322', '67323', '67324', '67330', '67331', '67332', '67333', '67334', '67380', '67381',
        '67382', '67383', '67384', '67400', '67401', '67402', '67403', '67404', '67410', '67412',
        '67414', '67420', '67422', '67424', '67430', '67432', '67434', '67440', '67442', '67444',
        '67450', '67451', '67452', '67453', '67454', '67480', '67482', '67484', '67490', '67492',
        '67494', '67500', '67501', '67502', '67503', '67504', '67510', '67511', '67512', '67513',
        '67514', '67520', '67521', '67522', '67523', '67524', '67580', '67581', '67582', '67583',
        '67584', '67590', '67591', '67592', '67593', '67594', '67600', '67601', '67602', '67603',
        '67604', '67610', '67611', '67612', '67613', '67614', '67620', '67621', '67622', '67623',
        '67624', '67630', '67631', '67632', '67633', '67634', '67640', '67641', '67642', '67643',
        '67644', '67650', '67651', '67652', '67653', '67654', '67660', '67661', '67662', '67663',
        '67664', '67680', '67681', '67682', '67683', '67684', '67690', '67691', '67692', '67693',
        '67694', '677', '67800', '67801', '67803', '67810', '67811', '67813', '67900', '67901',
        '67902', '67903', '67904', '67910', '67911', '67912', '67913', '67914'
    }

    SNOMEDCT = {
        '10058006', '10217006', '102872000', '102873005', '102875003', '102876002', '106004004',
        '106007006', '106008001', '106009009', '106010004', '10853001', '111451002', '111452009',
        '111453004', '111454005', '111458008', '11209007', '1125006', '11454006', '11687002',
        '11942004', '12062007', '126941005', '127365008', '127366009', '127367000', '127368005',
        '127369002', '127370001', '127371002', '127372009', '127373004', '127374005', '128077009',
        '13010001', '1343000', '13842006', '14331002', '14418008', '14918004', '15394000',
        '15504009', '1639007', '16574001', '16950007', '169560008', '169561007', '169562000',
        '169563005', '169564004', '169565003', '169566002', '169567006', '169568001', '17263003',
        '17285009', '17433009', '17618008', '17787002', '178280004', '18260003', '18606002',
        '18909006', '1938002', '19729005', '198332009', '198347000', '198609003', '198617006',
        '198620003', '198624007', '198626009', '198627000', '198903000', '198905007', '198906008',
        '198917009', '198918004', '198920001', '198922009', '198923004', '198925006', '198927003',
        '198928008', '198949009', '198951008', '198952001', '198953006', '198954000', '198965005',
        '198966006', '198967002', '198968007', '198983002', '198984008', '198985009', '198986005',
        '198997005', '198999008', '199000005', '199002002', '199003007', '199006004', '199049003',
        '199063009', '199064003', '199093003', '199094009', '199095005', '199096006', '199099004',
        '199100007', '199101006', '199102004', '199106001', '199107005', '199108000', '199109008',
        '199110003', '199111004', '199112006', '199127006', '199128001', '199129009', '199130004',
        '199139003', '199153003', '199154009', '199156006', '199157002', '199158007', '199159004',
        '199161008', '199163006', '199164000', '199165004', '199166003', '199175001', '199178004',
        '199179007', '199180005', '199181009', '199183007', '199185000', '199186004', '199187008',
        '199188003', '199192005', '199193000', '199194006', '199195007', '199203001', '199205008',
        '199293005', '199294004', '199295003', '199296002', '199305006', '199446000', '199461004',
        '199463001', '199464007', '199466009', '199468005', '199469002', '199470001', '199471002',
        '199511005', '199512003', '199513008', '199514002', '199595002', '199596001', '199597005',
        '199710008', '199711007', '199715003', '199719009', '199732004', '199745000', '199774009',
        '199775005', '199783004', '199784005', '199819004', '199821009', '199824001', '199825000',
        '199833004', '199834005', '199838008', '199839000', '199847000', '199848005', '199857004',
        '199858009', '199860006', '199862003', '199863008', '199869007', '199870008', '199874004',
        '199875003', '199880007', '199881006', '199889008', '199890004', '199895009', '199896005',
        '199916005', '199917001', '199925004', '199926003', '199930000', '199931001', '199934009',
        '199935005', '199958008', '199960005', '199961009', '199964001', '199965000', '199969006',
        '199970007', '199972004', '199974003', '199975002', '199977005', '199979008', '199980006',
        '199990003', '199991004', '199993001', '199997000', '200025008', '200030007', '200031006',
        '200046004', '200049006', '200050006', '200051005', '200052003', '200054002', '200056000',
        '200057009', '200058004', '200059007', '200061003', '200063000', '200064006', '200065007',
        '200066008', '200068009', '200069001', '200070000', '200074009', '200075005', '200077002',
        '200078007', '200080001', '200099005', '200100002', '200101003', '200102005', '200105007',
        '200106008', '200107004', '200108009', '200111005', '200112003', '200113008', '200114002',
        '200117009', '200118004', '200125006', '200164009', '200173001', '200181000', '200182007',
        '200185009', '200187001', '200190007', '200191006', '200195002', '200196001', '200204002',
        '200206000', '200207009', '200208004', '200209007', '200215007', '200216008', '200217004',
        '200218009', '200222004', '200224003', '200226001', '200227005', '200237000', '200238005',
        '200249004', '200251000', '200252007', '200253002', '200254008', '200277008', '200280009',
        '200281008', '200284000', '200286003', '200288002', '200289005', '200290001', '200291002',
        '200294005', '200295006', '200296007', '200297003', '200299000', '200301007', '200302000',
        '200303005', '200304004', '200308001', '200309009', '200310004', '200311000', '200330000',
        '200331001', '200332008', '200333003', '200337002', '200338007', '200342005', '200343000',
        '201134009', '204470001', '206070006', '206112008', '206113003', '206114009', '206115005',
        '206116006', '206117002', '206118007', '206121009', '206122002', '206123007', '206134005',
        '206137003', '206138008', '206146009', '206148005', '206149002', '206242003', '206244002',
        '20625004', '20845005', '20932005', '20956009', '21504004', '21987001', '22271007',
        '22399000', '2261009', '22846003', '23171006', '234058009', '23508005', '237186006',
        '237188007', '237189004', '237190008', '237198001', '237202004', '237206001', '237209008',
        '237233002', '237238006', '237239003', '237240001', '237241002', '237242009', '237244005',
        '237253003', '237254009', '237260009', '237261008', '237262001', '237270006', '237271005',
        '237272003', '237273008', '237274002', '237275001', '237276000', '237277009', '237279007',
        '237281009', '237282002', '237286004', '237305004', '237306003', '237307007', '237309005',
        '237310000', '237321009', '237325000', '237327008', '237328003', '237329006', '237336007',
        '237337003', '237338008', '237342006', '237343001', '237345008', '237346009', '237347000',
        '237348005', '237349002', '237350002', '237351003', '237352005', '238820002', '23885003',
        '239101008', '239102001', '239103006', '239104000', '239105004', '23960006', '24042004',
        '24082006', '24258008', '24342007', '24699006', '248985009', '249189006', '249196008',
        '249218000', '249219008', '249220002', '25053000', '25113000', '25825004', '26158002',
        '26528001', '267197003', '267199000', '267204006', '267257007', '267265005', '267266006',
        '267268007', '267271004', '267272006', '267276009', '267280004', '267282007', '267283002',
        '267284008', '267317007', '267340006', '267350007', '26840006', '26850007', '268809007',
        '268812005', '268813000', '268863005', '268864004', '268865003', '27015006', '270498000',
        '270500004', '27075004', '27214003', '27215002', '27388005', '273982004', '274117006',
        '274126009', '275412000', '275429002', '275434003', '276462003', '276881003', '27696007',
        '279225001', '280732008', '281307002', '282020008', '2858002', '28773001', '288208001',
        '288250001', '289311005', '289312003', '29057008', '290653008', '291665000', '29399001',
        '29847008', '300927001', '302929008', '302945005', '307632004', '308133005', '308134004',
        '308135003', '308136002', '308137006', '308140006', '308187004', '30850008', '31026002',
        '310592002', '310594001', '312977003', '312988009', '312989001', '312990005', '314204000',
        '31481000', '31516002', '31563000', '31601007', '32999002', '33058001', '33627001',
        '34150001', '34242002', '34262005', '34327003', '34801009', '34842007', '34981006',
        '35255008', '35347003', '35656003', '35882009', '361095003', '361096002', '36497006',
        '36697001', '37139009', '371607000', '373680009', '37618003', '38010008', '38534008',
        '387692004', '387696001', '387699008', '387700009', '38905006', '392280004', '396544001',
        '397752008', '397952002', '398019008', '398254007', '398262004', '399031001', '400170001',
        '40125005', '40193008', '402836009', '403528000', '405256006', '405733001', '405736009',
        '40609001', '41114007', '415810004', '41587001', '417426005', '41991004', '42537006',
        '42599006', '427139004', '428017002', '428165003', '428230005', '428252001', '428707000',
        '430881000', '430883002', '43715006', '442478007', '443460007', '44622003', '44772007',
        '44918005', '45307008', '46311005', '46502006', '46764007', '46894009', '47200007',
        '47236005', '47780009', '47821001', '4787007', '48194001', '48287005', '4907004',
        '49177006', '49279000', '49561003', '49815007', '5010004', '50258003', '51154004',
        '51495008', '51519001', '51920004', '52700006', '52772002', '53419009', '53443007',
        '54212005', '54449002', '54679003', '54844002', '55565007', '55581002', '5626004',
        '56272000', '56313000', '57220000', '5740008', '57630001', '57759005', '58532003',
        '58703003', '59136001', '59466002', '59795007', '5984000', '60000008', '60601008',
        '61007003', '61714007', '62023000', '62129004', '62131008', '6234006', '62377009',
        '62410004', '62583006', '62657007', '63040001', '63795001', '6383007', '64171002',
        '64229006', '64646001', '64954002', '65409004', '65727000', '6594005', '66119008',
        '66294006', '6636004', '66844003', '67229002', '67359005', '67486009', '682004', '6825008',
        '6867004', '6891008', '69270005', '69532007', '70068004', '70603007', '70964000',
        '71612002', '7245003', '7266006', '72892002', '73972002', '75022004', '7504005',
        '75836008', '75933004', '76012002', '76751001', '76771005', '77206006', '77259008',
        '77278008', '77386006', '77563000', '7768008', '78408007', '79179003', '79222000',
        '79290002', '79414005', '79586000', '79668009', '79748007', '79839005', '80002007',
        '80113008', '80856001', '81448000', '81557008', '81677009', '82634006', '82661006',
        '83074005', '83094001', '83916000', '8393005', '84007008', '84216001', '84693004',
        '85542007', '86081009', '86256001', '87038002', '87043009', '87383005', '87605005',
        '87814002', '88178009', '88697005', '88887003', '89244003', '89700002', '90009001',
        '90532005', '90968009', '9107002', '91957002', '9279009', '9293002', '9442009', '95212006',
        '95605009', '9899009'
    }


class MaternalPostPartumDepressionCare(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1013'
    VALUE_SET_NAME = 'Maternal Post Partum Depression Care'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428231000124106'}


class MaternalPostPartumDepressionScreening(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1014'
    VALUE_SET_NAME = 'Maternal Post Partum Depression Screening'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    SNOMEDCT = {'428221000124108'}


class DeliveryLiveBirths(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1015'
    VALUE_SET_NAME = 'Delivery Live Births'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    CPT = {
        '59400', '59409', '59410', '59412', '59414', '59425', '59426', '59430', '59510', '59514',
        '59515', '59525', '59610', '59612', '59614', '59618', '59620', '59622'
    }

    SNOMEDCT = {
        '10745001', '11466000', '14119008', '15413009', '16819009', '177141003', '177142005',
        '177143000', '177152009', '177157003', '177158008', '177161009', '177162002', '177164001',
        '177167008', '177168003', '177170007', '177173009', '177174003', '177175002', '177176001',
        '177179008', '177180006', '177181005', '177184002', '177185001', '177203002', '177204008',
        '177212000', '17860005', '18625004', '19390001', '22633006', '2321005', '236973005',
        '236974004', '236975003', '236976002', '236977006', '236978001', '236980007', '236981006',
        '236982004', '236983009', '236984003', '236985002', '236986001', '236987005', '236989008',
        '236991000', '236994008', '237311001', '25296001', '25828002', '26313002', '265639000',
        '274130007', '275168001', '275169009', '28542003', '287976008', '287977004', '288193006',
        '28860009', '29613008', '302382009', '302383004', '302384005', '30476003', '306727001',
        '315308008', '33807004', '359940006', '359943008', '384729004', '384730009', '38479009',
        '386622003', '387711001', '398307005', '40219000', '40704000', '40792007', '408819007',
        '41059002', '416055001', '417121007', '4504004', '450483001', '450484007', '450798003',
        '45718005', '46972000', '48204000', '5191001', '54973000', '5556001', '56620000',
        '57271003', '58705005', '61027002', '61586001', '62508004', '62688006', '65243006',
        '66201006', '69162008', '69422002', '69621003', '699999008', '700000006', '71166009',
        '72492007', '75928003', '84195007', '85403009', '89053004', '89346004', '89849000',
        '90438006'
    }


class GonococcalInfectionsAndVenerealDiseases(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1001'
    VALUE_SET_NAME = 'Gonococcal Infections and Venereal Diseases'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A5400', 'A5401', 'A5402', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424',
        'A5429', 'A5430', 'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443',
        'A5449', 'A545', 'A546', 'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489',
        'A549', 'A57', 'A58', 'A638', 'A64', 'M0230', 'M02311', 'M02312', 'M02319', 'M02321',
        'M02322', 'M02329', 'M02331', 'M02332', 'M02339', 'M02341', 'M02342', 'M02349', 'M02351',
        'M02352', 'M02359', 'M02361', 'M02362', 'M02369', 'M02371', 'M02372', 'M02379', 'M0238',
        'M0239', 'N341'
    }

    ICD9CM = {
        '0980', '09810', '09811', '09812', '09813', '09814', '09815', '09816', '09817', '09819',
        '0982', '09830', '09831', '09832', '09833', '09834', '09835', '09836', '09837', '09839',
        '09840', '09841', '09842', '09843', '09849', '09850', '09851', '09852', '09853', '09859',
        '0986', '0987', '09881', '09882', '09883', '09884', '09885', '09886', '09889', '0990',
        '0991', '0992', '0993', '09940', '09941', '09949', '09950', '09951', '09952', '09953',
        '09954', '09955', '09956', '09959', '0998', '0999'
    }

    SNOMEDCT = {
        '111806005', '111807001', '11906007', '12373006', '151004', '15628003', '17305005',
        '186915005', '186931002', '186932009', '186939000', '186946009', '197848003', '197967000',
        '199161008', '199163006', '199164000', '199165004', '199166003', '20943002', '231858009',
        '235861001', '235863003', '236682002', '236687008', '236766009', '236772009', '237038001',
        '237042003', '237046000', '237069002', '237083000', '237095000', '237096004', '238419002',
        '2390000', '23975003', '239785008', '239808004', '240039005', '240571007', '240572000',
        '240573005', '240574004', '240575003', '240576002', '240577006', '240578001', '240579009',
        '240581006', '240582004', '240602008', '240603003', '240604009', '24868007', '266138002',
        '272006008', '272262003', '27681008', '28438004', '28572009', '29864006', '30168008',
        '301990003', '307423008', '31999004', '35255008', '35526001', '35876006', '40149008',
        '402957000', '406581000', '415141001', '42746002', '44412000', '444834005', '44743006',
        '45377007', '46699001', '5085001', '50970007', '53529004', '53664003', '54825009',
        '60335002', '60893000', '61048000', '65049003', '65295003', '67224007', '74372003',
        '76802005', '80388004', '80604007', '88813005', '9091006', '9241004'
    }


class Syphilis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1002'
    VALUE_SET_NAME = 'Syphilis'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A5009', 'A501', 'A502', 'A5031', 'A5040', 'A5041', 'A5042', 'A5045', 'A5049', 'A5052',
        'A5057', 'A5059', 'A506', 'A507', 'A509', 'A510', 'A511', 'A512', 'A5131', 'A5132',
        'A5139', 'A5141', 'A5142', 'A5143', 'A5144', 'A5145', 'A5146', 'A5149', 'A515', 'A519',
        'A5200', 'A5201', 'A5202', 'A5203', 'A5204', 'A5205', 'A5206', 'A5209', 'A5210', 'A5211',
        'A5212', 'A5213', 'A5214', 'A5215', 'A5216', 'A5217', 'A5219', 'A522', 'A523', 'A5271',
        'A5272', 'A5273', 'A5274', 'A5275', 'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529',
        'A530', 'A539'
    }

    ICD9CM = {
        '0900', '0901', '0902', '0903', '09040', '09041', '09042', '09049', '0905', '0906', '0907',
        '0909', '0910', '0911', '0912', '0913', '0914', '09150', '09151', '09152', '09161',
        '09162', '09169', '0917', '09181', '09182', '09189', '0919', '0920', '0929', '0930',
        '0931', '09320', '09321', '09322', '09323', '09324', '09381', '09382', '09389', '0939',
        '0940', '0941', '0942', '0943', '09481', '09482', '09483', '09484', '09485', '09486',
        '09487', '09489', '0949', '0950', '0951', '0952', '0953', '0954', '0955', '0956', '0957',
        '0958', '0959', '096', '0970', '0971', '0979'
    }

    SNOMEDCT = {
        '10345003', '1107004', '11338007', '12232008', '13095005', '13310005', '13731006',
        '16070004', '186833000', '186842007', '186846005', '186847001', '186850003', '186854007',
        '186861006', '186863009', '186867005', '186868000', '186875004', '186877007', '186878002',
        '186899004', '186903006', '192008', '19206003', '192647003', '19290004', '193786000',
        '194907008', '194947001', '197305002', '197347003', '197348008', '197757004', '197966009',
        '198175009', '199154009', '199156006', '199157002', '199158007', '199159004', '202933002',
        '20735004', '21523006', '22386003', '230152000', '230182006', '230563005', '230735006',
        '232313005', '232367004', '233849007', '234017002', '235032001', '235062007', '235064008',
        '235065009', '23550005', '237446005', '237447001', '240552005', '240553000', '240554006',
        '240555007', '240556008', '240557004', '240558009', '240560006', '240562003', '240563008',
        '240564002', '240565001', '240566000', '240567009', '240568004', '240569007', '26039008',
        '26135000', '266125005', '266126006', '266127002', '266128007', '266130009', '266133006',
        '266136003', '27460003', '275376007', '27648007', '276700005', '278480000', '278481001',
        '28198007', '30080002', '302813001', '31015008', '31137003', '312934004', '312955002',
        '314840009', '315826004', '316841006', '32735002', '34242002', '35742006', '3589003',
        '36276008', '37028008', '371237000', '37430004', '37754005', '38523005', '39085002',
        '402940004', '402941000', '402942007', '402943002', '402944008', '402945009', '402946005',
        '402947001', '402949003', '402950003', '402951004', '405635002', '4082005', '410470003',
        '410478005', '42770003', '4359001', '444150000', '44568006', '4483005', '45058001',
        '46235002', '49923008', '50528008', '51928006', '51960003', '52414005', '54069001',
        '54274001', '55768006', '56118002', '58056005', '58227000', '58392004', '59233003',
        '59307008', '59530001', '59721007', '59934002', '60528006', '61612001', '62207008',
        '6267005', '62861003', '63751007', '64102008', '66281009', '66887000', '67125004',
        '67391006', '68764005', '69595007', '70983007', '72083004', '75299005', '76272004',
        '77028001', '77939001', '80770009', '81339006', '82323002', '82355002', '827006',
        '82959004', '83883001', '8555001', '85857008', '86028001', '86443005', '87318008',
        '88943008', '91554004', '9941009'
    }


class Chlamydia(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1003'
    VALUE_SET_NAME = 'Chlamydia'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {'A5600', 'A5601', 'A5609', 'A7489', 'A749'}

    ICD9CM = {'07888', '07988', '07998'}

    SNOMEDCT = {
        '105629000', '179101003', '186729003', '186731007', '188463006', '189312004', '197172005',
        '198176005', '236683007', '237039009', '237043008', '237084006', '237097008', '237106009',
        '240589008', '312099009', '367504009', '420910002', '426165006', '426247003', '428015005',
        '446642005', '446752000', '447353001', '447372001', '447386002', '447402003'
    }


class InflammatoryDiseasesOfFemaleReproductiveOrgans(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1004'
    VALUE_SET_NAME = 'Inflammatory Diseases of Female Reproductive Organs'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'A5602', 'A5611', 'A5900', 'A5901', 'A5902', 'A5903', 'A5909', 'A598', 'A599', 'N7001',
        'N7002', 'N7003', 'N7011', 'N7012', 'N7013', 'N7091', 'N7092', 'N7093', 'N710', 'N711',
        'N719', 'N72', 'N730', 'N731', 'N732', 'N733', 'N734', 'N735', 'N736', 'N738', 'N739',
        'N74', 'N750', 'N751', 'N758', 'N759', 'N760', 'N761', 'N762', 'N763', 'N764', 'N765',
        'N766', 'N7681', 'N7689', 'N770', 'N771'
    }

    ICD9CM = {
        '13100', '13101', '13102', '13103', '13109', '1318', '1319', '6140', '6141', '6142',
        '6143', '6144', '6145', '6146', '6147', '6148', '6149', '6150', '6151', '6159', '6160',
        '61610', '61611', '6162', '6163', '6164', '61650', '61651', '61681', '61689', '6169'
    }

    SNOMEDCT = {
        '109867008', '111418006', '12062007', '123613000', '129670002', '13125003', '14053009',
        '14248008', '14488001', '15363000', '16486000', '172001', '17716001', '188463006',
        '19272000', '19372002', '197850006', '198130006', '198133008', '198135001', '198136000',
        '198137009', '198138004', '198141008', '198142001', '198143006', '198156004', '198159006',
        '198160001', '198161002', '198175009', '198176005', '198179003', '198180000', '198182008',
        '198183003', '198184009', '198185005', '198186006', '198188007', '198189004', '198199009',
        '198203009', '198206001', '198212006', '198216009', '198217000', '198218005', '198219002',
        '198220008', '198227006', '198230004', '198231000', '198235009', '198236005', '198241002',
        '198242009', '198824009', '200181000', '200182007', '200185009', '200187001', '20932005',
        '20943002', '21711003', '21955004', '22399000', '22775002', '237037006', '237044002',
        '237045001', '237051006', '237085007', '237091009', '237093007', '237094001', '237097008',
        '237103001', '237104007', '237124006', '238921004', '24520005', '26535009', '266581008',
        '27420004', '27438001', '276877003', '278068003', '279499002', '280483007', '280486004',
        '286985001', '28783002', '289510007', '30406004', '30800001', '30806007', '30833006',
        '31354001', '314630009', '31474007', '31999004', '32582007', '32701000', '32923006',
        '33028007', '34543006', '35585004', '36742000', '371318006', '37610005', '37649008',
        '37830006', '38099005', '387681000', '387682007', '388602007', '388604008', '390897008',
        '39120007', '397810006', '398319002', '40113007', '4022007', '402314003', '402338004',
        '402375009', '402437008', '402715000', '402828000', '402890001', '402896007', '402935007',
        '403475002', '403477005', '403478000', '403479008', '403480006', '403482003', '403565003',
        '408386002', '419468003', '419760006', '4232007', '427307004', '427537009', '427786008',
        '427788009', '428193004', '428230005', '428252001', '4316006', '442506007', '443769009',
        '45022008', '46536000', '47132003', '48153009', '49249007', '49258000', '49558004',
        '51707007', '52441000', '53098006', '53200002', '53277000', '53529004', '54275000',
        '54672007', '55551005', '56321006', '56728002', '57468008', '58949002', '59211000',
        '60967006', '62394006', '62819009', '63144007', '63922003', '64150007', '65984002',
        '67624004', '67667007', '6815003', '68389001', '68640004', '6887003', '69430001',
        '70120007', '70718000', '72605008', '72934000', '73806001', '7415003', '74945001',
        '75530006', '75548002', '75585005', '75947000', '75993002', '76047005', '76151005',
        '77106003', '78623009', '7910003', '81521003', '81598001', '8258000', '83774001',
        '84194006', '85051008', '86070006', '8628002', '86709000', '87728001', '88027004',
        '88157006', '88981003', '8912009', '90206003', '91155009', '9516007', '95220008'
    }


class LowBackPain(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1001'
    VALUE_SET_NAME = 'Low Back Pain'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'M4646', 'M4647', 'M4648', 'M4726', 'M4727', 'M4728', 'M47816', 'M47817', 'M47818',
        'M47896', 'M47897', 'M47898', 'M4806', 'M4807', 'M4808', 'M5116', 'M5117', 'M5126',
        'M5127', 'M5136', 'M5137', 'M5146', 'M5147', 'M5186', 'M5187', 'M532X6', 'M532X7',
        'M532X8', 'M533', 'M5386', 'M5387', 'M5388', 'M5430', 'M5431', 'M5432', 'M5440', 'M5441',
        'M5442', 'M545', 'M5489', 'M549', 'M9903', 'M9904', 'M9923', 'M9933', 'M9943', 'M9953',
        'M9963', 'M9973', 'M9983', 'M9984', 'S33100A', 'S33100D', 'S33100S', 'S33110A', 'S33110D',
        'S33110S', 'S33120A', 'S33120D', 'S33120S', 'S33130A', 'S33130D', 'S33130S', 'S33140A',
        'S33140D', 'S33140S', 'S335XXA', 'S336XXA', 'S338XXA', 'S339XXA', 'S39002A', 'S39002D',
        'S39002S', 'S39012A', 'S39012D', 'S39012S', 'S39092A', 'S39092D', 'S39092S', 'S3982XA',
        'S3982XD', 'S3982XS', 'S3992XA', 'S3992XD', 'S3992XS'
    }

    ICD9CM = {
        '7213', '72210', '72232', '72252', '72293', '72402', '72403', '7242', '7243', '7245',
        '7246', '72470', '72471', '72479', '7385', '7393', '7394', '8460', '8461', '8462', '8463',
        '8468', '8469', '8472'
    }

    SNOMEDCT = {
        '161894002', '202794004', '247368002', '267067009', '267982002', '275316003', '278860009',
        '278862001', '279039007', '279040009', '279041008', '279042001', '279063004', '298674008',
        '300957005', '301408007'
    }


class XRayOfLowerSpine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1033'
    VALUE_SET_NAME = 'X-Ray of Lower Spine'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '24665-2', '24929-2', '24930-0', '24969-8', '24970-6', '24971-4', '24972-2', '24975-5',
        '24984-7', '30713-2', '30714-0', '30715-7', '30716-5', '30717-3', '30773-6', '30774-4',
        '30775-1', '30776-9', '30777-7', '30778-5', '30797-5', '30883-3', '30884-1', '36332-5',
        '36647-6', '36670-8', '36674-0', '36681-5', '36688-0', '36735-9', '36946-2', '36949-6',
        '36990-0', '36992-6', '37003-1', '37009-8', '37011-4', '37073-4', '37078-3', '37101-3',
        '37105-4', '37132-8', '37172-4', '37208-6', '37256-5', '37257-3', '37259-9', '37260-7',
        '37261-5', '37300-1', '37340-7', '37341-5', '37342-3', '37351-4', '37353-0', '37355-5',
        '37356-3', '37357-1', '37515-4', '37516-2', '37651-7', '37652-5', '37658-2', '37659-0',
        '37660-8', '37974-3', '37975-0', '38008-9', '38121-0', '38123-6', '38124-4', '39049-2',
        '39061-7', '39063-3', '39067-4', '39333-0', '39340-5', '39367-8', '42163-6', '42378-0',
        '42379-8', '42401-0', '42403-6', '42406-9', '42407-7', '42408-5', '42410-1', '42411-9',
        '42413-5', '42424-2', '42425-9', '42426-7', '42427-5', '42428-3', '42429-1', '42472-1',
        '42690-8', '42692-4', '43569-3', '43784-8', '43791-3', '44178-2', '44179-0', '44194-9',
        '44196-4', '44203-8', '44206-1', '46340-6', '47382-7', '47984-0', '48469-1', '48473-3',
        '69264-0', '69273-1'
    }


class MriOfLowerSpine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1034'
    VALUE_SET_NAME = 'MRI of Lower Spine'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '24967-2', '24968-0', '24977-1', '30678-7', '30679-5', '30854-4', '30855-1', '36059-4',
        '36060-2', '36100-6', '36111-3', '36246-7', '36247-5', '36391-1', '36392-9', '36521-3',
        '36522-1', '38061-8', '42698-1', '48436-0', '48452-7'
    }


class CtScanOfLowerSpine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1035'
    VALUE_SET_NAME = 'CT Scan of Lower Spine'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    LOINC = {
        '24963-1', '24964-9', '24965-6', '30620-9', '36058-6', '36069-3', '36110-5', '36245-9',
        '36390-3', '36402-6', '36520-5', '37232-6', '37288-8', '37509-7', '37653-3', '44114-7',
        '69116-2'
    }


class Trauma(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1036'
    VALUE_SET_NAME = 'Trauma'
    EXPANSION_VERSION = 'MU2 Update 2017-01-06'

    ICD10CM = {
        'S020XXA', 'S020XXB', 'S020XXD', 'S020XXG', 'S020XXK', 'S020XXS', 'S02101A', 'S02101B',
        'S02101D', 'S02101G', 'S02101K', 'S02101S', 'S02102A', 'S02102B', 'S02102D', 'S02102G',
        'S02102K', 'S02102S', 'S02109A', 'S02109B', 'S02109D', 'S02109G', 'S02109K', 'S02109S',
        'S0210XA', 'S0210XB', 'S0210XD', 'S0210XG', 'S0210XK', 'S0210XS', 'S02110A', 'S02110B',
        'S02110D', 'S02110G', 'S02110K', 'S02110S', 'S02111A', 'S02111B', 'S02111D', 'S02111G',
        'S02111K', 'S02111S', 'S02112A', 'S02112B', 'S02112D', 'S02112G', 'S02112K', 'S02112S',
        'S02113A', 'S02113B', 'S02113D', 'S02113G', 'S02113K', 'S02113S', 'S02118A', 'S02118B',
        'S02118D', 'S02118G', 'S02118K', 'S02118S', 'S02119A', 'S02119B', 'S02119D', 'S02119G',
        'S02119K', 'S02119S', 'S0211AA', 'S0211AB', 'S0211AD', 'S0211AG', 'S0211AK', 'S0211AS',
        'S0211BA', 'S0211BB', 'S0211BD', 'S0211BG', 'S0211BK', 'S0211BS', 'S0211CA', 'S0211CB',
        'S0211CD', 'S0211CG', 'S0211CK', 'S0211CS', 'S0211DA', 'S0211DB', 'S0211DD', 'S0211DG',
        'S0211DK', 'S0211DS', 'S0211EA', 'S0211EB', 'S0211ED', 'S0211EG', 'S0211EK', 'S0211ES',
        'S0211FA', 'S0211FB', 'S0211FD', 'S0211FG', 'S0211FK', 'S0211FS', 'S0211GA', 'S0211GB',
        'S0211GD', 'S0211GG', 'S0211GK', 'S0211GS', 'S0211HA', 'S0211HB', 'S0211HD', 'S0211HG',
        'S0211HK', 'S0211HS', 'S0219XA', 'S0219XB', 'S0219XD', 'S0219XG', 'S0219XK', 'S0219XS',
        'S022XXA', 'S022XXB', 'S022XXD', 'S022XXG', 'S022XXK', 'S022XXS', 'S0230XA', 'S0230XB',
        'S0230XD', 'S0230XG', 'S0230XK', 'S0230XS', 'S0231XA', 'S0231XB', 'S0231XD', 'S0231XG',
        'S0231XK', 'S0231XS', 'S0232XA', 'S0232XB', 'S0232XD', 'S0232XG', 'S0232XK', 'S0232XS',
        'S023XXA', 'S023XXB', 'S023XXD', 'S023XXG', 'S023XXK', 'S023XXS', 'S02400A', 'S02400B',
        'S02400D', 'S02400G', 'S02400K', 'S02400S', 'S02401A', 'S02401B', 'S02401D', 'S02401G',
        'S02401K', 'S02401S', 'S02402A', 'S02402B', 'S02402D', 'S02402G', 'S02402K', 'S02402S',
        'S0240AA', 'S0240AB', 'S0240AD', 'S0240AG', 'S0240AK', 'S0240AS', 'S0240BA', 'S0240BB',
        'S0240BD', 'S0240BG', 'S0240BK', 'S0240BS', 'S0240CA', 'S0240CB', 'S0240CD', 'S0240CG',
        'S0240CK', 'S0240CS', 'S0240DA', 'S0240DB', 'S0240DD', 'S0240DG', 'S0240DK', 'S0240DS',
        'S0240EA', 'S0240EB', 'S0240ED', 'S0240EG', 'S0240EK', 'S0240ES', 'S0240FA', 'S0240FB',
        'S0240FD', 'S0240FG', 'S0240FK', 'S0240FS', 'S02411A', 'S02411B', 'S02411D', 'S02411G',
        'S02411K', 'S02411S', 'S02412A', 'S02412B', 'S02412D', 'S02412G', 'S02412K', 'S02412S',
        'S02413A', 'S02413B', 'S02413D', 'S02413G', 'S02413K', 'S02413S', 'S0242XA', 'S0242XB',
        'S0242XD', 'S0242XG', 'S0242XK', 'S0242XS', 'S02600A', 'S02600B', 'S02600D', 'S02600G',
        'S02600K', 'S02600S', 'S02601A', 'S02601B', 'S02601D', 'S02601G', 'S02601K', 'S02601S',
        'S02602A', 'S02602B', 'S02602D', 'S02602G', 'S02602K', 'S02602S', 'S02609A', 'S02609B',
        'S02609D', 'S02609G', 'S02609K', 'S02609S', 'S02610A', 'S02610B', 'S02610D', 'S02610G',
        'S02610K', 'S02610S', 'S02611A', 'S02611B', 'S02611D', 'S02611G', 'S02611K', 'S02611S',
        'S02612A', 'S02612B', 'S02612D', 'S02612G', 'S02612K', 'S02612S', 'S0261XA', 'S0261XB',
        'S0261XD', 'S0261XG', 'S0261XK', 'S0261XS', 'S02620A', 'S02620B', 'S02620D', 'S02620G',
        'S02620K', 'S02620S', 'S02621A', 'S02621B', 'S02621D', 'S02621G', 'S02621K', 'S02621S',
        'S02622A', 'S02622B', 'S02622D', 'S02622G', 'S02622K', 'S02622S', 'S0262XA', 'S0262XB',
        'S0262XD', 'S0262XG', 'S0262XK', 'S0262XS', 'S02630A', 'S02630B', 'S02630D', 'S02630G',
        'S02630K', 'S02630S', 'S02631A', 'S02631B', 'S02631D', 'S02631G', 'S02631K', 'S02631S',
        'S02632A', 'S02632B', 'S02632D', 'S02632G', 'S02632K', 'S02632S', 'S0263XA', 'S0263XB',
        'S0263XD', 'S0263XG', 'S0263XK', 'S0263XS', 'S02640A', 'S02640B', 'S02640D', 'S02640G',
        'S02640K', 'S02640S', 'S02641A', 'S02641B', 'S02641D', 'S02641G', 'S02641K', 'S02641S',
        'S02642A', 'S02642B', 'S02642D', 'S02642G', 'S02642K', 'S02642S', 'S0264XA', 'S0264XB',
        'S0264XD', 'S0264XG', 'S0264XK', 'S0264XS', 'S02650A', 'S02650B', 'S02650D', 'S02650G',
        'S02650K', 'S02650S', 'S02651A', 'S02651B', 'S02651D', 'S02651G', 'S02651K', 'S02651S',
        'S02652A', 'S02652B', 'S02652D', 'S02652G', 'S02652K', 'S02652S', 'S0265XA', 'S0265XB',
        'S0265XD', 'S0265XG', 'S0265XK', 'S0265XS', 'S0266XA', 'S0266XB', 'S0266XD', 'S0266XG',
        'S0266XK', 'S0266XS', 'S02670A', 'S02670B', 'S02670D', 'S02670G', 'S02670K', 'S02670S',
        'S02671A', 'S02671B', 'S02671D', 'S02671G', 'S02671K', 'S02671S', 'S02672A', 'S02672B',
        'S02672D', 'S02672G', 'S02672K', 'S02672S', 'S0267XA', 'S0267XB', 'S0267XD', 'S0267XG',
        'S0267XK', 'S0267XS', 'S0269XA', 'S0269XB', 'S0269XD', 'S0269XG', 'S0269XK', 'S0269XS',
        'S0280XA', 'S0280XB', 'S0280XD', 'S0280XG', 'S0280XK', 'S0280XS', 'S0281XA', 'S0281XB',
        'S0281XD', 'S0281XG', 'S0281XK', 'S0281XS', 'S0282XA', 'S0282XB', 'S0282XD', 'S0282XG',
        'S0282XK', 'S0282XS', 'S028XXA', 'S028XXB', 'S028XXD', 'S028XXG', 'S028XXK', 'S028XXS',
        'S0291XA', 'S0291XB', 'S0291XD', 'S0291XG', 'S0291XK', 'S0291XS', 'S0292XA', 'S0292XB',
        'S0292XD', 'S0292XG', 'S0292XK', 'S0292XS', 'S0300XA', 'S0300XD', 'S0300XS', 'S0301XA',
        'S0301XD', 'S0301XS', 'S0302XA', 'S0302XD', 'S0302XS', 'S0303XA', 'S0303XD', 'S0303XS',
        'S030XXA', 'S030XXD', 'S030XXS', 'S031XXA', 'S031XXD', 'S031XXS', 'S060X0A', 'S060X0D',
        'S060X0S', 'S060X1A', 'S060X1D', 'S060X1S', 'S060X2A', 'S060X2D', 'S060X2S', 'S060X3A',
        'S060X3D', 'S060X3S', 'S060X4A', 'S060X4D', 'S060X4S', 'S060X5A', 'S060X5D', 'S060X5S',
        'S060X6A', 'S060X6D', 'S060X6S', 'S060X7A', 'S060X7D', 'S060X7S', 'S060X8A', 'S060X8D',
        'S060X8S', 'S060X9A', 'S060X9D', 'S060X9S', 'S061X0A', 'S061X0D', 'S061X0S', 'S061X1A',
        'S061X1D', 'S061X1S', 'S061X2A', 'S061X2D', 'S061X2S', 'S061X3A', 'S061X3D', 'S061X3S',
        'S061X4A', 'S061X4D', 'S061X4S', 'S061X5A', 'S061X5D', 'S061X5S', 'S061X6A', 'S061X6D',
        'S061X6S', 'S061X7A', 'S061X7D', 'S061X7S', 'S061X8A', 'S061X8D', 'S061X8S', 'S061X9A',
        'S061X9D', 'S061X9S', 'S062X0A', 'S062X0D', 'S062X0S', 'S062X1A', 'S062X1D', 'S062X1S',
        'S062X2A', 'S062X2D', 'S062X2S', 'S062X3A', 'S062X3D', 'S062X3S', 'S062X4A', 'S062X4D',
        'S062X4S', 'S062X5A', 'S062X5D', 'S062X5S', 'S062X6A', 'S062X6D', 'S062X6S', 'S062X7A',
        'S062X7D', 'S062X7S', 'S062X8A', 'S062X8D', 'S062X8S', 'S062X9A', 'S062X9D', 'S062X9S',
        'S06300A', 'S06300D', 'S06300S', 'S06301A', 'S06301D', 'S06301S', 'S06302A', 'S06302D',
        'S06302S', 'S06303A', 'S06303D', 'S06303S', 'S06304A', 'S06304D', 'S06304S', 'S06305A',
        'S06305D', 'S06305S', 'S06306A', 'S06306D', 'S06306S', 'S06307A', 'S06307D', 'S06307S',
        'S06308A', 'S06308D', 'S06308S', 'S06309A', 'S06309D', 'S06309S', 'S06310A', 'S06310D',
        'S06310S', 'S06311A', 'S06311D', 'S06311S', 'S06312A', 'S06312D', 'S06312S', 'S06313A',
        'S06313D', 'S06313S', 'S06314A', 'S06314D', 'S06314S', 'S06315A', 'S06315D', 'S06315S',
        'S06316A', 'S06316D', 'S06316S', 'S06317A', 'S06317D', 'S06317S', 'S06318A', 'S06318D',
        'S06318S', 'S06319A', 'S06319D', 'S06319S', 'S06320A', 'S06320D', 'S06320S', 'S06321A',
        'S06321D', 'S06321S', 'S06322A', 'S06322D', 'S06322S', 'S06323A', 'S06323D', 'S06323S',
        'S06324A', 'S06324D', 'S06324S', 'S06325A', 'S06325D', 'S06325S', 'S06326A', 'S06326D',
        'S06326S', 'S06327A', 'S06327D', 'S06327S', 'S06328A', 'S06328D', 'S06328S', 'S06329A',
        'S06329D', 'S06329S', 'S06330A', 'S06330D', 'S06330S', 'S06331A', 'S06331D', 'S06331S',
        'S06332A', 'S06332D', 'S06332S', 'S06333A', 'S06333D', 'S06333S', 'S06334A', 'S06334D',
        'S06334S', 'S06335A', 'S06335D', 'S06335S', 'S06336A', 'S06336D', 'S06336S', 'S06337A',
        'S06337D', 'S06337S', 'S06338A', 'S06338D', 'S06338S', 'S06339A', 'S06339D', 'S06339S',
        'S06340A', 'S06340D', 'S06340S', 'S06341A', 'S06341D', 'S06341S', 'S06342A', 'S06342D',
        'S06342S', 'S06343A', 'S06343D', 'S06343S', 'S06344A', 'S06344D', 'S06344S', 'S06345A',
        'S06345D', 'S06345S', 'S06346A', 'S06346D', 'S06346S', 'S06347A', 'S06347D', 'S06347S',
        'S06348A', 'S06348D', 'S06348S', 'S06349A', 'S06349D', 'S06349S', 'S06350A', 'S06350D',
        'S06350S', 'S06351A', 'S06351D', 'S06351S', 'S06352A', 'S06352D', 'S06352S', 'S06353A',
        'S06353D', 'S06353S', 'S06354A', 'S06354D', 'S06354S', 'S06355A', 'S06355D', 'S06355S',
        'S06356A', 'S06356D', 'S06356S', 'S06357A', 'S06357D', 'S06357S', 'S06358A', 'S06358D',
        'S06358S', 'S06359A', 'S06359D', 'S06359S', 'S06360A', 'S06360D', 'S06360S', 'S06361A',
        'S06361D', 'S06361S', 'S06362A', 'S06362D', 'S06362S', 'S06363A', 'S06363D', 'S06363S',
        'S06364A', 'S06364D', 'S06364S', 'S06365A', 'S06365D', 'S06365S', 'S06366A', 'S06366D',
        'S06366S', 'S06367A', 'S06367D', 'S06367S', 'S06368A', 'S06368D', 'S06368S', 'S06369A',
        'S06369D', 'S06369S', 'S06370A', 'S06370D', 'S06370S', 'S06371A', 'S06371D', 'S06371S',
        'S06372A', 'S06372D', 'S06372S', 'S06373A', 'S06373D', 'S06373S', 'S06374A', 'S06374D',
        'S06374S', 'S06375A', 'S06375D', 'S06375S', 'S06376A', 'S06376D', 'S06376S', 'S06377A',
        'S06377D', 'S06377S', 'S06378A', 'S06378D', 'S06378S', 'S06379A', 'S06379D', 'S06379S',
        'S06380A', 'S06380D', 'S06380S', 'S06381A', 'S06381D', 'S06381S', 'S06382A', 'S06382D',
        'S06382S', 'S06383A', 'S06383D', 'S06383S', 'S06384A', 'S06384D', 'S06384S', 'S06385A',
        'S06385D', 'S06385S', 'S06386A', 'S06386D', 'S06386S', 'S06387A', 'S06387D', 'S06387S',
        'S06388A', 'S06388D', 'S06388S', 'S06389A', 'S06389D', 'S06389S', 'S064X0A', 'S064X0D',
        'S064X0S', 'S064X1A', 'S064X1D', 'S064X1S', 'S064X2A', 'S064X2D', 'S064X2S', 'S064X3A',
        'S064X3D', 'S064X3S', 'S064X4A', 'S064X4D', 'S064X4S', 'S064X5A', 'S064X5D', 'S064X5S',
        'S064X6A', 'S064X6D', 'S064X6S', 'S064X7A', 'S064X7D', 'S064X7S', 'S064X8A', 'S064X8D',
        'S064X8S', 'S064X9A', 'S064X9D', 'S064X9S', 'S065X0A', 'S065X0D', 'S065X0S', 'S065X1A',
        'S065X1D', 'S065X1S', 'S065X2A', 'S065X2D', 'S065X2S', 'S065X3A', 'S065X3D', 'S065X3S',
        'S065X4A', 'S065X4D', 'S065X4S', 'S065X5A', 'S065X5D', 'S065X5S', 'S065X6A', 'S065X6D',
        'S065X6S', 'S065X7A', 'S065X7D', 'S065X7S', 'S065X8A', 'S065X8D', 'S065X8S', 'S065X9A',
        'S065X9D', 'S065X9S', 'S066X0A', 'S066X0D', 'S066X0S', 'S066X1A', 'S066X1D', 'S066X1S',
        'S066X2A', 'S066X2D', 'S066X2S', 'S066X3A', 'S066X3D', 'S066X3S', 'S066X4A', 'S066X4D',
        'S066X4S', 'S066X5A', 'S066X5D', 'S066X5S', 'S066X6A', 'S066X6D', 'S066X6S', 'S066X7A',
        'S066X7D', 'S066X7S', 'S066X8A', 'S066X8D', 'S066X8S', 'S066X9A', 'S066X9D', 'S066X9S',
        'S06810A', 'S06810D', 'S06810S', 'S06811A', 'S06811D', 'S06811S', 'S06812A', 'S06812D',
        'S06812S', 'S06813A', 'S06813D', 'S06813S', 'S06814A', 'S06814D', 'S06814S', 'S06815A',
        'S06815D', 'S06815S', 'S06816A', 'S06816D', 'S06816S', 'S06817A', 'S06817D', 'S06817S',
        'S06818A', 'S06818D', 'S06818S', 'S06819A', 'S06819D', 'S06819S', 'S06820A', 'S06820D',
        'S06820S', 'S06821A', 'S06821D', 'S06821S', 'S06822A', 'S06822D', 'S06822S', 'S06823A',
        'S06823D', 'S06823S', 'S06824A', 'S06824D', 'S06824S', 'S06825A', 'S06825D', 'S06825S',
        'S06826A', 'S06826D', 'S06826S', 'S06827A', 'S06827D', 'S06827S', 'S06828A', 'S06828D',
        'S06828S', 'S06829A', 'S06829D', 'S06829S', 'S06890A', 'S06890D', 'S06890S', 'S06891A',
        'S06891D', 'S06891S', 'S06892A', 'S06892D', 'S06892S', 'S06893A', 'S06893D', 'S06893S',
        'S06894A', 'S06894D', 'S06894S', 'S06895A', 'S06895D', 'S06895S', 'S06896A', 'S06896D',
        'S06896S', 'S06897A', 'S06897D', 'S06897S', 'S06898A', 'S06898D', 'S06898S', 'S06899A',
        'S06899D', 'S06899S', 'S069X0A', 'S069X0D', 'S069X0S', 'S069X1A', 'S069X1D', 'S069X1S',
        'S069X2A', 'S069X2D', 'S069X2S', 'S069X3A', 'S069X3D', 'S069X3S', 'S069X4A', 'S069X4D',
        'S069X4S', 'S069X5A', 'S069X5D', 'S069X5S', 'S069X6A', 'S069X6D', 'S069X6S', 'S069X7A',
        'S069X7D', 'S069X7S', 'S069X8A', 'S069X8D', 'S069X8S', 'S069X9A', 'S069X9D', 'S069X9S',
        'S12000A', 'S12000B', 'S12000D', 'S12000G', 'S12000K', 'S12000S', 'S12001A', 'S12001B',
        'S12001D', 'S12001G', 'S12001K', 'S12001S', 'S1201XA', 'S1201XB', 'S1201XD', 'S1201XG',
        'S1201XK', 'S1201XS', 'S1202XA', 'S1202XB', 'S1202XD', 'S1202XG', 'S1202XK', 'S1202XS',
        'S12030A', 'S12030B', 'S12030D', 'S12030G', 'S12030K', 'S12030S', 'S12031A', 'S12031B',
        'S12031D', 'S12031G', 'S12031K', 'S12031S', 'S12040A', 'S12040B', 'S12040D', 'S12040G',
        'S12040K', 'S12040S', 'S12041A', 'S12041B', 'S12041D', 'S12041G', 'S12041K', 'S12041S',
        'S12090A', 'S12090B', 'S12090D', 'S12090G', 'S12090K', 'S12090S', 'S12091A', 'S12091B',
        'S12091D', 'S12091G', 'S12091K', 'S12091S', 'S12100A', 'S12100B', 'S12100D', 'S12100G',
        'S12100K', 'S12100S', 'S12101A', 'S12101B', 'S12101D', 'S12101G', 'S12101K', 'S12101S',
        'S12110A', 'S12110B', 'S12110D', 'S12110G', 'S12110K', 'S12110S', 'S12111A', 'S12111B',
        'S12111D', 'S12111G', 'S12111K', 'S12111S', 'S12112A', 'S12112B', 'S12112D', 'S12112G',
        'S12112K', 'S12112S', 'S12120A', 'S12120B', 'S12120D', 'S12120G', 'S12120K', 'S12120S',
        'S12121A', 'S12121B', 'S12121D', 'S12121G', 'S12121K', 'S12121S', 'S12130A', 'S12130B',
        'S12130D', 'S12130G', 'S12130K', 'S12130S', 'S12131A', 'S12131B', 'S12131D', 'S12131G',
        'S12131K', 'S12131S', 'S1214XA', 'S1214XB', 'S1214XD', 'S1214XG', 'S1214XK', 'S1214XS',
        'S12150A', 'S12150B', 'S12150D', 'S12150G', 'S12150K', 'S12150S', 'S12151A', 'S12151B',
        'S12151D', 'S12151G', 'S12151K', 'S12151S', 'S12190A', 'S12190B', 'S12190D', 'S12190G',
        'S12190K', 'S12190S', 'S12191A', 'S12191B', 'S12191D', 'S12191G', 'S12191K', 'S12191S',
        'S12200A', 'S12200B', 'S12200D', 'S12200G', 'S12200K', 'S12200S', 'S12201A', 'S12201B',
        'S12201D', 'S12201G', 'S12201K', 'S12201S', 'S12230A', 'S12230B', 'S12230D', 'S12230G',
        'S12230K', 'S12230S', 'S12231A', 'S12231B', 'S12231D', 'S12231G', 'S12231K', 'S12231S',
        'S1224XA', 'S1224XB', 'S1224XD', 'S1224XG', 'S1224XK', 'S1224XS', 'S12250A', 'S12250B',
        'S12250D', 'S12250G', 'S12250K', 'S12250S', 'S12251A', 'S12251B', 'S12251D', 'S12251G',
        'S12251K', 'S12251S', 'S12290A', 'S12290B', 'S12290D', 'S12290G', 'S12290K', 'S12290S',
        'S12291A', 'S12291B', 'S12291D', 'S12291G', 'S12291K', 'S12291S', 'S12300A', 'S12300B',
        'S12300D', 'S12300G', 'S12300K', 'S12300S', 'S12301A', 'S12301B', 'S12301D', 'S12301G',
        'S12301K', 'S12301S', 'S12330A', 'S12330B', 'S12330D', 'S12330G', 'S12330K', 'S12330S',
        'S12331A', 'S12331B', 'S12331D', 'S12331G', 'S12331K', 'S12331S', 'S1234XA', 'S1234XB',
        'S1234XD', 'S1234XG', 'S1234XK', 'S1234XS', 'S12350A', 'S12350B', 'S12350D', 'S12350G',
        'S12350K', 'S12350S', 'S12351A', 'S12351B', 'S12351D', 'S12351G', 'S12351K', 'S12351S',
        'S12390A', 'S12390B', 'S12390D', 'S12390G', 'S12390K', 'S12390S', 'S12391A', 'S12391B',
        'S12391D', 'S12391G', 'S12391K', 'S12391S', 'S12400A', 'S12400B', 'S12400D', 'S12400G',
        'S12400K', 'S12400S', 'S12401A', 'S12401B', 'S12401D', 'S12401G', 'S12401K', 'S12401S',
        'S12430A', 'S12430B', 'S12430D', 'S12430G', 'S12430K', 'S12430S', 'S12431A', 'S12431B',
        'S12431D', 'S12431G', 'S12431K', 'S12431S', 'S1244XA', 'S1244XB', 'S1244XD', 'S1244XG',
        'S1244XK', 'S1244XS', 'S12450A', 'S12450B', 'S12450D', 'S12450G', 'S12450K', 'S12450S',
        'S12451A', 'S12451B', 'S12451D', 'S12451G', 'S12451K', 'S12451S', 'S12490A', 'S12490B',
        'S12490D', 'S12490G', 'S12490K', 'S12490S', 'S12491A', 'S12491B', 'S12491D', 'S12491G',
        'S12491K', 'S12491S', 'S12500A', 'S12500B', 'S12500D', 'S12500G', 'S12500K', 'S12500S',
        'S12501A', 'S12501B', 'S12501D', 'S12501G', 'S12501K', 'S12501S', 'S12530A', 'S12530B',
        'S12530D', 'S12530G', 'S12530K', 'S12530S', 'S12531A', 'S12531B', 'S12531D', 'S12531G',
        'S12531K', 'S12531S', 'S1254XA', 'S1254XB', 'S1254XD', 'S1254XG', 'S1254XK', 'S1254XS',
        'S12550A', 'S12550B', 'S12550D', 'S12550G', 'S12550K', 'S12550S', 'S12551A', 'S12551B',
        'S12551D', 'S12551G', 'S12551K', 'S12551S', 'S12590A', 'S12590B', 'S12590D', 'S12590G',
        'S12590K', 'S12590S', 'S12591A', 'S12591B', 'S12591D', 'S12591G', 'S12591K', 'S12591S',
        'S12600A', 'S12600B', 'S12600D', 'S12600G', 'S12600K', 'S12600S', 'S12601A', 'S12601B',
        'S12601D', 'S12601G', 'S12601K', 'S12601S', 'S12630A', 'S12630B', 'S12630D', 'S12630G',
        'S12630K', 'S12630S', 'S12631A', 'S12631B', 'S12631D', 'S12631G', 'S12631K', 'S12631S',
        'S1264XA', 'S1264XB', 'S1264XD', 'S1264XG', 'S1264XK', 'S1264XS', 'S12650A', 'S12650B',
        'S12650D', 'S12650G', 'S12650K', 'S12650S', 'S12651A', 'S12651B', 'S12651D', 'S12651G',
        'S12651K', 'S12651S', 'S12690A', 'S12690B', 'S12690D', 'S12690G', 'S12690K', 'S12690S',
        'S12691A', 'S12691B', 'S12691D', 'S12691G', 'S12691K', 'S12691S', 'S128XXA', 'S128XXD',
        'S128XXS', 'S129XXA', 'S129XXD', 'S129XXS', 'S130XXA', 'S130XXD', 'S130XXS', 'S13101A',
        'S13101D', 'S13101S', 'S13111A', 'S13111D', 'S13111S', 'S13121A', 'S13121D', 'S13121S',
        'S13131A', 'S13131D', 'S13131S', 'S13141A', 'S13141D', 'S13141S', 'S13151A', 'S13151D',
        'S13151S', 'S13161A', 'S13161D', 'S13161S', 'S13171A', 'S13171D', 'S13171S', 'S13181A',
        'S13181D', 'S13181S', 'S1320XA', 'S1320XD', 'S1320XS', 'S1329XA', 'S1329XD', 'S1329XS',
        'S14111A', 'S14111D', 'S14111S', 'S14112A', 'S14112D', 'S14112S', 'S14113A', 'S14113D',
        'S14113S', 'S14114A', 'S14114D', 'S14114S', 'S14115A', 'S14115D', 'S14115S', 'S14116A',
        'S14116D', 'S14116S', 'S14117A', 'S14117D', 'S14117S', 'S14118A', 'S14118D', 'S14118S',
        'S14119A', 'S14119D', 'S14119S', 'S14121A', 'S14121D', 'S14121S', 'S14122A', 'S14122D',
        'S14122S', 'S14123A', 'S14123D', 'S14123S', 'S14124A', 'S14124D', 'S14124S', 'S14125A',
        'S14125D', 'S14125S', 'S14126A', 'S14126D', 'S14126S', 'S14127A', 'S14127D', 'S14127S',
        'S14128A', 'S14128D', 'S14128S', 'S14129A', 'S14129D', 'S14129S', 'S14131A', 'S14131D',
        'S14131S', 'S14132A', 'S14132D', 'S14132S', 'S14133A', 'S14133D', 'S14133S', 'S14134A',
        'S14134D', 'S14134S', 'S14135A', 'S14135D', 'S14135S', 'S14136A', 'S14136D', 'S14136S',
        'S14137A', 'S14137D', 'S14137S', 'S14138A', 'S14138D', 'S14138S', 'S14139A', 'S14139D',
        'S14139S', 'S14141A', 'S14141D', 'S14141S', 'S14142A', 'S14142D', 'S14142S', 'S14143A',
        'S14143D', 'S14143S', 'S14144A', 'S14144D', 'S14144S', 'S14145A', 'S14145D', 'S14145S',
        'S14146A', 'S14146D', 'S14146S', 'S14147A', 'S14147D', 'S14147S', 'S14148A', 'S14148D',
        'S14148S', 'S14149A', 'S14149D', 'S14149S', 'S14151A', 'S14151D', 'S14151S', 'S14152A',
        'S14152D', 'S14152S', 'S14153A', 'S14153D', 'S14153S', 'S14154A', 'S14154D', 'S14154S',
        'S14155A', 'S14155D', 'S14155S', 'S14156A', 'S14156D', 'S14156S', 'S14157A', 'S14157D',
        'S14157S', 'S14158A', 'S14158D', 'S14158S', 'S14159A', 'S14159D', 'S14159S', 'S21301A',
        'S21301D', 'S21301S', 'S21302A', 'S21302D', 'S21302S', 'S21309A', 'S21309D', 'S21309S',
        'S21311A', 'S21311D', 'S21311S', 'S21312A', 'S21312D', 'S21312S', 'S21319A', 'S21319D',
        'S21319S', 'S21321A', 'S21321D', 'S21321S', 'S21322A', 'S21322D', 'S21322S', 'S21329A',
        'S21329D', 'S21329S', 'S21331A', 'S21331D', 'S21331S', 'S21332A', 'S21332D', 'S21332S',
        'S21339A', 'S21339D', 'S21339S', 'S21341A', 'S21341D', 'S21341S', 'S21342A', 'S21342D',
        'S21342S', 'S21349A', 'S21349D', 'S21349S', 'S21351A', 'S21351D', 'S21351S', 'S21352A',
        'S21352D', 'S21352S', 'S21359A', 'S21359D', 'S21359S', 'S21401A', 'S21401D', 'S21401S',
        'S21402A', 'S21402D', 'S21402S', 'S21409A', 'S21409D', 'S21409S', 'S21411A', 'S21411D',
        'S21411S', 'S21412A', 'S21412D', 'S21412S', 'S21419A', 'S21419D', 'S21419S', 'S21421A',
        'S21421D', 'S21421S', 'S21422A', 'S21422D', 'S21422S', 'S21429A', 'S21429D', 'S21429S',
        'S21431A', 'S21431D', 'S21431S', 'S21432A', 'S21432D', 'S21432S', 'S21439A', 'S21439D',
        'S21439S', 'S21441A', 'S21441D', 'S21441S', 'S21442A', 'S21442D', 'S21442S', 'S21449A',
        'S21449D', 'S21449S', 'S21451A', 'S21451D', 'S21451S', 'S21452A', 'S21452D', 'S21452S',
        'S21459A', 'S21459D', 'S21459S', 'S22000A', 'S22000B', 'S22000D', 'S22000G', 'S22000K',
        'S22000S', 'S22001A', 'S22001B', 'S22001D', 'S22001G', 'S22001K', 'S22001S', 'S22002A',
        'S22002B', 'S22002D', 'S22002G', 'S22002K', 'S22002S', 'S22008A', 'S22008B', 'S22008D',
        'S22008G', 'S22008K', 'S22008S', 'S22009A', 'S22009B', 'S22009D', 'S22009G', 'S22009K',
        'S22009S', 'S22010A', 'S22010B', 'S22010D', 'S22010G', 'S22010K', 'S22010S', 'S22011A',
        'S22011B', 'S22011D', 'S22011G', 'S22011K', 'S22011S', 'S22012A', 'S22012B', 'S22012D',
        'S22012G', 'S22012K', 'S22012S', 'S22018A', 'S22018B', 'S22018D', 'S22018G', 'S22018K',
        'S22018S', 'S22019A', 'S22019B', 'S22019D', 'S22019G', 'S22019K', 'S22019S', 'S22020A',
        'S22020B', 'S22020D', 'S22020G', 'S22020K', 'S22020S', 'S22021A', 'S22021B', 'S22021D',
        'S22021G', 'S22021K', 'S22021S', 'S22022A', 'S22022B', 'S22022D', 'S22022G', 'S22022K',
        'S22022S', 'S22028A', 'S22028B', 'S22028D', 'S22028G', 'S22028K', 'S22028S', 'S22029A',
        'S22029B', 'S22029D', 'S22029G', 'S22029K', 'S22029S', 'S22030A', 'S22030B', 'S22030D',
        'S22030G', 'S22030K', 'S22030S', 'S22031A', 'S22031B', 'S22031D', 'S22031G', 'S22031K',
        'S22031S', 'S22032A', 'S22032B', 'S22032D', 'S22032G', 'S22032K', 'S22032S', 'S22038A',
        'S22038B', 'S22038D', 'S22038G', 'S22038K', 'S22038S', 'S22039A', 'S22039B', 'S22039D',
        'S22039G', 'S22039K', 'S22039S', 'S22040A', 'S22040B', 'S22040D', 'S22040G', 'S22040K',
        'S22040S', 'S22041A', 'S22041B', 'S22041D', 'S22041G', 'S22041K', 'S22041S', 'S22042A',
        'S22042B', 'S22042D', 'S22042G', 'S22042K', 'S22042S', 'S22048A', 'S22048B', 'S22048D',
        'S22048G', 'S22048K', 'S22048S', 'S22049A', 'S22049B', 'S22049D', 'S22049G', 'S22049K',
        'S22049S', 'S22050A', 'S22050B', 'S22050D', 'S22050G', 'S22050K', 'S22050S', 'S22051A',
        'S22051B', 'S22051D', 'S22051G', 'S22051K', 'S22051S', 'S22052A', 'S22052B', 'S22052D',
        'S22052G', 'S22052K', 'S22052S', 'S22058A', 'S22058B', 'S22058D', 'S22058G', 'S22058K',
        'S22058S', 'S22059A', 'S22059B', 'S22059D', 'S22059G', 'S22059K', 'S22059S', 'S22060A',
        'S22060B', 'S22060D', 'S22060G', 'S22060K', 'S22060S', 'S22061A', 'S22061B', 'S22061D',
        'S22061G', 'S22061K', 'S22061S', 'S22062A', 'S22062B', 'S22062D', 'S22062G', 'S22062K',
        'S22062S', 'S22068A', 'S22068B', 'S22068D', 'S22068G', 'S22068K', 'S22068S', 'S22069A',
        'S22069B', 'S22069D', 'S22069G', 'S22069K', 'S22069S', 'S22070A', 'S22070B', 'S22070D',
        'S22070G', 'S22070K', 'S22070S', 'S22071A', 'S22071B', 'S22071D', 'S22071G', 'S22071K',
        'S22071S', 'S22072A', 'S22072B', 'S22072D', 'S22072G', 'S22072K', 'S22072S', 'S22078A',
        'S22078B', 'S22078D', 'S22078G', 'S22078K', 'S22078S', 'S22079A', 'S22079B', 'S22079D',
        'S22079G', 'S22079K', 'S22079S', 'S22080A', 'S22080B', 'S22080D', 'S22080G', 'S22080K',
        'S22080S', 'S22081A', 'S22081B', 'S22081D', 'S22081G', 'S22081K', 'S22081S', 'S22082A',
        'S22082B', 'S22082D', 'S22082G', 'S22082K', 'S22082S', 'S22088A', 'S22088B', 'S22088D',
        'S22088G', 'S22088K', 'S22088S', 'S22089A', 'S22089B', 'S22089D', 'S22089G', 'S22089K',
        'S22089S', 'S2220XA', 'S2220XB', 'S2220XD', 'S2220XG', 'S2220XK', 'S2220XS', 'S2221XA',
        'S2221XB', 'S2221XD', 'S2221XG', 'S2221XK', 'S2221XS', 'S2222XA', 'S2222XB', 'S2222XD',
        'S2222XG', 'S2222XK', 'S2222XS', 'S2223XA', 'S2223XB', 'S2223XD', 'S2223XG', 'S2223XK',
        'S2223XS', 'S2224XA', 'S2224XB', 'S2224XD', 'S2224XG', 'S2224XK', 'S2224XS', 'S2231XA',
        'S2231XB', 'S2231XD', 'S2231XG', 'S2231XK', 'S2231XS', 'S2232XA', 'S2232XB', 'S2232XD',
        'S2232XG', 'S2232XK', 'S2232XS', 'S2239XA', 'S2239XB', 'S2239XD', 'S2239XG', 'S2239XK',
        'S2239XS', 'S2241XA', 'S2241XB', 'S2241XD', 'S2241XG', 'S2241XK', 'S2241XS', 'S2242XA',
        'S2242XB', 'S2242XD', 'S2242XG', 'S2242XK', 'S2242XS', 'S2243XA', 'S2243XB', 'S2243XD',
        'S2243XG', 'S2243XK', 'S2243XS', 'S2249XA', 'S2249XB', 'S2249XD', 'S2249XG', 'S2249XK',
        'S2249XS', 'S225XXA', 'S225XXB', 'S225XXD', 'S225XXG', 'S225XXK', 'S225XXS', 'S229XXA',
        'S229XXB', 'S229XXD', 'S229XXG', 'S229XXK', 'S229XXS', 'S230XXA', 'S230XXD', 'S230XXS',
        'S23101A', 'S23101D', 'S23101S', 'S23111A', 'S23111D', 'S23111S', 'S23121A', 'S23121D',
        'S23121S', 'S23123A', 'S23123D', 'S23123S', 'S23131A', 'S23131D', 'S23131S', 'S23133A',
        'S23133D', 'S23133S', 'S23141A', 'S23141D', 'S23141S', 'S23143A', 'S23143D', 'S23143S',
        'S23151A', 'S23151D', 'S23151S', 'S23153A', 'S23153D', 'S23153S', 'S23161A', 'S23161D',
        'S23161S', 'S23163A', 'S23163D', 'S23163S', 'S23171A', 'S23171D', 'S23171S', 'S2320XA',
        'S2320XD', 'S2320XS', 'S2329XA', 'S2329XD', 'S2329XS', 'S240XXA', 'S240XXD', 'S240XXS',
        'S24111A', 'S24111D', 'S24111S', 'S24112A', 'S24112D', 'S24112S', 'S24113A', 'S24113D',
        'S24113S', 'S24114A', 'S24114D', 'S24114S', 'S24119A', 'S24119D', 'S24119S', 'S24131A',
        'S24131D', 'S24131S', 'S24132A', 'S24132D', 'S24132S', 'S24133A', 'S24133D', 'S24133S',
        'S24134A', 'S24134D', 'S24134S', 'S24139A', 'S24139D', 'S24139S', 'S24141A', 'S24141D',
        'S24141S', 'S24142A', 'S24142D', 'S24142S', 'S24143A', 'S24143D', 'S24143S', 'S24144A',
        'S24144D', 'S24144S', 'S24149A', 'S24149D', 'S24149S', 'S24151A', 'S24151D', 'S24151S',
        'S24152A', 'S24152D', 'S24152S', 'S24153A', 'S24153D', 'S24153S', 'S24154A', 'S24154D',
        'S24154S', 'S24159A', 'S24159D', 'S24159S', 'S2600XA', 'S2600XD', 'S2600XS', 'S2601XA',
        'S2601XD', 'S2601XS', 'S26020A', 'S26020D', 'S26020S', 'S26021A', 'S26021D', 'S26021S',
        'S26022A', 'S26022D', 'S26022S', 'S2609XA', 'S2609XD', 'S2609XS', 'S2610XA', 'S2610XD',
        'S2610XS', 'S2611XA', 'S2611XD', 'S2611XS', 'S2612XA', 'S2612XD', 'S2612XS', 'S2619XA',
        'S2619XD', 'S2619XS', 'S2690XA', 'S2690XD', 'S2690XS', 'S2691XA', 'S2691XD', 'S2691XS',
        'S2692XA', 'S2692XD', 'S2692XS', 'S2699XA', 'S2699XD', 'S2699XS', 'S270XXA', 'S270XXD',
        'S270XXS', 'S271XXA', 'S271XXD', 'S271XXS', 'S272XXA', 'S272XXD', 'S272XXS', 'S27301A',
        'S27301D', 'S27301S', 'S27302A', 'S27302D', 'S27302S', 'S27309A', 'S27309D', 'S27309S',
        'S27311A', 'S27311D', 'S27311S', 'S27312A', 'S27312D', 'S27312S', 'S27319A', 'S27319D',
        'S27319S', 'S27321A', 'S27321D', 'S27321S', 'S27322A', 'S27322D', 'S27322S', 'S27329A',
        'S27329D', 'S27329S', 'S27331A', 'S27331D', 'S27331S', 'S27332A', 'S27332D', 'S27332S',
        'S27339A', 'S27339D', 'S27339S', 'S27391A', 'S27391D', 'S27391S', 'S27392A', 'S27392D',
        'S27392S', 'S27399A', 'S27399D', 'S27399S', 'S27401A', 'S27401D', 'S27401S', 'S27402A',
        'S27402D', 'S27402S', 'S27409A', 'S27409D', 'S27409S', 'S27411A', 'S27411D', 'S27411S',
        'S27412A', 'S27412D', 'S27412S', 'S27419A', 'S27419D', 'S27419S', 'S27421A', 'S27421D',
        'S27421S', 'S27422A', 'S27422D', 'S27422S', 'S27429A', 'S27429D', 'S27429S', 'S27431A',
        'S27431D', 'S27431S', 'S27432A', 'S27432D', 'S27432S', 'S27439A', 'S27439D', 'S27439S',
        'S27491A', 'S27491D', 'S27491S', 'S27492A', 'S27492D', 'S27492S', 'S27499A', 'S27499D',
        'S27499S', 'S2750XA', 'S2750XD', 'S2750XS', 'S2751XA', 'S2751XD', 'S2751XS', 'S2752XA',
        'S2752XD', 'S2752XS', 'S2753XA', 'S2753XD', 'S2753XS', 'S2759XA', 'S2759XD', 'S2759XS',
        'S2760XA', 'S2760XD', 'S2760XS', 'S2763XA', 'S2763XD', 'S2763XS', 'S2769XA', 'S2769XD',
        'S2769XS', 'S27802A', 'S27802D', 'S27802S', 'S27803A', 'S27803D', 'S27803S', 'S27808A',
        'S27808D', 'S27808S', 'S27809A', 'S27809D', 'S27809S', 'S27812A', 'S27812D', 'S27812S',
        'S27813A', 'S27813D', 'S27813S', 'S27818A', 'S27818D', 'S27818S', 'S27819A', 'S27819D',
        'S27819S', 'S27892A', 'S27892D', 'S27892S', 'S27893A', 'S27893D', 'S27893S', 'S27898A',
        'S27898D', 'S27898S', 'S27899A', 'S27899D', 'S27899S', 'S279XXA', 'S279XXD', 'S279XXS',
        'S31001A', 'S31001D', 'S31001S', 'S31011A', 'S31011D', 'S31011S', 'S31021A', 'S31021D',
        'S31021S', 'S31031A', 'S31031D', 'S31031S', 'S31041A', 'S31041D', 'S31041S', 'S31051A',
        'S31051D', 'S31051S', 'S31600A', 'S31600D', 'S31600S', 'S31601A', 'S31601D', 'S31601S',
        'S31602A', 'S31602D', 'S31602S', 'S31603A', 'S31603D', 'S31603S', 'S31604A', 'S31604D',
        'S31604S', 'S31605A', 'S31605D', 'S31605S', 'S31609A', 'S31609D', 'S31609S', 'S31610A',
        'S31610D', 'S31610S', 'S31611A', 'S31611D', 'S31611S', 'S31612A', 'S31612D', 'S31612S',
        'S31613A', 'S31613D', 'S31613S', 'S31614A', 'S31614D', 'S31614S', 'S31615A', 'S31615D',
        'S31615S', 'S31619A', 'S31619D', 'S31619S', 'S31620A', 'S31620D', 'S31620S', 'S31621A',
        'S31621D', 'S31621S', 'S31622A', 'S31622D', 'S31622S', 'S31623A', 'S31623D', 'S31623S',
        'S31624A', 'S31624D', 'S31624S', 'S31625A', 'S31625D', 'S31625S', 'S31629A', 'S31629D',
        'S31629S', 'S31630A', 'S31630D', 'S31630S', 'S31631A', 'S31631D', 'S31631S', 'S31632A',
        'S31632D', 'S31632S', 'S31633A', 'S31633D', 'S31633S', 'S31634A', 'S31634D', 'S31634S',
        'S31635A', 'S31635D', 'S31635S', 'S31639A', 'S31639D', 'S31639S', 'S31640A', 'S31640D',
        'S31640S', 'S31641A', 'S31641D', 'S31641S', 'S31642A', 'S31642D', 'S31642S', 'S31643A',
        'S31643D', 'S31643S', 'S31644A', 'S31644D', 'S31644S', 'S31645A', 'S31645D', 'S31645S',
        'S31649A', 'S31649D', 'S31649S', 'S31650A', 'S31650D', 'S31650S', 'S31651A', 'S31651D',
        'S31651S', 'S31652A', 'S31652D', 'S31652S', 'S31653A', 'S31653D', 'S31653S', 'S31654A',
        'S31654D', 'S31654S', 'S31655A', 'S31655D', 'S31655S', 'S31659A', 'S31659D', 'S31659S',
        'S32000A', 'S32000B', 'S32000D', 'S32000G', 'S32000K', 'S32000S', 'S32001A', 'S32001B',
        'S32001D', 'S32001G', 'S32001K', 'S32001S', 'S32002A', 'S32002B', 'S32002D', 'S32002G',
        'S32002K', 'S32002S', 'S32008A', 'S32008B', 'S32008D', 'S32008G', 'S32008K', 'S32008S',
        'S32009A', 'S32009B', 'S32009D', 'S32009G', 'S32009K', 'S32009S', 'S32010A', 'S32010B',
        'S32010D', 'S32010G', 'S32010K', 'S32010S', 'S32011A', 'S32011B', 'S32011D', 'S32011G',
        'S32011K', 'S32011S', 'S32012A', 'S32012B', 'S32012D', 'S32012G', 'S32012K', 'S32012S',
        'S32018A', 'S32018B', 'S32018D', 'S32018G', 'S32018K', 'S32018S', 'S32019A', 'S32019B',
        'S32019D', 'S32019G', 'S32019K', 'S32019S', 'S32020A', 'S32020B', 'S32020D', 'S32020G',
        'S32020K', 'S32020S', 'S32021A', 'S32021B', 'S32021D', 'S32021G', 'S32021K', 'S32021S',
        'S32022A', 'S32022B', 'S32022D', 'S32022G', 'S32022K', 'S32022S', 'S32028A', 'S32028B',
        'S32028D', 'S32028G', 'S32028K', 'S32028S', 'S32029A', 'S32029B', 'S32029D', 'S32029G',
        'S32029K', 'S32029S', 'S32030A', 'S32030B', 'S32030D', 'S32030G', 'S32030K', 'S32030S',
        'S32031A', 'S32031B', 'S32031D', 'S32031G', 'S32031K', 'S32031S', 'S32032A', 'S32032B',
        'S32032D', 'S32032G', 'S32032K', 'S32032S', 'S32038A', 'S32038B', 'S32038D', 'S32038G',
        'S32038K', 'S32038S', 'S32039A', 'S32039B', 'S32039D', 'S32039G', 'S32039K', 'S32039S',
        'S32040A', 'S32040B', 'S32040D', 'S32040G', 'S32040K', 'S32040S', 'S32041A', 'S32041B',
        'S32041D', 'S32041G', 'S32041K', 'S32041S', 'S32042A', 'S32042B', 'S32042D', 'S32042G',
        'S32042K', 'S32042S', 'S32048A', 'S32048B', 'S32048D', 'S32048G', 'S32048K', 'S32048S',
        'S32049A', 'S32049B', 'S32049D', 'S32049G', 'S32049K', 'S32049S', 'S32050A', 'S32050B',
        'S32050D', 'S32050G', 'S32050K', 'S32050S', 'S32051A', 'S32051B', 'S32051D', 'S32051G',
        'S32051K', 'S32051S', 'S32052A', 'S32052B', 'S32052D', 'S32052G', 'S32052K', 'S32052S',
        'S32058A', 'S32058B', 'S32058D', 'S32058G', 'S32058K', 'S32058S', 'S32059A', 'S32059B',
        'S32059D', 'S32059G', 'S32059K', 'S32059S', 'S3210XA', 'S3210XB', 'S3210XD', 'S3210XG',
        'S3210XK', 'S3210XS', 'S32110A', 'S32110B', 'S32110D', 'S32110G', 'S32110K', 'S32110S',
        'S32111A', 'S32111B', 'S32111D', 'S32111G', 'S32111K', 'S32111S', 'S32112A', 'S32112B',
        'S32112D', 'S32112G', 'S32112K', 'S32112S', 'S32119A', 'S32119B', 'S32119D', 'S32119G',
        'S32119K', 'S32119S', 'S32120A', 'S32120B', 'S32120D', 'S32120G', 'S32120K', 'S32120S',
        'S32121A', 'S32121B', 'S32121D', 'S32121G', 'S32121K', 'S32121S', 'S32122A', 'S32122B',
        'S32122D', 'S32122G', 'S32122K', 'S32122S', 'S32129A', 'S32129B', 'S32129D', 'S32129G',
        'S32129K', 'S32129S', 'S32130A', 'S32130B', 'S32130D', 'S32130G', 'S32130K', 'S32130S',
        'S32131A', 'S32131B', 'S32131D', 'S32131G', 'S32131K', 'S32131S', 'S32132A', 'S32132B',
        'S32132D', 'S32132G', 'S32132K', 'S32132S', 'S32139A', 'S32139B', 'S32139D', 'S32139G',
        'S32139K', 'S32139S', 'S3214XA', 'S3214XB', 'S3214XD', 'S3214XG', 'S3214XK', 'S3214XS',
        'S3215XA', 'S3215XB', 'S3215XD', 'S3215XG', 'S3215XK', 'S3215XS', 'S3216XA', 'S3216XB',
        'S3216XD', 'S3216XG', 'S3216XK', 'S3216XS', 'S3217XA', 'S3217XB', 'S3217XD', 'S3217XG',
        'S3217XK', 'S3217XS', 'S3219XA', 'S3219XB', 'S3219XD', 'S3219XG', 'S3219XK', 'S3219XS',
        'S322XXA', 'S322XXB', 'S322XXD', 'S322XXG', 'S322XXK', 'S322XXS', 'S32301A', 'S32301B',
        'S32301D', 'S32301G', 'S32301K', 'S32301S', 'S32302A', 'S32302B', 'S32302D', 'S32302G',
        'S32302K', 'S32302S', 'S32309A', 'S32309B', 'S32309D', 'S32309G', 'S32309K', 'S32309S',
        'S32311A', 'S32311B', 'S32311D', 'S32311G', 'S32311K', 'S32311S', 'S32312A', 'S32312B',
        'S32312D', 'S32312G', 'S32312K', 'S32312S', 'S32313A', 'S32313B', 'S32313D', 'S32313G',
        'S32313K', 'S32313S', 'S32314A', 'S32314B', 'S32314D', 'S32314G', 'S32314K', 'S32314S',
        'S32315A', 'S32315B', 'S32315D', 'S32315G', 'S32315K', 'S32315S', 'S32316A', 'S32316B',
        'S32316D', 'S32316G', 'S32316K', 'S32316S', 'S32391A', 'S32391B', 'S32391D', 'S32391G',
        'S32391K', 'S32391S', 'S32392A', 'S32392B', 'S32392D', 'S32392G', 'S32392K', 'S32392S',
        'S32399A', 'S32399B', 'S32399D', 'S32399G', 'S32399K', 'S32399S', 'S32401A', 'S32401B',
        'S32401D', 'S32401G', 'S32401K', 'S32401S', 'S32402A', 'S32402B', 'S32402D', 'S32402G',
        'S32402K', 'S32402S', 'S32409A', 'S32409B', 'S32409D', 'S32409G', 'S32409K', 'S32409S',
        'S32411A', 'S32411B', 'S32411D', 'S32411G', 'S32411K', 'S32411S', 'S32412A', 'S32412B',
        'S32412D', 'S32412G', 'S32412K', 'S32412S', 'S32413A', 'S32413B', 'S32413D', 'S32413G',
        'S32413K', 'S32413S', 'S32414A', 'S32414B', 'S32414D', 'S32414G', 'S32414K', 'S32414S',
        'S32415A', 'S32415B', 'S32415D', 'S32415G', 'S32415K', 'S32415S', 'S32416A', 'S32416B',
        'S32416D', 'S32416G', 'S32416K', 'S32416S', 'S32421A', 'S32421B', 'S32421D', 'S32421G',
        'S32421K', 'S32421S', 'S32422A', 'S32422B', 'S32422D', 'S32422G', 'S32422K', 'S32422S',
        'S32423A', 'S32423B', 'S32423D', 'S32423G', 'S32423K', 'S32423S', 'S32424A', 'S32424B',
        'S32424D', 'S32424G', 'S32424K', 'S32424S', 'S32425A', 'S32425B', 'S32425D', 'S32425G',
        'S32425K', 'S32425S', 'S32426A', 'S32426B', 'S32426D', 'S32426G', 'S32426K', 'S32426S',
        'S32431A', 'S32431B', 'S32431D', 'S32431G', 'S32431K', 'S32431S', 'S32432A', 'S32432B',
        'S32432D', 'S32432G', 'S32432K', 'S32432S', 'S32433A', 'S32433B', 'S32433D', 'S32433G',
        'S32433K', 'S32433S', 'S32434A', 'S32434B', 'S32434D', 'S32434G', 'S32434K', 'S32434S',
        'S32435A', 'S32435B', 'S32435D', 'S32435G', 'S32435K', 'S32435S', 'S32436A', 'S32436B',
        'S32436D', 'S32436G', 'S32436K', 'S32436S', 'S32441A', 'S32441B', 'S32441D', 'S32441G',
        'S32441K', 'S32441S', 'S32442A', 'S32442B', 'S32442D', 'S32442G', 'S32442K', 'S32442S',
        'S32443A', 'S32443B', 'S32443D', 'S32443G', 'S32443K', 'S32443S', 'S32444A', 'S32444B',
        'S32444D', 'S32444G', 'S32444K', 'S32444S', 'S32445A', 'S32445B', 'S32445D', 'S32445G',
        'S32445K', 'S32445S', 'S32446A', 'S32446B', 'S32446D', 'S32446G', 'S32446K', 'S32446S',
        'S32451A', 'S32451B', 'S32451D', 'S32451G', 'S32451K', 'S32451S', 'S32452A', 'S32452B',
        'S32452D', 'S32452G', 'S32452K', 'S32452S', 'S32453A', 'S32453B', 'S32453D', 'S32453G',
        'S32453K', 'S32453S', 'S32454A', 'S32454B', 'S32454D', 'S32454G', 'S32454K', 'S32454S',
        'S32455A', 'S32455B', 'S32455D', 'S32455G', 'S32455K', 'S32455S', 'S32456A', 'S32456B',
        'S32456D', 'S32456G', 'S32456K', 'S32456S', 'S32461A', 'S32461B', 'S32461D', 'S32461G',
        'S32461K', 'S32461S', 'S32462A', 'S32462B', 'S32462D', 'S32462G', 'S32462K', 'S32462S',
        'S32463A', 'S32463B', 'S32463D', 'S32463G', 'S32463K', 'S32463S', 'S32464A', 'S32464B',
        'S32464D', 'S32464G', 'S32464K', 'S32464S', 'S32465A', 'S32465B', 'S32465D', 'S32465G',
        'S32465K', 'S32465S', 'S32466A', 'S32466B', 'S32466D', 'S32466G', 'S32466K', 'S32466S',
        'S32471A', 'S32471B', 'S32471D', 'S32471G', 'S32471K', 'S32471S', 'S32472A', 'S32472B',
        'S32472D', 'S32472G', 'S32472K', 'S32472S', 'S32473A', 'S32473B', 'S32473D', 'S32473G',
        'S32473K', 'S32473S', 'S32474A', 'S32474B', 'S32474D', 'S32474G', 'S32474K', 'S32474S',
        'S32475A', 'S32475B', 'S32475D', 'S32475G', 'S32475K', 'S32475S', 'S32476A', 'S32476B',
        'S32476D', 'S32476G', 'S32476K', 'S32476S', 'S32481A', 'S32481B', 'S32481D', 'S32481G',
        'S32481K', 'S32481S', 'S32482A', 'S32482B', 'S32482D', 'S32482G', 'S32482K', 'S32482S',
        'S32483A', 'S32483B', 'S32483D', 'S32483G', 'S32483K', 'S32483S', 'S32484A', 'S32484B',
        'S32484D', 'S32484G', 'S32484K', 'S32484S', 'S32485A', 'S32485B', 'S32485D', 'S32485G',
        'S32485K', 'S32485S', 'S32486A', 'S32486B', 'S32486D', 'S32486G', 'S32486K', 'S32486S',
        'S32491A', 'S32491B', 'S32491D', 'S32491G', 'S32491K', 'S32491S', 'S32492A', 'S32492B',
        'S32492D', 'S32492G', 'S32492K', 'S32492S', 'S32499A', 'S32499B', 'S32499D', 'S32499G',
        'S32499K', 'S32499S', 'S32501A', 'S32501B', 'S32501D', 'S32501G', 'S32501K', 'S32501S',
        'S32502A', 'S32502B', 'S32502D', 'S32502G', 'S32502K', 'S32502S', 'S32509A', 'S32509B',
        'S32509D', 'S32509G', 'S32509K', 'S32509S', 'S32511A', 'S32511B', 'S32511D', 'S32511G',
        'S32511K', 'S32511S', 'S32512A', 'S32512B', 'S32512D', 'S32512G', 'S32512K', 'S32512S',
        'S32519A', 'S32519B', 'S32519D', 'S32519G', 'S32519K', 'S32519S', 'S32591A', 'S32591B',
        'S32591D', 'S32591G', 'S32591K', 'S32591S', 'S32592A', 'S32592B', 'S32592D', 'S32592G',
        'S32592K', 'S32592S', 'S32599A', 'S32599B', 'S32599D', 'S32599G', 'S32599K', 'S32599S',
        'S32601A', 'S32601B', 'S32601D', 'S32601G', 'S32601K', 'S32601S', 'S32602A', 'S32602B',
        'S32602D', 'S32602G', 'S32602K', 'S32602S', 'S32609A', 'S32609B', 'S32609D', 'S32609G',
        'S32609K', 'S32609S', 'S32611A', 'S32611B', 'S32611D', 'S32611G', 'S32611K', 'S32611S',
        'S32612A', 'S32612B', 'S32612D', 'S32612G', 'S32612K', 'S32612S', 'S32613A', 'S32613B',
        'S32613D', 'S32613G', 'S32613K', 'S32613S', 'S32614A', 'S32614B', 'S32614D', 'S32614G',
        'S32614K', 'S32614S', 'S32615A', 'S32615B', 'S32615D', 'S32615G', 'S32615K', 'S32615S',
        'S32616A', 'S32616B', 'S32616D', 'S32616G', 'S32616K', 'S32616S', 'S32691A', 'S32691B',
        'S32691D', 'S32691G', 'S32691K', 'S32691S', 'S32692A', 'S32692B', 'S32692D', 'S32692G',
        'S32692K', 'S32692S', 'S32699A', 'S32699B', 'S32699D', 'S32699G', 'S32699K', 'S32699S',
        'S32810A', 'S32810B', 'S32810D', 'S32810G', 'S32810K', 'S32810S', 'S32811A', 'S32811B',
        'S32811D', 'S32811G', 'S32811K', 'S32811S', 'S3282XA', 'S3282XB', 'S3282XD', 'S3282XG',
        'S3282XK', 'S3282XS', 'S3289XA', 'S3289XB', 'S3289XD', 'S3289XG', 'S3289XK', 'S3289XS',
        'S329XXA', 'S329XXB', 'S329XXD', 'S329XXG', 'S329XXK', 'S329XXS', 'S330XXA', 'S330XXD',
        'S330XXS', 'S33101A', 'S33101D', 'S33101S', 'S33111A', 'S33111D', 'S33111S', 'S33121A',
        'S33121D', 'S33121S', 'S33131A', 'S33131D', 'S33131S', 'S33141A', 'S33141D', 'S33141S',
        'S332XXA', 'S332XXD', 'S332XXS', 'S3330XA', 'S3330XD', 'S3330XS', 'S3339XA', 'S3339XD',
        'S3339XS', 'S334XXA', 'S334XXD', 'S334XXS', 'S3401XA', 'S3401XD', 'S3401XS', 'S3402XA',
        'S3402XD', 'S3402XS', 'S34111A', 'S34111D', 'S34111S', 'S34112A', 'S34112D', 'S34112S',
        'S34113A', 'S34113D', 'S34113S', 'S34114A', 'S34114D', 'S34114S', 'S34115A', 'S34115D',
        'S34115S', 'S34119A', 'S34119D', 'S34119S', 'S34121A', 'S34121D', 'S34121S', 'S34122A',
        'S34122D', 'S34122S', 'S34123A', 'S34123D', 'S34123S', 'S34124A', 'S34124D', 'S34124S',
        'S34125A', 'S34125D', 'S34125S', 'S34129A', 'S34129D', 'S34129S', 'S34131A', 'S34131D',
        'S34131S', 'S34132A', 'S34132D', 'S34132S', 'S3600XA', 'S3600XD', 'S3600XS', 'S36020A',
        'S36020D', 'S36020S', 'S36021A', 'S36021D', 'S36021S', 'S36029A', 'S36029D', 'S36029S',
        'S36030A', 'S36030D', 'S36030S', 'S36031A', 'S36031D', 'S36031S', 'S36032A', 'S36032D',
        'S36032S', 'S36039A', 'S36039D', 'S36039S', 'S3609XA', 'S3609XD', 'S3609XS', 'S36112A',
        'S36112D', 'S36112S', 'S36113A', 'S36113D', 'S36113S', 'S36114A', 'S36114D', 'S36114S',
        'S36115A', 'S36115D', 'S36115S', 'S36116A', 'S36116D', 'S36116S', 'S36118A', 'S36118D',
        'S36118S', 'S36119A', 'S36119D', 'S36119S', 'S36122A', 'S36122D', 'S36122S', 'S36123A',
        'S36123D', 'S36123S', 'S36128A', 'S36128D', 'S36128S', 'S36129A', 'S36129D', 'S36129S',
        'S3613XA', 'S3613XD', 'S3613XS', 'S36200A', 'S36200D', 'S36200S', 'S36201A', 'S36201D',
        'S36201S', 'S36202A', 'S36202D', 'S36202S', 'S36209A', 'S36209D', 'S36209S', 'S36220A',
        'S36220D', 'S36220S', 'S36221A', 'S36221D', 'S36221S', 'S36222A', 'S36222D', 'S36222S',
        'S36229A', 'S36229D', 'S36229S', 'S36230A', 'S36230D', 'S36230S', 'S36231A', 'S36231D',
        'S36231S', 'S36232A', 'S36232D', 'S36232S', 'S36239A', 'S36239D', 'S36239S', 'S36240A',
        'S36240D', 'S36240S', 'S36241A', 'S36241D', 'S36241S', 'S36242A', 'S36242D', 'S36242S',
        'S36249A', 'S36249D', 'S36249S', 'S36250A', 'S36250D', 'S36250S', 'S36251A', 'S36251D',
        'S36251S', 'S36252A', 'S36252D', 'S36252S', 'S36259A', 'S36259D', 'S36259S', 'S36260A',
        'S36260D', 'S36260S', 'S36261A', 'S36261D', 'S36261S', 'S36262A', 'S36262D', 'S36262S',
        'S36269A', 'S36269D', 'S36269S', 'S36290A', 'S36290D', 'S36290S', 'S36291A', 'S36291D',
        'S36291S', 'S36292A', 'S36292D', 'S36292S', 'S36299A', 'S36299D', 'S36299S', 'S3630XA',
        'S3630XD', 'S3630XS', 'S3632XA', 'S3632XD', 'S3632XS', 'S3633XA', 'S3633XD', 'S3633XS',
        'S3639XA', 'S3639XD', 'S3639XS', 'S36400A', 'S36400D', 'S36400S', 'S36408A', 'S36408D',
        'S36408S', 'S36409A', 'S36409D', 'S36409S', 'S36410A', 'S36410D', 'S36410S', 'S36418A',
        'S36418D', 'S36418S', 'S36419A', 'S36419D', 'S36419S', 'S36420A', 'S36420D', 'S36420S',
        'S36428A', 'S36428D', 'S36428S', 'S36429A', 'S36429D', 'S36429S', 'S36430A', 'S36430D',
        'S36430S', 'S36438A', 'S36438D', 'S36438S', 'S36439A', 'S36439D', 'S36439S', 'S36490A',
        'S36490D', 'S36490S', 'S36498A', 'S36498D', 'S36498S', 'S36499A', 'S36499D', 'S36499S',
        'S36500A', 'S36500D', 'S36500S', 'S36501A', 'S36501D', 'S36501S', 'S36502A', 'S36502D',
        'S36502S', 'S36503A', 'S36503D', 'S36503S', 'S36508A', 'S36508D', 'S36508S', 'S36509A',
        'S36509D', 'S36509S', 'S36510A', 'S36510D', 'S36510S', 'S36511A', 'S36511D', 'S36511S',
        'S36512A', 'S36512D', 'S36512S', 'S36513A', 'S36513D', 'S36513S', 'S36518A', 'S36518D',
        'S36518S', 'S36519A', 'S36519D', 'S36519S', 'S36520A', 'S36520D', 'S36520S', 'S36521A',
        'S36521D', 'S36521S', 'S36522A', 'S36522D', 'S36522S', 'S36523A', 'S36523D', 'S36523S',
        'S36528A', 'S36528D', 'S36528S', 'S36529A', 'S36529D', 'S36529S', 'S36530A', 'S36530D',
        'S36530S', 'S36531A', 'S36531D', 'S36531S', 'S36532A', 'S36532D', 'S36532S', 'S36533A',
        'S36533D', 'S36533S', 'S36538A', 'S36538D', 'S36538S', 'S36539A', 'S36539D', 'S36539S',
        'S36590A', 'S36590D', 'S36590S', 'S36591A', 'S36591D', 'S36591S', 'S36592A', 'S36592D',
        'S36592S', 'S36593A', 'S36593D', 'S36593S', 'S36598A', 'S36598D', 'S36598S', 'S36599A',
        'S36599D', 'S36599S', 'S3660XA', 'S3660XD', 'S3660XS', 'S3661XA', 'S3661XD', 'S3661XS',
        'S3662XA', 'S3662XD', 'S3662XS', 'S3663XA', 'S3663XD', 'S3663XS', 'S3669XA', 'S3669XD',
        'S3669XS', 'S3681XA', 'S3681XD', 'S3681XS', 'S36892A', 'S36892D', 'S36892S', 'S36893A',
        'S36893D', 'S36893S', 'S36898A', 'S36898D', 'S36898S', 'S36899A', 'S36899D', 'S36899S',
        'S3690XA', 'S3690XD', 'S3690XS', 'S3692XA', 'S3692XD', 'S3692XS', 'S3693XA', 'S3693XD',
        'S3693XS', 'S3699XA', 'S3699XD', 'S3699XS', 'S37001A', 'S37001D', 'S37001S', 'S37002A',
        'S37002D', 'S37002S', 'S37009A', 'S37009D', 'S37009S', 'S37011A', 'S37011D', 'S37011S',
        'S37012A', 'S37012D', 'S37012S', 'S37019A', 'S37019D', 'S37019S', 'S37021A', 'S37021D',
        'S37021S', 'S37022A', 'S37022D', 'S37022S', 'S37029A', 'S37029D', 'S37029S', 'S37031A',
        'S37031D', 'S37031S', 'S37032A', 'S37032D', 'S37032S', 'S37039A', 'S37039D', 'S37039S',
        'S37041A', 'S37041D', 'S37041S', 'S37042A', 'S37042D', 'S37042S', 'S37049A', 'S37049D',
        'S37049S', 'S37051A', 'S37051D', 'S37051S', 'S37052A', 'S37052D', 'S37052S', 'S37059A',
        'S37059D', 'S37059S', 'S37061A', 'S37061D', 'S37061S', 'S37062A', 'S37062D', 'S37062S',
        'S37069A', 'S37069D', 'S37069S', 'S37091A', 'S37091D', 'S37091S', 'S37092A', 'S37092D',
        'S37092S', 'S37099A', 'S37099D', 'S37099S', 'S3710XA', 'S3710XD', 'S3710XS', 'S3712XA',
        'S3712XD', 'S3712XS', 'S3713XA', 'S3713XD', 'S3713XS', 'S3719XA', 'S3719XD', 'S3719XS',
        'S3720XA', 'S3720XD', 'S3720XS', 'S3722XA', 'S3722XD', 'S3722XS', 'S3723XA', 'S3723XD',
        'S3723XS', 'S3729XA', 'S3729XD', 'S3729XS', 'S3730XA', 'S3730XD', 'S3730XS', 'S3732XA',
        'S3732XD', 'S3732XS', 'S3733XA', 'S3733XD', 'S3733XS', 'S3739XA', 'S3739XD', 'S3739XS',
        'S37401A', 'S37401D', 'S37401S', 'S37402A', 'S37402D', 'S37402S', 'S37409A', 'S37409D',
        'S37409S', 'S37421A', 'S37421D', 'S37421S', 'S37422A', 'S37422D', 'S37422S', 'S37429A',
        'S37429D', 'S37429S', 'S37431A', 'S37431D', 'S37431S', 'S37432A', 'S37432D', 'S37432S',
        'S37439A', 'S37439D', 'S37439S', 'S37491A', 'S37491D', 'S37491S', 'S37492A', 'S37492D',
        'S37492S', 'S37499A', 'S37499D', 'S37499S', 'S37501A', 'S37501D', 'S37501S', 'S37502A',
        'S37502D', 'S37502S', 'S37509A', 'S37509D', 'S37509S', 'S37511A', 'S37511D', 'S37511S',
        'S37512A', 'S37512D', 'S37512S', 'S37519A', 'S37519D', 'S37519S', 'S37521A', 'S37521D',
        'S37521S', 'S37522A', 'S37522D', 'S37522S', 'S37529A', 'S37529D', 'S37529S', 'S37531A',
        'S37531D', 'S37531S', 'S37532A', 'S37532D', 'S37532S', 'S37539A', 'S37539D', 'S37539S',
        'S37591A', 'S37591D', 'S37591S', 'S37592A', 'S37592D', 'S37592S', 'S37599A', 'S37599D',
        'S37599S', 'S3760XA', 'S3760XD', 'S3760XS', 'S3762XA', 'S3762XD', 'S3762XS', 'S3763XA',
        'S3763XD', 'S3763XS', 'S3769XA', 'S3769XD', 'S3769XS', 'S37812A', 'S37812D', 'S37812S',
        'S37813A', 'S37813D', 'S37813S', 'S37818A', 'S37818D', 'S37818S', 'S37819A', 'S37819D',
        'S37819S', 'S37822A', 'S37822D', 'S37822S', 'S37823A', 'S37823D', 'S37823S', 'S37828A',
        'S37828D', 'S37828S', 'S37829A', 'S37829D', 'S37829S', 'S37892A', 'S37892D', 'S37892S',
        'S37893A', 'S37893D', 'S37893S', 'S37898A', 'S37898D', 'S37898S', 'S37899A', 'S37899D',
        'S37899S', 'S3790XA', 'S3790XD', 'S3790XS', 'S3792XA', 'S3792XD', 'S3792XS', 'S3793XA',
        'S3793XD', 'S3793XS', 'S3799XA', 'S3799XD', 'S3799XS', 'S381XXA', 'S381XXD', 'S381XXS',
        'S42001A', 'S42001B', 'S42001D', 'S42001G', 'S42001K', 'S42001P', 'S42001S', 'S42002A',
        'S42002B', 'S42002D', 'S42002G', 'S42002K', 'S42002P', 'S42002S', 'S42009A', 'S42009B',
        'S42009D', 'S42009G', 'S42009K', 'S42009P', 'S42009S', 'S42011A', 'S42011B', 'S42011D',
        'S42011G', 'S42011K', 'S42011P', 'S42011S', 'S42012A', 'S42012B', 'S42012D', 'S42012G',
        'S42012K', 'S42012P', 'S42012S', 'S42013A', 'S42013B', 'S42013D', 'S42013G', 'S42013K',
        'S42013P', 'S42013S', 'S42014A', 'S42014B', 'S42014D', 'S42014G', 'S42014K', 'S42014P',
        'S42014S', 'S42015A', 'S42015B', 'S42015D', 'S42015G', 'S42015K', 'S42015P', 'S42015S',
        'S42016A', 'S42016B', 'S42016D', 'S42016G', 'S42016K', 'S42016P', 'S42016S', 'S42017A',
        'S42017B', 'S42017D', 'S42017G', 'S42017K', 'S42017P', 'S42017S', 'S42018A', 'S42018B',
        'S42018D', 'S42018G', 'S42018K', 'S42018P', 'S42018S', 'S42019A', 'S42019B', 'S42019D',
        'S42019G', 'S42019K', 'S42019P', 'S42019S', 'S42021A', 'S42021B', 'S42021D', 'S42021G',
        'S42021K', 'S42021P', 'S42021S', 'S42022A', 'S42022B', 'S42022D', 'S42022G', 'S42022K',
        'S42022P', 'S42022S', 'S42023A', 'S42023B', 'S42023D', 'S42023G', 'S42023K', 'S42023P',
        'S42023S', 'S42024A', 'S42024B', 'S42024D', 'S42024G', 'S42024K', 'S42024P', 'S42024S',
        'S42025A', 'S42025B', 'S42025D', 'S42025G', 'S42025K', 'S42025P', 'S42025S', 'S42026A',
        'S42026B', 'S42026D', 'S42026G', 'S42026K', 'S42026P', 'S42026S', 'S42031A', 'S42031B',
        'S42031D', 'S42031G', 'S42031K', 'S42031P', 'S42031S', 'S42032A', 'S42032B', 'S42032D',
        'S42032G', 'S42032K', 'S42032P', 'S42032S', 'S42033A', 'S42033B', 'S42033D', 'S42033G',
        'S42033K', 'S42033P', 'S42033S', 'S42034A', 'S42034B', 'S42034D', 'S42034G', 'S42034K',
        'S42034P', 'S42034S', 'S42035A', 'S42035B', 'S42035D', 'S42035G', 'S42035K', 'S42035P',
        'S42035S', 'S42036A', 'S42036B', 'S42036D', 'S42036G', 'S42036K', 'S42036P', 'S42036S',
        'S42101A', 'S42101B', 'S42101D', 'S42101G', 'S42101K', 'S42101P', 'S42101S', 'S42102A',
        'S42102B', 'S42102D', 'S42102G', 'S42102K', 'S42102P', 'S42102S', 'S42109A', 'S42109B',
        'S42109D', 'S42109G', 'S42109K', 'S42109P', 'S42109S', 'S42111A', 'S42111B', 'S42111D',
        'S42111G', 'S42111K', 'S42111P', 'S42111S', 'S42112A', 'S42112B', 'S42112D', 'S42112G',
        'S42112K', 'S42112P', 'S42112S', 'S42113A', 'S42113B', 'S42113D', 'S42113G', 'S42113K',
        'S42113P', 'S42113S', 'S42114A', 'S42114B', 'S42114D', 'S42114G', 'S42114K', 'S42114P',
        'S42114S', 'S42115A', 'S42115B', 'S42115D', 'S42115G', 'S42115K', 'S42115P', 'S42115S',
        'S42116A', 'S42116B', 'S42116D', 'S42116G', 'S42116K', 'S42116P', 'S42116S', 'S42121A',
        'S42121B', 'S42121D', 'S42121G', 'S42121K', 'S42121P', 'S42121S', 'S42122A', 'S42122B',
        'S42122D', 'S42122G', 'S42122K', 'S42122P', 'S42122S', 'S42123A', 'S42123B', 'S42123D',
        'S42123G', 'S42123K', 'S42123P', 'S42123S', 'S42124A', 'S42124B', 'S42124D', 'S42124G',
        'S42124K', 'S42124P', 'S42124S', 'S42125A', 'S42125B', 'S42125D', 'S42125G', 'S42125K',
        'S42125P', 'S42125S', 'S42126A', 'S42126B', 'S42126D', 'S42126G', 'S42126K', 'S42126P',
        'S42126S', 'S42131A', 'S42131B', 'S42131D', 'S42131G', 'S42131K', 'S42131P', 'S42131S',
        'S42132A', 'S42132B', 'S42132D', 'S42132G', 'S42132K', 'S42132P', 'S42132S', 'S42133A',
        'S42133B', 'S42133D', 'S42133G', 'S42133K', 'S42133P', 'S42133S', 'S42134A', 'S42134B',
        'S42134D', 'S42134G', 'S42134K', 'S42134P', 'S42134S', 'S42135A', 'S42135B', 'S42135D',
        'S42135G', 'S42135K', 'S42135P', 'S42135S', 'S42136A', 'S42136B', 'S42136D', 'S42136G',
        'S42136K', 'S42136P', 'S42136S', 'S42141A', 'S42141B', 'S42141D', 'S42141G', 'S42141K',
        'S42141P', 'S42141S', 'S42142A', 'S42142B', 'S42142D', 'S42142G', 'S42142K', 'S42142P',
        'S42142S', 'S42143A', 'S42143B', 'S42143D', 'S42143G', 'S42143K', 'S42143P', 'S42143S',
        'S42144A', 'S42144B', 'S42144D', 'S42144G', 'S42144K', 'S42144P', 'S42144S', 'S42145A',
        'S42145B', 'S42145D', 'S42145G', 'S42145K', 'S42145P', 'S42145S', 'S42146A', 'S42146B',
        'S42146D', 'S42146G', 'S42146K', 'S42146P', 'S42146S', 'S42151A', 'S42151B', 'S42151D',
        'S42151G', 'S42151K', 'S42151P', 'S42151S', 'S42152A', 'S42152B', 'S42152D', 'S42152G',
        'S42152K', 'S42152P', 'S42152S', 'S42153A', 'S42153B', 'S42153D', 'S42153G', 'S42153K',
        'S42153P', 'S42153S', 'S42154A', 'S42154B', 'S42154D', 'S42154G', 'S42154K', 'S42154P',
        'S42154S', 'S42155A', 'S42155B', 'S42155D', 'S42155G', 'S42155K', 'S42155P', 'S42155S',
        'S42156A', 'S42156B', 'S42156D', 'S42156G', 'S42156K', 'S42156P', 'S42156S', 'S42191A',
        'S42191B', 'S42191D', 'S42191G', 'S42191K', 'S42191P', 'S42191S', 'S42192A', 'S42192B',
        'S42192D', 'S42192G', 'S42192K', 'S42192P', 'S42192S', 'S42199A', 'S42199B', 'S42199D',
        'S42199G', 'S42199K', 'S42199P', 'S42199S', 'S42201A', 'S42201B', 'S42201D', 'S42201G',
        'S42201K', 'S42201P', 'S42201S', 'S42202A', 'S42202B', 'S42202D', 'S42202G', 'S42202K',
        'S42202P', 'S42202S', 'S42209A', 'S42209B', 'S42209D', 'S42209G', 'S42209K', 'S42209P',
        'S42209S', 'S42211A', 'S42211B', 'S42211D', 'S42211G', 'S42211K', 'S42211P', 'S42211S',
        'S42212A', 'S42212B', 'S42212D', 'S42212G', 'S42212K', 'S42212P', 'S42212S', 'S42213A',
        'S42213B', 'S42213D', 'S42213G', 'S42213K', 'S42213P', 'S42213S', 'S42214A', 'S42214B',
        'S42214D', 'S42214G', 'S42214K', 'S42214P', 'S42214S', 'S42215A', 'S42215B', 'S42215D',
        'S42215G', 'S42215K', 'S42215P', 'S42215S', 'S42216A', 'S42216B', 'S42216D', 'S42216G',
        'S42216K', 'S42216P', 'S42216S', 'S42221A', 'S42221B', 'S42221D', 'S42221G', 'S42221K',
        'S42221P', 'S42221S', 'S42222A', 'S42222B', 'S42222D', 'S42222G', 'S42222K', 'S42222P',
        'S42222S', 'S42223A', 'S42223B', 'S42223D', 'S42223G', 'S42223K', 'S42223P', 'S42223S',
        'S42224A', 'S42224B', 'S42224D', 'S42224G', 'S42224K', 'S42224P', 'S42224S', 'S42225A',
        'S42225B', 'S42225D', 'S42225G', 'S42225K', 'S42225P', 'S42225S', 'S42226A', 'S42226B',
        'S42226D', 'S42226G', 'S42226K', 'S42226P', 'S42226S', 'S42231A', 'S42231B', 'S42231D',
        'S42231G', 'S42231K', 'S42231P', 'S42231S', 'S42232A', 'S42232B', 'S42232D', 'S42232G',
        'S42232K', 'S42232P', 'S42232S', 'S42239A', 'S42239B', 'S42239D', 'S42239G', 'S42239K',
        'S42239P', 'S42239S', 'S42241A', 'S42241B', 'S42241D', 'S42241G', 'S42241K', 'S42241P',
        'S42241S', 'S42242A', 'S42242B', 'S42242D', 'S42242G', 'S42242K', 'S42242P', 'S42242S',
        'S42249A', 'S42249B', 'S42249D', 'S42249G', 'S42249K', 'S42249P', 'S42249S', 'S42251A',
        'S42251B', 'S42251D', 'S42251G', 'S42251K', 'S42251P', 'S42251S', 'S42252A', 'S42252B',
        'S42252D', 'S42252G', 'S42252K', 'S42252P', 'S42252S', 'S42253A', 'S42253B', 'S42253D',
        'S42253G', 'S42253K', 'S42253P', 'S42253S', 'S42254A', 'S42254B', 'S42254D', 'S42254G',
        'S42254K', 'S42254P', 'S42254S', 'S42255A', 'S42255B', 'S42255D', 'S42255G', 'S42255K',
        'S42255P', 'S42255S', 'S42256A', 'S42256B', 'S42256D', 'S42256G', 'S42256K', 'S42256P',
        'S42256S', 'S42261A', 'S42261B', 'S42261D', 'S42261G', 'S42261K', 'S42261P', 'S42261S',
        'S42262A', 'S42262B', 'S42262D', 'S42262G', 'S42262K', 'S42262P', 'S42262S', 'S42263A',
        'S42263B', 'S42263D', 'S42263G', 'S42263K', 'S42263P', 'S42263S', 'S42264A', 'S42264B',
        'S42264D', 'S42264G', 'S42264K', 'S42264P', 'S42264S', 'S42265A', 'S42265B', 'S42265D',
        'S42265G', 'S42265K', 'S42265P', 'S42265S', 'S42266A', 'S42266B', 'S42266D', 'S42266G',
        'S42266K', 'S42266P', 'S42266S', 'S42271A', 'S42271D', 'S42271G', 'S42271K', 'S42271P',
        'S42271S', 'S42272A', 'S42272D', 'S42272G', 'S42272K', 'S42272P', 'S42272S', 'S42279A',
        'S42279D', 'S42279G', 'S42279K', 'S42279P', 'S42279S', 'S42291A', 'S42291B', 'S42291D',
        'S42291G', 'S42291K', 'S42291P', 'S42291S', 'S42292A', 'S42292B', 'S42292D', 'S42292G',
        'S42292K', 'S42292P', 'S42292S', 'S42293A', 'S42293B', 'S42293D', 'S42293G', 'S42293K',
        'S42293P', 'S42293S', 'S42294A', 'S42294B', 'S42294D', 'S42294G', 'S42294K', 'S42294P',
        'S42294S', 'S42295A', 'S42295B', 'S42295D', 'S42295G', 'S42295K', 'S42295P', 'S42295S',
        'S42296A', 'S42296B', 'S42296D', 'S42296G', 'S42296K', 'S42296P', 'S42296S', 'S42301A',
        'S42301B', 'S42301D', 'S42301G', 'S42301K', 'S42301P', 'S42301S', 'S42302A', 'S42302B',
        'S42302D', 'S42302G', 'S42302K', 'S42302P', 'S42302S', 'S42309A', 'S42309B', 'S42309D',
        'S42309G', 'S42309K', 'S42309P', 'S42309S', 'S42311A', 'S42311D', 'S42311G', 'S42311K',
        'S42311P', 'S42311S', 'S42312A', 'S42312D', 'S42312G', 'S42312K', 'S42312P', 'S42312S',
        'S42319A', 'S42319D', 'S42319G', 'S42319K', 'S42319P', 'S42319S', 'S42321A', 'S42321B',
        'S42321D', 'S42321G', 'S42321K', 'S42321P', 'S42321S', 'S42322A', 'S42322B', 'S42322D',
        'S42322G', 'S42322K', 'S42322P', 'S42322S', 'S42323A', 'S42323B', 'S42323D', 'S42323G',
        'S42323K', 'S42323P', 'S42323S', 'S42324A', 'S42324B', 'S42324D', 'S42324G', 'S42324K',
        'S42324P', 'S42324S', 'S42325A', 'S42325B', 'S42325D', 'S42325G', 'S42325K', 'S42325P',
        'S42325S', 'S42326A', 'S42326B', 'S42326D', 'S42326G', 'S42326K', 'S42326P', 'S42326S',
        'S42331A', 'S42331B', 'S42331D', 'S42331G', 'S42331K', 'S42331P', 'S42331S', 'S42332A',
        'S42332B', 'S42332D', 'S42332G', 'S42332K', 'S42332P', 'S42332S', 'S42333A', 'S42333B',
        'S42333D', 'S42333G', 'S42333K', 'S42333P', 'S42333S', 'S42334A', 'S42334B', 'S42334D',
        'S42334G', 'S42334K', 'S42334P', 'S42334S', 'S42335A', 'S42335B', 'S42335D', 'S42335G',
        'S42335K', 'S42335P', 'S42335S', 'S42336A', 'S42336B', 'S42336D', 'S42336G', 'S42336K',
        'S42336P', 'S42336S', 'S42341A', 'S42341B', 'S42341D', 'S42341G', 'S42341K', 'S42341P',
        'S42341S', 'S42342A', 'S42342B', 'S42342D', 'S42342G', 'S42342K', 'S42342P', 'S42342S',
        'S42343A', 'S42343B', 'S42343D', 'S42343G', 'S42343K', 'S42343P', 'S42343S', 'S42344A',
        'S42344B', 'S42344D', 'S42344G', 'S42344K', 'S42344P', 'S42344S', 'S42345A', 'S42345B',
        'S42345D', 'S42345G', 'S42345K', 'S42345P', 'S42345S', 'S42346A', 'S42346B', 'S42346D',
        'S42346G', 'S42346K', 'S42346P', 'S42346S', 'S42351A', 'S42351B', 'S42351D', 'S42351G',
        'S42351K', 'S42351P', 'S42351S', 'S42352A', 'S42352B', 'S42352D', 'S42352G', 'S42352K',
        'S42352P', 'S42352S', 'S42353A', 'S42353B', 'S42353D', 'S42353G', 'S42353K', 'S42353P',
        'S42353S', 'S42354A', 'S42354B', 'S42354D', 'S42354G', 'S42354K', 'S42354P', 'S42354S',
        'S42355A', 'S42355B', 'S42355D', 'S42355G', 'S42355K', 'S42355P', 'S42355S', 'S42356A',
        'S42356B', 'S42356D', 'S42356G', 'S42356K', 'S42356P', 'S42356S', 'S42361A', 'S42361B',
        'S42361D', 'S42361G', 'S42361K', 'S42361P', 'S42361S', 'S42362A', 'S42362B', 'S42362D',
        'S42362G', 'S42362K', 'S42362P', 'S42362S', 'S42363A', 'S42363B', 'S42363D', 'S42363G',
        'S42363K', 'S42363P', 'S42363S', 'S42364A', 'S42364B', 'S42364D', 'S42364G', 'S42364K',
        'S42364P', 'S42364S', 'S42365A', 'S42365B', 'S42365D', 'S42365G', 'S42365K', 'S42365P',
        'S42365S', 'S42366A', 'S42366B', 'S42366D', 'S42366G', 'S42366K', 'S42366P', 'S42366S',
        'S42391A', 'S42391B', 'S42391D', 'S42391G', 'S42391K', 'S42391P', 'S42391S', 'S42392A',
        'S42392B', 'S42392D', 'S42392G', 'S42392K', 'S42392P', 'S42392S', 'S42399A', 'S42399B',
        'S42399D', 'S42399G', 'S42399K', 'S42399P', 'S42399S', 'S42401A', 'S42401B', 'S42401D',
        'S42401G', 'S42401K', 'S42401P', 'S42401S', 'S42402A', 'S42402B', 'S42402D', 'S42402G',
        'S42402K', 'S42402P', 'S42402S', 'S42409A', 'S42409B', 'S42409D', 'S42409G', 'S42409K',
        'S42409P', 'S42409S', 'S42411A', 'S42411B', 'S42411D', 'S42411G', 'S42411K', 'S42411P',
        'S42411S', 'S42412A', 'S42412B', 'S42412D', 'S42412G', 'S42412K', 'S42412P', 'S42412S',
        'S42413A', 'S42413B', 'S42413D', 'S42413G', 'S42413K', 'S42413P', 'S42413S', 'S42414A',
        'S42414B', 'S42414D', 'S42414G', 'S42414K', 'S42414P', 'S42414S', 'S42415A', 'S42415B',
        'S42415D', 'S42415G', 'S42415K', 'S42415P', 'S42415S', 'S42416A', 'S42416B', 'S42416D',
        'S42416G', 'S42416K', 'S42416P', 'S42416S', 'S42421A', 'S42421B', 'S42421D', 'S42421G',
        'S42421K', 'S42421P', 'S42421S', 'S42422A', 'S42422B', 'S42422D', 'S42422G', 'S42422K',
        'S42422P', 'S42422S', 'S42423A', 'S42423B', 'S42423D', 'S42423G', 'S42423K', 'S42423P',
        'S42423S', 'S42424A', 'S42424B', 'S42424D', 'S42424G', 'S42424K', 'S42424P', 'S42424S',
        'S42425A', 'S42425B', 'S42425D', 'S42425G', 'S42425K', 'S42425P', 'S42425S', 'S42426A',
        'S42426B', 'S42426D', 'S42426G', 'S42426K', 'S42426P', 'S42426S', 'S42431A', 'S42431B',
        'S42431D', 'S42431G', 'S42431K', 'S42431P', 'S42431S', 'S42432A', 'S42432B', 'S42432D',
        'S42432G', 'S42432K', 'S42432P', 'S42432S', 'S42433A', 'S42433B', 'S42433D', 'S42433G',
        'S42433K', 'S42433P', 'S42433S', 'S42434A', 'S42434B', 'S42434D', 'S42434G', 'S42434K',
        'S42434P', 'S42434S', 'S42435A', 'S42435B', 'S42435D', 'S42435G', 'S42435K', 'S42435P',
        'S42435S', 'S42436A', 'S42436B', 'S42436D', 'S42436G', 'S42436K', 'S42436P', 'S42436S',
        'S42441A', 'S42441B', 'S42441D', 'S42441G', 'S42441K', 'S42441P', 'S42441S', 'S42442A',
        'S42442B', 'S42442D', 'S42442G', 'S42442K', 'S42442P', 'S42442S', 'S42443A', 'S42443B',
        'S42443D', 'S42443G', 'S42443K', 'S42443P', 'S42443S', 'S42444A', 'S42444B', 'S42444D',
        'S42444G', 'S42444K', 'S42444P', 'S42444S', 'S42445A', 'S42445B', 'S42445D', 'S42445G',
        'S42445K', 'S42445P', 'S42445S', 'S42446A', 'S42446B', 'S42446D', 'S42446G', 'S42446K',
        'S42446P', 'S42446S', 'S42447A', 'S42447B', 'S42447D', 'S42447G', 'S42447K', 'S42447P',
        'S42447S', 'S42448A', 'S42448B', 'S42448D', 'S42448G', 'S42448K', 'S42448P', 'S42448S',
        'S42449A', 'S42449B', 'S42449D', 'S42449G', 'S42449K', 'S42449P', 'S42449S', 'S42451A',
        'S42451B', 'S42451D', 'S42451G', 'S42451K', 'S42451P', 'S42451S', 'S42452A', 'S42452B',
        'S42452D', 'S42452G', 'S42452K', 'S42452P', 'S42452S', 'S42453A', 'S42453B', 'S42453D',
        'S42453G', 'S42453K', 'S42453P', 'S42453S', 'S42454A', 'S42454B', 'S42454D', 'S42454G',
        'S42454K', 'S42454P', 'S42454S', 'S42455A', 'S42455B', 'S42455D', 'S42455G', 'S42455K',
        'S42455P', 'S42455S', 'S42456A', 'S42456B', 'S42456D', 'S42456G', 'S42456K', 'S42456P',
        'S42456S', 'S42461A', 'S42461B', 'S42461D', 'S42461G', 'S42461K', 'S42461P', 'S42461S',
        'S42462A', 'S42462B', 'S42462D', 'S42462G', 'S42462K', 'S42462P', 'S42462S', 'S42463A',
        'S42463B', 'S42463D', 'S42463G', 'S42463K', 'S42463P', 'S42463S', 'S42464A', 'S42464B',
        'S42464D', 'S42464G', 'S42464K', 'S42464P', 'S42464S', 'S42465A', 'S42465B', 'S42465D',
        'S42465G', 'S42465K', 'S42465P', 'S42465S', 'S42466A', 'S42466B', 'S42466D', 'S42466G',
        'S42466K', 'S42466P', 'S42466S', 'S42471A', 'S42471B', 'S42471D', 'S42471G', 'S42471K',
        'S42471P', 'S42471S', 'S42472A', 'S42472B', 'S42472D', 'S42472G', 'S42472K', 'S42472P',
        'S42472S', 'S42473A', 'S42473B', 'S42473D', 'S42473G', 'S42473K', 'S42473P', 'S42473S',
        'S42474A', 'S42474B', 'S42474D', 'S42474G', 'S42474K', 'S42474P', 'S42474S', 'S42475A',
        'S42475B', 'S42475D', 'S42475G', 'S42475K', 'S42475P', 'S42475S', 'S42476A', 'S42476B',
        'S42476D', 'S42476G', 'S42476K', 'S42476P', 'S42476S', 'S42481A', 'S42481D', 'S42481G',
        'S42481K', 'S42481P', 'S42481S', 'S42482A', 'S42482D', 'S42482G', 'S42482K', 'S42482P',
        'S42482S', 'S42489A', 'S42489D', 'S42489G', 'S42489K', 'S42489P', 'S42489S', 'S42491A',
        'S42491B', 'S42491D', 'S42491G', 'S42491K', 'S42491P', 'S42491S', 'S42492A', 'S42492B',
        'S42492D', 'S42492G', 'S42492K', 'S42492P', 'S42492S', 'S42493A', 'S42493B', 'S42493D',
        'S42493G', 'S42493K', 'S42493P', 'S42493S', 'S42494A', 'S42494B', 'S42494D', 'S42494G',
        'S42494K', 'S42494P', 'S42494S', 'S42495A', 'S42495B', 'S42495D', 'S42495G', 'S42495K',
        'S42495P', 'S42495S', 'S42496A', 'S42496B', 'S42496D', 'S42496G', 'S42496K', 'S42496P',
        'S42496S', 'S4290XA', 'S4290XB', 'S4290XD', 'S4290XG', 'S4290XK', 'S4290XP', 'S4290XS',
        'S4291XA', 'S4291XB', 'S4291XD', 'S4291XG', 'S4291XK', 'S4291XP', 'S4291XS', 'S4292XA',
        'S4292XB', 'S4292XD', 'S4292XG', 'S4292XK', 'S4292XP', 'S4292XS', 'S43004A', 'S43004D',
        'S43004S', 'S43005A', 'S43005D', 'S43005S', 'S43006A', 'S43006D', 'S43006S', 'S43014A',
        'S43014D', 'S43014S', 'S43015A', 'S43015D', 'S43015S', 'S43016A', 'S43016D', 'S43016S',
        'S43024A', 'S43024D', 'S43024S', 'S43025A', 'S43025D', 'S43025S', 'S43026A', 'S43026D',
        'S43026S', 'S43034A', 'S43034D', 'S43034S', 'S43035A', 'S43035D', 'S43035S', 'S43036A',
        'S43036D', 'S43036S', 'S43084A', 'S43084D', 'S43084S', 'S43085A', 'S43085D', 'S43085S',
        'S43086A', 'S43086D', 'S43086S', 'S43101A', 'S43101D', 'S43101S', 'S43102A', 'S43102D',
        'S43102S', 'S43109A', 'S43109D', 'S43109S', 'S43121A', 'S43121D', 'S43121S', 'S43122A',
        'S43122D', 'S43122S', 'S43129A', 'S43129D', 'S43129S', 'S43131A', 'S43131D', 'S43131S',
        'S43132A', 'S43132D', 'S43132S', 'S43139A', 'S43139D', 'S43139S', 'S43141A', 'S43141D',
        'S43141S', 'S43142A', 'S43142D', 'S43142S', 'S43149A', 'S43149D', 'S43149S', 'S43151A',
        'S43151D', 'S43151S', 'S43152A', 'S43152D', 'S43152S', 'S43159A', 'S43159D', 'S43159S',
        'S43204A', 'S43204D', 'S43204S', 'S43205A', 'S43205D', 'S43205S', 'S43206A', 'S43206D',
        'S43206S', 'S43214A', 'S43214D', 'S43214S', 'S43215A', 'S43215D', 'S43215S', 'S43216A',
        'S43216D', 'S43216S', 'S43224A', 'S43224D', 'S43224S', 'S43225A', 'S43225D', 'S43225S',
        'S43226A', 'S43226D', 'S43226S', 'S43304A', 'S43304D', 'S43304S', 'S43305A', 'S43305D',
        'S43305S', 'S43306A', 'S43306D', 'S43306S', 'S43314A', 'S43314D', 'S43314S', 'S43315A',
        'S43315D', 'S43315S', 'S43316A', 'S43316D', 'S43316S', 'S43394A', 'S43394D', 'S43394S',
        'S43395A', 'S43395D', 'S43395S', 'S43396A', 'S43396D', 'S43396S', 'S49001A', 'S49001D',
        'S49001G', 'S49001K', 'S49001P', 'S49001S', 'S49002A', 'S49002D', 'S49002G', 'S49002K',
        'S49002P', 'S49002S', 'S49009A', 'S49009D', 'S49009G', 'S49009K', 'S49009P', 'S49009S',
        'S49011A', 'S49011D', 'S49011G', 'S49011K', 'S49011P', 'S49011S', 'S49012A', 'S49012D',
        'S49012G', 'S49012K', 'S49012P', 'S49012S', 'S49019A', 'S49019D', 'S49019G', 'S49019K',
        'S49019P', 'S49019S', 'S49021A', 'S49021D', 'S49021G', 'S49021K', 'S49021P', 'S49021S',
        'S49022A', 'S49022D', 'S49022G', 'S49022K', 'S49022P', 'S49022S', 'S49029A', 'S49029D',
        'S49029G', 'S49029K', 'S49029P', 'S49029S', 'S49031A', 'S49031D', 'S49031G', 'S49031K',
        'S49031P', 'S49031S', 'S49032A', 'S49032D', 'S49032G', 'S49032K', 'S49032P', 'S49032S',
        'S49039A', 'S49039D', 'S49039G', 'S49039K', 'S49039P', 'S49039S', 'S49041A', 'S49041D',
        'S49041G', 'S49041K', 'S49041P', 'S49041S', 'S49042A', 'S49042D', 'S49042G', 'S49042K',
        'S49042P', 'S49042S', 'S49049A', 'S49049D', 'S49049G', 'S49049K', 'S49049P', 'S49049S',
        'S49091A', 'S49091D', 'S49091G', 'S49091K', 'S49091P', 'S49091S', 'S49092A', 'S49092D',
        'S49092G', 'S49092K', 'S49092P', 'S49092S', 'S49099A', 'S49099D', 'S49099G', 'S49099K',
        'S49099P', 'S49099S', 'S49101A', 'S49101D', 'S49101G', 'S49101K', 'S49101P', 'S49101S',
        'S49102A', 'S49102D', 'S49102G', 'S49102K', 'S49102P', 'S49102S', 'S49109A', 'S49109D',
        'S49109G', 'S49109K', 'S49109P', 'S49109S', 'S49111A', 'S49111D', 'S49111G', 'S49111K',
        'S49111P', 'S49111S', 'S49112A', 'S49112D', 'S49112G', 'S49112K', 'S49112P', 'S49112S',
        'S49119A', 'S49119D', 'S49119G', 'S49119K', 'S49119P', 'S49119S', 'S49121A', 'S49121D',
        'S49121G', 'S49121K', 'S49121P', 'S49121S', 'S49122A', 'S49122D', 'S49122G', 'S49122K',
        'S49122P', 'S49122S', 'S49129A', 'S49129D', 'S49129G', 'S49129K', 'S49129P', 'S49129S',
        'S49131A', 'S49131D', 'S49131G', 'S49131K', 'S49131P', 'S49131S', 'S49132A', 'S49132D',
        'S49132G', 'S49132K', 'S49132P', 'S49132S', 'S49139A', 'S49139D', 'S49139G', 'S49139K',
        'S49139P', 'S49139S', 'S49141A', 'S49141D', 'S49141G', 'S49141K', 'S49141P', 'S49141S',
        'S49142A', 'S49142D', 'S49142G', 'S49142K', 'S49142P', 'S49142S', 'S49149A', 'S49149D',
        'S49149G', 'S49149K', 'S49149P', 'S49149S', 'S49191A', 'S49191D', 'S49191G', 'S49191K',
        'S49191P', 'S49191S', 'S49192A', 'S49192D', 'S49192G', 'S49192K', 'S49192P', 'S49192S',
        'S49199A', 'S49199D', 'S49199G', 'S49199K', 'S49199P', 'S49199S', 'S52001A', 'S52001B',
        'S52001C', 'S52001D', 'S52001E', 'S52001F', 'S52001G', 'S52001H', 'S52001J', 'S52001K',
        'S52001M', 'S52001N', 'S52001P', 'S52001Q', 'S52001R', 'S52001S', 'S52002A', 'S52002B',
        'S52002C', 'S52002D', 'S52002E', 'S52002F', 'S52002G', 'S52002H', 'S52002J', 'S52002K',
        'S52002M', 'S52002N', 'S52002P', 'S52002Q', 'S52002R', 'S52002S', 'S52009A', 'S52009B',
        'S52009C', 'S52009D', 'S52009E', 'S52009F', 'S52009G', 'S52009H', 'S52009J', 'S52009K',
        'S52009M', 'S52009N', 'S52009P', 'S52009Q', 'S52009R', 'S52009S', 'S52011A', 'S52011D',
        'S52011G', 'S52011K', 'S52011P', 'S52011S', 'S52012A', 'S52012D', 'S52012G', 'S52012K',
        'S52012P', 'S52012S', 'S52019A', 'S52019D', 'S52019G', 'S52019K', 'S52019P', 'S52019S',
        'S52021A', 'S52021B', 'S52021C', 'S52021D', 'S52021E', 'S52021F', 'S52021G', 'S52021H',
        'S52021J', 'S52021K', 'S52021M', 'S52021N', 'S52021P', 'S52021Q', 'S52021R', 'S52021S',
        'S52022A', 'S52022B', 'S52022C', 'S52022D', 'S52022E', 'S52022F', 'S52022G', 'S52022H',
        'S52022J', 'S52022K', 'S52022M', 'S52022N', 'S52022P', 'S52022Q', 'S52022R', 'S52022S',
        'S52023A', 'S52023B', 'S52023C', 'S52023D', 'S52023E', 'S52023F', 'S52023G', 'S52023H',
        'S52023J', 'S52023K', 'S52023M', 'S52023N', 'S52023P', 'S52023Q', 'S52023R', 'S52023S',
        'S52024A', 'S52024B', 'S52024C', 'S52024D', 'S52024E', 'S52024F', 'S52024G', 'S52024H',
        'S52024J', 'S52024K', 'S52024M', 'S52024N', 'S52024P', 'S52024Q', 'S52024R', 'S52024S',
        'S52025A', 'S52025B', 'S52025C', 'S52025D', 'S52025E', 'S52025F', 'S52025G', 'S52025H',
        'S52025J', 'S52025K', 'S52025M', 'S52025N', 'S52025P', 'S52025Q', 'S52025R', 'S52025S',
        'S52026A', 'S52026B', 'S52026C', 'S52026D', 'S52026E', 'S52026F', 'S52026G', 'S52026H',
        'S52026J', 'S52026K', 'S52026M', 'S52026N', 'S52026P', 'S52026Q', 'S52026R', 'S52026S',
        'S52031A', 'S52031B', 'S52031C', 'S52031D', 'S52031E', 'S52031F', 'S52031G', 'S52031H',
        'S52031J', 'S52031K', 'S52031M', 'S52031N', 'S52031P', 'S52031Q', 'S52031R', 'S52031S',
        'S52032A', 'S52032B', 'S52032C', 'S52032D', 'S52032E', 'S52032F', 'S52032G', 'S52032H',
        'S52032J', 'S52032K', 'S52032M', 'S52032N', 'S52032P', 'S52032Q', 'S52032R', 'S52032S',
        'S52033A', 'S52033B', 'S52033C', 'S52033D', 'S52033E', 'S52033F', 'S52033G', 'S52033H',
        'S52033J', 'S52033K', 'S52033M', 'S52033N', 'S52033P', 'S52033Q', 'S52033R', 'S52033S',
        'S52034A', 'S52034B', 'S52034C', 'S52034D', 'S52034E', 'S52034F', 'S52034G', 'S52034H',
        'S52034J', 'S52034K', 'S52034M', 'S52034N', 'S52034P', 'S52034Q', 'S52034R', 'S52034S',
        'S52035A', 'S52035B', 'S52035C', 'S52035D', 'S52035E', 'S52035F', 'S52035G', 'S52035H',
        'S52035J', 'S52035K', 'S52035M', 'S52035N', 'S52035P', 'S52035Q', 'S52035R', 'S52035S',
        'S52036A', 'S52036B', 'S52036C', 'S52036D', 'S52036E', 'S52036F', 'S52036G', 'S52036H',
        'S52036J', 'S52036K', 'S52036M', 'S52036N', 'S52036P', 'S52036Q', 'S52036R', 'S52036S',
        'S52041A', 'S52041B', 'S52041C', 'S52041D', 'S52041E', 'S52041F', 'S52041G', 'S52041H',
        'S52041J', 'S52041K', 'S52041M', 'S52041N', 'S52041P', 'S52041Q', 'S52041R', 'S52041S',
        'S52042A', 'S52042B', 'S52042C', 'S52042D', 'S52042E', 'S52042F', 'S52042G', 'S52042H',
        'S52042J', 'S52042K', 'S52042M', 'S52042N', 'S52042P', 'S52042Q', 'S52042R', 'S52042S',
        'S52043A', 'S52043B', 'S52043C', 'S52043D', 'S52043E', 'S52043F', 'S52043G', 'S52043H',
        'S52043J', 'S52043K', 'S52043M', 'S52043N', 'S52043P', 'S52043Q', 'S52043R', 'S52043S',
        'S52044A', 'S52044B', 'S52044C', 'S52044D', 'S52044E', 'S52044F', 'S52044G', 'S52044H',
        'S52044J', 'S52044K', 'S52044M', 'S52044N', 'S52044P', 'S52044Q', 'S52044R', 'S52044S',
        'S52045A', 'S52045B', 'S52045C', 'S52045D', 'S52045E', 'S52045F', 'S52045G', 'S52045H',
        'S52045J', 'S52045K', 'S52045M', 'S52045N', 'S52045P', 'S52045Q', 'S52045R', 'S52045S',
        'S52046A', 'S52046B', 'S52046C', 'S52046D', 'S52046E', 'S52046F', 'S52046G', 'S52046H',
        'S52046J', 'S52046K', 'S52046M', 'S52046N', 'S52046P', 'S52046Q', 'S52046R', 'S52046S',
        'S52091A', 'S52091B', 'S52091C', 'S52091D', 'S52091E', 'S52091F', 'S52091G', 'S52091H',
        'S52091J', 'S52091K', 'S52091M', 'S52091N', 'S52091P', 'S52091Q', 'S52091R', 'S52091S',
        'S52092A', 'S52092B', 'S52092C', 'S52092D', 'S52092E', 'S52092F', 'S52092G', 'S52092H',
        'S52092J', 'S52092K', 'S52092M', 'S52092N', 'S52092P', 'S52092Q', 'S52092R', 'S52092S',
        'S52099A', 'S52099B', 'S52099C', 'S52099D', 'S52099E', 'S52099F', 'S52099G', 'S52099H',
        'S52099J', 'S52099K', 'S52099M', 'S52099N', 'S52099P', 'S52099Q', 'S52099R', 'S52099S',
        'S52101A', 'S52101B', 'S52101C', 'S52101D', 'S52101E', 'S52101F', 'S52101G', 'S52101H',
        'S52101J', 'S52101K', 'S52101M', 'S52101N', 'S52101P', 'S52101Q', 'S52101R', 'S52101S',
        'S52102A', 'S52102B', 'S52102C', 'S52102D', 'S52102E', 'S52102F', 'S52102G', 'S52102H',
        'S52102J', 'S52102K', 'S52102M', 'S52102N', 'S52102P', 'S52102Q', 'S52102R', 'S52102S',
        'S52109A', 'S52109B', 'S52109C', 'S52109D', 'S52109E', 'S52109F', 'S52109G', 'S52109H',
        'S52109J', 'S52109K', 'S52109M', 'S52109N', 'S52109P', 'S52109Q', 'S52109R', 'S52109S',
        'S52111A', 'S52111D', 'S52111G', 'S52111K', 'S52111P', 'S52111S', 'S52112A', 'S52112D',
        'S52112G', 'S52112K', 'S52112P', 'S52112S', 'S52119A', 'S52119D', 'S52119G', 'S52119K',
        'S52119P', 'S52119S', 'S52121A', 'S52121B', 'S52121C', 'S52121D', 'S52121E', 'S52121F',
        'S52121G', 'S52121H', 'S52121J', 'S52121K', 'S52121M', 'S52121N', 'S52121P', 'S52121Q',
        'S52121R', 'S52121S', 'S52122A', 'S52122B', 'S52122C', 'S52122D', 'S52122E', 'S52122F',
        'S52122G', 'S52122H', 'S52122J', 'S52122K', 'S52122M', 'S52122N', 'S52122P', 'S52122Q',
        'S52122R', 'S52122S', 'S52123A', 'S52123B', 'S52123C', 'S52123D', 'S52123E', 'S52123F',
        'S52123G', 'S52123H', 'S52123J', 'S52123K', 'S52123M', 'S52123N', 'S52123P', 'S52123Q',
        'S52123R', 'S52123S', 'S52124A', 'S52124B', 'S52124C', 'S52124D', 'S52124E', 'S52124F',
        'S52124G', 'S52124H', 'S52124J', 'S52124K', 'S52124M', 'S52124N', 'S52124P', 'S52124Q',
        'S52124R', 'S52124S', 'S52125A', 'S52125B', 'S52125C', 'S52125D', 'S52125E', 'S52125F',
        'S52125G', 'S52125H', 'S52125J', 'S52125K', 'S52125M', 'S52125N', 'S52125P', 'S52125Q',
        'S52125R', 'S52125S', 'S52126A', 'S52126B', 'S52126C', 'S52126D', 'S52126E', 'S52126F',
        'S52126G', 'S52126H', 'S52126J', 'S52126K', 'S52126M', 'S52126N', 'S52126P', 'S52126Q',
        'S52126R', 'S52126S', 'S52131A', 'S52131B', 'S52131C', 'S52131D', 'S52131E', 'S52131F',
        'S52131G', 'S52131H', 'S52131J', 'S52131K', 'S52131M', 'S52131N', 'S52131P', 'S52131Q',
        'S52131R', 'S52131S', 'S52132A', 'S52132B', 'S52132C', 'S52132D', 'S52132E', 'S52132F',
        'S52132G', 'S52132H', 'S52132J', 'S52132K', 'S52132M', 'S52132N', 'S52132P', 'S52132Q',
        'S52132R', 'S52132S', 'S52133A', 'S52133B', 'S52133C', 'S52133D', 'S52133E', 'S52133F',
        'S52133G', 'S52133H', 'S52133J', 'S52133K', 'S52133M', 'S52133N', 'S52133P', 'S52133Q',
        'S52133R', 'S52133S', 'S52134A', 'S52134B', 'S52134C', 'S52134D', 'S52134E', 'S52134F',
        'S52134G', 'S52134H', 'S52134J', 'S52134K', 'S52134M', 'S52134N', 'S52134P', 'S52134Q',
        'S52134R', 'S52134S', 'S52135A', 'S52135B', 'S52135C', 'S52135D', 'S52135E', 'S52135F',
        'S52135G', 'S52135H', 'S52135J', 'S52135K', 'S52135M', 'S52135N', 'S52135P', 'S52135Q',
        'S52135R', 'S52135S', 'S52136A', 'S52136B', 'S52136C', 'S52136D', 'S52136E', 'S52136F',
        'S52136G', 'S52136H', 'S52136J', 'S52136K', 'S52136M', 'S52136N', 'S52136P', 'S52136Q',
        'S52136R', 'S52136S', 'S52181A', 'S52181B', 'S52181C', 'S52181D', 'S52181E', 'S52181F',
        'S52181G', 'S52181H', 'S52181J', 'S52181K', 'S52181M', 'S52181N', 'S52181P', 'S52181Q',
        'S52181R', 'S52181S', 'S52182A', 'S52182B', 'S52182C', 'S52182D', 'S52182E', 'S52182F',
        'S52182G', 'S52182H', 'S52182J', 'S52182K', 'S52182M', 'S52182N', 'S52182P', 'S52182Q',
        'S52182R', 'S52182S', 'S52189A', 'S52189B', 'S52189C', 'S52189D', 'S52189E', 'S52189F',
        'S52189G', 'S52189H', 'S52189J', 'S52189K', 'S52189M', 'S52189N', 'S52189P', 'S52189Q',
        'S52189R', 'S52189S', 'S52201A', 'S52201B', 'S52201C', 'S52201D', 'S52201E', 'S52201F',
        'S52201G', 'S52201H', 'S52201J', 'S52201K', 'S52201M', 'S52201N', 'S52201P', 'S52201Q',
        'S52201R', 'S52201S', 'S52202A', 'S52202B', 'S52202C', 'S52202D', 'S52202E', 'S52202F',
        'S52202G', 'S52202H', 'S52202J', 'S52202K', 'S52202M', 'S52202N', 'S52202P', 'S52202Q',
        'S52202R', 'S52202S', 'S52209A', 'S52209B', 'S52209C', 'S52209D', 'S52209E', 'S52209F',
        'S52209G', 'S52209H', 'S52209J', 'S52209K', 'S52209M', 'S52209N', 'S52209P', 'S52209Q',
        'S52209R', 'S52209S', 'S52211A', 'S52211D', 'S52211G', 'S52211K', 'S52211P', 'S52211S',
        'S52212A', 'S52212D', 'S52212G', 'S52212K', 'S52212P', 'S52212S', 'S52219A', 'S52219D',
        'S52219G', 'S52219K', 'S52219P', 'S52219S', 'S52221A', 'S52221B', 'S52221C', 'S52221D',
        'S52221E', 'S52221F', 'S52221G', 'S52221H', 'S52221J', 'S52221K', 'S52221M', 'S52221N',
        'S52221P', 'S52221Q', 'S52221R', 'S52221S', 'S52222A', 'S52222B', 'S52222C', 'S52222D',
        'S52222E', 'S52222F', 'S52222G', 'S52222H', 'S52222J', 'S52222K', 'S52222M', 'S52222N',
        'S52222P', 'S52222Q', 'S52222R', 'S52222S', 'S52223A', 'S52223B', 'S52223C', 'S52223D',
        'S52223E', 'S52223F', 'S52223G', 'S52223H', 'S52223J', 'S52223K', 'S52223M', 'S52223N',
        'S52223P', 'S52223Q', 'S52223R', 'S52223S', 'S52224A', 'S52224B', 'S52224C', 'S52224D',
        'S52224E', 'S52224F', 'S52224G', 'S52224H', 'S52224J', 'S52224K', 'S52224M', 'S52224N',
        'S52224P', 'S52224Q', 'S52224R', 'S52224S', 'S52225A', 'S52225B', 'S52225C', 'S52225D',
        'S52225E', 'S52225F', 'S52225G', 'S52225H', 'S52225J', 'S52225K', 'S52225M', 'S52225N',
        'S52225P', 'S52225Q', 'S52225R', 'S52225S', 'S52226A', 'S52226B', 'S52226C', 'S52226D',
        'S52226E', 'S52226F', 'S52226G', 'S52226H', 'S52226J', 'S52226K', 'S52226M', 'S52226N',
        'S52226P', 'S52226Q', 'S52226R', 'S52226S', 'S52231A', 'S52231B', 'S52231C', 'S52231D',
        'S52231E', 'S52231F', 'S52231G', 'S52231H', 'S52231J', 'S52231K', 'S52231M', 'S52231N',
        'S52231P', 'S52231Q', 'S52231R', 'S52231S', 'S52232A', 'S52232B', 'S52232C', 'S52232D',
        'S52232E', 'S52232F', 'S52232G', 'S52232H', 'S52232J', 'S52232K', 'S52232M', 'S52232N',
        'S52232P', 'S52232Q', 'S52232R', 'S52232S', 'S52233A', 'S52233B', 'S52233C', 'S52233D',
        'S52233E', 'S52233F', 'S52233G', 'S52233H', 'S52233J', 'S52233K', 'S52233M', 'S52233N',
        'S52233P', 'S52233Q', 'S52233R', 'S52233S', 'S52234A', 'S52234B', 'S52234C', 'S52234D',
        'S52234E', 'S52234F', 'S52234G', 'S52234H', 'S52234J', 'S52234K', 'S52234M', 'S52234N',
        'S52234P', 'S52234Q', 'S52234R', 'S52234S', 'S52235A', 'S52235B', 'S52235C', 'S52235D',
        'S52235E', 'S52235F', 'S52235G', 'S52235H', 'S52235J', 'S52235K', 'S52235M', 'S52235N',
        'S52235P', 'S52235Q', 'S52235R', 'S52235S', 'S52236A', 'S52236B', 'S52236C', 'S52236D',
        'S52236E', 'S52236F', 'S52236G', 'S52236H', 'S52236J', 'S52236K', 'S52236M', 'S52236N',
        'S52236P', 'S52236Q', 'S52236R', 'S52236S', 'S52241A', 'S52241B', 'S52241C', 'S52241D',
        'S52241E', 'S52241F', 'S52241G', 'S52241H', 'S52241J', 'S52241K', 'S52241M', 'S52241N',
        'S52241P', 'S52241Q', 'S52241R', 'S52241S', 'S52242A', 'S52242B', 'S52242C', 'S52242D',
        'S52242E', 'S52242F', 'S52242G', 'S52242H', 'S52242J', 'S52242K', 'S52242M', 'S52242N',
        'S52242P', 'S52242Q', 'S52242R', 'S52242S', 'S52243A', 'S52243B', 'S52243C', 'S52243D',
        'S52243E', 'S52243F', 'S52243G', 'S52243H', 'S52243J', 'S52243K', 'S52243M', 'S52243N',
        'S52243P', 'S52243Q', 'S52243R', 'S52243S', 'S52244A', 'S52244B', 'S52244C', 'S52244D',
        'S52244E', 'S52244F', 'S52244G', 'S52244H', 'S52244J', 'S52244K', 'S52244M', 'S52244N',
        'S52244P', 'S52244Q', 'S52244R', 'S52244S', 'S52245A', 'S52245B', 'S52245C', 'S52245D',
        'S52245E', 'S52245F', 'S52245G', 'S52245H', 'S52245J', 'S52245K', 'S52245M', 'S52245N',
        'S52245P', 'S52245Q', 'S52245R', 'S52245S', 'S52246A', 'S52246B', 'S52246C', 'S52246D',
        'S52246E', 'S52246F', 'S52246G', 'S52246H', 'S52246J', 'S52246K', 'S52246M', 'S52246N',
        'S52246P', 'S52246Q', 'S52246R', 'S52246S', 'S52251A', 'S52251B', 'S52251C', 'S52251D',
        'S52251E', 'S52251F', 'S52251G', 'S52251H', 'S52251J', 'S52251K', 'S52251M', 'S52251N',
        'S52251P', 'S52251Q', 'S52251R', 'S52251S', 'S52252A', 'S52252B', 'S52252C', 'S52252D',
        'S52252E', 'S52252F', 'S52252G', 'S52252H', 'S52252J', 'S52252K', 'S52252M', 'S52252N',
        'S52252P', 'S52252Q', 'S52252R', 'S52252S', 'S52253A', 'S52253B', 'S52253C', 'S52253D',
        'S52253E', 'S52253F', 'S52253G', 'S52253H', 'S52253J', 'S52253K', 'S52253M', 'S52253N',
        'S52253P', 'S52253Q', 'S52253R', 'S52253S', 'S52254A', 'S52254B', 'S52254C', 'S52254D',
        'S52254E', 'S52254F', 'S52254G', 'S52254H', 'S52254J', 'S52254K', 'S52254M', 'S52254N',
        'S52254P', 'S52254Q', 'S52254R', 'S52254S', 'S52255A', 'S52255B', 'S52255C', 'S52255D',
        'S52255E', 'S52255F', 'S52255G', 'S52255H', 'S52255J', 'S52255K', 'S52255M', 'S52255N',
        'S52255P', 'S52255Q', 'S52255R', 'S52255S', 'S52256A', 'S52256B', 'S52256C', 'S52256D',
        'S52256E', 'S52256F', 'S52256G', 'S52256H', 'S52256J', 'S52256K', 'S52256M', 'S52256N',
        'S52256P', 'S52256Q', 'S52256R', 'S52256S', 'S52261A', 'S52261B', 'S52261C', 'S52261D',
        'S52261E', 'S52261F', 'S52261G', 'S52261H', 'S52261J', 'S52261K', 'S52261M', 'S52261N',
        'S52261P', 'S52261Q', 'S52261R', 'S52261S', 'S52262A', 'S52262B', 'S52262C', 'S52262D',
        'S52262E', 'S52262F', 'S52262G', 'S52262H', 'S52262J', 'S52262K', 'S52262M', 'S52262N',
        'S52262P', 'S52262Q', 'S52262R', 'S52262S', 'S52263A', 'S52263B', 'S52263C', 'S52263D',
        'S52263E', 'S52263F', 'S52263G', 'S52263H', 'S52263J', 'S52263K', 'S52263M', 'S52263N',
        'S52263P', 'S52263Q', 'S52263R', 'S52263S', 'S52264A', 'S52264B', 'S52264C', 'S52264D',
        'S52264E', 'S52264F', 'S52264G', 'S52264H', 'S52264J', 'S52264K', 'S52264M', 'S52264N',
        'S52264P', 'S52264Q', 'S52264R', 'S52264S', 'S52265A', 'S52265B', 'S52265C', 'S52265D',
        'S52265E', 'S52265F', 'S52265G', 'S52265H', 'S52265J', 'S52265K', 'S52265M', 'S52265N',
        'S52265P', 'S52265Q', 'S52265R', 'S52265S', 'S52266A', 'S52266B', 'S52266C', 'S52266D',
        'S52266E', 'S52266F', 'S52266G', 'S52266H', 'S52266J', 'S52266K', 'S52266M', 'S52266N',
        'S52266P', 'S52266Q', 'S52266R', 'S52266S', 'S52271A', 'S52271B', 'S52271C', 'S52271D',
        'S52271E', 'S52271F', 'S52271G', 'S52271H', 'S52271J', 'S52271K', 'S52271M', 'S52271N',
        'S52271P', 'S52271Q', 'S52271R', 'S52271S', 'S52272A', 'S52272B', 'S52272C', 'S52272D',
        'S52272E', 'S52272F', 'S52272G', 'S52272H', 'S52272J', 'S52272K', 'S52272M', 'S52272N',
        'S52272P', 'S52272Q', 'S52272R', 'S52272S', 'S52279A', 'S52279B', 'S52279C', 'S52279D',
        'S52279E', 'S52279F', 'S52279G', 'S52279H', 'S52279J', 'S52279K', 'S52279M', 'S52279N',
        'S52279P', 'S52279Q', 'S52279R', 'S52279S', 'S52281A', 'S52281B', 'S52281C', 'S52281D',
        'S52281E', 'S52281F', 'S52281G', 'S52281H', 'S52281J', 'S52281K', 'S52281M', 'S52281N',
        'S52281P', 'S52281Q', 'S52281R', 'S52281S', 'S52282A', 'S52282B', 'S52282C', 'S52282D',
        'S52282E', 'S52282F', 'S52282G', 'S52282H', 'S52282J', 'S52282K', 'S52282M', 'S52282N',
        'S52282P', 'S52282Q', 'S52282R', 'S52282S', 'S52283A', 'S52283B', 'S52283C', 'S52283D',
        'S52283E', 'S52283F', 'S52283G', 'S52283H', 'S52283J', 'S52283K', 'S52283M', 'S52283N',
        'S52283P', 'S52283Q', 'S52283R', 'S52283S', 'S52291A', 'S52291B', 'S52291C', 'S52291D',
        'S52291E', 'S52291F', 'S52291G', 'S52291H', 'S52291J', 'S52291K', 'S52291M', 'S52291N',
        'S52291P', 'S52291Q', 'S52291R', 'S52291S', 'S52292A', 'S52292B', 'S52292C', 'S52292D',
        'S52292E', 'S52292F', 'S52292G', 'S52292H', 'S52292J', 'S52292K', 'S52292M', 'S52292N',
        'S52292P', 'S52292Q', 'S52292R', 'S52292S', 'S52299A', 'S52299B', 'S52299C', 'S52299D',
        'S52299E', 'S52299F', 'S52299G', 'S52299H', 'S52299J', 'S52299K', 'S52299M', 'S52299N',
        'S52299P', 'S52299Q', 'S52299R', 'S52299S', 'S52301A', 'S52301B', 'S52301C', 'S52301D',
        'S52301E', 'S52301F', 'S52301G', 'S52301H', 'S52301J', 'S52301K', 'S52301M', 'S52301N',
        'S52301P', 'S52301Q', 'S52301R', 'S52301S', 'S52302A', 'S52302B', 'S52302C', 'S52302D',
        'S52302E', 'S52302F', 'S52302G', 'S52302H', 'S52302J', 'S52302K', 'S52302M', 'S52302N',
        'S52302P', 'S52302Q', 'S52302R', 'S52302S', 'S52309A', 'S52309B', 'S52309C', 'S52309D',
        'S52309E', 'S52309F', 'S52309G', 'S52309H', 'S52309J', 'S52309K', 'S52309M', 'S52309N',
        'S52309P', 'S52309Q', 'S52309R', 'S52309S', 'S52311A', 'S52311D', 'S52311G', 'S52311K',
        'S52311P', 'S52311S', 'S52312A', 'S52312D', 'S52312G', 'S52312K', 'S52312P', 'S52312S',
        'S52319A', 'S52319D', 'S52319G', 'S52319K', 'S52319P', 'S52319S', 'S52321A', 'S52321B',
        'S52321C', 'S52321D', 'S52321E', 'S52321F', 'S52321G', 'S52321H', 'S52321J', 'S52321K',
        'S52321M', 'S52321N', 'S52321P', 'S52321Q', 'S52321R', 'S52321S', 'S52322A', 'S52322B',
        'S52322C', 'S52322D', 'S52322E', 'S52322F', 'S52322G', 'S52322H', 'S52322J', 'S52322K',
        'S52322M', 'S52322N', 'S52322P', 'S52322Q', 'S52322R', 'S52322S', 'S52323A', 'S52323B',
        'S52323C', 'S52323D', 'S52323E', 'S52323F', 'S52323G', 'S52323H', 'S52323J', 'S52323K',
        'S52323M', 'S52323N', 'S52323P', 'S52323Q', 'S52323R', 'S52323S', 'S52324A', 'S52324B',
        'S52324C', 'S52324D', 'S52324E', 'S52324F', 'S52324G', 'S52324H', 'S52324J', 'S52324K',
        'S52324M', 'S52324N', 'S52324P', 'S52324Q', 'S52324R', 'S52324S', 'S52325A', 'S52325B',
        'S52325C', 'S52325D', 'S52325E', 'S52325F', 'S52325G', 'S52325H', 'S52325J', 'S52325K',
        'S52325M', 'S52325N', 'S52325P', 'S52325Q', 'S52325R', 'S52325S', 'S52326A', 'S52326B',
        'S52326C', 'S52326D', 'S52326E', 'S52326F', 'S52326G', 'S52326H', 'S52326J', 'S52326K',
        'S52326M', 'S52326N', 'S52326P', 'S52326Q', 'S52326R', 'S52326S', 'S52331A', 'S52331B',
        'S52331C', 'S52331D', 'S52331E', 'S52331F', 'S52331G', 'S52331H', 'S52331J', 'S52331K',
        'S52331M', 'S52331N', 'S52331P', 'S52331Q', 'S52331R', 'S52331S', 'S52332A', 'S52332B',
        'S52332C', 'S52332D', 'S52332E', 'S52332F', 'S52332G', 'S52332H', 'S52332J', 'S52332K',
        'S52332M', 'S52332N', 'S52332P', 'S52332Q', 'S52332R', 'S52332S', 'S52333A', 'S52333B',
        'S52333C', 'S52333D', 'S52333E', 'S52333F', 'S52333G', 'S52333H', 'S52333J', 'S52333K',
        'S52333M', 'S52333N', 'S52333P', 'S52333Q', 'S52333R', 'S52333S', 'S52334A', 'S52334B',
        'S52334C', 'S52334D', 'S52334E', 'S52334F', 'S52334G', 'S52334H', 'S52334J', 'S52334K',
        'S52334M', 'S52334N', 'S52334P', 'S52334Q', 'S52334R', 'S52334S', 'S52335A', 'S52335B',
        'S52335C', 'S52335D', 'S52335E', 'S52335F', 'S52335G', 'S52335H', 'S52335J', 'S52335K',
        'S52335M', 'S52335N', 'S52335P', 'S52335Q', 'S52335R', 'S52335S', 'S52336A', 'S52336B',
        'S52336C', 'S52336D', 'S52336E', 'S52336F', 'S52336G', 'S52336H', 'S52336J', 'S52336K',
        'S52336M', 'S52336N', 'S52336P', 'S52336Q', 'S52336R', 'S52336S', 'S52341A', 'S52341B',
        'S52341C', 'S52341D', 'S52341E', 'S52341F', 'S52341G', 'S52341H', 'S52341J', 'S52341K',
        'S52341M', 'S52341N', 'S52341P', 'S52341Q', 'S52341R', 'S52341S', 'S52342A', 'S52342B',
        'S52342C', 'S52342D', 'S52342E', 'S52342F', 'S52342G', 'S52342H', 'S52342J', 'S52342K',
        'S52342M', 'S52342N', 'S52342P', 'S52342Q', 'S52342R', 'S52342S', 'S52343A', 'S52343B',
        'S52343C', 'S52343D', 'S52343E', 'S52343F', 'S52343G', 'S52343H', 'S52343J', 'S52343K',
        'S52343M', 'S52343N', 'S52343P', 'S52343Q', 'S52343R', 'S52343S', 'S52344A', 'S52344B',
        'S52344C', 'S52344D', 'S52344E', 'S52344F', 'S52344G', 'S52344H', 'S52344J', 'S52344K',
        'S52344M', 'S52344N', 'S52344P', 'S52344Q', 'S52344R', 'S52344S', 'S52345A', 'S52345B',
        'S52345C', 'S52345D', 'S52345E', 'S52345F', 'S52345G', 'S52345H', 'S52345J', 'S52345K',
        'S52345M', 'S52345N', 'S52345P', 'S52345Q', 'S52345R', 'S52345S', 'S52346A', 'S52346B',
        'S52346C', 'S52346D', 'S52346E', 'S52346F', 'S52346G', 'S52346H', 'S52346J', 'S52346K',
        'S52346M', 'S52346N', 'S52346P', 'S52346Q', 'S52346R', 'S52346S', 'S52351A', 'S52351B',
        'S52351C', 'S52351D', 'S52351E', 'S52351F', 'S52351G', 'S52351H', 'S52351J', 'S52351K',
        'S52351M', 'S52351N', 'S52351P', 'S52351Q', 'S52351R', 'S52351S', 'S52352A', 'S52352B',
        'S52352C', 'S52352D', 'S52352E', 'S52352F', 'S52352G', 'S52352H', 'S52352J', 'S52352K',
        'S52352M', 'S52352N', 'S52352P', 'S52352Q', 'S52352R', 'S52352S', 'S52353A', 'S52353B',
        'S52353C', 'S52353D', 'S52353E', 'S52353F', 'S52353G', 'S52353H', 'S52353J', 'S52353K',
        'S52353M', 'S52353N', 'S52353P', 'S52353Q', 'S52353R', 'S52353S', 'S52354A', 'S52354B',
        'S52354C', 'S52354D', 'S52354E', 'S52354F', 'S52354G', 'S52354H', 'S52354J', 'S52354K',
        'S52354M', 'S52354N', 'S52354P', 'S52354Q', 'S52354R', 'S52354S', 'S52355A', 'S52355B',
        'S52355C', 'S52355D', 'S52355E', 'S52355F', 'S52355G', 'S52355H', 'S52355J', 'S52355K',
        'S52355M', 'S52355N', 'S52355P', 'S52355Q', 'S52355R', 'S52355S', 'S52356A', 'S52356B',
        'S52356C', 'S52356D', 'S52356E', 'S52356F', 'S52356G', 'S52356H', 'S52356J', 'S52356K',
        'S52356M', 'S52356N', 'S52356P', 'S52356Q', 'S52356R', 'S52356S', 'S52361A', 'S52361B',
        'S52361C', 'S52361D', 'S52361E', 'S52361F', 'S52361G', 'S52361H', 'S52361J', 'S52361K',
        'S52361M', 'S52361N', 'S52361P', 'S52361Q', 'S52361R', 'S52361S', 'S52362A', 'S52362B',
        'S52362C', 'S52362D', 'S52362E', 'S52362F', 'S52362G', 'S52362H', 'S52362J', 'S52362K',
        'S52362M', 'S52362N', 'S52362P', 'S52362Q', 'S52362R', 'S52362S', 'S52363A', 'S52363B',
        'S52363C', 'S52363D', 'S52363E', 'S52363F', 'S52363G', 'S52363H', 'S52363J', 'S52363K',
        'S52363M', 'S52363N', 'S52363P', 'S52363Q', 'S52363R', 'S52363S', 'S52364A', 'S52364B',
        'S52364C', 'S52364D', 'S52364E', 'S52364F', 'S52364G', 'S52364H', 'S52364J', 'S52364K',
        'S52364M', 'S52364N', 'S52364P', 'S52364Q', 'S52364R', 'S52364S', 'S52365A', 'S52365B',
        'S52365C', 'S52365D', 'S52365E', 'S52365F', 'S52365G', 'S52365H', 'S52365J', 'S52365K',
        'S52365M', 'S52365N', 'S52365P', 'S52365Q', 'S52365R', 'S52365S', 'S52366A', 'S52366B',
        'S52366C', 'S52366D', 'S52366E', 'S52366F', 'S52366G', 'S52366H', 'S52366J', 'S52366K',
        'S52366M', 'S52366N', 'S52366P', 'S52366Q', 'S52366R', 'S52366S', 'S52371A', 'S52371B',
        'S52371C', 'S52371D', 'S52371E', 'S52371F', 'S52371G', 'S52371H', 'S52371J', 'S52371K',
        'S52371M', 'S52371N', 'S52371P', 'S52371Q', 'S52371R', 'S52371S', 'S52372A', 'S52372B',
        'S52372C', 'S52372D', 'S52372E', 'S52372F', 'S52372G', 'S52372H', 'S52372J', 'S52372K',
        'S52372M', 'S52372N', 'S52372P', 'S52372Q', 'S52372R', 'S52372S', 'S52379A', 'S52379B',
        'S52379C', 'S52379D', 'S52379E', 'S52379F', 'S52379G', 'S52379H', 'S52379J', 'S52379K',
        'S52379M', 'S52379N', 'S52379P', 'S52379Q', 'S52379R', 'S52379S', 'S52381A', 'S52381B',
        'S52381C', 'S52381D', 'S52381E', 'S52381F', 'S52381G', 'S52381H', 'S52381J', 'S52381K',
        'S52381M', 'S52381N', 'S52381P', 'S52381Q', 'S52381R', 'S52381S', 'S52382A', 'S52382B',
        'S52382C', 'S52382D', 'S52382E', 'S52382F', 'S52382G', 'S52382H', 'S52382J', 'S52382K',
        'S52382M', 'S52382N', 'S52382P', 'S52382Q', 'S52382R', 'S52382S', 'S52389A', 'S52389B',
        'S52389C', 'S52389D', 'S52389E', 'S52389F', 'S52389G', 'S52389H', 'S52389J', 'S52389K',
        'S52389M', 'S52389N', 'S52389P', 'S52389Q', 'S52389R', 'S52389S', 'S52391A', 'S52391B',
        'S52391C', 'S52391D', 'S52391E', 'S52391F', 'S52391G', 'S52391H', 'S52391J', 'S52391K',
        'S52391M', 'S52391N', 'S52391P', 'S52391Q', 'S52391R', 'S52391S', 'S52392A', 'S52392B',
        'S52392C', 'S52392D', 'S52392E', 'S52392F', 'S52392G', 'S52392H', 'S52392J', 'S52392K',
        'S52392M', 'S52392N', 'S52392P', 'S52392Q', 'S52392R', 'S52392S', 'S52399A', 'S52399B',
        'S52399C', 'S52399D', 'S52399E', 'S52399F', 'S52399G', 'S52399H', 'S52399J', 'S52399K',
        'S52399M', 'S52399N', 'S52399P', 'S52399Q', 'S52399R', 'S52399S', 'S52501A', 'S52501B',
        'S52501C', 'S52501D', 'S52501E', 'S52501F', 'S52501G', 'S52501H', 'S52501J', 'S52501K',
        'S52501M', 'S52501N', 'S52501P', 'S52501Q', 'S52501R', 'S52501S', 'S52502A', 'S52502B',
        'S52502C', 'S52502D', 'S52502E', 'S52502F', 'S52502G', 'S52502H', 'S52502J', 'S52502K',
        'S52502M', 'S52502N', 'S52502P', 'S52502Q', 'S52502R', 'S52502S', 'S52509A', 'S52509B',
        'S52509C', 'S52509D', 'S52509E', 'S52509F', 'S52509G', 'S52509H', 'S52509J', 'S52509K',
        'S52509M', 'S52509N', 'S52509P', 'S52509Q', 'S52509R', 'S52509S', 'S52511A', 'S52511B',
        'S52511C', 'S52511D', 'S52511E', 'S52511F', 'S52511G', 'S52511H', 'S52511J', 'S52511K',
        'S52511M', 'S52511N', 'S52511P', 'S52511Q', 'S52511R', 'S52511S', 'S52512A', 'S52512B',
        'S52512C', 'S52512D', 'S52512E', 'S52512F', 'S52512G', 'S52512H', 'S52512J', 'S52512K',
        'S52512M', 'S52512N', 'S52512P', 'S52512Q', 'S52512R', 'S52512S', 'S52513A', 'S52513B',
        'S52513C', 'S52513D', 'S52513E', 'S52513F', 'S52513G', 'S52513H', 'S52513J', 'S52513K',
        'S52513M', 'S52513N', 'S52513P', 'S52513Q', 'S52513R', 'S52513S', 'S52514A', 'S52514B',
        'S52514C', 'S52514D', 'S52514E', 'S52514F', 'S52514G', 'S52514H', 'S52514J', 'S52514K',
        'S52514M', 'S52514N', 'S52514P', 'S52514Q', 'S52514R', 'S52514S', 'S52515A', 'S52515B',
        'S52515C', 'S52515D', 'S52515E', 'S52515F', 'S52515G', 'S52515H', 'S52515J', 'S52515K',
        'S52515M', 'S52515N', 'S52515P', 'S52515Q', 'S52515R', 'S52515S', 'S52516A', 'S52516B',
        'S52516C', 'S52516D', 'S52516E', 'S52516F', 'S52516G', 'S52516H', 'S52516J', 'S52516K',
        'S52516M', 'S52516N', 'S52516P', 'S52516Q', 'S52516R', 'S52516S', 'S52521A', 'S52521D',
        'S52521G', 'S52521K', 'S52521P', 'S52521S', 'S52522A', 'S52522D', 'S52522G', 'S52522K',
        'S52522P', 'S52522S', 'S52529A', 'S52529D', 'S52529G', 'S52529K', 'S52529P', 'S52529S',
        'S52531A', 'S52531B', 'S52531C', 'S52531D', 'S52531E', 'S52531F', 'S52531G', 'S52531H',
        'S52531J', 'S52531K', 'S52531M', 'S52531N', 'S52531P', 'S52531Q', 'S52531R', 'S52531S',
        'S52532A', 'S52532B', 'S52532C', 'S52532D', 'S52532E', 'S52532F', 'S52532G', 'S52532H',
        'S52532J', 'S52532K', 'S52532M', 'S52532N', 'S52532P', 'S52532Q', 'S52532R', 'S52532S',
        'S52539A', 'S52539B', 'S52539C', 'S52539D', 'S52539E', 'S52539F', 'S52539G', 'S52539H',
        'S52539J', 'S52539K', 'S52539M', 'S52539N', 'S52539P', 'S52539Q', 'S52539R', 'S52539S',
        'S52541A', 'S52541B', 'S52541C', 'S52541D', 'S52541E', 'S52541F', 'S52541G', 'S52541H',
        'S52541J', 'S52541K', 'S52541M', 'S52541N', 'S52541P', 'S52541Q', 'S52541R', 'S52541S',
        'S52542A', 'S52542B', 'S52542C', 'S52542D', 'S52542E', 'S52542F', 'S52542G', 'S52542H',
        'S52542J', 'S52542K', 'S52542M', 'S52542N', 'S52542P', 'S52542Q', 'S52542R', 'S52542S',
        'S52549A', 'S52549B', 'S52549C', 'S52549D', 'S52549E', 'S52549F', 'S52549G', 'S52549H',
        'S52549J', 'S52549K', 'S52549M', 'S52549N', 'S52549P', 'S52549Q', 'S52549R', 'S52549S',
        'S52551A', 'S52551B', 'S52551C', 'S52551D', 'S52551E', 'S52551F', 'S52551G', 'S52551H',
        'S52551J', 'S52551K', 'S52551M', 'S52551N', 'S52551P', 'S52551Q', 'S52551R', 'S52551S',
        'S52552A', 'S52552B', 'S52552C', 'S52552D', 'S52552E', 'S52552F', 'S52552G', 'S52552H',
        'S52552J', 'S52552K', 'S52552M', 'S52552N', 'S52552P', 'S52552Q', 'S52552R', 'S52552S',
        'S52559A', 'S52559B', 'S52559C', 'S52559D', 'S52559E', 'S52559F', 'S52559G', 'S52559H',
        'S52559J', 'S52559K', 'S52559M', 'S52559N', 'S52559P', 'S52559Q', 'S52559R', 'S52559S',
        'S52561A', 'S52561B', 'S52561C', 'S52561D', 'S52561E', 'S52561F', 'S52561G', 'S52561H',
        'S52561J', 'S52561K', 'S52561M', 'S52561N', 'S52561P', 'S52561Q', 'S52561R', 'S52561S',
        'S52562A', 'S52562B', 'S52562C', 'S52562D', 'S52562E', 'S52562F', 'S52562G', 'S52562H',
        'S52562J', 'S52562K', 'S52562M', 'S52562N', 'S52562P', 'S52562Q', 'S52562R', 'S52562S',
        'S52569A', 'S52569B', 'S52569C', 'S52569D', 'S52569E', 'S52569F', 'S52569G', 'S52569H',
        'S52569J', 'S52569K', 'S52569M', 'S52569N', 'S52569P', 'S52569Q', 'S52569R', 'S52569S',
        'S52571A', 'S52571B', 'S52571C', 'S52571D', 'S52571E', 'S52571F', 'S52571G', 'S52571H',
        'S52571J', 'S52571K', 'S52571M', 'S52571N', 'S52571P', 'S52571Q', 'S52571R', 'S52571S',
        'S52572A', 'S52572B', 'S52572C', 'S52572D', 'S52572E', 'S52572F', 'S52572G', 'S52572H',
        'S52572J', 'S52572K', 'S52572M', 'S52572N', 'S52572P', 'S52572Q', 'S52572R', 'S52572S',
        'S52579A', 'S52579B', 'S52579C', 'S52579D', 'S52579E', 'S52579F', 'S52579G', 'S52579H',
        'S52579J', 'S52579K', 'S52579M', 'S52579N', 'S52579P', 'S52579Q', 'S52579R', 'S52579S',
        'S52591A', 'S52591B', 'S52591C', 'S52591D', 'S52591E', 'S52591F', 'S52591G', 'S52591H',
        'S52591J', 'S52591K', 'S52591M', 'S52591N', 'S52591P', 'S52591Q', 'S52591R', 'S52591S',
        'S52592A', 'S52592B', 'S52592C', 'S52592D', 'S52592E', 'S52592F', 'S52592G', 'S52592H',
        'S52592J', 'S52592K', 'S52592M', 'S52592N', 'S52592P', 'S52592Q', 'S52592R', 'S52592S',
        'S52599A', 'S52599B', 'S52599C', 'S52599D', 'S52599E', 'S52599F', 'S52599G', 'S52599H',
        'S52599J', 'S52599K', 'S52599M', 'S52599N', 'S52599P', 'S52599Q', 'S52599R', 'S52599S',
        'S52601A', 'S52601B', 'S52601C', 'S52601D', 'S52601E', 'S52601F', 'S52601G', 'S52601H',
        'S52601J', 'S52601K', 'S52601M', 'S52601N', 'S52601P', 'S52601Q', 'S52601R', 'S52601S',
        'S52602A', 'S52602B', 'S52602C', 'S52602D', 'S52602E', 'S52602F', 'S52602G', 'S52602H',
        'S52602J', 'S52602K', 'S52602M', 'S52602N', 'S52602P', 'S52602Q', 'S52602R', 'S52602S',
        'S52609A', 'S52609B', 'S52609C', 'S52609D', 'S52609E', 'S52609F', 'S52609G', 'S52609H',
        'S52609J', 'S52609K', 'S52609M', 'S52609N', 'S52609P', 'S52609Q', 'S52609R', 'S52609S',
        'S52611A', 'S52611B', 'S52611C', 'S52611D', 'S52611E', 'S52611F', 'S52611G', 'S52611H',
        'S52611J', 'S52611K', 'S52611M', 'S52611N', 'S52611P', 'S52611Q', 'S52611R', 'S52611S',
        'S52612A', 'S52612B', 'S52612C', 'S52612D', 'S52612E', 'S52612F', 'S52612G', 'S52612H',
        'S52612J', 'S52612K', 'S52612M', 'S52612N', 'S52612P', 'S52612Q', 'S52612R', 'S52612S',
        'S52613A', 'S52613B', 'S52613C', 'S52613D', 'S52613E', 'S52613F', 'S52613G', 'S52613H',
        'S52613J', 'S52613K', 'S52613M', 'S52613N', 'S52613P', 'S52613Q', 'S52613R', 'S52613S',
        'S52614A', 'S52614B', 'S52614C', 'S52614D', 'S52614E', 'S52614F', 'S52614G', 'S52614H',
        'S52614J', 'S52614K', 'S52614M', 'S52614N', 'S52614P', 'S52614Q', 'S52614R', 'S52614S',
        'S52615A', 'S52615B', 'S52615C', 'S52615D', 'S52615E', 'S52615F', 'S52615G', 'S52615H',
        'S52615J', 'S52615K', 'S52615M', 'S52615N', 'S52615P', 'S52615Q', 'S52615R', 'S52615S',
        'S52616A', 'S52616B', 'S52616C', 'S52616D', 'S52616E', 'S52616F', 'S52616G', 'S52616H',
        'S52616J', 'S52616K', 'S52616M', 'S52616N', 'S52616P', 'S52616Q', 'S52616R', 'S52616S',
        'S52621A', 'S52621D', 'S52621G', 'S52621K', 'S52621P', 'S52621S', 'S52622A', 'S52622D',
        'S52622G', 'S52622K', 'S52622P', 'S52622S', 'S52629A', 'S52629D', 'S52629G', 'S52629K',
        'S52629P', 'S52629S', 'S52691A', 'S52691B', 'S52691C', 'S52691D', 'S52691E', 'S52691F',
        'S52691G', 'S52691H', 'S52691J', 'S52691K', 'S52691M', 'S52691N', 'S52691P', 'S52691Q',
        'S52691R', 'S52691S', 'S52692A', 'S52692B', 'S52692C', 'S52692D', 'S52692E', 'S52692F',
        'S52692G', 'S52692H', 'S52692J', 'S52692K', 'S52692M', 'S52692N', 'S52692P', 'S52692Q',
        'S52692R', 'S52692S', 'S52699A', 'S52699B', 'S52699C', 'S52699D', 'S52699E', 'S52699F',
        'S52699G', 'S52699H', 'S52699J', 'S52699K', 'S52699M', 'S52699N', 'S52699P', 'S52699Q',
        'S52699R', 'S52699S', 'S5290XA', 'S5290XB', 'S5290XC', 'S5290XD', 'S5290XE', 'S5290XF',
        'S5290XG', 'S5290XH', 'S5290XJ', 'S5290XK', 'S5290XM', 'S5290XN', 'S5290XP', 'S5290XQ',
        'S5290XR', 'S5290XS', 'S5291XA', 'S5291XB', 'S5291XC', 'S5291XD', 'S5291XE', 'S5291XF',
        'S5291XG', 'S5291XH', 'S5291XJ', 'S5291XK', 'S5291XM', 'S5291XN', 'S5291XP', 'S5291XQ',
        'S5291XR', 'S5291XS', 'S5292XA', 'S5292XB', 'S5292XC', 'S5292XD', 'S5292XE', 'S5292XF',
        'S5292XG', 'S5292XH', 'S5292XJ', 'S5292XK', 'S5292XM', 'S5292XN', 'S5292XP', 'S5292XQ',
        'S5292XR', 'S5292XS', 'S53004A', 'S53004D', 'S53004S', 'S53005A', 'S53005D', 'S53005S',
        'S53006A', 'S53006D', 'S53006S', 'S53014A', 'S53014D', 'S53014S', 'S53015A', 'S53015D',
        'S53015S', 'S53016A', 'S53016D', 'S53016S', 'S53024A', 'S53024D', 'S53024S', 'S53025A',
        'S53025D', 'S53025S', 'S53026A', 'S53026D', 'S53026S', 'S53031A', 'S53031D', 'S53031S',
        'S53032A', 'S53032D', 'S53032S', 'S53033A', 'S53033D', 'S53033S', 'S53094A', 'S53094D',
        'S53094S', 'S53095A', 'S53095D', 'S53095S', 'S53096A', 'S53096D', 'S53096S', 'S53104A',
        'S53104D', 'S53104S', 'S53105A', 'S53105D', 'S53105S', 'S53106A', 'S53106D', 'S53106S',
        'S53114A', 'S53114D', 'S53114S', 'S53115A', 'S53115D', 'S53115S', 'S53116A', 'S53116D',
        'S53116S', 'S53124A', 'S53124D', 'S53124S', 'S53125A', 'S53125D', 'S53125S', 'S53126A',
        'S53126D', 'S53126S', 'S53134A', 'S53134D', 'S53134S', 'S53135A', 'S53135D', 'S53135S',
        'S53136A', 'S53136D', 'S53136S', 'S53144A', 'S53144D', 'S53144S', 'S53145A', 'S53145D',
        'S53145S', 'S53146A', 'S53146D', 'S53146S', 'S53194A', 'S53194D', 'S53194S', 'S53195A',
        'S53195D', 'S53195S', 'S53196A', 'S53196D', 'S53196S', 'S59001A', 'S59001D', 'S59001G',
        'S59001K', 'S59001P', 'S59001S', 'S59002A', 'S59002D', 'S59002G', 'S59002K', 'S59002P',
        'S59002S', 'S59009A', 'S59009D', 'S59009G', 'S59009K', 'S59009P', 'S59009S', 'S59011A',
        'S59011D', 'S59011G', 'S59011K', 'S59011P', 'S59011S', 'S59012A', 'S59012D', 'S59012G',
        'S59012K', 'S59012P', 'S59012S', 'S59019A', 'S59019D', 'S59019G', 'S59019K', 'S59019P',
        'S59019S', 'S59021A', 'S59021D', 'S59021G', 'S59021K', 'S59021P', 'S59021S', 'S59022A',
        'S59022D', 'S59022G', 'S59022K', 'S59022P', 'S59022S', 'S59029A', 'S59029D', 'S59029G',
        'S59029K', 'S59029P', 'S59029S', 'S59031A', 'S59031D', 'S59031G', 'S59031K', 'S59031P',
        'S59031S', 'S59032A', 'S59032D', 'S59032G', 'S59032K', 'S59032P', 'S59032S', 'S59039A',
        'S59039D', 'S59039G', 'S59039K', 'S59039P', 'S59039S', 'S59041A', 'S59041D', 'S59041G',
        'S59041K', 'S59041P', 'S59041S', 'S59042A', 'S59042D', 'S59042G', 'S59042K', 'S59042P',
        'S59042S', 'S59049A', 'S59049D', 'S59049G', 'S59049K', 'S59049P', 'S59049S', 'S59091A',
        'S59091D', 'S59091G', 'S59091K', 'S59091P', 'S59091S', 'S59092A', 'S59092D', 'S59092G',
        'S59092K', 'S59092P', 'S59092S', 'S59099A', 'S59099D', 'S59099G', 'S59099K', 'S59099P',
        'S59099S', 'S59101A', 'S59101D', 'S59101G', 'S59101K', 'S59101P', 'S59101S', 'S59102A',
        'S59102D', 'S59102G', 'S59102K', 'S59102P', 'S59102S', 'S59109A', 'S59109D', 'S59109G',
        'S59109K', 'S59109P', 'S59109S', 'S59111A', 'S59111D', 'S59111G', 'S59111K', 'S59111P',
        'S59111S', 'S59112A', 'S59112D', 'S59112G', 'S59112K', 'S59112P', 'S59112S', 'S59119A',
        'S59119D', 'S59119G', 'S59119K', 'S59119P', 'S59119S', 'S59121A', 'S59121D', 'S59121G',
        'S59121K', 'S59121P', 'S59121S', 'S59122A', 'S59122D', 'S59122G', 'S59122K', 'S59122P',
        'S59122S', 'S59129A', 'S59129D', 'S59129G', 'S59129K', 'S59129P', 'S59129S', 'S59131A',
        'S59131D', 'S59131G', 'S59131K', 'S59131P', 'S59131S', 'S59132A', 'S59132D', 'S59132G',
        'S59132K', 'S59132P', 'S59132S', 'S59139A', 'S59139D', 'S59139G', 'S59139K', 'S59139P',
        'S59139S', 'S59141A', 'S59141D', 'S59141G', 'S59141K', 'S59141P', 'S59141S', 'S59142A',
        'S59142D', 'S59142G', 'S59142K', 'S59142P', 'S59142S', 'S59149A', 'S59149D', 'S59149G',
        'S59149K', 'S59149P', 'S59149S', 'S59191A', 'S59191D', 'S59191G', 'S59191K', 'S59191P',
        'S59191S', 'S59192A', 'S59192D', 'S59192G', 'S59192K', 'S59192P', 'S59192S', 'S59199A',
        'S59199D', 'S59199G', 'S59199K', 'S59199P', 'S59199S', 'S59201A', 'S59201D', 'S59201G',
        'S59201K', 'S59201P', 'S59201S', 'S59202A', 'S59202D', 'S59202G', 'S59202K', 'S59202P',
        'S59202S', 'S59209A', 'S59209D', 'S59209G', 'S59209K', 'S59209P', 'S59209S', 'S59211A',
        'S59211D', 'S59211G', 'S59211K', 'S59211P', 'S59211S', 'S59212A', 'S59212D', 'S59212G',
        'S59212K', 'S59212P', 'S59212S', 'S59219A', 'S59219D', 'S59219G', 'S59219K', 'S59219P',
        'S59219S', 'S59221A', 'S59221D', 'S59221G', 'S59221K', 'S59221P', 'S59221S', 'S59222A',
        'S59222D', 'S59222G', 'S59222K', 'S59222P', 'S59222S', 'S59229A', 'S59229D', 'S59229G',
        'S59229K', 'S59229P', 'S59229S', 'S59231A', 'S59231D', 'S59231G', 'S59231K', 'S59231P',
        'S59231S', 'S59232A', 'S59232D', 'S59232G', 'S59232K', 'S59232P', 'S59232S', 'S59239A',
        'S59239D', 'S59239G', 'S59239K', 'S59239P', 'S59239S', 'S59241A', 'S59241D', 'S59241G',
        'S59241K', 'S59241P', 'S59241S', 'S59242A', 'S59242D', 'S59242G', 'S59242K', 'S59242P',
        'S59242S', 'S59249A', 'S59249D', 'S59249G', 'S59249K', 'S59249P', 'S59249S', 'S59291A',
        'S59291D', 'S59291G', 'S59291K', 'S59291P', 'S59291S', 'S59292A', 'S59292D', 'S59292G',
        'S59292K', 'S59292P', 'S59292S', 'S59299A', 'S59299D', 'S59299G', 'S59299K', 'S59299P',
        'S59299S', 'S62001A', 'S62001B', 'S62001D', 'S62001G', 'S62001K', 'S62001P', 'S62001S',
        'S62002A', 'S62002B', 'S62002D', 'S62002G', 'S62002K', 'S62002P', 'S62002S', 'S62009A',
        'S62009B', 'S62009D', 'S62009G', 'S62009K', 'S62009P', 'S62009S', 'S62011A', 'S62011B',
        'S62011D', 'S62011G', 'S62011K', 'S62011P', 'S62011S', 'S62012A', 'S62012B', 'S62012D',
        'S62012G', 'S62012K', 'S62012P', 'S62012S', 'S62013A', 'S62013B', 'S62013D', 'S62013G',
        'S62013K', 'S62013P', 'S62013S', 'S62014A', 'S62014B', 'S62014D', 'S62014G', 'S62014K',
        'S62014P', 'S62014S', 'S62015A', 'S62015B', 'S62015D', 'S62015G', 'S62015K', 'S62015P',
        'S62015S', 'S62016A', 'S62016B', 'S62016D', 'S62016G', 'S62016K', 'S62016P', 'S62016S',
        'S62021A', 'S62021B', 'S62021D', 'S62021G', 'S62021K', 'S62021P', 'S62021S', 'S62022A',
        'S62022B', 'S62022D', 'S62022G', 'S62022K', 'S62022P', 'S62022S', 'S62023A', 'S62023B',
        'S62023D', 'S62023G', 'S62023K', 'S62023P', 'S62023S', 'S62024A', 'S62024B', 'S62024D',
        'S62024G', 'S62024K', 'S62024P', 'S62024S', 'S62025A', 'S62025B', 'S62025D', 'S62025G',
        'S62025K', 'S62025P', 'S62025S', 'S62026A', 'S62026B', 'S62026D', 'S62026G', 'S62026K',
        'S62026P', 'S62026S', 'S62031A', 'S62031B', 'S62031D', 'S62031G', 'S62031K', 'S62031P',
        'S62031S', 'S62032A', 'S62032B', 'S62032D', 'S62032G', 'S62032K', 'S62032P', 'S62032S',
        'S62033A', 'S62033B', 'S62033D', 'S62033G', 'S62033K', 'S62033P', 'S62033S', 'S62034A',
        'S62034B', 'S62034D', 'S62034G', 'S62034K', 'S62034P', 'S62034S', 'S62035A', 'S62035B',
        'S62035D', 'S62035G', 'S62035K', 'S62035P', 'S62035S', 'S62036A', 'S62036B', 'S62036D',
        'S62036G', 'S62036K', 'S62036P', 'S62036S', 'S62101A', 'S62101B', 'S62101D', 'S62101G',
        'S62101K', 'S62101P', 'S62101S', 'S62102A', 'S62102B', 'S62102D', 'S62102G', 'S62102K',
        'S62102P', 'S62102S', 'S62109A', 'S62109B', 'S62109D', 'S62109G', 'S62109K', 'S62109P',
        'S62109S', 'S62111A', 'S62111B', 'S62111D', 'S62111G', 'S62111K', 'S62111P', 'S62111S',
        'S62112A', 'S62112B', 'S62112D', 'S62112G', 'S62112K', 'S62112P', 'S62112S', 'S62113A',
        'S62113B', 'S62113D', 'S62113G', 'S62113K', 'S62113P', 'S62113S', 'S62114A', 'S62114B',
        'S62114D', 'S62114G', 'S62114K', 'S62114P', 'S62114S', 'S62115A', 'S62115B', 'S62115D',
        'S62115G', 'S62115K', 'S62115P', 'S62115S', 'S62116A', 'S62116B', 'S62116D', 'S62116G',
        'S62116K', 'S62116P', 'S62116S', 'S62121A', 'S62121B', 'S62121D', 'S62121G', 'S62121K',
        'S62121P', 'S62121S', 'S62122A', 'S62122B', 'S62122D', 'S62122G', 'S62122K', 'S62122P',
        'S62122S', 'S62123A', 'S62123B', 'S62123D', 'S62123G', 'S62123K', 'S62123P', 'S62123S',
        'S62124A', 'S62124B', 'S62124D', 'S62124G', 'S62124K', 'S62124P', 'S62124S', 'S62125A',
        'S62125B', 'S62125D', 'S62125G', 'S62125K', 'S62125P', 'S62125S', 'S62126A', 'S62126B',
        'S62126D', 'S62126G', 'S62126K', 'S62126P', 'S62126S', 'S62131A', 'S62131B', 'S62131D',
        'S62131G', 'S62131K', 'S62131P', 'S62131S', 'S62132A', 'S62132B', 'S62132D', 'S62132G',
        'S62132K', 'S62132P', 'S62132S', 'S62133A', 'S62133B', 'S62133D', 'S62133G', 'S62133K',
        'S62133P', 'S62133S', 'S62134A', 'S62134B', 'S62134D', 'S62134G', 'S62134K', 'S62134P',
        'S62134S', 'S62135A', 'S62135B', 'S62135D', 'S62135G', 'S62135K', 'S62135P', 'S62135S',
        'S62136A', 'S62136B', 'S62136D', 'S62136G', 'S62136K', 'S62136P', 'S62136S', 'S62141A',
        'S62141B', 'S62141D', 'S62141G', 'S62141K', 'S62141P', 'S62141S', 'S62142A', 'S62142B',
        'S62142D', 'S62142G', 'S62142K', 'S62142P', 'S62142S', 'S62143A', 'S62143B', 'S62143D',
        'S62143G', 'S62143K', 'S62143P', 'S62143S', 'S62144A', 'S62144B', 'S62144D', 'S62144G',
        'S62144K', 'S62144P', 'S62144S', 'S62145A', 'S62145B', 'S62145D', 'S62145G', 'S62145K',
        'S62145P', 'S62145S', 'S62146A', 'S62146B', 'S62146D', 'S62146G', 'S62146K', 'S62146P',
        'S62146S', 'S62151A', 'S62151B', 'S62151D', 'S62151G', 'S62151K', 'S62151P', 'S62151S',
        'S62152A', 'S62152B', 'S62152D', 'S62152G', 'S62152K', 'S62152P', 'S62152S', 'S62153A',
        'S62153B', 'S62153D', 'S62153G', 'S62153K', 'S62153P', 'S62153S', 'S62154A', 'S62154B',
        'S62154D', 'S62154G', 'S62154K', 'S62154P', 'S62154S', 'S62155A', 'S62155B', 'S62155D',
        'S62155G', 'S62155K', 'S62155P', 'S62155S', 'S62156A', 'S62156B', 'S62156D', 'S62156G',
        'S62156K', 'S62156P', 'S62156S', 'S62161A', 'S62161B', 'S62161D', 'S62161G', 'S62161K',
        'S62161P', 'S62161S', 'S62162A', 'S62162B', 'S62162D', 'S62162G', 'S62162K', 'S62162P',
        'S62162S', 'S62163A', 'S62163B', 'S62163D', 'S62163G', 'S62163K', 'S62163P', 'S62163S',
        'S62164A', 'S62164B', 'S62164D', 'S62164G', 'S62164K', 'S62164P', 'S62164S', 'S62165A',
        'S62165B', 'S62165D', 'S62165G', 'S62165K', 'S62165P', 'S62165S', 'S62166A', 'S62166B',
        'S62166D', 'S62166G', 'S62166K', 'S62166P', 'S62166S', 'S62171A', 'S62171B', 'S62171D',
        'S62171G', 'S62171K', 'S62171P', 'S62171S', 'S62172A', 'S62172B', 'S62172D', 'S62172G',
        'S62172K', 'S62172P', 'S62172S', 'S62173A', 'S62173B', 'S62173D', 'S62173G', 'S62173K',
        'S62173P', 'S62173S', 'S62174A', 'S62174B', 'S62174D', 'S62174G', 'S62174K', 'S62174P',
        'S62174S', 'S62175A', 'S62175B', 'S62175D', 'S62175G', 'S62175K', 'S62175P', 'S62175S',
        'S62176A', 'S62176B', 'S62176D', 'S62176G', 'S62176K', 'S62176P', 'S62176S', 'S62181A',
        'S62181B', 'S62181D', 'S62181G', 'S62181K', 'S62181P', 'S62181S', 'S62182A', 'S62182B',
        'S62182D', 'S62182G', 'S62182K', 'S62182P', 'S62182S', 'S62183A', 'S62183B', 'S62183D',
        'S62183G', 'S62183K', 'S62183P', 'S62183S', 'S62184A', 'S62184B', 'S62184D', 'S62184G',
        'S62184K', 'S62184P', 'S62184S', 'S62185A', 'S62185B', 'S62185D', 'S62185G', 'S62185K',
        'S62185P', 'S62185S', 'S62186A', 'S62186B', 'S62186D', 'S62186G', 'S62186K', 'S62186P',
        'S62186S', 'S62201A', 'S62201B', 'S62201D', 'S62201G', 'S62201K', 'S62201P', 'S62201S',
        'S62202A', 'S62202B', 'S62202D', 'S62202G', 'S62202K', 'S62202P', 'S62202S', 'S62209A',
        'S62209B', 'S62209D', 'S62209G', 'S62209K', 'S62209P', 'S62209S', 'S62211A', 'S62211B',
        'S62211D', 'S62211G', 'S62211K', 'S62211P', 'S62211S', 'S62212A', 'S62212B', 'S62212D',
        'S62212G', 'S62212K', 'S62212P', 'S62212S', 'S62213A', 'S62213B', 'S62213D', 'S62213G',
        'S62213K', 'S62213P', 'S62213S', 'S62221A', 'S62221B', 'S62221D', 'S62221G', 'S62221K',
        'S62221P', 'S62221S', 'S62222A', 'S62222B', 'S62222D', 'S62222G', 'S62222K', 'S62222P',
        'S62222S', 'S62223A', 'S62223B', 'S62223D', 'S62223G', 'S62223K', 'S62223P', 'S62223S',
        'S62224A', 'S62224B', 'S62224D', 'S62224G', 'S62224K', 'S62224P', 'S62224S', 'S62225A',
        'S62225B', 'S62225D', 'S62225G', 'S62225K', 'S62225P', 'S62225S', 'S62226A', 'S62226B',
        'S62226D', 'S62226G', 'S62226K', 'S62226P', 'S62226S', 'S62231A', 'S62231B', 'S62231D',
        'S62231G', 'S62231K', 'S62231P', 'S62231S', 'S62232A', 'S62232B', 'S62232D', 'S62232G',
        'S62232K', 'S62232P', 'S62232S', 'S62233A', 'S62233B', 'S62233D', 'S62233G', 'S62233K',
        'S62233P', 'S62233S', 'S62234A', 'S62234B', 'S62234D', 'S62234G', 'S62234K', 'S62234P',
        'S62234S', 'S62235A', 'S62235B', 'S62235D', 'S62235G', 'S62235K', 'S62235P', 'S62235S',
        'S62236A', 'S62236B', 'S62236D', 'S62236G', 'S62236K', 'S62236P', 'S62236S', 'S62241A',
        'S62241B', 'S62241D', 'S62241G', 'S62241K', 'S62241P', 'S62241S', 'S62242A', 'S62242B',
        'S62242D', 'S62242G', 'S62242K', 'S62242P', 'S62242S', 'S62243A', 'S62243B', 'S62243D',
        'S62243G', 'S62243K', 'S62243P', 'S62243S', 'S62244A', 'S62244B', 'S62244D', 'S62244G',
        'S62244K', 'S62244P', 'S62244S', 'S62245A', 'S62245B', 'S62245D', 'S62245G', 'S62245K',
        'S62245P', 'S62245S', 'S62246A', 'S62246B', 'S62246D', 'S62246G', 'S62246K', 'S62246P',
        'S62246S', 'S62251A', 'S62251B', 'S62251D', 'S62251G', 'S62251K', 'S62251P', 'S62251S',
        'S62252A', 'S62252B', 'S62252D', 'S62252G', 'S62252K', 'S62252P', 'S62252S', 'S62253A',
        'S62253B', 'S62253D', 'S62253G', 'S62253K', 'S62253P', 'S62253S', 'S62254A', 'S62254B',
        'S62254D', 'S62254G', 'S62254K', 'S62254P', 'S62254S', 'S62255A', 'S62255B', 'S62255D',
        'S62255G', 'S62255K', 'S62255P', 'S62255S', 'S62256A', 'S62256B', 'S62256D', 'S62256G',
        'S62256K', 'S62256P', 'S62256S', 'S62291A', 'S62291B', 'S62291D', 'S62291G', 'S62291K',
        'S62291P', 'S62291S', 'S62292A', 'S62292B', 'S62292D', 'S62292G', 'S62292K', 'S62292P',
        'S62292S', 'S62299A', 'S62299B', 'S62299D', 'S62299G', 'S62299K', 'S62299P', 'S62299S',
        'S62300A', 'S62300B', 'S62300D', 'S62300G', 'S62300K', 'S62300P', 'S62300S', 'S62301A',
        'S62301B', 'S62301D', 'S62301G', 'S62301K', 'S62301P', 'S62301S', 'S62302A', 'S62302B',
        'S62302D', 'S62302G', 'S62302K', 'S62302P', 'S62302S', 'S62303A', 'S62303B', 'S62303D',
        'S62303G', 'S62303K', 'S62303P', 'S62303S', 'S62304A', 'S62304B', 'S62304D', 'S62304G',
        'S62304K', 'S62304P', 'S62304S', 'S62305A', 'S62305B', 'S62305D', 'S62305G', 'S62305K',
        'S62305P', 'S62305S', 'S62306A', 'S62306B', 'S62306D', 'S62306G', 'S62306K', 'S62306P',
        'S62306S', 'S62307A', 'S62307B', 'S62307D', 'S62307G', 'S62307K', 'S62307P', 'S62307S',
        'S62308A', 'S62308B', 'S62308D', 'S62308G', 'S62308K', 'S62308P', 'S62308S', 'S62309A',
        'S62309B', 'S62309D', 'S62309G', 'S62309K', 'S62309P', 'S62309S', 'S62310A', 'S62310B',
        'S62310D', 'S62310G', 'S62310K', 'S62310P', 'S62310S', 'S62311A', 'S62311B', 'S62311D',
        'S62311G', 'S62311K', 'S62311P', 'S62311S', 'S62312A', 'S62312B', 'S62312D', 'S62312G',
        'S62312K', 'S62312P', 'S62312S', 'S62313A', 'S62313B', 'S62313D', 'S62313G', 'S62313K',
        'S62313P', 'S62313S', 'S62314A', 'S62314B', 'S62314D', 'S62314G', 'S62314K', 'S62314P',
        'S62314S', 'S62315A', 'S62315B', 'S62315D', 'S62315G', 'S62315K', 'S62315P', 'S62315S',
        'S62316A', 'S62316B', 'S62316D', 'S62316G', 'S62316K', 'S62316P', 'S62316S', 'S62317A',
        'S62317B', 'S62317D', 'S62317G', 'S62317K', 'S62317P', 'S62317S', 'S62318A', 'S62318B',
        'S62318D', 'S62318G', 'S62318K', 'S62318P', 'S62318S', 'S62319A', 'S62319B', 'S62319D',
        'S62319G', 'S62319K', 'S62319P', 'S62319S', 'S62320A', 'S62320B', 'S62320D', 'S62320G',
        'S62320K', 'S62320P', 'S62320S', 'S62321A', 'S62321B', 'S62321D', 'S62321G', 'S62321K',
        'S62321P', 'S62321S', 'S62322A', 'S62322B', 'S62322D', 'S62322G', 'S62322K', 'S62322P',
        'S62322S', 'S62323A', 'S62323B', 'S62323D', 'S62323G', 'S62323K', 'S62323P', 'S62323S',
        'S62324A', 'S62324B', 'S62324D', 'S62324G', 'S62324K', 'S62324P', 'S62324S', 'S62325A',
        'S62325B', 'S62325D', 'S62325G', 'S62325K', 'S62325P', 'S62325S', 'S62326A', 'S62326B',
        'S62326D', 'S62326G', 'S62326K', 'S62326P', 'S62326S', 'S62327A', 'S62327B', 'S62327D',
        'S62327G', 'S62327K', 'S62327P', 'S62327S', 'S62328A', 'S62328B', 'S62328D', 'S62328G',
        'S62328K', 'S62328P', 'S62328S', 'S62329A', 'S62329B', 'S62329D', 'S62329G', 'S62329K',
        'S62329P', 'S62329S', 'S62330A', 'S62330B', 'S62330D', 'S62330G', 'S62330K', 'S62330P',
        'S62330S', 'S62331A', 'S62331B', 'S62331D', 'S62331G', 'S62331K', 'S62331P', 'S62331S',
        'S62332A', 'S62332B', 'S62332D', 'S62332G', 'S62332K', 'S62332P', 'S62332S', 'S62333A',
        'S62333B', 'S62333D', 'S62333G', 'S62333K', 'S62333P', 'S62333S', 'S62334A', 'S62334B',
        'S62334D', 'S62334G', 'S62334K', 'S62334P', 'S62334S', 'S62335A', 'S62335B', 'S62335D',
        'S62335G', 'S62335K', 'S62335P', 'S62335S', 'S62336A', 'S62336B', 'S62336D', 'S62336G',
        'S62336K', 'S62336P', 'S62336S', 'S62337A', 'S62337B', 'S62337D', 'S62337G', 'S62337K',
        'S62337P', 'S62337S', 'S62338A', 'S62338B', 'S62338D', 'S62338G', 'S62338K', 'S62338P',
        'S62338S', 'S62339A', 'S62339B', 'S62339D', 'S62339G', 'S62339K', 'S62339P', 'S62339S',
        'S62340A', 'S62340B', 'S62340D', 'S62340G', 'S62340K', 'S62340P', 'S62340S', 'S62341A',
        'S62341B', 'S62341D', 'S62341G', 'S62341K', 'S62341P', 'S62341S', 'S62342A', 'S62342B',
        'S62342D', 'S62342G', 'S62342K', 'S62342P', 'S62342S', 'S62343A', 'S62343B', 'S62343D',
        'S62343G', 'S62343K', 'S62343P', 'S62343S', 'S62344A', 'S62344B', 'S62344D', 'S62344G',
        'S62344K', 'S62344P', 'S62344S', 'S62345A', 'S62345B', 'S62345D', 'S62345G', 'S62345K',
        'S62345P', 'S62345S', 'S62346A', 'S62346B', 'S62346D', 'S62346G', 'S62346K', 'S62346P',
        'S62346S', 'S62347A', 'S62347B', 'S62347D', 'S62347G', 'S62347K', 'S62347P', 'S62347S',
        'S62348A', 'S62348B', 'S62348D', 'S62348G', 'S62348K', 'S62348P', 'S62348S', 'S62349A',
        'S62349B', 'S62349D', 'S62349G', 'S62349K', 'S62349P', 'S62349S', 'S62350A', 'S62350B',
        'S62350D', 'S62350G', 'S62350K', 'S62350P', 'S62350S', 'S62351A', 'S62351B', 'S62351D',
        'S62351G', 'S62351K', 'S62351P', 'S62351S', 'S62352A', 'S62352B', 'S62352D', 'S62352G',
        'S62352K', 'S62352P', 'S62352S', 'S62353A', 'S62353B', 'S62353D', 'S62353G', 'S62353K',
        'S62353P', 'S62353S', 'S62354A', 'S62354B', 'S62354D', 'S62354G', 'S62354K', 'S62354P',
        'S62354S', 'S62355A', 'S62355B', 'S62355D', 'S62355G', 'S62355K', 'S62355P', 'S62355S',
        'S62356A', 'S62356B', 'S62356D', 'S62356G', 'S62356K', 'S62356P', 'S62356S', 'S62357A',
        'S62357B', 'S62357D', 'S62357G', 'S62357K', 'S62357P', 'S62357S', 'S62358A', 'S62358B',
        'S62358D', 'S62358G', 'S62358K', 'S62358P', 'S62358S', 'S62359A', 'S62359B', 'S62359D',
        'S62359G', 'S62359K', 'S62359P', 'S62359S', 'S62360A', 'S62360B', 'S62360D', 'S62360G',
        'S62360K', 'S62360P', 'S62360S', 'S62361A', 'S62361B', 'S62361D', 'S62361G', 'S62361K',
        'S62361P', 'S62361S', 'S62362A', 'S62362B', 'S62362D', 'S62362G', 'S62362K', 'S62362P',
        'S62362S', 'S62363A', 'S62363B', 'S62363D', 'S62363G', 'S62363K', 'S62363P', 'S62363S',
        'S62364A', 'S62364B', 'S62364D', 'S62364G', 'S62364K', 'S62364P', 'S62364S', 'S62365A',
        'S62365B', 'S62365D', 'S62365G', 'S62365K', 'S62365P', 'S62365S', 'S62366A', 'S62366B',
        'S62366D', 'S62366G', 'S62366K', 'S62366P', 'S62366S', 'S62367A', 'S62367B', 'S62367D',
        'S62367G', 'S62367K', 'S62367P', 'S62367S', 'S62368A', 'S62368B', 'S62368D', 'S62368G',
        'S62368K', 'S62368P', 'S62368S', 'S62369A', 'S62369B', 'S62369D', 'S62369G', 'S62369K',
        'S62369P', 'S62369S', 'S62390A', 'S62390B', 'S62390D', 'S62390G', 'S62390K', 'S62390P',
        'S62390S', 'S62391A', 'S62391B', 'S62391D', 'S62391G', 'S62391K', 'S62391P', 'S62391S',
        'S62392A', 'S62392B', 'S62392D', 'S62392G', 'S62392K', 'S62392P', 'S62392S', 'S62393A',
        'S62393B', 'S62393D', 'S62393G', 'S62393K', 'S62393P', 'S62393S', 'S62394A', 'S62394B',
        'S62394D', 'S62394G', 'S62394K', 'S62394P', 'S62394S', 'S62395A', 'S62395B', 'S62395D',
        'S62395G', 'S62395K', 'S62395P', 'S62395S', 'S62396A', 'S62396B', 'S62396D', 'S62396G',
        'S62396K', 'S62396P', 'S62396S', 'S62397A', 'S62397B', 'S62397D', 'S62397G', 'S62397K',
        'S62397P', 'S62397S', 'S62398A', 'S62398B', 'S62398D', 'S62398G', 'S62398K', 'S62398P',
        'S62398S', 'S62399A', 'S62399B', 'S62399D', 'S62399G', 'S62399K', 'S62399P', 'S62399S',
        'S62501A', 'S62501B', 'S62501D', 'S62501G', 'S62501K', 'S62501P', 'S62501S', 'S62502A',
        'S62502B', 'S62502D', 'S62502G', 'S62502K', 'S62502P', 'S62502S', 'S62509A', 'S62509B',
        'S62509D', 'S62509G', 'S62509K', 'S62509P', 'S62509S', 'S62511A', 'S62511B', 'S62511D',
        'S62511G', 'S62511K', 'S62511P', 'S62511S', 'S62512A', 'S62512B', 'S62512D', 'S62512G',
        'S62512K', 'S62512P', 'S62512S', 'S62513A', 'S62513B', 'S62513D', 'S62513G', 'S62513K',
        'S62513P', 'S62513S', 'S62514A', 'S62514B', 'S62514D', 'S62514G', 'S62514K', 'S62514P',
        'S62514S', 'S62515A', 'S62515B', 'S62515D', 'S62515G', 'S62515K', 'S62515P', 'S62515S',
        'S62516A', 'S62516B', 'S62516D', 'S62516G', 'S62516K', 'S62516P', 'S62516S', 'S62521A',
        'S62521B', 'S62521D', 'S62521G', 'S62521K', 'S62521P', 'S62521S', 'S62522A', 'S62522B',
        'S62522D', 'S62522G', 'S62522K', 'S62522P', 'S62522S', 'S62523A', 'S62523B', 'S62523D',
        'S62523G', 'S62523K', 'S62523P', 'S62523S', 'S62524A', 'S62524B', 'S62524D', 'S62524G',
        'S62524K', 'S62524P', 'S62524S', 'S62525A', 'S62525B', 'S62525D', 'S62525G', 'S62525K',
        'S62525P', 'S62525S', 'S62526A', 'S62526B', 'S62526D', 'S62526G', 'S62526K', 'S62526P',
        'S62526S', 'S62600A', 'S62600B', 'S62600D', 'S62600G', 'S62600K', 'S62600P', 'S62600S',
        'S62601A', 'S62601B', 'S62601D', 'S62601G', 'S62601K', 'S62601P', 'S62601S', 'S62602A',
        'S62602B', 'S62602D', 'S62602G', 'S62602K', 'S62602P', 'S62602S', 'S62603A', 'S62603B',
        'S62603D', 'S62603G', 'S62603K', 'S62603P', 'S62603S', 'S62604A', 'S62604B', 'S62604D',
        'S62604G', 'S62604K', 'S62604P', 'S62604S', 'S62605A', 'S62605B', 'S62605D', 'S62605G',
        'S62605K', 'S62605P', 'S62605S', 'S62606A', 'S62606B', 'S62606D', 'S62606G', 'S62606K',
        'S62606P', 'S62606S', 'S62607A', 'S62607B', 'S62607D', 'S62607G', 'S62607K', 'S62607P',
        'S62607S', 'S62608A', 'S62608B', 'S62608D', 'S62608G', 'S62608K', 'S62608P', 'S62608S',
        'S62609A', 'S62609B', 'S62609D', 'S62609G', 'S62609K', 'S62609P', 'S62609S', 'S62610A',
        'S62610B', 'S62610D', 'S62610G', 'S62610K', 'S62610P', 'S62610S', 'S62611A', 'S62611B',
        'S62611D', 'S62611G', 'S62611K', 'S62611P', 'S62611S', 'S62612A', 'S62612B', 'S62612D',
        'S62612G', 'S62612K', 'S62612P', 'S62612S', 'S62613A', 'S62613B', 'S62613D', 'S62613G',
        'S62613K', 'S62613P', 'S62613S', 'S62614A', 'S62614B', 'S62614D', 'S62614G', 'S62614K',
        'S62614P', 'S62614S', 'S62615A', 'S62615B', 'S62615D', 'S62615G', 'S62615K', 'S62615P',
        'S62615S', 'S62616A', 'S62616B', 'S62616D', 'S62616G', 'S62616K', 'S62616P', 'S62616S',
        'S62617A', 'S62617B', 'S62617D', 'S62617G', 'S62617K', 'S62617P', 'S62617S', 'S62618A',
        'S62618B', 'S62618D', 'S62618G', 'S62618K', 'S62618P', 'S62618S', 'S62619A', 'S62619B',
        'S62619D', 'S62619G', 'S62619K', 'S62619P', 'S62619S', 'S62620A', 'S62620B', 'S62620D',
        'S62620G', 'S62620K', 'S62620P', 'S62620S', 'S62621A', 'S62621B', 'S62621D', 'S62621G',
        'S62621K', 'S62621P', 'S62621S', 'S62622A', 'S62622B', 'S62622D', 'S62622G', 'S62622K',
        'S62622P', 'S62622S', 'S62623A', 'S62623B', 'S62623D', 'S62623G', 'S62623K', 'S62623P',
        'S62623S', 'S62624A', 'S62624B', 'S62624D', 'S62624G', 'S62624K', 'S62624P', 'S62624S',
        'S62625A', 'S62625B', 'S62625D', 'S62625G', 'S62625K', 'S62625P', 'S62625S', 'S62626A',
        'S62626B', 'S62626D', 'S62626G', 'S62626K', 'S62626P', 'S62626S', 'S62627A', 'S62627B',
        'S62627D', 'S62627G', 'S62627K', 'S62627P', 'S62627S', 'S62628A', 'S62628B', 'S62628D',
        'S62628G', 'S62628K', 'S62628P', 'S62628S', 'S62629A', 'S62629B', 'S62629D', 'S62629G',
        'S62629K', 'S62629P', 'S62629S', 'S62630A', 'S62630B', 'S62630D', 'S62630G', 'S62630K',
        'S62630P', 'S62630S', 'S62631A', 'S62631B', 'S62631D', 'S62631G', 'S62631K', 'S62631P',
        'S62631S', 'S62632A', 'S62632B', 'S62632D', 'S62632G', 'S62632K', 'S62632P', 'S62632S',
        'S62633A', 'S62633B', 'S62633D', 'S62633G', 'S62633K', 'S62633P', 'S62633S', 'S62634A',
        'S62634B', 'S62634D', 'S62634G', 'S62634K', 'S62634P', 'S62634S', 'S62635A', 'S62635B',
        'S62635D', 'S62635G', 'S62635K', 'S62635P', 'S62635S', 'S62636A', 'S62636B', 'S62636D',
        'S62636G', 'S62636K', 'S62636P', 'S62636S', 'S62637A', 'S62637B', 'S62637D', 'S62637G',
        'S62637K', 'S62637P', 'S62637S', 'S62638A', 'S62638B', 'S62638D', 'S62638G', 'S62638K',
        'S62638P', 'S62638S', 'S62639A', 'S62639B', 'S62639D', 'S62639G', 'S62639K', 'S62639P',
        'S62639S', 'S62640A', 'S62640B', 'S62640D', 'S62640G', 'S62640K', 'S62640P', 'S62640S',
        'S62641A', 'S62641B', 'S62641D', 'S62641G', 'S62641K', 'S62641P', 'S62641S', 'S62642A',
        'S62642B', 'S62642D', 'S62642G', 'S62642K', 'S62642P', 'S62642S', 'S62643A', 'S62643B',
        'S62643D', 'S62643G', 'S62643K', 'S62643P', 'S62643S', 'S62644A', 'S62644B', 'S62644D',
        'S62644G', 'S62644K', 'S62644P', 'S62644S', 'S62645A', 'S62645B', 'S62645D', 'S62645G',
        'S62645K', 'S62645P', 'S62645S', 'S62646A', 'S62646B', 'S62646D', 'S62646G', 'S62646K',
        'S62646P', 'S62646S', 'S62647A', 'S62647B', 'S62647D', 'S62647G', 'S62647K', 'S62647P',
        'S62647S', 'S62648A', 'S62648B', 'S62648D', 'S62648G', 'S62648K', 'S62648P', 'S62648S',
        'S62649A', 'S62649B', 'S62649D', 'S62649G', 'S62649K', 'S62649P', 'S62649S', 'S62650A',
        'S62650B', 'S62650D', 'S62650G', 'S62650K', 'S62650P', 'S62650S', 'S62651A', 'S62651B',
        'S62651D', 'S62651G', 'S62651K', 'S62651P', 'S62651S', 'S62652A', 'S62652B', 'S62652D',
        'S62652G', 'S62652K', 'S62652P', 'S62652S', 'S62653A', 'S62653B', 'S62653D', 'S62653G',
        'S62653K', 'S62653P', 'S62653S', 'S62654A', 'S62654B', 'S62654D', 'S62654G', 'S62654K',
        'S62654P', 'S62654S', 'S62655A', 'S62655B', 'S62655D', 'S62655G', 'S62655K', 'S62655P',
        'S62655S', 'S62656A', 'S62656B', 'S62656D', 'S62656G', 'S62656K', 'S62656P', 'S62656S',
        'S62657A', 'S62657B', 'S62657D', 'S62657G', 'S62657K', 'S62657P', 'S62657S', 'S62658A',
        'S62658B', 'S62658D', 'S62658G', 'S62658K', 'S62658P', 'S62658S', 'S62659A', 'S62659B',
        'S62659D', 'S62659G', 'S62659K', 'S62659P', 'S62659S', 'S62660A', 'S62660B', 'S62660D',
        'S62660G', 'S62660K', 'S62660P', 'S62660S', 'S62661A', 'S62661B', 'S62661D', 'S62661G',
        'S62661K', 'S62661P', 'S62661S', 'S62662A', 'S62662B', 'S62662D', 'S62662G', 'S62662K',
        'S62662P', 'S62662S', 'S62663A', 'S62663B', 'S62663D', 'S62663G', 'S62663K', 'S62663P',
        'S62663S', 'S62664A', 'S62664B', 'S62664D', 'S62664G', 'S62664K', 'S62664P', 'S62664S',
        'S62665A', 'S62665B', 'S62665D', 'S62665G', 'S62665K', 'S62665P', 'S62665S', 'S62666A',
        'S62666B', 'S62666D', 'S62666G', 'S62666K', 'S62666P', 'S62666S', 'S62667A', 'S62667B',
        'S62667D', 'S62667G', 'S62667K', 'S62667P', 'S62667S', 'S62668A', 'S62668B', 'S62668D',
        'S62668G', 'S62668K', 'S62668P', 'S62668S', 'S62669A', 'S62669B', 'S62669D', 'S62669G',
        'S62669K', 'S62669P', 'S62669S', 'S6290XA', 'S6290XB', 'S6290XD', 'S6290XG', 'S6290XK',
        'S6290XP', 'S6290XS', 'S6291XA', 'S6291XB', 'S6291XD', 'S6291XG', 'S6291XK', 'S6291XP',
        'S6291XS', 'S6292XA', 'S6292XB', 'S6292XD', 'S6292XG', 'S6292XK', 'S6292XP', 'S6292XS',
        'S63004A', 'S63004D', 'S63004S', 'S63005A', 'S63005D', 'S63005S', 'S63006A', 'S63006D',
        'S63006S', 'S63014A', 'S63014D', 'S63014S', 'S63015A', 'S63015D', 'S63015S', 'S63016A',
        'S63016D', 'S63016S', 'S63024A', 'S63024D', 'S63024S', 'S63025A', 'S63025D', 'S63025S',
        'S63026A', 'S63026D', 'S63026S', 'S63034A', 'S63034D', 'S63034S', 'S63035A', 'S63035D',
        'S63035S', 'S63036A', 'S63036D', 'S63036S', 'S63044A', 'S63044D', 'S63044S', 'S63045A',
        'S63045D', 'S63045S', 'S63046A', 'S63046D', 'S63046S', 'S63054A', 'S63054D', 'S63054S',
        'S63055A', 'S63055D', 'S63055S', 'S63056A', 'S63056D', 'S63056S', 'S63064A', 'S63064D',
        'S63064S', 'S63065A', 'S63065D', 'S63065S', 'S63066A', 'S63066D', 'S63066S', 'S63074A',
        'S63074D', 'S63074S', 'S63075A', 'S63075D', 'S63075S', 'S63076A', 'S63076D', 'S63076S',
        'S63094A', 'S63094D', 'S63094S', 'S63095A', 'S63095D', 'S63095S', 'S63096A', 'S63096D',
        'S63096S', 'S63104A', 'S63104D', 'S63104S', 'S63105A', 'S63105D', 'S63105S', 'S63106A',
        'S63106D', 'S63106S', 'S63114A', 'S63114D', 'S63114S', 'S63115A', 'S63115D', 'S63115S',
        'S63116A', 'S63116D', 'S63116S', 'S63124A', 'S63124D', 'S63124S', 'S63125A', 'S63125D',
        'S63125S', 'S63126A', 'S63126D', 'S63126S', 'S63134A', 'S63134D', 'S63134S', 'S63135A',
        'S63135D', 'S63135S', 'S63136A', 'S63136D', 'S63136S', 'S63144A', 'S63144D', 'S63144S',
        'S63145A', 'S63145D', 'S63145S', 'S63146A', 'S63146D', 'S63146S', 'S63250A', 'S63250D',
        'S63250S', 'S63251A', 'S63251D', 'S63251S', 'S63252A', 'S63252D', 'S63252S', 'S63253A',
        'S63253D', 'S63253S', 'S63254A', 'S63254D', 'S63254S', 'S63255A', 'S63255D', 'S63255S',
        'S63256A', 'S63256D', 'S63256S', 'S63257A', 'S63257D', 'S63257S', 'S63258A', 'S63258D',
        'S63258S', 'S63259A', 'S63259D', 'S63259S', 'S63260A', 'S63260D', 'S63260S', 'S63261A',
        'S63261D', 'S63261S', 'S63262A', 'S63262D', 'S63262S', 'S63263A', 'S63263D', 'S63263S',
        'S63264A', 'S63264D', 'S63264S', 'S63265A', 'S63265D', 'S63265S', 'S63266A', 'S63266D',
        'S63266S', 'S63267A', 'S63267D', 'S63267S', 'S63268A', 'S63268D', 'S63268S', 'S63269A',
        'S63269D', 'S63269S', 'S63270A', 'S63270D', 'S63270S', 'S63271A', 'S63271D', 'S63271S',
        'S63272A', 'S63272D', 'S63272S', 'S63273A', 'S63273D', 'S63273S', 'S63274A', 'S63274D',
        'S63274S', 'S63275A', 'S63275D', 'S63275S', 'S63276A', 'S63276D', 'S63276S', 'S63277A',
        'S63277D', 'S63277S', 'S63278A', 'S63278D', 'S63278S', 'S63279A', 'S63279D', 'S63279S',
        'S63280A', 'S63280D', 'S63280S', 'S63281A', 'S63281D', 'S63281S', 'S63282A', 'S63282D',
        'S63282S', 'S63283A', 'S63283D', 'S63283S', 'S63284A', 'S63284D', 'S63284S', 'S63285A',
        'S63285D', 'S63285S', 'S63286A', 'S63286D', 'S63286S', 'S63287A', 'S63287D', 'S63287S',
        'S63288A', 'S63288D', 'S63288S', 'S63289A', 'S63289D', 'S63289S', 'S63290A', 'S63290D',
        'S63290S', 'S63291A', 'S63291D', 'S63291S', 'S63292A', 'S63292D', 'S63292S', 'S63293A',
        'S63293D', 'S63293S', 'S63294A', 'S63294D', 'S63294S', 'S63295A', 'S63295D', 'S63295S',
        'S63296A', 'S63296D', 'S63296S', 'S63297A', 'S63297D', 'S63297S', 'S63298A', 'S63298D',
        'S63298S', 'S63299A', 'S63299D', 'S63299S', 'S72001A', 'S72001B', 'S72001C', 'S72001D',
        'S72001E', 'S72001F', 'S72001G', 'S72001H', 'S72001J', 'S72001K', 'S72001M', 'S72001N',
        'S72001P', 'S72001Q', 'S72001R', 'S72001S', 'S72002A', 'S72002B', 'S72002C', 'S72002D',
        'S72002E', 'S72002F', 'S72002G', 'S72002H', 'S72002J', 'S72002K', 'S72002M', 'S72002N',
        'S72002P', 'S72002Q', 'S72002R', 'S72002S', 'S72009A', 'S72009B', 'S72009C', 'S72009D',
        'S72009E', 'S72009F', 'S72009G', 'S72009H', 'S72009J', 'S72009K', 'S72009M', 'S72009N',
        'S72009P', 'S72009Q', 'S72009R', 'S72009S', 'S72011A', 'S72011B', 'S72011C', 'S72011D',
        'S72011E', 'S72011F', 'S72011G', 'S72011H', 'S72011J', 'S72011K', 'S72011M', 'S72011N',
        'S72011P', 'S72011Q', 'S72011R', 'S72011S', 'S72012A', 'S72012B', 'S72012C', 'S72012D',
        'S72012E', 'S72012F', 'S72012G', 'S72012H', 'S72012J', 'S72012K', 'S72012M', 'S72012N',
        'S72012P', 'S72012Q', 'S72012R', 'S72012S', 'S72019A', 'S72019B', 'S72019C', 'S72019D',
        'S72019E', 'S72019F', 'S72019G', 'S72019H', 'S72019J', 'S72019K', 'S72019M', 'S72019N',
        'S72019P', 'S72019Q', 'S72019R', 'S72019S', 'S72021A', 'S72021B', 'S72021C', 'S72021D',
        'S72021E', 'S72021F', 'S72021G', 'S72021H', 'S72021J', 'S72021K', 'S72021M', 'S72021N',
        'S72021P', 'S72021Q', 'S72021R', 'S72021S', 'S72022A', 'S72022B', 'S72022C', 'S72022D',
        'S72022E', 'S72022F', 'S72022G', 'S72022H', 'S72022J', 'S72022K', 'S72022M', 'S72022N',
        'S72022P', 'S72022Q', 'S72022R', 'S72022S', 'S72023A', 'S72023B', 'S72023C', 'S72023D',
        'S72023E', 'S72023F', 'S72023G', 'S72023H', 'S72023J', 'S72023K', 'S72023M', 'S72023N',
        'S72023P', 'S72023Q', 'S72023R', 'S72023S', 'S72024A', 'S72024B', 'S72024C', 'S72024D',
        'S72024E', 'S72024F', 'S72024G', 'S72024H', 'S72024J', 'S72024K', 'S72024M', 'S72024N',
        'S72024P', 'S72024Q', 'S72024R', 'S72024S', 'S72025A', 'S72025B', 'S72025C', 'S72025D',
        'S72025E', 'S72025F', 'S72025G', 'S72025H', 'S72025J', 'S72025K', 'S72025M', 'S72025N',
        'S72025P', 'S72025Q', 'S72025R', 'S72025S', 'S72026A', 'S72026B', 'S72026C', 'S72026D',
        'S72026E', 'S72026F', 'S72026G', 'S72026H', 'S72026J', 'S72026K', 'S72026M', 'S72026N',
        'S72026P', 'S72026Q', 'S72026R', 'S72026S', 'S72031A', 'S72031B', 'S72031C', 'S72031D',
        'S72031E', 'S72031F', 'S72031G', 'S72031H', 'S72031J', 'S72031K', 'S72031M', 'S72031N',
        'S72031P', 'S72031Q', 'S72031R', 'S72031S', 'S72032A', 'S72032B', 'S72032C', 'S72032D',
        'S72032E', 'S72032F', 'S72032G', 'S72032H', 'S72032J', 'S72032K', 'S72032M', 'S72032N',
        'S72032P', 'S72032Q', 'S72032R', 'S72032S', 'S72033A', 'S72033B', 'S72033C', 'S72033D',
        'S72033E', 'S72033F', 'S72033G', 'S72033H', 'S72033J', 'S72033K', 'S72033M', 'S72033N',
        'S72033P', 'S72033Q', 'S72033R', 'S72033S', 'S72034A', 'S72034B', 'S72034C', 'S72034D',
        'S72034E', 'S72034F', 'S72034G', 'S72034H', 'S72034J', 'S72034K', 'S72034M', 'S72034N',
        'S72034P', 'S72034Q', 'S72034R', 'S72034S', 'S72035A', 'S72035B', 'S72035C', 'S72035D',
        'S72035E', 'S72035F', 'S72035G', 'S72035H', 'S72035J', 'S72035K', 'S72035M', 'S72035N',
        'S72035P', 'S72035Q', 'S72035R', 'S72035S', 'S72036A', 'S72036B', 'S72036C', 'S72036D',
        'S72036E', 'S72036F', 'S72036G', 'S72036H', 'S72036J', 'S72036K', 'S72036M', 'S72036N',
        'S72036P', 'S72036Q', 'S72036R', 'S72036S', 'S72041A', 'S72041B', 'S72041C', 'S72041D',
        'S72041E', 'S72041F', 'S72041G', 'S72041H', 'S72041J', 'S72041K', 'S72041M', 'S72041N',
        'S72041P', 'S72041Q', 'S72041R', 'S72041S', 'S72042A', 'S72042B', 'S72042C', 'S72042D',
        'S72042E', 'S72042F', 'S72042G', 'S72042H', 'S72042J', 'S72042K', 'S72042M', 'S72042N',
        'S72042P', 'S72042Q', 'S72042R', 'S72042S', 'S72043A', 'S72043B', 'S72043C', 'S72043D',
        'S72043E', 'S72043F', 'S72043G', 'S72043H', 'S72043J', 'S72043K', 'S72043M', 'S72043N',
        'S72043P', 'S72043Q', 'S72043R', 'S72043S', 'S72044A', 'S72044B', 'S72044C', 'S72044D',
        'S72044E', 'S72044F', 'S72044G', 'S72044H', 'S72044J', 'S72044K', 'S72044M', 'S72044N',
        'S72044P', 'S72044Q', 'S72044R', 'S72044S', 'S72045A', 'S72045B', 'S72045C', 'S72045D',
        'S72045E', 'S72045F', 'S72045G', 'S72045H', 'S72045J', 'S72045K', 'S72045M', 'S72045N',
        'S72045P', 'S72045Q', 'S72045R', 'S72045S', 'S72046A', 'S72046B', 'S72046C', 'S72046D',
        'S72046E', 'S72046F', 'S72046G', 'S72046H', 'S72046J', 'S72046K', 'S72046M', 'S72046N',
        'S72046P', 'S72046Q', 'S72046R', 'S72046S', 'S72051A', 'S72051B', 'S72051C', 'S72051D',
        'S72051E', 'S72051F', 'S72051G', 'S72051H', 'S72051J', 'S72051K', 'S72051M', 'S72051N',
        'S72051P', 'S72051Q', 'S72051R', 'S72051S', 'S72052A', 'S72052B', 'S72052C', 'S72052D',
        'S72052E', 'S72052F', 'S72052G', 'S72052H', 'S72052J', 'S72052K', 'S72052M', 'S72052N',
        'S72052P', 'S72052Q', 'S72052R', 'S72052S', 'S72059A', 'S72059B', 'S72059C', 'S72059D',
        'S72059E', 'S72059F', 'S72059G', 'S72059H', 'S72059J', 'S72059K', 'S72059M', 'S72059N',
        'S72059P', 'S72059Q', 'S72059R', 'S72059S', 'S72061A', 'S72061B', 'S72061C', 'S72061D',
        'S72061E', 'S72061F', 'S72061G', 'S72061H', 'S72061J', 'S72061K', 'S72061M', 'S72061N',
        'S72061P', 'S72061Q', 'S72061R', 'S72061S', 'S72062A', 'S72062B', 'S72062C', 'S72062D',
        'S72062E', 'S72062F', 'S72062G', 'S72062H', 'S72062J', 'S72062K', 'S72062M', 'S72062N',
        'S72062P', 'S72062Q', 'S72062R', 'S72062S', 'S72063A', 'S72063B', 'S72063C', 'S72063D',
        'S72063E', 'S72063F', 'S72063G', 'S72063H', 'S72063J', 'S72063K', 'S72063M', 'S72063N',
        'S72063P', 'S72063Q', 'S72063R', 'S72063S', 'S72064A', 'S72064B', 'S72064C', 'S72064D',
        'S72064E', 'S72064F', 'S72064G', 'S72064H', 'S72064J', 'S72064K', 'S72064M', 'S72064N',
        'S72064P', 'S72064Q', 'S72064R', 'S72064S', 'S72065A', 'S72065B', 'S72065C', 'S72065D',
        'S72065E', 'S72065F', 'S72065G', 'S72065H', 'S72065J', 'S72065K', 'S72065M', 'S72065N',
        'S72065P', 'S72065Q', 'S72065R', 'S72065S', 'S72066A', 'S72066B', 'S72066C', 'S72066D',
        'S72066E', 'S72066F', 'S72066G', 'S72066H', 'S72066J', 'S72066K', 'S72066M', 'S72066N',
        'S72066P', 'S72066Q', 'S72066R', 'S72066S', 'S72091A', 'S72091B', 'S72091C', 'S72091D',
        'S72091E', 'S72091F', 'S72091G', 'S72091H', 'S72091J', 'S72091K', 'S72091M', 'S72091N',
        'S72091P', 'S72091Q', 'S72091R', 'S72091S', 'S72092A', 'S72092B', 'S72092C', 'S72092D',
        'S72092E', 'S72092F', 'S72092G', 'S72092H', 'S72092J', 'S72092K', 'S72092M', 'S72092N',
        'S72092P', 'S72092Q', 'S72092R', 'S72092S', 'S72099A', 'S72099B', 'S72099C', 'S72099D',
        'S72099E', 'S72099F', 'S72099G', 'S72099H', 'S72099J', 'S72099K', 'S72099M', 'S72099N',
        'S72099P', 'S72099Q', 'S72099R', 'S72099S', 'S72101A', 'S72101B', 'S72101C', 'S72101D',
        'S72101E', 'S72101F', 'S72101G', 'S72101H', 'S72101J', 'S72101K', 'S72101M', 'S72101N',
        'S72101P', 'S72101Q', 'S72101R', 'S72101S', 'S72102A', 'S72102B', 'S72102C', 'S72102D',
        'S72102E', 'S72102F', 'S72102G', 'S72102H', 'S72102J', 'S72102K', 'S72102M', 'S72102N',
        'S72102P', 'S72102Q', 'S72102R', 'S72102S', 'S72109A', 'S72109B', 'S72109C', 'S72109D',
        'S72109E', 'S72109F', 'S72109G', 'S72109H', 'S72109J', 'S72109K', 'S72109M', 'S72109N',
        'S72109P', 'S72109Q', 'S72109R', 'S72109S', 'S72111A', 'S72111B', 'S72111C', 'S72111D',
        'S72111E', 'S72111F', 'S72111G', 'S72111H', 'S72111J', 'S72111K', 'S72111M', 'S72111N',
        'S72111P', 'S72111Q', 'S72111R', 'S72111S', 'S72112A', 'S72112B', 'S72112C', 'S72112D',
        'S72112E', 'S72112F', 'S72112G', 'S72112H', 'S72112J', 'S72112K', 'S72112M', 'S72112N',
        'S72112P', 'S72112Q', 'S72112R', 'S72112S', 'S72113A', 'S72113B', 'S72113C', 'S72113D',
        'S72113E', 'S72113F', 'S72113G', 'S72113H', 'S72113J', 'S72113K', 'S72113M', 'S72113N',
        'S72113P', 'S72113Q', 'S72113R', 'S72113S', 'S72114A', 'S72114B', 'S72114C', 'S72114D',
        'S72114E', 'S72114F', 'S72114G', 'S72114H', 'S72114J', 'S72114K', 'S72114M', 'S72114N',
        'S72114P', 'S72114Q', 'S72114R', 'S72114S', 'S72115A', 'S72115B', 'S72115C', 'S72115D',
        'S72115E', 'S72115F', 'S72115G', 'S72115H', 'S72115J', 'S72115K', 'S72115M', 'S72115N',
        'S72115P', 'S72115Q', 'S72115R', 'S72115S', 'S72116A', 'S72116B', 'S72116C', 'S72116D',
        'S72116E', 'S72116F', 'S72116G', 'S72116H', 'S72116J', 'S72116K', 'S72116M', 'S72116N',
        'S72116P', 'S72116Q', 'S72116R', 'S72116S', 'S72121A', 'S72121B', 'S72121C', 'S72121D',
        'S72121E', 'S72121F', 'S72121G', 'S72121H', 'S72121J', 'S72121K', 'S72121M', 'S72121N',
        'S72121P', 'S72121Q', 'S72121R', 'S72121S', 'S72122A', 'S72122B', 'S72122C', 'S72122D',
        'S72122E', 'S72122F', 'S72122G', 'S72122H', 'S72122J', 'S72122K', 'S72122M', 'S72122N',
        'S72122P', 'S72122Q', 'S72122R', 'S72122S', 'S72123A', 'S72123B', 'S72123C', 'S72123D',
        'S72123E', 'S72123F', 'S72123G', 'S72123H', 'S72123J', 'S72123K', 'S72123M', 'S72123N',
        'S72123P', 'S72123Q', 'S72123R', 'S72123S', 'S72124A', 'S72124B', 'S72124C', 'S72124D',
        'S72124E', 'S72124F', 'S72124G', 'S72124H', 'S72124J', 'S72124K', 'S72124M', 'S72124N',
        'S72124P', 'S72124Q', 'S72124R', 'S72124S', 'S72125A', 'S72125B', 'S72125C', 'S72125D',
        'S72125E', 'S72125F', 'S72125G', 'S72125H', 'S72125J', 'S72125K', 'S72125M', 'S72125N',
        'S72125P', 'S72125Q', 'S72125R', 'S72125S', 'S72126A', 'S72126B', 'S72126C', 'S72126D',
        'S72126E', 'S72126F', 'S72126G', 'S72126H', 'S72126J', 'S72126K', 'S72126M', 'S72126N',
        'S72126P', 'S72126Q', 'S72126R', 'S72126S', 'S72131A', 'S72131B', 'S72131C', 'S72131D',
        'S72131E', 'S72131F', 'S72131G', 'S72131H', 'S72131J', 'S72131K', 'S72131M', 'S72131N',
        'S72131P', 'S72131Q', 'S72131R', 'S72131S', 'S72132A', 'S72132B', 'S72132C', 'S72132D',
        'S72132E', 'S72132F', 'S72132G', 'S72132H', 'S72132J', 'S72132K', 'S72132M', 'S72132N',
        'S72132P', 'S72132Q', 'S72132R', 'S72132S', 'S72133A', 'S72133B', 'S72133C', 'S72133D',
        'S72133E', 'S72133F', 'S72133G', 'S72133H', 'S72133J', 'S72133K', 'S72133M', 'S72133N',
        'S72133P', 'S72133Q', 'S72133R', 'S72133S', 'S72134A', 'S72134B', 'S72134C', 'S72134D',
        'S72134E', 'S72134F', 'S72134G', 'S72134H', 'S72134J', 'S72134K', 'S72134M', 'S72134N',
        'S72134P', 'S72134Q', 'S72134R', 'S72134S', 'S72135A', 'S72135B', 'S72135C', 'S72135D',
        'S72135E', 'S72135F', 'S72135G', 'S72135H', 'S72135J', 'S72135K', 'S72135M', 'S72135N',
        'S72135P', 'S72135Q', 'S72135R', 'S72135S', 'S72136A', 'S72136B', 'S72136C', 'S72136D',
        'S72136E', 'S72136F', 'S72136G', 'S72136H', 'S72136J', 'S72136K', 'S72136M', 'S72136N',
        'S72136P', 'S72136Q', 'S72136R', 'S72136S', 'S72141A', 'S72141B', 'S72141C', 'S72141D',
        'S72141E', 'S72141F', 'S72141G', 'S72141H', 'S72141J', 'S72141K', 'S72141M', 'S72141N',
        'S72141P', 'S72141Q', 'S72141R', 'S72141S', 'S72142A', 'S72142B', 'S72142C', 'S72142D',
        'S72142E', 'S72142F', 'S72142G', 'S72142H', 'S72142J', 'S72142K', 'S72142M', 'S72142N',
        'S72142P', 'S72142Q', 'S72142R', 'S72142S', 'S72143A', 'S72143B', 'S72143C', 'S72143D',
        'S72143E', 'S72143F', 'S72143G', 'S72143H', 'S72143J', 'S72143K', 'S72143M', 'S72143N',
        'S72143P', 'S72143Q', 'S72143R', 'S72143S', 'S72144A', 'S72144B', 'S72144C', 'S72144D',
        'S72144E', 'S72144F', 'S72144G', 'S72144H', 'S72144J', 'S72144K', 'S72144M', 'S72144N',
        'S72144P', 'S72144Q', 'S72144R', 'S72144S', 'S72145A', 'S72145B', 'S72145C', 'S72145D',
        'S72145E', 'S72145F', 'S72145G', 'S72145H', 'S72145J', 'S72145K', 'S72145M', 'S72145N',
        'S72145P', 'S72145Q', 'S72145R', 'S72145S', 'S72146A', 'S72146B', 'S72146C', 'S72146D',
        'S72146E', 'S72146F', 'S72146G', 'S72146H', 'S72146J', 'S72146K', 'S72146M', 'S72146N',
        'S72146P', 'S72146Q', 'S72146R', 'S72146S', 'S7221XA', 'S7221XB', 'S7221XC', 'S7221XD',
        'S7221XE', 'S7221XF', 'S7221XG', 'S7221XH', 'S7221XJ', 'S7221XK', 'S7221XM', 'S7221XN',
        'S7221XP', 'S7221XQ', 'S7221XR', 'S7221XS', 'S7222XA', 'S7222XB', 'S7222XC', 'S7222XD',
        'S7222XE', 'S7222XF', 'S7222XG', 'S7222XH', 'S7222XJ', 'S7222XK', 'S7222XM', 'S7222XN',
        'S7222XP', 'S7222XQ', 'S7222XR', 'S7222XS', 'S7223XA', 'S7223XB', 'S7223XC', 'S7223XD',
        'S7223XE', 'S7223XF', 'S7223XG', 'S7223XH', 'S7223XJ', 'S7223XK', 'S7223XM', 'S7223XN',
        'S7223XP', 'S7223XQ', 'S7223XR', 'S7223XS', 'S7224XA', 'S7224XB', 'S7224XC', 'S7224XD',
        'S7224XE', 'S7224XF', 'S7224XG', 'S7224XH', 'S7224XJ', 'S7224XK', 'S7224XM', 'S7224XN',
        'S7224XP', 'S7224XQ', 'S7224XR', 'S7224XS', 'S7225XA', 'S7225XB', 'S7225XC', 'S7225XD',
        'S7225XE', 'S7225XF', 'S7225XG', 'S7225XH', 'S7225XJ', 'S7225XK', 'S7225XM', 'S7225XN',
        'S7225XP', 'S7225XQ', 'S7225XR', 'S7225XS', 'S7226XA', 'S7226XB', 'S7226XC', 'S7226XD',
        'S7226XE', 'S7226XF', 'S7226XG', 'S7226XH', 'S7226XJ', 'S7226XK', 'S7226XM', 'S7226XN',
        'S7226XP', 'S7226XQ', 'S7226XR', 'S7226XS', 'S72301A', 'S72301B', 'S72301C', 'S72301D',
        'S72301E', 'S72301F', 'S72301G', 'S72301H', 'S72301J', 'S72301K', 'S72301M', 'S72301N',
        'S72301P', 'S72301Q', 'S72301R', 'S72301S', 'S72302A', 'S72302B', 'S72302C', 'S72302D',
        'S72302E', 'S72302F', 'S72302G', 'S72302H', 'S72302J', 'S72302K', 'S72302M', 'S72302N',
        'S72302P', 'S72302Q', 'S72302R', 'S72302S', 'S72309A', 'S72309B', 'S72309C', 'S72309D',
        'S72309E', 'S72309F', 'S72309G', 'S72309H', 'S72309J', 'S72309K', 'S72309M', 'S72309N',
        'S72309P', 'S72309Q', 'S72309R', 'S72309S', 'S72321A', 'S72321B', 'S72321C', 'S72321D',
        'S72321E', 'S72321F', 'S72321G', 'S72321H', 'S72321J', 'S72321K', 'S72321M', 'S72321N',
        'S72321P', 'S72321Q', 'S72321R', 'S72321S', 'S72322A', 'S72322B', 'S72322C', 'S72322D',
        'S72322E', 'S72322F', 'S72322G', 'S72322H', 'S72322J', 'S72322K', 'S72322M', 'S72322N',
        'S72322P', 'S72322Q', 'S72322R', 'S72322S', 'S72323A', 'S72323B', 'S72323C', 'S72323D',
        'S72323E', 'S72323F', 'S72323G', 'S72323H', 'S72323J', 'S72323K', 'S72323M', 'S72323N',
        'S72323P', 'S72323Q', 'S72323R', 'S72323S', 'S72324A', 'S72324B', 'S72324C', 'S72324D',
        'S72324E', 'S72324F', 'S72324G', 'S72324H', 'S72324J', 'S72324K', 'S72324M', 'S72324N',
        'S72324P', 'S72324Q', 'S72324R', 'S72324S', 'S72325A', 'S72325B', 'S72325C', 'S72325D',
        'S72325E', 'S72325F', 'S72325G', 'S72325H', 'S72325J', 'S72325K', 'S72325M', 'S72325N',
        'S72325P', 'S72325Q', 'S72325R', 'S72325S', 'S72326A', 'S72326B', 'S72326C', 'S72326D',
        'S72326E', 'S72326F', 'S72326G', 'S72326H', 'S72326J', 'S72326K', 'S72326M', 'S72326N',
        'S72326P', 'S72326Q', 'S72326R', 'S72326S', 'S72331A', 'S72331B', 'S72331C', 'S72331D',
        'S72331E', 'S72331F', 'S72331G', 'S72331H', 'S72331J', 'S72331K', 'S72331M', 'S72331N',
        'S72331P', 'S72331Q', 'S72331R', 'S72331S', 'S72332A', 'S72332B', 'S72332C', 'S72332D',
        'S72332E', 'S72332F', 'S72332G', 'S72332H', 'S72332J', 'S72332K', 'S72332M', 'S72332N',
        'S72332P', 'S72332Q', 'S72332R', 'S72332S', 'S72333A', 'S72333B', 'S72333C', 'S72333D',
        'S72333E', 'S72333F', 'S72333G', 'S72333H', 'S72333J', 'S72333K', 'S72333M', 'S72333N',
        'S72333P', 'S72333Q', 'S72333R', 'S72333S', 'S72334A', 'S72334B', 'S72334C', 'S72334D',
        'S72334E', 'S72334F', 'S72334G', 'S72334H', 'S72334J', 'S72334K', 'S72334M', 'S72334N',
        'S72334P', 'S72334Q', 'S72334R', 'S72334S', 'S72335A', 'S72335B', 'S72335C', 'S72335D',
        'S72335E', 'S72335F', 'S72335G', 'S72335H', 'S72335J', 'S72335K', 'S72335M', 'S72335N',
        'S72335P', 'S72335Q', 'S72335R', 'S72335S', 'S72336A', 'S72336B', 'S72336C', 'S72336D',
        'S72336E', 'S72336F', 'S72336G', 'S72336H', 'S72336J', 'S72336K', 'S72336M', 'S72336N',
        'S72336P', 'S72336Q', 'S72336R', 'S72336S', 'S72341A', 'S72341B', 'S72341C', 'S72341D',
        'S72341E', 'S72341F', 'S72341G', 'S72341H', 'S72341J', 'S72341K', 'S72341M', 'S72341N',
        'S72341P', 'S72341Q', 'S72341R', 'S72341S', 'S72342A', 'S72342B', 'S72342C', 'S72342D',
        'S72342E', 'S72342F', 'S72342G', 'S72342H', 'S72342J', 'S72342K', 'S72342M', 'S72342N',
        'S72342P', 'S72342Q', 'S72342R', 'S72342S', 'S72343A', 'S72343B', 'S72343C', 'S72343D',
        'S72343E', 'S72343F', 'S72343G', 'S72343H', 'S72343J', 'S72343K', 'S72343M', 'S72343N',
        'S72343P', 'S72343Q', 'S72343R', 'S72343S', 'S72344A', 'S72344B', 'S72344C', 'S72344D',
        'S72344E', 'S72344F', 'S72344G', 'S72344H', 'S72344J', 'S72344K', 'S72344M', 'S72344N',
        'S72344P', 'S72344Q', 'S72344R', 'S72344S', 'S72345A', 'S72345B', 'S72345C', 'S72345D',
        'S72345E', 'S72345F', 'S72345G', 'S72345H', 'S72345J', 'S72345K', 'S72345M', 'S72345N',
        'S72345P', 'S72345Q', 'S72345R', 'S72345S', 'S72346A', 'S72346B', 'S72346C', 'S72346D',
        'S72346E', 'S72346F', 'S72346G', 'S72346H', 'S72346J', 'S72346K', 'S72346M', 'S72346N',
        'S72346P', 'S72346Q', 'S72346R', 'S72346S', 'S72351A', 'S72351B', 'S72351C', 'S72351D',
        'S72351E', 'S72351F', 'S72351G', 'S72351H', 'S72351J', 'S72351K', 'S72351M', 'S72351N',
        'S72351P', 'S72351Q', 'S72351R', 'S72351S', 'S72352A', 'S72352B', 'S72352C', 'S72352D',
        'S72352E', 'S72352F', 'S72352G', 'S72352H', 'S72352J', 'S72352K', 'S72352M', 'S72352N',
        'S72352P', 'S72352Q', 'S72352R', 'S72352S', 'S72353A', 'S72353B', 'S72353C', 'S72353D',
        'S72353E', 'S72353F', 'S72353G', 'S72353H', 'S72353J', 'S72353K', 'S72353M', 'S72353N',
        'S72353P', 'S72353Q', 'S72353R', 'S72353S', 'S72354A', 'S72354B', 'S72354C', 'S72354D',
        'S72354E', 'S72354F', 'S72354G', 'S72354H', 'S72354J', 'S72354K', 'S72354M', 'S72354N',
        'S72354P', 'S72354Q', 'S72354R', 'S72354S', 'S72355A', 'S72355B', 'S72355C', 'S72355D',
        'S72355E', 'S72355F', 'S72355G', 'S72355H', 'S72355J', 'S72355K', 'S72355M', 'S72355N',
        'S72355P', 'S72355Q', 'S72355R', 'S72355S', 'S72356A', 'S72356B', 'S72356C', 'S72356D',
        'S72356E', 'S72356F', 'S72356G', 'S72356H', 'S72356J', 'S72356K', 'S72356M', 'S72356N',
        'S72356P', 'S72356Q', 'S72356R', 'S72356S', 'S72361A', 'S72361B', 'S72361C', 'S72361D',
        'S72361E', 'S72361F', 'S72361G', 'S72361H', 'S72361J', 'S72361K', 'S72361M', 'S72361N',
        'S72361P', 'S72361Q', 'S72361R', 'S72361S', 'S72362A', 'S72362B', 'S72362C', 'S72362D',
        'S72362E', 'S72362F', 'S72362G', 'S72362H', 'S72362J', 'S72362K', 'S72362M', 'S72362N',
        'S72362P', 'S72362Q', 'S72362R', 'S72362S', 'S72363A', 'S72363B', 'S72363C', 'S72363D',
        'S72363E', 'S72363F', 'S72363G', 'S72363H', 'S72363J', 'S72363K', 'S72363M', 'S72363N',
        'S72363P', 'S72363Q', 'S72363R', 'S72363S', 'S72364A', 'S72364B', 'S72364C', 'S72364D',
        'S72364E', 'S72364F', 'S72364G', 'S72364H', 'S72364J', 'S72364K', 'S72364M', 'S72364N',
        'S72364P', 'S72364Q', 'S72364R', 'S72364S', 'S72365A', 'S72365B', 'S72365C', 'S72365D',
        'S72365E', 'S72365F', 'S72365G', 'S72365H', 'S72365J', 'S72365K', 'S72365M', 'S72365N',
        'S72365P', 'S72365Q', 'S72365R', 'S72365S', 'S72366A', 'S72366B', 'S72366C', 'S72366D',
        'S72366E', 'S72366F', 'S72366G', 'S72366H', 'S72366J', 'S72366K', 'S72366M', 'S72366N',
        'S72366P', 'S72366Q', 'S72366R', 'S72366S', 'S72391A', 'S72391B', 'S72391C', 'S72391D',
        'S72391E', 'S72391F', 'S72391G', 'S72391H', 'S72391J', 'S72391K', 'S72391M', 'S72391N',
        'S72391P', 'S72391Q', 'S72391R', 'S72391S', 'S72392A', 'S72392B', 'S72392C', 'S72392D',
        'S72392E', 'S72392F', 'S72392G', 'S72392H', 'S72392J', 'S72392K', 'S72392M', 'S72392N',
        'S72392P', 'S72392Q', 'S72392R', 'S72392S', 'S72399A', 'S72399B', 'S72399C', 'S72399D',
        'S72399E', 'S72399F', 'S72399G', 'S72399H', 'S72399J', 'S72399K', 'S72399M', 'S72399N',
        'S72399P', 'S72399Q', 'S72399R', 'S72399S', 'S72401A', 'S72401B', 'S72401C', 'S72401D',
        'S72401E', 'S72401F', 'S72401G', 'S72401H', 'S72401J', 'S72401K', 'S72401M', 'S72401N',
        'S72401P', 'S72401Q', 'S72401R', 'S72401S', 'S72402A', 'S72402B', 'S72402C', 'S72402D',
        'S72402E', 'S72402F', 'S72402G', 'S72402H', 'S72402J', 'S72402K', 'S72402M', 'S72402N',
        'S72402P', 'S72402Q', 'S72402R', 'S72402S', 'S72409A', 'S72409B', 'S72409C', 'S72409D',
        'S72409E', 'S72409F', 'S72409G', 'S72409H', 'S72409J', 'S72409K', 'S72409M', 'S72409N',
        'S72409P', 'S72409Q', 'S72409R', 'S72409S', 'S72411A', 'S72411B', 'S72411C', 'S72411D',
        'S72411E', 'S72411F', 'S72411G', 'S72411H', 'S72411J', 'S72411K', 'S72411M', 'S72411N',
        'S72411P', 'S72411Q', 'S72411R', 'S72411S', 'S72412A', 'S72412B', 'S72412C', 'S72412D',
        'S72412E', 'S72412F', 'S72412G', 'S72412H', 'S72412J', 'S72412K', 'S72412M', 'S72412N',
        'S72412P', 'S72412Q', 'S72412R', 'S72412S', 'S72413A', 'S72413B', 'S72413C', 'S72413D',
        'S72413E', 'S72413F', 'S72413G', 'S72413H', 'S72413J', 'S72413K', 'S72413M', 'S72413N',
        'S72413P', 'S72413Q', 'S72413R', 'S72413S', 'S72414A', 'S72414B', 'S72414C', 'S72414D',
        'S72414E', 'S72414F', 'S72414G', 'S72414H', 'S72414J', 'S72414K', 'S72414M', 'S72414N',
        'S72414P', 'S72414Q', 'S72414R', 'S72414S', 'S72415A', 'S72415B', 'S72415C', 'S72415D',
        'S72415E', 'S72415F', 'S72415G', 'S72415H', 'S72415J', 'S72415K', 'S72415M', 'S72415N',
        'S72415P', 'S72415Q', 'S72415R', 'S72415S', 'S72416A', 'S72416B', 'S72416C', 'S72416D',
        'S72416E', 'S72416F', 'S72416G', 'S72416H', 'S72416J', 'S72416K', 'S72416M', 'S72416N',
        'S72416P', 'S72416Q', 'S72416R', 'S72416S', 'S72421A', 'S72421B', 'S72421C', 'S72421D',
        'S72421E', 'S72421F', 'S72421G', 'S72421H', 'S72421J', 'S72421K', 'S72421M', 'S72421N',
        'S72421P', 'S72421Q', 'S72421R', 'S72421S', 'S72422A', 'S72422B', 'S72422C', 'S72422D',
        'S72422E', 'S72422F', 'S72422G', 'S72422H', 'S72422J', 'S72422K', 'S72422M', 'S72422N',
        'S72422P', 'S72422Q', 'S72422R', 'S72422S', 'S72423A', 'S72423B', 'S72423C', 'S72423D',
        'S72423E', 'S72423F', 'S72423G', 'S72423H', 'S72423J', 'S72423K', 'S72423M', 'S72423N',
        'S72423P', 'S72423Q', 'S72423R', 'S72423S', 'S72424A', 'S72424B', 'S72424C', 'S72424D',
        'S72424E', 'S72424F', 'S72424G', 'S72424H', 'S72424J', 'S72424K', 'S72424M', 'S72424N',
        'S72424P', 'S72424Q', 'S72424R', 'S72424S', 'S72425A', 'S72425B', 'S72425C', 'S72425D',
        'S72425E', 'S72425F', 'S72425G', 'S72425H', 'S72425J', 'S72425K', 'S72425M', 'S72425N',
        'S72425P', 'S72425Q', 'S72425R', 'S72425S', 'S72426A', 'S72426B', 'S72426C', 'S72426D',
        'S72426E', 'S72426F', 'S72426G', 'S72426H', 'S72426J', 'S72426K', 'S72426M', 'S72426N',
        'S72426P', 'S72426Q', 'S72426R', 'S72426S', 'S72431A', 'S72431B', 'S72431C', 'S72431D',
        'S72431E', 'S72431F', 'S72431G', 'S72431H', 'S72431J', 'S72431K', 'S72431M', 'S72431N',
        'S72431P', 'S72431Q', 'S72431R', 'S72431S', 'S72432A', 'S72432B', 'S72432C', 'S72432D',
        'S72432E', 'S72432F', 'S72432G', 'S72432H', 'S72432J', 'S72432K', 'S72432M', 'S72432N',
        'S72432P', 'S72432Q', 'S72432R', 'S72432S', 'S72433A', 'S72433B', 'S72433C', 'S72433D',
        'S72433E', 'S72433F', 'S72433G', 'S72433H', 'S72433J', 'S72433K', 'S72433M', 'S72433N',
        'S72433P', 'S72433Q', 'S72433R', 'S72433S', 'S72434A', 'S72434B', 'S72434C', 'S72434D',
        'S72434E', 'S72434F', 'S72434G', 'S72434H', 'S72434J', 'S72434K', 'S72434M', 'S72434N',
        'S72434P', 'S72434Q', 'S72434R', 'S72434S', 'S72435A', 'S72435B', 'S72435C', 'S72435D',
        'S72435E', 'S72435F', 'S72435G', 'S72435H', 'S72435J', 'S72435K', 'S72435M', 'S72435N',
        'S72435P', 'S72435Q', 'S72435R', 'S72435S', 'S72436A', 'S72436B', 'S72436C', 'S72436D',
        'S72436E', 'S72436F', 'S72436G', 'S72436H', 'S72436J', 'S72436K', 'S72436M', 'S72436N',
        'S72436P', 'S72436Q', 'S72436R', 'S72436S', 'S72441A', 'S72441B', 'S72441C', 'S72441D',
        'S72441E', 'S72441F', 'S72441G', 'S72441H', 'S72441J', 'S72441K', 'S72441M', 'S72441N',
        'S72441P', 'S72441Q', 'S72441R', 'S72441S', 'S72442A', 'S72442B', 'S72442C', 'S72442D',
        'S72442E', 'S72442F', 'S72442G', 'S72442H', 'S72442J', 'S72442K', 'S72442M', 'S72442N',
        'S72442P', 'S72442Q', 'S72442R', 'S72442S', 'S72443A', 'S72443B', 'S72443C', 'S72443D',
        'S72443E', 'S72443F', 'S72443G', 'S72443H', 'S72443J', 'S72443K', 'S72443M', 'S72443N',
        'S72443P', 'S72443Q', 'S72443R', 'S72443S', 'S72444A', 'S72444B', 'S72444C', 'S72444D',
        'S72444E', 'S72444F', 'S72444G', 'S72444H', 'S72444J', 'S72444K', 'S72444M', 'S72444N',
        'S72444P', 'S72444Q', 'S72444R', 'S72444S', 'S72445A', 'S72445B', 'S72445C', 'S72445D',
        'S72445E', 'S72445F', 'S72445G', 'S72445H', 'S72445J', 'S72445K', 'S72445M', 'S72445N',
        'S72445P', 'S72445Q', 'S72445R', 'S72445S', 'S72446A', 'S72446B', 'S72446C', 'S72446D',
        'S72446E', 'S72446F', 'S72446G', 'S72446H', 'S72446J', 'S72446K', 'S72446M', 'S72446N',
        'S72446P', 'S72446Q', 'S72446R', 'S72446S', 'S72451A', 'S72451B', 'S72451C', 'S72451D',
        'S72451E', 'S72451F', 'S72451G', 'S72451H', 'S72451J', 'S72451K', 'S72451M', 'S72451N',
        'S72451P', 'S72451Q', 'S72451R', 'S72451S', 'S72452A', 'S72452B', 'S72452C', 'S72452D',
        'S72452E', 'S72452F', 'S72452G', 'S72452H', 'S72452J', 'S72452K', 'S72452M', 'S72452N',
        'S72452P', 'S72452Q', 'S72452R', 'S72452S', 'S72453A', 'S72453B', 'S72453C', 'S72453D',
        'S72453E', 'S72453F', 'S72453G', 'S72453H', 'S72453J', 'S72453K', 'S72453M', 'S72453N',
        'S72453P', 'S72453Q', 'S72453R', 'S72453S', 'S72454A', 'S72454B', 'S72454C', 'S72454D',
        'S72454E', 'S72454F', 'S72454G', 'S72454H', 'S72454J', 'S72454K', 'S72454M', 'S72454N',
        'S72454P', 'S72454Q', 'S72454R', 'S72454S', 'S72455A', 'S72455B', 'S72455C', 'S72455D',
        'S72455E', 'S72455F', 'S72455G', 'S72455H', 'S72455J', 'S72455K', 'S72455M', 'S72455N',
        'S72455P', 'S72455Q', 'S72455R', 'S72455S', 'S72456A', 'S72456B', 'S72456C', 'S72456D',
        'S72456E', 'S72456F', 'S72456G', 'S72456H', 'S72456J', 'S72456K', 'S72456M', 'S72456N',
        'S72456P', 'S72456Q', 'S72456R', 'S72456S', 'S72461A', 'S72461B', 'S72461C', 'S72461D',
        'S72461E', 'S72461F', 'S72461G', 'S72461H', 'S72461J', 'S72461K', 'S72461M', 'S72461N',
        'S72461P', 'S72461Q', 'S72461R', 'S72461S', 'S72462A', 'S72462B', 'S72462C', 'S72462D',
        'S72462E', 'S72462F', 'S72462G', 'S72462H', 'S72462J', 'S72462K', 'S72462M', 'S72462N',
        'S72462P', 'S72462Q', 'S72462R', 'S72462S', 'S72463A', 'S72463B', 'S72463C', 'S72463D',
        'S72463E', 'S72463F', 'S72463G', 'S72463H', 'S72463J', 'S72463K', 'S72463M', 'S72463N',
        'S72463P', 'S72463Q', 'S72463R', 'S72463S', 'S72464A', 'S72464B', 'S72464C', 'S72464D',
        'S72464E', 'S72464F', 'S72464G', 'S72464H', 'S72464J', 'S72464K', 'S72464M', 'S72464N',
        'S72464P', 'S72464Q', 'S72464R', 'S72464S', 'S72465A', 'S72465B', 'S72465C', 'S72465D',
        'S72465E', 'S72465F', 'S72465G', 'S72465H', 'S72465J', 'S72465K', 'S72465M', 'S72465N',
        'S72465P', 'S72465Q', 'S72465R', 'S72465S', 'S72466A', 'S72466B', 'S72466C', 'S72466D',
        'S72466E', 'S72466F', 'S72466G', 'S72466H', 'S72466J', 'S72466K', 'S72466M', 'S72466N',
        'S72466P', 'S72466Q', 'S72466R', 'S72466S', 'S72471A', 'S72471D', 'S72471G', 'S72471K',
        'S72471P', 'S72471S', 'S72472A', 'S72472D', 'S72472G', 'S72472K', 'S72472P', 'S72472S',
        'S72479A', 'S72479D', 'S72479G', 'S72479K', 'S72479P', 'S72479S', 'S72491A', 'S72491B',
        'S72491C', 'S72491D', 'S72491E', 'S72491F', 'S72491G', 'S72491H', 'S72491J', 'S72491K',
        'S72491M', 'S72491N', 'S72491P', 'S72491Q', 'S72491R', 'S72491S', 'S72492A', 'S72492B',
        'S72492C', 'S72492D', 'S72492E', 'S72492F', 'S72492G', 'S72492H', 'S72492J', 'S72492K',
        'S72492M', 'S72492N', 'S72492P', 'S72492Q', 'S72492R', 'S72492S', 'S72499A', 'S72499B',
        'S72499C', 'S72499D', 'S72499E', 'S72499F', 'S72499G', 'S72499H', 'S72499J', 'S72499K',
        'S72499M', 'S72499N', 'S72499P', 'S72499Q', 'S72499R', 'S72499S', 'S728X1A', 'S728X1B',
        'S728X1C', 'S728X1D', 'S728X1E', 'S728X1F', 'S728X1G', 'S728X1H', 'S728X1J', 'S728X1K',
        'S728X1M', 'S728X1N', 'S728X1P', 'S728X1Q', 'S728X1R', 'S728X1S', 'S728X2A', 'S728X2B',
        'S728X2C', 'S728X2D', 'S728X2E', 'S728X2F', 'S728X2G', 'S728X2H', 'S728X2J', 'S728X2K',
        'S728X2M', 'S728X2N', 'S728X2P', 'S728X2Q', 'S728X2R', 'S728X2S', 'S728X9A', 'S728X9B',
        'S728X9C', 'S728X9D', 'S728X9E', 'S728X9F', 'S728X9G', 'S728X9H', 'S728X9J', 'S728X9K',
        'S728X9M', 'S728X9N', 'S728X9P', 'S728X9Q', 'S728X9R', 'S728X9S', 'S7290XA', 'S7290XB',
        'S7290XC', 'S7290XD', 'S7290XE', 'S7290XF', 'S7290XG', 'S7290XH', 'S7290XJ', 'S7290XK',
        'S7290XM', 'S7290XN', 'S7290XP', 'S7290XQ', 'S7290XR', 'S7290XS', 'S7291XA', 'S7291XB',
        'S7291XC', 'S7291XD', 'S7291XE', 'S7291XF', 'S7291XG', 'S7291XH', 'S7291XJ', 'S7291XK',
        'S7291XM', 'S7291XN', 'S7291XP', 'S7291XQ', 'S7291XR', 'S7291XS', 'S7292XA', 'S7292XB',
        'S7292XC', 'S7292XD', 'S7292XE', 'S7292XF', 'S7292XG', 'S7292XH', 'S7292XJ', 'S7292XK',
        'S7292XM', 'S7292XN', 'S7292XP', 'S7292XQ', 'S7292XR', 'S7292XS', 'S73004A', 'S73004D',
        'S73004S', 'S73005A', 'S73005D', 'S73005S', 'S73006A', 'S73006D', 'S73006S', 'S73014A',
        'S73014D', 'S73014S', 'S73015A', 'S73015D', 'S73015S', 'S73016A', 'S73016D', 'S73016S',
        'S73024A', 'S73024D', 'S73024S', 'S73025A', 'S73025D', 'S73025S', 'S73026A', 'S73026D',
        'S73026S', 'S73034A', 'S73034D', 'S73034S', 'S73035A', 'S73035D', 'S73035S', 'S73036A',
        'S73036D', 'S73036S', 'S73044A', 'S73044D', 'S73044S', 'S73045A', 'S73045D', 'S73045S',
        'S73046A', 'S73046D', 'S73046S', 'S79001A', 'S79001D', 'S79001G', 'S79001K', 'S79001P',
        'S79001S', 'S79002A', 'S79002D', 'S79002G', 'S79002K', 'S79002P', 'S79002S', 'S79009A',
        'S79009D', 'S79009G', 'S79009K', 'S79009P', 'S79009S', 'S79011A', 'S79011D', 'S79011G',
        'S79011K', 'S79011P', 'S79011S', 'S79012A', 'S79012D', 'S79012G', 'S79012K', 'S79012P',
        'S79012S', 'S79019A', 'S79019D', 'S79019G', 'S79019K', 'S79019P', 'S79019S', 'S79091A',
        'S79091D', 'S79091G', 'S79091K', 'S79091P', 'S79091S', 'S79092A', 'S79092D', 'S79092G',
        'S79092K', 'S79092P', 'S79092S', 'S79099A', 'S79099D', 'S79099G', 'S79099K', 'S79099P',
        'S79099S', 'S79101A', 'S79101D', 'S79101G', 'S79101K', 'S79101P', 'S79101S', 'S79102A',
        'S79102D', 'S79102G', 'S79102K', 'S79102P', 'S79102S', 'S79109A', 'S79109D', 'S79109G',
        'S79109K', 'S79109P', 'S79109S', 'S79111A', 'S79111D', 'S79111G', 'S79111K', 'S79111P',
        'S79111S', 'S79112A', 'S79112D', 'S79112G', 'S79112K', 'S79112P', 'S79112S', 'S79119A',
        'S79119D', 'S79119G', 'S79119K', 'S79119P', 'S79119S', 'S79121A', 'S79121D', 'S79121G',
        'S79121K', 'S79121P', 'S79121S', 'S79122A', 'S79122D', 'S79122G', 'S79122K', 'S79122P',
        'S79122S', 'S79129A', 'S79129D', 'S79129G', 'S79129K', 'S79129P', 'S79129S', 'S79131A',
        'S79131D', 'S79131G', 'S79131K', 'S79131P', 'S79131S', 'S79132A', 'S79132D', 'S79132G',
        'S79132K', 'S79132P', 'S79132S', 'S79139A', 'S79139D', 'S79139G', 'S79139K', 'S79139P',
        'S79139S', 'S79141A', 'S79141D', 'S79141G', 'S79141K', 'S79141P', 'S79141S', 'S79142A',
        'S79142D', 'S79142G', 'S79142K', 'S79142P', 'S79142S', 'S79149A', 'S79149D', 'S79149G',
        'S79149K', 'S79149P', 'S79149S', 'S79191A', 'S79191D', 'S79191G', 'S79191K', 'S79191P',
        'S79191S', 'S79192A', 'S79192D', 'S79192G', 'S79192K', 'S79192P', 'S79192S', 'S79199A',
        'S79199D', 'S79199G', 'S79199K', 'S79199P', 'S79199S', 'S82001A', 'S82001B', 'S82001C',
        'S82001D', 'S82001E', 'S82001F', 'S82001G', 'S82001H', 'S82001J', 'S82001K', 'S82001M',
        'S82001N', 'S82001P', 'S82001Q', 'S82001R', 'S82001S', 'S82002A', 'S82002B', 'S82002C',
        'S82002D', 'S82002E', 'S82002F', 'S82002G', 'S82002H', 'S82002J', 'S82002K', 'S82002M',
        'S82002N', 'S82002P', 'S82002Q', 'S82002R', 'S82002S', 'S82009A', 'S82009B', 'S82009C',
        'S82009D', 'S82009E', 'S82009F', 'S82009G', 'S82009H', 'S82009J', 'S82009K', 'S82009M',
        'S82009N', 'S82009P', 'S82009Q', 'S82009R', 'S82009S', 'S82011A', 'S82011B', 'S82011C',
        'S82011D', 'S82011E', 'S82011F', 'S82011G', 'S82011H', 'S82011J', 'S82011K', 'S82011M',
        'S82011N', 'S82011P', 'S82011Q', 'S82011R', 'S82011S', 'S82012A', 'S82012B', 'S82012C',
        'S82012D', 'S82012E', 'S82012F', 'S82012G', 'S82012H', 'S82012J', 'S82012K', 'S82012M',
        'S82012N', 'S82012P', 'S82012Q', 'S82012R', 'S82012S', 'S82013A', 'S82013B', 'S82013C',
        'S82013D', 'S82013E', 'S82013F', 'S82013G', 'S82013H', 'S82013J', 'S82013K', 'S82013M',
        'S82013N', 'S82013P', 'S82013Q', 'S82013R', 'S82013S', 'S82014A', 'S82014B', 'S82014C',
        'S82014D', 'S82014E', 'S82014F', 'S82014G', 'S82014H', 'S82014J', 'S82014K', 'S82014M',
        'S82014N', 'S82014P', 'S82014Q', 'S82014R', 'S82014S', 'S82015A', 'S82015B', 'S82015C',
        'S82015D', 'S82015E', 'S82015F', 'S82015G', 'S82015H', 'S82015J', 'S82015K', 'S82015M',
        'S82015N', 'S82015P', 'S82015Q', 'S82015R', 'S82015S', 'S82016A', 'S82016B', 'S82016C',
        'S82016D', 'S82016E', 'S82016F', 'S82016G', 'S82016H', 'S82016J', 'S82016K', 'S82016M',
        'S82016N', 'S82016P', 'S82016Q', 'S82016R', 'S82016S', 'S82021A', 'S82021B', 'S82021C',
        'S82021D', 'S82021E', 'S82021F', 'S82021G', 'S82021H', 'S82021J', 'S82021K', 'S82021M',
        'S82021N', 'S82021P', 'S82021Q', 'S82021R', 'S82021S', 'S82022A', 'S82022B', 'S82022C',
        'S82022D', 'S82022E', 'S82022F', 'S82022G', 'S82022H', 'S82022J', 'S82022K', 'S82022M',
        'S82022N', 'S82022P', 'S82022Q', 'S82022R', 'S82022S', 'S82023A', 'S82023B', 'S82023C',
        'S82023D', 'S82023E', 'S82023F', 'S82023G', 'S82023H', 'S82023J', 'S82023K', 'S82023M',
        'S82023N', 'S82023P', 'S82023Q', 'S82023R', 'S82023S', 'S82024A', 'S82024B', 'S82024C',
        'S82024D', 'S82024E', 'S82024F', 'S82024G', 'S82024H', 'S82024J', 'S82024K', 'S82024M',
        'S82024N', 'S82024P', 'S82024Q', 'S82024R', 'S82024S', 'S82025A', 'S82025B', 'S82025C',
        'S82025D', 'S82025E', 'S82025F', 'S82025G', 'S82025H', 'S82025J', 'S82025K', 'S82025M',
        'S82025N', 'S82025P', 'S82025Q', 'S82025R', 'S82025S', 'S82026A', 'S82026B', 'S82026C',
        'S82026D', 'S82026E', 'S82026F', 'S82026G', 'S82026H', 'S82026J', 'S82026K', 'S82026M',
        'S82026N', 'S82026P', 'S82026Q', 'S82026R', 'S82026S', 'S82031A', 'S82031B', 'S82031C',
        'S82031D', 'S82031E', 'S82031F', 'S82031G', 'S82031H', 'S82031J', 'S82031K', 'S82031M',
        'S82031N', 'S82031P', 'S82031Q', 'S82031R', 'S82031S', 'S82032A', 'S82032B', 'S82032C',
        'S82032D', 'S82032E', 'S82032F', 'S82032G', 'S82032H', 'S82032J', 'S82032K', 'S82032M',
        'S82032N', 'S82032P', 'S82032Q', 'S82032R', 'S82032S', 'S82033A', 'S82033B', 'S82033C',
        'S82033D', 'S82033E', 'S82033F', 'S82033G', 'S82033H', 'S82033J', 'S82033K', 'S82033M',
        'S82033N', 'S82033P', 'S82033Q', 'S82033R', 'S82033S', 'S82034A', 'S82034B', 'S82034C',
        'S82034D', 'S82034E', 'S82034F', 'S82034G', 'S82034H', 'S82034J', 'S82034K', 'S82034M',
        'S82034N', 'S82034P', 'S82034Q', 'S82034R', 'S82034S', 'S82035A', 'S82035B', 'S82035C',
        'S82035D', 'S82035E', 'S82035F', 'S82035G', 'S82035H', 'S82035J', 'S82035K', 'S82035M',
        'S82035N', 'S82035P', 'S82035Q', 'S82035R', 'S82035S', 'S82036A', 'S82036B', 'S82036C',
        'S82036D', 'S82036E', 'S82036F', 'S82036G', 'S82036H', 'S82036J', 'S82036K', 'S82036M',
        'S82036N', 'S82036P', 'S82036Q', 'S82036R', 'S82036S', 'S82041A', 'S82041B', 'S82041C',
        'S82041D', 'S82041E', 'S82041F', 'S82041G', 'S82041H', 'S82041J', 'S82041K', 'S82041M',
        'S82041N', 'S82041P', 'S82041Q', 'S82041R', 'S82041S', 'S82042A', 'S82042B', 'S82042C',
        'S82042D', 'S82042E', 'S82042F', 'S82042G', 'S82042H', 'S82042J', 'S82042K', 'S82042M',
        'S82042N', 'S82042P', 'S82042Q', 'S82042R', 'S82042S', 'S82043A', 'S82043B', 'S82043C',
        'S82043D', 'S82043E', 'S82043F', 'S82043G', 'S82043H', 'S82043J', 'S82043K', 'S82043M',
        'S82043N', 'S82043P', 'S82043Q', 'S82043R', 'S82043S', 'S82044A', 'S82044B', 'S82044C',
        'S82044D', 'S82044E', 'S82044F', 'S82044G', 'S82044H', 'S82044J', 'S82044K', 'S82044M',
        'S82044N', 'S82044P', 'S82044Q', 'S82044R', 'S82044S', 'S82045A', 'S82045B', 'S82045C',
        'S82045D', 'S82045E', 'S82045F', 'S82045G', 'S82045H', 'S82045J', 'S82045K', 'S82045M',
        'S82045N', 'S82045P', 'S82045Q', 'S82045R', 'S82045S', 'S82046A', 'S82046B', 'S82046C',
        'S82046D', 'S82046E', 'S82046F', 'S82046G', 'S82046H', 'S82046J', 'S82046K', 'S82046M',
        'S82046N', 'S82046P', 'S82046Q', 'S82046R', 'S82046S', 'S82091A', 'S82091B', 'S82091C',
        'S82091D', 'S82091E', 'S82091F', 'S82091G', 'S82091H', 'S82091J', 'S82091K', 'S82091M',
        'S82091N', 'S82091P', 'S82091Q', 'S82091R', 'S82091S', 'S82092A', 'S82092B', 'S82092C',
        'S82092D', 'S82092E', 'S82092F', 'S82092G', 'S82092H', 'S82092J', 'S82092K', 'S82092M',
        'S82092N', 'S82092P', 'S82092Q', 'S82092R', 'S82092S', 'S82099A', 'S82099B', 'S82099C',
        'S82099D', 'S82099E', 'S82099F', 'S82099G', 'S82099H', 'S82099J', 'S82099K', 'S82099M',
        'S82099N', 'S82099P', 'S82099Q', 'S82099R', 'S82099S', 'S82101A', 'S82101B', 'S82101C',
        'S82101D', 'S82101E', 'S82101F', 'S82101G', 'S82101H', 'S82101J', 'S82101K', 'S82101M',
        'S82101N', 'S82101P', 'S82101Q', 'S82101R', 'S82101S', 'S82102A', 'S82102B', 'S82102C',
        'S82102D', 'S82102E', 'S82102F', 'S82102G', 'S82102H', 'S82102J', 'S82102K', 'S82102M',
        'S82102N', 'S82102P', 'S82102Q', 'S82102R', 'S82102S', 'S82109A', 'S82109B', 'S82109C',
        'S82109D', 'S82109E', 'S82109F', 'S82109G', 'S82109H', 'S82109J', 'S82109K', 'S82109M',
        'S82109N', 'S82109P', 'S82109Q', 'S82109R', 'S82109S', 'S82111A', 'S82111B', 'S82111C',
        'S82111D', 'S82111E', 'S82111F', 'S82111G', 'S82111H', 'S82111J', 'S82111K', 'S82111M',
        'S82111N', 'S82111P', 'S82111Q', 'S82111R', 'S82111S', 'S82112A', 'S82112B', 'S82112C',
        'S82112D', 'S82112E', 'S82112F', 'S82112G', 'S82112H', 'S82112J', 'S82112K', 'S82112M',
        'S82112N', 'S82112P', 'S82112Q', 'S82112R', 'S82112S', 'S82113A', 'S82113B', 'S82113C',
        'S82113D', 'S82113E', 'S82113F', 'S82113G', 'S82113H', 'S82113J', 'S82113K', 'S82113M',
        'S82113N', 'S82113P', 'S82113Q', 'S82113R', 'S82113S', 'S82114A', 'S82114B', 'S82114C',
        'S82114D', 'S82114E', 'S82114F', 'S82114G', 'S82114H', 'S82114J', 'S82114K', 'S82114M',
        'S82114N', 'S82114P', 'S82114Q', 'S82114R', 'S82114S', 'S82115A', 'S82115B', 'S82115C',
        'S82115D', 'S82115E', 'S82115F', 'S82115G', 'S82115H', 'S82115J', 'S82115K', 'S82115M',
        'S82115N', 'S82115P', 'S82115Q', 'S82115R', 'S82115S', 'S82116A', 'S82116B', 'S82116C',
        'S82116D', 'S82116E', 'S82116F', 'S82116G', 'S82116H', 'S82116J', 'S82116K', 'S82116M',
        'S82116N', 'S82116P', 'S82116Q', 'S82116R', 'S82116S', 'S82121A', 'S82121B', 'S82121C',
        'S82121D', 'S82121E', 'S82121F', 'S82121G', 'S82121H', 'S82121J', 'S82121K', 'S82121M',
        'S82121N', 'S82121P', 'S82121Q', 'S82121R', 'S82121S', 'S82122A', 'S82122B', 'S82122C',
        'S82122D', 'S82122E', 'S82122F', 'S82122G', 'S82122H', 'S82122J', 'S82122K', 'S82122M',
        'S82122N', 'S82122P', 'S82122Q', 'S82122R', 'S82122S', 'S82123A', 'S82123B', 'S82123C',
        'S82123D', 'S82123E', 'S82123F', 'S82123G', 'S82123H', 'S82123J', 'S82123K', 'S82123M',
        'S82123N', 'S82123P', 'S82123Q', 'S82123R', 'S82123S', 'S82124A', 'S82124B', 'S82124C',
        'S82124D', 'S82124E', 'S82124F', 'S82124G', 'S82124H', 'S82124J', 'S82124K', 'S82124M',
        'S82124N', 'S82124P', 'S82124Q', 'S82124R', 'S82124S', 'S82125A', 'S82125B', 'S82125C',
        'S82125D', 'S82125E', 'S82125F', 'S82125G', 'S82125H', 'S82125J', 'S82125K', 'S82125M',
        'S82125N', 'S82125P', 'S82125Q', 'S82125R', 'S82125S', 'S82126A', 'S82126B', 'S82126C',
        'S82126D', 'S82126E', 'S82126F', 'S82126G', 'S82126H', 'S82126J', 'S82126K', 'S82126M',
        'S82126N', 'S82126P', 'S82126Q', 'S82126R', 'S82126S', 'S82131A', 'S82131B', 'S82131C',
        'S82131D', 'S82131E', 'S82131F', 'S82131G', 'S82131H', 'S82131J', 'S82131K', 'S82131M',
        'S82131N', 'S82131P', 'S82131Q', 'S82131R', 'S82131S', 'S82132A', 'S82132B', 'S82132C',
        'S82132D', 'S82132E', 'S82132F', 'S82132G', 'S82132H', 'S82132J', 'S82132K', 'S82132M',
        'S82132N', 'S82132P', 'S82132Q', 'S82132R', 'S82132S', 'S82133A', 'S82133B', 'S82133C',
        'S82133D', 'S82133E', 'S82133F', 'S82133G', 'S82133H', 'S82133J', 'S82133K', 'S82133M',
        'S82133N', 'S82133P', 'S82133Q', 'S82133R', 'S82133S', 'S82134A', 'S82134B', 'S82134C',
        'S82134D', 'S82134E', 'S82134F', 'S82134G', 'S82134H', 'S82134J', 'S82134K', 'S82134M',
        'S82134N', 'S82134P', 'S82134Q', 'S82134R', 'S82134S', 'S82135A', 'S82135B', 'S82135C',
        'S82135D', 'S82135E', 'S82135F', 'S82135G', 'S82135H', 'S82135J', 'S82135K', 'S82135M',
        'S82135N', 'S82135P', 'S82135Q', 'S82135R', 'S82135S', 'S82136A', 'S82136B', 'S82136C',
        'S82136D', 'S82136E', 'S82136F', 'S82136G', 'S82136H', 'S82136J', 'S82136K', 'S82136M',
        'S82136N', 'S82136P', 'S82136Q', 'S82136R', 'S82136S', 'S82141A', 'S82141B', 'S82141C',
        'S82141D', 'S82141E', 'S82141F', 'S82141G', 'S82141H', 'S82141J', 'S82141K', 'S82141M',
        'S82141N', 'S82141P', 'S82141Q', 'S82141R', 'S82141S', 'S82142A', 'S82142B', 'S82142C',
        'S82142D', 'S82142E', 'S82142F', 'S82142G', 'S82142H', 'S82142J', 'S82142K', 'S82142M',
        'S82142N', 'S82142P', 'S82142Q', 'S82142R', 'S82142S', 'S82143A', 'S82143B', 'S82143C',
        'S82143D', 'S82143E', 'S82143F', 'S82143G', 'S82143H', 'S82143J', 'S82143K', 'S82143M',
        'S82143N', 'S82143P', 'S82143Q', 'S82143R', 'S82143S', 'S82144A', 'S82144B', 'S82144C',
        'S82144D', 'S82144E', 'S82144F', 'S82144G', 'S82144H', 'S82144J', 'S82144K', 'S82144M',
        'S82144N', 'S82144P', 'S82144Q', 'S82144R', 'S82144S', 'S82145A', 'S82145B', 'S82145C',
        'S82145D', 'S82145E', 'S82145F', 'S82145G', 'S82145H', 'S82145J', 'S82145K', 'S82145M',
        'S82145N', 'S82145P', 'S82145Q', 'S82145R', 'S82145S', 'S82146A', 'S82146B', 'S82146C',
        'S82146D', 'S82146E', 'S82146F', 'S82146G', 'S82146H', 'S82146J', 'S82146K', 'S82146M',
        'S82146N', 'S82146P', 'S82146Q', 'S82146R', 'S82146S', 'S82151A', 'S82151B', 'S82151C',
        'S82151D', 'S82151E', 'S82151F', 'S82151G', 'S82151H', 'S82151J', 'S82151K', 'S82151M',
        'S82151N', 'S82151P', 'S82151Q', 'S82151R', 'S82151S', 'S82152A', 'S82152B', 'S82152C',
        'S82152D', 'S82152E', 'S82152F', 'S82152G', 'S82152H', 'S82152J', 'S82152K', 'S82152M',
        'S82152N', 'S82152P', 'S82152Q', 'S82152R', 'S82152S', 'S82153A', 'S82153B', 'S82153C',
        'S82153D', 'S82153E', 'S82153F', 'S82153G', 'S82153H', 'S82153J', 'S82153K', 'S82153M',
        'S82153N', 'S82153P', 'S82153Q', 'S82153R', 'S82153S', 'S82154A', 'S82154B', 'S82154C',
        'S82154D', 'S82154E', 'S82154F', 'S82154G', 'S82154H', 'S82154J', 'S82154K', 'S82154M',
        'S82154N', 'S82154P', 'S82154Q', 'S82154R', 'S82154S', 'S82155A', 'S82155B', 'S82155C',
        'S82155D', 'S82155E', 'S82155F', 'S82155G', 'S82155H', 'S82155J', 'S82155K', 'S82155M',
        'S82155N', 'S82155P', 'S82155Q', 'S82155R', 'S82155S', 'S82156A', 'S82156B', 'S82156C',
        'S82156D', 'S82156E', 'S82156F', 'S82156G', 'S82156H', 'S82156J', 'S82156K', 'S82156M',
        'S82156N', 'S82156P', 'S82156Q', 'S82156R', 'S82156S', 'S82161A', 'S82161D', 'S82161G',
        'S82161K', 'S82161P', 'S82161S', 'S82162A', 'S82162D', 'S82162G', 'S82162K', 'S82162P',
        'S82162S', 'S82169A', 'S82169D', 'S82169G', 'S82169K', 'S82169P', 'S82169S', 'S82191A',
        'S82191B', 'S82191C', 'S82191D', 'S82191E', 'S82191F', 'S82191G', 'S82191H', 'S82191J',
        'S82191K', 'S82191M', 'S82191N', 'S82191P', 'S82191Q', 'S82191R', 'S82191S', 'S82192A',
        'S82192B', 'S82192C', 'S82192D', 'S82192E', 'S82192F', 'S82192G', 'S82192H', 'S82192J',
        'S82192K', 'S82192M', 'S82192N', 'S82192P', 'S82192Q', 'S82192R', 'S82192S', 'S82199A',
        'S82199B', 'S82199C', 'S82199D', 'S82199E', 'S82199F', 'S82199G', 'S82199H', 'S82199J',
        'S82199K', 'S82199M', 'S82199N', 'S82199P', 'S82199Q', 'S82199R', 'S82199S', 'S82201A',
        'S82201B', 'S82201C', 'S82201D', 'S82201E', 'S82201F', 'S82201G', 'S82201H', 'S82201J',
        'S82201K', 'S82201M', 'S82201N', 'S82201P', 'S82201Q', 'S82201R', 'S82201S', 'S82202A',
        'S82202B', 'S82202C', 'S82202D', 'S82202E', 'S82202F', 'S82202G', 'S82202H', 'S82202J',
        'S82202K', 'S82202M', 'S82202N', 'S82202P', 'S82202Q', 'S82202R', 'S82202S', 'S82209A',
        'S82209B', 'S82209C', 'S82209D', 'S82209E', 'S82209F', 'S82209G', 'S82209H', 'S82209J',
        'S82209K', 'S82209M', 'S82209N', 'S82209P', 'S82209Q', 'S82209R', 'S82209S', 'S82221A',
        'S82221B', 'S82221C', 'S82221D', 'S82221E', 'S82221F', 'S82221G', 'S82221H', 'S82221J',
        'S82221K', 'S82221M', 'S82221N', 'S82221P', 'S82221Q', 'S82221R', 'S82221S', 'S82222A',
        'S82222B', 'S82222C', 'S82222D', 'S82222E', 'S82222F', 'S82222G', 'S82222H', 'S82222J',
        'S82222K', 'S82222M', 'S82222N', 'S82222P', 'S82222Q', 'S82222R', 'S82222S', 'S82223A',
        'S82223B', 'S82223C', 'S82223D', 'S82223E', 'S82223F', 'S82223G', 'S82223H', 'S82223J',
        'S82223K', 'S82223M', 'S82223N', 'S82223P', 'S82223Q', 'S82223R', 'S82223S', 'S82224A',
        'S82224B', 'S82224C', 'S82224D', 'S82224E', 'S82224F', 'S82224G', 'S82224H', 'S82224J',
        'S82224K', 'S82224M', 'S82224N', 'S82224P', 'S82224Q', 'S82224R', 'S82224S', 'S82225A',
        'S82225B', 'S82225C', 'S82225D', 'S82225E', 'S82225F', 'S82225G', 'S82225H', 'S82225J',
        'S82225K', 'S82225M', 'S82225N', 'S82225P', 'S82225Q', 'S82225R', 'S82225S', 'S82226A',
        'S82226B', 'S82226C', 'S82226D', 'S82226E', 'S82226F', 'S82226G', 'S82226H', 'S82226J',
        'S82226K', 'S82226M', 'S82226N', 'S82226P', 'S82226Q', 'S82226R', 'S82226S', 'S82231A',
        'S82231B', 'S82231C', 'S82231D', 'S82231E', 'S82231F', 'S82231G', 'S82231H', 'S82231J',
        'S82231K', 'S82231M', 'S82231N', 'S82231P', 'S82231Q', 'S82231R', 'S82231S', 'S82232A',
        'S82232B', 'S82232C', 'S82232D', 'S82232E', 'S82232F', 'S82232G', 'S82232H', 'S82232J',
        'S82232K', 'S82232M', 'S82232N', 'S82232P', 'S82232Q', 'S82232R', 'S82232S', 'S82233A',
        'S82233B', 'S82233C', 'S82233D', 'S82233E', 'S82233F', 'S82233G', 'S82233H', 'S82233J',
        'S82233K', 'S82233M', 'S82233N', 'S82233P', 'S82233Q', 'S82233R', 'S82233S', 'S82234A',
        'S82234B', 'S82234C', 'S82234D', 'S82234E', 'S82234F', 'S82234G', 'S82234H', 'S82234J',
        'S82234K', 'S82234M', 'S82234N', 'S82234P', 'S82234Q', 'S82234R', 'S82234S', 'S82235A',
        'S82235B', 'S82235C', 'S82235D', 'S82235E', 'S82235F', 'S82235G', 'S82235H', 'S82235J',
        'S82235K', 'S82235M', 'S82235N', 'S82235P', 'S82235Q', 'S82235R', 'S82235S', 'S82236A',
        'S82236B', 'S82236C', 'S82236D', 'S82236E', 'S82236F', 'S82236G', 'S82236H', 'S82236J',
        'S82236K', 'S82236M', 'S82236N', 'S82236P', 'S82236Q', 'S82236R', 'S82236S', 'S82241A',
        'S82241B', 'S82241C', 'S82241D', 'S82241E', 'S82241F', 'S82241G', 'S82241H', 'S82241J',
        'S82241K', 'S82241M', 'S82241N', 'S82241P', 'S82241Q', 'S82241R', 'S82241S', 'S82242A',
        'S82242B', 'S82242C', 'S82242D', 'S82242E', 'S82242F', 'S82242G', 'S82242H', 'S82242J',
        'S82242K', 'S82242M', 'S82242N', 'S82242P', 'S82242Q', 'S82242R', 'S82242S', 'S82243A',
        'S82243B', 'S82243C', 'S82243D', 'S82243E', 'S82243F', 'S82243G', 'S82243H', 'S82243J',
        'S82243K', 'S82243M', 'S82243N', 'S82243P', 'S82243Q', 'S82243R', 'S82243S', 'S82244A',
        'S82244B', 'S82244C', 'S82244D', 'S82244E', 'S82244F', 'S82244G', 'S82244H', 'S82244J',
        'S82244K', 'S82244M', 'S82244N', 'S82244P', 'S82244Q', 'S82244R', 'S82244S', 'S82245A',
        'S82245B', 'S82245C', 'S82245D', 'S82245E', 'S82245F', 'S82245G', 'S82245H', 'S82245J',
        'S82245K', 'S82245M', 'S82245N', 'S82245P', 'S82245Q', 'S82245R', 'S82245S', 'S82246A',
        'S82246B', 'S82246C', 'S82246D', 'S82246E', 'S82246F', 'S82246G', 'S82246H', 'S82246J',
        'S82246K', 'S82246M', 'S82246N', 'S82246P', 'S82246Q', 'S82246R', 'S82246S', 'S82251A',
        'S82251B', 'S82251C', 'S82251D', 'S82251E', 'S82251F', 'S82251G', 'S82251H', 'S82251J',
        'S82251K', 'S82251M', 'S82251N', 'S82251P', 'S82251Q', 'S82251R', 'S82251S', 'S82252A',
        'S82252B', 'S82252C', 'S82252D', 'S82252E', 'S82252F', 'S82252G', 'S82252H', 'S82252J',
        'S82252K', 'S82252M', 'S82252N', 'S82252P', 'S82252Q', 'S82252R', 'S82252S', 'S82253A',
        'S82253B', 'S82253C', 'S82253D', 'S82253E', 'S82253F', 'S82253G', 'S82253H', 'S82253J',
        'S82253K', 'S82253M', 'S82253N', 'S82253P', 'S82253Q', 'S82253R', 'S82253S', 'S82254A',
        'S82254B', 'S82254C', 'S82254D', 'S82254E', 'S82254F', 'S82254G', 'S82254H', 'S82254J',
        'S82254K', 'S82254M', 'S82254N', 'S82254P', 'S82254Q', 'S82254R', 'S82254S', 'S82255A',
        'S82255B', 'S82255C', 'S82255D', 'S82255E', 'S82255F', 'S82255G', 'S82255H', 'S82255J',
        'S82255K', 'S82255M', 'S82255N', 'S82255P', 'S82255Q', 'S82255R', 'S82255S', 'S82256A',
        'S82256B', 'S82256C', 'S82256D', 'S82256E', 'S82256F', 'S82256G', 'S82256H', 'S82256J',
        'S82256K', 'S82256M', 'S82256N', 'S82256P', 'S82256Q', 'S82256R', 'S82256S', 'S82261A',
        'S82261B', 'S82261C', 'S82261D', 'S82261E', 'S82261F', 'S82261G', 'S82261H', 'S82261J',
        'S82261K', 'S82261M', 'S82261N', 'S82261P', 'S82261Q', 'S82261R', 'S82261S', 'S82262A',
        'S82262B', 'S82262C', 'S82262D', 'S82262E', 'S82262F', 'S82262G', 'S82262H', 'S82262J',
        'S82262K', 'S82262M', 'S82262N', 'S82262P', 'S82262Q', 'S82262R', 'S82262S', 'S82263A',
        'S82263B', 'S82263C', 'S82263D', 'S82263E', 'S82263F', 'S82263G', 'S82263H', 'S82263J',
        'S82263K', 'S82263M', 'S82263N', 'S82263P', 'S82263Q', 'S82263R', 'S82263S', 'S82264A',
        'S82264B', 'S82264C', 'S82264D', 'S82264E', 'S82264F', 'S82264G', 'S82264H', 'S82264J',
        'S82264K', 'S82264M', 'S82264N', 'S82264P', 'S82264Q', 'S82264R', 'S82264S', 'S82265A',
        'S82265B', 'S82265C', 'S82265D', 'S82265E', 'S82265F', 'S82265G', 'S82265H', 'S82265J',
        'S82265K', 'S82265M', 'S82265N', 'S82265P', 'S82265Q', 'S82265R', 'S82265S', 'S82266A',
        'S82266B', 'S82266C', 'S82266D', 'S82266E', 'S82266F', 'S82266G', 'S82266H', 'S82266J',
        'S82266K', 'S82266M', 'S82266N', 'S82266P', 'S82266Q', 'S82266R', 'S82266S', 'S82291A',
        'S82291B', 'S82291C', 'S82291D', 'S82291E', 'S82291F', 'S82291G', 'S82291H', 'S82291J',
        'S82291K', 'S82291M', 'S82291N', 'S82291P', 'S82291Q', 'S82291R', 'S82291S', 'S82292A',
        'S82292B', 'S82292C', 'S82292D', 'S82292E', 'S82292F', 'S82292G', 'S82292H', 'S82292J',
        'S82292K', 'S82292M', 'S82292N', 'S82292P', 'S82292Q', 'S82292R', 'S82292S', 'S82299A',
        'S82299B', 'S82299C', 'S82299D', 'S82299E', 'S82299F', 'S82299G', 'S82299H', 'S82299J',
        'S82299K', 'S82299M', 'S82299N', 'S82299P', 'S82299Q', 'S82299R', 'S82299S', 'S82301A',
        'S82301B', 'S82301C', 'S82301D', 'S82301E', 'S82301F', 'S82301G', 'S82301H', 'S82301J',
        'S82301K', 'S82301M', 'S82301N', 'S82301P', 'S82301Q', 'S82301R', 'S82301S', 'S82302A',
        'S82302B', 'S82302C', 'S82302D', 'S82302E', 'S82302F', 'S82302G', 'S82302H', 'S82302J',
        'S82302K', 'S82302M', 'S82302N', 'S82302P', 'S82302Q', 'S82302R', 'S82302S', 'S82309A',
        'S82309B', 'S82309C', 'S82309D', 'S82309E', 'S82309F', 'S82309G', 'S82309H', 'S82309J',
        'S82309K', 'S82309M', 'S82309N', 'S82309P', 'S82309Q', 'S82309R', 'S82309S', 'S82311A',
        'S82311D', 'S82311G', 'S82311K', 'S82311P', 'S82311S', 'S82312A', 'S82312D', 'S82312G',
        'S82312K', 'S82312P', 'S82312S', 'S82319A', 'S82319D', 'S82319G', 'S82319K', 'S82319P',
        'S82319S', 'S82391A', 'S82391B', 'S82391C', 'S82391D', 'S82391E', 'S82391F', 'S82391G',
        'S82391H', 'S82391J', 'S82391K', 'S82391M', 'S82391N', 'S82391P', 'S82391Q', 'S82391R',
        'S82391S', 'S82392A', 'S82392B', 'S82392C', 'S82392D', 'S82392E', 'S82392F', 'S82392G',
        'S82392H', 'S82392J', 'S82392K', 'S82392M', 'S82392N', 'S82392P', 'S82392Q', 'S82392R',
        'S82392S', 'S82399A', 'S82399B', 'S82399C', 'S82399D', 'S82399E', 'S82399F', 'S82399G',
        'S82399H', 'S82399J', 'S82399K', 'S82399M', 'S82399N', 'S82399P', 'S82399Q', 'S82399R',
        'S82399S', 'S82401A', 'S82401B', 'S82401C', 'S82401D', 'S82401E', 'S82401F', 'S82401G',
        'S82401H', 'S82401J', 'S82401K', 'S82401M', 'S82401N', 'S82401P', 'S82401Q', 'S82401R',
        'S82401S', 'S82402A', 'S82402B', 'S82402C', 'S82402D', 'S82402E', 'S82402F', 'S82402G',
        'S82402H', 'S82402J', 'S82402K', 'S82402M', 'S82402N', 'S82402P', 'S82402Q', 'S82402R',
        'S82402S', 'S82409A', 'S82409B', 'S82409C', 'S82409D', 'S82409E', 'S82409F', 'S82409G',
        'S82409H', 'S82409J', 'S82409K', 'S82409M', 'S82409N', 'S82409P', 'S82409Q', 'S82409R',
        'S82409S', 'S82421A', 'S82421B', 'S82421C', 'S82421D', 'S82421E', 'S82421F', 'S82421G',
        'S82421H', 'S82421J', 'S82421K', 'S82421M', 'S82421N', 'S82421P', 'S82421Q', 'S82421R',
        'S82421S', 'S82422A', 'S82422B', 'S82422C', 'S82422D', 'S82422E', 'S82422F', 'S82422G',
        'S82422H', 'S82422J', 'S82422K', 'S82422M', 'S82422N', 'S82422P', 'S82422Q', 'S82422R',
        'S82422S', 'S82423A', 'S82423B', 'S82423C', 'S82423D', 'S82423E', 'S82423F', 'S82423G',
        'S82423H', 'S82423J', 'S82423K', 'S82423M', 'S82423N', 'S82423P', 'S82423Q', 'S82423R',
        'S82423S', 'S82424A', 'S82424B', 'S82424C', 'S82424D', 'S82424E', 'S82424F', 'S82424G',
        'S82424H', 'S82424J', 'S82424K', 'S82424M', 'S82424N', 'S82424P', 'S82424Q', 'S82424R',
        'S82424S', 'S82425A', 'S82425B', 'S82425C', 'S82425D', 'S82425E', 'S82425F', 'S82425G',
        'S82425H', 'S82425J', 'S82425K', 'S82425M', 'S82425N', 'S82425P', 'S82425Q', 'S82425R',
        'S82425S', 'S82426A', 'S82426B', 'S82426C', 'S82426D', 'S82426E', 'S82426F', 'S82426G',
        'S82426H', 'S82426J', 'S82426K', 'S82426M', 'S82426N', 'S82426P', 'S82426Q', 'S82426R',
        'S82426S', 'S82431A', 'S82431B', 'S82431C', 'S82431D', 'S82431E', 'S82431F', 'S82431G',
        'S82431H', 'S82431J', 'S82431K', 'S82431M', 'S82431N', 'S82431P', 'S82431Q', 'S82431R',
        'S82431S', 'S82432A', 'S82432B', 'S82432C', 'S82432D', 'S82432E', 'S82432F', 'S82432G',
        'S82432H', 'S82432J', 'S82432K', 'S82432M', 'S82432N', 'S82432P', 'S82432Q', 'S82432R',
        'S82432S', 'S82433A', 'S82433B', 'S82433C', 'S82433D', 'S82433E', 'S82433F', 'S82433G',
        'S82433H', 'S82433J', 'S82433K', 'S82433M', 'S82433N', 'S82433P', 'S82433Q', 'S82433R',
        'S82433S', 'S82434A', 'S82434B', 'S82434C', 'S82434D', 'S82434E', 'S82434F', 'S82434G',
        'S82434H', 'S82434J', 'S82434K', 'S82434M', 'S82434N', 'S82434P', 'S82434Q', 'S82434R',
        'S82434S', 'S82435A', 'S82435B', 'S82435C', 'S82435D', 'S82435E', 'S82435F', 'S82435G',
        'S82435H', 'S82435J', 'S82435K', 'S82435M', 'S82435N', 'S82435P', 'S82435Q', 'S82435R',
        'S82435S', 'S82436A', 'S82436B', 'S82436C', 'S82436D', 'S82436E', 'S82436F', 'S82436G',
        'S82436H', 'S82436J', 'S82436K', 'S82436M', 'S82436N', 'S82436P', 'S82436Q', 'S82436R',
        'S82436S', 'S82441A', 'S82441B', 'S82441C', 'S82441D', 'S82441E', 'S82441F', 'S82441G',
        'S82441H', 'S82441J', 'S82441K', 'S82441M', 'S82441N', 'S82441P', 'S82441Q', 'S82441R',
        'S82441S', 'S82442A', 'S82442B', 'S82442C', 'S82442D', 'S82442E', 'S82442F', 'S82442G',
        'S82442H', 'S82442J', 'S82442K', 'S82442M', 'S82442N', 'S82442P', 'S82442Q', 'S82442R',
        'S82442S', 'S82443A', 'S82443B', 'S82443C', 'S82443D', 'S82443E', 'S82443F', 'S82443G',
        'S82443H', 'S82443J', 'S82443K', 'S82443M', 'S82443N', 'S82443P', 'S82443Q', 'S82443R',
        'S82443S', 'S82444A', 'S82444B', 'S82444C', 'S82444D', 'S82444E', 'S82444F', 'S82444G',
        'S82444H', 'S82444J', 'S82444K', 'S82444M', 'S82444N', 'S82444P', 'S82444Q', 'S82444R',
        'S82444S', 'S82445A', 'S82445B', 'S82445C', 'S82445D', 'S82445E', 'S82445F', 'S82445G',
        'S82445H', 'S82445J', 'S82445K', 'S82445M', 'S82445N', 'S82445P', 'S82445Q', 'S82445R',
        'S82445S', 'S82446A', 'S82446B', 'S82446C', 'S82446D', 'S82446E', 'S82446F', 'S82446G',
        'S82446H', 'S82446J', 'S82446K', 'S82446M', 'S82446N', 'S82446P', 'S82446Q', 'S82446R',
        'S82446S', 'S82451A', 'S82451B', 'S82451C', 'S82451D', 'S82451E', 'S82451F', 'S82451G',
        'S82451H', 'S82451J', 'S82451K', 'S82451M', 'S82451N', 'S82451P', 'S82451Q', 'S82451R',
        'S82451S', 'S82452A', 'S82452B', 'S82452C', 'S82452D', 'S82452E', 'S82452F', 'S82452G',
        'S82452H', 'S82452J', 'S82452K', 'S82452M', 'S82452N', 'S82452P', 'S82452Q', 'S82452R',
        'S82452S', 'S82453A', 'S82453B', 'S82453C', 'S82453D', 'S82453E', 'S82453F', 'S82453G',
        'S82453H', 'S82453J', 'S82453K', 'S82453M', 'S82453N', 'S82453P', 'S82453Q', 'S82453R',
        'S82453S', 'S82454A', 'S82454B', 'S82454C', 'S82454D', 'S82454E', 'S82454F', 'S82454G',
        'S82454H', 'S82454J', 'S82454K', 'S82454M', 'S82454N', 'S82454P', 'S82454Q', 'S82454R',
        'S82454S', 'S82455A', 'S82455B', 'S82455C', 'S82455D', 'S82455E', 'S82455F', 'S82455G',
        'S82455H', 'S82455J', 'S82455K', 'S82455M', 'S82455N', 'S82455P', 'S82455Q', 'S82455R',
        'S82455S', 'S82456A', 'S82456B', 'S82456C', 'S82456D', 'S82456E', 'S82456F', 'S82456G',
        'S82456H', 'S82456J', 'S82456K', 'S82456M', 'S82456N', 'S82456P', 'S82456Q', 'S82456R',
        'S82456S', 'S82461A', 'S82461B', 'S82461C', 'S82461D', 'S82461E', 'S82461F', 'S82461G',
        'S82461H', 'S82461J', 'S82461K', 'S82461M', 'S82461N', 'S82461P', 'S82461Q', 'S82461R',
        'S82461S', 'S82462A', 'S82462B', 'S82462C', 'S82462D', 'S82462E', 'S82462F', 'S82462G',
        'S82462H', 'S82462J', 'S82462K', 'S82462M', 'S82462N', 'S82462P', 'S82462Q', 'S82462R',
        'S82462S', 'S82463A', 'S82463B', 'S82463C', 'S82463D', 'S82463E', 'S82463F', 'S82463G',
        'S82463H', 'S82463J', 'S82463K', 'S82463M', 'S82463N', 'S82463P', 'S82463Q', 'S82463R',
        'S82463S', 'S82464A', 'S82464B', 'S82464C', 'S82464D', 'S82464E', 'S82464F', 'S82464G',
        'S82464H', 'S82464J', 'S82464K', 'S82464M', 'S82464N', 'S82464P', 'S82464Q', 'S82464R',
        'S82464S', 'S82465A', 'S82465B', 'S82465C', 'S82465D', 'S82465E', 'S82465F', 'S82465G',
        'S82465H', 'S82465J', 'S82465K', 'S82465M', 'S82465N', 'S82465P', 'S82465Q', 'S82465R',
        'S82465S', 'S82466A', 'S82466B', 'S82466C', 'S82466D', 'S82466E', 'S82466F', 'S82466G',
        'S82466H', 'S82466J', 'S82466K', 'S82466M', 'S82466N', 'S82466P', 'S82466Q', 'S82466R',
        'S82466S', 'S82491A', 'S82491B', 'S82491C', 'S82491D', 'S82491E', 'S82491F', 'S82491G',
        'S82491H', 'S82491J', 'S82491K', 'S82491M', 'S82491N', 'S82491P', 'S82491Q', 'S82491R',
        'S82491S', 'S82492A', 'S82492B', 'S82492C', 'S82492D', 'S82492E', 'S82492F', 'S82492G',
        'S82492H', 'S82492J', 'S82492K', 'S82492M', 'S82492N', 'S82492P', 'S82492Q', 'S82492R',
        'S82492S', 'S82499A', 'S82499B', 'S82499C', 'S82499D', 'S82499E', 'S82499F', 'S82499G',
        'S82499H', 'S82499J', 'S82499K', 'S82499M', 'S82499N', 'S82499P', 'S82499Q', 'S82499R',
        'S82499S', 'S8251XA', 'S8251XB', 'S8251XC', 'S8251XD', 'S8251XE', 'S8251XF', 'S8251XG',
        'S8251XH', 'S8251XJ', 'S8251XK', 'S8251XM', 'S8251XN', 'S8251XP', 'S8251XQ', 'S8251XR',
        'S8251XS', 'S8252XA', 'S8252XB', 'S8252XC', 'S8252XD', 'S8252XE', 'S8252XF', 'S8252XG',
        'S8252XH', 'S8252XJ', 'S8252XK', 'S8252XM', 'S8252XN', 'S8252XP', 'S8252XQ', 'S8252XR',
        'S8252XS', 'S8253XA', 'S8253XB', 'S8253XC', 'S8253XD', 'S8253XE', 'S8253XF', 'S8253XG',
        'S8253XH', 'S8253XJ', 'S8253XK', 'S8253XM', 'S8253XN', 'S8253XP', 'S8253XQ', 'S8253XR',
        'S8253XS', 'S8254XA', 'S8254XB', 'S8254XC', 'S8254XD', 'S8254XE', 'S8254XF', 'S8254XG',
        'S8254XH', 'S8254XJ', 'S8254XK', 'S8254XM', 'S8254XN', 'S8254XP', 'S8254XQ', 'S8254XR',
        'S8254XS', 'S8255XA', 'S8255XB', 'S8255XC', 'S8255XD', 'S8255XE', 'S8255XF', 'S8255XG',
        'S8255XH', 'S8255XJ', 'S8255XK', 'S8255XM', 'S8255XN', 'S8255XP', 'S8255XQ', 'S8255XR',
        'S8255XS', 'S8256XA', 'S8256XB', 'S8256XC', 'S8256XD', 'S8256XE', 'S8256XF', 'S8256XG',
        'S8256XH', 'S8256XJ', 'S8256XK', 'S8256XM', 'S8256XN', 'S8256XP', 'S8256XQ', 'S8256XR',
        'S8256XS', 'S8261XA', 'S8261XB', 'S8261XC', 'S8261XD', 'S8261XE', 'S8261XF', 'S8261XG',
        'S8261XH', 'S8261XJ', 'S8261XK', 'S8261XM', 'S8261XN', 'S8261XP', 'S8261XQ', 'S8261XR',
        'S8261XS', 'S8262XA', 'S8262XB', 'S8262XC', 'S8262XD', 'S8262XE', 'S8262XF', 'S8262XG',
        'S8262XH', 'S8262XJ', 'S8262XK', 'S8262XM', 'S8262XN', 'S8262XP', 'S8262XQ', 'S8262XR',
        'S8262XS', 'S8263XA', 'S8263XB', 'S8263XC', 'S8263XD', 'S8263XE', 'S8263XF', 'S8263XG',
        'S8263XH', 'S8263XJ', 'S8263XK', 'S8263XM', 'S8263XN', 'S8263XP', 'S8263XQ', 'S8263XR',
        'S8263XS', 'S8264XA', 'S8264XB', 'S8264XC', 'S8264XD', 'S8264XE', 'S8264XF', 'S8264XG',
        'S8264XH', 'S8264XJ', 'S8264XK', 'S8264XM', 'S8264XN', 'S8264XP', 'S8264XQ', 'S8264XR',
        'S8264XS', 'S8265XA', 'S8265XB', 'S8265XC', 'S8265XD', 'S8265XE', 'S8265XF', 'S8265XG',
        'S8265XH', 'S8265XJ', 'S8265XK', 'S8265XM', 'S8265XN', 'S8265XP', 'S8265XQ', 'S8265XR',
        'S8265XS', 'S8266XA', 'S8266XB', 'S8266XC', 'S8266XD', 'S8266XE', 'S8266XF', 'S8266XG',
        'S8266XH', 'S8266XJ', 'S8266XK', 'S8266XM', 'S8266XN', 'S8266XP', 'S8266XQ', 'S8266XR',
        'S8266XS', 'S82811A', 'S82811D', 'S82811G', 'S82811K', 'S82811P', 'S82811S', 'S82812A',
        'S82812D', 'S82812G', 'S82812K', 'S82812P', 'S82812S', 'S82819A', 'S82819D', 'S82819G',
        'S82819K', 'S82819P', 'S82819S', 'S82821A', 'S82821D', 'S82821G', 'S82821K', 'S82821P',
        'S82821S', 'S82822A', 'S82822D', 'S82822G', 'S82822K', 'S82822P', 'S82822S', 'S82829A',
        'S82829D', 'S82829G', 'S82829K', 'S82829P', 'S82829S', 'S82831A', 'S82831B', 'S82831C',
        'S82831D', 'S82831E', 'S82831F', 'S82831G', 'S82831H', 'S82831J', 'S82831K', 'S82831M',
        'S82831N', 'S82831P', 'S82831Q', 'S82831R', 'S82831S', 'S82832A', 'S82832B', 'S82832C',
        'S82832D', 'S82832E', 'S82832F', 'S82832G', 'S82832H', 'S82832J', 'S82832K', 'S82832M',
        'S82832N', 'S82832P', 'S82832Q', 'S82832R', 'S82832S', 'S82839A', 'S82839B', 'S82839C',
        'S82839D', 'S82839E', 'S82839F', 'S82839G', 'S82839H', 'S82839J', 'S82839K', 'S82839M',
        'S82839N', 'S82839P', 'S82839Q', 'S82839R', 'S82839S', 'S82841A', 'S82841B', 'S82841C',
        'S82841D', 'S82841E', 'S82841F', 'S82841G', 'S82841H', 'S82841J', 'S82841K', 'S82841M',
        'S82841N', 'S82841P', 'S82841Q', 'S82841R', 'S82841S', 'S82842A', 'S82842B', 'S82842C',
        'S82842D', 'S82842E', 'S82842F', 'S82842G', 'S82842H', 'S82842J', 'S82842K', 'S82842M',
        'S82842N', 'S82842P', 'S82842Q', 'S82842R', 'S82842S', 'S82843A', 'S82843B', 'S82843C',
        'S82843D', 'S82843E', 'S82843F', 'S82843G', 'S82843H', 'S82843J', 'S82843K', 'S82843M',
        'S82843N', 'S82843P', 'S82843Q', 'S82843R', 'S82843S', 'S82844A', 'S82844B', 'S82844C',
        'S82844D', 'S82844E', 'S82844F', 'S82844G', 'S82844H', 'S82844J', 'S82844K', 'S82844M',
        'S82844N', 'S82844P', 'S82844Q', 'S82844R', 'S82844S', 'S82845A', 'S82845B', 'S82845C',
        'S82845D', 'S82845E', 'S82845F', 'S82845G', 'S82845H', 'S82845J', 'S82845K', 'S82845M',
        'S82845N', 'S82845P', 'S82845Q', 'S82845R', 'S82845S', 'S82846A', 'S82846B', 'S82846C',
        'S82846D', 'S82846E', 'S82846F', 'S82846G', 'S82846H', 'S82846J', 'S82846K', 'S82846M',
        'S82846N', 'S82846P', 'S82846Q', 'S82846R', 'S82846S', 'S82851A', 'S82851B', 'S82851C',
        'S82851D', 'S82851E', 'S82851F', 'S82851G', 'S82851H', 'S82851J', 'S82851K', 'S82851M',
        'S82851N', 'S82851P', 'S82851Q', 'S82851R', 'S82851S', 'S82852A', 'S82852B', 'S82852C',
        'S82852D', 'S82852E', 'S82852F', 'S82852G', 'S82852H', 'S82852J', 'S82852K', 'S82852M',
        'S82852N', 'S82852P', 'S82852Q', 'S82852R', 'S82852S', 'S82853A', 'S82853B', 'S82853C',
        'S82853D', 'S82853E', 'S82853F', 'S82853G', 'S82853H', 'S82853J', 'S82853K', 'S82853M',
        'S82853N', 'S82853P', 'S82853Q', 'S82853R', 'S82853S', 'S82854A', 'S82854B', 'S82854C',
        'S82854D', 'S82854E', 'S82854F', 'S82854G', 'S82854H', 'S82854J', 'S82854K', 'S82854M',
        'S82854N', 'S82854P', 'S82854Q', 'S82854R', 'S82854S', 'S82855A', 'S82855B', 'S82855C',
        'S82855D', 'S82855E', 'S82855F', 'S82855G', 'S82855H', 'S82855J', 'S82855K', 'S82855M',
        'S82855N', 'S82855P', 'S82855Q', 'S82855R', 'S82855S', 'S82856A', 'S82856B', 'S82856C',
        'S82856D', 'S82856E', 'S82856F', 'S82856G', 'S82856H', 'S82856J', 'S82856K', 'S82856M',
        'S82856N', 'S82856P', 'S82856Q', 'S82856R', 'S82856S', 'S82861A', 'S82861B', 'S82861C',
        'S82861D', 'S82861E', 'S82861F', 'S82861G', 'S82861H', 'S82861J', 'S82861K', 'S82861M',
        'S82861N', 'S82861P', 'S82861Q', 'S82861R', 'S82861S', 'S82862A', 'S82862B', 'S82862C',
        'S82862D', 'S82862E', 'S82862F', 'S82862G', 'S82862H', 'S82862J', 'S82862K', 'S82862M',
        'S82862N', 'S82862P', 'S82862Q', 'S82862R', 'S82862S', 'S82863A', 'S82863B', 'S82863C',
        'S82863D', 'S82863E', 'S82863F', 'S82863G', 'S82863H', 'S82863J', 'S82863K', 'S82863M',
        'S82863N', 'S82863P', 'S82863Q', 'S82863R', 'S82863S', 'S82864A', 'S82864B', 'S82864C',
        'S82864D', 'S82864E', 'S82864F', 'S82864G', 'S82864H', 'S82864J', 'S82864K', 'S82864M',
        'S82864N', 'S82864P', 'S82864Q', 'S82864R', 'S82864S', 'S82865A', 'S82865B', 'S82865C',
        'S82865D', 'S82865E', 'S82865F', 'S82865G', 'S82865H', 'S82865J', 'S82865K', 'S82865M',
        'S82865N', 'S82865P', 'S82865Q', 'S82865R', 'S82865S', 'S82866A', 'S82866B', 'S82866C',
        'S82866D', 'S82866E', 'S82866F', 'S82866G', 'S82866H', 'S82866J', 'S82866K', 'S82866M',
        'S82866N', 'S82866P', 'S82866Q', 'S82866R', 'S82866S', 'S82871A', 'S82871B', 'S82871C',
        'S82871D', 'S82871E', 'S82871F', 'S82871G', 'S82871H', 'S82871J', 'S82871K', 'S82871M',
        'S82871N', 'S82871P', 'S82871Q', 'S82871R', 'S82871S', 'S82872A', 'S82872B', 'S82872C',
        'S82872D', 'S82872E', 'S82872F', 'S82872G', 'S82872H', 'S82872J', 'S82872K', 'S82872M',
        'S82872N', 'S82872P', 'S82872Q', 'S82872R', 'S82872S', 'S82873A', 'S82873B', 'S82873C',
        'S82873D', 'S82873E', 'S82873F', 'S82873G', 'S82873H', 'S82873J', 'S82873K', 'S82873M',
        'S82873N', 'S82873P', 'S82873Q', 'S82873R', 'S82873S', 'S82874A', 'S82874B', 'S82874C',
        'S82874D', 'S82874E', 'S82874F', 'S82874G', 'S82874H', 'S82874J', 'S82874K', 'S82874M',
        'S82874N', 'S82874P', 'S82874Q', 'S82874R', 'S82874S', 'S82875A', 'S82875B', 'S82875C',
        'S82875D', 'S82875E', 'S82875F', 'S82875G', 'S82875H', 'S82875J', 'S82875K', 'S82875M',
        'S82875N', 'S82875P', 'S82875Q', 'S82875R', 'S82875S', 'S82876A', 'S82876B', 'S82876C',
        'S82876D', 'S82876E', 'S82876F', 'S82876G', 'S82876H', 'S82876J', 'S82876K', 'S82876M',
        'S82876N', 'S82876P', 'S82876Q', 'S82876R', 'S82876S', 'S82891A', 'S82891B', 'S82891C',
        'S82891D', 'S82891E', 'S82891F', 'S82891G', 'S82891H', 'S82891J', 'S82891K', 'S82891M',
        'S82891N', 'S82891P', 'S82891Q', 'S82891R', 'S82891S', 'S82892A', 'S82892B', 'S82892C',
        'S82892D', 'S82892E', 'S82892F', 'S82892G', 'S82892H', 'S82892J', 'S82892K', 'S82892M',
        'S82892N', 'S82892P', 'S82892Q', 'S82892R', 'S82892S', 'S82899A', 'S82899B', 'S82899C',
        'S82899D', 'S82899E', 'S82899F', 'S82899G', 'S82899H', 'S82899J', 'S82899K', 'S82899M',
        'S82899N', 'S82899P', 'S82899Q', 'S82899R', 'S82899S', 'S8290XA', 'S8290XB', 'S8290XC',
        'S8290XD', 'S8290XE', 'S8290XF', 'S8290XG', 'S8290XH', 'S8290XJ', 'S8290XK', 'S8290XM',
        'S8290XN', 'S8290XP', 'S8290XQ', 'S8290XR', 'S8290XS', 'S8291XA', 'S8291XB', 'S8291XC',
        'S8291XD', 'S8291XE', 'S8291XF', 'S8291XG', 'S8291XH', 'S8291XJ', 'S8291XK', 'S8291XM',
        'S8291XN', 'S8291XP', 'S8291XQ', 'S8291XR', 'S8291XS', 'S8292XA', 'S8292XB', 'S8292XC',
        'S8292XD', 'S8292XE', 'S8292XF', 'S8292XG', 'S8292XH', 'S8292XJ', 'S8292XK', 'S8292XM',
        'S8292XN', 'S8292XP', 'S8292XQ', 'S8292XR', 'S8292XS', 'S83004A', 'S83004D', 'S83004S',
        'S83005A', 'S83005D', 'S83005S', 'S83006A', 'S83006D', 'S83006S', 'S83014A', 'S83014D',
        'S83014S', 'S83015A', 'S83015D', 'S83015S', 'S83016A', 'S83016D', 'S83016S', 'S83094A',
        'S83094D', 'S83094S', 'S83095A', 'S83095D', 'S83095S', 'S83096A', 'S83096D', 'S83096S',
        'S83104A', 'S83104D', 'S83104S', 'S83105A', 'S83105D', 'S83105S', 'S83106A', 'S83106D',
        'S83106S', 'S83114A', 'S83114D', 'S83114S', 'S83115A', 'S83115D', 'S83115S', 'S83116A',
        'S83116D', 'S83116S', 'S83124A', 'S83124D', 'S83124S', 'S83125A', 'S83125D', 'S83125S',
        'S83126A', 'S83126D', 'S83126S', 'S83134A', 'S83134D', 'S83134S', 'S83135A', 'S83135D',
        'S83135S', 'S83136A', 'S83136D', 'S83136S', 'S83144A', 'S83144D', 'S83144S', 'S83145A',
        'S83145D', 'S83145S', 'S83146A', 'S83146D', 'S83146S', 'S83194A', 'S83194D', 'S83194S',
        'S83195A', 'S83195D', 'S83195S', 'S83196A', 'S83196D', 'S83196S', 'S89001A', 'S89001D',
        'S89001G', 'S89001K', 'S89001P', 'S89001S', 'S89002A', 'S89002D', 'S89002G', 'S89002K',
        'S89002P', 'S89002S', 'S89009A', 'S89009D', 'S89009G', 'S89009K', 'S89009P', 'S89009S',
        'S89011A', 'S89011D', 'S89011G', 'S89011K', 'S89011P', 'S89011S', 'S89012A', 'S89012D',
        'S89012G', 'S89012K', 'S89012P', 'S89012S', 'S89019A', 'S89019D', 'S89019G', 'S89019K',
        'S89019P', 'S89019S', 'S89021A', 'S89021D', 'S89021G', 'S89021K', 'S89021P', 'S89021S',
        'S89022A', 'S89022D', 'S89022G', 'S89022K', 'S89022P', 'S89022S', 'S89029A', 'S89029D',
        'S89029G', 'S89029K', 'S89029P', 'S89029S', 'S89031A', 'S89031D', 'S89031G', 'S89031K',
        'S89031P', 'S89031S', 'S89032A', 'S89032D', 'S89032G', 'S89032K', 'S89032P', 'S89032S',
        'S89039A', 'S89039D', 'S89039G', 'S89039K', 'S89039P', 'S89039S', 'S89041A', 'S89041D',
        'S89041G', 'S89041K', 'S89041P', 'S89041S', 'S89042A', 'S89042D', 'S89042G', 'S89042K',
        'S89042P', 'S89042S', 'S89049A', 'S89049D', 'S89049G', 'S89049K', 'S89049P', 'S89049S',
        'S89091A', 'S89091D', 'S89091G', 'S89091K', 'S89091P', 'S89091S', 'S89092A', 'S89092D',
        'S89092G', 'S89092K', 'S89092P', 'S89092S', 'S89099A', 'S89099D', 'S89099G', 'S89099K',
        'S89099P', 'S89099S', 'S89101A', 'S89101D', 'S89101G', 'S89101K', 'S89101P', 'S89101S',
        'S89102A', 'S89102D', 'S89102G', 'S89102K', 'S89102P', 'S89102S', 'S89109A', 'S89109D',
        'S89109G', 'S89109K', 'S89109P', 'S89109S', 'S89111A', 'S89111D', 'S89111G', 'S89111K',
        'S89111P', 'S89111S', 'S89112A', 'S89112D', 'S89112G', 'S89112K', 'S89112P', 'S89112S',
        'S89119A', 'S89119D', 'S89119G', 'S89119K', 'S89119P', 'S89119S', 'S89121A', 'S89121D',
        'S89121G', 'S89121K', 'S89121P', 'S89121S', 'S89122A', 'S89122D', 'S89122G', 'S89122K',
        'S89122P', 'S89122S', 'S89129A', 'S89129D', 'S89129G', 'S89129K', 'S89129P', 'S89129S',
        'S89131A', 'S89131D', 'S89131G', 'S89131K', 'S89131P', 'S89131S', 'S89132A', 'S89132D',
        'S89132G', 'S89132K', 'S89132P', 'S89132S', 'S89139A', 'S89139D', 'S89139G', 'S89139K',
        'S89139P', 'S89139S', 'S89141A', 'S89141D', 'S89141G', 'S89141K', 'S89141P', 'S89141S',
        'S89142A', 'S89142D', 'S89142G', 'S89142K', 'S89142P', 'S89142S', 'S89149A', 'S89149D',
        'S89149G', 'S89149K', 'S89149P', 'S89149S', 'S89191A', 'S89191D', 'S89191G', 'S89191K',
        'S89191P', 'S89191S', 'S89192A', 'S89192D', 'S89192G', 'S89192K', 'S89192P', 'S89192S',
        'S89199A', 'S89199D', 'S89199G', 'S89199K', 'S89199P', 'S89199S', 'S89201A', 'S89201D',
        'S89201G', 'S89201K', 'S89201P', 'S89201S', 'S89202A', 'S89202D', 'S89202G', 'S89202K',
        'S89202P', 'S89202S', 'S89209A', 'S89209D', 'S89209G', 'S89209K', 'S89209P', 'S89209S',
        'S89211A', 'S89211D', 'S89211G', 'S89211K', 'S89211P', 'S89211S', 'S89212A', 'S89212D',
        'S89212G', 'S89212K', 'S89212P', 'S89212S', 'S89219A', 'S89219D', 'S89219G', 'S89219K',
        'S89219P', 'S89219S', 'S89221A', 'S89221D', 'S89221G', 'S89221K', 'S89221P', 'S89221S',
        'S89222A', 'S89222D', 'S89222G', 'S89222K', 'S89222P', 'S89222S', 'S89229A', 'S89229D',
        'S89229G', 'S89229K', 'S89229P', 'S89229S', 'S89291A', 'S89291D', 'S89291G', 'S89291K',
        'S89291P', 'S89291S', 'S89292A', 'S89292D', 'S89292G', 'S89292K', 'S89292P', 'S89292S',
        'S89299A', 'S89299D', 'S89299G', 'S89299K', 'S89299P', 'S89299S', 'S89301A', 'S89301D',
        'S89301G', 'S89301K', 'S89301P', 'S89301S', 'S89302A', 'S89302D', 'S89302G', 'S89302K',
        'S89302P', 'S89302S', 'S89309A', 'S89309D', 'S89309G', 'S89309K', 'S89309P', 'S89309S',
        'S89311A', 'S89311D', 'S89311G', 'S89311K', 'S89311P', 'S89311S', 'S89312A', 'S89312D',
        'S89312G', 'S89312K', 'S89312P', 'S89312S', 'S89319A', 'S89319D', 'S89319G', 'S89319K',
        'S89319P', 'S89319S', 'S89321A', 'S89321D', 'S89321G', 'S89321K', 'S89321P', 'S89321S',
        'S89322A', 'S89322D', 'S89322G', 'S89322K', 'S89322P', 'S89322S', 'S89329A', 'S89329D',
        'S89329G', 'S89329K', 'S89329P', 'S89329S', 'S89391A', 'S89391D', 'S89391G', 'S89391K',
        'S89391P', 'S89391S', 'S89392A', 'S89392D', 'S89392G', 'S89392K', 'S89392P', 'S89392S',
        'S89399A', 'S89399D', 'S89399G', 'S89399K', 'S89399P', 'S89399S', 'S92001A', 'S92001B',
        'S92001D', 'S92001G', 'S92001K', 'S92001P', 'S92001S', 'S92002A', 'S92002B', 'S92002D',
        'S92002G', 'S92002K', 'S92002P', 'S92002S', 'S92009A', 'S92009B', 'S92009D', 'S92009G',
        'S92009K', 'S92009P', 'S92009S', 'S92011A', 'S92011B', 'S92011D', 'S92011G', 'S92011K',
        'S92011P', 'S92011S', 'S92012A', 'S92012B', 'S92012D', 'S92012G', 'S92012K', 'S92012P',
        'S92012S', 'S92013A', 'S92013B', 'S92013D', 'S92013G', 'S92013K', 'S92013P', 'S92013S',
        'S92014A', 'S92014B', 'S92014D', 'S92014G', 'S92014K', 'S92014P', 'S92014S', 'S92015A',
        'S92015B', 'S92015D', 'S92015G', 'S92015K', 'S92015P', 'S92015S', 'S92016A', 'S92016B',
        'S92016D', 'S92016G', 'S92016K', 'S92016P', 'S92016S', 'S92021A', 'S92021B', 'S92021D',
        'S92021G', 'S92021K', 'S92021P', 'S92021S', 'S92022A', 'S92022B', 'S92022D', 'S92022G',
        'S92022K', 'S92022P', 'S92022S', 'S92023A', 'S92023B', 'S92023D', 'S92023G', 'S92023K',
        'S92023P', 'S92023S', 'S92024A', 'S92024B', 'S92024D', 'S92024G', 'S92024K', 'S92024P',
        'S92024S', 'S92025A', 'S92025B', 'S92025D', 'S92025G', 'S92025K', 'S92025P', 'S92025S',
        'S92026A', 'S92026B', 'S92026D', 'S92026G', 'S92026K', 'S92026P', 'S92026S', 'S92031A',
        'S92031B', 'S92031D', 'S92031G', 'S92031K', 'S92031P', 'S92031S', 'S92032A', 'S92032B',
        'S92032D', 'S92032G', 'S92032K', 'S92032P', 'S92032S', 'S92033A', 'S92033B', 'S92033D',
        'S92033G', 'S92033K', 'S92033P', 'S92033S', 'S92034A', 'S92034B', 'S92034D', 'S92034G',
        'S92034K', 'S92034P', 'S92034S', 'S92035A', 'S92035B', 'S92035D', 'S92035G', 'S92035K',
        'S92035P', 'S92035S', 'S92036A', 'S92036B', 'S92036D', 'S92036G', 'S92036K', 'S92036P',
        'S92036S', 'S92041A', 'S92041B', 'S92041D', 'S92041G', 'S92041K', 'S92041P', 'S92041S',
        'S92042A', 'S92042B', 'S92042D', 'S92042G', 'S92042K', 'S92042P', 'S92042S', 'S92043A',
        'S92043B', 'S92043D', 'S92043G', 'S92043K', 'S92043P', 'S92043S', 'S92044A', 'S92044B',
        'S92044D', 'S92044G', 'S92044K', 'S92044P', 'S92044S', 'S92045A', 'S92045B', 'S92045D',
        'S92045G', 'S92045K', 'S92045P', 'S92045S', 'S92046A', 'S92046B', 'S92046D', 'S92046G',
        'S92046K', 'S92046P', 'S92046S', 'S92051A', 'S92051B', 'S92051D', 'S92051G', 'S92051K',
        'S92051P', 'S92051S', 'S92052A', 'S92052B', 'S92052D', 'S92052G', 'S92052K', 'S92052P',
        'S92052S', 'S92053A', 'S92053B', 'S92053D', 'S92053G', 'S92053K', 'S92053P', 'S92053S',
        'S92054A', 'S92054B', 'S92054D', 'S92054G', 'S92054K', 'S92054P', 'S92054S', 'S92055A',
        'S92055B', 'S92055D', 'S92055G', 'S92055K', 'S92055P', 'S92055S', 'S92056A', 'S92056B',
        'S92056D', 'S92056G', 'S92056K', 'S92056P', 'S92056S', 'S92061A', 'S92061B', 'S92061D',
        'S92061G', 'S92061K', 'S92061P', 'S92061S', 'S92062A', 'S92062B', 'S92062D', 'S92062G',
        'S92062K', 'S92062P', 'S92062S', 'S92063A', 'S92063B', 'S92063D', 'S92063G', 'S92063K',
        'S92063P', 'S92063S', 'S92064A', 'S92064B', 'S92064D', 'S92064G', 'S92064K', 'S92064P',
        'S92064S', 'S92065A', 'S92065B', 'S92065D', 'S92065G', 'S92065K', 'S92065P', 'S92065S',
        'S92066A', 'S92066B', 'S92066D', 'S92066G', 'S92066K', 'S92066P', 'S92066S', 'S92101A',
        'S92101B', 'S92101D', 'S92101G', 'S92101K', 'S92101P', 'S92101S', 'S92102A', 'S92102B',
        'S92102D', 'S92102G', 'S92102K', 'S92102P', 'S92102S', 'S92109A', 'S92109B', 'S92109D',
        'S92109G', 'S92109K', 'S92109P', 'S92109S', 'S92111A', 'S92111B', 'S92111D', 'S92111G',
        'S92111K', 'S92111P', 'S92111S', 'S92112A', 'S92112B', 'S92112D', 'S92112G', 'S92112K',
        'S92112P', 'S92112S', 'S92113A', 'S92113B', 'S92113D', 'S92113G', 'S92113K', 'S92113P',
        'S92113S', 'S92114A', 'S92114B', 'S92114D', 'S92114G', 'S92114K', 'S92114P', 'S92114S',
        'S92115A', 'S92115B', 'S92115D', 'S92115G', 'S92115K', 'S92115P', 'S92115S', 'S92116A',
        'S92116B', 'S92116D', 'S92116G', 'S92116K', 'S92116P', 'S92116S', 'S92121A', 'S92121B',
        'S92121D', 'S92121G', 'S92121K', 'S92121P', 'S92121S', 'S92122A', 'S92122B', 'S92122D',
        'S92122G', 'S92122K', 'S92122P', 'S92122S', 'S92123A', 'S92123B', 'S92123D', 'S92123G',
        'S92123K', 'S92123P', 'S92123S', 'S92124A', 'S92124B', 'S92124D', 'S92124G', 'S92124K',
        'S92124P', 'S92124S', 'S92125A', 'S92125B', 'S92125D', 'S92125G', 'S92125K', 'S92125P',
        'S92125S', 'S92126A', 'S92126B', 'S92126D', 'S92126G', 'S92126K', 'S92126P', 'S92126S',
        'S92131A', 'S92131B', 'S92131D', 'S92131G', 'S92131K', 'S92131P', 'S92131S', 'S92132A',
        'S92132B', 'S92132D', 'S92132G', 'S92132K', 'S92132P', 'S92132S', 'S92133A', 'S92133B',
        'S92133D', 'S92133G', 'S92133K', 'S92133P', 'S92133S', 'S92134A', 'S92134B', 'S92134D',
        'S92134G', 'S92134K', 'S92134P', 'S92134S', 'S92135A', 'S92135B', 'S92135D', 'S92135G',
        'S92135K', 'S92135P', 'S92135S', 'S92136A', 'S92136B', 'S92136D', 'S92136G', 'S92136K',
        'S92136P', 'S92136S', 'S92141A', 'S92141B', 'S92141D', 'S92141G', 'S92141K', 'S92141P',
        'S92141S', 'S92142A', 'S92142B', 'S92142D', 'S92142G', 'S92142K', 'S92142P', 'S92142S',
        'S92143A', 'S92143B', 'S92143D', 'S92143G', 'S92143K', 'S92143P', 'S92143S', 'S92144A',
        'S92144B', 'S92144D', 'S92144G', 'S92144K', 'S92144P', 'S92144S', 'S92145A', 'S92145B',
        'S92145D', 'S92145G', 'S92145K', 'S92145P', 'S92145S', 'S92146A', 'S92146B', 'S92146D',
        'S92146G', 'S92146K', 'S92146P', 'S92146S', 'S92151A', 'S92151B', 'S92151D', 'S92151G',
        'S92151K', 'S92151P', 'S92151S', 'S92152A', 'S92152B', 'S92152D', 'S92152G', 'S92152K',
        'S92152P', 'S92152S', 'S92153A', 'S92153B', 'S92153D', 'S92153G', 'S92153K', 'S92153P',
        'S92153S', 'S92154A', 'S92154B', 'S92154D', 'S92154G', 'S92154K', 'S92154P', 'S92154S',
        'S92155A', 'S92155B', 'S92155D', 'S92155G', 'S92155K', 'S92155P', 'S92155S', 'S92156A',
        'S92156B', 'S92156D', 'S92156G', 'S92156K', 'S92156P', 'S92156S', 'S92191A', 'S92191B',
        'S92191D', 'S92191G', 'S92191K', 'S92191P', 'S92191S', 'S92192A', 'S92192B', 'S92192D',
        'S92192G', 'S92192K', 'S92192P', 'S92192S', 'S92199A', 'S92199B', 'S92199D', 'S92199G',
        'S92199K', 'S92199P', 'S92199S', 'S92201A', 'S92201B', 'S92201D', 'S92201G', 'S92201K',
        'S92201P', 'S92201S', 'S92202A', 'S92202B', 'S92202D', 'S92202G', 'S92202K', 'S92202P',
        'S92202S', 'S92209A', 'S92209B', 'S92209D', 'S92209G', 'S92209K', 'S92209P', 'S92209S',
        'S92211A', 'S92211B', 'S92211D', 'S92211G', 'S92211K', 'S92211P', 'S92211S', 'S92212A',
        'S92212B', 'S92212D', 'S92212G', 'S92212K', 'S92212P', 'S92212S', 'S92213A', 'S92213B',
        'S92213D', 'S92213G', 'S92213K', 'S92213P', 'S92213S', 'S92214A', 'S92214B', 'S92214D',
        'S92214G', 'S92214K', 'S92214P', 'S92214S', 'S92215A', 'S92215B', 'S92215D', 'S92215G',
        'S92215K', 'S92215P', 'S92215S', 'S92216A', 'S92216B', 'S92216D', 'S92216G', 'S92216K',
        'S92216P', 'S92216S', 'S92221A', 'S92221B', 'S92221D', 'S92221G', 'S92221K', 'S92221P',
        'S92221S', 'S92222A', 'S92222B', 'S92222D', 'S92222G', 'S92222K', 'S92222P', 'S92222S',
        'S92223A', 'S92223B', 'S92223D', 'S92223G', 'S92223K', 'S92223P', 'S92223S', 'S92224A',
        'S92224B', 'S92224D', 'S92224G', 'S92224K', 'S92224P', 'S92224S', 'S92225A', 'S92225B',
        'S92225D', 'S92225G', 'S92225K', 'S92225P', 'S92225S', 'S92226A', 'S92226B', 'S92226D',
        'S92226G', 'S92226K', 'S92226P', 'S92226S', 'S92231A', 'S92231B', 'S92231D', 'S92231G',
        'S92231K', 'S92231P', 'S92231S', 'S92232A', 'S92232B', 'S92232D', 'S92232G', 'S92232K',
        'S92232P', 'S92232S', 'S92233A', 'S92233B', 'S92233D', 'S92233G', 'S92233K', 'S92233P',
        'S92233S', 'S92234A', 'S92234B', 'S92234D', 'S92234G', 'S92234K', 'S92234P', 'S92234S',
        'S92235A', 'S92235B', 'S92235D', 'S92235G', 'S92235K', 'S92235P', 'S92235S', 'S92236A',
        'S92236B', 'S92236D', 'S92236G', 'S92236K', 'S92236P', 'S92236S', 'S92241A', 'S92241B',
        'S92241D', 'S92241G', 'S92241K', 'S92241P', 'S92241S', 'S92242A', 'S92242B', 'S92242D',
        'S92242G', 'S92242K', 'S92242P', 'S92242S', 'S92243A', 'S92243B', 'S92243D', 'S92243G',
        'S92243K', 'S92243P', 'S92243S', 'S92244A', 'S92244B', 'S92244D', 'S92244G', 'S92244K',
        'S92244P', 'S92244S', 'S92245A', 'S92245B', 'S92245D', 'S92245G', 'S92245K', 'S92245P',
        'S92245S', 'S92246A', 'S92246B', 'S92246D', 'S92246G', 'S92246K', 'S92246P', 'S92246S',
        'S92251A', 'S92251B', 'S92251D', 'S92251G', 'S92251K', 'S92251P', 'S92251S', 'S92252A',
        'S92252B', 'S92252D', 'S92252G', 'S92252K', 'S92252P', 'S92252S', 'S92253A', 'S92253B',
        'S92253D', 'S92253G', 'S92253K', 'S92253P', 'S92253S', 'S92254A', 'S92254B', 'S92254D',
        'S92254G', 'S92254K', 'S92254P', 'S92254S', 'S92255A', 'S92255B', 'S92255D', 'S92255G',
        'S92255K', 'S92255P', 'S92255S', 'S92256A', 'S92256B', 'S92256D', 'S92256G', 'S92256K',
        'S92256P', 'S92256S', 'S92301A', 'S92301B', 'S92301D', 'S92301G', 'S92301K', 'S92301P',
        'S92301S', 'S92302A', 'S92302B', 'S92302D', 'S92302G', 'S92302K', 'S92302P', 'S92302S',
        'S92309A', 'S92309B', 'S92309D', 'S92309G', 'S92309K', 'S92309P', 'S92309S', 'S92311A',
        'S92311B', 'S92311D', 'S92311G', 'S92311K', 'S92311P', 'S92311S', 'S92312A', 'S92312B',
        'S92312D', 'S92312G', 'S92312K', 'S92312P', 'S92312S', 'S92313A', 'S92313B', 'S92313D',
        'S92313G', 'S92313K', 'S92313P', 'S92313S', 'S92314A', 'S92314B', 'S92314D', 'S92314G',
        'S92314K', 'S92314P', 'S92314S', 'S92315A', 'S92315B', 'S92315D', 'S92315G', 'S92315K',
        'S92315P', 'S92315S', 'S92316A', 'S92316B', 'S92316D', 'S92316G', 'S92316K', 'S92316P',
        'S92316S', 'S92321A', 'S92321B', 'S92321D', 'S92321G', 'S92321K', 'S92321P', 'S92321S',
        'S92322A', 'S92322B', 'S92322D', 'S92322G', 'S92322K', 'S92322P', 'S92322S', 'S92323A',
        'S92323B', 'S92323D', 'S92323G', 'S92323K', 'S92323P', 'S92323S', 'S92324A', 'S92324B',
        'S92324D', 'S92324G', 'S92324K', 'S92324P', 'S92324S', 'S92325A', 'S92325B', 'S92325D',
        'S92325G', 'S92325K', 'S92325P', 'S92325S', 'S92326A', 'S92326B', 'S92326D', 'S92326G',
        'S92326K', 'S92326P', 'S92326S', 'S92331A', 'S92331B', 'S92331D', 'S92331G', 'S92331K',
        'S92331P', 'S92331S', 'S92332A', 'S92332B', 'S92332D', 'S92332G', 'S92332K', 'S92332P',
        'S92332S', 'S92333A', 'S92333B', 'S92333D', 'S92333G', 'S92333K', 'S92333P', 'S92333S',
        'S92334A', 'S92334B', 'S92334D', 'S92334G', 'S92334K', 'S92334P', 'S92334S', 'S92335A',
        'S92335B', 'S92335D', 'S92335G', 'S92335K', 'S92335P', 'S92335S', 'S92336A', 'S92336B',
        'S92336D', 'S92336G', 'S92336K', 'S92336P', 'S92336S', 'S92341A', 'S92341B', 'S92341D',
        'S92341G', 'S92341K', 'S92341P', 'S92341S', 'S92342A', 'S92342B', 'S92342D', 'S92342G',
        'S92342K', 'S92342P', 'S92342S', 'S92343A', 'S92343B', 'S92343D', 'S92343G', 'S92343K',
        'S92343P', 'S92343S', 'S92344A', 'S92344B', 'S92344D', 'S92344G', 'S92344K', 'S92344P',
        'S92344S', 'S92345A', 'S92345B', 'S92345D', 'S92345G', 'S92345K', 'S92345P', 'S92345S',
        'S92346A', 'S92346B', 'S92346D', 'S92346G', 'S92346K', 'S92346P', 'S92346S', 'S92351A',
        'S92351B', 'S92351D', 'S92351G', 'S92351K', 'S92351P', 'S92351S', 'S92352A', 'S92352B',
        'S92352D', 'S92352G', 'S92352K', 'S92352P', 'S92352S', 'S92353A', 'S92353B', 'S92353D',
        'S92353G', 'S92353K', 'S92353P', 'S92353S', 'S92354A', 'S92354B', 'S92354D', 'S92354G',
        'S92354K', 'S92354P', 'S92354S', 'S92355A', 'S92355B', 'S92355D', 'S92355G', 'S92355K',
        'S92355P', 'S92355S', 'S92356A', 'S92356B', 'S92356D', 'S92356G', 'S92356K', 'S92356P',
        'S92356S', 'S92401A', 'S92401B', 'S92401D', 'S92401G', 'S92401K', 'S92401P', 'S92401S',
        'S92402A', 'S92402B', 'S92402D', 'S92402G', 'S92402K', 'S92402P', 'S92402S', 'S92403A',
        'S92403B', 'S92403D', 'S92403G', 'S92403K', 'S92403P', 'S92403S', 'S92404A', 'S92404B',
        'S92404D', 'S92404G', 'S92404K', 'S92404P', 'S92404S', 'S92405A', 'S92405B', 'S92405D',
        'S92405G', 'S92405K', 'S92405P', 'S92405S', 'S92406A', 'S92406B', 'S92406D', 'S92406G',
        'S92406K', 'S92406P', 'S92406S', 'S92411A', 'S92411B', 'S92411D', 'S92411G', 'S92411K',
        'S92411P', 'S92411S', 'S92412A', 'S92412B', 'S92412D', 'S92412G', 'S92412K', 'S92412P',
        'S92412S', 'S92413A', 'S92413B', 'S92413D', 'S92413G', 'S92413K', 'S92413P', 'S92413S',
        'S92414A', 'S92414B', 'S92414D', 'S92414G', 'S92414K', 'S92414P', 'S92414S', 'S92415A',
        'S92415B', 'S92415D', 'S92415G', 'S92415K', 'S92415P', 'S92415S', 'S92416A', 'S92416B',
        'S92416D', 'S92416G', 'S92416K', 'S92416P', 'S92416S', 'S92421A', 'S92421B', 'S92421D',
        'S92421G', 'S92421K', 'S92421P', 'S92421S', 'S92422A', 'S92422B', 'S92422D', 'S92422G',
        'S92422K', 'S92422P', 'S92422S', 'S92423A', 'S92423B', 'S92423D', 'S92423G', 'S92423K',
        'S92423P', 'S92423S', 'S92424A', 'S92424B', 'S92424D', 'S92424G', 'S92424K', 'S92424P',
        'S92424S', 'S92425A', 'S92425B', 'S92425D', 'S92425G', 'S92425K', 'S92425P', 'S92425S',
        'S92426A', 'S92426B', 'S92426D', 'S92426G', 'S92426K', 'S92426P', 'S92426S', 'S92491A',
        'S92491B', 'S92491D', 'S92491G', 'S92491K', 'S92491P', 'S92491S', 'S92492A', 'S92492B',
        'S92492D', 'S92492G', 'S92492K', 'S92492P', 'S92492S', 'S92499A', 'S92499B', 'S92499D',
        'S92499G', 'S92499K', 'S92499P', 'S92499S', 'S92501A', 'S92501B', 'S92501D', 'S92501G',
        'S92501K', 'S92501P', 'S92501S', 'S92502A', 'S92502B', 'S92502D', 'S92502G', 'S92502K',
        'S92502P', 'S92502S', 'S92503A', 'S92503B', 'S92503D', 'S92503G', 'S92503K', 'S92503P',
        'S92503S', 'S92504A', 'S92504B', 'S92504D', 'S92504G', 'S92504K', 'S92504P', 'S92504S',
        'S92505A', 'S92505B', 'S92505D', 'S92505G', 'S92505K', 'S92505P', 'S92505S', 'S92506A',
        'S92506B', 'S92506D', 'S92506G', 'S92506K', 'S92506P', 'S92506S', 'S92511A', 'S92511B',
        'S92511D', 'S92511G', 'S92511K', 'S92511P', 'S92511S', 'S92512A', 'S92512B', 'S92512D',
        'S92512G', 'S92512K', 'S92512P', 'S92512S', 'S92513A', 'S92513B', 'S92513D', 'S92513G',
        'S92513K', 'S92513P', 'S92513S', 'S92514A', 'S92514B', 'S92514D', 'S92514G', 'S92514K',
        'S92514P', 'S92514S', 'S92515A', 'S92515B', 'S92515D', 'S92515G', 'S92515K', 'S92515P',
        'S92515S', 'S92516A', 'S92516B', 'S92516D', 'S92516G', 'S92516K', 'S92516P', 'S92516S',
        'S92521A', 'S92521B', 'S92521D', 'S92521G', 'S92521K', 'S92521P', 'S92521S', 'S92522A',
        'S92522B', 'S92522D', 'S92522G', 'S92522K', 'S92522P', 'S92522S', 'S92523A', 'S92523B',
        'S92523D', 'S92523G', 'S92523K', 'S92523P', 'S92523S', 'S92524A', 'S92524B', 'S92524D',
        'S92524G', 'S92524K', 'S92524P', 'S92524S', 'S92525A', 'S92525B', 'S92525D', 'S92525G',
        'S92525K', 'S92525P', 'S92525S', 'S92526A', 'S92526B', 'S92526D', 'S92526G', 'S92526K',
        'S92526P', 'S92526S', 'S92531A', 'S92531B', 'S92531D', 'S92531G', 'S92531K', 'S92531P',
        'S92531S', 'S92532A', 'S92532B', 'S92532D', 'S92532G', 'S92532K', 'S92532P', 'S92532S',
        'S92533A', 'S92533B', 'S92533D', 'S92533G', 'S92533K', 'S92533P', 'S92533S', 'S92534A',
        'S92534B', 'S92534D', 'S92534G', 'S92534K', 'S92534P', 'S92534S', 'S92535A', 'S92535B',
        'S92535D', 'S92535G', 'S92535K', 'S92535P', 'S92535S', 'S92536A', 'S92536B', 'S92536D',
        'S92536G', 'S92536K', 'S92536P', 'S92536S', 'S92591A', 'S92591B', 'S92591D', 'S92591G',
        'S92591K', 'S92591P', 'S92591S', 'S92592A', 'S92592B', 'S92592D', 'S92592G', 'S92592K',
        'S92592P', 'S92592S', 'S92599A', 'S92599B', 'S92599D', 'S92599G', 'S92599K', 'S92599P',
        'S92599S', 'S92811A', 'S92811B', 'S92811D', 'S92811G', 'S92811K', 'S92811P', 'S92811S',
        'S92812A', 'S92812B', 'S92812D', 'S92812G', 'S92812K', 'S92812P', 'S92812S', 'S92819A',
        'S92819B', 'S92819D', 'S92819G', 'S92819K', 'S92819P', 'S92819S', 'S92901A', 'S92901B',
        'S92901D', 'S92901G', 'S92901K', 'S92901P', 'S92901S', 'S92902A', 'S92902B', 'S92902D',
        'S92902G', 'S92902K', 'S92902P', 'S92902S', 'S92909A', 'S92909B', 'S92909D', 'S92909G',
        'S92909K', 'S92909P', 'S92909S', 'S92911A', 'S92911B', 'S92911D', 'S92911G', 'S92911K',
        'S92911P', 'S92911S', 'S92912A', 'S92912B', 'S92912D', 'S92912G', 'S92912K', 'S92912P',
        'S92912S', 'S92919A', 'S92919B', 'S92919D', 'S92919G', 'S92919K', 'S92919P', 'S92919S',
        'S9304XA', 'S9304XD', 'S9304XS', 'S9305XA', 'S9305XD', 'S9305XS', 'S9306XA', 'S9306XD',
        'S9306XS', 'S93104A', 'S93104D', 'S93104S', 'S93105A', 'S93105D', 'S93105S', 'S93106A',
        'S93106D', 'S93106S', 'S93111A', 'S93111D', 'S93111S', 'S93112A', 'S93112D', 'S93112S',
        'S93113A', 'S93113D', 'S93113S', 'S93114A', 'S93114D', 'S93114S', 'S93115A', 'S93115D',
        'S93115S', 'S93116A', 'S93116D', 'S93116S', 'S93119A', 'S93119D', 'S93119S', 'S93121A',
        'S93121D', 'S93121S', 'S93122A', 'S93122D', 'S93122S', 'S93123A', 'S93123D', 'S93123S',
        'S93124A', 'S93124D', 'S93124S', 'S93125A', 'S93125D', 'S93125S', 'S93126A', 'S93126D',
        'S93126S', 'S93129A', 'S93129D', 'S93129S', 'S93304A', 'S93304D', 'S93304S', 'S93305A',
        'S93305D', 'S93305S', 'S93306A', 'S93306D', 'S93306S', 'S93314A', 'S93314D', 'S93314S',
        'S93315A', 'S93315D', 'S93315S', 'S93316A', 'S93316D', 'S93316S', 'S93321A', 'S93321D',
        'S93321S', 'S93325A', 'S93325D', 'S93325S', 'S93326A', 'S93326D', 'S93326S', 'S93334A',
        'S93334D', 'S93334S', 'S93335A', 'S93335D', 'S93335S', 'S93336A', 'S93336D', 'S93336S',
        'S99001A', 'S99001B', 'S99001D', 'S99001G', 'S99001K', 'S99001P', 'S99001S', 'S99002A',
        'S99002B', 'S99002D', 'S99002G', 'S99002K', 'S99002P', 'S99002S', 'S99009A', 'S99009B',
        'S99009D', 'S99009G', 'S99009K', 'S99009P', 'S99009S', 'S99011A', 'S99011B', 'S99011D',
        'S99011G', 'S99011K', 'S99011P', 'S99011S', 'S99012A', 'S99012B', 'S99012D', 'S99012G',
        'S99012K', 'S99012P', 'S99012S', 'S99019A', 'S99019B', 'S99019D', 'S99019G', 'S99019K',
        'S99019P', 'S99019S', 'S99021A', 'S99021B', 'S99021D', 'S99021G', 'S99021K', 'S99021P',
        'S99021S', 'S99022A', 'S99022B', 'S99022D', 'S99022G', 'S99022K', 'S99022P', 'S99022S',
        'S99029A', 'S99029B', 'S99029D', 'S99029G', 'S99029K', 'S99029P', 'S99029S', 'S99031A',
        'S99031B', 'S99031D', 'S99031G', 'S99031K', 'S99031P', 'S99031S', 'S99032A', 'S99032B',
        'S99032D', 'S99032G', 'S99032K', 'S99032P', 'S99032S', 'S99039A', 'S99039B', 'S99039D',
        'S99039G', 'S99039K', 'S99039P', 'S99039S', 'S99041A', 'S99041B', 'S99041D', 'S99041G',
        'S99041K', 'S99041P', 'S99041S', 'S99042A', 'S99042B', 'S99042D', 'S99042G', 'S99042K',
        'S99042P', 'S99042S', 'S99049A', 'S99049B', 'S99049D', 'S99049G', 'S99049K', 'S99049P',
        'S99049S', 'S99091A', 'S99091B', 'S99091D', 'S99091G', 'S99091K', 'S99091P', 'S99091S',
        'S99092A', 'S99092B', 'S99092D', 'S99092G', 'S99092K', 'S99092P', 'S99092S', 'S99099A',
        'S99099B', 'S99099D', 'S99099G', 'S99099K', 'S99099P', 'S99099S', 'S99101A', 'S99101B',
        'S99101D', 'S99101G', 'S99101K', 'S99101P', 'S99101S', 'S99102A', 'S99102B', 'S99102D',
        'S99102G', 'S99102K', 'S99102P', 'S99102S', 'S99109A', 'S99109B', 'S99109D', 'S99109G',
        'S99109K', 'S99109P', 'S99109S', 'S99111A', 'S99111B', 'S99111D', 'S99111G', 'S99111K',
        'S99111P', 'S99111S', 'S99112A', 'S99112B', 'S99112D', 'S99112G', 'S99112K', 'S99112P',
        'S99112S', 'S99119A', 'S99119B', 'S99119D', 'S99119G', 'S99119K', 'S99119P', 'S99119S',
        'S99121A', 'S99121B', 'S99121D', 'S99121G', 'S99121K', 'S99121P', 'S99121S', 'S99122A',
        'S99122B', 'S99122D', 'S99122G', 'S99122K', 'S99122P', 'S99122S', 'S99129A', 'S99129B',
        'S99129D', 'S99129G', 'S99129K', 'S99129P', 'S99129S', 'S99131A', 'S99131B', 'S99131D',
        'S99131G', 'S99131K', 'S99131P', 'S99131S', 'S99132A', 'S99132B', 'S99132D', 'S99132G',
        'S99132K', 'S99132P', 'S99132S', 'S99139A', 'S99139B', 'S99139D', 'S99139G', 'S99139K',
        'S99139P', 'S99139S', 'S99141A', 'S99141B', 'S99141D', 'S99141G', 'S99141K', 'S99141P',
        'S99141S', 'S99142A', 'S99142B', 'S99142D', 'S99142G', 'S99142K', 'S99142P', 'S99142S',
        'S99149A', 'S99149B', 'S99149D', 'S99149G', 'S99149K', 'S99149P', 'S99149S', 'S99191A',
        'S99191B', 'S99191D', 'S99191G', 'S99191K', 'S99191P', 'S99191S', 'S99192A', 'S99192B',
        'S99192D', 'S99192G', 'S99192K', 'S99192P', 'S99192S', 'S99199A', 'S99199B', 'S99199D',
        'S99199G', 'S99199K', 'S99199P', 'S99199S', 'S99201A', 'S99201B', 'S99201D', 'S99201G',
        'S99201K', 'S99201P', 'S99201S', 'S99202A', 'S99202B', 'S99202D', 'S99202G', 'S99202K',
        'S99202P', 'S99202S', 'S99209A', 'S99209B', 'S99209D', 'S99209G', 'S99209K', 'S99209P',
        'S99209S', 'S99211A', 'S99211B', 'S99211D', 'S99211G', 'S99211K', 'S99211P', 'S99211S',
        'S99212A', 'S99212B', 'S99212D', 'S99212G', 'S99212K', 'S99212P', 'S99212S', 'S99219A',
        'S99219B', 'S99219D', 'S99219G', 'S99219K', 'S99219P', 'S99219S', 'S99221A', 'S99221B',
        'S99221D', 'S99221G', 'S99221K', 'S99221P', 'S99221S', 'S99222A', 'S99222B', 'S99222D',
        'S99222G', 'S99222K', 'S99222P', 'S99222S', 'S99229A', 'S99229B', 'S99229D', 'S99229G',
        'S99229K', 'S99229P', 'S99229S', 'S99231A', 'S99231B', 'S99231D', 'S99231G', 'S99231K',
        'S99231P', 'S99231S', 'S99232A', 'S99232B', 'S99232D', 'S99232G', 'S99232K', 'S99232P',
        'S99232S', 'S99239A', 'S99239B', 'S99239D', 'S99239G', 'S99239K', 'S99239P', 'S99239S',
        'S99241A', 'S99241B', 'S99241D', 'S99241G', 'S99241K', 'S99241P', 'S99241S', 'S99242A',
        'S99242B', 'S99242D', 'S99242G', 'S99242K', 'S99242P', 'S99242S', 'S99249A', 'S99249B',
        'S99249D', 'S99249G', 'S99249K', 'S99249P', 'S99249S', 'S99291A', 'S99291B', 'S99291D',
        'S99291G', 'S99291K', 'S99291P', 'S99291S', 'S99292A', 'S99292B', 'S99292D', 'S99292G',
        'S99292K', 'S99292P', 'S99292S', 'S99299A', 'S99299B', 'S99299D', 'S99299G', 'S99299K',
        'S99299P', 'S99299S'
    }

    ICD9CM = {
        '80000', '80001', '80002', '80003', '80004', '80005', '80006', '80009', '80010', '80011',
        '80012', '80013', '80014', '80015', '80016', '80019', '80020', '80021', '80022', '80023',
        '80024', '80025', '80026', '80029', '80030', '80031', '80032', '80033', '80034', '80035',
        '80036', '80039', '80040', '80041', '80042', '80043', '80044', '80045', '80046', '80049',
        '80050', '80051', '80052', '80053', '80054', '80055', '80056', '80059', '80060', '80061',
        '80062', '80063', '80064', '80065', '80066', '80069', '80070', '80071', '80072', '80073',
        '80074', '80075', '80076', '80079', '80080', '80081', '80082', '80083', '80084', '80085',
        '80086', '80089', '80090', '80091', '80092', '80093', '80094', '80095', '80096', '80099',
        '80100', '80101', '80102', '80103', '80104', '80105', '80106', '80109', '80110', '80111',
        '80112', '80113', '80114', '80115', '80116', '80119', '80120', '80121', '80122', '80123',
        '80124', '80125', '80126', '80129', '80130', '80131', '80132', '80133', '80134', '80135',
        '80136', '80139', '80140', '80141', '80142', '80143', '80144', '80145', '80146', '80149',
        '80150', '80151', '80152', '80153', '80154', '80155', '80156', '80159', '80160', '80161',
        '80162', '80163', '80164', '80165', '80166', '80169', '80170', '80171', '80172', '80173',
        '80174', '80175', '80176', '80179', '80180', '80181', '80182', '80183', '80184', '80185',
        '80186', '80189', '80190', '80191', '80192', '80193', '80194', '80195', '80196', '80199',
        '8020', '8021', '80220', '80221', '80222', '80223', '80224', '80225', '80226', '80227',
        '80228', '80229', '80230', '80231', '80232', '80233', '80234', '80235', '80236', '80237',
        '80238', '80239', '8024', '8025', '8026', '8027', '8028', '8029', '80300', '80301',
        '80302', '80303', '80304', '80305', '80306', '80309', '80310', '80311', '80312', '80313',
        '80314', '80315', '80316', '80319', '80320', '80321', '80322', '80323', '80324', '80325',
        '80326', '80329', '80330', '80331', '80332', '80333', '80334', '80335', '80336', '80339',
        '80340', '80341', '80342', '80343', '80344', '80345', '80346', '80349', '80350', '80351',
        '80352', '80353', '80354', '80355', '80356', '80359', '80360', '80361', '80362', '80363',
        '80364', '80365', '80366', '80369', '80370', '80371', '80372', '80373', '80374', '80375',
        '80376', '80379', '80380', '80381', '80382', '80383', '80384', '80385', '80386', '80389',
        '80390', '80391', '80392', '80393', '80394', '80395', '80396', '80399', '80400', '80401',
        '80402', '80403', '80404', '80405', '80406', '80409', '80410', '80411', '80412', '80413',
        '80414', '80415', '80416', '80419', '80420', '80421', '80422', '80423', '80424', '80425',
        '80426', '80429', '80430', '80431', '80432', '80433', '80434', '80435', '80436', '80439',
        '80440', '80441', '80442', '80443', '80444', '80445', '80446', '80449', '80450', '80451',
        '80452', '80453', '80454', '80455', '80456', '80459', '80460', '80461', '80462', '80463',
        '80464', '80465', '80466', '80469', '80470', '80471', '80472', '80473', '80474', '80475',
        '80476', '80479', '80480', '80481', '80482', '80483', '80484', '80485', '80486', '80489',
        '80490', '80491', '80492', '80493', '80494', '80495', '80496', '80499', '80500', '80501',
        '80502', '80503', '80504', '80505', '80506', '80507', '80508', '80510', '80511', '80512',
        '80513', '80514', '80515', '80516', '80517', '80518', '8052', '8053', '8054', '8055',
        '8056', '8057', '8058', '8059', '80600', '80601', '80602', '80603', '80604', '80605',
        '80606', '80607', '80608', '80609', '80610', '80611', '80612', '80613', '80614', '80615',
        '80616', '80617', '80618', '80619', '80620', '80621', '80622', '80623', '80624', '80625',
        '80626', '80627', '80628', '80629', '80630', '80631', '80632', '80633', '80634', '80635',
        '80636', '80637', '80638', '80639', '8064', '8065', '80660', '80661', '80662', '80669',
        '80670', '80671', '80672', '80679', '8068', '8069', '80700', '80701', '80702', '80703',
        '80704', '80705', '80706', '80707', '80708', '80709', '80710', '80711', '80712', '80713',
        '80714', '80715', '80716', '80717', '80718', '80719', '8072', '8073', '8074', '8075',
        '8076', '8080', '8081', '8082', '8083', '80841', '80842', '80843', '80844', '80849',
        '80851', '80852', '80853', '80854', '80859', '8088', '8089', '8090', '8091', '81000',
        '81001', '81002', '81003', '81010', '81011', '81012', '81013', '81100', '81101', '81102',
        '81103', '81109', '81110', '81111', '81112', '81113', '81119', '81200', '81201', '81202',
        '81203', '81209', '81210', '81211', '81212', '81213', '81219', '81220', '81221', '81230',
        '81231', '81240', '81241', '81242', '81243', '81244', '81249', '81250', '81251', '81252',
        '81253', '81254', '81259', '81300', '81301', '81302', '81303', '81304', '81305', '81306',
        '81307', '81308', '81310', '81311', '81312', '81313', '81314', '81315', '81316', '81317',
        '81318', '81320', '81321', '81322', '81323', '81330', '81331', '81332', '81333', '81340',
        '81341', '81342', '81343', '81344', '81345', '81346', '81347', '81350', '81351', '81352',
        '81353', '81354', '81380', '81381', '81382', '81383', '81390', '81391', '81392', '81393',
        '81400', '81401', '81402', '81403', '81404', '81405', '81406', '81407', '81408', '81409',
        '81410', '81411', '81412', '81413', '81414', '81415', '81416', '81417', '81418', '81419',
        '81500', '81501', '81502', '81503', '81504', '81509', '81510', '81511', '81512', '81513',
        '81514', '81519', '81600', '81601', '81602', '81603', '81610', '81611', '81612', '81613',
        '8170', '8171', '8180', '8181', '8190', '8191', '82000', '82001', '82002', '82003',
        '82009', '82010', '82011', '82012', '82013', '82019', '82020', '82021', '82022', '82030',
        '82031', '82032', '8208', '8209', '82100', '82101', '82110', '82111', '82120', '82121',
        '82122', '82123', '82129', '82130', '82131', '82132', '82133', '82139', '8220', '8221',
        '82300', '82301', '82302', '82310', '82311', '82312', '82320', '82321', '82322', '82330',
        '82331', '82332', '82340', '82341', '82342', '82380', '82381', '82382', '82390', '82391',
        '82392', '8240', '8241', '8242', '8243', '8244', '8245', '8246', '8247', '8248', '8249',
        '8250', '8251', '82520', '82521', '82522', '82523', '82524', '82525', '82529', '82530',
        '82531', '82532', '82533', '82534', '82535', '82539', '8260', '8261', '8270', '8271',
        '8280', '8281', '8290', '8291', '8300', '8301', '83100', '83101', '83102', '83103',
        '83104', '83109', '83110', '83111', '83112', '83113', '83114', '83119', '83200', '83201',
        '83202', '83203', '83204', '83209', '83210', '83211', '83212', '83213', '83214', '83219',
        '8322', '83300', '83301', '83302', '83303', '83304', '83305', '83309', '83310', '83311',
        '83312', '83313', '83314', '83315', '83319', '83400', '83401', '83402', '83410', '83411',
        '83412', '83500', '83501', '83502', '83503', '83510', '83511', '83512', '83513', '8360',
        '8361', '8362', '8363', '8364', '83650', '83651', '83652', '83653', '83654', '83659',
        '83660', '83661', '83662', '83663', '83664', '83669', '8370', '8371', '83800', '83801',
        '83802', '83803', '83804', '83805', '83806', '83809', '83810', '83811', '83812', '83813',
        '83814', '83815', '83816', '83819', '83900', '83901', '83902', '83903', '83904', '83905',
        '83906', '83907', '83908', '83910', '83911', '83912', '83913', '83914', '83915', '83916',
        '83917', '83918', '83920', '83921', '83930', '83931', '83940', '83941', '83942', '83949',
        '83950', '83951', '83952', '83959', '83961', '83969', '83971', '83979', '8398', '8399',
        '8500', '85011', '85012', '8502', '8503', '8504', '8505', '8509', '85100', '85101',
        '85102', '85103', '85104', '85105', '85106', '85109', '85110', '85111', '85112', '85113',
        '85114', '85115', '85116', '85119', '85120', '85121', '85122', '85123', '85124', '85125',
        '85126', '85129', '85130', '85131', '85132', '85133', '85134', '85135', '85136', '85139',
        '85140', '85141', '85142', '85143', '85144', '85145', '85146', '85149', '85150', '85151',
        '85152', '85153', '85154', '85155', '85156', '85159', '85160', '85161', '85162', '85163',
        '85164', '85165', '85166', '85169', '85170', '85171', '85172', '85173', '85174', '85175',
        '85176', '85179', '85180', '85181', '85182', '85183', '85184', '85185', '85186', '85189',
        '85190', '85191', '85192', '85193', '85194', '85195', '85196', '85199', '85200', '85201',
        '85202', '85203', '85204', '85205', '85206', '85209', '85210', '85211', '85212', '85213',
        '85214', '85215', '85216', '85219', '85220', '85221', '85222', '85223', '85224', '85225',
        '85226', '85229', '85230', '85231', '85232', '85233', '85234', '85235', '85236', '85239',
        '85240', '85241', '85242', '85243', '85244', '85245', '85246', '85249', '85250', '85251',
        '85252', '85253', '85254', '85255', '85256', '85259', '85300', '85301', '85302', '85303',
        '85304', '85305', '85306', '85309', '85310', '85311', '85312', '85313', '85314', '85315',
        '85316', '85319', '85400', '85401', '85402', '85403', '85404', '85405', '85406', '85409',
        '85410', '85411', '85412', '85413', '85414', '85415', '85416', '85419', '8600', '8601',
        '8602', '8603', '8604', '8605', '86100', '86101', '86102', '86103', '86110', '86111',
        '86112', '86113', '86120', '86121', '86122', '86130', '86131', '86132', '8620', '8621',
        '86221', '86222', '86229', '86231', '86232', '86239', '8628', '8629', '8630', '8631',
        '86320', '86321', '86329', '86330', '86331', '86339', '86340', '86341', '86342', '86343',
        '86344', '86345', '86346', '86349', '86350', '86351', '86352', '86353', '86354', '86355',
        '86356', '86359', '86380', '86381', '86382', '86383', '86384', '86385', '86389', '86390',
        '86391', '86392', '86393', '86394', '86395', '86399', '86400', '86401', '86402', '86403',
        '86404', '86405', '86409', '86410', '86411', '86412', '86413', '86414', '86415', '86419',
        '86500', '86501', '86502', '86503', '86504', '86509', '86510', '86511', '86512', '86513',
        '86514', '86519', '86600', '86601', '86602', '86603', '86610', '86611', '86612', '86613',
        '8670', '8671', '8672', '8673', '8674', '8675', '8676', '8677', '8678', '8679', '86800',
        '86801', '86802', '86803', '86804', '86809', '86810', '86811', '86812', '86813', '86814',
        '86819', '8690', '8691', '9050', '9051', '9052', '9053', '9054', '9055', '9056', '9057',
        '9058', '9059', '9060', '9061', '9062', '9063', '9064', '9065', '9066', '9067', '9068',
        '9069', '9070', '9071', '9072', '9073', '9074', '9075', '9079', '9080', '9081', '9082',
        '9083', '9084', '9085', '9086', '9089', '9090', '9091', '9092', '9093', '9094', '9095',
        '9099', '92611', '92612', '9290', '9299', '95200', '95201', '95202', '95203', '95204',
        '95205', '95206', '95207', '95208', '95209', '95210', '95211', '95212', '95213', '95214',
        '95215', '95216', '95217', '95218', '95219', '9522', '9523', '9524', '9528', '9529',
        '9580', '9581', '9582', '9583', '9584', '9585', '9586', '9587', '9588', '95890', '95891',
        '95892', '95893', '95899', '95901', '95909', '95911', '95912', '95913', '95914', '95919',
        '9592', '9593', '9594', '9595', '9596', '9597', '9598', '9599'
    }

    SNOMEDCT = {
        '10061007', '10256000', '10310006', '105606008', '105612003', '105621002', '10568008',
        '10575009', '10771002', '108367008', '109379000', '10998006', '110016007', '110017003',
        '110018008', '110019000', '110020006', '110021005', '110022003', '110023008', '110024002',
        '110025001', '110026000', '110027009', '110028004', '110029007', '110030002', '11008006',
        '110150000', '111245009', '111593004', '111597003', '111601003', '111603000', '111605007',
        '111607004', '111609001', '111611005', '111613008', '111615001', '111617009', '111622009',
        '111633007', '111637008', '111638003', '111639006', '111640008', '111641007', '111642000',
        '111643005', '111644004', '111645003', '111646002', '111647006', '111648001', '111649009',
        '111651008', '111671004', '111673001', '111677000', '111681000', '111683002', '111684008',
        '111691006', '111727008', '111729006', '111731002', '111733004', '11229008', '11254008',
        '11413003', '11782000', '11805005', '11807002', '11920000', '12204004', '12227007',
        '122773008', '123534001', '123535000', '123618009', '123619001', '123971006', '123972004',
        '123973009', '123975002', '12412005', '12462000', '125588009', '125589001', '125591009',
        '125593007', '125594001', '125595000', '125596004', '125597008', '125598003', '125599006',
        '125600009', '125601008', '125602001', '125603006', '125604000', '125605004', '125606003',
        '125607007', '125608002', '125609005', '125610000', '125612008', '125613003', '125614009',
        '125615005', '125616006', '125617002', '125618007', '125619004', '125620005', '125621009',
        '125622002', '125623007', '125625000', '125626004', '125627008', '125628003', '125629006',
        '125630001', '125631002', '125632009', '125633004', '125634005', '125635006', '125636007',
        '125637003', '125638008', '125639000', '125640003', '125641004', '125642006', '125802004',
        '125871005', '125872003', '12588000', '12589008', '1261007', '1264004', '12676007',
        '12694001', '127275008', '127276009', '127278005', '127279002', '127280004', '127281000',
        '127282007', '127283002', '127284008', '127285009', '127286005', '127287001', '127288006',
        '127289003', '127290007', '127291006', '127295002', '127296001', '127297005', '127298000',
        '127299008', '127300000', '127301001', '127302008', '127303003', '127304009', '127305005',
        '127306006', '127307002', '127313006', '12746007', '128069005', '128125000', '128126004',
        '12912004', '129156001', '129157005', '129161004', '129162006', '129163001', '129164007',
        '129165008', '129166009', '13019000', '13047001', '1317001', '13194006', '13289004',
        '134291007', '134424008', '13456001', '13463001', '13498003', '13553006', '13695006',
        '1370007', '13752003', '13891000', '13975002', '1419004', '14434006', '14457000',
        '14493003', '14505003', '14546008', '14584002', '14675005', '14741001', '14817008',
        '14916000', '14950009', '15151004', '15271003', '15385006', '1544005', '15474008',
        '15574005', '15701003', '15724005', '157265008', '15741007', '15929008', '16111009',
        '16114001', '16319002', '1658003', '16695002', '16837005', '16950007', '1705000',
        '1708003', '171008', '17169009', '17194005', '17214002', '17222009', '1734006', '17367000',
        '1739001', '17414004', '17463000', '17498002', '17616007', '17633000', '17667005',
        '17819003', '18147000', '18171007', '18276007', '18296004', '18336000', '18531006',
        '18605003', '18685001', '18724009', '18960007', '19090007', '19210000', '19233004',
        '19234005', '19241004', '19259001', '19491003', '195160000', '19652000', '19856004',
        '1988005', '19936001', '20026002', '20100009', '2012002', '20121009', '20132009',
        '20158009', '20167009', '20213006', '20274005', '20276007', '202974002', '20341008',
        '203709007', '20377001', '20402005', '20433007', '20474007', '20511007', '205254006',
        '2053005', '20580001', '20594000', '206209004', '20714001', '20736003', '207687004',
        '207689001', '207690005', '207691009', '207692002', '207693007', '207696004', '207705002',
        '207707005', '207708000', '207709008', '207710003', '207711004', '207727006', '207728001',
        '207729009', '207730004', '207731000', '207745006', '207746007', '207747003', '207748008',
        '207749000', '207753003', '207755005', '207757002', '207759004', '207760009', '207763006',
        '207767007', '207768002', '207769005', '207771005', '207776000', '207782002', '207785000',
        '207787008', '207788003', '207794006', '207798009', '207800002', '20784007', '207881000',
        '207884008', '207895002', '207896001', '207897005', '207898000', '207899008', '207900003',
        '207901004', '207902006', '207903001', '207904007', '207905008', '207906009', '207907000',
        '207908005', '207909002', '207910007', '207921003', '207922005', '207923000', '207924006',
        '207925007', '207926008', '207927004', '207928009', '207929001', '207930006', '207931005',
        '207932003', '207933008', '207934002', '207935001', '207936000', '207938004', '207939007',
        '207940009', '207941008', '207942001', '207943006', '207944000', '207945004', '207949005',
        '207950005', '207951009', '207952002', '207953007', '207954001', '207955000', '207956004',
        '207957008', '207958003', '207959006', '207960001', '207961002', '207962009', '207963004',
        '207964005', '207965006', '207966007', '207967003', '207968008', '207969000', '207970004',
        '207971000', '207972007', '207974008', '207975009', '207976005', '207977001', '207978006',
        '207979003', '207980000', '207981001', '207983003', '207984009', '207985005', '207986006',
        '207993005', '207998001', '208000003', '208001004', '208002006', '208003001', '208006009',
        '208007000', '208008005', '208009002', '208012004', '208014003', '208015002', '208016001',
        '208017005', '208020002', '208021003', '208022005', '208023000', '208026008', '208028009',
        '208029001', '208030006', '208031005', '208034002', '208035001', '208036000', '208037009',
        '208040009', '208042001', '208043006', '208044000', '208045004', '208048002', '208049005',
        '208050005', '208051009', '208054001', '208056004', '208057008', '208058003', '208059006',
        '208060001', '208061002', '208063004', '208064005', '208065006', '208066007', '208067003',
        '208069000', '208071000', '208076005', '208078006', '208082008', '208084009', '208088007',
        '208090008', '208097006', '208130009', '208131008', '208146001', '208147005', '208148000',
        '208149008', '208150008', '208151007', '208155003', '208156002', '208157006', '208158001',
        '208159009', '208160004', '208164008', '208165009', '208166005', '208168006', '208172005',
        '208173000', '208174006', '208181004', '208182006', '208183001', '208184007', '208185008',
        '208186009', '208192003', '208193008', '208194002', '208195001', '208197009', '208198004',
        '208202002', '208203007', '208204001', '208205000', '208206004', '208207008', '208215006',
        '208225001', '208226000', '208227009', '208228004', '208229007', '208232005', '208233000',
        '208234006', '208235007', '208236008', '208240004', '208241000', '208242007', '208244008',
        '208245009', '208246005', '208250003', '208251004', '208253001', '208254007', '208255008',
        '208256009', '208257000', '208267005', '208270009', '208271008', '208272001', '208273006',
        '208274000', '208281007', '208283005', '208284004', '208285003', '208286002', '208294009',
        '208295005', '208296006', '208298007', '208301006', '208303009', '208304003', '208306001',
        '208309008', '208312006', '208318005', '208321007', '208322000', '208323005', '208324004',
        '208325003', '208326002', '208336005', '208337001', '208340001', '208341002', '208342009',
        '208343004', '208344005', '208345006', '208369005', '208370006', '208371005', '208372003',
        '208373008', '208374002', '208375001', '208379007', '208380005', '208381009', '208382002',
        '208383007', '208384001', '208385000', '208388003', '208390002', '208393000', '208394006',
        '208396008', '208397004', '208399001', '208400008', '208401007', '208402000', '208403005',
        '208404004', '208405003', '208406002', '208408001', '208413002', '208414008', '208416005',
        '208417001', '208418006', '208419003', '208420009', '208421008', '208422001', '208423006',
        '208424000', '208427007', '208428002', '208430000', '208434009', '208435005', '208436006',
        '208437002', '208438007', '208439004', '208440002', '208441003', '208442005', '208443000',
        '208444006', '208445007', '208446008', '208447004', '208448009', '208449001', '208450001',
        '208451002', '208452009', '208453004', '208454005', '208455006', '208456007', '208457003',
        '208458008', '208459000', '208460005', '208461009', '208463007', '208467008', '208468003',
        '208469006', '208470007', '208471006', '208472004', '208473009', '208474003', '208475002',
        '208476001', '208477005', '208478000', '208479008', '208480006', '208481005', '208482003',
        '208483008', '208484002', '208485001', '208486000', '208487009', '208488004', '208489007',
        '208490003', '208491004', '208492006', '208493001', '208494007', '208499002', '208500006',
        '208502003', '208503008', '208505001', '208508004', '208509007', '208510002', '208513000',
        '208514006', '208521006', '208523009', '208524003', '208526001', '208528000', '208529008',
        '208530003', '208531004', '208536009', '208537000', '208540000', '208541001', '208542008',
        '208543003', '208544009', '208548007', '208550004', '208551000', '208552007', '208555009',
        '208557001', '208558006', '208559003', '208562000', '208578003', '208579006', '208580009',
        '208581008', '208582001', '208587007', '208588002', '208589005', '208590001', '208591002',
        '208596007', '208597003', '208598008', '208600002', '208601003', '208602005', '208603000',
        '208604006', '208605007', '208606008', '208610006', '208611005', '208612003', '208613008',
        '208614002', '208615001', '208619007', '208620001', '208621002', '208622009', '208623004',
        '208624005', '208625006', '208627003', '208629000', '208631009', '208632002', '208634001',
        '208635000', '208636004', '208637008', '208638003', '208639006', '208657007', '208658002',
        '208659005', '208660000', '208662008', '208663003', '208664009', '208665005', '208666006',
        '208667002', '208668007', '208669004', '208677000', '208678005', '208679002', '208680004',
        '208684008', '208685009', '208686005', '208687001', '208688006', '208689003', '208690007',
        '208691006', '208692004', '208696001', '208697005', '208698000', '208699008', '208700009',
        '208701008', '208702001', '208703006', '208704000', '208710000', '208711001', '208712008',
        '208713003', '208715005', '208716006', '208717002', '208718007', '208719004', '208731002',
        '208732009', '208733004', '208748005', '208749002', '208750002', '208754006', '208759001',
        '208766000', '208768004', '208769007', '208774004', '208775003', '208778001', '208779009',
        '208782004', '208785002', '208786001', '208787005', '208788000', '208789008', '208790004',
        '208795009', '208796005', '208797001', '208798006', '208799003', '208800004', '208803002',
        '208805009', '208806005', '208808006', '208811007', '208815003', '208816002', '208818001',
        '208819009', '208820003', '208826009', '208827000', '208828005', '208829002', '208830007',
        '208831006', '208832004', '208836001', '208838000', '208839008', '208840005', '208842002',
        '208843007', '208844001', '208846004', '208848003', '208849006', '208850006', '208851005',
        '208852003', '208853008', '208857009', '208859007', '208860002', '208861003', '208862005',
        '208864006', '208866008', '208869001', '208870000', '208871001', '208872008', '208873003',
        '208874009', '208876006', '208878007', '208879004', '208880001', '208881002', '208882009',
        '208883004', '208885006', '208886007', '208887003', '208888008', '208889000', '208892001',
        '208894000', '208895004', '208896003', '208900000', '208901001', '208902008', '208904009',
        '208906006', '208907002', '208908007', '208910009', '208911008', '208929003', '208930008',
        '208931007', '208932000', '208933005', '208934004', '208937006', '208938001', '208939009',
        '208940006', '208941005', '208942003', '208946000', '208947009', '208948004', '208949007',
        '208950007', '208951006', '208953009', '208954003', '208955002', '208956001', '208957005',
        '208958000', '208959008', '208961004', '208962006', '208963001', '208964007', '208965008',
        '208966009', '208967000', '208970001', '208971002', '208972009', '208973004', '208974005',
        '208975006', '208977003', '208981003', '208983000', '208984006', '208986008', '20899000',
        '208990005', '208993007', '208994001', '208995000', '208996004', '208997008', '208998003',
        '209000008', '209003005', '209004004', '209006002', '209007006', '209008001', '209010004',
        '209011000', '209013002', '209016005', '209017001', '209018006', '209019003', '209020009',
        '209021008', '209022001', '209023006', '209024000', '209027007', '209028002', '209029005',
        '209030000', '209031001', '209032008', '209033003', '209034009', '209037002', '209046008',
        '209048009', '209049001', '209050001', '209051002', '209052009', '209054005', '209064001',
        '209066004', '209067008', '209068003', '209069006', '209071006', '209073009', '209074003',
        '209075002', '209077005', '209078000', '209079008', '209080006', '209082003', '209083008',
        '209084002', '209085001', '209086000', '209088004', '209090003', '209092006', '209093001',
        '209094007', '209095008', '209097000', '209098005', '209100005', '209101009', '209102002',
        '209117003', '209118008', '209119000', '209120006', '209121005', '209122003', '209127009',
        '209128004', '209129007', '209131003', '209134006', '209136008', '209137004', '209138009',
        '209139001', '209140004', '209141000', '209142007', '209143002', '209145009', '209146005',
        '209147001', '209148006', '209149003', '209151004', '209153001', '209154007', '209155008',
        '209156009', '209157000', '209158005', '209159002', '209160007', '209162004', '209163009',
        '209164003', '209165002', '209166001', '209168000', '209169008', '209170009', '209173006',
        '209174000', '209175004', '209176003', '209178002', '209179005', '209180008', '209181007',
        '209182000', '209184004', '209185003', '209186002', '209188001', '209189009', '209190000',
        '209191001', '209193003', '209194009', '209195005', '209196006', '209197002', '209201002',
        '209202009', '209206007', '209208008', '209211009', '209212002', '209213007', '209214001',
        '209215000', '209216004', '209217008', '209218003', '209221001', '209222008', '209223003',
        '209224009', '209225005', '209226006', '209227002', '209228007', '209236003', '209238002',
        '209239005', '209242004', '209243009', '209244003', '209245002', '209246001', '209248000',
        '209249008', '209250008', '209252000', '209253005', '209255003', '209256002', '209257006',
        '209258001', '209259009', '209261000', '209262007', '209263002', '209264008', '209265009',
        '209266005', '209267001', '209268006', '209269003', '209270002', '209271003', '209273000',
        '209274006', '209276008', '209277004', '209278009', '209279001', '209280003', '209281004',
        '209283001', '209284007', '209285008', '209286009', '209287000', '209288005', '209289002',
        '209290006', '209292003', '209293008', '209294002', '209295001', '209296000', '209297009',
        '209298004', '209299007', '209301000', '209302007', '209304008', '209306005', '209307001',
        '209308006', '209309003', '209310008', '209312000', '209314004', '209315003', '209316002',
        '209317006', '209318001', '209320003', '209322006', '209323001', '209324007', '209325008',
        '209326009', '209328005', '209330007', '209331006', '209332004', '209333009', '209335002',
        '209336001', '209337005', '209338000', '209339008', '209340005', '209341009', '209342002',
        '209343007', '209344001', '209345000', '209346004', '209347008', '209348003', '209349006',
        '209350006', '209351005', '209352003', '209353008', '209354002', '209355001', '209356000',
        '209357009', '209358004', '209359007', '209360002', '209361003', '209362005', '209363000',
        '209364006', '209365007', '209366008', '209367004', '209368009', '209369001', '209370000',
        '209371001', '209372008', '209373003', '209374009', '209375005', '209377002', '209378007',
        '209379004', '209380001', '209381002', '209382009', '209383004', '209384005', '209385006',
        '209386007', '209390009', '209391008', '209392001', '209394000', '209395004', '209396003',
        '209397007', '209399005', '209400003', '209401004', '209402006', '209404007', '209405008',
        '209406009', '209407000', '209827006', '209828001', '209829009', '209830004', '209834008',
        '209843004', '209845006', '209847003', '209848008', '209849000', '209850000', '209864000',
        '209865004', '209866003', '209867007', '209868002', '209871005', '209881009', '209883007',
        '209884001', '209885000', '209886004', '209887008', '209900006', '209902003', '209903008',
        '209904002', '209905001', '209906000', '209920007', '209921006', '209922004', '209923009',
        '209924003', '209940000', '209956005', '209958006', '209978003', '209987007', '210038008',
        '210039000', '210051003', '210052005', '210060006', '210063008', '210064002', '210067009',
        '210073005', '210076002', '210078001', '210083009', '210084003', '210086001', '210087005',
        '210088000', '210089008', '210093002', '210094008', '210095009', '210104002', '210106000',
        '210114006', '210116008', '210128000', '210130003', '210131004', '210132006', '210133001',
        '210135008', '210150004', '210155009', '210156005', '210157001', '210159003', '210160008',
        '210173007', '210174001', '210175000', '210176004', '210180009', '210188002', '210191002',
        '210192009', '210197003', '210203000', '210205007', '210206008', '210213008', '210216000',
        '210217009', '210220001', '210221002', '210222009', '210229000', '210241007', '210242000',
        '210243005', '210244004', '210245003', '210260000', '210262008', '210263003', '210272006',
        '210679005', '210680008', '210706009', '210782008', '210915008', '210916009', '210931000',
        '210937001', '210942009', '210950000', '210951001', '210952008', '210953003', '210954009',
        '210955005', '210957002', '210958007', '210959004', '210960009', '210961008', '210962001',
        '210963006', '210964000', '210965004', '210966003', '210967007', '210973008', '210974002',
        '210975001', '210976000', '212169004', '212171004', '212172006', '212173001', '212174007',
        '212177000', '212178005', '212179002', '212180004', '212183002', '212185009', '212186005',
        '212187001', '212188006', '212190007', '212194003', '212197005', '212198000', '212199008',
        '212200006', '212201005', '212202003', '212203008', '212205001', '212206000', '212207009',
        '212208004', '212209007', '212210002', '212211003', '212212005', '212213000', '212214006',
        '212215007', '212216008', '212217004', '212218009', '212219001', '212220007', '212221006',
        '212222004', '212223009', '212224003', '212225002', '212226001', '212227005', '212247002',
        '212296007', '212380006', '212381005', '212382003', '212383008', '212384002', '212385001',
        '212386000', '212399002', '212400009', '212421009', '212451003', '212456008', '212467009',
        '212469007', '212470008', '212471007', '212472000', '212473005', '212483009', '212486001',
        '212489008', '213346004', '213347008', '213350006', '213351005', '213354002', '213355001',
        '213358004', '213361003', '213375005', '213387003', '21351003', '21369007', '21419000',
        '21454007', '21573009', '21580006', '21698002', '21763005', '21835004', '21867001',
        '21949009', '21978005', '22000002', '2202000', '22025006', '22095002', '22225000',
        '22234005', '22383006', '22564003', '22682006', '22693008', '22713002', '22724000',
        '22802006', '22819008', '22825007', '22897006', '22911007', '2295008', '22973003',
        '23020007', '23026001', '23039002', '23055009', '230614002', '23123006', '231813003',
        '232265009', '232277004', '232278009', '232279001', '23283004', '23368007', '233975007',
        '23406007', '235627001', '235698003', '235887001', '23589004', '23611004', '236431008',
        '23658007', '2366001', '23697004', '237090005', '23713006', '23741005', '237573009',
        '237660002', '23813004', '23900009', '239750008', '239755003', '239756002', '240037007',
        '240127000', '24056002', '24063002', '24179004', '241989005', '242007009', '24212007',
        '24300005', '24350003', '24380008', '24392008', '24424003', '24850009', '24948002',
        '25110002', '25185004', '25331007', '25345001', '25415003', '25420003', '25424007',
        '25427000', '25529004', '25554004', '25586009', '25689009', '25899002', '26176009',
        '262520005', '262521009', '262522002', '262525000', '262626005', '262675006', '262683000',
        '262687004', '262688009', '262689001', '262691009', '262692002', '262693007', '262696004',
        '262697008', '262700007', '262705002', '262706001', '262707005', '262708000', '262709008',
        '262710003', '262711004', '262712006', '262713001', '262714007', '262717000', '262718005',
        '262719002', '262724004', '262725003', '262726002', '262727006', '262729009', '262730004',
        '262731000', '262732007', '262734008', '262735009', '262736005', '262737001', '262740001',
        '262741002', '262742009', '262743004', '262745006', '262746007', '262747003', '262748008',
        '262768002', '262775001', '262778004', '262780005', '262782002', '262783007', '262784001',
        '262785000', '262787008', '262788003', '262791003', '262792005', '262793000', '262795007',
        '262799001', '262801003', '262802005', '262803000', '262804006', '262805007', '262809001',
        '262810006', '262811005', '262812003', '262813008', '262815001', '262816000', '262820001',
        '262821002', '262822009', '262823004', '262824005', '262827003', '262828008', '262829000',
        '262830005', '262831009', '262833007', '262834001', '262835000', '262836004', '262845003',
        '262849009', '262850009', '262851008', '262853006', '262854000', '262855004', '262856003',
        '262857007', '262859005', '262860000', '262862008', '262863003', '262864009', '262866006',
        '262867002', '262868007', '262869004', '262871004', '262872006', '262873001', '262874007',
        '262875008', '262877000', '262878005', '262879002', '262881000', '262882007', '262883002',
        '262884008', '262885009', '262886005', '262887001', '262888006', '262889003', '262893009',
        '262897005', '262898000', '262900003', '262907000', '262911006', '262912004', '262913009',
        '262914003', '262915002', '262916001', '262918000', '262919008', '262920002', '262926008',
        '262928009', '262931005', '262932003', '262933008', '262952002', '262955000', '263004001',
        '263009006', '263010001', '263011002', '263012009', '263013004', '263014005', '263015006',
        '263017003', '263019000', '263020006', '263021005', '263022003', '263023008', '263024002',
        '263025001', '263026000', '263027009', '263028004', '263029007', '263030002', '263031003',
        '263034006', '263035007', '263036008', '263037004', '263038009', '263039001', '263040004',
        '263041000', '263042007', '263043002', '263044008', '263045009', '263046005', '263047001',
        '263048006', '263049003', '263050003', '263051004', '263052006', '263053001', '263054007',
        '263055008', '263056009', '263057000', '263058005', '263059002', '263060007', '263061006',
        '263062004', '263063009', '263064003', '263065002', '263066001', '263067005', '263068000',
        '263069008', '263070009', '263071008', '263072001', '263073006', '263074000', '263075004',
        '263076003', '263077007', '263078002', '263079005', '263080008', '263081007', '263082000',
        '263083005', '263084004', '263085003', '263086002', '263087006', '263088001', '263089009',
        '263090000', '263091001', '263092008', '263093003', '263094009', '263095005', '263096006',
        '263097002', '263098007', '263099004', '263100007', '263101006', '263102004', '263103009',
        '263104003', '263105002', '263106001', '263108000', '263109008', '263110003', '263111004',
        '263112006', '263113001', '263114007', '263115008', '263116009', '263117000', '263126002',
        '263148008', '263149000', '263150000', '263151001', '263152008', '263153003', '263154009',
        '263155005', '263156006', '263157002', '263158007', '263159004', '263160009', '263161008',
        '263162001', '263163006', '263164000', '263165004', '263166003', '263167007', '263168002',
        '263169005', '263170006', '263171005', '263172003', '263173008', '263174002', '263175001',
        '263176000', '263177009', '263178004', '263179007', '263180005', '263188003', '263189006',
        '263191003', '263192005', '263193000', '263195007', '263196008', '263197004', '263198009',
        '263199001', '263200003', '263201004', '263203001', '263204007', '263205008', '263206009',
        '263207000', '263208005', '263209002', '263210007', '263211006', '263216001', '263217005',
        '263218000', '263219008', '263220002', '263221003', '263222005', '263225007', '263226008',
        '263227004', '263228009', '263229001', '263231005', '263232003', '263233008', '263234002',
        '263235001', '263236000', '263237009', '263238004', '263239007', '263240009', '263241008',
        '263242001', '263244000', '263245004', '263246003', '263247007', '263248002', '263249005',
        '263250005', '263251009', '263252002', '263253007', '263256004', '263257008', '263262009',
        '263263004', '263264005', '263265006', '263266007', '263267003', '263268008', '263269000',
        '263274008', '26442006', '264534009', '2651006', '26646003', '26738009', '269057007',
        '269061001', '269062008', '269063003', '269064009', '269065005', '269066006', '269067002',
        '269068007', '269069004', '269070003', '269071004', '269072006', '269073001', '269074007',
        '269075008', '269076009', '269077000', '269078005', '269080004', '26908008', '269081000',
        '269083002', '269090007', '269100000', '269103003', '269105005', '269106006', '269107002',
        '269108007', '269111008', '269112001', '269114000', '269115004', '269116003', '269117007',
        '269118002', '269119005', '269120004', '269121000', '269122007', '269123002', '269124008',
        '269125009', '269126005', '269127001', '269128006', '269129003', '269144002', '269151006',
        '269160003', '269187004', '269188009', '269191009', '26938002', '269406001', '27094009',
        '271576001', '271577005', '27158007', '271963003', '274153008', '274154002', '274155001',
        '274156000', '274157009', '274158004', '274160002', '274164006', '274174009', '274175005',
        '27477003', '275272006', '275320004', '275329003', '275331007', '275332000', '275333005',
        '275337006', '275338001', '275339009', '275340006', '275341005', '275342003', '275343008',
        '275361004', '275362006', '275380002', '275382005', '275430007', '27644009', '276464002',
        '277326006', '278488007', '278537006', '279057008', '27923006', '27937002', '28012007',
        '28048009', '28078000', '28081005', '281502009', '281503004', '281504005', '281506007',
        '281513007', '281514001', '281515000', '281516004', '281517008', '281518003', '281519006',
        '281525005', '281526006', '281527002', '281528007', '281529004', '281530009', '281531008',
        '281532001', '281533006', '281534000', '281535004', '281536003', '28155008', '28156009',
        '281843000', '28188001', '281907005', '281908000', '281909008', '281910003', '281911004',
        '281912006', '281913001', '281914007', '281915008', '281916009', '281917000', '281918005',
        '281919002', '281920008', '281921007', '281922000', '281923005', '281924004', '281925003',
        '281926002', '281927006', '281928001', '281929009', '281930004', '281931000', '281932007',
        '281933002', '281934008', '281935009', '281936005', '281937001', '281938006', '281940001',
        '281941002', '282007005', '282050000', '282051001', '282053003', '282055005', '282059004',
        '282062001', '282063006', '282064000', '282066003', '282070006', '282072003', '282076000',
        '282077009', '282085000', '282429000', '282430005', '282431009', '282432002', '282434001',
        '282438003', '282439006', '282446002', '282447006', '282448001', '282463003', '282723003',
        '282725005', '282745002', '282749008', '282751007', '282752000', '282754004', '282755003',
        '282756002', '282757006', '282758001', '282759009', '282762007', '282763002', '282764008',
        '282765009', '282766005', '282771003', '282773000', '282783001', '282784007', '282785008',
        '282786009', '282787000', '28359007', '283905005', '283906006', '283908007', '283909004',
        '283915004', '283916003', '283918002', '283920004', '283922007', '283928006', '283930008',
        '283937006', '283939009', '283940006', '283942003', '283956001', '283957005', '283959008',
        '283961004', '283963001', '283964007', '283979000', '283980002', '28398002', '283981003',
        '283985007', '283998003', '283999006', '284000008', '2840008', '284003005', '284005003',
        '284006002', '28425007', '284346004', '285234008', '285235009', '285236005', '285239003',
        '285668009', '28576007', '285806007', '285807003', '285808008', '285830009', '285834000',
        '287093006', '287094000', '287096003', '287101003', '287154000', '28753006', '288280006',
        '288281005', '288282003', '288283008', '29014003', '29045004', '29264003', '295723007',
        '29635000', '29691006', '297130008', '297131007', '297132000', '297133005', '297158000',
        '2973002', '29749002', '29807001', '29818001', '29880001', '2999009', '299965004',
        '30031007', '30060003', '301032005', '301033000', '301034006', '301035007', '301757009',
        '3019000', '302034009', '302035005', '302036006', '302037002', '302038007', '302222008',
        '302232001', '302964004', '30371007', '304236004', '30489009', '30632004', '307131005',
        '307137009', '307171000', '307172007', '307178006', '307218005', '307712005', '307713000',
        '307727005', '308153009', '30858001', '30905007', '30943005', '309464009', '31033002',
        '31062001', '31103006', '31110000', '311408004', '311409007', '311814002', '311815001',
        '311816000', '311817009', '311819007', '311820001', '311821002', '311822009', '311825006',
        '311826007', '311827003', '311829000', '311831009', '311842000', '311844004', '311847006',
        '311848001', '311849009', '311850009', '311852001', '311853006', '311857007', '311859005',
        '311862008', '311864009', '31187005', '3119002', '31235003', '312660000', '312661001',
        '312662008', '312786001', '312787005', '312788000', '312792007', '312837005', '312838000',
        '312839008', '312844001', '312847008', '314195000', '314197008', '314198003', '314661000',
        '314662007', '314664008', '314667001', '314668006', '315643003', '316358009', '31693001',
        '31882001', '31975004', '31978002', '31984004', '320934008', '32106001', '32144005',
        '3217005', '3228009', '32311009', '32415004', '32497008', '32734003', '32805004',
        '32910