#  Authors: Sylvain Marie <sylvain.marie@se.com>
#
#  License: BSD 3 clause

from getversion.main import get_module_version, DetailedResults, ModuleVersionNotFound

try:
    # import version from _version.py generated by setuptools_scm
    from getversion._version import version as _v
    __version__ = _v
except ImportError:
    # use setuptools_scm to get the current version using git
    # we do not use this because our tests rely on the fact that this is NOT done correctly :)
    # from setuptools_scm import get_version as _gv
    # from os import path as _path
    # __version__ = _gv(_path.join(_path.dirname(__file__), _path.pardir))
    pass

__all__ = [
    # submodules
    'main',
    # symbols imported above
    'get_module_version', 'DetailedResults', 'ModuleVersionNotFound'
]
