# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2018-07-11 11:40
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Callback',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('update_datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('create_datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('target_url', models.URLField(max_length=512)),
                ('headers', models.TextField(blank=True, null=True)),
                ('payload', models.TextField(blank=True, null=True)),
                ('content_type', models.CharField(blank=True, max_length=128, null=True)),
                ('http_method', models.CharField(blank=True, choices=[('POST', 'POST'), ('PUT', 'PUT'), ('PATCH', 'PATCH'), ('GET', 'GET'), ('DELETE', 'DELETE')], max_length=64, null=True)),
                ('status', models.CharField(blank=True, choices=[('waiting', 'waiting'), ('sent', 'sent'), ('error', 'error')], default='waiting', max_length=64, null=True)),
                ('status_details', models.CharField(blank=True, max_length=512, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Hook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=512, null=True)),
                ('update_datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('create_datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('enabled', models.BooleanField(default=True)),
                ('target_url', models.URLField(max_length=512)),
                ('http_method', models.CharField(choices=[('POST', 'POST'), ('PUT', 'PUT'), ('PATCH', 'PATCH'), ('GET', 'GET'), ('DELETE', 'DELETE')], default='POST', max_length=64)),
                ('headers', models.TextField(blank=True, help_text='Headers should be pairs of key & value seperated by ":" and each pair should be in a new row. E.g: api-key: 12345 ', null=True)),
                ('payload_template', models.TextField(blank=True, help_text='Use {{}} for variables template. Placeholder names can be any attribute in the model using a prefix of "instance.". Leave empty for default payload. See documentation for further details.  ', null=True)),
                ('serializer_class', models.CharField(blank=True, help_text='Full path of the serializer class. Leave empty for default payload.', max_length=256, null=True)),
                ('content_type', models.CharField(blank=True, choices=[('application/json', 'application/json'), ('application/xml', 'application/xml'), ('text/xml', 'text/xml'), ('text/plain', 'text/plain'), ('application/javascript', 'application/javascript'), ('text/html', 'text/html')], max_length=128, null=True)),
                ('model', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='Signal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('signal', models.CharField(help_text='Full path of the signal class', max_length=256, unique=True)),
                ('update_time', models.DateTimeField(auto_now_add=True, null=True)),
                ('create_datetime', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='hook',
            name='signals',
            field=models.ManyToManyField(to='hooks.Signal'),
        ),
        migrations.AddField(
            model_name='callback',
            name='hook',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='hooks.Hook'),
        ),
    ]
