import { CartesianFrame } from "../canvas/cartesian_frame";
import { Canvas, CanvasView, FrameBox } from "../canvas/canvas";
import { Range } from "../ranges/range";
import { Renderer, RendererView } from "../renderers/renderer";
import { DataRenderer } from "../renderers/data_renderer";
import { Tool, ToolView } from "../tools/tool";
import { Selection } from "../selections/selection";
import { LayoutDOM, LayoutDOMView } from "../layouts/layout_dom";
import { Plot } from "./plot";
import { Title } from "../annotations/title";
import { AxisView } from "../axes/axis";
import { ToolbarPanel } from "../annotations/toolbar_panel";
import { Interval } from "../../core/types";
import { Signal0 } from "../../core/signaling";
import { UIEvents } from "../../core/ui_events";
import { RenderLevel } from "../../core/enums";
import { Context2d } from "../../core/util/canvas";
import { SizingPolicy } from "../../core/layout";
import { BorderLayout } from "../../core/layout/border";
import { BBox } from "../../core/util/bbox";
export declare type RangeInfo = {
    xrs: Map<string, Interval>;
    yrs: Map<string, Interval>;
};
export declare type StateInfo = {
    range?: RangeInfo;
    selection: Map<DataRenderer, Selection>;
    dimensions: {
        width: number;
        height: number;
    };
};
export declare class PlotView extends LayoutDOMView {
    model: Plot;
    visuals: Plot.Visuals;
    layout: BorderLayout;
    frame: CartesianFrame;
    canvas: Canvas;
    canvas_view: CanvasView;
    protected _title: Title;
    protected _toolbar: ToolbarPanel;
    protected _outer_bbox: BBox;
    protected _inner_bbox: BBox;
    protected _needs_paint: boolean;
    protected _needs_layout: boolean;
    protected _invalidated_painters: Set<RendererView>;
    protected _invalidate_all: boolean;
    state_changed: Signal0<this>;
    visibility_callbacks: ((visible: boolean) => void)[];
    protected _is_paused?: number;
    protected lod_started: boolean;
    protected _initial_state_info: StateInfo;
    protected state: {
        history: {
            type: string;
            info: StateInfo;
        }[];
        index: number;
    };
    protected throttled_paint: () => void;
    protected ui_event_bus: UIEvents;
    computed_renderers: Renderer[];
    renderer_views: Map<Renderer, RendererView>;
    tool_views: Map<Tool, ToolView>;
    protected range_update_timestamp?: number;
    get is_paused(): boolean;
    get child_models(): LayoutDOM[];
    pause(): void;
    unpause(no_render?: boolean): void;
    request_render(): void;
    request_paint(to_invalidate?: RendererView): void;
    request_layout(): void;
    reset(): void;
    remove(): void;
    render(): void;
    initialize(): void;
    lazy_initialize(): Promise<void>;
    protected _width_policy(): SizingPolicy;
    protected _height_policy(): SizingPolicy;
    _update_layout(): void;
    get axis_views(): AxisView[];
    set_cursor(cursor?: string): void;
    set_toolbar_visibility(visible: boolean): void;
    update_dataranges(): void;
    push_state(type: string, new_info: Partial<StateInfo>): void;
    clear_state(): void;
    can_undo(): boolean;
    can_redo(): boolean;
    undo(): void;
    redo(): void;
    protected _do_state_change(index: number): void;
    get_selection(): Map<DataRenderer, Selection>;
    update_selection(selections: Map<DataRenderer, Selection> | null): void;
    reset_selection(): void;
    protected _update_ranges_together(range_info_iter: [Range, Interval][]): void;
    protected _update_ranges_individually(range_info_iter: [Range, Interval][], is_panning: boolean, is_scrolling: boolean, maintain_focus: boolean): void;
    protected _get_weight_to_constrain_interval(rng: Range, range_info: Interval): number;
    update_range(range_info: RangeInfo | null, is_panning?: boolean, is_scrolling?: boolean, maintain_focus?: boolean): void;
    reset_range(): void;
    protected _invalidate_layout(): void;
    get_renderer_views(): RendererView[];
    build_renderer_views(): Promise<void>;
    build_tool_views(): Promise<void>;
    connect_signals(): void;
    set_initial_range(): void;
    has_finished(): boolean;
    after_layout(): void;
    repaint(): void;
    paint(): void;
    protected _paint_levels(ctx: Context2d, level: RenderLevel, clip_region: FrameBox, global_clip: boolean): void;
    protected _map_hook(_ctx: Context2d, _frame_box: FrameBox): void;
    protected _paint_empty(ctx: Context2d, frame_box: FrameBox): void;
    protected _paint_outline(ctx: Context2d, frame_box: FrameBox): void;
    to_blob(): Promise<Blob>;
    serializable_state(): {
        [key: string]: unknown;
    };
}
