"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const manifest_writer_1 = require("./manifest-writer");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const constructs_1 = require("constructs");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        aws_cdk_lib_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const snapshotDir = session.assembly.outdir;
                const manifest = {
                    version: '',
                    testCases: { [id]: toTestCase(props) },
                };
                manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
            },
        });
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.21.0-alpha.0" };
function toTestCase(props) {
    return {
        ...props,
        stacks: props.stacks.map(s => s.artifactId),
    };
}
//# sourceMappingURL=data:application/json;base64,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