# Generated by Django 3.1.12 on 2021-07-13 19:24

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("eveonline", "0014_auto_20210105_1413"),
        ("eveuniverse", "0005_type_materials_and_sections"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("structuretimers", "0001_initial"),
    ]

    operations = [
        migrations.AlterField(
            model_name="schedulednotification",
            name="notification_rule",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="scheduled_notifications",
                to="structuretimers.notificationrule",
            ),
        ),
        migrations.AlterField(
            model_name="schedulednotification",
            name="timer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="scheduled_notifications",
                to="structuretimers.timer",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="eve_alliance",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Alliance of the user who created this timer",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="eve_character",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Main character of the user who created this timer",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveonline.evecharacter",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="eve_corporation",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Corporation of the user who created this timer",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="eve_solar_system",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveuniverse.evesolarsystem",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="structure_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveuniverse.evetype",
            ),
        ),
        migrations.AlterField(
            model_name="timer",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.CreateModel(
            name="StagingSystem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_main", models.BooleanField(default=False)),
                (
                    "eve_solar_system",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evesolarsystem",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="DistancesFromStaging",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("light_years", models.FloatField(blank=True, default=None, null=True)),
                (
                    "jumps",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "staging_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="distances",
                        to="structuretimers.stagingsystem",
                    ),
                ),
                (
                    "timer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="distances",
                        to="structuretimers.timer",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="distancesfromstaging",
            constraint=models.UniqueConstraint(
                fields=("timer", "staging_system"), name="fpk_distances_from_staging"
            ),
        ),
    ]
