# Generated by sila2.code_generator; sila2.__version__: 0.8.1
from __future__ import annotations

from abc import ABC, abstractmethod
from typing import List

from sila2.server import FeatureImplementationBase, MetadataDict

from .authenticationservice_types import Login_Responses, Logout_Responses


class AuthenticationServiceBase(FeatureImplementationBase, ABC):
    @abstractmethod
    def Login(
        self,
        UserIdentification: str,
        Password: str,
        RequestedServer: str,
        RequestedFeatures: List[str],
        *,
        metadata: MetadataDict,
    ) -> Login_Responses:
        """
        Provides an access token based on user information.


        :param UserIdentification: The user identification string (e.g. a user name)

        :param Password: The password

        :param RequestedServer: The ServerUUID of the server for which an authorization is requested.

        :param RequestedFeatures: The fully qualified identifiers of features that are requested to access. If no feature is provided, this means that all features are requested.

        :param metadata: The SiLA Client Metadata attached to the call

        :return:

            - AccessToken: The token to be used along with accessing a Command or Property on a SiLA Server.

            - TokenLifetime:
        The lifetime (in seconds) of the provided access token as the maximum validity period after the last SiLA Server
        request.



        """
        pass

    @abstractmethod
    def Logout(self, AccessToken: str, *, metadata: MetadataDict) -> Logout_Responses:
        """
        Invalidates the given access token immediately.


        :param AccessToken: The access token to be invalidated.

        :param metadata: The SiLA Client Metadata attached to the call

        """
        pass
