"""Constants containing IUPAC codes for RNA sequences.

"""

from typing import List

__all__ = ["RNA_BASES"]

RNA_BASES: List[str] = [
    "A",  # Adenine
    "C",  # Cytosine
    "G",  # Guanine
    "U",  # Uracil
]
"""List[str]: The four RNA bases.

.. csv-table:: 
   :header: "Symbol", "Description"
   :widths: 5, 10
   
    "A",  "Adenine"
    "C",  "Cytosine"
    "G",  "Guanine"
    "U",  "Uracil"

"""
