# Changelog

All notable changes to this project will be documented here.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project attempts to adhere to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v0.1.2](https://github.com/engineervix/readme-coverage-badger/compare/v0.1.1...v0.1.2) (2022-01-21)


### 📝 Docs

* **changelog:** add note on version 0.1.0 ([7e7b8a6](https://github.com/engineervix/readme-coverage-badger/commit/7e7b8a6d77c29878d9e65e366a7633d1f7a85ccf))
* **changelog:** regenerate using [standard-version](https://github.com/conventional-changelog/standard-version) ([90da4da](https://github.com/engineervix/readme-coverage-badger/commit/90da4da6bd3440f528ed3e8f2b9d452ad7c1fb81))
* **readme:** add a GIF to demonstrate the tool ([82afdbe](https://github.com/engineervix/readme-coverage-badger/commit/82afdbeffe125cea3ef66e84af03d1c5d0eee926))
* **readme:** general reorganisation of the docs – centre the badges, categorize the TODOs and add some minor improvements ([d46fcbb](https://github.com/engineervix/readme-coverage-badger/commit/d46fcbb59b427700f34f9faebfdc92be28fbf61b))


### 💄 Styling

* **changelog:** move <hr> to the end of the file ([aa9b442](https://github.com/engineervix/readme-coverage-badger/commit/aa9b44220c757246a369a0558226ebe434daeb50))
* update changelog configuration ([0e0fd06](https://github.com/engineervix/readme-coverage-badger/commit/0e0fd0608412665fe080adffd2c86fd3ddbe410e))


### ⚙️ Build System

* **deps-dev:** bump faker from 8.9.1 to 8.10.0 ([#3](https://github.com/engineervix/readme-coverage-badger/issues/3)) ([63c50d9](https://github.com/engineervix/readme-coverage-badger/commit/63c50d974a7ae16124d886f88525aa24ec588c98))
* **deps-dev:** bump invoke from 1.5.0 to 1.6.0 ([#5](https://github.com/engineervix/readme-coverage-badger/issues/5)) ([f62aa4e](https://github.com/engineervix/readme-coverage-badger/commit/f62aa4e02df76def5539d8de104731904e40b9fa))
* **deps-dev:** bump isort from 5.9.1 to 5.9.2 ([#4](https://github.com/engineervix/readme-coverage-badger/issues/4)) ([81837d2](https://github.com/engineervix/readme-coverage-badger/commit/81837d2ba942e61180f4f3c5ffed178f8e1ac7fb))
* **deps-dev:** update outdated packages ([45bd516](https://github.com/engineervix/readme-coverage-badger/commit/45bd516bd226fb4d73c2ba0197b3a04fa0fba68e))
* **deps-dev:** update precommit hook commitizen-tools/commitizen to v2.17.12 ([63cf405](https://github.com/engineervix/readme-coverage-badger/commit/63cf405872557b4086e5b8b9ca4dfb7acaa90646))
* **deps-dev:** update precommit hook commitizen-tools/commitizen to v2.17.13 ([69b65cc](https://github.com/engineervix/readme-coverage-badger/commit/69b65ccae0d2767c8ddec04019a5d25b46321280))
* **deps-dev:** update precommit hook commitizen-tools/commitizen to v2.18.0 ([50a946f](https://github.com/engineervix/readme-coverage-badger/commit/50a946ffc186ea63ed4338647e19b5c78ba03c6a))
* **deps-dev:** update precommit hook pre-commit/mirrors-isort to v5.9.2 ([922f932](https://github.com/engineervix/readme-coverage-badger/commit/922f9326e47612a4ce600156b64cceb13babb278))
* **deps-dev:** update precommit hook pycqa/isort to v5.9.3 ([300dd31](https://github.com/engineervix/readme-coverage-badger/commit/300dd317ea2ae8346cb2334f8453744884f58819))


### 🐛 Bug Fixes

* enforce coverage<6 and ensure python 3.10 support ([e2c2f92](https://github.com/engineervix/readme-coverage-badger/commit/e2c2f92e5d4d2bc422d7029e2cced96083d7058a))


### 👷 CI/CD

* add `renovate.json` ([#6](https://github.com/engineervix/readme-coverage-badger/issues/6)) ([194b29e](https://github.com/engineervix/readme-coverage-badger/commit/194b29ea4b137774e8f1a0cb953462e8f1d2ffbb))
* add GH action to greet first-time contributors ([8085515](https://github.com/engineervix/readme-coverage-badger/commit/80855154f24c3239485738a9204a089474bb000a))
* add manually triggered workflow ([c8b3e66](https://github.com/engineervix/readme-coverage-badger/commit/c8b3e66e21fa857da7c72f19e0442e36d764e3a1))
* add the lint job to python 3.8 on TRavis CI ([0d20cbf](https://github.com/engineervix/readme-coverage-badger/commit/0d20cbf9ebd244a739360aa67f8f4a172351fbef))
* correct the Travis CI config to support PEP 517 builds ([9e476a1](https://github.com/engineervix/readme-coverage-badger/commit/9e476a1211d232516d1c90416c42142add8ab729))
* customize renovate config to allow automatic dependency management ([8fcc766](https://github.com/engineervix/readme-coverage-badger/commit/8fcc766910feae114ebdeb7e6cc7e695e3557a3f))
* disable publishing to testPyPI ([00c8783](https://github.com/engineervix/readme-coverage-badger/commit/00c87838a1007037bfbd7221c0d4018412fbe5a6))
* improved release workfow through some custom hacks ([ee12b8e](https://github.com/engineervix/readme-coverage-badger/commit/ee12b8e22d2d084d0ad8f1a8a3663f4a8c62d4c5))
* pre-commit autoupdate ([#10](https://github.com/engineervix/readme-coverage-badger/issues/10)) ([c4a52df](https://github.com/engineervix/readme-coverage-badger/commit/c4a52dffb0dbee881971935b8eb52f4fdf1fcbd6))
* **pre-commit.ci:** pre-commit autoupdate ([#12](https://github.com/engineervix/readme-coverage-badger/issues/12)) ([94c2929](https://github.com/engineervix/readme-coverage-badger/commit/94c2929d5b3ed6b847f7092b1c15b805795d44f3))
* remove `dependabot.yml` configuration file ([bc0568b](https://github.com/engineervix/readme-coverage-badger/commit/bc0568badcf3491c6b5fd03397abb051bf54e36b))
* **renovate.json:** fix configuration ([#9](https://github.com/engineervix/readme-coverage-badger/issues/9)) ([14dd8b3](https://github.com/engineervix/readme-coverage-badger/commit/14dd8b360e2b759c375474e585fb917f86ddb8b6))
* run tests on GNU/Linux, Mac OS X and Windows ([2a2b446](https://github.com/engineervix/readme-coverage-badger/commit/2a2b446ef756edc0f8ea1d6a0ee9803c77b28174))
* run tests on Python 3.10 ([6e93962](https://github.com/engineervix/readme-coverage-badger/commit/6e9396246f40d015f854632d9304149e973ebf38))
* switch from Travis CI to GitHub Actions ([ba1b1fb](https://github.com/engineervix/readme-coverage-badger/commit/ba1b1fb39deb71575b8e178189a509e5fde59b2c))
* **travis:** revert to the initial setup defined in f53d6a ([4db1f32](https://github.com/engineervix/readme-coverage-badger/commit/4db1f3292329e9ea9a3c8e6c4fed59933ad54dd5))

## [v0.1.1](https://github.com/engineervix/readme-coverage-badger/compare/v0.1.0...v0.1.1) (2021-07-07)


### 📝 Docs

* **readme:** additional badges showing PyPi download stats, supported Python versions and commit activity ([5c735b2](https://github.com/engineervix/readme-coverage-badger/commit/5c735b2a88c0423a937afb03dd900ed824e58b32))
* **readme:** correct the Travis CI Badge URL to point to the master branch ([275443e](https://github.com/engineervix/readme-coverage-badger/commit/275443e2a3711c1d2687f08d9b14f3f191f3ac61))
* **readme:** fix typo in opening paragraph of "Why this Project?" ([118f9ba](https://github.com/engineervix/readme-coverage-badger/commit/118f9ba30788cbdb0d822fdc994f033c4e67851c))
* **readme:** minor grammar improvements ([ad63721](https://github.com/engineervix/readme-coverage-badger/commit/ad6372176f4dfb6e24921af1751bd1562fd16d8a))


### ⚙️ Build System / Dependencies

* **deps-dev:** bump commitizen from 2.17.11 to 2.17.12 ([#2](https://github.com/engineervix/readme-coverage-badger/issues/2)) ([9e769fd](https://github.com/engineervix/readme-coverage-badger/commit/9e769fdf2016b7101a13bfad1d50cd3b552aee5b))


### 🛠 Miscellaneous

* deploy on PyPi only when you create (and push) new tags on master ([c34224f](https://github.com/engineervix/readme-coverage-badger/commit/c34224f0beb24470b75a1cc0b4f98d396849dcb9))
* **pyproject.toml:** make isort compatible with black, just like the pre-commit configuration ([ba0a438](https://github.com/engineervix/readme-coverage-badger/commit/ba0a4380184daa33bfe63399dfe00111b4795940))


### 🪠 Maintenance

* **travis:** replace __token__ with actual username ([87fddc2](https://github.com/engineervix/readme-coverage-badger/commit/87fddc26289c2afe05ebd04557e83c5962df40f7))


### 🐛 Bug Fixes

* bug in `readme_location` ([df68dc2](https://github.com/engineervix/readme-coverage-badger/commit/df68dc23bde654053b82a8abf6f55f81a7a0a636))

## [v0.1.0](https://github.com/engineervix/readme-coverage-badger/compare/8c618b...v0.1.0) (2021-07-06)


### 🪠 Maintenance

* automatic deployment on PyPi ([f53d6ae](https://github.com/engineervix/readme-coverage-badger/commit/f53d6ae33dde87788215f238086de28f04958e23))


### 🛠 Miscellaneous

* fix typo in repo name ([6d9cb11](https://github.com/engineervix/readme-coverage-badger/commit/6d9cb11ef5f6398c1ce501c5b8b2df391dfdff6f))
* fix typos on badge URLs ([d8b32ac](https://github.com/engineervix/readme-coverage-badger/commit/d8b32acba74a282aa38877e6af93e734252492b2))
* only install codecov on travis ([8a3bd55](https://github.com/engineervix/readme-coverage-badger/commit/8a3bd559d78ce7c810c4f3ffc5b9be5e1895e5cc))
* remove detect-aws-credentials hook ([4b571d8](https://github.com/engineervix/readme-coverage-badger/commit/4b571d87f7eb7d15d78ade48590de0ca277a3728))
* simplify travis setup, for now ([958aa6d](https://github.com/engineervix/readme-coverage-badger/commit/958aa6dfc6cf01a025aff05d250173b331df5e8d))
* use focal instead of default bionic ([5116bd6](https://github.com/engineervix/readme-coverage-badger/commit/5116bd602fcf78563272d886c24dac427b704638))
