# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSnapEmpty(PrettyPrint):
    def __init__(
            self,
            tick: int = 0,
            delta_tick: int = 0
    ) -> None:
        self.message_name = 'snap_empty'
        self.system_message = True
        self.header: ChunkHeader

        self.tick: int = tick
        self.delta_tick: int = delta_tick

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.tick = unpacker.get_int()
        self.delta_tick = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.tick) + \
            pack_int(self.delta_tick)