# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader

class MsgMapData(PrettyPrint):
    def __init__(
            self,
            data: bytes = b'\x00'
    ) -> None:
        self.message_name = 'map_data'
        self.system_message = True
        self.header: ChunkHeader

        self.data: bytes = data

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.data = unpacker.get_raw()
        return True

    def pack(self) -> bytes:
        return self.data