# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgInputTiming(PrettyPrint):
    def __init__(
            self,
            input_pred_tick: int = 0,
            time_left: int = 0
    ) -> None:
        self.message_name = 'input_timing'
        self.system_message = True
        self.header: ChunkHeader

        self.input_pred_tick: int = input_pred_tick
        self.time_left: int = time_left

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.input_pred_tick = unpacker.get_int()
        self.time_left = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.input_pred_tick) + \
            pack_int(self.time_left)