# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgInput(PrettyPrint):
    def __init__(
            self,
            ack_snapshot: int = 0,
            intended_tick: int = 0,
            input_size: int = 0,
            input: int = 0
    ) -> None:
        self.message_name = 'input'
        self.system_message = True
        self.header: ChunkHeader

        self.ack_snapshot: int = ack_snapshot
        self.intended_tick: int = intended_tick
        self.input_size: int = input_size
        self.input: int = input

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.ack_snapshot = unpacker.get_int()
        self.intended_tick = unpacker.get_int()
        self.input_size = unpacker.get_int()
        self.input = unpacker.get_int() # TODO: this is a snapshot object
        return True

    def pack(self) -> bytes:
        return pack_int(self.ack_snapshot) + \
            pack_int(self.intended_tick) + \
            pack_int(self.input_size) + \
            pack_int(self.input)