# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvTuneParams(PrettyPrint):
    def __init__(
            self,
            ground_control_speed: float = 10,
            ground_control_accel: float = 2,
            ground_friction: float = 0.5,
            ground_jump_impulse: float = 13.2,
            air_jump_impulse: float = 12,
            air_control_speed: float = 5,
            air_control_accel: float = 1.5,
            air_friction: float = 0.95,
            hook_length: float = 380,
            hook_fire_speed: float = 80,
            hook_drag_accel: float = 3,
            hook_drag_speed: float = 15,
            gravity: float = 0.5,
            velramp_start: float = 550,
            velramp_range: float = 2000,
            velramp_curvature: float = 1.4,
            gun_curvature: float = 1.25,
            gun_speed: float = 2200,
            gun_lifetime: float = 2,
            shotgun_curvature: float = 1.25,
            shotgun_speed: float = 2750,
            shotgun_speeddiff: float = 0.8,
            shotgun_lifetime: float = 0.2,
            grenade_curvature: float = 7,
            grenade_speed: float = 1000,
            grenade_lifetime: float = 2,
            laser_reach: float = 800,
            laser_bounce_delay: float = 150,
            laser_bounce_num: float = 1,
            laser_bounce_cost: float = 0,
            player_collision: float = 1,
            player_hooking: float = 1
    ) -> None:
        self.message_name = 'sv_tune_params'
        self.system_message = False
        self.header: ChunkHeader

        self.ground_control_speed: float = ground_control_speed
        self.ground_control_accel: float = ground_control_accel
        self.ground_friction: float = ground_friction
        self.ground_jump_impulse: float = ground_jump_impulse
        self.air_jump_impulse: float = air_jump_impulse
        self.air_control_speed: float = air_control_speed
        self.air_control_accel: float = air_control_accel
        self.air_friction: float = air_friction
        self.hook_length: float = hook_length
        self.hook_fire_speed: float = hook_fire_speed
        self.hook_drag_accel: float = hook_drag_accel
        self.hook_drag_speed: float = hook_drag_speed
        self.gravity: float = gravity
        self.velramp_start: float = velramp_start
        self.velramp_range: float = velramp_range
        self.velramp_curvature: float = velramp_curvature
        self.gun_curvature: float = gun_curvature
        self.gun_speed: float = gun_speed
        self.gun_lifetime: float = gun_lifetime
        self.shotgun_curvature: float = shotgun_curvature
        self.shotgun_speed: float = shotgun_speed
        self.shotgun_speeddiff: float = shotgun_speeddiff
        self.shotgun_lifetime: float = shotgun_lifetime
        self.grenade_curvature: float = grenade_curvature
        self.grenade_speed: float = grenade_speed
        self.grenade_lifetime: float = grenade_lifetime
        self.laser_reach: float = laser_reach
        self.laser_bounce_delay: float = laser_bounce_delay
        self.laser_bounce_num: float = laser_bounce_num
        self.laser_bounce_cost: float = laser_bounce_cost
        self.player_collision: float = player_collision
        self.player_hooking: float = player_hooking

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.ground_control_speed = unpacker.get_int() / 100.0
        self.ground_control_accel = unpacker.get_int() / 100.0
        self.ground_friction = unpacker.get_int() / 100.0
        self.ground_jump_impulse = unpacker.get_int() / 100.0
        self.air_jump_impulse = unpacker.get_int() / 100.0
        self.air_control_speed = unpacker.get_int() / 100.0
        self.air_control_accel = unpacker.get_int() / 100.0
        self.air_friction = unpacker.get_int() / 100.0
        self.hook_length = unpacker.get_int() / 100.0
        self.hook_fire_speed = unpacker.get_int() / 100.0
        self.hook_drag_accel = unpacker.get_int() / 100.0
        self.hook_drag_speed = unpacker.get_int() / 100.0
        self.gravity = unpacker.get_int() / 100.0
        self.velramp_start = unpacker.get_int() / 100.0
        self.velramp_range = unpacker.get_int() / 100.0
        self.velramp_curvature = unpacker.get_int() / 100.0
        self.gun_curvature = unpacker.get_int() / 100.0
        self.gun_speed = unpacker.get_int() / 100.0
        self.gun_lifetime = unpacker.get_int() / 100.0
        self.shotgun_curvature = unpacker.get_int() / 100.0
        self.shotgun_speed = unpacker.get_int() / 100.0
        self.shotgun_speeddiff = unpacker.get_int() / 100.0
        self.shotgun_lifetime = unpacker.get_int() / 100.0
        self.grenade_curvature = unpacker.get_int() / 100.0
        self.grenade_speed = unpacker.get_int() / 100.0
        self.grenade_lifetime = unpacker.get_int() / 100.0
        self.laser_reach = unpacker.get_int() / 100.0
        self.laser_bounce_delay = unpacker.get_int() / 100.0
        self.laser_bounce_num = unpacker.get_int() / 100.0
        self.laser_bounce_cost = unpacker.get_int() / 100.0
        self.player_collision = unpacker.get_int() / 100.0
        self.player_hooking = unpacker.get_int() / 100.0
        return True

    def pack(self) -> bytes:
        return pack_int(int(self.ground_control_speed * 100.0)) + \
            pack_int(int(self.ground_control_accel * 100.0)) + \
            pack_int(int(self.ground_friction * 100.0)) + \
            pack_int(int(self.ground_jump_impulse * 100.0)) + \
            pack_int(int(self.air_jump_impulse * 100.0)) + \
            pack_int(int(self.air_control_speed * 100.0)) + \
            pack_int(int(self.air_control_accel * 100.0)) + \
            pack_int(int(self.air_friction * 100.0)) + \
            pack_int(int(self.hook_length * 100.0)) + \
            pack_int(int(self.hook_fire_speed * 100.0)) + \
            pack_int(int(self.hook_drag_accel * 100.0)) + \
            pack_int(int(self.hook_drag_speed * 100.0)) + \
            pack_int(int(self.gravity * 100.0)) + \
            pack_int(int(self.velramp_start * 100.0)) + \
            pack_int(int(self.velramp_range * 100.0)) + \
            pack_int(int(self.velramp_curvature * 100.0)) + \
            pack_int(int(self.gun_curvature * 100.0)) + \
            pack_int(int(self.gun_speed * 100.0)) + \
            pack_int(int(self.gun_lifetime * 100.0)) + \
            pack_int(int(self.shotgun_curvature * 100.0)) + \
            pack_int(int(self.shotgun_speed * 100.0)) + \
            pack_int(int(self.shotgun_speeddiff * 100.0)) + \
            pack_int(int(self.shotgun_lifetime * 100.0)) + \
            pack_int(int(self.grenade_curvature * 100.0)) + \
            pack_int(int(self.grenade_speed * 100.0)) + \
            pack_int(int(self.grenade_lifetime * 100.0)) + \
            pack_int(int(self.laser_reach * 100.0)) + \
            pack_int(int(self.laser_bounce_delay * 100.0)) + \
            pack_int(int(self.laser_bounce_num * 100.0)) + \
            pack_int(int(self.laser_bounce_cost * 100.0)) + \
            pack_int(int(self.player_collision * 100.0)) + \
            pack_int(int(self.player_hooking * 100.0))