# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvServerSettings(PrettyPrint):
    def __init__(
            self,
            kick_vote: bool = False,
            kick_min: int = 0,
            spec_vote: bool = False,
            team_lock: bool = False,
            team_balance: bool = False,
            player_slots: int = 0
    ) -> None:
        self.message_name = 'sv_server_settings'
        self.system_message = False
        self.header: ChunkHeader

        self.kick_vote: bool = kick_vote
        self.kick_min: int = kick_min
        self.spec_vote: bool = spec_vote
        self.team_lock: bool = team_lock
        self.team_balance: bool = team_balance
        self.player_slots: int = player_slots

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.kick_vote = unpacker.get_int() == 1
        self.kick_min = unpacker.get_int()
        self.spec_vote = unpacker.get_int() == 1
        self.team_lock = unpacker.get_int() == 1
        self.team_balance = unpacker.get_int() == 1
        self.player_slots = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.kick_vote) + \
            pack_int(self.kick_min) + \
            pack_int(self.spec_vote) + \
            pack_int(self.team_lock) + \
            pack_int(self.team_balance) + \
            pack_int(self.player_slots)