# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvRaceFinish(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            time: int = 0,
            diff: int = 0,
            record_personal: bool = False,
            record_server: bool = False
    ) -> None:
        self.message_name = 'sv_race_finish'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.time: int = time
        self.diff: int = diff
        self.record_personal: bool = record_personal
        self.record_server: bool = record_server

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.time = unpacker.get_int()
        self.diff = unpacker.get_int()
        self.record_personal = unpacker.get_int() == 1
        self.record_server = unpacker.get_int() == 1
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_int(self.time) + \
            pack_int(self.diff) + \
            pack_int(self.record_personal) + \
            pack_int(self.record_server)