# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvExtraProjectile(PrettyPrint):
    def __init__(
            self,
            projectile: int = 0
    ) -> None:
        self.message_name = 'sv_extra_projectile'
        self.system_message = False
        self.header: ChunkHeader

        self.projectile: int = projectile

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.projectile = unpacker.get_int() # TODO: this is a snapshot object
        return True

    def pack(self) -> bytes:
        return pack_int(self.projectile)