# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvEmoticon(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            emoticon: int = 0
    ) -> None:
        self.message_name = 'sv_emoticon'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.emoticon: int = emoticon

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.emoticon = unpacker.get_int() # TODO: this is a enum
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_int(self.emoticon)