# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgSvClientDrop(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            reason: str = 'default',
            silent: bool = False
    ) -> None:
        self.message_name = 'sv_client_drop'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.reason: str = reason
        self.silent: bool = silent

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.reason = unpacker.get_str()
        self.silent = unpacker.get_int() == 1
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_str(self.reason) + \
            pack_int(self.silent)