# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvCheckpoint(PrettyPrint):
    def __init__(
            self,
            diff: int = 0
    ) -> None:
        self.message_name = 'sv_checkpoint'
        self.system_message = False
        self.header: ChunkHeader

        self.diff: int = diff

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.diff = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.diff)